use Test::Mojo;
use Test::More;
use Mojolicious::Lite;

my $t = Test::Mojo->new;
app->plugin("riotjs");

plan skip_all => 'npm install riotjs' unless $t->app->asset->preprocessors->can_process('tag');
plan skip_all => 'No idea what is going on on windows' if $^O eq 'MSWin32';

app->asset(
  "app.js" => qw(
    https://muut.com/riotjs/dist/demo/js/riot.js
    /js/todo.tag
    /js/main.js
    )
);

get "/" => "index";

return app->start if $ENV{RUN_APP};

$t->get_ok('/')->status_is(200)->element_exists('script')->text_like('script', qr{riot\.tag\('todo',})
  ->text_like('script', qr{riot\.mount\('todo'\)});

done_testing;

__DATA__
@@ /js/todo.tag
<todo>
  <h3>{ opts.title }</h3>
  <ul>
    <li each={ item, i in items }>{ item.title }</li>
  </ul>
  <form onsubmit={ add }>
    <input>
    <button>Add #{ items.length + 1 }</button>
  </form>

  this.items = []

  add(e) {
    var input = e.target[0]
    if (input.value.length) this.items.push({ title: input.value })
    input.value = ''
  }
</todo>

@@ /js/main.js
riot.mount('todo')

@@ index.html.ep
<!DOCTYPE html>
<html>
  <head>
    <title>Riot.js Demo</title>
    <!--[if lt IE 9]>
    <script src="//cdnjs.cloudflare.com/ajax/libs/es5-shim/4.0.5/es5-shim.min.js"></script>
    <script src="//cdnjs.cloudflare.com/ajax/libs/html5shiv/3.7.2/html5shiv.min.js"></script>
    <script>html5.addElements('todo')</script>
    <![endif]-->
  </head>
  <body>
    <todo></todo>
    %= asset "app.js" => { inline => 1 };
  </body>
</html>
