package Mojolicious::Plugin::Riotjs;

=head1 NAME

Mojolicious::Plugin::Riotjs - A Mojolicious  plugin for including riot.js .tag files in your project

=head1 VERSION

0.01

=head1 DESCRIPTION

L<Mojolicious::Plugin::Riotjs> is a L<Mojolicious> plugin for including
L<riot.js|https://muut.com/riotjs/> C<.tag> files in your project. It also
makes it very easy to bundle the latest L<riot.js|https://muut.com/riotjs/download.html>.

=head2 What is riotjs?

From the L<web page|https://muut.com/riotjs/>:

  A REACT-LIKE, 2.5KB USER INTERFACE LIBRARY
  Custom tags - Virtual DOM - Full stack - IE8

=head1 SYNOPSIS

  use Mojolicious::Lite;

  get "/" => "index";
  app->plugin("riotjs");
  app->asset(
    "app.js" => qw(
      https://muut.com/riotjs/dist/demo/js/riot.js
      /js/todo.tag
      /js/main.js
    )
  );
  app->start;

  __DATA__
  @@ /js/todo.tag
  <todo>
    <h3>{ opts.title }</h3>
    <ul>
      <li each={ item, i in items }>{ item.title }</li>
    </ul>
    <form onsubmit={ add }>
      <input>
      <button>Add #{ items.length + 1 }</button>
    </form>

    this.items = []

    add(e) {
      var input = e.target[0]
      if (input.value.length) this.items.push({ title: input.value })
      input.value = ''
    }
  </todo>

  @@ /js/main.js
  riot.mount('todo')

  @@ index.html.ep
  <!DOCTYPE html>
  <html>
    <head>
      <title>Riot.js Demo</title>
      <!--[if lt IE 9]>
      <script src="//cdnjs.cloudflare.com/ajax/libs/es5-shim/4.0.5/es5-shim.min.js"></script>
      <script src="//cdnjs.cloudflare.com/ajax/libs/html5shiv/3.7.2/html5shiv.min.js"></script>
      <script>html5.addElements('todo')</script>
      <![endif]-->
    </head>
    <body>
      <todo></todo>
      %= asset "app.js"
    </body>
  </html>

=cut

use Mojo::Base 'Mojolicious::Plugin';

our $VERSION = '0.01';

=head1 METHODS

=head2 register

Will register the L<Mojolicious::Plugin::Riotjs::Preprocessor> with the
".tag" file extension.

=cut

sub register {
  my ($self, $app, $config) = @_;

  $app->plugin('AssetPack') unless eval { $app->asset };
  $app->asset->preprocessor('Mojolicious::Plugin::Riotjs::Preprocessor', {extensions => ['tag']});
}

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2014, Jan Henning Thorsen

This program is free software, you can redistribute it and/or modify it under
the terms of the Artistic License version 2.0.

=head1 AUTHOR

Jan Henning Thorsen - C<jhthorsen@cpan.org>

=cut

1;
