use Mojo::Base -strict;
use Mojolicious::Command::bundle;
use Test::More;

my $cmd = Mojolicious::Command::bundle->new(quiet => $ENV{HARNESS_IS_VERBOSE} ? 0 : 1);
my $skip_all = 1;
my $log;

eval {
  $cmd->_git(qw( remote -v ), '# Checking for materialize', sub { /^materialize\b/ and $skip_all = 0 });
};

plan skip_all => $@ || 'git remote add materialize https://github.com/Dogfalo/materialize.git'
  if $skip_all and !$ENV{TEST_MATERIALIZE};

File::Path::remove_tree(Mojolicious::Command::bundle::OUT_DIR) if -d Mojolicious::Command::bundle::OUT_DIR;

like $cmd->repositories->{materialize}{download_url}, qr{^https:}, 'repositories download_url';
like $cmd->repositories->{materialize}{git_url},      qr{^https:}, 'repositories git_url';

eval { $cmd->run };
like $@, qr{Usage}, 'run usage';

$log = '';
is $cmd->run(materialize => 'v0.96.0'), 0, 'run v0.96.0';
$cmd->_git(qw( log -n1 ), sub { $log .= "$_\n" });
like $log, qr{^\s*Created assets/vendor/materialize from}m, 'created';

$log = '';
is $cmd->run(materialize => 'v0.97.0'), 0, 'run v0.97.0';
$cmd->_git(qw( log -n1 ), sub { $log .= "$_\n" });
like $log, qr{^\s*Updated assets/vendor/materialize from}m, 'updated';

if ($log =~ /^\s*Updated assets/m) {
  $cmd->_git(qw( reset HEAD^ ),  sub { });
  $cmd->_git(qw( reset --hard ), sub { });
  $cmd->_git(qw( reset HEAD^ ),  sub { });
  $cmd->_git(qw( reset --hard ), sub { });
  File::Path::remove_tree(Mojolicious::Command::bundle::OUT_DIR);
}

done_testing;
