# Oracle Perl Procedure Library
#
# Copyright (c) 2001 Jeff Horwitz (jeff@smashing.org).  All rights reserved.
# This package is free software; you can redistribute it and/or modify it under
# the same terms as Perl itself.

# $Id: Makefile.PL,v 1.4 2001/08/15 19:25:28 jhorwitz Exp $

# Makefile generator for extproc_perl

use Config;

my $DEFAULT_MODS = "IO Socket attrs";

print "Verifying configuration...\n\n";

# make sure we've set ORACLE_HOME
my $oracle_home = $ENV{'ORACLE_HOME'};
unless ($oracle_home) {
	die "Please set the ORACLE_HOME environment variable.";
}

# verify we have a shared libperl
if ($Config{'useshrplib'} ne 'yes' && $Config{'useshrplib'} ne 'true') {
	die "A shared libperl is required to build this distribution."
} 
print "You are using a shared libperl.  Good.\n";

# what is the path to perl?
my $perl = $Config{'perlpath'};

# what is the extension for shared libraries?
my $dlext = $Config{'dlext'};

# figure out which modules to include
if ( -r ".modules" ) {
	if (open(FILE, ".modules")) {
		$DEFAULT_MODS = <FILE>;
		chomp($DEFAULT_MODS);
		close(FILE);
	}
	else {
		print STDERR "couldn't open .modules (don't worry): $!";
	}
}
	
print <<_DONE_;

Oracle does not support Perl's dynamic loading of modules, so you need to
specify at compile time which modules you want to use.  This does not apply
to Perl-only modules, but you can enter them here anyway if you are unsure,
and they will be ignored.  ExtProc is automatically included, so you don't
need to specify it here.

_DONE_

print "Modules to include in this build [$DEFAULT_MODS]: ";
my $mods = <STDIN>;
chomp $mods;
unless ($mods) {
	$mods = $DEFAULT_MODS;
}

if (open(FILE, ">.modules")) {
	print FILE "$mods\n";
	close(FILE);
}
else {
	print STDERR "couldn't save module list.  Don't worry about it.";
}

print <<_DONE_;

extproc_perl requires a bootstrap file that contains the Perl subroutines
that will be called from Oracle.
_DONE_

my $DEFAULT_BOOTSTRAP = "${oracle_home}/lib/ora_perl_boot.pl";
print "Path to bootstrap file [${DEFAULT_BOOTSTRAP}]: ";
my $bootfile = <STDIN>;
chomp $bootfile;
unless ($bootfile) {
	$bootfile = $DEFAULT_BOOTSTRAP;
}

my $CC = $Config{'cc'};
my $LD = $Config{'ld'};
my $LDDLFLAGS = $Config{'lddlflags'};

print "\nWriting Makefile...\n";

rename("Makefile","Makefile.old");
open(FILE,">Makefile") or die "couldn't open Makefile for writing: $!";
print FILE <<_DONE_;
# AUTO-GENERATED BY Makefile.PL -- DO NOT EDIT!

CC=${CC}
LD=${LD}
PERL=${perl}
ORACLE_HOME=${oracle_home}
CPPFLAGS=-I. -I\$(ORACLE_HOME)/rdbms/demo -I\$(ORACLE_HOME)/rdbms/public -DBOOTSTRAP_FILE=\\"${bootfile}\\"
MODULES=ExtProc ${mods}

OBJS=extproc_perl.o perlxsi.o ExtProc.o

all: extproc_perl.${dlext}

perlxsi.c:
	\$(PERL) -MExtUtils::Embed -e xsinit -- -o STDOUT -std \$(MODULES) | grep -v boot_DynaLoader > \$@

ExtProc.o: extproc_perl.h ExtProc/ExtProc.xs
	(cd ExtProc ; \$(MAKE) all)
	cp -f ExtProc/ExtProc.o .

.c.o:
	\$(CC) \$(CPPFLAGS) `\$(PERL) -MExtUtils::Embed -e ccopts` -c \$<

extproc_perl.${dlext}: \$(OBJS)
	\$(LD) -o \$@ `\$(PERL) -MExtUtils::Embed -e ldopts` ${LDDLFLAGS} \$(OBJS) `PERL=\$(PERL) sh gen_module_libs \${MODULES}`

install: all
	(cd ExtProc ; \$(MAKE) install)
	\@echo " "
	\@echo "*** You should now copy extproc_perl.${dlext} to a convenient location."
	\@echo "*** You will specify the path to this file in your SQL library definition."

clean:
	rm -f *.o extproc_perl.so perlxsi.c Makefile
	(cd ExtProc ; \$(MAKE) clean)

distclean:
	rm -f *.o extproc_perl.so perlxsi.c Makefile Makefile.old .modules
	(cd ExtProc ; \$(MAKE) realclean)
_DONE_

print "Configuring ExtProc module\n";
system("cd ExtProc ; ${perl} Makefile.PL");
print "Done.\n";
