package Locale::CLDR::Transformations::Bgn::Ko::Ko_latn;
# This file auto generated from Data\common\transforms\Korean-Latin-BGN.xml
#	on Fri 28 Jun  8:55:56 am GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.45.0');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

BEGIN {
	die "Transliteration requires Perl 5.18 or above"
		unless $^V ge v5.18.0;
}

no warnings 'experimental::regex_sets';
has 'transforms' => (
	is => 'ro',
	isa => ArrayRef,
	init_arg => undef,
	default => sub { [
		qr/(?^umi:\G[ᄀᄁᄂᄃᄄᄅᄆᄇᄈᄉᄊᄋᄌᄍᄎᄏᄐᄑᄒᄭᄯᄲᄶᅡᅢᅣᅤᅥᅦᅧᅨᅩᅪᅫᅬᅭᅮᅯᅰᅱᅲᅳᅴᅵᆨᆫᆮᆯᆰᆱᆲᆷᆸᆺᆼᆽᆾᆿᇀᇁ])/,
		{
			type => 'transform',
			data => [
				{
					from => q(Any),
					to => q(NFD),
				},
			],
		},
		{
			type => 'conversion',
			data => [
				{
					before  => q(),
					after   => q(),
					replace => q(ᆨᄀ),
					result  => q(kk),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆨᄂ),
					result  => q(ngn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆨᄃ),
					result  => q(kt),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆨᄅ),
					result  => q(ngn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆨᄆ),
					result  => q(ngm),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆨᄇ),
					result  => q(kp),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆨᄉ),
					result  => q(ks),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆨᄋ),
					result  => q(g),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆨᄌ),
					result  => q(kch),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆨᄎ),
					result  => q(kch’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆨᄏ),
					result  => q(kk’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆨᄐ),
					result  => q(kt’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆨᄑ),
					result  => q(kp’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆨᄒ),
					result  => q(kh),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆨᄁ),
					result  => q(kk),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆨᄄ),
					result  => q(ktt),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆨᄈ),
					result  => q(kpp),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆨᄊ),
					result  => q(kss),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆨᄍ),
					result  => q(ktch),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆫᄀ),
					result  => q(n’g),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆫᄂ),
					result  => q(nn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆫᄃ),
					result  => q(nd),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆫᄅ),
					result  => q(ll),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆫᄆ),
					result  => q(nm),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆫᄇ),
					result  => q(nb),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆫᄉ),
					result  => q(ns),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆫᄋ),
					result  => q(n),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆫᄌ),
					result  => q(nj),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆫᄎ),
					result  => q(nch’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆫᄏ),
					result  => q(nk’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆫᄐ),
					result  => q(nt’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆫᄑ),
					result  => q(np’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆫᄒ),
					result  => q(nh),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆫᄁ),
					result  => q(nkk),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆫᄄ),
					result  => q(ntt),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆫᄈ),
					result  => q(npp),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆫᄊ),
					result  => q(nss),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆫᄍ),
					result  => q(ntch),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆯᄀ),
					result  => q(lg),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆯᄂ),
					result  => q(ll),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆯᄃ),
					result  => q(lt),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆯᄅ),
					result  => q(ll),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆯᄆ),
					result  => q(lm),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆯᄇ),
					result  => q(lb),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆯᄉ),
					result  => q(ls),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆯᄋ),
					result  => q(r),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆯᄌ),
					result  => q(lch),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆯᄎ),
					result  => q(lch’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆯᄏ),
					result  => q(lk’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆯᄐ),
					result  => q(lt’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆯᄑ),
					result  => q(lp’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆯᄒ),
					result  => q(rh),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆯᄁ),
					result  => q(lkk),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆯᄄ),
					result  => q(ltt),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆯᄈ),
					result  => q(lpp),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆯᄊ),
					result  => q(lss),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆯᄍ),
					result  => q(ltch),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆷᄀ),
					result  => q(mg),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆷᄂ),
					result  => q(mn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆷᄃ),
					result  => q(md),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆷᄅ),
					result  => q(mn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆷᄆ),
					result  => q(mm),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆷᄇ),
					result  => q(mb),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆷᄉ),
					result  => q(ms),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆷᄋ),
					result  => q(m),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆷᄌ),
					result  => q(mj),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆷᄎ),
					result  => q(mch’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆷᄏ),
					result  => q(mk’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆷᄐ),
					result  => q(mt’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆷᄑ),
					result  => q(mp’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆷᄒ),
					result  => q(mh),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆷᄁ),
					result  => q(mkk),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆷᄄ),
					result  => q(mtt),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆷᄈ),
					result  => q(mpp),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆷᄊ),
					result  => q(mss),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆷᄍ),
					result  => q(mtch),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆸᄀ),
					result  => q(pk),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆸᄂ),
					result  => q(mn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆸᄃ),
					result  => q(pt),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆸᄅ),
					result  => q(mn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆸᄆ),
					result  => q(mm),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆸᄇ),
					result  => q(pp),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆸᄉ),
					result  => q(ps),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆸᄋ),
					result  => q(p),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆸᄌ),
					result  => q(pch),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆸᄎ),
					result  => q(pch’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆸᄏ),
					result  => q(pk’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆸᄐ),
					result  => q(pt’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆸᄑ),
					result  => q(pp’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆸᄒ),
					result  => q(ph),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆸᄁ),
					result  => q(pkk),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆸᄄ),
					result  => q(ptt),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆸᄈ),
					result  => q(pp),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆸᄊ),
					result  => q(pss),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆸᄍ),
					result  => q(ptch),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆺᄀ),
					result  => q(kk),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆺᄂ),
					result  => q(nn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆺᄃ),
					result  => q(tt),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆺᄅ),
					result  => q(nn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆺᄆ),
					result  => q(nm),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆺᄇ),
					result  => q(pp),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆺᄉ),
					result  => q(ss),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆺᄋ),
					result  => q(d),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆺᄌ),
					result  => q(tch),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆺᄎ),
					result  => q(tch’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆺᄏ),
					result  => q(tk’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆺᄐ),
					result  => q(tt’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆺᄑ),
					result  => q(tp’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆺᄒ),
					result  => q(th),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆺᄁ),
					result  => q(tkk),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆺᄄ),
					result  => q(tt),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆺᄈ),
					result  => q(tpp),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆺᄊ),
					result  => q(tss),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆺᄍ),
					result  => q(tch),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆼᄀ),
					result  => q(ngg),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆼᄂ),
					result  => q(ngn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆼᄃ),
					result  => q(ngd),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆼᄅ),
					result  => q(ngn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆼᄆ),
					result  => q(ngm),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆼᄇ),
					result  => q(ngb),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆼᄉ),
					result  => q(ngs),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆼᄋ),
					result  => q(ng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆼᄌ),
					result  => q(ngj),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆼᄎ),
					result  => q(ngch’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆼᄏ),
					result  => q(ngk’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆼᄐ),
					result  => q(ngt’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆼᄑ),
					result  => q(ngp’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆼᄒ),
					result  => q(ngh),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆼᄁ),
					result  => q(ngkk),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆼᄄ),
					result  => q(ngtt),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆼᄈ),
					result  => q(ngpp),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆼᄊ),
					result  => q(ngss),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆼᄍ),
					result  => q(ngtch),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([ᅡᅢᅣᅤᅥᅦᅧᅨᅩᅪᅫᅬᅭᅮᅯᅰᅱᅲᅳᅴᅵ]ᄀ),
					result  => q(g),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([ᅡᅢᅣᅤᅥᅦᅧᅨᅩᅪᅫᅬᅭᅮᅯᅰᅱᅲᅳᅴᅵ]ᄂ),
					result  => q(n),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([ᅡᅢᅣᅤᅥᅦᅧᅨᅩᅪᅫᅬᅭᅮᅯᅰᅱᅲᅳᅴᅵ]ᄃ),
					result  => q(d),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([ᅡᅢᅣᅤᅥᅦᅧᅨᅩᅪᅫᅬᅭᅮᅯᅰᅱᅲᅳᅴᅵ]ᄅ),
					result  => q(r),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([ᅡᅢᅣᅤᅥᅦᅧᅨᅩᅪᅫᅬᅭᅮᅯᅰᅱᅲᅳᅴᅵ]ᄆ),
					result  => q(m),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([ᅡᅢᅣᅤᅥᅦᅧᅨᅩᅪᅫᅬᅭᅮᅯᅰᅱᅲᅳᅴᅵ]ᄇ),
					result  => q(b),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([ᅡᅢᅣᅤᅥᅦᅧᅨᅩᅪᅫᅬᅭᅮᅯᅰᅱᅲᅳᅴᅵ]ᄉ),
					result  => q(s),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([ᅡᅢᅣᅤᅥᅦᅧᅨᅩᅪᅫᅬᅭᅮᅯᅰᅱᅲᅳᅴᅵ]ᄋ),
					result  => q(),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([ᅡᅢᅣᅤᅥᅦᅧᅨᅩᅪᅫᅬᅭᅮᅯᅰᅱᅲᅳᅴᅵ]ᄌ),
					result  => q(j),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([ᅡᅢᅣᅤᅥᅦᅧᅨᅩᅪᅫᅬᅭᅮᅯᅰᅱᅲᅳᅴᅵ]ᄎ),
					result  => q(ch’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([ᅡᅢᅣᅤᅥᅦᅧᅨᅩᅪᅫᅬᅭᅮᅯᅰᅱᅲᅳᅴᅵ]ᄏ),
					result  => q(k’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([ᅡᅢᅣᅤᅥᅦᅧᅨᅩᅪᅫᅬᅭᅮᅯᅰᅱᅲᅳᅴᅵ]ᄐ),
					result  => q(t’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([ᅡᅢᅣᅤᅥᅦᅧᅨᅩᅪᅫᅬᅭᅮᅯᅰᅱᅲᅳᅴᅵ]ᄑ),
					result  => q(p’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([ᅡᅢᅣᅤᅥᅦᅧᅨᅩᅪᅫᅬᅭᅮᅯᅰᅱᅲᅳᅴᅵ]ᄒ),
					result  => q(h),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([ᅡᅢᅣᅤᅥᅦᅧᅨᅩᅪᅫᅬᅭᅮᅯᅰᅱᅲᅳᅴᅵ]ᄁ),
					result  => q(kk),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([ᅡᅢᅣᅤᅥᅦᅧᅨᅩᅪᅫᅬᅭᅮᅯᅰᅱᅲᅳᅴᅵ]ᄄ),
					result  => q(tt),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([ᅡᅢᅣᅤᅥᅦᅧᅨᅩᅪᅫᅬᅭᅮᅯᅰᅱᅲᅳᅴᅵ]ᄈ),
					result  => q(pp),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([ᅡᅢᅣᅤᅥᅦᅧᅨᅩᅪᅫᅬᅭᅮᅯᅰᅱᅲᅳᅴᅵ]ᄊ),
					result  => q(ss),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([ᅡᅢᅣᅤᅥᅦᅧᅨᅩᅪᅫᅬᅭᅮᅯᅰᅱᅲᅳᅴᅵ]ᄍ),
					result  => q(tch),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆰᄀ),
					result  => q(lg),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆰᄂ),
					result  => q(ngn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆰᄃ),
					result  => q(kt),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆰᄅ),
					result  => q(ngl),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆰᄆ),
					result  => q(ngm),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆰᄇ),
					result  => q(kp),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆰᄉ),
					result  => q(ks),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆰᄋ),
					result  => q(lg),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆰᄌ),
					result  => q(kch),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆰᄎ),
					result  => q(kch’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆰᄏ),
					result  => q(lk’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆰᄐ),
					result  => q(kt’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆰᄑ),
					result  => q(kp’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆰᄒ),
					result  => q(lkh),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆰᄁ),
					result  => q(lkk),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆰᄄ),
					result  => q(ktt),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆰᄈ),
					result  => q(kpp),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆰᄊ),
					result  => q(kss),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆰᄍ),
					result  => q(ktch),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆱᄀ),
					result  => q(mg),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆱᄂ),
					result  => q(mn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆱᄃ),
					result  => q(md),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆱᄅ),
					result  => q(ml),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆱᄆ),
					result  => q(lm),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆱᄇ),
					result  => q(mb),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆱᄉ),
					result  => q(ms),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆱᄋ),
					result  => q(lm),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆱᄌ),
					result  => q(mj),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆱᄎ),
					result  => q(mch’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆱᄏ),
					result  => q(mk’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆱᄐ),
					result  => q(mt’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆱᄑ),
					result  => q(mp’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆱᄒ),
					result  => q(mh),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆱᄁ),
					result  => q(mkk),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆱᄄ),
					result  => q(mtt),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆱᄈ),
					result  => q(mpp),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆱᄊ),
					result  => q(mss),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆱᄍ),
					result  => q(mtch),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆲᄀ),
					result  => q(pk),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆲᄂ),
					result  => q(mn),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆲᄃ),
					result  => q(pt),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆲᄅ),
					result  => q(ml),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆲᄆ),
					result  => q(mm),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆲᄇ),
					result  => q(lb),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆲᄉ),
					result  => q(ps),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆲᄋ),
					result  => q(lb),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆲᄌ),
					result  => q(pch),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆲᄎ),
					result  => q(pch’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆲᄏ),
					result  => q(pk’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆲᄐ),
					result  => q(pt’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆲᄑ),
					result  => q(lp’),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆲᄒ),
					result  => q(lph),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆲᄁ),
					result  => q(pkk),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆲᄄ),
					result  => q(ptt),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆲᄈ),
					result  => q(lpp),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆲᄊ),
					result  => q(pss),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᆲᄍ),
					result  => q(ptch),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(ᄀ),
					result  => q(k),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(ᄂ),
					result  => q(n),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(ᄃ),
					result  => q(t),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(ᄅ),
					result  => q(n),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(ᄆ),
					result  => q(m),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(ᄇ),
					result  => q(p),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(ᄉ),
					result  => q(s),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(ᄋ),
					result  => q(),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(ᄌ),
					result  => q(ch),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(ᄎ),
					result  => q(ch’),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(ᄏ),
					result  => q(k’),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(ᄐ),
					result  => q(t’),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(ᄑ),
					result  => q(p’),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(ᄒ),
					result  => q(h),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(ᄁ),
					result  => q(kk),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(ᄭ),
					result  => q(kk),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(ᄄ),
					result  => q(tt),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(ᄯ),
					result  => q(tt),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(ᄈ),
					result  => q(pp),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(ᄲ),
					result  => q(pp),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(ᄊ),
					result  => q(ss),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(ᄍ),
					result  => q(tch),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(ᄶ),
					result  => q(tch),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᅡ),
					result  => q(a),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᅣ),
					result  => q(ya),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᅥ),
					result  => q(ŏ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᅧ),
					result  => q(yŏ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᅩ),
					result  => q(o),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᅭ),
					result  => q(yo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᅮ),
					result  => q(u),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᅲ),
					result  => q(yu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᅳ),
					result  => q(ŭ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᅵ),
					result  => q(i),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᅢ),
					result  => q(ae),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᅤ),
					result  => q(yae),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᅦ),
					result  => q(e),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᅨ),
					result  => q(ye),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᅬ),
					result  => q(oe),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᅱ),
					result  => q(wi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᅴ),
					result  => q(ŭi),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᅪ),
					result  => q(wa),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᅯ),
					result  => q(wŏ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᅫ),
					result  => q(wae),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ᅰ),
					result  => q(we),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ᆨ),
					result  => q(k),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ᆫ),
					result  => q(n),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ᆮ),
					result  => q(t),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ᆯ),
					result  => q(l),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ᆷ),
					result  => q(m),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ᆸ),
					result  => q(p),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ᆺ),
					result  => q(t),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ᆼ),
					result  => q(ng),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ᆽ),
					result  => q(t),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ᆾ),
					result  => q(t),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ᆿ),
					result  => q(k),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ᇀ),
					result  => q(t),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ᇁ),
					result  => q(p),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ᆰ),
					result  => q(k),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^ \p{L} \p{M} \p{N}]),
					replace => q(ᆲ),
					result  => q(p),
					revisit => 0,
				},
			]
		},
	] },
);

no Moo;

1;

# vim: tabstop=4
