=encoding utf8

=head1 NAME

Locale::CLDR::Locales::Ur - Package for language Urdu

=cut

package Locale::CLDR::Locales::Ur;
# This file auto generated from Data\common\main\ur.xml
#	on Sat  6 Jan 12:50:56 am GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.40.0');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

extends('Locale::CLDR::Locales::Root');
# Need to add code for Key type pattern
sub display_name_pattern {
	my ($self, $name, $region, $script, $variant) = @_;

	my $display_pattern = '{0} ({1})';
	$display_pattern =~s/\{0\}/$name/g;
	my $subtags = join '{0}،{1}', grep {$_} (
		$region,
		$script,
		$variant,
	);

	$display_pattern =~s/\{1\}/$subtags/g;
	return $display_pattern;
}

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		 sub {
			 my %languages = (
				'aa' => 'افار',
 				'ab' => 'ابقازیان',
 				'ace' => 'اچائینیز',
 				'ach' => 'اکولی',
 				'ada' => 'ادانگمے',
 				'ady' => 'ادیگھے',
 				'af' => 'افریقی',
 				'agq' => 'اغم',
 				'ain' => 'اینو',
 				'ak' => 'اکان',
 				'ale' => 'الیوت',
 				'alt' => 'جنوبی الٹائی',
 				'am' => 'امہاری',
 				'an' => 'اراگونیز',
 				'anp' => 'انگیکا',
 				'ar' => 'عربی',
 				'ar_001' => 'ماڈرن اسٹینڈرڈ عربی',
 				'arn' => 'ماپوچے',
 				'arp' => 'اراپاہو',
 				'as' => 'آسامی',
 				'asa' => 'آسو',
 				'ast' => 'اسٹوریائی',
 				'av' => 'اواری',
 				'awa' => 'اوادھی',
 				'ay' => 'ایمارا',
 				'az' => 'آذربائیجانی',
 				'az@alt=short' => 'ازیری',
 				'az_Arab' => 'آزربائیجانی (عربی)',
 				'ba' => 'باشکیر',
 				'ban' => 'بالینیز',
 				'bas' => 'باسا',
 				'be' => 'بیلاروسی',
 				'bem' => 'بیمبا',
 				'bez' => 'بینا',
 				'bg' => 'بلغاری',
 				'bgn' => 'مغربی بلوچی',
 				'bho' => 'بھوجپوری',
 				'bi' => 'بسلاما',
 				'bin' => 'بینی',
 				'bla' => 'سکسیکا',
 				'bm' => 'بمبارا',
 				'bn' => 'بنگلہ',
 				'bo' => 'تبتی',
 				'br' => 'بریٹن',
 				'brx' => 'بوڈو',
 				'bs' => 'بوسنیائی',
 				'bug' => 'بگینیز',
 				'byn' => 'بلین',
 				'ca' => 'کیٹالان',
 				'ccp' => 'چکمہ',
 				'ce' => 'چیچن',
 				'ceb' => 'سیبوآنو',
 				'cgg' => 'چیگا',
 				'ch' => 'چیمارو',
 				'chk' => 'چوکیز',
 				'chm' => 'ماری',
 				'cho' => 'چاکٹاؤ',
 				'chr' => 'چیروکی',
 				'chy' => 'چینّے',
 				'ckb' => 'سینٹرل کردش',
 				'co' => 'کوراسیکن',
 				'crs' => 'سیسلوا کریولے فرانسیسی',
 				'cs' => 'چیک',
 				'cu' => 'چرچ سلاوک',
 				'cv' => 'چوواش',
 				'cy' => 'ویلش',
 				'da' => 'ڈینش',
 				'dak' => 'ڈاکوٹا',
 				'dar' => 'درگوا',
 				'dav' => 'تائتا',
 				'de' => 'جرمن',
 				'de_AT' => 'آسٹریائی جرمن',
 				'de_CH' => 'سوئس ہائی جرمن',
 				'dgr' => 'دوگریب',
 				'dje' => 'زرما',
 				'doi' => 'ڈوگری',
 				'dsb' => 'ذیلی سربیائی',
 				'dua' => 'دوالا',
 				'dv' => 'ڈیویہی',
 				'dyo' => 'جولا فونيا',
 				'dz' => 'ژونگکھا',
 				'dzg' => 'دزاگا',
 				'ebu' => 'امبو',
 				'ee' => 'ایو',
 				'efi' => 'ایفِک',
 				'eka' => 'ایکاجوی',
 				'el' => 'یونانی',
 				'en' => 'انگریزی',
 				'en_AU' => 'آسٹریلیائی انگریزی',
 				'en_CA' => 'کینیڈین انگریزی',
 				'en_GB' => 'برطانوی انگریزی',
 				'en_US' => 'امریکی انگریزی',
 				'en_US@alt=short' => 'امریکی انگریزی',
 				'eo' => 'ایسپرانٹو',
 				'es' => 'ہسپانوی',
 				'es_419' => 'لاطینی امریکی ہسپانوی',
 				'es_ES' => 'یورپی ہسپانوی',
 				'es_MX' => 'میکسیکن ہسپانوی',
 				'et' => 'اسٹونین',
 				'eu' => 'باسکی',
 				'ewo' => 'ایوانڈو',
 				'fa' => 'فارسی',
 				'fa_AF' => 'دری',
 				'ff' => 'فولہ',
 				'fi' => 'فینیش',
 				'fil' => 'فلیپینو',
 				'fj' => 'فجی',
 				'fo' => 'فیروئیز',
 				'fon' => 'فون',
 				'fr' => 'فرانسیسی',
 				'fr_CA' => 'کینیڈین فرانسیسی',
 				'fr_CH' => 'سوئس فرینچ',
 				'frc' => 'کاجن فرانسیسی',
 				'fur' => 'فریولیائی',
 				'fy' => 'مغربی فریسیئن',
 				'ga' => 'آئرش',
 				'gaa' => 'گا',
 				'gag' => 'غاغاوز',
 				'gan' => 'gan',
 				'gd' => 'سکاٹش گیلک',
 				'gez' => 'گیز',
 				'gil' => 'گلبرتیز',
 				'gl' => 'گالیشیائی',
 				'gn' => 'گُارانی',
 				'gor' => 'گورانٹالو',
 				'gsw' => 'سوئس جرمن',
 				'gu' => 'گجراتی',
 				'guz' => 'گسی',
 				'gv' => 'مینکس',
 				'gwi' => 'گوئچ ان',
 				'ha' => 'ہؤسا',
 				'haw' => 'ہوائی',
 				'he' => 'عبرانی',
 				'hi' => 'ہندی',
 				'hil' => 'ہالیگینون',
 				'hmn' => 'ہمانگ',
 				'hr' => 'کراتی',
 				'hsb' => 'اپر سربیائی',
 				'ht' => 'ہیتی',
 				'hu' => 'ہنگیرین',
 				'hup' => 'ہیوپا',
 				'hy' => 'آرمینیائی',
 				'hz' => 'ہریرو',
 				'ia' => 'بین لسانیات',
 				'iba' => 'ایبان',
 				'ibb' => 'ابی بیو',
 				'id' => 'انڈونیثیائی',
 				'ig' => 'اِگبو',
 				'ii' => 'سچوان ای',
 				'ilo' => 'ایلوکو',
 				'inh' => 'انگوش',
 				'io' => 'ایڈو',
 				'is' => 'آئس لینڈک',
 				'it' => 'اطالوی',
 				'iu' => 'اینُکٹیٹٹ',
 				'ja' => 'جاپانی',
 				'jbo' => 'لوجبان',
 				'jgo' => 'نگومبا',
 				'jmc' => 'ماشیم',
 				'jv' => 'جاوی',
 				'ka' => 'جارجیائی',
 				'kab' => 'قبائلی',
 				'kac' => 'کاچن',
 				'kaj' => 'جے جو',
 				'kam' => 'کامبا',
 				'kbd' => 'کبارڈین',
 				'kcg' => 'تیاپ',
 				'kde' => 'ماکونده',
 				'kea' => 'کابويرديانو',
 				'kfo' => 'کورو',
 				'kg' => 'کانگو',
 				'kha' => 'کھاسی',
 				'khq' => 'کويرا شيني',
 				'ki' => 'کیکویو',
 				'kj' => 'کونیاما',
 				'kk' => 'قزاخ',
 				'kkj' => 'کاکو',
 				'kl' => 'کالاليست',
 				'kln' => 'کالينجين',
 				'km' => 'خمیر',
 				'kmb' => 'کیمبونڈو',
 				'kn' => 'کنّاڈا',
 				'ko' => 'کوریائی',
 				'koi' => 'کومی پرمیاک',
 				'kok' => 'کونکنی',
 				'kpe' => 'کیپیلّے',
 				'kr' => 'کنوری',
 				'krc' => 'کراچے بالکر',
 				'krl' => 'کیرلین',
 				'kru' => 'کوروکھ',
 				'ks' => 'کشمیری',
 				'ksb' => 'شامبالا',
 				'ksf' => 'بافيا',
 				'ksh' => 'کولوگنیائی',
 				'ku' => 'کردش',
 				'kum' => 'کومیک',
 				'kv' => 'کومی',
 				'kw' => 'کورنش',
 				'ky' => 'کرغیزی',
 				'la' => 'لاطینی',
 				'lad' => 'لیڈینو',
 				'lag' => 'لانگی',
 				'lb' => 'لکسمبرگیش',
 				'lez' => 'لیزگیان',
 				'lg' => 'گینڈا',
 				'li' => 'لیمبرگش',
 				'lkt' => 'لاکوٹا',
 				'ln' => 'لِنگَلا',
 				'lo' => 'لاؤ',
 				'lou' => 'لوزیانا کریول',
 				'loz' => 'لوزی',
 				'lrc' => 'شمالی لری',
 				'lt' => 'لیتھوینین',
 				'lu' => 'لبا-کاتانجا',
 				'lua' => 'لیوبا لولوآ',
 				'lun' => 'لونڈا',
 				'luo' => 'لو',
 				'lus' => 'میزو',
 				'luy' => 'لویا',
 				'lv' => 'لیٹوین',
 				'mad' => 'مدورسی',
 				'mag' => 'مگاہی',
 				'mai' => 'میتھیلی',
 				'mak' => 'مکاسر',
 				'mas' => 'مسائی',
 				'mdf' => 'موکشا',
 				'men' => 'میندے',
 				'mer' => 'میرو',
 				'mfe' => 'موریسیین',
 				'mg' => 'ملاگاسی',
 				'mgh' => 'ماخاوا-ميتو',
 				'mgo' => 'میٹا',
 				'mh' => 'مارشلیز',
 				'mi' => 'ماؤری',
 				'mic' => 'مکمیک',
 				'min' => 'منانگکباؤ',
 				'mk' => 'مقدونیائی',
 				'ml' => 'مالایالم',
 				'mn' => 'منگولین',
 				'mni' => 'منی پوری',
 				'moh' => 'موہاک',
 				'mos' => 'موسی',
 				'mr' => 'مراٹهی',
 				'ms' => 'مالے',
 				'mt' => 'مالٹی',
 				'mua' => 'منڈانگ',
 				'mul' => 'متعدد زبانیں',
 				'mus' => 'کریک',
 				'mwl' => 'میرانڈیز',
 				'my' => 'برمی',
 				'myv' => 'ارزیا',
 				'mzn' => 'مزندرانی',
 				'na' => 'ناؤرو',
 				'nap' => 'نیاپولیٹن',
 				'naq' => 'ناما',
 				'nb' => 'نارویجین بوکمل',
 				'nd' => 'شمالی دبیل',
 				'nds' => 'ادنی جرمن',
 				'nds_NL' => 'ادنی سیکسن',
 				'ne' => 'نیپالی',
 				'new' => 'نیواری',
 				'ng' => 'نڈونگا',
 				'nia' => 'نیاس',
 				'niu' => 'نیویائی',
 				'nl' => 'ڈچ',
 				'nl_BE' => 'فلیمِش',
 				'nmg' => 'کوايسو',
 				'nn' => 'نارویجین نینورسک',
 				'nnh' => 'نگیمبون',
 				'no' => 'نارویجین',
 				'nog' => 'نوگائی',
 				'nqo' => 'اینکو',
 				'nr' => 'جنوبی نڈیبیلی',
 				'nso' => 'شمالی سوتھو',
 				'nus' => 'نویر',
 				'nv' => 'نواجو',
 				'ny' => 'نیانجا',
 				'nyn' => 'نینکول',
 				'oc' => 'آکسیٹان',
 				'om' => 'اورومو',
 				'or' => 'اڑیہ',
 				'os' => 'اوسیٹک',
 				'pa' => 'پنجابی',
 				'pag' => 'پنگاسنان',
 				'pam' => 'پامپنگا',
 				'pap' => 'پاپیامینٹو',
 				'pau' => 'پالاون',
 				'pcm' => 'نائجیریائی پڈگن',
 				'pl' => 'پولش',
 				'prg' => 'پارسی',
 				'ps' => 'پشتو',
 				'pt' => 'پُرتگالی',
 				'pt_BR' => 'برازیلی پرتگالی',
 				'pt_PT' => 'یورپی پرتگالی',
 				'qu' => 'کویچوآ',
 				'quc' => 'کيشی',
 				'rap' => 'رپانوی',
 				'rar' => 'راروتونگان',
 				'rhg' => 'روہنگیا',
 				'rm' => 'رومانش',
 				'rn' => 'رونڈی',
 				'ro' => 'رومینین',
 				'ro_MD' => 'مالدووا',
 				'rof' => 'رومبو',
 				'ru' => 'روسی',
 				'rup' => 'ارومانی',
 				'rw' => 'کینیاروانڈا',
 				'rwk' => 'روا',
 				'sa' => 'سنسکرت',
 				'sad' => 'سنڈاوے',
 				'sah' => 'ساکھا',
 				'saq' => 'سامبورو',
 				'sat' => 'سنتالی',
 				'sba' => 'نگامبے',
 				'sbp' => 'سانگو',
 				'sc' => 'سردینین',
 				'scn' => 'سیسیلین',
 				'sco' => 'سکاٹ',
 				'sd' => 'سندھی',
 				'sdh' => 'جنوبی کرد',
 				'se' => 'شمالی سامی',
 				'seh' => 'سینا',
 				'ses' => 'کويرابورو سينی',
 				'sg' => 'ساںغو',
 				'sh' => 'سربو-کروئیشین',
 				'shi' => 'تشلحيت',
 				'shn' => 'شان',
 				'si' => 'سنہالا',
 				'sk' => 'سلوواک',
 				'sl' => 'سلووینیائی',
 				'sm' => 'ساموآن',
 				'sma' => 'جنوبی سامی',
 				'smj' => 'لول سامی',
 				'smn' => 'اناری سامی',
 				'sms' => 'سکولٹ سامی',
 				'sn' => 'شونا',
 				'snk' => 'سوننکے',
 				'so' => 'صومالی',
 				'sq' => 'البانی',
 				'sr' => 'سربین',
 				'srn' => 'سرانن ٹونگو',
 				'ss' => 'سواتی',
 				'ssy' => 'ساہو',
 				'st' => 'جنوبی سوتھو',
 				'su' => 'سنڈانیز',
 				'suk' => 'سکوما',
 				'sv' => 'سویڈش',
 				'sw' => 'سواحلی',
 				'sw_CD' => 'کانگو سواحلی',
 				'swb' => 'کوموریائی',
 				'syr' => 'سریانی',
 				'ta' => 'تمل',
 				'te' => 'تیلگو',
 				'tem' => 'ٹمنے',
 				'teo' => 'تیسو',
 				'tet' => 'ٹیٹم',
 				'tg' => 'تاجک',
 				'th' => 'تھائی',
 				'ti' => 'ٹگرینیا',
 				'tig' => 'ٹگرے',
 				'tk' => 'ترکمان',
 				'tl' => 'ٹیگا لوگ',
 				'tlh' => 'کلنگن',
 				'tn' => 'سوانا',
 				'to' => 'ٹونگن',
 				'tpi' => 'ٹوک پِسِن',
 				'tr' => 'ترکی',
 				'trv' => 'ٹوروکو',
 				'ts' => 'زونگا',
 				'tt' => 'تاتار',
 				'tum' => 'ٹمبوکا',
 				'tvl' => 'تووالو',
 				'tw' => 'توی',
 				'twq' => 'تاساواق',
 				'ty' => 'تاہیتی',
 				'tyv' => 'تووینین',
 				'tzm' => 'سینٹرل ایٹلس ٹمازائٹ',
 				'udm' => 'ادمورت',
 				'ug' => 'یوئگہر',
 				'uk' => 'یوکرینیائی',
 				'umb' => 'اومبوندو',
 				'und' => 'نامعلوم زبان',
 				'ur' => 'اردو',
 				'uz' => 'ازبیک',
 				'vai' => 'وائی',
 				've' => 'وینڈا',
 				'vi' => 'ویتنامی',
 				'vo' => 'وولاپوک',
 				'vun' => 'ونجو',
 				'wa' => 'والون',
 				'wae' => 'والسر',
 				'wal' => 'وولایتا',
 				'war' => 'وارے',
 				'wbp' => 'وارلپیری',
 				'wo' => 'وولوف',
 				'xal' => 'کالمیک',
 				'xh' => 'ژوسا',
 				'xog' => 'سوگا',
 				'yav' => 'یانگبین',
 				'ybb' => 'یمبا',
 				'yi' => 'یدش',
 				'yo' => 'یوروبا',
 				'yue' => 'کینٹونیز',
 				'yue@alt=menu' => 'چینی، کینٹونیز',
 				'zgh' => 'اسٹینڈرڈ مراقشی تمازیقی',
 				'zh' => 'چینی',
 				'zh@alt=menu' => 'چینی، مندارن',
 				'zh_Hans' => 'چینی (آسان کردہ)',
 				'zh_Hans@alt=long' => 'سادہ مندارن چینی',
 				'zh_Hant' => 'روایتی چینی',
 				'zh_Hant@alt=long' => 'روایتی مندارن چینی',
 				'zu' => 'زولو',
 				'zun' => 'زونی',
 				'zxx' => 'کوئی لسانی مواد نہیں',
 				'zza' => 'زازا',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Arab' => 'عربی',
 			'Arab@alt=variant' => 'فارسی عربی',
 			'Aran' => 'نستعلیق',
 			'Armn' => 'آرمینیائی',
 			'Beng' => 'بنگالی',
 			'Bopo' => 'بوپوموفو',
 			'Brai' => 'بریل',
 			'Cyrl' => 'سیریلک',
 			'Deva' => 'دیوناگری',
 			'Ethi' => 'ایتھوپیائی',
 			'Geor' => 'جارجیائی',
 			'Grek' => 'یونانی',
 			'Gujr' => 'گجراتی',
 			'Guru' => 'گرمکھی',
 			'Hanb' => 'ہینب',
 			'Hang' => 'ہنگول',
 			'Hani' => 'ہان',
 			'Hans' => 'آسان',
 			'Hans@alt=stand-alone' => 'آسان ہان',
 			'Hant' => 'روایتی',
 			'Hant@alt=stand-alone' => 'روایتی ہان',
 			'Hebr' => 'عبرانی',
 			'Hira' => 'ہیراگینا',
 			'Hrkt' => 'جاپانی سیلابریز',
 			'Jamo' => 'جامو',
 			'Jpan' => 'جاپانی',
 			'Kana' => 'کٹاکانا',
 			'Khmr' => 'خمیر',
 			'Knda' => 'کنڑ',
 			'Kore' => 'کوریائی',
 			'Laoo' => 'لاؤ',
 			'Latn' => 'لاطینی',
 			'Mlym' => 'ملیالم',
 			'Mong' => 'منگولیائی',
 			'Mymr' => 'میانمار',
 			'Orya' => 'اڑیہ',
 			'Sinh' => 'سنہالا',
 			'Taml' => 'تمل',
 			'Telu' => 'تیلگو',
 			'Thaa' => 'تھانا',
 			'Thai' => 'تھائی',
 			'Tibt' => 'تبتی',
 			'Zmth' => 'ریاضی کی علامتیں',
 			'Zsye' => 'ایموجی',
 			'Zsym' => 'علامات',
 			'Zxxx' => 'غیر تحریر شدہ',
 			'Zyyy' => 'عام',
 			'Zzzz' => 'نامعلوم رسم الخط',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'001' => 'دنیا',
 			'002' => 'افریقہ',
 			'003' => 'شمالی امریکہ',
 			'005' => 'جنوبی امریکہ',
 			'009' => 'اوشیانیا',
 			'011' => 'مغربی افریقہ',
 			'013' => 'وسطی امریکہ',
 			'014' => 'مشرقی افریقہ',
 			'015' => 'شمالی افریقہ',
 			'017' => 'وسطی افریقہ',
 			'018' => 'جنوبی افریقہ کا علاقہ',
 			'019' => 'امیریکاز',
 			'021' => 'شمالی امریکہ کا علاقہ',
 			'029' => 'کریبیائی',
 			'030' => 'مشرقی ایشیا',
 			'034' => 'جنوبی ایشیا',
 			'035' => 'جنوب مشرقی ایشیا',
 			'039' => 'جنوبی یورپ',
 			'053' => 'آسٹریلیشیا',
 			'054' => 'مالینیشیا',
 			'057' => 'مائکرونیشیائی علاقہ',
 			'061' => 'پولینیشیا',
 			'142' => 'ایشیا',
 			'143' => 'وسطی ایشیا',
 			'145' => 'مغربی ایشیا',
 			'150' => 'یورپ',
 			'151' => 'مشرقی یورپ',
 			'154' => 'شمالی یورپ',
 			'155' => 'مغربی یورپ',
 			'202' => 'ذیلی صحارن افریقہ',
 			'419' => 'لاطینی امریکہ',
 			'AC' => 'اسینشن آئلینڈ',
 			'AD' => 'انڈورا',
 			'AE' => 'متحدہ عرب امارات',
 			'AF' => 'افغانستان',
 			'AG' => 'انٹیگوا اور باربودا',
 			'AI' => 'انگوئیلا',
 			'AL' => 'البانیہ',
 			'AM' => 'آرمینیا',
 			'AO' => 'انگولا',
 			'AQ' => 'انٹارکٹیکا',
 			'AR' => 'ارجنٹینا',
 			'AS' => 'امریکی ساموآ',
 			'AT' => 'آسٹریا',
 			'AU' => 'آسٹریلیا',
 			'AW' => 'اروبا',
 			'AX' => 'آلینڈ آئلینڈز',
 			'AZ' => 'آذربائیجان',
 			'BA' => 'بوسنیا اور ہرزیگووینا',
 			'BB' => 'بارباڈوس',
 			'BD' => 'بنگلہ دیش',
 			'BE' => 'بیلجیم',
 			'BF' => 'برکینا فاسو',
 			'BG' => 'بلغاریہ',
 			'BH' => 'بحرین',
 			'BI' => 'برونڈی',
 			'BJ' => 'بینن',
 			'BL' => 'سینٹ برتھلیمی',
 			'BM' => 'برمودا',
 			'BN' => 'برونائی',
 			'BO' => 'بولیویا',
 			'BQ' => 'کریبیائی نیدرلینڈز',
 			'BR' => 'برازیل',
 			'BS' => 'بہاماس',
 			'BT' => 'بھوٹان',
 			'BV' => 'بؤویٹ آئلینڈ',
 			'BW' => 'بوتسوانا',
 			'BY' => 'بیلاروس',
 			'BZ' => 'بیلائز',
 			'CA' => 'کینیڈا',
 			'CC' => 'کوکوس (کیلنگ) جزائر',
 			'CD' => 'کانگو - کنشاسا',
 			'CD@alt=variant' => 'کانگو (DRC)',
 			'CF' => 'وسط افریقی جمہوریہ',
 			'CG' => 'کانگو - برازاویلے',
 			'CG@alt=variant' => 'کانگو (جمہوریہ)',
 			'CH' => 'سوئٹزر لینڈ',
 			'CI' => 'کوٹ ڈی آئیوری',
 			'CI@alt=variant' => 'آئیوری کوسٹ',
 			'CK' => 'کک آئلینڈز',
 			'CL' => 'چلی',
 			'CM' => 'کیمرون',
 			'CN' => 'چین',
 			'CO' => 'کولمبیا',
 			'CP' => 'کلپرٹن آئلینڈ',
 			'CR' => 'کوسٹا ریکا',
 			'CU' => 'کیوبا',
 			'CV' => 'کیپ ورڈی',
 			'CW' => 'کیوراکاؤ',
 			'CX' => 'جزیرہ کرسمس',
 			'CY' => 'قبرص',
 			'CZ' => 'چیکیا',
 			'CZ@alt=variant' => 'چیک جمہوریہ',
 			'DE' => 'جرمنی',
 			'DG' => 'ڈائجو گارسیا',
 			'DJ' => 'جبوتی',
 			'DK' => 'ڈنمارک',
 			'DM' => 'ڈومنیکا',
 			'DO' => 'جمہوریہ ڈومينيکن',
 			'DZ' => 'الجیریا',
 			'EA' => 'سیئوٹا اور میلیلا',
 			'EC' => 'ایکواڈور',
 			'EE' => 'اسٹونیا',
 			'EG' => 'مصر',
 			'EH' => 'مغربی صحارا',
 			'ER' => 'اریٹیریا',
 			'ES' => 'ہسپانیہ',
 			'ET' => 'ایتھوپیا',
 			'EU' => 'یوروپی یونین',
 			'EZ' => 'یوروزون',
 			'FI' => 'فن لینڈ',
 			'FJ' => 'فجی',
 			'FK' => 'فاکلینڈ جزائر',
 			'FK@alt=variant' => 'فاکلینڈ جزائر (مالویناس)',
 			'FM' => 'مائکرونیشیا',
 			'FO' => 'جزائر فارو',
 			'FR' => 'فرانس',
 			'GA' => 'گیبون',
 			'GB' => 'سلطنت متحدہ',
 			'GB@alt=short' => 'یو کے',
 			'GD' => 'گریناڈا',
 			'GE' => 'جارجیا',
 			'GF' => 'فرینچ گیانا',
 			'GG' => 'گوئرنسی',
 			'GH' => 'گھانا',
 			'GI' => 'جبل الطارق',
 			'GL' => 'گرین لینڈ',
 			'GM' => 'گیمبیا',
 			'GN' => 'گنی',
 			'GP' => 'گواڈیلوپ',
 			'GQ' => 'استوائی گیانا',
 			'GR' => 'یونان',
 			'GS' => 'جنوبی جارجیا اور جنوبی سینڈوچ جزائر',
 			'GT' => 'گواٹے مالا',
 			'GU' => 'گوام',
 			'GW' => 'گنی بساؤ',
 			'GY' => 'گیانا',
 			'HK' => 'ہانگ کانگ SAR چین',
 			'HK@alt=short' => 'ہانگ کانگ',
 			'HM' => 'ہیرڈ جزیرہ و میکڈولینڈ جزائر',
 			'HN' => 'ہونڈاروس',
 			'HR' => 'کروشیا',
 			'HT' => 'ہیٹی',
 			'HU' => 'ہنگری',
 			'IC' => 'کینری آئلینڈز',
 			'ID' => 'انڈونیشیا',
 			'IE' => 'آئرلینڈ',
 			'IL' => 'اسرائیل',
 			'IM' => 'آئل آف مین',
 			'IN' => 'بھارت',
 			'IO' => 'برطانوی بحر ہند کا علاقہ',
 			'IQ' => 'عراق',
 			'IR' => 'ایران',
 			'IS' => 'آئس لینڈ',
 			'IT' => 'اٹلی',
 			'JE' => 'جرسی',
 			'JM' => 'جمائیکا',
 			'JO' => 'اردن',
 			'JP' => 'جاپان',
 			'KE' => 'کینیا',
 			'KG' => 'کرغزستان',
 			'KH' => 'کمبوڈیا',
 			'KI' => 'کریباتی',
 			'KM' => 'کوموروس',
 			'KN' => 'سینٹ کٹس اور نیویس',
 			'KP' => 'شمالی کوریا',
 			'KR' => 'جنوبی کوریا',
 			'KW' => 'کویت',
 			'KY' => 'کیمین آئلینڈز',
 			'KZ' => 'قزاخستان',
 			'LA' => 'لاؤس',
 			'LB' => 'لبنان',
 			'LC' => 'سینٹ لوسیا',
 			'LI' => 'لیشٹنسٹائن',
 			'LK' => 'سری لنکا',
 			'LR' => 'لائبیریا',
 			'LS' => 'لیسوتھو',
 			'LT' => 'لیتھونیا',
 			'LU' => 'لکسمبرگ',
 			'LV' => 'لٹویا',
 			'LY' => 'لیبیا',
 			'MA' => 'مراکش',
 			'MC' => 'موناکو',
 			'MD' => 'مالدووا',
 			'ME' => 'مونٹے نیگرو',
 			'MF' => 'سینٹ مارٹن',
 			'MG' => 'مڈغاسکر',
 			'MH' => 'مارشل آئلینڈز',
 			'MK' => 'شمالی مقدونیہ',
 			'ML' => 'مالی',
 			'MM' => 'میانمار (برما)',
 			'MN' => 'منگولیا',
 			'MO' => 'مکاؤ SAR چین',
 			'MO@alt=short' => 'مکاؤ',
 			'MP' => 'شمالی ماریانا آئلینڈز',
 			'MQ' => 'مارٹینک',
 			'MR' => 'موریطانیہ',
 			'MS' => 'مونٹسیراٹ',
 			'MT' => 'مالٹا',
 			'MU' => 'ماریشس',
 			'MV' => 'مالدیپ',
 			'MW' => 'ملاوی',
 			'MX' => 'میکسیکو',
 			'MY' => 'ملائشیا',
 			'MZ' => 'موزمبیق',
 			'NA' => 'نامیبیا',
 			'NC' => 'نیو کلیڈونیا',
 			'NE' => 'نائجر',
 			'NF' => 'نارفوک آئلینڈ',
 			'NG' => 'نائجیریا',
 			'NI' => 'نکاراگووا',
 			'NL' => 'نیدر لینڈز',
 			'NO' => 'ناروے',
 			'NP' => 'نیپال',
 			'NR' => 'نؤرو',
 			'NU' => 'نیئو',
 			'NZ' => 'نیوزی لینڈ',
 			'OM' => 'عمان',
 			'PA' => 'پانامہ',
 			'PE' => 'پیرو',
 			'PF' => 'فرانسیسی پولینیشیا',
 			'PG' => 'پاپوآ نیو گنی',
 			'PH' => 'فلپائن',
 			'PK' => 'پاکستان',
 			'PL' => 'پولینڈ',
 			'PM' => 'سینٹ پیئر اور میکلیئون',
 			'PN' => 'پٹکائرن جزائر',
 			'PR' => 'پیورٹو ریکو',
 			'PS' => 'فلسطینی خطے',
 			'PS@alt=short' => 'فلسطین',
 			'PT' => 'پرتگال',
 			'PW' => 'پلاؤ',
 			'PY' => 'پیراگوئے',
 			'QA' => 'قطر',
 			'QO' => 'بیرونی اوشیانیا',
 			'RE' => 'ری یونین',
 			'RO' => 'رومانیہ',
 			'RS' => 'سربیا',
 			'RU' => 'روس',
 			'RW' => 'روانڈا',
 			'SA' => 'سعودی عرب',
 			'SB' => 'سولومن آئلینڈز',
 			'SC' => 'سشلیز',
 			'SD' => 'سوڈان',
 			'SE' => 'سویڈن',
 			'SG' => 'سنگاپور',
 			'SH' => 'سینٹ ہیلینا',
 			'SI' => 'سلووینیا',
 			'SJ' => 'سوالبرڈ اور جان ماین',
 			'SK' => 'سلوواکیہ',
 			'SL' => 'سیرالیون',
 			'SM' => 'سان مارینو',
 			'SN' => 'سینیگل',
 			'SO' => 'صومالیہ',
 			'SR' => 'سورینام',
 			'SS' => 'جنوبی سوڈان',
 			'ST' => 'ساؤ ٹومے اور پرنسپے',
 			'SV' => 'ال سلواڈور',
 			'SX' => 'سنٹ مارٹن',
 			'SY' => 'شام',
 			'SZ' => 'سواتنی',
 			'SZ@alt=variant' => 'سوازی لینڈ',
 			'TA' => 'ٹرسٹن ڈا کیونہا',
 			'TC' => 'ٹرکس اور کیکوس جزائر',
 			'TD' => 'چاڈ',
 			'TF' => 'فرانسیسی جنوبی خطے',
 			'TG' => 'ٹوگو',
 			'TH' => 'تھائی لینڈ',
 			'TJ' => 'تاجکستان',
 			'TK' => 'ٹوکیلاؤ',
 			'TL' => 'تیمور لیسٹ',
 			'TL@alt=variant' => 'مشرقی تیمور',
 			'TM' => 'ترکمانستان',
 			'TN' => 'تونس',
 			'TO' => 'ٹونگا',
 			'TR' => 'ترکی',
 			'TT' => 'ترینیداد اور ٹوباگو',
 			'TV' => 'ٹووالو',
 			'TW' => 'تائیوان',
 			'TZ' => 'تنزانیہ',
 			'UA' => 'یوکرین',
 			'UG' => 'یوگنڈا',
 			'UM' => 'امریکہ سے باہر کے چھوٹے جزائز',
 			'UN' => 'اقوام متحدہ',
 			'US' => 'ریاست ہائے متحدہ امریکہ',
 			'US@alt=short' => 'امریکا',
 			'UY' => 'یوروگوئے',
 			'UZ' => 'ازبکستان',
 			'VA' => 'ویٹیکن سٹی',
 			'VC' => 'سینٹ ونسنٹ اور گرینیڈائنز',
 			'VE' => 'وینزوئیلا',
 			'VG' => 'برٹش ورجن آئلینڈز',
 			'VI' => 'امریکی ورجن آئلینڈز',
 			'VN' => 'ویتنام',
 			'VU' => 'وینوآٹو',
 			'WF' => 'ویلیز اور فیوٹیونا',
 			'WS' => 'ساموآ',
 			'XA' => 'بناوٹی لہجے',
 			'XB' => 'بناوٹی دو سمتی',
 			'XK' => 'کوسووو',
 			'YE' => 'یمن',
 			'YT' => 'مایوٹ',
 			'ZA' => 'جنوبی افریقہ',
 			'ZM' => 'زامبیا',
 			'ZW' => 'زمبابوے',
 			'ZZ' => 'نامعلوم علاقہ',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => 'کیلنڈر',
 			'cf' => 'کرنسی فارمیٹ',
 			'colalternate' => 'علامات کی چھٹائی نظرانداز کریں',
 			'colbackwards' => 'معکوس تلفظ کی چھٹائی',
 			'colcasefirst' => 'بڑے حروف/ چھوٹے حروف کی ترتیب بندی',
 			'colcaselevel' => 'حروف کے تئیں حساس چھٹائی',
 			'collation' => 'چھٹائی کی ترتیب',
 			'colnormalization' => 'معمول کی چھانٹی',
 			'colnumeric' => 'عددی چھانٹی',
 			'colstrength' => 'چھانٹی کی قوت',
 			'currency' => 'کرنسی',
 			'hc' => 'گھنٹہ سائیکل (12 بنام 24)',
 			'lb' => 'لائن بریک انداز',
 			'ms' => 'پیمائش کا نظام',
 			'numbers' => 'اعداد',
 			'timezone' => 'منطقۂ وقت',
 			'va' => 'مقام کا متغیرہ',
 			'x' => 'نجی-استعمال',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[Str]],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{بودھ کلینڈر},
 				'chinese' => q{چینی کیلنڈر},
 				'coptic' => q{کاپٹک کیلنڈر},
 				'dangi' => q{ڈانگی کیلنڈر},
 				'ethiopic' => q{ایتھوپیائی کیلنڈر},
 				'ethiopic-amete-alem' => q{ایتھوپک امیٹ الیم کیلنڈر},
 				'gregorian' => q{جارجیائی کیلنڈر},
 				'hebrew' => q{عبرانی کیلنڈر},
 				'indian' => q{ہندوستانی قومی کیلنڈر},
 				'islamic' => q{اسلامی کیلنڈر},
 				'islamic-civil' => q{اسلامی شہری کیلنڈر},
 				'islamic-umalqura' => q{اسلامی کیلنڈر (ام القراہ)},
 				'iso8601' => q{ISO-8601 کیلنڈر},
 				'japanese' => q{جاپانی کیلنڈر},
 				'persian' => q{فارسی کیلنڈر},
 				'roc' => q{منگوو کیلنڈر},
 			},
 			'cf' => {
 				'account' => q{اکاؤنٹنگ کرنسی فارمیٹ},
 				'standard' => q{اسٹینڈرڈ کرنسی فارمیٹ},
 			},
 			'colalternate' => {
 				'non-ignorable' => q{علامات کی چھٹائی کریں},
 				'shifted' => q{علامات کو نظرانداز کرکے چھٹائی کریں},
 			},
 			'colbackwards' => {
 				'no' => q{لہجوں کی چھٹائی معمول کے انداز میں کریں},
 				'yes' => q{لہجوں کی معکوس چھٹائی کریں},
 			},
 			'colcasefirst' => {
 				'lower' => q{پہلے چھوٹے حروف کی چھٹائی کریں},
 				'no' => q{معمول کے حروف کی ترتیب کی چھٹائی کریں},
 				'upper' => q{پہلے بالائی حروف کی چھٹائی کریں},
 			},
 			'colcaselevel' => {
 				'no' => q{حروف کی عدم حساسیت کی چھٹائی کریں},
 				'yes' => q{حروف کے تئیں حساس کی چھٹائی کریں},
 			},
 			'collation' => {
 				'big5han' => q{روایتی چینی کی چھٹائی کی ترتیب - Big5},
 				'compat' => q{سابقہ چھٹائی کی ترتیب، مطابقت کیلئے},
 				'dictionary' => q{لغت کی چھٹنی کی ترتیب},
 				'ducet' => q{ڈیفالٹ یونی کوڈ چھانٹی کی ترتیب},
 				'eor' => q{یورپی ترتیبی قوانین},
 				'gb2312han' => q{آسان چینی کی چھٹائی کی ترتیب - GB2312},
 				'phonebook' => q{فون بک کی چھٹنی کی ترتیب},
 				'phonetic' => q{صوتی چھٹائی کی ترتیب},
 				'pinyin' => q{پن ین کی چھٹنی کی ترتیب},
 				'reformed' => q{دوبارہ تشکیل شدہ چھٹنی کی ترتیب},
 				'search' => q{عمومی تلاش},
 				'searchjl' => q{Hangul Initial Consonant کے لحاظ سے تلاش کریں},
 				'standard' => q{معیاری چھانٹی کی ترتیب},
 				'stroke' => q{سٹروک کی چھٹنی کی ترتیب},
 				'traditional' => q{روایتی چھٹنی کی ترتیب},
 				'unihan' => q{اساسی-سٹروک کی چھٹنی کی ترتیب},
 			},
 			'colnormalization' => {
 				'no' => q{حسب معمول بنائے بغیر چھٹائی کریں},
 				'yes' => q{معمول کے یونیکوڈ کی چھٹائی کریں},
 			},
 			'colnumeric' => {
 				'no' => q{انفرادی طور پر ہندسوں کی چھٹائی کریں},
 				'yes' => q{اعداد کے لحاظ سے ہندسوں کی چھٹائی کریں},
 			},
 			'colstrength' => {
 				'identical' => q{سبھی کی چھٹائی کریں},
 				'primary' => q{صرف اساسی حروف کی چھٹائی کریں},
 				'quaternary' => q{لہجہ/ بڑے چھوٹے حروف/چوڑائی/Kana کی چھٹائی کریں},
 				'secondary' => q{لہجوں کی چھٹائی کریں},
 				'tertiary' => q{لہجوں/حروف/چوڑائی کی چھٹائی کریں},
 			},
 			'd0' => {
 				'fwidth' => q{پورا عرض},
 				'hwidth' => q{نصف عرض},
 				'npinyin' => q{عددی},
 			},
 			'hc' => {
 				'h11' => q{12 گھنٹے کا نظام (0–11)},
 				'h12' => q{12 گھنٹے کا نظام (1–12)},
 				'h23' => q{24 گھنٹے کا نظام (0–23)},
 				'h24' => q{24 گھنٹے کا نظام (1–24)},
 			},
 			'lb' => {
 				'loose' => q{ڈھیلا لائن بریک انداز},
 				'normal' => q{عمومی لائن بریک انداز},
 				'strict' => q{سخت لائن بریک انداز},
 			},
 			'm0' => {
 				'bgn' => q{US BGN ٹرانسلٹریشن},
 				'ungegn' => q{UN GEGN ٹرانسلٹریشن},
 			},
 			'ms' => {
 				'metric' => q{میٹرک نظام},
 				'uksystem' => q{پیمائش کا امپیریل نظام},
 				'ussystem' => q{پیمائش کا امریکی نظام},
 			},
 			'numbers' => {
 				'arab' => q{عربی ہندی ہندسے},
 				'arabext' => q{توسیع شدہ عربی ہندی ہندسے},
 				'armn' => q{آرمینیائی اعداد},
 				'armnlow' => q{آرمینیائی زیریں اعداد},
 				'beng' => q{بنگالی ہندسے},
 				'deva' => q{دیوناگری ہندسے},
 				'ethi' => q{ایتھوپیائی اعداد},
 				'finance' => q{مالیاتی ہندسے},
 				'fullwide' => q{پورے عرض والے ہندسے},
 				'geor' => q{جارجیائی اعداد},
 				'grek' => q{یونانی اعداد},
 				'greklow' => q{یونانی زیریں اعداد},
 				'gujr' => q{گجراتی ہندسے},
 				'guru' => q{گرمکھی ہندسے},
 				'hanidec' => q{چینی اعشاری اعداد},
 				'hans' => q{آسان چینی اعداد},
 				'hansfin' => q{آسان چینی مالی اعداد},
 				'hant' => q{روایتی چینی اعداد},
 				'hantfin' => q{روایتی چینی مالی اعداد},
 				'hebr' => q{عبرانی اعداد},
 				'jpan' => q{جاپانی اعداد},
 				'jpanfin' => q{جاپانی مالی اعداد},
 				'khmr' => q{خمیر ہندسے},
 				'knda' => q{کنڑ ہندسے},
 				'laoo' => q{لاؤ ہندسے},
 				'latn' => q{مغربی ہندسے},
 				'mlym' => q{ملیالم ہندسے},
 				'mong' => q{منگولیائی ہندسے},
 				'mymr' => q{میانمار کے ہندسے},
 				'native' => q{اصل ہندسے},
 				'orya' => q{اڑیہ ہندسے},
 				'roman' => q{رومن اعداد},
 				'romanlow' => q{رومن زیریں اعداد},
 				'taml' => q{روایتی تمل اعداد},
 				'tamldec' => q{تمل اعداد},
 				'telu' => q{تیلگو ہندسے},
 				'thai' => q{تھائی ہندسے},
 				'tibt' => q{تبتی اعداد},
 				'traditional' => q{روایتی اعداد},
 				'vaii' => q{وائی ہندسے},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'metric' => q{میٹرک},
 			'UK' => q{برطانیہ},
 			'US' => q{ریاست ہائے متحدہ امریکہ},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'language' => 'زبان:{0}',
 			'script' => 'رسم الخط:{0}',
 			'region' => 'خطہ:{0}',

		}
	},
);

has 'text_orientation' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { return {
			lines => '',
			characters => 'right-to-left',
		}}
);

has 'characters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{[؀؁؂؃‌‍‎‏ ً ٌ ٍ َ ُ ِ ّ ْ ٔ ٖ ٗ ٘ ٰ أ آ ں ؤ ۂ ۃ ئ ٻ ة ٺ ټ ٽ ه ي]},
			index => ['ا', 'ب', 'پ', 'ت', 'ٹ', 'ث', 'ج', 'چ', 'ح', 'خ', 'د', 'ڈ', 'ذ', 'ر', 'ڑ', 'ز', 'ژ', 'س', 'ش', 'ص', 'ض', 'ط', 'ظ', 'ع', 'غ', 'ف', 'ق', 'ک', 'گ', 'ل', 'م', 'ن', 'و', 'ہ', 'ھ', 'ء', 'ی', 'ے'],
			main => qr{[ا ب پ ت ٹ ث ج چ ح خ د ڈ ذ ر ڑ ز ژ س ش ص ض ط ظ ع غ ف ق ک گ ل م ن و ہ ھ ء ی ے]},
			numbers => qr{[‎ \- ‑ , ٫ ٬ . % ‰ + 0۰ 1۱ 2۲ 3۳ 4۴ 5۵ 6۶ 7۷ 8۸ 9۹]},
			punctuation => qr{[، ؍ ٫ ٬ ؛ \: ؟ . ۔ ( ) \[ \]]},
		};
	},
EOT
: sub {
		return { index => ['ا', 'ب', 'پ', 'ت', 'ٹ', 'ث', 'ج', 'چ', 'ح', 'خ', 'د', 'ڈ', 'ذ', 'ر', 'ڑ', 'ز', 'ژ', 'س', 'ش', 'ص', 'ض', 'ط', 'ظ', 'ع', 'غ', 'ف', 'ق', 'ک', 'گ', 'ل', 'م', 'ن', 'و', 'ہ', 'ھ', 'ء', 'ی', 'ے'], };
},
);


has 'ellipsis' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub {
		return {
			'final' => '{0}…',
			'initial' => '…{0}',
			'medial' => '{0}…{1}',
			'word-final' => '{0} …',
			'word-initial' => '… {0}',
			'word-medial' => '{0} … {1}',
		};
	},
);

has 'more_information' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{؟},
);

has 'quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{”},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{“},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{’},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{‘},
);

has 'duration_units' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { {
				hm => 'h:mm',
				hms => 'h:mm:ss',
				ms => 'm:ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[HashRef[Str]]],
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					# Long Unit Identifier
					'' => {
						'name' => q(کارڈینل ڈائریکشن),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(کارڈینل ڈائریکشن),
					},
					# Long Unit Identifier
					'1024p1' => {
						'1' => q(کیبی{0}),
					},
					# Core Unit Identifier
					'1024p1' => {
						'1' => q(کیبی{0}),
					},
					# Long Unit Identifier
					'1024p2' => {
						'1' => q(میبی{0}),
					},
					# Core Unit Identifier
					'1024p2' => {
						'1' => q(میبی{0}),
					},
					# Long Unit Identifier
					'1024p3' => {
						'1' => q(جیبی{0}),
					},
					# Core Unit Identifier
					'1024p3' => {
						'1' => q(جیبی{0}),
					},
					# Long Unit Identifier
					'1024p4' => {
						'1' => q(ٹیبی{0}),
					},
					# Core Unit Identifier
					'1024p4' => {
						'1' => q(ٹیبی{0}),
					},
					# Long Unit Identifier
					'1024p5' => {
						'1' => q(پیبی{0}),
					},
					# Core Unit Identifier
					'1024p5' => {
						'1' => q(پیبی{0}),
					},
					# Long Unit Identifier
					'1024p6' => {
						'1' => q(ایکسبی{0}),
					},
					# Core Unit Identifier
					'1024p6' => {
						'1' => q(ایکسبی{0}),
					},
					# Long Unit Identifier
					'1024p7' => {
						'1' => q(زیبی{0}),
					},
					# Core Unit Identifier
					'1024p7' => {
						'1' => q(زیبی{0}),
					},
					# Long Unit Identifier
					'1024p8' => {
						'1' => q(یوب{0}),
					},
					# Core Unit Identifier
					'1024p8' => {
						'1' => q(یوب{0}),
					},
					# Long Unit Identifier
					'10p-1' => {
						'1' => q(ڈیسی {0}),
					},
					# Core Unit Identifier
					'1' => {
						'1' => q(ڈیسی {0}),
					},
					# Long Unit Identifier
					'10p-12' => {
						'1' => q(پکو{0}),
					},
					# Core Unit Identifier
					'12' => {
						'1' => q(پکو{0}),
					},
					# Long Unit Identifier
					'10p-15' => {
						'1' => q(فیمٹو{0}),
					},
					# Core Unit Identifier
					'15' => {
						'1' => q(فیمٹو{0}),
					},
					# Long Unit Identifier
					'10p-18' => {
						'1' => q(اٹو{0}),
					},
					# Core Unit Identifier
					'18' => {
						'1' => q(اٹو{0}),
					},
					# Long Unit Identifier
					'10p-2' => {
						'1' => q(سینٹی {0}),
					},
					# Core Unit Identifier
					'2' => {
						'1' => q(سینٹی {0}),
					},
					# Long Unit Identifier
					'10p-21' => {
						'1' => q(زپٹو{0}),
					},
					# Core Unit Identifier
					'21' => {
						'1' => q(زپٹو{0}),
					},
					# Long Unit Identifier
					'10p-24' => {
						'1' => q(یوکٹو{0}),
					},
					# Core Unit Identifier
					'24' => {
						'1' => q(یوکٹو{0}),
					},
					# Long Unit Identifier
					'10p-3' => {
						'1' => q(ملی {0}),
					},
					# Core Unit Identifier
					'3' => {
						'1' => q(ملی {0}),
					},
					# Long Unit Identifier
					'10p-6' => {
						'1' => q(مائکرو {0}),
					},
					# Core Unit Identifier
					'6' => {
						'1' => q(مائکرو {0}),
					},
					# Long Unit Identifier
					'10p-9' => {
						'1' => q(نینو {0}),
					},
					# Core Unit Identifier
					'9' => {
						'1' => q(نینو {0}),
					},
					# Long Unit Identifier
					'10p1' => {
						'1' => q(ڈیکا{0}),
					},
					# Core Unit Identifier
					'10p1' => {
						'1' => q(ڈیکا{0}),
					},
					# Long Unit Identifier
					'10p12' => {
						'1' => q(ٹیرا{0}),
					},
					# Core Unit Identifier
					'10p12' => {
						'1' => q(ٹیرا{0}),
					},
					# Long Unit Identifier
					'10p15' => {
						'1' => q(پیٹا{0}),
					},
					# Core Unit Identifier
					'10p15' => {
						'1' => q(پیٹا{0}),
					},
					# Long Unit Identifier
					'10p18' => {
						'1' => q(اکسا{0}),
					},
					# Core Unit Identifier
					'10p18' => {
						'1' => q(اکسا{0}),
					},
					# Long Unit Identifier
					'10p2' => {
						'1' => q(ہیکٹو{0}),
					},
					# Core Unit Identifier
					'10p2' => {
						'1' => q(ہیکٹو{0}),
					},
					# Long Unit Identifier
					'10p21' => {
						'1' => q(زیٹا{0}),
					},
					# Core Unit Identifier
					'10p21' => {
						'1' => q(زیٹا{0}),
					},
					# Long Unit Identifier
					'10p24' => {
						'1' => q(یوٹا{0}),
					},
					# Core Unit Identifier
					'10p24' => {
						'1' => q(یوٹا{0}),
					},
					# Long Unit Identifier
					'10p3' => {
						'1' => q(کلو{0}),
					},
					# Core Unit Identifier
					'10p3' => {
						'1' => q(کلو{0}),
					},
					# Long Unit Identifier
					'10p6' => {
						'1' => q(میگا{0}),
					},
					# Core Unit Identifier
					'10p6' => {
						'1' => q(میگا{0}),
					},
					# Long Unit Identifier
					'10p9' => {
						'1' => q(گیگا {0}),
					},
					# Core Unit Identifier
					'10p9' => {
						'1' => q(گیگا {0}),
					},
					# Long Unit Identifier
					'acceleration-g-force' => {
						'1' => q(feminine),
						'name' => q(جی-فورس),
						'one' => q({0} جی-فورس),
						'other' => q({0} جی-فورس),
					},
					# Core Unit Identifier
					'g-force' => {
						'1' => q(feminine),
						'name' => q(جی-فورس),
						'one' => q({0} جی-فورس),
						'other' => q({0} جی-فورس),
					},
					# Long Unit Identifier
					'acceleration-meter-per-square-second' => {
						'name' => q(میٹر فی مربع سیکنڈ),
						'one' => q({0} میٹر فی مربع سیکنڈ),
						'other' => q({0} میٹر فی مربع سیکنڈ),
					},
					# Core Unit Identifier
					'meter-per-square-second' => {
						'name' => q(میٹر فی مربع سیکنڈ),
						'one' => q({0} میٹر فی مربع سیکنڈ),
						'other' => q({0} میٹر فی مربع سیکنڈ),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'1' => q(masculine),
						'name' => q(آرک منٹ),
						'one' => q({0} آرک منٹ),
						'other' => q({0} آرک منٹ),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'1' => q(masculine),
						'name' => q(آرک منٹ),
						'one' => q({0} آرک منٹ),
						'other' => q({0} آرک منٹ),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'1' => q(masculine),
						'name' => q(آرک سیکنڈ),
						'one' => q({0} آرک سیکنڈ),
						'other' => q({0} آرک سیکنڈ),
					},
					# Core Unit Identifier
					'arc-second' => {
						'1' => q(masculine),
						'name' => q(آرک سیکنڈ),
						'one' => q({0} آرک سیکنڈ),
						'other' => q({0} آرک سیکنڈ),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'1' => q(masculine),
						'name' => q(ڈگری),
						'one' => q({0} ڈگری),
						'other' => q({0} ڈگری),
					},
					# Core Unit Identifier
					'degree' => {
						'1' => q(masculine),
						'name' => q(ڈگری),
						'one' => q({0} ڈگری),
						'other' => q({0} ڈگری),
					},
					# Long Unit Identifier
					'angle-radian' => {
						'1' => q(feminine),
						'name' => q(ریڈینس),
						'one' => q({0} ریڈین),
						'other' => q({0} ریڈینس),
					},
					# Core Unit Identifier
					'radian' => {
						'1' => q(feminine),
						'name' => q(ریڈینس),
						'one' => q({0} ریڈین),
						'other' => q({0} ریڈینس),
					},
					# Long Unit Identifier
					'angle-revolution' => {
						'1' => q(feminine),
						'name' => q(گردش),
						'one' => q({0} rev),
						'other' => q({0} گردش),
					},
					# Core Unit Identifier
					'revolution' => {
						'1' => q(feminine),
						'name' => q(گردش),
						'one' => q({0} rev),
						'other' => q({0} گردش),
					},
					# Long Unit Identifier
					'area-acre' => {
						'name' => q(ایکڑ),
						'one' => q({0} ایکڑ),
						'other' => q({0} ایکڑ),
					},
					# Core Unit Identifier
					'acre' => {
						'name' => q(ایکڑ),
						'one' => q({0} ایکڑ),
						'other' => q({0} ایکڑ),
					},
					# Long Unit Identifier
					'area-dunam' => {
						'name' => q(دُنامز),
						'one' => q({0} دُنام),
						'other' => q({0} دُنامز),
					},
					# Core Unit Identifier
					'dunam' => {
						'name' => q(دُنامز),
						'one' => q({0} دُنام),
						'other' => q({0} دُنامز),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'1' => q(masculine),
						'name' => q(ہیکٹر),
						'one' => q({0} ہیکٹر),
						'other' => q({0} ہیکٹر),
					},
					# Core Unit Identifier
					'hectare' => {
						'1' => q(masculine),
						'name' => q(ہیکٹر),
						'one' => q({0} ہیکٹر),
						'other' => q({0} ہیکٹر),
					},
					# Long Unit Identifier
					'area-square-centimeter' => {
						'name' => q(مربع سینٹی میٹر),
						'one' => q({0} مربع سینٹی میٹر),
						'other' => q({0} مربع سینٹی میٹر),
						'per' => q({0} فی مربع سینٹی میٹر),
					},
					# Core Unit Identifier
					'square-centimeter' => {
						'name' => q(مربع سینٹی میٹر),
						'one' => q({0} مربع سینٹی میٹر),
						'other' => q({0} مربع سینٹی میٹر),
						'per' => q({0} فی مربع سینٹی میٹر),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'name' => q(مربع فٹ),
						'one' => q({0} مربع فٹ),
						'other' => q({0} مربع فٹ),
					},
					# Core Unit Identifier
					'square-foot' => {
						'name' => q(مربع فٹ),
						'one' => q({0} مربع فٹ),
						'other' => q({0} مربع فٹ),
					},
					# Long Unit Identifier
					'area-square-inch' => {
						'name' => q(مربع انچ),
						'one' => q({0} مربع انچ),
						'other' => q({0} مربع انچ),
						'per' => q({0} فی مربع انچ),
					},
					# Core Unit Identifier
					'square-inch' => {
						'name' => q(مربع انچ),
						'one' => q({0} مربع انچ),
						'other' => q({0} مربع انچ),
						'per' => q({0} فی مربع انچ),
					},
					# Long Unit Identifier
					'area-square-kilometer' => {
						'name' => q(مربع کلو میٹر),
						'one' => q({0} مربع کلو میٹر),
						'other' => q({0} مربع کلو میٹر),
						'per' => q({0} فی مربع کلو میٹر),
					},
					# Core Unit Identifier
					'square-kilometer' => {
						'name' => q(مربع کلو میٹر),
						'one' => q({0} مربع کلو میٹر),
						'other' => q({0} مربع کلو میٹر),
						'per' => q({0} فی مربع کلو میٹر),
					},
					# Long Unit Identifier
					'area-square-meter' => {
						'name' => q(مربع میٹر),
						'one' => q({0} مربع میٹر),
						'other' => q({0} مربع میٹر),
						'per' => q({0} فی مربع میٹر),
					},
					# Core Unit Identifier
					'square-meter' => {
						'name' => q(مربع میٹر),
						'one' => q({0} مربع میٹر),
						'other' => q({0} مربع میٹر),
						'per' => q({0} فی مربع میٹر),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'name' => q(مربع میل),
						'one' => q({0} مربع میل),
						'other' => q({0} مربع میل),
						'per' => q({0} فی مربع میل),
					},
					# Core Unit Identifier
					'square-mile' => {
						'name' => q(مربع میل),
						'one' => q({0} مربع میل),
						'other' => q({0} مربع میل),
						'per' => q({0} فی مربع میل),
					},
					# Long Unit Identifier
					'area-square-yard' => {
						'name' => q(مربع گز),
						'one' => q({0} مربع گز),
						'other' => q({0} مربع گز),
					},
					# Core Unit Identifier
					'square-yard' => {
						'name' => q(مربع گز),
						'one' => q({0} مربع گز),
						'other' => q({0} مربع گز),
					},
					# Long Unit Identifier
					'concentr-item' => {
						'name' => q(آئٹمز),
						'one' => q({0} آئٹم),
						'other' => q({0} آئٹمز),
					},
					# Core Unit Identifier
					'item' => {
						'name' => q(آئٹمز),
						'one' => q({0} آئٹم),
						'other' => q({0} آئٹمز),
					},
					# Long Unit Identifier
					'concentr-karat' => {
						'1' => q(masculine),
						'name' => q(قیراط),
						'one' => q({0} قیراط),
						'other' => q({0} قیراط),
					},
					# Core Unit Identifier
					'karat' => {
						'1' => q(masculine),
						'name' => q(قیراط),
						'one' => q({0} قیراط),
						'other' => q({0} قیراط),
					},
					# Long Unit Identifier
					'concentr-milligram-ofglucose-per-deciliter' => {
						'name' => q(ملی گرام فی ڈیسی لیٹر),
						'one' => q({0} ملی گرام فی ڈیسی لیٹر),
						'other' => q({0} ملی گرام فی ڈیسی لیٹر),
					},
					# Core Unit Identifier
					'milligram-ofglucose-per-deciliter' => {
						'name' => q(ملی گرام فی ڈیسی لیٹر),
						'one' => q({0} ملی گرام فی ڈیسی لیٹر),
						'other' => q({0} ملی گرام فی ڈیسی لیٹر),
					},
					# Long Unit Identifier
					'concentr-millimole-per-liter' => {
						'name' => q(ملی مولس فی لیٹر),
						'one' => q({0} ملی مول فی لیٹر),
						'other' => q({0} ملی مول فی لیٹر),
					},
					# Core Unit Identifier
					'millimole-per-liter' => {
						'name' => q(ملی مولس فی لیٹر),
						'one' => q({0} ملی مول فی لیٹر),
						'other' => q({0} ملی مول فی لیٹر),
					},
					# Long Unit Identifier
					'concentr-mole' => {
						'1' => q(feminine),
						'name' => q(مولز),
						'one' => q({0} مول),
						'other' => q({0} مولز),
					},
					# Core Unit Identifier
					'mole' => {
						'1' => q(feminine),
						'name' => q(مولز),
						'one' => q({0} مول),
						'other' => q({0} مولز),
					},
					# Long Unit Identifier
					'concentr-percent' => {
						'1' => q(feminine),
						'name' => q(فیصد),
						'one' => q({0} فیصد),
						'other' => q({0} فیصد),
					},
					# Core Unit Identifier
					'percent' => {
						'1' => q(feminine),
						'name' => q(فیصد),
						'one' => q({0} فیصد),
						'other' => q({0} فیصد),
					},
					# Long Unit Identifier
					'concentr-permille' => {
						'1' => q(feminine),
						'name' => q(فی ہزار),
						'one' => q({0} فی ہزار),
						'other' => q({0} فی ہزار),
					},
					# Core Unit Identifier
					'permille' => {
						'1' => q(feminine),
						'name' => q(فی ہزار),
						'one' => q({0} فی ہزار),
						'other' => q({0} فی ہزار),
					},
					# Long Unit Identifier
					'concentr-permillion' => {
						'1' => q(feminine),
						'name' => q(فی ملین حصے),
						'one' => q({0} فی ملین حصے),
						'other' => q({0} فی ملین حصے),
					},
					# Core Unit Identifier
					'permillion' => {
						'1' => q(feminine),
						'name' => q(فی ملین حصے),
						'one' => q({0} فی ملین حصے),
						'other' => q({0} فی ملین حصے),
					},
					# Long Unit Identifier
					'concentr-permyriad' => {
						'1' => q(feminine),
						'name' => q(پرمرئیڈ),
						'one' => q({0} پرمرئیڈ),
						'other' => q({0} پرمرئیڈ),
					},
					# Core Unit Identifier
					'permyriad' => {
						'1' => q(feminine),
						'name' => q(پرمرئیڈ),
						'one' => q({0} پرمرئیڈ),
						'other' => q({0} پرمرئیڈ),
					},
					# Long Unit Identifier
					'consumption-liter-per-100-kilometer' => {
						'name' => q(لیٹر فی 100 کلو میٹر),
						'one' => q({0} لیٹر فی 100 کلو میٹر),
						'other' => q({0} لیٹر فی 100 کلو میٹر),
					},
					# Core Unit Identifier
					'liter-per-100-kilometer' => {
						'name' => q(لیٹر فی 100 کلو میٹر),
						'one' => q({0} لیٹر فی 100 کلو میٹر),
						'other' => q({0} لیٹر فی 100 کلو میٹر),
					},
					# Long Unit Identifier
					'consumption-liter-per-kilometer' => {
						'name' => q(لیٹر فی کلومیٹر),
						'one' => q({0} لیٹر فی کلومیٹر),
						'other' => q({0} لیٹر فی کلومیٹر),
					},
					# Core Unit Identifier
					'liter-per-kilometer' => {
						'name' => q(لیٹر فی کلومیٹر),
						'one' => q({0} لیٹر فی کلومیٹر),
						'other' => q({0} لیٹر فی کلومیٹر),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon' => {
						'name' => q(میل فی گیلن),
						'one' => q({0} میل فی گیلن),
						'other' => q({0} میل فی گیلن),
					},
					# Core Unit Identifier
					'mile-per-gallon' => {
						'name' => q(میل فی گیلن),
						'one' => q({0} میل فی گیلن),
						'other' => q({0} میل فی گیلن),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon-imperial' => {
						'name' => q(میل فی امپیریل گیلن),
						'one' => q({0} میل فی امپیریل گیلن),
						'other' => q({0} میل فی امپیریل گیلن),
					},
					# Core Unit Identifier
					'mile-per-gallon-imperial' => {
						'name' => q(میل فی امپیریل گیلن),
						'one' => q({0} میل فی امپیریل گیلن),
						'other' => q({0} میل فی امپیریل گیلن),
					},
					# Long Unit Identifier
					'coordinate' => {
						'east' => q({0} مشرق),
						'north' => q({0} شمال),
						'south' => q({0} جنوب),
						'west' => q({0} مغرب),
					},
					# Core Unit Identifier
					'coordinate' => {
						'east' => q({0} مشرق),
						'north' => q({0} شمال),
						'south' => q({0} جنوب),
						'west' => q({0} مغرب),
					},
					# Long Unit Identifier
					'digital-bit' => {
						'1' => q(feminine),
						'name' => q(بٹس),
						'one' => q({0} بٹ),
						'other' => q({0} بٹس),
					},
					# Core Unit Identifier
					'bit' => {
						'1' => q(feminine),
						'name' => q(بٹس),
						'one' => q({0} بٹ),
						'other' => q({0} بٹس),
					},
					# Long Unit Identifier
					'digital-byte' => {
						'1' => q(feminine),
						'name' => q(بائٹ),
						'one' => q({0} بائٹ),
						'other' => q({0} بائٹس),
					},
					# Core Unit Identifier
					'byte' => {
						'1' => q(feminine),
						'name' => q(بائٹ),
						'one' => q({0} بائٹ),
						'other' => q({0} بائٹس),
					},
					# Long Unit Identifier
					'digital-gigabit' => {
						'name' => q(گیگابٹس),
						'one' => q({0} گیگابٹ),
						'other' => q({0} گیگابٹس),
					},
					# Core Unit Identifier
					'gigabit' => {
						'name' => q(گیگابٹس),
						'one' => q({0} گیگابٹ),
						'other' => q({0} گیگابٹس),
					},
					# Long Unit Identifier
					'digital-gigabyte' => {
						'name' => q(گیگابائٹس),
						'one' => q({0} گیگابائٹ),
						'other' => q({0} گیگابائٹ),
					},
					# Core Unit Identifier
					'gigabyte' => {
						'name' => q(گیگابائٹس),
						'one' => q({0} گیگابائٹ),
						'other' => q({0} گیگابائٹ),
					},
					# Long Unit Identifier
					'digital-kilobit' => {
						'name' => q(کلوبٹس),
						'one' => q({0} کلوبٹ),
						'other' => q({0} کلوبٹس),
					},
					# Core Unit Identifier
					'kilobit' => {
						'name' => q(کلوبٹس),
						'one' => q({0} کلوبٹ),
						'other' => q({0} کلوبٹس),
					},
					# Long Unit Identifier
					'digital-kilobyte' => {
						'name' => q(کلوبائٹس),
						'one' => q({0} کلوبائٹ),
						'other' => q({0} کلوبائٹس),
					},
					# Core Unit Identifier
					'kilobyte' => {
						'name' => q(کلوبائٹس),
						'one' => q({0} کلوبائٹ),
						'other' => q({0} کلوبائٹس),
					},
					# Long Unit Identifier
					'digital-megabit' => {
						'name' => q(میگابٹس),
						'one' => q({0} میگابٹ),
						'other' => q({0} میگابٹس),
					},
					# Core Unit Identifier
					'megabit' => {
						'name' => q(میگابٹس),
						'one' => q({0} میگابٹ),
						'other' => q({0} میگابٹس),
					},
					# Long Unit Identifier
					'digital-megabyte' => {
						'name' => q(ميگابائٹس),
						'one' => q({0} میگابائٹ),
						'other' => q({0} ميگابائٹس),
					},
					# Core Unit Identifier
					'megabyte' => {
						'name' => q(ميگابائٹس),
						'one' => q({0} میگابائٹ),
						'other' => q({0} ميگابائٹس),
					},
					# Long Unit Identifier
					'digital-petabyte' => {
						'name' => q(پیٹا بائٹس),
						'one' => q({0} پیٹا بائٹ),
						'other' => q({0} پیٹا بائٹس),
					},
					# Core Unit Identifier
					'petabyte' => {
						'name' => q(پیٹا بائٹس),
						'one' => q({0} پیٹا بائٹ),
						'other' => q({0} پیٹا بائٹس),
					},
					# Long Unit Identifier
					'digital-terabit' => {
						'name' => q(ٹیرابٹس),
						'one' => q({0} ٹیرابٹ),
						'other' => q({0} ٹیرابٹس),
					},
					# Core Unit Identifier
					'terabit' => {
						'name' => q(ٹیرابٹس),
						'one' => q({0} ٹیرابٹ),
						'other' => q({0} ٹیرابٹس),
					},
					# Long Unit Identifier
					'digital-terabyte' => {
						'name' => q(ٹیرابائٹس),
						'one' => q({0} ٹیرابائٹ),
						'other' => q({0} ٹیرابائٹ),
					},
					# Core Unit Identifier
					'terabyte' => {
						'name' => q(ٹیرابائٹس),
						'one' => q({0} ٹیرابائٹ),
						'other' => q({0} ٹیرابائٹ),
					},
					# Long Unit Identifier
					'duration-century' => {
						'1' => q(feminine),
						'name' => q(صدیاں),
						'one' => q({0} صدی),
						'other' => q({0} صدیاں),
					},
					# Core Unit Identifier
					'century' => {
						'1' => q(feminine),
						'name' => q(صدیاں),
						'one' => q({0} صدی),
						'other' => q({0} صدیاں),
					},
					# Long Unit Identifier
					'duration-day' => {
						'1' => q(masculine),
						'name' => q(دن),
						'one' => q({0} دن),
						'other' => q({0} دن),
						'per' => q({0} فی دن),
					},
					# Core Unit Identifier
					'day' => {
						'1' => q(masculine),
						'name' => q(دن),
						'one' => q({0} دن),
						'other' => q({0} دن),
						'per' => q({0} فی دن),
					},
					# Long Unit Identifier
					'duration-day-person' => {
						'1' => q(masculine),
					},
					# Core Unit Identifier
					'day-person' => {
						'1' => q(masculine),
					},
					# Long Unit Identifier
					'duration-decade' => {
						'1' => q(feminine),
						'name' => q(دہائیاں),
						'one' => q({0} دہائی),
						'other' => q({0} دہائیاں),
					},
					# Core Unit Identifier
					'decade' => {
						'1' => q(feminine),
						'name' => q(دہائیاں),
						'one' => q({0} دہائی),
						'other' => q({0} دہائیاں),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'1' => q(masculine),
						'name' => q(گھنٹے),
						'one' => q({0} گھنٹہ),
						'other' => q({0} گھنٹے),
						'per' => q({0} فی گھنٹہ),
					},
					# Core Unit Identifier
					'hour' => {
						'1' => q(masculine),
						'name' => q(گھنٹے),
						'one' => q({0} گھنٹہ),
						'other' => q({0} گھنٹے),
						'per' => q({0} فی گھنٹہ),
					},
					# Long Unit Identifier
					'duration-microsecond' => {
						'name' => q(مائیکرو سیکنڈز),
						'one' => q({0} مائیکرو سیکنڈ),
						'other' => q({0} مائیکرو سیکنڈز),
					},
					# Core Unit Identifier
					'microsecond' => {
						'name' => q(مائیکرو سیکنڈز),
						'one' => q({0} مائیکرو سیکنڈ),
						'other' => q({0} مائیکرو سیکنڈز),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'name' => q(ملی سیکنڈز),
						'one' => q({0} ملی سیکنڈ),
						'other' => q({0} میل سیکنڈ),
					},
					# Core Unit Identifier
					'millisecond' => {
						'name' => q(ملی سیکنڈز),
						'one' => q({0} ملی سیکنڈ),
						'other' => q({0} میل سیکنڈ),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'1' => q(masculine),
						'name' => q(منٹ),
						'one' => q({0} منٹ),
						'other' => q({0} منٹ),
						'per' => q({0} فی منٹ),
					},
					# Core Unit Identifier
					'minute' => {
						'1' => q(masculine),
						'name' => q(منٹ),
						'one' => q({0} منٹ),
						'other' => q({0} منٹ),
						'per' => q({0} فی منٹ),
					},
					# Long Unit Identifier
					'duration-month' => {
						'1' => q(masculine),
						'name' => q(مہینے),
						'one' => q({0} مہینہ),
						'other' => q({0} مہینے),
						'per' => q({0}/m),
					},
					# Core Unit Identifier
					'month' => {
						'1' => q(masculine),
						'name' => q(مہینے),
						'one' => q({0} مہینہ),
						'other' => q({0} مہینے),
						'per' => q({0}/m),
					},
					# Long Unit Identifier
					'duration-nanosecond' => {
						'name' => q(نینو سیکنڈز),
						'one' => q({0} نینو سیکنڈ),
						'other' => q({0} نینو سیکنڈ),
					},
					# Core Unit Identifier
					'nanosecond' => {
						'name' => q(نینو سیکنڈز),
						'one' => q({0} نینو سیکنڈ),
						'other' => q({0} نینو سیکنڈ),
					},
					# Long Unit Identifier
					'duration-second' => {
						'1' => q(masculine),
						'name' => q(سیکنڈ),
						'one' => q({0} سیکنڈ),
						'other' => q({0} سیکنڈ),
						'per' => q({0} فی سیکنڈ),
					},
					# Core Unit Identifier
					'second' => {
						'1' => q(masculine),
						'name' => q(سیکنڈ),
						'one' => q({0} سیکنڈ),
						'other' => q({0} سیکنڈ),
						'per' => q({0} فی سیکنڈ),
					},
					# Long Unit Identifier
					'duration-week' => {
						'1' => q(masculine),
						'name' => q(ہفتے),
						'one' => q({0} ہفتہ),
						'other' => q({0} ہفتے),
						'per' => q({0} فی ہفتہ),
					},
					# Core Unit Identifier
					'week' => {
						'1' => q(masculine),
						'name' => q(ہفتے),
						'one' => q({0} ہفتہ),
						'other' => q({0} ہفتے),
						'per' => q({0} فی ہفتہ),
					},
					# Long Unit Identifier
					'duration-year' => {
						'1' => q(masculine),
						'name' => q(سال),
						'one' => q({0} سال),
						'other' => q({0} سال),
						'per' => q(فی سال {0}),
					},
					# Core Unit Identifier
					'year' => {
						'1' => q(masculine),
						'name' => q(سال),
						'one' => q({0} سال),
						'other' => q({0} سال),
						'per' => q(فی سال {0}),
					},
					# Long Unit Identifier
					'electric-ampere' => {
						'1' => q(masculine),
						'name' => q(ایمپیئر),
						'one' => q({0} ایمپیئر),
						'other' => q({0} ایمپیئر),
					},
					# Core Unit Identifier
					'ampere' => {
						'1' => q(masculine),
						'name' => q(ایمپیئر),
						'one' => q({0} ایمپیئر),
						'other' => q({0} ایمپیئر),
					},
					# Long Unit Identifier
					'electric-milliampere' => {
						'name' => q(ملی ایمپیئر),
						'one' => q({0} ملی ایمپیئر),
						'other' => q({0} ملی ایمپیئر),
					},
					# Core Unit Identifier
					'milliampere' => {
						'name' => q(ملی ایمپیئر),
						'one' => q({0} ملی ایمپیئر),
						'other' => q({0} ملی ایمپیئر),
					},
					# Long Unit Identifier
					'electric-ohm' => {
						'1' => q(masculine),
						'name' => q(اوہم),
						'one' => q({0} اوہم),
						'other' => q({0} اوہم),
					},
					# Core Unit Identifier
					'ohm' => {
						'1' => q(masculine),
						'name' => q(اوہم),
						'one' => q({0} اوہم),
						'other' => q({0} اوہم),
					},
					# Long Unit Identifier
					'electric-volt' => {
						'1' => q(masculine),
						'name' => q(وولٹ),
						'one' => q({0} وولٹ),
						'other' => q({0} وولٹ),
					},
					# Core Unit Identifier
					'volt' => {
						'1' => q(masculine),
						'name' => q(وولٹ),
						'one' => q({0} وولٹ),
						'other' => q({0} وولٹ),
					},
					# Long Unit Identifier
					'energy-british-thermal-unit' => {
						'name' => q(برطانوی تھرمل اکائیاں),
						'one' => q({0} برطانوی تھرمل اکائی),
						'other' => q({0} برطانوی تھرمل اکائیاں),
					},
					# Core Unit Identifier
					'british-thermal-unit' => {
						'name' => q(برطانوی تھرمل اکائیاں),
						'one' => q({0} برطانوی تھرمل اکائی),
						'other' => q({0} برطانوی تھرمل اکائیاں),
					},
					# Long Unit Identifier
					'energy-calorie' => {
						'1' => q(feminine),
						'name' => q(کیلوریز),
						'one' => q({0} کیلوری),
						'other' => q({0} کیلوریز),
					},
					# Core Unit Identifier
					'calorie' => {
						'1' => q(feminine),
						'name' => q(کیلوریز),
						'one' => q({0} کیلوری),
						'other' => q({0} کیلوریز),
					},
					# Long Unit Identifier
					'energy-electronvolt' => {
						'name' => q(الیکٹرون وولٹس),
						'one' => q({0} الیکٹرون وولٹ),
						'other' => q({0} الیکٹرون وولٹس),
					},
					# Core Unit Identifier
					'electronvolt' => {
						'name' => q(الیکٹرون وولٹس),
						'one' => q({0} الیکٹرون وولٹ),
						'other' => q({0} الیکٹرون وولٹس),
					},
					# Long Unit Identifier
					'energy-foodcalorie' => {
						'name' => q(کیلوریز),
						'one' => q({0} کیلوری),
						'other' => q({0} کیلوریز),
					},
					# Core Unit Identifier
					'foodcalorie' => {
						'name' => q(کیلوریز),
						'one' => q({0} کیلوری),
						'other' => q({0} کیلوریز),
					},
					# Long Unit Identifier
					'energy-joule' => {
						'1' => q(feminine),
						'name' => q(جول),
						'one' => q({0} جول),
						'other' => q({0} جول),
					},
					# Core Unit Identifier
					'joule' => {
						'1' => q(feminine),
						'name' => q(جول),
						'one' => q({0} جول),
						'other' => q({0} جول),
					},
					# Long Unit Identifier
					'energy-kilocalorie' => {
						'name' => q(کلو کیلوریز),
						'one' => q({0} کلو کیلوری),
						'other' => q({0} کلو کیلوریز),
					},
					# Core Unit Identifier
					'kilocalorie' => {
						'name' => q(کلو کیلوریز),
						'one' => q({0} کلو کیلوری),
						'other' => q({0} کلو کیلوریز),
					},
					# Long Unit Identifier
					'energy-kilojoule' => {
						'name' => q(کلو جول),
						'one' => q({0} کلو جول),
						'other' => q({0} کلو جول),
					},
					# Core Unit Identifier
					'kilojoule' => {
						'name' => q(کلو جول),
						'one' => q({0} کلو جول),
						'other' => q({0} کلو جول),
					},
					# Long Unit Identifier
					'energy-kilowatt-hour' => {
						'name' => q(کلو واٹ آور),
						'one' => q({0} کلو واٹ آور),
						'other' => q({0} کلو واٹ آور),
					},
					# Core Unit Identifier
					'kilowatt-hour' => {
						'name' => q(کلو واٹ آور),
						'one' => q({0} کلو واٹ آور),
						'other' => q({0} کلو واٹ آور),
					},
					# Long Unit Identifier
					'energy-therm-us' => {
						'name' => q(امریکی تھرمز),
						'one' => q({0} امریکی تھرم),
						'other' => q({0} امریکی تھرمز),
					},
					# Core Unit Identifier
					'therm-us' => {
						'name' => q(امریکی تھرمز),
						'one' => q({0} امریکی تھرم),
						'other' => q({0} امریکی تھرمز),
					},
					# Long Unit Identifier
					'force-kilowatt-hour-per-100-kilometer' => {
						'name' => q(کلو واٹ گھنٹے فی 100 کلومیٹر),
						'one' => q({0} کلو واٹ گھنٹہ فی 100 کلومیٹر),
						'other' => q({0} کلو واٹ گھنٹے فی 100 کلومیٹر),
					},
					# Core Unit Identifier
					'kilowatt-hour-per-100-kilometer' => {
						'name' => q(کلو واٹ گھنٹے فی 100 کلومیٹر),
						'one' => q({0} کلو واٹ گھنٹہ فی 100 کلومیٹر),
						'other' => q({0} کلو واٹ گھنٹے فی 100 کلومیٹر),
					},
					# Long Unit Identifier
					'force-newton' => {
						'1' => q(masculine),
						'name' => q(نیوٹنز),
						'one' => q({0} نیوٹن),
						'other' => q({0} نیوٹنز),
					},
					# Core Unit Identifier
					'newton' => {
						'1' => q(masculine),
						'name' => q(نیوٹنز),
						'one' => q({0} نیوٹن),
						'other' => q({0} نیوٹنز),
					},
					# Long Unit Identifier
					'force-pound-force' => {
						'name' => q(پاؤنڈز قوت),
						'one' => q({0} پاؤنڈ قوت),
						'other' => q({0} پاؤنڈز قوت),
					},
					# Core Unit Identifier
					'pound-force' => {
						'name' => q(پاؤنڈز قوت),
						'one' => q({0} پاؤنڈ قوت),
						'other' => q({0} پاؤنڈز قوت),
					},
					# Long Unit Identifier
					'frequency-gigahertz' => {
						'name' => q(گیگاہرٹز),
						'one' => q({0} گیگاہرٹز),
						'other' => q({0} گیگاہرٹز),
					},
					# Core Unit Identifier
					'gigahertz' => {
						'name' => q(گیگاہرٹز),
						'one' => q({0} گیگاہرٹز),
						'other' => q({0} گیگاہرٹز),
					},
					# Long Unit Identifier
					'frequency-hertz' => {
						'1' => q(masculine),
						'name' => q(ہرٹز),
						'one' => q({0} ہرٹز),
						'other' => q({0} ہرٹز),
					},
					# Core Unit Identifier
					'hertz' => {
						'1' => q(masculine),
						'name' => q(ہرٹز),
						'one' => q({0} ہرٹز),
						'other' => q({0} ہرٹز),
					},
					# Long Unit Identifier
					'frequency-kilohertz' => {
						'name' => q(کلوہرٹز),
						'one' => q({0} کلوہرٹز),
						'other' => q({0} کلوہرٹز),
					},
					# Core Unit Identifier
					'kilohertz' => {
						'name' => q(کلوہرٹز),
						'one' => q({0} کلوہرٹز),
						'other' => q({0} کلوہرٹز),
					},
					# Long Unit Identifier
					'frequency-megahertz' => {
						'name' => q(میگاہرٹز),
						'one' => q({0} میگاہرٹز),
						'other' => q({0} میگاہرٹز),
					},
					# Core Unit Identifier
					'megahertz' => {
						'name' => q(میگاہرٹز),
						'one' => q({0} میگاہرٹز),
						'other' => q({0} میگاہرٹز),
					},
					# Long Unit Identifier
					'graphics-dot' => {
						'name' => q(ڈاٹ),
					},
					# Core Unit Identifier
					'dot' => {
						'name' => q(ڈاٹ),
					},
					# Long Unit Identifier
					'graphics-dot-per-centimeter' => {
						'name' => q(ڈاٹس فی سینٹی میٹر),
						'one' => q({0} ڈاٹ فی سینٹی میٹر),
						'other' => q({0} ڈاٹس فی سینٹی میٹر),
					},
					# Core Unit Identifier
					'dot-per-centimeter' => {
						'name' => q(ڈاٹس فی سینٹی میٹر),
						'one' => q({0} ڈاٹ فی سینٹی میٹر),
						'other' => q({0} ڈاٹس فی سینٹی میٹر),
					},
					# Long Unit Identifier
					'graphics-dot-per-inch' => {
						'name' => q(ڈاٹس فی انچ),
						'one' => q({0} ڈاٹ فی انچ),
						'other' => q({0} ڈاٹس فی انچ),
					},
					# Core Unit Identifier
					'dot-per-inch' => {
						'name' => q(ڈاٹس فی انچ),
						'one' => q({0} ڈاٹ فی انچ),
						'other' => q({0} ڈاٹس فی انچ),
					},
					# Long Unit Identifier
					'graphics-em' => {
						'1' => q(masculine),
						'name' => q(ٹائپوگرافک em),
						'one' => q({0} em),
						'other' => q({0} ems),
					},
					# Core Unit Identifier
					'em' => {
						'1' => q(masculine),
						'name' => q(ٹائپوگرافک em),
						'one' => q({0} em),
						'other' => q({0} ems),
					},
					# Long Unit Identifier
					'graphics-megapixel' => {
						'name' => q(میگا پکسلز),
						'one' => q({0} میگا پکسل),
						'other' => q({0} میگا پکسلز),
					},
					# Core Unit Identifier
					'megapixel' => {
						'name' => q(میگا پکسلز),
						'one' => q({0} میگا پکسل),
						'other' => q({0} میگا پکسلز),
					},
					# Long Unit Identifier
					'graphics-pixel' => {
						'1' => q(masculine),
						'name' => q(پکسلز),
						'one' => q({0} پکسل),
						'other' => q({0} پکسلز),
					},
					# Core Unit Identifier
					'pixel' => {
						'1' => q(masculine),
						'name' => q(پکسلز),
						'one' => q({0} پکسل),
						'other' => q({0} پکسلز),
					},
					# Long Unit Identifier
					'graphics-pixel-per-centimeter' => {
						'name' => q(پکسلز فی سینٹی میٹر),
						'one' => q({0} پکسل فی سینٹی میٹر),
						'other' => q({0} پکسلز فی سینٹی میٹر),
					},
					# Core Unit Identifier
					'pixel-per-centimeter' => {
						'name' => q(پکسلز فی سینٹی میٹر),
						'one' => q({0} پکسل فی سینٹی میٹر),
						'other' => q({0} پکسلز فی سینٹی میٹر),
					},
					# Long Unit Identifier
					'graphics-pixel-per-inch' => {
						'name' => q(پکسلز فی انچ),
						'one' => q({0} پکسل فی انچ),
						'other' => q({0} پکسلز فی انچ),
					},
					# Core Unit Identifier
					'pixel-per-inch' => {
						'name' => q(پکسلز فی انچ),
						'one' => q({0} پکسل فی انچ),
						'other' => q({0} پکسلز فی انچ),
					},
					# Long Unit Identifier
					'length-astronomical-unit' => {
						'name' => q(ایسٹرونومیکل یونٹس),
						'one' => q({0} ایسٹرونومیکل یونٹ),
						'other' => q({0} ایسٹرونومیکل یونٹس),
					},
					# Core Unit Identifier
					'astronomical-unit' => {
						'name' => q(ایسٹرونومیکل یونٹس),
						'one' => q({0} ایسٹرونومیکل یونٹ),
						'other' => q({0} ایسٹرونومیکل یونٹس),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'name' => q(سینٹی میٹر),
						'one' => q({0} سینٹی میٹر),
						'other' => q({0} سینٹی میٹر),
						'per' => q({0} فی سینٹی میٹر),
					},
					# Core Unit Identifier
					'centimeter' => {
						'name' => q(سینٹی میٹر),
						'one' => q({0} سینٹی میٹر),
						'other' => q({0} سینٹی میٹر),
						'per' => q({0} فی سینٹی میٹر),
					},
					# Long Unit Identifier
					'length-decimeter' => {
						'name' => q(ڈیسی میٹر),
						'one' => q({0} ڈیسی میٹر),
						'other' => q({0} ڈیسی میٹر),
					},
					# Core Unit Identifier
					'decimeter' => {
						'name' => q(ڈیسی میٹر),
						'one' => q({0} ڈیسی میٹر),
						'other' => q({0} ڈیسی میٹر),
					},
					# Long Unit Identifier
					'length-earth-radius' => {
						'name' => q(زمینی رداس),
						'one' => q({0} زمینی رداس),
						'other' => q({0} زمینی رداس),
					},
					# Core Unit Identifier
					'earth-radius' => {
						'name' => q(زمینی رداس),
						'one' => q({0} زمینی رداس),
						'other' => q({0} زمینی رداس),
					},
					# Long Unit Identifier
					'length-fathom' => {
						'name' => q(فیدمز),
						'one' => q({0} فیدم),
						'other' => q({0} فیدمز),
					},
					# Core Unit Identifier
					'fathom' => {
						'name' => q(فیدمز),
						'one' => q({0} فیدم),
						'other' => q({0} فیدمز),
					},
					# Long Unit Identifier
					'length-foot' => {
						'name' => q(فیٹ),
						'one' => q({0} فیٹ),
						'other' => q({0} فیٹ),
						'per' => q({0} فی فوٹ),
					},
					# Core Unit Identifier
					'foot' => {
						'name' => q(فیٹ),
						'one' => q({0} فیٹ),
						'other' => q({0} فیٹ),
						'per' => q({0} فی فوٹ),
					},
					# Long Unit Identifier
					'length-furlong' => {
						'name' => q(فرلانگز),
						'one' => q({0} فرلانگ),
						'other' => q({0} فرلانگز),
					},
					# Core Unit Identifier
					'furlong' => {
						'name' => q(فرلانگز),
						'one' => q({0} فرلانگ),
						'other' => q({0} فرلانگز),
					},
					# Long Unit Identifier
					'length-inch' => {
						'name' => q(انچ),
						'one' => q({0} انچ),
						'other' => q({0} انچ),
						'per' => q({0} فی انچ),
					},
					# Core Unit Identifier
					'inch' => {
						'name' => q(انچ),
						'one' => q({0} انچ),
						'other' => q({0} انچ),
						'per' => q({0} فی انچ),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'name' => q(کلو میٹر),
						'one' => q({0} کلو میٹر),
						'other' => q({0} کلو میٹر),
						'per' => q({0} فی کلومیٹر),
					},
					# Core Unit Identifier
					'kilometer' => {
						'name' => q(کلو میٹر),
						'one' => q({0} کلو میٹر),
						'other' => q({0} کلو میٹر),
						'per' => q({0} فی کلومیٹر),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'name' => q(نوری سال),
						'one' => q({0} نوری سال),
						'other' => q({0} نوری سال),
					},
					# Core Unit Identifier
					'light-year' => {
						'name' => q(نوری سال),
						'one' => q({0} نوری سال),
						'other' => q({0} نوری سال),
					},
					# Long Unit Identifier
					'length-meter' => {
						'1' => q(masculine),
						'name' => q(میٹر),
						'one' => q({0} میٹر),
						'other' => q({0} میٹر),
						'per' => q({0} فی میٹر),
					},
					# Core Unit Identifier
					'meter' => {
						'1' => q(masculine),
						'name' => q(میٹر),
						'one' => q({0} میٹر),
						'other' => q({0} میٹر),
						'per' => q({0} فی میٹر),
					},
					# Long Unit Identifier
					'length-micrometer' => {
						'name' => q(مائیکرو میٹر),
						'one' => q({0} مائیکرو میٹر),
						'other' => q({0} مائیکرو میٹر),
					},
					# Core Unit Identifier
					'micrometer' => {
						'name' => q(مائیکرو میٹر),
						'one' => q({0} مائیکرو میٹر),
						'other' => q({0} مائیکرو میٹر),
					},
					# Long Unit Identifier
					'length-mile' => {
						'name' => q(میل),
						'one' => q({0} میل),
						'other' => q({0} میل),
					},
					# Core Unit Identifier
					'mile' => {
						'name' => q(میل),
						'one' => q({0} میل),
						'other' => q({0} میل),
					},
					# Long Unit Identifier
					'length-mile-scandinavian' => {
						'1' => q(masculine),
						'name' => q(اسکینڈی نیویائی میل),
						'one' => q({0} اسکینڈی نیویائی میل),
						'other' => q({0} اسکینڈی نیویائی میل),
					},
					# Core Unit Identifier
					'mile-scandinavian' => {
						'1' => q(masculine),
						'name' => q(اسکینڈی نیویائی میل),
						'one' => q({0} اسکینڈی نیویائی میل),
						'other' => q({0} اسکینڈی نیویائی میل),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'name' => q(ملی میٹر),
						'one' => q({0} ملیمیٹر),
						'other' => q({0} ملیمیٹر),
					},
					# Core Unit Identifier
					'millimeter' => {
						'name' => q(ملی میٹر),
						'one' => q({0} ملیمیٹر),
						'other' => q({0} ملیمیٹر),
					},
					# Long Unit Identifier
					'length-nanometer' => {
						'name' => q(نینو میٹر),
						'one' => q({0} نینو میٹر),
						'other' => q({0} نینو میٹر),
					},
					# Core Unit Identifier
					'nanometer' => {
						'name' => q(نینو میٹر),
						'one' => q({0} نینو میٹر),
						'other' => q({0} نینو میٹر),
					},
					# Long Unit Identifier
					'length-nautical-mile' => {
						'name' => q(بحری میل),
						'one' => q({0} بحری میل),
						'other' => q({0} بحری میل),
					},
					# Core Unit Identifier
					'nautical-mile' => {
						'name' => q(بحری میل),
						'one' => q({0} بحری میل),
						'other' => q({0} بحری میل),
					},
					# Long Unit Identifier
					'length-parsec' => {
						'name' => q(پارسیک),
						'one' => q({0} پارسیک),
						'other' => q({0} پارسیک),
					},
					# Core Unit Identifier
					'parsec' => {
						'name' => q(پارسیک),
						'one' => q({0} پارسیک),
						'other' => q({0} پارسیک),
					},
					# Long Unit Identifier
					'length-picometer' => {
						'name' => q(پیکو میٹر),
						'one' => q({0} پیکو میٹر),
						'other' => q({0} پیکو میٹر),
					},
					# Core Unit Identifier
					'picometer' => {
						'name' => q(پیکو میٹر),
						'one' => q({0} پیکو میٹر),
						'other' => q({0} پیکو میٹر),
					},
					# Long Unit Identifier
					'length-point' => {
						'name' => q(پوائنٹس),
						'one' => q({0} پوائنٹ),
						'other' => q({0} پوائنٹس),
					},
					# Core Unit Identifier
					'point' => {
						'name' => q(پوائنٹس),
						'one' => q({0} پوائنٹ),
						'other' => q({0} پوائنٹس),
					},
					# Long Unit Identifier
					'length-solar-radius' => {
						'name' => q(شمسی رداس),
						'one' => q({0} شمسی رداس),
						'other' => q({0} شمسی رداس),
					},
					# Core Unit Identifier
					'solar-radius' => {
						'name' => q(شمسی رداس),
						'one' => q({0} شمسی رداس),
						'other' => q({0} شمسی رداس),
					},
					# Long Unit Identifier
					'length-yard' => {
						'name' => q(گز),
						'one' => q({0} یارڈ),
						'other' => q({0} یارڈ),
					},
					# Core Unit Identifier
					'yard' => {
						'name' => q(گز),
						'one' => q({0} یارڈ),
						'other' => q({0} یارڈ),
					},
					# Long Unit Identifier
					'light-candela' => {
						'1' => q(masculine),
						'name' => q(کنڈیلا),
						'one' => q({0} کنڈیلا),
						'other' => q({0} کنڈیلا),
					},
					# Core Unit Identifier
					'candela' => {
						'1' => q(masculine),
						'name' => q(کنڈیلا),
						'one' => q({0} کنڈیلا),
						'other' => q({0} کنڈیلا),
					},
					# Long Unit Identifier
					'light-lumen' => {
						'1' => q(feminine),
						'name' => q(لیومِن),
						'one' => q({0} لیومِن),
						'other' => q({0} لیومِن),
					},
					# Core Unit Identifier
					'lumen' => {
						'1' => q(feminine),
						'name' => q(لیومِن),
						'one' => q({0} لیومِن),
						'other' => q({0} لیومِن),
					},
					# Long Unit Identifier
					'light-lux' => {
						'1' => q(masculine),
						'name' => q(lux),
						'one' => q({0} lux),
						'other' => q({0} lux),
					},
					# Core Unit Identifier
					'lux' => {
						'1' => q(masculine),
						'name' => q(lux),
						'one' => q({0} lux),
						'other' => q({0} lux),
					},
					# Long Unit Identifier
					'light-solar-luminosity' => {
						'name' => q(شمسی چمک),
						'one' => q({0} شمسی چمک),
						'other' => q({0} شمسی چمک),
					},
					# Core Unit Identifier
					'solar-luminosity' => {
						'name' => q(شمسی چمک),
						'one' => q({0} شمسی چمک),
						'other' => q({0} شمسی چمک),
					},
					# Long Unit Identifier
					'mass-carat' => {
						'1' => q(masculine),
						'name' => q(قیراط),
						'one' => q({0} قیراط),
						'other' => q({0} قیراط),
					},
					# Core Unit Identifier
					'carat' => {
						'1' => q(masculine),
						'name' => q(قیراط),
						'one' => q({0} قیراط),
						'other' => q({0} قیراط),
					},
					# Long Unit Identifier
					'mass-dalton' => {
						'name' => q(ڈالٹنز),
						'one' => q({0} ڈالٹن),
						'other' => q({0} ڈالٹنز),
					},
					# Core Unit Identifier
					'dalton' => {
						'name' => q(ڈالٹنز),
						'one' => q({0} ڈالٹن),
						'other' => q({0} ڈالٹنز),
					},
					# Long Unit Identifier
					'mass-earth-mass' => {
						'name' => q(زمینی کمیتیں),
						'one' => q({0} زمینی کمیت),
						'other' => q({0} زمینی کمیتیں),
					},
					# Core Unit Identifier
					'earth-mass' => {
						'name' => q(زمینی کمیتیں),
						'one' => q({0} زمینی کمیت),
						'other' => q({0} زمینی کمیتیں),
					},
					# Long Unit Identifier
					'mass-grain' => {
						'name' => q(گرین),
						'one' => q({0} گرین),
						'other' => q({0} گرین),
					},
					# Core Unit Identifier
					'grain' => {
						'name' => q(گرین),
						'one' => q({0} گرین),
						'other' => q({0} گرین),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'1' => q(masculine),
						'name' => q(گرام),
						'one' => q({0} گرام),
						'other' => q({0} گرام),
						'per' => q({0} فی گرام),
					},
					# Core Unit Identifier
					'gram' => {
						'1' => q(masculine),
						'name' => q(گرام),
						'one' => q({0} گرام),
						'other' => q({0} گرام),
						'per' => q({0} فی گرام),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'1' => q(masculine),
						'name' => q(کلو گرام),
						'one' => q({0} کلو گرام),
						'other' => q({0} کلو گرام),
						'per' => q({0} فی کلو گرام),
					},
					# Core Unit Identifier
					'kilogram' => {
						'1' => q(masculine),
						'name' => q(کلو گرام),
						'one' => q({0} کلو گرام),
						'other' => q({0} کلو گرام),
						'per' => q({0} فی کلو گرام),
					},
					# Long Unit Identifier
					'mass-metric-ton' => {
						'1' => q(masculine),
						'name' => q(میٹرک ٹن),
						'one' => q({0} میٹرک ٹن),
						'other' => q({0} میٹرک ٹن),
					},
					# Core Unit Identifier
					'metric-ton' => {
						'1' => q(masculine),
						'name' => q(میٹرک ٹن),
						'one' => q({0} میٹرک ٹن),
						'other' => q({0} میٹرک ٹن),
					},
					# Long Unit Identifier
					'mass-microgram' => {
						'name' => q(مائکرو گرام),
						'one' => q({0} مائکرو گرام),
						'other' => q({0} مائکرو گرام),
					},
					# Core Unit Identifier
					'microgram' => {
						'name' => q(مائکرو گرام),
						'one' => q({0} مائکرو گرام),
						'other' => q({0} مائکرو گرام),
					},
					# Long Unit Identifier
					'mass-milligram' => {
						'name' => q(ملی گرام),
						'one' => q({0} ملی گرام),
						'other' => q({0} ملی گرام),
					},
					# Core Unit Identifier
					'milligram' => {
						'name' => q(ملی گرام),
						'one' => q({0} ملی گرام),
						'other' => q({0} ملی گرام),
					},
					# Long Unit Identifier
					'mass-ounce' => {
						'name' => q(اونس),
						'one' => q({0} اونس),
						'other' => q({0} اونس),
						'per' => q({0} فی اونس),
					},
					# Core Unit Identifier
					'ounce' => {
						'name' => q(اونس),
						'one' => q({0} اونس),
						'other' => q({0} اونس),
						'per' => q({0} فی اونس),
					},
					# Long Unit Identifier
					'mass-ounce-troy' => {
						'name' => q(ٹرائے اونس),
						'one' => q({0} ٹرائے اونس),
						'other' => q({0} ٹرائے اونس),
					},
					# Core Unit Identifier
					'ounce-troy' => {
						'name' => q(ٹرائے اونس),
						'one' => q({0} ٹرائے اونس),
						'other' => q({0} ٹرائے اونس),
					},
					# Long Unit Identifier
					'mass-pound' => {
						'name' => q(پونڈ),
						'one' => q({0} پونڈ),
						'other' => q({0} پونڈ),
						'per' => q({0} فی پونڈ),
					},
					# Core Unit Identifier
					'pound' => {
						'name' => q(پونڈ),
						'one' => q({0} پونڈ),
						'other' => q({0} پونڈ),
						'per' => q({0} فی پونڈ),
					},
					# Long Unit Identifier
					'mass-solar-mass' => {
						'name' => q(شمسی کمیتیں),
						'one' => q({0} شمسی کمیت),
						'other' => q({0} شمسی کمیتیں),
					},
					# Core Unit Identifier
					'solar-mass' => {
						'name' => q(شمسی کمیتیں),
						'one' => q({0} شمسی کمیت),
						'other' => q({0} شمسی کمیتیں),
					},
					# Long Unit Identifier
					'mass-stone' => {
						'name' => q(اسٹونز),
						'one' => q({0} اسٹون),
						'other' => q({0} اسٹونز),
					},
					# Core Unit Identifier
					'stone' => {
						'name' => q(اسٹونز),
						'one' => q({0} اسٹون),
						'other' => q({0} اسٹونز),
					},
					# Long Unit Identifier
					'mass-ton' => {
						'name' => q(ٹن),
						'one' => q({0} ٹن),
						'other' => q({0} ٹن),
					},
					# Core Unit Identifier
					'ton' => {
						'name' => q(ٹن),
						'one' => q({0} ٹن),
						'other' => q({0} ٹن),
					},
					# Long Unit Identifier
					'per' => {
						'1' => q({0} فی {1}),
					},
					# Core Unit Identifier
					'per' => {
						'1' => q({0} فی {1}),
					},
					# Long Unit Identifier
					'power-gigawatt' => {
						'name' => q(گیگا واٹ),
						'one' => q({0} گیگا واٹ),
						'other' => q({0} گیگا واٹ),
					},
					# Core Unit Identifier
					'gigawatt' => {
						'name' => q(گیگا واٹ),
						'one' => q({0} گیگا واٹ),
						'other' => q({0} گیگا واٹ),
					},
					# Long Unit Identifier
					'power-horsepower' => {
						'name' => q(ہارس پاور),
						'one' => q({0} ہارس پاور),
						'other' => q({0} ہارس پاور),
					},
					# Core Unit Identifier
					'horsepower' => {
						'name' => q(ہارس پاور),
						'one' => q({0} ہارس پاور),
						'other' => q({0} ہارس پاور),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'name' => q(کلو واٹ),
						'one' => q({0} کلو واٹ),
						'other' => q({0} کلو واٹ),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'name' => q(کلو واٹ),
						'one' => q({0} کلو واٹ),
						'other' => q({0} کلو واٹ),
					},
					# Long Unit Identifier
					'power-megawatt' => {
						'name' => q(میگا واٹ),
						'one' => q({0} میگا واٹ),
						'other' => q({0} میگا واٹ),
					},
					# Core Unit Identifier
					'megawatt' => {
						'name' => q(میگا واٹ),
						'one' => q({0} میگا واٹ),
						'other' => q({0} میگا واٹ),
					},
					# Long Unit Identifier
					'power-milliwatt' => {
						'name' => q(ملی واٹ),
						'one' => q({0} ملی واٹ),
						'other' => q({0} ملی واٹ),
					},
					# Core Unit Identifier
					'milliwatt' => {
						'name' => q(ملی واٹ),
						'one' => q({0} ملی واٹ),
						'other' => q({0} ملی واٹ),
					},
					# Long Unit Identifier
					'power-watt' => {
						'1' => q(feminine),
						'name' => q(واٹ),
						'one' => q({0} واٹ),
						'other' => q({0} واٹ),
					},
					# Core Unit Identifier
					'watt' => {
						'1' => q(feminine),
						'name' => q(واٹ),
						'one' => q({0} واٹ),
						'other' => q({0} واٹ),
					},
					# Long Unit Identifier
					'power2' => {
						'1' => q(مربع {0}),
						'one' => q(مربع {0}),
						'other' => q(مربع {0}),
					},
					# Core Unit Identifier
					'power2' => {
						'1' => q(مربع {0}),
						'one' => q(مربع {0}),
						'other' => q(مربع {0}),
					},
					# Long Unit Identifier
					'power3' => {
						'1' => q(کیوبک {0}),
						'one' => q(کیوبک {0}),
						'other' => q(کیوبک {0}),
					},
					# Core Unit Identifier
					'power3' => {
						'1' => q(کیوبک {0}),
						'one' => q(کیوبک {0}),
						'other' => q(کیوبک {0}),
					},
					# Long Unit Identifier
					'pressure-atmosphere' => {
						'1' => q(masculine),
						'name' => q(ماحول),
						'one' => q({0} ماحول),
						'other' => q({0} ماحول),
					},
					# Core Unit Identifier
					'atmosphere' => {
						'1' => q(masculine),
						'name' => q(ماحول),
						'one' => q({0} ماحول),
						'other' => q({0} ماحول),
					},
					# Long Unit Identifier
					'pressure-bar' => {
						'1' => q(feminine),
						'name' => q(بارز),
						'one' => q({0} بار),
						'other' => q({0} بارز),
					},
					# Core Unit Identifier
					'bar' => {
						'1' => q(feminine),
						'name' => q(بارز),
						'one' => q({0} بار),
						'other' => q({0} بارز),
					},
					# Long Unit Identifier
					'pressure-hectopascal' => {
						'name' => q(ہیکٹو پاسکل),
						'one' => q({0} ہیکٹو پاسکل),
						'other' => q({0} ہیکٹو پاسکل),
					},
					# Core Unit Identifier
					'hectopascal' => {
						'name' => q(ہیکٹو پاسکل),
						'one' => q({0} ہیکٹو پاسکل),
						'other' => q({0} ہیکٹو پاسکل),
					},
					# Long Unit Identifier
					'pressure-inch-ofhg' => {
						'name' => q(انچ مرکری),
						'one' => q({0} انچ مرکری),
						'other' => q({0} انچ مرکری),
					},
					# Core Unit Identifier
					'inch-ofhg' => {
						'name' => q(انچ مرکری),
						'one' => q({0} انچ مرکری),
						'other' => q({0} انچ مرکری),
					},
					# Long Unit Identifier
					'pressure-kilopascal' => {
						'name' => q(کلو پاسکلز),
						'one' => q({0} کلو پاسکل),
						'other' => q({0} کلو پاسکلز),
					},
					# Core Unit Identifier
					'kilopascal' => {
						'name' => q(کلو پاسکلز),
						'one' => q({0} کلو پاسکل),
						'other' => q({0} کلو پاسکلز),
					},
					# Long Unit Identifier
					'pressure-megapascal' => {
						'name' => q(میگا پاسکلز),
						'one' => q({0} میگا پاسکل),
						'other' => q({0} میگا پاسکلز),
					},
					# Core Unit Identifier
					'megapascal' => {
						'name' => q(میگا پاسکلز),
						'one' => q({0} میگا پاسکل),
						'other' => q({0} میگا پاسکلز),
					},
					# Long Unit Identifier
					'pressure-millibar' => {
						'name' => q(ملی بار),
						'one' => q({0} ملی بار),
						'other' => q({0} ملی بار),
					},
					# Core Unit Identifier
					'millibar' => {
						'name' => q(ملی بار),
						'one' => q({0} ملی بار),
						'other' => q({0} ملی بار),
					},
					# Long Unit Identifier
					'pressure-millimeter-ofhg' => {
						'name' => q(ملی میٹر مرکری),
						'one' => q({0} ملی میٹر مرکری),
						'other' => q({0} ملی میٹر مرکری),
					},
					# Core Unit Identifier
					'millimeter-ofhg' => {
						'name' => q(ملی میٹر مرکری),
						'one' => q({0} ملی میٹر مرکری),
						'other' => q({0} ملی میٹر مرکری),
					},
					# Long Unit Identifier
					'pressure-pascal' => {
						'1' => q(masculine),
						'name' => q(پاسکل),
						'one' => q({0} پاسکل),
						'other' => q({0} پاسکل),
					},
					# Core Unit Identifier
					'pascal' => {
						'1' => q(masculine),
						'name' => q(پاسکل),
						'one' => q({0} پاسکل),
						'other' => q({0} پاسکل),
					},
					# Long Unit Identifier
					'pressure-pound-force-per-square-inch' => {
						'name' => q(پاؤنڈز فی مربع انچ),
						'one' => q({0} پاؤنڈ فی مربع انچ),
						'other' => q({0} پاؤنڈز فی مربع انچ),
					},
					# Core Unit Identifier
					'pound-force-per-square-inch' => {
						'name' => q(پاؤنڈز فی مربع انچ),
						'one' => q({0} پاؤنڈ فی مربع انچ),
						'other' => q({0} پاؤنڈز فی مربع انچ),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'name' => q(کلومیٹر فی گھنٹہ),
						'one' => q({0} کلومیٹر فی گھنٹہ),
						'other' => q({0} کلومیٹر فی گھنٹہ),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'name' => q(کلومیٹر فی گھنٹہ),
						'one' => q({0} کلومیٹر فی گھنٹہ),
						'other' => q({0} کلومیٹر فی گھنٹہ),
					},
					# Long Unit Identifier
					'speed-knot' => {
						'name' => q(ناٹس),
						'one' => q({0} ناٹ),
						'other' => q({0} ناٹس),
					},
					# Core Unit Identifier
					'knot' => {
						'name' => q(ناٹس),
						'one' => q({0} ناٹ),
						'other' => q({0} ناٹس),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'name' => q(میٹر فی سیکنڈ),
						'one' => q({0} میٹر فی سیکنڈ),
						'other' => q({0} میٹر فی سیکنڈ),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'name' => q(میٹر فی سیکنڈ),
						'one' => q({0} میٹر فی سیکنڈ),
						'other' => q({0} میٹر فی سیکنڈ),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'name' => q(میل فی گھنٹہ),
						'one' => q({0} میل فی گھنٹہ),
						'other' => q({0} میل فی گھنٹہ),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'name' => q(میل فی گھنٹہ),
						'one' => q({0} میل فی گھنٹہ),
						'other' => q({0} میل فی گھنٹہ),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'1' => q(feminine),
						'name' => q(ڈگری سیلسیس),
						'one' => q({0} ڈگری سیلسیس),
						'other' => q({0} ڈگری سیلسیس),
					},
					# Core Unit Identifier
					'celsius' => {
						'1' => q(feminine),
						'name' => q(ڈگری سیلسیس),
						'one' => q({0} ڈگری سیلسیس),
						'other' => q({0} ڈگری سیلسیس),
					},
					# Long Unit Identifier
					'temperature-fahrenheit' => {
						'name' => q(ڈگری فارن ہائیٹ),
						'one' => q({0} ڈگری فارن ہائیٹ),
						'other' => q({0} ڈگری فارن ہائیٹ),
					},
					# Core Unit Identifier
					'fahrenheit' => {
						'name' => q(ڈگری فارن ہائیٹ),
						'one' => q({0} ڈگری فارن ہائیٹ),
						'other' => q({0} ڈگری فارن ہائیٹ),
					},
					# Long Unit Identifier
					'temperature-generic' => {
						'1' => q(masculine),
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Core Unit Identifier
					'generic' => {
						'1' => q(masculine),
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Long Unit Identifier
					'temperature-kelvin' => {
						'1' => q(masculine),
						'name' => q(کیلون),
						'one' => q({0} کیلون),
						'other' => q({0} کیلون),
					},
					# Core Unit Identifier
					'kelvin' => {
						'1' => q(masculine),
						'name' => q(کیلون),
						'one' => q({0} کیلون),
						'other' => q({0} کیلون),
					},
					# Long Unit Identifier
					'torque-newton-meter' => {
						'name' => q(نیوٹن میٹر),
						'one' => q({0} نیوٹن میٹر),
						'other' => q({0} نیوٹن میٹر),
					},
					# Core Unit Identifier
					'newton-meter' => {
						'name' => q(نیوٹن میٹر),
						'one' => q({0} نیوٹن میٹر),
						'other' => q({0} نیوٹن میٹر),
					},
					# Long Unit Identifier
					'torque-pound-force-foot' => {
						'name' => q(پاؤنڈ فٹ),
						'one' => q({0} پاؤنڈ فورس فوٹ),
						'other' => q({0} پاؤنڈ فٹ),
					},
					# Core Unit Identifier
					'pound-force-foot' => {
						'name' => q(پاؤنڈ فٹ),
						'one' => q({0} پاؤنڈ فورس فوٹ),
						'other' => q({0} پاؤنڈ فٹ),
					},
					# Long Unit Identifier
					'volume-acre-foot' => {
						'name' => q(ایکڑ فٹ),
						'one' => q({0} ایکڑ فٹ),
						'other' => q({0} ایکڑ فٹ),
					},
					# Core Unit Identifier
					'acre-foot' => {
						'name' => q(ایکڑ فٹ),
						'one' => q({0} ایکڑ فٹ),
						'other' => q({0} ایکڑ فٹ),
					},
					# Long Unit Identifier
					'volume-barrel' => {
						'name' => q(بیرلز),
						'one' => q({0} بیرل),
						'other' => q({0} بیرلز),
					},
					# Core Unit Identifier
					'barrel' => {
						'name' => q(بیرلز),
						'one' => q({0} بیرل),
						'other' => q({0} بیرلز),
					},
					# Long Unit Identifier
					'volume-bushel' => {
						'name' => q(بُشلز),
						'one' => q({0} بُشل),
						'other' => q({0} بُشلز),
					},
					# Core Unit Identifier
					'bushel' => {
						'name' => q(بُشلز),
						'one' => q({0} بُشل),
						'other' => q({0} بُشلز),
					},
					# Long Unit Identifier
					'volume-centiliter' => {
						'name' => q(سینٹی لیٹر),
						'one' => q({0} سینٹی لیٹر),
						'other' => q({0} سینٹی لیٹر),
					},
					# Core Unit Identifier
					'centiliter' => {
						'name' => q(سینٹی لیٹر),
						'one' => q({0} سینٹی لیٹر),
						'other' => q({0} سینٹی لیٹر),
					},
					# Long Unit Identifier
					'volume-cubic-centimeter' => {
						'name' => q(کیوبک سینٹی میٹر),
						'one' => q({0} کیوبک سینٹی میٹر),
						'other' => q({0} کیوبک سینٹی میٹر),
						'per' => q({0} فی کیوبک سینٹی میٹر),
					},
					# Core Unit Identifier
					'cubic-centimeter' => {
						'name' => q(کیوبک سینٹی میٹر),
						'one' => q({0} کیوبک سینٹی میٹر),
						'other' => q({0} کیوبک سینٹی میٹر),
						'per' => q({0} فی کیوبک سینٹی میٹر),
					},
					# Long Unit Identifier
					'volume-cubic-foot' => {
						'name' => q(کیوبک فیٹ),
						'one' => q({0} کیوبک فیٹ),
						'other' => q({0} کیوبک فٹ),
					},
					# Core Unit Identifier
					'cubic-foot' => {
						'name' => q(کیوبک فیٹ),
						'one' => q({0} کیوبک فیٹ),
						'other' => q({0} کیوبک فٹ),
					},
					# Long Unit Identifier
					'volume-cubic-inch' => {
						'name' => q(کیوبک انچ),
						'one' => q({0} کیوبک انچ),
						'other' => q({0} کیوبک انچ),
					},
					# Core Unit Identifier
					'cubic-inch' => {
						'name' => q(کیوبک انچ),
						'one' => q({0} کیوبک انچ),
						'other' => q({0} کیوبک انچ),
					},
					# Long Unit Identifier
					'volume-cubic-kilometer' => {
						'name' => q(کیوبک کلو میٹر),
						'one' => q({0} کیوبک کلو میٹر),
						'other' => q({0} کیوبک کلو میٹر),
					},
					# Core Unit Identifier
					'cubic-kilometer' => {
						'name' => q(کیوبک کلو میٹر),
						'one' => q({0} کیوبک کلو میٹر),
						'other' => q({0} کیوبک کلو میٹر),
					},
					# Long Unit Identifier
					'volume-cubic-meter' => {
						'name' => q(کیوبک میٹر),
						'one' => q({0} کیوبک میٹر),
						'other' => q({0} کیوبک میٹر),
						'per' => q({0} فی کیوبک میٹر),
					},
					# Core Unit Identifier
					'cubic-meter' => {
						'name' => q(کیوبک میٹر),
						'one' => q({0} کیوبک میٹر),
						'other' => q({0} کیوبک میٹر),
						'per' => q({0} فی کیوبک میٹر),
					},
					# Long Unit Identifier
					'volume-cubic-mile' => {
						'name' => q(کیوبک میل),
						'one' => q({0} کیوبک میل),
						'other' => q({0} کیوبک میل),
					},
					# Core Unit Identifier
					'cubic-mile' => {
						'name' => q(کیوبک میل),
						'one' => q({0} کیوبک میل),
						'other' => q({0} کیوبک میل),
					},
					# Long Unit Identifier
					'volume-cubic-yard' => {
						'name' => q(کیوبک گز),
						'one' => q({0} کیوبک گز),
						'other' => q({0} کیوبک گز),
					},
					# Core Unit Identifier
					'cubic-yard' => {
						'name' => q(کیوبک گز),
						'one' => q({0} کیوبک گز),
						'other' => q({0} کیوبک گز),
					},
					# Long Unit Identifier
					'volume-cup' => {
						'name' => q(کپ),
						'one' => q({0} کپ),
						'other' => q({0} کپ),
					},
					# Core Unit Identifier
					'cup' => {
						'name' => q(کپ),
						'one' => q({0} کپ),
						'other' => q({0} کپ),
					},
					# Long Unit Identifier
					'volume-cup-metric' => {
						'1' => q(masculine),
						'name' => q(میٹرک کپ),
						'one' => q({0} میٹرک کپ),
						'other' => q({0} میٹرک کپ),
					},
					# Core Unit Identifier
					'cup-metric' => {
						'1' => q(masculine),
						'name' => q(میٹرک کپ),
						'one' => q({0} میٹرک کپ),
						'other' => q({0} میٹرک کپ),
					},
					# Long Unit Identifier
					'volume-deciliter' => {
						'name' => q(ڈیسی لیٹر),
						'one' => q({0} ڈیسی لیٹر),
						'other' => q({0} ڈیسی لیٹر),
					},
					# Core Unit Identifier
					'deciliter' => {
						'name' => q(ڈیسی لیٹر),
						'one' => q({0} ڈیسی لیٹر),
						'other' => q({0} ڈیسی لیٹر),
					},
					# Long Unit Identifier
					'volume-dessert-spoon' => {
						'name' => q(ڈیزرٹ اسپون),
						'one' => q({0} ڈیزرٹ اسپون),
						'other' => q({0} ڈیزرٹ اسپون),
					},
					# Core Unit Identifier
					'dessert-spoon' => {
						'name' => q(ڈیزرٹ اسپون),
						'one' => q({0} ڈیزرٹ اسپون),
						'other' => q({0} ڈیزرٹ اسپون),
					},
					# Long Unit Identifier
					'volume-dessert-spoon-imperial' => {
						'name' => q(امپیریئل ڈیزرٹ اسپون),
						'one' => q({0} امپیریئل ڈیزرٹ اسپون),
						'other' => q({0} امپیریئل ڈیزرٹ اسپون),
					},
					# Core Unit Identifier
					'dessert-spoon-imperial' => {
						'name' => q(امپیریئل ڈیزرٹ اسپون),
						'one' => q({0} امپیریئل ڈیزرٹ اسپون),
						'other' => q({0} امپیریئل ڈیزرٹ اسپون),
					},
					# Long Unit Identifier
					'volume-dram' => {
						'name' => q(ڈرام),
						'one' => q({0} ڈرام),
						'other' => q({0} ڈرام),
					},
					# Core Unit Identifier
					'dram' => {
						'name' => q(ڈرام),
						'one' => q({0} ڈرام),
						'other' => q({0} ڈرام),
					},
					# Long Unit Identifier
					'volume-drop' => {
						'name' => q(قطرہ),
						'one' => q({0} قطرہ),
						'other' => q({0} قطرہ),
					},
					# Core Unit Identifier
					'drop' => {
						'name' => q(قطرہ),
						'one' => q({0} قطرہ),
						'other' => q({0} قطرہ),
					},
					# Long Unit Identifier
					'volume-fluid-ounce' => {
						'name' => q(فلوئڈ اونس),
						'one' => q({0} فلوئڈ اونس),
						'other' => q({0} فلوئڈ اونس),
					},
					# Core Unit Identifier
					'fluid-ounce' => {
						'name' => q(فلوئڈ اونس),
						'one' => q({0} فلوئڈ اونس),
						'other' => q({0} فلوئڈ اونس),
					},
					# Long Unit Identifier
					'volume-fluid-ounce-imperial' => {
						'name' => q(امپیریل فلوئڈ اونس),
						'one' => q({0} امپیریئل فلوئڈ اونس),
						'other' => q({0} امپیریئل فلوئڈ اونس),
					},
					# Core Unit Identifier
					'fluid-ounce-imperial' => {
						'name' => q(امپیریل فلوئڈ اونس),
						'one' => q({0} امپیریئل فلوئڈ اونس),
						'other' => q({0} امپیریئل فلوئڈ اونس),
					},
					# Long Unit Identifier
					'volume-gallon' => {
						'name' => q(گیلن),
						'one' => q({0} گیلن),
						'other' => q({0} گیلن),
						'per' => q({0} فی گیلن),
					},
					# Core Unit Identifier
					'gallon' => {
						'name' => q(گیلن),
						'one' => q({0} گیلن),
						'other' => q({0} گیلن),
						'per' => q({0} فی گیلن),
					},
					# Long Unit Identifier
					'volume-gallon-imperial' => {
						'name' => q(امپیریل گیلن),
						'one' => q({0} امپیریل گیلن),
						'other' => q({0} امپیریل گیلن),
						'per' => q({0} فی امپیریل گیلن),
					},
					# Core Unit Identifier
					'gallon-imperial' => {
						'name' => q(امپیریل گیلن),
						'one' => q({0} امپیریل گیلن),
						'other' => q({0} امپیریل گیلن),
						'per' => q({0} فی امپیریل گیلن),
					},
					# Long Unit Identifier
					'volume-hectoliter' => {
						'name' => q(ہیکٹو لیٹر),
						'one' => q({0} ہیکٹو لیٹر),
						'other' => q({0} ہیکٹو لیٹر),
					},
					# Core Unit Identifier
					'hectoliter' => {
						'name' => q(ہیکٹو لیٹر),
						'one' => q({0} ہیکٹو لیٹر),
						'other' => q({0} ہیکٹو لیٹر),
					},
					# Long Unit Identifier
					'volume-jigger' => {
						'name' => q(جگر),
						'one' => q({0} جگر),
						'other' => q({0} جگر),
					},
					# Core Unit Identifier
					'jigger' => {
						'name' => q(جگر),
						'one' => q({0} جگر),
						'other' => q({0} جگر),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'1' => q(masculine),
						'name' => q(لیٹر),
						'one' => q({0} لیٹر),
						'other' => q({0} لیٹر),
						'per' => q({0} فی لیٹر),
					},
					# Core Unit Identifier
					'liter' => {
						'1' => q(masculine),
						'name' => q(لیٹر),
						'one' => q({0} لیٹر),
						'other' => q({0} لیٹر),
						'per' => q({0} فی لیٹر),
					},
					# Long Unit Identifier
					'volume-megaliter' => {
						'name' => q(میگا لیٹر),
						'one' => q({0} میگا لیٹر),
						'other' => q({0} میگا لیٹر),
					},
					# Core Unit Identifier
					'megaliter' => {
						'name' => q(میگا لیٹر),
						'one' => q({0} میگا لیٹر),
						'other' => q({0} میگا لیٹر),
					},
					# Long Unit Identifier
					'volume-milliliter' => {
						'name' => q(ملی لیٹر),
						'one' => q({0} ملی لیٹر),
						'other' => q({0} ملی لیٹر),
					},
					# Core Unit Identifier
					'milliliter' => {
						'name' => q(ملی لیٹر),
						'one' => q({0} ملی لیٹر),
						'other' => q({0} ملی لیٹر),
					},
					# Long Unit Identifier
					'volume-pinch' => {
						'name' => q(چٹکی),
						'one' => q({0} چٹکی),
						'other' => q({0} چٹکی),
					},
					# Core Unit Identifier
					'pinch' => {
						'name' => q(چٹکی),
						'one' => q({0} چٹکی),
						'other' => q({0} چٹکی),
					},
					# Long Unit Identifier
					'volume-pint' => {
						'name' => q(پائنٹ),
						'one' => q({0} پائنٹ),
						'other' => q({0} پائنٹ),
					},
					# Core Unit Identifier
					'pint' => {
						'name' => q(پائنٹ),
						'one' => q({0} پائنٹ),
						'other' => q({0} پائنٹ),
					},
					# Long Unit Identifier
					'volume-pint-metric' => {
						'1' => q(masculine),
						'name' => q(میٹرک پائنٹ),
						'one' => q({0} میٹرک پائنٹ),
						'other' => q({0} میٹرک پائنٹ),
					},
					# Core Unit Identifier
					'pint-metric' => {
						'1' => q(masculine),
						'name' => q(میٹرک پائنٹ),
						'one' => q({0} میٹرک پائنٹ),
						'other' => q({0} میٹرک پائنٹ),
					},
					# Long Unit Identifier
					'volume-quart' => {
						'name' => q(کوارٹ),
						'one' => q({0} کوارٹ),
						'other' => q({0} کوارٹ),
					},
					# Core Unit Identifier
					'quart' => {
						'name' => q(کوارٹ),
						'one' => q({0} کوارٹ),
						'other' => q({0} کوارٹ),
					},
					# Long Unit Identifier
					'volume-quart-imperial' => {
						'name' => q(امپیریئل کوارٹ),
						'one' => q({0} امپیریئل کوارٹ),
						'other' => q({0} امپیریئل کوارٹ),
					},
					# Core Unit Identifier
					'quart-imperial' => {
						'name' => q(امپیریئل کوارٹ),
						'one' => q({0} امپیریئل کوارٹ),
						'other' => q({0} امپیریئل کوارٹ),
					},
					# Long Unit Identifier
					'volume-tablespoon' => {
						'name' => q(ٹیبل سپون),
						'one' => q({0} ٹیبل سپون),
						'other' => q({0} ٹیبل سپون),
					},
					# Core Unit Identifier
					'tablespoon' => {
						'name' => q(ٹیبل سپون),
						'one' => q({0} ٹیبل سپون),
						'other' => q({0} ٹیبل سپون),
					},
					# Long Unit Identifier
					'volume-teaspoon' => {
						'name' => q(ٹی سپون),
						'one' => q({0} ٹی سپون),
						'other' => q({0} ٹی سپون),
					},
					# Core Unit Identifier
					'teaspoon' => {
						'name' => q(ٹی سپون),
						'one' => q({0} ٹی سپون),
						'other' => q({0} ٹی سپون),
					},
				},
				'narrow' => {
					# Long Unit Identifier
					'' => {
						'name' => q(ڈائریکشن),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(ڈائریکشن),
					},
					# Long Unit Identifier
					'1024p1' => {
						'1' => q(Ki{0}),
					},
					# Core Unit Identifier
					'1024p1' => {
						'1' => q(Ki{0}),
					},
					# Long Unit Identifier
					'1024p2' => {
						'1' => q(Mi{0}),
					},
					# Core Unit Identifier
					'1024p2' => {
						'1' => q(Mi{0}),
					},
					# Long Unit Identifier
					'1024p3' => {
						'1' => q(Gi{0}),
					},
					# Core Unit Identifier
					'1024p3' => {
						'1' => q(Gi{0}),
					},
					# Long Unit Identifier
					'1024p4' => {
						'1' => q(Ti{0}),
					},
					# Core Unit Identifier
					'1024p4' => {
						'1' => q(Ti{0}),
					},
					# Long Unit Identifier
					'1024p5' => {
						'1' => q(Pi{0}),
					},
					# Core Unit Identifier
					'1024p5' => {
						'1' => q(Pi{0}),
					},
					# Long Unit Identifier
					'1024p6' => {
						'1' => q(Ei{0}),
					},
					# Core Unit Identifier
					'1024p6' => {
						'1' => q(Ei{0}),
					},
					# Long Unit Identifier
					'1024p7' => {
						'1' => q(Zi{0}),
					},
					# Core Unit Identifier
					'1024p7' => {
						'1' => q(Zi{0}),
					},
					# Long Unit Identifier
					'1024p8' => {
						'1' => q(Yi{0}),
					},
					# Core Unit Identifier
					'1024p8' => {
						'1' => q(Yi{0}),
					},
					# Long Unit Identifier
					'10p-1' => {
						'1' => q(d{0}),
					},
					# Core Unit Identifier
					'1' => {
						'1' => q(d{0}),
					},
					# Long Unit Identifier
					'10p-12' => {
						'1' => q(p{0}),
					},
					# Core Unit Identifier
					'12' => {
						'1' => q(p{0}),
					},
					# Long Unit Identifier
					'10p-15' => {
						'1' => q(فیمٹو{0}),
					},
					# Core Unit Identifier
					'15' => {
						'1' => q(فیمٹو{0}),
					},
					# Long Unit Identifier
					'10p-18' => {
						'1' => q(اٹو{0}),
					},
					# Core Unit Identifier
					'18' => {
						'1' => q(اٹو{0}),
					},
					# Long Unit Identifier
					'10p-2' => {
						'1' => q(c{0}),
					},
					# Core Unit Identifier
					'2' => {
						'1' => q(c{0}),
					},
					# Long Unit Identifier
					'10p-21' => {
						'1' => q(زپٹو{0}),
					},
					# Core Unit Identifier
					'21' => {
						'1' => q(زپٹو{0}),
					},
					# Long Unit Identifier
					'10p-24' => {
						'1' => q(یوکٹو{0}),
					},
					# Core Unit Identifier
					'24' => {
						'1' => q(یوکٹو{0}),
					},
					# Long Unit Identifier
					'10p-3' => {
						'1' => q(m{0}),
					},
					# Core Unit Identifier
					'3' => {
						'1' => q(m{0}),
					},
					# Long Unit Identifier
					'10p-9' => {
						'1' => q(n{0}),
					},
					# Core Unit Identifier
					'9' => {
						'1' => q(n{0}),
					},
					# Long Unit Identifier
					'10p1' => {
						'1' => q(ڈیکا{0}),
					},
					# Core Unit Identifier
					'10p1' => {
						'1' => q(ڈیکا{0}),
					},
					# Long Unit Identifier
					'10p12' => {
						'1' => q(T{0}),
					},
					# Core Unit Identifier
					'10p12' => {
						'1' => q(T{0}),
					},
					# Long Unit Identifier
					'10p15' => {
						'1' => q(P{0}),
					},
					# Core Unit Identifier
					'10p15' => {
						'1' => q(P{0}),
					},
					# Long Unit Identifier
					'10p18' => {
						'1' => q(اکسا{0}),
					},
					# Core Unit Identifier
					'10p18' => {
						'1' => q(اکسا{0}),
					},
					# Long Unit Identifier
					'10p2' => {
						'1' => q(h{0}),
					},
					# Core Unit Identifier
					'10p2' => {
						'1' => q(h{0}),
					},
					# Long Unit Identifier
					'10p21' => {
						'1' => q(زیٹا{0}),
					},
					# Core Unit Identifier
					'10p21' => {
						'1' => q(زیٹا{0}),
					},
					# Long Unit Identifier
					'10p24' => {
						'1' => q(یوٹا{0}),
					},
					# Core Unit Identifier
					'10p24' => {
						'1' => q(یوٹا{0}),
					},
					# Long Unit Identifier
					'10p3' => {
						'1' => q(k{0}),
					},
					# Core Unit Identifier
					'10p3' => {
						'1' => q(k{0}),
					},
					# Long Unit Identifier
					'10p6' => {
						'1' => q(M{0}),
					},
					# Core Unit Identifier
					'10p6' => {
						'1' => q(M{0}),
					},
					# Long Unit Identifier
					'10p9' => {
						'1' => q(G{0}),
					},
					# Core Unit Identifier
					'10p9' => {
						'1' => q(G{0}),
					},
					# Long Unit Identifier
					'acceleration-g-force' => {
						'one' => q({0}g),
						'other' => q({0}g),
					},
					# Core Unit Identifier
					'g-force' => {
						'one' => q({0}g),
						'other' => q({0}g),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'one' => q({0}′),
						'other' => q({0}′),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'one' => q({0}′),
						'other' => q({0}′),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					# Core Unit Identifier
					'arc-second' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'one' => q({0} ڈگری),
						'other' => q({0} ڈگری),
					},
					# Core Unit Identifier
					'degree' => {
						'one' => q({0} ڈگری),
						'other' => q({0} ڈگری),
					},
					# Long Unit Identifier
					'angle-radian' => {
						'name' => q(ریڈین),
					},
					# Core Unit Identifier
					'radian' => {
						'name' => q(ریڈین),
					},
					# Long Unit Identifier
					'area-acre' => {
						'one' => q({0} ایکڑ),
						'other' => q({0} ایکڑ),
					},
					# Core Unit Identifier
					'acre' => {
						'one' => q({0} ایکڑ),
						'other' => q({0} ایکڑ),
					},
					# Long Unit Identifier
					'area-dunam' => {
						'name' => q(دُنام),
					},
					# Core Unit Identifier
					'dunam' => {
						'name' => q(دُنام),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'one' => q({0} ہیکٹر),
						'other' => q({0} ہیکٹر),
					},
					# Core Unit Identifier
					'hectare' => {
						'one' => q({0} ہیکٹر),
						'other' => q({0} ہیکٹر),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'name' => q(ft²),
						'one' => q({0}ft²),
						'other' => q({0}ft²),
					},
					# Core Unit Identifier
					'square-foot' => {
						'name' => q(ft²),
						'one' => q({0}ft²),
						'other' => q({0}ft²),
					},
					# Long Unit Identifier
					'area-square-inch' => {
						'name' => q(in²),
					},
					# Core Unit Identifier
					'square-inch' => {
						'name' => q(in²),
					},
					# Long Unit Identifier
					'area-square-kilometer' => {
						'one' => q({0} km²),
						'other' => q({0} km²),
					},
					# Core Unit Identifier
					'square-kilometer' => {
						'one' => q({0} km²),
						'other' => q({0} km²),
					},
					# Long Unit Identifier
					'area-square-meter' => {
						'one' => q({0} m²),
						'other' => q({0} m²),
					},
					# Core Unit Identifier
					'square-meter' => {
						'one' => q({0} m²),
						'other' => q({0} m²),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'name' => q(mi²),
						'one' => q({0}mi²),
						'other' => q({0}mi²),
					},
					# Core Unit Identifier
					'square-mile' => {
						'name' => q(mi²),
						'one' => q({0}mi²),
						'other' => q({0}mi²),
					},
					# Long Unit Identifier
					'area-square-yard' => {
						'name' => q(yd²),
					},
					# Core Unit Identifier
					'square-yard' => {
						'name' => q(yd²),
					},
					# Long Unit Identifier
					'concentr-item' => {
						'one' => q({0} آئٹم),
						'other' => q({0} آئٹمز),
					},
					# Core Unit Identifier
					'item' => {
						'one' => q({0} آئٹم),
						'other' => q({0} آئٹمز),
					},
					# Long Unit Identifier
					'concentr-percent' => {
						'name' => q(%),
						'one' => q({0}%),
						'other' => q({0}%),
					},
					# Core Unit Identifier
					'percent' => {
						'name' => q(%),
						'one' => q({0}%),
						'other' => q({0}%),
					},
					# Long Unit Identifier
					'consumption-liter-per-100-kilometer' => {
						'name' => q(لیٹر/100 کلو میٹر),
						'one' => q({0}L/100km),
						'other' => q({0}L/100km),
					},
					# Core Unit Identifier
					'liter-per-100-kilometer' => {
						'name' => q(لیٹر/100 کلو میٹر),
						'one' => q({0}L/100km),
						'other' => q({0}L/100km),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon-imperial' => {
						'name' => q(mpg UK),
						'one' => q({0}m/gUK),
						'other' => q({0}m/gUK),
					},
					# Core Unit Identifier
					'mile-per-gallon-imperial' => {
						'name' => q(mpg UK),
						'one' => q({0}m/gUK),
						'other' => q({0}m/gUK),
					},
					# Long Unit Identifier
					'coordinate' => {
						'east' => q({0}E),
						'north' => q({0}N),
						'south' => q({0}S),
						'west' => q({0}W),
					},
					# Core Unit Identifier
					'coordinate' => {
						'east' => q({0}E),
						'north' => q({0}N),
						'south' => q({0}S),
						'west' => q({0}W),
					},
					# Long Unit Identifier
					'digital-byte' => {
						'one' => q({0}B),
						'other' => q({0}B),
					},
					# Core Unit Identifier
					'byte' => {
						'one' => q({0}B),
						'other' => q({0}B),
					},
					# Long Unit Identifier
					'duration-day' => {
						'name' => q(دن),
						'one' => q({0} دن),
						'other' => q({0} دن),
						'per' => q({0} فی دن),
					},
					# Core Unit Identifier
					'day' => {
						'name' => q(دن),
						'one' => q({0} دن),
						'other' => q({0} دن),
						'per' => q({0} فی دن),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'name' => q(گھنٹہ),
						'one' => q({0} گھنٹہ),
						'other' => q({0} گھنٹے),
						'per' => q({0} فی گھنٹہ),
					},
					# Core Unit Identifier
					'hour' => {
						'name' => q(گھنٹہ),
						'one' => q({0} گھنٹہ),
						'other' => q({0} گھنٹے),
						'per' => q({0} فی گھنٹہ),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'name' => q(ملی سیکنڈ),
						'one' => q({0} ms),
						'other' => q({0} ms),
					},
					# Core Unit Identifier
					'millisecond' => {
						'name' => q(ملی سیکنڈ),
						'one' => q({0} ms),
						'other' => q({0} ms),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'name' => q(منٹ),
						'one' => q({0} منٹ),
						'other' => q({0} منٹ),
						'per' => q({0} فی منٹ),
					},
					# Core Unit Identifier
					'minute' => {
						'name' => q(منٹ),
						'one' => q({0} منٹ),
						'other' => q({0} منٹ),
						'per' => q({0} فی منٹ),
					},
					# Long Unit Identifier
					'duration-month' => {
						'name' => q(مہینہ),
						'one' => q({0} مہینہ),
						'other' => q({0} مہینے),
						'per' => q({0}/مہینہ),
					},
					# Core Unit Identifier
					'month' => {
						'name' => q(مہینہ),
						'one' => q({0} مہینہ),
						'other' => q({0} مہینے),
						'per' => q({0}/مہینہ),
					},
					# Long Unit Identifier
					'duration-second' => {
						'name' => q(سیکنڈ),
						'one' => q({0} سیکنڈ),
						'other' => q({0} سیکنڈ),
						'per' => q({0} فی سیکنڈ),
					},
					# Core Unit Identifier
					'second' => {
						'name' => q(سیکنڈ),
						'one' => q({0} سیکنڈ),
						'other' => q({0} سیکنڈ),
						'per' => q({0} فی سیکنڈ),
					},
					# Long Unit Identifier
					'duration-week' => {
						'name' => q(ہفتہ),
						'one' => q({0} ہفتہ),
						'other' => q({0} ہفتے),
						'per' => q({0}/ہفتہ),
					},
					# Core Unit Identifier
					'week' => {
						'name' => q(ہفتہ),
						'one' => q({0} ہفتہ),
						'other' => q({0} ہفتے),
						'per' => q({0}/ہفتہ),
					},
					# Long Unit Identifier
					'duration-year' => {
						'name' => q(سال),
						'one' => q({0} سال),
						'other' => q({0} سال),
						'per' => q({0}/سال),
					},
					# Core Unit Identifier
					'year' => {
						'name' => q(سال),
						'one' => q({0} سال),
						'other' => q({0} سال),
						'per' => q({0}/سال),
					},
					# Long Unit Identifier
					'electric-ampere' => {
						'name' => q(amp),
					},
					# Core Unit Identifier
					'ampere' => {
						'name' => q(amp),
					},
					# Long Unit Identifier
					'energy-joule' => {
						'name' => q(جول),
					},
					# Core Unit Identifier
					'joule' => {
						'name' => q(جول),
					},
					# Long Unit Identifier
					'energy-kilowatt-hour' => {
						'name' => q(kWh),
					},
					# Core Unit Identifier
					'kilowatt-hour' => {
						'name' => q(kWh),
					},
					# Long Unit Identifier
					'force-pound-force' => {
						'name' => q(lbf),
					},
					# Core Unit Identifier
					'pound-force' => {
						'name' => q(lbf),
					},
					# Long Unit Identifier
					'graphics-dot-per-centimeter' => {
						'name' => q(dpcm),
						'one' => q({0} dpcm),
						'other' => q({0} dpcm),
					},
					# Core Unit Identifier
					'dot-per-centimeter' => {
						'name' => q(dpcm),
						'one' => q({0} dpcm),
						'other' => q({0} dpcm),
					},
					# Long Unit Identifier
					'graphics-dot-per-inch' => {
						'name' => q(dpi),
						'one' => q({0} dpi),
						'other' => q({0} dpi),
					},
					# Core Unit Identifier
					'dot-per-inch' => {
						'name' => q(dpi),
						'one' => q({0} dpi),
						'other' => q({0} dpi),
					},
					# Long Unit Identifier
					'graphics-megapixel' => {
						'name' => q(MP),
					},
					# Core Unit Identifier
					'megapixel' => {
						'name' => q(MP),
					},
					# Long Unit Identifier
					'graphics-pixel' => {
						'name' => q(px),
					},
					# Core Unit Identifier
					'pixel' => {
						'name' => q(px),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'name' => q(سینٹی میٹر),
						'one' => q({0}cm),
						'other' => q({0}cm),
						'per' => q({0} فی سینٹی میٹر),
					},
					# Core Unit Identifier
					'centimeter' => {
						'name' => q(سینٹی میٹر),
						'one' => q({0}cm),
						'other' => q({0}cm),
						'per' => q({0} فی سینٹی میٹر),
					},
					# Long Unit Identifier
					'length-decimeter' => {
						'name' => q(ڈیسی میٹر),
						'one' => q({0} dm),
						'other' => q({0} dm),
					},
					# Core Unit Identifier
					'decimeter' => {
						'name' => q(ڈیسی میٹر),
						'one' => q({0} dm),
						'other' => q({0} dm),
					},
					# Long Unit Identifier
					'length-fathom' => {
						'name' => q(فیدم),
					},
					# Core Unit Identifier
					'fathom' => {
						'name' => q(فیدم),
					},
					# Long Unit Identifier
					'length-foot' => {
						'name' => q(فیٹ),
						'one' => q({0}′),
						'other' => q({0}′),
						'per' => q({0} فی فیٹ),
					},
					# Core Unit Identifier
					'foot' => {
						'name' => q(فیٹ),
						'one' => q({0}′),
						'other' => q({0}′),
						'per' => q({0} فی فیٹ),
					},
					# Long Unit Identifier
					'length-furlong' => {
						'name' => q(فرلانگ),
					},
					# Core Unit Identifier
					'furlong' => {
						'name' => q(فرلانگ),
					},
					# Long Unit Identifier
					'length-inch' => {
						'name' => q(انچ),
						'one' => q({0} انچ),
						'other' => q({0} انچ),
						'per' => q({0} فی انچ),
					},
					# Core Unit Identifier
					'inch' => {
						'name' => q(انچ),
						'one' => q({0} انچ),
						'other' => q({0} انچ),
						'per' => q({0} فی انچ),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'name' => q(کلو میٹر),
						'one' => q({0} کلو میٹر),
						'other' => q({0} کلو میٹر),
						'per' => q({0} فی کلو میٹر),
					},
					# Core Unit Identifier
					'kilometer' => {
						'name' => q(کلو میٹر),
						'one' => q({0} کلو میٹر),
						'other' => q({0} کلو میٹر),
						'per' => q({0} فی کلو میٹر),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'name' => q(ly),
						'one' => q({0}ly),
						'other' => q({0}ly),
					},
					# Core Unit Identifier
					'light-year' => {
						'name' => q(ly),
						'one' => q({0}ly),
						'other' => q({0}ly),
					},
					# Long Unit Identifier
					'length-meter' => {
						'name' => q(میٹر),
						'one' => q({0} میٹر),
						'other' => q({0} میٹر),
						'per' => q({0} فی میٹر),
					},
					# Core Unit Identifier
					'meter' => {
						'name' => q(میٹر),
						'one' => q({0} میٹر),
						'other' => q({0} میٹر),
						'per' => q({0} فی میٹر),
					},
					# Long Unit Identifier
					'length-mile' => {
						'name' => q(میل),
						'one' => q({0} میل),
						'other' => q({0} میل),
					},
					# Core Unit Identifier
					'mile' => {
						'name' => q(میل),
						'one' => q({0} میل),
						'other' => q({0} میل),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'name' => q(ملی میٹر),
						'one' => q({0} ملیمیٹر),
						'other' => q({0} ملیمیٹر),
					},
					# Core Unit Identifier
					'millimeter' => {
						'name' => q(ملی میٹر),
						'one' => q({0} ملیمیٹر),
						'other' => q({0} ملیمیٹر),
					},
					# Long Unit Identifier
					'length-picometer' => {
						'name' => q(pm),
						'one' => q({0}pm),
						'other' => q({0}pm),
					},
					# Core Unit Identifier
					'picometer' => {
						'name' => q(pm),
						'one' => q({0}pm),
						'other' => q({0}pm),
					},
					# Long Unit Identifier
					'length-solar-radius' => {
						'name' => q(R☉),
					},
					# Core Unit Identifier
					'solar-radius' => {
						'name' => q(R☉),
					},
					# Long Unit Identifier
					'length-yard' => {
						'name' => q(گز),
						'one' => q({0} یارڈ),
						'other' => q({0} یارڈ),
					},
					# Core Unit Identifier
					'yard' => {
						'name' => q(گز),
						'one' => q({0} یارڈ),
						'other' => q({0} یارڈ),
					},
					# Long Unit Identifier
					'mass-dalton' => {
						'name' => q(ڈالٹن),
					},
					# Core Unit Identifier
					'dalton' => {
						'name' => q(ڈالٹن),
					},
					# Long Unit Identifier
					'mass-earth-mass' => {
						'name' => q(زمینی کمیت),
					},
					# Core Unit Identifier
					'earth-mass' => {
						'name' => q(زمینی کمیت),
					},
					# Long Unit Identifier
					'mass-grain' => {
						'one' => q({0}gr),
						'other' => q({0}gr),
					},
					# Core Unit Identifier
					'grain' => {
						'one' => q({0}gr),
						'other' => q({0}gr),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'name' => q(گرام),
						'one' => q({0} گرام),
						'other' => q({0} گرام),
						'per' => q({0} فی گرام),
					},
					# Core Unit Identifier
					'gram' => {
						'name' => q(گرام),
						'one' => q({0} گرام),
						'other' => q({0} گرام),
						'per' => q({0} فی گرام),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'name' => q(kg),
						'one' => q({0}kg),
						'other' => q({0}kg),
						'per' => q({0} فی کلو گرام),
					},
					# Core Unit Identifier
					'kilogram' => {
						'name' => q(kg),
						'one' => q({0}kg),
						'other' => q({0}kg),
						'per' => q({0} فی کلو گرام),
					},
					# Long Unit Identifier
					'mass-ounce' => {
						'name' => q(oz),
						'one' => q({0} ونس),
						'other' => q({0} ونس),
						'per' => q({0}/oz),
					},
					# Core Unit Identifier
					'ounce' => {
						'name' => q(oz),
						'one' => q({0} ونس),
						'other' => q({0} ونس),
						'per' => q({0}/oz),
					},
					# Long Unit Identifier
					'mass-pound' => {
						'name' => q(lb),
						'one' => q({0} پونڈ),
						'other' => q({0} پونڈ),
					},
					# Core Unit Identifier
					'pound' => {
						'name' => q(lb),
						'one' => q({0} پونڈ),
						'other' => q({0} پونڈ),
					},
					# Long Unit Identifier
					'mass-solar-mass' => {
						'name' => q(شمسی کمیت),
					},
					# Core Unit Identifier
					'solar-mass' => {
						'name' => q(شمسی کمیت),
					},
					# Long Unit Identifier
					'mass-stone' => {
						'name' => q(st),
						'one' => q({0} st),
						'other' => q({0} st),
					},
					# Core Unit Identifier
					'stone' => {
						'name' => q(st),
						'one' => q({0} st),
						'other' => q({0} st),
					},
					# Long Unit Identifier
					'per' => {
						'1' => q({0}/{1}),
					},
					# Core Unit Identifier
					'per' => {
						'1' => q({0}/{1}),
					},
					# Long Unit Identifier
					'power-horsepower' => {
						'one' => q({0}hp),
						'other' => q({0}hp),
					},
					# Core Unit Identifier
					'horsepower' => {
						'one' => q({0}hp),
						'other' => q({0}hp),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'one' => q({0}kW),
						'other' => q({0}kW),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'one' => q({0}kW),
						'other' => q({0}kW),
					},
					# Long Unit Identifier
					'power-watt' => {
						'one' => q({0} واٹ),
						'other' => q({0} واٹ),
					},
					# Core Unit Identifier
					'watt' => {
						'one' => q({0} واٹ),
						'other' => q({0} واٹ),
					},
					# Long Unit Identifier
					'pressure-hectopascal' => {
						'name' => q(hPa),
						'one' => q({0}hPa),
						'other' => q({0}hPa),
					},
					# Core Unit Identifier
					'hectopascal' => {
						'name' => q(hPa),
						'one' => q({0}hPa),
						'other' => q({0}hPa),
					},
					# Long Unit Identifier
					'pressure-inch-ofhg' => {
						'name' => q(″ Hg),
						'one' => q({0} انچ مرکری),
						'other' => q({0} انچ مرکری),
					},
					# Core Unit Identifier
					'inch-ofhg' => {
						'name' => q(″ Hg),
						'one' => q({0} انچ مرکری),
						'other' => q({0} انچ مرکری),
					},
					# Long Unit Identifier
					'pressure-millibar' => {
						'name' => q(mbar),
						'one' => q({0}mb),
						'other' => q({0}mb),
					},
					# Core Unit Identifier
					'millibar' => {
						'name' => q(mbar),
						'one' => q({0}mb),
						'other' => q({0}mb),
					},
					# Long Unit Identifier
					'pressure-millimeter-ofhg' => {
						'name' => q(mm Hg),
						'one' => q({0} mm Hg),
						'other' => q({0} mm Hg),
					},
					# Core Unit Identifier
					'millimeter-ofhg' => {
						'name' => q(mm Hg),
						'one' => q({0} mm Hg),
						'other' => q({0} mm Hg),
					},
					# Long Unit Identifier
					'pressure-pound-force-per-square-inch' => {
						'name' => q(psi),
						'one' => q({0} psi),
						'other' => q({0} psi),
					},
					# Core Unit Identifier
					'pound-force-per-square-inch' => {
						'name' => q(psi),
						'one' => q({0} psi),
						'other' => q({0} psi),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'name' => q(km/hr),
						'one' => q({0}kph),
						'other' => q({0}kph),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'name' => q(km/hr),
						'one' => q({0}kph),
						'other' => q({0}kph),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'name' => q(میٹر فی سیکنڈ),
						'one' => q({0}m/s),
						'other' => q({0}m/s),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'name' => q(میٹر فی سیکنڈ),
						'one' => q({0}m/s),
						'other' => q({0}m/s),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'name' => q(میل فی گھنٹہ),
						'one' => q({0}mph),
						'other' => q({0}mph),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'name' => q(میل فی گھنٹہ),
						'one' => q({0}mph),
						'other' => q({0}mph),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'name' => q(⁰C),
						'one' => q({0}‎°),
						'other' => q({0}‎°),
					},
					# Core Unit Identifier
					'celsius' => {
						'name' => q(⁰C),
						'one' => q({0}‎°),
						'other' => q({0}‎°),
					},
					# Long Unit Identifier
					'temperature-fahrenheit' => {
						'name' => q(°F),
						'one' => q({0}‎°F),
						'other' => q({0}‎°F),
					},
					# Core Unit Identifier
					'fahrenheit' => {
						'name' => q(°F),
						'one' => q({0}‎°F),
						'other' => q({0}‎°F),
					},
					# Long Unit Identifier
					'temperature-generic' => {
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Core Unit Identifier
					'generic' => {
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Long Unit Identifier
					'temperature-kelvin' => {
						'name' => q(K),
						'one' => q({0} K),
						'other' => q({0} K),
					},
					# Core Unit Identifier
					'kelvin' => {
						'name' => q(K),
						'one' => q({0} K),
						'other' => q({0} K),
					},
					# Long Unit Identifier
					'volume-bushel' => {
						'name' => q(بُشل),
					},
					# Core Unit Identifier
					'bushel' => {
						'name' => q(بُشل),
					},
					# Long Unit Identifier
					'volume-centiliter' => {
						'name' => q(cL),
					},
					# Core Unit Identifier
					'centiliter' => {
						'name' => q(cL),
					},
					# Long Unit Identifier
					'volume-cubic-centimeter' => {
						'name' => q(cm³),
					},
					# Core Unit Identifier
					'cubic-centimeter' => {
						'name' => q(cm³),
					},
					# Long Unit Identifier
					'volume-cubic-foot' => {
						'name' => q(ft³),
					},
					# Core Unit Identifier
					'cubic-foot' => {
						'name' => q(ft³),
					},
					# Long Unit Identifier
					'volume-cubic-inch' => {
						'name' => q(in³),
					},
					# Core Unit Identifier
					'cubic-inch' => {
						'name' => q(in³),
					},
					# Long Unit Identifier
					'volume-cubic-kilometer' => {
						'name' => q(km³),
						'one' => q({0}km³),
						'other' => q({0}km³),
					},
					# Core Unit Identifier
					'cubic-kilometer' => {
						'name' => q(km³),
						'one' => q({0}km³),
						'other' => q({0}km³),
					},
					# Long Unit Identifier
					'volume-cubic-mile' => {
						'name' => q(mi³),
						'one' => q({0}mi³),
						'other' => q({0}mi³),
					},
					# Core Unit Identifier
					'cubic-mile' => {
						'name' => q(mi³),
						'one' => q({0}mi³),
						'other' => q({0}mi³),
					},
					# Long Unit Identifier
					'volume-cubic-yard' => {
						'name' => q(yd³),
					},
					# Core Unit Identifier
					'cubic-yard' => {
						'name' => q(yd³),
					},
					# Long Unit Identifier
					'volume-deciliter' => {
						'name' => q(dL),
					},
					# Core Unit Identifier
					'deciliter' => {
						'name' => q(dL),
					},
					# Long Unit Identifier
					'volume-dessert-spoon' => {
						'name' => q(dsp),
						'one' => q({0}dsp),
						'other' => q({0}dsp),
					},
					# Core Unit Identifier
					'dessert-spoon' => {
						'name' => q(dsp),
						'one' => q({0}dsp),
						'other' => q({0}dsp),
					},
					# Long Unit Identifier
					'volume-dessert-spoon-imperial' => {
						'name' => q(dsp Imp),
						'one' => q({0}dsp-Imp),
						'other' => q({0}dsp-Imp),
					},
					# Core Unit Identifier
					'dessert-spoon-imperial' => {
						'name' => q(dsp Imp),
						'one' => q({0}dsp-Imp),
						'other' => q({0}dsp-Imp),
					},
					# Long Unit Identifier
					'volume-dram' => {
						'name' => q(fl.dr.),
						'one' => q({0}fl.dr.),
						'other' => q({0}fl.dr.),
					},
					# Core Unit Identifier
					'dram' => {
						'name' => q(fl.dr.),
						'one' => q({0}fl.dr.),
						'other' => q({0}fl.dr.),
					},
					# Long Unit Identifier
					'volume-fluid-ounce-imperial' => {
						'one' => q({0}fl oz Im),
						'other' => q({0}fl oz Im),
					},
					# Core Unit Identifier
					'fluid-ounce-imperial' => {
						'one' => q({0}fl oz Im),
						'other' => q({0}fl oz Im),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'name' => q(لیٹر),
						'one' => q({0} لیٹر),
						'other' => q({0} لیٹر),
					},
					# Core Unit Identifier
					'liter' => {
						'name' => q(لیٹر),
						'one' => q({0} لیٹر),
						'other' => q({0} لیٹر),
					},
					# Long Unit Identifier
					'volume-pint-metric' => {
						'name' => q(pt),
					},
					# Core Unit Identifier
					'pint-metric' => {
						'name' => q(pt),
					},
					# Long Unit Identifier
					'volume-quart' => {
						'name' => q(qt),
					},
					# Core Unit Identifier
					'quart' => {
						'name' => q(qt),
					},
				},
				'short' => {
					# Long Unit Identifier
					'' => {
						'name' => q(ڈائریکشن),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(ڈائریکشن),
					},
					# Long Unit Identifier
					'1024p1' => {
						'1' => q(Ki{0}),
					},
					# Core Unit Identifier
					'1024p1' => {
						'1' => q(Ki{0}),
					},
					# Long Unit Identifier
					'1024p2' => {
						'1' => q(Mi{0}),
					},
					# Core Unit Identifier
					'1024p2' => {
						'1' => q(Mi{0}),
					},
					# Long Unit Identifier
					'1024p3' => {
						'1' => q(Gi{0}),
					},
					# Core Unit Identifier
					'1024p3' => {
						'1' => q(Gi{0}),
					},
					# Long Unit Identifier
					'1024p4' => {
						'1' => q(Ti{0}),
					},
					# Core Unit Identifier
					'1024p4' => {
						'1' => q(Ti{0}),
					},
					# Long Unit Identifier
					'1024p5' => {
						'1' => q(Pi{0}),
					},
					# Core Unit Identifier
					'1024p5' => {
						'1' => q(Pi{0}),
					},
					# Long Unit Identifier
					'1024p6' => {
						'1' => q(Ei{0}),
					},
					# Core Unit Identifier
					'1024p6' => {
						'1' => q(Ei{0}),
					},
					# Long Unit Identifier
					'1024p7' => {
						'1' => q(Zi{0}),
					},
					# Core Unit Identifier
					'1024p7' => {
						'1' => q(Zi{0}),
					},
					# Long Unit Identifier
					'1024p8' => {
						'1' => q(Yi{0}),
					},
					# Core Unit Identifier
					'1024p8' => {
						'1' => q(Yi{0}),
					},
					# Long Unit Identifier
					'10p-1' => {
						'1' => q(d{0}),
					},
					# Core Unit Identifier
					'1' => {
						'1' => q(d{0}),
					},
					# Long Unit Identifier
					'10p-12' => {
						'1' => q(p{0}),
					},
					# Core Unit Identifier
					'12' => {
						'1' => q(p{0}),
					},
					# Long Unit Identifier
					'10p-15' => {
						'1' => q(فے۔{0}),
					},
					# Core Unit Identifier
					'15' => {
						'1' => q(فے۔{0}),
					},
					# Long Unit Identifier
					'10p-18' => {
						'1' => q(ا۔{0}),
					},
					# Core Unit Identifier
					'18' => {
						'1' => q(ا۔{0}),
					},
					# Long Unit Identifier
					'10p-2' => {
						'1' => q(c{0}),
					},
					# Core Unit Identifier
					'2' => {
						'1' => q(c{0}),
					},
					# Long Unit Identifier
					'10p-21' => {
						'1' => q(ز۔{0}),
					},
					# Core Unit Identifier
					'21' => {
						'1' => q(ز۔{0}),
					},
					# Long Unit Identifier
					'10p-24' => {
						'1' => q(یوکٹو{0}),
					},
					# Core Unit Identifier
					'24' => {
						'1' => q(یوکٹو{0}),
					},
					# Long Unit Identifier
					'10p-3' => {
						'1' => q(m{0}),
					},
					# Core Unit Identifier
					'3' => {
						'1' => q(m{0}),
					},
					# Long Unit Identifier
					'10p-9' => {
						'1' => q(n{0}),
					},
					# Core Unit Identifier
					'9' => {
						'1' => q(n{0}),
					},
					# Long Unit Identifier
					'10p1' => {
						'1' => q(ڈے۔{0}),
					},
					# Core Unit Identifier
					'10p1' => {
						'1' => q(ڈے۔{0}),
					},
					# Long Unit Identifier
					'10p12' => {
						'1' => q(T{0}),
					},
					# Core Unit Identifier
					'10p12' => {
						'1' => q(T{0}),
					},
					# Long Unit Identifier
					'10p15' => {
						'1' => q(P{0}),
					},
					# Core Unit Identifier
					'10p15' => {
						'1' => q(P{0}),
					},
					# Long Unit Identifier
					'10p18' => {
						'1' => q(ای۔{0}),
					},
					# Core Unit Identifier
					'10p18' => {
						'1' => q(ای۔{0}),
					},
					# Long Unit Identifier
					'10p2' => {
						'1' => q(h{0}),
					},
					# Core Unit Identifier
					'10p2' => {
						'1' => q(h{0}),
					},
					# Long Unit Identifier
					'10p21' => {
						'1' => q(زے{0}),
					},
					# Core Unit Identifier
					'10p21' => {
						'1' => q(زے{0}),
					},
					# Long Unit Identifier
					'10p24' => {
						'1' => q(یو{0}),
					},
					# Core Unit Identifier
					'10p24' => {
						'1' => q(یو{0}),
					},
					# Long Unit Identifier
					'10p3' => {
						'1' => q(k{0}),
					},
					# Core Unit Identifier
					'10p3' => {
						'1' => q(k{0}),
					},
					# Long Unit Identifier
					'10p6' => {
						'1' => q(M{0}),
					},
					# Core Unit Identifier
					'10p6' => {
						'1' => q(M{0}),
					},
					# Long Unit Identifier
					'10p9' => {
						'1' => q(G{0}),
					},
					# Core Unit Identifier
					'10p9' => {
						'1' => q(G{0}),
					},
					# Long Unit Identifier
					'acceleration-g-force' => {
						'name' => q(جی-فورس),
						'one' => q({0} G),
						'other' => q({0} G),
					},
					# Core Unit Identifier
					'g-force' => {
						'name' => q(جی-فورس),
						'one' => q({0} G),
						'other' => q({0} G),
					},
					# Long Unit Identifier
					'acceleration-meter-per-square-second' => {
						'name' => q(m/s²),
						'one' => q({0} m/s²),
						'other' => q({0} m/s²),
					},
					# Core Unit Identifier
					'meter-per-square-second' => {
						'name' => q(m/s²),
						'one' => q({0} m/s²),
						'other' => q({0} m/s²),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'name' => q(آرک منٹ),
						'one' => q({0} آرک منٹ),
						'other' => q({0} آرک منٹ),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'name' => q(آرک منٹ),
						'one' => q({0} آرک منٹ),
						'other' => q({0} آرک منٹ),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'name' => q(آرک سیکنڈ),
						'one' => q({0} آرک سیکنڈ),
						'other' => q({0} آرک سیکنڈ),
					},
					# Core Unit Identifier
					'arc-second' => {
						'name' => q(آرک سیکنڈ),
						'one' => q({0} آرک سیکنڈ),
						'other' => q({0} آرک سیکنڈ),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'name' => q(ڈگری),
						'one' => q({0} ڈگری),
						'other' => q({0} ڈگری),
					},
					# Core Unit Identifier
					'degree' => {
						'name' => q(ڈگری),
						'one' => q({0} ڈگری),
						'other' => q({0} ڈگری),
					},
					# Long Unit Identifier
					'angle-radian' => {
						'name' => q(ریڈینس),
						'one' => q({0} rad),
						'other' => q({0} rad),
					},
					# Core Unit Identifier
					'radian' => {
						'name' => q(ریڈینس),
						'one' => q({0} rad),
						'other' => q({0} rad),
					},
					# Long Unit Identifier
					'angle-revolution' => {
						'name' => q(rev),
						'one' => q({0} rev),
						'other' => q({0} rev),
					},
					# Core Unit Identifier
					'revolution' => {
						'name' => q(rev),
						'one' => q({0} rev),
						'other' => q({0} rev),
					},
					# Long Unit Identifier
					'area-acre' => {
						'name' => q(ایکڑ),
						'one' => q({0} ایکڑ),
						'other' => q({0} ایکڑ),
					},
					# Core Unit Identifier
					'acre' => {
						'name' => q(ایکڑ),
						'one' => q({0} ایکڑ),
						'other' => q({0} ایکڑ),
					},
					# Long Unit Identifier
					'area-dunam' => {
						'name' => q(دُنامز),
						'one' => q({0} دُنام),
						'other' => q({0} دُنام),
					},
					# Core Unit Identifier
					'dunam' => {
						'name' => q(دُنامز),
						'one' => q({0} دُنام),
						'other' => q({0} دُنام),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'name' => q(ہیکٹر),
						'one' => q({0} ہیکٹر),
						'other' => q({0} ہیکٹر),
					},
					# Core Unit Identifier
					'hectare' => {
						'name' => q(ہیکٹر),
						'one' => q({0} ہیکٹر),
						'other' => q({0} ہیکٹر),
					},
					# Long Unit Identifier
					'area-square-centimeter' => {
						'name' => q(cm²),
						'one' => q({0} cm²),
						'other' => q({0} cm²),
						'per' => q({0}/cm²),
					},
					# Core Unit Identifier
					'square-centimeter' => {
						'name' => q(cm²),
						'one' => q({0} cm²),
						'other' => q({0} cm²),
						'per' => q({0}/cm²),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'name' => q(مربع فٹ),
						'one' => q({0} sq ft),
						'other' => q({0} sq ft),
					},
					# Core Unit Identifier
					'square-foot' => {
						'name' => q(مربع فٹ),
						'one' => q({0} sq ft),
						'other' => q({0} sq ft),
					},
					# Long Unit Identifier
					'area-square-inch' => {
						'name' => q(مربع انچ),
						'one' => q({0} in²),
						'other' => q({0} in²),
						'per' => q({0}/in²),
					},
					# Core Unit Identifier
					'square-inch' => {
						'name' => q(مربع انچ),
						'one' => q({0} in²),
						'other' => q({0} in²),
						'per' => q({0}/in²),
					},
					# Long Unit Identifier
					'area-square-kilometer' => {
						'name' => q(km²),
						'one' => q({0} km²),
						'other' => q({0} km²),
						'per' => q({0}/km²),
					},
					# Core Unit Identifier
					'square-kilometer' => {
						'name' => q(km²),
						'one' => q({0} km²),
						'other' => q({0} km²),
						'per' => q({0}/km²),
					},
					# Long Unit Identifier
					'area-square-meter' => {
						'name' => q(مربع میٹر),
						'one' => q({0} m²),
						'other' => q({0} m²),
						'per' => q({0}/m²),
					},
					# Core Unit Identifier
					'square-meter' => {
						'name' => q(مربع میٹر),
						'one' => q({0} m²),
						'other' => q({0} m²),
						'per' => q({0}/m²),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'name' => q(مربع میل),
						'one' => q({0} sq mi),
						'other' => q({0} sq mi),
						'per' => q({0}/mi²),
					},
					# Core Unit Identifier
					'square-mile' => {
						'name' => q(مربع میل),
						'one' => q({0} sq mi),
						'other' => q({0} sq mi),
						'per' => q({0}/mi²),
					},
					# Long Unit Identifier
					'area-square-yard' => {
						'name' => q(مربع گز),
						'one' => q({0} yd²),
						'other' => q({0} yd²),
					},
					# Core Unit Identifier
					'square-yard' => {
						'name' => q(مربع گز),
						'one' => q({0} yd²),
						'other' => q({0} yd²),
					},
					# Long Unit Identifier
					'concentr-item' => {
						'name' => q(آئٹم),
						'one' => q({0} آئٹم),
						'other' => q({0} آئٹمز),
					},
					# Core Unit Identifier
					'item' => {
						'name' => q(آئٹم),
						'one' => q({0} آئٹم),
						'other' => q({0} آئٹمز),
					},
					# Long Unit Identifier
					'concentr-karat' => {
						'name' => q(قیراط),
						'one' => q({0} kt),
						'other' => q({0} kt),
					},
					# Core Unit Identifier
					'karat' => {
						'name' => q(قیراط),
						'one' => q({0} kt),
						'other' => q({0} kt),
					},
					# Long Unit Identifier
					'concentr-milligram-ofglucose-per-deciliter' => {
						'name' => q(mg/dL),
						'one' => q({0} mg/dL),
						'other' => q({0} mg/dL),
					},
					# Core Unit Identifier
					'milligram-ofglucose-per-deciliter' => {
						'name' => q(mg/dL),
						'one' => q({0} mg/dL),
						'other' => q({0} mg/dL),
					},
					# Long Unit Identifier
					'concentr-millimole-per-liter' => {
						'name' => q(ملی مول/لیٹر),
						'one' => q({0} mmol/L),
						'other' => q({0} mmol/L),
					},
					# Core Unit Identifier
					'millimole-per-liter' => {
						'name' => q(ملی مول/لیٹر),
						'one' => q({0} mmol/L),
						'other' => q({0} mmol/L),
					},
					# Long Unit Identifier
					'concentr-mole' => {
						'name' => q(مول),
						'one' => q({0} مول),
						'other' => q({0} مول),
					},
					# Core Unit Identifier
					'mole' => {
						'name' => q(مول),
						'one' => q({0} مول),
						'other' => q({0} مول),
					},
					# Long Unit Identifier
					'concentr-percent' => {
						'name' => q(فیصد),
						'one' => q({0}%),
						'other' => q({0}%),
					},
					# Core Unit Identifier
					'percent' => {
						'name' => q(فیصد),
						'one' => q({0}%),
						'other' => q({0}%),
					},
					# Long Unit Identifier
					'concentr-permille' => {
						'name' => q(فی ہزار),
						'one' => q({0}‰),
						'other' => q({0}‰),
					},
					# Core Unit Identifier
					'permille' => {
						'name' => q(فی ہزار),
						'one' => q({0}‰),
						'other' => q({0}‰),
					},
					# Long Unit Identifier
					'concentr-permillion' => {
						'name' => q(حصے/ملین),
						'one' => q({0} ppm),
						'other' => q({0} ppm),
					},
					# Core Unit Identifier
					'permillion' => {
						'name' => q(حصے/ملین),
						'one' => q({0} ppm),
						'other' => q({0} ppm),
					},
					# Long Unit Identifier
					'concentr-permyriad' => {
						'name' => q(پرمرئیڈ),
					},
					# Core Unit Identifier
					'permyriad' => {
						'name' => q(پرمرئیڈ),
					},
					# Long Unit Identifier
					'consumption-liter-per-100-kilometer' => {
						'name' => q(لیٹر/100 کلو میٹر),
						'one' => q({0} L/100km),
						'other' => q({0} L/100km),
					},
					# Core Unit Identifier
					'liter-per-100-kilometer' => {
						'name' => q(لیٹر/100 کلو میٹر),
						'one' => q({0} L/100km),
						'other' => q({0} L/100km),
					},
					# Long Unit Identifier
					'consumption-liter-per-kilometer' => {
						'name' => q(L/km),
						'one' => q({0} L/km),
						'other' => q({0} L/km),
					},
					# Core Unit Identifier
					'liter-per-kilometer' => {
						'name' => q(L/km),
						'one' => q({0} L/km),
						'other' => q({0} L/km),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon' => {
						'name' => q(mpg),
						'one' => q({0} mpg),
						'other' => q({0} mpg),
					},
					# Core Unit Identifier
					'mile-per-gallon' => {
						'name' => q(mpg),
						'one' => q({0} mpg),
						'other' => q({0} mpg),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon-imperial' => {
						'name' => q(miles/gal Imp.),
						'one' => q({0} mpg Imp.),
						'other' => q({0} mpg Imp.),
					},
					# Core Unit Identifier
					'mile-per-gallon-imperial' => {
						'name' => q(miles/gal Imp.),
						'one' => q({0} mpg Imp.),
						'other' => q({0} mpg Imp.),
					},
					# Long Unit Identifier
					'coordinate' => {
						'east' => q({0}E),
						'north' => q({0}N),
						'south' => q({0}S),
						'west' => q({0}W),
					},
					# Core Unit Identifier
					'coordinate' => {
						'east' => q({0}E),
						'north' => q({0}N),
						'south' => q({0}S),
						'west' => q({0}W),
					},
					# Long Unit Identifier
					'digital-bit' => {
						'name' => q(bit),
						'one' => q({0} bit),
						'other' => q({0} bit),
					},
					# Core Unit Identifier
					'bit' => {
						'name' => q(bit),
						'one' => q({0} bit),
						'other' => q({0} bit),
					},
					# Long Unit Identifier
					'digital-byte' => {
						'name' => q(بائٹ),
						'one' => q({0} byte),
						'other' => q({0} byte),
					},
					# Core Unit Identifier
					'byte' => {
						'name' => q(بائٹ),
						'one' => q({0} byte),
						'other' => q({0} byte),
					},
					# Long Unit Identifier
					'digital-gigabit' => {
						'name' => q(Gbit),
						'one' => q({0} Gb),
						'other' => q({0} Gb),
					},
					# Core Unit Identifier
					'gigabit' => {
						'name' => q(Gbit),
						'one' => q({0} Gb),
						'other' => q({0} Gb),
					},
					# Long Unit Identifier
					'digital-gigabyte' => {
						'name' => q(GB),
						'one' => q({0} GB),
						'other' => q({0} GB),
					},
					# Core Unit Identifier
					'gigabyte' => {
						'name' => q(GB),
						'one' => q({0} GB),
						'other' => q({0} GB),
					},
					# Long Unit Identifier
					'digital-kilobit' => {
						'name' => q(kbit),
						'one' => q({0} kb),
						'other' => q({0} kb),
					},
					# Core Unit Identifier
					'kilobit' => {
						'name' => q(kbit),
						'one' => q({0} kb),
						'other' => q({0} kb),
					},
					# Long Unit Identifier
					'digital-kilobyte' => {
						'name' => q(kByte),
						'one' => q({0} kB),
						'other' => q({0} kB),
					},
					# Core Unit Identifier
					'kilobyte' => {
						'name' => q(kByte),
						'one' => q({0} kB),
						'other' => q({0} kB),
					},
					# Long Unit Identifier
					'digital-megabit' => {
						'name' => q(Mb),
						'one' => q({0} Mb),
						'other' => q({0} Mb),
					},
					# Core Unit Identifier
					'megabit' => {
						'name' => q(Mb),
						'one' => q({0} Mb),
						'other' => q({0} Mb),
					},
					# Long Unit Identifier
					'digital-megabyte' => {
						'name' => q(MByte),
						'one' => q({0} MB),
						'other' => q({0} MB),
					},
					# Core Unit Identifier
					'megabyte' => {
						'name' => q(MByte),
						'one' => q({0} MB),
						'other' => q({0} MB),
					},
					# Long Unit Identifier
					'digital-petabyte' => {
						'name' => q(پی بائٹ),
						'one' => q({0} پی بی),
						'other' => q({0} پی بی),
					},
					# Core Unit Identifier
					'petabyte' => {
						'name' => q(پی بائٹ),
						'one' => q({0} پی بی),
						'other' => q({0} پی بی),
					},
					# Long Unit Identifier
					'digital-terabit' => {
						'name' => q(Tbit),
						'one' => q({0} Tb),
						'other' => q({0} Tb),
					},
					# Core Unit Identifier
					'terabit' => {
						'name' => q(Tbit),
						'one' => q({0} Tb),
						'other' => q({0} Tb),
					},
					# Long Unit Identifier
					'digital-terabyte' => {
						'name' => q(TB),
						'one' => q({0} TB),
						'other' => q({0} TB),
					},
					# Core Unit Identifier
					'terabyte' => {
						'name' => q(TB),
						'one' => q({0} TB),
						'other' => q({0} TB),
					},
					# Long Unit Identifier
					'duration-century' => {
						'name' => q(صدی),
						'one' => q({0} صدی),
						'other' => q({0} صدیاں),
					},
					# Core Unit Identifier
					'century' => {
						'name' => q(صدی),
						'one' => q({0} صدی),
						'other' => q({0} صدیاں),
					},
					# Long Unit Identifier
					'duration-day' => {
						'name' => q(دن),
						'one' => q({0} دن),
						'other' => q({0} دن),
						'per' => q({0} فی دن),
					},
					# Core Unit Identifier
					'day' => {
						'name' => q(دن),
						'one' => q({0} دن),
						'other' => q({0} دن),
						'per' => q({0} فی دن),
					},
					# Long Unit Identifier
					'duration-decade' => {
						'name' => q(دہائی),
						'one' => q({0} دہائی),
						'other' => q({0} دہائی),
					},
					# Core Unit Identifier
					'decade' => {
						'name' => q(دہائی),
						'one' => q({0} دہائی),
						'other' => q({0} دہائی),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'name' => q(گھنٹے),
						'one' => q({0} گھنٹہ),
						'other' => q({0} گھنٹے),
						'per' => q({0} فی گھنٹہ),
					},
					# Core Unit Identifier
					'hour' => {
						'name' => q(گھنٹے),
						'one' => q({0} گھنٹہ),
						'other' => q({0} گھنٹے),
						'per' => q({0} فی گھنٹہ),
					},
					# Long Unit Identifier
					'duration-microsecond' => {
						'name' => q(مائیکرو سیکنڈ),
						'one' => q({0} مائیکرو سیکنڈ),
						'other' => q({0} مائیکرو سیکنڈ),
					},
					# Core Unit Identifier
					'microsecond' => {
						'name' => q(مائیکرو سیکنڈ),
						'one' => q({0} مائیکرو سیکنڈ),
						'other' => q({0} مائیکرو سیکنڈ),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'name' => q(ملی سیکنڈ),
						'one' => q({0} ملی سیکنڈ),
						'other' => q({0} ملی سیکنڈ),
					},
					# Core Unit Identifier
					'millisecond' => {
						'name' => q(ملی سیکنڈ),
						'one' => q({0} ملی سیکنڈ),
						'other' => q({0} ملی سیکنڈ),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'name' => q(منٹ),
						'one' => q({0} منٹ),
						'other' => q({0} منٹ),
						'per' => q({0} فی منٹ),
					},
					# Core Unit Identifier
					'minute' => {
						'name' => q(منٹ),
						'one' => q({0} منٹ),
						'other' => q({0} منٹ),
						'per' => q({0} فی منٹ),
					},
					# Long Unit Identifier
					'duration-month' => {
						'name' => q(مہینے),
						'one' => q({0} مہینہ),
						'other' => q({0} مہینے),
						'per' => q({0}/m),
					},
					# Core Unit Identifier
					'month' => {
						'name' => q(مہینے),
						'one' => q({0} مہینہ),
						'other' => q({0} مہینے),
						'per' => q({0}/m),
					},
					# Long Unit Identifier
					'duration-nanosecond' => {
						'name' => q(نینو سیکنڈز),
						'one' => q({0} نینو سیکنڈ),
						'other' => q({0} نینو سیکنڈ),
					},
					# Core Unit Identifier
					'nanosecond' => {
						'name' => q(نینو سیکنڈز),
						'one' => q({0} نینو سیکنڈ),
						'other' => q({0} نینو سیکنڈ),
					},
					# Long Unit Identifier
					'duration-second' => {
						'name' => q(سیکنڈ),
						'one' => q({0} سیکنڈ),
						'other' => q({0} سیکنڈ),
						'per' => q({0} فی سیکنڈ),
					},
					# Core Unit Identifier
					'second' => {
						'name' => q(سیکنڈ),
						'one' => q({0} سیکنڈ),
						'other' => q({0} سیکنڈ),
						'per' => q({0} فی سیکنڈ),
					},
					# Long Unit Identifier
					'duration-week' => {
						'name' => q(ہفتے),
						'one' => q({0} ہفتہ),
						'other' => q({0} ہفتے),
						'per' => q({0} فی ہفتہ),
					},
					# Core Unit Identifier
					'week' => {
						'name' => q(ہفتے),
						'one' => q({0} ہفتہ),
						'other' => q({0} ہفتے),
						'per' => q({0} فی ہفتہ),
					},
					# Long Unit Identifier
					'duration-year' => {
						'name' => q(سال),
						'one' => q({0} سال),
						'other' => q({0} سال),
						'per' => q({0}/y),
					},
					# Core Unit Identifier
					'year' => {
						'name' => q(سال),
						'one' => q({0} سال),
						'other' => q({0} سال),
						'per' => q({0}/y),
					},
					# Long Unit Identifier
					'electric-ampere' => {
						'name' => q(amps),
						'one' => q({0} A),
						'other' => q({0} A),
					},
					# Core Unit Identifier
					'ampere' => {
						'name' => q(amps),
						'one' => q({0} A),
						'other' => q({0} A),
					},
					# Long Unit Identifier
					'electric-milliampere' => {
						'name' => q(milliamps),
						'one' => q({0} mA),
						'other' => q({0} mA),
					},
					# Core Unit Identifier
					'milliampere' => {
						'name' => q(milliamps),
						'one' => q({0} mA),
						'other' => q({0} mA),
					},
					# Long Unit Identifier
					'electric-ohm' => {
						'name' => q(اوہم),
						'one' => q({0} Ω),
						'other' => q({0} Ω),
					},
					# Core Unit Identifier
					'ohm' => {
						'name' => q(اوہم),
						'one' => q({0} Ω),
						'other' => q({0} Ω),
					},
					# Long Unit Identifier
					'electric-volt' => {
						'name' => q(وولٹ),
						'one' => q({0} V),
						'other' => q({0} V),
					},
					# Core Unit Identifier
					'volt' => {
						'name' => q(وولٹ),
						'one' => q({0} V),
						'other' => q({0} V),
					},
					# Long Unit Identifier
					'energy-british-thermal-unit' => {
						'name' => q(BTU),
					},
					# Core Unit Identifier
					'british-thermal-unit' => {
						'name' => q(BTU),
					},
					# Long Unit Identifier
					'energy-calorie' => {
						'name' => q(cal),
						'one' => q({0} cal),
						'other' => q({0} cal),
					},
					# Core Unit Identifier
					'calorie' => {
						'name' => q(cal),
						'one' => q({0} cal),
						'other' => q({0} cal),
					},
					# Long Unit Identifier
					'energy-electronvolt' => {
						'name' => q(الیکٹرون وولٹ),
					},
					# Core Unit Identifier
					'electronvolt' => {
						'name' => q(الیکٹرون وولٹ),
					},
					# Long Unit Identifier
					'energy-foodcalorie' => {
						'name' => q(Cal),
						'one' => q({0} Cal),
						'other' => q({0} Cal),
					},
					# Core Unit Identifier
					'foodcalorie' => {
						'name' => q(Cal),
						'one' => q({0} Cal),
						'other' => q({0} Cal),
					},
					# Long Unit Identifier
					'energy-joule' => {
						'name' => q(joule),
						'one' => q({0} J),
						'other' => q({0} J),
					},
					# Core Unit Identifier
					'joule' => {
						'name' => q(joule),
						'one' => q({0} J),
						'other' => q({0} J),
					},
					# Long Unit Identifier
					'energy-kilocalorie' => {
						'name' => q(kcal),
						'one' => q({0} kcal),
						'other' => q({0} kcal),
					},
					# Core Unit Identifier
					'kilocalorie' => {
						'name' => q(kcal),
						'one' => q({0} kcal),
						'other' => q({0} kcal),
					},
					# Long Unit Identifier
					'energy-kilojoule' => {
						'name' => q(kJ),
						'one' => q({0} kJ),
						'other' => q({0} kJ),
					},
					# Core Unit Identifier
					'kilojoule' => {
						'name' => q(kJ),
						'one' => q({0} kJ),
						'other' => q({0} kJ),
					},
					# Long Unit Identifier
					'energy-kilowatt-hour' => {
						'name' => q(kW-hour),
						'one' => q({0} kWh),
						'other' => q({0} kWh),
					},
					# Core Unit Identifier
					'kilowatt-hour' => {
						'name' => q(kW-hour),
						'one' => q({0} kWh),
						'other' => q({0} kWh),
					},
					# Long Unit Identifier
					'energy-therm-us' => {
						'name' => q(امریکی تھرم),
						'one' => q({0} امریکی تھرم),
						'other' => q({0} امریکی تھرمز),
					},
					# Core Unit Identifier
					'therm-us' => {
						'name' => q(امریکی تھرم),
						'one' => q({0} امریکی تھرم),
						'other' => q({0} امریکی تھرمز),
					},
					# Long Unit Identifier
					'force-newton' => {
						'name' => q(نیوٹن),
					},
					# Core Unit Identifier
					'newton' => {
						'name' => q(نیوٹن),
					},
					# Long Unit Identifier
					'force-pound-force' => {
						'name' => q(پاؤنڈ قوت),
					},
					# Core Unit Identifier
					'pound-force' => {
						'name' => q(پاؤنڈ قوت),
					},
					# Long Unit Identifier
					'frequency-gigahertz' => {
						'name' => q(GHz),
						'one' => q({0} GHz),
						'other' => q({0} GHz),
					},
					# Core Unit Identifier
					'gigahertz' => {
						'name' => q(GHz),
						'one' => q({0} GHz),
						'other' => q({0} GHz),
					},
					# Long Unit Identifier
					'frequency-hertz' => {
						'name' => q(Hz),
						'one' => q({0} Hz),
						'other' => q({0} Hz),
					},
					# Core Unit Identifier
					'hertz' => {
						'name' => q(Hz),
						'one' => q({0} Hz),
						'other' => q({0} Hz),
					},
					# Long Unit Identifier
					'frequency-kilohertz' => {
						'name' => q(kHz),
						'one' => q({0} kHz),
						'other' => q({0} kHz),
					},
					# Core Unit Identifier
					'kilohertz' => {
						'name' => q(kHz),
						'one' => q({0} kHz),
						'other' => q({0} kHz),
					},
					# Long Unit Identifier
					'frequency-megahertz' => {
						'name' => q(MHz),
						'one' => q({0} MHz),
						'other' => q({0} MHz),
					},
					# Core Unit Identifier
					'megahertz' => {
						'name' => q(MHz),
						'one' => q({0} MHz),
						'other' => q({0} MHz),
					},
					# Long Unit Identifier
					'graphics-dot' => {
						'name' => q(ڈاٹ),
						'one' => q({0} ڈاٹ),
						'other' => q({0} ڈاٹ),
					},
					# Core Unit Identifier
					'dot' => {
						'name' => q(ڈاٹ),
						'one' => q({0} ڈاٹ),
						'other' => q({0} ڈاٹ),
					},
					# Long Unit Identifier
					'graphics-dot-per-centimeter' => {
						'name' => q(dpcm),
						'one' => q({0} dpcm),
						'other' => q({0} dpcm),
					},
					# Core Unit Identifier
					'dot-per-centimeter' => {
						'name' => q(dpcm),
						'one' => q({0} dpcm),
						'other' => q({0} dpcm),
					},
					# Long Unit Identifier
					'graphics-dot-per-inch' => {
						'name' => q(dpi),
						'one' => q({0} dpi),
						'other' => q({0} dpi),
					},
					# Core Unit Identifier
					'dot-per-inch' => {
						'name' => q(dpi),
						'one' => q({0} dpi),
						'other' => q({0} dpi),
					},
					# Long Unit Identifier
					'graphics-megapixel' => {
						'name' => q(میگا پکسلز),
					},
					# Core Unit Identifier
					'megapixel' => {
						'name' => q(میگا پکسلز),
					},
					# Long Unit Identifier
					'graphics-pixel' => {
						'name' => q(پکسلز),
					},
					# Core Unit Identifier
					'pixel' => {
						'name' => q(پکسلز),
					},
					# Long Unit Identifier
					'length-astronomical-unit' => {
						'name' => q(au),
						'one' => q({0} au),
						'other' => q({0} au),
					},
					# Core Unit Identifier
					'astronomical-unit' => {
						'name' => q(au),
						'one' => q({0} au),
						'other' => q({0} au),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'name' => q(سینٹی میٹر),
						'one' => q({0} سینٹی میٹر),
						'other' => q({0} سینٹی میٹر),
						'per' => q({0}/cm),
					},
					# Core Unit Identifier
					'centimeter' => {
						'name' => q(سینٹی میٹر),
						'one' => q({0} سینٹی میٹر),
						'other' => q({0} سینٹی میٹر),
						'per' => q({0}/cm),
					},
					# Long Unit Identifier
					'length-decimeter' => {
						'name' => q(dm),
						'one' => q({0} dm),
						'other' => q({0} dm),
					},
					# Core Unit Identifier
					'decimeter' => {
						'name' => q(dm),
						'one' => q({0} dm),
						'other' => q({0} dm),
					},
					# Long Unit Identifier
					'length-earth-radius' => {
						'name' => q(R⊕),
						'one' => q({0} R⊕),
						'other' => q({0} R⊕),
					},
					# Core Unit Identifier
					'earth-radius' => {
						'name' => q(R⊕),
						'one' => q({0} R⊕),
						'other' => q({0} R⊕),
					},
					# Long Unit Identifier
					'length-fathom' => {
						'name' => q(فیدمز),
						'one' => q({0} فیدم),
						'other' => q({0} فیدم),
					},
					# Core Unit Identifier
					'fathom' => {
						'name' => q(فیدمز),
						'one' => q({0} فیدم),
						'other' => q({0} فیدم),
					},
					# Long Unit Identifier
					'length-foot' => {
						'name' => q(فیٹ),
						'one' => q({0} فیٹ),
						'other' => q({0} فیٹ),
						'per' => q({0}/ft),
					},
					# Core Unit Identifier
					'foot' => {
						'name' => q(فیٹ),
						'one' => q({0} فیٹ),
						'other' => q({0} فیٹ),
						'per' => q({0}/ft),
					},
					# Long Unit Identifier
					'length-furlong' => {
						'name' => q(فرلانگز),
						'one' => q({0} فرلانگ),
						'other' => q({0} فرلانگ),
					},
					# Core Unit Identifier
					'furlong' => {
						'name' => q(فرلانگز),
						'one' => q({0} فرلانگ),
						'other' => q({0} فرلانگ),
					},
					# Long Unit Identifier
					'length-inch' => {
						'name' => q(انچ),
						'one' => q({0} انچ),
						'other' => q({0} in),
						'per' => q({0}/in),
					},
					# Core Unit Identifier
					'inch' => {
						'name' => q(انچ),
						'one' => q({0} انچ),
						'other' => q({0} in),
						'per' => q({0}/in),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'name' => q(کلو میٹر),
						'one' => q({0} کلو میٹر),
						'other' => q({0} کلو میٹر),
						'per' => q({0} فی کلو میٹر),
					},
					# Core Unit Identifier
					'kilometer' => {
						'name' => q(کلو میٹر),
						'one' => q({0} کلو میٹر),
						'other' => q({0} کلو میٹر),
						'per' => q({0} فی کلو میٹر),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'name' => q(نوری سال),
						'one' => q({0} ly),
						'other' => q({0} ly),
					},
					# Core Unit Identifier
					'light-year' => {
						'name' => q(نوری سال),
						'one' => q({0} ly),
						'other' => q({0} ly),
					},
					# Long Unit Identifier
					'length-meter' => {
						'name' => q(میٹر),
						'one' => q({0} میٹر),
						'other' => q({0} میٹر),
						'per' => q({0}/m),
					},
					# Core Unit Identifier
					'meter' => {
						'name' => q(میٹر),
						'one' => q({0} میٹر),
						'other' => q({0} میٹر),
						'per' => q({0}/m),
					},
					# Long Unit Identifier
					'length-micrometer' => {
						'name' => q(μm),
						'one' => q({0} μm),
						'other' => q({0} μm),
					},
					# Core Unit Identifier
					'micrometer' => {
						'name' => q(μm),
						'one' => q({0} μm),
						'other' => q({0} μm),
					},
					# Long Unit Identifier
					'length-mile' => {
						'name' => q(میل),
						'one' => q({0} میل),
						'other' => q({0} میل),
					},
					# Core Unit Identifier
					'mile' => {
						'name' => q(میل),
						'one' => q({0} میل),
						'other' => q({0} میل),
					},
					# Long Unit Identifier
					'length-mile-scandinavian' => {
						'name' => q(smi),
						'one' => q({0} smi),
						'other' => q({0} smi),
					},
					# Core Unit Identifier
					'mile-scandinavian' => {
						'name' => q(smi),
						'one' => q({0} smi),
						'other' => q({0} smi),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'name' => q(ملی میٹر),
						'one' => q({0} ملیمیٹر),
						'other' => q({0} ملیمیٹر),
					},
					# Core Unit Identifier
					'millimeter' => {
						'name' => q(ملی میٹر),
						'one' => q({0} ملیمیٹر),
						'other' => q({0} ملیمیٹر),
					},
					# Long Unit Identifier
					'length-nanometer' => {
						'name' => q(nm),
						'one' => q({0} nm),
						'other' => q({0} nm),
					},
					# Core Unit Identifier
					'nanometer' => {
						'name' => q(nm),
						'one' => q({0} nm),
						'other' => q({0} nm),
					},
					# Long Unit Identifier
					'length-nautical-mile' => {
						'name' => q(nmi),
						'one' => q({0} nmi),
						'other' => q({0} nmi),
					},
					# Core Unit Identifier
					'nautical-mile' => {
						'name' => q(nmi),
						'one' => q({0} nmi),
						'other' => q({0} nmi),
					},
					# Long Unit Identifier
					'length-parsec' => {
						'name' => q(پارسیک),
						'one' => q({0} pc),
						'other' => q({0} pc),
					},
					# Core Unit Identifier
					'parsec' => {
						'name' => q(پارسیک),
						'one' => q({0} pc),
						'other' => q({0} pc),
					},
					# Long Unit Identifier
					'length-picometer' => {
						'name' => q(پیکو میٹر),
						'one' => q({0} پیکو میٹر),
						'other' => q({0} پیکو میٹر),
					},
					# Core Unit Identifier
					'picometer' => {
						'name' => q(پیکو میٹر),
						'one' => q({0} پیکو میٹر),
						'other' => q({0} پیکو میٹر),
					},
					# Long Unit Identifier
					'length-point' => {
						'name' => q(پوائنٹس),
						'one' => q({0} pt),
						'other' => q({0} pt),
					},
					# Core Unit Identifier
					'point' => {
						'name' => q(پوائنٹس),
						'one' => q({0} pt),
						'other' => q({0} pt),
					},
					# Long Unit Identifier
					'length-solar-radius' => {
						'name' => q(شمسی رداس),
					},
					# Core Unit Identifier
					'solar-radius' => {
						'name' => q(شمسی رداس),
					},
					# Long Unit Identifier
					'length-yard' => {
						'name' => q(گز),
						'one' => q({0} یارڈ),
						'other' => q({0} یارڈ),
					},
					# Core Unit Identifier
					'yard' => {
						'name' => q(گز),
						'one' => q({0} یارڈ),
						'other' => q({0} یارڈ),
					},
					# Long Unit Identifier
					'light-candela' => {
						'name' => q(cd),
						'one' => q({0} cd),
						'other' => q({0} cd),
					},
					# Core Unit Identifier
					'candela' => {
						'name' => q(cd),
						'one' => q({0} cd),
						'other' => q({0} cd),
					},
					# Long Unit Identifier
					'light-lumen' => {
						'name' => q(lm),
						'one' => q({0} lm),
						'other' => q({0} lm),
					},
					# Core Unit Identifier
					'lumen' => {
						'name' => q(lm),
						'one' => q({0} lm),
						'other' => q({0} lm),
					},
					# Long Unit Identifier
					'light-lux' => {
						'name' => q(lux),
						'one' => q({0} lx),
						'other' => q({0} lx),
					},
					# Core Unit Identifier
					'lux' => {
						'name' => q(lux),
						'one' => q({0} lx),
						'other' => q({0} lx),
					},
					# Long Unit Identifier
					'light-solar-luminosity' => {
						'name' => q(شمسی چمک),
					},
					# Core Unit Identifier
					'solar-luminosity' => {
						'name' => q(شمسی چمک),
					},
					# Long Unit Identifier
					'mass-carat' => {
						'name' => q(قیراط),
						'one' => q({0} CD),
						'other' => q({0} CD),
					},
					# Core Unit Identifier
					'carat' => {
						'name' => q(قیراط),
						'one' => q({0} CD),
						'other' => q({0} CD),
					},
					# Long Unit Identifier
					'mass-dalton' => {
						'name' => q(ڈالٹنز),
						'one' => q({0} Da),
						'other' => q({0} Da),
					},
					# Core Unit Identifier
					'dalton' => {
						'name' => q(ڈالٹنز),
						'one' => q({0} Da),
						'other' => q({0} Da),
					},
					# Long Unit Identifier
					'mass-earth-mass' => {
						'name' => q(زمینی کمیتیں),
						'one' => q({0} M⊕),
						'other' => q({0} M⊕),
					},
					# Core Unit Identifier
					'earth-mass' => {
						'name' => q(زمینی کمیتیں),
						'one' => q({0} M⊕),
						'other' => q({0} M⊕),
					},
					# Long Unit Identifier
					'mass-grain' => {
						'name' => q(گرین),
						'one' => q({0} گرین),
						'other' => q({0} گرین),
					},
					# Core Unit Identifier
					'grain' => {
						'name' => q(گرین),
						'one' => q({0} گرین),
						'other' => q({0} گرین),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'name' => q(گرام),
						'one' => q({0} g),
						'other' => q({0} g),
						'per' => q({0}/g),
					},
					# Core Unit Identifier
					'gram' => {
						'name' => q(گرام),
						'one' => q({0} g),
						'other' => q({0} g),
						'per' => q({0}/g),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'name' => q(kg),
						'one' => q({0} kg),
						'other' => q({0} kg),
						'per' => q({0}/kg),
					},
					# Core Unit Identifier
					'kilogram' => {
						'name' => q(kg),
						'one' => q({0} kg),
						'other' => q({0} kg),
						'per' => q({0}/kg),
					},
					# Long Unit Identifier
					'mass-metric-ton' => {
						'name' => q(t),
						'one' => q({0} t),
						'other' => q({0} t),
					},
					# Core Unit Identifier
					'metric-ton' => {
						'name' => q(t),
						'one' => q({0} t),
						'other' => q({0} t),
					},
					# Long Unit Identifier
					'mass-microgram' => {
						'name' => q(μg),
						'one' => q({0} μg),
						'other' => q({0} μg),
					},
					# Core Unit Identifier
					'microgram' => {
						'name' => q(μg),
						'one' => q({0} μg),
						'other' => q({0} μg),
					},
					# Long Unit Identifier
					'mass-milligram' => {
						'name' => q(mg),
						'one' => q({0} mg),
						'other' => q({0} mg),
					},
					# Core Unit Identifier
					'milligram' => {
						'name' => q(mg),
						'one' => q({0} mg),
						'other' => q({0} mg),
					},
					# Long Unit Identifier
					'mass-ounce' => {
						'name' => q(oz),
						'one' => q({0} oz),
						'other' => q({0} oz),
						'per' => q({0}/oz),
					},
					# Core Unit Identifier
					'ounce' => {
						'name' => q(oz),
						'one' => q({0} oz),
						'other' => q({0} oz),
						'per' => q({0}/oz),
					},
					# Long Unit Identifier
					'mass-ounce-troy' => {
						'name' => q(oz t),
						'one' => q({0} oz t),
						'other' => q({0} oz t),
					},
					# Core Unit Identifier
					'ounce-troy' => {
						'name' => q(oz t),
						'one' => q({0} oz t),
						'other' => q({0} oz t),
					},
					# Long Unit Identifier
					'mass-pound' => {
						'name' => q(پونڈ),
						'one' => q({0} lb),
						'other' => q({0} lb),
						'per' => q({0}/lb),
					},
					# Core Unit Identifier
					'pound' => {
						'name' => q(پونڈ),
						'one' => q({0} lb),
						'other' => q({0} lb),
						'per' => q({0}/lb),
					},
					# Long Unit Identifier
					'mass-solar-mass' => {
						'name' => q(شمسی کمیتیں),
						'one' => q({0} M☉),
						'other' => q({0} M☉),
					},
					# Core Unit Identifier
					'solar-mass' => {
						'name' => q(شمسی کمیتیں),
						'one' => q({0} M☉),
						'other' => q({0} M☉),
					},
					# Long Unit Identifier
					'mass-stone' => {
						'name' => q(st),
						'one' => q({0} st),
						'other' => q({0} st),
					},
					# Core Unit Identifier
					'stone' => {
						'name' => q(st),
						'one' => q({0} st),
						'other' => q({0} st),
					},
					# Long Unit Identifier
					'mass-ton' => {
						'name' => q(ٹن),
						'one' => q({0} tn),
						'other' => q({0} tn),
					},
					# Core Unit Identifier
					'ton' => {
						'name' => q(ٹن),
						'one' => q({0} tn),
						'other' => q({0} tn),
					},
					# Long Unit Identifier
					'per' => {
						'1' => q({0}/{1}),
					},
					# Core Unit Identifier
					'per' => {
						'1' => q({0}/{1}),
					},
					# Long Unit Identifier
					'power-gigawatt' => {
						'name' => q(GW),
						'one' => q({0} GW),
						'other' => q({0} GW),
					},
					# Core Unit Identifier
					'gigawatt' => {
						'name' => q(GW),
						'one' => q({0} GW),
						'other' => q({0} GW),
					},
					# Long Unit Identifier
					'power-horsepower' => {
						'name' => q(hp),
						'one' => q({0} hp),
						'other' => q({0} hp),
					},
					# Core Unit Identifier
					'horsepower' => {
						'name' => q(hp),
						'one' => q({0} hp),
						'other' => q({0} hp),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'name' => q(kW),
						'one' => q({0} کلو واٹ),
						'other' => q({0} کلو واٹ),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'name' => q(kW),
						'one' => q({0} کلو واٹ),
						'other' => q({0} کلو واٹ),
					},
					# Long Unit Identifier
					'power-megawatt' => {
						'name' => q(MW),
						'one' => q({0} MW),
						'other' => q({0} MW),
					},
					# Core Unit Identifier
					'megawatt' => {
						'name' => q(MW),
						'one' => q({0} MW),
						'other' => q({0} MW),
					},
					# Long Unit Identifier
					'power-milliwatt' => {
						'name' => q(mW),
						'one' => q({0} mW),
						'other' => q({0} mW),
					},
					# Core Unit Identifier
					'milliwatt' => {
						'name' => q(mW),
						'one' => q({0} mW),
						'other' => q({0} mW),
					},
					# Long Unit Identifier
					'power-watt' => {
						'name' => q(واٹ),
						'one' => q({0} واٹ),
						'other' => q({0} واٹ),
					},
					# Core Unit Identifier
					'watt' => {
						'name' => q(واٹ),
						'one' => q({0} واٹ),
						'other' => q({0} واٹ),
					},
					# Long Unit Identifier
					'pressure-atmosphere' => {
						'name' => q(atm),
						'one' => q({0} atm),
						'other' => q({0} atm),
					},
					# Core Unit Identifier
					'atmosphere' => {
						'name' => q(atm),
						'one' => q({0} atm),
						'other' => q({0} atm),
					},
					# Long Unit Identifier
					'pressure-bar' => {
						'name' => q(بار),
						'one' => q({0} بار),
						'other' => q({0} بارز),
					},
					# Core Unit Identifier
					'bar' => {
						'name' => q(بار),
						'one' => q({0} بار),
						'other' => q({0} بارز),
					},
					# Long Unit Identifier
					'pressure-hectopascal' => {
						'name' => q(hPa),
						'one' => q({0} hPa),
						'other' => q({0} hPa),
					},
					# Core Unit Identifier
					'hectopascal' => {
						'name' => q(hPa),
						'one' => q({0} hPa),
						'other' => q({0} hPa),
					},
					# Long Unit Identifier
					'pressure-inch-ofhg' => {
						'name' => q(inHg),
						'one' => q({0} inHg),
						'other' => q({0} inHg),
					},
					# Core Unit Identifier
					'inch-ofhg' => {
						'name' => q(inHg),
						'one' => q({0} inHg),
						'other' => q({0} inHg),
					},
					# Long Unit Identifier
					'pressure-kilopascal' => {
						'name' => q(kPa),
						'one' => q({0} kPa),
						'other' => q({0} kPa),
					},
					# Core Unit Identifier
					'kilopascal' => {
						'name' => q(kPa),
						'one' => q({0} kPa),
						'other' => q({0} kPa),
					},
					# Long Unit Identifier
					'pressure-megapascal' => {
						'name' => q(MPa),
						'one' => q({0} MPa),
						'other' => q({0} MPa),
					},
					# Core Unit Identifier
					'megapascal' => {
						'name' => q(MPa),
						'one' => q({0} MPa),
						'other' => q({0} MPa),
					},
					# Long Unit Identifier
					'pressure-millibar' => {
						'name' => q(mbar),
						'one' => q({0} mbar),
						'other' => q({0} mbar),
					},
					# Core Unit Identifier
					'millibar' => {
						'name' => q(mbar),
						'one' => q({0} mbar),
						'other' => q({0} mbar),
					},
					# Long Unit Identifier
					'pressure-millimeter-ofhg' => {
						'name' => q(mm Hg),
						'one' => q({0} mm Hg),
						'other' => q({0} mm Hg),
					},
					# Core Unit Identifier
					'millimeter-ofhg' => {
						'name' => q(mm Hg),
						'one' => q({0} mm Hg),
						'other' => q({0} mm Hg),
					},
					# Long Unit Identifier
					'pressure-pound-force-per-square-inch' => {
						'name' => q(psi),
						'one' => q({0} psi),
						'other' => q({0} psi),
					},
					# Core Unit Identifier
					'pound-force-per-square-inch' => {
						'name' => q(psi),
						'one' => q({0} psi),
						'other' => q({0} psi),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'name' => q(کلومیٹر/گھنٹہ),
						'one' => q({0} kph),
						'other' => q({0} kph),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'name' => q(کلومیٹر/گھنٹہ),
						'one' => q({0} kph),
						'other' => q({0} kph),
					},
					# Long Unit Identifier
					'speed-knot' => {
						'name' => q(kn),
						'one' => q({0} kn),
						'other' => q({0} kn),
					},
					# Core Unit Identifier
					'knot' => {
						'name' => q(kn),
						'one' => q({0} kn),
						'other' => q({0} kn),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'name' => q(میٹر فی سیکنڈ),
						'one' => q({0} m/s),
						'other' => q({0} m/s),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'name' => q(میٹر فی سیکنڈ),
						'one' => q({0} m/s),
						'other' => q({0} m/s),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'name' => q(میل فی گھنٹہ),
						'one' => q({0} mph),
						'other' => q({0} mph),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'name' => q(میل فی گھنٹہ),
						'one' => q({0} mph),
						'other' => q({0} mph),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'name' => q(ڈگری سیلسیس),
						'one' => q({0}‎°C),
						'other' => q({0}‎°C),
					},
					# Core Unit Identifier
					'celsius' => {
						'name' => q(ڈگری سیلسیس),
						'one' => q({0}‎°C),
						'other' => q({0}‎°C),
					},
					# Long Unit Identifier
					'temperature-fahrenheit' => {
						'name' => q(ڈگری فارن ہائیٹ),
						'one' => q({0}‎°F),
						'other' => q({0}‎°F),
					},
					# Core Unit Identifier
					'fahrenheit' => {
						'name' => q(ڈگری فارن ہائیٹ),
						'one' => q({0}‎°F),
						'other' => q({0}‎°F),
					},
					# Long Unit Identifier
					'temperature-generic' => {
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Core Unit Identifier
					'generic' => {
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Long Unit Identifier
					'temperature-kelvin' => {
						'name' => q(K),
						'one' => q({0} K),
						'other' => q({0} K),
					},
					# Core Unit Identifier
					'kelvin' => {
						'name' => q(K),
						'one' => q({0} K),
						'other' => q({0} K),
					},
					# Long Unit Identifier
					'volume-acre-foot' => {
						'name' => q(ایکڑ فٹ),
						'one' => q({0} ac ft),
						'other' => q({0} ac ft),
					},
					# Core Unit Identifier
					'acre-foot' => {
						'name' => q(ایکڑ فٹ),
						'one' => q({0} ac ft),
						'other' => q({0} ac ft),
					},
					# Long Unit Identifier
					'volume-barrel' => {
						'name' => q(بیرل),
					},
					# Core Unit Identifier
					'barrel' => {
						'name' => q(بیرل),
					},
					# Long Unit Identifier
					'volume-bushel' => {
						'name' => q(بُشلز),
						'one' => q({0} بو),
						'other' => q({0} بو),
					},
					# Core Unit Identifier
					'bushel' => {
						'name' => q(بُشلز),
						'one' => q({0} بو),
						'other' => q({0} بو),
					},
					# Long Unit Identifier
					'volume-centiliter' => {
						'name' => q(سینٹی لیٹر),
						'one' => q({0} cL),
						'other' => q({0} cL),
					},
					# Core Unit Identifier
					'centiliter' => {
						'name' => q(سینٹی لیٹر),
						'one' => q({0} cL),
						'other' => q({0} cL),
					},
					# Long Unit Identifier
					'volume-cubic-centimeter' => {
						'name' => q(کیوبک سینٹی میٹر),
						'one' => q({0} cm³),
						'other' => q({0} cm³),
						'per' => q({0}/cm³),
					},
					# Core Unit Identifier
					'cubic-centimeter' => {
						'name' => q(کیوبک سینٹی میٹر),
						'one' => q({0} cm³),
						'other' => q({0} cm³),
						'per' => q({0}/cm³),
					},
					# Long Unit Identifier
					'volume-cubic-foot' => {
						'name' => q(کیوبک فٹ),
						'one' => q({0} ft³),
						'other' => q({0} ft³),
					},
					# Core Unit Identifier
					'cubic-foot' => {
						'name' => q(کیوبک فٹ),
						'one' => q({0} ft³),
						'other' => q({0} ft³),
					},
					# Long Unit Identifier
					'volume-cubic-inch' => {
						'name' => q(کیوبک انچ),
						'one' => q({0} in³),
						'other' => q({0} in³),
					},
					# Core Unit Identifier
					'cubic-inch' => {
						'name' => q(کیوبک انچ),
						'one' => q({0} in³),
						'other' => q({0} in³),
					},
					# Long Unit Identifier
					'volume-cubic-kilometer' => {
						'name' => q(km³),
						'one' => q({0} km³),
						'other' => q({0} km³),
					},
					# Core Unit Identifier
					'cubic-kilometer' => {
						'name' => q(km³),
						'one' => q({0} km³),
						'other' => q({0} km³),
					},
					# Long Unit Identifier
					'volume-cubic-meter' => {
						'name' => q(m³),
						'one' => q({0} m³),
						'other' => q({0} m³),
						'per' => q({0}/m³),
					},
					# Core Unit Identifier
					'cubic-meter' => {
						'name' => q(m³),
						'one' => q({0} m³),
						'other' => q({0} m³),
						'per' => q({0}/m³),
					},
					# Long Unit Identifier
					'volume-cubic-mile' => {
						'name' => q(کیوبک میل),
						'one' => q({0} کیوبک میل),
						'other' => q({0} کیوبک میل),
					},
					# Core Unit Identifier
					'cubic-mile' => {
						'name' => q(کیوبک میل),
						'one' => q({0} کیوبک میل),
						'other' => q({0} کیوبک میل),
					},
					# Long Unit Identifier
					'volume-cubic-yard' => {
						'name' => q(کیوبک گز),
						'one' => q({0} yd³),
						'other' => q({0} yd³),
					},
					# Core Unit Identifier
					'cubic-yard' => {
						'name' => q(کیوبک گز),
						'one' => q({0} yd³),
						'other' => q({0} yd³),
					},
					# Long Unit Identifier
					'volume-cup' => {
						'name' => q(کپ),
						'one' => q({0} c),
						'other' => q({0} c),
					},
					# Core Unit Identifier
					'cup' => {
						'name' => q(کپ),
						'one' => q({0} c),
						'other' => q({0} c),
					},
					# Long Unit Identifier
					'volume-cup-metric' => {
						'name' => q(mcup),
						'one' => q({0} mc),
						'other' => q({0} mc),
					},
					# Core Unit Identifier
					'cup-metric' => {
						'name' => q(mcup),
						'one' => q({0} mc),
						'other' => q({0} mc),
					},
					# Long Unit Identifier
					'volume-deciliter' => {
						'name' => q(ڈیسی لیٹر),
						'one' => q({0} dL),
						'other' => q({0} dL),
					},
					# Core Unit Identifier
					'deciliter' => {
						'name' => q(ڈیسی لیٹر),
						'one' => q({0} dL),
						'other' => q({0} dL),
					},
					# Long Unit Identifier
					'volume-dessert-spoon' => {
						'name' => q(ڈیزرٹ اسپون),
						'one' => q({0} dstspn),
						'other' => q({0} dstspn),
					},
					# Core Unit Identifier
					'dessert-spoon' => {
						'name' => q(ڈیزرٹ اسپون),
						'one' => q({0} dstspn),
						'other' => q({0} dstspn),
					},
					# Long Unit Identifier
					'volume-dessert-spoon-imperial' => {
						'one' => q({0} dstspn Imp),
						'other' => q({0} dstspn Imp),
					},
					# Core Unit Identifier
					'dessert-spoon-imperial' => {
						'one' => q({0} dstspn Imp),
						'other' => q({0} dstspn Imp),
					},
					# Long Unit Identifier
					'volume-dram' => {
						'name' => q(ڈرام فلوئیڈ),
						'one' => q({0} ڈرام فلوئیڈ),
						'other' => q({0} ڈرام فلوئیڈ),
					},
					# Core Unit Identifier
					'dram' => {
						'name' => q(ڈرام فلوئیڈ),
						'one' => q({0} ڈرام فلوئیڈ),
						'other' => q({0} ڈرام فلوئیڈ),
					},
					# Long Unit Identifier
					'volume-drop' => {
						'name' => q(قطرہ),
						'one' => q({0} قطرہ),
						'other' => q({0} قطرہ),
					},
					# Core Unit Identifier
					'drop' => {
						'name' => q(قطرہ),
						'one' => q({0} قطرہ),
						'other' => q({0} قطرہ),
					},
					# Long Unit Identifier
					'volume-fluid-ounce' => {
						'name' => q(fl oz),
						'one' => q({0} fl oz),
						'other' => q({0} fl oz),
					},
					# Core Unit Identifier
					'fluid-ounce' => {
						'name' => q(fl oz),
						'one' => q({0} fl oz),
						'other' => q({0} fl oz),
					},
					# Long Unit Identifier
					'volume-gallon' => {
						'name' => q(gal),
						'one' => q({0} gal),
						'other' => q({0} gal),
						'per' => q({0}/gal),
					},
					# Core Unit Identifier
					'gallon' => {
						'name' => q(gal),
						'one' => q({0} gal),
						'other' => q({0} gal),
						'per' => q({0}/gal),
					},
					# Long Unit Identifier
					'volume-gallon-imperial' => {
						'name' => q(Imp. gal),
						'one' => q({0} gal Imp.),
						'other' => q({0} gal Imp.),
						'per' => q({0}/gal Imp.),
					},
					# Core Unit Identifier
					'gallon-imperial' => {
						'name' => q(Imp. gal),
						'one' => q({0} gal Imp.),
						'other' => q({0} gal Imp.),
						'per' => q({0}/gal Imp.),
					},
					# Long Unit Identifier
					'volume-hectoliter' => {
						'name' => q(hL),
						'one' => q({0} hL),
						'other' => q({0} hL),
					},
					# Core Unit Identifier
					'hectoliter' => {
						'name' => q(hL),
						'one' => q({0} hL),
						'other' => q({0} hL),
					},
					# Long Unit Identifier
					'volume-jigger' => {
						'name' => q(جگر),
						'one' => q({0} جگر),
						'other' => q({0} جگر),
					},
					# Core Unit Identifier
					'jigger' => {
						'name' => q(جگر),
						'one' => q({0} جگر),
						'other' => q({0} جگر),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'name' => q(لیٹر),
						'one' => q({0} لیٹر),
						'other' => q({0} لیٹر),
						'per' => q({0} فی لیٹر),
					},
					# Core Unit Identifier
					'liter' => {
						'name' => q(لیٹر),
						'one' => q({0} لیٹر),
						'other' => q({0} لیٹر),
						'per' => q({0} فی لیٹر),
					},
					# Long Unit Identifier
					'volume-megaliter' => {
						'name' => q(ML),
						'one' => q({0} ML),
						'other' => q({0} ML),
					},
					# Core Unit Identifier
					'megaliter' => {
						'name' => q(ML),
						'one' => q({0} ML),
						'other' => q({0} ML),
					},
					# Long Unit Identifier
					'volume-milliliter' => {
						'name' => q(mL),
						'one' => q({0} mL),
						'other' => q({0} mL),
					},
					# Core Unit Identifier
					'milliliter' => {
						'name' => q(mL),
						'one' => q({0} mL),
						'other' => q({0} mL),
					},
					# Long Unit Identifier
					'volume-pinch' => {
						'name' => q(چٹکی),
						'one' => q({0} چٹکی),
						'other' => q({0} چٹکی),
					},
					# Core Unit Identifier
					'pinch' => {
						'name' => q(چٹکی),
						'one' => q({0} چٹکی),
						'other' => q({0} چٹکی),
					},
					# Long Unit Identifier
					'volume-pint' => {
						'name' => q(pt),
						'one' => q({0} pt),
						'other' => q({0} pt),
					},
					# Core Unit Identifier
					'pint' => {
						'name' => q(pt),
						'one' => q({0} pt),
						'other' => q({0} pt),
					},
					# Long Unit Identifier
					'volume-pint-metric' => {
						'name' => q(mpt),
						'one' => q({0} mpt),
						'other' => q({0} mpt),
					},
					# Core Unit Identifier
					'pint-metric' => {
						'name' => q(mpt),
						'one' => q({0} mpt),
						'other' => q({0} mpt),
					},
					# Long Unit Identifier
					'volume-quart' => {
						'name' => q(qts),
						'one' => q({0} qt),
						'other' => q({0} qt),
					},
					# Core Unit Identifier
					'quart' => {
						'name' => q(qts),
						'one' => q({0} qt),
						'other' => q({0} qt),
					},
					# Long Unit Identifier
					'volume-quart-imperial' => {
						'name' => q(qt Imp),
						'one' => q({0} qt Imp.),
						'other' => q({0} qt Imp.),
					},
					# Core Unit Identifier
					'quart-imperial' => {
						'name' => q(qt Imp),
						'one' => q({0} qt Imp.),
						'other' => q({0} qt Imp.),
					},
					# Long Unit Identifier
					'volume-tablespoon' => {
						'name' => q(tbsp),
						'one' => q({0} tbsp),
						'other' => q({0} tbsp),
					},
					# Core Unit Identifier
					'tablespoon' => {
						'name' => q(tbsp),
						'one' => q({0} tbsp),
						'other' => q({0} tbsp),
					},
					# Long Unit Identifier
					'volume-teaspoon' => {
						'name' => q(tsp),
						'one' => q({0} tsp),
						'other' => q({0} tsp),
					},
					# Core Unit Identifier
					'teaspoon' => {
						'name' => q(tsp),
						'one' => q({0} tsp),
						'other' => q({0} tsp),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:ہاں|ہاں|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:نہیں|نہیں|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
				start => q({0}، {1}),
				middle => q({0}، {1}),
				end => q({0}، اور {1}),
				2 => q({0} اور {1}),
		} }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'latn',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'arabext',
);

has 'minimum_grouping_digits' => (
	is			=>'ro',
	isa			=> Int,
	init_arg	=> undef,
	default		=> 1,
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'arabext' => {
			'decimal' => q(٫),
			'exponential' => q(×۱۰^),
			'group' => q(٬),
			'infinity' => q(∞),
			'list' => q(;),
			'minusSign' => q(‎-‎),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(‎+‎),
			'superscriptingExponent' => q(×),
		},
		'latn' => {
			'decimal' => q(.),
			'exponential' => q(E),
			'group' => q(,),
			'infinity' => q(∞),
			'list' => q(;),
			'minusSign' => q(‎-),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(‎+),
			'superscriptingExponent' => q(×),
			'timeSeparator' => q(:),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'1000' => {
					'one' => '0 ہزار',
					'other' => '0 ہزار',
				},
				'10000' => {
					'one' => '00 ہزار',
					'other' => '00 ہزار',
				},
				'100000' => {
					'one' => '0 لاکھ',
					'other' => '0 لاکھ',
				},
				'1000000' => {
					'one' => '00 لاکھ',
					'other' => '00 لاکھ',
				},
				'10000000' => {
					'one' => '0 کروڑ',
					'other' => '0 کروڑ',
				},
				'100000000' => {
					'one' => '00 کروڑ',
					'other' => '00 کروڑ',
				},
				'1000000000' => {
					'one' => '0 ارب',
					'other' => '0 ارب',
				},
				'10000000000' => {
					'one' => '00 ارب',
					'other' => '00 ارب',
				},
				'100000000000' => {
					'one' => '0 کھرب',
					'other' => '0 کھرب',
				},
				'1000000000000' => {
					'one' => '00 کھرب',
					'other' => '00 کھرب',
				},
				'10000000000000' => {
					'one' => '00 ٹریلین',
					'other' => '00 ٹریلین',
				},
				'100000000000000' => {
					'one' => '000 ٹریلین',
					'other' => '000 ٹریلین',
				},
				'standard' => {
					'default' => '#,##0.###',
				},
			},
			'long' => {
				'1000' => {
					'one' => '0 ہزار',
					'other' => '0 ہزار',
				},
				'10000' => {
					'one' => '00 ہزار',
					'other' => '00 ہزار',
				},
				'100000' => {
					'one' => '0 لاکھ',
					'other' => '0 لاکھ',
				},
				'1000000' => {
					'one' => '00 لاکھ',
					'other' => '00 لاکھ',
				},
				'10000000' => {
					'one' => '0 کروڑ',
					'other' => '0 کروڑ',
				},
				'100000000' => {
					'one' => '00 کروڑ',
					'other' => '00 کروڑ',
				},
				'1000000000' => {
					'one' => '0 ارب',
					'other' => '0 ارب',
				},
				'10000000000' => {
					'one' => '00 ارب',
					'other' => '00 ارب',
				},
				'100000000000' => {
					'one' => '0 کھرب',
					'other' => '0 کھرب',
				},
				'1000000000000' => {
					'one' => '00 کھرب',
					'other' => '00 کھرب',
				},
				'10000000000000' => {
					'one' => '00 ٹریلین',
					'other' => '00 ٹریلین',
				},
				'100000000000000' => {
					'one' => '000 ٹریلین',
					'other' => '000 ٹریلین',
				},
			},
			'short' => {
				'1000' => {
					'one' => '0 ہزار',
					'other' => '0 ہزار',
				},
				'10000' => {
					'one' => '00 ہزار',
					'other' => '00 ہزار',
				},
				'100000' => {
					'one' => '0 لاکھ',
					'other' => '0 لاکھ',
				},
				'1000000' => {
					'one' => '00 لاکھ',
					'other' => '00 لاکھ',
				},
				'10000000' => {
					'one' => '0 کروڑ',
					'other' => '0 کروڑ',
				},
				'100000000' => {
					'one' => '00 کروڑ',
					'other' => '00 کروڑ',
				},
				'1000000000' => {
					'one' => '0 ارب',
					'other' => '0 ارب',
				},
				'10000000000' => {
					'one' => '00 ارب',
					'other' => '00 ارب',
				},
				'100000000000' => {
					'one' => '0 کھرب',
					'other' => '0 کھرب',
				},
				'1000000000000' => {
					'one' => '00 کھرب',
					'other' => '00 کھرب',
				},
				'10000000000000' => {
					'one' => '00 ٹریلین',
					'other' => '00 ٹریلین',
				},
				'100000000000000' => {
					'one' => '000 ٹریلین',
					'other' => '000 ٹریلین',
				},
			},
		},
		percentFormat => {
			'default' => {
				'standard' => {
					'default' => '#,##0%',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'standard' => {
					'default' => '#E0',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'arabext' => {
			'pattern' => {
				'default' => {
					'standard' => {
						'positive' => '¤#,##0.00',
					},
				},
			},
		},
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'negative' => '(¤#,##0.00)',
						'positive' => '¤#,##0.00',
					},
					'standard' => {
						'positive' => '¤ #,##0.00',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'AED' => {
			symbol => 'AED',
			display_name => {
				'currency' => q(متحدہ عرب اماراتی درہم),
				'one' => q(متحدہ عرب اماراتی درہم),
				'other' => q(متحدہ عرب اماراتی درہم),
			},
		},
		'AFN' => {
			symbol => 'AFN',
			display_name => {
				'currency' => q(افغان افغانی),
				'one' => q(افغان افغانی),
				'other' => q(افغان افغانی),
			},
		},
		'ALL' => {
			symbol => 'ALL',
			display_name => {
				'currency' => q(البانیا کا لیک),
				'one' => q(البانیا کا لیک),
				'other' => q(البانیا کا لیک),
			},
		},
		'AMD' => {
			symbol => 'AMD',
			display_name => {
				'currency' => q(آرمینیائی ڈرم),
				'one' => q(آرمینیائی ڈرم),
				'other' => q(آرمینیائی ڈرم),
			},
		},
		'ANG' => {
			symbol => 'ANG',
			display_name => {
				'currency' => q(نیدر لینڈز انٹیلیئن گلڈر),
				'one' => q(نیدر لینڈز انٹیلیئن گلڈر),
				'other' => q(نیدر لینڈز انٹیلیئن گلڈر),
			},
		},
		'AOA' => {
			symbol => 'AOA',
			display_name => {
				'currency' => q(انگولا کا کوانزا),
				'one' => q(انگولا کا کوانزا),
				'other' => q(انگولا کا کوانزا),
			},
		},
		'ARS' => {
			symbol => 'ARS',
			display_name => {
				'currency' => q(ارجنٹائن پیسہ),
				'one' => q(ارجنٹائن پیسہ),
				'other' => q(ارجنٹائن پیسہ),
			},
		},
		'AUD' => {
			symbol => 'A$',
			display_name => {
				'currency' => q(آسٹریلین ڈالر),
				'one' => q(آسٹریلین ڈالر),
				'other' => q(آسٹریلین ڈالر),
			},
		},
		'AWG' => {
			symbol => 'AWG',
			display_name => {
				'currency' => q(اروبن فلورِن),
				'one' => q(اروبن فلورِن),
				'other' => q(اروبن فلورِن),
			},
		},
		'AZN' => {
			symbol => 'AZN',
			display_name => {
				'currency' => q(آذربائجانی منات),
				'one' => q(آذربائجانی منات),
				'other' => q(آذربائجانی منات),
			},
		},
		'BAM' => {
			symbol => 'BAM',
			display_name => {
				'currency' => q(بوسنیا ہرزیگووینا کا قابل منتقلی نشان),
				'one' => q(بوسنیا ہرزیگووینا کا قابل منتقلی نشان),
				'other' => q(بوسنیا ہرزیگووینا کا قابل منتقلی نشان),
			},
		},
		'BBD' => {
			symbol => 'BBD',
			display_name => {
				'currency' => q(باربیڈین ڈالر),
				'one' => q(باربیڈین ڈالر),
				'other' => q(باربیڈین ڈالر),
			},
		},
		'BDT' => {
			symbol => 'BDT',
			display_name => {
				'currency' => q(بنگلہ دیشی ٹکا),
				'one' => q(بنگلہ دیشی ٹکا),
				'other' => q(بنگلہ دیشی ٹکا),
			},
		},
		'BGN' => {
			symbol => 'BGN',
			display_name => {
				'currency' => q(بلغارین لیو),
				'one' => q(بلغارین لیو),
				'other' => q(بلغارین لیو),
			},
		},
		'BHD' => {
			symbol => 'BHD',
			display_name => {
				'currency' => q(بحرینی دینار),
				'one' => q(بحرینی دینار),
				'other' => q(بحرینی دینار),
			},
		},
		'BIF' => {
			symbol => 'BIF',
			display_name => {
				'currency' => q(برونڈیئن فرانک),
				'one' => q(برونڈیئن فرانک),
				'other' => q(برونڈیئن فرانک),
			},
		},
		'BMD' => {
			symbol => 'BMD',
			display_name => {
				'currency' => q(برموڈا ڈالر),
				'one' => q(برموڈا ڈالر),
				'other' => q(برموڈا ڈالر),
			},
		},
		'BND' => {
			symbol => 'BND',
			display_name => {
				'currency' => q(برونئی ڈالر),
				'one' => q(برونئی ڈالر),
				'other' => q(برونئی ڈالر),
			},
		},
		'BOB' => {
			symbol => 'BOB',
			display_name => {
				'currency' => q(بولیوین بولیویانو),
				'one' => q(بولیوین بولیویانو),
				'other' => q(بولیوین بولیویانو),
			},
		},
		'BRL' => {
			symbol => 'R$',
			display_name => {
				'currency' => q(برازیلی ریئل),
				'one' => q(برازیلی ریئل),
				'other' => q(برازیلی ریئل),
			},
		},
		'BSD' => {
			symbol => 'BSD',
			display_name => {
				'currency' => q(بہامانی ڈالر),
				'one' => q(بہامانی ڈالر),
				'other' => q(بہامانی ڈالر),
			},
		},
		'BTN' => {
			symbol => 'BTN',
			display_name => {
				'currency' => q(بھوٹانی گُلٹرم),
				'one' => q(بھوٹانی گُلٹرم),
				'other' => q(بھوٹانی گُلٹرم),
			},
		},
		'BWP' => {
			symbol => 'BWP',
			display_name => {
				'currency' => q(بوتسوانا کا پولا),
				'one' => q(بوتسوانا کا پولا),
				'other' => q(بوتسوانا کا پولا),
			},
		},
		'BYN' => {
			symbol => 'BYN',
			display_name => {
				'currency' => q(بیلاروسی روبل),
				'one' => q(بیلاروسی روبل),
				'other' => q(بیلاروسی روبل),
			},
		},
		'BYR' => {
			symbol => 'BYR',
			display_name => {
				'currency' => q(بیلاروسی روبل \(۲۰۰۰–۲۰۱۶\)),
				'one' => q(بیلاروسی روبل \(۲۰۰۰–۲۰۱۶\)),
				'other' => q(بیلاروسی روبل \(۲۰۰۰–۲۰۱۶\)),
			},
		},
		'BZD' => {
			symbol => 'BZD',
			display_name => {
				'currency' => q(بیلیز ڈالر),
				'one' => q(بیلیز ڈالر),
				'other' => q(بیلیز ڈالرز),
			},
		},
		'CAD' => {
			symbol => 'CA$',
			display_name => {
				'currency' => q(کنیڈین ڈالر),
				'one' => q(کنیڈین ڈالر),
				'other' => q(کنیڈین ڈالر),
			},
		},
		'CDF' => {
			symbol => 'CDF',
			display_name => {
				'currency' => q(کانگولیز فرانک),
				'one' => q(کانگولیز فرانک),
				'other' => q(کانگولیز فرانک),
			},
		},
		'CHF' => {
			symbol => 'CHF',
			display_name => {
				'currency' => q(سوئس فرانکس),
				'one' => q(سوئس فرانکس),
				'other' => q(سوئس فرانکس),
			},
		},
		'CLP' => {
			symbol => 'CLP',
			display_name => {
				'currency' => q(چلّین پیسہ),
				'one' => q(چلّین پیسہ),
				'other' => q(چلّین پیسہ),
			},
		},
		'CNH' => {
			symbol => 'CNH',
			display_name => {
				'currency' => q(چینی یوآن \(آف شور\)),
				'one' => q(چینی یوآن \(آف شور\)),
				'other' => q(چینی یوآن \(آف شور\)),
			},
		},
		'CNY' => {
			symbol => 'CN¥',
			display_name => {
				'currency' => q(چینی یوآن),
				'one' => q(چینی یوآن),
				'other' => q(چینی یوآن),
			},
		},
		'COP' => {
			symbol => 'COP',
			display_name => {
				'currency' => q(کولمبین پیسہ),
				'one' => q(کولمبین پیسہ),
				'other' => q(کولمبین پیسہ),
			},
		},
		'CRC' => {
			symbol => 'CRC',
			display_name => {
				'currency' => q(کوسٹا ریکا کا کولن),
				'one' => q(کوسٹا ریکا کا کولن),
				'other' => q(کوسٹا ریکا کا کولن),
			},
		},
		'CUC' => {
			symbol => 'CUC',
			display_name => {
				'currency' => q(کیوبا کا قابل منتقلی پیسو),
				'one' => q(کیوبا کا قابل منتقلی پیسو),
				'other' => q(کیوبا کا قابل منتقلی پیسو),
			},
		},
		'CUP' => {
			symbol => 'CUP',
			display_name => {
				'currency' => q(کیوبا کا پیسو),
				'one' => q(کیوبا کا پیسو),
				'other' => q(کیوبا کا پیسو),
			},
		},
		'CVE' => {
			symbol => 'CVE',
			display_name => {
				'currency' => q(کیپ ورڈی کا اسکیوڈو),
				'one' => q(کیپ ورڈی کا اسکیوڈو),
				'other' => q(کیپ ورڈی کا اسکیوڈو),
			},
		},
		'CZK' => {
			symbol => 'CZK',
			display_name => {
				'currency' => q(چیک کرونا),
				'one' => q(چیک کرونا),
				'other' => q(چیک کروناز),
			},
		},
		'DEM' => {
			display_name => {
				'currency' => q(ڈچ مارکس),
			},
		},
		'DJF' => {
			symbol => 'DJF',
			display_name => {
				'currency' => q(جبوتی فرانک),
				'one' => q(جبوتی فرانک),
				'other' => q(جبوتی فرانک),
			},
		},
		'DKK' => {
			symbol => 'DKK',
			display_name => {
				'currency' => q(ڈنمارک کرون),
				'one' => q(ڈنمارک کرون),
				'other' => q(ڈنمارک کرون),
			},
		},
		'DOP' => {
			symbol => 'DOP',
			display_name => {
				'currency' => q(ڈومنیکن پیسو),
				'one' => q(ڈومنیکن پیسو),
				'other' => q(ڈومنیکن پیسو),
			},
		},
		'DZD' => {
			symbol => 'DZD',
			display_name => {
				'currency' => q(الجیریائی دینار),
				'one' => q(الجیریائی دینار),
				'other' => q(الجیریائی دینار),
			},
		},
		'EEK' => {
			display_name => {
				'currency' => q(ایسٹونین کرون),
			},
		},
		'EGP' => {
			symbol => 'EGP',
			display_name => {
				'currency' => q(مصری پاؤنڈ),
				'one' => q(مصری پاؤنڈ),
				'other' => q(مصری پاؤنڈ),
			},
		},
		'ERN' => {
			symbol => 'ERN',
			display_name => {
				'currency' => q(اریٹیریائی ناکفا),
				'one' => q(اریٹیریائی ناکفا),
				'other' => q(اریٹیریائی ناکفا),
			},
		},
		'ETB' => {
			symbol => 'ETB',
			display_name => {
				'currency' => q(ایتھوپیائی بِرّ),
				'one' => q(ایتھوپیائی بِرّ),
				'other' => q(ایتھوپیائی بِرّ),
			},
		},
		'EUR' => {
			symbol => '€',
			display_name => {
				'currency' => q(یورو),
				'one' => q(یورو),
				'other' => q(یورو),
			},
		},
		'FJD' => {
			symbol => 'FJD',
			display_name => {
				'currency' => q(فجی کا ڈالر),
				'one' => q(فجی کا ڈالر),
				'other' => q(فجی کا ڈالر),
			},
		},
		'FKP' => {
			symbol => 'FKP',
			display_name => {
				'currency' => q(فاکلینڈ آئلینڈز پونڈ),
				'one' => q(فاکلینڈ آئلینڈز پونڈ),
				'other' => q(فاکلینڈ آئلینڈز پونڈ),
			},
		},
		'FRF' => {
			display_name => {
				'currency' => q(فرانسیسی فرانک),
			},
		},
		'GBP' => {
			symbol => '£',
			display_name => {
				'currency' => q(برطانوی پاؤنڈ),
				'one' => q(برطانوی پاؤنڈ),
				'other' => q(برطانوی پاؤنڈ),
			},
		},
		'GEL' => {
			symbol => 'GEL',
			display_name => {
				'currency' => q(جارجیائی لاری),
				'one' => q(جارجیائی لاری),
				'other' => q(جارجیائی لاری),
			},
		},
		'GHS' => {
			symbol => 'GHS',
			display_name => {
				'currency' => q(گھانا کا سیڈی),
				'one' => q(گھانا کا سیڈی),
				'other' => q(گھانا کا سیڈی),
			},
		},
		'GIP' => {
			symbol => 'GIP',
			display_name => {
				'currency' => q(جبل الطارق پونڈ),
				'one' => q(جبل الطارق پونڈ),
				'other' => q(جبل الطارق پونڈ),
			},
		},
		'GMD' => {
			symbol => 'GMD',
			display_name => {
				'currency' => q(گامبیا کا ڈلاسی),
				'one' => q(گامبیا کا ڈلاسی),
				'other' => q(گامبیا کا ڈلاسی),
			},
		},
		'GNF' => {
			symbol => 'GNF',
			display_name => {
				'currency' => q(گنی فرانک),
				'one' => q(گنی فرانک),
				'other' => q(گنی فرانک),
			},
		},
		'GTQ' => {
			symbol => 'GTQ',
			display_name => {
				'currency' => q(گواٹے مالا کا کوئٹزل),
				'one' => q(گواٹے مالا کا کوئٹزل),
				'other' => q(گواٹے مالا کا کوئٹزل),
			},
		},
		'GYD' => {
			symbol => 'GYD',
			display_name => {
				'currency' => q(گویانیز ڈالر),
				'one' => q(گویانیز ڈالر),
				'other' => q(گویانیز ڈالر),
			},
		},
		'HKD' => {
			symbol => 'HK$',
			display_name => {
				'currency' => q(ھانگ کانگ ڈالر),
				'one' => q(ھانگ کانگ ڈالر),
				'other' => q(ھانگ کانگ ڈالر),
			},
		},
		'HNL' => {
			symbol => 'HNL',
			display_name => {
				'currency' => q(ہونڈوران لیمپیرا),
				'one' => q(ہونڈوران لیمپیرا),
				'other' => q(ہونڈوران لیمپیرا),
			},
		},
		'HRK' => {
			symbol => 'HRK',
			display_name => {
				'currency' => q(کروشین کونا),
				'one' => q(کروشین کونا),
				'other' => q(کروشین کونا),
			},
		},
		'HTG' => {
			symbol => 'HTG',
			display_name => {
				'currency' => q(ہیتی کا گؤرڈی),
				'one' => q(ہیتی کا گؤرڈی),
				'other' => q(ہیتی کا گؤرڈی),
			},
		},
		'HUF' => {
			symbol => 'HUF',
			display_name => {
				'currency' => q(ہنگرین فورنٹ),
				'one' => q(ہنگرین فورنٹ),
				'other' => q(ہنگرین فورنٹ),
			},
		},
		'IDR' => {
			symbol => 'IDR',
			display_name => {
				'currency' => q(انڈونیشین روپیہ),
				'one' => q(انڈونیشین روپیہ),
				'other' => q(انڈونیشین روپیہ),
			},
		},
		'ILS' => {
			symbol => '₪',
			display_name => {
				'currency' => q(اسرائیلی نیا شیکل),
				'one' => q(اسرائیلی نیا شیکل),
				'other' => q(اسرائیلی نیا شیکلز),
			},
		},
		'INR' => {
			symbol => '₹',
			display_name => {
				'currency' => q(بھارتی روپیہ),
				'one' => q(بھارتی روپیہ),
				'other' => q(بھارتی روپے),
			},
		},
		'IQD' => {
			symbol => 'IQD',
			display_name => {
				'currency' => q(عراقی دینار),
				'one' => q(عراقی دینار),
				'other' => q(عراقی دینار),
			},
		},
		'IRR' => {
			symbol => 'IRR',
			display_name => {
				'currency' => q(ایرانی ریال),
				'one' => q(ایرانی ریال),
				'other' => q(ایرانی ریال),
			},
		},
		'ISK' => {
			symbol => 'ISK',
			display_name => {
				'currency' => q(آئس لينڈی کرونا),
				'one' => q(آئس لينڈی کرونا),
				'other' => q(آئس لينڈی کرونوں),
			},
		},
		'JMD' => {
			symbol => 'JMD',
			display_name => {
				'currency' => q(جمائیکن ڈالر),
				'one' => q(جمائیکن ڈالر),
				'other' => q(جمائیکن ڈالر),
			},
		},
		'JOD' => {
			symbol => 'JOD',
			display_name => {
				'currency' => q(اردنی دینار),
				'one' => q(اردنی دینار),
				'other' => q(اردنی دینار),
			},
		},
		'JPY' => {
			symbol => 'JP¥',
			display_name => {
				'currency' => q(جاپانی ین),
				'one' => q(جاپانی ین),
				'other' => q(جاپانی ین),
			},
		},
		'KES' => {
			symbol => 'KES',
			display_name => {
				'currency' => q(کینیائی شلنگ),
				'one' => q(کینیائی شلنگ),
				'other' => q(کینیائی شلنگ),
			},
		},
		'KGS' => {
			symbol => 'KGS',
			display_name => {
				'currency' => q(کرغستانی سوم),
				'one' => q(کرغستانی سوم),
				'other' => q(کرغستانی سوم),
			},
		},
		'KHR' => {
			symbol => 'KHR',
			display_name => {
				'currency' => q(کمبوڈیائی ریئل),
				'one' => q(کمبوڈیائی ریئل),
				'other' => q(کمبوڈیائی ریئل),
			},
		},
		'KMF' => {
			symbol => 'KMF',
			display_name => {
				'currency' => q(کوموریئن فرانک),
				'one' => q(کوموریئن فرانک),
				'other' => q(کوموریئن فرانک),
			},
		},
		'KPW' => {
			symbol => 'KPW',
			display_name => {
				'currency' => q(شمالی کوریائی وون),
				'one' => q(شمالی کوریائی وون),
				'other' => q(شمالی کوریائی وون),
			},
		},
		'KRW' => {
			symbol => '₩',
			display_name => {
				'currency' => q(جنوبی کوریائی وون),
				'one' => q(جنوبی کوریائی وون),
				'other' => q(جنوبی کوریائی وون),
			},
		},
		'KWD' => {
			symbol => 'KWD',
			display_name => {
				'currency' => q(کویتی دینار),
				'one' => q(کویتی دینار),
				'other' => q(کویتی دینار),
			},
		},
		'KYD' => {
			symbol => 'KYD',
			display_name => {
				'currency' => q(کیمین آئلینڈز ڈالر),
				'one' => q(کیمین آئلینڈز ڈالر),
				'other' => q(کیمین آئلینڈز ڈالر),
			},
		},
		'KZT' => {
			symbol => 'KZT',
			display_name => {
				'currency' => q(قزاخستانی ٹینگ),
				'one' => q(قزاخستانی ٹینگ),
				'other' => q(قزاخستانی ٹینگ),
			},
		},
		'LAK' => {
			symbol => 'LAK',
			display_name => {
				'currency' => q(لاؤشیائی کِپ),
				'one' => q(لاؤشیائی کِپ),
				'other' => q(لاؤشیائی کِپ),
			},
		},
		'LBP' => {
			symbol => 'LBP',
			display_name => {
				'currency' => q(لبنانی پونڈ),
				'one' => q(لبنانی پونڈ),
				'other' => q(لبنانی پونڈ),
			},
		},
		'LKR' => {
			symbol => 'LKR',
			display_name => {
				'currency' => q(سری لنکائی روپیہ),
				'one' => q(سری لنکائی روپیہ),
				'other' => q(سری لنکائی روپیہ),
			},
		},
		'LRD' => {
			symbol => 'LRD',
			display_name => {
				'currency' => q(لائبریائی ڈالر),
				'one' => q(لائبریائی ڈالر),
				'other' => q(لائبریائی ڈالر),
			},
		},
		'LSL' => {
			display_name => {
				'currency' => q(لیسوتھو لوتی),
				'one' => q(لیسوتھو لوتی),
				'other' => q(لیسوتھو لوتی),
			},
		},
		'LTL' => {
			symbol => 'LTL',
			display_name => {
				'currency' => q(لیتھوینیائی لیٹاس),
				'one' => q(لیتھوینیائی لیٹاس),
				'other' => q(لیتھوینیائی لیٹاس),
			},
		},
		'LVL' => {
			symbol => 'LVL',
			display_name => {
				'currency' => q(لاتویائی لیٹس),
				'one' => q(لاتویائی لیٹس),
				'other' => q(لاتویائی لیٹس),
			},
		},
		'LYD' => {
			symbol => 'LYD',
			display_name => {
				'currency' => q(لیبیائی دینار),
				'one' => q(لیبیائی دینار),
				'other' => q(لیبیائی دینار),
			},
		},
		'MAD' => {
			symbol => 'MAD',
			display_name => {
				'currency' => q(مراکشی درہم),
				'one' => q(مراکشی درہم),
				'other' => q(مراکشی درہم),
			},
		},
		'MDL' => {
			symbol => 'MDL',
			display_name => {
				'currency' => q(مالدووی لیو),
				'one' => q(مالدووی لیو),
				'other' => q(مالدووی لیو),
			},
		},
		'MGA' => {
			symbol => 'MGA',
			display_name => {
				'currency' => q(ملاگاسی اریاری),
				'one' => q(ملاگاسی اریاری),
				'other' => q(ملاگاسی اریاری),
			},
		},
		'MKD' => {
			symbol => 'MKD',
			display_name => {
				'currency' => q(مقدونیائی دینار),
				'one' => q(مقدونیائی دینار),
				'other' => q(مقدونیائی دینار),
			},
		},
		'MMK' => {
			symbol => 'MMK',
			display_name => {
				'currency' => q(میانمار کیاٹ),
				'one' => q(میانمار کیاٹ),
				'other' => q(میانمار کیاٹ),
			},
		},
		'MNT' => {
			symbol => 'MNT',
			display_name => {
				'currency' => q(منگولیائی ٹگرِ),
				'one' => q(منگولیائی ٹگرِ),
				'other' => q(منگولیائی ٹگرِ),
			},
		},
		'MOP' => {
			symbol => 'MOP',
			display_name => {
				'currency' => q(میکانیز پٹاکا),
				'one' => q(میکانیز پٹاکا),
				'other' => q(میکانیز پٹاکا),
			},
		},
		'MRO' => {
			symbol => 'MRO',
			display_name => {
				'currency' => q(موریطانیائی اوگوئیا \(1973–2017\)),
				'one' => q(موریطانیائی اوگوئیا \(1973–2017\)),
				'other' => q(موریطانیائی اوگوئیا \(1973–2017\)),
			},
		},
		'MRU' => {
			symbol => 'MRU',
			display_name => {
				'currency' => q(موریطانیائی اوگوئیا),
				'one' => q(موریطانیائی اوگوئیا),
				'other' => q(موریطانیائی اوگوئیا),
			},
		},
		'MUR' => {
			symbol => 'MUR',
			display_name => {
				'currency' => q(ماریشس کا روپیہ),
				'one' => q(ماریشس کا روپیہ),
				'other' => q(ماریشس کا روپیہ),
			},
		},
		'MVR' => {
			symbol => 'MVR',
			display_name => {
				'currency' => q(مالدیپ کا روفیہ),
				'one' => q(مالدیپ کا روفیہ),
				'other' => q(مالدیپ کا روفیہ),
			},
		},
		'MWK' => {
			symbol => 'MWK',
			display_name => {
				'currency' => q(ملاوی کواچا),
				'one' => q(ملاوی کواچا),
				'other' => q(ملاوی کواچا),
			},
		},
		'MXN' => {
			symbol => 'MX$',
			display_name => {
				'currency' => q(میکسیکی پیسہ),
				'one' => q(میکسیکی پیسہ),
				'other' => q(میکسیکی پیسہ),
			},
		},
		'MYR' => {
			symbol => 'MYR',
			display_name => {
				'currency' => q(ملیشیائی رنگِٹ),
				'one' => q(ملیشیائی رنگِٹ),
				'other' => q(ملیشیائی رنگِٹ),
			},
		},
		'MZN' => {
			symbol => 'MZN',
			display_name => {
				'currency' => q(موزامبیقی میٹیکل),
				'one' => q(موزامبیقی میٹیکل),
				'other' => q(موزامبیقی میٹیکلز),
			},
		},
		'NAD' => {
			symbol => 'NAD',
			display_name => {
				'currency' => q(نامیبیائی ڈالر),
				'one' => q(نامیبیائی ڈالر),
				'other' => q(نامیبیائی ڈالر),
			},
		},
		'NGN' => {
			symbol => 'NGN',
			display_name => {
				'currency' => q(نائیجیریائی نائرا),
				'one' => q(نائیجیریائی نائرا),
				'other' => q(نائیجیریائی نائرا),
			},
		},
		'NIO' => {
			symbol => 'NIO',
			display_name => {
				'currency' => q(نکارا گوا کا کورڈوبا),
				'one' => q(نکارا گوا کا کورڈوبا),
				'other' => q(نکارا گوا کا کورڈوبا),
			},
		},
		'NOK' => {
			symbol => 'NOK',
			display_name => {
				'currency' => q(ناروے کرون),
				'one' => q(ناروے کرون),
				'other' => q(ناروے کرون),
			},
		},
		'NPR' => {
			symbol => 'NPR',
			display_name => {
				'currency' => q(نیپالی روپیہ),
				'one' => q(نیپالی روپیہ),
				'other' => q(نیپالی روپیہ),
			},
		},
		'NZD' => {
			symbol => 'NZ$',
			display_name => {
				'currency' => q(نیوزی لینڈ ڈالر),
				'one' => q(نیوزی لینڈ ڈالر),
				'other' => q(نیوزی لینڈ ڈالر),
			},
		},
		'OMR' => {
			symbol => 'OMR',
			display_name => {
				'currency' => q(عمانی ریال),
				'one' => q(عمانی ریال),
				'other' => q(عمانی ریال),
			},
		},
		'PAB' => {
			symbol => 'PAB',
			display_name => {
				'currency' => q(پنامہ کا بالبوآ),
				'one' => q(پنامہ کا بالبوآ),
				'other' => q(پنامہ کا بالبوآ),
			},
		},
		'PEN' => {
			symbol => 'PEN',
			display_name => {
				'currency' => q(پیروویئن سول),
				'one' => q(پیروویئن سول),
				'other' => q(پیروویئن سول),
			},
		},
		'PGK' => {
			symbol => 'PGK',
			display_name => {
				'currency' => q(پاپوآ نیو گنی کا کینا),
				'one' => q(پاپوآ نیو گنی کا کینا),
				'other' => q(پاپوآ نیو گنی کا کینا),
			},
		},
		'PHP' => {
			symbol => 'PHP',
			display_name => {
				'currency' => q(فلپائینی پیسہ),
				'one' => q(فلپائینی پیسہ),
				'other' => q(فلپائنی پیسو),
			},
		},
		'PKR' => {
			symbol => 'Rs',
			display_name => {
				'currency' => q(پاکستانی روپیہ),
				'one' => q(پاکستانی روپیہ),
				'other' => q(پاکستانی روپیہ),
			},
		},
		'PLN' => {
			symbol => 'PLN',
			display_name => {
				'currency' => q(پولش زلوٹی),
				'one' => q(پولش زلوٹی),
				'other' => q(پولش زلوٹی),
			},
		},
		'PYG' => {
			symbol => 'PYG',
			display_name => {
				'currency' => q(پیراگوئے کا گوآرنی),
				'one' => q(پیراگوئے کا گوآرنی),
				'other' => q(پیراگوئے کا گوآرنی),
			},
		},
		'QAR' => {
			symbol => 'QAR',
			display_name => {
				'currency' => q(قطری ریال),
				'one' => q(قطری ریال),
				'other' => q(قطری ریال),
			},
		},
		'RON' => {
			symbol => 'RON',
			display_name => {
				'currency' => q(رومانیائی لیو),
				'one' => q(رومانیائی لیو),
				'other' => q(رومانیائی لی),
			},
		},
		'RSD' => {
			symbol => 'RSD',
			display_name => {
				'currency' => q(سربین دینار),
				'one' => q(سربین دینار),
				'other' => q(سربین دینار),
			},
		},
		'RUB' => {
			symbol => 'RUB',
			display_name => {
				'currency' => q(روسی روبل),
				'one' => q(روسی روبل),
				'other' => q(روسی روبل),
			},
		},
		'RWF' => {
			symbol => 'RWF',
			display_name => {
				'currency' => q(روانڈا کا فرانک),
				'one' => q(روانڈا کا فرانک),
				'other' => q(روانڈا کا فرانک),
			},
		},
		'SAR' => {
			symbol => 'SAR',
			display_name => {
				'currency' => q(سعودی ریال),
				'one' => q(سعودی ریال),
				'other' => q(سعودی ریال),
			},
		},
		'SBD' => {
			symbol => 'SBD',
			display_name => {
				'currency' => q(سولومن آئلینڈز ڈالر),
				'one' => q(سولومن آئلینڈز ڈالر),
				'other' => q(سولومن آئلینڈز ڈالر),
			},
		},
		'SCR' => {
			symbol => 'SCR',
			display_name => {
				'currency' => q(سشلی کا روپیہ),
				'one' => q(سشلی کا روپیہ),
				'other' => q(سشلی کا روپیہ),
			},
		},
		'SDG' => {
			symbol => 'SDG',
			display_name => {
				'currency' => q(سوڈانی پاؤنڈ),
				'one' => q(سوڈانی پاؤنڈ),
				'other' => q(سوڈانی پاؤنڈ),
			},
		},
		'SEK' => {
			symbol => 'SEK',
			display_name => {
				'currency' => q(سویڈن کرونا),
				'one' => q(سویڈن کرونا),
				'other' => q(سویڈن کرونر),
			},
		},
		'SGD' => {
			symbol => 'SGD',
			display_name => {
				'currency' => q(سنگا پور ڈالر),
				'one' => q(سنگا پور ڈالر),
				'other' => q(سنگا پور ڈالر),
			},
		},
		'SHP' => {
			symbol => 'SHP',
			display_name => {
				'currency' => q(سینٹ ہیلینا پاؤنڈ),
				'one' => q(سینٹ ہیلینا پاؤنڈ),
				'other' => q(سینٹ ہیلینا پاؤنڈ),
			},
		},
		'SIT' => {
			display_name => {
				'currency' => q(سلوانین ٹولر),
			},
		},
		'SKK' => {
			display_name => {
				'currency' => q(سلووک کرونا),
			},
		},
		'SLL' => {
			symbol => 'SLL',
			display_name => {
				'currency' => q(سیئرا لیونین لیون),
				'one' => q(سیئرا لیونین لیون),
				'other' => q(سیئرا لیونین لیون),
			},
		},
		'SOS' => {
			symbol => 'SOS',
			display_name => {
				'currency' => q(صومالی شلنگ),
				'one' => q(صومالی شلنگ),
				'other' => q(صومالی شلنگ),
			},
		},
		'SRD' => {
			symbol => 'SRD',
			display_name => {
				'currency' => q(سورینامی ڈالر),
				'one' => q(سورینامی ڈالر),
				'other' => q(سورینامی ڈالر),
			},
		},
		'SSP' => {
			symbol => 'SSP',
			display_name => {
				'currency' => q(جنوبی سوڈانی پاؤنڈ),
				'one' => q(جنوبی سوڈانی پاؤنڈ),
				'other' => q(جنوبی سوڈانی پاؤنڈز),
			},
		},
		'STD' => {
			symbol => 'STD',
			display_name => {
				'currency' => q(ساؤ ٹوم اور پرنسپے ڈوبرا \(1977–2017\)),
				'one' => q(ساؤ ٹوم اور پرنسپے ڈوبرا \(1977–2017\)),
				'other' => q(ساؤ ٹوم اور پرنسپے ڈوبرا \(1977–2017\)),
			},
		},
		'STN' => {
			symbol => 'STN',
			display_name => {
				'currency' => q(ساؤ ٹومے اور پرنسپے ڈوبرا),
				'one' => q(ساؤ ٹومے اور پرنسپے ڈوبرا),
				'other' => q(ساؤ ٹومے اور پرنسپے ڈوبرا),
			},
		},
		'SYP' => {
			symbol => 'SYP',
			display_name => {
				'currency' => q(شامی پونڈ),
				'one' => q(شامی پونڈ),
				'other' => q(شامی پونڈ),
			},
		},
		'SZL' => {
			symbol => 'SZL',
			display_name => {
				'currency' => q(سوازی لیلانجینی),
				'one' => q(سوازی لیلانجینی),
				'other' => q(سوازی لیلانجینی),
			},
		},
		'THB' => {
			symbol => '฿',
			display_name => {
				'currency' => q(تھائی باہت),
				'one' => q(تھائی باہت),
				'other' => q(تھائی باہت),
			},
		},
		'TJS' => {
			symbol => 'TJS',
			display_name => {
				'currency' => q(تاجکستانی سومونی),
				'one' => q(تاجکستانی سومونی),
				'other' => q(تاجکستانی سومونی),
			},
		},
		'TMT' => {
			symbol => 'TMT',
			display_name => {
				'currency' => q(ترکمانستانی منات),
				'one' => q(ترکمانستانی منات),
				'other' => q(ترکمانستانی منات),
			},
		},
		'TND' => {
			symbol => 'TND',
			display_name => {
				'currency' => q(تیونیسیائی دینار),
				'one' => q(تیونیسیائی دینار),
				'other' => q(تیونیسیائی دینار),
			},
		},
		'TOP' => {
			symbol => 'TOP',
			display_name => {
				'currency' => q(ٹونگن پانگا),
				'one' => q(ٹونگن پانگا),
				'other' => q(ٹونگن پانگا),
			},
		},
		'TRY' => {
			symbol => 'TRY',
			display_name => {
				'currency' => q(ترکی لیرا),
				'one' => q(ترکی لیرا),
				'other' => q(ترکی لیرا),
			},
		},
		'TTD' => {
			symbol => 'TTD',
			display_name => {
				'currency' => q(ترینیداد اور ٹوباگو کا ڈالر),
				'one' => q(ترینیداد اور ٹوباگو کا ڈالر),
				'other' => q(ترینیداد اور ٹوباگو کا ڈالر),
			},
		},
		'TWD' => {
			symbol => 'NT$',
			display_name => {
				'currency' => q(نیو تائیوان ڈالر),
				'one' => q(نیو تائیوان ڈالر),
				'other' => q(نیو تائیوان ڈالر),
			},
		},
		'TZS' => {
			symbol => 'TZS',
			display_name => {
				'currency' => q(تنزانیائی شلنگ),
				'one' => q(تنزانیائی شلنگ),
				'other' => q(تنزانیائی شلنگ),
			},
		},
		'UAH' => {
			symbol => 'UAH',
			display_name => {
				'currency' => q(یوکرینیائی ہریونیا),
				'one' => q(یوکرینیائی ہریونیا),
				'other' => q(یوکرینیائی ہریونیا),
			},
		},
		'UGX' => {
			symbol => 'UGX',
			display_name => {
				'currency' => q(یوگانڈا شلنگ),
				'one' => q(یوگانڈا شلنگ),
				'other' => q(یوگانڈا شلنگ),
			},
		},
		'USD' => {
			symbol => '$',
			display_name => {
				'currency' => q(امریکی ڈالر),
				'one' => q(امریکی ڈالر),
				'other' => q(امریکی ڈالر),
			},
		},
		'UYU' => {
			symbol => 'UYU',
			display_name => {
				'currency' => q(یوروگویان پیسو),
				'one' => q(یوروگویان پیسو),
				'other' => q(یوروگویان پیسو),
			},
		},
		'UZS' => {
			symbol => 'UZS',
			display_name => {
				'currency' => q(ازبکستانی سوم),
				'one' => q(ازبکستانی سوم),
				'other' => q(ازبکستانی سوم),
			},
		},
		'VEB' => {
			display_name => {
				'currency' => q(وینزویلا بولیور \(1871–2008\)),
			},
		},
		'VEF' => {
			symbol => 'VEF',
			display_name => {
				'currency' => q(وینزویلا بولیور \(2008–2018\)),
				'one' => q(وینزویلا بولیور \(2008–2018\)),
				'other' => q(وینزویلا بولیور \(2008–2018\)),
			},
		},
		'VES' => {
			symbol => 'VES',
			display_name => {
				'currency' => q(وینزویلا بولیور),
				'one' => q(وینزویلا بولیور),
				'other' => q(وینزویلا بولیور),
			},
		},
		'VND' => {
			symbol => '₫',
			display_name => {
				'currency' => q(ویتنامی ڈانگ),
				'one' => q(ویتنامی ڈانگ),
				'other' => q(ویتنامی ڈانگ),
			},
		},
		'VUV' => {
			symbol => 'VUV',
			display_name => {
				'currency' => q(وینوواتو واتو),
				'one' => q(وینوواتو واتو),
				'other' => q(وینوواتو واتو),
			},
		},
		'WST' => {
			symbol => 'WST',
			display_name => {
				'currency' => q(ساموآ کا ٹالا),
				'one' => q(ساموآ کا ٹالا),
				'other' => q(ساموآ کا ٹالا),
			},
		},
		'XAF' => {
			symbol => 'FCFA',
			display_name => {
				'currency' => q(وسطی افریقی [CFA] فرانک),
				'one' => q(وسطی افریقی [CFA] فرانک),
				'other' => q(وسطی افریقی [CFA] فرانک),
			},
		},
		'XCD' => {
			symbol => 'EC$',
			display_name => {
				'currency' => q(مشرقی کریبیا کا ڈالر),
				'one' => q(مشرقی کریبیا کا ڈالر),
				'other' => q(مشرقی کریبیا کا ڈالر),
			},
		},
		'XOF' => {
			symbol => 'F CFA',
			display_name => {
				'currency' => q(مغربی افریقی [CFA] فرانک),
				'one' => q(مغربی افریقی [CFA] فرانک),
				'other' => q(مغربی افریقی [CFA] فرانک),
			},
		},
		'XPF' => {
			symbol => 'CFPF',
			display_name => {
				'currency' => q(CFP فرانک),
				'one' => q(CFP فرانک),
				'other' => q(CFP فرانکس),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(نامعلوم کرنسی),
				'one' => q(\(کرنسی کی نامعلوم یونٹ\)),
				'other' => q(\(نامعلوم کرنسی\)),
			},
		},
		'YER' => {
			symbol => 'YER',
			display_name => {
				'currency' => q(یمنی ریال),
				'one' => q(یمنی ریال),
				'other' => q(یمنی ریال),
			},
		},
		'ZAR' => {
			symbol => 'ZAR',
			display_name => {
				'currency' => q(جنوبی افریقی رانڈ),
				'one' => q(جنوبی افریقی رانڈ),
				'other' => q(جنوبی افریقی رانڈ),
			},
		},
		'ZMK' => {
			display_name => {
				'currency' => q(زامبیائی کواچا \(1968–2012\)),
			},
		},
		'ZMW' => {
			symbol => 'ZMW',
			display_name => {
				'currency' => q(زامبیائی کواچا),
				'one' => q(زامبیائی کواچا),
				'other' => q(زامبیائی کواچا),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'coptic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'ٹاؤٹ',
							'بابا',
							'ہیٹر',
							'کیاہک',
							'توبا',
							'امشیر',
							'برمہات',
							'برموڈا',
							'بشانس',
							'پاؤنا',
							'ایپپ',
							'میسرا',
							'ناسی'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ٹاؤٹ',
							'بابا',
							'ہیٹر',
							'کیاہک',
							'توبا',
							'امشیر',
							'برمہات',
							'برموڈا',
							'بشانس',
							'پاؤنا',
							'ایپپ',
							'میسرا',
							'ناسی'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'ٹاؤٹ',
							'بابا',
							'ہیٹر',
							'کیاہک',
							'توبا',
							'امشیر',
							'برمہات',
							'برموڈا',
							'بشانس',
							'پاؤنا',
							'ایپپ',
							'میسرا',
							'ناسی'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ٹاؤٹ',
							'بابا',
							'ہیٹر',
							'کیاہک',
							'توبا',
							'امشیر',
							'برمہات',
							'برموڈا',
							'بشانس',
							'پاؤنا',
							'ایپپ',
							'میسرا',
							'ناسی'
						],
						leap => [
							
						],
					},
				},
			},
			'ethiopic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'مسکرم',
							'تیکیمت',
							'ہیدر',
							'تہساس',
							'تیر',
							'یکاتیت',
							'میگابت',
							'میازیا',
							'گیمبوٹ',
							'سینے',
							'ہیملے',
							'نیہاسے',
							'پیگیومین'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'مسکرم',
							'تیکیمت',
							'ہیدر',
							'تہساس',
							'تیر',
							'یکاتیت',
							'میگابت',
							'میازیا',
							'گیمبوٹ',
							'سینے',
							'ہیملے',
							'نیہاسے',
							'پیگیومین'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'مسکرم',
							'تیکیمت',
							'ہیدر',
							'تہساس',
							'تیر',
							'یکاتیت',
							'میگابت',
							'میازیا',
							'گیمبوٹ',
							'سینے',
							'ہیملے',
							'نیہاسے',
							'پیگیومین'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'مسکرم',
							'تیکیمت',
							'ہیدر',
							'تہساس',
							'تیر',
							'یکاتیت',
							'میگابت',
							'میازیا',
							'گیمبوٹ',
							'سینے',
							'ہیملے',
							'نیہاسے',
							'پیگیومین'
						],
						leap => [
							
						],
					},
				},
			},
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'جنوری',
							'فروری',
							'مارچ',
							'اپریل',
							'مئی',
							'جون',
							'جولائی',
							'اگست',
							'ستمبر',
							'اکتوبر',
							'نومبر',
							'دسمبر'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'J',
							'F',
							'M',
							'A',
							'M',
							'J',
							'J',
							'A',
							'S',
							'O',
							'N',
							'D'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'جنوری',
							'فروری',
							'مارچ',
							'اپریل',
							'مئی',
							'جون',
							'جولائی',
							'اگست',
							'ستمبر',
							'اکتوبر',
							'نومبر',
							'دسمبر'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'جنوری',
							'فروری',
							'مارچ',
							'اپریل',
							'مئی',
							'جون',
							'جولائی',
							'اگست',
							'ستمبر',
							'اکتوبر',
							'نومبر',
							'دسمبر'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'J',
							'F',
							'M',
							'A',
							'M',
							'J',
							'J',
							'A',
							'S',
							'O',
							'N',
							'D'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'جنوری',
							'فروری',
							'مارچ',
							'اپریل',
							'مئی',
							'جون',
							'جولائی',
							'اگست',
							'ستمبر',
							'اکتوبر',
							'نومبر',
							'دسمبر'
						],
						leap => [
							
						],
					},
				},
			},
			'hebrew' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'ٹشری',
							'هےشوان',
							'کسلیو',
							'تیویت',
							'شیوت',
							'آدر اوّل',
							'آدر',
							'نسان',
							'ایئر',
							'سیون',
							'تموز',
							'او',
							'ای لول'
						],
						leap => [
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							
						],
					},
					wide => {
						nonleap => [
							'ٹشری',
							'هےشوان',
							'کسلیو',
							'تیویت',
							'شیوت',
							'آدر اوّل',
							'آدر',
							'نسان',
							'ایئر',
							'سیون',
							'تموز',
							'او',
							'ای لول'
						],
						leap => [
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'ٹشری',
							'هےشوان',
							'کسلیو',
							'تیویت',
							'شیوت',
							'آدر اوّل',
							'آدر',
							'نسان',
							'ایئر',
							'سیون',
							'تموز',
							'او',
							'ای لول'
						],
						leap => [
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							
						],
					},
					wide => {
						nonleap => [
							'ٹشری',
							'هےشوان',
							'کسلیو',
							'تیویت',
							'شیوت',
							'آدر اوّل',
							'آدر',
							'نسان',
							'ایئر',
							'سیون',
							'تموز',
							'او',
							'ای لول'
						],
						leap => [
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							
						],
					},
				},
			},
			'indian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'چتررا',
							'ویساکھا',
							'جیہائشہ',
							'اسدھا',
							'سراؤنا',
							'بھدرا',
							'اسوینا',
							'کارتیکا',
							'اگراہانا',
							'پوسا',
							'میگا',
							'پھالگنا'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'چتررا',
							'ویساکھا',
							'جیہائشہ',
							'اسدھا',
							'سراؤنا',
							'بھدرا',
							'اسوینا',
							'کارتیکا',
							'اگراہانا',
							'پوسا',
							'میگا',
							'پھالگنا'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'چتررا',
							'ویساکھا',
							'جیہائشہ',
							'اسدھا',
							'سراؤنا',
							'بھدرا',
							'اسوینا',
							'کارتیکا',
							'اگراہانا',
							'پوسا',
							'میگا',
							'پھالگنا'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'چتررا',
							'ویساکھا',
							'جیہائشہ',
							'اسدھا',
							'سراؤنا',
							'بھدرا',
							'اسوینا',
							'کارتیکا',
							'اگراہانا',
							'پوسا',
							'میگا',
							'پھالگنا'
						],
						leap => [
							
						],
					},
				},
			},
			'islamic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'محرم',
							'صفر',
							'ربیع الاوّل',
							'ربیع الثانی',
							'جمادی الاوّل',
							'جمادی الثانی',
							'رجب',
							'شعبان',
							'رمضان',
							'شوال',
							'ذوالقعدۃ',
							'ذوالحجۃ'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'محرم',
							'صفر',
							'ر بیع الاول',
							'ر بیع الثانی',
							'جمادی الاول',
							'جمادی الثانی',
							'رجب',
							'شعبان',
							'رمضان',
							'شوال',
							'ذوالقعدۃ',
							'ذوالحجۃ'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'محرم',
							'صفر',
							'ربیع الاوّل',
							'ربیع الثّانی',
							'جمادی الاوّل',
							'جمادی الثّانی',
							'رجب',
							'شعبان',
							'رمضان',
							'شوال',
							'ذوالقعدۃ',
							'ذوالحجۃ'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'محرم',
							'صفر',
							'ر بیع الاول',
							'ر بیع الثانی',
							'جمادی الاول',
							'جمادی الثانی',
							'رجب',
							'شعبان',
							'رمضان',
							'شوال',
							'ذوالقعدۃ',
							'ذوالحجۃ'
						],
						leap => [
							
						],
					},
				},
			},
			'persian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'فروردن',
							'آرڈبائش',
							'خداداد',
							'تیر',
							'مرداد',
							'شہریوار',
							'مہر',
							'ابان',
							'آزر',
							'ڈے',
							'بہمن',
							'اسفند'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'فروردن',
							'آرڈبائش',
							'خداداد',
							'تیر',
							'مرداد',
							'شہریوار',
							'مہر',
							'ابان',
							'آزر',
							'ڈے',
							'بہمن',
							'اسفند'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'فروردن',
							'آرڈبائش',
							'خداداد',
							'تیر',
							'مرداد',
							'شہریوار',
							'مہر',
							'ابان',
							'آزر',
							'ڈے',
							'بہمن',
							'اسفند'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'فروردن',
							'آرڈبائش',
							'خداداد',
							'تیر',
							'مرداد',
							'شہریوار',
							'مہر',
							'ابان',
							'آزر',
							'ڈے',
							'بہمن',
							'اسفند'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'پیر',
						tue => 'منگل',
						wed => 'بدھ',
						thu => 'جمعرات',
						fri => 'جمعہ',
						sat => 'ہفتہ',
						sun => 'اتوار'
					},
					narrow => {
						mon => 'M',
						tue => 'T',
						wed => 'W',
						thu => 'T',
						fri => 'F',
						sat => 'S',
						sun => 'S'
					},
					short => {
						mon => 'پیر',
						tue => 'منگل',
						wed => 'بدھ',
						thu => 'جمعرات',
						fri => 'جمعہ',
						sat => 'ہفتہ',
						sun => 'اتوار'
					},
					wide => {
						mon => 'پیر',
						tue => 'منگل',
						wed => 'بدھ',
						thu => 'جمعرات',
						fri => 'جمعہ',
						sat => 'ہفتہ',
						sun => 'اتوار'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'پیر',
						tue => 'منگل',
						wed => 'بدھ',
						thu => 'جمعرات',
						fri => 'جمعہ',
						sat => 'ہفتہ',
						sun => 'اتوار'
					},
					narrow => {
						mon => 'M',
						tue => 'T',
						wed => 'W',
						thu => 'T',
						fri => 'F',
						sat => 'S',
						sun => 'S'
					},
					short => {
						mon => 'پیر',
						tue => 'منگل',
						wed => 'بدھ',
						thu => 'جمعرات',
						fri => 'جمعہ',
						sat => 'ہفتہ',
						sun => 'اتوار'
					},
					wide => {
						mon => 'پیر',
						tue => 'منگل',
						wed => 'بدھ',
						thu => 'جمعرات',
						fri => 'جمعہ',
						sat => 'ہفتہ',
						sun => 'اتوار'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'پہلی سہ ماہی',
						1 => 'دوسری سہ ماہی',
						2 => 'تیسری سہ ماہی',
						3 => 'چوتهی سہ ماہی'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => 'پہلی سہ ماہی',
						1 => 'دوسری سہ ماہی',
						2 => 'تیسری سہ ماہی',
						3 => 'چوتهی سہ ماہی'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => 'پہلی سہ ماہی',
						1 => 'دوسری سہ ماہی',
						2 => 'تیسری سہ ماہی',
						3 => 'چوتهی سہ ماہی'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => 'پہلی سہ ماہی',
						1 => 'دوسری سہ ماہی',
						2 => 'تیسری سہ ماہی',
						3 => 'چوتهی سہ ماہی'
					},
				},
			},
	} },
);

has 'day_period_data' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub { sub {
		# Time in hhmm format
		my ($self, $type, $time, $day_period_type) = @_;
		$day_period_type //= 'default';
		SWITCH:
		for ($type) {
			if ($_ eq 'buddhist') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'coptic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'ethiopic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'generic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'gregorian') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'hebrew') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'indian') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'islamic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'persian') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				last SWITCH;
				}
			if ($_ eq 'roc') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
				}
				last SWITCH;
				}
		}
	} },
);

around day_period_data => sub {
    my ($orig, $self) = @_;
    return $self->$orig;
};

has 'day_periods' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'abbreviated' => {
					'afternoon1' => q{دوپہر},
					'afternoon2' => q{سہ پہر},
					'am' => q{AM},
					'evening1' => q{شام},
					'midnight' => q{آدھی رات},
					'morning1' => q{صبح},
					'night1' => q{رات},
					'pm' => q{PM},
				},
				'narrow' => {
					'afternoon1' => q{دوپہر},
					'afternoon2' => q{سہ پہر},
					'am' => q{a},
					'evening1' => q{شام},
					'midnight' => q{آدھی رات},
					'morning1' => q{صبح},
					'night1' => q{رات},
					'pm' => q{p},
				},
				'wide' => {
					'afternoon1' => q{دوپہر میں},
					'afternoon2' => q{سہ پہر},
					'am' => q{AM},
					'evening1' => q{شام میں},
					'midnight' => q{آدھی رات},
					'morning1' => q{صبح میں},
					'night1' => q{رات میں},
					'pm' => q{PM},
				},
			},
			'stand-alone' => {
				'abbreviated' => {
					'afternoon1' => q{دوپہر},
					'afternoon2' => q{سہ پہر},
					'am' => q{AM},
					'evening1' => q{شام},
					'midnight' => q{آدھی رات},
					'morning1' => q{صبح},
					'night1' => q{رات},
					'pm' => q{PM},
				},
				'narrow' => {
					'afternoon1' => q{دوپہر},
					'afternoon2' => q{سہ پہر},
					'am' => q{AM},
					'evening1' => q{شام},
					'midnight' => q{آدھی رات},
					'morning1' => q{صبح},
					'night1' => q{رات},
					'pm' => q{PM},
				},
				'wide' => {
					'afternoon1' => q{دوپہر},
					'afternoon2' => q{سہ پہر},
					'am' => q{AM},
					'evening1' => q{شام},
					'midnight' => q{آدھی رات},
					'morning1' => q{صبح},
					'night1' => q{رات},
					'pm' => q{PM},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
			abbreviated => {
				'0' => 'BE'
			},
			narrow => {
				'0' => 'BE'
			},
			wide => {
				'0' => 'BE'
			},
		},
		'coptic' => {
			abbreviated => {
				'0' => 'دور0',
				'1' => 'دور1'
			},
			narrow => {
				'0' => 'دور0',
				'1' => 'دور1'
			},
			wide => {
				'0' => 'دور0',
				'1' => 'دور1'
			},
		},
		'ethiopic' => {
			abbreviated => {
				'0' => 'دور0',
				'1' => 'دور1'
			},
			narrow => {
				'0' => 'دور0',
				'1' => 'دور1'
			},
			wide => {
				'0' => 'دور0',
				'1' => 'دور1'
			},
		},
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'قبل مسیح',
				'1' => 'عیسوی'
			},
			wide => {
				'0' => 'قبل مسیح',
				'1' => 'عیسوی'
			},
		},
		'hebrew' => {
			abbreviated => {
				'0' => 'AM'
			},
			narrow => {
				'0' => 'AM'
			},
			wide => {
				'0' => 'AM'
			},
		},
		'indian' => {
			abbreviated => {
				'0' => 'ساکا'
			},
			narrow => {
				'0' => 'ساکا'
			},
			wide => {
				'0' => 'ساکا'
			},
		},
		'islamic' => {
			abbreviated => {
				'0' => 'ہجری'
			},
			narrow => {
				'0' => 'ہجری'
			},
			wide => {
				'0' => 'ہجری'
			},
		},
		'persian' => {
			abbreviated => {
				'0' => 'AP'
			},
			narrow => {
				'0' => 'AP'
			},
			wide => {
				'0' => 'AP'
			},
		},
		'roc' => {
			abbreviated => {
				'0' => 'قبل از جمہوریہ چین',
				'1' => 'جمہوریہ چین'
			},
			narrow => {
				'0' => 'قبل از جمہوریہ چین',
				'1' => 'جمہوریہ چین'
			},
			wide => {
				'0' => 'قبل از جمہوریہ چین',
				'1' => 'جمہوریہ چین'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
			'full' => q{EEEE، d MMMM، y G},
			'long' => q{d MMMM، y G},
			'medium' => q{d MMM، y G},
			'short' => q{d/M/y GGGGG},
		},
		'gregorian' => {
			'full' => q{EEEE، d MMMM، y},
			'long' => q{d MMMM، y},
			'medium' => q{d MMM، y},
			'short' => q{d/M/yy},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
		},
		'gregorian' => {
			'full' => q{h:mm:ss a zzzz},
			'long' => q{h:mm:ss a z},
			'medium' => q{h:mm:ss a},
			'short' => q{h:mm a},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'gregorian' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Bh => q{h B},
			Bhm => q{h:mm B},
			Bhms => q{h:mm:ss B},
			E => q{ccc},
			EBhm => q{E h:mm B},
			EBhms => q{E h:mm:ss B},
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{d E},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{y G},
			GyMMM => q{MMM y G},
			GyMMMEd => q{E، d MMM، y G},
			GyMMMd => q{d MMM، y G},
			GyMd => q{d/M/y GGGGG},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{E، d/M},
			MMM => q{LLL},
			MMMEd => q{E، d MMM},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			Md => q{d/M},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{y G},
			yyyy => q{y G},
			yyyyM => q{M/y G},
			yyyyMEd => q{E، d/M/y G},
			yyyyMMM => q{MMM y G},
			yyyyMMMEd => q{E، d MMM، y G},
			yyyyMMMM => q{MMMM y G},
			yyyyMMMd => q{d MMM، y G},
			yyyyMd => q{d/M/y G},
			yyyyQQQ => q{QQQ y G},
			yyyyQQQQ => q{QQQQ y G},
		},
		'gregorian' => {
			Bh => q{h B},
			Bhm => q{h:mm B},
			Bhms => q{h:mm:ss B},
			E => q{ccc},
			EBhm => q{E h:mm B},
			EBhms => q{E h:mm:ss B},
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{d E},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{y G},
			GyMMM => q{MMM y G},
			GyMMMEd => q{E، d MMM، y G},
			GyMMMd => q{d MMM، y G},
			GyMd => q{d/M/y GGGGG},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			Hmsv => q{HH:mm:ss v},
			Hmv => q{HH:mm v},
			M => q{L},
			MEd => q{E، d/M},
			MMM => q{LLL},
			MMMEd => q{E، d MMM},
			MMMMW => q{MMMM کا ہفتہ W},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			Md => q{d/M},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			hmsv => q{h:mm:ss a v},
			hmv => q{h:mm a v},
			ms => q{mm:ss},
			y => q{y},
			yM => q{M/y},
			yMEd => q{E، d/M/y},
			yMMM => q{MMM y},
			yMMMEd => q{E، d MMM، y},
			yMMMM => q{MMMM y},
			yMMMd => q{d MMM، y},
			yMd => q{d/M/y},
			yQQQ => q{QQQ y},
			yQQQQ => q{QQQQ y},
			yw => q{Y کا w ہفتہ},
		},
		'islamic' => {
			GyMd => q{d/M/y GGGGG},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'Timezone' => '{0} {1}',
		},
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Bh => {
				B => q{h B – h B},
				h => q{h–h B},
			},
			Bhm => {
				B => q{h:mm B – h:mm B},
				h => q{h:mm – h:mm B},
				m => q{h:mm – h:mm B},
			},
			Gy => {
				G => q{y G – y G},
				y => q{y – y G},
			},
			GyM => {
				G => q{M/y GGGGG – M/y GGGGG},
				M => q{M/y – M/y GGGGG},
				y => q{M/y – M/y GGGGG},
			},
			GyMEd => {
				G => q{E, M/d/y GGGGG – E, M/d/y GGGGG},
				M => q{E, M/d/y – E, M/d/y GGGGG},
				d => q{E, M/d/y – E, M/d/y GGGGG},
				y => q{E, M/d/y – E, M/d/y GGGGG},
			},
			GyMMM => {
				G => q{MMM y G – MMM y G},
				M => q{MMM – MMM y G},
				y => q{MMM y – MMM y G},
			},
			GyMMMEd => {
				G => q{E, MMM d, y G – E, MMM d, y G},
				M => q{E, MMM d – E, MMM d, y G},
				d => q{E, MMM d – E, MMM d, y G},
				y => q{E, MMM d, y – E, MMM d, y G},
			},
			GyMMMd => {
				G => q{MMM d, y G – MMM d, y G},
				M => q{MMM d – MMM d, y G},
				d => q{MMM d – d, y G},
				y => q{MMM d, y – MMM d, y G},
			},
			GyMd => {
				G => q{M/d/y GGGGG – M/d/y GGGGG},
				M => q{M/d/y – M/d/y GGGGG},
				d => q{M/d/y – M/d/y GGGGG},
				y => q{M/d/y – M/d/y GGGGG},
			},
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E، d/M – E، d/M},
				d => q{E، d/M – E، d/M},
			},
			MMM => {
				M => q{MMM–MMM},
			},
			MMMEd => {
				M => q{E، d MMM – E، d MMM},
				d => q{E، d MMM – E، d MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d–d MMM},
			},
			Md => {
				M => q{d/M – d/M},
				d => q{d/M – d/M},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{y–y G},
			},
			yM => {
				M => q{M/y – M/y G},
				y => q{M/y – M/y G},
			},
			yMEd => {
				M => q{E، d/M/y – E، d/M/y G},
				d => q{E، d/M/y – E، d/M/y G},
				y => q{E، d/M/y – E، d/M/y G},
			},
			yMMM => {
				M => q{MMM–MMM y G},
				y => q{MMM y – MMM y G},
			},
			yMMMEd => {
				M => q{E، d MMM – E، d MMM، y G},
				d => q{E، d MMM – E، d MMM، y G},
				y => q{E، d MMM، y – E، d MMM، y G},
			},
			yMMMM => {
				M => q{MMMM–MMMM y G},
				y => q{MMMM y – MMMM y G},
			},
			yMMMd => {
				M => q{d MMM – d MMM، y G},
				d => q{d–d MMM، y G},
				y => q{d MMM، y – d MMM، y G},
			},
			yMd => {
				M => q{d/M/y – d/M/y G},
				d => q{d/M/y – d/M/y G},
				y => q{d/M/y – d/M/y G},
			},
		},
		'gregorian' => {
			Bh => {
				B => q{h B – h B},
				h => q{h – h B},
			},
			Bhm => {
				B => q{h:mm B – h:mm B},
				h => q{h:mm – h:mm B},
				m => q{h:mm – h:mm B},
			},
			Gy => {
				G => q{y G – y G},
				y => q{y – y G},
			},
			GyM => {
				G => q{M/y GGGGG – M/y GGGGG},
				M => q{M/y – M/y GGGGG},
				y => q{M/y – M/y GGGGG},
			},
			GyMEd => {
				G => q{E, M/d/y GGGGG – E, M/d/y GGGGG},
				M => q{E, M/d/y – E, M/d/y GGGGG},
				d => q{E, M/d/y – E, M/d/y GGGGG},
				y => q{E, M/d/y – E, M/d/y GGGGG},
			},
			GyMMM => {
				G => q{MMM y G – MMM y G},
				M => q{MMM – MMM y G},
				y => q{MMM y – MMM y G},
			},
			GyMMMEd => {
				G => q{E, MMM d, y G – E, MMM d, y G},
				M => q{E, MMM d – E, MMM d, y G},
				d => q{E, MMM d – E, MMM d, y G},
				y => q{E, MMM d, y – E, MMM d, y G},
			},
			GyMMMd => {
				G => q{MMM d, y G – MMM d, y G},
				M => q{MMM d – MMM d, y G},
				d => q{MMM d – d, y G},
				y => q{MMM d, y – MMM d, y G},
			},
			GyMd => {
				G => q{M/d/y GGGGG – M/d/y GGGGG},
				M => q{M/d/y – M/d/y GGGGG},
				d => q{M/d/y – M/d/y GGGGG},
				y => q{M/d/y – M/d/y GGGGG},
			},
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E، d/M – E، d/M},
				d => q{E، d/M – E، d/M},
			},
			MMM => {
				M => q{MMM–MMM},
			},
			MMMEd => {
				M => q{E، d MMM – E، d MMM},
				d => q{E، d MMM – E، d MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d–d MMM},
			},
			Md => {
				M => q{d/M – d/M},
				d => q{d/M – d/M},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{y–y},
			},
			yM => {
				M => q{M/y – M/y},
				y => q{M/y – M/y},
			},
			yMEd => {
				M => q{E، d/M/y – E، d/M/y},
				d => q{E، d/M/y – E، d/M/y},
				y => q{E، d/M/y – E، d/M/y},
			},
			yMMM => {
				M => q{MMM–MMM y},
				y => q{MMM y – MMM y},
			},
			yMMMEd => {
				M => q{E، d MMM – E، d MMM، y},
				d => q{E، d MMM – E، d MMM، y},
				y => q{E، d MMM، y – E، d MMM، y},
			},
			yMMMM => {
				M => q{MMMM–MMMM y},
				y => q{MMMM y – MMMM y},
			},
			yMMMd => {
				M => q{d MMM – d MMM، y},
				d => q{d–d MMM y},
				y => q{d MMM، y – d MMM، y},
			},
			yMd => {
				M => q{d/M/y – d/M/y},
				d => q{d/M/y – d/M/y},
				y => q{d/M/y – d/M/y},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HH:mm;-HH:mm),
		gmtFormat => q(GMT {0}),
		gmtZeroFormat => q(GMT),
		regionFormat => q({0} وقت),
		regionFormat => q({0} ڈے لائٹ ٹائم),
		regionFormat => q({0} معیاری وقت),
		fallbackFormat => q({1} ({0})),
		'Afghanistan' => {
			long => {
				'standard' => q#افغانستان کا وقت#,
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#عابدجان#,
		},
		'Africa/Accra' => {
			exemplarCity => q#اکّرا#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#عدیس ابابا#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#الجیئرس#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#اسمارا#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#بماکو#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#بنگوئی#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#بنجول#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#بِساؤ#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#بلینٹائر#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#برازاویلے#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#بجمبرا#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#قاہرہ#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#کیسا بلانکا#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#سیوٹا#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#کونکری#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#ڈکار#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#دار السلام#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#جبوتی#,
		},
		'Africa/Douala' => {
			exemplarCity => q#ڈوآلا#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#العیون#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#فری ٹاؤن#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#گبرون#,
		},
		'Africa/Harare' => {
			exemplarCity => q#ہرارے#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#جوہانسبرگ#,
		},
		'Africa/Juba' => {
			exemplarCity => q#جوبا#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#کیمپالا#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#خرطوم#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#کگالی#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#کنشاسا#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#لاگوس#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#لبرے ویلے#,
		},
		'Africa/Lome' => {
			exemplarCity => q#لوم#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#لوانڈا#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#لوبمباشی#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#لیوساکا#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#ملابو#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#مپوٹو#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#مسیرو#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#مبابین#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#موگادیشو#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#مونروویا#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#نیروبی#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#اینجامینا#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#نیامی#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#نواکشوط#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#اؤگاڈؤگوو#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#پورٹو نووو#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#ساؤ ٹوم#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#ٹریپولی#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#تیونس#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#ونڈہوک#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q#وسطی افریقہ ٹائم#,
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q#مشرقی افریقہ ٹائم#,
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q#جنوبی افریقہ سٹینڈرڈ ٹائم#,
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q#مغربی افریقہ سمر ٹائم#,
				'generic' => q#مغربی افریقہ ٹائم#,
				'standard' => q#مغربی افریقہ سٹینڈرڈ ٹائم#,
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q#الاسکا ڈے لائٹ ٹائم#,
				'generic' => q#الاسکا ٹائم#,
				'standard' => q#الاسکا اسٹینڈرڈ ٹائم#,
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q#امیزون کا موسم گرما کا وقت#,
				'generic' => q#امیزون ٹائم#,
				'standard' => q#ایمیزون کا معیاری وقت#,
			},
		},
		'America/Adak' => {
			exemplarCity => q#اداک#,
		},
		'America/Anchorage' => {
			exemplarCity => q#اینکریج#,
		},
		'America/Anguilla' => {
			exemplarCity => q#انگویلا#,
		},
		'America/Antigua' => {
			exemplarCity => q#انٹیگوا#,
		},
		'America/Araguaina' => {
			exemplarCity => q#اراگویانا#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#لا ریئوجا#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#ریو گالیگوس#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#سالٹا#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#سان جوآن#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#سان لوئس#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#ٹوکومین#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#اوشوآئیا#,
		},
		'America/Aruba' => {
			exemplarCity => q#اروبا#,
		},
		'America/Asuncion' => {
			exemplarCity => q#اسنسیئن#,
		},
		'America/Bahia' => {
			exemplarCity => q#باہیا#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#بہیا بندراز#,
		},
		'America/Barbados' => {
			exemplarCity => q#بارباڈوس#,
		},
		'America/Belem' => {
			exemplarCity => q#بیلیم#,
		},
		'America/Belize' => {
			exemplarCity => q#بیلائز#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#بلانک سبلون#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#بوآ وسٹا#,
		},
		'America/Bogota' => {
			exemplarCity => q#بگوٹا#,
		},
		'America/Boise' => {
			exemplarCity => q#بوائس#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#بیونس آئرس#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#کیمبرج کی کھاڑی#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#کیمپو گرینڈ#,
		},
		'America/Cancun' => {
			exemplarCity => q#کنکیون#,
		},
		'America/Caracas' => {
			exemplarCity => q#کراکاس#,
		},
		'America/Catamarca' => {
			exemplarCity => q#کیٹامارکا#,
		},
		'America/Cayenne' => {
			exemplarCity => q#کائین#,
		},
		'America/Cayman' => {
			exemplarCity => q#کیمین#,
		},
		'America/Chicago' => {
			exemplarCity => q#شکاگو#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#چیہوآہوآ#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#اٹیکوکن#,
		},
		'America/Cordoba' => {
			exemplarCity => q#کورڈوبا#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#کوسٹا ریکا#,
		},
		'America/Creston' => {
			exemplarCity => q#کریسٹون#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#کوئیابا#,
		},
		'America/Curacao' => {
			exemplarCity => q#کیوراکاؤ#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#ڈنمارک شاون#,
		},
		'America/Dawson' => {
			exemplarCity => q#ڈاؤسن#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#ڈاؤسن کریک#,
		},
		'America/Denver' => {
			exemplarCity => q#ڈینور#,
		},
		'America/Detroit' => {
			exemplarCity => q#ڈیٹرائٹ#,
		},
		'America/Dominica' => {
			exemplarCity => q#ڈومنیکا#,
		},
		'America/Edmonton' => {
			exemplarCity => q#ایڈمونٹن#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#ایرونیپ#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#ال سلواڈور#,
		},
		'America/Fort_Nelson' => {
			exemplarCity => q#فورٹ نیلسن#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#فورٹالیزا#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#گلیس کی کھاڑی#,
		},
		'America/Godthab' => {
			exemplarCity => q#نوک#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#گوس کی کھاڑی#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#عظیم ترک#,
		},
		'America/Grenada' => {
			exemplarCity => q#غرناطہ#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#گواڈیلوپ#,
		},
		'America/Guatemala' => {
			exemplarCity => q#گواٹے مالا#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#گوآیاکوئل#,
		},
		'America/Guyana' => {
			exemplarCity => q#گیانا#,
		},
		'America/Halifax' => {
			exemplarCity => q#ہیلیفیکس#,
		},
		'America/Havana' => {
			exemplarCity => q#ہوانا#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#ہرموسیلو#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#کنوکس، انڈیانا#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#مرینگو، انڈیانا#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#پیٹرزبرگ، انڈیانا#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#ٹیل سٹی، انڈیانا#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#ویوے، انڈیانا#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#ونسینیز، انڈیانا#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#وینامیک، انڈیانا#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#انڈیاناپولس#,
		},
		'America/Inuvik' => {
			exemplarCity => q#انووِک#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#ایکالوئٹ#,
		},
		'America/Jamaica' => {
			exemplarCity => q#جمائیکا#,
		},
		'America/Jujuy' => {
			exemplarCity => q#جوجوئی#,
		},
		'America/Juneau' => {
			exemplarCity => q#جونیئو#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#مونٹیسیلو، کینٹوکی#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#کرالینڈیجک#,
		},
		'America/La_Paz' => {
			exemplarCity => q#لا پاز#,
		},
		'America/Lima' => {
			exemplarCity => q#لیما#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#لاس اینجلس#,
		},
		'America/Louisville' => {
			exemplarCity => q#لوئس ویلے#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#لوور پرنسس کوارٹر#,
		},
		'America/Maceio' => {
			exemplarCity => q#میسیئو#,
		},
		'America/Managua' => {
			exemplarCity => q#مناگوآ#,
		},
		'America/Manaus' => {
			exemplarCity => q#مناؤس#,
		},
		'America/Marigot' => {
			exemplarCity => q#میریگوٹ#,
		},
		'America/Martinique' => {
			exemplarCity => q#مارٹینک#,
		},
		'America/Matamoros' => {
			exemplarCity => q#میٹاموروس#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#میزٹلان#,
		},
		'America/Mendoza' => {
			exemplarCity => q#مینڈوزا#,
		},
		'America/Menominee' => {
			exemplarCity => q#مینومینی#,
		},
		'America/Merida' => {
			exemplarCity => q#میریڈا#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#میٹلا کاٹلا#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#میکسیکو سٹی#,
		},
		'America/Miquelon' => {
			exemplarCity => q#میکلیئون#,
		},
		'America/Moncton' => {
			exemplarCity => q#مونکٹن#,
		},
		'America/Monterrey' => {
			exemplarCity => q#مونٹیری#,
		},
		'America/Montevideo' => {
			exemplarCity => q#مونٹی ویڈیو#,
		},
		'America/Montserrat' => {
			exemplarCity => q#مونٹسیراٹ#,
		},
		'America/Nassau' => {
			exemplarCity => q#نساؤ#,
		},
		'America/New_York' => {
			exemplarCity => q#نیو یارک#,
		},
		'America/Nipigon' => {
			exemplarCity => q#نپیگون#,
		},
		'America/Nome' => {
			exemplarCity => q#نوم#,
		},
		'America/Noronha' => {
			exemplarCity => q#نورونہا#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#بیولاہ، شمالی ڈکوٹا#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#وسط، شمالی ڈکوٹا#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#نیو سلیم، شمالی ڈکوٹا#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#اوجیناگا#,
		},
		'America/Panama' => {
			exemplarCity => q#پنامہ#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#پینگنِرٹنگ#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#پراماریبو#,
		},
		'America/Phoenix' => {
			exemplarCity => q#فینکس#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#پورٹ او پرنس#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#پورٹ آف اسپین#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#پورٹو ویلہو#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#پیورٹو ریکو#,
		},
		'America/Punta_Arenas' => {
			exemplarCity => q#پنٹا اریناس#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#رینی ریور#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#رینکن انلیٹ#,
		},
		'America/Recife' => {
			exemplarCity => q#ریسائف#,
		},
		'America/Regina' => {
			exemplarCity => q#ریجینا#,
		},
		'America/Resolute' => {
			exemplarCity => q#ریزولیوٹ#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#ریئو برینکو#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#سانتا ایزابیل#,
		},
		'America/Santarem' => {
			exemplarCity => q#سنٹارین#,
		},
		'America/Santiago' => {
			exemplarCity => q#سنٹیاگو#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#سانتو ڈومنگو#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#ساؤ پالو#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#اسکورز بائی سنڈ#,
		},
		'America/Sitka' => {
			exemplarCity => q#سیٹکا#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#سینٹ برتھیلمی#,
		},
		'America/St_Johns' => {
			exemplarCity => q#سینٹ جانز#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#سینٹ کٹس#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#سینٹ لوسیا#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#سینٹ تھامس#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#سینٹ ونسنٹ#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#سوِفٹ کرنٹ#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#ٹیگوسیگالپے#,
		},
		'America/Thule' => {
			exemplarCity => q#تھولو#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#تھنڈر بے#,
		},
		'America/Tijuana' => {
			exemplarCity => q#تیجوآنا#,
		},
		'America/Toronto' => {
			exemplarCity => q#ٹورنٹو#,
		},
		'America/Tortola' => {
			exemplarCity => q#ٹورٹولا#,
		},
		'America/Vancouver' => {
			exemplarCity => q#وینکوور#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#وہائٹ ہارس#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#ونّیپیگ#,
		},
		'America/Yakutat' => {
			exemplarCity => q#یکوٹیٹ#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#ایلو نائف#,
		},
		'America_Central' => {
			long => {
				'daylight' => q#سنٹرل ڈے لائٹ ٹائم#,
				'generic' => q#سنٹرل ٹائم#,
				'standard' => q#سنٹرل اسٹینڈرڈ ٹائم#,
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q#ایسٹرن ڈے لائٹ ٹائم#,
				'generic' => q#ایسٹرن ٹائم#,
				'standard' => q#ایسٹرن اسٹینڈرڈ ٹائم#,
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q#ماؤنٹین ڈے لائٹ ٹائم#,
				'generic' => q#ماؤنٹین ٹائم#,
				'standard' => q#ماؤنٹین اسٹینڈرڈ ٹائم#,
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q#پیسفک ڈے لائٹ ٹائم#,
				'generic' => q#پیسفک ٹائم#,
				'standard' => q#پیسفک اسٹینڈرڈ ٹائم#,
			},
		},
		'Anadyr' => {
			long => {
				'daylight' => q#انیدر سمر ٹائم#,
				'generic' => q#انیدر ٹائم#,
				'standard' => q#انیدر اسٹینڈرڈ ٹائم#,
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#کیسی#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#ڈیوس#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#ڈومونٹ ڈی ارویلے#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#میکواری#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#ماؤسن#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#میک مرڈو#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#پلمیر#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#روتھیرا#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#سیووا#,
		},
		'Antarctica/Troll' => {
			exemplarCity => q#ٹرول#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#ووستوک#,
		},
		'Apia' => {
			long => {
				'daylight' => q#ایپیا ڈے لائٹ ٹائم#,
				'generic' => q#ایپیا ٹائم#,
				'standard' => q#ایپیا سٹینڈرڈ ٹائم#,
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q#عرب ڈے لائٹ ٹائم#,
				'generic' => q#عرب کا وقت#,
				'standard' => q#عرب کا معیاری وقت#,
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#لانگ ایئر بین#,
		},
		'Argentina' => {
			long => {
				'daylight' => q#ارجنٹینا کا موسم گرما کا وقت#,
				'generic' => q#ارجنٹینا کا وقت#,
				'standard' => q#ارجنٹینا کا معیاری وقت#,
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q#مغربی ارجنٹینا کا موسم گرما کا وقت#,
				'generic' => q#مغربی ارجنٹینا کا وقت#,
				'standard' => q#مغربی ارجنٹینا کا معیاری وقت#,
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q#آرمینیا کا موسم گرما کا وقت#,
				'generic' => q#آرمینیا کا وقت#,
				'standard' => q#آرمینیا کا معیاری وقت#,
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#عدن#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#الماٹی#,
		},
		'Asia/Amman' => {
			exemplarCity => q#امّان#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#انیدر#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#اکتاؤ#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#اکٹوب#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#اشغبت#,
		},
		'Asia/Atyrau' => {
			exemplarCity => q#آتیراؤ#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#بغداد#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#بحرین#,
		},
		'Asia/Baku' => {
			exemplarCity => q#باکو#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#بنکاک#,
		},
		'Asia/Barnaul' => {
			exemplarCity => q#برنال#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#بیروت#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#بشکیک#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#برونئی#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#کولکاتا#,
		},
		'Asia/Chita' => {
			exemplarCity => q#چیتا#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#چوئبالسان#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#کولمبو#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#دمشق#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#ڈھاکہ#,
		},
		'Asia/Dili' => {
			exemplarCity => q#ڈلی#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#دبئی#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#دوشانبے#,
		},
		'Asia/Famagusta' => {
			exemplarCity => q#فاماگوسٹا#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#غزہ#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#ہیبرون#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#ہانگ کانگ#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#ہووارڈ#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#ارکتسک#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#جکارتہ#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#جے پورہ#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#یروشلم#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#کابل#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#کیمچٹکا#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#کراچی#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#کاٹھمنڈو#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#خندیگا#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#کریسنویارسک#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#کوالا لمپور#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#کیوچنگ#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#کویت#,
		},
		'Asia/Macau' => {
			exemplarCity => q#مکاؤ#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#میگیدن#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#مکاسر#,
		},
		'Asia/Manila' => {
			exemplarCity => q#منیلا#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#مسقط#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#نکوسیا#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#نوووکیوزنیسک#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#نوووسِبِرسک#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#اومسک#,
		},
		'Asia/Oral' => {
			exemplarCity => q#اورال#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#پنوم پن#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#پونٹیانک#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#پیونگ یانگ#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#قطر#,
		},
		'Asia/Qostanay' => {
			exemplarCity => q#کوستانے#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#کیزیلورڈا#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#رنگون#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#ریاض#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#ہو چی منہ سٹی#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#سخالین#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#سمرقند#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#سیئول#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#شنگھائی#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#سنگاپور#,
		},
		'Asia/Srednekolymsk' => {
			exemplarCity => q#سرہدنیکولیمسک#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#تائپے#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#تاشقند#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#طبلیسی#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#تہران#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#تھمپو#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#ٹوکیو#,
		},
		'Asia/Tomsk' => {
			exemplarCity => q#ٹامسک#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#اولان باتار#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#یورومکی#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#اوست-نیرا#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#وینٹیانا#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#ولادی ووستک#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#یکوتسک#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#یکاٹیرِنبرگ#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#یریوان#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q#اٹلانٹک ڈے لائٹ ٹائم#,
				'generic' => q#اٹلانٹک ٹائم#,
				'standard' => q#اٹلانٹک اسٹینڈرڈ ٹائم#,
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#ازوریس#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#برمودا#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#کینری#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#کیپ ورڈی#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#فارو#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#مڈیئرا#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#ریکجاوک#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#جنوبی جارجیا#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#سینٹ ہیلینا#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#اسٹینلے#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#اڈیلائڈ#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#برسبین#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#بروکن ہِل#,
		},
		'Australia/Currie' => {
			exemplarCity => q#کیوری#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#ڈارون#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#ایوکلا#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#ہوبارٹ#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#لِنڈمین#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#لارڈ ہووے#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#ملبورن#,
		},
		'Australia/Perth' => {
			exemplarCity => q#پرتھ#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#سڈنی#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q#آسٹریلین سنٹرل ڈے لائٹ ٹائم#,
				'generic' => q#سنٹرل آسٹریلیا ٹائم#,
				'standard' => q#آسٹریلین سنٹرل اسٹینڈرڈ ٹائم#,
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q#آسٹریلین سنٹرل ویسٹرن ڈے لائٹ ٹائم#,
				'generic' => q#آسٹریلین سنٹرل ویسٹرن ٹائم#,
				'standard' => q#آسٹریلین سنٹرل ویسٹرن اسٹینڈرڈ ٹائم#,
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q#آسٹریلین ایسٹرن ڈے لائٹ ٹائم#,
				'generic' => q#ایسٹرن آسٹریلیا ٹائم#,
				'standard' => q#آسٹریلین ایسٹرن اسٹینڈرڈ ٹائم#,
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q#آسٹریلین ویسٹرن ڈے لائٹ ٹائم#,
				'generic' => q#ویسٹرن آسٹریلیا ٹائم#,
				'standard' => q#آسٹریلیا ویسٹرن اسٹینڈرڈ ٹائم#,
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q#آذربائیجان کا موسم گرما کا وقت#,
				'generic' => q#آذربائیجان کا وقت#,
				'standard' => q#آذربائیجان کا معیاری وقت#,
			},
		},
		'Azores' => {
			long => {
				'daylight' => q#ازوریس کا موسم گرما کا وقت#,
				'generic' => q#ازوریس کا وقت#,
				'standard' => q#ازوریس کا معیاری وقت#,
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q#بنگلہ دیش کا موسم گرما کا وقت#,
				'generic' => q#بنگلہ دیش کا وقت#,
				'standard' => q#بنگلہ دیش کا معیاری وقت#,
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q#بھوٹان کا وقت#,
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q#بولیویا کا وقت#,
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q#برازیلیا سمر ٹائم#,
				'generic' => q#برازیلیا ٹائم#,
				'standard' => q#برازیلیا اسٹینڈرڈ ٹائم#,
			},
		},
		'Brunei' => {
			long => {
				'standard' => q#برونئی دارالسلام ٹائم#,
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q#کیپ ورڈی سمر ٹائم#,
				'generic' => q#کیپ ورڈی ٹائم#,
				'standard' => q#کیپ ورڈی سٹینڈرڈ ٹائم#,
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q#چامورو سٹینڈرڈ ٹائم#,
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q#چیتھم ڈے لائٹ ٹائم#,
				'generic' => q#چیتھم ٹائم#,
				'standard' => q#چیتھم اسٹینڈرڈ ٹائم#,
			},
		},
		'Chile' => {
			long => {
				'daylight' => q#چلی کا موسم گرما کا وقت#,
				'generic' => q#چلی کا وقت#,
				'standard' => q#چلی کا معیاری وقت#,
			},
		},
		'China' => {
			long => {
				'daylight' => q#چینی ڈے لائٹ ٹائم#,
				'generic' => q#چین کا وقت#,
				'standard' => q#چین سٹینڈرڈ ٹائم#,
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q#کوائبلسان سمر ٹائم#,
				'generic' => q#کوئبلسان ٹائم#,
				'standard' => q#کوئبلسان سٹینڈرڈ ٹائم#,
			},
		},
		'Christmas' => {
			long => {
				'standard' => q#کرسمس آئلینڈ ٹائم#,
			},
		},
		'Cocos' => {
			long => {
				'standard' => q#کوکوس آئلینڈز ٹائم#,
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q#کولمبیا کا موسم گرما کا وقت#,
				'generic' => q#کولمبیا ٹائم#,
				'standard' => q#کولمبیا کا معیاری وقت#,
			},
		},
		'Cook' => {
			long => {
				'daylight' => q#کک آئلینڈز نصف سمر ٹائم#,
				'generic' => q#کک آئلینڈز ٹائم#,
				'standard' => q#کک آئلینڈز سٹینڈرڈ ٹائم#,
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q#کیوبا ڈے لائٹ ٹائم#,
				'generic' => q#کیوبا ٹائم#,
				'standard' => q#کیوبا اسٹینڈرڈ ٹائم#,
			},
		},
		'Davis' => {
			long => {
				'standard' => q#ڈیوس ٹائم#,
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q#ڈومونٹ-ڈی’ارویلے ٹائم#,
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q#مشرقی تیمور ٹائم#,
			},
		},
		'Easter' => {
			long => {
				'daylight' => q#ایسٹر آئلینڈ کا موسم گرما کا وقت#,
				'generic' => q#ایسٹر آئلینڈ کا وقت#,
				'standard' => q#ایسٹر آئلینڈ کا معیاری وقت#,
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q#ایکواڈور کا وقت#,
			},
		},
		'Etc/UTC' => {
			long => {
				'standard' => q#کوآرڈینیٹڈ یونیورسل ٹائم#,
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#نامعلوم شہر#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#ایمسٹرڈم#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#انڈورا#,
		},
		'Europe/Astrakhan' => {
			exemplarCity => q#استراخان#,
		},
		'Europe/Athens' => {
			exemplarCity => q#ایتھنز#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#بلغراد#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#برلن#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#بریٹِسلاوا#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#برسلز#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#بخارسٹ#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#بڈاپسٹ#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#بزنجن#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#چیسیناؤ#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#کوپن ہیگن#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#ڈبلن#,
			long => {
				'daylight' => q#آئرش اسٹینڈرڈ ٹائم#,
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#جبل الطارق#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#گرنزی#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#ہیلسنکی#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#آئل آف مین#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#استنبول#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#جرسی#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#کالينينغراد#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#کیو#,
		},
		'Europe/Kirov' => {
			exemplarCity => q#کیروف#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#لسبن#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#لیوبلیانا#,
		},
		'Europe/London' => {
			exemplarCity => q#لندن#,
			long => {
				'daylight' => q#برٹش سمر ٹائم#,
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#لگژمبرگ#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#میڈرڈ#,
		},
		'Europe/Malta' => {
			exemplarCity => q#مالٹا#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#میریہام#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#مِنسک#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#موناکو#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#ماسکو#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#اوسلو#,
		},
		'Europe/Paris' => {
			exemplarCity => q#پیرس#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#پوڈگورسیا#,
		},
		'Europe/Prague' => {
			exemplarCity => q#پراگ#,
		},
		'Europe/Riga' => {
			exemplarCity => q#ریگا#,
		},
		'Europe/Rome' => {
			exemplarCity => q#روم#,
		},
		'Europe/Samara' => {
			exemplarCity => q#سمارا#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#سان ماریانو#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#سراجیوو#,
		},
		'Europe/Saratov' => {
			exemplarCity => q#سیراٹو#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#سمفروپول#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#اسکوپجے#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#صوفیہ#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#اسٹاک ہوم#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#ٹالن#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#ٹیرانی#,
		},
		'Europe/Ulyanovsk' => {
			exemplarCity => q#الیانوسک#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#ازہوراڈ#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#ویڈوز#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#واٹیکن#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#ویانا#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#وِلنیئس#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#وولگوگراد#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#وارسا#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#زیگریب#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#زیپوروزائی#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#زیورخ#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q#وسطی یورپ کا موسم گرما کا وقت#,
				'generic' => q#وسط یورپ کا وقت#,
				'standard' => q#وسطی یورپ کا معیاری وقت#,
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q#مشرقی یورپ کا موسم گرما کا وقت#,
				'generic' => q#مشرقی یورپ کا وقت#,
				'standard' => q#مشرقی یورپ کا معیاری وقت#,
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q#بعید مشرقی یورپی وقت#,
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q#مغربی یورپ کا موسم گرما کا وقت#,
				'generic' => q#مغربی یورپ کا وقت#,
				'standard' => q#مغربی یورپ کا معیاری وقت#,
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q#فاک لینڈ آئلینڈز کا موسم گرما کا وقت#,
				'generic' => q#فاک لینڈ آئلینڈز کا وقت#,
				'standard' => q#فاک لینڈ آئلینڈز کا معیاری وقت#,
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q#فجی سمر ٹائم#,
				'generic' => q#فجی ٹائم#,
				'standard' => q#فجی سٹینڈرڈ ٹائم#,
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q#فرینچ گیانا کا وقت#,
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q#فرینچ جنوبی اور انٹارکٹک ٹائم#,
			},
		},
		'GMT' => {
			long => {
				'standard' => q#گرین وچ کا اصل وقت#,
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q#گالاپاگوز کا وقت#,
			},
		},
		'Gambier' => {
			long => {
				'standard' => q#گیمبیئر ٹائم#,
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q#جارجیا کا موسم گرما کا وقت#,
				'generic' => q#جارجیا کا وقت#,
				'standard' => q#جارجیا کا معیاری وقت#,
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q#جلبرٹ آئلینڈز ٹائم#,
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q#مشرقی گرین لینڈ کا موسم گرما کا وقت#,
				'generic' => q#مشرقی گرین لینڈ ٹائم#,
				'standard' => q#مشرقی گرین لینڈ اسٹینڈرڈ ٹائم#,
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q#مغربی گرین لینڈ کا موسم گرما کا وقت#,
				'generic' => q#مغربی گرین لینڈ ٹائم#,
				'standard' => q#مغربی گرین لینڈ اسٹینڈرڈ ٹائم#,
			},
		},
		'Gulf' => {
			long => {
				'standard' => q#خلیج کا معیاری وقت#,
			},
		},
		'Guyana' => {
			long => {
				'standard' => q#گیانا کا وقت#,
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q#ہوائی الیوٹیئن ڈے لائٹ ٹائم#,
				'generic' => q#ہوائی الیوٹیئن ٹائم#,
				'standard' => q#ہوائی الیوٹیئن اسٹینڈرڈ ٹائم#,
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q#ہانگ کانگ سمر ٹائم#,
				'generic' => q#ہانگ کانگ ٹائم#,
				'standard' => q#ہانگ کانگ سٹینڈرڈ ٹائم#,
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q#ہووڈ سمر ٹائم#,
				'generic' => q#ہووڈ ٹائم#,
				'standard' => q#ہووڈ سٹینڈرڈ ٹائم#,
			},
		},
		'India' => {
			long => {
				'standard' => q#ہندوستان کا معیاری وقت#,
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#انٹاناناریوو#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#چاگوس#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#کرسمس#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#کوکوس#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#کومورو#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#کرگیولین#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#ماہی#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#مالدیپ#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#ماریشس#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#مایوٹ#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#ری یونین#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q#بحر ہند ٹائم#,
			},
		},
		'Indochina' => {
			long => {
				'standard' => q#ہند چین ٹائم#,
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q#وسطی انڈونیشیا ٹائم#,
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q#مشرقی انڈونیشیا ٹائم#,
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q#مغربی انڈونیشیا ٹائم#,
			},
		},
		'Iran' => {
			long => {
				'daylight' => q#ایران ڈے لائٹ ٹائم#,
				'generic' => q#ایران کا وقت#,
				'standard' => q#ایران کا معیاری وقت#,
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q#ارکتسک سمر ٹائم#,
				'generic' => q#ارکتسک ٹائم#,
				'standard' => q#ارکتسک سٹینڈرڈ ٹائم#,
			},
		},
		'Israel' => {
			long => {
				'daylight' => q#اسرائیل ڈے لائٹ ٹائم#,
				'generic' => q#اسرائیل کا وقت#,
				'standard' => q#اسرائیل کا معیاری وقت#,
			},
		},
		'Japan' => {
			long => {
				'daylight' => q#جاپان ڈے لائٹ ٹائم#,
				'generic' => q#جاپان ٹائم#,
				'standard' => q#جاپان سٹینڈرڈ ٹائم#,
			},
		},
		'Kamchatka' => {
			long => {
				'daylight' => q#پیٹروپاؤلووسک-کیمچسکی سمر ٹائم#,
				'generic' => q#پیٹروپاؤلووسک-کیمچسکی ٹائم#,
				'standard' => q#پیٹروپاؤلووسک-کیمچسکی اسٹینڈرڈ ٹائم#,
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q#مشرقی قزاخستان کا وقت#,
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q#مغربی قزاخستان کا وقت#,
			},
		},
		'Korea' => {
			long => {
				'daylight' => q#کوریا ڈے لائٹ ٹائم#,
				'generic' => q#کوریا ٹائم#,
				'standard' => q#کوریا سٹینڈرڈ ٹائم#,
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q#کوسرے ٹائم#,
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q#کریسنویارسک سمر ٹائم#,
				'generic' => q#کریسنویارسک ٹائم#,
				'standard' => q#کرسنویارسک سٹینڈرڈ ٹائم#,
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q#کرغستان کا وقت#,
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q#لائن آئلینڈز ٹائم#,
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q#لارڈ ہووے ڈے لائٹ ٹائم#,
				'generic' => q#لارڈ ہووے ٹائم#,
				'standard' => q#لارڈ ہووے اسٹینڈرڈ ٹائم#,
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q#مکوآری آئلینڈ کا وقت#,
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q#میگیدن سمر ٹائم#,
				'generic' => q#میگیدن ٹائم#,
				'standard' => q#مگادان اسٹینڈرڈ ٹائم#,
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q#ملیشیا ٹائم#,
			},
		},
		'Maldives' => {
			long => {
				'standard' => q#مالدیپ کا وقت#,
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q#مارکیسس ٹائم#,
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q#مارشل آئلینڈز ٹائم#,
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q#ماریشس سمر ٹائم#,
				'generic' => q#ماریشس ٹائم#,
				'standard' => q#ماریشس سٹینڈرڈ ٹائم#,
			},
		},
		'Mawson' => {
			long => {
				'standard' => q#ماؤسن ٹائم#,
			},
		},
		'Mexico_Northwest' => {
			long => {
				'daylight' => q#شمال مغربی میکسیکو ڈے لائٹ ٹائم#,
				'generic' => q#شمال مغربی میکسیکو ٹائم#,
				'standard' => q#شمال مغربی میکسیکو اسٹینڈرڈ ٹائم#,
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q#میکسیکن پیسفک ڈے لائٹ ٹائم#,
				'generic' => q#میکسیکن پیسفک ٹائم#,
				'standard' => q#میکسیکن پیسفک اسٹینڈرڈ ٹائم#,
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q#یولان بیتور سمر ٹائم#,
				'generic' => q#یولان بیتور ٹائم#,
				'standard' => q#یولان بیتور سٹینڈرڈ ٹائم#,
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q#ماسکو سمر ٹائم#,
				'generic' => q#ماسکو ٹائم#,
				'standard' => q#ماسکو اسٹینڈرڈ ٹائم#,
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q#میانمار ٹائم#,
			},
		},
		'Nauru' => {
			long => {
				'standard' => q#ناؤرو ٹائم#,
			},
		},
		'Nepal' => {
			long => {
				'standard' => q#نیپال کا وقت#,
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q#نیو کیلیڈونیا سمر ٹائم#,
				'generic' => q#نیو کیلیڈونیا ٹائم#,
				'standard' => q#نیو کیلیڈونیا سٹینڈرڈ ٹائم#,
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q#نیوزی لینڈ ڈے لائٹ ٹائم#,
				'generic' => q#نیوزی لینڈ کا وقت#,
				'standard' => q#نیوزی لینڈ کا معیاری وقت#,
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q#نیو فاؤنڈ لینڈ ڈے لائٹ ٹائم#,
				'generic' => q#نیو فاؤنڈ لینڈ ٹائم#,
				'standard' => q#نیو فاؤنڈ لینڈ اسٹینڈرڈ ٹائم#,
			},
		},
		'Niue' => {
			long => {
				'standard' => q#نیئو ٹائم#,
			},
		},
		'Norfolk' => {
			long => {
				'daylight' => q#نارفوک آئلینڈ ڈے لائٹ وقت#,
				'generic' => q#نارفوک آئلینڈ کا وقت#,
				'standard' => q#نارفوک آئلینڈ کا معیاری وقت#,
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q#فرنانڈو ڈی نورونہا سمر ٹائم#,
				'generic' => q#فرنانڈو ڈی نورنہا کا وقت#,
				'standard' => q#فرنانڈو ڈی نورنہا کا معیاری وقت#,
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q#نوووسیبرسک سمر ٹائم#,
				'generic' => q#نوووسیبرسک ٹائم#,
				'standard' => q#نوووسیبرسک سٹینڈرڈ ٹائم#,
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q#اومسک سمر ٹائم#,
				'generic' => q#اومسک ٹائم#,
				'standard' => q#اومسک سٹینڈرڈ ٹائم#,
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#اپیا#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#آکلینڈ#,
		},
		'Pacific/Bougainville' => {
			exemplarCity => q#بوگینولے#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#چیتھم#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#ایسٹر#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#ایفیٹ#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#اینڈربری#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#فکاؤفو#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#فجی#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#فیونافیوٹی#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#گیلاپیگوس#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#گامبیئر#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#گواڈل کینال#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#گوآم#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#ہونولولو#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#جانسٹن#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#کریتیماٹی#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#کوسرائی#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#کواجیلین#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#مجورو#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#مارکیساس#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#مڈوے#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#ناؤرو#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#نیئو#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#نورفوک#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#نؤمیا#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#پاگو پاگو#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#پلاؤ#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#پٹکائرن#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#پونپیئی#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#پورٹ موریسبی#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#راروٹونگا#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#سائپین#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#تاہیتی#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#ٹراوا#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#ٹونگاٹاپو#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#چیوک#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#ویک#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#ولّیس#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q#پاکستان کا موسم گرما کا وقت#,
				'generic' => q#پاکستان کا وقت#,
				'standard' => q#پاکستان کا معیاری وقت#,
			},
		},
		'Palau' => {
			long => {
				'standard' => q#پلاؤ ٹائم#,
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q#پاپوآ نیو گنی ٹائم#,
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q#پیراگوئے کا موسم گرما کا وقت#,
				'generic' => q#پیراگوئے کا وقت#,
				'standard' => q#پیراگوئے کا معیاری وقت#,
			},
		},
		'Peru' => {
			long => {
				'daylight' => q#پیرو کا موسم گرما کا وقت#,
				'generic' => q#پیرو کا وقت#,
				'standard' => q#پیرو کا معیاری وقت#,
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q#فلپائن سمر ٹائم#,
				'generic' => q#فلپائن ٹائم#,
				'standard' => q#فلپائن سٹینڈرڈ ٹائم#,
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q#فینکس آئلینڈز ٹائم#,
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q#سینٹ پیئر اور مکلیئون ڈے لائٹ ٹائم#,
				'generic' => q#سینٹ پیئر اور مکلیئون ٹائم#,
				'standard' => q#سینٹ پیئر اور مکلیئون اسٹینڈرڈ ٹائم#,
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q#پٹکائرن ٹائم#,
			},
		},
		'Ponape' => {
			long => {
				'standard' => q#پوناپے ٹائم#,
			},
		},
		'Pyongyang' => {
			long => {
				'standard' => q#پیانگ یانگ وقت#,
			},
		},
		'Reunion' => {
			long => {
				'standard' => q#ری یونین ٹائم#,
			},
		},
		'Rothera' => {
			long => {
				'standard' => q#روتھیرا کا وقت#,
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q#سخالین سمر ٹائم#,
				'generic' => q#سخالین ٹائم#,
				'standard' => q#سخالین سٹینڈرڈ ٹائم#,
			},
		},
		'Samara' => {
			long => {
				'daylight' => q#سمارا سمر ٹائم#,
				'generic' => q#سمارا ٹائم#,
				'standard' => q#سمارا اسٹینڈرڈ ٹائم#,
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q#ساموآ ڈے لائٹ ٹائم#,
				'generic' => q#ساموآ ٹائم#,
				'standard' => q#ساموآ سٹینڈرڈ ٹائم#,
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q#سیشلیز ٹائم#,
			},
		},
		'Singapore' => {
			long => {
				'standard' => q#سنگاپور سٹینڈرڈ ٹائم#,
			},
		},
		'Solomon' => {
			long => {
				'standard' => q#سولمن آئلینڈز ٹائم#,
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q#جنوبی جارجیا ٹائم#,
			},
		},
		'Suriname' => {
			long => {
				'standard' => q#سورینام کا وقت#,
			},
		},
		'Syowa' => {
			long => {
				'standard' => q#سیووا ٹائم#,
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q#تاہیتی ٹائم#,
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q#تئی پیئی ڈے لائٹ ٹائم#,
				'generic' => q#تائی پیئی ٹائم#,
				'standard' => q#تائی پیئی اسٹینڈرڈ ٹائم#,
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q#تاجکستان کا وقت#,
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q#ٹوکیلاؤ ٹائم#,
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q#ٹونگا سمر ٹائم#,
				'generic' => q#ٹونگا ٹائم#,
				'standard' => q#ٹونگا سٹینڈرڈ ٹائم#,
			},
		},
		'Truk' => {
			long => {
				'standard' => q#چوک ٹائم#,
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q#ترکمانستان کا موسم گرما کا وقت#,
				'generic' => q#ترکمانستان کا وقت#,
				'standard' => q#ترکمانستان کا معیاری وقت#,
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q#ٹوالو ٹائم#,
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q#یوروگوئے کا موسم گرما کا وقت#,
				'generic' => q#یوروگوئے کا وقت#,
				'standard' => q#یوروگوئے کا معیاری وقت#,
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q#ازبکستان کا موسم گرما کا وقت#,
				'generic' => q#ازبکستان کا وقت#,
				'standard' => q#ازبکستان کا معیاری وقت#,
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q#وانوآٹو سمر ٹائم#,
				'generic' => q#وانوآٹو ٹائم#,
				'standard' => q#وانوآٹو سٹینڈرڈ ٹائم#,
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q#وینزوئیلا کا وقت#,
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q#ولادی ووستک سمر ٹائم#,
				'generic' => q#ولادی ووستک ٹائم#,
				'standard' => q#ولادی ووستک سٹینڈرڈ ٹائم#,
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q#وولگوگراد سمر ٹائم#,
				'generic' => q#وولگوگراد ٹائم#,
				'standard' => q#وولگوگراد اسٹینڈرڈ ٹائم#,
			},
		},
		'Vostok' => {
			long => {
				'standard' => q#ووسٹاک کا وقت#,
			},
		},
		'Wake' => {
			long => {
				'standard' => q#ویک آئلینڈ ٹائم#,
			},
		},
		'Wallis' => {
			long => {
				'standard' => q#والیز اور فٹونا ٹائم#,
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q#یکوتسک سمر ٹائم#,
				'generic' => q#یکوتسک ٹائم#,
				'standard' => q#یکوتسک اسٹینڈرڈ ٹائم#,
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q#یکاٹیرِنبرگ سمر ٹائم#,
				'generic' => q#یکاٹیرِنبرگ ٹائم#,
				'standard' => q#یکاٹیرِنبرگ اسٹینڈرڈ ٹائم#,
			},
		},
		'Yukon' => {
			long => {
				'standard' => q#یوکون ٹائم#,
			},
		},
	 } }
);
no Moo;

1;

# vim: tabstop=4
