#!/usr/bin/perl
# Do not normalise this test file. It has deliberately unnormalised characters in it.
use v5.10;
use strict;
use warnings;
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';

use Test::More tests => 25;
use Test::Exception;

use ok 'Locale::CLDR';

my $locale = Locale::CLDR->new('da_DK');
my $other_locale = Locale::CLDR->new('en_US');

is($locale->locale_name(), 'dansk (Danmark)', 'Locale name from current locale');
is($locale->locale_name('fr_CA'), 'canadisk fransk', 'Locale name from string');
is($locale->locale_name($other_locale), 'amerikansk engelsk', 'Locale name from other locale object');

is($locale->language_name(), 'dansk', 'Language name from current locale');
is($locale->language_name('fr'), 'fransk', 'Language name from string');
is($locale->language_name($other_locale), 'engelsk', 'Language name from other locale object');

my $all_languages = {
	'aa' => 'afar',
	'ab' => 'abkhasisk',
	'ace' => 'achinesisk',
	'ach' => 'acoli',
	'ada' => 'adangme',
	'ady' => 'adyghe',
	'ae' => 'avestan',
	'af' => 'afrikaans',
	'afh' => 'afrihili',
	'agq' => 'aghem',
	'ain' => 'ainu',
	'ak' => 'akan',
	'akk' => 'akkadisk',
	'ale' => 'aleutisk',
	'alt' => 'sydaltaisk',
	'am' => 'amharisk',
	'an' => 'aragonesisk',
	'ang' => 'oldengelsk',
	'anp' => 'angika',
	'ar' => 'arabisk',
	'ar_001' => 'moderne standardarabisk',
	'arc' => 'aramæisk',
	'arn' => 'mapuche',
	'arp' => 'arapaho',
	'arw' => 'arawak',
	'as' => 'assamesisk',
	'asa' => 'asu',
	'ast' => 'asturisk',
	'av' => 'avarisk',
	'awa' => 'awadhi',
	'ay' => 'aymara',
	'az' => 'aserbajdsjansk',
	'az@alt=short' => 'azeri',
	'az_Arab' => 'sydaserbajdsjansk',
	'ba' => 'bashkir',
	'bal' => 'baluchi',
	'ban' => 'balinesisk',
	'bas' => 'basa',
	'bax' => 'bamun',
	'bbj' => 'ghomala',
	'be' => 'hviderussisk',
	'bej' => 'beja',
	'bem' => 'bemba',
	'bez' => 'bena',
	'bfd' => 'bafut',
	'bg' => 'bulgarsk',
	'bgn' => 'vestbaluchi',
	'bho' => 'bhojpuri',
	'bi' => 'bislama',
	'bik' => 'bikol',
	'bin' => 'bini',
	'bkm' => 'kom',
	'bla' => 'siksika',
	'bm' => 'bambara',
	'bn' => 'bengali',
	'bo' => 'tibetansk',
	'br' => 'bretonsk',
	'bra' => 'braj',
	'brx' => 'bodo',
	'bs' => 'bosnisk',
	'bss' => 'bakossi',
	'bua' => 'buriatisk',
	'bug' => 'buginesisk',
	'bum' => 'bulu',
	'byn' => 'blin',
	'byv' => 'medumba',
	'ca' => 'catalansk',
	'cad' => 'caddo',
	'car' => 'caribisk',
	'cay' => 'cayuga',
	'cch' => 'atsam',
	'ce' => 'tjetjensk',
	'ceb' => 'cebuano',
	'cgg' => 'chiga',
	'ch' => 'chamorro',
	'chb' => 'chibcha',
	'chg' => 'chagatai',
	'chk' => 'chuukese',
	'chm' => 'mari',
	'chn' => 'chinook',
	'cho' => 'choctaw',
	'chp' => 'chipewyan',
	'chr' => 'cherokee',
	'chy' => 'cheyenne',
	'ckb' => 'sorani',
	'co' => 'korsikansk',
	'cop' => 'koptisk',
	'cr' => 'cree',
	'crh' => 'krim tyrkisk',
	'cs' => 'tjekkisk',
	'csb' => 'kasjubisk',
	'cu' => 'kirkeslavisk',
	'cv' => 'chuvash',
	'cy' => 'walisisk',
	'da' => 'dansk',
	'dak' => 'dakota',
	'dar' => 'dargwa',
	'dav' => 'taita',
	'de' => 'tysk',
	'de_AT' => 'østrigsk tysk',
	'de_CH' => 'schweizerhøjtysk',
	'del' => 'delaware',
	'den' => 'athapaskisk',
	'dgr' => 'dogrib',
	'din' => 'dinka',
	'dje' => 'zarma',
	'doi' => 'dogri',
	'dsb' => 'nedersorbisk',
	'dua' => 'duala',
	'dum' => 'middelhollandsk',
	'dv' => 'divehi',
	'dyo' => 'jola-fonyi',
	'dyu' => 'dyula',
	'dz' => 'dzongkha',
	'dzg' => 'dazaga',
	'ebu' => 'kiembu',
	'ee' => 'ewe',
	'efi' => 'efik',
	'egy' => 'oldegyptisk',
	'eka' => 'ekajuk',
	'el' => 'græsk',
	'elx' => 'elamitisk',
	'en' => 'engelsk',
	'en_AU' => 'australsk engelsk',
	'en_CA' => 'canadisk engelsk',
	'en_GB' => 'britisk engelsk',
	'en_GB@alt=short' => 'engelsk (UK)',
	'en_US' => 'amerikansk engelsk',
	'enm' => 'middelengelsk',
	'eo' => 'esperanto',
	'es' => 'spansk',
	'es_419' => 'latinamerikansk spansk',
	'es_ES' => 'europæisk spansk',
	'es_MX' => 'mexicansk spansk',
	'et' => 'estisk',
	'eu' => 'baskisk',
	'ewo' => 'ewondo',
	'fa' => 'persisk',
	'fan' => 'fang',
	'fat' => 'fanti',
	'ff' => 'fulah',
	'fi' => 'finsk',
	'fil' => 'filippinsk',
	'fj' => 'fijiansk',
	'fo' => 'færøsk',
	'fon' => 'fon',
	'fr' => 'fransk',
	'fr_CA' => 'canadisk fransk',
	'fr_CH' => 'schweizisk fransk',
	'frm' => 'middelfransk',
	'fro' => 'oldfransk',
	'frr' => 'nordfrisisk',
	'frs' => 'østfrisisk',
	'fur' => 'friulian',
	'fy' => 'frisisk',
	'ga' => 'irsk',
	'gaa' => 'ga',
	'gag' => 'gagauzisk',
	'gay' => 'gayo',
	'gba' => 'gbaya',
	'gd' => 'skotsk gælisk',
	'gez' => 'geez',
	'gil' => 'gilbertesisk',
	'gl' => 'galicisk',
	'gmh' => 'middelhøjtysk',
	'gn' => 'guarani',
	'goh' => 'oldhøjtysk',
	'gon' => 'gondi',
	'gor' => 'gorontalo',
	'got' => 'gotisk',
	'grb' => 'grebo',
	'grc' => 'oldgræsk',
	'gsw' => 'schweizertysk',
	'gu' => 'gujarati',
	'guz' => 'gusii',
	'gv' => 'manx',
	'gwi' => 'gwichin',
	'ha' => 'hausa',
	'hai' => 'haida',
	'haw' => 'hawaiiansk',
	'he' => 'hebraisk',
	'hi' => 'hindi',
	'hil' => 'hiligaynon',
	'hit' => 'hittitisk',
	'hmn' => 'hmong',
	'ho' => 'hirimotu',
	'hr' => 'kroatisk',
	'hsb' => 'øvresorbisk',
	'ht' => 'haitisk',
	'hu' => 'ungarsk',
	'hup' => 'hupa',
	'hy' => 'armensk',
	'hz' => 'herero',
	'ia' => 'interlingua',
	'iba' => 'iban',
	'ibb' => 'ibibio',
	'id' => 'indonesisk',
	'ie' => 'interlingue',
	'ig' => 'igbo',
	'ii' => 'sichuan yi',
	'ik' => 'inupiaq',
	'ilo' => 'iloko',
	'inh' => 'ingush',
	'io' => 'ido',
	'is' => 'islandsk',
	'it' => 'italiensk',
	'iu' => 'inuktitut',
	'ja' => 'japansk',
	'jbo' => 'lojban',
	'jgo' => 'ngomba',
	'jmc' => 'machame',
	'jpr' => 'jødisk-persisk',
	'jrb' => 'jødisk-arabisk',
	'jv' => 'javanesisk',
	'ka' => 'georgisk',
	'kaa' => 'karakalpakisk',
	'kab' => 'kabylisk',
	'kac' => 'kachin',
	'kaj' => 'jju',
	'kam' => 'kamba',
	'kaw' => 'kawi',
	'kbd' => 'kabardian',
	'kbl' => 'kanembu',
	'kcg' => 'tyap',
	'kde' => 'makonde',
	'kea' => 'kapverdisk',
	'kfo' => 'koro',
	'kg' => 'kongo',
	'kha' => 'khasi',
	'kho' => 'khotanesisk',
	'khq' => 'koyra-chiini',
	'ki' => 'kikuyu',
	'kj' => 'kuanyama',
	'kk' => 'kasakhisk',
	'kkj' => 'kako',
	'kl' => 'grønlandsk',
	'kln' => 'kalenjin',
	'km' => 'khmer',
	'kmb' => 'kimbundu',
	'kn' => 'kannada',
	'ko' => 'koreansk',
	'koi' => 'komi-permjakisk',
	'kok' => 'konkani',
	'kos' => 'kosraean',
	'kpe' => 'kpelle',
	'kr' => 'kanuri',
	'krc' => 'karatjai-balkar',
	'krl' => 'karelsk',
	'kru' => 'kurukh',
	'ks' => 'kashmiri',
	'ksb' => 'shambala',
	'ksf' => 'bafia',
	'ksh' => 'kölsch',
	'ku' => 'kurdisk',
	'kum' => 'kymyk',
	'kut' => 'kutenaj',
	'kv' => 'komi',
	'kw' => 'cornisk',
	'ky' => 'kirgisisk',
	'la' => 'latin',
	'lad' => 'ladino',
	'lag' => 'langi',
	'lah' => 'lahnda',
	'lam' => 'lamba',
	'lb' => 'luxembourgsk',
	'lez' => 'lezghian',
	'lg' => 'ganda',
	'li' => 'limburgsk',
	'lkt' => 'lakota',
	'ln' => 'lingala',
	'lo' => 'lao',
	'lol' => 'mongo',
	'loz' => 'lozi',
	'lrc' => 'nordluri',
	'lt' => 'litauisk',
	'lu' => 'luba-Katanga',
	'lua' => 'luba-Lulua',
	'lui' => 'luiseno',
	'lun' => 'lunda',
	'luo' => 'luo',
	'lus' => 'lushai',
	'luy' => 'luyana',
	'lv' => 'lettisk',
	'mad' => 'madurese',
	'maf' => 'mafa',
	'mag' => 'magahi',
	'mai' => 'maithili',
	'mak' => 'makasar',
	'man' => 'mandingo',
	'mas' => 'masai',
	'mde' => 'maba',
	'mdf' => 'moksha',
	'mdr' => 'mandar',
	'men' => 'mende',
	'mer' => 'meru',
	'mfe' => 'morisyen',
	'mg' => 'malagassisk',
	'mga' => 'middelirsk',
	'mgh' => 'makhuwa-meetto',
	'mgo' => 'meta',
	'mh' => 'marshallese',
	'mi' => 'maori',
	'mic' => 'micmac',
	'min' => 'minangkabau',
	'mk' => 'makedonsk',
	'ml' => 'malayalam',
	'mn' => 'mongolsk',
	'mnc' => 'manchu',
	'mni' => 'manipuri',
	'moh' => 'mohawk',
	'mos' => 'mossi',
	'mr' => 'marathisk',
	'ms' => 'malay',
	'mt' => 'maltesisk',
	'mua' => 'mundang',
	'mul' => 'flere sprog',
	'mus' => 'creek',
	'mwl' => 'mirandesisk',
	'mwr' => 'marwari',
	'my' => 'burmesisk',
	'mye' => 'myene',
	'myv' => 'erzya',
	'mzn' => 'mazenisk',
	'na' => 'nauru',
	'nap' => 'neapolitansk',
	'naq' => 'nama',
	'nb' => 'norsk bokmål',
	'nd' => 'nordndebele',
	'nds' => 'nedertysk',
	'ne' => 'nepalesisk',
	'new' => 'newari',
	'ng' => 'ndonga',
	'nia' => 'nias',
	'niu' => 'niuean',
	'nl' => 'hollandsk',
	'nl_BE' => 'flamsk',
	'nmg' => 'kwasio',
	'nn' => 'nynorsk',
	'nnh' => 'ngiemboon',
	'no' => 'norsk',
	'nog' => 'nogai',
	'non' => 'oldislandsk',
	'nqo' => 'n-ko',
	'nr' => 'sydndebele',
	'nso' => 'nordsotho',
	'nus' => 'nuer',
	'nv' => 'navajo',
	'nwc' => 'klassisk newarisk',
	'ny' => 'nyanja',
	'nym' => 'nyamwezi',
	'nyn' => 'nyankole',
	'nyo' => 'nyoro sprog',
	'nzi' => 'nzima',
	'oc' => 'occitansk',
	'oj' => 'ojibwa',
	'om' => 'oromo',
	'or' => 'oriya',
	'os' => 'ossetisk',
	'osa' => 'osage',
	'ota' => 'osmannisk-tyrkisk',
	'pa' => 'punjabi',
	'pag' => 'pangasinan',
	'pal' => 'pahlavi',
	'pam' => 'pampanga',
	'pap' => 'papiamento',
	'pau' => 'palauansk',
	'peo' => 'oldpersisk',
	'phn' => 'fønikisk',
	'pi' => 'pali',
	'pl' => 'polsk',
	'pon' => 'ponape',
	'pro' => 'oldprovencalsk',
	'ps' => 'pashto',
	'ps@alt=variant' => 'pushto',
	'pt' => 'portugisisk',
	'pt_BR' => 'brasiliansk portugisisk',
	'pt_PT' => 'europæisk portugisisk',
	'qu' => 'quechua',
	'quc' => 'quiché',
	'raj' => 'rajasthani',
	'rap' => 'rapanui',
	'rar' => 'rarotongan',
	'rm' => 'rætoromansk',
	'rn' => 'rundi',
	'ro' => 'rumænsk',
	'ro_MD' => 'moldovisk',
	'rof' => 'rombo',
	'rom' => 'romani',
	'root' => 'rot',
	'ru' => 'russisk',
	'rup' => 'arumænsk',
	'rw' => 'kinyarwanda',
	'rwk' => 'rwa',
	'sa' => 'sanskrit',
	'sad' => 'sandawe',
	'sah' => 'yakut',
	'sam' => 'samaritansk',
	'saq' => 'samburu',
	'sas' => 'sasak',
	'sat' => 'santali',
	'sba' => 'ngambay',
	'sbp' => 'sangu',
	'sc' => 'sardinsk',
	'scn' => 'siciliansk',
	'sco' => 'skotsk',
	'sd' => 'sindhi',
	'sdh' => 'sydkurdisk',
	'se' => 'nordsamisk',
	'see' => 'seneca',
	'seh' => 'sena',
	'sel' => 'selkupisk',
	'ses' => 'koyraboro senni',
	'sg' => 'sango',
	'sga' => 'oldirsk',
	'sh' => 'serbokroatisk',
	'shi' => 'tachelhit',
	'shn' => 'shan',
	'shu' => 'tchadisk-arabisk',
	'si' => 'singalesisk',
	'sid' => 'sidamo',
	'sk' => 'slovakisk',
	'sl' => 'slovensk',
	'sm' => 'samoansk',
	'sma' => 'sydsamisk',
	'smj' => 'lulesamisk',
	'smn' => 'enaresamisk',
	'sms' => 'skoltesamisk',
	'sn' => 'shona',
	'snk' => 'soninke',
	'so' => 'somalisk',
	'sog' => 'sogdiansk',
	'sq' => 'albansk',
	'sr' => 'serbisk',
	'srn' => 'sranan tongo',
	'srr' => 'serer',
	'ss' => 'swati',
	'ssy' => 'saho',
	'st' => 'sydsotho',
	'su' => 'sundanesisk',
	'suk' => 'sukuma',
	'sus' => 'susu',
	'sux' => 'sumerisk',
	'sv' => 'svensk',
	'sw' => 'swahili',
	'swb' => 'shimaore',
	'swc' => 'congolesisk swahili',
	'syc' => 'klassisk syrisk',
	'syr' => 'syrisk',
	'ta' => 'tamilsk',
	'te' => 'telugu',
	'tem' => 'temne',
	'teo' => 'teso',
	'ter' => 'tereno',
	'tet' => 'tetum',
	'tg' => 'tajik',
	'th' => 'thai',
	'ti' => 'tigrinya',
	'tig' => 'tigre',
	'tiv' => 'tivi',
	'tk' => 'turkmensk',
	'tkl' => 'tokelau',
	'tl' => 'tagalog',
	'tlh' => 'klingon',
	'tli' => 'tlingit',
	'tmh' => 'tamashek',
	'tn' => 'tswana',
	'to' => 'tongansk',
	'tog' => 'nyasa tongansk',
	'tpi' => 'tok pisin',
	'tr' => 'tyrkisk',
	'trv' => 'taroko',
	'ts' => 'tsonga',
	'tsi' => 'tsimshisk',
	'tt' => 'tatarisk',
	'tum' => 'tumbuka',
	'tvl' => 'tuvalu',
	'tw' => 'twi',
	'twq' => 'tasawaq',
	'ty' => 'tahitiansk',
	'tyv' => 'tuvinian',
	'tzm' => 'centralmarokkansk tamazight',
	'udm' => 'udmurt',
	'ug' => 'uygurisk',
	'ug@alt=variant' => 'uighurisk',
	'uga' => 'ugaristisk',
	'uk' => 'ukrainsk',
	'umb' => 'umbundu',
	'und' => 'ukendt sprog',
	'ur' => 'urdu',
	'uz' => 'usbekisk',
	'vai' => 'vai',
	've' => 'venda',
	'vi' => 'vietnamesisk',
	'vo' => 'volapyk',
	'vot' => 'votisk',
	'vun' => 'vunjo',
	'wa' => 'vallonsk',
	'wae' => 'walsertysk',
	'wal' => 'walamo',
	'war' => 'waray',
	'was' => 'washo',
	'wbp' => 'walbiri',
	'wo' => 'wolof',
	'xal' => 'kalmyk',
	'xh' => 'xhosa',
	'xog' => 'soga',
	'yao' => 'yao',
	'yap' => 'yapese',
	'yav' => 'yangben',
	'ybb' => 'yemba',
	'yi' => 'jiddisch',
	'yo' => 'yoruba',
	'yue' => 'kantonesisk',
	'za' => 'zhuang',
	'zap' => 'zapotec',
	'zbl' => 'blissymboler',
	'zen' => 'zenaga',
	'zgh' => 'tamazight',
	'zh' => 'kinesisk',
	'zh_Hans' => 'forenklet kinesisk',
	'zh_Hant' => 'traditionelt kinesisk',
	'zu' => 'zulu',
	'zun' => 'zuni',
	'zxx' => 'intet sprogligt indhold',
	'zza' => 'zaza',
};

is_deeply($locale->all_languages, $all_languages, 'All languages');

is($locale->script_name(), '', 'Script name from current locale');
is($locale->script_name('latn'), 'latinsk', 'Script name from string');
is($locale->script_name($other_locale), '', 'Script name from other locale object');

my $all_scripts = {
	'Afak' => 'afaka',
	'Arab' => 'arabisk',
	'Arab@alt=variant' => 'persisk-arabisk',
	'Armi' => 'armi',
	'Armn' => 'armensk',
	'Avst' => 'avestansk',
	'Bali' => 'balinesisk',
	'Bamu' => 'bamum',
	'Bass' => 'bassa',
	'Batk' => 'batak',
	'Beng' => 'bengali',
	'Blis' => 'blissymboler',
	'Bopo' => 'bopomofo',
	'Brah' => 'bramisk',
	'Brai' => 'brailleskrift',
	'Bugi' => 'buginesisk',
	'Buhd' => 'buhid',
	'Cakm' => 'cakm',
	'Cans' => 'oprindelige canadiske symboler',
	'Cari' => 'kariansk',
	'Cham' => 'cham',
	'Cher' => 'cherokee',
	'Cirt' => 'cirt',
	'Copt' => 'koptisk',
	'Cprt' => 'cypriotisk',
	'Cyrl' => 'kyrillisk',
	'Cyrs' => 'kyrillisk - oldkirkeslavisk variant',
	'Deva' => 'devanagari',
	'Dsrt' => 'deseret',
	'Dupl' => 'Duploya-stenografi',
	'Egyd' => 'egyptisk demotisk',
	'Egyh' => 'egyptisk hieratisk',
	'Egyp' => 'egyptiske hieroglyffer',
	'Ethi' => 'etiopisk',
	'Geok' => 'georgisk kutsuri',
	'Geor' => 'georgisk',
	'Glag' => 'glagolitisk',
	'Goth' => 'gotisk',
	'Gran' => 'grantha',
	'Grek' => 'græsk',
	'Gujr' => 'gujarati',
	'Guru' => 'gurmukhi',
	'Hang' => 'hangul',
	'Hani' => 'han',
	'Hano' => 'hanunoo',
	'Hans' => 'forenklet',
	'Hans@alt=stand-alone' => 'forenklet han',
	'Hant' => 'traditionelt',
	'Hant@alt=stand-alone' => 'traditionelt han',
	'Hebr' => 'hebraisk',
	'Hira' => 'hiragana',
	'Hluw' => 'anatolske hieroglyffer',
	'Hmng' => 'pahawh hmong',
	'Hrkt' => 'katakana eller hiragana',
	'Hung' => 'oldungarsk',
	'Inds' => 'indus',
	'Ital' => 'Olditalisk',
	'Java' => 'javanesisk',
	'Jpan' => 'japansk',
	'Jurc' => 'jurchen',
	'Kali' => 'kaya li',
	'Kana' => 'katakana',
	'Khar' => 'kharoshti',
	'Khmr' => 'khmer',
	'Khoj' => 'khojki',
	'Knda' => 'kannada',
	'Kore' => 'koreansk',
	'Kpel' => 'kpelle',
	'Kthi' => 'kthi',
	'Lana' => 'lanna',
	'Laoo' => 'lao',
	'Latf' => 'latinsk - frakturvariant',
	'Latg' => 'latinsk - gælisk variant',
	'Latn' => 'latinsk',
	'Lepc' => 'lepcha',
	'Limb' => 'limbu',
	'Lina' => 'lineær A',
	'Linb' => 'lineær B',
	'Lisu' => 'lisu',
	'Loma' => 'loma',
	'Lyci' => 'lykisk',
	'Lydi' => 'lydisk',
	'Mand' => 'mandaisk',
	'Mani' => 'manikæisk',
	'Maya' => 'mayahieroglyffer',
	'Mend' => 'mende',
	'Merc' => 'metroitisk sammenhængende',
	'Mero' => 'meroitisk',
	'Mlym' => 'malayalam',
	'Mong' => 'mongolsk',
	'Moon' => 'moon',
	'Mroo' => 'mroo',
	'Mtei' => 'meitei-mayek',
	'Mymr' => 'burmesisk',
	'Narb' => 'gammelt nordarabisk',
	'Nbat' => 'nabateisk',
	'Nkgb' => 'nakhi geba',
	'Nkoo' => 'n’ko',
	'Nshu' => 'nüshu',
	'Ogam' => 'ogham',
	'Olck' => 'ol-chiki',
	'Orkh' => 'orkhon',
	'Orya' => 'oriya',
	'Osma' => 'osmannisk',
	'Palm' => 'palmyrensk',
	'Perm' => 'oldpermisk',
	'Phag' => 'phags-pa',
	'Phli' => 'phli',
	'Phlp' => 'phlp',
	'Phlv' => 'pahlavi',
	'Phnx' => 'fønikisk',
	'Plrd' => 'pollardtegn',
	'Prti' => 'prti',
	'Rjng' => 'rejang',
	'Roro' => 'rongo-rongo',
	'Runr' => 'runer',
	'Samr' => 'samaritansk',
	'Sara' => 'sarati',
	'Sarb' => 'oldsørarabisk',
	'Saur' => 'saurashtra',
	'Sgnw' => 'tegnskrift',
	'Shaw' => 'shavisk',
	'Shrd' => 'sharada',
	'Sind' => 'khudawadi',
	'Sinh' => 'singalesisk',
	'Sora' => 'sora',
	'Sund' => 'sundanesisk',
	'Sylo' => 'syloti nagri',
	'Syrc' => 'syrisk',
	'Syre' => 'syrisk - estrangelovariant',
	'Syrj' => 'vestsyrisk',
	'Syrn' => 'østsyriakisk',
	'Tagb' => 'tagbanwa',
	'Takr' => 'takri',
	'Tale' => 'tai le',
	'Talu' => 'tai lue',
	'Taml' => 'tamilsk',
	'Tang' => 'tangut',
	'Tavt' => 'tavt',
	'Telu' => 'telugu',
	'Teng' => 'tengwar',
	'Tfng' => 'tifinagh',
	'Tglg' => 'tagalog',
	'Thaa' => 'thaana',
	'Thai' => 'thailandsk',
	'Tibt' => 'tibetansk',
	'Tirh' => 'tirhuta',
	'Ugar' => 'ugaritisk',
	'Vaii' => 'vai',
	'Visp' => 'synlig tale',
	'Wara' => 'varang kshiti',
	'Wole' => 'woleai',
	'Xpeo' => 'oldpersisk',
	'Xsux' => 'sumero-akkadisk cuneiform',
	'Yiii' => 'yi',
	'Zinh' => 'arvet',
	'Zmth' => 'zmth',
	'Zsym' => 'zsym',
	'Zxxx' => 'uden skriftsprog',
	'Zyyy' => 'fælles',
	'Zzzz' => 'ukendt skriftsprog',
};

is_deeply($locale->all_scripts, $all_scripts, 'All scripts');

is($locale->region_name(), 'Danmark', 'Territory name from current locale');
is($locale->region_name('fr'), 'Frankrig', 'Territory name from string');
is($locale->region_name($other_locale), 'USA', 'Territory name from other locale object');

my $all_regions = {
	'001' => 'Verden',
	'002' => 'Afrika',
	'003' => 'Nordamerika',
	'005' => 'Sydamerika',
	'009' => 'Oceanien',
	'011' => 'Vestafrika',
	'013' => 'Mellemamerika',
	'014' => 'Østafrika',
	'015' => 'Nordafrika',
	'017' => 'Centralafrika',
	'018' => 'Det sydlige Afrika',
	'019' => 'Amerika',
	'021' => 'Det nordlige Amerika',
	'029' => 'Caribien',
	'030' => 'Østasien',
	'034' => 'Sydasien',
	'035' => 'Sydøstasien',
	'039' => 'Sydeuropa',
	'053' => 'Australasien',
	'054' => 'Melanesien',
	'057' => 'Mikronesien',
	'061' => 'Polynesien',
	'142' => 'Asien',
	'143' => 'Centralasien',
	'145' => 'Vestasien',
	'150' => 'Europa',
	'151' => 'Østeuropa',
	'154' => 'Nordeuropa',
	'155' => 'Vesteuropa',
	'419' => 'Latinamerika',
	'AC' => 'Ascensionøen',
	'AD' => 'Andorra',
	'AE' => 'De Forenede Arabiske Emirater',
	'AF' => 'Afghanistan',
	'AG' => 'Antigua og Barbuda',
	'AI' => 'Anguilla',
	'AL' => 'Albanien',
	'AM' => 'Armenien',
	'AN' => 'Hollandske Antiller',
	'AO' => 'Angola',
	'AQ' => 'Antarktis',
	'AR' => 'Argentina',
	'AS' => 'Amerikansk Samoa',
	'AT' => 'Østrig',
	'AU' => 'Australien',
	'AW' => 'Aruba',
	'AX' => 'Åland',
	'AZ' => 'Aserbajdsjan',
	'BA' => 'Bosnien-Hercegovina',
	'BB' => 'Barbados',
	'BD' => 'Bangladesh',
	'BE' => 'Belgien',
	'BF' => 'Burkina Faso',
	'BG' => 'Bulgarien',
	'BH' => 'Bahrain',
	'BI' => 'Burundi',
	'BJ' => 'Benin',
	'BL' => 'Saint Barthélemy',
	'BM' => 'Bermuda',
	'BN' => 'Brunei',
	'BO' => 'Bolivia',
	'BQ' => 'De Nederlandske Antiller',
	'BR' => 'Brasilien',
	'BS' => 'Bahamas',
	'BT' => 'Bhutan',
	'BV' => 'Bouvetøen',
	'BW' => 'Botswana',
	'BY' => 'Hviderusland',
	'BZ' => 'Belize',
	'CA' => 'Canada',
	'CC' => 'Cocosøerne',
	'CD' => 'Congo-Kinshasa',
	'CD@alt=variant' => 'Den Demokratiske Republik Congo',
	'CF' => 'Den Centralafrikanske Republik',
	'CG' => 'Congo-Brazzaville',
	'CG@alt=variant' => 'Republikken Congo',
	'CH' => 'Schweiz',
	'CI' => 'Elfenbenskysten',
	'CK' => 'Cookøerne',
	'CL' => 'Chile',
	'CM' => 'Cameroun',
	'CN' => 'Kina',
	'CO' => 'Colombia',
	'CP' => 'Clippertonøen',
	'CR' => 'Costa Rica',
	'CU' => 'Cuba',
	'CV' => 'Kap Verde',
	'CW' => 'Curaçao',
	'CX' => 'Juleøen',
	'CY' => 'Cypern',
	'CZ' => 'Tjekkiet',
	'DE' => 'Tyskland',
	'DG' => 'Diego Garcia',
	'DJ' => 'Djibouti',
	'DK' => 'Danmark',
	'DM' => 'Dominica',
	'DO' => 'Den Dominikanske Republik',
	'DZ' => 'Algeriet',
	'EA' => 'Ceuta og Melilla',
	'EC' => 'Ecuador',
	'EE' => 'Estland',
	'EG' => 'Egypten',
	'EH' => 'Vestsahara',
	'ER' => 'Eritrea',
	'ES' => 'Spanien',
	'ET' => 'Etiopien',
	'EU' => 'Den Europæiske Union',
	'FI' => 'Finland',
	'FJ' => 'Fiji',
	'FK' => 'Falklandsøerne',
	'FK@alt=variant' => 'Falklandsøerne (Islas Malvinas)',
	'FM' => 'Mikronesiens Forenede Stater',
	'FO' => 'Færøerne',
	'FR' => 'Frankrig',
	'GA' => 'Gabon',
	'GB' => 'Storbritannien',
	'GB@alt=short' => 'UK',
	'GD' => 'Grenada',
	'GE' => 'Georgien',
	'GF' => 'Fransk Guyana',
	'GG' => 'Guernsey',
	'GH' => 'Ghana',
	'GI' => 'Gibraltar',
	'GL' => 'Grønland',
	'GM' => 'Gambia',
	'GN' => 'Guinea',
	'GP' => 'Guadeloupe',
	'GQ' => 'Ækvatorialguinea',
	'GR' => 'Grækenland',
	'GS' => 'South Georgia og South Sandwich Islands',
	'GT' => 'Guatemala',
	'GU' => 'Guam',
	'GW' => 'Guinea-Bissau',
	'GY' => 'Guyana',
	'HK' => 'Hongkong SAR',
	'HK@alt=short' => 'Hongkong',
	'HM' => 'Heard Island og McDonald Islands',
	'HN' => 'Honduras',
	'HR' => 'Kroatien',
	'HT' => 'Haiti',
	'HU' => 'Ungarn',
	'IC' => 'Kanariske øer',
	'ID' => 'Indonesien',
	'IE' => 'Irland',
	'IL' => 'Israel',
	'IM' => 'Isle of Man',
	'IN' => 'Indien',
	'IO' => 'Det britiske territorium i Det Indiske Ocean',
	'IQ' => 'Irak',
	'IR' => 'Iran',
	'IS' => 'Island',
	'IT' => 'Italien',
	'JE' => 'Jersey',
	'JM' => 'Jamaica',
	'JO' => 'Jordan',
	'JP' => 'Japan',
	'KE' => 'Kenya',
	'KG' => 'Kirgisistan',
	'KH' => 'Cambodja',
	'KI' => 'Kiribati',
	'KM' => 'Comorerne',
	'KN' => 'Saint Kitts og Nevis',
	'KP' => 'Nordkorea',
	'KR' => 'Sydkorea',
	'KW' => 'Kuwait',
	'KY' => 'Caymanøerne',
	'KZ' => 'Kasakhstan',
	'LA' => 'Laos',
	'LB' => 'Libanon',
	'LC' => 'Saint Lucia',
	'LI' => 'Liechtenstein',
	'LK' => 'Sri Lanka',
	'LR' => 'Liberia',
	'LS' => 'Lesotho',
	'LT' => 'Litauen',
	'LU' => 'Luxembourg',
	'LV' => 'Letland',
	'LY' => 'Libyen',
	'MA' => 'Marokko',
	'MC' => 'Monaco',
	'MD' => 'Moldova',
	'ME' => 'Montenegro',
	'MF' => 'Saint Martin',
	'MG' => 'Madagaskar',
	'MH' => 'Marshalløerne',
	'MK' => 'Makedonien',
	'MK@alt=variant' => 'Den tidligere jugoslaviske republik Makedonien',
	'ML' => 'Mali',
	'MM' => 'Myanmar (Burma)',
	'MN' => 'Mongoliet',
	'MO' => 'Macao SAR',
	'MO@alt=short' => 'Macao',
	'MP' => 'Nordmarianerne',
	'MQ' => 'Martinique',
	'MR' => 'Mauretanien',
	'MS' => 'Montserrat',
	'MT' => 'Malta',
	'MU' => 'Mauritius',
	'MV' => 'Maldiverne',
	'MW' => 'Malawi',
	'MX' => 'Mexico',
	'MY' => 'Malaysia',
	'MZ' => 'Mozambique',
	'NA' => 'Namibia',
	'NC' => 'Ny Kaledonien',
	'NE' => 'Niger',
	'NF' => 'Norfolk Island',
	'NG' => 'Nigeria',
	'NI' => 'Nicaragua',
	'NL' => 'Nederlandene',
	'NO' => 'Norge',
	'NP' => 'Nepal',
	'NR' => 'Nauru',
	'NU' => 'Niue',
	'NZ' => 'New Zealand',
	'OM' => 'Oman',
	'PA' => 'Panama',
	'PE' => 'Peru',
	'PF' => 'Fransk Polynesien',
	'PG' => 'Papua Ny Guinea',
	'PH' => 'Filippinerne',
	'PK' => 'Pakistan',
	'PL' => 'Polen',
	'PM' => 'Saint Pierre og Miquelon',
	'PN' => 'Pitcairn',
	'PR' => 'Puerto Rico',
	'PS' => 'De palæstinensiske områder',
	'PS@alt=short' => 'Palæstina',
	'PT' => 'Portugal',
	'PW' => 'Palau',
	'PY' => 'Paraguay',
	'QA' => 'Qatar',
	'QO' => 'Ydre Oceanien',
	'RE' => 'Réunion',
	'RO' => 'Rumænien',
	'RS' => 'Serbien',
	'RU' => 'Rusland',
	'RW' => 'Rwanda',
	'SA' => 'Saudi-Arabien',
	'SB' => 'Salomonøerne',
	'SC' => 'Seychellerne',
	'SD' => 'Sudan',
	'SE' => 'Sverige',
	'SG' => 'Singapore',
	'SH' => 'St. Helena',
	'SI' => 'Slovenien',
	'SJ' => 'Svalbard og Jan Mayen',
	'SK' => 'Slovakiet',
	'SL' => 'Sierra Leone',
	'SM' => 'San Marino',
	'SN' => 'Senegal',
	'SO' => 'Somalia',
	'SR' => 'Surinam',
	'SS' => 'Sydsudan',
	'ST' => 'São Tomé og Príncipe',
	'SV' => 'El Salvador',
	'SX' => 'Sint Maarten',
	'SY' => 'Syrien',
	'SZ' => 'Swaziland',
	'TA' => 'Tristan da Cunha',
	'TC' => 'Turks- og Caicosøerne',
	'TD' => 'Tchad',
	'TF' => 'De franske besiddelser i Det Sydlige Indiske Ocean',
	'TG' => 'Togo',
	'TH' => 'Thailand',
	'TJ' => 'Tadsjikistan',
	'TK' => 'Tokelau',
	'TL' => 'Timor-Leste',
	'TL@alt=variant' => 'Østtimor',
	'TM' => 'Turkmenistan',
	'TN' => 'Tunesien',
	'TO' => 'Tonga',
	'TR' => 'Tyrkiet',
	'TT' => 'Trinidad og Tobago',
	'TV' => 'Tuvalu',
	'TW' => 'Taiwan',
	'TZ' => 'Tanzania',
	'UA' => 'Ukraine',
	'UG' => 'Uganda',
	'UM' => 'Amerikanske oversøiske øer',
	'US' => 'USA',
	'US@alt=short' => 'USA',
	'UY' => 'Uruguay',
	'UZ' => 'Usbekistan',
	'VA' => 'Vatikanstaten',
	'VC' => 'Saint Vincent og Grenadinerne',
	'VE' => 'Venezuela',
	'VG' => 'De Britiske Jomfruøer',
	'VI' => 'De Amerikanske Jomfruøer',
	'VN' => 'Vietnam',
	'VU' => 'Vanuatu',
	'WF' => 'Wallis og Futuna',
	'WS' => 'Samoa',
	'XK' => 'Kosovo',
	'YE' => 'Yemen',
	'YT' => 'Mayotte',
	'ZA' => 'Sydafrika',
	'ZM' => 'Zambia',
	'ZW' => 'Zimbabwe',
	'ZZ' => 'Ukendt område',
};

is_deeply($locale->all_regions(), $all_regions, 'All Regions');

is($locale->variant_name(), '', 'Variant name from current locale');
is($locale->variant_name('BOHORIC'), 'Bohorič-alfabet', 'Variant name from string');
is($locale->variant_name($other_locale), '', 'Variant name from other locale object');

is($locale->key_name('colCaseLevel'), 'Sortering med forskel på små og store bogstaver', 'Key name from string');

is($locale->type_name(colCaseFirst => 'lower'), 'Sortér med små bogstaver først', 'Type name from string');

is($locale->measurement_system_name('metric'), 'Det metriske system', 'Measurement system name English Metric');
is($locale->measurement_system_name('us'), 'De amerikanske målesystemer', 'Measurement system name English US');
is($locale->measurement_system_name('uk'), 'De britiske målesystemer', 'Measurement system name English UK');

is($locale->transform_name('Numeric'), 'Numerisk', 'Transform name from string');