=head1

Locale::CLDR::Locales::Cy - Package for language Welsh

=cut

package Locale::CLDR::Locales::Cy;
# This file auto generated from Data\common\main\cy.xml
#	on Sat  6 Feb 10:33:18 am GMT

use version;

our $VERSION = version->declare('v0.28.3');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';

use Moose;

extends('Locale::CLDR::Locales::Root');
has 'valid_algorithmic_formats' => (
	is => 'ro',
	isa => 'ArrayRef',
	init_arg => undef,
	default => sub {[ 'spellout-numbering-year','spellout-numbering','spellout-cardinal-masculine','spellout-cardinal-masculine-before-consonant','spellout-cardinal-feminine','spellout-cardinal-feminine-before-consonant' ]},
);

has 'algorithmic_number_format_data' => (
	is => 'ro',
	isa => 'HashRef',
	init_arg => undef,
	default => sub { 
		use bignum;
		return {
		'spellout-cardinal-feminine' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(minws →→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(dim),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(←← pwynt →→),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(un),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(dwy),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(tair),
				},
				'4' => {
					base_value => q(4),
					divisor => q(1),
					rule => q(pedair),
				},
				'5' => {
					base_value => q(5),
					divisor => q(1),
					rule => q(pump),
				},
				'6' => {
					base_value => q(6),
					divisor => q(1),
					rule => q(chwech),
				},
				'7' => {
					base_value => q(7),
					divisor => q(1),
					rule => q(saith),
				},
				'8' => {
					base_value => q(8),
					divisor => q(1),
					rule => q(wyth),
				},
				'9' => {
					base_value => q(9),
					divisor => q(1),
					rule => q(naw),
				},
				'10' => {
					base_value => q(10),
					divisor => q(10),
					rule => q(un deg[ →→]),
				},
				'20' => {
					base_value => q(20),
					divisor => q(10),
					rule => q(dau ddeg[ →→]),
				},
				'30' => {
					base_value => q(30),
					divisor => q(10),
					rule => q(←%spellout-cardinal-masculine-before-consonant← deg[ →→]),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(←%spellout-cardinal-masculine-before-consonant← cant[ →→]),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(←%spellout-cardinal-masculine-before-consonant← mil[ →→]),
				},
				'1000000' => {
					base_value => q(1000000),
					divisor => q(1000000),
					rule => q(←%spellout-cardinal-masculine-before-consonant← miliwn[ →→]),
				},
				'1000000000' => {
					base_value => q(1000000000),
					divisor => q(1000000000),
					rule => q(←%spellout-cardinal-masculine-before-consonant← biliwn[ →→]),
				},
				'1000000000000' => {
					base_value => q(1000000000000),
					divisor => q(1000000000000),
					rule => q(←%spellout-cardinal-masculine-before-consonant← triliwn[ →→]),
				},
				'1000000000000000' => {
					base_value => q(1000000000000000),
					divisor => q(1000000000000000),
					rule => q(←%spellout-cardinal-masculine-before-consonant← kwadriliwn[ →→]),
				},
				'1000000000000000000' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
				'max' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
			},
		},
		'spellout-cardinal-feminine-before-consonant' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(minws →→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(dim),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(←← pwynt →→),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(un),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(dwy),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(tair),
				},
				'4' => {
					base_value => q(4),
					divisor => q(1),
					rule => q(pedair),
				},
				'5' => {
					base_value => q(5),
					divisor => q(1),
					rule => q(pum),
				},
				'6' => {
					base_value => q(6),
					divisor => q(1),
					rule => q(chwe),
				},
				'7' => {
					base_value => q(7),
					divisor => q(1),
					rule => q(saith),
				},
				'8' => {
					base_value => q(8),
					divisor => q(1),
					rule => q(wyth),
				},
				'9' => {
					base_value => q(9),
					divisor => q(1),
					rule => q(naw),
				},
				'10' => {
					base_value => q(10),
					divisor => q(10),
					rule => q(un deg[ →→]),
				},
				'20' => {
					base_value => q(20),
					divisor => q(10),
					rule => q(dau ddeg[ →→]),
				},
				'30' => {
					base_value => q(30),
					divisor => q(10),
					rule => q(←%spellout-cardinal-masculine-before-consonant← deg[ →→]),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(←%spellout-cardinal-masculine-before-consonant← cant[ →→]),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(←%spellout-cardinal-masculine-before-consonant← mil[ →→]),
				},
				'1000000' => {
					base_value => q(1000000),
					divisor => q(1000000),
					rule => q(←%spellout-cardinal-masculine-before-consonant← miliwn[ →→]),
				},
				'1000000000' => {
					base_value => q(1000000000),
					divisor => q(1000000000),
					rule => q(←%spellout-cardinal-masculine-before-consonant← biliwn[ →→]),
				},
				'1000000000000' => {
					base_value => q(1000000000000),
					divisor => q(1000000000000),
					rule => q(←%spellout-cardinal-masculine-before-consonant← triliwn[ →→]),
				},
				'1000000000000000' => {
					base_value => q(1000000000000000),
					divisor => q(1000000000000000),
					rule => q(←%spellout-cardinal-masculine-before-consonant← kwadriliwn[ →→]),
				},
				'1000000000000000000' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
				'max' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
			},
		},
		'spellout-cardinal-masculine' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(minws →→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(dim),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(←← pwynt →→),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(un),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(dau),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(tri),
				},
				'4' => {
					base_value => q(4),
					divisor => q(1),
					rule => q(pedwar),
				},
				'5' => {
					base_value => q(5),
					divisor => q(1),
					rule => q(pump),
				},
				'6' => {
					base_value => q(6),
					divisor => q(1),
					rule => q(chwech),
				},
				'7' => {
					base_value => q(7),
					divisor => q(1),
					rule => q(saith),
				},
				'8' => {
					base_value => q(8),
					divisor => q(1),
					rule => q(wyth),
				},
				'9' => {
					base_value => q(9),
					divisor => q(1),
					rule => q(naw),
				},
				'10' => {
					base_value => q(10),
					divisor => q(10),
					rule => q(un deg[ →→]),
				},
				'20' => {
					base_value => q(20),
					divisor => q(10),
					rule => q(dau ddeg[ →→]),
				},
				'30' => {
					base_value => q(30),
					divisor => q(10),
					rule => q(←%spellout-cardinal-masculine-before-consonant← deg[ →→]),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(←%spellout-cardinal-masculine-before-consonant← cant[ →→]),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(←%spellout-cardinal-masculine-before-consonant← mil[ →→]),
				},
				'1000000' => {
					base_value => q(1000000),
					divisor => q(1000000),
					rule => q(←%spellout-cardinal-masculine-before-consonant← miliwn[ →→]),
				},
				'1000000000' => {
					base_value => q(1000000000),
					divisor => q(1000000000),
					rule => q(←%spellout-cardinal-masculine-before-consonant← biliwn[ →→]),
				},
				'1000000000000' => {
					base_value => q(1000000000000),
					divisor => q(1000000000000),
					rule => q(←%spellout-cardinal-masculine-before-consonant← triliwn[ →→]),
				},
				'1000000000000000' => {
					base_value => q(1000000000000000),
					divisor => q(1000000000000000),
					rule => q(←%spellout-cardinal-masculine-before-consonant← kwadriliwn[ →→]),
				},
				'1000000000000000000' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
				'max' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
			},
		},
		'spellout-cardinal-masculine-before-consonant' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(minws →→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(dim),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(←← pwynt →→),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(un),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(dau),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(tri),
				},
				'4' => {
					base_value => q(4),
					divisor => q(1),
					rule => q(pedwar),
				},
				'5' => {
					base_value => q(5),
					divisor => q(1),
					rule => q(pum),
				},
				'6' => {
					base_value => q(6),
					divisor => q(1),
					rule => q(chwe),
				},
				'7' => {
					base_value => q(7),
					divisor => q(1),
					rule => q(saith),
				},
				'8' => {
					base_value => q(8),
					divisor => q(1),
					rule => q(wyth),
				},
				'9' => {
					base_value => q(9),
					divisor => q(1),
					rule => q(naw),
				},
				'10' => {
					base_value => q(10),
					divisor => q(10),
					rule => q(un deg[ →→]),
				},
				'20' => {
					base_value => q(20),
					divisor => q(10),
					rule => q(dau ddeg[ →→]),
				},
				'30' => {
					base_value => q(30),
					divisor => q(10),
					rule => q(←%spellout-cardinal-masculine-before-consonant← deg[ →→]),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(←%spellout-cardinal-masculine-before-consonant← cant[ →→]),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(←%spellout-cardinal-masculine-before-consonant← mil[ →→]),
				},
				'1000000' => {
					base_value => q(1000000),
					divisor => q(1000000),
					rule => q(←%spellout-cardinal-masculine-before-consonant← miliwn[ →→]),
				},
				'1000000000' => {
					base_value => q(1000000000),
					divisor => q(1000000000),
					rule => q(←%spellout-cardinal-masculine-before-consonant← biliwn[ →→]),
				},
				'1000000000000' => {
					base_value => q(1000000000000),
					divisor => q(1000000000000),
					rule => q(←%spellout-cardinal-masculine-before-consonant← triliwn[ →→]),
				},
				'1000000000000000' => {
					base_value => q(1000000000000000),
					divisor => q(1000000000000000),
					rule => q(←%spellout-cardinal-masculine-before-consonant← kwadriliwn[ →→]),
				},
				'1000000000000000000' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
				'max' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
			},
		},
		'spellout-numbering' => {
			'public' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-cardinal-masculine=),
				},
				'max' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-cardinal-masculine=),
				},
			},
		},
		'spellout-numbering-year' => {
			'public' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-numbering=),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(=#,###0.#=),
				},
				'max' => {
					divisor => q(1),
					rule => q(=#,###0.#=),
				},
			},
		},
	} },
);

# Need to add code for Key type pattern
sub display_name_pattern {
	my ($self, $name, $region, $script, $variant) = @_;

	my $display_pattern = '{0} ({1})';
	$display_pattern =~s/\{0\}/$name/g;
	my $subtags = join '{0}, {1}', grep {$_} (
		$region,
		$script,
		$variant,
	);

	$display_pattern =~s/\{1\}/$subtags/g;
	return $display_pattern;
}

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub { 
		 sub {
			 my %languages = (
				'aa' => 'Affareg',
 				'ab' => 'Abchaseg',
 				'ace' => 'Acehneg',
 				'ach' => 'Acoli',
 				'ada' => 'Adangmeg',
 				'ady' => 'Circaseg Gorllewinol',
 				'ae' => 'Afestaneg',
 				'aeb' => 'Arabeg Tunisia',
 				'af' => 'Affricâneg',
 				'afh' => 'Affrihili',
 				'agq' => 'Aghemeg',
 				'ain' => 'Ainŵeg',
 				'ak' => 'Acaneg',
 				'akk' => 'Acadeg',
 				'akz' => 'Alabamäeg',
 				'ale' => 'Alewteg',
 				'aln' => 'Ghegeg Albania',
 				'alt' => 'Altäeg Deheuol',
 				'am' => 'Amhareg',
 				'an' => 'Aragoneg',
 				'ang' => 'Hen Saesneg',
 				'anp' => 'Angika',
 				'ar' => 'Arabeg',
 				'ar_001' => 'Arabeg Modern Safonol',
 				'arc' => 'Aramaeg',
 				'arn' => 'Arawcaneg',
 				'aro' => 'Araonaeg',
 				'arp' => 'Arapaho',
 				'arq' => 'Arabeg Algeria',
 				'arw' => 'Arawaceg',
 				'ary' => 'Arabeg Moroco',
 				'arz' => 'Arabeg yr Aifft',
 				'as' => 'Asameg',
 				'asa' => 'Asw',
 				'ase' => 'Iaith Arwyddion America',
 				'ast' => 'Astwrianeg',
 				'av' => 'Afareg',
 				'awa' => 'Awadhi',
 				'ay' => 'Aymareg',
 				'az' => 'Aserbaijaneg',
 				'az@alt=short' => 'Aseri',
 				'az_Arab' => 'Aserbaijaneg Deheuol',
 				'ba' => 'Bashcorteg',
 				'bal' => 'Balwtsi',
 				'ban' => 'Balïeg',
 				'bas' => 'Basâeg',
 				'bax' => 'Bamwmeg',
 				'be' => 'Belarwseg',
 				'bej' => 'Bejäeg',
 				'bem' => 'Bembeg',
 				'bez' => 'Bena',
 				'bfd' => 'Baffwteg',
 				'bfq' => 'Badaga',
 				'bg' => 'Bwlgareg',
 				'bgn' => 'Balochi Gorllewinol',
 				'bi' => 'Bislama',
 				'bkm' => 'Comeg',
 				'bla' => 'Siksika',
 				'bm' => 'Bambareg',
 				'bn' => 'Bengaleg',
 				'bo' => 'Tibeteg',
 				'br' => 'Llydaweg',
 				'brh' => 'Brahui',
 				'brx' => 'Bodo',
 				'bs' => 'Bosnieg',
 				'bss' => 'Acwseg',
 				'bua' => 'Bwriateg',
 				'bum' => 'Bwlw',
 				'ca' => 'Catalaneg',
 				'cad' => 'Cado',
 				'car' => 'Caribeg',
 				'cch' => 'Atsameg',
 				'ce' => 'Tsietsieneg',
 				'cgg' => 'Tsiga',
 				'ch' => 'Tsiamorro',
 				'chm' => 'Marieg',
 				'cho' => 'Siocto',
 				'chr' => 'Tsierocî',
 				'chy' => 'Cheyenne',
 				'ckb' => 'Cwrdeg Sorani',
 				'co' => 'Corseg',
 				'cop' => 'Copteg',
 				'cr' => 'Cri',
 				'crh' => 'Tyrceg y Crimea',
 				'cs' => 'Tsieceg',
 				'cu' => 'Hen Slafoneg',
 				'cv' => 'Tshwfasheg',
 				'cy' => 'Cymraeg',
 				'da' => 'Daneg',
 				'dak' => 'Dacotaeg',
 				'dar' => 'Dargwa',
 				'dav' => 'Taita',
 				'de' => 'Almaeneg',
 				'de_AT' => 'Almaeneg Awstria',
 				'de_CH' => 'Almaeneg Safonol y Swistir',
 				'din' => 'Dinca',
 				'dje' => 'Zarmaeg',
 				'doi' => 'Dogri',
 				'dsb' => 'Sorbeg Isaf',
 				'dua' => 'Diwaleg',
 				'dum' => 'Iseldireg Canol',
 				'dv' => 'Difehi',
 				'dyo' => 'Jola-Fonyi',
 				'dz' => 'Dzongkha',
 				'ebu' => 'Embw',
 				'ee' => 'Ewe',
 				'egy' => 'Hen Eiffteg',
 				'el' => 'Groeg',
 				'elx' => 'Elameg',
 				'en' => 'Saesneg',
 				'en_AU' => 'Saesneg Awstralia',
 				'en_CA' => 'Saesneg Canada',
 				'en_GB' => 'Saesneg Prydain',
 				'en_GB@alt=short' => 'Saesneg (DU)',
 				'en_US' => 'Saesneg America',
 				'en_US@alt=short' => 'Saesneg (UDA)',
 				'enm' => 'Saesneg Canol',
 				'eo' => 'Esperanto',
 				'es' => 'Sbaeneg',
 				'es_419' => 'Sbaeneg America Ladin',
 				'es_ES' => 'Sbaeneg Ewrop',
 				'es_MX' => 'Sbaeneg Mecsico',
 				'et' => 'Estoneg',
 				'eu' => 'Basgeg',
 				'ewo' => 'Ewondo',
 				'ext' => 'Extremadureg',
 				'fa' => 'Perseg',
 				'fat' => 'Ffanti',
 				'ff' => 'Ffwla',
 				'fi' => 'Ffinneg',
 				'fil' => 'Ffilipineg',
 				'fit' => 'Ffinneg Tornedal',
 				'fj' => 'Ffijïeg',
 				'fo' => 'Ffaröeg',
 				'fr' => 'Ffrangeg',
 				'fr_CA' => 'Ffrangeg Canada',
 				'fr_CH' => 'Ffrangeg y Swistir',
 				'frc' => 'Ffrangeg Cajwn',
 				'frm' => 'Ffrangeg Canol',
 				'fro' => 'Hen Ffrangeg',
 				'frp' => 'Arpitaneg',
 				'frr' => 'Ffriseg y Gogledd',
 				'frs' => 'Ffriseg y Dwyrain',
 				'fur' => 'Ffriwleg',
 				'fy' => 'Ffriseg y Gorllewin',
 				'ga' => 'Gwyddeleg',
 				'gag' => 'Gagauz',
 				'gay' => 'Gaio',
 				'gba' => 'Gbaia',
 				'gbz' => 'Dareg y Zoroastriaid',
 				'gd' => 'Gaeleg yr Alban',
 				'gil' => 'Gilberteg',
 				'gl' => 'Galisieg',
 				'gmh' => 'Uchel Almaeneg Canol',
 				'gn' => 'Guaraní',
 				'goh' => 'Hen Uchel Almaeneg',
 				'got' => 'Gotheg',
 				'grc' => 'Hen Roeg',
 				'gsw' => 'Almaeneg y Swistir',
 				'gu' => 'Gwjarati',
 				'guz' => 'Gusii',
 				'gv' => 'Manaweg',
 				'ha' => 'Hawsa',
 				'hai' => 'Haida',
 				'haw' => 'Hawäieg',
 				'he' => 'Hebraeg',
 				'hi' => 'Hindi',
 				'hit' => 'Hetheg',
 				'hmn' => 'Hmongeg',
 				'hr' => 'Croateg',
 				'hsb' => 'Sorbeg Uchaf',
 				'ht' => 'Creol Haiti',
 				'hu' => 'Hwngareg',
 				'hy' => 'Armeneg',
 				'hz' => 'Herero',
 				'ia' => 'Interlingua',
 				'iba' => 'Ibaneg',
 				'ibb' => 'Ibibio',
 				'id' => 'Indoneseg',
 				'ie' => 'Interlingue',
 				'ig' => 'Igbo',
 				'ii' => 'Nwosw',
 				'ik' => 'Inwpiaceg',
 				'ilo' => 'Ilocaneg',
 				'inh' => 'Ingwsieg',
 				'is' => 'Islandeg',
 				'it' => 'Eidaleg',
 				'iu' => 'Inwctitwt',
 				'ja' => 'Japaneeg',
 				'jgo' => 'Ngomba',
 				'jmc' => 'Matsiame',
 				'jpr' => 'Iddew-Bersieg',
 				'jrb' => 'Iddew-Arabeg',
 				'jv' => 'Jafanaeg',
 				'ka' => 'Georgeg',
 				'kaa' => 'Cara-Calpaceg',
 				'kab' => 'Cabileg',
 				'kam' => 'Camba',
 				'kbd' => 'Circaseg Dwyreiniol',
 				'kcg' => 'Tyapeg',
 				'kde' => 'Macondeg',
 				'kea' => 'Caboferdianeg',
 				'kg' => 'Congo',
 				'kha' => 'Càseg',
 				'khq' => 'Koyra Chiini',
 				'khw' => 'Chowareg',
 				'ki' => 'Kikuyu',
 				'kk' => 'Casacheg',
 				'kl' => 'Kalaallisut',
 				'kln' => 'Kalenjin',
 				'km' => 'Chmereg',
 				'kn' => 'Kannada',
 				'ko' => 'Coreeg',
 				'koi' => 'Komi-Permyak',
 				'kok' => 'Concani',
 				'kr' => 'Canwri',
 				'krl' => 'Careleg',
 				'ks' => 'Cashmireg',
 				'ksb' => 'Shambala',
 				'ksf' => 'Baffia',
 				'ksh' => 'Cwleneg',
 				'ku' => 'Cwrdeg',
 				'kum' => 'Cwmiceg',
 				'kv' => 'Comi',
 				'kw' => 'Cernyweg',
 				'ky' => 'Cirgiseg',
 				'la' => 'Lladin',
 				'lad' => 'Iddew-Sbaeneg',
 				'lag' => 'Langi',
 				'lah' => 'Lahnda',
 				'lam' => 'Lamba',
 				'lb' => 'Lwcsembwrgeg',
 				'lez' => 'Lezgheg',
 				'lg' => 'Ganda',
 				'li' => 'Limbwrgeg',
 				'lkt' => 'Lakota',
 				'lmo' => 'Lombardeg',
 				'ln' => 'Lingala',
 				'lo' => 'Laoeg',
 				'lol' => 'Mongo',
 				'loz' => 'Lozi',
 				'lrc' => 'Luri Gogleddol',
 				'lt' => 'Lithwaneg',
 				'ltg' => 'Latgaleg',
 				'lu' => 'Luba-Katanga',
 				'lun' => 'Lwnda',
 				'luo' => 'Lŵo',
 				'lus' => 'Lwshaieg',
 				'luy' => 'Lwyia',
 				'lv' => 'Latfieg',
 				'mad' => 'Madwreg',
 				'mag' => 'Magahi',
 				'mai' => 'Maithili',
 				'mak' => 'Macasareg',
 				'man' => 'Mandingo',
 				'mas' => 'Masai',
 				'mdf' => 'Mocsia',
 				'mdr' => 'Mandareg',
 				'men' => 'Mendeg',
 				'mer' => 'Mêrw',
 				'mfe' => 'Morisyen',
 				'mg' => 'Malagaseg',
 				'mga' => 'Gwyddeleg Canol',
 				'mgh' => 'Makhuwa-Meetto',
 				'mgo' => 'Meta',
 				'mh' => 'Marsialeg',
 				'mi' => 'Maori',
 				'mic' => 'Micmaceg',
 				'mk' => 'Macedoneg',
 				'ml' => 'Malayalam',
 				'mn' => 'Mongoleg',
 				'mnc' => 'Manshw',
 				'mni' => 'Manipwri',
 				'moh' => 'Mohoceg',
 				'mos' => 'Mosi',
 				'mr' => 'Marathi',
 				'mrj' => 'Mari Gorllewinol',
 				'ms' => 'Maleieg',
 				'mt' => 'Malteg',
 				'mua' => 'Mundang',
 				'mul' => 'mwy nag un iaith',
 				'mwl' => 'Mirandeg',
 				'mwr' => 'Marwari',
 				'my' => 'Byrmaneg',
 				'mzn' => 'Masanderani',
 				'na' => 'Nawrŵeg',
 				'nap' => 'Naplieg',
 				'naq' => 'Nama',
 				'nb' => 'Norwyeg Bokmål',
 				'nd' => 'Ndebele Gogleddol',
 				'nds' => 'Isel Almaeneg',
 				'nds_NL' => 'Sacsoneg Isel',
 				'ne' => 'Nepaleg',
 				'new' => 'Newaeg',
 				'ng' => 'Ndonga',
 				'njo' => 'Ao Naga',
 				'nl' => 'Iseldireg',
 				'nl_BE' => 'Fflemeg',
 				'nmg' => 'Kwasio',
 				'nn' => 'Norwyeg Nynorsk',
 				'no' => 'Norwyeg',
 				'non' => 'Hen Norseg',
 				'nqo' => 'N’Ko',
 				'nr' => 'Ndebele Deheuol',
 				'nso' => 'Sotho Gogleddol',
 				'nus' => 'Nŵereg',
 				'nv' => 'Nafaho',
 				'nwc' => 'Hen Newari',
 				'ny' => 'Nianja',
 				'nym' => 'Niamwezi',
 				'nyn' => 'Niancole',
 				'nyo' => 'Nioro',
 				'nzi' => 'Nzimeg',
 				'oc' => 'Ocsitaneg',
 				'oj' => 'Ojibwa',
 				'om' => 'Oromo',
 				'or' => 'Oriya',
 				'os' => 'Oseteg',
 				'osa' => 'Osageg',
 				'ota' => 'Tyrceg Otoman',
 				'pa' => 'Pwnjabeg',
 				'pag' => 'Pangasineg',
 				'pal' => 'Pahlafi',
 				'pam' => 'Pampanga',
 				'pcd' => 'Picardeg',
 				'pdc' => 'Almaeneg Pensylfania',
 				'peo' => 'Hen Bersieg',
 				'pfl' => 'Almaeneg Palatin',
 				'phn' => 'Phoeniceg',
 				'pi' => 'Pali',
 				'pl' => 'Pwyleg',
 				'pms' => 'Piedmonteg',
 				'pnt' => 'Ponteg',
 				'pon' => 'Pohnpeianeg',
 				'prg' => 'Prwseg',
 				'pro' => 'Hen Brofensaleg',
 				'ps' => 'Pashto',
 				'pt' => 'Portiwgeeg',
 				'pt_BR' => 'Portiwgeeg Brasil',
 				'pt_PT' => 'Portiwgeeg Ewrop',
 				'qu' => 'Quechua',
 				'quc' => 'K’iche’',
 				'raj' => 'Rajasthaneg',
 				'rap' => 'Rapanŵi',
 				'rar' => 'Raratongeg',
 				'rm' => 'Románsh',
 				'rn' => 'Rwndi',
 				'ro' => 'Rwmaneg',
 				'ro_MD' => 'Moldofeg',
 				'rof' => 'Rombo',
 				'rom' => 'Romani',
 				'root' => 'y Gwraidd',
 				'rtm' => 'Rotumaneg',
 				'ru' => 'Rwseg',
 				'rup' => 'Aromaneg',
 				'rw' => 'Ciniarŵandeg',
 				'rwk' => 'Rwa',
 				'sa' => 'Sansgrit',
 				'sad' => 'Sandäweg',
 				'sah' => 'Iacwteg',
 				'sam' => 'Aramaeg Samaria',
 				'saq' => 'Sambŵrw',
 				'sas' => 'Sasaceg',
 				'sat' => 'Santali',
 				'sba' => 'Ngambeieg',
 				'sbp' => 'Sangw',
 				'sc' => 'Sardeg',
 				'scn' => 'Sisileg',
 				'sco' => 'Sgoteg',
 				'sd' => 'Sindhi',
 				'sdc' => 'Sasareseg Sardinia',
 				'sdh' => 'Cwrdeg Deheuol',
 				'se' => 'Sami Gogleddol',
 				'see' => 'Seneca',
 				'seh' => 'Sena',
 				'sei' => 'Seri',
 				'sel' => 'Selcypeg',
 				'ses' => 'Koyraboro Senni',
 				'sg' => 'Sango',
 				'sga' => 'Hen Wyddeleg',
 				'sgs' => 'Samogiteg',
 				'sh' => 'Serbo-Croateg',
 				'shi' => 'Tachelhit',
 				'shu' => 'Arabeg Chad',
 				'si' => 'Sinhaleg',
 				'sid' => 'Sidamo',
 				'sk' => 'Slofaceg',
 				'sl' => 'Slofeneg',
 				'sli' => 'Is-silesieg',
 				'sm' => 'Samöeg',
 				'sma' => 'Sami Deheuol',
 				'smj' => 'Sami Lwle',
 				'smn' => 'Sami Inari',
 				'sms' => 'Sami Scolt',
 				'sn' => 'Shona',
 				'snk' => 'Soninceg',
 				'so' => 'Somaleg',
 				'sog' => 'Sogdeg',
 				'sq' => 'Albaneg',
 				'sr' => 'Serbeg',
 				'srr' => 'Serereg',
 				'ss' => 'Swati',
 				'st' => 'Sesotheg',
 				'stq' => 'Ffriseg Saterland',
 				'su' => 'Swndaneg',
 				'suk' => 'Swcwma',
 				'sus' => 'Swsŵeg',
 				'sux' => 'Swmereg',
 				'sv' => 'Swedeg',
 				'sw' => 'Swahili',
 				'swb' => 'Comoreg',
 				'swc' => 'Swahili’r Congo',
 				'syc' => 'Hen Syrieg',
 				'syr' => 'Syrieg',
 				'szl' => 'Silesieg',
 				'ta' => 'Tamileg',
 				'tcy' => 'Tulu',
 				'te' => 'Telugu',
 				'tem' => 'Timneg',
 				'teo' => 'Teso',
 				'ter' => 'Terena',
 				'tet' => 'Tetumeg',
 				'tg' => 'Tajiceg',
 				'th' => 'Thai',
 				'ti' => 'Tigrinya',
 				'tig' => 'Tigreg',
 				'tiv' => 'Tifeg',
 				'tk' => 'Twrcmeneg',
 				'tkl' => 'Tocelaweg',
 				'tkr' => 'Tsakhureg',
 				'tl' => 'Tagalog',
 				'tlh' => 'Klingon',
 				'tli' => 'Llingit',
 				'tly' => 'Talysheg',
 				'tmh' => 'Tamasheceg',
 				'tn' => 'Tswana',
 				'to' => 'Tongeg',
 				'tpi' => 'Tok Pisin',
 				'tr' => 'Tyrceg',
 				'trv' => 'Taroko',
 				'ts' => 'Tsongaeg',
 				'tsd' => 'Tsaconeg',
 				'tt' => 'Tatareg',
 				'tum' => 'Twmbwca',
 				'tvl' => 'Twfalweg',
 				'tw' => 'Twi',
 				'twq' => 'Tasawaq',
 				'ty' => 'Tahitïeg',
 				'tzm' => 'Tamaseit Canolbarth Moroco',
 				'udm' => 'Fotiaceg',
 				'ug' => 'Uighur',
 				'uga' => 'Wgariteg',
 				'uk' => 'Wcreineg',
 				'umb' => 'Umbundu',
 				'und' => 'Iaith Anhysbys',
 				'ur' => 'Wrdw',
 				'uz' => 'Wsbeceg',
 				'vai' => 'Faieg',
 				've' => 'Fendeg',
 				'vec' => 'Feniseg',
 				'vep' => 'Feps',
 				'vi' => 'Fietnameg',
 				'vls' => 'Fflemeg Gorllewinol',
 				'vot' => 'Foteg',
 				'vun' => 'Funjo',
 				'wa' => 'Walwneg',
 				'wae' => 'Walsereg',
 				'wal' => 'Walamo',
 				'war' => 'Winarayeg',
 				'was' => 'Washo',
 				'wbp' => 'Warlpiri',
 				'wo' => 'Woloff',
 				'xal' => 'Calmyceg',
 				'xh' => 'Xhosa',
 				'xog' => 'Soga',
 				'ybb' => 'Iembaeg',
 				'yi' => 'Iddew-Almaeneg',
 				'yo' => 'Iorwba',
 				'yue' => 'Cantoneeg',
 				'zap' => 'Zapoteceg',
 				'zbl' => 'Blisssymbols',
 				'zea' => 'Zêlandeg',
 				'zgh' => 'Tamaseit Safonol',
 				'zh' => 'Tsieineeg',
 				'zh_Hans' => 'Tsieineeg Symledig',
 				'zh_Hant' => 'Tsieineeg Traddodiadol',
 				'zu' => 'Swlw',
 				'zun' => 'Zuni',
 				'zxx' => 'Dim cynnwys ieithyddol',
 				'zza' => 'Zazäeg',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Arab' => 'Arabaidd',
 			'Armn' => 'Armenaidd',
 			'Beng' => 'Bengalaidd',
 			'Bopo' => 'Bopomofo',
 			'Brai' => 'Braille',
 			'Cyrl' => 'Cyrilig',
 			'Deva' => 'Devanagari',
 			'Ethi' => 'Ethiopig',
 			'Geor' => 'Georgaidd',
 			'Grek' => 'Groegaidd',
 			'Gujr' => 'Gwjarataidd',
 			'Guru' => 'Gwrmwci',
 			'Hang' => 'Hangul',
 			'Hani' => 'Han',
 			'Hans' => 'Symledig',
 			'Hans@alt=stand-alone' => 'Han symledig',
 			'Hant' => 'Traddodiadol',
 			'Hant@alt=stand-alone' => 'Han traddodiadol',
 			'Hebr' => 'Hebreig',
 			'Hira' => 'Hiragana',
 			'Jpan' => 'Japaneaidd',
 			'Kana' => 'Catacana',
 			'Khmr' => 'Chmeraidd',
 			'Knda' => 'Canaraidd',
 			'Kore' => 'Coreaidd',
 			'Laoo' => 'Laoaidd',
 			'Latn' => 'Lladin',
 			'Mlym' => 'Malayalamaidd',
 			'Mong' => 'Mongolaidd',
 			'Mymr' => 'Myanmaraidd',
 			'Ogam' => 'Ogam',
 			'Orya' => 'Orïaidd',
 			'Sinh' => 'Sinhanaidd',
 			'Taml' => 'Tamilaidd',
 			'Telu' => 'Telugu',
 			'Thaa' => 'Thaana',
 			'Thai' => 'Tai',
 			'Tibt' => 'Tibetaidd',
 			'Zsym' => 'Symbolau',
 			'Zxxx' => 'Anysgrifenedig',
 			'Zyyy' => 'Cyffredin',
 			'Zzzz' => 'Sgript anhysbys',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'001' => 'Y Byd',
 			'002' => 'Affrica',
 			'003' => 'Gogledd America',
 			'005' => 'De America',
 			'009' => 'Oceania',
 			'011' => 'Gorllewin Affrica',
 			'013' => 'Canolbarth America',
 			'014' => 'Dwyrain Affrica',
 			'015' => 'Gogledd Affrica',
 			'017' => 'Canol Affrica',
 			'018' => 'Deheudir Affrica',
 			'019' => 'Yr Amerig',
 			'021' => 'America i’r Gogledd o Fecsico',
 			'029' => 'Y Caribî',
 			'030' => 'Dwyrain Asia',
 			'034' => 'De Asia',
 			'035' => 'De-Ddwyrain Asia',
 			'039' => 'De Ewrop',
 			'053' => 'Awstralasia',
 			'054' => 'Melanesia',
 			'057' => 'Rhanbarth Micronesia',
 			'061' => 'Polynesia',
 			'142' => 'Asia',
 			'143' => 'Canol Asia',
 			'145' => 'Gorllewin Asia',
 			'150' => 'Ewrop',
 			'151' => 'Dwyrain Ewrop',
 			'154' => 'Gogledd Ewrop',
 			'155' => 'Gorllewin Ewrop',
 			'419' => 'America Ladin',
 			'AC' => 'Ynys Ascension',
 			'AD' => 'Andorra',
 			'AE' => 'Emiradau Arabaidd Unedig',
 			'AF' => 'Afghanistan',
 			'AG' => 'Antigua a Barbuda',
 			'AI' => 'Anguilla',
 			'AL' => 'Albania',
 			'AM' => 'Armenia',
 			'AN' => 'Ynysoedd Caribî yr Iseldiroedd',
 			'AO' => 'Angola',
 			'AQ' => 'Antarctica',
 			'AR' => 'Yr Ariannin',
 			'AS' => 'Samoa America',
 			'AT' => 'Awstria',
 			'AU' => 'Awstralia',
 			'AW' => 'Aruba',
 			'AX' => 'Ynysoedd Åland',
 			'AZ' => 'Azerbaijan',
 			'BA' => 'Bosnia a Hercegovina',
 			'BB' => 'Barbados',
 			'BD' => 'Bangladesh',
 			'BE' => 'Gwlad Belg',
 			'BF' => 'Burkina Faso',
 			'BG' => 'Bwlgaria',
 			'BH' => 'Bahrain',
 			'BI' => 'Burundi',
 			'BJ' => 'Benin',
 			'BL' => 'Saint Barthélemy',
 			'BM' => 'Bermuda',
 			'BN' => 'Brunei',
 			'BO' => 'Bolifia',
 			'BQ' => 'Antilles yr Iseldiroedd',
 			'BR' => 'Brasil',
 			'BS' => 'Y Bahamas',
 			'BT' => 'Bhutan',
 			'BV' => 'Ynys Bouvet',
 			'BW' => 'Botswana',
 			'BY' => 'Belarws',
 			'BZ' => 'Belize',
 			'CA' => 'Canada',
 			'CC' => 'Ynysoedd Cocos (Keeling)',
 			'CD' => 'Y Congo - Kinshasa',
 			'CD@alt=variant' => 'y Congo (G.Dd.C.)',
 			'CF' => 'Gweriniaeth Canolbarth Affrica',
 			'CG' => 'Y Congo - Brazzaville',
 			'CG@alt=variant' => 'Y Congo (Gweriniaeth)',
 			'CH' => 'Y Swistir',
 			'CI' => 'Côte d’Ivoire',
 			'CI@alt=variant' => 'Arfordir Ifori',
 			'CK' => 'Ynysoedd Cook',
 			'CL' => 'Chile',
 			'CM' => 'Camerŵn',
 			'CN' => 'Tsieina',
 			'CO' => 'Colombia',
 			'CP' => 'Ynys Clipperton',
 			'CR' => 'Costa Rica',
 			'CU' => 'Ciwba',
 			'CV' => 'Cabo Verde',
 			'CW' => 'Curaçao',
 			'CX' => 'Ynys y Nadolig',
 			'CY' => 'Cyprus',
 			'CZ' => 'Gweriniaeth Tsiec',
 			'DE' => 'Yr Almaen',
 			'DG' => 'Diego Garcia',
 			'DJ' => 'Djibouti',
 			'DK' => 'Denmarc',
 			'DM' => 'Dominica',
 			'DO' => 'Gweriniaeth Dominica',
 			'DZ' => 'Algeria',
 			'EA' => 'Ceuta a Melilla',
 			'EC' => 'Ecuador',
 			'EE' => 'Estonia',
 			'EG' => 'Yr Aifft',
 			'EH' => 'Gorllewin Sahara',
 			'ER' => 'Eritrea',
 			'ES' => 'Sbaen',
 			'ET' => 'Ethiopia',
 			'EU' => 'Yr Undeb Ewropeaidd',
 			'FI' => 'Y Ffindir',
 			'FJ' => 'Fiji',
 			'FK' => 'Ynysoedd y Falkland/Malvinas',
 			'FK@alt=variant' => 'Ynysoedd y Falkland (Ynysoedd y Malfinas)',
 			'FM' => 'Micronesia',
 			'FO' => 'Ynysoedd Ffaro',
 			'FR' => 'Ffrainc',
 			'GA' => 'Gabon',
 			'GB' => 'Y Deyrnas Unedig',
 			'GB@alt=short' => 'DU',
 			'GD' => 'Grenada',
 			'GE' => 'Georgia',
 			'GF' => 'Guyane Ffrengig',
 			'GG' => 'Ynys y Garn',
 			'GH' => 'Ghana',
 			'GI' => 'Gibraltar',
 			'GL' => 'Yr Ynys Las',
 			'GM' => 'Gambia',
 			'GN' => 'Guinée',
 			'GP' => 'Guadeloupe',
 			'GQ' => 'Guinea Gyhydeddol',
 			'GR' => 'Gwlad Groeg',
 			'GS' => 'De Georgia ac Ynysoedd Sandwich y De',
 			'GT' => 'Guatemala',
 			'GU' => 'Guam',
 			'GW' => 'Guiné-Bissau',
 			'GY' => 'Guyana',
 			'HK' => 'Hong Kong RhGA Tsieina',
 			'HK@alt=short' => 'Hong Kong',
 			'HM' => 'Ynys Heard ac Ynysoedd McDonald',
 			'HN' => 'Honduras',
 			'HR' => 'Croatia',
 			'HT' => 'Haiti',
 			'HU' => 'Hwngari',
 			'IC' => 'Yr Ynysoedd Dedwydd',
 			'ID' => 'Indonesia',
 			'IE' => 'Iwerddon',
 			'IL' => 'Israel',
 			'IM' => 'Ynys Manaw',
 			'IN' => 'India',
 			'IO' => 'Tiriogaeth Brydeinig Cefnfor India',
 			'IQ' => 'Irac',
 			'IR' => 'Iran',
 			'IS' => 'Gwlad yr Iâ',
 			'IT' => 'Yr Eidal',
 			'JE' => 'Jersey',
 			'JM' => 'Jamaica',
 			'JO' => 'Gwlad Iorddonen',
 			'JP' => 'Japan',
 			'KE' => 'Kenya',
 			'KG' => 'Kyrgyzstan',
 			'KH' => 'Cambodia',
 			'KI' => 'Kiribati',
 			'KM' => 'Comoros',
 			'KN' => 'Saint Kitts a Nevis',
 			'KP' => 'Gogledd Korea',
 			'KR' => 'De Korea',
 			'KW' => 'Kuwait',
 			'KY' => 'Ynysoedd Cayman',
 			'KZ' => 'Kazakstan',
 			'LA' => 'Laos',
 			'LB' => 'Libanus',
 			'LC' => 'Saint Lucia',
 			'LI' => 'Liechtenstein',
 			'LK' => 'Sri Lanka',
 			'LR' => 'Liberia',
 			'LS' => 'Lesotho',
 			'LT' => 'Lithuania',
 			'LU' => 'Lwcsembwrg',
 			'LV' => 'Latfia',
 			'LY' => 'Libya',
 			'MA' => 'Moroco',
 			'MC' => 'Monaco',
 			'MD' => 'Moldofa',
 			'ME' => 'Montenegro',
 			'MF' => 'Saint Martin',
 			'MG' => 'Madagascar',
 			'MH' => 'Ynysoedd Marshall',
 			'MK' => 'Macedonia',
 			'MK@alt=variant' => 'Macedonia (CWIM)',
 			'ML' => 'Mali',
 			'MM' => 'Myanmar (Burma)',
 			'MN' => 'Mongolia',
 			'MO' => 'Macau RhGA Tsieina',
 			'MO@alt=short' => 'Macau',
 			'MP' => 'Ynysoedd Gogledd Mariana',
 			'MQ' => 'Martinique',
 			'MR' => 'Mauritania',
 			'MS' => 'Montserrat',
 			'MT' => 'Malta',
 			'MU' => 'Mauritius',
 			'MV' => 'Y Maldives',
 			'MW' => 'Malawi',
 			'MX' => 'Mecsico',
 			'MY' => 'Malaysia',
 			'MZ' => 'Mozambique',
 			'NA' => 'Namibia',
 			'NC' => 'Caledonia Newydd',
 			'NE' => 'Niger',
 			'NF' => 'Ynys Norfolk',
 			'NG' => 'Nigeria',
 			'NI' => 'Nicaragua',
 			'NL' => 'Yr Iseldiroedd',
 			'NO' => 'Norwy',
 			'NP' => 'Nepal',
 			'NR' => 'Nauru',
 			'NU' => 'Niue',
 			'NZ' => 'Seland Newydd',
 			'OM' => 'Oman',
 			'PA' => 'Panama',
 			'PE' => 'Periw',
 			'PF' => 'Polynesia Ffrengig',
 			'PG' => 'Papua Guinea Newydd',
 			'PH' => 'Y Philipinau',
 			'PK' => 'Pakistan',
 			'PL' => 'Gwlad Pwyl',
 			'PM' => 'Saint-Pierre-et-Miquelon',
 			'PN' => 'Ynysoedd Pitcairn',
 			'PR' => 'Puerto Rico',
 			'PS' => 'Tiriogaethau Palesteinaidd',
 			'PS@alt=short' => 'Palesteina',
 			'PT' => 'Portiwgal',
 			'PW' => 'Palau',
 			'PY' => 'Paraguay',
 			'QA' => 'Qatar',
 			'QO' => 'Oceania Bellennig',
 			'RE' => 'Réunion',
 			'RO' => 'Rwmania',
 			'RS' => 'Serbia',
 			'RU' => 'Rwsia',
 			'RW' => 'Rwanda',
 			'SA' => 'Saudi Arabia',
 			'SB' => 'Ynysoedd Solomon',
 			'SC' => 'Seychelles',
 			'SD' => 'Swdan',
 			'SE' => 'Sweden',
 			'SG' => 'Singapore',
 			'SH' => 'Saint Helena',
 			'SI' => 'Slofenia',
 			'SJ' => 'Svalbard a Jan Mayen',
 			'SK' => 'Slofacia',
 			'SL' => 'Sierra Leone',
 			'SM' => 'San Marino',
 			'SN' => 'Senegal',
 			'SO' => 'Somalia',
 			'SR' => 'Suriname',
 			'SS' => 'De Swdan',
 			'ST' => 'São Tomé a Príncipe',
 			'SV' => 'El Salvador',
 			'SX' => 'Sint Maarten',
 			'SY' => 'Syria',
 			'SZ' => 'Gwlad Swazi',
 			'TA' => 'Tristan da Cunha',
 			'TC' => 'Ynysoedd Turks a Caicos',
 			'TD' => 'Tchad',
 			'TF' => 'Tiroedd Deheuol ac Antarctig Ffrainc',
 			'TG' => 'Togo',
 			'TH' => 'Gwlad Thai',
 			'TJ' => 'Tajikistan',
 			'TK' => 'Tokelau',
 			'TL' => 'Timor-Leste',
 			'TL@alt=variant' => 'Dwyrain Timor',
 			'TM' => 'Turkmenistan',
 			'TN' => 'Tunisia',
 			'TO' => 'Tonga',
 			'TR' => 'Twrci',
 			'TT' => 'Trinidad a Tobago',
 			'TV' => 'Tuvalu',
 			'TW' => 'Taiwan',
 			'TZ' => 'Tanzania',
 			'UA' => 'Wcráin',
 			'UG' => 'Uganda',
 			'UM' => 'Ynysoedd Pellennig UDA',
 			'US' => 'Yr Unol Daleithiau',
 			'US@alt=short' => 'UDA',
 			'UY' => 'Uruguay',
 			'UZ' => 'Uzbekistan',
 			'VA' => 'Y Fatican',
 			'VC' => 'Saint Vincent a’r Grenadines',
 			'VE' => 'Venezuela',
 			'VG' => 'Ynysoedd Gwyryf Prydain',
 			'VI' => 'Ynysoedd Gwyryf yr Unol Daleithiau',
 			'VN' => 'Fietnam',
 			'VU' => 'Vanuatu',
 			'WF' => 'Wallis a Futuna',
 			'WS' => 'Samoa',
 			'XK' => 'Kosovo',
 			'YE' => 'Yemen',
 			'YT' => 'Mayotte',
 			'ZA' => 'De Affrica',
 			'ZM' => 'Zambia',
 			'ZW' => 'Zimbabwe',
 			'ZZ' => 'Rhanbarth Anhysbys',

		}
	},
);

has 'display_name_variant' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'1901' => 'orgraff draddodiadol yr Almaeneg',
 			'1606NICT' => 'Ffrangeg Canol Diweddar hyd at 1606',
 			'1694ACAD' => 'Ffrangeg Modern Cynnar',
 			'1959ACAD' => 'Academig',
 			'ALUKU' => 'tafodiaith Aluku',
 			'AREVELA' => 'Armeneg Dwyreiniol',
 			'AREVMDA' => 'Armeneg Gorllewinol',
 			'BAUDDHA' => 'BAUDDHA',
 			'BISCAYAN' => 'BISCAYAN',
 			'BOHORIC' => 'Gwyddor Bohorič',
 			'DAJNKO' => 'gwyddor Dajnko',
 			'EMODENG' => 'Saesneg Modern Cynnar',
 			'FONIPA' => 'Seineg IPA',
 			'FONUPA' => 'Seineg UPA',
 			'FONXSAMP' => 'FONXSAMP',
 			'HOGNORSK' => 'HOGNORSK',
 			'ITIHASA' => 'ITIHASA',
 			'JAUER' => 'JAUER',
 			'JYUTPING' => 'JYUTPING',
 			'KKCOR' => 'yr Orgraff Gyffredin',
 			'KOCIEWIE' => 'KOCIEWIE',
 			'KSCOR' => 'yr Orgraff Safonol',
 			'LAUKIKA' => 'LAUKIKA',
 			'LUNA1918' => 'LUNA1918',
 			'METELKO' => 'gwyddor Metelko',
 			'NDYUKA' => 'tafodiaith Ndyuka',
 			'NEDIS' => 'tafodiaith Natisone',
 			'NJIVA' => 'tafodiaith Gniva/Njiva',
 			'OSOJS' => 'tafodiaith Oseacco/Osojane',
 			'PAMAKA' => 'tafodiaith Pamaka',
 			'POSIX' => 'Cyfrifiadur',
 			'SCOTLAND' => 'Saesneg Safonol yr Alban',
 			'SURMIRAN' => 'SURMIRAN',
 			'SURSILV' => 'SURSILV',
 			'SUTSILV' => 'SUTSILV',
 			'VAIDIKA' => 'VAIDIKA',
 			'VALLADER' => 'VALLADER',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'calendar' => 'Calendr',
 			'collation' => 'Trefn',
 			'currency' => 'Arian Breiniol',
 			'hc' => 'Cylched Awr (12 vs 24)',
 			'lb' => 'Arddull Torriad Llinell',
 			'ms' => 'System Fesur',
 			'numbers' => 'Rhifau',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[Str]]',
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{Calendr y Bwdiaid},
 				'chinese' => q{Calendr Tseina},
 				'coptic' => q{Calendr y Coptiaid},
 				'dangi' => q{Calendr Dangi},
 				'ethiopic' => q{Calendr Ethiopia},
 				'ethiopic-amete-alem' => q{Calendr Amete Alem Ethiopia},
 				'gregorian' => q{Calendr Gregori},
 				'hebrew' => q{Calendr yr Hebraed},
 				'indian' => q{Calendr Cenedlaethol India},
 				'islamic' => q{Calendr Islam},
 				'islamic-umalqura' => q{Calendr Islam (Umm al-Qura)},
 				'iso8601' => q{Calendr ISO-8601},
 				'japanese' => q{Calendr Japan},
 				'persian' => q{Calendr Persia},
 				'roc' => q{Calendr Gweriniaeth Tseina},
 			},
 			'collation' => {
 				'big5han' => q{Trefn Traddodiadol Tsieina - Big5},
 				'dictionary' => q{Trefn Geiriadur},
 				'ducet' => q{Trefn Rhagosodedig Unicode},
 				'eor' => q{Rheolau trefnu Ewropeaidd},
 				'gb2312han' => q{Trefn Symledig Tsieina - GB2312},
 				'phonebook' => q{Trefn Llyfr Ffôn},
 				'pinyin' => q{Trefn Pinyin},
 				'reformed' => q{Trefn Diwygiedig},
 				'search' => q{Chwilio at Ddibenion Cyffredinol},
 				'standard' => q{Trefn Safonol},
 				'traditional' => q{Trefn Traddodiadol},
 				'zhuyin' => q{Trefn Zhuyin},
 			},
 			'hc' => {
 				'h11' => q{System 12 Awr (0–11)},
 				'h12' => q{System 12 Awr (1–12)},
 				'h23' => q{System 24 Awr (0–23)},
 				'h24' => q{System 24 Awr (1–24)},
 			},
 			'lb' => {
 				'loose' => q{Arddull Torriad Llinell Rhydd},
 				'normal' => q{Arddull Torriad Llinell Arferol},
 				'strict' => q{Arddull Torriad Llinell Caeth},
 			},
 			'ms' => {
 				'metric' => q{System Fetrig},
 				'uksystem' => q{System Fesur Imperialaidd},
 				'ussystem' => q{System Fesur UDA},
 			},
 			'numbers' => {
 				'arab' => q{Digidau Arabig-Indig},
 				'arabext' => q{Digidau Arabig-Indig Estynedig},
 				'armn' => q{Rhifolion Armenaidd},
 				'armnlow' => q{Rhifolion Armenaidd mewn Llythrennau Bychain},
 				'beng' => q{Digidau Bengalaidd},
 				'deva' => q{Digidau Devanagarig},
 				'ethi' => q{Rhifolion Ethiopig},
 				'fullwide' => q{Digidau Lled Llawn},
 				'geor' => q{Rhifolion Georgaidd},
 				'grek' => q{Rhifolion Groegaidd},
 				'greklow' => q{Rhifolion Groegaidd mewn Llythrennau Bychain},
 				'gujr' => q{Digidau Gwjarataidd},
 				'guru' => q{Digidau Gwrmwcaidd},
 				'hanidec' => q{Rhifolion Degol Tsieineaidd},
 				'hans' => q{Rhifolion Tsieineaidd Symledig},
 				'hansfin' => q{Rhifolion Ariannol Tsieineaidd Symledig},
 				'hant' => q{Rhifolion Tsieineaidd Traddodiadol},
 				'hantfin' => q{Rhifolion Ariannol Tsieineaidd Traddodiadol},
 				'hebr' => q{Rhifolion Hebreig},
 				'jpan' => q{Rhifolion Japaneaidd},
 				'jpanfin' => q{Rhifolion Ariannol Japaneaidd},
 				'khmr' => q{Digidau Chmeraidd},
 				'knda' => q{Digidau Kannaraidd},
 				'laoo' => q{Digidau Laoaidd},
 				'latn' => q{Digidau Gorllewinol},
 				'mlym' => q{Digidau Malayalamaidd},
 				'mong' => q{Digidau Mongolia},
 				'mymr' => q{Digidau Myanmar},
 				'orya' => q{Digidau Orïaidd},
 				'roman' => q{Rhifolion Rhufeinig},
 				'romanlow' => q{Rhifolion Rhufeinig mewn Llythrennau Bychain},
 				'takr' => q{Digidau Takri},
 				'taml' => q{Rhifolion Tamilaidd Traddodiadol},
 				'tamldec' => q{Digidau Tamilaidd},
 				'telu' => q{Digidau Telugu},
 				'thai' => q{Digidau Thai},
 				'tibt' => q{Digidau Tibetaidd},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'metric' => q{Metrig},
 			'UK' => q{DU},
 			'US' => q{UDA},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'language' => 'Iaith: {0}',
 			'script' => 'Sgript: {0}',
 			'region' => 'Rhanbarth: {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{(?^u:[ă å ã ā æ ç ĕ ē ĭ ī k ñ ŏ ø ō œ q ŭ ū v x z])},
			index => ['A', 'B', 'C', '{CH}', 'D', '{DD}', 'E', 'F', '{FF}', 'G', '{NG}', 'H', 'I', 'J', 'K', 'L', '{LL}', 'M', 'N', 'O', 'P', '{PH}', 'Q', 'R', '{RH}', 'S', 'T', '{TH}', 'U', 'V', 'W', 'X', 'Y', 'Z'],
			main => qr{(?^u:[a á à â ä b c {ch} d {dd} e é è ê ë f {ff} g {ng} h i í ì î ï j l {ll} m n o ó ò ô ö p {ph} r {rh} s t {th} u ú ù û ü w ẃ ẁ ŵ ẅ y ý ỳ ŷ ÿ])},
			punctuation => qr{(?^u:[\- ‐ – — , ; \: ! ? . … ' ‘ ’ " “ ” ( ) \[ \] § @ * / \& # † ‡ ′ ″])},
		};
	},
EOT
: sub {
		return { index => ['A', 'B', 'C', '{CH}', 'D', '{DD}', 'E', 'F', '{FF}', 'G', '{NG}', 'H', 'I', 'J', 'K', 'L', '{LL}', 'M', 'N', 'O', 'P', '{PH}', 'Q', 'R', '{RH}', 'S', 'T', '{TH}', 'U', 'V', 'W', 'X', 'Y', 'Z'], };
},
);


has 'ellipsis' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub {
		return {
			'final' => '{0}…',
			'initial' => '…{0}',
			'medial' => '{0}…{1}',
			'word-final' => '{0} …',
			'word-initial' => '… {0}',
			'word-medial' => '{0} … {1}',
		};
	},
);

has 'more_information' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{?},
);

has 'quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{‘},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{’},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{“},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{”},
);

has 'duration_units' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { {
				hm => 'h:mm',
				hms => 'h:mm:ss',
				ms => 'm:ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[HashRef[Str]]]',
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					'acre' => {
						'few' => q({0} erw),
						'many' => q({0} erw),
						'name' => q(erw),
						'one' => q({0} erw),
						'other' => q({0} erw),
						'two' => q({0} erw),
						'zero' => q({0} erw),
					},
					'acre-foot' => {
						'few' => q({0} erw-droedfedd),
						'many' => q({0} erw-droedfedd),
						'name' => q(erw-droedfeddi),
						'one' => q({0} erw-droedfedd),
						'other' => q({0} erw-droedfedd),
						'two' => q({0} erw-droedfedd),
						'zero' => q({0} erw-droedfedd),
					},
					'ampere' => {
						'few' => q({0} amper),
						'many' => q({0} amper),
						'name' => q(amperau),
						'one' => q({0} amper),
						'other' => q({0} amper),
						'two' => q({0} amper),
						'zero' => q({0} amper),
					},
					'arc-minute' => {
						'few' => q({0} arcfunud),
						'many' => q({0} arcfunud),
						'name' => q(arcfunudau),
						'one' => q({0} arcfunud),
						'other' => q({0} arcfunud),
						'two' => q({0} arcfunud),
						'zero' => q({0} arcfunud),
					},
					'arc-second' => {
						'few' => q({0} arceiliad),
						'many' => q({0} arceiliad),
						'name' => q(arceiliadau),
						'one' => q({0} arceiliad),
						'other' => q({0} arceiliad),
						'two' => q({0} arceiliad),
						'zero' => q({0} arceiliad),
					},
					'astronomical-unit' => {
						'few' => q({0} uned seryddol),
						'many' => q({0} uned seryddol),
						'name' => q(unedau seryddol),
						'one' => q({0} uned seryddol),
						'other' => q({0} uned seryddol),
						'two' => q({0} uned seryddol),
						'zero' => q({0} uned seryddol),
					},
					'bit' => {
						'few' => q({0} did),
						'many' => q({0} did),
						'name' => q(didau),
						'one' => q({0} did),
						'other' => q({0} did),
						'two' => q({0} ddid),
						'zero' => q({0} did),
					},
					'bushel' => {
						'few' => q({0} bwsiel),
						'many' => q({0} bwsiel),
						'name' => q(bwsielau),
						'one' => q({0} bwsiel),
						'other' => q({0} bwsiel),
						'two' => q({0} bwsiel),
						'zero' => q({0} bwsiel),
					},
					'byte' => {
						'few' => q({0} beit),
						'many' => q({0} beit),
						'name' => q(beitiau),
						'one' => q({0} beit),
						'other' => q({0} beit),
						'two' => q({0} feit),
						'zero' => q({0} beit),
					},
					'calorie' => {
						'few' => q({0} chalori),
						'many' => q({0} chalori),
						'name' => q(calorïau),
						'one' => q({0} calori),
						'other' => q({0} calori),
						'two' => q({0} galori),
						'zero' => q({0} calori),
					},
					'carat' => {
						'few' => q({0} charat),
						'many' => q({0} charat),
						'name' => q(caratau),
						'one' => q({0} carat),
						'other' => q({0} carat),
						'two' => q({0} garat),
						'zero' => q({0} carat),
					},
					'celsius' => {
						'few' => q({0} gradd Celsius),
						'many' => q({0} gradd Celsius),
						'name' => q(graddau Celsius),
						'one' => q({0} radd Celsius),
						'other' => q({0} gradd Celsius),
						'two' => q({0} radd Celsius),
						'zero' => q({0} gradd Celsius),
					},
					'centiliter' => {
						'few' => q({0} chentilitr),
						'many' => q({0} chentilitr),
						'name' => q(centilitrau),
						'one' => q({0} centilitr),
						'other' => q({0} centilitr),
						'two' => q({0} gentilitr),
						'zero' => q({0} centilitr),
					},
					'centimeter' => {
						'few' => q({0} chentimetr),
						'many' => q({0} chentimetr),
						'name' => q(centimetrau),
						'one' => q({0} centimetr),
						'other' => q({0} centimetr),
						'per' => q({0} y centimetr),
						'two' => q({0} gentimetr),
						'zero' => q({0} centimetr),
					},
					'century' => {
						'few' => q({0} canrif),
						'many' => q({0} canrif),
						'name' => q(canrifoedd),
						'one' => q({0} canrif),
						'other' => q({0} canrif),
						'two' => q({0} ganrif),
						'zero' => q({0} canrif),
					},
					'coordinate' => {
						'east' => q({0} i’r dwyrain),
						'north' => q({0} i’r gogledd),
						'south' => q({0} i’r de),
						'west' => q({0} i’r gorllewin),
					},
					'cubic-centimeter' => {
						'few' => q({0} chentimetr ciwbig),
						'many' => q({0} centimetr ciwbig),
						'name' => q(centimetrau ciwbig),
						'one' => q({0} centimetr ciwbig),
						'other' => q({0} chentimetr ciwbig),
						'per' => q({0} y centimetr ciwbig),
						'two' => q({0} gentimetr ciwbig),
						'zero' => q({0} centimetr ciwbig),
					},
					'cubic-foot' => {
						'few' => q({0} troedfedd giwbig),
						'many' => q({0} troedfedd giwbig),
						'name' => q(troedfeddi ciwbig),
						'one' => q({0} droedfedd giwbig),
						'other' => q({0} troedfedd giwbig),
						'two' => q({0} droedfedd giwbig),
						'zero' => q({0} troedfedd giwbig),
					},
					'cubic-inch' => {
						'few' => q({0} modfedd giwbig),
						'many' => q({0} modfedd giwbig),
						'name' => q(modfeddi ciwbig),
						'one' => q({0} fodfedd giwbig),
						'other' => q({0} modfedd giwbig),
						'two' => q({0} fodfedd giwbig),
						'zero' => q({0} modfedd giwbig),
					},
					'cubic-kilometer' => {
						'few' => q({0} chilometr ciwbig),
						'many' => q({0} chilometr ciwbig),
						'name' => q(cilometrau ciwbig),
						'one' => q({0} cilometr ciwbig),
						'other' => q({0} cilometr ciwbig),
						'two' => q({0} gilometr ciwbig),
						'zero' => q({0} cilometr ciwbig),
					},
					'cubic-meter' => {
						'few' => q({0} metr ciwbig),
						'many' => q({0} metr ciwbig),
						'name' => q(metrau ciwbig),
						'one' => q({0} metr ciwbig),
						'other' => q({0} metr ciwbig),
						'per' => q({0} y metr ciwbig),
						'two' => q({0} fetr ciwbig),
						'zero' => q({0} metr ciwbig),
					},
					'cubic-mile' => {
						'few' => q({0} milltir giwbig),
						'many' => q({0} milltir giwbig),
						'name' => q(milltiroedd ciwbig),
						'one' => q({0} filltir giwbig),
						'other' => q({0} milltir giwbig),
						'two' => q({0} filltir giwbig),
						'zero' => q({0} milltir giwbig),
					},
					'cubic-yard' => {
						'few' => q({0} llath giwbig),
						'many' => q({0} llath giwbig),
						'name' => q(llathenni ciwbig),
						'one' => q({0} llathen giwbig),
						'other' => q({0} llath giwbig),
						'two' => q({0} lath giwbig),
						'zero' => q({0} llath giwbig),
					},
					'cup' => {
						'few' => q({0} cwpanaid),
						'many' => q({0} cwpanaid),
						'name' => q(cwpaneidiau),
						'one' => q({0} cwpanaid),
						'other' => q({0} cwpanaid),
						'two' => q({0} gwpanaid),
						'zero' => q({0} cwpanaid),
					},
					'cup-metric' => {
						'few' => q({0} cwpanaid metrig),
						'many' => q({0} cwpanaid metrig),
						'name' => q(cwpaneidiau metrig),
						'one' => q({0} cwpanaid metrig),
						'other' => q({0} cwpanaid metrig),
						'two' => q({0} gwpanaid metrig),
						'zero' => q({0} cwpanaid metrig),
					},
					'day' => {
						'few' => q({0} diwrnod),
						'many' => q({0} diwrnod),
						'name' => q(diwrnodau),
						'one' => q({0} diwrnod),
						'other' => q({0} diwrnod),
						'per' => q({0} y diwrnod),
						'two' => q({0} ddiwrnod),
						'zero' => q({0} diwrnod),
					},
					'deciliter' => {
						'few' => q({0} decilitr),
						'many' => q({0} decilitr),
						'name' => q(decilitrau),
						'one' => q({0} decilitr),
						'other' => q({0} decilitr),
						'two' => q({0} decilitr),
						'zero' => q({0} decilitr),
					},
					'decimeter' => {
						'few' => q({0} decimetr),
						'many' => q({0} decimetr),
						'name' => q(decimetrau),
						'one' => q({0} decimetr),
						'other' => q({0} decimetr),
						'two' => q({0} decimetr),
						'zero' => q({0} decimetr),
					},
					'degree' => {
						'few' => q({0} gradd),
						'many' => q({0} gradd),
						'name' => q(graddau),
						'one' => q({0} radd),
						'other' => q({0} gradd),
						'two' => q({0} radd),
						'zero' => q({0} gradd),
					},
					'fahrenheit' => {
						'few' => q({0} gradd Fahrenheit),
						'many' => q({0} gradd Fahrenheit),
						'name' => q(gradd Fahrenheit),
						'one' => q({0} radd Fahrenheit),
						'other' => q({0} gradd Fahrenheit),
						'two' => q({0} radd Fahrenheit),
						'zero' => q({0} gradd Fahrenheit),
					},
					'fathom' => {
						'few' => q({0} gwryd),
						'many' => q({0} gwryd),
						'name' => q(gwrhydau),
						'one' => q({0} gwryd),
						'other' => q({0} gwryd),
						'two' => q({0} wryd),
						'zero' => q({0} gwryd),
					},
					'fluid-ounce' => {
						'few' => q({0} owns hylifol),
						'many' => q({0} owns hylifol),
						'name' => q(ownsiau hylifol),
						'one' => q({0} owns hylifol),
						'other' => q({0} owns hylifol),
						'two' => q({0} owns hylifol),
						'zero' => q({0} owns hylifol),
					},
					'foodcalorie' => {
						'few' => q({0} Chalori),
						'many' => q({0} Chalori),
						'name' => q(Calorïau),
						'one' => q({0} Calori),
						'other' => q({0} Calori),
						'two' => q({0} Galori),
						'zero' => q({0} Calori),
					},
					'foot' => {
						'few' => q({0} troedfedd),
						'many' => q({0} throedfedd),
						'name' => q(troedfeddi),
						'one' => q({0} droedfedd),
						'other' => q({0} troedfedd),
						'per' => q({0} y droedfedd),
						'two' => q({0} droedfedd),
						'zero' => q({0} troedfedd),
					},
					'furlong' => {
						'few' => q({0} ystaden),
						'many' => q({0} ystaden),
						'name' => q(ystadenni),
						'one' => q({0} ystaden),
						'other' => q({0} ystaden),
						'two' => q({0} ystaden),
						'zero' => q({0} ystaden),
					},
					'g-force' => {
						'few' => q({0} grym disgyrchedd),
						'many' => q({0} grym disgyrchedd),
						'name' => q(grym disgyrchedd),
						'one' => q({0} grym disgyrchedd),
						'other' => q({0} grym disgyrchedd),
						'two' => q({0} rym disgyrchedd),
						'zero' => q({0} grym disgyrchedd),
					},
					'gallon' => {
						'few' => q({0} galwyn),
						'many' => q({0} galwyn),
						'name' => q(galwyni),
						'one' => q({0} galwyn),
						'other' => q({0} galwyn),
						'per' => q({0} y galwyn),
						'two' => q({0} alwyn),
						'zero' => q({0} galwyn),
					},
					'generic' => {
						'few' => q({0}°),
						'many' => q({0}°),
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
						'two' => q({0}°),
						'zero' => q({0}°),
					},
					'gigabit' => {
						'few' => q({0} gigadid),
						'many' => q({0} gigadid),
						'name' => q(gigadidau),
						'one' => q({0} gigadid),
						'other' => q({0} gigadid),
						'two' => q({0} gigadid),
						'zero' => q({0} gigadid),
					},
					'gigabyte' => {
						'few' => q({0} gigabeit),
						'many' => q({0} gigabeit),
						'name' => q(gigabeitiau),
						'one' => q({0} gigabeit),
						'other' => q({0} gigabeit),
						'two' => q({0} gigabeit),
						'zero' => q({0} gigabeit),
					},
					'gigahertz' => {
						'few' => q({0} gigaherts),
						'many' => q({0} gigaherts),
						'name' => q(gigaherts),
						'one' => q({0} gigaherts),
						'other' => q({0} gigaherts),
						'two' => q({0} gigaherts),
						'zero' => q({0} gigaherts),
					},
					'gigawatt' => {
						'few' => q({0} gigawat),
						'many' => q({0} gigawat),
						'name' => q(gigawatiau),
						'one' => q({0} gigawat),
						'other' => q({0} gigawat),
						'two' => q({0} gigawat),
						'zero' => q({0} gigawat),
					},
					'gram' => {
						'few' => q({0} gram),
						'many' => q({0} gram),
						'name' => q(gramau),
						'one' => q({0} gram),
						'other' => q({0} gram),
						'per' => q({0} y gram),
						'two' => q({0} gram),
						'zero' => q({0} gram),
					},
					'hectare' => {
						'few' => q({0} hectar),
						'many' => q({0} hectar),
						'name' => q(hectarau),
						'one' => q({0} hectar),
						'other' => q({0} hectar),
						'two' => q({0} hectar),
						'zero' => q({0} hectar),
					},
					'hectoliter' => {
						'few' => q({0} hectolitr),
						'many' => q({0} hectolitr),
						'name' => q(hectolitrau),
						'one' => q({0} hectolitr),
						'other' => q({0} hectolitr),
						'two' => q({0} hectolitr),
						'zero' => q({0} hectolitr),
					},
					'hectopascal' => {
						'few' => q({0} hectopascal),
						'many' => q({0} hectopascal),
						'name' => q(hectopascalau),
						'one' => q({0} hectopascal),
						'other' => q({0} hectopascal),
						'two' => q({0} hectopascal),
						'zero' => q({0} hectopascal),
					},
					'hertz' => {
						'few' => q({0} herts),
						'many' => q({0} herts),
						'name' => q(herts),
						'one' => q({0} herts),
						'other' => q({0} herts),
						'two' => q({0} herts),
						'zero' => q({0} herts),
					},
					'horsepower' => {
						'few' => q({0} marchnerth),
						'many' => q({0} marchnerth),
						'name' => q(marchnerth),
						'one' => q({0} marchnerth),
						'other' => q({0} marchnerth),
						'two' => q({0} farchnerth),
						'zero' => q({0} marchnerth),
					},
					'hour' => {
						'few' => q({0} awr),
						'many' => q({0} awr),
						'name' => q(oriau),
						'one' => q({0} awr),
						'other' => q({0} awr),
						'per' => q({0} yr awr),
						'two' => q({0} awr),
						'zero' => q({0} awr),
					},
					'inch' => {
						'few' => q({0} modfedd),
						'many' => q({0} modfedd),
						'name' => q(modfeddi),
						'one' => q({0} fodfedd),
						'other' => q({0} modfedd),
						'per' => q({0} y fodfedd),
						'two' => q({0} fodfedd),
						'zero' => q({0} modfedd),
					},
					'inch-hg' => {
						'few' => q({0} modfedd o fercwri),
						'many' => q({0} modfedd o fercwri),
						'name' => q(modfeddi o fercwri),
						'one' => q({0} fodfedd o fercwri),
						'other' => q({0} modfedd o fercwri),
						'two' => q({0} fodfedd o fercwri),
						'zero' => q({0} modfedd o fercwri),
					},
					'joule' => {
						'few' => q({0} joule),
						'many' => q({0} joule),
						'name' => q(jouleau),
						'one' => q({0} joule),
						'other' => q({0} joule),
						'two' => q({0} joule),
						'zero' => q({0} joule),
					},
					'karat' => {
						'few' => q({0} karat),
						'many' => q({0} karat),
						'name' => q(karatau),
						'one' => q({0} karat),
						'other' => q({0} karat),
						'two' => q({0} karat),
						'zero' => q({0} karat),
					},
					'kelvin' => {
						'few' => q({0} chelfin),
						'many' => q({0} celfin),
						'name' => q(celfinau),
						'one' => q({0} celfin),
						'other' => q({0} celfin),
						'two' => q({0} gelfin),
						'zero' => q({0} celfin),
					},
					'kilobit' => {
						'few' => q({0} cilodid),
						'many' => q({0} cilodid),
						'name' => q(cilodidau),
						'one' => q({0} cilodid),
						'other' => q({0} cilodid),
						'two' => q({0} cilodid),
						'zero' => q({0} cilodid),
					},
					'kilobyte' => {
						'few' => q({0} cilobeit),
						'many' => q({0} cilobeit),
						'name' => q(cilobeitiau),
						'one' => q({0} cilobeit),
						'other' => q({0} cilobeit),
						'two' => q({0} gilobeit),
						'zero' => q({0} cilobeit),
					},
					'kilocalorie' => {
						'few' => q({0} chilocalori),
						'many' => q({0} chilocalori),
						'name' => q(cilocalorïau),
						'one' => q({0} cilocalori),
						'other' => q({0} cilocalori),
						'two' => q({0} gilocalori),
						'zero' => q({0} cilocalori),
					},
					'kilogram' => {
						'few' => q({0} chilogram),
						'many' => q({0} chilogram),
						'name' => q(cilogramau),
						'one' => q({0} cilogram),
						'other' => q({0} cilogram),
						'per' => q({0} y cilogram),
						'two' => q({0} gilogram),
						'zero' => q({0} cilogram),
					},
					'kilohertz' => {
						'few' => q({0} ciloherts),
						'many' => q({0} ciloherts),
						'name' => q(ciloherts),
						'one' => q({0} ciloherts),
						'other' => q({0} ciloherts),
						'two' => q({0} ciloherts),
						'zero' => q({0} ciloherts),
					},
					'kilojoule' => {
						'few' => q({0} chilojoule),
						'many' => q({0} chilojoule),
						'name' => q(cilojouleau),
						'one' => q({0} cilojoule),
						'other' => q({0} cilojoule),
						'two' => q({0} gilojoule),
						'zero' => q({0} cilojoule),
					},
					'kilometer' => {
						'few' => q({0} chilometr),
						'many' => q({0} chilometr),
						'name' => q(cilometrau),
						'one' => q({0} cilometr),
						'other' => q({0} cilometr),
						'per' => q({0} y cilometr),
						'two' => q({0} gilometr),
						'zero' => q({0} cilometr),
					},
					'kilometer-per-hour' => {
						'few' => q({0} chilometr yr awr),
						'many' => q({0} chilometr yr awr),
						'name' => q(cilometrau yr awr),
						'one' => q({0} cilometr yr awr),
						'other' => q({0} cilometr yr awr),
						'two' => q({0} gilometr yr awr),
						'zero' => q({0} cilometr yr awr),
					},
					'kilowatt' => {
						'few' => q({0} chilowat),
						'many' => q({0} chilowat),
						'name' => q(cilawatiau),
						'one' => q({0} cilowat),
						'other' => q({0} cilowat),
						'two' => q({0} gilowat),
						'zero' => q({0} cilowat),
					},
					'kilowatt-hour' => {
						'few' => q({0} chilowat awr),
						'many' => q({0} chilowat awr),
						'name' => q(cilowat oriau),
						'one' => q({0} cilowat awr),
						'other' => q({0} cilowat awr),
						'two' => q({0} gilowat awr),
						'zero' => q({0} cilowat awr),
					},
					'knot' => {
						'few' => q({0} not),
						'many' => q({0} not),
						'name' => q(notiau),
						'one' => q({0} not),
						'other' => q({0} not),
						'two' => q({0} not),
						'zero' => q({0} not),
					},
					'light-year' => {
						'few' => q({0} blwyddyn golau),
						'many' => q({0} blwyddyn golau),
						'name' => q(blynyddoedd golau),
						'one' => q({0} flwyddyn golau),
						'other' => q({0} blwyddyn golau),
						'two' => q({0} flwyddyn golau),
						'zero' => q({0} blwyddyn golau),
					},
					'liter' => {
						'few' => q({0} litr),
						'many' => q({0} litr),
						'name' => q(litrau),
						'one' => q({0} litr),
						'other' => q({0} litr),
						'per' => q({0} y litr),
						'two' => q({0} litr),
						'zero' => q({0} litr),
					},
					'liter-per-100kilometers' => {
						'few' => q({0} litr wrth y 100 cilometr),
						'many' => q({0} litr wrth y 100 cilometr),
						'name' => q(litrau wrth y 100 cilometr),
						'one' => q({0} litr wrth y 100 cilometr),
						'other' => q({0} litr wrth y 100 cilometr),
						'two' => q({0} litr wrth y 100 cilometr),
						'zero' => q({0} litr wrth y 100 cilometr),
					},
					'liter-per-kilometer' => {
						'few' => q({0} litr y cilometr),
						'many' => q({0} litr y cilometr),
						'name' => q(litrau y cilometr),
						'one' => q({0} litr y cilometr),
						'other' => q({0} litr y cilometr),
						'two' => q({0} litr y cilometr),
						'zero' => q({0} litr y cilometr),
					},
					'lux' => {
						'few' => q({0} lwcs),
						'many' => q({0} lwcs),
						'name' => q(lycsau),
						'one' => q({0} lwcs),
						'other' => q({0} lwcs),
						'two' => q({0} lwcs),
						'zero' => q({0} lwcs),
					},
					'megabit' => {
						'few' => q({0} megadid),
						'many' => q({0} megadid),
						'name' => q(megadidau),
						'one' => q({0} megadid),
						'other' => q({0} megadid),
						'two' => q({0} fegadid),
						'zero' => q({0} megadid),
					},
					'megabyte' => {
						'few' => q({0} megabeit),
						'many' => q({0} megabeit),
						'name' => q(megabeitiau),
						'one' => q({0} megabeit),
						'other' => q({0} megabeit),
						'two' => q({0} fegabeit),
						'zero' => q({0} megabeit),
					},
					'megahertz' => {
						'few' => q({0} megaherts),
						'many' => q({0} megaherts),
						'name' => q(megaherts),
						'one' => q({0} megaherts),
						'other' => q({0} megaherts),
						'two' => q({0} fegaherts),
						'zero' => q({0} megaherts),
					},
					'megaliter' => {
						'few' => q({0} megalitr),
						'many' => q({0} megalitr),
						'name' => q(megalitrau),
						'one' => q({0} megalitr),
						'other' => q({0} megalitr),
						'two' => q({0} fegalitr),
						'zero' => q({0} megalitr),
					},
					'megawatt' => {
						'few' => q({0} megawat),
						'many' => q({0} megawat),
						'name' => q(megawatiau),
						'one' => q({0} megawat),
						'other' => q({0} megawat),
						'two' => q({0} fegawat),
						'zero' => q({0} megawat),
					},
					'meter' => {
						'few' => q({0} metr),
						'many' => q({0} metr),
						'name' => q(metrau),
						'one' => q({0} metr),
						'other' => q({0} metr),
						'per' => q({0} y metr),
						'two' => q({0} fetr),
						'zero' => q({0} metr),
					},
					'meter-per-second' => {
						'few' => q({0} metr yr eiliad),
						'many' => q({0} metr yr eiliad),
						'name' => q(metrau yr eiliad),
						'one' => q({0} metr yr eiliad),
						'other' => q({0} metr yr eiliad),
						'two' => q({0} fetr yr eiliad),
						'zero' => q({0} metr yr eiliad),
					},
					'meter-per-second-squared' => {
						'few' => q({0} metr yr eiliad sgwâr),
						'many' => q({0} metr yr eiliad sgwâr),
						'name' => q(metrau yr eiliad sgwâr),
						'one' => q({0} metr yr eiliad sgwâr),
						'other' => q({0} metr yr eiliad sgwâr),
						'two' => q({0} fetr yr eiliad sgwâr),
						'zero' => q({0} metr yr eiliad sgwâr),
					},
					'metric-ton' => {
						'few' => q({0} tunnell fetrig),
						'many' => q({0} tunnell fetrig),
						'name' => q(tunelli metrig),
						'one' => q({0} dunnell fetrig),
						'other' => q({0} tunnell fetrig),
						'two' => q({0} dunnell fetrig),
						'zero' => q({0} tunnell fetrig),
					},
					'microgram' => {
						'few' => q({0} microgram),
						'many' => q({0} microgram),
						'name' => q(microgramau),
						'one' => q({0} microgram),
						'other' => q({0} microgram),
						'two' => q({0} ficrogram),
						'zero' => q({0} microgram),
					},
					'micrometer' => {
						'few' => q({0} micrometr),
						'many' => q({0} micrometr),
						'name' => q(micrometrau),
						'one' => q({0} micrometr),
						'other' => q({0} micrometr),
						'two' => q({0} ficrometr),
						'zero' => q({0} micrometr),
					},
					'microsecond' => {
						'few' => q({0} microeiliadau),
						'many' => q({0} microeiliadau),
						'name' => q(microeiliadau),
						'one' => q({0} microeiliadau),
						'other' => q({0} microeiliadau),
						'two' => q({0} microeiliadau),
						'zero' => q({0} microeiliadau),
					},
					'mile' => {
						'few' => q({0} milltir),
						'many' => q({0} milltir),
						'name' => q(milltiroedd),
						'one' => q({0} filltir),
						'other' => q({0} milltir),
						'two' => q({0} filltir),
						'zero' => q({0} milltir),
					},
					'mile-per-gallon' => {
						'few' => q({0} milltir y galwyn),
						'many' => q({0} milltir y galwyn),
						'name' => q(milltiroedd y galwyn),
						'one' => q({0} filltir y galwyn),
						'other' => q({0} milltir y galwyn),
						'two' => q({0} filltir y galwyn),
						'zero' => q({0} milltir y galwyn),
					},
					'mile-per-hour' => {
						'few' => q({0} milltir yr awr),
						'many' => q({0} milltir yr awr),
						'name' => q(milltiroedd yr awr),
						'one' => q({0} filltir yr awr),
						'other' => q({0} milltir yr awr),
						'two' => q({0} filltir yr awr),
						'zero' => q({0} milltir yr awr),
					},
					'mile-scandinavian' => {
						'few' => q({0} milltir Sgandinafia),
						'many' => q({0} milltir Sgandinafia),
						'name' => q(milltir Sgandinafia),
						'one' => q({0} filltir Sgandinafia),
						'other' => q({0} milltir Sgandinafia),
						'two' => q({0} filltir Sgandinafia),
						'zero' => q({0} milltir Sgandinafia),
					},
					'milliampere' => {
						'few' => q({0} miliamper),
						'many' => q({0} miliamper),
						'name' => q(miliamperau),
						'one' => q({0} miliamper),
						'other' => q({0} miliamper),
						'two' => q({0} filiamper),
						'zero' => q({0} miliamper),
					},
					'millibar' => {
						'few' => q({0} milibar),
						'many' => q({0} milibar),
						'name' => q(milibarrau),
						'one' => q({0} milibar),
						'other' => q({0} milibar),
						'two' => q({0} filibar),
						'zero' => q({0} milibar),
					},
					'milligram' => {
						'few' => q({0} miligram),
						'many' => q({0} miligram),
						'name' => q(miligramau),
						'one' => q({0} miligram),
						'other' => q({0} miligram),
						'two' => q({0} filigram),
						'zero' => q({0} miligram),
					},
					'milliliter' => {
						'few' => q({0} mililitr),
						'many' => q({0} mililitr),
						'name' => q(mililitrau),
						'one' => q({0} mililitr),
						'other' => q({0} mililitr),
						'two' => q({0} mililitr),
						'zero' => q({0} mililitr),
					},
					'millimeter' => {
						'few' => q({0} milimetr),
						'many' => q({0} milimetr),
						'name' => q(milimetrau),
						'one' => q({0} milimetr),
						'other' => q({0} milimetr),
						'two' => q({0} filimetr),
						'zero' => q({0} milimetr),
					},
					'millimeter-of-mercury' => {
						'few' => q({0} milimetr o fercwri),
						'many' => q({0} milimetr o fercwri),
						'name' => q(milimetrau o fercwri),
						'one' => q({0} milimetr o fercwri),
						'other' => q({0} milimetr o fercwri),
						'two' => q({0} filimetr o fercwri),
						'zero' => q({0} milimetr o fercwri),
					},
					'millisecond' => {
						'few' => q({0} milieiliad),
						'many' => q({0} milieiliad),
						'name' => q(milieiliadau),
						'one' => q({0} milieiliad),
						'other' => q({0} milieiliad),
						'two' => q({0} filieiliad),
						'zero' => q({0} milieiliad),
					},
					'milliwatt' => {
						'few' => q({0} miliwat),
						'many' => q({0} miliwat),
						'name' => q(miliwatiau),
						'one' => q({0} miliwat),
						'other' => q({0} miliwat),
						'two' => q({0} filiwat),
						'zero' => q({0} miliwat),
					},
					'minute' => {
						'few' => q({0} munud),
						'many' => q({0} munud),
						'name' => q(munudau),
						'one' => q({0} munud),
						'other' => q({0} munud),
						'per' => q({0} y munud),
						'two' => q({0} funud),
						'zero' => q({0} munud),
					},
					'month' => {
						'few' => q({0} mis),
						'many' => q({0} mis),
						'name' => q(misoedd),
						'one' => q({0} mis),
						'other' => q({0} mis),
						'per' => q({0} y mis),
						'two' => q({0} fis),
						'zero' => q({0} mis),
					},
					'nanometer' => {
						'few' => q({0} nanometr),
						'many' => q({0} nanometr),
						'name' => q(nanometrau),
						'one' => q({0} nanometr),
						'other' => q({0} nanometr),
						'two' => q({0} nanometr),
						'zero' => q({0} nanometr),
					},
					'nanosecond' => {
						'few' => q({0} nanoeiliadau),
						'many' => q({0} nanoeiliadau),
						'name' => q(nanoeiliadau),
						'one' => q({0} nanoeiliadau),
						'other' => q({0} nanoeiliadau),
						'two' => q({0} nanoeiliadau),
						'zero' => q({0} nanoeiliadau),
					},
					'nautical-mile' => {
						'few' => q({0} milltir fôr),
						'many' => q({0} milltir fôr),
						'name' => q(milltiroedd môr),
						'one' => q({0} filltir fôr),
						'other' => q({0} milltir fôr),
						'two' => q({0} filltir fôr),
						'zero' => q({0} milltir fôr),
					},
					'ohm' => {
						'few' => q({0} ohm),
						'many' => q({0} ohm),
						'name' => q(ohmau),
						'one' => q({0} ohm),
						'other' => q({0} ohm),
						'two' => q({0} ohm),
						'zero' => q({0} ohm),
					},
					'ounce' => {
						'few' => q({0} owns),
						'many' => q({0} owns),
						'name' => q(ownsys),
						'one' => q({0} owns),
						'other' => q({0} owns),
						'per' => q({0} yr owns),
						'two' => q({0} owns),
						'zero' => q({0} owns),
					},
					'ounce-troy' => {
						'few' => q({0} owns pwysau aur),
						'many' => q({0} owns pwysau aur),
						'name' => q(ownsiau pwysau aur),
						'one' => q({0} owns pwysau aur),
						'other' => q({0} owns pwysau aur),
						'two' => q({0} owns pwysau aur),
						'zero' => q({0} owns pwysau aur),
					},
					'parsec' => {
						'few' => q({0} pharsec),
						'many' => q({0} pharsec),
						'name' => q(parsecau),
						'one' => q({0} parsec),
						'other' => q({0} parsec),
						'two' => q({0} barsec),
						'zero' => q({0} parsec),
					},
					'per' => {
						'1' => q({0}/{1}),
					},
					'picometer' => {
						'few' => q({0} phicometr),
						'many' => q({0} phicometr),
						'name' => q(picometrau),
						'one' => q({0} picometr),
						'other' => q({0} picometr),
						'two' => q({0} bicometr),
						'zero' => q({0} picometr),
					},
					'pint' => {
						'few' => q({0} pheint),
						'many' => q({0} pheint),
						'name' => q(peintiau),
						'one' => q({0} peint),
						'other' => q({0} peint),
						'two' => q({0} beint),
						'zero' => q({0} peint),
					},
					'pint-metric' => {
						'few' => q({0} peint metrig),
						'many' => q({0} peint metrig),
						'name' => q(peintiau metrig),
						'one' => q({0} peint metrig),
						'other' => q({0} peint metrig),
						'two' => q({0} peint metrig),
						'zero' => q({0} peint metrig),
					},
					'pound' => {
						'few' => q({0} phwys),
						'many' => q({0} phwys),
						'name' => q(pwysi),
						'one' => q({0} pwys),
						'other' => q({0} pwys),
						'per' => q({0} y pwys),
						'two' => q({0} bwys),
						'zero' => q({0} pwys),
					},
					'pound-per-square-inch' => {
						'few' => q({0} pwys y fodfedd sgwar),
						'many' => q({0} pwys y fodfedd sgwar),
						'name' => q(pwysau y fodfedd sgwar),
						'one' => q({0} pwys y fodfedd sgwar),
						'other' => q({0} pwys y fodfedd sgwar),
						'two' => q({0} bwys y fodfedd sgwar),
						'zero' => q({0} pwys y fodfedd sgwar),
					},
					'quart' => {
						'few' => q({0} chwart),
						'many' => q({0} chwart),
						'name' => q(chwartiau),
						'one' => q({0} chwart),
						'other' => q({0} chwart),
						'two' => q({0} gwart),
						'zero' => q({0} chwart),
					},
					'radian' => {
						'few' => q({0} radian),
						'many' => q({0} radian),
						'name' => q(radianau),
						'one' => q({0} radian),
						'other' => q({0} radian),
						'two' => q({0} radian),
						'zero' => q({0} radian),
					},
					'revolution' => {
						'few' => q({0} cylchdro),
						'many' => q({0} cylchdro),
						'name' => q(cylchdroeon),
						'one' => q({0} cylchdro),
						'other' => q({0} cylchdro),
						'two' => q({0} gylchdro),
						'zero' => q({0} cylchdro),
					},
					'second' => {
						'few' => q({0} eiliad),
						'many' => q({0} eiliad),
						'name' => q(eiliadau),
						'one' => q({0} eiliad),
						'other' => q({0} eiliad),
						'per' => q({0} yr eiliad),
						'two' => q({0} eiliad),
						'zero' => q({0} eiliad),
					},
					'square-centimeter' => {
						'few' => q({0} chentimetr sgwâr),
						'many' => q({0} chentimetr sgwâr),
						'name' => q(centimetrau sgwâr),
						'one' => q({0} centimetr sgwâr),
						'other' => q({0} centimetr sgwâr),
						'per' => q({0} y centimetr sgwâr),
						'two' => q({0} gentimetr sgwâr),
						'zero' => q({0} centimetr sgwâr),
					},
					'square-foot' => {
						'few' => q({0} troedfedd sgwâr),
						'many' => q({0} throedfedd sgwâr),
						'name' => q(troedfeddi sgwâr),
						'one' => q({0} droedfedd sgwâr),
						'other' => q({0} troedfedd sgwâr),
						'two' => q({0} droedfedd sgwâr),
						'zero' => q({0} troedfedd sgwâr),
					},
					'square-inch' => {
						'few' => q({0} modfedd sgwâr),
						'many' => q({0} modfedd sgwâr),
						'name' => q(modfeddi sgwâr),
						'one' => q({0} modfedd sgwâr),
						'other' => q({0} modfedd sgwâr),
						'per' => q({0} y modfedd sgwâr),
						'two' => q({0} fodfedd sgwâr),
						'zero' => q({0} modfedd sgwâr),
					},
					'square-kilometer' => {
						'few' => q({0} chilometr sgwâr),
						'many' => q({0} chilometr sgwâr),
						'name' => q(cilometrau sgwâr),
						'one' => q({0} cilometr sgwâr),
						'other' => q({0} cilometr sgwâr),
						'two' => q({0} gilometr sgwâr),
						'zero' => q({0} cilometr sgwâr),
					},
					'square-meter' => {
						'few' => q({0} metr sgwâr),
						'many' => q({0} metr sgwâr),
						'name' => q(metrau sgwâr),
						'one' => q({0} metr sgwâr),
						'other' => q({0} metr sgwâr),
						'per' => q({0} y metr sgwâr),
						'two' => q({0} fetr sgwâr),
						'zero' => q({0} metr sgwâr),
					},
					'square-mile' => {
						'few' => q({0} milltir sgwâr),
						'many' => q({0} milltir sgwâr),
						'name' => q(milltiroedd sgwâr),
						'one' => q({0} filltir sgwâr),
						'other' => q({0} milltir sgwâr),
						'two' => q({0} filltir sgwâr),
						'zero' => q({0} milltir sgwâr),
					},
					'square-yard' => {
						'few' => q({0} llath sgwâr),
						'many' => q({0} llath sgwâr),
						'name' => q(llathenni sgwâr),
						'one' => q({0} llath sgwâr),
						'other' => q({0} llath sgwâr),
						'two' => q({0} lath sgwâr),
						'zero' => q({0} llath sgwâr),
					},
					'stone' => {
						'few' => q({0} stôn),
						'many' => q({0} stôn),
						'name' => q(stonau),
						'one' => q({0} stôn),
						'other' => q({0} stôn),
						'two' => q({0} stôn),
						'zero' => q({0} stôn),
					},
					'tablespoon' => {
						'few' => q({0} llond llwy fwrdd),
						'many' => q({0} llond llwy fwrdd),
						'name' => q(llond llwy fwrdd),
						'one' => q({0} llond llwy fwrdd),
						'other' => q({0} llond llwy fwrdd),
						'two' => q({0} lond llwy fwrdd),
						'zero' => q({0} llond llwy fwrdd),
					},
					'teaspoon' => {
						'few' => q({0} llond llwy de),
						'many' => q({0} llond llwy de),
						'name' => q(llond llwy de),
						'one' => q({0} llond llwy de),
						'other' => q({0} llond llwy de),
						'two' => q({0} lond llwy de),
						'zero' => q({0} llond llwy de),
					},
					'terabit' => {
						'few' => q({0} teradid),
						'many' => q({0} teradid),
						'name' => q(teradidau),
						'one' => q({0} teradid),
						'other' => q({0} teradid),
						'two' => q({0} deradid),
						'zero' => q({0} teradid),
					},
					'terabyte' => {
						'few' => q({0} terabeit),
						'many' => q({0} terabeit),
						'name' => q(terabeitiau),
						'one' => q({0} terabeit),
						'other' => q({0} terabeit),
						'two' => q({0} derabeit),
						'zero' => q({0} terabeit),
					},
					'ton' => {
						'few' => q({0} tunnell),
						'many' => q({0} tunnell),
						'name' => q(tunelli),
						'one' => q({0} dunnell),
						'other' => q({0} tunnell),
						'two' => q({0} dunnell),
						'zero' => q({0} tunnell),
					},
					'volt' => {
						'few' => q({0} folt),
						'many' => q({0} folt),
						'name' => q(foltiau),
						'one' => q({0} folt),
						'other' => q({0} folt),
						'two' => q({0} folt),
						'zero' => q({0} folt),
					},
					'watt' => {
						'few' => q({0} wat),
						'many' => q({0} wat),
						'name' => q(watiau),
						'one' => q({0} wat),
						'other' => q({0} wat),
						'two' => q({0} wat),
						'zero' => q({0} wat),
					},
					'week' => {
						'few' => q({0} wythnos),
						'many' => q({0} wythnos),
						'name' => q(wythnosau),
						'one' => q({0} wythnos),
						'other' => q({0} wythnos),
						'per' => q({0} yr wythnos),
						'two' => q({0} wythnos),
						'zero' => q({0} wythnos),
					},
					'yard' => {
						'few' => q({0} llath),
						'many' => q({0} llath),
						'name' => q(llathenni),
						'one' => q({0} llath),
						'other' => q({0} llath),
						'two' => q({0} lath),
						'zero' => q({0} llath),
					},
					'year' => {
						'few' => q({0} blynedd),
						'many' => q({0} blynedd),
						'name' => q(blynyddoedd),
						'one' => q({0} flwyddyn),
						'other' => q({0} mlynedd),
						'per' => q({0} y flwyddyn),
						'two' => q({0} flynedd),
						'zero' => q({0} mlynedd),
					},
				},
				'narrow' => {
					'acre' => {
						'few' => q({0}erw),
						'many' => q({0}erw),
						'name' => q(erw),
						'one' => q({0}erw),
						'other' => q({0}erw),
						'two' => q({0}erw),
						'zero' => q({0}erw),
					},
					'ampere' => {
						'few' => q({0}A),
						'many' => q({0}A),
						'name' => q(amp),
						'one' => q({0}A),
						'other' => q({0}A),
						'two' => q({0}A),
						'zero' => q({0}A),
					},
					'arc-minute' => {
						'few' => q({0}′),
						'many' => q({0}′),
						'one' => q({0}′),
						'other' => q({0}′),
						'two' => q({0}′),
						'zero' => q({0}′),
					},
					'arc-second' => {
						'few' => q({0}″),
						'many' => q({0}″),
						'one' => q({0}″),
						'other' => q({0}″),
						'two' => q({0}″),
						'zero' => q({0}″),
					},
					'astronomical-unit' => {
						'few' => q({0}u.s.),
						'many' => q({0}u.s.),
						'name' => q(u.s.),
						'one' => q({0}u.s.),
						'other' => q({0}u.s.),
						'two' => q({0}u.s.),
						'zero' => q({0}u.s.),
					},
					'bit' => {
						'few' => q({0}did),
						'many' => q({0}did),
						'name' => q(did),
						'one' => q({0}did),
						'other' => q({0}did),
						'two' => q({0}ddid),
						'zero' => q({0}did),
					},
					'byte' => {
						'few' => q({0}beit),
						'many' => q({0}beit),
						'name' => q(beit),
						'one' => q({0}beit),
						'other' => q({0}beit),
						'two' => q({0}feit),
						'zero' => q({0}beit),
					},
					'calorie' => {
						'few' => q({0}cal),
						'many' => q({0}cal),
						'name' => q(cal),
						'one' => q({0}cal),
						'other' => q({0}cal),
						'two' => q({0}cal),
						'zero' => q({0}cal),
					},
					'carat' => {
						'few' => q({0}CD),
						'many' => q({0}CD),
						'name' => q(carat),
						'one' => q({0}CD),
						'other' => q({0}CD),
						'two' => q({0}CD),
						'zero' => q({0}CD),
					},
					'celsius' => {
						'few' => q({0}°),
						'many' => q({0}°),
						'name' => q(°C),
						'one' => q({0}°),
						'other' => q({0}°),
						'two' => q({0}°),
						'zero' => q({0}°),
					},
					'centiliter' => {
						'few' => q({0}cL),
						'many' => q({0}cL),
						'name' => q(cL),
						'one' => q({0}cL),
						'other' => q({0}cL),
						'two' => q({0}cL),
						'zero' => q({0}cL),
					},
					'centimeter' => {
						'few' => q({0}cm),
						'many' => q({0}cm),
						'name' => q(cm),
						'one' => q({0}cm),
						'other' => q({0}cm),
						'per' => q({0}/cm),
						'two' => q({0}cm),
						'zero' => q({0}cm),
					},
					'century' => {
						'few' => q({0}c),
						'many' => q({0}c),
						'name' => q(c),
						'one' => q({0}c),
						'other' => q({0}c),
						'two' => q({0}c),
						'zero' => q({0}c),
					},
					'coordinate' => {
						'east' => q({0}dn),
						'north' => q({0}g),
						'south' => q({0}d),
						'west' => q({0}gn),
					},
					'cubic-centimeter' => {
						'few' => q({0}cm³),
						'many' => q({0}cm³),
						'name' => q(cm³),
						'one' => q({0}cm³),
						'other' => q({0}cm³),
						'per' => q({0}/cm³),
						'two' => q({0}cm³),
						'zero' => q({0}cm³),
					},
					'cubic-kilometer' => {
						'few' => q({0}km³),
						'many' => q({0}km³),
						'name' => q(km³),
						'one' => q({0}km³),
						'other' => q({0}km³),
						'two' => q({0}km³),
						'zero' => q({0}km³),
					},
					'cubic-meter' => {
						'few' => q({0}m³),
						'many' => q({0}m³),
						'name' => q(m³),
						'one' => q({0}m³),
						'other' => q({0}m³),
						'per' => q({0}/m³),
						'two' => q({0}m³),
						'zero' => q({0}m³),
					},
					'cubic-mile' => {
						'few' => q({0}mi³),
						'many' => q({0}mi³),
						'name' => q(mi³),
						'one' => q({0}mi³),
						'other' => q({0}mi³),
						'two' => q({0}mi³),
						'zero' => q({0}mi³),
					},
					'day' => {
						'few' => q({0}d),
						'many' => q({0}d),
						'name' => q(d),
						'one' => q({0}d),
						'other' => q({0}d),
						'per' => q({0}/d),
						'two' => q({0}d),
						'zero' => q({0}d),
					},
					'deciliter' => {
						'few' => q({0}dL),
						'many' => q({0}dL),
						'name' => q(dL),
						'one' => q({0}dL),
						'other' => q({0}dL),
						'two' => q({0}dL),
						'zero' => q({0}dL),
					},
					'decimeter' => {
						'few' => q({0}dm),
						'many' => q({0}dm),
						'name' => q(dm),
						'one' => q({0}dm),
						'other' => q({0}dm),
						'two' => q({0}dm),
						'zero' => q({0}dm),
					},
					'degree' => {
						'few' => q({0}°),
						'many' => q({0}°),
						'name' => q(gradd),
						'one' => q({0}°),
						'other' => q({0}°),
						'two' => q({0}°),
						'zero' => q({0}°),
					},
					'fahrenheit' => {
						'few' => q({0}°F),
						'many' => q({0}°F),
						'name' => q(°F),
						'one' => q({0}°F),
						'other' => q({0}°F),
						'two' => q({0}°F),
						'zero' => q({0}°F),
					},
					'fathom' => {
						'few' => q({0}fm),
						'many' => q({0}fm),
						'name' => q(gwrhydau),
						'one' => q({0}fm),
						'other' => q({0}fm),
						'two' => q({0}fm),
						'zero' => q({0}fm),
					},
					'foodcalorie' => {
						'few' => q({0}Cal),
						'many' => q({0}Cal),
						'name' => q(Cal),
						'one' => q({0}Cal),
						'other' => q({0}Cal),
						'two' => q({0}Cal),
						'zero' => q({0}Cal),
					},
					'foot' => {
						'few' => q({0}′),
						'many' => q({0}′),
						'name' => q(troedfedd),
						'one' => q({0}′),
						'other' => q({0}′),
						'per' => q({0}/ft),
						'two' => q({0}′),
						'zero' => q({0}′),
					},
					'g-force' => {
						'few' => q({0}G),
						'many' => q({0}G),
						'one' => q({0}G),
						'other' => q({0}G),
						'two' => q({0}G),
						'zero' => q({0}G),
					},
					'gallon' => {
						'few' => q({0}gal),
						'many' => q({0}gal),
						'name' => q(gal),
						'one' => q({0}gal),
						'other' => q({0}gal),
						'per' => q({0}/gal),
						'two' => q({0}gal),
						'zero' => q({0}gal),
					},
					'generic' => {
						'few' => q({0}°),
						'many' => q({0}°),
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
						'two' => q({0}°),
						'zero' => q({0}°),
					},
					'gigabit' => {
						'few' => q({0}Gb),
						'many' => q({0}Gb),
						'name' => q(Gb),
						'one' => q({0}Gb),
						'other' => q({0}Gb),
						'two' => q({0}Gb),
						'zero' => q({0}Gb),
					},
					'gigabyte' => {
						'few' => q({0}GB),
						'many' => q({0}GB),
						'name' => q(GBeit),
						'one' => q({0}GB),
						'other' => q({0}GB),
						'two' => q({0}GB),
						'zero' => q({0}GB),
					},
					'gigahertz' => {
						'few' => q({0}GHz),
						'many' => q({0}GHz),
						'name' => q(GHz),
						'one' => q({0}GHz),
						'other' => q({0}GHz),
						'two' => q({0}GHz),
						'zero' => q({0}GHz),
					},
					'gigawatt' => {
						'few' => q({0}GW),
						'many' => q({0}GW),
						'name' => q(GW),
						'one' => q({0}GW),
						'other' => q({0}GW),
						'two' => q({0}GW),
						'zero' => q({0}GW),
					},
					'gram' => {
						'few' => q({0}g),
						'many' => q({0}g),
						'name' => q(gram),
						'one' => q({0}g),
						'other' => q({0}g),
						'per' => q({0}/g),
						'two' => q({0}g),
						'zero' => q({0}g),
					},
					'hectare' => {
						'few' => q({0}ha),
						'many' => q({0}ha),
						'name' => q(hectar),
						'one' => q({0}ha),
						'other' => q({0}ha),
						'two' => q({0}ha),
						'zero' => q({0}ha),
					},
					'hectoliter' => {
						'few' => q({0}hL),
						'many' => q({0}hL),
						'name' => q(hL),
						'one' => q({0}hL),
						'other' => q({0}hL),
						'two' => q({0}hL),
						'zero' => q({0}hL),
					},
					'hectopascal' => {
						'few' => q({0}hPa),
						'many' => q({0}hPa),
						'name' => q(hPa),
						'one' => q({0}hPa),
						'other' => q({0}hPa),
						'two' => q({0}hPa),
						'zero' => q({0}hPa),
					},
					'hertz' => {
						'few' => q({0}Hz),
						'many' => q({0}Hz),
						'name' => q(Hz),
						'one' => q({0}Hz),
						'other' => q({0}Hz),
						'two' => q({0}Hz),
						'zero' => q({0}Hz),
					},
					'horsepower' => {
						'few' => q({0}hp),
						'many' => q({0}hp),
						'name' => q(hp),
						'one' => q({0}hp),
						'other' => q({0}hp),
						'two' => q({0}hp),
						'zero' => q({0}hp),
					},
					'hour' => {
						'few' => q({0} awr),
						'many' => q({0} awr),
						'name' => q(awr),
						'one' => q({0} awr),
						'other' => q({0} awr),
						'per' => q({0}/a),
						'two' => q({0} awr),
						'zero' => q({0} awr),
					},
					'inch' => {
						'few' => q({0}″),
						'many' => q({0}″),
						'name' => q(modfedd),
						'one' => q({0}″),
						'other' => q({0}″),
						'per' => q({0}/mod),
						'two' => q({0}″),
						'zero' => q({0}″),
					},
					'inch-hg' => {
						'few' => q({0}" Hg),
						'many' => q({0}" Hg),
						'name' => q(″ Hg),
						'one' => q({0}" Hg),
						'other' => q({0}" Hg),
						'two' => q({0}" Hg),
						'zero' => q({0}" Hg),
					},
					'joule' => {
						'few' => q({0}J),
						'many' => q({0}J),
						'name' => q(joule),
						'one' => q({0}J),
						'other' => q({0}J),
						'two' => q({0}J),
						'zero' => q({0}J),
					},
					'kelvin' => {
						'few' => q({0}K),
						'many' => q({0}K),
						'name' => q(K),
						'one' => q({0}K),
						'other' => q({0}K),
						'two' => q({0}K),
						'zero' => q({0}K),
					},
					'kilobyte' => {
						'few' => q({0}kB),
						'many' => q({0}kB),
						'name' => q(kBeit),
						'one' => q({0}kB),
						'other' => q({0}kB),
						'two' => q({0}kB),
						'zero' => q({0}kB),
					},
					'kilocalorie' => {
						'few' => q({0}kcal),
						'many' => q({0}kcal),
						'name' => q(kcal),
						'one' => q({0}kcal),
						'other' => q({0}kcal),
						'two' => q({0}kcal),
						'zero' => q({0}kcal),
					},
					'kilogram' => {
						'few' => q({0}kg),
						'many' => q({0}kg),
						'name' => q(kg),
						'one' => q({0}kg),
						'other' => q({0}kg),
						'per' => q({0}/kg),
						'two' => q({0}kg),
						'zero' => q({0}kg),
					},
					'kilohertz' => {
						'few' => q({0}kHz),
						'many' => q({0}kHz),
						'name' => q(kHz),
						'one' => q({0}kHz),
						'other' => q({0}kHz),
						'two' => q({0}kHz),
						'zero' => q({0}kHz),
					},
					'kilojoule' => {
						'few' => q({0}kj),
						'many' => q({0}kj),
						'name' => q(kJ),
						'one' => q({0}kj),
						'other' => q({0}kj),
						'two' => q({0}kj),
						'zero' => q({0}kj),
					},
					'kilometer' => {
						'few' => q({0}km),
						'many' => q({0}km),
						'name' => q(km),
						'one' => q({0}km),
						'other' => q({0}km),
						'per' => q({0}/km),
						'two' => q({0}km),
						'zero' => q({0}km),
					},
					'kilometer-per-hour' => {
						'few' => q({0}km/h),
						'many' => q({0}km/h),
						'name' => q(km/h),
						'one' => q({0}km/h),
						'other' => q({0}km/h),
						'two' => q({0}km/h),
						'zero' => q({0}km/h),
					},
					'kilowatt' => {
						'few' => q({0}kW),
						'many' => q({0}kW),
						'name' => q(kW),
						'one' => q({0}kW),
						'other' => q({0}kW),
						'two' => q({0}kW),
						'zero' => q({0}kW),
					},
					'knot' => {
						'few' => q({0}not),
						'many' => q({0}not),
						'name' => q(not),
						'one' => q({0}not),
						'other' => q({0}not),
						'two' => q({0}not),
						'zero' => q({0}not),
					},
					'light-year' => {
						'few' => q({0}ly),
						'many' => q({0}ly),
						'name' => q(ly),
						'one' => q({0}ly),
						'other' => q({0}ly),
						'two' => q({0}ly),
						'zero' => q({0}ly),
					},
					'liter' => {
						'few' => q({0} L),
						'many' => q({0} L),
						'name' => q(litr),
						'one' => q({0} L),
						'other' => q({0} L),
						'two' => q({0} L),
						'zero' => q({0} L),
					},
					'liter-per-100kilometers' => {
						'few' => q({0}L/100km),
						'many' => q({0}L/100km),
						'name' => q(L/100km),
						'one' => q({0}L/100km),
						'other' => q({0}L/100km),
						'two' => q({0}L/100km),
						'zero' => q({0}L/100km),
					},
					'liter-per-kilometer' => {
						'few' => q({0}L/km),
						'many' => q({0}L/km),
						'name' => q(L/km),
						'one' => q({0}L/km),
						'other' => q({0}L/km),
						'two' => q({0}L/km),
						'zero' => q({0}L/km),
					},
					'lux' => {
						'few' => q({0}lx),
						'many' => q({0}lx),
						'name' => q(lwcs),
						'one' => q({0}lx),
						'other' => q({0}lx),
						'two' => q({0}lx),
						'zero' => q({0}lx),
					},
					'megabyte' => {
						'few' => q({0}MB),
						'many' => q({0}MB),
						'name' => q(MBeit),
						'one' => q({0}MB),
						'other' => q({0}MB),
						'two' => q({0}MB),
						'zero' => q({0}MB),
					},
					'megahertz' => {
						'few' => q({0}MHz),
						'many' => q({0}MHz),
						'name' => q(MHz),
						'one' => q({0}MHz),
						'other' => q({0}MHz),
						'two' => q({0}MHz),
						'zero' => q({0}MHz),
					},
					'megaliter' => {
						'few' => q({0}ML),
						'many' => q({0}ML),
						'name' => q(ML),
						'one' => q({0}ML),
						'other' => q({0}ML),
						'two' => q({0}ML),
						'zero' => q({0}ML),
					},
					'megawatt' => {
						'few' => q({0}MW),
						'many' => q({0}MW),
						'name' => q(MW),
						'one' => q({0}MW),
						'other' => q({0}MW),
						'two' => q({0}MW),
						'zero' => q({0}MW),
					},
					'meter' => {
						'few' => q({0}m),
						'many' => q({0}m),
						'name' => q(metr),
						'one' => q({0}m),
						'other' => q({0}m),
						'per' => q({0}/m),
						'two' => q({0}m),
						'zero' => q({0}m),
					},
					'meter-per-second' => {
						'few' => q({0}m/s),
						'many' => q({0}m/s),
						'name' => q(m/s),
						'one' => q({0}m/s),
						'other' => q({0}m/s),
						'two' => q({0}m/s),
						'zero' => q({0}m/s),
					},
					'metric-ton' => {
						'few' => q({0}t),
						'many' => q({0}t),
						'name' => q(t),
						'one' => q({0}t),
						'other' => q({0}t),
						'two' => q({0}t),
						'zero' => q({0}t),
					},
					'microgram' => {
						'few' => q({0}µg),
						'many' => q({0}µg),
						'name' => q(µg),
						'one' => q({0}µg),
						'other' => q({0}µg),
						'two' => q({0}µg),
						'zero' => q({0}µg),
					},
					'micrometer' => {
						'few' => q({0}µm),
						'many' => q({0}µm),
						'name' => q(µm),
						'one' => q({0}µm),
						'other' => q({0}µm),
						'two' => q({0}µm),
						'zero' => q({0}µm),
					},
					'mile' => {
						'few' => q({0}mi),
						'many' => q({0}mi),
						'name' => q(mi),
						'one' => q({0}mi),
						'other' => q({0}mi),
						'two' => q({0}mi),
						'zero' => q({0}mi),
					},
					'mile-per-hour' => {
						'few' => q({0}m.y.a.),
						'many' => q({0}m.y.a.),
						'name' => q(m.y.a.),
						'one' => q({0}m.y.a.),
						'other' => q({0}m.y.a.),
						'two' => q({0}m.y.a.),
						'zero' => q({0}m.y.a.),
					},
					'milliampere' => {
						'few' => q({0}mA),
						'many' => q({0}mA),
						'name' => q(mA),
						'one' => q({0}mA),
						'other' => q({0}mA),
						'two' => q({0}mA),
						'zero' => q({0}mA),
					},
					'millibar' => {
						'few' => q({0}mb),
						'many' => q({0}mb),
						'name' => q(mbar),
						'one' => q({0}mb),
						'other' => q({0}mb),
						'two' => q({0}mb),
						'zero' => q({0}mb),
					},
					'milligram' => {
						'few' => q({0}mg),
						'many' => q({0}mg),
						'name' => q(mg),
						'one' => q({0}mg),
						'other' => q({0}mg),
						'two' => q({0}mg),
						'zero' => q({0}mg),
					},
					'milliliter' => {
						'few' => q({0}mL),
						'many' => q({0}mL),
						'name' => q(mL),
						'one' => q({0}mL),
						'other' => q({0}mL),
						'two' => q({0}mL),
						'zero' => q({0}mL),
					},
					'millimeter' => {
						'few' => q({0}mm),
						'many' => q({0}mm),
						'name' => q(mm),
						'one' => q({0}mm),
						'other' => q({0}mm),
						'two' => q({0}mm),
						'zero' => q({0}mm),
					},
					'millimeter-of-mercury' => {
						'few' => q({0}mm Hg),
						'many' => q({0}mm Hg),
						'name' => q(mm Hg),
						'one' => q({0}mm Hg),
						'other' => q({0}mm Hg),
						'two' => q({0}mm Hg),
						'zero' => q({0}mm Hg),
					},
					'millisecond' => {
						'few' => q({0}ms),
						'many' => q({0}ms),
						'name' => q(milieiliad),
						'one' => q({0}ms),
						'other' => q({0}ms),
						'two' => q({0}ms),
						'zero' => q({0}ms),
					},
					'milliwatt' => {
						'few' => q({0}mW),
						'many' => q({0}mW),
						'name' => q(mW),
						'one' => q({0}mW),
						'other' => q({0}mW),
						'two' => q({0}mW),
						'zero' => q({0}mW),
					},
					'minute' => {
						'few' => q({0}mun),
						'many' => q({0}mun),
						'name' => q(mun),
						'one' => q({0}mun),
						'other' => q({0}mun),
						'per' => q({0}/mun),
						'two' => q({0}mun),
						'zero' => q({0}mun),
					},
					'month' => {
						'few' => q({0}m),
						'many' => q({0}m),
						'name' => q(mis),
						'one' => q({0}m),
						'other' => q({0}m),
						'per' => q({0}/m),
						'two' => q({0}m),
						'zero' => q({0}m),
					},
					'nanometer' => {
						'few' => q({0}nm),
						'many' => q({0}nm),
						'name' => q(nm),
						'one' => q({0}nm),
						'other' => q({0}nm),
						'two' => q({0}nm),
						'zero' => q({0}nm),
					},
					'nautical-mile' => {
						'name' => q(mi fôr),
					},
					'ohm' => {
						'few' => q({0}Ω),
						'many' => q({0}Ω),
						'name' => q(ohm),
						'one' => q({0}Ω),
						'other' => q({0}Ω),
						'two' => q({0}Ω),
						'zero' => q({0}Ω),
					},
					'ounce' => {
						'few' => q({0}owns),
						'many' => q({0}owns),
						'name' => q(owns),
						'one' => q({0}owns),
						'other' => q({0}owns),
						'per' => q({0}/owns),
						'two' => q({0}owns),
						'zero' => q({0}owns),
					},
					'parsec' => {
						'few' => q({0}pc),
						'many' => q({0}pc),
						'name' => q(pc),
						'one' => q({0}pc),
						'other' => q({0}pc),
						'two' => q({0}pc),
						'zero' => q({0}pc),
					},
					'per' => {
						'1' => q({0}/{1}),
					},
					'picometer' => {
						'few' => q({0}pm),
						'many' => q({0}pm),
						'name' => q(pm),
						'one' => q({0}pm),
						'other' => q({0}pm),
						'two' => q({0}pm),
						'zero' => q({0}pm),
					},
					'pint' => {
						'few' => q({0}pt),
						'many' => q({0}pt),
						'name' => q(pt),
						'one' => q({0}pt),
						'other' => q({0}pt),
						'two' => q({0}pt),
						'zero' => q({0}pt),
					},
					'pound' => {
						'few' => q({0}phwys),
						'many' => q({0}phwys),
						'name' => q(pwys),
						'one' => q({0}pwys),
						'other' => q({0}pwys),
						'per' => q({0}/pwys),
						'two' => q({0}bwys),
						'zero' => q({0}pwys),
					},
					'pound-per-square-inch' => {
						'few' => q({0}psi),
						'many' => q({0}psi),
						'name' => q(psi),
						'one' => q({0}psi),
						'other' => q({0}psi),
						'two' => q({0}psi),
						'zero' => q({0}psi),
					},
					'radian' => {
						'few' => q({0}rad),
						'many' => q({0}rad),
						'name' => q(rad),
						'one' => q({0}rad),
						'other' => q({0}rad),
						'two' => q({0}rad),
						'zero' => q({0}rad),
					},
					'second' => {
						'few' => q({0} eil),
						'many' => q({0} eil),
						'name' => q(eil),
						'one' => q({0} eil),
						'other' => q({0} eil),
						'per' => q({0}/e),
						'two' => q({0} eil),
						'zero' => q({0} eil),
					},
					'square-centimeter' => {
						'few' => q({0}cm²),
						'many' => q({0}cm²),
						'name' => q(cm²),
						'one' => q({0}cm²),
						'other' => q({0}cm²),
						'per' => q({0}/cm²),
						'two' => q({0}cm²),
						'zero' => q({0}cm²),
					},
					'square-foot' => {
						'few' => q({0}ft²),
						'many' => q({0}ft²),
						'one' => q({0}ft²),
						'other' => q({0}ft²),
						'two' => q({0}ft²),
						'zero' => q({0}ft²),
					},
					'square-kilometer' => {
						'few' => q({0}km²),
						'many' => q({0}km²),
						'name' => q(km²),
						'one' => q({0}km²),
						'other' => q({0}km²),
						'two' => q({0}km²),
						'zero' => q({0}km²),
					},
					'square-meter' => {
						'few' => q({0}m²),
						'many' => q({0}m²),
						'name' => q(metrau²),
						'one' => q({0}m²),
						'other' => q({0}m²),
						'per' => q({0}/m²),
						'two' => q({0}m²),
						'zero' => q({0}m²),
					},
					'square-mile' => {
						'few' => q({0}mi²),
						'many' => q({0}mi²),
						'name' => q(mi²),
						'one' => q({0}mi²),
						'other' => q({0}mi²),
						'two' => q({0}mi²),
						'zero' => q({0}mi²),
					},
					'stone' => {
						'few' => q({0}st),
						'many' => q({0}st),
						'name' => q(stôn),
						'one' => q({0}st),
						'other' => q({0}st),
						'two' => q({0}st),
						'zero' => q({0}st),
					},
					'terabyte' => {
						'few' => q({0}TB),
						'many' => q({0}TB),
						'name' => q(TBeit),
						'one' => q({0}TB),
						'other' => q({0}TB),
						'two' => q({0}TB),
						'zero' => q({0}TB),
					},
					'volt' => {
						'few' => q({0}V),
						'many' => q({0}V),
						'name' => q(folt),
						'one' => q({0}V),
						'other' => q({0}V),
						'two' => q({0}V),
						'zero' => q({0}V),
					},
					'watt' => {
						'few' => q({0}W),
						'many' => q({0}W),
						'name' => q(wat),
						'one' => q({0}W),
						'other' => q({0}W),
						'two' => q({0}W),
						'zero' => q({0}W),
					},
					'week' => {
						'few' => q({0}w),
						'many' => q({0}w),
						'name' => q(w),
						'one' => q({0}w),
						'other' => q({0}w),
						'per' => q({0}/w),
						'two' => q({0}w),
						'zero' => q({0}w),
					},
					'yard' => {
						'few' => q({0}llath),
						'many' => q({0}llath),
						'name' => q(llath),
						'one' => q({0}llath),
						'other' => q({0}llath),
						'two' => q({0}lath),
						'zero' => q({0}llath),
					},
					'year' => {
						'few' => q({0}bl),
						'many' => q({0}bl),
						'name' => q(bl),
						'one' => q({0}bl),
						'other' => q({0}bl),
						'per' => q({0}/bl),
						'two' => q({0}bl),
						'zero' => q({0}bl),
					},
				},
				'short' => {
					'acre' => {
						'few' => q({0} erw),
						'many' => q({0} erw),
						'name' => q(erw),
						'one' => q({0} erw),
						'other' => q({0} erw),
						'two' => q({0} erw),
						'zero' => q({0} erw),
					},
					'acre-foot' => {
						'few' => q({0} erw tr),
						'many' => q({0} erw tr),
						'name' => q(erw tr),
						'one' => q({0} erw tr),
						'other' => q({0} erw tr),
						'two' => q({0} erw tr),
						'zero' => q({0} erw tr),
					},
					'ampere' => {
						'few' => q({0} A),
						'many' => q({0} A),
						'name' => q(ampau),
						'one' => q({0} A),
						'other' => q({0} A),
						'two' => q({0} A),
						'zero' => q({0} A),
					},
					'arc-minute' => {
						'few' => q({0}′),
						'many' => q({0}′),
						'name' => q(arcfunudau),
						'one' => q({0}′),
						'other' => q({0}′),
						'two' => q({0}′),
						'zero' => q({0}′),
					},
					'arc-second' => {
						'few' => q({0}″),
						'many' => q({0}″),
						'name' => q(arceiliadau),
						'one' => q({0}″),
						'other' => q({0}″),
						'two' => q({0}″),
						'zero' => q({0}″),
					},
					'astronomical-unit' => {
						'few' => q({0} u.s.),
						'many' => q({0} u.s.),
						'name' => q(u.s.),
						'one' => q({0} u.s.),
						'other' => q({0} u.s.),
						'two' => q({0} u.s.),
						'zero' => q({0} u.s.),
					},
					'bit' => {
						'few' => q({0} did),
						'many' => q({0} did),
						'name' => q(did),
						'one' => q({0} did),
						'other' => q({0} did),
						'two' => q({0} ddid),
						'zero' => q({0} did),
					},
					'bushel' => {
						'few' => q({0} bwsiel),
						'many' => q({0} bwsiel),
						'name' => q(bwsielau),
						'one' => q({0} bwsiel),
						'other' => q({0} bwsiel),
						'two' => q({0} bwsiel),
						'zero' => q({0} bwsiel),
					},
					'byte' => {
						'few' => q({0} beit),
						'many' => q({0} beit),
						'name' => q(beit),
						'one' => q({0} beit),
						'other' => q({0} beit),
						'two' => q({0} feit),
						'zero' => q({0} beit),
					},
					'calorie' => {
						'few' => q({0} cal),
						'many' => q({0} cal),
						'name' => q(cal),
						'one' => q({0} cal),
						'other' => q({0} cal),
						'two' => q({0} cal),
						'zero' => q({0} cal),
					},
					'carat' => {
						'few' => q({0} CD),
						'many' => q({0} CD),
						'name' => q(caratau),
						'one' => q({0} CD),
						'other' => q({0} CD),
						'two' => q({0} CD),
						'zero' => q({0} CD),
					},
					'celsius' => {
						'few' => q({0}°C),
						'many' => q({0}°C),
						'name' => q(gradd C),
						'one' => q({0}°C),
						'other' => q({0}°C),
						'two' => q({0}°C),
						'zero' => q({0}°C),
					},
					'centiliter' => {
						'few' => q({0} cL),
						'many' => q({0} cL),
						'name' => q(cL),
						'one' => q({0} cL),
						'other' => q({0} cL),
						'two' => q({0} cL),
						'zero' => q({0} cL),
					},
					'centimeter' => {
						'few' => q({0} cm),
						'many' => q({0} cm),
						'name' => q(cm),
						'one' => q({0} cm),
						'other' => q({0} cm),
						'per' => q({0}/cm),
						'two' => q({0} cm),
						'zero' => q({0} cm),
					},
					'century' => {
						'few' => q({0} c),
						'many' => q({0} c),
						'name' => q(c),
						'one' => q({0} c),
						'other' => q({0} c),
						'two' => q({0} c),
						'zero' => q({0} c),
					},
					'coordinate' => {
						'east' => q({0}dn),
						'north' => q({0}g),
						'south' => q({0}d),
						'west' => q({0}gn),
					},
					'cubic-centimeter' => {
						'few' => q({0} cm³),
						'many' => q({0} cm³),
						'name' => q(cm³),
						'one' => q({0} cm³),
						'other' => q({0} cm³),
						'per' => q({0}/cm³),
						'two' => q({0} cm³),
						'zero' => q({0} cm³),
					},
					'cubic-foot' => {
						'few' => q({0} troedfedd³),
						'many' => q({0} troedfedd³),
						'name' => q(troedfedd³),
						'one' => q({0} troedfedd³),
						'other' => q({0} troedfedd³),
						'two' => q({0} droedfedd³),
						'zero' => q({0} troedfedd³),
					},
					'cubic-inch' => {
						'few' => q({0} modfedd³),
						'many' => q({0} modfedd³),
						'name' => q(modfeddi³),
						'one' => q({0} modfedd³),
						'other' => q({0} modfedd³),
						'two' => q({0} fodfedd³),
						'zero' => q({0} modfedd³),
					},
					'cubic-kilometer' => {
						'few' => q({0} km³),
						'many' => q({0} km³),
						'name' => q(cilometrau ciwbig),
						'one' => q({0} km³),
						'other' => q({0} km³),
						'two' => q({0} km³),
						'zero' => q({0} km³),
					},
					'cubic-meter' => {
						'few' => q({0} m³),
						'many' => q({0} m³),
						'name' => q(m³),
						'one' => q({0} m³),
						'other' => q({0} m³),
						'per' => q({0}/m³),
						'two' => q({0} m³),
						'zero' => q({0} m³),
					},
					'cubic-mile' => {
						'few' => q({0} mi³),
						'many' => q({0} mi³),
						'name' => q(mi³),
						'one' => q({0} mi³),
						'other' => q({0} mi³),
						'two' => q({0} mi³),
						'zero' => q({0} mi³),
					},
					'cubic-yard' => {
						'few' => q({0} llath³),
						'many' => q({0} llath³),
						'name' => q(llathenni³),
						'one' => q({0} llathen³),
						'other' => q({0} llath³),
						'two' => q({0} lath³),
						'zero' => q({0} llath³),
					},
					'cup' => {
						'few' => q({0} c),
						'many' => q({0} c),
						'name' => q(cwpaneidiau),
						'one' => q({0} c),
						'other' => q({0} c),
						'two' => q({0} c),
						'zero' => q({0} c),
					},
					'cup-metric' => {
						'few' => q({0} mc),
						'many' => q({0} mc),
						'name' => q(cwpanaid metrig),
						'one' => q({0} mc),
						'other' => q({0} mc),
						'two' => q({0} mc),
						'zero' => q({0} mc),
					},
					'day' => {
						'few' => q({0} diwrnod),
						'many' => q({0} diwrnod),
						'name' => q(diwrnodau),
						'one' => q({0} diwrnod),
						'other' => q({0} diwrnod),
						'per' => q({0}/d),
						'two' => q({0} ddiwrnod),
						'zero' => q({0} diwrnod),
					},
					'deciliter' => {
						'few' => q({0} dL),
						'many' => q({0} dL),
						'name' => q(dL),
						'one' => q({0} dL),
						'other' => q({0} dL),
						'two' => q({0} dL),
						'zero' => q({0} dL),
					},
					'decimeter' => {
						'few' => q({0} dm),
						'many' => q({0} dm),
						'name' => q(dm),
						'one' => q({0} dm),
						'other' => q({0} dm),
						'two' => q({0} dm),
						'zero' => q({0} dm),
					},
					'degree' => {
						'few' => q({0}°),
						'many' => q({0}°),
						'name' => q(gradd),
						'one' => q({0}°),
						'other' => q({0}°),
						'two' => q({0}°),
						'zero' => q({0}°),
					},
					'fahrenheit' => {
						'few' => q({0}°F),
						'many' => q({0}°F),
						'name' => q(gradd F),
						'one' => q({0}°F),
						'other' => q({0}°F),
						'two' => q({0}°F),
						'zero' => q({0}°F),
					},
					'fathom' => {
						'few' => q({0} gwryd),
						'many' => q({0} gwryd),
						'name' => q(gwrhydau),
						'one' => q({0} gwryd),
						'other' => q({0} gwryd),
						'two' => q({0} wryd),
						'zero' => q({0} gwryd),
					},
					'fluid-ounce' => {
						'few' => q({0} fl oz),
						'many' => q({0} fl oz),
						'name' => q(fl oz),
						'one' => q({0} fl oz),
						'other' => q({0} fl oz),
						'two' => q({0} fl oz),
						'zero' => q({0} fl oz),
					},
					'foodcalorie' => {
						'few' => q({0} Cal),
						'many' => q({0} Cal),
						'name' => q(Cal),
						'one' => q({0} Cal),
						'other' => q({0} Cal),
						'two' => q({0} Cal),
						'zero' => q({0} Cal),
					},
					'foot' => {
						'few' => q({0}′),
						'many' => q({0}′),
						'name' => q(troedfeddi),
						'one' => q({0}′),
						'other' => q({0}′),
						'per' => q({0}/troedfedd),
						'two' => q({0}′),
						'zero' => q({0}′),
					},
					'furlong' => {
						'name' => q(ystadenni),
					},
					'g-force' => {
						'few' => q({0} G),
						'many' => q({0} G),
						'name' => q(grym disgyrchedd),
						'one' => q({0} G),
						'other' => q({0} G),
						'two' => q({0} G),
						'zero' => q({0} G),
					},
					'gallon' => {
						'few' => q({0} gal),
						'many' => q({0} gal),
						'name' => q(gal),
						'one' => q({0} gal),
						'other' => q({0} gal),
						'per' => q({0}/gal),
						'two' => q({0} gal),
						'zero' => q({0} gal),
					},
					'generic' => {
						'few' => q({0}°),
						'many' => q({0}°),
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
						'two' => q({0}°),
						'zero' => q({0}°),
					},
					'gigabit' => {
						'few' => q({0} Gb),
						'many' => q({0} Gb),
						'name' => q(Gb),
						'one' => q({0} Gb),
						'other' => q({0} Gb),
						'two' => q({0} Gb),
						'zero' => q({0} Gb),
					},
					'gigabyte' => {
						'few' => q({0} GB),
						'many' => q({0} GB),
						'name' => q(GBeit),
						'one' => q({0} GB),
						'other' => q({0} GB),
						'two' => q({0} GB),
						'zero' => q({0} GB),
					},
					'gigahertz' => {
						'few' => q({0} GHz),
						'many' => q({0} GHz),
						'name' => q(GHz),
						'one' => q({0} GHz),
						'other' => q({0} GHz),
						'two' => q({0} GHz),
						'zero' => q({0} GHz),
					},
					'gigawatt' => {
						'few' => q({0} GW),
						'many' => q({0} GW),
						'name' => q(GW),
						'one' => q({0} GW),
						'other' => q({0} GW),
						'two' => q({0} GW),
						'zero' => q({0} GW),
					},
					'gram' => {
						'few' => q({0} g),
						'many' => q({0} g),
						'name' => q(gramau),
						'one' => q({0} g),
						'other' => q({0} g),
						'per' => q({0}/g),
						'two' => q({0} g),
						'zero' => q({0} g),
					},
					'hectare' => {
						'few' => q({0} ha),
						'many' => q({0} ha),
						'name' => q(hectarau),
						'one' => q({0} ha),
						'other' => q({0} ha),
						'two' => q({0} ha),
						'zero' => q({0} ha),
					},
					'hectoliter' => {
						'few' => q({0} hL),
						'many' => q({0} hL),
						'name' => q(hL),
						'one' => q({0} hL),
						'other' => q({0} hL),
						'two' => q({0} hL),
						'zero' => q({0} hL),
					},
					'hectopascal' => {
						'few' => q({0} hPa),
						'many' => q({0} hPa),
						'name' => q(hPa),
						'one' => q({0} hPa),
						'other' => q({0} hPa),
						'two' => q({0} hPa),
						'zero' => q({0} hPa),
					},
					'hertz' => {
						'few' => q({0} Hz),
						'many' => q({0} Hz),
						'name' => q(Hz),
						'one' => q({0} Hz),
						'other' => q({0} Hz),
						'two' => q({0} Hz),
						'zero' => q({0} Hz),
					},
					'horsepower' => {
						'few' => q({0} hp),
						'many' => q({0} hp),
						'name' => q(hp),
						'one' => q({0} hp),
						'other' => q({0} hp),
						'two' => q({0} hp),
						'zero' => q({0} hp),
					},
					'hour' => {
						'few' => q({0} awr),
						'many' => q({0} awr),
						'name' => q(oriau),
						'one' => q({0} awr),
						'other' => q({0} awr),
						'per' => q({0} ya),
						'two' => q({0} awr),
						'zero' => q({0} awr),
					},
					'inch' => {
						'few' => q({0} modfedd),
						'many' => q({0} modfedd),
						'name' => q(modfeddi),
						'one' => q({0} fodfedd),
						'other' => q({0} modfedd),
						'per' => q({0}/fodfedd),
						'two' => q({0} fodfedd),
						'zero' => q({0} modfedd),
					},
					'inch-hg' => {
						'few' => q({0} ″ Hg),
						'many' => q({0} ″ Hg),
						'name' => q(modfeddi o fercwri),
						'one' => q({0} ″ Hg),
						'other' => q({0} ″ Hg),
						'two' => q({0} ″ Hg),
						'zero' => q({0} ″ Hg),
					},
					'joule' => {
						'few' => q({0} J),
						'many' => q({0} J),
						'name' => q(jouleau),
						'one' => q({0} J),
						'other' => q({0} J),
						'two' => q({0} J),
						'zero' => q({0} J),
					},
					'karat' => {
						'few' => q({0} kt),
						'many' => q({0} kt),
						'name' => q(karatau),
						'one' => q({0} kt),
						'other' => q({0} kt),
						'two' => q({0} kt),
						'zero' => q({0} kt),
					},
					'kelvin' => {
						'few' => q({0} K),
						'many' => q({0} K),
						'name' => q(K),
						'one' => q({0} K),
						'other' => q({0} K),
						'two' => q({0} K),
						'zero' => q({0} K),
					},
					'kilobit' => {
						'few' => q({0} kb),
						'many' => q({0} kb),
						'name' => q(kb),
						'one' => q({0} kb),
						'other' => q({0} kb),
						'two' => q({0} kb),
						'zero' => q({0} kb),
					},
					'kilobyte' => {
						'few' => q({0} kB),
						'many' => q({0} kB),
						'name' => q(kBeit),
						'one' => q({0} kB),
						'other' => q({0} kB),
						'two' => q({0} kB),
						'zero' => q({0} kB),
					},
					'kilocalorie' => {
						'few' => q({0} kcal),
						'many' => q({0} kcal),
						'name' => q(kcal),
						'one' => q({0} kcal),
						'other' => q({0} kcal),
						'two' => q({0} kcal),
						'zero' => q({0} kcal),
					},
					'kilogram' => {
						'few' => q({0} kg),
						'many' => q({0} kg),
						'name' => q(kg),
						'one' => q({0} kg),
						'other' => q({0} kg),
						'per' => q({0}/kg),
						'two' => q({0} kg),
						'zero' => q({0} kg),
					},
					'kilohertz' => {
						'few' => q({0} kHz),
						'many' => q({0} kHz),
						'name' => q(kHz),
						'one' => q({0} kHz),
						'other' => q({0} kHz),
						'two' => q({0} kHz),
						'zero' => q({0} kHz),
					},
					'kilojoule' => {
						'few' => q({0} kJ),
						'many' => q({0} kJ),
						'name' => q(cilojouleau),
						'one' => q({0} kJ),
						'other' => q({0} kJ),
						'two' => q({0} kJ),
						'zero' => q({0} kJ),
					},
					'kilometer' => {
						'few' => q({0} km),
						'many' => q({0} km),
						'name' => q(km),
						'one' => q({0} km),
						'other' => q({0} km),
						'per' => q({0}/km),
						'two' => q({0} km),
						'zero' => q({0} km),
					},
					'kilometer-per-hour' => {
						'few' => q({0} km/h),
						'many' => q({0} km/h),
						'name' => q(km/h),
						'one' => q({0} km/h),
						'other' => q({0} km/h),
						'two' => q({0} km/h),
						'zero' => q({0} km/h),
					},
					'kilowatt' => {
						'few' => q({0} kW),
						'many' => q({0} kW),
						'name' => q(kW),
						'one' => q({0} kW),
						'other' => q({0} kW),
						'two' => q({0} kW),
						'zero' => q({0} kW),
					},
					'kilowatt-hour' => {
						'few' => q({0} kW-awr),
						'many' => q({0} kW-awr),
						'name' => q(kW-awr),
						'one' => q({0} kW-awr),
						'other' => q({0} kW-awr),
						'two' => q({0} kW-awr),
						'zero' => q({0} kW-awr),
					},
					'knot' => {
						'few' => q({0} not),
						'many' => q({0} not),
						'name' => q(notiau),
						'one' => q({0} not),
						'other' => q({0} not),
						'two' => q({0} not),
						'zero' => q({0} not),
					},
					'light-year' => {
						'few' => q({0} blwyddyn golau),
						'many' => q({0} blwyddyn golau),
						'name' => q(bl golau),
						'one' => q({0} flwyddyn golau),
						'other' => q({0} blwyddyn golau),
						'two' => q({0} flwyddyn golau),
						'zero' => q({0} blwyddyn golau),
					},
					'liter' => {
						'few' => q({0} L),
						'many' => q({0} L),
						'name' => q(litrau),
						'one' => q({0} L),
						'other' => q({0} L),
						'per' => q({0}/L),
						'two' => q({0} L),
						'zero' => q({0} L),
					},
					'liter-per-100kilometers' => {
						'few' => q({0} L/100km),
						'many' => q({0} L/100km),
						'name' => q(L/100km),
						'one' => q({0} L/100km),
						'other' => q({0} L/100km),
						'two' => q({0} L/100km),
						'zero' => q({0} L/100km),
					},
					'liter-per-kilometer' => {
						'few' => q({0} L/km),
						'many' => q({0} L/km),
						'name' => q(litrau/km),
						'one' => q({0} L/km),
						'other' => q({0} L/km),
						'two' => q({0} L/km),
						'zero' => q({0} L/km),
					},
					'lux' => {
						'few' => q({0} lx),
						'many' => q({0} lx),
						'name' => q(lycsau),
						'one' => q({0} lx),
						'other' => q({0} lx),
						'two' => q({0} lx),
						'zero' => q({0} lx),
					},
					'megabit' => {
						'few' => q({0} Mb),
						'many' => q({0} Mb),
						'name' => q(Mb),
						'one' => q({0} Mb),
						'other' => q({0} Mb),
						'two' => q({0} Mb),
						'zero' => q({0} Mb),
					},
					'megabyte' => {
						'few' => q({0} MB),
						'many' => q({0} MB),
						'name' => q(MBeit),
						'one' => q({0} MB),
						'other' => q({0} MB),
						'two' => q({0} MB),
						'zero' => q({0} MB),
					},
					'megahertz' => {
						'few' => q({0} MHz),
						'many' => q({0} MHz),
						'name' => q(MHz),
						'one' => q({0} MHz),
						'other' => q({0} MHz),
						'two' => q({0} MHz),
						'zero' => q({0} MHz),
					},
					'megaliter' => {
						'few' => q({0} ML),
						'many' => q({0} ML),
						'name' => q(ML),
						'one' => q({0} ML),
						'other' => q({0} ML),
						'two' => q({0} ML),
						'zero' => q({0} ML),
					},
					'megawatt' => {
						'few' => q({0} MW),
						'many' => q({0} MW),
						'name' => q(MW),
						'one' => q({0} MW),
						'other' => q({0} MW),
						'two' => q({0} MW),
						'zero' => q({0} MW),
					},
					'meter' => {
						'few' => q({0} m),
						'many' => q({0} m),
						'name' => q(metrau),
						'one' => q({0} m),
						'other' => q({0} m),
						'per' => q({0} y metr),
						'two' => q({0} m),
						'zero' => q({0} m),
					},
					'meter-per-second' => {
						'few' => q({0} m/s),
						'many' => q({0} m/s),
						'name' => q(metrau/eil),
						'one' => q({0} m/s),
						'other' => q({0} m/s),
						'two' => q({0} m/s),
						'zero' => q({0} m/s),
					},
					'meter-per-second-squared' => {
						'few' => q({0} m/eil²),
						'many' => q({0} m/eil²),
						'name' => q(metrau/eil²),
						'one' => q({0} m/eil²),
						'other' => q({0} m/eil²),
						'two' => q({0} m/eil²),
						'zero' => q({0} m/eil²),
					},
					'metric-ton' => {
						'few' => q({0} t),
						'many' => q({0} t),
						'name' => q(t),
						'one' => q({0} t),
						'other' => q({0} t),
						'two' => q({0} t),
						'zero' => q({0} t),
					},
					'microgram' => {
						'few' => q({0} µg),
						'many' => q({0} µg),
						'name' => q(µg),
						'one' => q({0} µg),
						'other' => q({0} µg),
						'two' => q({0} µg),
						'zero' => q({0} µg),
					},
					'micrometer' => {
						'few' => q({0} µm),
						'many' => q({0} µm),
						'name' => q(µmetrau),
						'one' => q({0} µm),
						'other' => q({0} µm),
						'two' => q({0} µm),
						'zero' => q({0} µm),
					},
					'microsecond' => {
						'few' => q({0} μs),
						'many' => q({0} μs),
						'name' => q(μs),
						'one' => q({0} μs),
						'other' => q({0} μs),
						'two' => q({0} μs),
						'zero' => q({0} μs),
					},
					'mile' => {
						'few' => q({0} mi),
						'many' => q({0} mi),
						'name' => q(milltiroedd),
						'one' => q({0} mi),
						'other' => q({0} mi),
						'two' => q({0} mi),
						'zero' => q({0} mi),
					},
					'mile-per-gallon' => {
						'few' => q({0} mpg),
						'many' => q({0} mpg),
						'name' => q(mpg),
						'one' => q({0} mpg),
						'other' => q({0} mpg),
						'two' => q({0} mpg),
						'zero' => q({0} mpg),
					},
					'mile-per-hour' => {
						'few' => q({0} m.y.a.),
						'many' => q({0} m.y.a.),
						'name' => q(milltir/awr),
						'one' => q({0} m.y.a.),
						'other' => q({0} m.y.a.),
						'two' => q({0} m.y.a.),
						'zero' => q({0} m.y.a.),
					},
					'mile-scandinavian' => {
						'few' => q({0} mi Sgand.),
						'many' => q({0} mi Sgand.),
						'name' => q(mi Sgand.),
						'one' => q({0} mi Sgand.),
						'other' => q({0} mi Sgand.),
						'two' => q({0} mi Sgand.),
						'zero' => q({0} mi Sgand.),
					},
					'milliampere' => {
						'few' => q({0} mA),
						'many' => q({0} mA),
						'name' => q(miliampau),
						'one' => q({0} mA),
						'other' => q({0} mA),
						'two' => q({0} mA),
						'zero' => q({0} mA),
					},
					'millibar' => {
						'few' => q({0} mbar),
						'many' => q({0} mbar),
						'name' => q(mbar),
						'one' => q({0} mbar),
						'other' => q({0} mbar),
						'two' => q({0} mbar),
						'zero' => q({0} mbar),
					},
					'milligram' => {
						'few' => q({0} mg),
						'many' => q({0} mg),
						'name' => q(mg),
						'one' => q({0} mg),
						'other' => q({0} mg),
						'two' => q({0} mg),
						'zero' => q({0} mg),
					},
					'milliliter' => {
						'few' => q({0} mL),
						'many' => q({0} mL),
						'name' => q(mL),
						'one' => q({0} mL),
						'other' => q({0} mL),
						'two' => q({0} mL),
						'zero' => q({0} mL),
					},
					'millimeter' => {
						'few' => q({0} mm),
						'many' => q({0} mm),
						'name' => q(mm),
						'one' => q({0} mm),
						'other' => q({0} mm),
						'two' => q({0} mm),
						'zero' => q({0} mm),
					},
					'millimeter-of-mercury' => {
						'few' => q({0} mm Hg),
						'many' => q({0} mm Hg),
						'name' => q(mm Hg),
						'one' => q({0} mm Hg),
						'other' => q({0} mm Hg),
						'two' => q({0} mm Hg),
						'zero' => q({0} mm Hg),
					},
					'millisecond' => {
						'few' => q({0} ms),
						'many' => q({0} ms),
						'name' => q(milieiliadau),
						'one' => q({0} ms),
						'other' => q({0} ms),
						'two' => q({0} ms),
						'zero' => q({0} milieil),
					},
					'milliwatt' => {
						'few' => q({0} mW),
						'many' => q({0} mW),
						'name' => q(mW),
						'one' => q({0} mW),
						'other' => q({0} mW),
						'two' => q({0} mW),
						'zero' => q({0} mW),
					},
					'minute' => {
						'few' => q({0} mun),
						'many' => q({0} mun),
						'name' => q(mun),
						'one' => q({0} mun),
						'other' => q({0} mun),
						'per' => q({0}/mun),
						'two' => q({0} mun),
						'zero' => q({0} mun),
					},
					'month' => {
						'few' => q({0} mis),
						'many' => q({0} mis),
						'name' => q(misoedd),
						'one' => q({0} mis),
						'other' => q({0} mis),
						'per' => q({0}/mis),
						'two' => q({0} fis),
						'zero' => q({0} mis),
					},
					'nanometer' => {
						'few' => q({0} nm),
						'many' => q({0} nm),
						'name' => q(nm),
						'one' => q({0} nm),
						'other' => q({0} nm),
						'two' => q({0} nm),
						'zero' => q({0} nm),
					},
					'nanosecond' => {
						'few' => q({0} ns),
						'many' => q({0} ns),
						'name' => q(ns),
						'one' => q({0} ns),
						'other' => q({0} ns),
						'two' => q({0} ns),
						'zero' => q({0} ns),
					},
					'nautical-mile' => {
						'few' => q({0} mi fôr),
						'many' => q({0} mi fôr),
						'name' => q(mi fôr),
						'one' => q({0} mi fôr),
						'other' => q({0} mi fôr),
						'two' => q({0} mi fôr),
						'zero' => q({0} mi fôr),
					},
					'ohm' => {
						'few' => q({0} Ω),
						'many' => q({0} Ω),
						'name' => q(ohmau),
						'one' => q({0} Ω),
						'other' => q({0} Ω),
						'two' => q({0} Ω),
						'zero' => q({0} Ω),
					},
					'ounce' => {
						'few' => q({0} owns),
						'many' => q({0} owns),
						'name' => q(owns),
						'one' => q({0} owns),
						'other' => q({0} owns),
						'per' => q({0}/owns),
						'two' => q({0} owns),
						'zero' => q({0} owns),
					},
					'ounce-troy' => {
						'few' => q({0} oz t),
						'many' => q({0} oz t),
						'name' => q(oz t),
						'one' => q({0} oz t),
						'other' => q({0} oz t),
						'two' => q({0} oz t),
						'zero' => q({0} oz t),
					},
					'parsec' => {
						'few' => q({0} pc),
						'many' => q({0} pc),
						'name' => q(parsecau),
						'one' => q({0} pc),
						'other' => q({0} pc),
						'two' => q({0} pc),
						'zero' => q({0} pc),
					},
					'per' => {
						'1' => q({0}/{1}),
					},
					'picometer' => {
						'few' => q({0} pm),
						'many' => q({0} pm),
						'name' => q(pm),
						'one' => q({0} pm),
						'other' => q({0} pm),
						'two' => q({0} pm),
						'zero' => q({0} pm),
					},
					'pint' => {
						'few' => q({0} pt),
						'many' => q({0} pt),
						'name' => q(peintiau),
						'one' => q({0} pt),
						'other' => q({0} pt),
						'two' => q({0} pt),
						'zero' => q({0} pt),
					},
					'pint-metric' => {
						'few' => q({0} mpt),
						'many' => q({0} mpt),
						'name' => q(mpt),
						'one' => q({0} mpt),
						'other' => q({0} mpt),
						'two' => q({0} mpt),
						'zero' => q({0} mpt),
					},
					'pound' => {
						'few' => q({0} phwys),
						'many' => q({0} phwys),
						'name' => q(pwysi),
						'one' => q({0} pwys),
						'other' => q({0} pwys),
						'per' => q({0}/pwys),
						'two' => q({0} bwys),
						'zero' => q({0} pwys),
					},
					'pound-per-square-inch' => {
						'few' => q({0} psi),
						'many' => q({0} psi),
						'name' => q(psi),
						'one' => q({0} psi),
						'other' => q({0} psi),
						'two' => q({0} psi),
						'zero' => q({0} psi),
					},
					'quart' => {
						'few' => q({0} qt),
						'many' => q({0} qt),
						'name' => q(qt),
						'one' => q({0} qt),
						'other' => q({0} qt),
						'two' => q({0} qt),
						'zero' => q({0} qt),
					},
					'radian' => {
						'few' => q({0} rad),
						'many' => q({0} rad),
						'name' => q(radianau),
						'one' => q({0} rad),
						'other' => q({0} rad),
						'two' => q({0} rad),
						'zero' => q({0} rad),
					},
					'revolution' => {
						'few' => q({0} chylchdro),
						'many' => q({0} cylchdro),
						'name' => q(cylchdro),
						'one' => q({0} cylchdro),
						'other' => q({0} cylchdro),
						'two' => q({0} gylchdro),
						'zero' => q({0} cylchdro),
					},
					'second' => {
						'few' => q({0} eil),
						'many' => q({0} eil),
						'name' => q(eiliadau),
						'one' => q({0} eil),
						'other' => q({0} eil),
						'per' => q({0}/eil),
						'two' => q({0} eil),
						'zero' => q({0} eil),
					},
					'square-centimeter' => {
						'few' => q({0} cm²),
						'many' => q({0} cm²),
						'name' => q(cm²),
						'one' => q({0} cm²),
						'other' => q({0} cm²),
						'per' => q({0} y cm²),
						'two' => q({0} cm²),
						'zero' => q({0} cm²),
					},
					'square-foot' => {
						'few' => q({0} tr²),
						'many' => q({0} tr²),
						'name' => q(troedfedd²),
						'one' => q({0} tr²),
						'other' => q({0} tr²),
						'two' => q({0} tr²),
						'zero' => q({0} tr²),
					},
					'square-inch' => {
						'few' => q({0} mod²),
						'many' => q({0} mod²),
						'name' => q(modfedd²),
						'one' => q({0} mod²),
						'other' => q({0} mod²),
						'per' => q({0} y mod²),
						'two' => q({0} mod²),
						'zero' => q({0} mod²),
					},
					'square-kilometer' => {
						'few' => q({0} km²),
						'many' => q({0} km²),
						'name' => q(km²),
						'one' => q({0} km²),
						'other' => q({0} km²),
						'two' => q({0} km²),
						'zero' => q({0} km²),
					},
					'square-meter' => {
						'few' => q({0} m²),
						'many' => q({0} m²),
						'name' => q(meterau²),
						'one' => q({0} m²),
						'other' => q({0} m²),
						'per' => q({0} y m²),
						'two' => q({0} m²),
						'zero' => q({0} m²),
					},
					'square-mile' => {
						'few' => q({0} mi²),
						'many' => q({0} mi²),
						'name' => q(mi²),
						'one' => q({0} mi²),
						'other' => q({0} mi²),
						'two' => q({0} mi²),
						'zero' => q({0} mi²),
					},
					'square-yard' => {
						'few' => q({0} llath²),
						'many' => q({0} llath²),
						'name' => q(llath²),
						'one' => q({0} llath²),
						'other' => q({0} llath²),
						'two' => q({0} llath²),
						'zero' => q({0} llath²),
					},
					'stone' => {
						'few' => q({0} st),
						'many' => q({0} st),
						'name' => q(stonau),
						'one' => q({0} st),
						'other' => q({0} st),
						'two' => q({0} st),
						'zero' => q({0} st),
					},
					'tablespoon' => {
						'few' => q({0} tbsp),
						'many' => q({0} tbsp),
						'name' => q(tbsp),
						'one' => q({0} tbsp),
						'other' => q({0} tbsp),
						'two' => q({0} tbsp),
						'zero' => q({0} tbsp),
					},
					'teaspoon' => {
						'few' => q({0} tsp),
						'many' => q({0} tsp),
						'name' => q(tsp),
						'one' => q({0} tsp),
						'other' => q({0} tsp),
						'two' => q({0} tsp),
						'zero' => q({0} tsp),
					},
					'terabit' => {
						'few' => q({0} Tb),
						'many' => q({0} Tb),
						'name' => q(Tb),
						'one' => q({0} Tb),
						'other' => q({0} Tb),
						'two' => q({0} Tb),
						'zero' => q({0} Tb),
					},
					'terabyte' => {
						'few' => q({0} TB),
						'many' => q({0} TB),
						'name' => q(TBeit),
						'one' => q({0} TB),
						'other' => q({0} TB),
						'two' => q({0} TB),
						'zero' => q({0} TB),
					},
					'ton' => {
						'few' => q({0} tn),
						'many' => q({0} tn),
						'name' => q(tn),
						'one' => q({0} tn),
						'other' => q({0} tn),
						'two' => q({0} tn),
						'zero' => q({0} tn),
					},
					'volt' => {
						'few' => q({0} V),
						'many' => q({0} V),
						'name' => q(foltiau),
						'one' => q({0} V),
						'other' => q({0} V),
						'two' => q({0} V),
						'zero' => q({0} V),
					},
					'watt' => {
						'few' => q({0} W),
						'many' => q({0} W),
						'name' => q(watiau),
						'one' => q({0} W),
						'other' => q({0} W),
						'two' => q({0} W),
						'zero' => q({0} W),
					},
					'week' => {
						'few' => q({0} wythnos),
						'many' => q({0} wythnos),
						'name' => q(wythnosau),
						'one' => q({0} wythnos),
						'other' => q({0} wythnos),
						'per' => q({0}/wythnos),
						'two' => q({0} wythnos),
						'zero' => q({0} wythnos),
					},
					'yard' => {
						'few' => q({0} llath),
						'many' => q({0} llath),
						'name' => q(llathenni),
						'one' => q({0} llath),
						'other' => q({0} llath),
						'two' => q({0} lath),
						'zero' => q({0} llath),
					},
					'year' => {
						'few' => q({0} bl),
						'many' => q({0} bl),
						'name' => q(blynyddoedd),
						'one' => q({0} bl),
						'other' => q({0} bl),
						'per' => q({0}/bl),
						'two' => q({0} bl),
						'zero' => q({0} bl),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:ie|i|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:na|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
				start => q({0}, {1}),
				middle => q({0}, {1}),
				end => q({0}, {1}),
				2 => q({0}, {1}),
		} }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> 'latn',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> 'latn',
);

has 'minimum_grouping_digits' => (
	is			=>'ro',
	isa			=> 'Int',
	init_arg	=> undef,
	default		=> 1,
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'arab' => {
			'timeSeparator' => q(:),
		},
		'latn' => {
			'decimal' => q(.),
			'exponential' => q(E),
			'group' => q(,),
			'infinity' => q(∞),
			'list' => q(;),
			'minusSign' => q(-),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(x),
			'timeSeparator' => q(:),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'1000' => {
					'few' => '0K',
					'many' => '0K',
					'one' => '0K',
					'other' => '0K',
					'two' => '0K',
					'zero' => '0K',
				},
				'10000' => {
					'few' => '00K',
					'many' => '00K',
					'one' => '00K',
					'other' => '00K',
					'two' => '00K',
					'zero' => '00K',
				},
				'100000' => {
					'few' => '000K',
					'many' => '000K',
					'one' => '000K',
					'other' => '000K',
					'two' => '000K',
					'zero' => '000K',
				},
				'1000000' => {
					'few' => '0M',
					'many' => '0M',
					'one' => '0M',
					'other' => '0M',
					'two' => '0M',
					'zero' => '0M',
				},
				'10000000' => {
					'few' => '00M',
					'many' => '00M',
					'one' => '00M',
					'other' => '00M',
					'two' => '00M',
					'zero' => '00M',
				},
				'100000000' => {
					'few' => '000M',
					'many' => '000M',
					'one' => '000M',
					'other' => '000M',
					'two' => '000M',
					'zero' => '000M',
				},
				'1000000000' => {
					'few' => '0B',
					'many' => '0B',
					'one' => '0B',
					'other' => '0B',
					'two' => '0B',
					'zero' => '0B',
				},
				'10000000000' => {
					'few' => '00B',
					'many' => '00B',
					'one' => '00B',
					'other' => '00B',
					'two' => '00B',
					'zero' => '00B',
				},
				'100000000000' => {
					'few' => '000B',
					'many' => '000B',
					'one' => '000B',
					'other' => '000B',
					'two' => '000B',
					'zero' => '000B',
				},
				'1000000000000' => {
					'few' => '0T',
					'many' => '0T',
					'one' => '0T',
					'other' => '0T',
					'two' => '0T',
					'zero' => '0T',
				},
				'10000000000000' => {
					'few' => '00T',
					'many' => '00T',
					'one' => '00T',
					'other' => '00T',
					'two' => '00T',
					'zero' => '00T',
				},
				'100000000000000' => {
					'few' => '000T',
					'many' => '000T',
					'one' => '000T',
					'other' => '000T',
					'two' => '000T',
					'zero' => '000T',
				},
				'standard' => {
					'' => '#,##0.###',
				},
			},
			'long' => {
				'1000' => {
					'few' => '0 mil',
					'many' => '0 mil',
					'one' => '0 mil',
					'other' => '0 mil',
					'two' => '0 fil',
					'zero' => '0 mil',
				},
				'10000' => {
					'few' => '00 mil',
					'many' => '00 mil',
					'one' => '00 mil',
					'other' => '00 mil',
					'two' => '00 mil',
					'zero' => '00 mil',
				},
				'100000' => {
					'few' => '000 mil',
					'many' => '000 mil',
					'one' => '000 mil',
					'other' => '000 mil',
					'two' => '000 mil',
					'zero' => '000 mil',
				},
				'1000000' => {
					'few' => '0 miliwn',
					'many' => '0 miliwn',
					'one' => '0 miliwn',
					'other' => '0 miliwn',
					'two' => '0 filiwn',
					'zero' => '0 miliwn',
				},
				'10000000' => {
					'few' => '00 miliwn',
					'many' => '00 miliwn',
					'one' => '00 miliwn',
					'other' => '00 miliwn',
					'two' => '00 miliwn',
					'zero' => '00 miliwn',
				},
				'100000000' => {
					'few' => '000 miliwn',
					'many' => '000 miliwn',
					'one' => '000 miliwn',
					'other' => '000 miliwn',
					'two' => '000 miliwn',
					'zero' => '000 miliwn',
				},
				'1000000000' => {
					'few' => '0 biliwn',
					'many' => '0 biliwn',
					'one' => '0 biliwn',
					'other' => '0 biliwn',
					'two' => '0 biliwn',
					'zero' => '0 biliwn',
				},
				'10000000000' => {
					'few' => '00 biliwn',
					'many' => '00 biliwn',
					'one' => '00 biliwn',
					'other' => '00 biliwn',
					'two' => '00 biliwn',
					'zero' => '00 biliwn',
				},
				'100000000000' => {
					'few' => '000 biliwn',
					'many' => '000 biliwn',
					'one' => '000 biliwn',
					'other' => '000 biliwn',
					'two' => '000 biliwn',
					'zero' => '000 biliwn',
				},
				'1000000000000' => {
					'few' => '0 thriliwn',
					'many' => '0 thriliwn',
					'one' => '0 triliwn',
					'other' => '0 triliwn',
					'two' => '0 driliwn',
					'zero' => '0 triliwn',
				},
				'10000000000000' => {
					'few' => '00 triliwn',
					'many' => '00 triliwn',
					'one' => '00 triliwn',
					'other' => '00 triliwn',
					'two' => '00 triliwn',
					'zero' => '00 triliwn',
				},
				'100000000000000' => {
					'few' => '000 triliwn',
					'many' => '000 triliwn',
					'one' => '000 triliwn',
					'other' => '000 triliwn',
					'two' => '000 triliwn',
					'zero' => '000 triliwn',
				},
			},
			'short' => {
				'1000' => {
					'few' => '0K',
					'many' => '0K',
					'one' => '0K',
					'other' => '0K',
					'two' => '0K',
					'zero' => '0K',
				},
				'10000' => {
					'few' => '00K',
					'many' => '00K',
					'one' => '00K',
					'other' => '00K',
					'two' => '00K',
					'zero' => '00K',
				},
				'100000' => {
					'few' => '000K',
					'many' => '000K',
					'one' => '000K',
					'other' => '000K',
					'two' => '000K',
					'zero' => '000K',
				},
				'1000000' => {
					'few' => '0M',
					'many' => '0M',
					'one' => '0M',
					'other' => '0M',
					'two' => '0M',
					'zero' => '0M',
				},
				'10000000' => {
					'few' => '00M',
					'many' => '00M',
					'one' => '00M',
					'other' => '00M',
					'two' => '00M',
					'zero' => '00M',
				},
				'100000000' => {
					'few' => '000M',
					'many' => '000M',
					'one' => '000M',
					'other' => '000M',
					'two' => '000M',
					'zero' => '000M',
				},
				'1000000000' => {
					'few' => '0B',
					'many' => '0B',
					'one' => '0B',
					'other' => '0B',
					'two' => '0B',
					'zero' => '0B',
				},
				'10000000000' => {
					'few' => '00B',
					'many' => '00B',
					'one' => '00B',
					'other' => '00B',
					'two' => '00B',
					'zero' => '00B',
				},
				'100000000000' => {
					'few' => '000B',
					'many' => '000B',
					'one' => '000B',
					'other' => '000B',
					'two' => '000B',
					'zero' => '000B',
				},
				'1000000000000' => {
					'few' => '0T',
					'many' => '0T',
					'one' => '0T',
					'other' => '0T',
					'two' => '0T',
					'zero' => '0T',
				},
				'10000000000000' => {
					'few' => '00T',
					'many' => '00T',
					'one' => '00T',
					'other' => '00T',
					'two' => '00T',
					'zero' => '00T',
				},
				'100000000000000' => {
					'few' => '000T',
					'many' => '000T',
					'one' => '000T',
					'other' => '000T',
					'two' => '000T',
					'zero' => '000T',
				},
			},
		},
		percentFormat => {
			'default' => {
				'standard' => {
					'' => '#,##0%',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'standard' => {
					'' => '#E0',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'negative' => '(¤#,##0.00)',
						'positive' => '¤#,##0.00',
					},
					'standard' => {
						'positive' => '¤#,##0.00',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'AED' => {
			symbol => 'AED',
			display_name => {
				'currency' => q(Dirham Yr Emiradau Arabaidd Unedig),
				'few' => q(dirham yr Emiradau Arabaidd Unedig),
				'many' => q(dirham yr Emiradau Arabaidd Unedig),
				'one' => q(dirham yr Emiradau Arabaidd Unedig),
				'other' => q(dirham yr Emiradau Arabaidd Unedig),
				'two' => q(dirham yr Emiradau Arabaidd Unedig),
				'zero' => q(dirham yr Emiradau Arabaidd Unedig),
			},
		},
		'AFA' => {
			symbol => 'AFA',
			display_name => {
				'currency' => q(Afghani Afghanistan \(1927–2002\)),
				'few' => q(afghani Afghanistan \(1927–2002\)),
				'many' => q(afghani Afghanistan \(1927–2002\)),
				'one' => q(afghani Afghanistan \(1927–2002\)),
				'other' => q(afghani Afghanistan \(1927–2002\)),
				'two' => q(afghani Afghanistan \(1927–2002\)),
				'zero' => q(afghani Afghanistan \(1927–2002\)),
			},
		},
		'AFN' => {
			symbol => 'AFN',
			display_name => {
				'currency' => q(Afghani Afghanistan),
				'few' => q(Afghani Afghanistan),
				'many' => q(Afghani Afghanistan),
				'one' => q(Afghani Afghanistan),
				'other' => q(Afghani Afghanistan),
				'two' => q(Afghani Afghanistan),
				'zero' => q(Afghani Afghanistan),
			},
		},
		'ALL' => {
			symbol => 'ALL',
			display_name => {
				'currency' => q(Lek Albania),
				'few' => q(lek Albania),
				'many' => q(lek Albania),
				'one' => q(lek Albania),
				'other' => q(lek Albania),
				'two' => q(lek Albania),
				'zero' => q(lek Albania),
			},
		},
		'AMD' => {
			symbol => 'AMD',
			display_name => {
				'currency' => q(Dram Armenia),
				'few' => q(dram Armenia),
				'many' => q(dram Armenia),
				'one' => q(dram Armenia),
				'other' => q(dram Armenia),
				'two' => q(dram Armenia),
				'zero' => q(dram Armenia),
			},
		},
		'ANG' => {
			symbol => 'ANG',
			display_name => {
				'currency' => q(Guilder Antilles yr Iseldiroedd),
				'few' => q(guilder Antilles yr Iseldiroedd),
				'many' => q(guilder Antilles yr Iseldiroedd),
				'one' => q(guilder Antilles yr Iseldiroedd),
				'other' => q(guilder Antilles yr Iseldiroedd),
				'two' => q(guilder Antilles yr Iseldiroedd),
				'zero' => q(guilder Antilles yr Iseldiroedd),
			},
		},
		'AOA' => {
			symbol => 'AOA',
			display_name => {
				'currency' => q(Kwanza Angola),
				'few' => q(kwanza Angola),
				'many' => q(kwanza Angola),
				'one' => q(kwanza Angola),
				'other' => q(kwanza Angola),
				'two' => q(kwanza Angola),
				'zero' => q(kwanza Angola),
			},
		},
		'AOK' => {
			symbol => 'AOK',
			display_name => {
				'currency' => q(Kwanza Angola \(1977–1991\)),
				'few' => q(Kwanza Angola \(1977–1991\)),
				'many' => q(Kwanza Angola \(1977–1991\)),
				'one' => q(Kwanza Angola \(1977–1991\)),
				'other' => q(Kwanza Angola \(1977–1991\)),
				'two' => q(Kwanza Angola \(1977–1991\)),
				'zero' => q(Kwanza Angola \(1977–1991\)),
			},
		},
		'AON' => {
			symbol => 'AON',
			display_name => {
				'currency' => q(Kwanza Newydd Angola \(1990–2000\)),
				'few' => q(Kwanza Newydd Angola \(1990–2000\)),
				'many' => q(Kwanza Newydd Angola \(1990–2000\)),
				'one' => q(Kwanza Newydd Angola \(1990–2000\)),
				'other' => q(Kwanza Newydd Angola \(1990–2000\)),
				'two' => q(Kwanza Newydd Angola \(1990–2000\)),
				'zero' => q(Kwanza Newydd Angola \(1990–2000\)),
			},
		},
		'AOR' => {
			symbol => 'AOR',
			display_name => {
				'currency' => q(Kwanza Ailgymhwysedig Angola \(1995–1999\)),
				'few' => q(Kwanza Ailgymhwysedig Angola \(1995–1999\)),
				'many' => q(Kwanza Ailgymhwysedig Angola \(1995–1999\)),
				'one' => q(Kwanza Ailgymhwysedig Angola \(1995–1999\)),
				'other' => q(Kwanza Ailgymhwysedig Angola \(1995–1999\)),
				'two' => q(Kwanza Ailgymhwysedig Angola \(1995–1999\)),
				'zero' => q(Kwanza Ailgymhwysedig Angola \(1995–1999\)),
			},
		},
		'ARA' => {
			symbol => 'ARA',
			display_name => {
				'currency' => q(Austral yr Ariannin),
				'few' => q(austral yr Ariannin),
				'many' => q(austral yr Ariannin),
				'one' => q(austral yr Ariannin),
				'other' => q(austral yr Ariannin),
				'two' => q(austral yr Ariannin),
				'zero' => q(austral yr Ariannin),
			},
		},
		'ARL' => {
			symbol => 'ARL',
			display_name => {
				'currency' => q(Peso Ley yr Ariannin \(1970–1983\)),
				'few' => q(peso ley yr Ariannin \(1970–1983\)),
				'many' => q(peso ley yr Ariannin \(1970–1983\)),
				'one' => q(peso ley yr Ariannin \(1970–1983\)),
				'other' => q(peso ley yr Ariannin \(1970–1983\)),
				'two' => q(peso ley yr Ariannin \(1970–1983\)),
				'zero' => q(peso ley yr Ariannin \(1970–1983\)),
			},
		},
		'ARM' => {
			symbol => 'ARM',
			display_name => {
				'currency' => q(Peso yr Ariannin \(1881–1970\)),
				'few' => q(peso yr Ariannin \(1881–1970\)),
				'many' => q(peso yr Ariannin \(1881–1970\)),
				'one' => q(peso yr Ariannin \(1881–1970\)),
				'other' => q(peso yr Ariannin \(1881–1970\)),
				'two' => q(peso yr Ariannin \(1881–1970\)),
				'zero' => q(peso yr Ariannin \(1881–1970\)),
			},
		},
		'ARP' => {
			symbol => 'ARP',
			display_name => {
				'currency' => q(Peso yr Ariannin \(1983–1985\)),
				'few' => q(peso yr Ariannin \(1983–1985\)),
				'many' => q(peso yr Ariannin \(1983–1985\)),
				'one' => q(peso yr Ariannin \(1983–1985\)),
				'other' => q(peso yr Ariannin \(1983–1985\)),
				'two' => q(peso yr Ariannin \(1983–1985\)),
				'zero' => q(peso yr Ariannin \(1983–1985\)),
			},
		},
		'ARS' => {
			symbol => 'ARS',
			display_name => {
				'currency' => q(Peso yr Ariannin),
				'few' => q(peso yr Ariannin),
				'many' => q(peso yr Ariannin),
				'one' => q(peso yr Ariannin),
				'other' => q(peso yr Ariannin),
				'two' => q(peso yr Ariannin),
				'zero' => q(peso yr Ariannin),
			},
		},
		'ATS' => {
			symbol => 'ATS',
			display_name => {
				'currency' => q(Swllt Awstria),
				'few' => q(swllt Awstria),
				'many' => q(swllt Awstria),
				'one' => q(swllt Awstria),
				'other' => q(swllt Awstria),
				'two' => q(swllt Awstria),
				'zero' => q(swllt Awstria),
			},
		},
		'AUD' => {
			symbol => 'A$',
			display_name => {
				'currency' => q(Doler Awstralia),
				'few' => q(Doler Awstralia),
				'many' => q(Doler Awstralia),
				'one' => q(Doler Awstralia),
				'other' => q(Doler Awstralia),
				'two' => q(Doler Awstralia),
				'zero' => q(Doler Awstralia),
			},
		},
		'AWG' => {
			symbol => 'AWG',
			display_name => {
				'currency' => q(Fflorin Aruba),
				'few' => q(fflorin Aruba),
				'many' => q(fflorin Aruba),
				'one' => q(fflorin Aruba),
				'other' => q(fflorin Aruba),
				'two' => q(fflorin Aruba),
				'zero' => q(fflorin Aruba),
			},
		},
		'AZM' => {
			symbol => 'AZM',
			display_name => {
				'currency' => q(Manat Azerbaijan \(1993–2006\)),
				'few' => q(manat Azerbaijan \(1993–2006\)),
				'many' => q(manat Azerbaijan \(1993–2006\)),
				'one' => q(manat Azerbaijan \(1993–2006\)),
				'other' => q(manat Azerbaijan \(1993–2006\)),
				'two' => q(manat Azerbaijan \(1993–2006\)),
				'zero' => q(manat Azerbaijan \(1993–2006\)),
			},
		},
		'AZN' => {
			symbol => 'AZN',
			display_name => {
				'currency' => q(Manat Azerbaijan),
				'few' => q(manat Azerbaijan),
				'many' => q(manat Azerbaijan),
				'one' => q(manat Azerbaijan),
				'other' => q(Manat Azerbaijan),
				'two' => q(manat Azerbaijan),
				'zero' => q(manat Azerbaijan),
			},
		},
		'BAM' => {
			symbol => 'BAM',
			display_name => {
				'currency' => q(Marc Trosadwy Bosnia a Hercegovina),
				'few' => q(marc trosadwy Bosnia a Hercegovina),
				'many' => q(marc trosadwy Bosnia a Hercegovina),
				'one' => q(marc trosadwy Bosnia a Hercegovina),
				'other' => q(marc trosadwy Bosnia a Hercegovina),
				'two' => q(marc trosadwy Bosnia a Hercegovina),
				'zero' => q(marc trosadwy Bosnia a Hercegovina),
			},
		},
		'BBD' => {
			symbol => 'BBD',
			display_name => {
				'currency' => q(Doler Barbados),
				'few' => q(doler Barbados),
				'many' => q(doler Barbados),
				'one' => q(ddoler Barbados),
				'other' => q(doler Barbados),
				'two' => q(ddoler Barbados),
				'zero' => q(doler Barbados),
			},
		},
		'BDT' => {
			symbol => 'BDT',
			display_name => {
				'currency' => q(Taka Bangladesh),
				'few' => q(Taka Bangladesh),
				'many' => q(Taka Bangladesh),
				'one' => q(Taka Bangladesh),
				'other' => q(Taka Bangladesh),
				'two' => q(Taka Bangladesh),
				'zero' => q(Taka Bangladesh),
			},
		},
		'BEC' => {
			symbol => 'BEC',
		},
		'BEF' => {
			symbol => 'BEF',
		},
		'BEL' => {
			symbol => 'BEL',
		},
		'BGM' => {
			symbol => 'BGM',
			display_name => {
				'currency' => q(Lev Sosialaidd Bwlgaria),
				'few' => q(lev sosialaidd Bwlgaria),
				'many' => q(lev sosialaidd Bwlgaria),
				'one' => q(lev sosialaidd Bwlgaria),
				'other' => q(lev sosialaidd Bwlgaria),
				'two' => q(lev sosialaidd Bwlgaria),
				'zero' => q(lev sosialaidd Bwlgaria),
			},
		},
		'BGN' => {
			symbol => 'BGN',
			display_name => {
				'currency' => q(Lev Bwlgaria),
				'few' => q(lev Bwlgaria),
				'many' => q(lev Bwlgaria),
				'one' => q(lev Bwlgaria),
				'other' => q(lev Bwlgaria),
				'two' => q(lev Bwlgaria),
				'zero' => q(lev Bwlgaria),
			},
		},
		'BGO' => {
			symbol => 'BGO',
			display_name => {
				'currency' => q(Lev Bwlgaria \(1879–1952\)),
				'few' => q(Lev Bwlgaria \(1879–1952\)),
				'many' => q(Lev Bwlgaria \(1879–1952\)),
				'one' => q(Lev Bwlgaria \(1879–1952\)),
				'other' => q(Lev Bwlgaria \(1879–1952\)),
				'two' => q(Lev Bwlgaria \(1879–1952\)),
				'zero' => q(Lev Bwlgaria \(1879–1952\)),
			},
		},
		'BHD' => {
			symbol => 'BHD',
			display_name => {
				'currency' => q(Dinar Bahrain),
				'few' => q(dinar Bahrain),
				'many' => q(dinar Bahrain),
				'one' => q(dinar Bahrain),
				'other' => q(dinar Bahrain),
				'two' => q(dinar Bahrain),
				'zero' => q(dinar Bahrain),
			},
		},
		'BIF' => {
			symbol => 'BIF',
			display_name => {
				'currency' => q(Ffranc Burundi),
				'few' => q(ffranc Burundi),
				'many' => q(ffranc Burundi),
				'one' => q(ffranc Burundi),
				'other' => q(ffranc Burundi),
				'two' => q(ffranc Burundi),
				'zero' => q(ffranc Burundi),
			},
		},
		'BMD' => {
			symbol => 'BMD',
			display_name => {
				'currency' => q(Doler Bermuda),
				'few' => q(doler Bermuda),
				'many' => q(doler Bermuda),
				'one' => q(ddoler Bermuda),
				'other' => q(doler Bermuda),
				'two' => q(ddoler Bermuda),
				'zero' => q(doler Bermuda),
			},
		},
		'BND' => {
			symbol => 'BND',
			display_name => {
				'currency' => q(Doler Brunei),
				'few' => q(Doler Brunei),
				'many' => q(Doler Brunei),
				'one' => q(Doler Brunei),
				'other' => q(Doler Brunei),
				'two' => q(Doler Brunei),
				'zero' => q(Doler Brunei),
			},
		},
		'BOB' => {
			symbol => 'BOB',
			display_name => {
				'currency' => q(Boliviano Bolifia),
				'few' => q(boliviano Bolifia),
				'many' => q(boliviano Bolifia),
				'one' => q(boliviano Bolifia),
				'other' => q(boliviano Bolifia),
				'two' => q(boliviano Bolifia),
				'zero' => q(boliviano Bolifia),
			},
		},
		'BOL' => {
			symbol => 'BOL',
			display_name => {
				'currency' => q(Boliviano Bolifia \(1863–1963\)),
				'few' => q(boliviano Bolifia \(1863–1963\)),
				'many' => q(boliviano Bolifia \(1863–1963\)),
				'one' => q(boliviano Bolifia \(1863–1963\)),
				'other' => q(boliviano Bolifia \(1863–1963\)),
				'two' => q(boliviano Bolifia \(1863–1963\)),
				'zero' => q(boliviano Bolifia \(1863–1963\)),
			},
		},
		'BOP' => {
			symbol => 'BOP',
			display_name => {
				'currency' => q(Peso Bolifia),
				'few' => q(peso Bolifia),
				'many' => q(peso Bolifia),
				'one' => q(peso Bolifia),
				'other' => q(peso Bolifia),
				'two' => q(peso Bolifia),
				'zero' => q(peso Bolifia),
			},
		},
		'BOV' => {
			symbol => 'BOV',
			display_name => {
				'currency' => q(Mvdol Bolifia),
				'few' => q(mvdol Bolifia),
				'many' => q(mvdol Bolifia),
				'one' => q(mvdol Bolifia),
				'other' => q(mvdol Bolifia),
				'two' => q(mvdol Bolifia),
				'zero' => q(mvdol Bolifia),
			},
		},
		'BRB' => {
			symbol => 'BRB',
			display_name => {
				'currency' => q(Cruzeiro Newydd Brasil \(1967–1986\)),
				'few' => q(cruzeiro newydd Brasil \(1967–1986\)),
				'many' => q(cruzeiro newydd Brasil \(1967–1986\)),
				'one' => q(cruzeiro newydd Brasil \(1967–1986\)),
				'other' => q(cruzeiro newydd Brasil \(1967–1986\)),
				'two' => q(cruzeiro newydd Brasil \(1967–1986\)),
				'zero' => q(cruzeiro newydd Brasil \(1967–1986\)),
			},
		},
		'BRC' => {
			symbol => 'BRC',
			display_name => {
				'currency' => q(Cruzado Brasil \(1986–1989\)),
				'few' => q(cruzado Brasil \(1986–1989\)),
				'many' => q(cruzado Brasil \(1986–1989\)),
				'one' => q(cruzado Brasil \(1986–1989\)),
				'other' => q(cruzado Brasil \(1986–1989\)),
				'two' => q(cruzado Brasil \(1986–1989\)),
				'zero' => q(cruzado Brasil \(1986–1989\)),
			},
		},
		'BRE' => {
			symbol => 'BRE',
			display_name => {
				'currency' => q(Cruzeiro Brasil \(1990–1993\)),
				'few' => q(cruzeiro Brasil \(1990–1993\)),
				'many' => q(cruzeiro Brasil \(1990–1993\)),
				'one' => q(cruzeiro Brasil \(1990–1993\)),
				'other' => q(cruzeiro Brasil \(1990–1993\)),
				'two' => q(cruzeiro Brasil \(1990–1993\)),
				'zero' => q(cruzeiro Brasil \(1990–1993\)),
			},
		},
		'BRL' => {
			symbol => 'R$',
			display_name => {
				'currency' => q(Real Brasil),
				'few' => q(real Brasil),
				'many' => q(real Brasil),
				'one' => q(real Brasil),
				'other' => q(real Brasil),
				'two' => q(real Brasil),
				'zero' => q(real Brasil),
			},
		},
		'BRN' => {
			symbol => 'BRN',
			display_name => {
				'currency' => q(Cruzado Newydd Brasil \(1989–1990\)),
				'few' => q(cruzado newydd Brasil \(1989–1990\)),
				'many' => q(cruzado newydd Brasil \(1989–1990\)),
				'one' => q(cruzado newydd Brasil \(1989–1990\)),
				'other' => q(cruzado newydd Brasil \(1989–1990\)),
				'two' => q(cruzado newydd Brasil \(1989–1990\)),
				'zero' => q(cruzado newydd Brasil \(1989–1990\)),
			},
		},
		'BRR' => {
			symbol => 'BRR',
			display_name => {
				'currency' => q(Cruzeiro Brasil \(1993–1994\)),
				'few' => q(cruzeiro Brasil \(1993–1994\)),
				'many' => q(cruzeiro Brasil \(1993–1994\)),
				'one' => q(cruzeiro Brasil \(1993–1994\)),
				'other' => q(cruzeiro Brasil \(1993–1994\)),
				'two' => q(cruzeiro Brasil \(1993–1994\)),
				'zero' => q(cruzeiro Brasil \(1993–1994\)),
			},
		},
		'BRZ' => {
			symbol => 'BRZ',
			display_name => {
				'currency' => q(Cruzeiro Brasil \(1942–1967\)),
				'few' => q(cruzeiro Brasil \(1942–1967\)),
				'many' => q(cruzeiro Brasil \(1942–1967\)),
				'one' => q(cruzeiro Brasil \(1942–1967\)),
				'other' => q(cruzeiro Brasil \(1942–1967\)),
				'two' => q(cruzeiro Brasil \(1942–1967\)),
				'zero' => q(cruzeiro Brasil \(1942–1967\)),
			},
		},
		'BSD' => {
			symbol => 'BSD',
			display_name => {
				'currency' => q(Doler y Bahamas),
				'few' => q(doler y Bahamas),
				'many' => q(doler y Bahamas),
				'one' => q(doler y Bahamas),
				'other' => q(doler y Bahamas),
				'two' => q(doler y Bahamas),
				'zero' => q(doler y Bahamas),
			},
		},
		'BTN' => {
			symbol => 'BTN',
			display_name => {
				'currency' => q(Ngultrum Bhutan),
				'few' => q(Ngultrum Bhutan),
				'many' => q(Ngultrum Bhutan),
				'one' => q(Ngultrum Bhutan),
				'other' => q(Ngultrum Bhutan),
				'two' => q(Ngultrum Bhutan),
				'zero' => q(Ngultrum Bhutan),
			},
		},
		'BUK' => {
			symbol => 'BUK',
			display_name => {
				'currency' => q(Kyat Byrma),
				'few' => q(kyat Byrma),
				'many' => q(kyat Byrma),
				'one' => q(kyat Byrma),
				'other' => q(kyat Byrma),
				'two' => q(kyat Byrma),
				'zero' => q(kyat Byrma),
			},
		},
		'BWP' => {
			symbol => 'BWP',
			display_name => {
				'currency' => q(Pula Botswana),
				'few' => q(pula Botswana),
				'many' => q(pula Botswana),
				'one' => q(pula Botswana),
				'other' => q(pula Botswana),
				'two' => q(pula Botswana),
				'zero' => q(pula Botswana),
			},
		},
		'BYR' => {
			symbol => 'BYR',
			display_name => {
				'currency' => q(Rwbl Belarws),
				'few' => q(rwbl Belarws),
				'many' => q(rwbl Belarws),
				'one' => q(rwbl Belarws),
				'other' => q(rwbl Belarws),
				'two' => q(rwbl Belarws),
				'zero' => q(rwbl Belarws),
			},
		},
		'BZD' => {
			symbol => 'BZD',
			display_name => {
				'currency' => q(Doler Belize),
				'few' => q(doler Belize),
				'many' => q(doler Belize),
				'one' => q(ddoler Belize),
				'other' => q(doler Belize),
				'two' => q(ddoler Belize),
				'zero' => q(doler Belize),
			},
		},
		'CAD' => {
			symbol => 'CA$',
			display_name => {
				'currency' => q(Doler Canada),
				'few' => q(doler Canada),
				'many' => q(doler Canada),
				'one' => q(ddoler Canada),
				'other' => q(doler Canada),
				'two' => q(ddoler Canada),
				'zero' => q(doler Canada),
			},
		},
		'CDF' => {
			symbol => 'CDF',
			display_name => {
				'currency' => q(Ffranc Congo),
				'few' => q(ffranc Congo),
				'many' => q(ffranc Congo),
				'one' => q(ffranc Congo),
				'other' => q(ffranc Congo),
				'two' => q(ffranc Congo),
				'zero' => q(ffranc Congo),
			},
		},
		'CHE' => {
			symbol => 'CHE',
		},
		'CHF' => {
			symbol => 'CHF',
			display_name => {
				'currency' => q(Ffranc y Swistir),
				'few' => q(ffranc y Swistir),
				'many' => q(ffranc y Swistir),
				'one' => q(ffranc y Swistir),
				'other' => q(ffranc y Swistir),
				'two' => q(ffranc y Swistir),
				'zero' => q(ffranc y Swistir),
			},
		},
		'CHW' => {
			symbol => 'CHW',
		},
		'CLE' => {
			symbol => 'CLE',
			display_name => {
				'currency' => q(Escudo Chile),
				'few' => q(escudo Chile),
				'many' => q(escudo Chile),
				'one' => q(escudo Chile),
				'other' => q(escudo Chile),
				'two' => q(escudo Chile),
				'zero' => q(escudo Chile),
			},
		},
		'CLF' => {
			symbol => 'CLF',
			display_name => {
				'currency' => q(Uned Cyfrifo Chile \(UF\)),
				'few' => q(uned cyfrifo Chile \(UF\)),
				'many' => q(uned cyfrifo Chile \(UF\)),
				'one' => q(uned cyfrifo Chile \(UF\)),
				'other' => q(uned cyfrifo Chile \(UF\)),
				'two' => q(uned cyfrifo Chile \(UF\)),
				'zero' => q(uned cyfrifo Chile \(UF\)),
			},
		},
		'CLP' => {
			symbol => 'CLP',
			display_name => {
				'currency' => q(Peso Chile),
				'few' => q(peso Chile),
				'many' => q(peso Chile),
				'one' => q(peso Chile),
				'other' => q(peso Chile),
				'two' => q(peso Chile),
				'zero' => q(peso Chile),
			},
		},
		'CNX' => {
			display_name => {
				'currency' => q(Doler Banc Pobl Tsieina),
				'few' => q(doler Banc Pobl Tsieina),
				'many' => q(doler Banc Pobl Tsieina),
				'one' => q(ddoler Banc Pobl Tsieina),
				'other' => q(doler Banc Pobl Tsieina),
				'two' => q(ddoler Banc Pobl Tsieina),
				'zero' => q(doler Banc Pobl Tsieina),
			},
		},
		'CNY' => {
			symbol => 'CN¥',
			display_name => {
				'currency' => q(Yuan Tsieina),
				'few' => q(yuan Tsieina),
				'many' => q(yuan Tsieina),
				'one' => q(yuan Tsieina),
				'other' => q(yuan Tsieina),
				'two' => q(yuan Tsieina),
				'zero' => q(yuan Tsieina),
			},
		},
		'COP' => {
			symbol => 'COP',
			display_name => {
				'currency' => q(Peso Colombia),
				'few' => q(peso Colombia),
				'many' => q(peso Colombia),
				'one' => q(peso Colombia),
				'other' => q(peso Colombia),
				'two' => q(peso Colombia),
				'zero' => q(peso Colombia),
			},
		},
		'COU' => {
			symbol => 'COU',
		},
		'CRC' => {
			symbol => 'CRC',
			display_name => {
				'currency' => q(Colón Costa Rica),
				'few' => q(colón Costa Rica),
				'many' => q(colón Costa Rica),
				'one' => q(colón Costa Rica),
				'other' => q(colón Costa Rica),
				'two' => q(colón Costa Rica),
				'zero' => q(colón Costa Rica),
			},
		},
		'CSD' => {
			symbol => 'CSD',
		},
		'CUC' => {
			symbol => 'CUC',
			display_name => {
				'currency' => q(Peso Trosadwy Ciwba),
				'few' => q(peso trosadwy Ciwba),
				'many' => q(peso trosadwy Ciwba),
				'one' => q(peso trosadwy Ciwba),
				'other' => q(peso trosadwy Ciwba),
				'two' => q(peso trosadwy Ciwba),
				'zero' => q(peso trosadwy Ciwba),
			},
		},
		'CUP' => {
			symbol => 'CUP',
			display_name => {
				'currency' => q(Peso Ciwba),
				'few' => q(peso Ciwba),
				'many' => q(peso Ciwba),
				'one' => q(peso Ciwba),
				'other' => q(peso Ciwba),
				'two' => q(peso Ciwba),
				'zero' => q(peso Ciwba),
			},
		},
		'CVE' => {
			symbol => 'CVE',
			display_name => {
				'currency' => q(Esgwdo Cabo Verde),
				'few' => q(esgwdo Cabo Verde),
				'many' => q(esgwdo Cabo Verde),
				'one' => q(esgwdo Cabo Verde),
				'other' => q(esgwdo Cabo Verde),
				'two' => q(esgwdo Cabo Verde),
				'zero' => q(esgwdo Cabo Verde),
			},
		},
		'CYP' => {
			symbol => 'CYP',
			display_name => {
				'currency' => q(Punt Cyprus),
				'few' => q(punt Cyprus),
				'many' => q(punt Cyprus),
				'one' => q(bunt Cyprus),
				'other' => q(punt Cyprus),
				'two' => q(bunt Cyprus),
				'zero' => q(punt Cyprus),
			},
		},
		'CZK' => {
			symbol => 'CZK',
			display_name => {
				'currency' => q(Koruna Tsiec),
				'few' => q(koruna’r Weriniaeth Tsiec),
				'many' => q(koruna’r Weriniaeth Tsiec),
				'one' => q(koruna’r Weriniaeth Tsiec),
				'other' => q(koruna’r Weriniaeth Tsiec),
				'two' => q(koruna’r Weriniaeth Tsiec),
				'zero' => q(koruna’r Weriniaeth Tsiec),
			},
		},
		'DDM' => {
			symbol => 'DDM',
		},
		'DEM' => {
			symbol => 'DEM',
		},
		'DJF' => {
			symbol => 'DJF',
			display_name => {
				'currency' => q(Ffranc Djibouti),
				'few' => q(ffranc Djibouti),
				'many' => q(ffranc Djibouti),
				'one' => q(ffranc Djibouti),
				'other' => q(ffranc Djibouti),
				'two' => q(ffranc Djibouti),
				'zero' => q(ffranc Djibouti),
			},
		},
		'DKK' => {
			symbol => 'DKK',
			display_name => {
				'currency' => q(Krone Denmarc),
				'few' => q(krone Denmarc),
				'many' => q(krone Denmarc),
				'one' => q(krone Denmarc),
				'other' => q(krone Denmarc),
				'two' => q(krone Denmarc),
				'zero' => q(krone Denmarc),
			},
		},
		'DOP' => {
			symbol => 'DOP',
			display_name => {
				'currency' => q(Peso Gweriniaeth Dominica),
				'few' => q(peso Gweriniaeth Dominica),
				'many' => q(peso Gweriniaeth Dominica),
				'one' => q(peso Gweriniaeth Dominica),
				'other' => q(peso Gweriniaeth Dominica),
				'two' => q(peso Gweriniaeth Dominica),
				'zero' => q(peso Gweriniaeth Dominica),
			},
		},
		'DZD' => {
			symbol => 'DZD',
			display_name => {
				'currency' => q(Dinar Algeria),
				'few' => q(dinar Algeria),
				'many' => q(dinar Algeria),
				'one' => q(dinar Algeria),
				'other' => q(dinar Algeria),
				'two' => q(dinar Algeria),
				'zero' => q(dinar Algeria),
			},
		},
		'ECS' => {
			symbol => 'ECS',
			display_name => {
				'currency' => q(Sucre Ecuador),
				'few' => q(sucre Ecuador),
				'many' => q(sucre Ecuador),
				'one' => q(sucre Ecuador),
				'other' => q(sucre Ecuador),
				'two' => q(sucre Ecuador),
				'zero' => q(sucre Ecuador),
			},
		},
		'EGP' => {
			symbol => 'EGP',
			display_name => {
				'currency' => q(Punt Yr Aifft),
				'few' => q(punt yr Aifft),
				'many' => q(phunt yr Aifft),
				'one' => q(bunt yr Aifft),
				'other' => q(punt yr Aifft),
				'two' => q(bunt yr Aifft),
				'zero' => q(punt yr Aifft),
			},
		},
		'ERN' => {
			symbol => 'ERN',
			display_name => {
				'currency' => q(Nakfa Eritrea),
				'few' => q(nakfa Eritrea),
				'many' => q(nakfa Eritrea),
				'one' => q(nakfa Eritrea),
				'other' => q(nakfa Eritrea),
				'two' => q(nakfa Eritrea),
				'zero' => q(nakfa Eritrea),
			},
		},
		'ESP' => {
			symbol => 'ESP',
		},
		'ETB' => {
			symbol => 'ETB',
			display_name => {
				'currency' => q(Birr Ethiopia),
				'few' => q(birr Ethiopia),
				'many' => q(birr Ethiopia),
				'one' => q(birr Ethiopia),
				'other' => q(birr Ethiopia),
				'two' => q(birr Ethiopia),
				'zero' => q(birr Ethiopia),
			},
		},
		'EUR' => {
			symbol => '€',
			display_name => {
				'currency' => q(Ewro),
				'few' => q(Ewro),
				'many' => q(Ewro),
				'one' => q(Ewro),
				'other' => q(Ewro),
				'two' => q(Ewro),
				'zero' => q(Ewro),
			},
		},
		'FIM' => {
			symbol => 'FIM',
		},
		'FJD' => {
			symbol => 'FJD',
			display_name => {
				'currency' => q(Doler Ffiji),
				'few' => q(Doler Ffiji),
				'many' => q(Doler Ffiji),
				'one' => q(Doler Ffiji),
				'other' => q(Doler Ffiji),
				'two' => q(Doler Ffiji),
				'zero' => q(Doler Ffiji),
			},
		},
		'FKP' => {
			symbol => 'FKP',
			display_name => {
				'currency' => q(Punt Ynysoedd Falkland/Malvinas),
				'few' => q(punt Ynysoedd Falkland/Malvinas),
				'many' => q(phunt Ynysoedd Falkland/Malvinas),
				'one' => q(bunt Ynysoedd Falkland/Malvinas),
				'other' => q(punt Ynysoedd Falkland/Malvinas),
				'two' => q(bunt Ynysoedd Falkland/Malvinas),
				'zero' => q(punt Ynysoedd Falkland/Malvinas),
			},
		},
		'FRF' => {
			symbol => 'FRF',
		},
		'GBP' => {
			symbol => '£',
			display_name => {
				'currency' => q(Punt Prydain),
				'few' => q(punt Prydain),
				'many' => q(phunt Prydain),
				'one' => q(bunt Prydain),
				'other' => q(punt Prydain),
				'two' => q(bunt Prydain),
				'zero' => q(punt Prydain),
			},
		},
		'GEK' => {
			symbol => 'GEK',
			display_name => {
				'currency' => q(Kupon Larit Georgia),
				'few' => q(kupon larit Georgia),
				'many' => q(kupon larit Georgia),
				'one' => q(kupon larit Georgia),
				'other' => q(kupon larit Georgia),
				'two' => q(kupon larit Georgia),
				'zero' => q(kupon larit Georgia),
			},
		},
		'GEL' => {
			symbol => 'GEL',
			display_name => {
				'currency' => q(Lari Georgia),
				'few' => q(lari Georgia),
				'many' => q(lari Georgia),
				'one' => q(lari Georgia),
				'other' => q(lari Georgia),
				'two' => q(lari Georgia),
				'zero' => q(lari Georgia),
			},
		},
		'GHC' => {
			symbol => 'GHC',
			display_name => {
				'currency' => q(Cedi Ghana \(1979–2007\)),
				'few' => q(cedi Ghana \(1979–2007\)),
				'many' => q(cedi Ghana \(1979–2007\)),
				'one' => q(cedi Ghana \(1979–2007\)),
				'other' => q(cedi Ghana \(1979–2007\)),
				'two' => q(cedi Ghana \(1979–2007\)),
				'zero' => q(cedi Ghana \(1979–2007\)),
			},
		},
		'GHS' => {
			symbol => 'GHS',
			display_name => {
				'currency' => q(Cedi Ghana),
				'few' => q(cedi Ghana),
				'many' => q(cedi Ghana),
				'one' => q(cedi Ghana),
				'other' => q(cedi Ghana),
				'two' => q(cedi Ghana),
				'zero' => q(cedi Ghana),
			},
		},
		'GIP' => {
			symbol => 'GIP',
			display_name => {
				'currency' => q(Punt Gibraltar),
				'few' => q(punt Gibraltar),
				'many' => q(phunt Gibraltar),
				'one' => q(bunt Gibraltar),
				'other' => q(punt Gibraltar),
				'two' => q(bunt Gibraltar),
				'zero' => q(punt Gibraltar),
			},
		},
		'GMD' => {
			symbol => 'GMD',
			display_name => {
				'currency' => q(Dalasi Gambia),
				'few' => q(dalasi Gambia),
				'many' => q(dalasi Gambia),
				'one' => q(dalasi Gambia),
				'other' => q(dalasi Gambia),
				'two' => q(dalasi Gambia),
				'zero' => q(dalasi Gambia),
			},
		},
		'GNF' => {
			symbol => 'GNF',
			display_name => {
				'currency' => q(Ffranc Guinée),
				'few' => q(ffranc Guinée),
				'many' => q(ffranc Guinée),
				'one' => q(ffranc Guinée),
				'other' => q(ffranc Guinée),
				'two' => q(ffranc Guinée),
				'zero' => q(ffranc Guinée),
			},
		},
		'GNS' => {
			symbol => 'GNS',
			display_name => {
				'currency' => q(Syli Guinée),
				'few' => q(syli Guinée),
				'many' => q(syli Guinée),
				'one' => q(syli Guinée),
				'other' => q(syli Guinée),
				'two' => q(syli Guinée),
				'zero' => q(syli Guinée),
			},
		},
		'GQE' => {
			symbol => 'GQE',
			display_name => {
				'currency' => q(Ekwele Guinea Gyhydeddol),
				'few' => q(Ekwele Guinea Gyhydeddol),
				'many' => q(Ekwele Guinea Gyhydeddol),
				'one' => q(Ekwele Guinea Gyhydeddol),
				'other' => q(Ekwele Guinea Gyhydeddol),
				'two' => q(Ekwele Guinea Gyhydeddol),
				'zero' => q(Ekwele Guinea Gyhydeddol),
			},
		},
		'GRD' => {
			symbol => 'GRD',
		},
		'GTQ' => {
			symbol => 'GTQ',
			display_name => {
				'currency' => q(Quetzal Guatemala),
				'few' => q(quetzal Guatemala),
				'many' => q(quetzal Guatemala),
				'one' => q(quetzal Guatemala),
				'other' => q(quetzal Guatemala),
				'two' => q(quetzal Guatemala),
				'zero' => q(quetzal Guatemala),
			},
		},
		'GWE' => {
			symbol => 'GWE',
		},
		'GWP' => {
			symbol => 'GWP',
			display_name => {
				'currency' => q(Peso Guiné-Bissau),
				'few' => q(peso Guiné-Bissau),
				'many' => q(peso Guiné-Bissau),
				'one' => q(peso Guiné-Bissau),
				'other' => q(peso Guiné-Bissau),
				'two' => q(peso Guiné-Bissau),
				'zero' => q(peso Guiné-Bissau),
			},
		},
		'GYD' => {
			symbol => 'GYD',
			display_name => {
				'currency' => q(Doler Guyana),
				'few' => q(doler Guyana),
				'many' => q(doler Guyana),
				'one' => q(ddoler Guyana),
				'other' => q(doler Guyana),
				'two' => q(ddoler Guyana),
				'zero' => q(doler Guyana),
			},
		},
		'HKD' => {
			symbol => 'HK$',
			display_name => {
				'currency' => q(Doler Hong Kong),
				'few' => q(doler Hong Kong),
				'many' => q(doler Hong Kong),
				'one' => q(ddoler Hong Kong),
				'other' => q(doler Hong Kong),
				'two' => q(ddoler Hong Kong),
				'zero' => q(doler Hong Kong),
			},
		},
		'HNL' => {
			symbol => 'HNL',
			display_name => {
				'currency' => q(Lempira Honduras),
				'few' => q(lempira Honduras),
				'many' => q(lempira Honduras),
				'one' => q(lempira Honduras),
				'other' => q(lempira Honduras),
				'two' => q(lempira Honduras),
				'zero' => q(lempira Honduras),
			},
		},
		'HRD' => {
			symbol => 'HRD',
		},
		'HRK' => {
			symbol => 'HRK',
			display_name => {
				'currency' => q(Kuna Croatia),
				'few' => q(kuna Croatia),
				'many' => q(kuna Croatia),
				'one' => q(kuna Croatia),
				'other' => q(kuna Croatia),
				'two' => q(kuna Croatia),
				'zero' => q(kuna Croatia),
			},
		},
		'HTG' => {
			symbol => 'HTG',
			display_name => {
				'currency' => q(Gourde Haiti),
				'few' => q(gourde Haiti),
				'many' => q(gourde Haiti),
				'one' => q(gourde Haiti),
				'other' => q(gourde Haiti),
				'two' => q(gourde Haiti),
				'zero' => q(gourde Haiti),
			},
		},
		'HUF' => {
			symbol => 'HUF',
			display_name => {
				'currency' => q(Fforint Hwngari),
				'few' => q(fforint Hwngari),
				'many' => q(fforint Hwngari),
				'one' => q(fforint Hwngari),
				'other' => q(fforint Hwngari),
				'two' => q(fforint Hwngari),
				'zero' => q(fforint Hwngari),
			},
		},
		'IDR' => {
			symbol => 'IDR',
			display_name => {
				'currency' => q(Rupiah Indonesia),
				'few' => q(Rupiah Indonesia),
				'many' => q(Rupiah Indonesia),
				'one' => q(Rupiah Indonesia),
				'other' => q(Rupiah Indonesia),
				'two' => q(Rupiah Indonesia),
				'zero' => q(Rupiah Indonesia),
			},
		},
		'IEP' => {
			symbol => 'IEP',
			display_name => {
				'currency' => q(Punt Iwerddon),
				'few' => q(punt Iwerddon),
				'many' => q(phunt Iwerddon),
				'one' => q(bunt Iwerddon),
				'other' => q(punt Iwerddon),
				'two' => q(bunt Iwerddon),
				'zero' => q(punt Iwerddon),
			},
		},
		'ILP' => {
			symbol => 'ILP',
			display_name => {
				'currency' => q(Punt Israel),
				'few' => q(punt Israel),
				'many' => q(phunt Israel),
				'one' => q(bunt Israel),
				'other' => q(punt Israel),
				'two' => q(bunt Israel),
				'zero' => q(punt Israel),
			},
		},
		'ILR' => {
			display_name => {
				'currency' => q(Shegel Israel \(1980–1985\)),
				'few' => q(shegel Israel \(1980–1985\)),
				'many' => q(shegel Israel \(1980–1985\)),
				'one' => q(shegel Israel \(1980–1985\)),
				'other' => q(shegel Israel \(1980–1985\)),
				'two' => q(shegel Israel \(1980–1985\)),
				'zero' => q(shegel Israel \(1980–1985\)),
			},
		},
		'ILS' => {
			symbol => '₪',
			display_name => {
				'currency' => q(Shegel Newydd Israel),
				'few' => q(shegel newydd Israel),
				'many' => q(shegel newydd Israel),
				'one' => q(shegel newydd Israel),
				'other' => q(shegel newydd Israel),
				'two' => q(shegel newydd Israel),
				'zero' => q(shegel newydd Israel),
			},
		},
		'INR' => {
			symbol => '₹',
			display_name => {
				'currency' => q(Rwpî India),
				'few' => q(Rwpî India),
				'many' => q(Rwpî India),
				'one' => q(Rwpî India),
				'other' => q(Rwpî India),
				'two' => q(Rwpî India),
				'zero' => q(Rwpî India),
			},
		},
		'IQD' => {
			symbol => 'IQD',
			display_name => {
				'currency' => q(Dinar Irac),
				'few' => q(dinar Irac),
				'many' => q(dinar Irac),
				'one' => q(dinar Irac),
				'other' => q(dinar Irac),
				'two' => q(dinar Irac),
				'zero' => q(dinar Irac),
			},
		},
		'IRR' => {
			symbol => 'IRR',
			display_name => {
				'currency' => q(Rial Iran),
				'few' => q(Rial Iran),
				'many' => q(Rial Iran),
				'one' => q(Rial Iran),
				'other' => q(Rial Iran),
				'two' => q(Rial Iran),
				'zero' => q(Rial Iran),
			},
		},
		'ISK' => {
			symbol => 'ISK',
			display_name => {
				'currency' => q(Króna Gwlad yr Iâ),
				'few' => q(króna Gwlad yr Iâ),
				'many' => q(króna Gwlad yr Iâ),
				'one' => q(króna Gwlad yr Iâ),
				'other' => q(króna Gwlad yr Iâ),
				'two' => q(króna Gwlad yr Iâ),
				'zero' => q(króna Gwlad yr Iâ),
			},
		},
		'ITL' => {
			symbol => 'ITL',
		},
		'JMD' => {
			symbol => 'JMD',
			display_name => {
				'currency' => q(Doler Jamaica),
				'few' => q(doler Jamaica),
				'many' => q(doler Jamaica),
				'one' => q(ddoler Jamaica),
				'other' => q(doler Jamaica),
				'two' => q(ddoler Jamaica),
				'zero' => q(doler Jamaica),
			},
		},
		'JOD' => {
			symbol => 'JOD',
			display_name => {
				'currency' => q(Dinar Gwlad yr Iorddonen),
				'few' => q(dinar Gwlad yr Iorddonen),
				'many' => q(dinar Gwlad yr Iorddonen),
				'one' => q(dinar Gwlad yr Iorddonen),
				'other' => q(dinar Gwlad yr Iorddonen),
				'two' => q(dinar Gwlad yr Iorddonen),
				'zero' => q(dinar Gwlad yr Iorddonen),
			},
		},
		'JPY' => {
			symbol => 'JP¥',
			display_name => {
				'currency' => q(Yen Japan),
				'few' => q(yen Japan),
				'many' => q(yen Japan),
				'one' => q(yen Japan),
				'other' => q(yen Japan),
				'two' => q(yen Japan),
				'zero' => q(yen Japan),
			},
		},
		'KES' => {
			symbol => 'KES',
			display_name => {
				'currency' => q(Swllt Kenya),
				'few' => q(swllt Kenya),
				'many' => q(swllt Kenya),
				'one' => q(swllt Kenya),
				'other' => q(swllt Kenya),
				'two' => q(swllt Kenya),
				'zero' => q(swllt Kenya),
			},
		},
		'KGS' => {
			symbol => 'KGS',
			display_name => {
				'currency' => q(Som Kyrgyzstan),
				'few' => q(Som Kyrgyzstan),
				'many' => q(Som Kyrgyzstan),
				'one' => q(Som Kyrgyzstan),
				'other' => q(Som Kyrgyzstan),
				'two' => q(Som Kyrgyzstan),
				'zero' => q(Som Kyrgyzstan),
			},
		},
		'KHR' => {
			symbol => 'KHR',
			display_name => {
				'currency' => q(Riel Cambodia),
				'few' => q(Riel Cambodia),
				'many' => q(Riel Cambodia),
				'one' => q(Riel Cambodia),
				'other' => q(Riel Cambodia),
				'two' => q(Riel Cambodia),
				'zero' => q(Riel Cambodia),
			},
		},
		'KMF' => {
			symbol => 'KMF',
			display_name => {
				'currency' => q(Ffranc Comoros),
				'few' => q(ffranc Comoros),
				'many' => q(ffranc Comoros),
				'one' => q(ffranc Comoros),
				'other' => q(ffranc Comoros),
				'two' => q(ffranc Comoros),
				'zero' => q(ffranc Comoros),
			},
		},
		'KPW' => {
			symbol => 'KPW',
			display_name => {
				'currency' => q(Won Gogledd Corea),
				'few' => q(won Gogledd Corea),
				'many' => q(won Gogledd Corea),
				'one' => q(won Gogledd Corea),
				'other' => q(won Gogledd Corea),
				'two' => q(won Gogledd Corea),
				'zero' => q(won Gogledd Corea),
			},
		},
		'KRH' => {
			symbol => 'KRH',
			display_name => {
				'currency' => q(Hwan De Corea \(1953–1962\)),
				'few' => q(hwan De Corea \(1953–1962\)),
				'many' => q(hwan De Corea \(1953–1962\)),
				'one' => q(hwan De Corea \(1953–1962\)),
				'other' => q(hwan De Corea \(1953–1962\)),
				'two' => q(hwan De Corea \(1953–1962\)),
				'zero' => q(hwan De Corea \(1953–1962\)),
			},
		},
		'KRO' => {
			symbol => 'KRO',
			display_name => {
				'currency' => q(Won De Corea \(1945–1953\)),
				'few' => q(won De Corea \(1945–1953\)),
				'many' => q(won De Corea \(1945–1953\)),
				'one' => q(won De Corea \(1945–1953\)),
				'other' => q(won De Corea \(1945–1953\)),
				'two' => q(won De Corea \(1945–1953\)),
				'zero' => q(won De Corea \(1945–1953\)),
			},
		},
		'KRW' => {
			symbol => 'KRW',
			display_name => {
				'currency' => q(Won De Corea),
				'few' => q(won De Corea),
				'many' => q(won De Corea),
				'one' => q(won De Corea),
				'other' => q(won De Corea),
				'two' => q(won De Corea),
				'zero' => q(won De Corea),
			},
		},
		'KWD' => {
			symbol => 'KWD',
			display_name => {
				'currency' => q(Dinar Kuwait),
				'few' => q(dinar Kuwait),
				'many' => q(dinar Kuwait),
				'one' => q(dinar Kuwait),
				'other' => q(dinar Kuwait),
				'two' => q(dinar Kuwait),
				'zero' => q(dinar Kuwait),
			},
		},
		'KYD' => {
			symbol => 'KYD',
			display_name => {
				'currency' => q(Doler Ynysoedd Cayman),
				'few' => q(doler Ynysoedd Cayman),
				'many' => q(doler Ynysoedd Cayman),
				'one' => q(ddoler Ynysoedd Cayman),
				'other' => q(doler Ynysoedd Cayman),
				'two' => q(ddoler Ynysoedd Cayman),
				'zero' => q(doler Ynysoedd Cayman),
			},
		},
		'KZT' => {
			symbol => 'KZT',
			display_name => {
				'currency' => q(Tenge Kazakstan),
				'few' => q(Tenge Kazakstan),
				'many' => q(Tenge Kazakstan),
				'one' => q(Tenge Kazakstan),
				'other' => q(Tenge Kazakstan),
				'two' => q(Tenge Kazakstan),
				'zero' => q(Tenge Kazakstan),
			},
		},
		'LAK' => {
			symbol => 'LAK',
			display_name => {
				'currency' => q(Kip Laos),
				'few' => q(Kip Laos),
				'many' => q(Kip Laos),
				'one' => q(Kip Laos),
				'other' => q(Kip Laos),
				'two' => q(Kip Laos),
				'zero' => q(Kip Laos),
			},
		},
		'LBP' => {
			symbol => 'LBP',
			display_name => {
				'currency' => q(Punt Libanus),
				'few' => q(punt Libanus),
				'many' => q(phunt Libanus),
				'one' => q(bunt Libanus),
				'other' => q(punt Libanus),
				'two' => q(bunt Libanus),
				'zero' => q(punt Libanus),
			},
		},
		'LKR' => {
			symbol => 'LKR',
			display_name => {
				'currency' => q(Rwpî Sri Lanka),
				'few' => q(Rwpî Sri Lanka),
				'many' => q(Rwpî Sri Lanka),
				'one' => q(Rwpî Sri Lanka),
				'other' => q(Rwpî Sri Lanka),
				'two' => q(Rwpî Sri Lanka),
				'zero' => q(Rwpî Sri Lanka),
			},
		},
		'LRD' => {
			symbol => 'LRD',
			display_name => {
				'currency' => q(Doler Liberia),
				'few' => q(doler Liberia),
				'many' => q(doler Liberia),
				'one' => q(ddoler Liberia),
				'other' => q(doler Liberia),
				'two' => q(ddoler Liberia),
				'zero' => q(doler Liberia),
			},
		},
		'LSL' => {
			symbol => 'LSL',
			display_name => {
				'currency' => q(Loti Lesotho),
				'few' => q(loti Lesotho),
				'many' => q(loti Lesotho),
				'one' => q(loti Lesotho),
				'other' => q(loti Lesotho),
				'two' => q(loti Lesotho),
				'zero' => q(loti Lesotho),
			},
		},
		'LTL' => {
			symbol => 'LTL',
			display_name => {
				'currency' => q(Litas Lithwania),
				'few' => q(Litas Lithwania),
				'many' => q(Litas Lithwania),
				'one' => q(Litas Lithwania),
				'other' => q(Litas Lithwania),
				'two' => q(Litas Lithwania),
				'zero' => q(Litas Lithwania),
			},
		},
		'LTT' => {
			symbol => 'LTT',
			display_name => {
				'currency' => q(Talonas Lithwania),
				'few' => q(talonas Lithwania),
				'many' => q(talonas Lithwania),
				'one' => q(talonas Lithwania),
				'other' => q(talonas Lithwania),
				'two' => q(talonas Lithwania),
				'zero' => q(talonas Lithwania),
			},
		},
		'LUC' => {
			symbol => 'LUC',
		},
		'LUF' => {
			symbol => 'LUF',
		},
		'LUL' => {
			symbol => 'LUL',
		},
		'LVL' => {
			symbol => 'LVL',
			display_name => {
				'currency' => q(Lats Latfia),
				'few' => q(Lats Latfia),
				'many' => q(Lats Latfia),
				'one' => q(Lats Latfia),
				'other' => q(Lats Latfia),
				'two' => q(Lats Latfia),
				'zero' => q(Lats Latfia),
			},
		},
		'LVR' => {
			symbol => 'LVR',
		},
		'LYD' => {
			symbol => 'LYD',
			display_name => {
				'currency' => q(Dinar Libya),
				'few' => q(dinar Libya),
				'many' => q(dinar Libya),
				'one' => q(dinar Libya),
				'other' => q(dinar Libya),
				'two' => q(dinar Libya),
				'zero' => q(dinar Libya),
			},
		},
		'MAD' => {
			symbol => 'MAD',
			display_name => {
				'currency' => q(Dirham Moroco),
				'few' => q(dirham Moroco),
				'many' => q(dirham Moroco),
				'one' => q(dirham Moroco),
				'other' => q(dirham Moroco),
				'two' => q(dirham Moroco),
				'zero' => q(dirham Moroco),
			},
		},
		'MAF' => {
			symbol => 'MAF',
			display_name => {
				'currency' => q(Ffranc Moroco),
				'few' => q(ffranc Moroco),
				'many' => q(ffranc Moroco),
				'one' => q(ffranc Moroco),
				'other' => q(ffranc Moroco),
				'two' => q(ffranc Moroco),
				'zero' => q(ffranc Moroco),
			},
		},
		'MCF' => {
			symbol => 'MCF',
			display_name => {
				'currency' => q(Ffranc Monaco),
				'few' => q(ffranc Monaco),
				'many' => q(ffranc Monaco),
				'one' => q(ffranc Monaco),
				'other' => q(ffranc Monaco),
				'two' => q(ffranc Monaco),
				'zero' => q(ffranc Monaco),
			},
		},
		'MDL' => {
			symbol => 'MDL',
			display_name => {
				'currency' => q(Leu Moldofa),
				'few' => q(leu Moldofa),
				'many' => q(leu Moldofa),
				'one' => q(leu Moldofa),
				'other' => q(leu Moldofa),
				'two' => q(leu Moldofa),
				'zero' => q(leu Moldofa),
			},
		},
		'MGA' => {
			symbol => 'MGA',
			display_name => {
				'currency' => q(Ariary Madagascar),
				'few' => q(ariary Madagascar),
				'many' => q(ariary Madagascar),
				'one' => q(ariary Madagascar),
				'other' => q(ariary Madagascar),
				'two' => q(ariary Madagascar),
				'zero' => q(ariary Madagascar),
			},
		},
		'MGF' => {
			symbol => 'MGF',
			display_name => {
				'currency' => q(Ffranc Madagascar),
				'few' => q(ffranc Madagascar),
				'many' => q(ffranc Madagascar),
				'one' => q(ffranc Madagascar),
				'other' => q(ffranc Madagascar),
				'two' => q(ffranc Madagascar),
				'zero' => q(ffranc Madagascar),
			},
		},
		'MKD' => {
			symbol => 'MKD',
			display_name => {
				'currency' => q(Denar Macedonia),
				'few' => q(denar Macedonia),
				'many' => q(denar Macedonia),
				'one' => q(denar Macedonia),
				'other' => q(denar Macedonia),
				'two' => q(denar Macedonia),
				'zero' => q(denar Macedonia),
			},
		},
		'MKN' => {
			symbol => 'MKN',
		},
		'MLF' => {
			symbol => 'MLF',
			display_name => {
				'currency' => q(Ffranc Mali),
				'few' => q(ffranc Mali),
				'many' => q(ffranc Mali),
				'one' => q(ffranc Mali),
				'other' => q(ffranc Mali),
				'two' => q(ffranc Mali),
				'zero' => q(ffranc Mali),
			},
		},
		'MMK' => {
			symbol => 'MMK',
			display_name => {
				'currency' => q(Kyat Myanmar),
				'few' => q(Kyat Myanmar),
				'many' => q(Kyat Myanmar),
				'one' => q(Kyat Myanmar),
				'other' => q(Kyat Myanmar),
				'two' => q(Kyat Myanmar),
				'zero' => q(Kyat Myanmar),
			},
		},
		'MNT' => {
			symbol => 'MNT',
			display_name => {
				'currency' => q(Tugrik Mongolia),
				'few' => q(tugrik Mongolia),
				'many' => q(tugrik Mongolia),
				'one' => q(tugrik Mongolia),
				'other' => q(tugrik Mongolia),
				'two' => q(tugrik Mongolia),
				'zero' => q(tugrik Mongolia),
			},
		},
		'MOP' => {
			symbol => 'MOP',
			display_name => {
				'currency' => q(Pataca Macau),
				'few' => q(pataca Macau),
				'many' => q(pataca Macau),
				'one' => q(pataca Macau),
				'other' => q(pataca Macau),
				'two' => q(pataca Macau),
				'zero' => q(pataca Macau),
			},
		},
		'MRO' => {
			symbol => 'MRO',
			display_name => {
				'currency' => q(Ouguiya Mauritania),
				'few' => q(ouguiya Mauritania),
				'many' => q(ouguiya Mauritania),
				'one' => q(ouguiya Mauritania),
				'other' => q(ouguiya Mauritania),
				'two' => q(ouguiya Mauritania),
				'zero' => q(ouguiya Mauritania),
			},
		},
		'MTL' => {
			symbol => 'MTL',
		},
		'MTP' => {
			symbol => 'MTP',
		},
		'MUR' => {
			symbol => 'MUR',
			display_name => {
				'currency' => q(Rwpî Mauritius),
				'few' => q(rwpî Mauritius),
				'many' => q(rwpî Mauritius),
				'one' => q(rwpî Mauritius),
				'other' => q(rwpî Mauritius),
				'two' => q(rwpî Mauritius),
				'zero' => q(rwpî Mauritius),
			},
		},
		'MVP' => {
			display_name => {
				'currency' => q(Rwpî’r Maldives \(1947–1981\)),
				'few' => q(rwpî’r Maldives \(1947–1981\)),
				'many' => q(rwpî’r Maldives \(1947–1981\)),
				'one' => q(rwpî’r Maldives \(1947–1981\)),
				'other' => q(rwpî’r Maldives \(1947–1981\)),
				'two' => q(rwpî’r Maldives \(1947–1981\)),
				'zero' => q(rwpî’r Maldives \(1947–1981\)),
			},
		},
		'MVR' => {
			symbol => 'MVR',
			display_name => {
				'currency' => q(Rufiyaa’r Maldives),
				'few' => q(Rufiyaa’r Maldives),
				'many' => q(Rufiyaa’r Maldives),
				'one' => q(Rufiyaa’r Maldives),
				'other' => q(Rufiyaa’r Maldives),
				'two' => q(Rufiyaa’r Maldives),
				'zero' => q(Rufiyaa’r Maldives),
			},
		},
		'MWK' => {
			symbol => 'MWK',
			display_name => {
				'currency' => q(Kwacha Malawi),
				'few' => q(kwacha Malawi),
				'many' => q(kwacha Malawi),
				'one' => q(kwacha Malawi),
				'other' => q(kwacha Malawi),
				'two' => q(kwacha Malawi),
				'zero' => q(kwacha Malawi),
			},
		},
		'MXN' => {
			symbol => 'MX$',
			display_name => {
				'currency' => q(Peso Mecsico),
				'few' => q(peso Mecsico),
				'many' => q(peso Mecsico),
				'one' => q(peso Mecsico),
				'other' => q(peso Mecsico),
				'two' => q(peso Mecsico),
				'zero' => q(peso Mecsico),
			},
		},
		'MXP' => {
			symbol => 'MXP',
			display_name => {
				'currency' => q(Peso Arian México \(1861–1992\)),
				'few' => q(peso arian México \(1861–1992\)),
				'many' => q(peso arian México \(1861–1992\)),
				'one' => q(peso arian México \(1861–1992\)),
				'other' => q(peso arian México \(1861–1992\)),
				'two' => q(peso arian México \(1861–1992\)),
				'zero' => q(peso arian México \(1861–1992\)),
			},
		},
		'MXV' => {
			symbol => 'MXV',
			display_name => {
				'currency' => q(Uned Fuddsoddi México),
				'few' => q(uned fuddsoddi México),
				'many' => q(uned fuddsoddi México),
				'one' => q(uned fuddsoddi México),
				'other' => q(uned fuddsoddi México),
				'two' => q(uned fuddsoddi México),
				'zero' => q(uned fuddsoddi México),
			},
		},
		'MYR' => {
			symbol => 'MYR',
			display_name => {
				'currency' => q(Ringgit Malaysia),
				'few' => q(Ringgit Malaysia),
				'many' => q(Ringgit Malaysia),
				'one' => q(Ringgit Malaysia),
				'other' => q(Ringgit Malaysia),
				'two' => q(Ringgit Malaysia),
				'zero' => q(Ringgit Malaysia),
			},
		},
		'MZE' => {
			symbol => 'MZE',
			display_name => {
				'currency' => q(Escudo Mozambique),
				'few' => q(escudo Mozambique),
				'many' => q(escudo Mozambique),
				'one' => q(escudo Mozambique),
				'other' => q(escudo Mozambique),
				'two' => q(escudo Mozambique),
				'zero' => q(escudo Mozambique),
			},
		},
		'MZM' => {
			symbol => 'MZM',
			display_name => {
				'currency' => q(Metical Mozambique \(1980–2006\)),
				'few' => q(metical Mozambique \(1980–2006\)),
				'many' => q(metical Mozambique \(1980–2006\)),
				'one' => q(metical Mozambique \(1980–2006\)),
				'other' => q(metical Mozambique \(1980–2006\)),
				'two' => q(metical Mozambique \(1980–2006\)),
				'zero' => q(metical Mozambique \(1980–2006\)),
			},
		},
		'MZN' => {
			symbol => 'MZN',
			display_name => {
				'currency' => q(Metical Mozambique),
				'few' => q(metical Mozambique),
				'many' => q(metical Mozambique),
				'one' => q(metical Mozambique),
				'other' => q(metical Mozambique),
				'two' => q(metical Mozambique),
				'zero' => q(metical Mozambique),
			},
		},
		'NAD' => {
			symbol => 'NAD',
			display_name => {
				'currency' => q(Doler Namibia),
				'few' => q(doler Namibia),
				'many' => q(doler Namibia),
				'one' => q(ddoler Namibia),
				'other' => q(doler Namibia),
				'two' => q(ddoler Namibia),
				'zero' => q(doler Namibia),
			},
		},
		'NGN' => {
			symbol => 'NGN',
			display_name => {
				'currency' => q(Naira Nigeria),
				'few' => q(naira Nigeria),
				'many' => q(naira Nigeria),
				'one' => q(naira Nigeria),
				'other' => q(naira Nigeria),
				'two' => q(naira Nigeria),
				'zero' => q(naira Nigeria),
			},
		},
		'NIC' => {
			symbol => 'NIC',
			display_name => {
				'currency' => q(Córdoba Nicaragua \(1988–1991\)),
				'few' => q(córdoba Nicaragua \(1988–1991\)),
				'many' => q(córdoba Nicaragua \(1988–1991\)),
				'one' => q(córdoba Nicaragua \(1988–1991\)),
				'other' => q(córdoba Nicaragua \(1988–1991\)),
				'two' => q(córdoba Nicaragua \(1988–1991\)),
				'zero' => q(córdoba Nicaragua \(1988–1991\)),
			},
		},
		'NIO' => {
			symbol => 'NIO',
			display_name => {
				'currency' => q(Cordoba Nicaragwa),
				'few' => q(Cordoba Nicaragwa),
				'many' => q(Cordoba Nicaragwa),
				'one' => q(Cordoba Nicaragwa),
				'other' => q(Cordoba Nicaragwa),
				'two' => q(Cordoba Nicaragwa),
				'zero' => q(Cordoba Nicaragwa),
			},
		},
		'NLG' => {
			symbol => 'NLG',
			display_name => {
				'currency' => q(Guilder yr Iseldiroedd),
				'few' => q(guilder yr Iseldiroedd),
				'many' => q(guilder yr Iseldiroedd),
				'one' => q(guilder yr Iseldiroedd),
				'other' => q(guilder yr Iseldiroedd),
				'two' => q(guilder yr Iseldiroedd),
				'zero' => q(guilder yr Iseldiroedd),
			},
		},
		'NOK' => {
			symbol => 'NOK',
			display_name => {
				'currency' => q(Krone Norwy),
				'few' => q(krone Norwy),
				'many' => q(krone Norwy),
				'one' => q(krone Norwy),
				'other' => q(krone Norwy),
				'two' => q(krone Norwy),
				'zero' => q(krone Norwy),
			},
		},
		'NPR' => {
			symbol => 'NPR',
			display_name => {
				'currency' => q(Rwpî Nepal),
				'few' => q(Rwpî Nepal),
				'many' => q(Rwpî Nepal),
				'one' => q(Rwpî Nepal),
				'other' => q(Rwpî Nepal),
				'two' => q(Rwpî Nepal),
				'zero' => q(Rwpî Nepal),
			},
		},
		'NZD' => {
			symbol => 'NZ$',
			display_name => {
				'currency' => q(Doler Seland Newydd),
				'few' => q(Doler Seland Newydd),
				'many' => q(Doler Seland Newydd),
				'one' => q(Doler Seland Newydd),
				'other' => q(Doler Seland Newydd),
				'two' => q(Doler Seland Newydd),
				'zero' => q(Doler Seland Newydd),
			},
		},
		'OMR' => {
			symbol => 'OMR',
			display_name => {
				'currency' => q(Rial Oman),
				'few' => q(rial Oman),
				'many' => q(rial Oman),
				'one' => q(rial Oman),
				'other' => q(rial Oman),
				'two' => q(rial Oman),
				'zero' => q(rial Oman),
			},
		},
		'PAB' => {
			symbol => 'PAB',
			display_name => {
				'currency' => q(Balboa Panama),
				'few' => q(balboa Panama),
				'many' => q(balboa Panama),
				'one' => q(balboa Panama),
				'other' => q(balboa Panama),
				'two' => q(balboa Panama),
				'zero' => q(balboa Panama),
			},
		},
		'PEI' => {
			symbol => 'PEI',
			display_name => {
				'currency' => q(Inti Periw),
				'few' => q(inti Periw),
				'many' => q(inti Periw),
				'one' => q(inti Periw),
				'other' => q(inti Periw),
				'two' => q(inti Periw),
				'zero' => q(inti Periw),
			},
		},
		'PEN' => {
			symbol => 'PEN',
			display_name => {
				'currency' => q(Nuevo Sol Periw),
				'few' => q(nuevo sol Periw),
				'many' => q(nuevo sol Periw),
				'one' => q(nuevo sol Periw),
				'other' => q(nuevo sol Periw),
				'two' => q(nuevo sol Periw),
				'zero' => q(nuevo sol Periw),
			},
		},
		'PES' => {
			symbol => 'PES',
			display_name => {
				'currency' => q(Sol Periw \(1863–1965\)),
				'few' => q(sol Periw \(1863–1965\)),
				'many' => q(sol Periw \(1863–1965\)),
				'one' => q(sol Periw \(1863–1965\)),
				'other' => q(sol Periw \(1863–1965\)),
				'two' => q(sol Periw \(1863–1965\)),
				'zero' => q(sol Periw \(1863–1965\)),
			},
		},
		'PGK' => {
			symbol => 'PGK',
			display_name => {
				'currency' => q(Kina Papua Guinea Newydd),
				'few' => q(Kina Papua Guinea Newydd),
				'many' => q(Kina Papua Guinea Newydd),
				'one' => q(Kina Papua Guinea Newydd),
				'other' => q(Kina Papua Guinea Newydd),
				'two' => q(Kina Papua Guinea Newydd),
				'zero' => q(Kina Papua Guinea Newydd),
			},
		},
		'PHP' => {
			symbol => 'PHP',
			display_name => {
				'currency' => q(Peso’r Philipinau),
				'few' => q(Peso Pilipinas),
				'many' => q(Peso Pilipinas),
				'one' => q(Peso Pilipinas),
				'other' => q(Peso Pilipinas),
				'two' => q(Peso Pilipinas),
				'zero' => q(Peso Pilipinas),
			},
		},
		'PKR' => {
			symbol => 'PKR',
			display_name => {
				'currency' => q(Rwpî Pacistan),
				'few' => q(Rwpî Pacistan),
				'many' => q(Rwpî Pacistan),
				'one' => q(Rwpî Pacistan),
				'other' => q(Rwpî Pacistan),
				'two' => q(Rwpî Pacistan),
				'zero' => q(Rwpî Pacistan),
			},
		},
		'PLN' => {
			symbol => 'PLN',
			display_name => {
				'currency' => q(Zloty Gwlad Pwyl),
				'few' => q(zloty Gwlad Pwyl),
				'many' => q(zloty Gwlad Pwyl),
				'one' => q(zloty Gwlad Pwyl),
				'other' => q(zloty Gwlad Pwyl),
				'two' => q(zloty Gwlad Pwyl),
				'zero' => q(zloty Gwlad Pwyl),
			},
		},
		'PTE' => {
			symbol => 'PTE',
		},
		'PYG' => {
			symbol => 'PYG',
			display_name => {
				'currency' => q(Guarani Paraguay),
				'few' => q(guarani Paraguay),
				'many' => q(guarani Paraguay),
				'one' => q(guarani Paraguay),
				'other' => q(guarani Paraguay),
				'two' => q(guarani Paraguay),
				'zero' => q(guarani Paraguay),
			},
		},
		'QAR' => {
			symbol => 'QAR',
			display_name => {
				'currency' => q(Rial Qatar),
				'few' => q(rial Qatar),
				'many' => q(rial Qatar),
				'one' => q(rial Qatar),
				'other' => q(rial Qatar),
				'two' => q(rial Qatar),
				'zero' => q(rial Qatar),
			},
		},
		'RHD' => {
			symbol => 'RHD',
			display_name => {
				'currency' => q(Doler Rhodesia),
				'few' => q(doler Rhodesia),
				'many' => q(doler Rhodesia),
				'one' => q(ddoler Rhodesia),
				'other' => q(doler Rhodesia),
				'two' => q(ddoler Rhodesia),
				'zero' => q(doler Rhodesia),
			},
		},
		'RON' => {
			symbol => 'RON',
			display_name => {
				'currency' => q(Leu Rwmania),
				'few' => q(leu Rwmania),
				'many' => q(leu Rwmania),
				'one' => q(leu Rwmania),
				'other' => q(leu Rwmania),
				'two' => q(leu Rwmania),
				'zero' => q(leu Rwmania),
			},
		},
		'RSD' => {
			symbol => 'RSD',
			display_name => {
				'currency' => q(Dinar Serbia),
				'few' => q(dinar Serbia),
				'many' => q(dinar Serbia),
				'one' => q(dinar Serbia),
				'other' => q(dinar Serbia),
				'two' => q(dinar Serbia),
				'zero' => q(dinar Serbia),
			},
		},
		'RUB' => {
			symbol => 'RUB',
			display_name => {
				'currency' => q(Rwbl Rwsia),
				'few' => q(rwbl Rwsia),
				'many' => q(rwbl Rwsia),
				'one' => q(rwbl Rwsia),
				'other' => q(rwbl Rwsia),
				'two' => q(rwbl Rwsia),
				'zero' => q(rwbl Rwsia),
			},
		},
		'RWF' => {
			symbol => 'RWF',
			display_name => {
				'currency' => q(Ffranc Rwanda),
				'few' => q(ffranc Rwanda),
				'many' => q(ffranc Rwanda),
				'one' => q(ffranc Rwanda),
				'other' => q(ffranc Rwanda),
				'two' => q(ffranc Rwanda),
				'zero' => q(ffranc Rwanda),
			},
		},
		'SAR' => {
			symbol => 'SAR',
			display_name => {
				'currency' => q(Riyal Saudi Arabia),
				'few' => q(riyal Saudi Arabia),
				'many' => q(riyal Saudi Arabia),
				'one' => q(Riyal Saudi Arabia),
				'other' => q(riyal Saudi Arabia),
				'two' => q(riyal Saudi Arabia),
				'zero' => q(riyal Saudi Arabia),
			},
		},
		'SBD' => {
			symbol => 'SBD',
			display_name => {
				'currency' => q(Doler Ynysoedd Solomon),
				'few' => q(Doler Ynysoedd Solomon),
				'many' => q(Doler Ynysoedd Solomon),
				'one' => q(Doler Ynysoedd Solomon),
				'other' => q(Doler Ynysoedd Solomon),
				'two' => q(Doler Ynysoedd Solomon),
				'zero' => q(Doler Ynysoedd Solomon),
			},
		},
		'SCR' => {
			symbol => 'SCR',
			display_name => {
				'currency' => q(Rwpî Seychelles),
				'few' => q(rwpî Seychelles),
				'many' => q(rwpî Seychelles),
				'one' => q(rwpî Seychelles),
				'other' => q(rwpî Seychelles),
				'two' => q(rwpî Seychelles),
				'zero' => q(rwpî Seychelles),
			},
		},
		'SDD' => {
			symbol => 'SDD',
			display_name => {
				'currency' => q(Dinar Sudan \(1992–2007\)),
				'few' => q(dinar Sudan \(1992–2007\)),
				'many' => q(dinar Sudan \(1992–2007\)),
				'one' => q(dinar Sudan \(1992–2007\)),
				'other' => q(dinar Sudan \(1992–2007\)),
				'two' => q(dinar Sudan \(1992–2007\)),
				'zero' => q(dinar Sudan \(1992–2007\)),
			},
		},
		'SDG' => {
			symbol => 'SDG',
			display_name => {
				'currency' => q(Punt Sudan),
				'few' => q(punt Sudan),
				'many' => q(phunt Sudan),
				'one' => q(bunt Sudan),
				'other' => q(punt Sudan),
				'two' => q(bunt Sudan),
				'zero' => q(punt Sudan),
			},
		},
		'SDP' => {
			symbol => 'SDP',
			display_name => {
				'currency' => q(Punt Sudan \(1957–1998\)),
				'few' => q(punt Sudan \(1957–1998\)),
				'many' => q(phunt Sudan \(1957–1998\)),
				'one' => q(bunt Sudan \(1957–1998\)),
				'other' => q(punt Sudan \(1957–1998\)),
				'two' => q(bunt Sudan \(1957–1998\)),
				'zero' => q(punt Sudan \(1957–1998\)),
			},
		},
		'SEK' => {
			symbol => 'SEK',
			display_name => {
				'currency' => q(Krona Sweden),
				'few' => q(krona Sweden),
				'many' => q(krona Sweden),
				'one' => q(krona Sweden),
				'other' => q(krona Sweden),
				'two' => q(krona Sweden),
				'zero' => q(krona Sweden),
			},
		},
		'SGD' => {
			symbol => 'SGD',
			display_name => {
				'currency' => q(Doler Singapore),
				'few' => q(Doler Singapore),
				'many' => q(Doler Singapore),
				'one' => q(Doler Singapore),
				'other' => q(Doler Singapore),
				'two' => q(Doler Singapore),
				'zero' => q(Doler Singapore),
			},
		},
		'SHP' => {
			symbol => 'SHP',
			display_name => {
				'currency' => q(Punt Saint Helena),
				'few' => q(punt St. Helena),
				'many' => q(phunt St. Helena),
				'one' => q(bunt St. Helena),
				'other' => q(punt St. Helena),
				'two' => q(bunt St. Helena),
				'zero' => q(punt St. Helena),
			},
		},
		'SIT' => {
			symbol => 'SIT',
		},
		'SLL' => {
			symbol => 'SLL',
			display_name => {
				'currency' => q(Leone Sierra Leone),
				'few' => q(leone Sierra Leone),
				'many' => q(leone Sierra Leone),
				'one' => q(leone Sierra Leone),
				'other' => q(leone Sierra Leone),
				'two' => q(leone Sierra Leone),
				'zero' => q(leone Sierra Leone),
			},
		},
		'SOS' => {
			symbol => 'SOS',
			display_name => {
				'currency' => q(Swllt Somalia),
				'few' => q(swllt Somalia),
				'many' => q(swllt Somalia),
				'one' => q(swllt Somalia),
				'other' => q(swllt Somalia),
				'two' => q(swllt Somalia),
				'zero' => q(swllt Somalia),
			},
		},
		'SRD' => {
			symbol => 'SRD',
			display_name => {
				'currency' => q(Doler Surinam),
				'few' => q(doler Surinam),
				'many' => q(doler Surinam),
				'one' => q(ddoler Surinam),
				'other' => q(doler Surinam),
				'two' => q(ddoler Surinam),
				'zero' => q(doler Surinam),
			},
		},
		'SRG' => {
			symbol => 'SRG',
			display_name => {
				'currency' => q(Guilder Surinam),
				'few' => q(guilder Surinam),
				'many' => q(guilder Surinam),
				'one' => q(guilder Surinam),
				'other' => q(guilder Surinam),
				'two' => q(guilder Surinam),
				'zero' => q(guilder Surinam),
			},
		},
		'SSP' => {
			symbol => 'SSP',
			display_name => {
				'currency' => q(Punt De Sudan),
				'few' => q(punt De Sudan),
				'many' => q(phunt De Sudan),
				'one' => q(bunt De Sudan),
				'other' => q(punt De Sudan),
				'two' => q(bunt De Sudan),
				'zero' => q(punt De Sudan),
			},
		},
		'STD' => {
			symbol => 'STD',
			display_name => {
				'currency' => q(Dobra São Tomé a Príncipe),
				'few' => q(Dobra São Tomé a Príncipe),
				'many' => q(Dobra São Tomé a Príncipe),
				'one' => q(Dobra São Tomé a Príncipe),
				'other' => q(Dobra São Tomé a Príncipe),
				'two' => q(Dobra São Tomé a Príncipe),
				'zero' => q(Dobra São Tomé a Príncipe),
			},
		},
		'SVC' => {
			symbol => 'SVC',
			display_name => {
				'currency' => q(Colón El Salvador),
				'few' => q(colón El Salvador),
				'many' => q(colón El Salvador),
				'one' => q(colón El Salvador),
				'other' => q(colón El Salvador),
				'two' => q(colón El Salvador),
				'zero' => q(colón El Salvador),
			},
		},
		'SYP' => {
			symbol => 'SYP',
			display_name => {
				'currency' => q(Punt Syria),
				'few' => q(Punt Syria),
				'many' => q(Punt Syria),
				'one' => q(Punt Syria),
				'other' => q(Punt Syria),
				'two' => q(Punt Syria),
				'zero' => q(Punt Syria),
			},
		},
		'SZL' => {
			symbol => 'SZL',
			display_name => {
				'currency' => q(Lilangeni Gwlad Swazi),
				'few' => q(lilangeni Gwlad Swazi),
				'many' => q(lilangeni Gwlad Swazi),
				'one' => q(lilangeni Gwlad Swazi),
				'other' => q(lilangeni Gwlad Swazi),
				'two' => q(lilangeni Gwlad Swazi),
				'zero' => q(lilangeni Gwlad Swazi),
			},
		},
		'THB' => {
			symbol => '฿',
			display_name => {
				'currency' => q(Baht Gwlad Thai),
				'few' => q(Baht Gwlad Thai),
				'many' => q(Baht Gwlad Thai),
				'one' => q(Baht Gwlad Thai),
				'other' => q(Baht Gwlad Thai),
				'two' => q(Baht Gwlad Thai),
				'zero' => q(Baht Gwlad Thai),
			},
		},
		'TJR' => {
			symbol => 'TJR',
			display_name => {
				'currency' => q(Rwbl Tajikistan),
				'few' => q(rwbl Tajikistan),
				'many' => q(rwbl Tajikistan),
				'one' => q(rwbl Tajikistan),
				'other' => q(rwbl Tajikistan),
				'two' => q(rwbl Tajikistan),
				'zero' => q(rwbl Tajikistan),
			},
		},
		'TJS' => {
			symbol => 'TJS',
			display_name => {
				'currency' => q(Somoni Tajikistan),
				'few' => q(Somoni Tajikistan),
				'many' => q(Somoni Tajikistan),
				'one' => q(Somoni Tajikistan),
				'other' => q(Somoni Tajikistan),
				'two' => q(Somoni Tajikistan),
				'zero' => q(Somoni Tajikistan),
			},
		},
		'TMM' => {
			symbol => 'TMM',
			display_name => {
				'currency' => q(Manat Turkmenistan \(1993–2009\)),
				'few' => q(manat Turkmenistan \(1993–2009\)),
				'many' => q(manat Turkmenistan \(1993–2009\)),
				'one' => q(manat Turkmenistan \(1993–2009\)),
				'other' => q(manat Turkmenistan \(1993–2009\)),
				'two' => q(manat Turkmenistan \(1993–2009\)),
				'zero' => q(manat Turkmenistan \(1993–2009\)),
			},
		},
		'TMT' => {
			symbol => 'TMT',
			display_name => {
				'currency' => q(Manat Turkmenistan),
				'few' => q(Manat Turkmenistan),
				'many' => q(Manat Turkmenistan),
				'one' => q(Manat Turkmenistan),
				'other' => q(Manat Turkmenistan),
				'two' => q(Manat Turkmenistan),
				'zero' => q(Manat Turkmenistan),
			},
		},
		'TND' => {
			symbol => 'TND',
			display_name => {
				'currency' => q(Dinar Tunisia),
				'few' => q(dinar Tunisia),
				'many' => q(dinar Tunisia),
				'one' => q(dinar Tunisia),
				'other' => q(dinar Tunisia),
				'two' => q(dinar Tunisia),
				'zero' => q(dinar Tunisia),
			},
		},
		'TOP' => {
			symbol => 'TOP',
			display_name => {
				'currency' => q(Paʻanga Tonga),
				'few' => q(Paʻanga Tonga),
				'many' => q(Paʻanga Tonga),
				'one' => q(Paʻanga Tonga),
				'other' => q(Paʻanga Tonga),
				'two' => q(Paʻanga Tonga),
				'zero' => q(Paʻanga Tonga),
			},
		},
		'TPE' => {
			symbol => 'TPE',
			display_name => {
				'currency' => q(Escudo Timor),
				'few' => q(escudo Timor),
				'many' => q(escudo Timor),
				'one' => q(escudo Timor),
				'other' => q(escudo Timor),
				'two' => q(escudo Timor),
				'zero' => q(escudo Timor),
			},
		},
		'TRL' => {
			symbol => 'TRL',
			display_name => {
				'currency' => q(Lira Twrci \(1922–2005\)),
				'few' => q(lira Twrci \(1922–2005\)),
				'many' => q(lira Twrci \(1922–2005\)),
				'one' => q(lira Twrci \(1922–2005\)),
				'other' => q(lira Twrci \(1922–2005\)),
				'two' => q(lira Twrci \(1922–2005\)),
				'zero' => q(lira Twrci \(1922–2005\)),
			},
		},
		'TRY' => {
			symbol => 'TRY',
			display_name => {
				'currency' => q(Lira Twrci),
				'few' => q(Lira Twrci),
				'many' => q(Lira Twrci),
				'one' => q(Lira Twrci),
				'other' => q(Lira Twrci),
				'two' => q(Lira Twrci),
				'zero' => q(Lira Twrci),
			},
		},
		'TTD' => {
			symbol => 'TTD',
			display_name => {
				'currency' => q(Doler Trinidad a Tobago),
				'few' => q(doler Trinidad a Tobago),
				'many' => q(doler Trinidad a Tobago),
				'one' => q(ddoler Trinidad a Tobago),
				'other' => q(doler Trinidad a Tobago),
				'two' => q(ddoler Trinidad a Tobago),
				'zero' => q(doler Trinidad a Tobago),
			},
		},
		'TWD' => {
			symbol => 'NT$',
			display_name => {
				'currency' => q(Doler Newydd Taiwan),
				'few' => q(doler newydd Taiwan),
				'many' => q(doler newydd Taiwan),
				'one' => q(ddoler newydd Taiwan),
				'other' => q(doler newydd Taiwan),
				'two' => q(ddoler newydd Taiwan),
				'zero' => q(doler newydd Taiwan),
			},
		},
		'TZS' => {
			symbol => 'TZS',
			display_name => {
				'currency' => q(Swllt Tanzania),
				'few' => q(swllt Tanzania),
				'many' => q(swllt Tanzania),
				'one' => q(swllt Tanzania),
				'other' => q(swllt Tanzania),
				'two' => q(swllt Tanzania),
				'zero' => q(swllt Tanzania),
			},
		},
		'UAH' => {
			symbol => 'UAH',
			display_name => {
				'currency' => q(Hryvnia Wcráin),
				'few' => q(hryvnia Wcráin),
				'many' => q(hryvnia Wcráin),
				'one' => q(hryvnia Wcráin),
				'other' => q(hryvnia Wcráin),
				'two' => q(hryvnia Wcráin),
				'zero' => q(hryvnia Wcráin),
			},
		},
		'UGS' => {
			symbol => 'UGS',
			display_name => {
				'currency' => q(Swllt Uganda \(1966–1987\)),
				'few' => q(swllt Uganda \(1966–1987\)),
				'many' => q(swllt Uganda \(1966–1987\)),
				'one' => q(swllt Uganda \(1966–1987\)),
				'other' => q(swllt Uganda \(1966–1987\)),
				'two' => q(swllt Uganda \(1966–1987\)),
				'zero' => q(swllt Uganda \(1966–1987\)),
			},
		},
		'UGX' => {
			symbol => 'UGX',
			display_name => {
				'currency' => q(Swllt Uganda),
				'few' => q(swllt Uganda),
				'many' => q(swllt Uganda),
				'one' => q(swllt Uganda),
				'other' => q(swllt Uganda),
				'two' => q(swllt Uganda),
				'zero' => q(swllt Uganda),
			},
		},
		'USD' => {
			symbol => 'US$',
			display_name => {
				'currency' => q(Doler UDA),
				'few' => q(doler UDA),
				'many' => q(doler UDA),
				'one' => q(ddoler UDA),
				'other' => q(doler UDA),
				'two' => q(ddoler UDA),
				'zero' => q(doler UDA),
			},
		},
		'USN' => {
			symbol => 'USN',
			display_name => {
				'currency' => q(Doler UDA \(y diwrnod nesaf\)),
				'few' => q(doler UDA \(y diwrnod nesaf\)),
				'many' => q(doler UDA \(y diwrnod nesaf\)),
				'one' => q(doler UDA \(y diwrnod nesaf\)),
				'other' => q(doler UDA \(y diwrnod nesaf\)),
				'two' => q(doler UDA \(y diwrnod nesaf\)),
				'zero' => q(doler UDA \(y diwrnod nesaf\)),
			},
		},
		'USS' => {
			symbol => 'USS',
			display_name => {
				'currency' => q(Doler UDA \(yr un diwrnod\)),
				'few' => q(doler UDA \(yr un diwrnod\)),
				'many' => q(doler UDA \(yr un diwrnod\)),
				'one' => q(doler UDA \(yr un diwrnod\)),
				'other' => q(doler UDA \(yr un diwrnod\)),
				'two' => q(doler UDA \(yr un diwrnod\)),
				'zero' => q(doler UDA \(yr un diwrnod\)),
			},
		},
		'UYI' => {
			symbol => 'UYI',
		},
		'UYP' => {
			symbol => 'UYP',
			display_name => {
				'currency' => q(Peso Uruguay \(1975–1993\)),
				'few' => q(peso Uruguay \(1975–1993\)),
				'many' => q(peso Uruguay \(1975–1993\)),
				'one' => q(peso Uruguay \(1975–1993\)),
				'other' => q(peso Uruguay \(1975–1993\)),
				'two' => q(peso Uruguay \(1975–1993\)),
				'zero' => q(peso Uruguay \(1975–1993\)),
			},
		},
		'UYU' => {
			symbol => 'UYU',
			display_name => {
				'currency' => q(Peso Uruguay),
				'few' => q(peso Uruguay),
				'many' => q(peso Uruguay),
				'one' => q(peso Uruguay),
				'other' => q(peso Uruguay),
				'two' => q(peso Uruguay),
				'zero' => q(peso Uruguay),
			},
		},
		'UZS' => {
			symbol => 'UZS',
			display_name => {
				'currency' => q(Som Uzbekistan),
				'few' => q(Som Uzbekistan),
				'many' => q(Som Uzbekistan),
				'one' => q(Som Uzbekistan),
				'other' => q(Som Uzbekistan),
				'two' => q(Som Uzbekistan),
				'zero' => q(Som Uzbekistan),
			},
		},
		'VEB' => {
			symbol => 'VEB',
			display_name => {
				'currency' => q(Bolívar Venezuela \(1871–2008\)),
				'few' => q(bolívar Venezuela \(1871–2008\)),
				'many' => q(bolívar Venezuela \(1871–2008\)),
				'one' => q(bolívar Venezuela \(1871–2008\)),
				'other' => q(bolívar Venezuela \(1871–2008\)),
				'two' => q(bolívar Venezuela \(1871–2008\)),
				'zero' => q(bolívar Venezuela \(1871–2008\)),
			},
		},
		'VEF' => {
			symbol => 'VEF',
			display_name => {
				'currency' => q(Bolívar Venezuela),
				'few' => q(Bolívar Venezuela),
				'many' => q(bolivar Venezuela),
				'one' => q(Bolívar Venezuela),
				'other' => q(bolivar Venezuela),
				'two' => q(Bolívar Venezuela),
				'zero' => q(Bolívar Venezuela),
			},
		},
		'VND' => {
			symbol => '₫',
			display_name => {
				'currency' => q(Dong Fietnam),
				'few' => q(Dong Fietnam),
				'many' => q(Dong Fietnam),
				'one' => q(Dong Fietnam),
				'other' => q(Dong Fietnam),
				'two' => q(Dong Fietnam),
				'zero' => q(Dong Fietnam),
			},
		},
		'VNN' => {
			symbol => 'VNN',
			display_name => {
				'currency' => q(Dong Fietnam \(1978–1985\)),
				'few' => q(dong Fietnam \(1978–1985\)),
				'many' => q(dong Fietnam \(1978–1985\)),
				'one' => q(dong Fietnam \(1978–1985\)),
				'other' => q(dong Fietnam \(1978–1985\)),
				'two' => q(dong Fietnam \(1978–1985\)),
				'zero' => q(dong Fietnam \(1978–1985\)),
			},
		},
		'VUV' => {
			symbol => 'VUV',
			display_name => {
				'currency' => q(Vatu Vanuatu),
				'few' => q(Vatu Vanuatu),
				'many' => q(Vatu Vanuatu),
				'one' => q(Vatu Vanuatu),
				'other' => q(Vatu Vanuatu),
				'two' => q(Vatu Vanuatu),
				'zero' => q(Vatu Vanuatu),
			},
		},
		'WST' => {
			symbol => 'WST',
			display_name => {
				'currency' => q(Tala Samoa),
				'few' => q(Tala Samoa),
				'many' => q(Tala Samoa),
				'one' => q(Tala Samoa),
				'other' => q(Tala Samoa),
				'two' => q(Tala Samoa),
				'zero' => q(Tala Samoa),
			},
		},
		'XAF' => {
			symbol => 'FCFA',
			display_name => {
				'currency' => q(Ffranc CFA Canol Affrica),
				'few' => q(ffranc CFA Canol Affrica),
				'many' => q(ffranc CFA Canol Affrica),
				'one' => q(ffranc CFA Canol Affrica),
				'other' => q(ffranc CFA Canol Affrica),
				'two' => q(ffranc CFA Canol Affrica),
				'zero' => q(ffranc CFA Canol Affrica),
			},
		},
		'XCD' => {
			symbol => 'EC$',
			display_name => {
				'currency' => q(Doler Dwyrain y Caribî),
				'few' => q(doler Dwyrain y Caribî),
				'many' => q(doler Dwyrain y Caribî),
				'one' => q(ddoler Dwyrain y Caribî),
				'other' => q(doler Dwyrain y Caribî),
				'two' => q(ddoler Dwyrain y Caribî),
				'zero' => q(doler Dwyrain y Caribî),
			},
		},
		'XEU' => {
			symbol => 'XEU',
		},
		'XOF' => {
			symbol => 'CFA',
			display_name => {
				'currency' => q(Ffranc CFA Gorllewin Affrica),
				'few' => q(ffranc CFA Gorllewin Affrica),
				'many' => q(ffranc CFA Gorllewin Affrica),
				'one' => q(ffranc CFA Gorllewin Affrica),
				'other' => q(ffranc CFA Gorllewin Affrica),
				'two' => q(ffranc CFA Gorllewin Affrica),
				'zero' => q(ffranc CFA Gorllewin Affrica),
			},
		},
		'XPF' => {
			symbol => 'CFPF',
			display_name => {
				'currency' => q(Ffranc CFP),
				'few' => q(Ffranc CPF),
				'many' => q(Ffranc CPF),
				'one' => q(Ffranc CPF),
				'other' => q(Ffranc CPF),
				'two' => q(Ffranc CPF),
				'zero' => q(Ffranc CPF),
			},
		},
		'XXX' => {
			symbol => 'XXX',
			display_name => {
				'currency' => q(Arian Cyfred Anhysbys),
				'few' => q(\(arian cyfred anhysbys\)),
				'many' => q(\(arian cyfred anhysbys\)),
				'one' => q(\(arian cyfred anhysbys\)),
				'other' => q(\(arian cyfred anhysbys\)),
				'two' => q(\(arian cyfred anhysbys\)),
				'zero' => q(\(arian cyfred anhysbys\)),
			},
		},
		'YDD' => {
			symbol => 'YDD',
			display_name => {
				'currency' => q(Dinar Yemen),
				'few' => q(dinar Yemen),
				'many' => q(dinar Yemen),
				'one' => q(dinar Yemen),
				'other' => q(dinar Yemen),
				'two' => q(dinar Yemen),
				'zero' => q(dinar Yemen),
			},
		},
		'YER' => {
			symbol => 'YER',
			display_name => {
				'currency' => q(Rial Yemen),
				'few' => q(Rial Yemen),
				'many' => q(Rial Yemen),
				'one' => q(Rial Yemen),
				'other' => q(Rial Yemen),
				'two' => q(Rial Yemen),
				'zero' => q(Rial Yemen),
			},
		},
		'YUD' => {
			symbol => 'YUD',
		},
		'YUM' => {
			symbol => 'YUM',
		},
		'YUN' => {
			symbol => 'YUN',
		},
		'YUR' => {
			symbol => 'YUR',
		},
		'ZAL' => {
			symbol => 'ZAL',
			display_name => {
				'currency' => q(Rand \(ariannol\) De Affrica),
				'few' => q(rand \(ariannol\) De Affrica),
				'many' => q(rand \(ariannol\) De Affrica),
				'one' => q(rand \(ariannol\) De Affrica),
				'other' => q(rand \(ariannol\) De Affrica),
				'two' => q(rand \(ariannol\) De Affrica),
				'zero' => q(rand \(ariannol\) De Affrica),
			},
		},
		'ZAR' => {
			symbol => 'ZAR',
			display_name => {
				'currency' => q(Rand De Affrica),
				'few' => q(rand De Affrica),
				'many' => q(rand De Affrica),
				'one' => q(rand De Affrica),
				'other' => q(rand De Affrica),
				'two' => q(rand De Affrica),
				'zero' => q(rand De Affrica),
			},
		},
		'ZMK' => {
			symbol => 'ZMK',
			display_name => {
				'currency' => q(Kwacha Zambia \(1968–2012\)),
				'few' => q(kwacha Zambia \(1968–2012\)),
				'many' => q(kwacha Zambia \(1968–2012\)),
				'one' => q(kwacha Zambia \(1968–2012\)),
				'other' => q(kwacha Zambia \(1968–2012\)),
				'two' => q(kwacha Zambia \(1968–2012\)),
				'zero' => q(kwacha Zambia \(1968–2012\)),
			},
		},
		'ZMW' => {
			symbol => 'ZMW',
			display_name => {
				'currency' => q(Kwacha Zambia),
				'few' => q(kwacha Zambia),
				'many' => q(kwacha Zambia),
				'one' => q(kwacha Zambia),
				'other' => q(kwacha Zambia),
				'two' => q(kwacha Zambia),
				'zero' => q(kwacha Zambia),
			},
		},
		'ZRN' => {
			symbol => 'ZRN',
			display_name => {
				'currency' => q(Zaire Newydd Zaire \(1993–1998\)),
				'few' => q(Zaire Newydd Zaire \(1993–1998\)),
				'many' => q(Zaire Newydd Zaire \(1993–1998\)),
				'one' => q(Zaire Newydd Zaire \(1993–1998\)),
				'other' => q(Zaire Newydd Zaire \(1993–1998\)),
				'two' => q(Zaire Newydd Zaire \(1993–1998\)),
				'zero' => q(Zaire Newydd Zaire \(1993–1998\)),
			},
		},
		'ZRZ' => {
			symbol => 'ZRZ',
			display_name => {
				'currency' => q(Zaire Zaire \(1971–1993\)),
				'few' => q(Zaire Zaire \(1971–1993\)),
				'many' => q(Zaire Zaire \(1971–1993\)),
				'one' => q(Zaire Zaire \(1971–1993\)),
				'other' => q(Zaire Zaire \(1971–1993\)),
				'two' => q(Zaire Zaire \(1971–1993\)),
				'zero' => q(Zaire Zaire \(1971–1993\)),
			},
		},
		'ZWD' => {
			symbol => 'ZWD',
			display_name => {
				'currency' => q(Doler Zimbabwe \(1980–2008\)),
				'few' => q(doler Zimbabwe \(1980–2008\)),
				'many' => q(doler Zimbabwe \(1980–2008\)),
				'one' => q(ddoler Zimbabwe \(1980–2008\)),
				'other' => q(doler Zimbabwe \(1980–2008\)),
				'two' => q(ddoler Zimbabwe \(1980–2008\)),
				'zero' => q(doler Zimbabwe \(1980–2008\)),
			},
		},
		'ZWL' => {
			symbol => 'ZWL',
			display_name => {
				'currency' => q(Doler Zimbabwe \(2009\)),
				'few' => q(doler Zimbabwe \(2009\)),
				'many' => q(doler Zimbabwe \(2009\)),
				'one' => q(ddoler Zimbabwe \(2009\)),
				'other' => q(doler Zimbabwe \(2009\)),
				'two' => q(ddoler Zimbabwe \(2009\)),
				'zero' => q(doler Zimbabwe \(2009\)),
			},
		},
		'ZWR' => {
			symbol => 'ZWR',
			display_name => {
				'currency' => q(Doler Zimbabwe \(2008\)),
				'few' => q(doler Zimbabwe \(2008\)),
				'many' => q(doler Zimbabwe \(2008\)),
				'one' => q(ddoler Zimbabwe \(2008\)),
				'other' => q(doler Zimbabwe \(2008\)),
				'two' => q(ddoler Zimbabwe \(2008\)),
				'zero' => q(doler Zimbabwe \(2008\)),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'Ion',
							'Chwef',
							'Maw',
							'Ebrill',
							'Mai',
							'Meh',
							'Gorff',
							'Awst',
							'Medi',
							'Hyd',
							'Tach',
							'Rhag'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'I',
							'Ch',
							'M',
							'E',
							'M',
							'M',
							'G',
							'A',
							'M',
							'H',
							'T',
							'Rh'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'Ionawr',
							'Chwefror',
							'Mawrth',
							'Ebrill',
							'Mai',
							'Mehefin',
							'Gorffennaf',
							'Awst',
							'Medi',
							'Hydref',
							'Tachwedd',
							'Rhagfyr'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'Ion',
							'Chw',
							'Maw',
							'Ebr',
							'Mai',
							'Meh',
							'Gor',
							'Awst',
							'Medi',
							'Hyd',
							'Tach',
							'Rhag'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'I',
							'Ch',
							'M',
							'E',
							'M',
							'M',
							'G',
							'A',
							'M',
							'H',
							'T',
							'Rh'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'Ionawr',
							'Chwefror',
							'Mawrth',
							'Ebrill',
							'Mai',
							'Mehefin',
							'Gorffennaf',
							'Awst',
							'Medi',
							'Hydref',
							'Tachwedd',
							'Rhagfyr'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'Llun',
						tue => 'Maw',
						wed => 'Mer',
						thu => 'Iau',
						fri => 'Gwen',
						sat => 'Sad',
						sun => 'Sul'
					},
					narrow => {
						mon => 'Ll',
						tue => 'M',
						wed => 'M',
						thu => 'I',
						fri => 'G',
						sat => 'S',
						sun => 'S'
					},
					short => {
						mon => 'Ll',
						tue => 'Ma',
						wed => 'Me',
						thu => 'Ia',
						fri => 'Gw',
						sat => 'Sa',
						sun => 'Su'
					},
					wide => {
						mon => 'Dydd Llun',
						tue => 'Dydd Mawrth',
						wed => 'Dydd Mercher',
						thu => 'Dydd Iau',
						fri => 'Dydd Gwener',
						sat => 'Dydd Sadwrn',
						sun => 'Dydd Sul'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'Llun',
						tue => 'Maw',
						wed => 'Mer',
						thu => 'Iau',
						fri => 'Gwe',
						sat => 'Sad',
						sun => 'Sul'
					},
					narrow => {
						mon => 'Ll',
						tue => 'M',
						wed => 'M',
						thu => 'I',
						fri => 'G',
						sat => 'S',
						sun => 'S'
					},
					short => {
						mon => 'Ll',
						tue => 'Ma',
						wed => 'Me',
						thu => 'Ia',
						fri => 'Gw',
						sat => 'Sa',
						sun => 'Su'
					},
					wide => {
						mon => 'Dydd Llun',
						tue => 'Dydd Mawrth',
						wed => 'Dydd Mercher',
						thu => 'Dydd Iau',
						fri => 'Dydd Gwener',
						sat => 'Dydd Sadwrn',
						sun => 'Dydd Sul'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'Ch1',
						1 => 'Ch2',
						2 => 'Ch3',
						3 => 'Ch4'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => 'chwarter 1af',
						1 => '2il chwarter',
						2 => '3ydd chwarter',
						3 => '4ydd chwarter'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => 'Ch1',
						1 => 'Ch2',
						2 => 'Ch3',
						3 => 'Ch4'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => 'chwarter 1af',
						1 => '2il chwarter',
						2 => '3ydd chwarter',
						3 => '4ydd chwarter'
					},
				},
			},
	} },
);

has 'day_periods' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'wide' => {
					'am' => q{AM},
					'pm' => q{PM},
				},
				'abbreviated' => {
					'am' => q{AM},
					'pm' => q{PM},
				},
				'narrow' => {
					'am' => q{AM},
					'pm' => q{PM},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'CC',
				'1' => 'OC'
			},
			narrow => {
				'0' => 'C',
				'1' => 'O'
			},
			wide => {
				'0' => 'Cyn Crist',
				'1' => 'Oed Crist'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{EEEE, d MMMM y G},
			'long' => q{d MMMM y G},
			'medium' => q{d MMM y G},
			'short' => q{dd/MM/y GGGGG},
		},
		'gregorian' => {
			'full' => q{EEEE, d MMMM y},
			'long' => q{d MMMM y},
			'medium' => q{d MMM y},
			'short' => q{dd/MM/yy},
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			'full' => q{HH:mm:ss zzzz},
			'long' => q{HH:mm:ss z},
			'medium' => q{HH:mm:ss},
			'short' => q{HH:mm},
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{{1} am {0}},
			'long' => q{{1} am {0}},
			'medium' => q{{1}, {0}},
			'short' => q{{1}, {0}},
		},
		'gregorian' => {
			'full' => q{{1} 'am' {0}},
			'long' => q{{1} 'am' {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			E => q{ccc},
			Ed => q{E, d},
			Gy => q{y G},
			GyMMM => q{MMM y G},
			GyMMMEd => q{E, d MMM y G},
			GyMMMd => q{d MMM y G},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{E, d/M},
			MMM => q{LLL},
			MMMEd => q{E, d MMM},
			MMMMd => q{MMMM d},
			MMMd => q{d MMM},
			Md => q{d/M},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{y},
			yyyy => q{y G},
			yyyyM => q{M/y G},
			yyyyMEd => q{E, d/M/y G},
			yyyyMMM => q{MMM y G},
			yyyyMMMEd => q{E, d MMM y G},
			yyyyMMMM => q{G y MMMM},
			yyyyMMMd => q{d MMM y G},
			yyyyMd => q{d/M/y G},
			yyyyQQQ => q{QQQ y G},
			yyyyQQQQ => q{QQQQ y G},
		},
		'gregorian' => {
			E => q{ccc},
			EHm => q{E, HH:mm},
			EHms => q{E, HH:mm:ss},
			Ed => q{E, d},
			Ehm => q{E, h:mm a},
			Ehms => q{E, h:mm:ss a},
			Gy => q{y G},
			GyMMM => q{MMM y G},
			GyMMMEd => q{E, d MMM y G},
			GyMMMd => q{d MMM y G},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			Hmsv => q{HH:mm:ss v},
			Hmv => q{HH:mm v},
			M => q{L},
			MEd => q{E, d/M},
			MMM => q{LLL},
			MMMEd => q{E, d MMM},
			MMMMd => q{MMMM d},
			MMMd => q{d MMM},
			Md => q{d/M},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			hmsv => q{h:mm:ss a v},
			hmv => q{h:mm a v},
			ms => q{mm:ss},
			y => q{y},
			yM => q{M/y},
			yMEd => q{E, d/M/y},
			yMMM => q{MMM y},
			yMMMEd => q{E, d MMM y},
			yMMMM => q{MMMM y},
			yMMMd => q{d MMM y},
			yMd => q{d/M/y},
			yQ => q{Q y},
			yQQQ => q{QQQ y},
			yQQQQ => q{QQQQ y},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'Timezone' => '{0} {1}',
		},
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			H => {
				H => q{HH – HH},
			},
			Hm => {
				H => q{HH:mm – HH:mm},
				m => q{HH:mm – HH:mm},
			},
			Hmv => {
				H => q{HH:mm – HH:mm v},
				m => q{HH:mm – HH:mm v},
			},
			Hv => {
				H => q{HH – HH v},
			},
			M => {
				M => q{M – M},
			},
			MEd => {
				M => q{E, d/M – E, d/M},
				d => q{E, d/M – E, d/M},
			},
			MMM => {
				M => q{MMM–MMM},
			},
			MMMEd => {
				M => q{E, d MMM – E, d MMM},
				d => q{E, d MMM – E, d MMM},
			},
			MMMM => {
				M => q{LLLL–LLLL},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d – d MMM},
			},
			Md => {
				M => q{d/M – d/M},
				d => q{d/M – d/M},
			},
			d => {
				d => q{d – d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h – h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm – h:mm a},
				m => q{h:mm – h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm – h:mm a v},
				m => q{h:mm – h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h – h a v},
			},
			y => {
				y => q{y–y G},
			},
			yM => {
				M => q{M/y – M/y GGGGG},
				y => q{M/y – M/y GGGGG},
			},
			yMEd => {
				M => q{E, d/M/y – E, d/M/y GGGGG},
				d => q{E, d/M/y – E, d/M/y GGGGG},
				y => q{E, d/M/y – E, d/M/y GGGGG},
			},
			yMMM => {
				M => q{MMM – MMM y G},
				y => q{MMM y – MMM y G},
			},
			yMMMEd => {
				M => q{E, d MMM – E, d MMM y G},
				d => q{E, d MMM – E, d MMM y G},
				y => q{E, d MMM, y – E, d MMM y G},
			},
			yMMMM => {
				M => q{MMMM–MMMM y G},
				y => q{MMMM y – MMMM y G},
			},
			yMMMd => {
				M => q{d MMM – d MMM y G},
				d => q{d–d MMM y G},
				y => q{d MMM y – d MMM y G},
			},
			yMd => {
				M => q{d/M/y – d/M/y GGGGG},
				d => q{d/M/y – d/M/y GGGGG},
				y => q{d/M/y – d/M/y GGGGG},
			},
		},
		'gregorian' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E, d/M – E, d/M},
				d => q{E, d/M – E, d/M},
			},
			MMM => {
				M => q{MMM–MMM},
			},
			MMMEd => {
				M => q{E, d MMM – E, d MMM},
				d => q{E, d MMM – E, d MMM},
			},
			MMMM => {
				M => q{LLLL–LLLL},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d–d MMM},
			},
			Md => {
				M => q{d/M – d/M},
				d => q{d/M – d/M},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm h:mm a},
				m => q{h:mm – h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm – h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{y–y},
			},
			yM => {
				M => q{M/y – M/y},
				y => q{M/y – M/y},
			},
			yMEd => {
				M => q{E, d/M/y – E, d/M/y},
				d => q{E, d/M/y – E, d/M/y},
				y => q{E, d/M/y – E, d/M/y},
			},
			yMMM => {
				M => q{MMM – MMM y},
				y => q{MMM y – MMM y},
			},
			yMMMEd => {
				M => q{E, d MMM – E, d MMM y},
				d => q{E, d MMM – E, d MMM y},
				y => q{E, d MMM y – E, d MMM y},
			},
			yMMMM => {
				M => q{MMMM–MMMM y},
				y => q{MMMM y – MMMM y},
			},
			yMMMd => {
				M => q{d MMM – d MMM y},
				d => q{d–d MMM y},
				y => q{d MMM, y – d MMM y},
			},
			yMd => {
				M => q{d/M/y – d/M/y},
				d => q{d/M/y – d/M/y},
				y => q{d/M/y – d/M/y},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HH:mm;-HH:mm),
		gmtFormat => q(GMT{0}),
		gmtZeroFormat => q(GMT),
		regionFormat => q(Amser {0}),
		regionFormat => q(Amser Haf {0}),
		regionFormat => q(Amser Safonol {0}),
		fallbackFormat => q({1} ({0})),
		'Afghanistan' => {
			long => {
				'standard' => q(Amser Afghanistan),
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#Abidjan#,
		},
		'Africa/Accra' => {
			exemplarCity => q#Accra#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#Addis Ababa#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#Alger#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#Asmera#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#Bamako#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#Bangui#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#Banjul#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#Bissau#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#Blantyre#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#Brazzaville#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#Bujumbura#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#Cairo#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#Casablanca#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#Ceuta#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#Conakry#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#Dakar#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#Dar es Salaam#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#Djibouti#,
		},
		'Africa/Douala' => {
			exemplarCity => q#Douala#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#El Aaiún#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#Freetown#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#Gaborone#,
		},
		'Africa/Harare' => {
			exemplarCity => q#Harare#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#Johannesburg#,
		},
		'Africa/Juba' => {
			exemplarCity => q#Juba#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#Kampala#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#Khartoum#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#Kigali#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#Kinshasa#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#Lagos#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#Libreville#,
		},
		'Africa/Lome' => {
			exemplarCity => q#Lomé#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#Luanda#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#Lubumbashi#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#Lusaka#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#Malabo#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#Maputo#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#Maseru#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#Mbabane#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#Mogadishu#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#Monrovia#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#Nairobi#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#N’Djamena#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#Niamey#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#Nouakchott#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#Ouagadougou#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#Porto-Novo#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#São Tomé#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#Tripoli#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#Tunis#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#Windhoek#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q(Amser Canolbarth Affrica),
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q(Amser Dwyrain Affrica),
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q(Amser Safonol De Affrica),
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q(Amser Haf Gorllewin Affrica),
				'generic' => q(Amser Gorllewin Affrica),
				'standard' => q(Amser Safonol Gorllewin Affrica),
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q(Amser Haf Alaska),
				'generic' => q(Amser Alaska),
				'standard' => q(Amser Safonol Alaska),
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q(Amser Haf Amazonas),
				'generic' => q(Amser Amazonas),
				'standard' => q(Amser Safonol Amazonas),
			},
		},
		'America/Adak' => {
			exemplarCity => q#Adak#,
		},
		'America/Anchorage' => {
			exemplarCity => q#Anchorage#,
		},
		'America/Anguilla' => {
			exemplarCity => q#Anguilla#,
		},
		'America/Antigua' => {
			exemplarCity => q#Antigua#,
		},
		'America/Araguaina' => {
			exemplarCity => q#Araguaina#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#La Rioja#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#Rio Gallegos#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#Salta#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#San Juan#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#San Luis#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#Tucumán#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#Ushuaia#,
		},
		'America/Aruba' => {
			exemplarCity => q#Aruba#,
		},
		'America/Asuncion' => {
			exemplarCity => q#Asunción#,
		},
		'America/Bahia' => {
			exemplarCity => q#Bahia#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#Bae Banderas#,
		},
		'America/Barbados' => {
			exemplarCity => q#Barbados#,
		},
		'America/Belem' => {
			exemplarCity => q#Belém#,
		},
		'America/Belize' => {
			exemplarCity => q#Belize#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#Blanc-Sablon#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#Boa Vista#,
		},
		'America/Bogota' => {
			exemplarCity => q#Bogotá#,
		},
		'America/Boise' => {
			exemplarCity => q#Boise#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#Buenos Aires#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#Cambridge Bay#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#Campo Grande#,
		},
		'America/Cancun' => {
			exemplarCity => q#Cancún#,
		},
		'America/Caracas' => {
			exemplarCity => q#Caracas#,
		},
		'America/Catamarca' => {
			exemplarCity => q#Catamarca#,
		},
		'America/Cayenne' => {
			exemplarCity => q#Cayenne#,
		},
		'America/Cayman' => {
			exemplarCity => q#Cayman#,
		},
		'America/Chicago' => {
			exemplarCity => q#Chicago#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#Chihuahua#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#Atikokan#,
		},
		'America/Cordoba' => {
			exemplarCity => q#Cordoba#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#Costa Rica#,
		},
		'America/Creston' => {
			exemplarCity => q#Creston#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#Cuiabá#,
		},
		'America/Curacao' => {
			exemplarCity => q#Curaçao#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#Danmarkshavn#,
		},
		'America/Dawson' => {
			exemplarCity => q#Dawson#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#Dawson Creek#,
		},
		'America/Denver' => {
			exemplarCity => q#Denver#,
		},
		'America/Detroit' => {
			exemplarCity => q#Detroit#,
		},
		'America/Dominica' => {
			exemplarCity => q#Dominica#,
		},
		'America/Edmonton' => {
			exemplarCity => q#Edmonton#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#Eirunepé#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#El Salvador#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#Fortaleza#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#Glace Bay#,
		},
		'America/Godthab' => {
			exemplarCity => q#Nuuk#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#Goose Bay#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#Grand Turk#,
		},
		'America/Grenada' => {
			exemplarCity => q#Grenada#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#Guadeloupe#,
		},
		'America/Guatemala' => {
			exemplarCity => q#Guatemala#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#Guayaquil#,
		},
		'America/Guyana' => {
			exemplarCity => q#Guyana#,
		},
		'America/Halifax' => {
			exemplarCity => q#Halifax#,
		},
		'America/Havana' => {
			exemplarCity => q#Havana#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#Hermosillo#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#Knox, Indiana#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#Marengo, Indiana#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#Petersburg, Indiana#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#Dinas Tell, Indiana#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#Vevay, Indiana#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#Vincennes, Indiana#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#Winamac, Indiana#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#Indianapolis#,
		},
		'America/Inuvik' => {
			exemplarCity => q#Inuvik#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#Iqaluit#,
		},
		'America/Jamaica' => {
			exemplarCity => q#Jamaica#,
		},
		'America/Jujuy' => {
			exemplarCity => q#Jujuy#,
		},
		'America/Juneau' => {
			exemplarCity => q#Juneau#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#Monticello, Kentucky#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#Kralendijk#,
		},
		'America/La_Paz' => {
			exemplarCity => q#La Paz#,
		},
		'America/Lima' => {
			exemplarCity => q#Lima#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#Los Angeles#,
		},
		'America/Louisville' => {
			exemplarCity => q#Louisville#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#Lower Prince’s Quarter#,
		},
		'America/Maceio' => {
			exemplarCity => q#Maceió#,
		},
		'America/Managua' => {
			exemplarCity => q#Managua#,
		},
		'America/Manaus' => {
			exemplarCity => q#Manaus#,
		},
		'America/Marigot' => {
			exemplarCity => q#Marigot#,
		},
		'America/Martinique' => {
			exemplarCity => q#Martinique#,
		},
		'America/Matamoros' => {
			exemplarCity => q#Matamoros#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#Mazatlán#,
		},
		'America/Mendoza' => {
			exemplarCity => q#Mendoza#,
		},
		'America/Menominee' => {
			exemplarCity => q#Menominee#,
		},
		'America/Merida' => {
			exemplarCity => q#Merida#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#Metlakatla#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#Dinas Mecsico#,
		},
		'America/Miquelon' => {
			exemplarCity => q#Miquelon#,
		},
		'America/Moncton' => {
			exemplarCity => q#Moncton#,
		},
		'America/Monterrey' => {
			exemplarCity => q#Monterrey#,
		},
		'America/Montevideo' => {
			exemplarCity => q#Montevideo#,
		},
		'America/Montserrat' => {
			exemplarCity => q#Montserrat#,
		},
		'America/Nassau' => {
			exemplarCity => q#Nassau#,
		},
		'America/New_York' => {
			exemplarCity => q#Efrog Newydd#,
		},
		'America/Nipigon' => {
			exemplarCity => q#Nipigon#,
		},
		'America/Nome' => {
			exemplarCity => q#Nome#,
		},
		'America/Noronha' => {
			exemplarCity => q#Noronha#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#Beulah, Gogledd Dakota#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#Center, Gogledd Dakota#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#New Salem, Gogledd Dakota#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#Ojinaga#,
		},
		'America/Panama' => {
			exemplarCity => q#Panamá#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#Pangnirtung#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#Paramaribo#,
		},
		'America/Phoenix' => {
			exemplarCity => q#Phoenix#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#Port-au-Prince#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#Port of Spain#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#Porto Velho#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#Puerto Rico#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#Rainy River#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#Rankin Inlet#,
		},
		'America/Recife' => {
			exemplarCity => q#Recife#,
		},
		'America/Regina' => {
			exemplarCity => q#Regina#,
		},
		'America/Resolute' => {
			exemplarCity => q#Resolute#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#Rio Branco#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#Santa Isabel#,
		},
		'America/Santarem' => {
			exemplarCity => q#Santarem#,
		},
		'America/Santiago' => {
			exemplarCity => q#Santiago#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#Santo Domingo#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#São Paulo#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#Ittoqqortoormiit#,
		},
		'America/Sitka' => {
			exemplarCity => q#Sitka#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#St. Barthelemy#,
		},
		'America/St_Johns' => {
			exemplarCity => q#St. John’s#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#Saint Kitts#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#Saint Lucia#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#Saint Thomas#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#Saint Vincent#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#Swift Current#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#Tegucigalpa#,
		},
		'America/Thule' => {
			exemplarCity => q#Thule#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#Thunder Bay#,
		},
		'America/Tijuana' => {
			exemplarCity => q#Tijuana#,
		},
		'America/Toronto' => {
			exemplarCity => q#Toronto#,
		},
		'America/Tortola' => {
			exemplarCity => q#Tortola#,
		},
		'America/Vancouver' => {
			exemplarCity => q#Vancouver#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#Whitehorse#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#Winnipeg#,
		},
		'America/Yakutat' => {
			exemplarCity => q#Yakutat#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#Yellowknife#,
		},
		'America_Central' => {
			long => {
				'daylight' => q(Amser Haf Canolbarth Gogledd America),
				'generic' => q(Amser Canolbarth Gogledd America),
				'standard' => q(Amser Safonol Canolbarth Gogledd America),
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q(Amser Haf Dwyrain Gogledd America),
				'generic' => q(Amser Dwyrain Gogledd America),
				'standard' => q(Amser Safonol Dwyrain Gogledd America),
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q(Amser Haf Mynyddoedd Gogledd America),
				'generic' => q(Amser Mynyddoedd Gogledd America),
				'standard' => q(Amser Safonol Mynyddoedd Gogledd America),
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q(Amser Haf Cefnfor Tawel Gogledd America),
				'generic' => q(Amser Cefnfor Tawel Gogledd America),
				'standard' => q(Amser Safonol Cefnfor Tawel Gogledd America),
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#Casey#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#Davis#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#Dumont d’Urville#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#Macquarie#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#Mawson#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#McMurdo#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#Palmer#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#Rothera#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#Syowa#,
		},
		'Antarctica/Troll' => {
			exemplarCity => q#Troll#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#Vostok#,
		},
		'Apia' => {
			long => {
				'daylight' => q(Amser Haf Apia),
				'generic' => q(Amser Apia),
				'standard' => q(Amser Safonol Apia),
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q(Amser Haf Arabaidd),
				'generic' => q(Amser Arabaidd),
				'standard' => q(Amser Safonol Arabaidd),
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#Longyearbyen#,
		},
		'Argentina' => {
			long => {
				'daylight' => q(Amser Haf Ariannin),
				'generic' => q(Amser yr Ariannin),
				'standard' => q(Amser Safonol Ariannin),
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q(Amser Haf Gorllewin Ariannin),
				'generic' => q(Amser Gorllewin Ariannin),
				'standard' => q(Amser Safonol Gorllewin Ariannin),
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q(Amser Haf Armenia),
				'generic' => q(Amser Armenia),
				'standard' => q(Amser Safonol Armenia),
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#Aden#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#Almaty#,
		},
		'Asia/Amman' => {
			exemplarCity => q#Amman#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#Anadyr#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#Aqtau#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#Aqtobe#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#Ashgabat#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#Baghdad#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#Bahrain#,
		},
		'Asia/Baku' => {
			exemplarCity => q#Baku#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#Bangkok#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#Beirut#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#Bishkek#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#Brunei#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#Kolkata#,
		},
		'Asia/Chita' => {
			exemplarCity => q#Chita#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#Choibalsan#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#Colombo#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#Damascus#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#Dhaka#,
		},
		'Asia/Dili' => {
			exemplarCity => q#Dili#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#Dubai#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#Dushanbe#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#Gasa#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#Hebron#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#Hong Kong#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#Hovd#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#Irkutsk#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#Jakarta#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#Jayapura#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#Jerwsalem#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#Kabul#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#Kamchatka#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#Karachi#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#Kathmandu#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#Khandyga#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#Krasnoyarsk#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#Kuala Lumpur#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#Kuching#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#Kuwait#,
		},
		'Asia/Macau' => {
			exemplarCity => q#Macau#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#Magadan#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#Makassar#,
		},
		'Asia/Manila' => {
			exemplarCity => q#Manila#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#Muscat#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#Nicosia#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#Novokuznetsk#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#Novosibirsk#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#Omsk#,
		},
		'Asia/Oral' => {
			exemplarCity => q#Oral#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#Phnom Penh#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#Pontianak#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#Pyongyang#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#Qatar#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#Qyzylorda#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#Yangon#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#Riyadh#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#Dinas Hô Chi Minh#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#Sakhalin#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#Samarkand#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#Seoul#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#Shanghai#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#Singapore#,
		},
		'Asia/Srednekolymsk' => {
			exemplarCity => q#Srednekolymsk#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#Taipei#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#Tashkent#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#Tiflis#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#Tehran#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#Thimphu#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#Tokyo#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#Ulan Bator#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#Urumqi#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#Ust-Nera#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#Vientiane#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#Vladivostok#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#Yakutsk#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#Yekaterinburg#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#Yerevan#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q(Amser Haf Cefnfor yr Iwerydd),
				'generic' => q(Amser Cefnfor yr Iwerydd),
				'standard' => q(Amser Safonol Cefnfor yr Iwerydd),
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#Azores#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#Bermuda#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#yr Ynysoedd Dedwydd#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#Cabo Verde#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#Ffaro#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#Madeira#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#Reykjavík#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#De Georgia#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#Saint Helena#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#Stanley#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#Adelaide#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#Brisbane#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#Broken Hill#,
		},
		'Australia/Currie' => {
			exemplarCity => q#Currie#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#Darwin#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#Eucla#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#Hobart#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#Lindeman#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#Lord Howe#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#Melbourne#,
		},
		'Australia/Perth' => {
			exemplarCity => q#Perth#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#Sydney#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q(Amser Haf Canolbarth Awstralia),
				'generic' => q(Amser Canolbarth Awstralia),
				'standard' => q(Amser Safonol Canolbarth Awstralia),
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q(Amser Haf Canolbarth Gorllewin Awstralia),
				'generic' => q(Amser Canolbarth Gorllewin Awstralia),
				'standard' => q(Amser Safonol Canolbarth Gorllewin Awstralia),
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q(Amser Haf Dwyrain Awstralia),
				'generic' => q(Amser Dwyrain Awstralia),
				'standard' => q(Amser Safonol Dwyrain Awstralia),
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q(Amser Haf Gorllewin Awstralia),
				'generic' => q(Amser Gorllewin Awstralia),
				'standard' => q(Amser Safonol Gorllewin Awstralia),
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q(Amser Haf Aserbaijan),
				'generic' => q(Amser Aserbaijan),
				'standard' => q(Amser Safonol Aserbaijan),
			},
		},
		'Azores' => {
			long => {
				'daylight' => q(Amser Haf yr Azores),
				'generic' => q(Amser yr Azores),
				'standard' => q(Amser Safonol yr Azores),
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q(Amser Haf Bangladesh),
				'generic' => q(Amser Bangladesh),
				'standard' => q(Amser Safonol Bangladesh),
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q(Amser Bhutan),
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q(Amser Bolivia),
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q(Amser Haf Brasília),
				'generic' => q(Amser Brasília),
				'standard' => q(Amser Safonol Brasília),
			},
		},
		'Brunei' => {
			long => {
				'standard' => q(Amser Brunei Darussalam),
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q(Amser Haf Cabo Verde),
				'generic' => q(Amser Cabo Verde),
				'standard' => q(Amser Safonol Cabo Verde),
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q(Amser Chamorro),
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q(Amser Haf Chatham),
				'generic' => q(Amser Chatham),
				'standard' => q(Amser Safonol Chatham),
			},
		},
		'Chile' => {
			long => {
				'daylight' => q(Amser Haf Chile),
				'generic' => q(Amser Chile),
				'standard' => q(Amser Safonol Chile),
			},
		},
		'China' => {
			long => {
				'daylight' => q(Amser Haf Tsieina),
				'generic' => q(Amser Tsieina),
				'standard' => q(Amser Safonol Tsieina),
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q(Amser Haf Choibalsan),
				'generic' => q(Amser Choibalsan),
				'standard' => q(Amser Safonol Choibalsan),
			},
		},
		'Christmas' => {
			long => {
				'standard' => q(Amser Ynys Y Nadolig),
			},
		},
		'Cocos' => {
			long => {
				'standard' => q(Amser Ynysoedd Cocos),
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q(Amser Haf Colombia),
				'generic' => q(Amser Colombia),
				'standard' => q(Amser Safonol Colombia),
			},
		},
		'Cook' => {
			long => {
				'daylight' => q(Amser Hanner Haf Ynysoedd Cook),
				'generic' => q(Amser Ynysoedd Cook),
				'standard' => q(Amser Safonol Ynysoedd Cook),
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q(Amser Haf Cuba),
				'generic' => q(Amser Cuba),
				'standard' => q(Amser Safonol Cuba),
			},
		},
		'Davis' => {
			long => {
				'standard' => q(Amser Davis),
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q(Amser Dumont-d’Urville),
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q(Amser Dwyrain Timor),
			},
		},
		'Easter' => {
			long => {
				'daylight' => q(Amser Haf Ynys y Pasg),
				'generic' => q(Amser Ynys y Pasg),
				'standard' => q(Amser Safonol Ynys y Pasg),
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q(Amser Ecuador),
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#Dinas Anhysbys#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#Amsterdam#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#Andorra#,
		},
		'Europe/Athens' => {
			exemplarCity => q#Athen#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#Beograd#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#Berlin#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#Bratislava#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#Brwsel#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#Bwcarést#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#Budapest#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#Busingen#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#Chisinau#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#Copenhagen#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#Dulyn#,
			long => {
				'daylight' => q(Amser Haf Iwerddon),
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#Gibraltar#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#Ynys y Garn#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#Helsinki#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#Ynys Manaw#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#Caergystennin#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#Jersey#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#Kaliningrad#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#Kiev#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#Lisbon#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#Ljubljana#,
		},
		'Europe/London' => {
			exemplarCity => q#Llundain#,
			long => {
				'daylight' => q(Amser Haf Prydain),
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#Lwcsembwrg#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#Madrid#,
		},
		'Europe/Malta' => {
			exemplarCity => q#Malta#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#Mariehamn#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#Minsk#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#Monaco#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#Moscfa#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#Oslo#,
		},
		'Europe/Paris' => {
			exemplarCity => q#Paris#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#Podgorica#,
		},
		'Europe/Prague' => {
			exemplarCity => q#Prag#,
		},
		'Europe/Riga' => {
			exemplarCity => q#Riga#,
		},
		'Europe/Rome' => {
			exemplarCity => q#Rhufain#,
		},
		'Europe/Samara' => {
			exemplarCity => q#Samara#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#San Marino#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#Sarajevo#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#Simferopol#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#Skopje#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#Sofia#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#Stockholm#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#Tallinn#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#Tirane#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#Uzhhorod#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#Vaduz#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#y Fatican#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#Fienna#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#Vilnius#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#Volgograd#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#Warsaw#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#Zagreb#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#Zaporizhzhya#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#Zurich#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q(Amser Haf Canolbarth Ewrop),
				'generic' => q(Amser Canolbarth Ewrop),
				'standard' => q(Amser Safonol Canolbarth Ewrop),
			},
			short => {
				'daylight' => q(CEST),
				'generic' => q(CET),
				'standard' => q(CET),
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q(Amser Haf Dwyrain Ewrop),
				'generic' => q(Amser Dwyrain Ewrop),
				'standard' => q(Amser Safonol Dwyrain Ewrop),
			},
			short => {
				'daylight' => q(EEST),
				'generic' => q(EET),
				'standard' => q(EET),
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q(Amser Dwyrain Pell Ewrop),
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q(Amser Haf Gorllewin Ewrop),
				'generic' => q(Amser Gorllewin Ewrop),
				'standard' => q(Amser Safonol Gorllewin Ewrop),
			},
			short => {
				'daylight' => q(WEST),
				'generic' => q(WET),
				'standard' => q(WET),
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q(Amser Haf Ynysoedd Falklands/Malvinas),
				'generic' => q(Amser Ynysoedd Falklands/Malvinas),
				'standard' => q(Amser Safonol Ynysoedd Falklands/Malvinas),
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q(Amser Haf Fiji),
				'generic' => q(Amser Fiji),
				'standard' => q(Amser Safonol Fiji),
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q(Amser Guyane Ffrengig),
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q(Amser Deheuol ac Antarctig Frengig),
			},
		},
		'GMT' => {
			long => {
				'standard' => q(Amser Safonol Greenwich),
			},
			short => {
				'standard' => q(GMT),
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q(Amser Galapagos),
			},
		},
		'Gambier' => {
			long => {
				'standard' => q(Amser Gambier),
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q(Amser Haf Georgia),
				'generic' => q(Amser Georgia),
				'standard' => q(Amser Safonol Georgia),
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q(Amser Ynysoedd Gilbert),
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q(Amser Haf Dwyrain yr Ynys Las),
				'generic' => q(Amser Dwyrain yr Ynys Las),
				'standard' => q(Amser Safonol Dwyrain yr Ynys Las),
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q(Amser Haf Gorllewin yr Ynys Las),
				'generic' => q(Amser Gorllewin yr Ynys Las),
				'standard' => q(Amser Safonol Gorllewin yr Ynys Las),
			},
		},
		'Gulf' => {
			long => {
				'standard' => q(Amser Safonol y Gwlff),
			},
		},
		'Guyana' => {
			long => {
				'standard' => q(Amser Guyana),
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q(Amser Haf Hawaii-Aleutian),
				'generic' => q(Amser Hawaii-Aleutian),
				'standard' => q(Amser Safonol Hawaii-Aleutian),
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q(Amser Haf Hong Kong),
				'generic' => q(Amser Hong Kong),
				'standard' => q(Amser Safonol Hong Kong),
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q(Amser Haf Hovd),
				'generic' => q(Amser Hovd),
				'standard' => q(Amser Safonol Hovd),
			},
		},
		'India' => {
			long => {
				'standard' => q(Amser India),
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#Antananarivo#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#Chagos#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#Ynys y Nadolig#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#Cocos#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#Comoro#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#Kerguelen#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#Mahé#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#Maldives#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#Mauritius#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#Mayotte#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#Réunion#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q(Amser Cefnfor India),
			},
		},
		'Indochina' => {
			long => {
				'standard' => q(Amser Indo-Tsieina),
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q(Amser Canolbarth Indonesia),
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q(Amser Dwyrain Indonesia),
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q(Amser Gorllewin Indonesia),
			},
		},
		'Iran' => {
			long => {
				'daylight' => q(Amser Haf Iran),
				'generic' => q(Amser Iran),
				'standard' => q(Amser Safonol Iran),
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q(Amser Haf Irkutsk),
				'generic' => q(Amser Irkutsk),
				'standard' => q(Amser Safonol Irkutsk),
			},
		},
		'Israel' => {
			long => {
				'daylight' => q(Amser Haf Israel),
				'generic' => q(Amser Israel),
				'standard' => q(Amser Safonol Israel),
			},
		},
		'Japan' => {
			long => {
				'daylight' => q(Amser Haf Siapan),
				'generic' => q(Amser Siapan),
				'standard' => q(Amser Safonol Siapan),
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q(Amser Dwyrain Casachstan),
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q(Amser Gorllewin Casachstan),
			},
		},
		'Korea' => {
			long => {
				'daylight' => q(Amser Haf Corea),
				'generic' => q(Amser Corea),
				'standard' => q(Amser Safonol Corea),
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q(Amser Kosrae),
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q(Amser Haf Krasnoyarsk),
				'generic' => q(Amser Krasnoyarsk),
				'standard' => q(Amser Safonol Krasnoyarsk),
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q(Amser Casachstan),
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q(Amser Ynysoedd Line),
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q(Amser Haf yr Arglwydd Howe),
				'generic' => q(Amser yr Arglwydd Howe),
				'standard' => q(Amser Safonol yr Arglwydd Howe),
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q(Amser Ynys Macquarie),
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q(Amser Haf Magadan),
				'generic' => q(Amser Magadan),
				'standard' => q(Amser Safonol Magadan),
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q(Amser Malaysia),
			},
		},
		'Maldives' => {
			long => {
				'standard' => q(Amser Y Maldives),
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q(Amser Marquises),
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q(Amser Ynysoedd Marshall),
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q(Amser Haf Mauritius),
				'generic' => q(Amser Mauritius),
				'standard' => q(Amser Safonol Mauritius),
			},
		},
		'Mawson' => {
			long => {
				'standard' => q(Amser Mawson),
			},
		},
		'Mexico_Northwest' => {
			long => {
				'daylight' => q(Amser Haf Gogledd Orllewin Mecsico),
				'generic' => q(Amser Gogledd Orllewin Mecsico),
				'standard' => q(Amser Safonol Gogledd Orllewin Mecsico),
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q(Amser Haf Pasiffig Mecsico),
				'generic' => q(Amser Pasiffig Mecsico),
				'standard' => q(Amser Safonol Pasiffig Mecsico),
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q(Amser Haf Ulan Bator),
				'generic' => q(Amser Ulan Bator),
				'standard' => q(Amser Safonol Ulan Bator),
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q(Amser Haf Moscfa),
				'generic' => q(Amser Moscfa),
				'standard' => q(Amser Safonol Moscfa),
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q(Amser Myanmar),
			},
		},
		'Nauru' => {
			long => {
				'standard' => q(Amser Nauru),
			},
		},
		'Nepal' => {
			long => {
				'standard' => q(Amser Nepal),
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q(Amser Haf Caledonia Newydd),
				'generic' => q(Amser Caledonia Newydd),
				'standard' => q(Amser Safonol Caledonia Newydd),
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q(Amser Haf Seland Newydd),
				'generic' => q(Amser Seland Newydd),
				'standard' => q(Amser Safonol Seland Newydd),
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q(Amser Haf Newfoundland),
				'generic' => q(Amser Newfoundland),
				'standard' => q(Amser Safonol Newfoundland),
			},
		},
		'Niue' => {
			long => {
				'standard' => q(Amser Niue),
			},
		},
		'Norfolk' => {
			long => {
				'standard' => q(Amser Ynys Norfolk),
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q(Amser Haf Fernando de Noronha),
				'generic' => q(Amser Fernando de Noronha),
				'standard' => q(Amser Safonol Fernando de Noronha),
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q(Amser Haf Novosibirsk),
				'generic' => q(Amser Novosibirsk),
				'standard' => q(Amser Safonol Novosibirsk),
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q(Amser Haf Omsk),
				'generic' => q(Amser Omsk),
				'standard' => q(Amser Safonol Omsk),
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#Apia#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#Auckland#,
		},
		'Pacific/Bougainville' => {
			exemplarCity => q#Bougainville#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#Chatham#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#Ynys y Pasg#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#Efate#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#Enderbury#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#Fakaofo#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#Fiji#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#Funafuti#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#Galapagos#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#Gambier#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#Guadalcanal#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#Guam#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#Honolulu#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#Johnston#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#Kiritimati#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#Kosrae#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#Kwajalein#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#Majuro#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#Marquesas#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#Midway#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#Nauru#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#Niue#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#Norfolk#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#Noumea#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#Pago Pago#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#Palau#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#Pitcairn#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#Pohnpei#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#Port Moresby#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#Rarotonga#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#Saipan#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#Tahiti#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#Tarawa#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#Tongatapu#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#Chuuk#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#Wake#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#Wallis#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q(Amser Haf Pakistan),
				'generic' => q(Amser Pakistan),
				'standard' => q(Amser Safonol Pakistan),
			},
		},
		'Palau' => {
			long => {
				'standard' => q(Amser Palau),
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q(Amser Papua Guinea Newydd),
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q(Amser Haf Paraguay),
				'generic' => q(Amser Paraguay),
				'standard' => q(Amser Safonol Paraguay),
			},
		},
		'Peru' => {
			long => {
				'daylight' => q(Amser Haf Periw),
				'generic' => q(Amser Periw),
				'standard' => q(Amser Safonol Periw),
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q(Amser Haf Pilipinas),
				'generic' => q(Amser Pilipinas),
				'standard' => q(Amser Safonol Pilipinas),
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q(Amser Ynysoedd Phoenix),
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q(Amser Haf Saint-Pierre-et-Miquelon),
				'generic' => q(Amser Saint-Pierre-et-Miquelon),
				'standard' => q(Amser Safonol Saint-Pierre-et-Miquelon),
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q(Amser Pitcairn),
			},
		},
		'Ponape' => {
			long => {
				'standard' => q(Amser Pohnpei),
			},
		},
		'Reunion' => {
			long => {
				'standard' => q(Amser Réunion),
			},
		},
		'Rothera' => {
			long => {
				'standard' => q(Amser Rothera),
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q(Amser Haf Sakhalin),
				'generic' => q(Amser Sakhalin),
				'standard' => q(Amser Safonol Sakhalin),
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q(Amser Haf Samoa),
				'generic' => q(Amser Samoa),
				'standard' => q(Amser Safonol Samoa),
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q(Amser Seychelles),
			},
		},
		'Singapore' => {
			long => {
				'standard' => q(Amser Singapore),
			},
		},
		'Solomon' => {
			long => {
				'standard' => q(Amser Ynysoedd Solomon),
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q(Amser De Georgia),
			},
		},
		'Suriname' => {
			long => {
				'standard' => q(Amser Suriname),
			},
		},
		'Syowa' => {
			long => {
				'standard' => q(Amser Syowa),
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q(Amser Tahiti),
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q(Amser Haf Taipei),
				'generic' => q(Amser Taipei),
				'standard' => q(Amser Safonol Taipei),
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q(Amser Tajicistan),
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q(Amser Tokelau),
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q(Amser Haf Tonga),
				'generic' => q(Amser Tonga),
				'standard' => q(Amser Safonol Tonga),
			},
		},
		'Truk' => {
			long => {
				'standard' => q(Amser Chuuk),
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q(Amser Haf Tyrcmenistan),
				'generic' => q(Amser Tyrcmenistan),
				'standard' => q(Amser Safonol Tyrcmenistan),
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q(Amser Tuvalu),
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q(Amser Haf Uruguay),
				'generic' => q(Amser Uruguay),
				'standard' => q(Amser Safonol Uruguay),
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q(Amser Haf Wsbecistan),
				'generic' => q(Amser Wsbecistan),
				'standard' => q(Amser Safonol Wsbecistan),
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q(Amser Haf Vanuatu),
				'generic' => q(Amser Vanuatu),
				'standard' => q(Amser Safonol Vanuatu),
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q(Amser Venezuela),
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q(Amser Haf Vladivostok),
				'generic' => q(Amser Vladivostok),
				'standard' => q(Amser Safonol Vladivostok),
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q(Amser Haf Volgograd),
				'generic' => q(Amser Volgograd),
				'standard' => q(Amser Safonol Volgograd),
			},
		},
		'Vostok' => {
			long => {
				'standard' => q(Amser Vostok),
			},
		},
		'Wake' => {
			long => {
				'standard' => q(Amser Ynys Wake),
			},
		},
		'Wallis' => {
			long => {
				'standard' => q(Amser Wallis a Futuna),
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q(Amser Haf Yakutsk),
				'generic' => q(Amser Yakutsk),
				'standard' => q(Amser Safonol Yakutsk),
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q(Amser Haf Yekaterinburg),
				'generic' => q(Amser Yekaterinburg),
				'standard' => q(Amser Safonol Yekaterinburg),
			},
		},
	 } }
);
no Moose;
__PACKAGE__->meta->make_immutable;

1;

# vim: tabstop=4
