%{
#include "io.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <utils/matrix_reader.h>
#include <utils/real.h>

int matrixlex();
int matrixparse();
int matrixerror(char *s);

matrix_reader *me = 0;
%}

%union {
    double dval;
    int    ival;
}

%token MatrixStart MatrixEnd VectorStart VectorEnd ON OFF Comma
%token <dval> REAL
%token <ival> INT 

%left Comma
%%

matricies: matrix | matricies matrix;
vectors:   vector | vectors   vector;

matrix:  ms vectors me;
vector:  vs bits    ve 
      |  vs numbers ve;

bits:      bit    | bits       bit;
numbers:   number | numbers co number;

// All terminals in rules below this line:

bit:       ON       { me->add_element_to_current_matrix(1.0); } 
   |       OFF      { me->add_element_to_current_matrix(0.0); } ;

number:    INT      { me->add_element_to_current_matrix((real)$1); } ;
      |    REAL     { me->add_element_to_current_matrix(      $1); } ;

vs:    VectorStart  { me->start_new_row_in_current_matrix();  } ;
ve:    VectorEnd;
ms:    MatrixStart  { me->start_new_matrix(); } ;
me:    MatrixEnd;
co:    Comma;

%%

matrix_node::matrix_node() {
    my_matrix = new matrix;
    next      = 0;
}

matrix_reader::matrix_reader(char *filename) {
    size = 0;
    head = 0;
    me   = this;

    if(!jopen(filename)) {
        exit(1);
    }
    yyparse();
}

void matrix_reader::start_new_matrix() {
    if(!head) {
        head = new matrix_node;
        current_matrix_node = head;
    } else {
        current_matrix_node->next = new matrix_node;
        current_matrix_node = current_matrix_node->next;
    }
    size++;
}

void matrix_reader::add_element_to_current_matrix(real v) {
    current_matrix_node->my_matrix->add_element(v);
}

void matrix_reader::start_new_row_in_current_matrix() {
    current_matrix_node->my_matrix->start_new_row();
}

void matrix_reader::start_foreach() {
    current_matrix_node = head;
}

void matrix_reader::next_matrix() {
    current_matrix_node = current_matrix_node->next;
}

int matrix_reader::has_a_matrix() {
    return (current_matrix_node) ? 1:0;
}

int matrix_reader::has_a_next_matrix() {
    return (current_matrix_node->next) ? 1:0;
}

real *matrix_reader::query_current_matrix_as_vector() {
    return current_matrix_node->my_matrix->query_matrix_as_vector();
}

real **matrix_reader::query_current_matrix_as_matrix() {
    return current_matrix_node->my_matrix->query_matrix_as_matrix();
}

void matrix_reader::show_current_matrix_graphically() {
    return current_matrix_node->my_matrix->show_matrix_graphically();
}

int matrix_reader::query_size() {
    return size;
}

int matrix_reader::query_current_matrix_rows() {
    return current_matrix_node->my_matrix->query_rows();
}

int matrix_reader::query_current_matrix_cols() {
    return current_matrix_node->my_matrix->query_cols();
}

int matrix_reader::query_current_matrix_size() {
    return current_matrix_node->my_matrix->query_size();
}
