#ifndef NEURON_H
#define NEURON_H

#include <arch/synaptic_group.h>
#include <arch/layer.h>
#include <utils/real.h>

class synaptic_group;
class layer_node;
class layer;

class neuron {
    private:
      layer_node  *my_layer_node;
         int       is_biased;
         int       input_same;
         int       output_same;
         int       output_dot_same;
        char       name[255];
        real       my_output;
        real       my_output_dot;
        real       my_input;
        real       my_delta;
        int        transfer_type;
        void       connect_to(neuron *n);
        void       recalc_input();
        void       recalc_output();
        void       recalc_output_dot();

        // These need friends:
        void       recalc_needed();
        void    set_is_in_layer_node(layer_node *l);

        // These are the friends:
        friend void synaptic_group::set_current_weight_to(real d);
        friend void synaptic_group::change_current_weight_by(real d);
        friend void synaptic_group::recalc_needed_upward();
        friend layer_node::layer_node(layer_node *p, char name[20], int number);

    public:
        synaptic_group *dendrites;
        synaptic_group *axon_fires_at;

                  neuron(char n[20]);
        void      dendrites_touch(int n, ...);
        void      dendrites_touch(layer *l);
        char     *query_name();
        real      query_input();
        real      query_output();
        real      query_output_dot();
        void      set_transfer_function(int type);
        void      set_input(real);
        void      set_input_as_bias(real);
        void      set_delta(real d);
        real      query_delta();
        //void      recalc_needed();
        int       query_biased();

        neuron *query_left_neighbor();
        neuron *query_right_neighbor();
        neuron *query_above_neighbor();
        neuron *query_below_neighbor();

        void    save_weights(FILE *F);
        void restore_weights(FILE *F);
};

#endif
