/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.utils;

import com.javonet.sdk.java.Javonet;
import com.javonet.utils.RuntimeName;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.Locale;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public class BinariesUnloader {
    public static void extractBinariesFromJar(RuntimeName runtimeName) {
        block28: {
            if (BinariesUnloader.isAndroid()) {
                return;
            }
            try {
                String dir = BinariesUnloader.getJarPath(Javonet.class);
                String destDir = System.getProperty("user.dir");
                String binariesJvmPath = BinariesUnloader.getBinariesSpecificPath(runtimeName.toString());
                Path binariesPath = Paths.get(destDir, binariesJvmPath);
                String currentVersion = BinariesUnloader.getManifestProperty("Version");
                if (Files.isDirectory(Paths.get(binariesJvmPath, new String[0]), new LinkOption[0]) && !BinariesUnloader.shouldUpdateBinaries(binariesPath, currentVersion)) break block28;
                if (dir.contains("!")) {
                    try (JarInputStream jarStream = BinariesUnloader.getJarInputStream(dir);){
                        BinariesUnloader.extractFolderFromJar(jarStream, destDir, binariesJvmPath);
                        break block28;
                    }
                }
                try (JarFile jarFile = new JarFile(dir);){
                    BinariesUnloader.extractFolderFromJar(jarFile, destDir, binariesJvmPath);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void extractNativeFromJar() {
        block28: {
            if (BinariesUnloader.isAndroid()) {
                return;
            }
            try {
                String dir = BinariesUnloader.getJarPath(Javonet.class);
                String destDir = System.getProperty("user.dir");
                String binariesNativePath = BinariesUnloader.getBinariesSpecificPath("Native");
                Path binariesPath = Paths.get(destDir, binariesNativePath);
                String currentVersion = BinariesUnloader.getManifestProperty("Version");
                if (Files.isDirectory(Paths.get(binariesNativePath, new String[0]), new LinkOption[0]) && !BinariesUnloader.shouldUpdateBinaries(binariesPath, currentVersion)) break block28;
                if (dir.contains("!")) {
                    try (JarInputStream jarStream = BinariesUnloader.getJarInputStream(dir);){
                        BinariesUnloader.extractFolderFromJar(jarStream, destDir, binariesNativePath);
                        break block28;
                    }
                }
                try (JarFile jarFile = new JarFile(dir);){
                    BinariesUnloader.extractFolderFromJar(jarFile, destDir, binariesNativePath);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static JarInputStream getJarInputStream(String jarFilePath) throws IOException {
        URL jarUrl = new URL(jarFilePath);
        JarURLConnection jarConnection = (JarURLConnection)jarUrl.openConnection();
        return new JarInputStream(jarConnection.getInputStream());
    }

    private static void extractFolderFromJar(Object jar, String destDir, String folderPath) throws IOException {
        if (jar instanceof JarFile) {
            JarFile jarFile = (JarFile)jar;
            Enumeration<JarEntry> enumEntries = jarFile.entries();
            while (enumEntries.hasMoreElements()) {
                JarEntry file = enumEntries.nextElement();
                BinariesUnloader.extractFileFromJarEntry(jarFile, file, destDir, folderPath);
            }
        } else {
            JarEntry entry;
            JarInputStream jarStream = (JarInputStream)jar;
            while ((entry = jarStream.getNextJarEntry()) != null) {
                BinariesUnloader.extractFileFromJarEntry(jarStream, entry, destDir, folderPath);
            }
        }
    }

    private static void extractFileFromJarEntry(Object jar, JarEntry file, String destDir, String folderPath) throws IOException {
        File f = new File(destDir + File.separator + file.getName());
        if (file.isDirectory() && file.getName().startsWith(folderPath)) {
            f.mkdirs();
            return;
        }
        if (file.getName().startsWith(folderPath)) {
            InputStream in = jar instanceof JarFile ? ((JarFile)jar).getInputStream(file) : (JarInputStream)jar;
            try (FileOutputStream out = new FileOutputStream(f);){
                int len;
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
            }
        }
    }

    private static String getBinariesSpecificPath(String runtimeLib) {
        String osArch = "X64";
        String binariesPath = System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("win") ? "Binaries/" + runtimeLib + "/Windows/" + osArch + "/" : (System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("mac") ? "Binaries/" + runtimeLib + "/MacOs/" + osArch + "/" : "Binaries/" + runtimeLib + "/Linux/" + osArch + "/");
        return binariesPath;
    }

    private static boolean isAndroid() {
        return System.getProperty("os.version").toLowerCase(Locale.US).contains("android");
    }

    private static String getJarPath(Class<?> aclass) {
        String suffix;
        URL url;
        try {
            url = aclass.getProtectionDomain().getCodeSource().getLocation();
        }
        catch (SecurityException ex) {
            url = aclass.getResource(aclass.getSimpleName() + ".class");
        }
        String extURL = url.toExternalForm();
        if (extURL.contains(".jar!")) {
            return extURL;
        }
        if (!extURL.endsWith(".jar") && (extURL = extURL.replace(suffix = "/" + aclass.getName().replace(".", "/") + ".class", "")).startsWith("jar:") && extURL.endsWith(".jar!")) {
            extURL = extURL.substring(4);
        }
        try {
            return new File(new URL(extURL).toURI()).getAbsolutePath();
        }
        catch (MalformedURLException | URISyntaxException ex) {
            return new File(url.getPath()).getAbsolutePath();
        }
    }

    private static String getManifestProperty(String propertyName) throws IOException {
        Enumeration<URL> resources = BinariesUnloader.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
        while (resources.hasMoreElements()) {
            InputStream input = resources.nextElement().openStream();
            Throwable throwable = null;
            try {
                Manifest manifest = new Manifest(input);
                Attributes mainAttributes = manifest.getMainAttributes();
                String value = mainAttributes.getValue(propertyName);
                if (value == null) continue;
                String string = value;
                return string;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (input == null) continue;
                if (throwable != null) {
                    try {
                        input.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                input.close();
            }
        }
        return null;
    }

    private static boolean shouldUpdateBinaries(Path binariesPath, String currentVersion) throws IOException {
        Path versionFile = Paths.get(binariesPath.toString(), "version.txt");
        if (Files.exists(versionFile, new LinkOption[0])) {
            String oldVersion = new String(Files.readAllBytes(versionFile), StandardCharsets.UTF_8);
            return !(oldVersion = oldVersion.replace("'", "")).equals(currentVersion);
        }
        return true;
    }
}

