#############################################################
# This file was automatically generated on 2021-01-15.      #
#                                                           #
# Perl Bindings Version 2.1.29                              #
#                                                           #
# If you have a bugfix for this file and want to commit it, #
# please fix the bug in the generator. You can find a link  #
# to the generators git repository on tinkerforge.com       #
#############################################################

=pod

=encoding utf8

=head1 NAME

Tinkerforge::BrickDC - Drives one brushed DC motor with up to 28V and 5A (peak)

=cut

package Tinkerforge::BrickDC;

use strict;
use warnings;
use Carp;
use threads;
use threads::shared;
use parent 'Tinkerforge::Device';
use Tinkerforge::IPConnection;
use Tinkerforge::Error;

=head1 CONSTANTS

=over

=item DEVICE_IDENTIFIER

This constant is used to identify a DC Brick.

The get_identity() subroutine and the CALLBACK_ENUMERATE callback of the
IP Connection have a device_identifier parameter to specify the Brick's or
Bricklet's type.

=cut

use constant DEVICE_IDENTIFIER => 11;

=item DEVICE_DISPLAY_NAME

This constant represents the display name of a DC Brick.

=cut

use constant DEVICE_DISPLAY_NAME => 'DC Brick';

=item CALLBACK_UNDER_VOLTAGE

This constant is used with the register_callback() subroutine to specify
the CALLBACK_UNDER_VOLTAGE callback.

=cut

use constant CALLBACK_UNDER_VOLTAGE => 21;

=item CALLBACK_EMERGENCY_SHUTDOWN

This constant is used with the register_callback() subroutine to specify
the CALLBACK_EMERGENCY_SHUTDOWN callback.

=cut

use constant CALLBACK_EMERGENCY_SHUTDOWN => 22;

=item CALLBACK_VELOCITY_REACHED

This constant is used with the register_callback() subroutine to specify
the CALLBACK_VELOCITY_REACHED callback.

=cut

use constant CALLBACK_VELOCITY_REACHED => 23;

=item CALLBACK_CURRENT_VELOCITY

This constant is used with the register_callback() subroutine to specify
the CALLBACK_CURRENT_VELOCITY callback.

=cut

use constant CALLBACK_CURRENT_VELOCITY => 24;

=item FUNCTION_SET_VELOCITY

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_VELOCITY => 1;

=item FUNCTION_GET_VELOCITY

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_VELOCITY => 2;

=item FUNCTION_GET_CURRENT_VELOCITY

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_CURRENT_VELOCITY => 3;

=item FUNCTION_SET_ACCELERATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_ACCELERATION => 4;

=item FUNCTION_GET_ACCELERATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_ACCELERATION => 5;

=item FUNCTION_SET_PWM_FREQUENCY

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_PWM_FREQUENCY => 6;

=item FUNCTION_GET_PWM_FREQUENCY

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_PWM_FREQUENCY => 7;

=item FUNCTION_FULL_BRAKE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_FULL_BRAKE => 8;

=item FUNCTION_GET_STACK_INPUT_VOLTAGE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_STACK_INPUT_VOLTAGE => 9;

=item FUNCTION_GET_EXTERNAL_INPUT_VOLTAGE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_EXTERNAL_INPUT_VOLTAGE => 10;

=item FUNCTION_GET_CURRENT_CONSUMPTION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_CURRENT_CONSUMPTION => 11;

=item FUNCTION_ENABLE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_ENABLE => 12;

=item FUNCTION_DISABLE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_DISABLE => 13;

=item FUNCTION_IS_ENABLED

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_IS_ENABLED => 14;

=item FUNCTION_SET_MINIMUM_VOLTAGE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_MINIMUM_VOLTAGE => 15;

=item FUNCTION_GET_MINIMUM_VOLTAGE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_MINIMUM_VOLTAGE => 16;

=item FUNCTION_SET_DRIVE_MODE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_DRIVE_MODE => 17;

=item FUNCTION_GET_DRIVE_MODE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_DRIVE_MODE => 18;

=item FUNCTION_SET_CURRENT_VELOCITY_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_CURRENT_VELOCITY_PERIOD => 19;

=item FUNCTION_GET_CURRENT_VELOCITY_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_CURRENT_VELOCITY_PERIOD => 20;

=item FUNCTION_SET_SPITFP_BAUDRATE_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_SPITFP_BAUDRATE_CONFIG => 231;

=item FUNCTION_GET_SPITFP_BAUDRATE_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_SPITFP_BAUDRATE_CONFIG => 232;

=item FUNCTION_GET_SEND_TIMEOUT_COUNT

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_SEND_TIMEOUT_COUNT => 233;

=item FUNCTION_SET_SPITFP_BAUDRATE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_SPITFP_BAUDRATE => 234;

=item FUNCTION_GET_SPITFP_BAUDRATE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_SPITFP_BAUDRATE => 235;

=item FUNCTION_GET_SPITFP_ERROR_COUNT

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_SPITFP_ERROR_COUNT => 237;

=item FUNCTION_ENABLE_STATUS_LED

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_ENABLE_STATUS_LED => 238;

=item FUNCTION_DISABLE_STATUS_LED

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_DISABLE_STATUS_LED => 239;

=item FUNCTION_IS_STATUS_LED_ENABLED

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_IS_STATUS_LED_ENABLED => 240;

=item FUNCTION_GET_PROTOCOL1_BRICKLET_NAME

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_PROTOCOL1_BRICKLET_NAME => 241;

=item FUNCTION_GET_CHIP_TEMPERATURE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_CHIP_TEMPERATURE => 242;

=item FUNCTION_RESET

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_RESET => 243;

=item FUNCTION_WRITE_BRICKLET_PLUGIN

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_WRITE_BRICKLET_PLUGIN => 246;

=item FUNCTION_READ_BRICKLET_PLUGIN

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_READ_BRICKLET_PLUGIN => 247;

=item FUNCTION_GET_IDENTITY

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_IDENTITY => 255;
use constant DRIVE_MODE_DRIVE_BRAKE => 0;
use constant DRIVE_MODE_DRIVE_COAST => 1;
use constant COMMUNICATION_METHOD_NONE => 0;
use constant COMMUNICATION_METHOD_USB => 1;
use constant COMMUNICATION_METHOD_SPI_STACK => 2;
use constant COMMUNICATION_METHOD_CHIBI => 3;
use constant COMMUNICATION_METHOD_RS485 => 4;
use constant COMMUNICATION_METHOD_WIFI => 5;
use constant COMMUNICATION_METHOD_ETHERNET => 6;
use constant COMMUNICATION_METHOD_WIFI_V2 => 7;


=back

=head1 FUNCTIONS

=over

=item new()

Creates an object with the unique device ID *uid* and adds it to
the IP Connection *ipcon*.

=cut

sub new
{
	my ($class, $uid, $ipcon) = @_;

	my $self = Tinkerforge::Device->_new($uid, $ipcon, [2, 0, 3], &DEVICE_IDENTIFIER, &DEVICE_DISPLAY_NAME);

	$self->{response_expected}->{&FUNCTION_SET_VELOCITY} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_VELOCITY} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_CURRENT_VELOCITY} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_ACCELERATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_ACCELERATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_PWM_FREQUENCY} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_PWM_FREQUENCY} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_FULL_BRAKE} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_STACK_INPUT_VOLTAGE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_EXTERNAL_INPUT_VOLTAGE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_CURRENT_CONSUMPTION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_ENABLE} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_DISABLE} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_IS_ENABLED} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_MINIMUM_VOLTAGE} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_MINIMUM_VOLTAGE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_DRIVE_MODE} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_DRIVE_MODE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_CURRENT_VELOCITY_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_CURRENT_VELOCITY_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_SPITFP_BAUDRATE_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_SPITFP_BAUDRATE_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_SEND_TIMEOUT_COUNT} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_SPITFP_BAUDRATE} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_SPITFP_BAUDRATE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_SPITFP_ERROR_COUNT} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_ENABLE_STATUS_LED} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_DISABLE_STATUS_LED} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_IS_STATUS_LED_ENABLED} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_PROTOCOL1_BRICKLET_NAME} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_CHIP_TEMPERATURE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_RESET} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_WRITE_BRICKLET_PLUGIN} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_READ_BRICKLET_PLUGIN} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_IDENTITY} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;

	$self->{callback_formats}->{&CALLBACK_UNDER_VOLTAGE} = shared_clone([10, 'S']);
	$self->{callback_formats}->{&CALLBACK_EMERGENCY_SHUTDOWN} = shared_clone([8, '']);
	$self->{callback_formats}->{&CALLBACK_VELOCITY_REACHED} = shared_clone([10, 's']);
	$self->{callback_formats}->{&CALLBACK_CURRENT_VELOCITY} = shared_clone([10, 's']);



	bless($self, $class);

	$ipcon->_add_device($self);

	return $self;
}


=item set_velocity()

Sets the velocity of the motor. Whereas -32767 is full speed backward,
0 is stop and 32767 is full speed forward. Depending on the
acceleration (see :func:`Set Acceleration`), the motor is not immediately
brought to the velocity but smoothly accelerated.

The velocity describes the duty cycle of the PWM with which the motor is
controlled, e.g. a velocity of 3277 sets a PWM with a 10% duty cycle.
You can not only control the duty cycle of the PWM but also the frequency,
see :func:`Set PWM Frequency`.

=cut

sub set_velocity
{
	my ($self, $velocity) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_VELOCITY, [$velocity], 's', 0, '');
}

=item get_velocity()

Returns the velocity as set by :func:`Set Velocity`.

=cut

sub get_velocity
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_VELOCITY, [], '', 10, 's');
}

=item get_current_velocity()

Returns the *current* velocity of the motor. This value is different
from :func:`Get Velocity` whenever the motor is currently accelerating
to a goal set by :func:`Set Velocity`.

=cut

sub get_current_velocity
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_CURRENT_VELOCITY, [], '', 10, 's');
}

=item set_acceleration()

Sets the acceleration of the motor. It is given in *velocity/s*. An
acceleration of 10000 means, that every second the velocity is increased
by 10000 (or about 30% duty cycle).

For example: If the current velocity is 0 and you want to accelerate to a
velocity of 16000 (about 50% duty cycle) in 10 seconds, you should set
an acceleration of 1600.

If acceleration is set to 0, there is no speed ramping, i.e. a new velocity
is immediately given to the motor.

=cut

sub set_acceleration
{
	my ($self, $acceleration) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_ACCELERATION, [$acceleration], 'S', 0, '');
}

=item get_acceleration()

Returns the acceleration as set by :func:`Set Acceleration`.

=cut

sub get_acceleration
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_ACCELERATION, [], '', 10, 'S');
}

=item set_pwm_frequency()

Sets the frequency of the PWM with which the motor is driven.
Often a high frequency
is less noisy and the motor runs smoother. However, with a low frequency
there are less switches and therefore fewer switching losses. Also with
most motors lower frequencies enable higher torque.

If you have no idea what all this means, just ignore this function and use
the default frequency, it will very likely work fine.

=cut

sub set_pwm_frequency
{
	my ($self, $frequency) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_PWM_FREQUENCY, [$frequency], 'S', 0, '');
}

=item get_pwm_frequency()

Returns the PWM frequency as set by :func:`Set PWM Frequency`.

=cut

sub get_pwm_frequency
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_PWM_FREQUENCY, [], '', 10, 'S');
}

=item full_brake()

Executes an active full brake.

.. warning::
 This function is for emergency purposes,
 where an immediate brake is necessary. Depending on the current velocity and
 the strength of the motor, a full brake can be quite violent.

Call :func:`Set Velocity` with 0 if you just want to stop the motor.

=cut

sub full_brake
{
	my ($self) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_FULL_BRAKE, [], '', 0, '');
}

=item get_stack_input_voltage()

Returns the stack input voltage. The stack input voltage is the
voltage that is supplied via the stack, i.e. it is given by a
Step-Down or Step-Up Power Supply.

=cut

sub get_stack_input_voltage
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_STACK_INPUT_VOLTAGE, [], '', 10, 'S');
}

=item get_external_input_voltage()

Returns the external input voltage. The external input voltage is
given via the black power input connector on the DC Brick.

If there is an external input voltage and a stack input voltage, the motor
will be driven by the external input voltage. If there is only a stack
voltage present, the motor will be driven by this voltage.

.. warning::
 This means, if you have a high stack voltage and a low external voltage,
 the motor will be driven with the low external voltage. If you then remove
 the external connection, it will immediately be driven by the high
 stack voltage.

=cut

sub get_external_input_voltage
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_EXTERNAL_INPUT_VOLTAGE, [], '', 10, 'S');
}

=item get_current_consumption()

Returns the current consumption of the motor.

=cut

sub get_current_consumption
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_CURRENT_CONSUMPTION, [], '', 10, 'S');
}

=item enable()

Enables the driver chip. The driver parameters can be configured (velocity,
acceleration, etc) before it is enabled.

=cut

sub enable
{
	my ($self) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_ENABLE, [], '', 0, '');
}

=item disable()

Disables the driver chip. The configurations are kept (velocity,
acceleration, etc) but the motor is not driven until it is enabled again.

.. warning::
 Disabling the driver chip while the motor is still turning can damage the
 driver chip. The motor should be stopped calling :func:`Set Velocity` with 0
 before disabling the motor power. The :func:`Set Velocity` function will **not**
 wait until the motor is actually stopped. You have to explicitly wait for the
 appropriate time after calling the :func:`Set Velocity` function before calling
 the :func:`Disable` function.

=cut

sub disable
{
	my ($self) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_DISABLE, [], '', 0, '');
}

=item is_enabled()

Returns *true* if the driver chip is enabled, *false* otherwise.

=cut

sub is_enabled
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_IS_ENABLED, [], '', 9, '?');
}

=item set_minimum_voltage()

Sets the minimum voltage, below which the :cb:`Under Voltage` callback
is triggered. The minimum possible value that works with the DC Brick is 6V.
You can use this function to detect the discharge of a battery that is used
to drive the motor. If you have a fixed power supply, you likely do not need
this functionality.

=cut

sub set_minimum_voltage
{
	my ($self, $voltage) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_MINIMUM_VOLTAGE, [$voltage], 'S', 0, '');
}

=item get_minimum_voltage()

Returns the minimum voltage as set by :func:`Set Minimum Voltage`

=cut

sub get_minimum_voltage
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_MINIMUM_VOLTAGE, [], '', 10, 'S');
}

=item set_drive_mode()

Sets the drive mode. Possible modes are:

* 0 = Drive/Brake
* 1 = Drive/Coast

These modes are different kinds of motor controls.

In Drive/Brake mode, the motor is always either driving or braking. There
is no freewheeling. Advantages are: A more linear correlation between
PWM and velocity, more exact accelerations and the possibility to drive
with slower velocities.

In Drive/Coast mode, the motor is always either driving or freewheeling.
Advantages are: Less current consumption and less demands on the motor and
driver chip.

=cut

sub set_drive_mode
{
	my ($self, $mode) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_DRIVE_MODE, [$mode], 'C', 0, '');
}

=item get_drive_mode()

Returns the drive mode, as set by :func:`Set Drive Mode`.

=cut

sub get_drive_mode
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_DRIVE_MODE, [], '', 9, 'C');
}

=item set_current_velocity_period()

Sets a period with which the :cb:`Current Velocity` callback is triggered.
A period of 0 turns the callback off.

=cut

sub set_current_velocity_period
{
	my ($self, $period) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_CURRENT_VELOCITY_PERIOD, [$period], 'S', 0, '');
}

=item get_current_velocity_period()

Returns the period as set by :func:`Set Current Velocity Period`.

=cut

sub get_current_velocity_period
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_CURRENT_VELOCITY_PERIOD, [], '', 10, 'S');
}

=item set_spitfp_baudrate_config()

The SPITF protocol can be used with a dynamic baudrate. If the dynamic baudrate is
enabled, the Brick will try to adapt the baudrate for the communication
between Bricks and Bricklets according to the amount of data that is transferred.

The baudrate will be increased exponentially if lots of data is sent/received and
decreased linearly if little data is sent/received.

This lowers the baudrate in applications where little data is transferred (e.g.
a weather station) and increases the robustness. If there is lots of data to transfer
(e.g. Thermal Imaging Bricklet) it automatically increases the baudrate as needed.

In cases where some data has to transferred as fast as possible every few seconds
(e.g. RS485 Bricklet with a high baudrate but small payload) you may want to turn
the dynamic baudrate off to get the highest possible performance.

The maximum value of the baudrate can be set per port with the function
:func:`Set SPITFP Baudrate`. If the dynamic baudrate is disabled, the baudrate
as set by :func:`Set SPITFP Baudrate` will be used statically.

.. versionadded:: 2.3.5$nbsp;(Firmware)

=cut

sub set_spitfp_baudrate_config
{
	my ($self, $enable_dynamic_baudrate, $minimum_dynamic_baudrate) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_SPITFP_BAUDRATE_CONFIG, [$enable_dynamic_baudrate, $minimum_dynamic_baudrate], '? L', 0, '');
}

=item get_spitfp_baudrate_config()

Returns the baudrate config, see :func:`Set SPITFP Baudrate Config`.

.. versionadded:: 2.3.5$nbsp;(Firmware)

=cut

sub get_spitfp_baudrate_config
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_SPITFP_BAUDRATE_CONFIG, [], '', 13, '? L');
}

=item get_send_timeout_count()

Returns the timeout count for the different communication methods.

The methods 0-2 are available for all Bricks, 3-7 only for Master Bricks.

This function is mostly used for debugging during development, in normal operation
the counters should nearly always stay at 0.

.. versionadded:: 2.3.3$nbsp;(Firmware)

=cut

sub get_send_timeout_count
{
	my ($self, $communication_method) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_SEND_TIMEOUT_COUNT, [$communication_method], 'C', 12, 'L');
}

=item set_spitfp_baudrate()

Sets the baudrate for a specific Bricklet port.

If you want to increase the throughput of Bricklets you can increase
the baudrate. If you get a high error count because of high
interference (see :func:`Get SPITFP Error Count`) you can decrease the
baudrate.

If the dynamic baudrate feature is enabled, the baudrate set by this
function corresponds to the maximum baudrate (see :func:`Set SPITFP Baudrate Config`).

Regulatory testing is done with the default baudrate. If CE compatibility
or similar is necessary in your applications we recommend to not change
the baudrate.

.. versionadded:: 2.3.3$nbsp;(Firmware)

=cut

sub set_spitfp_baudrate
{
	my ($self, $bricklet_port, $baudrate) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_SPITFP_BAUDRATE, [$bricklet_port, $baudrate], 'a L', 0, '');
}

=item get_spitfp_baudrate()

Returns the baudrate for a given Bricklet port, see :func:`Set SPITFP Baudrate`.

.. versionadded:: 2.3.3$nbsp;(Firmware)

=cut

sub get_spitfp_baudrate
{
	my ($self, $bricklet_port) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_SPITFP_BAUDRATE, [$bricklet_port], 'a', 12, 'L');
}

=item get_spitfp_error_count()

Returns the error count for the communication between Brick and Bricklet.

The errors are divided into

* ACK checksum errors,
* message checksum errors,
* framing errors and
* overflow errors.

The errors counts are for errors that occur on the Brick side. All
Bricklets have a similar function that returns the errors on the Bricklet side.

.. versionadded:: 2.3.3$nbsp;(Firmware)

=cut

sub get_spitfp_error_count
{
	my ($self, $bricklet_port) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_SPITFP_ERROR_COUNT, [$bricklet_port], 'a', 24, 'L L L L');
}

=item enable_status_led()

Enables the status LED.

The status LED is the blue LED next to the USB connector. If enabled is is
on and it flickers if data is transfered. If disabled it is always off.

The default state is enabled.

.. versionadded:: 2.3.1$nbsp;(Firmware)

=cut

sub enable_status_led
{
	my ($self) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_ENABLE_STATUS_LED, [], '', 0, '');
}

=item disable_status_led()

Disables the status LED.

The status LED is the blue LED next to the USB connector. If enabled is is
on and it flickers if data is transfered. If disabled it is always off.

The default state is enabled.

.. versionadded:: 2.3.1$nbsp;(Firmware)

=cut

sub disable_status_led
{
	my ($self) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_DISABLE_STATUS_LED, [], '', 0, '');
}

=item is_status_led_enabled()

Returns *true* if the status LED is enabled, *false* otherwise.

.. versionadded:: 2.3.1$nbsp;(Firmware)

=cut

sub is_status_led_enabled
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_IS_STATUS_LED_ENABLED, [], '', 9, '?');
}

=item get_protocol1_bricklet_name()

Returns the firmware and protocol version and the name of the Bricklet for a
given port.

This functions sole purpose is to allow automatic flashing of v1.x.y Bricklet
plugins.

=cut

sub get_protocol1_bricklet_name
{
	my ($self, $port) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_PROTOCOL1_BRICKLET_NAME, [$port], 'a', 52, 'C C3 Z40');
}

=item get_chip_temperature()

Returns the temperature as measured inside the microcontroller. The
value returned is not the ambient temperature!

The temperature is only proportional to the real temperature and it has an
accuracy of ±15%. Practically it is only useful as an indicator for
temperature changes.

=cut

sub get_chip_temperature
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_CHIP_TEMPERATURE, [], '', 10, 's');
}

=item reset()

Calling this function will reset the Brick. Calling this function
on a Brick inside of a stack will reset the whole stack.

After a reset you have to create new device objects,
calling functions on the existing ones will result in
undefined behavior!

=cut

sub reset
{
	my ($self) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_RESET, [], '', 0, '');
}

=item write_bricklet_plugin()

Writes 32 bytes of firmware to the bricklet attached at the given port.
The bytes are written to the position offset * 32.

This function is used by Brick Viewer during flashing. It should not be
necessary to call it in a normal user program.

=cut

sub write_bricklet_plugin
{
	my ($self, $port, $offset, $chunk) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_WRITE_BRICKLET_PLUGIN, [$port, $offset, $chunk], 'a C C32', 0, '');
}

=item read_bricklet_plugin()

Reads 32 bytes of firmware from the bricklet attached at the given port.
The bytes are read starting at the position offset * 32.

This function is used by Brick Viewer during flashing. It should not be
necessary to call it in a normal user program.

=cut

sub read_bricklet_plugin
{
	my ($self, $port, $offset) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_READ_BRICKLET_PLUGIN, [$port, $offset], 'a C', 40, 'C32');
}

=item get_identity()

Returns the UID, the UID where the Brick is connected to,
the position, the hardware and firmware version as well as the
device identifier.

The position is the position in the stack from '0' (bottom) to '8' (top).

The device identifier numbers can be found :ref:`here <device_identifier>`.
|device_identifier_constant|

=cut

sub get_identity
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_IDENTITY, [], '', 33, 'Z8 Z8 a C3 C3 S');
}

=back
=cut

1;
