#############################################################
# This file was automatically generated on 2019-05-21.      #
#                                                           #
# Perl Bindings Version 2.1.22                              #
#                                                           #
# If you have a bugfix for this file and want to commit it, #
# please fix the bug in the generator. You can find a link  #
# to the generators git repository on tinkerforge.com       #
#############################################################

=pod

=encoding utf8

=head1 NAME

Tinkerforge::BrickIMUV2 - Full fledged AHRS with 9 degrees of freedom

=cut

package Tinkerforge::BrickIMUV2;

use strict;
use warnings;
use Carp;
use threads;
use threads::shared;
use parent 'Tinkerforge::Device';
use Tinkerforge::IPConnection;
use Tinkerforge::Error;

=head1 CONSTANTS

=over

=item DEVICE_IDENTIFIER

This constant is used to identify a IMU Brick 2.0.

The get_identity() subroutine and the CALLBACK_ENUMERATE callback of the
IP Connection have a device_identifier parameter to specify the Brick's or
Bricklet's type.

=cut

use constant DEVICE_IDENTIFIER => 18;

=item DEVICE_DISPLAY_NAME

This constant represents the display name of a IMU Brick 2.0.

=cut

use constant DEVICE_DISPLAY_NAME => 'IMU Brick 2.0';

=item CALLBACK_ACCELERATION

This constant is used with the register_callback() subroutine to specify
the CALLBACK_ACCELERATION callback.

=cut

use constant CALLBACK_ACCELERATION => 32;

=item CALLBACK_MAGNETIC_FIELD

This constant is used with the register_callback() subroutine to specify
the CALLBACK_MAGNETIC_FIELD callback.

=cut

use constant CALLBACK_MAGNETIC_FIELD => 33;

=item CALLBACK_ANGULAR_VELOCITY

This constant is used with the register_callback() subroutine to specify
the CALLBACK_ANGULAR_VELOCITY callback.

=cut

use constant CALLBACK_ANGULAR_VELOCITY => 34;

=item CALLBACK_TEMPERATURE

This constant is used with the register_callback() subroutine to specify
the CALLBACK_TEMPERATURE callback.

=cut

use constant CALLBACK_TEMPERATURE => 35;

=item CALLBACK_LINEAR_ACCELERATION

This constant is used with the register_callback() subroutine to specify
the CALLBACK_LINEAR_ACCELERATION callback.

=cut

use constant CALLBACK_LINEAR_ACCELERATION => 36;

=item CALLBACK_GRAVITY_VECTOR

This constant is used with the register_callback() subroutine to specify
the CALLBACK_GRAVITY_VECTOR callback.

=cut

use constant CALLBACK_GRAVITY_VECTOR => 37;

=item CALLBACK_ORIENTATION

This constant is used with the register_callback() subroutine to specify
the CALLBACK_ORIENTATION callback.

=cut

use constant CALLBACK_ORIENTATION => 38;

=item CALLBACK_QUATERNION

This constant is used with the register_callback() subroutine to specify
the CALLBACK_QUATERNION callback.

=cut

use constant CALLBACK_QUATERNION => 39;

=item CALLBACK_ALL_DATA

This constant is used with the register_callback() subroutine to specify
the CALLBACK_ALL_DATA callback.

=cut

use constant CALLBACK_ALL_DATA => 40;

=item FUNCTION_GET_ACCELERATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_ACCELERATION => 1;

=item FUNCTION_GET_MAGNETIC_FIELD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_MAGNETIC_FIELD => 2;

=item FUNCTION_GET_ANGULAR_VELOCITY

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_ANGULAR_VELOCITY => 3;

=item FUNCTION_GET_TEMPERATURE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_TEMPERATURE => 4;

=item FUNCTION_GET_ORIENTATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_ORIENTATION => 5;

=item FUNCTION_GET_LINEAR_ACCELERATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_LINEAR_ACCELERATION => 6;

=item FUNCTION_GET_GRAVITY_VECTOR

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_GRAVITY_VECTOR => 7;

=item FUNCTION_GET_QUATERNION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_QUATERNION => 8;

=item FUNCTION_GET_ALL_DATA

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_ALL_DATA => 9;

=item FUNCTION_LEDS_ON

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_LEDS_ON => 10;

=item FUNCTION_LEDS_OFF

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_LEDS_OFF => 11;

=item FUNCTION_ARE_LEDS_ON

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_ARE_LEDS_ON => 12;

=item FUNCTION_SAVE_CALIBRATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SAVE_CALIBRATION => 13;

=item FUNCTION_SET_ACCELERATION_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_ACCELERATION_PERIOD => 14;

=item FUNCTION_GET_ACCELERATION_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_ACCELERATION_PERIOD => 15;

=item FUNCTION_SET_MAGNETIC_FIELD_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_MAGNETIC_FIELD_PERIOD => 16;

=item FUNCTION_GET_MAGNETIC_FIELD_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_MAGNETIC_FIELD_PERIOD => 17;

=item FUNCTION_SET_ANGULAR_VELOCITY_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_ANGULAR_VELOCITY_PERIOD => 18;

=item FUNCTION_GET_ANGULAR_VELOCITY_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_ANGULAR_VELOCITY_PERIOD => 19;

=item FUNCTION_SET_TEMPERATURE_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_TEMPERATURE_PERIOD => 20;

=item FUNCTION_GET_TEMPERATURE_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_TEMPERATURE_PERIOD => 21;

=item FUNCTION_SET_ORIENTATION_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_ORIENTATION_PERIOD => 22;

=item FUNCTION_GET_ORIENTATION_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_ORIENTATION_PERIOD => 23;

=item FUNCTION_SET_LINEAR_ACCELERATION_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_LINEAR_ACCELERATION_PERIOD => 24;

=item FUNCTION_GET_LINEAR_ACCELERATION_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_LINEAR_ACCELERATION_PERIOD => 25;

=item FUNCTION_SET_GRAVITY_VECTOR_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_GRAVITY_VECTOR_PERIOD => 26;

=item FUNCTION_GET_GRAVITY_VECTOR_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_GRAVITY_VECTOR_PERIOD => 27;

=item FUNCTION_SET_QUATERNION_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_QUATERNION_PERIOD => 28;

=item FUNCTION_GET_QUATERNION_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_QUATERNION_PERIOD => 29;

=item FUNCTION_SET_ALL_DATA_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_ALL_DATA_PERIOD => 30;

=item FUNCTION_GET_ALL_DATA_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_ALL_DATA_PERIOD => 31;

=item FUNCTION_SET_SENSOR_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_SENSOR_CONFIGURATION => 41;

=item FUNCTION_GET_SENSOR_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_SENSOR_CONFIGURATION => 42;

=item FUNCTION_SET_SENSOR_FUSION_MODE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_SENSOR_FUSION_MODE => 43;

=item FUNCTION_GET_SENSOR_FUSION_MODE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_SENSOR_FUSION_MODE => 44;

=item FUNCTION_SET_SPITFP_BAUDRATE_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_SPITFP_BAUDRATE_CONFIG => 231;

=item FUNCTION_GET_SPITFP_BAUDRATE_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_SPITFP_BAUDRATE_CONFIG => 232;

=item FUNCTION_GET_SEND_TIMEOUT_COUNT

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_SEND_TIMEOUT_COUNT => 233;

=item FUNCTION_SET_SPITFP_BAUDRATE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_SPITFP_BAUDRATE => 234;

=item FUNCTION_GET_SPITFP_BAUDRATE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_SPITFP_BAUDRATE => 235;

=item FUNCTION_GET_SPITFP_ERROR_COUNT

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_SPITFP_ERROR_COUNT => 237;

=item FUNCTION_ENABLE_STATUS_LED

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_ENABLE_STATUS_LED => 238;

=item FUNCTION_DISABLE_STATUS_LED

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_DISABLE_STATUS_LED => 239;

=item FUNCTION_IS_STATUS_LED_ENABLED

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_IS_STATUS_LED_ENABLED => 240;

=item FUNCTION_GET_PROTOCOL1_BRICKLET_NAME

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_PROTOCOL1_BRICKLET_NAME => 241;

=item FUNCTION_GET_CHIP_TEMPERATURE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_CHIP_TEMPERATURE => 242;

=item FUNCTION_RESET

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_RESET => 243;

=item FUNCTION_GET_IDENTITY

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_IDENTITY => 255;
use constant MAGNETOMETER_RATE_2HZ => 0;
use constant MAGNETOMETER_RATE_6HZ => 1;
use constant MAGNETOMETER_RATE_8HZ => 2;
use constant MAGNETOMETER_RATE_10HZ => 3;
use constant MAGNETOMETER_RATE_15HZ => 4;
use constant MAGNETOMETER_RATE_20HZ => 5;
use constant MAGNETOMETER_RATE_25HZ => 6;
use constant MAGNETOMETER_RATE_30HZ => 7;
use constant GYROSCOPE_RANGE_2000DPS => 0;
use constant GYROSCOPE_RANGE_1000DPS => 1;
use constant GYROSCOPE_RANGE_500DPS => 2;
use constant GYROSCOPE_RANGE_250DPS => 3;
use constant GYROSCOPE_RANGE_125DPS => 4;
use constant GYROSCOPE_BANDWIDTH_523HZ => 0;
use constant GYROSCOPE_BANDWIDTH_230HZ => 1;
use constant GYROSCOPE_BANDWIDTH_116HZ => 2;
use constant GYROSCOPE_BANDWIDTH_47HZ => 3;
use constant GYROSCOPE_BANDWIDTH_23HZ => 4;
use constant GYROSCOPE_BANDWIDTH_12HZ => 5;
use constant GYROSCOPE_BANDWIDTH_64HZ => 6;
use constant GYROSCOPE_BANDWIDTH_32HZ => 7;
use constant ACCELEROMETER_RANGE_2G => 0;
use constant ACCELEROMETER_RANGE_4G => 1;
use constant ACCELEROMETER_RANGE_8G => 2;
use constant ACCELEROMETER_RANGE_16G => 3;
use constant ACCELEROMETER_BANDWIDTH_7_81HZ => 0;
use constant ACCELEROMETER_BANDWIDTH_15_63HZ => 1;
use constant ACCELEROMETER_BANDWIDTH_31_25HZ => 2;
use constant ACCELEROMETER_BANDWIDTH_62_5HZ => 3;
use constant ACCELEROMETER_BANDWIDTH_125HZ => 4;
use constant ACCELEROMETER_BANDWIDTH_250HZ => 5;
use constant ACCELEROMETER_BANDWIDTH_500HZ => 6;
use constant ACCELEROMETER_BANDWIDTH_1000HZ => 7;
use constant SENSOR_FUSION_OFF => 0;
use constant SENSOR_FUSION_ON => 1;
use constant SENSOR_FUSION_ON_WITHOUT_MAGNETOMETER => 2;
use constant SENSOR_FUSION_ON_WITHOUT_FAST_MAGNETOMETER_CALIBRATION => 3;
use constant COMMUNICATION_METHOD_NONE => 0;
use constant COMMUNICATION_METHOD_USB => 1;
use constant COMMUNICATION_METHOD_SPI_STACK => 2;
use constant COMMUNICATION_METHOD_CHIBI => 3;
use constant COMMUNICATION_METHOD_RS485 => 4;
use constant COMMUNICATION_METHOD_WIFI => 5;
use constant COMMUNICATION_METHOD_ETHERNET => 6;
use constant COMMUNICATION_METHOD_WIFI_V2 => 7;


=back

=head1 FUNCTIONS

=over

=item new()

Creates an object with the unique device ID *uid* and adds it to
the IP Connection *ipcon*.

=cut

sub new
{
	my ($class, $uid, $ipcon) = @_;

	my $self = Tinkerforge::Device->_new($uid, $ipcon, [2, 0, 3]);

	$self->{response_expected}->{&FUNCTION_GET_ACCELERATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_MAGNETIC_FIELD} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_ANGULAR_VELOCITY} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_TEMPERATURE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_ORIENTATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_LINEAR_ACCELERATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_GRAVITY_VECTOR} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_QUATERNION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_ALL_DATA} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_LEDS_ON} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_LEDS_OFF} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_ARE_LEDS_ON} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SAVE_CALIBRATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_ACCELERATION_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_ACCELERATION_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_MAGNETIC_FIELD_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_MAGNETIC_FIELD_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_ANGULAR_VELOCITY_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_ANGULAR_VELOCITY_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_TEMPERATURE_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_TEMPERATURE_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_ORIENTATION_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_ORIENTATION_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_LINEAR_ACCELERATION_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_LINEAR_ACCELERATION_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_GRAVITY_VECTOR_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_GRAVITY_VECTOR_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_QUATERNION_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_QUATERNION_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_ALL_DATA_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_ALL_DATA_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_SENSOR_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_SENSOR_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_SENSOR_FUSION_MODE} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_SENSOR_FUSION_MODE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_SPITFP_BAUDRATE_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_SPITFP_BAUDRATE_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_SEND_TIMEOUT_COUNT} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_SPITFP_BAUDRATE} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_SPITFP_BAUDRATE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_SPITFP_ERROR_COUNT} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_ENABLE_STATUS_LED} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_DISABLE_STATUS_LED} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_IS_STATUS_LED_ENABLED} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_PROTOCOL1_BRICKLET_NAME} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_CHIP_TEMPERATURE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_RESET} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_IDENTITY} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;

	$self->{callback_formats}->{&CALLBACK_ACCELERATION} = 's s s';
	$self->{callback_formats}->{&CALLBACK_MAGNETIC_FIELD} = 's s s';
	$self->{callback_formats}->{&CALLBACK_ANGULAR_VELOCITY} = 's s s';
	$self->{callback_formats}->{&CALLBACK_TEMPERATURE} = 'c';
	$self->{callback_formats}->{&CALLBACK_LINEAR_ACCELERATION} = 's s s';
	$self->{callback_formats}->{&CALLBACK_GRAVITY_VECTOR} = 's s s';
	$self->{callback_formats}->{&CALLBACK_ORIENTATION} = 's s s';
	$self->{callback_formats}->{&CALLBACK_QUATERNION} = 's s s s';
	$self->{callback_formats}->{&CALLBACK_ALL_DATA} = 's3 s3 s3 s3 s4 s3 s3 c C';



	bless($self, $class);

	return $self;
}


=item get_acceleration()

Returns the calibrated acceleration from the accelerometer for the
x, y and z axis in 1/100 m/s².

If you want to get the acceleration periodically, it is recommended
to use the :cb:`Acceleration` callback and set the period with
:func:`Set Acceleration Period`.

=cut

sub get_acceleration
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_ACCELERATION, [], '', 's s s');
}

=item get_magnetic_field()

Returns the calibrated magnetic field from the magnetometer for the
x, y and z axis in 1/16 µT (Microtesla).

If you want to get the magnetic field periodically, it is recommended
to use the :cb:`Magnetic Field` callback and set the period with
:func:`Set Magnetic Field Period`.

=cut

sub get_magnetic_field
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_MAGNETIC_FIELD, [], '', 's s s');
}

=item get_angular_velocity()

Returns the calibrated angular velocity from the gyroscope for the
x, y and z axis in 1/16 °/s.

If you want to get the angular velocity periodically, it is recommended
to use the :cb:`Angular Velocity` acallback nd set the period with
:func:`Set Angular Velocity Period`.

=cut

sub get_angular_velocity
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_ANGULAR_VELOCITY, [], '', 's s s');
}

=item get_temperature()

Returns the temperature of the IMU Brick. The temperature is given in
°C. The temperature is measured in the core of the BNO055 IC, it is not the
ambient temperature

=cut

sub get_temperature
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_TEMPERATURE, [], '', 'c');
}

=item get_orientation()

Returns the current orientation (heading, roll, pitch) of the IMU Brick as
independent Euler angles in 1/16 degree. Note that Euler angles always
experience a `gimbal lock <https://en.wikipedia.org/wiki/Gimbal_lock>`__.
We recommend that you use quaternions instead, if you need the absolute
orientation.

The rotation angle has the following ranges:

* heading: 0° to 360°
* roll: -90° to +90°
* pitch: -180° to +180°

If you want to get the orientation periodically, it is recommended
to use the :cb:`Orientation` callback and set the period with
:func:`Set Orientation Period`.

=cut

sub get_orientation
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_ORIENTATION, [], '', 's s s');
}

=item get_linear_acceleration()

Returns the linear acceleration of the IMU Brick for the
x, y and z axis in 1/100 m/s².

The linear acceleration is the acceleration in each of the three
axis of the IMU Brick with the influences of gravity removed.

It is also possible to get the gravity vector with the influence of linear
acceleration removed, see :func:`Get Gravity Vector`.

If you want to get the linear acceleration periodically, it is recommended
to use the :cb:`Linear Acceleration` callback and set the period with
:func:`Set Linear Acceleration Period`.

=cut

sub get_linear_acceleration
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_LINEAR_ACCELERATION, [], '', 's s s');
}

=item get_gravity_vector()

Returns the current gravity vector of the IMU Brick for the
x, y and z axis in 1/100 m/s².

The gravity vector is the acceleration that occurs due to gravity.
Influences of additional linear acceleration are removed.

It is also possible to get the linear acceleration with the influence
of gravity removed, see :func:`Get Linear Acceleration`.

If you want to get the gravity vector periodically, it is recommended
to use the :cb:`Gravity Vector` callback and set the period with
:func:`Set Gravity Vector Period`.

=cut

sub get_gravity_vector
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_GRAVITY_VECTOR, [], '', 's s s');
}

=item get_quaternion()

Returns the current orientation (w, x, y, z) of the IMU Brick as
`quaternions <https://en.wikipedia.org/wiki/Quaternions_and_spatial_rotation>`__.

You have to divide the returns values by 16383 (14 bit) to get
the usual range of -1.0 to +1.0 for quaternions.

If you want to get the quaternions periodically, it is recommended
to use the :cb:`Quaternion` callback and set the period with
:func:`Set Quaternion Period`.

=cut

sub get_quaternion
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_QUATERNION, [], '', 's s s s');
}

=item get_all_data()

Return all of the available data of the IMU Brick.

* acceleration in 1/100 m/s² (see :func:`Get Acceleration`)
* magnetic field in 1/16 µT (see :func:`Get Magnetic Field`)
* angular velocity in 1/16 °/s (see :func:`Get Angular Velocity`)
* Euler angles in 1/16 ° (see :func:`Get Orientation`)
* quaternion 1/16383 (see :func:`Get Quaternion`)
* linear acceleration 1/100 m/s² (see :func:`Get Linear Acceleration`)
* gravity vector 1/100 m/s² (see :func:`Get Gravity Vector`)
* temperature in 1 °C (see :func:`Get Temperature`)
* calibration status (see below)

The calibration status consists of four pairs of two bits. Each pair
of bits represents the status of the current calibration.

* bit 0-1: Magnetometer
* bit 2-3: Accelerometer
* bit 4-5: Gyroscope
* bit 6-7: System

A value of 0 means for "not calibrated" and a value of 3 means
"fully calibrated". In your program you should always be able to
ignore the calibration status, it is used by the calibration
window of the Brick Viewer and it can be ignored after the first
calibration. See the documentation in the calibration window for
more information regarding the calibration of the IMU Brick.

If you want to get the data periodically, it is recommended
to use the :cb:`All Data` callback and set the period with
:func:`Set All Data Period`.

=cut

sub get_all_data
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_ALL_DATA, [], '', 's3 s3 s3 s3 s4 s3 s3 c C');
}

=item leds_on()

Turns the orientation and direction LEDs of the IMU Brick on.

=cut

sub leds_on
{
	my ($self) = @_;

	$self->_send_request(&FUNCTION_LEDS_ON, [], '', '');
}

=item leds_off()

Turns the orientation and direction LEDs of the IMU Brick off.

=cut

sub leds_off
{
	my ($self) = @_;

	$self->_send_request(&FUNCTION_LEDS_OFF, [], '', '');
}

=item are_leds_on()

Returns *true* if the orientation and direction LEDs of the IMU Brick
are on, *false* otherwise.

=cut

sub are_leds_on
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_ARE_LEDS_ON, [], '', '?');
}

=item save_calibration()

A call of this function saves the current calibration to be used
as a starting point for the next restart of continuous calibration
of the IMU Brick.

A return value of *true* means that the calibration could be used and
*false* means that it could not be used (this happens if the calibration
status is not "fully calibrated").

This function is used by the calibration window of the Brick Viewer, you
should not need to call it in your program.

=cut

sub save_calibration
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_SAVE_CALIBRATION, [], '', '?');
}

=item set_acceleration_period()

Sets the period in ms with which the :cb:`Acceleration` callback is triggered
periodically. A value of 0 turns the callback off.

The default value is 0.

=cut

sub set_acceleration_period
{
	my ($self, $period) = @_;

	$self->_send_request(&FUNCTION_SET_ACCELERATION_PERIOD, [$period], 'L', '');
}

=item get_acceleration_period()

Returns the period as set by :func:`Set Acceleration Period`.

=cut

sub get_acceleration_period
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_ACCELERATION_PERIOD, [], '', 'L');
}

=item set_magnetic_field_period()

Sets the period in ms with which the :cb:`Magnetic Field` callback is triggered
periodically. A value of 0 turns the callback off.

=cut

sub set_magnetic_field_period
{
	my ($self, $period) = @_;

	$self->_send_request(&FUNCTION_SET_MAGNETIC_FIELD_PERIOD, [$period], 'L', '');
}

=item get_magnetic_field_period()

Returns the period as set by :func:`Set Magnetic Field Period`.

=cut

sub get_magnetic_field_period
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_MAGNETIC_FIELD_PERIOD, [], '', 'L');
}

=item set_angular_velocity_period()

Sets the period in ms with which the :cb:`Angular Velocity` callback is
triggered periodically. A value of 0 turns the callback off.

=cut

sub set_angular_velocity_period
{
	my ($self, $period) = @_;

	$self->_send_request(&FUNCTION_SET_ANGULAR_VELOCITY_PERIOD, [$period], 'L', '');
}

=item get_angular_velocity_period()

Returns the period as set by :func:`Set Angular Velocity Period`.

=cut

sub get_angular_velocity_period
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_ANGULAR_VELOCITY_PERIOD, [], '', 'L');
}

=item set_temperature_period()

Sets the period in ms with which the :cb:`Temperature` callback is triggered
periodically. A value of 0 turns the callback off.

=cut

sub set_temperature_period
{
	my ($self, $period) = @_;

	$self->_send_request(&FUNCTION_SET_TEMPERATURE_PERIOD, [$period], 'L', '');
}

=item get_temperature_period()

Returns the period as set by :func:`Set Temperature Period`.

=cut

sub get_temperature_period
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_TEMPERATURE_PERIOD, [], '', 'L');
}

=item set_orientation_period()

Sets the period in ms with which the :cb:`Orientation` callback is triggered
periodically. A value of 0 turns the callback off.

=cut

sub set_orientation_period
{
	my ($self, $period) = @_;

	$self->_send_request(&FUNCTION_SET_ORIENTATION_PERIOD, [$period], 'L', '');
}

=item get_orientation_period()

Returns the period as set by :func:`Set Orientation Period`.

=cut

sub get_orientation_period
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_ORIENTATION_PERIOD, [], '', 'L');
}

=item set_linear_acceleration_period()

Sets the period in ms with which the :cb:`Linear Acceleration` callback is
triggered periodically. A value of 0 turns the callback off.

=cut

sub set_linear_acceleration_period
{
	my ($self, $period) = @_;

	$self->_send_request(&FUNCTION_SET_LINEAR_ACCELERATION_PERIOD, [$period], 'L', '');
}

=item get_linear_acceleration_period()

Returns the period as set by :func:`Set Linear Acceleration Period`.

=cut

sub get_linear_acceleration_period
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_LINEAR_ACCELERATION_PERIOD, [], '', 'L');
}

=item set_gravity_vector_period()

Sets the period in ms with which the :cb:`Gravity Vector` callback is triggered
periodically. A value of 0 turns the callback off.

=cut

sub set_gravity_vector_period
{
	my ($self, $period) = @_;

	$self->_send_request(&FUNCTION_SET_GRAVITY_VECTOR_PERIOD, [$period], 'L', '');
}

=item get_gravity_vector_period()

Returns the period as set by :func:`Set Gravity Vector Period`.

=cut

sub get_gravity_vector_period
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_GRAVITY_VECTOR_PERIOD, [], '', 'L');
}

=item set_quaternion_period()

Sets the period in ms with which the :cb:`Quaternion` callback is triggered
periodically. A value of 0 turns the callback off.

=cut

sub set_quaternion_period
{
	my ($self, $period) = @_;

	$self->_send_request(&FUNCTION_SET_QUATERNION_PERIOD, [$period], 'L', '');
}

=item get_quaternion_period()

Returns the period as set by :func:`Set Quaternion Period`.

=cut

sub get_quaternion_period
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_QUATERNION_PERIOD, [], '', 'L');
}

=item set_all_data_period()

Sets the period in ms with which the :cb:`All Data` callback is triggered
periodically. A value of 0 turns the callback off.

=cut

sub set_all_data_period
{
	my ($self, $period) = @_;

	$self->_send_request(&FUNCTION_SET_ALL_DATA_PERIOD, [$period], 'L', '');
}

=item get_all_data_period()

Returns the period as set by :func:`Set All Data Period`.

=cut

sub get_all_data_period
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_ALL_DATA_PERIOD, [], '', 'L');
}

=item set_sensor_configuration()

Sets the available sensor configuration for the Magnetometer, Gyroscope and
Accelerometer. The Accelerometer Range is user selectable in all fusion modes,
all other configurations are auto-controlled in fusion mode.

The default values are:

* Magnetometer Rate 20Hz
* Gyroscope Range 2000°/s
* Gyroscope Bandwidth 32Hz
* Accelerometer Range +/-4G
* Accelerometer Bandwidth 62.5Hz

.. versionadded:: 2.0.5$nbsp;(Firmware)

=cut

sub set_sensor_configuration
{
	my ($self, $magnetometer_rate, $gyroscope_range, $gyroscope_bandwidth, $accelerometer_range, $accelerometer_bandwidth) = @_;

	$self->_send_request(&FUNCTION_SET_SENSOR_CONFIGURATION, [$magnetometer_rate, $gyroscope_range, $gyroscope_bandwidth, $accelerometer_range, $accelerometer_bandwidth], 'C C C C C', '');
}

=item get_sensor_configuration()

Returns the sensor configuration as set by :func:`Set Sensor Configuration`.

.. versionadded:: 2.0.5$nbsp;(Firmware)

=cut

sub get_sensor_configuration
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_SENSOR_CONFIGURATION, [], '', 'C C C C C');
}

=item set_sensor_fusion_mode()

If the fusion mode is turned off, the functions :func:`Get Acceleration`,
:func:`Get Magnetic Field` and :func:`Get Angular Velocity` return uncalibrated
and uncompensated sensor data. All other sensor data getters return no data.

Since firmware version 2.0.6 you can also use a fusion mode without magnetometer.
In this mode the calculated orientation is relative (with magnetometer it is
absolute with respect to the earth). However, the calculation can't be influenced
by spurious magnetic fields.

Since firmware version 2.0.13 you can also use a fusion mode without fast
magnetometer calibration. This mode is the same as the normal fusion mode,
but the fast magnetometer calibration is turned off. So to find the orientation
the first time will likely take longer, but small magnetic influences might
not affect the automatic calibration as much.

By default sensor fusion is on.

.. versionadded:: 2.0.5$nbsp;(Firmware)

=cut

sub set_sensor_fusion_mode
{
	my ($self, $mode) = @_;

	$self->_send_request(&FUNCTION_SET_SENSOR_FUSION_MODE, [$mode], 'C', '');
}

=item get_sensor_fusion_mode()

Returns the sensor fusion mode as set by :func:`Set Sensor Fusion Mode`.

.. versionadded:: 2.0.5$nbsp;(Firmware)

=cut

sub get_sensor_fusion_mode
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_SENSOR_FUSION_MODE, [], '', 'C');
}

=item set_spitfp_baudrate_config()

The SPITF protocol can be used with a dynamic baudrate. If the dynamic baudrate is
enabled, the Brick will try to adapt the baudrate for the communication
between Bricks and Bricklets according to the amount of data that is transferred.

The baudrate will be increased exponentially if lots of data is send/received and
decreased linearly if little data is send/received.

This lowers the baudrate in applications where little data is transferred (e.g.
a weather station) and increases the robustness. If there is lots of data to transfer
(e.g. Thermal Imaging Bricklet) it automatically increases the baudrate as needed.

In cases where some data has to transferred as fast as possible every few seconds
(e.g. RS485 Bricklet with a high baudrate but small payload) you may want to turn
the dynamic baudrate off to get the highest possible performance.

The maximum value of the baudrate can be set per port with the function
:func:`Set SPITFP Baudrate`. If the dynamic baudrate is disabled, the baudrate
as set by :func:`Set SPITFP Baudrate` will be used statically.

The minimum dynamic baudrate has a value range of 400000 to 2000000 baud.

By default dynamic baudrate is enabled and the minimum dynamic baudrate is 400000.

.. versionadded:: 2.0.10$nbsp;(Firmware)

=cut

sub set_spitfp_baudrate_config
{
	my ($self, $enable_dynamic_baudrate, $minimum_dynamic_baudrate) = @_;

	$self->_send_request(&FUNCTION_SET_SPITFP_BAUDRATE_CONFIG, [$enable_dynamic_baudrate, $minimum_dynamic_baudrate], '? L', '');
}

=item get_spitfp_baudrate_config()

Returns the baudrate config, see :func:`Set SPITFP Baudrate Config`.

.. versionadded:: 2.0.10$nbsp;(Firmware)

=cut

sub get_spitfp_baudrate_config
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_SPITFP_BAUDRATE_CONFIG, [], '', '? L');
}

=item get_send_timeout_count()

Returns the timeout count for the different communication methods.

The methods 0-2 are available for all Bricks, 3-7 only for Master Bricks.

This function is mostly used for debugging during development, in normal operation
the counters should nearly always stay at 0.

.. versionadded:: 2.0.7$nbsp;(Firmware)

=cut

sub get_send_timeout_count
{
	my ($self, $communication_method) = @_;

	return $self->_send_request(&FUNCTION_GET_SEND_TIMEOUT_COUNT, [$communication_method], 'C', 'L');
}

=item set_spitfp_baudrate()

Sets the baudrate for a specific Bricklet port ('a' - 'd'). The
baudrate can be in the range 400000 to 2000000.

If you want to increase the throughput of Bricklets you can increase
the baudrate. If you get a high error count because of high
interference (see :func:`Get SPITFP Error Count`) you can decrease the
baudrate.

If the dynamic baudrate feature is enabled, the baudrate set by this
function corresponds to the maximum baudrate (see :func:`Set SPITFP Baudrate Config`).

Regulatory testing is done with the default baudrate. If CE compatibility
or similar is necessary in you applications we recommend to not change
the baudrate.

The default baudrate for all ports is 1400000.

.. versionadded:: 2.0.5$nbsp;(Firmware)

=cut

sub set_spitfp_baudrate
{
	my ($self, $bricklet_port, $baudrate) = @_;

	$self->_send_request(&FUNCTION_SET_SPITFP_BAUDRATE, [$bricklet_port, $baudrate], 'a L', '');
}

=item get_spitfp_baudrate()

Returns the baudrate for a given Bricklet port, see :func:`Set SPITFP Baudrate`.

.. versionadded:: 2.0.5$nbsp;(Firmware)

=cut

sub get_spitfp_baudrate
{
	my ($self, $bricklet_port) = @_;

	return $self->_send_request(&FUNCTION_GET_SPITFP_BAUDRATE, [$bricklet_port], 'a', 'L');
}

=item get_spitfp_error_count()

Returns the error count for the communication between Brick and Bricklet.

The errors are divided into

* ACK checksum errors,
* message checksum errors,
* framing errors and
* overflow errors.

The errors counts are for errors that occur on the Brick side. All
Bricklets have a similar function that returns the errors on the Bricklet side.

.. versionadded:: 2.0.5$nbsp;(Firmware)

=cut

sub get_spitfp_error_count
{
	my ($self, $bricklet_port) = @_;

	return $self->_send_request(&FUNCTION_GET_SPITFP_ERROR_COUNT, [$bricklet_port], 'a', 'L L L L');
}

=item enable_status_led()

Enables the status LED.

The status LED is the blue LED next to the USB connector. If enabled is is
on and it flickers if data is transfered. If disabled it is always off.

The default state is enabled.

=cut

sub enable_status_led
{
	my ($self) = @_;

	$self->_send_request(&FUNCTION_ENABLE_STATUS_LED, [], '', '');
}

=item disable_status_led()

Disables the status LED.

The status LED is the blue LED next to the USB connector. If enabled is is
on and it flickers if data is transfered. If disabled it is always off.

The default state is enabled.

=cut

sub disable_status_led
{
	my ($self) = @_;

	$self->_send_request(&FUNCTION_DISABLE_STATUS_LED, [], '', '');
}

=item is_status_led_enabled()

Returns *true* if the status LED is enabled, *false* otherwise.

=cut

sub is_status_led_enabled
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_IS_STATUS_LED_ENABLED, [], '', '?');
}

=item get_protocol1_bricklet_name()

Returns the firmware and protocol version and the name of the Bricklet for a
given port.

This functions sole purpose is to allow automatic flashing of v1.x.y Bricklet
plugins.

=cut

sub get_protocol1_bricklet_name
{
	my ($self, $port) = @_;

	return $self->_send_request(&FUNCTION_GET_PROTOCOL1_BRICKLET_NAME, [$port], 'a', 'C C3 Z40');
}

=item get_chip_temperature()

Returns the temperature in °C/10 as measured inside the microcontroller. The
value returned is not the ambient temperature!

The temperature is only proportional to the real temperature and it has an
accuracy of +-15%. Practically it is only useful as an indicator for
temperature changes.

=cut

sub get_chip_temperature
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_CHIP_TEMPERATURE, [], '', 's');
}

=item reset()

Calling this function will reset the Brick. Calling this function
on a Brick inside of a stack will reset the whole stack.

After a reset you have to create new device objects,
calling functions on the existing ones will result in
undefined behavior!

=cut

sub reset
{
	my ($self) = @_;

	$self->_send_request(&FUNCTION_RESET, [], '', '');
}

=item get_identity()

Returns the UID, the UID where the Brick is connected to,
the position, the hardware and firmware version as well as the
device identifier.

The position can be '0'-'8' (stack position).

The device identifier numbers can be found :ref:`here <device_identifier>`.
|device_identifier_constant|

=cut

sub get_identity
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_IDENTITY, [], '', 'Z8 Z8 a C3 C3 S');
}

=back
=cut

1;
