package DBD::SQLite::Constants;

# This module is generated by a script.
# Do not edit manually.

use strict;
use warnings;
use base 'Exporter';
use DBD::SQLite;
our @EXPORT_OK = (
    # authorizer_action_codes
    qw/
      SQLITE_ALTER_TABLE
      SQLITE_ANALYZE
      SQLITE_ATTACH
      SQLITE_COPY
      SQLITE_CREATE_INDEX
      SQLITE_CREATE_TABLE
      SQLITE_CREATE_TEMP_INDEX
      SQLITE_CREATE_TEMP_TABLE
      SQLITE_CREATE_TEMP_TRIGGER
      SQLITE_CREATE_TEMP_VIEW
      SQLITE_CREATE_TRIGGER
      SQLITE_CREATE_VIEW
      SQLITE_CREATE_VTABLE
      SQLITE_DELETE
      SQLITE_DETACH
      SQLITE_DROP_INDEX
      SQLITE_DROP_TABLE
      SQLITE_DROP_TEMP_INDEX
      SQLITE_DROP_TEMP_TABLE
      SQLITE_DROP_TEMP_TRIGGER
      SQLITE_DROP_TEMP_VIEW
      SQLITE_DROP_TRIGGER
      SQLITE_DROP_VIEW
      SQLITE_DROP_VTABLE
      SQLITE_FUNCTION
      SQLITE_INSERT
      SQLITE_PRAGMA
      SQLITE_READ
      SQLITE_RECURSIVE
      SQLITE_REINDEX
      SQLITE_SAVEPOINT
      SQLITE_SELECT
      SQLITE_TRANSACTION
      SQLITE_UPDATE
    /,

    # authorizer_return_codes
    qw/
      SQLITE_DENY
      SQLITE_IGNORE
    /,

    # compile_time_library_version_numbers
    qw/
      SQLITE_VERSION_NUMBER
    /,

    # extended_result_codes
    qw/
      SQLITE_ABORT_ROLLBACK
      SQLITE_AUTH_USER
      SQLITE_BUSY_RECOVERY
      SQLITE_BUSY_SNAPSHOT
      SQLITE_CANTOPEN_CONVPATH
      SQLITE_CANTOPEN_DIRTYWAL
      SQLITE_CANTOPEN_FULLPATH
      SQLITE_CANTOPEN_ISDIR
      SQLITE_CANTOPEN_NOTEMPDIR
      SQLITE_CONSTRAINT_CHECK
      SQLITE_CONSTRAINT_COMMITHOOK
      SQLITE_CONSTRAINT_FOREIGNKEY
      SQLITE_CONSTRAINT_FUNCTION
      SQLITE_CONSTRAINT_NOTNULL
      SQLITE_CONSTRAINT_PRIMARYKEY
      SQLITE_CONSTRAINT_ROWID
      SQLITE_CONSTRAINT_TRIGGER
      SQLITE_CONSTRAINT_UNIQUE
      SQLITE_CONSTRAINT_VTAB
      SQLITE_CORRUPT_SEQUENCE
      SQLITE_CORRUPT_VTAB
      SQLITE_ERROR_MISSING_COLLSEQ
      SQLITE_ERROR_RETRY
      SQLITE_ERROR_SNAPSHOT
      SQLITE_IOERR_ACCESS
      SQLITE_IOERR_AUTH
      SQLITE_IOERR_BEGIN_ATOMIC
      SQLITE_IOERR_BLOCKED
      SQLITE_IOERR_CHECKRESERVEDLOCK
      SQLITE_IOERR_CLOSE
      SQLITE_IOERR_COMMIT_ATOMIC
      SQLITE_IOERR_CONVPATH
      SQLITE_IOERR_DELETE
      SQLITE_IOERR_DELETE_NOENT
      SQLITE_IOERR_DIR_CLOSE
      SQLITE_IOERR_DIR_FSYNC
      SQLITE_IOERR_FSTAT
      SQLITE_IOERR_FSYNC
      SQLITE_IOERR_GETTEMPPATH
      SQLITE_IOERR_LOCK
      SQLITE_IOERR_MMAP
      SQLITE_IOERR_NOMEM
      SQLITE_IOERR_RDLOCK
      SQLITE_IOERR_READ
      SQLITE_IOERR_ROLLBACK_ATOMIC
      SQLITE_IOERR_SEEK
      SQLITE_IOERR_SHMLOCK
      SQLITE_IOERR_SHMMAP
      SQLITE_IOERR_SHMOPEN
      SQLITE_IOERR_SHMSIZE
      SQLITE_IOERR_SHORT_READ
      SQLITE_IOERR_TRUNCATE
      SQLITE_IOERR_UNLOCK
      SQLITE_IOERR_VNODE
      SQLITE_IOERR_WRITE
      SQLITE_LOCKED_SHAREDCACHE
      SQLITE_LOCKED_VTAB
      SQLITE_NOTICE_RECOVER_ROLLBACK
      SQLITE_NOTICE_RECOVER_WAL
      SQLITE_READONLY_CANTINIT
      SQLITE_READONLY_CANTLOCK
      SQLITE_READONLY_DBMOVED
      SQLITE_READONLY_DIRECTORY
      SQLITE_READONLY_RECOVERY
      SQLITE_READONLY_ROLLBACK
      SQLITE_WARNING_AUTOINDEX
    /,

    # flags_for_file_open_operations
    qw/
      SQLITE_OPEN_CREATE
      SQLITE_OPEN_FULLMUTEX
      SQLITE_OPEN_MEMORY
      SQLITE_OPEN_NOMUTEX
      SQLITE_OPEN_PRIVATECACHE
      SQLITE_OPEN_READONLY
      SQLITE_OPEN_READWRITE
      SQLITE_OPEN_SHAREDCACHE
      SQLITE_OPEN_URI
    /,

    # function_flags
    qw/
      SQLITE_DETERMINISTIC
    /,

    # fundamental_datatypes
    qw/
      SQLITE_BLOB
      SQLITE_FLOAT
      SQLITE_INTEGER
      SQLITE_NULL
    /,

    # result_codes
    qw/
      SQLITE_ABORT
      SQLITE_AUTH
      SQLITE_BUSY
      SQLITE_CANTOPEN
      SQLITE_CONSTRAINT
      SQLITE_CORRUPT
      SQLITE_DONE
      SQLITE_EMPTY
      SQLITE_ERROR
      SQLITE_FORMAT
      SQLITE_FULL
      SQLITE_INTERNAL
      SQLITE_INTERRUPT
      SQLITE_IOERR
      SQLITE_LOCKED
      SQLITE_MISMATCH
      SQLITE_MISUSE
      SQLITE_NOLFS
      SQLITE_NOMEM
      SQLITE_NOTADB
      SQLITE_NOTFOUND
      SQLITE_NOTICE
      SQLITE_OK
      SQLITE_PERM
      SQLITE_PROTOCOL
      SQLITE_RANGE
      SQLITE_READONLY
      SQLITE_ROW
      SQLITE_SCHEMA
      SQLITE_TOOBIG
      SQLITE_WARNING
    /,

    # run_time_limit_categories
    qw/
      SQLITE_LIMIT_ATTACHED
      SQLITE_LIMIT_COLUMN
      SQLITE_LIMIT_COMPOUND_SELECT
      SQLITE_LIMIT_EXPR_DEPTH
      SQLITE_LIMIT_FUNCTION_ARG
      SQLITE_LIMIT_LENGTH
      SQLITE_LIMIT_LIKE_PATTERN_LENGTH
      SQLITE_LIMIT_SQL_LENGTH
      SQLITE_LIMIT_TRIGGER_DEPTH
      SQLITE_LIMIT_VARIABLE_NUMBER
      SQLITE_LIMIT_VDBE_OP
      SQLITE_LIMIT_WORKER_THREADS
    /,

);

our %EXPORT_TAGS = (
    all => [qw/
      SQLITE_ABORT
      SQLITE_ABORT_ROLLBACK
      SQLITE_ALTER_TABLE
      SQLITE_ANALYZE
      SQLITE_ATTACH
      SQLITE_AUTH
      SQLITE_AUTH_USER
      SQLITE_BLOB
      SQLITE_BUSY
      SQLITE_BUSY_RECOVERY
      SQLITE_BUSY_SNAPSHOT
      SQLITE_CANTOPEN
      SQLITE_CANTOPEN_CONVPATH
      SQLITE_CANTOPEN_DIRTYWAL
      SQLITE_CANTOPEN_FULLPATH
      SQLITE_CANTOPEN_ISDIR
      SQLITE_CANTOPEN_NOTEMPDIR
      SQLITE_CONSTRAINT
      SQLITE_CONSTRAINT_CHECK
      SQLITE_CONSTRAINT_COMMITHOOK
      SQLITE_CONSTRAINT_FOREIGNKEY
      SQLITE_CONSTRAINT_FUNCTION
      SQLITE_CONSTRAINT_NOTNULL
      SQLITE_CONSTRAINT_PRIMARYKEY
      SQLITE_CONSTRAINT_ROWID
      SQLITE_CONSTRAINT_TRIGGER
      SQLITE_CONSTRAINT_UNIQUE
      SQLITE_CONSTRAINT_VTAB
      SQLITE_COPY
      SQLITE_CORRUPT
      SQLITE_CORRUPT_SEQUENCE
      SQLITE_CORRUPT_VTAB
      SQLITE_CREATE_INDEX
      SQLITE_CREATE_TABLE
      SQLITE_CREATE_TEMP_INDEX
      SQLITE_CREATE_TEMP_TABLE
      SQLITE_CREATE_TEMP_TRIGGER
      SQLITE_CREATE_TEMP_VIEW
      SQLITE_CREATE_TRIGGER
      SQLITE_CREATE_VIEW
      SQLITE_CREATE_VTABLE
      SQLITE_DELETE
      SQLITE_DENY
      SQLITE_DETACH
      SQLITE_DETERMINISTIC
      SQLITE_DONE
      SQLITE_DROP_INDEX
      SQLITE_DROP_TABLE
      SQLITE_DROP_TEMP_INDEX
      SQLITE_DROP_TEMP_TABLE
      SQLITE_DROP_TEMP_TRIGGER
      SQLITE_DROP_TEMP_VIEW
      SQLITE_DROP_TRIGGER
      SQLITE_DROP_VIEW
      SQLITE_DROP_VTABLE
      SQLITE_EMPTY
      SQLITE_ERROR
      SQLITE_ERROR_MISSING_COLLSEQ
      SQLITE_ERROR_RETRY
      SQLITE_ERROR_SNAPSHOT
      SQLITE_FLOAT
      SQLITE_FORMAT
      SQLITE_FULL
      SQLITE_FUNCTION
      SQLITE_IGNORE
      SQLITE_INSERT
      SQLITE_INTEGER
      SQLITE_INTERNAL
      SQLITE_INTERRUPT
      SQLITE_IOERR
      SQLITE_IOERR_ACCESS
      SQLITE_IOERR_AUTH
      SQLITE_IOERR_BEGIN_ATOMIC
      SQLITE_IOERR_BLOCKED
      SQLITE_IOERR_CHECKRESERVEDLOCK
      SQLITE_IOERR_CLOSE
      SQLITE_IOERR_COMMIT_ATOMIC
      SQLITE_IOERR_CONVPATH
      SQLITE_IOERR_DELETE
      SQLITE_IOERR_DELETE_NOENT
      SQLITE_IOERR_DIR_CLOSE
      SQLITE_IOERR_DIR_FSYNC
      SQLITE_IOERR_FSTAT
      SQLITE_IOERR_FSYNC
      SQLITE_IOERR_GETTEMPPATH
      SQLITE_IOERR_LOCK
      SQLITE_IOERR_MMAP
      SQLITE_IOERR_NOMEM
      SQLITE_IOERR_RDLOCK
      SQLITE_IOERR_READ
      SQLITE_IOERR_ROLLBACK_ATOMIC
      SQLITE_IOERR_SEEK
      SQLITE_IOERR_SHMLOCK
      SQLITE_IOERR_SHMMAP
      SQLITE_IOERR_SHMOPEN
      SQLITE_IOERR_SHMSIZE
      SQLITE_IOERR_SHORT_READ
      SQLITE_IOERR_TRUNCATE
      SQLITE_IOERR_UNLOCK
      SQLITE_IOERR_VNODE
      SQLITE_IOERR_WRITE
      SQLITE_LIMIT_ATTACHED
      SQLITE_LIMIT_COLUMN
      SQLITE_LIMIT_COMPOUND_SELECT
      SQLITE_LIMIT_EXPR_DEPTH
      SQLITE_LIMIT_FUNCTION_ARG
      SQLITE_LIMIT_LENGTH
      SQLITE_LIMIT_LIKE_PATTERN_LENGTH
      SQLITE_LIMIT_SQL_LENGTH
      SQLITE_LIMIT_TRIGGER_DEPTH
      SQLITE_LIMIT_VARIABLE_NUMBER
      SQLITE_LIMIT_VDBE_OP
      SQLITE_LIMIT_WORKER_THREADS
      SQLITE_LOCKED
      SQLITE_LOCKED_SHAREDCACHE
      SQLITE_LOCKED_VTAB
      SQLITE_MISMATCH
      SQLITE_MISUSE
      SQLITE_NOLFS
      SQLITE_NOMEM
      SQLITE_NOTADB
      SQLITE_NOTFOUND
      SQLITE_NOTICE
      SQLITE_NOTICE_RECOVER_ROLLBACK
      SQLITE_NOTICE_RECOVER_WAL
      SQLITE_NULL
      SQLITE_OK
      SQLITE_OPEN_CREATE
      SQLITE_OPEN_FULLMUTEX
      SQLITE_OPEN_MEMORY
      SQLITE_OPEN_NOMUTEX
      SQLITE_OPEN_PRIVATECACHE
      SQLITE_OPEN_READONLY
      SQLITE_OPEN_READWRITE
      SQLITE_OPEN_SHAREDCACHE
      SQLITE_OPEN_URI
      SQLITE_PERM
      SQLITE_PRAGMA
      SQLITE_PROTOCOL
      SQLITE_RANGE
      SQLITE_READ
      SQLITE_READONLY
      SQLITE_READONLY_CANTINIT
      SQLITE_READONLY_CANTLOCK
      SQLITE_READONLY_DBMOVED
      SQLITE_READONLY_DIRECTORY
      SQLITE_READONLY_RECOVERY
      SQLITE_READONLY_ROLLBACK
      SQLITE_RECURSIVE
      SQLITE_REINDEX
      SQLITE_ROW
      SQLITE_SAVEPOINT
      SQLITE_SCHEMA
      SQLITE_SELECT
      SQLITE_TOOBIG
      SQLITE_TRANSACTION
      SQLITE_UPDATE
      SQLITE_VERSION_NUMBER
      SQLITE_WARNING
      SQLITE_WARNING_AUTOINDEX
    /],

    authorizer_action_codes => [qw/
      SQLITE_ALTER_TABLE
      SQLITE_ANALYZE
      SQLITE_ATTACH
      SQLITE_COPY
      SQLITE_CREATE_INDEX
      SQLITE_CREATE_TABLE
      SQLITE_CREATE_TEMP_INDEX
      SQLITE_CREATE_TEMP_TABLE
      SQLITE_CREATE_TEMP_TRIGGER
      SQLITE_CREATE_TEMP_VIEW
      SQLITE_CREATE_TRIGGER
      SQLITE_CREATE_VIEW
      SQLITE_CREATE_VTABLE
      SQLITE_DELETE
      SQLITE_DETACH
      SQLITE_DROP_INDEX
      SQLITE_DROP_TABLE
      SQLITE_DROP_TEMP_INDEX
      SQLITE_DROP_TEMP_TABLE
      SQLITE_DROP_TEMP_TRIGGER
      SQLITE_DROP_TEMP_VIEW
      SQLITE_DROP_TRIGGER
      SQLITE_DROP_VIEW
      SQLITE_DROP_VTABLE
      SQLITE_FUNCTION
      SQLITE_INSERT
      SQLITE_PRAGMA
      SQLITE_READ
      SQLITE_RECURSIVE
      SQLITE_REINDEX
      SQLITE_SAVEPOINT
      SQLITE_SELECT
      SQLITE_TRANSACTION
      SQLITE_UPDATE
    /],

    authorizer_return_codes => [qw/
      SQLITE_DENY
      SQLITE_IGNORE
    /],

    compile_time_library_version_numbers => [qw/
      SQLITE_VERSION_NUMBER
    /],

    extended_result_codes => [qw/
      SQLITE_ABORT_ROLLBACK
      SQLITE_AUTH_USER
      SQLITE_BUSY_RECOVERY
      SQLITE_BUSY_SNAPSHOT
      SQLITE_CANTOPEN_CONVPATH
      SQLITE_CANTOPEN_DIRTYWAL
      SQLITE_CANTOPEN_FULLPATH
      SQLITE_CANTOPEN_ISDIR
      SQLITE_CANTOPEN_NOTEMPDIR
      SQLITE_CONSTRAINT_CHECK
      SQLITE_CONSTRAINT_COMMITHOOK
      SQLITE_CONSTRAINT_FOREIGNKEY
      SQLITE_CONSTRAINT_FUNCTION
      SQLITE_CONSTRAINT_NOTNULL
      SQLITE_CONSTRAINT_PRIMARYKEY
      SQLITE_CONSTRAINT_ROWID
      SQLITE_CONSTRAINT_TRIGGER
      SQLITE_CONSTRAINT_UNIQUE
      SQLITE_CONSTRAINT_VTAB
      SQLITE_CORRUPT_SEQUENCE
      SQLITE_CORRUPT_VTAB
      SQLITE_ERROR_MISSING_COLLSEQ
      SQLITE_ERROR_RETRY
      SQLITE_ERROR_SNAPSHOT
      SQLITE_IOERR_ACCESS
      SQLITE_IOERR_AUTH
      SQLITE_IOERR_BEGIN_ATOMIC
      SQLITE_IOERR_BLOCKED
      SQLITE_IOERR_CHECKRESERVEDLOCK
      SQLITE_IOERR_CLOSE
      SQLITE_IOERR_COMMIT_ATOMIC
      SQLITE_IOERR_CONVPATH
      SQLITE_IOERR_DELETE
      SQLITE_IOERR_DELETE_NOENT
      SQLITE_IOERR_DIR_CLOSE
      SQLITE_IOERR_DIR_FSYNC
      SQLITE_IOERR_FSTAT
      SQLITE_IOERR_FSYNC
      SQLITE_IOERR_GETTEMPPATH
      SQLITE_IOERR_LOCK
      SQLITE_IOERR_MMAP
      SQLITE_IOERR_NOMEM
      SQLITE_IOERR_RDLOCK
      SQLITE_IOERR_READ
      SQLITE_IOERR_ROLLBACK_ATOMIC
      SQLITE_IOERR_SEEK
      SQLITE_IOERR_SHMLOCK
      SQLITE_IOERR_SHMMAP
      SQLITE_IOERR_SHMOPEN
      SQLITE_IOERR_SHMSIZE
      SQLITE_IOERR_SHORT_READ
      SQLITE_IOERR_TRUNCATE
      SQLITE_IOERR_UNLOCK
      SQLITE_IOERR_VNODE
      SQLITE_IOERR_WRITE
      SQLITE_LOCKED_SHAREDCACHE
      SQLITE_LOCKED_VTAB
      SQLITE_NOTICE_RECOVER_ROLLBACK
      SQLITE_NOTICE_RECOVER_WAL
      SQLITE_READONLY_CANTINIT
      SQLITE_READONLY_CANTLOCK
      SQLITE_READONLY_DBMOVED
      SQLITE_READONLY_DIRECTORY
      SQLITE_READONLY_RECOVERY
      SQLITE_READONLY_ROLLBACK
      SQLITE_WARNING_AUTOINDEX
    /],

    flags_for_file_open_operations => [qw/
      SQLITE_OPEN_CREATE
      SQLITE_OPEN_FULLMUTEX
      SQLITE_OPEN_MEMORY
      SQLITE_OPEN_NOMUTEX
      SQLITE_OPEN_PRIVATECACHE
      SQLITE_OPEN_READONLY
      SQLITE_OPEN_READWRITE
      SQLITE_OPEN_SHAREDCACHE
      SQLITE_OPEN_URI
    /],

    function_flags => [qw/
      SQLITE_DETERMINISTIC
    /],

    fundamental_datatypes => [qw/
      SQLITE_BLOB
      SQLITE_FLOAT
      SQLITE_INTEGER
      SQLITE_NULL
    /],

    result_codes => [qw/
      SQLITE_ABORT
      SQLITE_AUTH
      SQLITE_BUSY
      SQLITE_CANTOPEN
      SQLITE_CONSTRAINT
      SQLITE_CORRUPT
      SQLITE_DONE
      SQLITE_EMPTY
      SQLITE_ERROR
      SQLITE_FORMAT
      SQLITE_FULL
      SQLITE_INTERNAL
      SQLITE_INTERRUPT
      SQLITE_IOERR
      SQLITE_LOCKED
      SQLITE_MISMATCH
      SQLITE_MISUSE
      SQLITE_NOLFS
      SQLITE_NOMEM
      SQLITE_NOTADB
      SQLITE_NOTFOUND
      SQLITE_NOTICE
      SQLITE_OK
      SQLITE_PERM
      SQLITE_PROTOCOL
      SQLITE_RANGE
      SQLITE_READONLY
      SQLITE_ROW
      SQLITE_SCHEMA
      SQLITE_TOOBIG
      SQLITE_WARNING
    /],

    run_time_limit_categories => [qw/
      SQLITE_LIMIT_ATTACHED
      SQLITE_LIMIT_COLUMN
      SQLITE_LIMIT_COMPOUND_SELECT
      SQLITE_LIMIT_EXPR_DEPTH
      SQLITE_LIMIT_FUNCTION_ARG
      SQLITE_LIMIT_LENGTH
      SQLITE_LIMIT_LIKE_PATTERN_LENGTH
      SQLITE_LIMIT_SQL_LENGTH
      SQLITE_LIMIT_TRIGGER_DEPTH
      SQLITE_LIMIT_VARIABLE_NUMBER
      SQLITE_LIMIT_VDBE_OP
      SQLITE_LIMIT_WORKER_THREADS
    /],

);
$EXPORT_TAGS{version} = $EXPORT_TAGS{compile_time_library_version_numbers};
$EXPORT_TAGS{file_open} = $EXPORT_TAGS{flags_for_file_open_operations};
$EXPORT_TAGS{datatypes} = $EXPORT_TAGS{fundamental_datatypes};

1;

__END__

=encoding utf-8

=head1 NAME

DBD::SQLite::Constants - common SQLite constants

=head1 SYNOPSIS

  DBD::SQLite::Constants qw/:result_codes/;

=head1 DESCRIPTION

You can import necessary SQLite constants from this module. Available tags are C<all>, C<authorizer_action_codes>, C<authorizer_return_codes>, C<version> (C<compile_time_library_version_numbers>), C<extended_result_codes>, C<file_open> (C<flags_for_file_open_operations>), C<function_flags>, C<datatypes> (C<fundamental_datatypes>), C<result_codes>, C<run_time_limit_categories>. See L<http://sqlite.org/c3ref/constlist.html> for the complete list of constants.

This module does not export anything by default.

=head1 CONSTANTS

=head2 authorizer_action_codes

=over 4

=item SQLITE_CREATE_INDEX

=item SQLITE_CREATE_TABLE

=item SQLITE_CREATE_TEMP_INDEX

=item SQLITE_CREATE_TEMP_TABLE

=item SQLITE_CREATE_TEMP_TRIGGER

=item SQLITE_CREATE_TEMP_VIEW

=item SQLITE_CREATE_TRIGGER

=item SQLITE_CREATE_VIEW

=item SQLITE_DELETE

=item SQLITE_DROP_INDEX

=item SQLITE_DROP_TABLE

=item SQLITE_DROP_TEMP_INDEX

=item SQLITE_DROP_TEMP_TABLE

=item SQLITE_DROP_TEMP_TRIGGER

=item SQLITE_DROP_TEMP_VIEW

=item SQLITE_DROP_TRIGGER

=item SQLITE_DROP_VIEW

=item SQLITE_INSERT

=item SQLITE_PRAGMA

=item SQLITE_READ

=item SQLITE_SELECT

=item SQLITE_TRANSACTION

=item SQLITE_UPDATE

=item SQLITE_ATTACH

=item SQLITE_DETACH

=item SQLITE_ALTER_TABLE

=item SQLITE_REINDEX

=item SQLITE_ANALYZE

=item SQLITE_CREATE_VTABLE

=item SQLITE_DROP_VTABLE

=item SQLITE_FUNCTION

=item SQLITE_COPY

=item SQLITE_SAVEPOINT

=item SQLITE_RECURSIVE

=back

=head2 authorizer_return_codes

=over 4

=item SQLITE_DENY

=item SQLITE_IGNORE

=back

=head2 version (compile_time_library_version_numbers)

=over 4

=item SQLITE_VERSION_NUMBER

=back

=head2 extended_result_codes

=over 4

=item SQLITE_IOERR_LOCK

=item SQLITE_IOERR_READ

=item SQLITE_IOERR_SHORT_READ

=item SQLITE_IOERR_WRITE

=item SQLITE_IOERR_FSYNC

=item SQLITE_IOERR_DIR_FSYNC

=item SQLITE_IOERR_TRUNCATE

=item SQLITE_IOERR_FSTAT

=item SQLITE_IOERR_UNLOCK

=item SQLITE_IOERR_RDLOCK

=item SQLITE_IOERR_DELETE

=item SQLITE_IOERR_BLOCKED

=item SQLITE_IOERR_NOMEM

=item SQLITE_IOERR_ACCESS

=item SQLITE_IOERR_CHECKRESERVEDLOCK

=item SQLITE_IOERR_CLOSE

=item SQLITE_IOERR_DIR_CLOSE

=item SQLITE_LOCKED_SHAREDCACHE

=item SQLITE_IOERR_SHMOPEN

=item SQLITE_IOERR_SHMSIZE

=item SQLITE_IOERR_SHMLOCK

=item SQLITE_BUSY_RECOVERY

=item SQLITE_CANTOPEN_NOTEMPDIR

=item SQLITE_IOERR_SHMMAP

=item SQLITE_IOERR_SEEK

=item SQLITE_CORRUPT_VTAB

=item SQLITE_READONLY_RECOVERY

=item SQLITE_READONLY_CANTLOCK

=item SQLITE_ABORT_ROLLBACK

=item SQLITE_CANTOPEN_ISDIR

=item SQLITE_IOERR_DELETE_NOENT

=item SQLITE_CANTOPEN_FULLPATH

=item SQLITE_READONLY_ROLLBACK

=item SQLITE_CONSTRAINT_CHECK

=item SQLITE_CONSTRAINT_COMMITHOOK

=item SQLITE_CONSTRAINT_FOREIGNKEY

=item SQLITE_CONSTRAINT_FUNCTION

=item SQLITE_CONSTRAINT_NOTNULL

=item SQLITE_CONSTRAINT_PRIMARYKEY

=item SQLITE_CONSTRAINT_TRIGGER

=item SQLITE_CONSTRAINT_UNIQUE

=item SQLITE_CONSTRAINT_VTAB

=item SQLITE_IOERR_MMAP

=item SQLITE_NOTICE_RECOVER_WAL

=item SQLITE_NOTICE_RECOVER_ROLLBACK

=item SQLITE_IOERR_GETTEMPPATH

=item SQLITE_BUSY_SNAPSHOT

=item SQLITE_WARNING_AUTOINDEX

=item SQLITE_IOERR_CONVPATH

=item SQLITE_CANTOPEN_CONVPATH

=item SQLITE_CONSTRAINT_ROWID

=item SQLITE_READONLY_DBMOVED

=item SQLITE_AUTH_USER

=item SQLITE_IOERR_VNODE

=item SQLITE_IOERR_AUTH

=item SQLITE_IOERR_BEGIN_ATOMIC

=item SQLITE_IOERR_COMMIT_ATOMIC

=item SQLITE_IOERR_ROLLBACK_ATOMIC

=item SQLITE_ERROR_MISSING_COLLSEQ

=item SQLITE_ERROR_RETRY

=item SQLITE_READONLY_CANTINIT

=item SQLITE_READONLY_DIRECTORY

=item SQLITE_LOCKED_VTAB

=item SQLITE_CORRUPT_SEQUENCE

=item SQLITE_ERROR_SNAPSHOT

=item SQLITE_CANTOPEN_DIRTYWAL

=back

=head2 file_open (flags_for_file_open_operations)

=over 4

=item SQLITE_OPEN_READONLY

=item SQLITE_OPEN_READWRITE

=item SQLITE_OPEN_CREATE

=item SQLITE_OPEN_NOMUTEX

=item SQLITE_OPEN_FULLMUTEX

=item SQLITE_OPEN_SHAREDCACHE

=item SQLITE_OPEN_PRIVATECACHE

=item SQLITE_OPEN_URI

=item SQLITE_OPEN_MEMORY

=back

=head2 function_flags

=over 4

=item SQLITE_DETERMINISTIC

=back

=head2 datatypes (fundamental_datatypes)

=over 4

=item SQLITE_INTEGER

=item SQLITE_FLOAT

=item SQLITE_BLOB

=item SQLITE_NULL

=back

=head2 result_codes

=over 4

=item SQLITE_OK

=item SQLITE_ERROR

=item SQLITE_INTERNAL

=item SQLITE_PERM

=item SQLITE_ABORT

=item SQLITE_BUSY

=item SQLITE_LOCKED

=item SQLITE_NOMEM

=item SQLITE_READONLY

=item SQLITE_INTERRUPT

=item SQLITE_IOERR

=item SQLITE_CORRUPT

=item SQLITE_NOTFOUND

=item SQLITE_FULL

=item SQLITE_CANTOPEN

=item SQLITE_PROTOCOL

=item SQLITE_EMPTY

=item SQLITE_SCHEMA

=item SQLITE_TOOBIG

=item SQLITE_CONSTRAINT

=item SQLITE_MISMATCH

=item SQLITE_MISUSE

=item SQLITE_NOLFS

=item SQLITE_AUTH

=item SQLITE_FORMAT

=item SQLITE_RANGE

=item SQLITE_NOTADB

=item SQLITE_ROW

=item SQLITE_DONE

=item SQLITE_NOTICE

=item SQLITE_WARNING

=back

=head2 run_time_limit_categories

=over 4

=item SQLITE_LIMIT_LENGTH

=item SQLITE_LIMIT_SQL_LENGTH

=item SQLITE_LIMIT_COLUMN

=item SQLITE_LIMIT_EXPR_DEPTH

=item SQLITE_LIMIT_COMPOUND_SELECT

=item SQLITE_LIMIT_VDBE_OP

=item SQLITE_LIMIT_FUNCTION_ARG

=item SQLITE_LIMIT_ATTACHED

=item SQLITE_LIMIT_LIKE_PATTERN_LENGTH

=item SQLITE_LIMIT_VARIABLE_NUMBER

=item SQLITE_LIMIT_TRIGGER_DEPTH

=item SQLITE_LIMIT_WORKER_THREADS

=back

