use v6.c;

role ThisMarginalNumber { 
	### single marginal number for a marginal distribution based upon
	### this column or row
	method GeneratedNumber() {

		my $sum = 0.0;

		for @.population -> $p {
			$sum += $p;	
		}
		return $sum;
	}
}

use Mathx::Stat::Population;

class Mathx::Stat::DistributionPopulation is Mathx::Stat::Population does ThisMarginalNumber 
{
	method Expectance() {

		my $e = 0.0;

		for @.population -> $p {
			$e += $p;
		}

		return $e / @.population.elems;
	}

	method Variance () {
		my $e = self.Expectance();
		my $var = 0.0;

		for @.population -> $p {
			$var += ($p - $e) * ($p - $e);
		}

		return $var / (@.population.elems - 1);
	}

}
