use SDL;

class Game::QFG::AI {

	has @!msg-list is rw;  ### the message list to be processed
	has @!msg-return-values is rw; ### the message responses of a pass msg

	method BUILD() {

	}

	# The common message methods

	### dispatch message to entity
	method pass-message($entity, $msg) {

		return $entity.pass-message($msg);

	}

	### do something with the return message, after method of dispatch
	method accept-message($return-msg) {

	}

	### put away return message in attribute list
	method keep-return-message($return-msg) {

		if ($return-msg == Nil) {
			return;
		}

		push (@!msg-return-values, $return-msg);

		self.accept-message($return-msg);
	}

	### single send to acceptor/receiver entity
	method send-message-to-target($msg, @entities) {

		for @entities -> $k {
			if ($k === $msg.acceptor) {
				self.keep-return-message(self.pass-message($k, $msg));
				return;
			}
		}
	}

	# The flush methods, dispatching every message available

	### flush everything, without targets, evrything is a target
	method flush-messages-to-all-entities(@entities) {

		for @entities -> $k {
			for @!msg-list -> $msg {
				self.keep-return-message(self.pass-message($k, $msg));
			}
		}	

		@!msg-list = Empty;

	}

	### flush FIFO stacked first message in attribute list to all entities
	method flush-first-message-to-entities(@entities) {

		if (@!msg-list.elems == 0) {
			return Nil;
		}

		my $msg = @!msg-list[0];

		for @entities -> $k {
			self.keep-return-message(self.pass-message($k, $msg));
		}	

		if (@!msg-list.elems > 1) { ### kludge
			@!msg-list = @!msg-list[1..^@!msg-list.elems];
		} else {
			@!msg-list = Empty;
		}
	}

	### flush given message to every entity
	method flush-message-to-entities($msg, @entities) {

		for @entities -> $k {
			self.keep-return-message(self.pass-message($k, $msg));
		}
	}

}
