# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl 1.t'

# Note:
# This test requires internet connection.
# And it will take several minutes to progress.

use Test::More tests => 5;

BEGIN {
	use_ok('Finance::YahooJPN::QuoteHist')
};

# Sony Corp. at Tokyo market.
my $obj = Finance::YahooJPN::QuoteHist->new('6758.t');
isa_ok($obj, 'Finance::YahooJPN::QuoteHist');

$obj->fetch('start' => '1991-09-20');
$obj->extract('noadjust' => 1);
my @quotes = $obj->output();
my $quotes = join "\n", @quotes[0..2932];

my $expected = '1991-09-20	5730	5770	5700	5720	683000
1991-09-24	5730	5830	5720	5830	782700
1991-09-25	5480	5500	5300	5340	914800
1991-09-26	5370	5450	5330	5440	760100
1991-09-27	5440	5530	5440	5460	761300
1991-09-30	5400	5430	5380	5420	385600
1991-10-01	5380	5440	5380	5400	669800
1991-10-02	5440	5470	5390	5440	744800
1991-10-03	5450	5450	5320	5380	782100
1991-10-04	5320	5330	5190	5200	951200
1991-10-07	5160	5240	5150	5150	584500
1991-10-08	5130	5180	5100	5160	453800
1991-10-09	5190	5320	5190	5320	498000
1991-10-11	5220	5260	5150	5180	401200
1991-10-14	5190	5200	5100	5100	354600
1991-10-15	5160	5170	5100	5150	349400
1991-10-16	5150	5190	5110	5190	337800
1991-10-17	5170	5200	5150	5150	389200
1991-10-18	5140	5200	5120	5200	549500
1991-10-21	5200	5200	5030	5050	624000
1991-10-22	5040	5120	5030	5080	499200
1991-10-23	5060	5120	5050	5120	325800
1991-10-24	5130	5240	5130	5190	618400
1991-10-25	5190	5200	5150	5160	571300
1991-10-28	5200	5230	5160	5160	207800
1991-10-29	5200	5300	5190	5300	457200
1991-10-30	5270	5280	5200	5250	326700
1991-10-31	5200	5240	5170	5240	485900
1991-11-01	5230	5230	5150	5160	513700
1991-11-05	5150	5160	5140	5150	258800
1991-11-06	5130	5140	5100	5120	199000
1991-11-07	5050	5100	5030	5030	613600
1991-11-08	5120	5120	5000	5000	546100
1991-11-11	5010	5040	4960	4960	369900
1991-11-12	5000	5060	4980	5010	383100
1991-11-13	5040	5070	4990	5000	502200
1991-11-14	5000	5010	4900	4900	531500
1991-11-15	4900	4920	4780	4790	829900
1991-11-18	4690	4750	4690	4750	629900
1991-11-19	4850	4900	4790	4800	675400
1991-11-20	4750	4790	4700	4710	611800
1991-11-21	4660	4680	4520	4580	1013500
1991-11-22	4540	4570	4500	4500	930900
1991-11-25	4450	4490	4410	4430	420100
1991-11-26	4380	4430	4340	4400	742700
1991-11-27	4420	4440	4350	4350	579800
1991-11-28	4340	4420	4310	4370	760600
1991-11-29	4370	4450	4350	4350	687900
1991-12-02	4350	4360	4220	4220	515500
1991-12-03	4270	4360	4240	4330	868800
1991-12-04	4330	4430	4330	4360	832200
1991-12-05	4310	4330	4260	4260	619100
1991-12-06	4280	4300	4220	4250	575500
1991-12-09	4210	4230	4200	4220	423800
1991-12-10	4200	4200	4080	4100	460000
1991-12-11	4050	4130	4020	4130	968500
1991-12-12	4170	4230	4140	4140	647400
1991-12-13	4290	4290	4150	4180	2334000
1991-12-16	4230	4420	4200	4300	313400
1991-12-17	4340	4400	4320	4360	421700
1991-12-18	4240	4260	4130	4190	759700
1991-12-19	4100	4140	4050	4050	617600
1991-12-20	4100	4130	4030	4030	849600
1991-12-24	4100	4120	3980	3990	567700
1991-12-25	4010	4150	4000	4140	514300
1991-12-26	4120	4140	4040	4070	396600
1991-12-27	4130	4130	4010	4030	308600
1991-12-30	4100	4150	4080	4100	348200
1992-01-06	4400	4420	4350	4400	481200
1992-01-07	4350	4390	4300	4300	316200
1992-01-08	4170	4170	4080	4080	311600
1992-01-09	4130	4130	4050	4060	468600
1992-01-10	4060	4070	4010	4020	644500
1992-01-13	4020	4030	3980	4000	396600
1992-01-14	4000	4030	3980	4000	458100
1992-01-16	4150	4180	4060	4080	589700
1992-01-17	4080	4160	4010	4100	472700
1992-01-20	4070	4100	4020	4100	441000
1992-01-21	4130	4200	4060	4100	570900
1992-01-22	4150	4290	4110	4270	1063800
1992-01-23	4290	4350	4250	4260	928900
1992-01-24	4210	4230	4160	4200	356900
1992-01-27	4170	4240	4130	4240	305700
1992-01-28	4210	4300	4210	4250	197300
1992-01-29	4300	4340	4260	4280	464200
1992-01-30	4240	4300	4220	4220	516100
1992-01-31	4270	4330	4240	4240	806500
1992-02-03	4290	4340	4270	4340	430700
1992-02-04	4310	4420	4300	4360	1037800
1992-02-05	4370	4430	4350	4360	756700
1992-02-06	4350	4380	4290	4310	637000
1992-02-07	4360	4380	4280	4280	450200
1992-02-10	4280	4300	4240	4250	268700
1992-02-12	4260	4260	4210	4210	290100
1992-02-13	4210	4250	4180	4210	622100
1992-02-14	4210	4230	4100	4180	536600
1992-02-17	4110	4250	4100	4250	443700
1992-02-18	4130	4220	4120	4160	384600
1992-02-19	3960	4020	3950	4000	1221000
1992-02-20	3960	4030	3950	4010	719500
1992-02-21	4030	4070	4000	4020	706300
1992-02-24	4050	4060	4030	4050	426900
1992-02-25	4030	4050	4020	4020	358400
1992-02-26	4030	4060	4020	4020	507500
1992-02-27	4090	4100	4040	4050	324200
1992-02-28	4060	4090	4050	4080	318100
1992-03-02	4080	4110	4060	4070	366700
1992-03-03	4080	4100	4060	4060	368000
1992-03-04	4050	4070	4030	4070	212000
1992-03-05	4060	4070	4010	4010	450700
1992-03-06	4010	4020	3990	4000	417800
1992-03-09	3980	4000	3950	3950	356900
1992-03-10	3950	3950	3900	3900	516000
1992-03-11	3900	3910	3860	3860	518300
1992-03-12	3830	3950	3800	3940	610100
1992-03-13	3890	4000	3890	3960	2103200
1992-03-16	3950	3950	3900	3920	336200
1992-03-17	3900	3950	3890	3930	771300
1992-03-18	3930	3960	3910	3950	850200
1992-03-19	3900	4100	3900	3930	2064500
1992-03-23	4030	4110	4020	4100	1094900
1992-03-24	4100	4110	4050	4080	732800
1992-03-25	4060	4150	4040	4150	874500
1992-03-26	4150	4150	4040	4040	544900
1992-03-27	4090	4090	4000	4000	398400
1992-03-30	4020	4100	4000	4050	396600
1992-03-31	4110	4120	4040	4050	420300
1992-04-01	4070	4070	3990	4000	707000
1992-04-02	4050	4060	3950	4050	907600
1992-04-03	4070	4130	3980	4110	1156200
1992-04-06	4110	4110	4050	4060	725300
1992-04-07	4080	4090	4010	4020	563100
1992-04-08	4000	4050	3950	4010	751800
1992-04-09	4020	4080	3980	3990	876400
1992-04-10	4120	4230	4090	4230	1340100
1992-04-13	4250	4250	4040	4080	1123500
1992-04-14	4100	4170	4040	4110	1019000
1992-04-15	4180	4320	4150	4300	1771000
1992-04-16	4300	4330	4250	4270	1204400
1992-04-17	4250	4280	4160	4190	696400
1992-04-20	4140	4190	4110	4120	501700
1992-04-21	4100	4200	4090	4150	756500
1992-04-22	4190	4230	4130	4230	697100
1992-04-23	4200	4340	4160	4300	1178900
1992-04-24	4300	4400	4250	4380	1128300
1992-04-27	4340	4410	4300	4310	866700
1992-04-28	4330	4360	4280	4330	481100
1992-04-30	4360	4390	4320	4330	448900
1992-05-01	4310	4360	4270	4300	492000
1992-05-06	4280	4380	4280	4330	441700
1992-05-07	4350	4400	4320	4400	568000
1992-05-08	4390	4530	4360	4480	1474300
1992-05-11	4480	4500	4440	4450	616500
1992-05-12	4480	4490	4410	4440	596600
1992-05-13	4400	4440	4340	4430	572700
1992-05-14	4410	4420	4360	4370	622900
1992-05-15	4370	4390	4250	4290	632500
1992-05-18	4340	4380	4300	4340	422100
1992-05-19	4350	4420	4330	4400	542000
1992-05-20	4350	4420	4350	4360	293600
1992-05-21	4320	4370	4310	4310	266100
1992-05-22	4310	4320	4250	4260	593000
1992-05-25	4240	4350	4240	4300	398300
1992-05-26	4270	4300	4210	4210	284000
1992-05-27	4190	4200	4050	4080	1112400
1992-05-28	4140	4290	4140	4290	1239000
1992-05-29	4290	4330	4280	4320	533700
1992-06-01	4310	4320	4280	4280	268800
1992-06-02	4290	4320	4280	4290	403900
1992-06-03	4310	4420	4310	4390	977500
1992-06-04	4400	4420	4350	4390	781700
1992-06-05	4360	4370	4320	4320	316600
1992-06-08	4350	4350	4250	4310	517300
1992-06-09	4260	4320	4260	4300	144300
1992-06-10	4260	4310	4240	4280	335500
1992-06-11	4290	4330	4280	4290	234900
1992-06-12	4240	4270	4100	4110	2773100
1992-06-15	4110	4120	4050	4050	565200
1992-06-16	4080	4140	4050	4070	444800
1992-06-17	4070	4090	4020	4020	489500
1992-06-18	4000	4100	3980	4010	800600
1992-06-19	4040	4160	4030	4160	420900
1992-06-22	4200	4200	4010	4010	518500
1992-06-23	4010	4070	4000	4050	437500
1992-06-24	4090	4120	4020	4030	525900
1992-06-25	4050	4250	4030	4250	873400
1992-06-26	4200	4220	4060	4110	757200
1992-06-29	4120	4130	4060	4110	533900
1992-06-30	4160	4170	4100	4120	507400
1992-07-01	4120	4190	4050	4190	517000
1992-07-02	4180	4230	4150	4230	609300
1992-07-03	4200	4250	4140	4180	428000
1992-07-06	4180	4230	4170	4180	134900
1992-07-07	4180	4200	4120	4140	171500
1992-07-08	4140	4160	4110	4160	188900
1992-07-09	4180	4220	4150	4200	354300
1992-07-10	4250	4250	4150	4180	811100
1992-07-13	4220	4280	4190	4260	496200
1992-07-14	4250	4280	4180	4210	408200
1992-07-15	4220	4260	4200	4210	277200
1992-07-16	4170	4200	4150	4150	271200
1992-07-17	4170	4170	4100	4100	510500
1992-07-20	4080	4080	3960	3960	682100
1992-07-21	3970	4030	3960	4030	656000
1992-07-22	4010	4030	3880	3940	1273700
1992-07-23	3900	4050	3890	3990	613200
1992-07-24	3970	3970	3850	3850	816400
1992-07-27	3990	3990	3810	3840	797200
1992-07-28	3810	3870	3790	3830	763500
1992-07-29	3910	3910	3770	3800	745200
1992-07-30	3850	3880	3800	3810	678100
1992-07-31	3850	3980	3840	3980	505100
1992-08-03	3970	4030	3950	3970	269100
1992-08-04	3970	4070	3970	4040	660800
1992-08-05	4040	4080	4000	4070	484400
1992-08-06	4040	4090	3970	4020	277900
1992-08-07	3980	4010	3910	3910	172700
1992-08-10	3870	3870	3810	3860	315000
1992-08-11	3870	3870	3750	3760	497100
1992-08-12	3740	3790	3730	3780	724900
1992-08-13	3790	3850	3750	3810	593600
1992-08-14	3770	3870	3770	3800	1041700
1992-08-17	3820	3850	3780	3790	534300
1992-08-18	3780	3780	3560	3560	929300
1992-08-19	3600	3610	3350	3540	1623000
1992-08-20	3670	3980	3600	3880	1301500
1992-08-21	3880	4070	3850	4070	1332000
1992-08-24	4060	4190	3950	4040	1113300
1992-08-25	3940	4020	3910	3970	581800
1992-08-26	3930	4010	3930	4010	463900
1992-08-27	4150	4290	4120	4290	1939800
1992-08-28	4190	4290	4180	4200	1282200
1992-08-31	4120	4240	4120	4200	771600
1992-09-01	4130	4160	4100	4100	407100
1992-09-02	4010	4040	3980	3990	396800
1992-09-03	4000	4150	4000	4140	821100
1992-09-04	4190	4260	4170	4220	1352100
1992-09-07	4210	4320	4210	4270	793600
1992-09-08	4250	4300	4200	4210	727000
1992-09-09	4160	4320	4140	4320	746600
1992-09-10	4270	4350	4260	4310	983100
1992-09-11	4320	4320	4110	4110	1880800
1992-09-14	4200	4250	4140	4210	423900
1992-09-16	4210	4260	4140	4240	536000
1992-09-17	4210	4320	4210	4280	886500
1992-09-18	4230	4290	4190	4280	529200
1992-09-21	4270	4320	4200	4200	474900
1992-09-22	4200	4290	4180	4250	658400
1992-09-24	4240	4240	4130	4130	670900
1992-09-25	4150	4180	4110	4150	526900
1992-09-28	4190	4230	4120	4150	424700
1992-09-29	4130	4170	4050	4140	413900
1992-09-30	4110	4110	3990	3990	650400
1992-10-01	4010	4050	3920	3970	674100
1992-10-02	4000	4020	3970	3970	432600
1992-10-05	3900	3950	3890	3930	379200
1992-10-06	3890	3950	3870	3930	720600
1992-10-07	3920	3970	3890	3890	291800
1992-10-08	3890	3950	3890	3930	287100
1992-10-09	3880	3960	3880	3950	1755300
1992-10-12	3950	4040	3930	4030	472000
1992-10-13	4030	4060	4000	4040	282900
1992-10-14	4090	4110	4070	4070	425500
1992-10-15	4090	4130	4070	4130	450300
1992-10-16	4130	4140	4030	4060	602700
1992-10-19	4060	4100	3960	3980	446500
1992-10-20	4030	4080	3980	4060	526700
1992-10-21	4050	4130	4020	4120	440000
1992-10-22	4110	4140	4090	4120	488700
1992-10-23	4100	4110	4050	4080	328100
1992-10-26	4060	4090	4030	4030	210100
1992-10-27	4020	4080	4020	4060	180500
1992-10-28	4100	4110	4020	4030	284200
1992-10-29	4000	4030	3980	3990	247200
1992-10-30	3990	4030	3960	4030	405900
1992-11-02	3980	4040	3960	4040	208700
1992-11-04	4000	4030	3970	4030	357000
1992-11-05	3980	4000	3920	3950	372800
1992-11-06	3930	3940	3900	3920	298100
1992-11-09	3850	3870	3820	3820	386600
1992-11-10	3830	3880	3820	3850	423400
1992-11-11	3860	3870	3820	3820	271200
1992-11-12	3820	3890	3770	3810	509300
1992-11-13	3780	3870	3770	3820	907900
1992-11-16	3780	3800	3740	3750	260700
1992-11-17	3730	3850	3690	3820	537500
1992-11-18	3840	4050	3820	3960	755000
1992-11-19	4040	4040	3810	3830	892800
1992-11-20	3780	3970	3770	3840	689600
1992-11-24	3860	3890	3810	3810	462900
1992-11-25	3810	3860	3800	3850	621700
1992-11-26	3890	4040	3890	4000	586500
1992-11-27	4000	4050	3990	4000	670600
1992-11-30	4040	4090	4010	4090	572900
1992-12-01	4100	4150	4070	4100	594300
1992-12-02	4120	4190	4110	4150	1058600
1992-12-03	4140	4150	4070	4100	458800
1992-12-04	4060	4090	4040	4050	267700
1992-12-07	4050	4080	4010	4080	285500
1992-12-08	4080	4170	4060	4140	694500
1992-12-09	4140	4160	4110	4140	470400
1992-12-10	4140	4170	4120	4120	452300
1992-12-11	4120	4140	4080	4110	1372200
1992-12-14	4110	4130	4090	4120	236000
1992-12-15	4070	4140	4060	4110	228000
1992-12-16	4110	4140	4100	4130	457100
1992-12-17	4130	4190	4110	4160	765300
1992-12-18	4180	4220	4180	4200	1006000
1992-12-21	4220	4250	4190	4250	650700
1992-12-22	4250	4290	4230	4290	745300
1992-12-24	4300	4310	4280	4300	815100
1992-12-25	4270	4310	4270	4310	873200
1992-12-28	4300	4300	4190	4230	335800
1992-12-29	4200	4260	4200	4260	317400
1992-12-30	4260	4290	4220	4260	379000
1993-01-04	4260	4280	4240	4250	242700
1993-01-05	4250	4270	4210	4240	481900
1993-01-06	4220	4250	4200	4250	406000
1993-01-07	4250	4270	4220	4220	471900
1993-01-08	4190	4230	4180	4180	809600
1993-01-11	4190	4190	4130	4160	289300
1993-01-12	4130	4160	4080	4110	380900
1993-01-13	4110	4110	4060	4060	280200
1993-01-14	4070	4080	4050	4060	231600
1993-01-18	4090	4130	4080	4130	367000
1993-01-19	4160	4210	4150	4210	354500
1993-01-20	4240	4240	4180	4200	376700
1993-01-21	4200	4210	4180	4210	405900
1993-01-22	4210	4210	4110	4110	384600
1993-01-25	4140	4150	4060	4090	540900
1993-01-26	4090	4130	4060	4100	285900
1993-01-27	4090	4120	4070	4070	446900
1993-01-28	4070	4120	4030	4120	583700
1993-01-29	4100	4120	4080	4100	351300
1993-02-01	4100	4120	4070	4100	235100
1993-02-02	4120	4150	4110	4150	358900
1993-02-03	4140	4140	4100	4140	497900
1993-02-04	4140	4150	4110	4140	491500
1993-02-05	4140	4200	4140	4180	562300
1993-02-08	4180	4180	4130	4130	239000
1993-02-09	4150	4170	4110	4140	403900
1993-02-10	4110	4110	4070	4080	356600
1993-02-12	4080	4080	4060	4060	706800
1993-02-15	4090	4140	4080	4110	529900
1993-02-16	4120	4150	4100	4150	490400
1993-02-17	4060	4120	4060	4120	336300
1993-02-18	4110	4120	4070	4100	629400
1993-02-19	4080	4080	3990	4000	827400
1993-02-22	3960	3970	3900	3900	550700
1993-02-23	3850	3920	3850	3910	769600
1993-02-24	3880	3910	3850	3880	300800
1993-02-25	3900	3930	3890	3920	545100
1993-02-26	3950	4000	3940	3980	639400
1993-03-01	4000	4000	3960	3990	253600
1993-03-02	3990	4000	3970	3970	377500
1993-03-03	3990	4000	3900	3910	414400
1993-03-04	3880	3930	3870	3930	618900
1993-03-05	3910	3950	3890	3920	522000
1993-03-08	3950	4140	3950	4000	1109600
1993-03-09	4050	4150	4050	4100	1210100
1993-03-10	4090	4130	4070	4130	778700
1993-03-11	4140	4180	4130	4160	790400
1993-03-12	4110	4150	4070	4110	1586400
1993-03-15	4060	4100	4050	4060	442800
1993-03-16	4060	4070	4030	4070	491700
1993-03-17	4060	4070	4030	4070	289000
1993-03-18	4080	4170	4080	4130	575800
1993-03-19	4080	4120	4010	4010	576800
1993-03-22	4100	4110	4050	4110	461800
1993-03-23	4100	4170	4070	4150	671700
1993-03-24	4110	4170	4100	4100	650300
1993-03-25	4120	4170	4090	4100	505700
1993-03-26	4150	4290	4140	4230	1405700
1993-03-29	4290	4490	4280	4470	1461300
1993-03-30	4480	4620	4470	4590	1916500
1993-03-31	4580	4600	4380	4430	1115000
1993-04-01	4380	4420	4270	4400	731000
1993-04-02	4400	4480	4300	4320	1253600
1993-04-05	4420	4550	4340	4490	1254300
1993-04-06	4490	4540	4450	4530	913600
1993-04-07	4600	5030	4560	4950	3725500
1993-04-08	4920	5030	4830	5000	2662400
1993-04-09	4980	5040	4770	4840	2601200
1993-04-12	4850	4860	4720	4800	710000
1993-04-13	4760	5040	4760	5000	1323200
1993-04-14	5080	5100	4930	4980	1997000
1993-04-15	4990	5000	4870	4960	748500
1993-04-16	4950	4950	4830	4860	554000
1993-04-19	4760	4800	4670	4770	797800
1993-04-20	4720	4820	4600	4650	865000
1993-04-21	4680	4740	4640	4650	881600
1993-04-22	4720	4840	4640	4690	1189000
1993-04-23	4660	4740	4650	4700	695900
1993-04-26	4740	4790	4680	4730	741000
1993-04-27	4750	4940	4750	4900	1136600
1993-04-28	5000	5050	4940	4990	2594500
1993-04-30	5010	5040	4960	5000	1180300
1993-05-06	5020	5020	4880	4910	1082600
1993-05-07	4910	4920	4830	4890	686000
1993-05-10	4840	4890	4800	4850	638500
1993-05-11	4950	4960	4900	4930	601400
1993-05-12	4900	4910	4750	4780	1097400
1993-05-13	4800	4880	4780	4780	1024500
1993-05-14	4790	4840	4750	4750	1038800
1993-05-17	4750	4780	4720	4720	358500
1993-05-18	4700	4710	4650	4650	616600
1993-05-19	4610	4710	4600	4710	511800
1993-05-20	4700	4700	4600	4680	493100
1993-05-21	4660	4760	4660	4730	599900
1993-05-24	4760	4780	4670	4670	377200
1993-05-25	4650	4690	4650	4650	550300
1993-05-26	4620	4640	4600	4630	614000
1993-05-27	4610	4660	4550	4570	629600
1993-05-28	4570	4610	4550	4550	636500
1993-05-31	4510	4540	4490	4490	467500
1993-06-01	4490	4570	4490	4530	421300
1993-06-02	4560	4680	4530	4620	475000
1993-06-03	4680	4800	4670	4730	686300
1993-06-04	4730	4770	4660	4690	709800
1993-06-07	4650	4720	4620	4640	302900
1993-06-08	4640	4660	4550	4580	531500
1993-06-10	4570	4580	4500	4560	719000
1993-06-11	4610	4610	4500	4510	1777600
1993-06-14	4500	4510	4400	4400	753500
1993-06-15	4350	4380	4260	4290	760400
1993-06-16	4320	4360	4290	4320	809900
1993-06-17	4320	4380	4250	4310	1066400
1993-06-18	4330	4390	4310	4360	866700
1993-06-21	4390	4450	4370	4410	902300
1993-06-22	4410	4460	4380	4430	653700
1993-06-23	4410	4430	4330	4350	539500
1993-06-24	4320	4370	4320	4330	306800
1993-06-25	4360	4370	4270	4300	530700
1993-06-28	4270	4340	4270	4300	249900
1993-06-29	4300	4350	4270	4270	332800
1993-06-30	4270	4300	4240	4290	765500
1993-07-01	4290	4340	4290	4330	512200
1993-07-02	4370	4370	4260	4280	581700
1993-07-05	4300	4320	4270	4280	214400
1993-07-06	4280	4370	4280	4350	376000
1993-07-07	4350	4360	4300	4300	409000
1993-07-08	4300	4300	4250	4250	480500
1993-07-09	4280	4360	4280	4350	942700
1993-07-12	4400	4430	4370	4430	505200
1993-07-13	4430	4580	4410	4540	991900
1993-07-14	4530	4570	4500	4570	596400
1993-07-15	4560	4610	4530	4570	961900
1993-07-16	4550	4690	4540	4670	1238600
1993-07-19	4660	4690	4570	4650	860900
1993-07-20	4620	4640	4590	4610	406300
1993-07-21	4520	4580	4520	4530	471200
1993-07-22	4530	4620	4530	4580	472100
1993-07-23	4510	4540	4470	4470	419500
1993-07-26	4490	4490	4430	4430	243400
1993-07-27	4450	4450	4390	4410	294800
1993-07-28	4450	4460	4370	4380	285600
1993-07-29	4390	4600	4380	4590	761800
1993-07-30	4540	4600	4470	4500	521400
1993-08-02	4450	4460	4380	4410	350000
1993-08-03	4420	4550	4400	4410	406500
1993-08-04	4390	4520	4390	4460	584800
1993-08-05	4470	4500	4450	4450	304600
1993-08-06	4410	4430	4380	4420	483000
1993-08-09	4420	4500	4420	4490	650800
1993-08-10	4500	4520	4460	4490	609900
1993-08-11	4480	4490	4410	4430	486800
1993-08-12	4450	4450	4370	4370	690900
1993-08-13	4370	4380	4320	4380	738600
1993-08-16	4300	4370	4300	4370	302400
1993-08-17	4400	4450	4330	4350	315300
1993-08-18	4350	4390	4340	4340	409400
1993-08-19	4380	4400	4310	4350	425200
1993-08-20	4430	4460	4390	4460	737500
1993-08-23	4490	4490	4440	4480	251200
1993-08-24	4450	4500	4440	4460	335200
1993-08-25	4470	4480	4430	4460	351200
1993-08-26	4470	4470	4430	4460	223300
1993-08-27	4460	4520	4450	4480	556200
1993-08-30	4500	4520	4490	4510	305100
1993-08-31	4520	4590	4510	4570	448000
1993-09-01	4540	4650	4540	4630	784900
1993-09-02	4610	4680	4600	4620	905300
1993-09-03	4620	4720	4620	4670	1169700
1993-09-06	4700	4720	4660	4660	641000
1993-09-07	4660	4660	4610	4620	240400
1993-09-08	4620	4670	4600	4660	348300
1993-09-09	4660	4670	4640	4660	256100
1993-09-10	4630	4660	4560	4600	1533700
1993-09-13	4610	4630	4550	4610	456500
1993-09-14	4600	4600	4480	4530	439700
1993-09-16	4530	4530	4400	4440	440500
1993-09-17	4410	4410	4320	4350	804900
1993-09-20	4360	4400	4330	4330	368500
1993-09-21	4380	4430	4360	4400	787600
1993-09-22	4390	4470	4370	4470	810800
1993-09-24	4500	4580	4480	4580	758800
1993-09-27	4590	4600	4490	4490	428400
1993-09-28	4550	4550	4520	4530	393300
1993-09-29	4530	4600	4460	4590	523000
1993-09-30	4590	4590	4500	4510	205600
1993-10-01	4550	4600	4530	4560	399800
1993-10-04	4550	4610	4540	4610	378800
1993-10-05	4630	4680	4610	4650	308100
1993-10-06	4640	4640	4610	4620	374000
1993-10-07	4610	4630	4580	4580	370900
1993-10-08	4580	4620	4540	4560	526100
1993-10-12	4590	4620	4530	4540	509500
1993-10-13	4520	4530	4470	4500	544100
1993-10-14	4460	4490	4450	4490	361000
1993-10-15	4530	4660	4520	4610	1193300
1993-10-18	4700	4840	4700	4800	1902300
1993-10-19	4790	4810	4760	4760	959300
1993-10-20	4770	4850	4760	4830	1641700
1993-10-21	4860	4880	4790	4800	1526200
1993-10-22	4850	4930	4840	4900	2731100
1993-10-25	4950	4970	4920	4950	1418000
1993-10-26	4920	5000	4900	4900	1651500
1993-10-27	4900	4930	4750	4850	927400
1993-10-28	4900	4960	4790	4850	1164000
1993-10-29	4900	4940	4850	4920	891200
1993-11-01	4930	4970	4900	4960	849000
1993-11-02	4940	5010	4930	4970	2153600
1993-11-04	4970	5010	4920	4930	1244300
1993-11-05	4910	4980	4830	4950	1963800
1993-11-08	4920	4940	4870	4910	772500
1993-11-09	4910	4910	4760	4790	1002000
1993-11-10	4800	4860	4720	4820	944800
1993-11-11	4840	4890	4810	4810	678400
1993-11-12	4820	4900	4810	4890	1464400
1993-11-15	4880	4890	4810	4810	835500
1993-11-16	4780	4900	4750	4860	1051300
1993-11-17	4850	4900	4830	4850	359500
1993-11-18	4900	4950	4840	4840	917100
1993-11-19	4860	4930	4830	4840	737300
1993-11-22	4810	4820	4680	4750	1012800
1993-11-24	4750	4800	4620	4650	676900
1993-11-25	4700	4730	4630	4690	520600
1993-11-26	4740	4780	4600	4630	734900
1993-11-29	4560	4590	4420	4590	860800
1993-11-30	4640	4780	4600	4670	1105700
1993-12-01	4740	4890	4690	4860	752000
1993-12-02	4870	5000	4830	4930	1794200
1993-12-03	4830	4930	4830	4930	671300
1993-12-06	4850	4870	4760	4840	671400
1993-12-07	4860	4950	4850	4920	691800
1993-12-08	4900	4920	4850	4920	947500
1993-12-09	4970	5030	4960	5030	1836400
1993-12-10	5030	5230	5020	5200	4424000
1993-12-13	5220	5400	5190	5340	3216300
1993-12-14	5360	5360	5270	5310	1419600
1993-12-15	5290	5430	5280	5430	3247600
1993-12-16	5530	5570	5490	5500	3062000
1993-12-17	5480	5520	5410	5510	1762200
1993-12-20	5530	5550	5410	5440	1969600
1993-12-21	5430	5470	5370	5440	1472500
1993-12-22	5500	5530	5390	5440	1914800
1993-12-24	5440	5460	5370	5400	765700
1993-12-27	5340	5400	5310	5390	536000
1993-12-28	5400	5490	5400	5480	592100
1993-12-29	5460	5540	5460	5510	1022800
1993-12-30	5510	5540	5450	5510	569000
1994-01-04	5530	5620	5490	5620	1096900
1994-01-05	5660	5840	5660	5840	3072800
1994-01-06	5860	5920	5760	5790	2548900
1994-01-07	5740	5790	5730	5750	1390300
1994-01-10	5850	5920	5820	5890	3528300
1994-01-11	5930	5930	5780	5790	1678200
1994-01-12	5780	5800	5710	5780	1436300
1994-01-13	5790	5970	5770	5880	3362700
1994-01-14	5900	5930	5840	5900	1250200
1994-01-17	5850	5940	5830	5930	887500
1994-01-18	5900	5970	5830	5830	1375200
1994-01-19	5850	5950	5840	5930	1540800
1994-01-20	5950	5970	5850	5870	1841000
1994-01-21	5870	5870	5830	5860	1088000
1994-01-24	5600	5700	5600	5660	1601500
1994-01-25	5760	5770	5690	5770	1040500
1994-01-26	5810	5870	5770	5870	1193000
1994-01-27	5820	5990	5820	5850	2284900
1994-01-28	5790	5870	5760	5830	1358500
1994-01-31	6130	6390	6090	6370	4473900
1994-02-01	6390	6450	6270	6400	3160000
1994-02-02	6260	6280	6150	6170	1964500
1994-02-03	6240	6270	6100	6190	1250600
1994-02-04	6200	6280	6190	6280	1372800
1994-02-07	6280	6300	6230	6290	684500
1994-02-08	6350	6410	6300	6310	1499400
1994-02-09	6330	6330	6100	6190	928700
1994-02-10	6200	6290	6150	6290	997200
1994-02-14	6110	6140	6030	6050	1546700
1994-02-15	5750	5900	5750	5870	1288400
1994-02-16	5970	5990	5820	5860	860100
1994-02-17	5850	5860	5740	5800	1087300
1994-02-18	5920	6030	5900	6030	1460000
1994-02-21	6000	6140	5980	6110	1229000
1994-02-22	6150	6190	6070	6110	1073900
1994-02-23	6150	6180	6110	6140	724400
1994-02-24	6280	6320	6250	6300	1821900
1994-02-25	6240	6400	6230	6370	2280000
1994-02-28	6390	6460	6370	6400	1974100
1994-03-01	6440	6440	6340	6400	988800
1994-03-02	6300	6350	6180	6180	817700
1994-03-03	6180	6210	6030	6060	920400
1994-03-04	6080	6240	6060	6180	1507100
1994-03-07	6270	6360	6210	6240	980500
1994-03-08	6240	6300	6190	6220	711500
1994-03-09	6200	6220	6160	6190	440800
1994-03-10	6230	6290	6230	6260	435200
1994-03-11	6360	6360	6250	6260	1824100
1994-03-14	6300	6350	6270	6300	727700
1994-03-15	6380	6390	6320	6330	613100
1994-03-16	6390	6410	6340	6350	1203800
1994-03-17	6360	6400	6290	6390	583900
1994-03-18	6390	6390	6290	6290	735300
1994-03-22	6200	6220	6090	6100	1004300
1994-03-23	6150	6180	6080	6090	749700
1994-03-24	6120	6150	6090	6100	679200
1994-03-25	6070	6140	6060	6100	732600
1994-03-28	6150	6270	6120	6220	529300
1994-03-29	6140	6200	6130	6130	603100
1994-03-30	6030	6100	6010	6050	1132700
1994-03-31	5990	6030	5850	5850	1504300
1994-04-01	5920	5950	5890	5930	744800
1994-04-04	5850	5900	5820	5890	535300
1994-04-05	5920	6000	5910	6000	625500
1994-04-06	6080	6120	5990	5990	762600
1994-04-07	5980	6020	5940	6020	283600
1994-04-08	5960	6020	5880	6010	1038900
1994-04-11	6000	6000	5950	5960	327900
1994-04-12	5910	5980	5900	5920	658500
1994-04-13	5950	6000	5920	5980	582400
1994-04-14	5960	6000	5900	5980	367300
1994-04-15	6050	6070	5950	5950	506200
1994-04-18	6030	6050	5960	5960	325400
1994-04-19	5970	6030	5950	5980	313500
1994-04-20	6000	6010	5920	5920	386900
1994-04-21	5940	5970	5910	5910	359600
1994-04-22	5960	5970	5880	5910	472100
1994-04-25	5900	5930	5850	5900	420900
1994-04-26	5920	5970	5880	5940	481400
1994-04-27	5890	5910	5860	5890	329800
1994-04-28	5850	5850	5760	5760	817900
1994-05-02	5700	5700	5670	5700	456900
1994-05-06	5720	5750	5680	5700	763700
1994-05-09	5640	5650	5600	5610	545300
1994-05-10	5600	5670	5590	5640	771600
1994-05-11	5770	5890	5760	5890	956800
1994-05-12	5890	5890	5810	5840	401100
1994-05-13	5860	5930	5850	5880	610800
1994-05-16	5980	6000	5920	5930	627200
1994-05-17	5930	6010	5930	6000	632300
1994-05-18	6010	6020	5880	5940	380600
1994-05-19	5910	5930	5840	5840	435400
1994-05-20	5930	5950	5910	5920	527500
1994-05-23	6000	6000	5960	5990	391800
1994-05-24	5940	6000	5930	5940	627100
1994-05-25	5960	6000	5930	5970	686900
1994-05-26	6000	6050	5970	6020	839700
1994-05-27	5980	6050	5970	6050	402800
1994-05-30	6150	6190	6080	6180	765800
1994-05-31	6170	6230	6160	6220	662500
1994-06-01	6240	6340	6210	6340	1819400
1994-06-02	6380	6410	6250	6290	1627900
1994-06-03	6250	6280	6230	6270	643100
1994-06-06	6260	6300	6200	6210	403900
1994-06-07	6240	6340	6210	6340	642600
1994-06-08	6300	6410	6270	6390	1097300
1994-06-09	6400	6420	6300	6350	658500
1994-06-10	6440	6440	6330	6370	1801200
1994-06-13	6270	6380	6230	6380	465200
1994-06-14	6320	6340	6300	6330	420500
1994-06-15	6350	6350	6280	6320	410500
1994-06-16	6270	6320	6270	6310	329900
1994-06-17	6380	6390	6340	6340	623000
1994-06-20	6330	6360	6280	6280	514300
1994-06-21	6180	6220	6150	6160	456100
1994-06-22	6060	6110	6020	6070	1208900
1994-06-23	6130	6140	6090	6120	586400
1994-06-24	6100	6250	6090	6120	663100
1994-06-27	6000	6020	5920	5980	881500
1994-06-28	6070	6160	6030	6070	627100
1994-06-29	6040	6060	5990	6000	612900
1994-06-30	5950	6100	5940	6050	864000
1994-07-01	6000	6020	5940	6010	958500
1994-07-04	6030	6080	6010	6080	319600
1994-07-05	6150	6310	6140	6270	790900
1994-07-06	6240	6240	6100	6110	494000
1994-07-07	6060	6110	6060	6080	639800
1994-07-08	6060	6080	6020	6030	822100
1994-07-11	5980	6030	5970	6000	380300
1994-07-12	5940	5950	5900	5920	754500
1994-07-13	5880	5910	5830	5850	1031000
1994-07-14	5940	6070	5930	6050	540600
1994-07-15	6040	6070	5920	5950	461700
1994-07-18	5900	5940	5900	5940	225000
1994-07-19	5980	6000	5920	5990	167200
1994-07-20	6010	6040	5970	6010	493300
1994-07-21	5980	5980	5930	5950	234900
1994-07-22	6000	6000	5890	5950	366800
1994-07-25	5800	5840	5750	5790	651800
1994-07-26	5770	5840	5710	5780	563900
1994-07-27	5730	5760	5640	5650	797300
1994-07-28	5740	5840	5680	5760	654900
1994-07-29	5950	5980	5870	5870	823200
1994-08-01	5800	5890	5780	5850	361800
1994-08-02	5940	6000	5910	6000	532600
1994-08-03	6000	6020	5940	5940	409700
1994-08-04	5980	5980	5920	5960	264700
1994-08-05	5950	5970	5870	5900	348800
1994-08-08	5900	5940	5870	5930	261100
1994-08-09	5950	5950	5880	5900	500300
1994-08-10	5930	5990	5910	5980	394200
1994-08-11	6000	6010	5950	6000	580900
1994-08-12	6000	6000	5930	5970	488800
1994-08-15	5930	5960	5920	5930	184600
1994-08-16	5930	5970	5900	5950	194300
1994-08-17	5990	6010	5960	5980	493500
1994-08-18	5990	5990	5960	5990	263600
1994-08-19	5960	6000	5900	5900	546800
1994-08-22	5900	5910	5860	5870	282900
1994-08-23	5870	5930	5850	5890	267500
1994-08-24	5880	5920	5880	5910	282500
1994-08-25	5940	5940	5870	5870	435400
1994-08-26	5880	5900	5830	5830	415100
1994-08-29	5920	5940	5880	5900	265600
1994-08-30	5900	6060	5890	6020	798600
1994-08-31	6050	6110	6030	6110	720600
1994-09-01	6150	6230	6140	6150	1180800
1994-09-02	6150	6150	6100	6100	409500
1994-09-05	6100	6100	5900	5900	446700
1994-09-06	5900	6020	5900	5950	209500
1994-09-07	5910	5950	5850	5850	615000
1994-09-08	5850	5900	5800	5800	695600
1994-09-09	5860	5880	5750	5780	1528100
1994-09-12	5810	5940	5810	5850	353200
1994-09-13	5870	5950	5850	5920	387000
1994-09-14	5900	5940	5860	5930	305200
1994-09-16	5930	5940	5880	5880	272400
1994-09-19	5880	5880	5790	5790	352200
1994-09-20	5850	5880	5830	5880	426500
1994-09-21	5830	5940	5820	5890	521900
1994-09-22	5890	5910	5850	5860	457900
1994-09-26	5860	5870	5830	5850	276200
1994-09-27	5850	5870	5800	5800	368700
1994-09-28	5810	5830	5790	5790	516600
1994-09-29	5810	5850	5800	5800	414700
1994-09-30	5800	5820	5760	5760	368500
1994-10-03	5780	5820	5750	5800	232300
1994-10-04	5820	5820	5780	5800	155800
1994-10-05	5790	5800	5760	5770	549200
1994-10-06	5810	5810	5760	5770	492800
1994-10-07	5780	5910	5760	5900	495800
1994-10-11	5970	6010	5950	6000	458300
1994-10-12	6000	6000	5920	6000	596400
1994-10-13	5980	6010	5960	5970	397800
1994-10-14	5950	5970	5920	5970	691800
1994-10-17	5930	5970	5890	5950	208600
1994-10-18	5890	5920	5850	5880	150700
1994-10-19	5890	5930	5870	5870	239200
1994-10-20	5870	5900	5870	5900	144500
1994-10-21	5800	5830	5760	5810	486700
1994-10-24	5840	5850	5770	5770	286700
1994-10-25	5780	5810	5760	5780	264800
1994-10-26	5800	5810	5770	5810	168900
1994-10-27	5840	5900	5820	5830	277600
1994-10-28	5850	5880	5800	5830	370800
1994-10-31	5900	5910	5860	5910	209000
1994-11-01	5890	5940	5860	5920	185400
1994-11-02	5890	5900	5830	5850	262600
1994-11-04	5900	5900	5800	5830	303500
1994-11-07	5780	5780	5710	5740	418200
1994-11-08	5750	5780	5730	5780	394300
1994-11-09	5740	5780	5720	5760	379900
1994-11-10	5830	5830	5720	5730	573100
1994-11-11	5760	5770	5730	5750	366000
1994-11-14	5720	5780	5710	5750	216100
1994-11-15	5800	5820	5760	5780	304300
1994-11-16	5800	5820	5770	5800	451900
1994-11-17	5810	5820	5780	5790	276400
1994-11-18	5490	5500	5300	5480	3974100
1994-11-21	5380	5390	5230	5230	1924600
1994-11-22	5080	5160	5070	5110	2055200
1994-11-24	5010	5080	5000	5030	1456200
1994-11-25	5130	5160	5080	5160	879300
1994-11-28	5180	5210	5140	5140	880000
1994-11-29	5170	5250	5160	5230	962600
1994-11-30	5250	5330	5240	5250	1301500
1994-12-01	5260	5430	5260	5340	1217400
1994-12-02	5320	5430	5320	5420	873800
1994-12-05	5520	5520	5460	5520	814000
1994-12-06	5520	5560	5500	5510	824100
1994-12-07	5440	5450	5330	5330	712200
1994-12-08	5290	5360	5260	5280	734000
1994-12-09	5350	5360	5280	5280	1383700
1994-12-12	5360	5400	5330	5380	335400
1994-12-13	5400	5420	5320	5400	414200
1994-12-14	5400	5400	5360	5360	264000
1994-12-15	5420	5420	5360	5380	384100
1994-12-16	5400	5400	5360	5390	289800
1994-12-19	5420	5510	5400	5500	596500
1994-12-20	5470	5570	5450	5550	1017900
1994-12-21	5550	5590	5530	5530	944900
1994-12-22	5590	5610	5550	5590	988400
1994-12-26	5600	5640	5560	5610	543100
1994-12-27	5630	5670	5600	5640	731700
1994-12-28	5670	5700	5590	5590	671100
1994-12-29	5580	5650	5580	5630	487900
1994-12-30	5560	5660	5560	5650	361100
1995-01-04	5680	5720	5650	5680	331000
1995-01-05	5680	5690	5610	5680	284400
1995-01-06	5650	5650	5580	5630	190700
1995-01-09	5610	5620	5590	5600	254700
1995-01-10	5550	5580	5530	5550	420700
1995-01-11	5580	5610	5550	5550	393400
1995-01-12	5570	5570	5460	5480	281400
1995-01-13	5490	5490	5380	5390	728100
1995-01-17	5350	5390	5150	5170	714500
1995-01-18	5240	5290	5230	5240	376100
1995-01-19	5240	5270	5120	5120	615400
1995-01-20	5120	5150	5020	5040	1213100
1995-01-23	5040	5080	4910	4910	1329000
1995-01-24	4920	5040	4910	5000	827900
1995-01-25	5020	5040	4920	4920	795900
1995-01-26	4930	4960	4820	4890	860300
1995-01-27	4850	4880	4750	4800	798500
1995-01-30	4840	4900	4800	4810	699200
1995-01-31	4850	4850	4570	4590	952800
1995-02-01	4640	4790	4620	4700	1128700
1995-02-02	4650	4660	4540	4640	1296900
1995-02-03	4630	4640	4590	4620	636100
1995-02-06	4680	4690	4610	4620	564800
1995-02-07	4690	4690	4650	4650	544900
1995-02-08	4680	4740	4660	4720	667100
1995-02-09	4740	4790	4710	4720	639000
1995-02-10	4740	4780	4730	4770	690800
1995-02-13	4800	4810	4710	4720	648800
1995-02-14	4700	4720	4680	4700	393500
1995-02-15	4650	4650	4550	4570	756600
1995-02-16	4420	4430	4350	4380	1155400
1995-02-17	4350	4490	4300	4400	1840400
1995-02-20	4420	4500	4400	4400	539200
1995-02-21	4410	4480	4410	4430	526100
1995-02-22	4480	4520	4450	4450	676500
1995-02-23	4460	4460	4380	4440	722700
1995-02-24	4410	4420	4260	4270	1346800
1995-02-27	4120	4150	3990	4030	2082600
1995-02-28	4180	4250	4150	4200	994200
1995-03-01	4240	4270	4150	4230	1108400
1995-03-02	4430	4500	4380	4500	1359300
1995-03-03	4400	4520	4370	4450	937600
1995-03-06	4380	4440	4360	4390	538700
1995-03-07	4430	4430	4350	4360	575700
1995-03-08	4280	4310	4220	4290	1043000
1995-03-09	4260	4290	4220	4220	866900
1995-03-10	4190	4250	4150	4200	2205800
1995-03-13	4200	4240	4120	4240	743400
1995-03-14	4160	4180	4070	4130	1064600
1995-03-15	4100	4210	4100	4200	826600
1995-03-16	4150	4200	4110	4110	473100
1995-03-17	4140	4150	4060	4080	499100
1995-03-20	4050	4100	4030	4100	366100
1995-03-22	4100	4150	4060	4090	371100
1995-03-23	4050	4090	4030	4060	728000
1995-03-24	4020	4100	3990	4070	1124900
1995-03-27	4170	4310	4170	4300	586900
1995-03-28	4330	4400	4330	4380	742300
1995-03-29	4430	4430	4350	4370	675700
1995-03-30	4270	4420	4270	4320	366200
1995-03-31	4420	4430	4310	4350	789900
1995-04-03	4200	4220	4080	4100	912900
1995-04-04	4180	4240	4050	4210	1175300
1995-04-05	4180	4220	4130	4180	540400
1995-04-06	4130	4200	4120	4150	519300
1995-04-07	4110	4140	4080	4130	848100
1995-04-10	4120	4220	4060	4150	826900
1995-04-11	4200	4250	4180	4250	742000
1995-04-12	4250	4320	4240	4300	728200
1995-04-13	4290	4320	4230	4260	418500
1995-04-14	4210	4240	4110	4110	786100
1995-04-17	4060	4150	4050	4150	406500
1995-04-18	4150	4180	4140	4160	404300
1995-04-19	4110	4160	4090	4130	871200
1995-04-20	4180	4290	4160	4260	715400
1995-04-21	4290	4320	4280	4300	670800
1995-04-24	4280	4300	4170	4200	216500
1995-04-25	4250	4300	4240	4290	559900
1995-04-26	4250	4290	4180	4200	473200
1995-04-27	4270	4270	4220	4220	298600
1995-04-28	4230	4270	4210	4240	513800
1995-05-01	4260	4280	4230	4250	298000
1995-05-02	4260	4300	4240	4300	511100
1995-05-08	4320	4320	4210	4210	411000
1995-05-09	4210	4230	4150	4170	377500
1995-05-10	4160	4180	4090	4100	592500
1995-05-11	4140	4140	4050	4080	1045500
1995-05-12	4130	4160	4110	4110	1161800
1995-05-15	4140	4260	4110	4260	614100
1995-05-16	4230	4260	4220	4220	332300
1995-05-17	4270	4270	4230	4250	437500
1995-05-18	4270	4280	4170	4200	558100
1995-05-19	4110	4230	4100	4200	626300
1995-05-22	4190	4210	4130	4140	273500
1995-05-23	4140	4150	4100	4120	597600
1995-05-24	4120	4170	4110	4170	520100
1995-05-25	4170	4180	4030	4030	728300
1995-05-26	4030	4130	4010	4100	404200
1995-05-29	4000	4070	4000	4060	363400
1995-05-30	4060	4100	4050	4070	297200
1995-05-31	4090	4120	4020	4080	759400
1995-06-01	4120	4200	4090	4160	903800
1995-06-02	4200	4270	4180	4230	1033800
1995-06-05	4230	4240	4190	4220	287900
1995-06-06	4200	4200	4100	4120	244800
1995-06-07	4110	4180	4110	4180	312900
1995-06-08	4140	4170	4100	4140	321500
1995-06-09	4040	4090	4020	4060	2123300
1995-06-12	4070	4070	4000	4020	652700
1995-06-13	4020	4040	3800	3800	1292700
1995-06-14	3780	3870	3770	3840	1238100
1995-06-15	3800	3960	3730	3950	943300
1995-06-16	3990	3990	3850	3850	559200
1995-06-19	3890	3960	3880	3880	487900
1995-06-20	3930	3960	3870	3940	509100
1995-06-21	3950	4040	3930	4040	837400
1995-06-22	4090	4110	4070	4100	684300
1995-06-23	4130	4150	4110	4130	482400
1995-06-26	4180	4190	4130	4170	561400
1995-06-27	4140	4160	4060	4060	448900
1995-06-28	4010	4090	3980	4050	463200
1995-06-29	4150	4180	3960	4060	1272100
1995-06-30	4110	4130	4060	4070	694800
1995-07-03	4090	4100	4010	4100	538400
1995-07-04	4090	4130	4060	4110	446200
1995-07-05	4120	4150	4070	4140	396500
1995-07-06	4170	4200	4120	4190	705100
1995-07-07	4250	4360	4230	4320	2062800
1995-07-10	4520	4670	4500	4610	2851000
1995-07-11	4600	4650	4520	4640	1039700
1995-07-12	4650	4760	4610	4720	1226300
1995-07-13	4720	4730	4660	4680	604500
1995-07-14	4730	4820	4700	4750	1401800
1995-07-17	4750	4850	4750	4800	688400
1995-07-18	4900	4940	4850	4860	1898800
1995-07-19	4760	4790	4650	4740	933700
1995-07-20	4670	4720	4620	4720	660900
1995-07-21	4800	4800	4710	4780	754100
1995-07-24	4800	4820	4760	4810	487000
1995-07-25	4800	4800	4690	4690	604400
1995-07-26	4720	4750	4700	4750	598500
1995-07-27	4730	4860	4720	4840	614800
1995-07-28	4780	4830	4740	4800	650300
1995-07-31	4780	4840	4770	4770	442100
1995-08-01	4720	4770	4710	4760	238100
1995-08-02	4740	4910	4720	4870	1102300
1995-08-03	5020	5370	5000	5350	4156500
1995-08-04	5350	5440	5250	5290	2292900
1995-08-07	5390	5420	5220	5260	1041100
1995-08-08	5290	5340	5140	5320	1156600
1995-08-09	5260	5320	5170	5200	1044600
1995-08-10	5150	5240	5060	5100	1021500
1995-08-11	5290	5300	5190	5280	1180900
1995-08-14	5260	5290	5210	5210	538300
1995-08-15	5200	5350	5140	5350	662400
1995-08-16	5600	5630	5380	5400	1699500
1995-08-17	5430	5540	5420	5420	883200
1995-08-18	5400	5500	5310	5420	618800
1995-08-21	5370	5410	5280	5290	387500
1995-08-22	5290	5400	5290	5350	374000
1995-08-23	5350	5370	5150	5160	284200
1995-08-24	5110	5350	5110	5350	460900
1995-08-25	5250	5260	5120	5170	383200
1995-08-28	5150	5180	5080	5170	372900
1995-08-29	5200	5250	5160	5220	368400
1995-08-30	5320	5320	5230	5270	387000
1995-08-31	5300	5390	5280	5340	691600
1995-09-01	5300	5320	5280	5320	693800
1995-09-04	5320	5350	5260	5290	558600
1995-09-05	5320	5380	5250	5320	775400
1995-09-06	5320	5430	5320	5370	709500
1995-09-07	5400	5400	5230	5250	488200
1995-09-08	5550	5550	5270	5310	3603400
1995-09-11	5290	5350	5150	5210	801600
1995-09-12	5290	5310	5230	5250	553900
1995-09-13	5290	5360	5280	5320	736700
1995-09-14	5400	5400	5350	5350	694800
1995-09-18	5380	5440	5340	5400	812700
1995-09-19	5350	5390	5320	5350	650300
1995-09-20	5450	5450	5300	5340	597100
1995-09-21	5300	5400	5280	5370	580800
1995-09-22	5220	5330	5220	5250	643200
1995-09-25	5250	5270	5150	5170	592900
1995-09-26	5170	5230	5140	5220	825500
1995-09-27	5160	5250	5090	5250	722500
1995-09-28	5150	5200	5100	5120	584000
1995-09-29	5180	5240	5110	5140	493100
1995-10-02	5150	5160	5030	5120	546600
1995-10-03	5120	5240	5100	5240	365900
1995-10-04	5230	5250	5150	5180	450300
1995-10-05	5180	5240	5130	5240	289100
1995-10-06	5220	5330	5200	5320	540900
1995-10-09	5320	5320	5200	5200	392200
1995-10-11	5150	5150	5050	5080	417400
1995-10-12	5180	5180	5080	5100	350300
1995-10-13	5050	5170	5030	5060	537400
1995-10-16	5130	5200	5120	5150	247700
1995-10-17	5140	5190	5050	5070	357100
1995-10-18	5120	5150	5050	5140	439800
1995-10-19	5140	5210	5120	5170	304900
1995-10-20	5200	5230	5170	5200	515400
1995-10-23	5170	5210	5150	5200	372400
1995-10-24	5150	5160	5050	5080	766300
1995-10-25	5100	5110	5050	5090	948000
1995-10-26	5110	5110	4920	4940	987100
1995-10-27	4810	4870	4750	4750	1068500
1995-10-30	4760	4760	4690	4740	891900
1995-10-31	4720	4730	4570	4600	1381200
1995-11-01	4610	4690	4590	4680	1249000
1995-11-02	4730	4870	4730	4870	1135100
1995-11-06	4850	4910	4770	4830	644000
1995-11-07	4830	4850	4810	4820	430900
1995-11-08	4720	4750	4660	4660	594000
1995-11-09	4710	4800	4710	4740	531400
1995-11-10	4940	4950	4850	4900	1256700
1995-11-13	4950	4990	4930	4950	700300
1995-11-14	5000	5040	4930	4950	885700
1995-11-15	4920	4950	4850	4860	589500
1995-11-16	4900	5000	4880	5000	658900
1995-11-17	5070	5090	5010	5040	619200
1995-11-20	5070	5160	5070	5150	802000
1995-11-21	5170	5180	5110	5150	387600
1995-11-22	5130	5180	5120	5150	462500
1995-11-24	5190	5190	5170	5190	343600
1995-11-27	5200	5300	5200	5290	851500
1995-11-28	5370	5390	5330	5350	1069200
1995-11-29	5400	5480	5400	5400	1114100
1995-11-30	5450	5480	5400	5400	762000
1995-12-01	5500	5530	5450	5500	1275800
1995-12-04	5550	5590	5520	5550	1406600
1995-12-05	5560	5570	5500	5500	661400
1995-12-06	5500	5620	5500	5620	1186600
1995-12-07	5720	5850	5670	5810	1834800
1995-12-08	5800	5810	5710	5780	2958900
1995-12-11	5800	5800	5720	5740	589700
1995-12-12	5750	5830	5750	5810	1028000
1995-12-13	5850	5890	5780	5790	1109000
1995-12-14	5840	5840	5780	5800	571200
1995-12-15	5770	5780	5620	5670	496200
1995-12-18	5630	5710	5630	5660	315100
1995-12-19	5530	5620	5500	5580	664000
1995-12-20	5620	5640	5580	5590	613300
1995-12-21	5610	5820	5600	5810	762500
1995-12-22	5910	6010	5890	6000	2679000
1995-12-25	6000	6000	5930	5950	399800
1995-12-26	5940	5980	5890	5980	304300
1995-12-27	6020	6140	6000	6130	1391900
1995-12-28	6120	6210	6080	6150	1425000
1995-12-29	6120	6230	6100	6190	896300
1996-01-04	6590	7030	6510	6850	3079300
1996-01-05	6800	6960	6770	6780	3063500
1996-01-08	6780	6910	6750	6780	1875400
1996-01-09	6750	6820	6680	6810	1327500
1996-01-10	6710	6770	6650	6680	1580100
1996-01-11	6500	6580	6480	6540	1117600
1996-01-12	6640	6650	6450	6450	1120300
1996-01-16	6490	6580	6430	6550	665600
1996-01-17	6650	6690	6600	6630	1204200
1996-01-18	6470	6550	6470	6500	697100
1996-01-19	6500	6520	6410	6510	834300
1996-01-22	6500	6530	6430	6500	589500
1996-01-23	6530	6570	6460	6470	668400
1996-01-24	6270	6300	6230	6300	1302500
1996-01-25	6340	6370	6240	6290	1159400
1996-01-26	6280	6340	6230	6300	507600
1996-01-29	6390	6390	6300	6300	335800
1996-01-30	6330	6450	6330	6430	826400
1996-01-31	6530	6600	6500	6550	907100
1996-02-01	6550	6560	6420	6490	863900
1996-02-02	6490	6530	6470	6500	665300
1996-02-05	6500	6500	6410	6420	516100
1996-02-06	6350	6500	6320	6500	603300
1996-02-07	6500	6760	6450	6520	1611900
1996-02-08	6570	6710	6560	6650	1038500
1996-02-09	6550	6570	6450	6450	1194300
1996-02-13	6480	6490	6450	6460	374500
1996-02-14	6490	6530	6460	6470	364500
1996-02-15	6450	6500	6440	6500	366700
1996-02-16	6450	6500	6430	6500	346500
1996-02-19	6450	6450	6330	6360	338400
1996-02-20	6240	6240	6190	6200	943300
1996-02-21	6380	6400	6290	6340	795600
1996-02-22	6300	6340	6260	6280	546200
1996-02-23	6300	6330	6280	6280	395200
1996-02-26	6280	6280	6170	6170	482500
1996-02-27	6190	6200	6100	6100	683700
1996-02-28	6200	6220	6090	6090	469400
1996-02-29	6190	6190	6100	6160	1502800
1996-03-01	6150	6160	6040	6120	1180600
1996-03-04	6150	6150	6050	6080	438900
1996-03-05	6080	6130	6070	6100	654300
1996-03-06	6150	6320	6100	6300	1580500
1996-03-07	6300	6300	6150	6150	848700
1996-03-08	6100	6250	6100	6250	3786400
1996-03-11	6160	6250	6150	6180	475900
1996-03-12	6240	6250	6180	6200	781300
1996-03-13	6200	6200	6100	6130	609300
1996-03-14	6140	6190	6120	6190	512300
1996-03-15	6230	6390	6190	6270	1919400
1996-03-18	6320	6320	6260	6280	426900
1996-03-19	6380	6380	6300	6300	689500
1996-03-21	6360	6380	6330	6380	761000
1996-03-22	6400	6420	6340	6370	790900
1996-03-25	6400	6400	6310	6330	431900
1996-03-26	6360	6400	6310	6310	564900
1996-03-27	6340	6390	6330	6390	393900
1996-03-28	6400	6430	6340	6390	743700
1996-03-29	6390	6440	6360	6390	855100
1996-04-01	6450	6500	6440	6450	1425600
1996-04-02	6490	6510	6410	6440	855500
1996-04-03	6460	6470	6380	6400	733400
1996-04-04	6390	6420	6370	6390	411200
1996-04-05	6390	6450	6370	6440	508200
1996-04-08	6350	6390	6350	6380	254900
1996-04-09	6440	6500	6410	6440	811100
1996-04-10	6450	6470	6430	6440	858900
1996-04-11	6460	6510	6420	6420	1209100
1996-04-12	6390	6450	6390	6400	691500
1996-04-15	6400	6460	6400	6430	857800
1996-04-16	6490	6550	6460	6500	1783200
1996-04-17	6600	6680	6550	6600	2995900
1996-04-18	6620	6750	6580	6660	2502000
1996-04-19	6670	6700	6620	6660	1288700
1996-04-22	6730	6860	6720	6850	2477900
1996-04-23	6850	6850	6780	6820	1337800
1996-04-24	6820	6860	6790	6800	1272600
1996-04-25	6840	6860	6790	6830	1858500
1996-04-26	6840	6940	6810	6900	2358000
1996-04-30	6800	6850	6780	6800	1101000
1996-05-01	6820	6850	6740	6780	1006000
1996-05-02	6750	6770	6710	6770	805600
1996-05-07	6740	6740	6690	6720	625700
1996-05-08	6720	6800	6710	6790	759300
1996-05-09	6790	6790	6660	6670	856100
1996-05-10	6690	6760	6680	6680	1083100
1996-05-13	6750	6750	6660	6670	638300
1996-05-14	6690	6720	6670	6680	361500
1996-05-15	6790	6880	6770	6880	1910400
1996-05-16	6950	6990	6910	6920	2772200
1996-05-17	6870	6900	6840	6880	692400
1996-05-20	6870	6910	6850	6900	578600
1996-05-21	6890	6930	6860	6870	763800
1996-05-22	6900	6920	6870	6880	637600
1996-05-23	6850	6880	6800	6820	503900
1996-05-24	6810	6880	6790	6860	644000
1996-05-27	6870	6880	6800	6850	299300
1996-05-28	6880	6910	6850	6910	455600
1996-05-29	6910	6920	6870	6870	942800
1996-05-30	6850	6900	6840	6870	959300
1996-05-31	6890	6900	6870	6870	694400
1996-06-03	6850	6860	6800	6800	408400
1996-06-04	6870	6900	6840	6870	614500
1996-06-05	6960	6980	6920	6960	1707800
1996-06-06	6970	6980	6940	6970	811200
1996-06-07	6960	6970	6940	6960	477800
1996-06-10	6960	6980	6930	6950	877000
1996-06-11	6960	7000	6940	6980	1880500
1996-06-12	7010	7100	7000	7060	3331400
1996-06-13	7070	7080	7030	7060	1469400
1996-06-14	7060	7130	7040	7130	3668000
1996-06-17	7120	7160	7080	7100	1601800
1996-06-18	7110	7120	7070	7100	1212100
1996-06-19	7090	7140	7080	7130	1275000
1996-06-20	7070	7120	7060	7110	640800
1996-06-21	7130	7140	7080	7100	874200
1996-06-24	7110	7150	7100	7150	1146900
1996-06-25	7150	7200	7140	7200	1816500
1996-06-26	7220	7310	7210	7250	2652600
1996-06-27	7250	7280	7200	7200	1121200
1996-06-28	7240	7260	7190	7210	876600
1996-07-01	7260	7260	7210	7230	718200
1996-07-02	7230	7240	7150	7200	457700
1996-07-03	7160	7180	7110	7130	468100
1996-07-04	7110	7150	7070	7140	635500
1996-07-05	7180	7190	7160	7180	628000
1996-07-08	7100	7140	7080	7120	525100
1996-07-09	7120	7170	7120	7140	474900
1996-07-10	7160	7170	7090	7100	559800
1996-07-11	7160	7160	7090	7150	606700
1996-07-12	7060	7130	7050	7100	911300
1996-07-15	7080	7110	7070	7110	412300
1996-07-16	7010	7040	6970	6990	718700
1996-07-17	6990	7010	6870	6900	929600
1996-07-18	6900	6960	6850	6900	990400
1996-07-19	6920	6940	6820	6830	826100
1996-07-22	6850	6850	6780	6780	506600
1996-07-23	6750	6760	6680	6760	1060200
1996-07-24	6760	6760	6700	6700	489900
1996-07-25	6720	6800	6690	6770	800700
1996-07-26	6800	6860	6770	6830	516000
1996-07-29	6840	6850	6800	6800	306800
1996-07-30	6720	6770	6720	6760	509600
1996-07-31	6770	6800	6720	6750	468300
1996-08-01	6750	6930	6730	6920	540400
1996-08-02	6950	6970	6910	6920	415300
1996-08-05	6980	6980	6920	6960	255800
1996-08-06	6930	6930	6870	6870	261900
1996-08-07	6830	6870	6750	6790	399600
1996-08-08	6820	6860	6800	6850	417800
1996-08-09	6850	6850	6800	6820	530900
1996-08-12	6840	6880	6800	6870	238600
1996-08-13	6900	6950	6880	6930	355800
1996-08-14	6920	6980	6900	6970	320100
1996-08-15	6970	6990	6890	6920	483700
1996-08-16	6900	6920	6890	6900	238700
1996-08-19	6930	6980	6900	6940	465600
1996-08-20	6940	6970	6910	6940	280300
1996-08-21	7010	7020	6980	7000	511500
1996-08-22	7010	7060	7000	7030	800100
1996-08-23	7040	7040	6990	6990	392300
1996-08-26	6990	6990	6910	6910	244200
1996-08-27	6910	6960	6910	6960	302500
1996-08-28	6960	7000	6910	6910	449300
1996-08-29	6910	6920	6870	6880	475100
1996-08-30	6830	6860	6810	6820	785400
1996-09-02	6830	6860	6780	6780	225800
1996-09-03	6800	6860	6790	6830	447900
1996-09-04	6840	6860	6790	6810	587200
1996-09-05	6810	6880	6800	6840	504500
1996-09-06	6830	6850	6810	6820	293300
1996-09-09	6900	6900	6840	6860	342600
1996-09-10	6890	6920	6860	6920	573400
1996-09-11	6920	6930	6870	6900	338400
1996-09-12	6890	6920	6850	6890	375700
1996-09-13	6910	6950	6880	6950	1837500
1996-09-17	7020	7040	6990	7020	949000
1996-09-18	7010	7020	6970	6970	533800
1996-09-19	6950	7000	6930	7000	603900
1996-09-20	7000	7000	6960	6960	459300
1996-09-24	6950	6990	6930	6960	333600
1996-09-25	6950	6990	6940	6950	227400
1996-09-26	6980	7010	6960	6960	729700
1996-09-27	6960	7010	6940	7000	506900
1996-09-30	7000	7040	6990	7030	417400
1996-10-01	7030	7050	7010	7050	426500
1996-10-02	7060	7110	7060	7100	1622900
1996-10-03	7120	7120	7040	7050	473700
1996-10-04	7030	7030	6970	7000	439100
1996-10-07	7020	7020	6970	6980	258600
1996-10-08	6980	6980	6950	6960	340100
1996-10-09	6950	6990	6940	6980	203100
1996-10-11	6990	7000	6960	6990	540200
1996-10-14	7000	7000	6980	7000	200400
1996-10-15	7060	7130	7040	7130	1084900
1996-10-16	7150	7150	7110	7120	568500
1996-10-17	7110	7120	7070	7070	307200
1996-10-18	7070	7140	7050	7060	732600
1996-10-21	7050	7070	6980	7020	362500
1996-10-22	6960	7000	6900	6930	435200
1996-10-23	6890	6910	6820	6910	658100
1996-10-24	6900	6920	6840	6840	332500
1996-10-25	6850	6880	6820	6860	586100
1996-10-28	6860	6900	6860	6890	254600
1996-10-29	6890	6930	6860	6890	365900
1996-10-30	6900	6900	6830	6880	405400
1996-10-31	6850	6900	6820	6830	414900
1996-11-01	6760	6790	6720	6760	986800
1996-11-05	6770	6780	6740	6770	483500
1996-11-06	6790	6900	6790	6860	528600
1996-11-07	6900	6910	6850	6850	361100
1996-11-08	6830	6920	6830	6890	791500
1996-11-11	6890	6930	6870	6870	225500
1996-11-12	6880	6940	6880	6920	402400
1996-11-13	6900	6930	6880	6900	369500
1996-11-14	6950	6950	6910	6950	273900
1996-11-15	6960	6980	6940	6950	390000
1996-11-18	6950	6990	6920	6990	312200
1996-11-19	6990	7010	6940	7000	414200
1996-11-20	7030	7110	7020	7100	1621900
1996-11-21	7110	7140	7050	7080	1073100
1996-11-22	7070	7120	7060	7120	552400
1996-11-25	7140	7240	7130	7240	1347800
1996-11-26	7290	7300	7200	7230	1500200
1996-11-27	7280	7400	7260	7380	2819800
1996-11-28	7350	7410	7330	7340	1515000
1996-11-29	7310	7350	7290	7290	846600
1996-12-02	7320	7340	7230	7230	775500
1996-12-03	7250	7330	7230	7270	841700
1996-12-04	7280	7430	7270	7430	1504900
1996-12-05	7450	7520	7440	7500	3066100
1996-12-06	7590	7630	7340	7470	3114800
1996-12-09	7540	7570	7500	7520	1011300
1996-12-10	7620	7700	7560	7680	1881100
1996-12-11	7580	7660	7520	7560	1112700
1996-12-12	7490	7530	7460	7510	853000
1996-12-13	7490	7510	7400	7500	2707200
1996-12-16	7520	7540	7480	7510	1345600
1996-12-17	7450	7490	7390	7460	1021800
1996-12-18	7400	7430	7340	7340	1107200
1996-12-19	7350	7410	7290	7320	1087200
1996-12-20	7400	7490	7370	7420	1026500
1996-12-24	7500	7510	7440	7440	1042600
1996-12-25	7530	7610	7470	7580	788000
1996-12-26	7560	7600	7480	7600	1124000
1996-12-27	7600	7650	7540	7570	1354400
1996-12-30	7640	7660	7590	7590	747700
1997-01-06	7640	7710	7590	7700	1238700
1997-01-07	7720	7750	7640	7640	1460400
1997-01-08	7680	7710	7640	7690	1382100
1997-01-09	7630	7680	7510	7510	1043000
1997-01-10	7510	7560	7300	7320	2555500
1997-01-13	7360	7390	7250	7360	1851700
1997-01-14	7440	7480	7290	7470	2511000
1997-01-16	7650	7700	7600	7690	2283100
1997-01-17	7650	7720	7620	7660	1942700
1997-01-20	7680	7690	7530	7580	1249500
1997-01-21	7590	7640	7570	7600	1145000
1997-01-22	7700	7730	7670	7710	1559100
1997-01-23	7700	7760	7690	7720	1592700
1997-01-24	7740	7820	7740	7760	2510900
1997-01-27	7800	7900	7770	7830	2030700
1997-01-28	7910	8010	7870	7990	2939600
1997-01-29	8100	8270	8080	8250	5269500
1997-01-30	8150	8240	8090	8150	1564900
1997-01-31	8200	8240	8150	8180	1520800
1997-02-03	8100	8140	8020	8030	1002500
1997-02-04	8130	8190	8090	8130	1342900
1997-02-05	8200	8220	8120	8220	1162800
1997-02-06	8320	8390	8290	8360	2521300
1997-02-07	8440	8500	8400	8460	2386500
1997-02-10	8480	8560	8450	8550	1538100
1997-02-12	8600	8960	8600	8900	4214900
1997-02-13	9100	9160	9060	9070	3254600
1997-02-14	9150	9180	9050	9080	2645300
1997-02-17	9080	9090	8990	9000	1313200
1997-02-18	8950	8970	8700	8800	1718000
1997-02-19	8750	8830	8650	8830	1648800
1997-02-20	8900	8950	8810	8890	1460000
1997-02-21	8620	8800	8540	8750	1841300
1997-02-24	8660	8710	8570	8580	873800
1997-02-25	8570	8780	8560	8780	1374300
1997-02-26	8880	8930	8810	8820	1419700
1997-02-27	8740	8870	8730	8860	731900
1997-02-28	8840	8850	8690	8710	934500
1997-03-03	8610	8740	8600	8700	560700
1997-03-04	8800	8900	8760	8900	1569000
1997-03-05	8990	9020	8900	8900	2302500
1997-03-06	8950	8960	8770	8800	1395100
1997-03-07	8730	8820	8710	8770	920600
1997-03-10	8840	8900	8800	8810	1206900
1997-03-11	8810	8820	8740	8790	1057600
1997-03-12	8840	8860	8760	8840	730200
1997-03-13	8830	8840	8760	8800	1051500
1997-03-14	8600	8840	8600	8840	2537500
1997-03-17	8900	8920	8850	8910	1056400
1997-03-18	8860	8910	8770	8820	1005800
1997-03-19	8820	8830	8650	8710	843400
1997-03-21	8630	8650	8600	8600	808300
1997-03-24	8600	8630	8300	8300	1183400
1997-03-25	8450	8550	8410	8410	1293100
1997-03-26	8550	8650	8430	8650	1395900
1997-03-27	8680	8690	8520	8650	1161200
1997-03-28	8620	8650	8560	8640	486000
1997-03-31	8600	8650	8540	8650	408100
1997-04-01	8600	8690	8520	8680	1182200
1997-04-02	8660	8670	8610	8660	1182300
1997-04-03	8660	8840	8640	8780	1726000
1997-04-04	8850	8970	8780	8940	2084600
1997-04-07	8950	9030	8940	8980	1645100
1997-04-08	9050	9120	8990	9120	1961300
1997-04-09	9120	9160	9060	9100	1687200
1997-04-10	9140	9200	9000	9050	1542600
1997-04-11	9000	9050	8890	9050	1353000
1997-04-14	8950	8980	8910	8950	869700
1997-04-15	9000	9010	8930	9010	1273100
1997-04-16	9000	9000	8910	8920	1008800
1997-04-17	8870	8890	8740	8810	1008500
1997-04-18	8850	8920	8850	8850	998400
1997-04-21	8850	8950	8810	8950	657400
1997-04-22	8890	8990	8890	8970	1217200
1997-04-23	9050	9160	9010	9150	2009700
1997-04-24	9120	9170	9030	9080	1392700
1997-04-25	9100	9180	9070	9140	1417800
1997-04-28	9140	9150	9110	9140	430900
1997-04-30	9240	9280	9220	9240	1697300
1997-05-01	9280	9320	9240	9260	1491700
1997-05-02	9230	9360	9220	9360	1391800
1997-05-06	9500	9590	9450	9500	2407500
1997-05-07	9500	9670	9490	9630	2981200
1997-05-08	9640	9800	9630	9720	2851800
1997-05-09	9820	9830	9520	9520	3477100
1997-05-12	9380	9590	9270	9570	2818800
1997-05-13	9720	9990	9680	9730	3283200
1997-05-14	9710	9870	9680	9830	1446800
1997-05-15	9800	9820	9650	9750	1179600
1997-05-16	9750	9820	9730	9820	1053300
1997-05-19	9780	9860	9740	9800	1145700
1997-05-20	9820	9860	9630	9730	1132300
1997-05-21	9710	9710	9500	9550	919300
1997-05-22	9580	9580	9330	9400	1696600
1997-05-23	9580	9690	9550	9680	1372400
1997-05-26	9690	9720	9650	9700	612600
1997-05-27	9700	9730	9630	9690	477400
1997-05-28	9700	9900	9630	9900	1020000
1997-05-29	9900	9920	9780	9840	1339300
1997-05-30	9940	10000	9810	9810	2123700
1997-06-02	9890	9940	9820	9940	836100
1997-06-03	9950	10100	9940	10100	1818100
1997-06-04	10100	10100	10000	10000	1281000
1997-06-05	10000	10100	9960	10000	1105600
1997-06-06	10000	10000	9870	9950	624900
1997-06-09	9900	9940	9840	9840	619400
1997-06-10	9850	9970	9850	9900	711600
1997-06-11	9970	9980	9850	9850	835800
1997-06-12	9830	9940	9810	9890	792600
1997-06-13	9950	9970	9800	9880	2233900
1997-06-16	9940	9950	9890	9910	549100
1997-06-17	9910	9910	9740	9800	588300
1997-06-18	9850	9850	9700	9750	438400
1997-06-19	9780	9840	9720	9780	588900
1997-06-20	9880	9880	9770	9830	717900
1997-06-23	9920	9920	9820	9870	647500
1997-06-24	9800	9840	9770	9840	475100
1997-06-25	9860	9890	9820	9890	828800
1997-06-26	9990	10100	9920	9920	1812600
1997-06-27	9970	10000	9930	9990	706500
1997-06-30	10100	10100	9940	9990	638300
1997-07-01	10000	10000	9900	9930	667600
1997-07-02	9840	9890	9550	9770	1262600
1997-07-03	9750	9750	9570	9640	1199700
1997-07-04	9650	9680	9560	9680	920600
1997-07-07	9640	9690	9600	9660	588800
1997-07-08	9760	9790	9700	9760	1094200
1997-07-09	9840	9860	9670	9700	1178800
1997-07-10	9740	9790	9720	9760	759100
1997-07-11	9830	9900	9680	9870	1776400
1997-07-14	9890	10100	9890	10100	2356700
1997-07-15	10200	10300	10100	10100	1816900
1997-07-16	10400	10500	10300	10500	2607600
1997-07-17	10600	10700	10400	10700	1914200
1997-07-18	10700	10900	10600	10700	1630200
1997-07-22	10700	10800	10500	10700	856600
1997-07-23	10800	10900	10600	10700	938500
1997-07-24	10800	10900	10700	10800	839600
1997-07-25	10900	11000	10800	10800	841400
1997-07-28	11000	11300	10900	11300	1702500
1997-07-29	11400	11800	11400	11700	2480900
1997-07-30	11900	11900	11500	11600	1658300
1997-07-31	11700	11800	11500	11800	995200
1997-08-01	12000	12600	11900	12200	3341800
1997-08-04	12200	12300	11500	12000	1270200
1997-08-05	11800	11900	11600	11900	1306700
1997-08-06	11900	12000	11600	11900	1540200
1997-08-07	12000	12200	11900	12100	1430900
1997-08-08	11900	12000	11700	11900	1233800
1997-08-11	11500	11700	11400	11400	1351100
1997-08-12	11600	11700	11500	11600	817400
1997-08-13	11400	11600	11300	11400	830500
1997-08-14	11400	11600	11300	11500	1012400
1997-08-15	11900	12000	11800	11900	1014700
1997-08-18	11500	11600	11400	11500	1493100
1997-08-19	11500	11600	10900	11000	1622600
1997-08-20	11200	11500	11100	11400	1067300
1997-08-21	11500	11700	11400	11400	1222800
1997-08-22	11200	11300	10900	11000	1009600
1997-08-25	11000	11100	10600	10700	839300
1997-08-26	10800	11100	10700	11100	828600
1997-08-27	10800	11000	10700	10800	758100
1997-08-28	10900	11100	10700	10800	1062100
1997-08-29	10400	10500	10200	10500	1364300
1997-09-01	10400	10500	10300	10300	804600
1997-09-02	10500	10700	10400	10600	1094300
1997-09-03	11100	11300	11000	11300	1819900
1997-09-04	11200	11400	11100	11200	1150800
1997-09-05	11200	11500	11100	11400	886900
1997-09-08	11400	11700	11400	11500	1196100
1997-09-09	11400	11500	11100	11400	817700
1997-09-10	11200	11300	11100	11300	457900
1997-09-11	11000	11100	10700	11000	960300
1997-09-12	10800	10800	10500	10800	2233400
1997-09-16	10700	10800	10500	10600	933700
1997-09-17	10800	11000	10600	10800	790600
1997-09-18	10700	11000	10600	10800	934600
1997-09-19	10800	11000	10600	10900	1161900
1997-09-22	11000	11000	10800	10900	910900
1997-09-24	11000	11500	11000	11500	1692100
1997-09-25	11500	11700	11400	11600	1111200
1997-09-26	11400	11500	11200	11300	772200
1997-09-29	11300	11300	11000	11200	722600
1997-09-30	11300	11500	11200	11400	619700
1997-10-01	11300	11800	11200	11700	1370800
1997-10-02	11800	11900	11500	11500	1081400
1997-10-03	11600	11900	11500	11800	1026900
1997-10-06	11800	12100	11800	12000	1204200
1997-10-07	12000	12100	11700	11800	722400
1997-10-08	11900	12000	11800	11900	520200
1997-10-09	11900	11900	11600	11600	790400
1997-10-13	11400	11400	11100	11300	487200
1997-10-14	11400	11800	11200	11700	860200
1997-10-15	11700	11800	11500	11800	712800
1997-10-16	11900	12100	11800	11900	1450500
1997-10-17	11700	12000	11600	12000	1116400
1997-10-20	11600	11800	11400	11400	927800
1997-10-21	11600	11600	11100	11100	1008500
1997-10-22	11200	11300	11000	11300	958000
1997-10-23	11100	11300	10700	10700	885700
1997-10-24	10300	10600	10200	10600	2074000
1997-10-27	10200	10300	10100	10300	1006900
1997-10-29	10100	10200	10000	10100	2095300
1997-10-30	10100	10200	9850	9900	1626800
1997-10-31	9700	10100	9660	9990	1796100
1997-11-04	10300	10600	10300	10500	1370400
1997-11-05	10600	10800	10400	10700	985100
1997-11-06	11000	11200	10900	11000	1414100
1997-11-07	10600	10800	10200	10300	1403300
1997-11-10	10000	10200	9920	10100	1695100
1997-11-11	9950	10200	9950	10100	1249700
1997-11-12	10000	10100	9860	9880	1199300
1997-11-13	9600	9780	9460	9670	2442000
1997-11-14	9470	9590	9320	9450	2193900
1997-11-17	9650	10200	9600	10200	1861800
1997-11-18	10300	10700	10100	10500	1880500
1997-11-19	10100	10200	10000	10100	906300
1997-11-20	10200	10500	10100	10400	940300
1997-11-21	10600	10700	10500	10600	780900
1997-11-25	10200	10700	10100	10600	2293700
1997-11-26	10600	10700	10300	10300	1121300
1997-11-27	10600	10800	10400	10800	710200
1997-11-28	11000	11000	10800	10900	1124300
1997-12-01	10800	11300	10700	11200	1134600
1997-12-02	11400	11700	11300	11500	1634300
1997-12-03	11400	11500	11200	11300	883300
1997-12-04	11400	11500	11200	11400	976000
1997-12-05	11500	11900	11500	11800	2000000
1997-12-08	11800	12000	11800	12000	1136600
1997-12-09	12000	12200	11900	12200	1498300
1997-12-10	12000	12100	11800	12000	830700
1997-12-11	11600	11700	11200	11400	822200
1997-12-12	11400	11400	10700	11100	2850700
1997-12-15	11000	11200	10800	11000	681100
1997-12-16	11000	11100	10700	10900	809600
1997-12-17	11300	12000	11200	11800	1853300
1997-12-18	11600	11700	11500	11600	515600
1997-12-19	11300	11300	10800	10900	1244800
1997-12-22	10800	11000	10800	10900	972300
1997-12-24	11300	11800	11200	11700	1305900
1997-12-25	11700	12100	11700	11700	1578100
1997-12-26	11800	11900	11200	11300	552800
1997-12-29	11400	11600	11200	11600	527400
1997-12-30	11600	11600	11400	11600	283300
1998-01-05	12000	12100	11800	11800	688200
1998-01-06	12000	12100	11800	12000	1044500
1998-01-07	12000	12400	12000	12400	1179300
1998-01-08	12400	12600	12300	12300	1697200
1998-01-09	11900	12200	11800	12100	943900
1998-01-12	11600	12000	11600	11700	803500
1998-01-13	11900	12000	11500	11600	851900
1998-01-14	11800	11900	11600	11700	794300
1998-01-16	12000	12400	12000	12300	1327600
1998-01-19	12600	12700	12200	12200	1350300
1998-01-20	12300	12500	12200	12200	894400
1998-01-21	12400	12400	11900	12100	1044700
1998-01-22	12000	12100	11700	11800	813800
1998-01-23	11700	12000	11700	12000	910600
1998-01-26	11900	12000	11600	11600	968700
1998-01-27	11700	11700	11300	11300	1003400
1998-01-28	11600	11700	11100	11100	1028500
1998-01-29	11500	11900	11400	11800	1196500
1998-01-30	11500	11800	11500	11700	1086100
1998-02-02	11800	12000	11600	11800	739800
1998-02-03	12200	12200	11900	12100	1245100
1998-02-04	12100	12100	11800	11900	673500
1998-02-05	11700	11700	11300	11400	957900
1998-02-06	11500	11600	11300	11400	818800
1998-02-09	11300	11300	11000	11200	1264900
1998-02-10	11200	11300	11100	11200	655700
1998-02-12	11300	11300	10900	11100	1248400
1998-02-13	11100	11100	10800	11000	1306000
1998-02-16	11000	11300	10900	11300	658400
1998-02-17	11400	11500	11300	11400	571500
1998-02-18	11400	11400	11100	11300	434700
1998-02-19	11200	11300	11000	11000	665900
1998-02-20	11100	11100	10900	11000	555600
1998-02-23	11100	11300	11000	11200	458500
1998-02-24	11400	11400	11100	11300	691000
1998-02-25	11100	11300	11000	11300	681800
1998-02-26	11300	11500	11300	11500	733800
1998-02-27	11500	11500	11000	11400	1179000
1998-03-02	11400	11500	11200	11400	662400
1998-03-03	11500	11800	11500	11600	1833300
1998-03-04	11500	11600	11400	11600	777300
1998-03-05	11300	11400	11100	11100	694800
1998-03-06	11200	11400	11100	11300	463600
1998-03-09	11500	11600	11100	11200	587000
1998-03-10	11300	11300	11100	11200	356700
1998-03-11	11100	11100	10800	10900	789500
1998-03-12	10800	10900	10500	10500	1052400
1998-03-13	10400	10800	10400	10700	1866600
1998-03-16	10900	11000	10800	10900	690500
1998-03-17	11100	11200	11000	11100	710800
1998-03-18	11100	11100	10700	11000	934500
1998-03-19	10900	11000	10700	10800	569200
1998-03-20	10900	11100	10800	11000	1057700
1998-03-23	11100	11200	10900	11100	703700
1998-03-24	11000	11100	10900	10900	718500
1998-03-25	11100	11100	10800	11000	732400
1998-03-26	11200	11300	11100	11100	744600
1998-03-27	11200	11300	11100	11200	664100
1998-03-30	11300	11400	11000	11100	812900
1998-03-31	11100	11300	10900	11300	1475600
1998-04-01	11100	11600	11100	11400	1346000
1998-04-02	11800	11900	11600	11600	1468800
1998-04-03	11600	11700	11100	11300	1350100
1998-04-06	11300	11500	11200	11300	1267400
1998-04-07	11100	11300	10800	11000	1511600
1998-04-08	11100	11400	11100	11200	1262800
1998-04-09	11400	11400	11200	11300	1472200
1998-04-10	11300	11400	11200	11400	738800
1998-04-13	11350	11440	11300	11330	635100
1998-04-14	11360	11500	11320	11360	692500
1998-04-15	11410	11490	11340	11480	1244300
1998-04-16	11550	11610	11490	11520	1435100
1998-04-17	11130	11350	10920	11350	1623500
1998-04-20	11150	11300	11120	11300	734500
1998-04-21	11350	11380	11250	11330	704200
1998-04-22	11340	11340	11200	11280	865300
1998-04-23	11260	11270	11180	11200	679100
1998-04-24	11230	11410	11200	11300	921000
1998-04-27	11290	11320	11100	11140	860100
1998-04-28	11010	11150	10960	11020	971000
1998-04-30	11200	11200	10970	11010	677900
1998-05-01	11050	11100	10980	11100	682100
1998-05-06	11020	11020	10760	11000	1207200
1998-05-07	10910	10970	10630	10650	1279300
1998-05-08	10450	10670	10450	10550	2366200
1998-05-11	10570	10620	10430	10570	1226700
1998-05-12	10770	10990	10710	10940	1475300
1998-05-13	11000	11180	10910	11180	1459800
1998-05-14	11160	11440	11160	11220	1258300
1998-05-15	11280	11550	11250	11420	1560600
1998-05-18	11380	11420	11180	11420	651800
1998-05-19	11450	11620	11380	11600	942500
1998-05-20	11570	11700	11540	11550	800300
1998-05-21	11650	11800	11630	11700	902400
1998-05-22	11690	11690	11540	11610	546000
1998-05-25	11550	11620	11530	11600	367700
1998-05-26	11620	11760	11620	11720	747900
1998-05-27	11750	11860	11700	11850	1234500
1998-05-28	11750	11820	11740	11790	907200
1998-05-29	11690	11730	11610	11700	777900
1998-06-01	11610	11700	11340	11340	911200
1998-06-02	11440	11460	11350	11420	489000
1998-06-03	11430	11430	11210	11250	828400
1998-06-04	11200	11290	11150	11150	566800
1998-06-05	11350	11420	11260	11310	715700
1998-06-08	11340	11560	11330	11420	770600
1998-06-09	11590	11700	11590	11670	660800
1998-06-10	11690	11710	11550	11680	717400
1998-06-11	11570	11590	11310	11350	897500
1998-06-12	11340	11650	11140	11540	1925300
1998-06-15	11340	11500	11340	11350	630700
1998-06-16	11310	11490	11210	11290	758300
1998-06-17	11250	11270	10820	10900	1955300
1998-06-18	11390	11400	11000	11150	1189200
1998-06-19	10910	11190	10910	11140	579700
1998-06-22	11180	11200	11130	11140	277300
1998-06-23	11170	11240	11000	11050	332700
1998-06-24	11250	11400	11160	11380	624400
1998-06-25	11550	11750	11490	11670	1408200
1998-06-26	11700	11820	11690	11730	1443300
1998-06-29	11700	11830	11680	11790	457700
1998-06-30	11990	12040	11900	11950	1414700
1998-07-01	11990	12080	11830	12000	1266300
1998-07-02	11980	12090	11830	11890	1263200
1998-07-03	11900	12140	11890	12040	1095500
1998-07-06	11930	12070	11870	11920	504200
1998-07-07	11930	12220	11890	12130	787300
1998-07-08	12200	12330	12160	12190	1049100
1998-07-09	12210	12400	12150	12400	971700
1998-07-10	12490	12600	12140	12300	1724100
1998-07-13	12100	12650	12100	12640	933900
1998-07-14	12640	12710	12390	12530	813000
1998-07-15	12730	12930	12650	12900	1713200
1998-07-16	12950	13150	12880	13150	1438000
1998-07-17	13200	13260	13120	13150	1349000
1998-07-21	13400	13490	13360	13390	1216100
1998-07-22	13320	13360	13260	13300	858600
1998-07-23	13220	13270	12930	13050	630900
1998-07-24	12900	13290	12860	13240	719200
1998-07-27	13060	13250	13060	13060	779100
1998-07-28	13080	13130	12940	13060	886200
1998-07-29	12920	13040	12810	13040	743600
1998-07-30	12650	12780	12320	12430	2157200
1998-07-31	12410	12500	12190	12290	1722500
1998-08-03	12210	12220	12050	12180	944500
1998-08-04	11980	12170	11940	12020	1104300
1998-08-05	11960	12090	11840	11930	1594900
1998-08-06	11870	11870	11520	11650	2131000
1998-08-07	11700	11870	11670	11710	1104000
1998-08-10	11750	12000	11730	12000	672500
1998-08-11	11950	12100	11890	12000	1054600
1998-08-12	11610	11800	11510	11580	1473700
1998-08-13	11660	11700	11550	11680	923200
1998-08-14	11480	11630	11470	11500	1432000
1998-08-17	11480	11500	11150	11160	1060400
1998-08-18	11360	11550	11260	11550	772100
1998-08-19	11750	12070	11650	11980	1196200
1998-08-20	11970	12140	11830	12070	592100
1998-08-21	11970	12040	11850	11850	530300
1998-08-24	11450	11530	11230	11390	1085300
1998-08-25	11400	11670	11390	11390	972600
1998-08-26	11340	11340	11210	11220	834500
1998-08-27	11200	11240	11030	11130	957900
1998-08-28	10410	10690	10400	10570	1920800
1998-08-31	10640	10650	10250	10310	1537300
1998-09-01	9910	10230	9900	10230	1420200
1998-09-02	10090	10220	10050	10110	1546200
1998-09-03	10140	10260	10060	10170	997300
1998-09-04	10000	10030	9950	9980	959400
1998-09-07	9800	10180	9750	10160	1148700
1998-09-08	10250	10780	10240	10640	1713200
1998-09-09	10700	10700	10260	10290	1397000
1998-09-10	10490	10640	10290	10400	1052000
1998-09-11	10000	10150	9790	9800	3660600
1998-09-14	9810	10090	9780	9990	878300
1998-09-16	10000	10300	10000	10180	816200
1998-09-17	10110	10140	9910	9940	609400
1998-09-18	9750	9790	9650	9750	1385400
1998-09-21	9610	9680	9400	9410	980200
1998-09-22	9370	9460	8760	8980	2732400
1998-09-24	9480	9850	9390	9720	1591600
1998-09-25	9500	9570	9250	9500	830200
1998-09-28	9450	9630	9320	9470	994400
1998-09-29	9550	9810	9350	9750	997000
1998-09-30	9940	10020	9460	9490	1535900
1998-10-01	9290	9340	8550	8950	3460300
1998-10-02	8350	8450	8040	8320	4578500
1998-10-05	8370	8430	8150	8290	1260000
1998-10-06	8240	8540	8230	8420	1096600
1998-10-07	8520	8930	8350	8930	2000600
1998-10-08	8330	8380	7930	8150	2441200
1998-10-09	7750	7940	7650	7770	2627000
1998-10-12	8170	8450	8070	8420	1986700
1998-10-13	8330	8400	8230	8290	1191100
1998-10-14	8300	8390	8150	8200	1077300
1998-10-15	8200	8240	7920	7990	1222600
1998-10-16	8290	8300	8090	8140	1705600
1998-10-19	8030	8250	7920	8010	1450200
1998-10-20	8210	8380	8100	8320	1171800
1998-10-21	8500	8620	8470	8590	1699900
1998-10-22	8800	8920	8600	8650	1563600
1998-10-23	8790	8900	8700	8860	895900
1998-10-26	8800	8860	8710	8790	828800
1998-10-27	8690	8820	8400	8540	884700
1998-10-28	8200	8250	7980	8010	2045000
1998-10-29	7710	7860	7630	7700	3320100
1998-10-30	7700	7700	7230	7400	3217300
1998-11-02	7500	7630	7350	7500	1720500
1998-11-04	7890	7950	7770	7940	2479700
1998-11-05	8140	8290	8050	8210	2898600
1998-11-06	8250	8320	8190	8280	1766900
1998-11-09	8280	8350	8250	8350	873300
1998-11-10	8370	8580	8340	8390	1478100
1998-11-11	8380	8410	8160	8380	1188400
1998-11-12	8280	8290	8090	8130	1026400
1998-11-13	8150	8220	7960	8100	1479600
1998-11-16	8070	8170	7960	8080	1285200
1998-11-17	8180	8280	8120	8280	933900
1998-11-18	8280	8580	8260	8510	1613700
1998-11-19	8580	8590	8350	8440	851500
1998-11-20	8600	8650	8530	8600	1058300
1998-11-24	9000	9250	8880	9200	2397800
1998-11-25	9020	9130	8970	9130	962600
1998-11-26	9200	9320	9170	9280	1163200
1998-11-27	9310	9420	9240	9400	771100
1998-11-30	9400	9420	9010	9010	1008600
1998-12-01	9010	9140	8970	9040	863500
1998-12-02	9010	9100	8900	9100	1087300
1998-12-03	9050	9130	9000	9000	746000
1998-12-04	8950	8990	8780	8890	797200
1998-12-07	8950	8980	8890	8950	619400
1998-12-08	9020	9100	9000	9010	667700
1998-12-09	8910	9030	8870	8990	584600
1998-12-10	8950	9000	8830	8850	566600
1998-12-11	8750	8880	8580	8690	2168700
1998-12-14	8590	8590	8300	8300	933700
1998-12-15	8300	8420	8240	8260	701400
1998-12-16	8360	8490	8320	8440	546800
1998-12-17	8400	8440	8260	8310	777300
1998-12-18	8410	8550	8380	8500	657300
1998-12-21	8500	8500	8380	8440	444800
1998-12-22	8540	8570	8260	8320	672700
1998-12-24	8380	8380	8230	8270	446800
1998-12-25	8390	8440	8270	8270	198900
1998-12-28	8370	8400	8240	8280	299700
1998-12-29	8350	8350	8210	8260	399900
1998-12-30	8280	8370	8230	8230	140500
1999-01-04	8100	8160	8030	8050	500300
1999-01-05	8030	8050	7720	7770	1312300
1999-01-06	7830	7850	7660	7740	1650700
1999-01-07	7940	7990	7640	7700	1788800
1999-01-08	7600	7670	7480	7570	2111600
1999-01-11	7590	7600	7450	7460	1629000
1999-01-12	7360	7530	7290	7390	3015700
1999-01-13	7490	7610	7440	7560	1971800
1999-01-14	7520	7700	7500	7650	1441100
1999-01-18	7790	7890	7760	7880	1110700
1999-01-19	7900	7930	7780	7900	1091400
1999-01-20	7860	8020	7820	7990	1007200
1999-01-21	8030	8150	7930	8090	1272000
1999-01-22	8050	8190	8050	8060	1007500
1999-01-25	8020	8060	7900	7920	1035500
1999-01-26	7930	7980	7800	7900	920300
1999-01-27	7890	8130	7810	8060	925500
1999-01-28	8210	8340	8130	8130	1608700
1999-01-29	8430	8520	8370	8450	1634400
1999-02-01	8540	8570	8450	8520	726700
1999-02-02	8480	8480	8360	8410	518700
1999-02-03	8240	8320	8160	8200	729800
1999-02-04	8300	8460	8210	8290	833100
1999-02-05	8250	8290	8110	8170	716300
1999-02-08	8270	8350	8210	8350	575000
1999-02-09	8400	8400	8210	8220	645600
1999-02-10	8150	8400	8140	8400	742400
1999-02-12	8300	8390	8280	8340	1189400
1999-02-15	8350	8420	8320	8400	511700
1999-02-16	8450	8640	8450	8600	1057500
1999-02-17	8800	8900	8750	8840	1754400
1999-02-18	8830	8860	8710	8850	879600
1999-02-19	8950	9100	8910	9100	1580100
1999-02-22	9160	9170	9080	9100	762400
1999-02-23	9090	9140	9020	9140	656500
1999-02-24	9090	9170	8990	9060	1139000
1999-02-25	9160	9220	9060	9090	808800
1999-02-26	9080	9080	8960	8980	684800
1999-03-01	8890	8950	8720	8720	780700
1999-03-02	8840	8940	8690	8690	740800
1999-03-03	8860	9100	8820	9070	1090100
1999-03-04	9270	9480	9220	9450	2144900
1999-03-05	10000	10110	9860	10100	3346700
1999-03-08	10300	10340	10050	10050	1827200
1999-03-09	10650	11050	10550	10940	4667200
1999-03-10	11700	11930	11590	11850	5954500
1999-03-11	11050	11350	10750	10910	4262200
1999-03-12	11200	11280	11000	11010	3765600
1999-03-15	11150	11300	11080	11300	1979700
1999-03-16	11500	11530	11360	11500	3095900
1999-03-17	11430	11590	11290	11590	1864400
1999-03-18	11550	11550	10980	11070	1732100
1999-03-19	11200	11400	11100	11360	1513500
1999-03-23	11500	11550	11260	11400	1556000
1999-03-24	10800	11030	10750	10750	1585400
1999-03-25	11050	11300	11050	11290	1072400
1999-03-26	11400	11500	11090	11400	1108000
1999-03-29	11390	11420	11280	11300	864500
1999-03-30	11400	11450	11120	11300	922000
1999-03-31	11100	11200	10930	10950	843100
1999-04-01	11000	11400	10940	11300	1219000
1999-04-02	11500	11570	11350	11400	1278400
1999-04-05	11400	11490	11240	11380	716300
1999-04-06	11500	11690	11310	11690	1320000
1999-04-07	11750	12250	11660	12090	4334100
1999-04-08	12090	12400	12000	12400	1777200
1999-04-09	12800	12800	12300	12360	2983800
1999-04-12	12160	12240	11970	12000	911800
1999-04-13	12200	12210	12050	12080	1169900
1999-04-14	11950	11980	11600	11700	1709900
1999-04-15	11750	11960	11670	11850	1288800
1999-04-16	11900	12020	11600	11610	1245700
1999-04-19	11610	11610	11310	11450	1082300
1999-04-20	11250	11370	11200	11300	1028100
1999-04-21	11330	11400	11180	11280	659200
1999-04-22	11480	11490	11270	11490	1110200
1999-04-23	11500	11690	11480	11630	1040700
1999-04-26	11550	11680	11430	11430	707600
1999-04-27	11630	11640	11450	11560	770400
1999-04-28	11650	11870	11560	11700	1430100
1999-04-30	11300	11330	11050	11150	2407400
1999-05-06	11100	11320	11090	11280	1567700
1999-05-07	11270	11300	11000	11000	1204700
1999-05-10	11150	11190	11070	11090	677200
1999-05-11	11220	11220	11080	11120	950500
1999-05-12	11300	11440	11220	11220	1101300
1999-05-13	11160	11330	11120	11250	616100
1999-05-14	11330	11340	11240	11320	1371200
1999-05-17	11280	11290	11160	11180	728600
1999-05-18	11180	11270	11050	11180	785100
1999-05-19	11010	11220	10960	10980	1077000
1999-05-20	11180	11450	11000	11410	1173400
1999-05-21	11410	11490	11300	11480	773600
1999-05-24	11440	11630	11360	11600	998800
1999-05-25	11300	11370	11150	11170	941100
1999-05-26	11160	11500	11140	11310	865700
1999-05-27	11510	11510	11310	11450	614500
1999-05-28	11340	11410	11280	11360	1001100
1999-05-31	11300	11330	11110	11230	793000
1999-06-01	11150	11310	11110	11240	741400
1999-06-02	11220	11230	11030	11080	926900
1999-06-03	11010	11070	10800	10850	1330000
1999-06-04	10890	10940	10720	10850	906300
1999-06-07	10950	11270	10920	11170	1203200
1999-06-08	11370	11400	11260	11300	859700
1999-06-09	11300	11400	11270	11370	698800
1999-06-10	11300	11540	11230	11440	1084100
1999-06-11	11400	11850	11400	11800	4566400
1999-06-14	11820	11990	11730	11800	1616200
1999-06-15	11890	12020	11750	11990	1280600
1999-06-16	11950	12030	11850	11900	941400
1999-06-17	12100	12240	12050	12150	1462200
1999-06-18	12190	12300	12160	12290	1506800
1999-06-21	12490	12980	12410	12980	2909200
1999-06-22	13380	13410	13170	13300	4743500
1999-06-23	13100	13150	12950	13020	2263700
1999-06-24	12900	12940	12720	12850	1317500
1999-06-25	12650	12710	12510	12510	1040000
1999-06-28	12600	12610	12510	12580	772900
1999-06-29	12660	13150	12660	13070	2400300
1999-06-30	13300	13460	13050	13050	2489000
1999-07-01	13350	13590	13210	13590	2853900
1999-07-02	13700	13770	13460	13650	1915700
1999-07-05	13740	13900	13700	13700	1429100
1999-07-06	13700	13740	13300	13500	1184200
1999-07-07	13500	13620	13350	13500	1227000
1999-07-08	13600	13870	13520	13700	2000900
1999-07-09	13800	13840	13530	13770	1650900
1999-07-12	13860	14430	13800	14430	2571000
1999-07-13	14300	14550	14230	14420	1885300
1999-07-14	14310	14730	14310	14540	1831000
1999-07-15	14800	14900	14660	14820	2002100
1999-07-16	15420	15680	15060	15150	2490800
1999-07-19	15100	15120	14880	15020	1212500
1999-07-21	14420	14510	14200	14330	1710800
1999-07-22	14130	14180	13700	13850	1637600
1999-07-23	13500	13920	13470	13700	1654300
1999-07-26	13900	14150	13850	13970	1457200
1999-07-27	14070	14120	13720	13770	1449500
1999-07-28	14100	14230	13920	14020	1222600
1999-07-29	14550	15230	14520	14750	3306300
1999-07-30	14490	14790	14380	14590	1820600
1999-08-02	14300	14490	14260	14360	1226500
1999-08-03	14450	14550	14210	14440	1422600
1999-08-04	14250	14300	14000	14040	1317800
1999-08-05	13640	13730	13490	13650	1573100
1999-08-06	13700	13820	13650	13740	1504800
1999-08-09	13650	13890	13580	13770	1041700
1999-08-10	13890	14270	13840	14240	2000700
1999-08-11	14160	14360	14090	14130	1439800
1999-08-12	14500	14550	14330	14390	984600
1999-08-13	14390	14610	14300	14530	1356400
1999-08-16	15000	15000	14820	14820	1365700
1999-08-17	14980	15070	14870	14950	1852800
1999-08-18	15100	15210	14890	14970	2271400
1999-08-19	14570	14600	14300	14450	1307300
1999-08-20	14150	14790	14150	14750	1577800
1999-08-23	14900	14900	14280	14460	966300
1999-08-24	14800	15000	14690	14800	1016400
1999-08-25	14550	14750	14260	14330	974300
1999-08-26	14500	14570	14310	14310	837600
1999-08-27	14310	14400	14210	14350	574300
1999-08-30	14150	14570	14140	14550	554600
1999-08-31	14210	14320	14110	14180	1113900
1999-09-01	14110	14440	14060	14350	1074800
1999-09-02	14350	14370	14150	14150	666700
1999-09-03	14060	14270	14050	14140	783300
1999-09-06	14540	14540	14210	14220	674600
1999-09-07	14300	14440	14190	14350	801600
1999-09-08	14330	14330	14170	14310	965000
1999-09-09	14500	14520	14160	14160	879000
1999-09-10	14000	14520	13990	14280	3678200
1999-09-13	14640	15090	14570	14930	2772700
1999-09-14	15330	16150	15070	15950	7465600
1999-09-16	15550	15840	15500	15600	3823800
1999-09-17	15620	15780	15360	15540	2359100
1999-09-20	15940	16870	15930	16460	4696500
1999-09-21	16750	17260	16670	17250	4750200
1999-09-22	16450	16870	16330	16600	3832600
1999-09-24	16000	16080	15600	15970	3384300
1999-09-27	16050	16280	15750	15760	1430800
1999-09-28	16160	16230	16000	16140	1410000
1999-09-29	16140	16140	15800	15940	950500
1999-09-30	16100	16240	15910	15910	1563100
1999-10-01	16190	16920	16150	16550	3467900
1999-10-04	16490	16670	16400	16500	1372600
1999-10-05	16700	16880	16550	16620	1248600
1999-10-06	16800	16800	16410	16700	1183400
1999-10-07	16900	16970	16730	16880	1919900
1999-10-08	16800	16800	16560	16790	1604800
1999-10-12	16590	16800	16570	16690	1330200
1999-10-13	16580	16690	16510	16510	849900
1999-10-14	16430	16840	16420	16680	996500
1999-10-15	16690	16790	16160	16250	1189300
1999-10-18	15500	15700	15130	15270	2217300
1999-10-19	15400	15410	15170	15210	1123700
1999-10-20	15600	15780	15520	15590	1344200
1999-10-21	15740	15740	15360	15420	1049400
1999-10-22	15600	15640	15340	15420	1013400
1999-10-25	15800	16010	15730	15750	1507600
1999-10-26	15850	16090	15790	15880	1093500
1999-10-27	15960	16000	15550	15620	1179100
1999-10-28	15820	16020	15710	15710	1617600
1999-10-29	16200	16410	16160	16260	2421900
1999-11-01	16400	16620	16350	16370	1600400
1999-11-02	16370	16550	16310	16540	1013100
1999-11-04	16640	16830	16620	16660	2068100
1999-11-05	16790	17340	16630	17050	3230400
1999-11-08	17400	17580	17300	17410	3446500
1999-11-09	17810	18050	17650	17990	4193300
1999-11-10	17850	18450	17650	18300	3060900
1999-11-11	18300	18520	18080	18080	2589100
1999-11-12	18090	18550	18080	18490	1993400
1999-11-15	18690	18940	18670	18760	2024900
1999-11-16	18750	19100	18430	18800	2203700
1999-11-17	19200	19370	18430	18730	2153400
1999-11-18	18730	18730	18390	18560	1516100
1999-11-19	18680	18880	18530	18600	1412400
1999-11-22	18700	19000	18700	18800	1353300
1999-11-24	18660	19090	18590	18890	1900300
1999-11-25	19090	19270	18770	18800	1590400
1999-11-26	19000	19300	18730	19300	1289400
1999-11-29	19200	19400	19040	19350	1447800
1999-11-30	19330	19370	18750	18900	1424700
1999-12-01	18700	18800	18310	18430	1196200
1999-12-02	18430	18570	17900	18130	1188900
1999-12-03	18200	18280	18060	18150	830400
1999-12-06	18550	18620	18370	18550	1222400
1999-12-07	18730	18900	18630	18780	1371300
1999-12-08	18780	18790	18460	18540	868000
1999-12-09	18740	18740	18310	18470	913600
1999-12-10	19590	19720	19050	19160	5684600
1999-12-13	19250	19260	18980	19250	1499400
1999-12-14	19370	19510	19280	19400	2037600
1999-12-15	19380	19450	19300	19410	2005600
1999-12-16	19450	19510	19150	19430	1185400
1999-12-17	19630	20970	19460	20510	4412200
1999-12-20	21500	22080	21290	21320	3315300
1999-12-21	21320	21700	21320	21650	2154100
1999-12-22	21850	23650	21770	23090	3362700
1999-12-24	24290	24980	24160	24800	3194100
1999-12-27	24610	24850	24060	24300	1181800
1999-12-28	26300	26300	26300	26300	80200
1999-12-29	28300	28300	28300	28300	189500
1999-12-30	30300	30300	30300	30300	2419800
2000-01-04	30000	32250	29800	30700	4397100
2000-01-05	27700	27700	27700	27700	1036600
2000-01-06	27100	27250	25700	25700	4959900
2000-01-07	23700	24100	23700	23700	4680100
2000-01-11	25700	25700	25700	25700	1241300
2000-01-12	25100	25790	24730	25400	3931600
2000-01-13	24700	24790	24000	24250	2974000
2000-01-14	24450	24550	23430	24000	3058500
2000-01-17	24200	24780	24170	24630	1665900
2000-01-18	24030	24150	23630	23780	1573500
2000-01-19	23980	24160	23450	23450	1656600
2000-01-20	23600	23950	23450	23700	1554300
2000-01-21	24000	24200	23850	24200	1389000
2000-01-24	24800	25200	24720	25150	2111000
2000-01-25	24750	25600	24670	25030	2012500
2000-01-26	25350	25530	25280	25480	1412300
2000-01-27	26000	26250	25800	26250	2025400
2000-01-28	26450	27350	26310	27090	2375800
2000-01-31	26690	27500	26500	26960	1788800
2000-02-01	27500	27500	26900	27130	1817500
2000-02-02	27520	28150	27450	27550	2887200
2000-02-03	28140	28250	27960	28100	1894200
2000-02-04	28900	29590	28900	29180	2824600
2000-02-07	29980	29990	29500	29980	2193800
2000-02-08	30000	30000	28710	29150	2162900
2000-02-09	29750	29850	29550	29570	2144200
2000-02-10	28970	29000	28410	28710	2456300
2000-02-14	28110	28450	28000	28000	1672300
2000-02-15	28140	28440	27950	28010	1726400
2000-02-16	27960	28010	27380	27900	1489500
2000-02-17	27800	29480	27520	28900	2504000
2000-02-18	29300	29780	29150	29650	2058600
2000-02-21	30000	31650	29950	31650	4145600
2000-02-22	33150	33250	30100	30350	4323900
2000-02-23	30250	30600	29360	30000	2192400
2000-02-24	30600	30750	29870	29970	1839500
2000-02-25	30350	30850	30000	30850	1898300
2000-02-28	30800	31550	30650	31000	2293500
2000-02-29	31600	32900	31500	32500	3877400
2000-03-01	33700	33900	32500	32600	3722100
2000-03-02	32900	32950	31950	32300	2145600
2000-03-03	31400	31900	30850	31000	2062500
2000-03-06	31300	31450	29020	29550	2843000
2000-03-07	28750	29380	28550	29040	2854200
2000-03-08	28300	29250	28140	28860	1933800
2000-03-09	28900	29330	28020	28100	1965400
2000-03-10	28100	28170	26100	26300	5750000
2000-03-13	25100	25180	24300	24300	2331200
2000-03-14	23900	25840	23900	25390	3758400
2000-03-15	25590	26950	25430	26750	2859100
2000-03-16	26950	27320	26310	27010	1944900
2000-03-17	26810	26810	26070	26640	2383800
2000-03-21	26500	26500	25760	25950	2052500
2000-03-22	25750	26700	25700	26380	2136300
2000-03-23	26390	26390	25760	25870	1912600
2000-03-24	26050	26150	25700	25700	2260600
2000-03-27	25800	26680	24700	26400	5468600
2000-03-28	13000	13450	12600	13120	6840000
2000-03-29	13300	13840	13300	13730	5632000
2000-03-30	13920	14880	13800	14500	8860000
2000-03-31	14300	14820	14050	14500	4130100
2000-04-03	14490	15100	14360	15000	5948200
2000-04-04	14920	14930	14570	14760	3046100
2000-04-05	14360	14440	14060	14250	4283300
2000-04-06	14250	14330	13810	14060	2975500
2000-04-07	14200	14250	13900	14020	2619200
2000-04-10	14420	14580	14350	14570	2759100
2000-04-11	14370	14460	14170	14250	2040900
2000-04-12	14020	14120	13940	14110	2316600
2000-04-13	13700	13770	13300	13450	3465000
2000-04-14	13180	13630	13070	13280	4223000
2000-04-17	11880	12200	11450	12040	6895300
2000-04-18	12440	12650	12200	12380	4006400
2000-04-19	12580	12670	12400	12590	3091000
2000-04-20	12600	12930	12510	12580	4359300
2000-04-21	12780	12870	12280	12300	5009100
2000-04-24	12690	12800	12520	12700	2721400
2000-04-25	12700	12740	12450	12700	2792900
2000-04-26	12850	12850	12520	12750	2296900
2000-04-27	12560	12650	12450	12480	2388400
2000-04-28	12500	12570	12190	12410	2654000
2000-05-01	12210	12640	12110	12580	2800500
2000-05-02	12660	12700	12380	12500	1980100
2000-05-08	12480	12480	12110	12170	3288100
2000-05-09	11900	11960	11700	11700	3835200
2000-05-10	11600	11920	11490	11810	3228500
2000-05-11	11550	11600	11320	11440	3567000
2000-05-12	11700	11790	11600	11690	2880200
2000-05-15	11710	11790	11630	11720	1318200
2000-05-16	11720	11740	11580	11670	1295800
2000-05-17	11800	11850	11710	11770	1322300
2000-05-18	11670	11670	11380	11490	2024300
2000-05-19	11090	11190	10700	10830	3823300
2000-05-22	10230	10340	10010	10280	3968200
2000-05-23	10080	10310	9900	10000	5788700
2000-05-24	9700	9750	9260	9490	5688800
2000-05-25	9990	10350	9970	10080	4601700
2000-05-26	9780	9860	9490	9680	4642000
2000-05-29	9780	10330	9720	10100	4685800
2000-05-30	10080	10100	9880	9970	1593100
2000-05-31	10160	10160	9520	9750	4063000
2000-06-01	9550	9750	9490	9750	3822500
2000-06-02	9950	10300	9910	10290	4033000
2000-06-05	10890	11150	10720	11120	4938100
2000-06-06	11090	11100	10910	11100	2406400
2000-06-07	10900	11010	10850	11000	1833200
2000-06-08	11000	11060	10740	10750	2194500
2000-06-09	10550	10850	10500	10680	3207600
2000-06-12	10560	10610	10460	10590	1214600
2000-06-13	10400	10560	10170	10280	1855500
2000-06-14	10050	10070	9780	9850	3575700
2000-06-15	9600	9700	9410	9550	4737500
2000-06-16	9550	9780	9490	9660	3236300
2000-06-19	9670	9720	9510	9700	2385400
2000-06-20	9800	9950	9780	9800	2047900
2000-06-21	9970	10090	9900	10010	2370400
2000-06-22	10200	10360	10050	10150	3293500
2000-06-23	10000	10080	9920	9990	2109800
2000-06-26	9890	9890	9680	9850	1850900
2000-06-27	9870	9930	9780	9910	1501900
2000-06-28	9910	9920	9780	9890	1583700
2000-06-29	10080	10230	10020	10100	1743800
2000-06-30	10000	10060	9850	9900	1281200
2000-07-03	9930	10350	9930	10340	1772800
2000-07-04	10500	10520	10220	10420	1753400
2000-07-05	10610	10710	10480	10600	1825500
2000-07-06	10580	10870	10360	10750	2485600
2000-07-07	11000	11100	10900	10980	3344000
2000-07-10	11150	11250	11110	11180	2841300
2000-07-11	11000	11130	10840	10900	2072400
2000-07-12	11050	11080	10820	10820	1612200
2000-07-13	10650	10750	10500	10560	1759700
2000-07-14	10720	10910	10650	10900	1744400
2000-07-17	11100	11260	11000	11170	1850200
2000-07-18	11200	11200	10770	10910	1590600
2000-07-19	10660	11070	10640	10950	2002400
2000-07-21	10950	10950	10610	10680	1620200
2000-07-24	10500	10550	10300	10490	1409100
2000-07-25	10290	10460	10250	10450	2617500
2000-07-26	10610	10840	10510	10710	1823000
2000-07-27	10520	10580	10250	10360	2592000
2000-07-28	10160	10210	9940	10180	2469200
2000-07-31	9880	10270	9850	10070	2572800
2000-08-01	10250	10340	9990	10040	2833500
2000-08-02	10180	10500	10120	10400	2321100
2000-08-03	10120	10180	9980	10030	2549800
2000-08-04	9950	10020	9850	9900	3709700
2000-08-07	10000	10160	9920	10150	1935200
2000-08-08	10200	10240	9960	10090	1644100
2000-08-09	10000	10050	9910	10050	2008200
2000-08-10	10030	10090	10020	10090	1746300
2000-08-11	10040	10280	10040	10200	2379000
2000-08-14	10200	10280	10100	10190	1016400
2000-08-15	10350	10600	10310	10550	2846600
2000-08-16	10630	10740	10510	10640	1962600
2000-08-17	10570	10690	10460	10580	1218400
2000-08-18	10580	10630	10510	10610	1161400
2000-08-21	10500	10570	10320	10430	925200
2000-08-22	10320	10430	10150	10430	1392400
2000-08-23	10500	10640	10450	10540	1990600
2000-08-24	10580	10880	10550	10800	2428800
2000-08-25	11000	11100	10930	11100	3107900
2000-08-28	11400	12030	11300	11890	6642900
2000-08-29	11950	11990	11750	11850	3012600
2000-08-30	11850	11940	11500	11530	2032400
2000-08-31	11730	11900	11630	11900	2583900
2000-09-01	12000	12140	11860	11990	3088400
2000-09-04	12000	12030	11870	11900	1297600
2000-09-05	11800	11840	11530	11620	2077100
2000-09-06	11420	11580	11330	11330	2236100
2000-09-07	11340	11460	11280	11340	1836000
2000-09-08	11600	11740	11500	11680	3613600
2000-09-11	11600	11850	11570	11700	2077000
2000-09-12	11550	11700	11510	11650	1562200
2000-09-13	11460	11690	11460	11650	1581500
2000-09-14	11700	11750	11370	11430	1758600
2000-09-18	11430	11880	11400	11750	2397600
2000-09-19	11550	11990	11520	11940	2791000
2000-09-20	12000	12370	11960	12260	4413400
2000-09-21	12300	12480	12200	12480	3275900
2000-09-22	12000	12090	11760	11830	2898500
2000-09-25	12030	12140	11700	11840	1495700
2000-09-26	11850	11950	11630	11800	1215200
2000-09-27	11500	11550	11350	11370	2018400
2000-09-28	10970	11110	10630	10640	3089900
2000-09-29	11000	11120	10900	10960	3227400
2000-10-02	10660	10800	10480	10800	3041400
2000-10-03	10750	10840	10670	10690	1977800
2000-10-04	10500	10870	10500	10760	1806000
2000-10-05	10770	10800	10560	10650	2097200
2000-10-06	10650	10870	10650	10740	1645700
2000-10-10	10540	10680	10540	10650	1816200
2000-10-11	10450	10460	10240	10280	2369900
2000-10-12	10090	10240	10050	10150	2373900
2000-10-13	10000	10110	9990	10050	2688100
2000-10-16	10200	10270	10010	10080	2389200
2000-10-17	10010	10090	9990	10010	2055300
2000-10-18	9800	9840	9540	9610	4312000
2000-10-19	9710	9820	9690	9770	2091500
2000-10-20	10370	10550	10250	10470	4420200
2000-10-23	10470	10490	10180	10280	1819600
2000-10-24	10250	10430	10160	10380	1548000
2000-10-25	10580	10680	10410	10410	2563500
2000-10-26	10210	10420	10150	10350	1817500
2000-10-27	9900	9950	9480	9570	6123000
2000-10-30	9370	9430	9090	9190	4445200
2000-10-31	9000	9020	8620	8720	5410300
2000-11-01	9050	9290	9030	9250	3377000
2000-11-02	9050	9060	8920	8990	3703900
2000-11-06	9140	9360	9100	9360	2616600
2000-11-07	9340	9340	9080	9140	2196800
2000-11-08	9080	9350	9060	9230	2094400
2000-11-09	9060	9150	9030	9060	1952800
2000-11-10	8950	9000	8830	8850	2807100
2000-11-13	8510	8540	8410	8470	3254900
2000-11-14	8470	8530	8360	8470	2837900
2000-11-15	8770	8780	8510	8520	2694900
2000-11-16	8500	8530	8320	8340	2946800
2000-11-17	8250	8480	8100	8230	3574100
2000-11-20	8130	8190	8070	8120	2060500
2000-11-21	8000	8010	7820	7940	3808600
2000-11-22	8040	8120	7990	8040	3239400
2000-11-24	8140	8200	8050	8170	2609600
2000-11-27	8470	8960	8420	8800	3672200
2000-11-28	8900	8980	8790	8930	2349000
2000-11-29	8710	8730	8400	8510	2770800
2000-11-30	8310	8420	8190	8360	3052600
2000-12-01	8290	8350	8160	8240	2832400
2000-12-04	8300	8630	8290	8540	2785400
2000-12-05	8610	8640	8420	8450	1685700
2000-12-06	8850	8920	8730	8800	3083200
2000-12-07	8740	8740	8570	8670	1281500
2000-12-08	8550	8600	8420	8540	4049500
2000-12-11	8800	8980	8760	8980	2551800
2000-12-12	8960	9040	8830	8900	2962400
2000-12-13	8800	9010	8660	8980	2288800
2000-12-14	8780	8870	8700	8790	2120700
2000-12-15	8540	8630	8330	8340	2641200
2000-12-18	8240	8440	8240	8400	2022700
2000-12-19	8350	8370	8230	8300	1472600
2000-12-20	8100	8160	8010	8100	2749300
2000-12-21	7830	7920	7570	7770	3744500
2000-12-22	7800	7860	7510	7560	3149800
2000-12-25	7760	7900	7710	7900	1906000
2000-12-26	7880	7990	7830	7900	1330400
2000-12-27	7880	7930	7770	7900	1017400
2000-12-28	8000	8110	7950	8000	1693000
2000-12-29	8070	8070	7900	7900	702300
2001-01-04	8300	8430	8200	8230	2575900
2001-01-05	8430	8600	8410	8600	3954400
2001-01-09	8700	8710	8530	8690	3687100
2001-01-10	8740	8820	8700	8700	2911100
2001-01-11	8750	8770	8400	8620	2850400
2001-01-12	8630	8830	8630	8800	3763700
2001-01-15	8900	9050	8850	8980	3690900
2001-01-16	9020	9060	8830	8930	3052000
2001-01-17	8830	8990	8730	8920	2032600
2001-01-18	9050	9160	8770	8850	3063300
2001-01-19	8980	9120	8870	9080	3707400
2001-01-22	8990	9050	8750	8870	2460100
2001-01-23	8720	8850	8630	8750	2117100
2001-01-24	8750	8850	8530	8580	2647200
2001-01-25	8500	8590	8350	8510	2416500
2001-01-26	8500	8730	8470	8570	2365300
2001-01-29	8550	8630	8490	8590	1487700
2001-01-30	8560	8610	8380	8460	2098900
2001-01-31	8360	8460	8290	8450	1442600
2001-02-01	8330	8440	8260	8440	2096600
2001-02-02	8340	8370	8150	8160	2591300
2001-02-05	8000	8120	7990	8040	2597000
2001-02-06	8040	8260	8040	8160	2427100
2001-02-07	8060	8440	8060	8320	2644900
2001-02-08	8400	8510	8270	8450	3204700
2001-02-09	8550	8640	8510	8550	3469600
2001-02-13	8650	8700	8480	8550	2634500
2001-02-14	8450	8500	8230	8360	2296600
2001-02-15	8380	8480	8370	8440	1484100
2001-02-16	8340	8420	8260	8300	2087200
2001-02-19	8200	8340	8180	8340	1482700
2001-02-20	8240	8310	8230	8270	1442800
2001-02-21	8170	8220	8080	8150	1840300
2001-02-22	8040	8220	8000	8180	2035000
2001-02-23	8160	8450	8160	8360	1733000
2001-02-26	8390	8640	8370	8520	2635900
2001-02-27	8620	8770	8560	8580	2683600
2001-02-28	8380	8450	8350	8450	1885900
2001-03-01	8250	8320	8150	8220	2946400
2001-03-02	8150	8360	8050	8130	3407800
2001-03-05	8100	8160	8050	8150	1942000
2001-03-06	8240	8360	8210	8360	1824800
2001-03-07	8560	8570	8310	8480	2834400
2001-03-08	8580	8650	8530	8550	3126700
2001-03-09	8350	8520	8340	8490	4026300
2001-03-12	8390	8420	8220	8330	2218500
2001-03-13	8060	8190	8060	8100	3991500
2001-03-14	8130	8210	8080	8120	3042200
2001-03-15	8000	8170	8000	8160	3062700
2001-03-16	8260	8600	8250	8440	3119300
2001-03-19	8340	8620	8200	8270	2214800
2001-03-21	8310	8590	8300	8580	2875900
2001-03-22	8510	8880	8510	8710	3524900
2001-03-23	8880	9070	8840	9000	4713000
2001-03-26	9060	9290	9060	9290	3921500
2001-03-27	9270	9560	9170	9370	4022700
2001-03-28	9470	9480	9240	9350	2272700
2001-03-29	9120	9150	8920	8970	2311200
2001-03-30	8990	9050	8810	8900	2341800
2001-04-02	8810	8930	8610	8890	3125700
2001-04-03	8700	8870	8680	8740	2111000
2001-04-04	8550	8700	8510	8700	2552200
2001-04-05	8760	8950	8740	8890	2199500
2001-04-06	9140	9140	8900	8900	2255400
2001-04-09	8800	8810	8600	8600	1674200
2001-04-10	8570	8640	8420	8450	1919200
2001-04-11	8560	8680	8490	8660	2399600
2001-04-12	8700	8840	8650	8720	2033400
2001-04-13	8820	8950	8530	8630	2172500
2001-04-16	8570	8710	8520	8670	996800
2001-04-17	8680	8840	8610	8770	1828600
2001-04-18	8900	9000	8840	8960	2896000
2001-04-19	9360	9380	9140	9250	3760100
2001-04-20	9200	9280	9050	9170	1912300
2001-04-23	9120	9270	8990	8990	1842600
2001-04-24	8850	8980	8770	8930	1751100
2001-04-25	9050	9260	9010	9030	1972300
2001-04-26	9230	9250	9100	9150	2347400
2001-04-27	9250	9270	9130	9240	1772000
2001-05-01	9440	9520	9360	9520	4080800
2001-05-02	9720	9830	9650	9790	5830400
2001-05-07	9890	9950	9790	9930	5215900
2001-05-08	9890	10000	9840	9990	4565200
2001-05-09	9990	9990	9670	9770	3792400
2001-05-10	9670	9800	9670	9740	1606100
2001-05-11	9780	9920	9770	9880	2605900
2001-05-14	9710	9750	9450	9630	2700000
2001-05-15	9480	9720	9420	9690	1903100
2001-05-16	9710	9930	9700	9700	2060100
2001-05-17	9870	9980	9820	9980	2908100
2001-05-18	9970	10050	9910	9960	3277800
2001-05-21	10000	10170	9970	10170	2887500
2001-05-22	10300	10340	10120	10150	3166500
2001-05-23	10100	10250	10070	10200	1805400
2001-05-24	9900	9970	9850	9950	2193200
2001-05-25	10000	10160	9970	10000	1916900
2001-05-28	9880	9940	9730	9750	1448600
2001-05-29	9700	9860	9700	9810	908100
2001-05-30	9610	9660	9350	9400	2915700
2001-05-31	9200	9360	9130	9170	2522600
2001-06-01	9370	9420	9260	9300	1449400
2001-06-04	9400	9440	9320	9370	1074700
2001-06-05	9210	9270	9060	9260	2686800
2001-06-06	9400	9440	9160	9270	1682700
2001-06-07	9200	9210	9090	9140	1689500
2001-06-08	9080	9280	9060	9210	5306300
2001-06-11	9200	9220	9110	9180	1181000
2001-06-12	9060	9100	8800	8800	2345200
2001-06-13	8830	8980	8810	8840	2522800
2001-06-14	8860	8940	8810	8850	1243100
2001-06-15	8750	8810	8600	8780	2542100
2001-06-18	8730	8790	8620	8660	1693800
2001-06-19	8760	8940	8730	8760	2198100
2001-06-20	8750	8840	8640	8660	2003800
2001-06-21	8750	8750	8500	8610	2502500
2001-06-22	8650	8850	8650	8690	2360200
2001-06-25	8590	8640	8320	8380	3106200
2001-06-26	8280	8350	8150	8180	4090800
2001-06-27	8190	8360	8170	8190	3147100
2001-06-28	8220	8230	8020	8100	3122100
2001-06-29	8220	8260	8120	8200	2548800
2001-07-02	8280	8280	8100	8150	1823600
2001-07-03	8200	8220	7960	7980	3328100
2001-07-04	7950	7960	7780	7800	3762500
2001-07-05	7600	7670	7530	7590	5513100
2001-07-06	7450	7460	7200	7250	6923200
2001-07-09	7100	7190	7030	7150	5770100
2001-07-10	7130	7350	7080	7240	7196400
2001-07-11	7130	7160	7010	7010	5351900
2001-07-12	7210	7420	7200	7420	4240000
2001-07-13	7520	7550	7200	7380	5382500
2001-07-16	7380	7450	7320	7400	1687100
2001-07-17	7280	7320	7240	7270	2903000
2001-07-18	7220	7250	6990	7000	6418700
2001-07-19	7020	7180	7020	7160	4276100
2001-07-23	7190	7190	6930	7020	3802900
2001-07-24	7060	7110	6930	7060	3624700
2001-07-25	7080	7240	7060	7120	3409900
2001-07-26	7130	7140	6930	7070	3817000
2001-07-27	6370	6430	6080	6260	16181400
2001-07-30	6200	6230	5780	5830	10276000
2001-07-31	5960	6190	5940	6150	6913200
2001-08-01	6250	6310	6060	6200	5977300
2001-08-02	6310	6510	6200	6500	5388000
2001-08-03	6460	6560	6290	6360	3118200
2001-08-06	6280	6370	6250	6300	2514000
2001-08-07	6240	6430	6200	6410	2296200
2001-08-08	6400	6440	6340	6410	1380700
2001-08-09	6260	6280	6120	6130	2460000
2001-08-10	6120	6250	6100	6120	2507800
2001-08-13	6120	6150	5990	6000	3072600
2001-08-14	6050	6200	5990	6190	2734100
2001-08-15	6200	6340	6080	6320	2316100
2001-08-16	6020	6060	5950	6010	3458200
2001-08-17	5960	6000	5730	5740	5202100
2001-08-20	5640	5820	5620	5740	3883500
2001-08-21	5720	5740	5460	5580	7212400
2001-08-22	5620	5840	5590	5790	3620600
2001-08-23	5790	5800	5510	5550	4113300
2001-08-24	5700	5710	5500	5600	2482800
2001-08-27	5700	5830	5680	5690	2573800
2001-08-28	5790	5800	5650	5790	2105800
2001-08-29	5690	5780	5670	5690	1856000
2001-08-30	5690	5690	5500	5590	3136300
2001-08-31	5450	5450	5230	5290	5722600
2001-09-03	5190	5210	5030	5060	4216300
2001-09-04	5160	5290	5040	5280	5336100
2001-09-05	5180	5230	5100	5160	3835500
2001-09-06	5160	5310	5100	5230	2913100
2001-09-07	5030	5110	4960	5050	5178100
2001-09-10	4960	5040	4940	4950	4267500
2001-09-11	4950	5010	4890	4980	4831700
2001-09-12	4730	4730	4730	4730	533800
2001-09-13	4680	4770	4480	4480	8777400
2001-09-14	4430	4610	4410	4580	8296000
2001-09-17	4400	4410	4080	4210	6240700
2001-09-18	4310	4360	4260	4260	6613600
2001-09-19	4340	4540	4320	4480	4696400
2001-09-20	4350	4490	4300	4450	3847900
2001-09-21	4250	4300	4180	4220	5449000
2001-09-25	4470	4550	4300	4390	5906300
2001-09-26	4400	4420	4310	4350	3113900
2001-09-27	4300	4420	4290	4390	2820300
2001-09-28	4400	4450	4340	4390	4573900
2001-10-01	4040	4160	3970	4100	7589400
2001-10-02	4000	4080	4000	4050	6910700
2001-10-03	4100	4120	3960	3980	7500200
2001-10-04	4130	4250	4070	4250	5781300
2001-10-05	4300	4440	4230	4380	5434300
2001-10-09	4210	4270	4170	4210	4453400
2001-10-10	4240	4400	4190	4320	3800200
2001-10-11	4520	4820	4500	4820	9259400
2001-10-12	4970	5120	4940	5060	10634400
2001-10-15	4910	4940	4830	4850	4729100
2001-10-16	4800	4970	4750	4900	4426400
2001-10-17	5000	5100	4930	5050	5403800
2001-10-18	4910	5020	4910	4930	4084300
2001-10-19	4920	5090	4870	5040	4700900
2001-10-22	5020	5100	5000	5000	2183900
2001-10-23	5100	5150	5050	5150	3743000
2001-10-24	5080	5080	4940	4950	5768800
2001-10-25	4950	4950	4670	4780	6310900
2001-10-26	5030	5050	4920	4930	4916900
2001-10-29	4980	4990	4810	4880	2080500
2001-10-30	4780	4830	4690	4750	3323200
2001-10-31	4610	4720	4610	4630	2258400
2001-11-01	4680	4760	4620	4660	2611100
2001-11-02	4760	4810	4720	4780	3285400
2001-11-05	4830	4980	4830	4940	2971700
2001-11-06	5000	5020	4950	4980	3628000
2001-11-07	4980	4990	4710	4710	2873700
2001-11-08	4790	4850	4700	4820	2398500
2001-11-09	4870	4880	4750	4760	2713200
2001-11-12	4800	4870	4780	4810	2200300
2001-11-13	4780	4820	4760	4800	1978400
2001-11-14	4950	4970	4860	4920	2587500
2001-11-15	4980	5420	4980	5400	10210000
2001-11-16	5540	5740	5480	5710	9482500
2001-11-19	5790	5940	5750	5830	6195600
2001-11-20	5860	5870	5610	5650	3608700
2001-11-21	5530	5770	5510	5740	3274700
2001-11-22	5640	5690	5560	5690	2198900
2001-11-26	5840	5940	5770	5900	5448700
2001-11-27	5950	6140	5880	6010	10336600
2001-11-28	5910	5990	5830	5830	3991000
2001-11-29	5730	5790	5660	5750	3922200
2001-11-30	5830	5860	5760	5810	2416400
2001-12-03	5840	5840	5630	5710	3340400
2001-12-04	5680	5850	5640	5850	3938900
2001-12-05	5920	5990	5800	5960	3134900
2001-12-06	6180	6230	6080	6200	6213400
2001-12-07	6200	6260	6080	6140	3943600
2001-12-10	6090	6120	5970	6030	3704800
2001-12-11	5880	5900	5790	5840	3122200
2001-12-12	5900	6080	5870	6030	3231800
2001-12-13	5960	5990	5870	5880	2631300
2001-12-14	5800	5880	5720	5800	7590100
2001-12-17	5800	5850	5700	5730	2141500
2001-12-18	5900	5970	5860	5950	3194400
2001-12-19	5960	6020	5930	5960	3127000
2001-12-20	5970	5990	5880	5970	2941200
2001-12-21	5810	5920	5640	5690	3874500
2001-12-25	5700	5730	5500	5580	3355000
2001-12-26	5630	5640	5570	5600	1731500
2001-12-27	5700	5870	5660	5820	2582300
2001-12-28	5920	6000	5860	5990	2296200
2002-01-04	6290	6460	6280	6420	6214700
2002-01-07	6400	6510	6380	6470	3984200
2002-01-08	6370	6420	6310	6360	3732700
2002-01-09	6350	6450	6300	6390	3671300
2002-01-10	6440	6700	6420	6550	7831200
2002-01-11	6520	6550	6340	6400	3773600
2002-01-15	6030	6110	6030	6050	4279500
2002-01-16	6000	6000	5920	5930	3146900
2002-01-17	5930	5970	5830	5900	2541400
2002-01-18	5990	6040	5900	5990	3148000
2002-01-21	5890	5930	5840	5890	3067300
2002-01-22	5910	5960	5820	5820	2340400
2002-01-23	5850	6040	5830	5940	3601600
2002-01-24	6040	6150	5840	6080	4682600
2002-01-25	6200	6220	6110	6200	2927200
2002-01-28	6190	6250	5980	6040	5225200
2002-01-29	5940	6010	5900	5920	3202400
2002-01-30	5790	5820	5730	5790	2906900
2002-01-31	5830	5890	5760	5870	2491100
2002-02-01	5970	5980	5810	5810	3007100
2002-02-04	5780	5840	5770	5810	2062200
2002-02-05	5650	5750	5580	5600	4232600
2002-02-06	5540	5680	5530	5540	2850900
2002-02-07	5560	5780	5520	5720	2925000
2002-02-08	5670	5830	5640	5710	3461700
2002-02-12	5890	5900	5830	5900	2548200
2002-02-13	5860	5960	5830	5920	3441000
2002-02-14	5980	6130	5970	6050	4790400
2002-02-15	6040	6070	5950	6030	2456700
2002-02-18	5960	6090	5900	6040	1784800
2002-02-19	6290	6300	6150	6150	4491000
2002-02-20	6050	6100	6000	6000	2542800
2002-02-21	6080	6270	6070	6260	3701100
2002-02-22	6200	6300	6140	6270	3110900
2002-02-25	6300	6310	6200	6200	1887300
2002-02-26	6290	6300	6140	6200	2133200
2002-02-27	6240	6330	6210	6300	2969300
2002-02-28	6340	6370	6080	6080	3916700
2002-03-01	6210	6310	6180	6270	3194000
2002-03-04	6360	6530	6350	6530	5280600
2002-03-05	6690	6690	6560	6590	3951600
2002-03-06	6650	6890	6640	6880	5951300
2002-03-07	7000	7320	7000	7200	11113500
2002-03-08	7200	7240	7090	7160	7560400
2002-03-11	7250	7280	7120	7200	2943600
2002-03-12	7020	7100	6970	6970	3127600
2002-03-13	6910	7070	6830	6830	3272600
2002-03-14	6890	7090	6800	7090	4366200
2002-03-15	7180	7230	7080	7140	3029300
2002-03-18	7150	7170	6920	6920	2809500
2002-03-19	7000	7210	6990	7170	3535200
2002-03-20	7200	7230	6880	6890	4845100
2002-03-22	6910	7020	6880	6930	2561000
2002-03-25	6850	6880	6690	6770	2758600
2002-03-26	6710	6920	6660	6740	3091400
2002-03-27	6830	6870	6700	6770	2534500
2002-03-28	6860	6890	6750	6890	2124000
2002-03-29	6840	6910	6680	6700	2026000
2002-04-01	6750	6820	6700	6700	1517100
2002-04-02	6800	6950	6760	6930	2309900
2002-04-03	6830	7050	6800	7000	3028000
2002-04-04	7030	7050	6950	6980	2848900
2002-04-05	6860	6910	6760	6770	3196400
2002-04-08	6800	6960	6780	6910	1574400
2002-04-09	6830	6900	6760	6760	1953600
2002-04-10	6710	6930	6710	6800	2357900
2002-04-11	6860	6920	6820	6820	1629900
2002-04-12	6720	6800	6710	6710	3340600
2002-04-15	6750	6800	6720	6790	2294600
2002-04-16	6810	6890	6760	6890	2241300
2002-04-17	6970	7060	6950	7050	3906900
2002-04-18	7010	7120	6980	7100	5822700
2002-04-19	6920	6960	6820	6930	4145000
2002-04-22	6950	7150	6950	7150	3032400
2002-04-23	7050	7120	7010	7040	2541200
2002-04-24	7040	7080	6950	7020	2511900
2002-04-25	7090	7180	7060	7150	3406700
2002-04-26	7200	7300	7150	7200	7491300
2002-04-30	7100	7110	6860	6900	4854900
2002-05-01	6910	7000	6890	6910	3107100
2002-05-02	6940	6950	6850	6850	1954600
2002-05-07	6800	6820	6730	6820	3248700
2002-05-08	6840	6950	6840	6850	2537700
2002-05-09	7020	7060	6950	7000	3143100
2002-05-10	6980	7040	6940	7000	2022800
2002-05-13	6920	6930	6860	6870	1643200
2002-05-14	6970	7030	6940	6960	1926400
2002-05-15	7060	7150	7040	7150	2755000
2002-05-16	7160	7180	7070	7160	2243600
2002-05-17	7200	7300	7190	7260	3656600
2002-05-20	7310	7340	7230	7250	2247800
2002-05-21	7210	7230	7130	7190	1447800
2002-05-22	7250	7310	7120	7270	3422200
2002-05-23	7350	7390	7300	7390	3355600
2002-05-24	7430	7450	7380	7450	4189700
2002-05-27	7450	7460	7330	7330	1669100
2002-05-28	7320	7320	7210	7280	1865400
2002-05-29	7180	7270	7170	7210	1756800
2002-05-30	7140	7220	7090	7210	2169600
2002-05-31	7110	7200	7020	7200	2708700
2002-06-03	7170	7170	7080	7140	2577500
2002-06-04	7010	7040	6860	6880	3971600
2002-06-05	6950	7050	6930	6970	2397500
2002-06-06	7070	7090	6950	6970	2781900
2002-06-07	6820	6920	6810	6910	3138700
2002-06-10	6860	6930	6800	6800	1457700
2002-06-11	6780	6840	6730	6770	2419100
2002-06-12	6780	6950	6750	6950	2659300
2002-06-13	6870	6880	6710	6710	3614400
2002-06-14	6700	6700	6560	6560	5989100
2002-06-17	6460	6490	6360	6420	4446900
2002-06-18	6490	6600	6420	6480	4935000
2002-06-19	6410	6500	6230	6290	4223300
2002-06-20	6210	6280	6060	6280	5004000
2002-06-21	6080	6120	6000	6020	4446500
2002-06-24	5960	6180	5910	6150	4118200
2002-06-25	6100	6270	6080	6100	4044100
2002-06-26	5950	5980	5800	5810	5213200
2002-06-27	5960	6100	5930	6030	4686600
2002-06-28	6150	6330	6130	6330	3981700
2002-07-01	6230	6260	6150	6190	2468100
2002-07-02	6150	6190	5990	6190	4555000
2002-07-03	6020	6300	6020	6240	4572300
2002-07-04	6140	6190	6030	6050	4139900
2002-07-05	6100	6170	6090	6150	2380800
2002-07-08	6350	6360	6180	6180	3941300
2002-07-09	6220	6320	6160	6300	2898500
2002-07-10	6200	6230	6100	6100	3242500
2002-07-11	6000	6030	5960	5990	3580900
2002-07-12	6090	6110	6040	6040	3652600
2002-07-15	5970	5980	5880	5880	2857100
2002-07-16	5840	5910	5800	5800	4127900
2002-07-17	5750	5760	5470	5560	8632700
2002-07-18	5650	5800	5630	5800	5412200
2002-07-19	5700	5700	5510	5530	5655800
2002-07-22	5310	5410	5280	5390	6321500
2002-07-23	5250	5460	5210	5420	6676200
2002-07-24	5320	5360	5280	5280	4775400
2002-07-25	5470	5470	5270	5290	4540300
2002-07-26	5310	5390	5270	5280	8526500
2002-07-29	5370	5470	5310	5310	4596000
2002-07-30	5550	5600	5500	5570	4704200
2002-07-31	5620	5620	5410	5410	3506300
2002-08-01	5500	5500	5360	5400	3068100
2002-08-02	5310	5310	5170	5220	4889400
2002-08-05	5120	5160	5060	5110	4321600
2002-08-06	5010	5060	4950	4980	5673800
2002-08-07	5230	5310	5200	5280	4252500
2002-08-08	5280	5340	5230	5280	2534600
2002-08-09	5320	5380	5250	5380	4783900
2002-08-12	5240	5260	5130	5130	2687100
2002-08-13	5100	5190	5050	5070	3211600
2002-08-14	5010	5060	5010	5040	2919700
2002-08-15	5100	5200	5060	5070	4587300
2002-08-16	5170	5190	5090	5150	3195100
2002-08-19	5180	5190	5090	5120	3308600
2002-08-20	5250	5290	5190	5280	4612800
2002-08-21	5220	5390	5210	5360	4169300
2002-08-22	5390	5540	5330	5490	5320200
2002-08-23	5580	5600	5540	5550	3764300
2002-08-26	5480	5600	5470	5540	3504900
2002-08-27	5470	5510	5340	5340	3266200
2002-08-28	5430	5450	5290	5350	2834400
2002-08-29	5220	5250	5160	5180	3593100
2002-08-30	5200	5220	5160	5170	3607800
2002-09-02	5110	5140	5080	5100	2641800
2002-09-03	5060	5090	5000	5010	4467600
2002-09-04	4910	4910	4810	4850	5712600
2002-09-05	4920	5040	4900	4940	4815700
2002-09-06	4840	4940	4810	4910	4059400
2002-09-09	5000	5050	4970	4980	2345300
2002-09-10	5030	5190	5030	5100	5253300
2002-09-11	5200	5320	5160	5240	3565300
2002-09-12	5300	5330	5240	5310	3739100
2002-09-13	5200	5210	5080	5110	6150400
2002-09-17	5310	5450	5270	5440	4955200
2002-09-18	5240	5370	5230	5350	3344200
2002-09-19	5510	5570	5350	5350	3997500
2002-09-20	5210	5280	5200	5200	2507900
2002-09-24	5060	5100	5030	5060	3073700
2002-09-25	5030	5060	4980	4980	3193500
2002-09-26	5090	5210	5080	5170	3056400
2002-09-27	5290	5370	5270	5330	2520500
2002-09-30	5230	5260	5090	5110	2692000
2002-10-01	5100	5100	5050	5090	2944600
2002-10-02	5190	5210	5080	5080	2144800
2002-10-03	5100	5140	5030	5030	3472400
2002-10-04	5030	5180	5020	5170	2655500
2002-10-07	5050	5100	5040	5040	2738300
2002-10-08	5040	5150	5030	5100	4177000
2002-10-09	5030	5070	5000	5040	3992200
2002-10-10	4980	4990	4900	4960	3761200
2002-10-11	5040	5080	4990	5020	2385200
2002-10-15	5200	5210	5130	5210	3092300
2002-10-16	5300	5340	5240	5290	3850200
2002-10-17	5300	5390	5300	5370	2541300
2002-10-18	5470	5590	5460	5540	6204700
2002-10-21	5520	5540	5460	5490	2024100
2002-10-22	5460	5470	5300	5300	3140600
2002-10-23	5310	5380	5230	5370	2839400
2002-10-24	5380	5390	5260	5320	1708800
2002-10-25	5350	5450	5340	5390	2654000
2002-10-28	5380	5490	5350	5490	2659600
2002-10-29	5500	5530	5420	5420	3926700
2002-10-30	5320	5430	5300	5370	2453900
2002-10-31	5410	5420	5250	5270	2322400
2002-11-01	5300	5330	5260	5330	2371700
2002-11-05	5490	5530	5440	5500	3143400
2002-11-06	5500	5510	5410	5460	2577000
2002-11-07	5360	5410	5280	5320	3324900
2002-11-08	5220	5230	5150	5190	3319200
2002-11-11	5060	5080	4930	4930	5441900
2002-11-12	4900	4950	4850	4870	5547300
2002-11-13	4940	4980	4870	4870	3481200
2002-11-14	4920	4990	4900	4950	2512400
2002-11-15	5060	5150	5030	5150	4528200
2002-11-18	5100	5120	4950	5000	2633200
2002-11-19	5030	5080	5010	5070	2851300
2002-11-20	5120	5160	5110	5130	2108700
2002-11-21	5200	5210	5130	5200	3080100
2002-11-22	5300	5320	5240	5320	4132200
2002-11-25	5360	5410	5350	5390	3862500
2002-11-26	5380	5390	5300	5380	2649100
2002-11-27	5310	5360	5310	5340	1838100
2002-11-28	5410	5450	5390	5450	3889800
2002-11-29	5450	5490	5420	5420	2645100
2002-12-02	5440	5470	5390	5470	2051100
2002-12-03	5490	5520	5460	5500	3548800
2002-12-04	5400	5430	5310	5310	2770400
2002-12-05	5310	5420	5310	5350	2674900
2002-12-06	5370	5400	5340	5350	3121700
2002-12-09	5360	5400	5300	5300	2433300
2002-12-10	5220	5250	5200	5200	2507900
2002-12-11	5250	5300	5220	5230	1933600
2002-12-12	5210	5220	5160	5200	1937800
2002-12-13	5150	5170	5050	5080	5290500
2002-12-16	5030	5080	5020	5030	3183700
2002-12-17	5100	5110	5060	5070	2644400
2002-12-18	5060	5060	4990	5000	2864300
2002-12-19	4980	5030	4960	5020	3312100
2002-12-20	4990	5010	4980	4990	2916200
2002-12-24	5020	5080	4990	5060	4067600
2002-12-25	5040	5060	5020	5020	3143600
2002-12-26	5050	5120	5050	5100	1861400
2002-12-27	5090	5100	5040	5060	1583300
2002-12-30	4990	5010	4960	4960	1535300
2003-01-06	5110	5110	5010	5030	1974500
2003-01-07	5130	5130	5020	5030	2573000
2003-01-08	5040	5050	4960	4980	2319500
2003-01-09	4960	5050	4940	5050	2571800
2003-01-10	5080	5120	5060	5110	3714000
2003-01-14	5100	5110	5030	5060	2176500
2003-01-15	5050	5050	4970	5000	3507000
2003-01-16	4970	4990	4960	4990	2534800
2003-01-17	4970	5040	4960	5020	2862800
2003-01-20	5000	5030	4980	5010	3139800
2003-01-21	5000	5100	4970	5090	3716600
2003-01-22	5020	5050	4990	5000	3559000
2003-01-23	5020	5060	4980	5060	4032800
2003-01-24	5030	5040	4980	5000	3662300
2003-01-27	4920	4940	4900	4910	3361700
2003-01-28	4880	4890	4820	4850	5025600
2003-01-29	4840	4850	4750	4760	4907900
2003-01-30	4770	4850	4750	4770	4719100
2003-01-31	4770	4770	4620	4710	5467400
2003-02-03	4720	4810	4660	4800	3467800
2003-02-04	4820	4840	4730	4740	3041300
2003-02-05	4670	4720	4660	4690	4207400
2003-02-06	4700	4740	4650	4660	2643700
2003-02-07	4650	4670	4620	4650	2602500
2003-02-10	4600	4670	4600	4650	1918300
2003-02-12	4670	4720	4660	4700	2899700
2003-02-13	4650	4690	4600	4620	3179100
2003-02-14	4630	4690	4620	4650	3714100
2003-02-17	4700	4760	4690	4710	3379000
2003-02-18	4710	4730	4640	4660	2424100
2003-02-19	4710	4750	4700	4720	3237300
2003-02-20	4690	4720	4640	4690	2269200
2003-02-21	4650	4670	4570	4590	2768600
2003-02-24	4600	4600	4570	4580	1519100
2003-02-25	4520	4550	4450	4460	3929800
2003-02-26	4430	4550	4430	4500	4319600
2003-02-27	4470	4520	4450	4470	3413500
2003-02-28	4500	4510	4450	4490	2460300
2003-03-03	4500	4520	4470	4510	2057700
2003-03-04	4480	4490	4450	4480	1508500
2003-03-05	4430	4460	4420	4430	1696200
2003-03-06	4400	4410	4320	4330	4025400
2003-03-07	4260	4290	4220	4250	5035600
2003-03-10	4270	4290	4180	4200	5369500
2003-03-11	4100	4160	4070	4080	4891100
2003-03-12	4120	4180	4110	4160	4117100
2003-03-13	4150	4170	4110	4110	3329800
2003-03-14	4280	4320	4250	4290	7405700
2003-03-17	4310	4320	4230	4240	2393100
2003-03-18	4410	4430	4340	4340	4277200
2003-03-19	4360	4360	4270	4350	2535200
2003-03-20	4450	4490	4420	4480	3460600
2003-03-24	4580	4600	4530	4560	3378900
2003-03-25	4510	4510	4440	4450	2360700
2003-03-26	4460	4500	4450	4460	2368100
2003-03-27	4460	4510	4450	4490	1772300
2003-03-28	4500	4500	4360	4400	2650900
2003-03-31	4300	4310	4190	4200	3132200
2003-04-01	4100	4160	4100	4110	4516700
2003-04-02	4150	4170	4080	4150	3529700
2003-04-03	4240	4240	4140	4160	3132400
2003-04-04	4170	4170	4040	4140	4614600
2003-04-07	4180	4210	4100	4190	4831000
2003-04-08	4140	4150	4090	4120	4321900
2003-04-09	4020	4080	4000	4020	6672900
2003-04-10	4000	4000	3870	3910	7103300
2003-04-11	3860	3890	3750	3770	8369900
2003-04-14	3820	3850	3780	3810	4690400
2003-04-15	3880	3940	3870	3910	4849900
2003-04-16	3960	3990	3930	3950	3470400
2003-04-17	3910	3940	3870	3890	2776900
2003-04-18	3920	3940	3860	3880	2995900
2003-04-21	3850	3880	3800	3870	3555400
2003-04-22	3860	3870	3750	3790	4049700
2003-04-23	3800	3800	3640	3700	7805400
2003-04-24	3750	3780	3640	3720	7982700
2003-04-25	3220	3220	3220	3220	1986500
2003-04-28	2720	2770	2720	2720	34982300
2003-04-30	2845	2915	2835	2900	23292200
2003-05-01	2940	2940	2855	2865	8324800
2003-05-02	2870	2875	2800	2860	8998400
2003-05-06	2940	3020	2935	2985	11663500
2003-05-07	3030	3040	2935	2965	5695200
2003-05-08	2940	2945	2865	2890	7032800
2003-05-09	2850	2860	2775	2815	9417900
2003-05-12	2880	2880	2815	2850	5355600
2003-05-13	2915	2970	2905	2920	7905900
2003-05-14	3030	3040	2990	3040	9874200
2003-05-15	3000	3010	2925	2955	6328700
2003-05-16	2960	2965	2870	2920	6938500
2003-05-19	2870	2935	2870	2930	3571700
2003-05-20	2915	2915	2860	2890	5150600
2003-05-21	2905	2920	2865	2900	3488800
2003-05-22	2890	2925	2880	2915	3517300
2003-05-23	2990	3050	2970	3040	7608000
2003-05-26	3020	3080	3010	3060	3207500
2003-05-27	3020	3020	2990	3000	2861600
2003-05-28	3030	3050	2995	3000	4851700
2003-05-29	3120	3130	3070	3100	7028200
2003-05-30	3150	3190	3140	3180	7238300
2003-06-02	3250	3300	3240	3300	6153200
2003-06-03	3310	3370	3280	3330	6707000
2003-06-04	3380	3430	3340	3390	5453100
2003-06-05	3440	3450	3400	3420	3910200
2003-06-06	3420	3490	3380	3470	4904800
2003-06-09	3490	3590	3470	3550	5448200
2003-06-10	3480	3480	3400	3420	5712400
2003-06-11	3440	3500	3440	3450	8062500
2003-06-12	3540	3540	3450	3470	4326300
2003-06-13	3460	3490	3460	3480	5558600
2003-06-16	3420	3430	3370	3370	4338300
2003-06-17	3460	3480	3430	3470	4212800
2003-06-18	3510	3540	3480	3480	3909100
2003-06-19	3530	3540	3500	3540	3828300
2003-06-20	3490	3520	3460	3520	2837300
2003-06-23	3470	3480	3420	3450	3341100
2003-06-24	3370	3390	3320	3330	4184100
2003-06-25	3300	3300	3250	3270	4860500
2003-06-26	3260	3300	3220	3270	5204000
2003-06-27	3360	3370	3320	3340	4238900
2003-06-30	3360	3400	3340	3380	3495500
2003-07-01	3350	3440	3350	3430	3161200
2003-07-02	3470	3680	3470	3640	10907000
2003-07-03	3840	3880	3700	3720	12179900
2003-07-04	3680	3730	3660	3680	4732600
2003-07-07	3690	3840	3680	3830	5300200
2003-07-08	3950	3970	3890	3910	9249100
2003-07-09	3920	3940	3880	3890	6844100
2003-07-10	3860	3870	3780	3810	6360300
2003-07-11	3730	3760	3650	3670	7038400
2003-07-14	3770	3890	3750	3890	7520500
2003-07-15	3970	4050	3960	3990	13971000
2003-07-16	4010	4020	3910	3990	7087600
2003-07-17	3890	3910	3810	3820	4535900
2003-07-18	3800	3810	3750	3780	4166400
2003-07-22	3750	3760	3680	3750	4042200
2003-07-23	3810	3820	3760	3790	4861500
2003-07-24	3740	3800	3680	3760	5245400
2003-07-25	3710	3750	3650	3710	10478000
2003-07-28	3790	3820	3760	3820	4402400
2003-07-29	3850	3870	3830	3840	3825000
2003-07-30	3800	3810	3720	3730	4110900
2003-07-31	3760	3760	3680	3730	3221300
2003-08-01	3820	3820	3720	3750	3694900
2003-08-04	3700	3700	3590	3600	4740800
2003-08-05	3620	3680	3620	3630	4100100
2003-08-06	3590	3600	3540	3560	3610700
2003-08-07	3570	3590	3530	3590	2985300
2003-08-08	3530	3570	3510	3530	3670700
2003-08-11	3540	3570	3500	3570	1843900
2003-08-12	3590	3630	3560	3600	1871600
2003-08-13	3620	3650	3590	3630	2570100
2003-08-14	3650	3720	3640	3720	2447400';

is( $quotes, $expected,
	'fetch() and extract() quotes (without adjustment for the splits)' );

my $obj2 = Finance::YahooJPN::QuoteHist->new('6758.t');
$obj2->fetch('start' => '1991-09-20');
$obj2->extract();
my @quotes2 = $obj2->output();
my $quotes2 = join "\n", @quotes2[0..2932];

$expected = '1991-09-20	2605	2623	2591	2600	1502600
1991-09-24	2605	2650	2600	2650	1721940
1991-09-25	2740	2750	2650	2670	1829600
1991-09-26	2685	2725	2665	2720	1520200
1991-09-27	2720	2765	2720	2730	1522600
1991-09-30	2700	2715	2690	2710	771200
1991-10-01	2690	2720	2690	2700	1339600
1991-10-02	2720	2735	2695	2720	1489600
1991-10-03	2725	2725	2660	2690	1564200
1991-10-04	2660	2665	2595	2600	1902400
1991-10-07	2580	2620	2575	2575	1169000
1991-10-08	2565	2590	2550	2580	907600
1991-10-09	2595	2660	2595	2660	996000
1991-10-11	2610	2630	2575	2590	802400
1991-10-14	2595	2600	2550	2550	709200
1991-10-15	2580	2585	2550	2575	698800
1991-10-16	2575	2595	2555	2595	675600
1991-10-17	2585	2600	2575	2575	778400
1991-10-18	2570	2600	2560	2600	1099000
1991-10-21	2600	2600	2515	2525	1248000
1991-10-22	2520	2560	2515	2540	998400
1991-10-23	2530	2560	2525	2560	651600
1991-10-24	2565	2620	2565	2595	1236800
1991-10-25	2595	2600	2575	2580	1142600
1991-10-28	2600	2615	2580	2580	415600
1991-10-29	2600	2650	2595	2650	914400
1991-10-30	2635	2640	2600	2625	653400
1991-10-31	2600	2620	2585	2620	971800
1991-11-01	2615	2615	2575	2580	1027400
1991-11-05	2575	2580	2570	2575	517600
1991-11-06	2565	2570	2550	2560	398000
1991-11-07	2525	2550	2515	2515	1227200
1991-11-08	2560	2560	2500	2500	1092200
1991-11-11	2505	2520	2480	2480	739800
1991-11-12	2500	2530	2490	2505	766200
1991-11-13	2520	2535	2495	2500	1004400
1991-11-14	2500	2505	2450	2450	1063000
1991-11-15	2450	2460	2390	2395	1659800
1991-11-18	2345	2375	2345	2375	1259800
1991-11-19	2425	2450	2395	2400	1350800
1991-11-20	2375	2395	2350	2355	1223600
1991-11-21	2330	2340	2260	2290	2027000
1991-11-22	2270	2285	2250	2250	1861800
1991-11-25	2225	2245	2205	2215	840200
1991-11-26	2190	2215	2170	2200	1485400
1991-11-27	2210	2220	2175	2175	1159600
1991-11-28	2170	2210	2155	2185	1521200
1991-11-29	2185	2225	2175	2175	1375800
1991-12-02	2175	2180	2110	2110	1031000
1991-12-03	2135	2180	2120	2165	1737600
1991-12-04	2165	2215	2165	2180	1664400
1991-12-05	2155	2165	2130	2130	1238200
1991-12-06	2140	2150	2110	2125	1151000
1991-12-09	2105	2115	2100	2110	847600
1991-12-10	2100	2100	2040	2050	920000
1991-12-11	2025	2065	2010	2065	1937000
1991-12-12	2085	2115	2070	2070	1294800
1991-12-13	2145	2145	2075	2090	4668000
1991-12-16	2115	2210	2100	2150	626800
1991-12-17	2170	2200	2160	2180	843400
1991-12-18	2120	2130	2065	2095	1519400
1991-12-19	2050	2070	2025	2025	1235200
1991-12-20	2050	2065	2015	2015	1699200
1991-12-24	2050	2060	1990	1995	1135400
1991-12-25	2005	2075	2000	2070	1028600
1991-12-26	2060	2070	2020	2035	793200
1991-12-27	2065	2065	2005	2015	617200
1991-12-30	2050	2075	2040	2050	696400
1992-01-06	2200	2210	2175	2200	962400
1992-01-07	2175	2195	2150	2150	632400
1992-01-08	2085	2085	2040	2040	623200
1992-01-09	2065	2065	2025	2030	937200
1992-01-10	2030	2035	2005	2010	1289000
1992-01-13	2010	2015	1990	2000	793200
1992-01-14	2000	2015	1990	2000	916200
1992-01-16	2075	2090	2030	2040	1179400
1992-01-17	2040	2080	2005	2050	945400
1992-01-20	2035	2050	2010	2050	882000
1992-01-21	2065	2100	2030	2050	1141800
1992-01-22	2075	2145	2055	2135	2127600
1992-01-23	2145	2175	2125	2130	1857800
1992-01-24	2105	2115	2080	2100	713800
1992-01-27	2085	2120	2065	2120	611400
1992-01-28	2105	2150	2105	2125	394600
1992-01-29	2150	2170	2130	2140	928400
1992-01-30	2120	2150	2110	2110	1032200
1992-01-31	2135	2165	2120	2120	1613000
1992-02-03	2145	2170	2135	2170	861400
1992-02-04	2155	2210	2150	2180	2075600
1992-02-05	2185	2215	2175	2180	1513400
1992-02-06	2175	2190	2145	2155	1274000
1992-02-07	2180	2190	2140	2140	900400
1992-02-10	2140	2150	2120	2125	537400
1992-02-12	2130	2130	2105	2105	580200
1992-02-13	2105	2125	2090	2105	1244200
1992-02-14	2105	2115	2050	2090	1073200
1992-02-17	2055	2125	2050	2125	887400
1992-02-18	2065	2110	2060	2080	769200
1992-02-19	1980	2010	1975	2000	2442000
1992-02-20	1980	2015	1975	2005	1439000
1992-02-21	2015	2035	2000	2010	1412600
1992-02-24	2025	2030	2015	2025	853800
1992-02-25	2015	2025	2010	2010	716800
1992-02-26	2015	2030	2010	2010	1015000
1992-02-27	2045	2050	2020	2025	648400
1992-02-28	2030	2045	2025	2040	636200
1992-03-02	2040	2055	2030	2035	733400
1992-03-03	2040	2050	2030	2030	736000
1992-03-04	2025	2035	2015	2035	424000
1992-03-05	2030	2035	2005	2005	901400
1992-03-06	2005	2010	1995	2000	835600
1992-03-09	1990	2000	1975	1975	713800
1992-03-10	1975	1975	1950	1950	1032000
1992-03-11	1950	1955	1930	1930	1036600
1992-03-12	1915	1975	1900	1970	1220200
1992-03-13	1945	2000	1945	1980	4206400
1992-03-16	1975	1975	1950	1960	672400
1992-03-17	1950	1975	1945	1965	1542600
1992-03-18	1965	1980	1955	1975	1700400
1992-03-19	1950	2050	1950	1965	4129000
1992-03-23	2015	2055	2010	2050	2189800
1992-03-24	2050	2055	2025	2040	1465600
1992-03-25	2030	2075	2020	2075	1749000
1992-03-26	2075	2075	2020	2020	1089800
1992-03-27	2045	2045	2000	2000	796800
1992-03-30	2010	2050	2000	2025	793200
1992-03-31	2055	2060	2020	2025	840600
1992-04-01	2035	2035	1995	2000	1414000
1992-04-02	2025	2030	1975	2025	1815200
1992-04-03	2035	2065	1990	2055	2312400
1992-04-06	2055	2055	2025	2030	1450600
1992-04-07	2040	2045	2005	2010	1126200
1992-04-08	2000	2025	1975	2005	1503600
1992-04-09	2010	2040	1990	1995	1752800
1992-04-10	2060	2115	2045	2115	2680200
1992-04-13	2125	2125	2020	2040	2247000
1992-04-14	2050	2085	2020	2055	2038000
1992-04-15	2090	2160	2075	2150	3542000
1992-04-16	2150	2165	2125	2135	2408800
1992-04-17	2125	2140	2080	2095	1392800
1992-04-20	2070	2095	2055	2060	1003400
1992-04-21	2050	2100	2045	2075	1513000
1992-04-22	2095	2115	2065	2115	1394200
1992-04-23	2100	2170	2080	2150	2357800
1992-04-24	2150	2200	2125	2190	2256600
1992-04-27	2170	2205	2150	2155	1733400
1992-04-28	2165	2180	2140	2165	962200
1992-04-30	2180	2195	2160	2165	897800
1992-05-01	2155	2180	2135	2150	984000
1992-05-06	2140	2190	2140	2165	883400
1992-05-07	2175	2200	2160	2200	1136000
1992-05-08	2195	2265	2180	2240	2948600
1992-05-11	2240	2250	2220	2225	1233000
1992-05-12	2240	2245	2205	2220	1193200
1992-05-13	2200	2220	2170	2215	1145400
1992-05-14	2205	2210	2180	2185	1245800
1992-05-15	2185	2195	2125	2145	1265000
1992-05-18	2170	2190	2150	2170	844200
1992-05-19	2175	2210	2165	2200	1084000
1992-05-20	2175	2210	2175	2180	587200
1992-05-21	2160	2185	2155	2155	532200
1992-05-22	2155	2160	2125	2130	1186000
1992-05-25	2120	2175	2120	2150	796600
1992-05-26	2135	2150	2105	2105	568000
1992-05-27	2095	2100	2025	2040	2224800
1992-05-28	2070	2145	2070	2145	2478000
1992-05-29	2145	2165	2140	2160	1067400
1992-06-01	2155	2160	2140	2140	537600
1992-06-02	2145	2160	2140	2145	807800
1992-06-03	2155	2210	2155	2195	1955000
1992-06-04	2200	2210	2175	2195	1563400
1992-06-05	2180	2185	2160	2160	633200
1992-06-08	2175	2175	2125	2155	1034600
1992-06-09	2130	2160	2130	2150	288600
1992-06-10	2130	2155	2120	2140	671000
1992-06-11	2145	2165	2140	2145	469800
1992-06-12	2120	2135	2050	2055	5546200
1992-06-15	2055	2060	2025	2025	1130400
1992-06-16	2040	2070	2025	2035	889600
1992-06-17	2035	2045	2010	2010	979000
1992-06-18	2000	2050	1990	2005	1601200
1992-06-19	2020	2080	2015	2080	841800
1992-06-22	2100	2100	2005	2005	1037000
1992-06-23	2005	2035	2000	2025	875000
1992-06-24	2045	2060	2010	2015	1051800
1992-06-25	2025	2125	2015	2125	1746800
1992-06-26	2100	2110	2030	2055	1514400
1992-06-29	2060	2065	2030	2055	1067800
1992-06-30	2080	2085	2050	2060	1014800
1992-07-01	2060	2095	2025	2095	1034000
1992-07-02	2090	2115	2075	2115	1218600
1992-07-03	2100	2125	2070	2090	856000
1992-07-06	2090	2115	2085	2090	269800
1992-07-07	2090	2100	2060	2070	343000
1992-07-08	2070	2080	2055	2080	377800
1992-07-09	2090	2110	2075	2100	708600
1992-07-10	2125	2125	2075	2090	1622200
1992-07-13	2110	2140	2095	2130	992400
1992-07-14	2125	2140	2090	2105	816400
1992-07-15	2110	2130	2100	2105	554400
1992-07-16	2085	2100	2075	2075	542400
1992-07-17	2085	2085	2050	2050	1021000
1992-07-20	2040	2040	1980	1980	1364200
1992-07-21	1985	2015	1980	2015	1312000
1992-07-22	2005	2015	1940	1970	2547400
1992-07-23	1950	2025	1945	1995	1226400
1992-07-24	1985	1985	1925	1925	1632800
1992-07-27	1995	1995	1905	1920	1594400
1992-07-28	1905	1935	1895	1915	1527000
1992-07-29	1955	1955	1885	1900	1490400
1992-07-30	1925	1940	1900	1905	1356200
1992-07-31	1925	1990	1920	1990	1010200
1992-08-03	1985	2015	1975	1985	538200
1992-08-04	1985	2035	1985	2020	1321600
1992-08-05	2020	2040	2000	2035	968800
1992-08-06	2020	2045	1985	2010	555800
1992-08-07	1990	2005	1955	1955	345400
1992-08-10	1935	1935	1905	1930	630000
1992-08-11	1935	1935	1875	1880	994200
1992-08-12	1870	1895	1865	1890	1449800
1992-08-13	1895	1925	1875	1905	1187200
1992-08-14	1885	1935	1885	1900	2083400
1992-08-17	1910	1925	1890	1895	1068600
1992-08-18	1890	1890	1780	1780	1858600
1992-08-19	1800	1805	1675	1770	3246000
1992-08-20	1835	1990	1800	1940	2603000
1992-08-21	1940	2035	1925	2035	2664000
1992-08-24	2030	2095	1975	2020	2226600
1992-08-25	1970	2010	1955	1985	1163600
1992-08-26	1965	2005	1965	2005	927800
1992-08-27	2075	2145	2060	2145	3879600
1992-08-28	2095	2145	2090	2100	2564400
1992-08-31	2060	2120	2060	2100	1543200
1992-09-01	2065	2080	2050	2050	814200
1992-09-02	2005	2020	1990	1995	793600
1992-09-03	2000	2075	2000	2070	1642200
1992-09-04	2095	2130	2085	2110	2704200
1992-09-07	2105	2160	2105	2135	1587200
1992-09-08	2125	2150	2100	2105	1454000
1992-09-09	2080	2160	2070	2160	1493200
1992-09-10	2135	2175	2130	2155	1966200
1992-09-11	2160	2160	2055	2055	3761600
1992-09-14	2100	2125	2070	2105	847800
1992-09-16	2105	2130	2070	2120	1072000
1992-09-17	2105	2160	2105	2140	1773000
1992-09-18	2115	2145	2095	2140	1058400
1992-09-21	2135	2160	2100	2100	949800
1992-09-22	2100	2145	2090	2125	1316800
1992-09-24	2120	2120	2065	2065	1341800
1992-09-25	2075	2090	2055	2075	1053800
1992-09-28	2095	2115	2060	2075	849400
1992-09-29	2065	2085	2025	2070	827800
1992-09-30	2055	2055	1995	1995	1300800
1992-10-01	2005	2025	1960	1985	1348200
1992-10-02	2000	2010	1985	1985	865200
1992-10-05	1950	1975	1945	1965	758400
1992-10-06	1945	1975	1935	1965	1441200
1992-10-07	1960	1985	1945	1945	583600
1992-10-08	1945	1975	1945	1965	574200
1992-10-09	1940	1980	1940	1975	3510600
1992-10-12	1975	2020	1965	2015	944000
1992-10-13	2015	2030	2000	2020	565800
1992-10-14	2045	2055	2035	2035	851000
1992-10-15	2045	2065	2035	2065	900600
1992-10-16	2065	2070	2015	2030	1205400
1992-10-19	2030	2050	1980	1990	893000
1992-10-20	2015	2040	1990	2030	1053400
1992-10-21	2025	2065	2010	2060	880000
1992-10-22	2055	2070	2045	2060	977400
1992-10-23	2050	2055	2025	2040	656200
1992-10-26	2030	2045	2015	2015	420200
1992-10-27	2010	2040	2010	2030	361000
1992-10-28	2050	2055	2010	2015	568400
1992-10-29	2000	2015	1990	1995	494400
1992-10-30	1995	2015	1980	2015	811800
1992-11-02	1990	2020	1980	2020	417400
1992-11-04	2000	2015	1985	2015	714000
1992-11-05	1990	2000	1960	1975	745600
1992-11-06	1965	1970	1950	1960	596200
1992-11-09	1925	1935	1910	1910	773200
1992-11-10	1915	1940	1910	1925	846800
1992-11-11	1930	1935	1910	1910	542400
1992-11-12	1910	1945	1885	1905	1018600
1992-11-13	1890	1935	1885	1910	1815800
1992-11-16	1890	1900	1870	1875	521400
1992-11-17	1865	1925	1845	1910	1075000
1992-11-18	1920	2025	1910	1980	1510000
1992-11-19	2020	2020	1905	1915	1785600
1992-11-20	1890	1985	1885	1920	1379200
1992-11-24	1930	1945	1905	1905	925800
1992-11-25	1905	1930	1900	1925	1243400
1992-11-26	1945	2020	1945	2000	1173000
1992-11-27	2000	2025	1995	2000	1341200
1992-11-30	2020	2045	2005	2045	1145800
1992-12-01	2050	2075	2035	2050	1188600
1992-12-02	2060	2095	2055	2075	2117200
1992-12-03	2070	2075	2035	2050	917600
1992-12-04	2030	2045	2020	2025	535400
1992-12-07	2025	2040	2005	2040	571000
1992-12-08	2040	2085	2030	2070	1389000
1992-12-09	2070	2080	2055	2070	940800
1992-12-10	2070	2085	2060	2060	904600
1992-12-11	2060	2070	2040	2055	2744400
1992-12-14	2055	2065	2045	2060	472000
1992-12-15	2035	2070	2030	2055	456000
1992-12-16	2055	2070	2050	2065	914200
1992-12-17	2065	2095	2055	2080	1530600
1992-12-18	2090	2110	2090	2100	2012000
1992-12-21	2110	2125	2095	2125	1301400
1992-12-22	2125	2145	2115	2145	1490600
1992-12-24	2150	2155	2140	2150	1630200
1992-12-25	2135	2155	2135	2155	1746400
1992-12-28	2150	2150	2095	2115	671600
1992-12-29	2100	2130	2100	2130	634800
1992-12-30	2130	2145	2110	2130	758000
1993-01-04	2130	2140	2120	2125	485400
1993-01-05	2125	2135	2105	2120	963800
1993-01-06	2110	2125	2100	2125	812000
1993-01-07	2125	2135	2110	2110	943800
1993-01-08	2095	2115	2090	2090	1619200
1993-01-11	2095	2095	2065	2080	578600
1993-01-12	2065	2080	2040	2055	761800
1993-01-13	2055	2055	2030	2030	560400
1993-01-14	2035	2040	2025	2030	463200
1993-01-18	2045	2065	2040	2065	734000
1993-01-19	2080	2105	2075	2105	709000
1993-01-20	2120	2120	2090	2100	753400
1993-01-21	2100	2105	2090	2105	811800
1993-01-22	2105	2105	2055	2055	769200
1993-01-25	2070	2075	2030	2045	1081800
1993-01-26	2045	2065	2030	2050	571800
1993-01-27	2045	2060	2035	2035	893800
1993-01-28	2035	2060	2015	2060	1167400
1993-01-29	2050	2060	2040	2050	702600
1993-02-01	2050	2060	2035	2050	470200
1993-02-02	2060	2075	2055	2075	717800
1993-02-03	2070	2070	2050	2070	995800
1993-02-04	2070	2075	2055	2070	983000
1993-02-05	2070	2100	2070	2090	1124600
1993-02-08	2090	2090	2065	2065	478000
1993-02-09	2075	2085	2055	2070	807800
1993-02-10	2055	2055	2035	2040	713200
1993-02-12	2040	2040	2030	2030	1413600
1993-02-15	2045	2070	2040	2055	1059800
1993-02-16	2060	2075	2050	2075	980800
1993-02-17	2030	2060	2030	2060	672600
1993-02-18	2055	2060	2035	2050	1258800
1993-02-19	2040	2040	1995	2000	1654800
1993-02-22	1980	1985	1950	1950	1101400
1993-02-23	1925	1960	1925	1955	1539200
1993-02-24	1940	1955	1925	1940	601600
1993-02-25	1950	1965	1945	1960	1090200
1993-02-26	1975	2000	1970	1990	1278800
1993-03-01	2000	2000	1980	1995	507200
1993-03-02	1995	2000	1985	1985	755000
1993-03-03	1995	2000	1950	1955	828800
1993-03-04	1940	1965	1935	1965	1237800
1993-03-05	1955	1975	1945	1960	1044000
1993-03-08	1975	2070	1975	2000	2219200
1993-03-09	2025	2075	2025	2050	2420200
1993-03-10	2045	2065	2035	2065	1557400
1993-03-11	2070	2090	2065	2080	1580800
1993-03-12	2055	2075	2035	2055	3172800
1993-03-15	2030	2050	2025	2030	885600
1993-03-16	2030	2035	2015	2035	983400
1993-03-17	2030	2035	2015	2035	578000
1993-03-18	2040	2085	2040	2065	1151600
1993-03-19	2040	2060	2005	2005	1153600
1993-03-22	2050	2055	2025	2055	923600
1993-03-23	2050	2085	2035	2075	1343400
1993-03-24	2055	2085	2050	2050	1300600
1993-03-25	2060	2085	2045	2050	1011400
1993-03-26	2075	2145	2070	2115	2811400
1993-03-29	2145	2245	2140	2235	2922600
1993-03-30	2240	2310	2235	2295	3833000
1993-03-31	2290	2300	2190	2215	2230000
1993-04-01	2190	2210	2135	2200	1462000
1993-04-02	2200	2240	2150	2160	2507200
1993-04-05	2210	2275	2170	2245	2508600
1993-04-06	2245	2270	2225	2265	1827200
1993-04-07	2300	2515	2280	2475	7451000
1993-04-08	2460	2515	2415	2500	5324800
1993-04-09	2490	2520	2385	2420	5202400
1993-04-12	2425	2430	2360	2400	1420000
1993-04-13	2380	2520	2380	2500	2646400
1993-04-14	2540	2550	2465	2490	3994000
1993-04-15	2495	2500	2435	2480	1497000
1993-04-16	2475	2475	2415	2430	1108000
1993-04-19	2380	2400	2335	2385	1595600
1993-04-20	2360	2410	2300	2325	1730000
1993-04-21	2340	2370	2320	2325	1763200
1993-04-22	2360	2420	2320	2345	2378000
1993-04-23	2330	2370	2325	2350	1391800
1993-04-26	2370	2395	2340	2365	1482000
1993-04-27	2375	2470	2375	2450	2273200
1993-04-28	2500	2525	2470	2495	5189000
1993-04-30	2505	2520	2480	2500	2360600
1993-05-06	2510	2510	2440	2455	2165200
1993-05-07	2455	2460	2415	2445	1372000
1993-05-10	2420	2445	2400	2425	1277000
1993-05-11	2475	2480	2450	2465	1202800
1993-05-12	2450	2455	2375	2390	2194800
1993-05-13	2400	2440	2390	2390	2049000
1993-05-14	2395	2420	2375	2375	2077600
1993-05-17	2375	2390	2360	2360	717000
1993-05-18	2350	2355	2325	2325	1233200
1993-05-19	2305	2355	2300	2355	1023600
1993-05-20	2350	2350	2300	2340	986200
1993-05-21	2330	2380	2330	2365	1199800
1993-05-24	2380	2390	2335	2335	754400
1993-05-25	2325	2345	2325	2325	1100600
1993-05-26	2310	2320	2300	2315	1228000
1993-05-27	2305	2330	2275	2285	1259200
1993-05-28	2285	2305	2275	2275	1273000
1993-05-31	2255	2270	2245	2245	935000
1993-06-01	2245	2285	2245	2265	842600
1993-06-02	2280	2340	2265	2310	950000
1993-06-03	2340	2400	2335	2365	1372600
1993-06-04	2365	2385	2330	2345	1419600
1993-06-07	2325	2360	2310	2320	605800
1993-06-08	2320	2330	2275	2290	1063000
1993-06-10	2285	2290	2250	2280	1438000
1993-06-11	2305	2305	2250	2255	3555200
1993-06-14	2250	2255	2200	2200	1507000
1993-06-15	2175	2190	2130	2145	1520800
1993-06-16	2160	2180	2145	2160	1619800
1993-06-17	2160	2190	2125	2155	2132800
1993-06-18	2165	2195	2155	2180	1733400
1993-06-21	2195	2225	2185	2205	1804600
1993-06-22	2205	2230	2190	2215	1307400
1993-06-23	2205	2215	2165	2175	1079000
1993-06-24	2160	2185	2160	2165	613600
1993-06-25	2180	2185	2135	2150	1061400
1993-06-28	2135	2170	2135	2150	499800
1993-06-29	2150	2175	2135	2135	665600
1993-06-30	2135	2150	2120	2145	1531000
1993-07-01	2145	2170	2145	2165	1024400
1993-07-02	2185	2185	2130	2140	1163400
1993-07-05	2150	2160	2135	2140	428800
1993-07-06	2140	2185	2140	2175	752000
1993-07-07	2175	2180	2150	2150	818000
1993-07-08	2150	2150	2125	2125	961000
1993-07-09	2140	2180	2140	2175	1885400
1993-07-12	2200	2215	2185	2215	1010400
1993-07-13	2215	2290	2205	2270	1983800
1993-07-14	2265	2285	2250	2285	1192800
1993-07-15	2280	2305	2265	2285	1923800
1993-07-16	2275	2345	2270	2335	2477200
1993-07-19	2330	2345	2285	2325	1721800
1993-07-20	2310	2320	2295	2305	812600
1993-07-21	2260	2290	2260	2265	942400
1993-07-22	2265	2310	2265	2290	944200
1993-07-23	2255	2270	2235	2235	839000
1993-07-26	2245	2245	2215	2215	486800
1993-07-27	2225	2225	2195	2205	589600
1993-07-28	2225	2230	2185	2190	571200
1993-07-29	2195	2300	2190	2295	1523600
1993-07-30	2270	2300	2235	2250	1042800
1993-08-02	2225	2230	2190	2205	700000
1993-08-03	2210	2275	2200	2205	813000
1993-08-04	2195	2260	2195	2230	1169600
1993-08-05	2235	2250	2225	2225	609200
1993-08-06	2205	2215	2190	2210	966000
1993-08-09	2210	2250	2210	2245	1301600
1993-08-10	2250	2260	2230	2245	1219800
1993-08-11	2240	2245	2205	2215	973600
1993-08-12	2225	2225	2185	2185	1381800
1993-08-13	2185	2190	2160	2190	1477200
1993-08-16	2150	2185	2150	2185	604800
1993-08-17	2200	2225	2165	2175	630600
1993-08-18	2175	2195	2170	2170	818800
1993-08-19	2190	2200	2155	2175	850400
1993-08-20	2215	2230	2195	2230	1475000
1993-08-23	2245	2245	2220	2240	502400
1993-08-24	2225	2250	2220	2230	670400
1993-08-25	2235	2240	2215	2230	702400
1993-08-26	2235	2235	2215	2230	446600
1993-08-27	2230	2260	2225	2240	1112400
1993-08-30	2250	2260	2245	2255	610200
1993-08-31	2260	2295	2255	2285	896000
1993-09-01	2270	2325	2270	2315	1569800
1993-09-02	2305	2340	2300	2310	1810600
1993-09-03	2310	2360	2310	2335	2339400
1993-09-06	2350	2360	2330	2330	1282000
1993-09-07	2330	2330	2305	2310	480800
1993-09-08	2310	2335	2300	2330	696600
1993-09-09	2330	2335	2320	2330	512200
1993-09-10	2315	2330	2280	2300	3067400
1993-09-13	2305	2315	2275	2305	913000
1993-09-14	2300	2300	2240	2265	879400
1993-09-16	2265	2265	2200	2220	881000
1993-09-17	2205	2205	2160	2175	1609800
1993-09-20	2180	2200	2165	2165	737000
1993-09-21	2190	2215	2180	2200	1575200
1993-09-22	2195	2235	2185	2235	1621600
1993-09-24	2250	2290	2240	2290	1517600
1993-09-27	2295	2300	2245	2245	856800
1993-09-28	2275	2275	2260	2265	786600
1993-09-29	2265	2300	2230	2295	1046000
1993-09-30	2295	2295	2250	2255	411200
1993-10-01	2275	2300	2265	2280	799600
1993-10-04	2275	2305	2270	2305	757600
1993-10-05	2315	2340	2305	2325	616200
1993-10-06	2320	2320	2305	2310	748000
1993-10-07	2305	2315	2290	2290	741800
1993-10-08	2290	2310	2270	2280	1052200
1993-10-12	2295	2310	2265	2270	1019000
1993-10-13	2260	2265	2235	2250	1088200
1993-10-14	2230	2245	2225	2245	722000
1993-10-15	2265	2330	2260	2305	2386600
1993-10-18	2350	2420	2350	2400	3804600
1993-10-19	2395	2405	2380	2380	1918600
1993-10-20	2385	2425	2380	2415	3283400
1993-10-21	2430	2440	2395	2400	3052400
1993-10-22	2425	2465	2420	2450	5462200
1993-10-25	2475	2485	2460	2475	2836000
1993-10-26	2460	2500	2450	2450	3303000
1993-10-27	2450	2465	2375	2425	1854800
1993-10-28	2450	2480	2395	2425	2328000
1993-10-29	2450	2470	2425	2460	1782400
1993-11-01	2465	2485	2450	2480	1698000
1993-11-02	2470	2505	2465	2485	4307200
1993-11-04	2485	2505	2460	2465	2488600
1993-11-05	2455	2490	2415	2475	3927600
1993-11-08	2460	2470	2435	2455	1545000
1993-11-09	2455	2455	2380	2395	2004000
1993-11-10	2400	2430	2360	2410	1889600
1993-11-11	2420	2445	2405	2405	1356800
1993-11-12	2410	2450	2405	2445	2928800
1993-11-15	2440	2445	2405	2405	1671000
1993-11-16	2390	2450	2375	2430	2102600
1993-11-17	2425	2450	2415	2425	719000
1993-11-18	2450	2475	2420	2420	1834200
1993-11-19	2430	2465	2415	2420	1474600
1993-11-22	2405	2410	2340	2375	2025600
1993-11-24	2375	2400	2310	2325	1353800
1993-11-25	2350	2365	2315	2345	1041200
1993-11-26	2370	2390	2300	2315	1469800
1993-11-29	2280	2295	2210	2295	1721600
1993-11-30	2320	2390	2300	2335	2211400
1993-12-01	2370	2445	2345	2430	1504000
1993-12-02	2435	2500	2415	2465	3588400
1993-12-03	2415	2465	2415	2465	1342600
1993-12-06	2425	2435	2380	2420	1342800
1993-12-07	2430	2475	2425	2460	1383600
1993-12-08	2450	2460	2425	2460	1895000
1993-12-09	2485	2515	2480	2515	3672800
1993-12-10	2515	2615	2510	2600	8848000
1993-12-13	2610	2700	2595	2670	6432600
1993-12-14	2680	2680	2635	2655	2839200
1993-12-15	2645	2715	2640	2715	6495200
1993-12-16	2765	2785	2745	2750	6124000
1993-12-17	2740	2760	2705	2755	3524400
1993-12-20	2765	2775	2705	2720	3939200
1993-12-21	2715	2735	2685	2720	2945000
1993-12-22	2750	2765	2695	2720	3829600
1993-12-24	2720	2730	2685	2700	1531400
1993-12-27	2670	2700	2655	2695	1072000
1993-12-28	2700	2745	2700	2740	1184200
1993-12-29	2730	2770	2730	2755	2045600
1993-12-30	2755	2770	2725	2755	1138000
1994-01-04	2765	2810	2745	2810	2193800
1994-01-05	2830	2920	2830	2920	6145600
1994-01-06	2930	2960	2880	2895	5097800
1994-01-07	2870	2895	2865	2875	2780600
1994-01-10	2925	2960	2910	2945	7056600
1994-01-11	2965	2965	2890	2895	3356400
1994-01-12	2890	2900	2855	2890	2872600
1994-01-13	2895	2985	2885	2940	6725400
1994-01-14	2950	2965	2920	2950	2500400
1994-01-17	2925	2970	2915	2965	1775000
1994-01-18	2950	2985	2915	2915	2750400
1994-01-19	2925	2975	2920	2965	3081600
1994-01-20	2975	2985	2925	2935	3682000
1994-01-21	2935	2935	2915	2930	2176000
1994-01-24	2800	2850	2800	2830	3203000
1994-01-25	2880	2885	2845	2885	2081000
1994-01-26	2905	2935	2885	2935	2386000
1994-01-27	2910	2995	2910	2925	4569800
1994-01-28	2895	2935	2880	2915	2717000
1994-01-31	3065	3195	3045	3185	8947800
1994-02-01	3195	3225	3135	3200	6320000
1994-02-02	3130	3140	3075	3085	3929000
1994-02-03	3120	3135	3050	3095	2501200
1994-02-04	3100	3140	3095	3140	2745600
1994-02-07	3140	3150	3115	3145	1369000
1994-02-08	3175	3205	3150	3155	2998800
1994-02-09	3165	3165	3050	3095	1857400
1994-02-10	3100	3145	3075	3145	1994400
1994-02-14	3055	3070	3015	3025	3093400
1994-02-15	2875	2950	2875	2935	2576800
1994-02-16	2985	2995	2910	2930	1720200
1994-02-17	2925	2930	2870	2900	2174600
1994-02-18	2960	3015	2950	3015	2920000
1994-02-21	3000	3070	2990	3055	2458000
1994-02-22	3075	3095	3035	3055	2147800
1994-02-23	3075	3090	3055	3070	1448800
1994-02-24	3140	3160	3125	3150	3643800
1994-02-25	3120	3200	3115	3185	4560000
1994-02-28	3195	3230	3185	3200	3948200
1994-03-01	3220	3220	3170	3200	1977600
1994-03-02	3150	3175	3090	3090	1635400
1994-03-03	3090	3105	3015	3030	1840800
1994-03-04	3040	3120	3030	3090	3014200
1994-03-07	3135	3180	3105	3120	1961000
1994-03-08	3120	3150	3095	3110	1423000
1994-03-09	3100	3110	3080	3095	881600
1994-03-10	3115	3145	3115	3130	870400
1994-03-11	3180	3180	3125	3130	3648200
1994-03-14	3150	3175	3135	3150	1455400
1994-03-15	3190	3195	3160	3165	1226200
1994-03-16	3195	3205	3170	3175	2407600
1994-03-17	3180	3200	3145	3195	1167800
1994-03-18	3195	3195	3145	3145	1470600
1994-03-22	3100	3110	3045	3050	2008600
1994-03-23	3075	3090	3040	3045	1499400
1994-03-24	3060	3075	3045	3050	1358400
1994-03-25	3035	3070	3030	3050	1465200
1994-03-28	3075	3135	3060	3110	1058600
1994-03-29	3070	3100	3065	3065	1206200
1994-03-30	3015	3050	3005	3025	2265400
1994-03-31	2995	3015	2925	2925	3008600
1994-04-01	2960	2975	2945	2965	1489600
1994-04-04	2925	2950	2910	2945	1070600
1994-04-05	2960	3000	2955	3000	1251000
1994-04-06	3040	3060	2995	2995	1525200
1994-04-07	2990	3010	2970	3010	567200
1994-04-08	2980	3010	2940	3005	2077800
1994-04-11	3000	3000	2975	2980	655800
1994-04-12	2955	2990	2950	2960	1317000
1994-04-13	2975	3000	2960	2990	1164800
1994-04-14	2980	3000	2950	2990	734600
1994-04-15	3025	3035	2975	2975	1012400
1994-04-18	3015	3025	2980	2980	650800
1994-04-19	2985	3015	2975	2990	627000
1994-04-20	3000	3005	2960	2960	773800
1994-04-21	2970	2985	2955	2955	719200
1994-04-22	2980	2985	2940	2955	944200
1994-04-25	2950	2965	2925	2950	841800
1994-04-26	2960	2985	2940	2970	962800
1994-04-27	2945	2955	2930	2945	659600
1994-04-28	2925	2925	2880	2880	1635800
1994-05-02	2850	2850	2835	2850	913800
1994-05-06	2860	2875	2840	2850	1527400
1994-05-09	2820	2825	2800	2805	1090600
1994-05-10	2800	2835	2795	2820	1543200
1994-05-11	2885	2945	2880	2945	1913600
1994-05-12	2945	2945	2905	2920	802200
1994-05-13	2930	2965	2925	2940	1221600
1994-05-16	2990	3000	2960	2965	1254400
1994-05-17	2965	3005	2965	3000	1264600
1994-05-18	3005	3010	2940	2970	761200
1994-05-19	2955	2965	2920	2920	870800
1994-05-20	2965	2975	2955	2960	1055000
1994-05-23	3000	3000	2980	2995	783600
1994-05-24	2970	3000	2965	2970	1254200
1994-05-25	2980	3000	2965	2985	1373800
1994-05-26	3000	3025	2985	3010	1679400
1994-05-27	2990	3025	2985	3025	805600
1994-05-30	3075	3095	3040	3090	1531600
1994-05-31	3085	3115	3080	3110	1325000
1994-06-01	3120	3170	3105	3170	3638800
1994-06-02	3190	3205	3125	3145	3255800
1994-06-03	3125	3140	3115	3135	1286200
1994-06-06	3130	3150	3100	3105	807800
1994-06-07	3120	3170	3105	3170	1285200
1994-06-08	3150	3205	3135	3195	2194600
1994-06-09	3200	3210	3150	3175	1317000
1994-06-10	3220	3220	3165	3185	3602400
1994-06-13	3135	3190	3115	3190	930400
1994-06-14	3160	3170	3150	3165	841000
1994-06-15	3175	3175	3140	3160	821000
1994-06-16	3135	3160	3135	3155	659800
1994-06-17	3190	3195	3170	3170	1246000
1994-06-20	3165	3180	3140	3140	1028600
1994-06-21	3090	3110	3075	3080	912200
1994-06-22	3030	3055	3010	3035	2417800
1994-06-23	3065	3070	3045	3060	1172800
1994-06-24	3050	3125	3045	3060	1326200
1994-06-27	3000	3010	2960	2990	1763000
1994-06-28	3035	3080	3015	3035	1254200
1994-06-29	3020	3030	2995	3000	1225800
1994-06-30	2975	3050	2970	3025	1728000
1994-07-01	3000	3010	2970	3005	1917000
1994-07-04	3015	3040	3005	3040	639200
1994-07-05	3075	3155	3070	3135	1581800
1994-07-06	3120	3120	3050	3055	988000
1994-07-07	3030	3055	3030	3040	1279600
1994-07-08	3030	3040	3010	3015	1644200
1994-07-11	2990	3015	2985	3000	760600
1994-07-12	2970	2975	2950	2960	1509000
1994-07-13	2940	2955	2915	2925	2062000
1994-07-14	2970	3035	2965	3025	1081200
1994-07-15	3020	3035	2960	2975	923400
1994-07-18	2950	2970	2950	2970	450000
1994-07-19	2990	3000	2960	2995	334400
1994-07-20	3005	3020	2985	3005	986600
1994-07-21	2990	2990	2965	2975	469800
1994-07-22	3000	3000	2945	2975	733600
1994-07-25	2900	2920	2875	2895	1303600
1994-07-26	2885	2920	2855	2890	1127800
1994-07-27	2865	2880	2820	2825	1594600
1994-07-28	2870	2920	2840	2880	1309800
1994-07-29	2975	2990	2935	2935	1646400
1994-08-01	2900	2945	2890	2925	723600
1994-08-02	2970	3000	2955	3000	1065200
1994-08-03	3000	3010	2970	2970	819400
1994-08-04	2990	2990	2960	2980	529400
1994-08-05	2975	2985	2935	2950	697600
1994-08-08	2950	2970	2935	2965	522200
1994-08-09	2975	2975	2940	2950	1000600
1994-08-10	2965	2995	2955	2990	788400
1994-08-11	3000	3005	2975	3000	1161800
1994-08-12	3000	3000	2965	2985	977600
1994-08-15	2965	2980	2960	2965	369200
1994-08-16	2965	2985	2950	2975	388600
1994-08-17	2995	3005	2980	2990	987000
1994-08-18	2995	2995	2980	2995	527200
1994-08-19	2980	3000	2950	2950	1093600
1994-08-22	2950	2955	2930	2935	565800
1994-08-23	2935	2965	2925	2945	535000
1994-08-24	2940	2960	2940	2955	565000
1994-08-25	2970	2970	2935	2935	870800
1994-08-26	2940	2950	2915	2915	830200
1994-08-29	2960	2970	2940	2950	531200
1994-08-30	2950	3030	2945	3010	1597200
1994-08-31	3025	3055	3015	3055	1441200
1994-09-01	3075	3115	3070	3075	2361600
1994-09-02	3075	3075	3050	3050	819000
1994-09-05	3050	3050	2950	2950	893400
1994-09-06	2950	3010	2950	2975	419000
1994-09-07	2955	2975	2925	2925	1230000
1994-09-08	2925	2950	2900	2900	1391200
1994-09-09	2930	2940	2875	2890	3056200
1994-09-12	2905	2970	2905	2925	706400
1994-09-13	2935	2975	2925	2960	774000
1994-09-14	2950	2970	2930	2965	610400
1994-09-16	2965	2970	2940	2940	544800
1994-09-19	2940	2940	2895	2895	704400
1994-09-20	2925	2940	2915	2940	853000
1994-09-21	2915	2970	2910	2945	1043800
1994-09-22	2945	2955	2925	2930	915800
1994-09-26	2930	2935	2915	2925	552400
1994-09-27	2925	2935	2900	2900	737400
1994-09-28	2905	2915	2895	2895	1033200
1994-09-29	2905	2925	2900	2900	829400
1994-09-30	2900	2910	2880	2880	737000
1994-10-03	2890	2910	2875	2900	464600
1994-10-04	2910	2910	2890	2900	311600
1994-10-05	2895	2900	2880	2885	1098400
1994-10-06	2905	2905	2880	2885	985600
1994-10-07	2890	2955	2880	2950	991600
1994-10-11	2985	3005	2975	3000	916600
1994-10-12	3000	3000	2960	3000	1192800
1994-10-13	2990	3005	2980	2985	795600
1994-10-14	2975	2985	2960	2985	1383600
1994-10-17	2965	2985	2945	2975	417200
1994-10-18	2945	2960	2925	2940	301400
1994-10-19	2945	2965	2935	2935	478400
1994-10-20	2935	2950	2935	2950	289000
1994-10-21	2900	2915	2880	2905	973400
1994-10-24	2920	2925	2885	2885	573400
1994-10-25	2890	2905	2880	2890	529600
1994-10-26	2900	2905	2885	2905	337800
1994-10-27	2920	2950	2910	2915	555200
1994-10-28	2925	2940	2900	2915	741600
1994-10-31	2950	2955	2930	2955	418000
1994-11-01	2945	2970	2930	2960	370800
1994-11-02	2945	2950	2915	2925	525200
1994-11-04	2950	2950	2900	2915	607000
1994-11-07	2890	2890	2855	2870	836400
1994-11-08	2875	2890	2865	2890	788600
1994-11-09	2870	2890	2860	2880	759800
1994-11-10	2915	2915	2860	2865	1146200
1994-11-11	2880	2885	2865	2875	732000
1994-11-14	2860	2890	2855	2875	432200
1994-11-15	2900	2910	2880	2890	608600
1994-11-16	2900	2910	2885	2900	903800
1994-11-17	2905	2910	2890	2895	552800
1994-11-18	2745	2750	2650	2740	7948200
1994-11-21	2690	2695	2615	2615	3849200
1994-11-22	2540	2580	2535	2555	4110400
1994-11-24	2505	2540	2500	2515	2912400
1994-11-25	2565	2580	2540	2580	1758600
1994-11-28	2590	2605	2570	2570	1760000
1994-11-29	2585	2625	2580	2615	1925200
1994-11-30	2625	2665	2620	2625	2603000
1994-12-01	2630	2715	2630	2670	2434800
1994-12-02	2660	2715	2660	2710	1747600
1994-12-05	2760	2760	2730	2760	1628000
1994-12-06	2760	2780	2750	2755	1648200
1994-12-07	2720	2725	2665	2665	1424400
1994-12-08	2645	2680	2630	2640	1468000
1994-12-09	2675	2680	2640	2640	2767400
1994-12-12	2680	2700	2665	2690	670800
1994-12-13	2700	2710	2660	2700	828400
1994-12-14	2700	2700	2680	2680	528000
1994-12-15	2710	2710	2680	2690	768200
1994-12-16	2700	2700	2680	2695	579600
1994-12-19	2710	2755	2700	2750	1193000
1994-12-20	2735	2785	2725	2775	2035800
1994-12-21	2775	2795	2765	2765	1889800
1994-12-22	2795	2805	2775	2795	1976800
1994-12-26	2800	2820	2780	2805	1086200
1994-12-27	2815	2835	2800	2820	1463400
1994-12-28	2835	2850	2795	2795	1342200
1994-12-29	2790	2825	2790	2815	975800
1994-12-30	2780	2830	2780	2825	722200
1995-01-04	2840	2860	2825	2840	662000
1995-01-05	2840	2845	2805	2840	568800
1995-01-06	2825	2825	2790	2815	381400
1995-01-09	2805	2810	2795	2800	509400
1995-01-10	2775	2790	2765	2775	841400
1995-01-11	2790	2805	2775	2775	786800
1995-01-12	2785	2785	2730	2740	562800
1995-01-13	2745	2745	2690	2695	1456200
1995-01-17	2675	2695	2575	2585	1429000
1995-01-18	2620	2645	2615	2620	752200
1995-01-19	2620	2635	2560	2560	1230800
1995-01-20	2560	2575	2510	2520	2426200
1995-01-23	2520	2540	2455	2455	2658000
1995-01-24	2460	2520	2455	2500	1655800
1995-01-25	2510	2520	2460	2460	1591800
1995-01-26	2465	2480	2410	2445	1720600
1995-01-27	2425	2440	2375	2400	1597000
1995-01-30	2420	2450	2400	2405	1398400
1995-01-31	2425	2425	2285	2295	1905600
1995-02-01	2320	2395	2310	2350	2257400
1995-02-02	2325	2330	2270	2320	2593800
1995-02-03	2315	2320	2295	2310	1272200
1995-02-06	2340	2345	2305	2310	1129600
1995-02-07	2345	2345	2325	2325	1089800
1995-02-08	2340	2370	2330	2360	1334200
1995-02-09	2370	2395	2355	2360	1278000
1995-02-10	2370	2390	2365	2385	1381600
1995-02-13	2400	2405	2355	2360	1297600
1995-02-14	2350	2360	2340	2350	787000
1995-02-15	2325	2325	2275	2285	1513200
1995-02-16	2210	2215	2175	2190	2310800
1995-02-17	2175	2245	2150	2200	3680800
1995-02-20	2210	2250	2200	2200	1078400
1995-02-21	2205	2240	2205	2215	1052200
1995-02-22	2240	2260	2225	2225	1353000
1995-02-23	2230	2230	2190	2220	1445400
1995-02-24	2205	2210	2130	2135	2693600
1995-02-27	2060	2075	1995	2015	4165200
1995-02-28	2090	2125	2075	2100	1988400
1995-03-01	2120	2135	2075	2115	2216800
1995-03-02	2215	2250	2190	2250	2718600
1995-03-03	2200	2260	2185	2225	1875200
1995-03-06	2190	2220	2180	2195	1077400
1995-03-07	2215	2215	2175	2180	1151400
1995-03-08	2140	2155	2110	2145	2086000
1995-03-09	2130	2145	2110	2110	1733800
1995-03-10	2095	2125	2075	2100	4411600
1995-03-13	2100	2120	2060	2120	1486800
1995-03-14	2080	2090	2035	2065	2129200
1995-03-15	2050	2105	2050	2100	1653200
1995-03-16	2075	2100	2055	2055	946200
1995-03-17	2070	2075	2030	2040	998200
1995-03-20	2025	2050	2015	2050	732200
1995-03-22	2050	2075	2030	2045	742200
1995-03-23	2025	2045	2015	2030	1456000
1995-03-24	2010	2050	1995	2035	2249800
1995-03-27	2085	2155	2085	2150	1173800
1995-03-28	2165	2200	2165	2190	1484600
1995-03-29	2215	2215	2175	2185	1351400
1995-03-30	2135	2210	2135	2160	732400
1995-03-31	2210	2215	2155	2175	1579800
1995-04-03	2100	2110	2040	2050	1825800
1995-04-04	2090	2120	2025	2105	2350600
1995-04-05	2090	2110	2065	2090	1080800
1995-04-06	2065	2100	2060	2075	1038600
1995-04-07	2055	2070	2040	2065	1696200
1995-04-10	2060	2110	2030	2075	1653800
1995-04-11	2100	2125	2090	2125	1484000
1995-04-12	2125	2160	2120	2150	1456400
1995-04-13	2145	2160	2115	2130	837000
1995-04-14	2105	2120	2055	2055	1572200
1995-04-17	2030	2075	2025	2075	813000
1995-04-18	2075	2090	2070	2080	808600
1995-04-19	2055	2080	2045	2065	1742400
1995-04-20	2090	2145	2080	2130	1430800
1995-04-21	2145	2160	2140	2150	1341600
1995-04-24	2140	2150	2085	2100	433000
1995-04-25	2125	2150	2120	2145	1119800
1995-04-26	2125	2145	2090	2100	946400
1995-04-27	2135	2135	2110	2110	597200
1995-04-28	2115	2135	2105	2120	1027600
1995-05-01	2130	2140	2115	2125	596000
1995-05-02	2130	2150	2120	2150	1022200
1995-05-08	2160	2160	2105	2105	822000
1995-05-09	2105	2115	2075	2085	755000
1995-05-10	2080	2090	2045	2050	1185000
1995-05-11	2070	2070	2025	2040	2091000
1995-05-12	2065	2080	2055	2055	2323600
1995-05-15	2070	2130	2055	2130	1228200
1995-05-16	2115	2130	2110	2110	664600
1995-05-17	2135	2135	2115	2125	875000
1995-05-18	2135	2140	2085	2100	1116200
1995-05-19	2055	2115	2050	2100	1252600
1995-05-22	2095	2105	2065	2070	547000
1995-05-23	2070	2075	2050	2060	1195200
1995-05-24	2060	2085	2055	2085	1040200
1995-05-25	2085	2090	2015	2015	1456600
1995-05-26	2015	2065	2005	2050	808400
1995-05-29	2000	2035	2000	2030	726800
1995-05-30	2030	2050	2025	2035	594400
1995-05-31	2045	2060	2010	2040	1518800
1995-06-01	2060	2100	2045	2080	1807600
1995-06-02	2100	2135	2090	2115	2067600
1995-06-05	2115	2120	2095	2110	575800
1995-06-06	2100	2100	2050	2060	489600
1995-06-07	2055	2090	2055	2090	625800
1995-06-08	2070	2085	2050	2070	643000
1995-06-09	2020	2045	2010	2030	4246600
1995-06-12	2035	2035	2000	2010	1305400
1995-06-13	2010	2020	1900	1900	2585400
1995-06-14	1890	1935	1885	1920	2476200
1995-06-15	1900	1980	1865	1975	1886600
1995-06-16	1995	1995	1925	1925	1118400
1995-06-19	1945	1980	1940	1940	975800
1995-06-20	1965	1980	1935	1970	1018200
1995-06-21	1975	2020	1965	2020	1674800
1995-06-22	2045	2055	2035	2050	1368600
1995-06-23	2065	2075	2055	2065	964800
1995-06-26	2090	2095	2065	2085	1122800
1995-06-27	2070	2080	2030	2030	897800
1995-06-28	2005	2045	1990	2025	926400
1995-06-29	2075	2090	1980	2030	2544200
1995-06-30	2055	2065	2030	2035	1389600
1995-07-03	2045	2050	2005	2050	1076800
1995-07-04	2045	2065	2030	2055	892400
1995-07-05	2060	2075	2035	2070	793000
1995-07-06	2085	2100	2060	2095	1410200
1995-07-07	2125	2180	2115	2160	4125600
1995-07-10	2260	2335	2250	2305	5702000
1995-07-11	2300	2325	2260	2320	2079400
1995-07-12	2325	2380	2305	2360	2452600
1995-07-13	2360	2365	2330	2340	1209000
1995-07-14	2365	2410	2350	2375	2803600
1995-07-17	2375	2425	2375	2400	1376800
1995-07-18	2450	2470	2425	2430	3797600
1995-07-19	2380	2395	2325	2370	1867400
1995-07-20	2335	2360	2310	2360	1321800
1995-07-21	2400	2400	2355	2390	1508200
1995-07-24	2400	2410	2380	2405	974000
1995-07-25	2400	2400	2345	2345	1208800
1995-07-26	2360	2375	2350	2375	1197000
1995-07-27	2365	2430	2360	2420	1229600
1995-07-28	2390	2415	2370	2400	1300600
1995-07-31	2390	2420	2385	2385	884200
1995-08-01	2360	2385	2355	2380	476200
1995-08-02	2370	2455	2360	2435	2204600
1995-08-03	2510	2685	2500	2675	8313000
1995-08-04	2675	2720	2625	2645	4585800
1995-08-07	2695	2710	2610	2630	2082200
1995-08-08	2645	2670	2570	2660	2313200
1995-08-09	2630	2660	2585	2600	2089200
1995-08-10	2575	2620	2530	2550	2043000
1995-08-11	2645	2650	2595	2640	2361800
1995-08-14	2630	2645	2605	2605	1076600
1995-08-15	2600	2675	2570	2675	1324800
1995-08-16	2800	2815	2690	2700	3399000
1995-08-17	2715	2770	2710	2710	1766400
1995-08-18	2700	2750	2655	2710	1237600
1995-08-21	2685	2705	2640	2645	775000
1995-08-22	2645	2700	2645	2675	748000
1995-08-23	2675	2685	2575	2580	568400
1995-08-24	2555	2675	2555	2675	921800
1995-08-25	2625	2630	2560	2585	766400
1995-08-28	2575	2590	2540	2585	745800
1995-08-29	2600	2625	2580	2610	736800
1995-08-30	2660	2660	2615	2635	774000
1995-08-31	2650	2695	2640	2670	1383200
1995-09-01	2650	2660	2640	2660	1387600
1995-09-04	2660	2675	2630	2645	1117200
1995-09-05	2660	2690	2625	2660	1550800
1995-09-06	2660	2715	2660	2685	1419000
1995-09-07	2700	2700	2615	2625	976400
1995-09-08	2775	2775	2635	2655	7206800
1995-09-11	2645	2675	2575	2605	1603200
1995-09-12	2645	2655	2615	2625	1107800
1995-09-13	2645	2680	2640	2660	1473400
1995-09-14	2700	2700	2675	2675	1389600
1995-09-18	2690	2720	2670	2700	1625400
1995-09-19	2675	2695	2660	2675	1300600
1995-09-20	2725	2725	2650	2670	1194200
1995-09-21	2650	2700	2640	2685	1161600
1995-09-22	2610	2665	2610	2625	1286400
1995-09-25	2625	2635	2575	2585	1185800
1995-09-26	2585	2615	2570	2610	1651000
1995-09-27	2580	2625	2545	2625	1445000
1995-09-28	2575	2600	2550	2560	1168000
1995-09-29	2590	2620	2555	2570	986200
1995-10-02	2575	2580	2515	2560	1093200
1995-10-03	2560	2620	2550	2620	731800
1995-10-04	2615	2625	2575	2590	900600
1995-10-05	2590	2620	2565	2620	578200
1995-10-06	2610	2665	2600	2660	1081800
1995-10-09	2660	2660	2600	2600	784400
1995-10-11	2575	2575	2525	2540	834800
1995-10-12	2590	2590	2540	2550	700600
1995-10-13	2525	2585	2515	2530	1074800
1995-10-16	2565	2600	2560	2575	495400
1995-10-17	2570	2595	2525	2535	714200
1995-10-18	2560	2575	2525	2570	879600
1995-10-19	2570	2605	2560	2585	609800
1995-10-20	2600	2615	2585	2600	1030800
1995-10-23	2585	2605	2575	2600	744800
1995-10-24	2575	2580	2525	2540	1532600
1995-10-25	2550	2555	2525	2545	1896000
1995-10-26	2555	2555	2460	2470	1974200
1995-10-27	2405	2435	2375	2375	2137000
1995-10-30	2380	2380	2345	2370	1783800
1995-10-31	2360	2365	2285	2300	2762400
1995-11-01	2305	2345	2295	2340	2498000
1995-11-02	2365	2435	2365	2435	2270200
1995-11-06	2425	2455	2385	2415	1288000
1995-11-07	2415	2425	2405	2410	861800
1995-11-08	2360	2375	2330	2330	1188000
1995-11-09	2355	2400	2355	2370	1062800
1995-11-10	2470	2475	2425	2450	2513400
1995-11-13	2475	2495	2465	2475	1400600
1995-11-14	2500	2520	2465	2475	1771400
1995-11-15	2460	2475	2425	2430	1179000
1995-11-16	2450	2500	2440	2500	1317800
1995-11-17	2535	2545	2505	2520	1238400
1995-11-20	2535	2580	2535	2575	1604000
1995-11-21	2585	2590	2555	2575	775200
1995-11-22	2565	2590	2560	2575	925000
1995-11-24	2595	2595	2585	2595	687200
1995-11-27	2600	2650	2600	2645	1703000
1995-11-28	2685	2695	2665	2675	2138400
1995-11-29	2700	2740	2700	2700	2228200
1995-11-30	2725	2740	2700	2700	1524000
1995-12-01	2750	2765	2725	2750	2551600
1995-12-04	2775	2795	2760	2775	2813200
1995-12-05	2780	2785	2750	2750	1322800
1995-12-06	2750	2810	2750	2810	2373200
1995-12-07	2860	2925	2835	2905	3669600
1995-12-08	2900	2905	2855	2890	5917800
1995-12-11	2900	2900	2860	2870	1179400
1995-12-12	2875	2915	2875	2905	2056000
1995-12-13	2925	2945	2890	2895	2218000
1995-12-14	2920	2920	2890	2900	1142400
1995-12-15	2885	2890	2810	2835	992400
1995-12-18	2815	2855	2815	2830	630200
1995-12-19	2765	2810	2750	2790	1328000
1995-12-20	2810	2820	2790	2795	1226600
1995-12-21	2805	2910	2800	2905	1525000
1995-12-22	2955	3005	2945	3000	5358000
1995-12-25	3000	3000	2965	2975	799600
1995-12-26	2970	2990	2945	2990	608600
1995-12-27	3010	3070	3000	3065	2783800
1995-12-28	3060	3105	3040	3075	2850000
1995-12-29	3060	3115	3050	3095	1792600
1996-01-04	3295	3515	3255	3425	6158600
1996-01-05	3400	3480	3385	3390	6127000
1996-01-08	3390	3455	3375	3390	3750800
1996-01-09	3375	3410	3340	3405	2655000
1996-01-10	3355	3385	3325	3340	3160200
1996-01-11	3250	3290	3240	3270	2235200
1996-01-12	3320	3325	3225	3225	2240600
1996-01-16	3245	3290	3215	3275	1331200
1996-01-17	3325	3345	3300	3315	2408400
1996-01-18	3235	3275	3235	3250	1394200
1996-01-19	3250	3260	3205	3255	1668600
1996-01-22	3250	3265	3215	3250	1179000
1996-01-23	3265	3285	3230	3235	1336800
1996-01-24	3135	3150	3115	3150	2605000
1996-01-25	3170	3185	3120	3145	2318800
1996-01-26	3140	3170	3115	3150	1015200
1996-01-29	3195	3195	3150	3150	671600
1996-01-30	3165	3225	3165	3215	1652800
1996-01-31	3265	3300	3250	3275	1814200
1996-02-01	3275	3280	3210	3245	1727800
1996-02-02	3245	3265	3235	3250	1330600
1996-02-05	3250	3250	3205	3210	1032200
1996-02-06	3175	3250	3160	3250	1206600
1996-02-07	3250	3380	3225	3260	3223800
1996-02-08	3285	3355	3280	3325	2077000
1996-02-09	3275	3285	3225	3225	2388600
1996-02-13	3240	3245	3225	3230	749000
1996-02-14	3245	3265	3230	3235	729000
1996-02-15	3225	3250	3220	3250	733400
1996-02-16	3225	3250	3215	3250	693000
1996-02-19	3225	3225	3165	3180	676800
1996-02-20	3120	3120	3095	3100	1886600
1996-02-21	3190	3200	3145	3170	1591200
1996-02-22	3150	3170	3130	3140	1092400
1996-02-23	3150	3165	3140	3140	790400
1996-02-26	3140	3140	3085	3085	965000
1996-02-27	3095	3100	3050	3050	1367400
1996-02-28	3100	3110	3045	3045	938800
1996-02-29	3095	3095	3050	3080	3005600
1996-03-01	3075	3080	3020	3060	2361200
1996-03-04	3075	3075	3025	3040	877800
1996-03-05	3040	3065	3035	3050	1308600
1996-03-06	3075	3160	3050	3150	3161000
1996-03-07	3150	3150	3075	3075	1697400
1996-03-08	3050	3125	3050	3125	7572800
1996-03-11	3080	3125	3075	3090	951800
1996-03-12	3120	3125	3090	3100	1562600
1996-03-13	3100	3100	3050	3065	1218600
1996-03-14	3070	3095	3060	3095	1024600
1996-03-15	3115	3195	3095	3135	3838800
1996-03-18	3160	3160	3130	3140	853800
1996-03-19	3190	3190	3150	3150	1379000
1996-03-21	3180	3190	3165	3190	1522000
1996-03-22	3200	3210	3170	3185	1581800
1996-03-25	3200	3200	3155	3165	863800
1996-03-26	3180	3200	3155	3155	1129800
1996-03-27	3170	3195	3165	3195	787800
1996-03-28	3200	3215	3170	3195	1487400
1996-03-29	3195	3220	3180	3195	1710200
1996-04-01	3225	3250	3220	3225	2851200
1996-04-02	3245	3255	3205	3220	1711000
1996-04-03	3230	3235	3190	3200	1466800
1996-04-04	3195	3210	3185	3195	822400
1996-04-05	3195	3225	3185	3220	1016400
1996-04-08	3175	3195	3175	3190	509800
1996-04-09	3220	3250	3205	3220	1622200
1996-04-10	3225	3235	3215	3220	1717800
1996-04-11	3230	3255	3210	3210	2418200
1996-04-12	3195	3225	3195	3200	1383000
1996-04-15	3200	3230	3200	3215	1715600
1996-04-16	3245	3275	3230	3250	3566400
1996-04-17	3300	3340	3275	3300	5991800
1996-04-18	3310	3375	3290	3330	5004000
1996-04-19	3335	3350	3310	3330	2577400
1996-04-22	3365	3430	3360	3425	4955800
1996-04-23	3425	3425	3390	3410	2675600
1996-04-24	3410	3430	3395	3400	2545200
1996-04-25	3420	3430	3395	3415	3717000
1996-04-26	3420	3470	3405	3450	4716000
1996-04-30	3400	3425	3390	3400	2202000
1996-05-01	3410	3425	3370	3390	2012000
1996-05-02	3375	3385	3355	3385	1611200
1996-05-07	3370	3370	3345	3360	1251400
1996-05-08	3360	3400	3355	3395	1518600
1996-05-09	3395	3395	3330	3335	1712200
1996-05-10	3345	3380	3340	3340	2166200
1996-05-13	3375	3375	3330	3335	1276600
1996-05-14	3345	3360	3335	3340	723000
1996-05-15	3395	3440	3385	3440	3820800
1996-05-16	3475	3495	3455	3460	5544400
1996-05-17	3435	3450	3420	3440	1384800
1996-05-20	3435	3455	3425	3450	1157200
1996-05-21	3445	3465	3430	3435	1527600
1996-05-22	3450	3460	3435	3440	1275200
1996-05-23	3425	3440	3400	3410	1007800
1996-05-24	3405	3440	3395	3430	1288000
1996-05-27	3435	3440	3400	3425	598600
1996-05-28	3440	3455	3425	3455	911200
1996-05-29	3455	3460	3435	3435	1885600
1996-05-30	3425	3450	3420	3435	1918600
1996-05-31	3445	3450	3435	3435	1388800
1996-06-03	3425	3430	3400	3400	816800
1996-06-04	3435	3450	3420	3435	1229000
1996-06-05	3480	3490	3460	3480	3415600
1996-06-06	3485	3490	3470	3485	1622400
1996-06-07	3480	3485	3470	3480	955600
1996-06-10	3480	3490	3465	3475	1754000
1996-06-11	3480	3500	3470	3490	3761000
1996-06-12	3505	3550	3500	3530	6662800
1996-06-13	3535	3540	3515	3530	2938800
1996-06-14	3530	3565	3520	3565	7336000
1996-06-17	3560	3580	3540	3550	3203600
1996-06-18	3555	3560	3535	3550	2424200
1996-06-19	3545	3570	3540	3565	2550000
1996-06-20	3535	3560	3530	3555	1281600
1996-06-21	3565	3570	3540	3550	1748400
1996-06-24	3555	3575	3550	3575	2293800
1996-06-25	3575	3600	3570	3600	3633000
1996-06-26	3610	3655	3605	3625	5305200
1996-06-27	3625	3640	3600	3600	2242400
1996-06-28	3620	3630	3595	3605	1753200
1996-07-01	3630	3630	3605	3615	1436400
1996-07-02	3615	3620	3575	3600	915400
1996-07-03	3580	3590	3555	3565	936200
1996-07-04	3555	3575	3535	3570	1271000
1996-07-05	3590	3595	3580	3590	1256000
1996-07-08	3550	3570	3540	3560	1050200
1996-07-09	3560	3585	3560	3570	949800
1996-07-10	3580	3585	3545	3550	1119600
1996-07-11	3580	3580	3545	3575	1213400
1996-07-12	3530	3565	3525	3550	1822600
1996-07-15	3540	3555	3535	3555	824600
1996-07-16	3505	3520	3485	3495	1437400
1996-07-17	3495	3505	3435	3450	1859200
1996-07-18	3450	3480	3425	3450	1980800
1996-07-19	3460	3470	3410	3415	1652200
1996-07-22	3425	3425	3390	3390	1013200
1996-07-23	3375	3380	3340	3380	2120400
1996-07-24	3380	3380	3350	3350	979800
1996-07-25	3360	3400	3345	3385	1601400
1996-07-26	3400	3430	3385	3415	1032000
1996-07-29	3420	3425	3400	3400	613600
1996-07-30	3360	3385	3360	3380	1019200
1996-07-31	3385	3400	3360	3375	936600
1996-08-01	3375	3465	3365	3460	1080800
1996-08-02	3475	3485	3455	3460	830600
1996-08-05	3490	3490	3460	3480	511600
1996-08-06	3465	3465	3435	3435	523800
1996-08-07	3415	3435	3375	3395	799200
1996-08-08	3410	3430	3400	3425	835600
1996-08-09	3425	3425	3400	3410	1061800
1996-08-12	3420	3440	3400	3435	477200
1996-08-13	3450	3475	3440	3465	711600
1996-08-14	3460	3490	3450	3485	640200
1996-08-15	3485	3495	3445	3460	967400
1996-08-16	3450	3460	3445	3450	477400
1996-08-19	3465	3490	3450	3470	931200
1996-08-20	3470	3485	3455	3470	560600
1996-08-21	3505	3510	3490	3500	1023000
1996-08-22	3505	3530	3500	3515	1600200
1996-08-23	3520	3520	3495	3495	784600
1996-08-26	3495	3495	3455	3455	488400
1996-08-27	3455	3480	3455	3480	605000
1996-08-28	3480	3500	3455	3455	898600
1996-08-29	3455	3460	3435	3440	950200
1996-08-30	3415	3430	3405	3410	1570800
1996-09-02	3415	3430	3390	3390	451600
1996-09-03	3400	3430	3395	3415	895800
1996-09-04	3420	3430	3395	3405	1174400
1996-09-05	3405	3440	3400	3420	1009000
1996-09-06	3415	3425	3405	3410	586600
1996-09-09	3450	3450	3420	3430	685200
1996-09-10	3445	3460	3430	3460	1146800
1996-09-11	3460	3465	3435	3450	676800
1996-09-12	3445	3460	3425	3445	751400
1996-09-13	3455	3475	3440	3475	3675000
1996-09-17	3510	3520	3495	3510	1898000
1996-09-18	3505	3510	3485	3485	1067600
1996-09-19	3475	3500	3465	3500	1207800
1996-09-20	3500	3500	3480	3480	918600
1996-09-24	3475	3495	3465	3480	667200
1996-09-25	3475	3495	3470	3475	454800
1996-09-26	3490	3505	3480	3480	1459400
1996-09-27	3480	3505	3470	3500	1013800
1996-09-30	3500	3520	3495	3515	834800
1996-10-01	3515	3525	3505	3525	853000
1996-10-02	3530	3555	3530	3550	3245800
1996-10-03	3560	3560	3520	3525	947400
1996-10-04	3515	3515	3485	3500	878200
1996-10-07	3510	3510	3485	3490	517200
1996-10-08	3490	3490	3475	3480	680200
1996-10-09	3475	3495	3470	3490	406200
1996-10-11	3495	3500	3480	3495	1080400
1996-10-14	3500	3500	3490	3500	400800
1996-10-15	3530	3565	3520	3565	2169800
1996-10-16	3575	3575	3555	3560	1137000
1996-10-17	3555	3560	3535	3535	614400
1996-10-18	3535	3570	3525	3530	1465200
1996-10-21	3525	3535	3490	3510	725000
1996-10-22	3480	3500	3450	3465	870400
1996-10-23	3445	3455	3410	3455	1316200
1996-10-24	3450	3460	3420	3420	665000
1996-10-25	3425	3440	3410	3430	1172200
1996-10-28	3430	3450	3430	3445	509200
1996-10-29	3445	3465	3430	3445	731800
1996-10-30	3450	3450	3415	3440	810800
1996-10-31	3425	3450	3410	3415	829800
1996-11-01	3380	3395	3360	3380	1973600
1996-11-05	3385	3390	3370	3385	967000
1996-11-06	3395	3450	3395	3430	1057200
1996-11-07	3450	3455	3425	3425	722200
1996-11-08	3415	3460	3415	3445	1583000
1996-11-11	3445	3465	3435	3435	451000
1996-11-12	3440	3470	3440	3460	804800
1996-11-13	3450	3465	3440	3450	739000
1996-11-14	3475	3475	3455	3475	547800
1996-11-15	3480	3490	3470	3475	780000
1996-11-18	3475	3495	3460	3495	624400
1996-11-19	3495	3505	3470	3500	828400
1996-11-20	3515	3555	3510	3550	3243800
1996-11-21	3555	3570	3525	3540	2146200
1996-11-22	3535	3560	3530	3560	1104800
1996-11-25	3570	3620	3565	3620	2695600
1996-11-26	3645	3650	3600	3615	3000400
1996-11-27	3640	3700	3630	3690	5639600
1996-11-28	3675	3705	3665	3670	3030000
1996-11-29	3655	3675	3645	3645	1693200
1996-12-02	3660	3670	3615	3615	1551000
1996-12-03	3625	3665	3615	3635	1683400
1996-12-04	3640	3715	3635	3715	3009800
1996-12-05	3725	3760	3720	3750	6132200
1996-12-06	3795	3815	3670	3735	6229600
1996-12-09	3770	3785	3750	3760	2022600
1996-12-10	3810	3850	3780	3840	3762200
1996-12-11	3790	3830	3760	3780	2225400
1996-12-12	3745	3765	3730	3755	1706000
1996-12-13	3745	3755	3700	3750	5414400
1996-12-16	3760	3770	3740	3755	2691200
1996-12-17	3725	3745	3695	3730	2043600
1996-12-18	3700	3715	3670	3670	2214400
1996-12-19	3675	3705	3645	3660	2174400
1996-12-20	3700	3745	3685	3710	2053000
1996-12-24	3750	3755	3720	3720	2085200
1996-12-25	3765	3805	3735	3790	1576000
1996-12-26	3780	3800	3740	3800	2248000
1996-12-27	3800	3825	3770	3785	2708800
1996-12-30	3820	3830	3795	3795	1495400
1997-01-06	3820	3855	3795	3850	2477400
1997-01-07	3860	3875	3820	3820	2920800
1997-01-08	3840	3855	3820	3845	2764200
1997-01-09	3815	3840	3755	3755	2086000
1997-01-10	3755	3780	3650	3660	5111000
1997-01-13	3680	3695	3625	3680	3703400
1997-01-14	3720	3740	3645	3735	5022000
1997-01-16	3825	3850	3800	3845	4566200
1997-01-17	3825	3860	3810	3830	3885400
1997-01-20	3840	3845	3765	3790	2499000
1997-01-21	3795	3820	3785	3800	2290000
1997-01-22	3850	3865	3835	3855	3118200
1997-01-23	3850	3880	3845	3860	3185400
1997-01-24	3870	3910	3870	3880	5021800
1997-01-27	3900	3950	3885	3915	4061400
1997-01-28	3955	4005	3935	3995	5879200
1997-01-29	4050	4135	4040	4125	10539000
1997-01-30	4075	4120	4045	4075	3129800
1997-01-31	4100	4120	4075	4090	3041600
1997-02-03	4050	4070	4010	4015	2005000
1997-02-04	4065	4095	4045	4065	2685800
1997-02-05	4100	4110	4060	4110	2325600
1997-02-06	4160	4195	4145	4180	5042600
1997-02-07	4220	4250	4200	4230	4773000
1997-02-10	4240	4280	4225	4275	3076200
1997-02-12	4300	4480	4300	4450	8429800
1997-02-13	4550	4580	4530	4535	6509200
1997-02-14	4575	4590	4525	4540	5290600
1997-02-17	4540	4545	4495	4500	2626400
1997-02-18	4475	4485	4350	4400	3436000
1997-02-19	4375	4415	4325	4415	3297600
1997-02-20	4450	4475	4405	4445	2920000
1997-02-21	4310	4400	4270	4375	3682600
1997-02-24	4330	4355	4285	4290	1747600
1997-02-25	4285	4390	4280	4390	2748600
1997-02-26	4440	4465	4405	4410	2839400
1997-02-27	4370	4435	4365	4430	1463800
1997-02-28	4420	4425	4345	4355	1869000
1997-03-03	4305	4370	4300	4350	1121400
1997-03-04	4400	4450	4380	4450	3138000
1997-03-05	4495	4510	4450	4450	4605000
1997-03-06	4475	4480	4385	4400	2790200
1997-03-07	4365	4410	4355	4385	1841200
1997-03-10	4420	4450	4400	4405	2413800
1997-03-11	4405	4410	4370	4395	2115200
1997-03-12	4420	4430	4380	4420	1460400
1997-03-13	4415	4420	4380	4400	2103000
1997-03-14	4300	4420	4300	4420	5075000
1997-03-17	4450	4460	4425	4455	2112800
1997-03-18	4430	4455	4385	4410	2011600
1997-03-19	4410	4415	4325	4355	1686800
1997-03-21	4315	4325	4300	4300	1616600
1997-03-24	4300	4315	4150	4150	2366800
1997-03-25	4225	4275	4205	4205	2586200
1997-03-26	4275	4325	4215	4325	2791800
1997-03-27	4340	4345	4260	4325	2322400
1997-03-28	4310	4325	4280	4320	972000
1997-03-31	4300	4325	4270	4325	816200
1997-04-01	4300	4345	4260	4340	2364400
1997-04-02	4330	4335	4305	4330	2364600
1997-04-03	4330	4420	4320	4390	3452000
1997-04-04	4425	4485	4390	4470	4169200
1997-04-07	4475	4515	4470	4490	3290200
1997-04-08	4525	4560	4495	4560	3922600
1997-04-09	4560	4580	4530	4550	3374400
1997-04-10	4570	4600	4500	4525	3085200
1997-04-11	4500	4525	4445	4525	2706000
1997-04-14	4475	4490	4455	4475	1739400
1997-04-15	4500	4505	4465	4505	2546200
1997-04-16	4500	4500	4455	4460	2017600
1997-04-17	4435	4445	4370	4405	2017000
1997-04-18	4425	4460	4425	4425	1996800
1997-04-21	4425	4475	4405	4475	1314800
1997-04-22	4445	4495	4445	4485	2434400
1997-04-23	4525	4580	4505	4575	4019400
1997-04-24	4560	4585	4515	4540	2785400
1997-04-25	4550	4590	4535	4570	2835600
1997-04-28	4570	4575	4555	4570	861800
1997-04-30	4620	4640	4610	4620	3394600
1997-05-01	4640	4660	4620	4630	2983400
1997-05-02	4615	4680	4610	4680	2783600
1997-05-06	4750	4795	4725	4750	4815000
1997-05-07	4750	4835	4745	4815	5962400
1997-05-08	4820	4900	4815	4860	5703600
1997-05-09	4910	4915	4760	4760	6954200
1997-05-12	4690	4795	4635	4785	5637600
1997-05-13	4860	4995	4840	4865	6566400
1997-05-14	4855	4935	4840	4915	2893600
1997-05-15	4900	4910	4825	4875	2359200
1997-05-16	4875	4910	4865	4910	2106600
1997-05-19	4890	4930	4870	4900	2291400
1997-05-20	4910	4930	4815	4865	2264600
1997-05-21	4855	4855	4750	4775	1838600
1997-05-22	4790	4790	4665	4700	3393200
1997-05-23	4790	4845	4775	4840	2744800
1997-05-26	4845	4860	4825	4850	1225200
1997-05-27	4850	4865	4815	4845	954800
1997-05-28	4850	4950	4815	4950	2040000
1997-05-29	4950	4960	4890	4920	2678600
1997-05-30	4970	5000	4905	4905	4247400
1997-06-02	4945	4970	4910	4970	1672200
1997-06-03	4975	5050	4970	5050	3636200
1997-06-04	5050	5050	5000	5000	2562000
1997-06-05	5000	5050	4980	5000	2211200
1997-06-06	5000	5000	4935	4975	1249800
1997-06-09	4950	4970	4920	4920	1238800
1997-06-10	4925	4985	4925	4950	1423200
1997-06-11	4985	4990	4925	4925	1671600
1997-06-12	4915	4970	4905	4945	1585200
1997-06-13	4975	4985	4900	4940	4467800
1997-06-16	4970	4975	4945	4955	1098200
1997-06-17	4955	4955	4870	4900	1176600
1997-06-18	4925	4925	4850	4875	876800
1997-06-19	4890	4920	4860	4890	1177800
1997-06-20	4940	4940	4885	4915	1435800
1997-06-23	4960	4960	4910	4935	1295000
1997-06-24	4900	4920	4885	4920	950200
1997-06-25	4930	4945	4910	4945	1657600
1997-06-26	4995	5050	4960	4960	3625200
1997-06-27	4985	5000	4965	4995	1413000
1997-06-30	5050	5050	4970	4995	1276600
1997-07-01	5000	5000	4950	4965	1335200
1997-07-02	4920	4945	4775	4885	2525200
1997-07-03	4875	4875	4785	4820	2399400
1997-07-04	4825	4840	4780	4840	1841200
1997-07-07	4820	4845	4800	4830	1177600
1997-07-08	4880	4895	4850	4880	2188400
1997-07-09	4920	4930	4835	4850	2357600
1997-07-10	4870	4895	4860	4880	1518200
1997-07-11	4915	4950	4840	4935	3552800
1997-07-14	4945	5050	4945	5050	4713400
1997-07-15	5100	5150	5050	5050	3633800
1997-07-16	5200	5250	5150	5250	5215200
1997-07-17	5300	5350	5200	5350	3828400
1997-07-18	5350	5450	5300	5350	3260400
1997-07-22	5350	5400	5250	5350	1713200
1997-07-23	5400	5450	5300	5350	1877000
1997-07-24	5400	5450	5350	5400	1679200
1997-07-25	5450	5500	5400	5400	1682800
1997-07-28	5500	5650	5450	5650	3405000
1997-07-29	5700	5900	5700	5850	4961800
1997-07-30	5950	5950	5750	5800	3316600
1997-07-31	5850	5900	5750	5900	1990400
1997-08-01	6000	6300	5950	6100	6683600
1997-08-04	6100	6150	5750	6000	2540400
1997-08-05	5900	5950	5800	5950	2613400
1997-08-06	5950	6000	5800	5950	3080400
1997-08-07	6000	6100	5950	6050	2861800
1997-08-08	5950	6000	5850	5950	2467600
1997-08-11	5750	5850	5700	5700	2702200
1997-08-12	5800	5850	5750	5800	1634800
1997-08-13	5700	5800	5650	5700	1661000
1997-08-14	5700	5800	5650	5750	2024800
1997-08-15	5950	6000	5900	5950	2029400
1997-08-18	5750	5800	5700	5750	2986200
1997-08-19	5750	5800	5450	5500	3245200
1997-08-20	5600	5750	5550	5700	2134600
1997-08-21	5750	5850	5700	5700	2445600
1997-08-22	5600	5650	5450	5500	2019200
1997-08-25	5500	5550	5300	5350	1678600
1997-08-26	5400	5550	5350	5550	1657200
1997-08-27	5400	5500	5350	5400	1516200
1997-08-28	5450	5550	5350	5400	2124200
1997-08-29	5200	5250	5100	5250	2728600
1997-09-01	5200	5250	5150	5150	1609200
1997-09-02	5250	5350	5200	5300	2188600
1997-09-03	5550	5650	5500	5650	3639800
1997-09-04	5600	5700	5550	5600	2301600
1997-09-05	5600	5750	5550	5700	1773800
1997-09-08	5700	5850	5700	5750	2392200
1997-09-09	5700	5750	5550	5700	1635400
1997-09-10	5600	5650	5550	5650	915800
1997-09-11	5500	5550	5350	5500	1920600
1997-09-12	5400	5400	5250	5400	4466800
1997-09-16	5350	5400	5250	5300	1867400
1997-09-17	5400	5500	5300	5400	1581200
1997-09-18	5350	5500	5300	5400	1869200
1997-09-19	5400	5500	5300	5450	2323800
1997-09-22	5500	5500	5400	5450	1821800
1997-09-24	5500	5750	5500	5750	3384200
1997-09-25	5750	5850	5700	5800	2222400
1997-09-26	5700	5750	5600	5650	1544400
1997-09-29	5650	5650	5500	5600	1445200
1997-09-30	5650	5750	5600	5700	1239400
1997-10-01	5650	5900	5600	5850	2741600
1997-10-02	5900	5950	5750	5750	2162800
1997-10-03	5800	5950	5750	5900	2053800
1997-10-06	5900	6050	5900	6000	2408400
1997-10-07	6000	6050	5850	5900	1444800
1997-10-08	5950	6000	5900	5950	1040400
1997-10-09	5950	5950	5800	5800	1580800
1997-10-13	5700	5700	5550	5650	974400
1997-10-14	5700	5900	5600	5850	1720400
1997-10-15	5850	5900	5750	5900	1425600
1997-10-16	5950	6050	5900	5950	2901000
1997-10-17	5850	6000	5800	6000	2232800
1997-10-20	5800	5900	5700	5700	1855600
1997-10-21	5800	5800	5550	5550	2017000
1997-10-22	5600	5650	5500	5650	1916000
1997-10-23	5550	5650	5350	5350	1771400
1997-10-24	5150	5300	5100	5300	4148000
1997-10-27	5100	5150	5050	5150	2013800
1997-10-29	5050	5100	5000	5050	4190600
1997-10-30	5050	5100	4925	4950	3253600
1997-10-31	4850	5050	4830	4995	3592200
1997-11-04	5150	5300	5150	5250	2740800
1997-11-05	5300	5400	5200	5350	1970200
1997-11-06	5500	5600	5450	5500	2828200
1997-11-07	5300	5400	5100	5150	2806600
1997-11-10	5000	5100	4960	5050	3390200
1997-11-11	4975	5100	4975	5050	2499400
1997-11-12	5000	5050	4930	4940	2398600
1997-11-13	4800	4890	4730	4835	4884000
1997-11-14	4735	4795	4660	4725	4387800
1997-11-17	4825	5100	4800	5100	3723600
1997-11-18	5150	5350	5050	5250	3761000
1997-11-19	5050	5100	5000	5050	1812600
1997-11-20	5100	5250	5050	5200	1880600
1997-11-21	5300	5350	5250	5300	1561800
1997-11-25	5100	5350	5050	5300	4587400
1997-11-26	5300	5350	5150	5150	2242600
1997-11-27	5300	5400	5200	5400	1420400
1997-11-28	5500	5500	5400	5450	2248600
1997-12-01	5400	5650	5350	5600	2269200
1997-12-02	5700	5850	5650	5750	3268600
1997-12-03	5700	5750	5600	5650	1766600
1997-12-04	5700	5750	5600	5700	1952000
1997-12-05	5750	5950	5750	5900	4000000
1997-12-08	5900	6000	5900	6000	2273200
1997-12-09	6000	6100	5950	6100	2996600
1997-12-10	6000	6050	5900	6000	1661400
1997-12-11	5800	5850	5600	5700	1644400
1997-12-12	5700	5700	5350	5550	5701400
1997-12-15	5500	5600	5400	5500	1362200
1997-12-16	5500	5550	5350	5450	1619200
1997-12-17	5650	6000	5600	5900	3706600
1997-12-18	5800	5850	5750	5800	1031200
1997-12-19	5650	5650	5400	5450	2489600
1997-12-22	5400	5500	5400	5450	1944600
1997-12-24	5650	5900	5600	5850	2611800
1997-12-25	5850	6050	5850	5850	3156200
1997-12-26	5900	5950	5600	5650	1105600
1997-12-29	5700	5800	5600	5800	1054800
1997-12-30	5800	5800	5700	5800	566600
1998-01-05	6000	6050	5900	5900	1376400
1998-01-06	6000	6050	5900	6000	2089000
1998-01-07	6000	6200	6000	6200	2358600
1998-01-08	6200	6300	6150	6150	3394400
1998-01-09	5950	6100	5900	6050	1887800
1998-01-12	5800	6000	5800	5850	1607000
1998-01-13	5950	6000	5750	5800	1703800
1998-01-14	5900	5950	5800	5850	1588600
1998-01-16	6000	6200	6000	6150	2655200
1998-01-19	6300	6350	6100	6100	2700600
1998-01-20	6150	6250	6100	6100	1788800
1998-01-21	6200	6200	5950	6050	2089400
1998-01-22	6000	6050	5850	5900	1627600
1998-01-23	5850	6000	5850	6000	1821200
1998-01-26	5950	6000	5800	5800	1937400
1998-01-27	5850	5850	5650	5650	2006800
1998-01-28	5800	5850	5550	5550	2057000
1998-01-29	5750	5950	5700	5900	2393000
1998-01-30	5750	5900	5750	5850	2172200
1998-02-02	5900	6000	5800	5900	1479600
1998-02-03	6100	6100	5950	6050	2490200
1998-02-04	6050	6050	5900	5950	1347000
1998-02-05	5850	5850	5650	5700	1915800
1998-02-06	5750	5800	5650	5700	1637600
1998-02-09	5650	5650	5500	5600	2529800
1998-02-10	5600	5650	5550	5600	1311400
1998-02-12	5650	5650	5450	5550	2496800
1998-02-13	5550	5550	5400	5500	2612000
1998-02-16	5500	5650	5450	5650	1316800
1998-02-17	5700	5750	5650	5700	1143000
1998-02-18	5700	5700	5550	5650	869400
1998-02-19	5600	5650	5500	5500	1331800
1998-02-20	5550	5550	5450	5500	1111200
1998-02-23	5550	5650	5500	5600	917000
1998-02-24	5700	5700	5550	5650	1382000
1998-02-25	5550	5650	5500	5650	1363600
1998-02-26	5650	5750	5650	5750	1467600
1998-02-27	5750	5750	5500	5700	2358000
1998-03-02	5700	5750	5600	5700	1324800
1998-03-03	5750	5900	5750	5800	3666600
1998-03-04	5750	5800	5700	5800	1554600
1998-03-05	5650	5700	5550	5550	1389600
1998-03-06	5600	5700	5550	5650	927200
1998-03-09	5750	5800	5550	5600	1174000
1998-03-10	5650	5650	5550	5600	713400
1998-03-11	5550	5550	5400	5450	1579000
1998-03-12	5400	5450	5250	5250	2104800
1998-03-13	5200	5400	5200	5350	3733200
1998-03-16	5450	5500	5400	5450	1381000
1998-03-17	5550	5600	5500	5550	1421600
1998-03-18	5550	5550	5350	5500	1869000
1998-03-19	5450	5500	5350	5400	1138400
1998-03-20	5450	5550	5400	5500	2115400
1998-03-23	5550	5600	5450	5550	1407400
1998-03-24	5500	5550	5450	5450	1437000
1998-03-25	5550	5550	5400	5500	1464800
1998-03-26	5600	5650	5550	5550	1489200
1998-03-27	5600	5650	5550	5600	1328200
1998-03-30	5650	5700	5500	5550	1625800
1998-03-31	5550	5650	5450	5650	2951200
1998-04-01	5550	5800	5550	5700	2692000
1998-04-02	5900	5950	5800	5800	2937600
1998-04-03	5800	5850	5550	5650	2700200
1998-04-06	5650	5750	5600	5650	2534800
1998-04-07	5550	5650	5400	5500	3023200
1998-04-08	5550	5700	5550	5600	2525600
1998-04-09	5700	5700	5600	5650	2944400
1998-04-10	5650	5700	5600	5700	1477600
1998-04-13	5675	5720	5650	5665	1270200
1998-04-14	5680	5750	5660	5680	1385000
1998-04-15	5705	5745	5670	5740	2488600
1998-04-16	5775	5805	5745	5760	2870200
1998-04-17	5565	5675	5460	5675	3247000
1998-04-20	5575	5650	5560	5650	1469000
1998-04-21	5675	5690	5625	5665	1408400
1998-04-22	5670	5670	5600	5640	1730600
1998-04-23	5630	5635	5590	5600	1358200
1998-04-24	5615	5705	5600	5650	1842000
1998-04-27	5645	5660	5550	5570	1720200
1998-04-28	5505	5575	5480	5510	1942000
1998-04-30	5600	5600	5485	5505	1355800
1998-05-01	5525	5550	5490	5550	1364200
1998-05-06	5510	5510	5380	5500	2414400
1998-05-07	5455	5485	5315	5325	2558600
1998-05-08	5225	5335	5225	5275	4732400
1998-05-11	5285	5310	5215	5285	2453400
1998-05-12	5385	5495	5355	5470	2950600
1998-05-13	5500	5590	5455	5590	2919600
1998-05-14	5580	5720	5580	5610	2516600
1998-05-15	5640	5775	5625	5710	3121200
1998-05-18	5690	5710	5590	5710	1303600
1998-05-19	5725	5810	5690	5800	1885000
1998-05-20	5785	5850	5770	5775	1600600
1998-05-21	5825	5900	5815	5850	1804800
1998-05-22	5845	5845	5770	5805	1092000
1998-05-25	5775	5810	5765	5800	735400
1998-05-26	5810	5880	5810	5860	1495800
1998-05-27	5875	5930	5850	5925	2469000
1998-05-28	5875	5910	5870	5895	1814400
1998-05-29	5845	5865	5805	5850	1555800
1998-06-01	5805	5850	5670	5670	1822400
1998-06-02	5720	5730	5675	5710	978000
1998-06-03	5715	5715	5605	5625	1656800
1998-06-04	5600	5645	5575	5575	1133600
1998-06-05	5675	5710	5630	5655	1431400
1998-06-08	5670	5780	5665	5710	1541200
1998-06-09	5795	5850	5795	5835	1321600
1998-06-10	5845	5855	5775	5840	1434800
1998-06-11	5785	5795	5655	5675	1795000
1998-06-12	5670	5825	5570	5770	3850600
1998-06-15	5670	5750	5670	5675	1261400
1998-06-16	5655	5745	5605	5645	1516600
1998-06-17	5625	5635	5410	5450	3910600
1998-06-18	5695	5700	5500	5575	2378400
1998-06-19	5455	5595	5455	5570	1159400
1998-06-22	5590	5600	5565	5570	554600
1998-06-23	5585	5620	5500	5525	665400
1998-06-24	5625	5700	5580	5690	1248800
1998-06-25	5775	5875	5745	5835	2816400
1998-06-26	5850	5910	5845	5865	2886600
1998-06-29	5850	5915	5840	5895	915400
1998-06-30	5995	6020	5950	5975	2829400
1998-07-01	5995	6040	5915	6000	2532600
1998-07-02	5990	6045	5915	5945	2526400
1998-07-03	5950	6070	5945	6020	2191000
1998-07-06	5965	6035	5935	5960	1008400
1998-07-07	5965	6110	5945	6065	1574600
1998-07-08	6100	6165	6080	6095	2098200
1998-07-09	6105	6200	6075	6200	1943400
1998-07-10	6245	6300	6070	6150	3448200
1998-07-13	6050	6325	6050	6320	1867800
1998-07-14	6320	6355	6195	6265	1626000
1998-07-15	6365	6465	6325	6450	3426400
1998-07-16	6475	6575	6440	6575	2876000
1998-07-17	6600	6630	6560	6575	2698000
1998-07-21	6700	6745	6680	6695	2432200
1998-07-22	6660	6680	6630	6650	1717200
1998-07-23	6610	6635	6465	6525	1261800
1998-07-24	6450	6645	6430	6620	1438400
1998-07-27	6530	6625	6530	6530	1558200
1998-07-28	6540	6565	6470	6530	1772400
1998-07-29	6460	6520	6405	6520	1487200
1998-07-30	6325	6390	6160	6215	4314400
1998-07-31	6205	6250	6095	6145	3445000
1998-08-03	6105	6110	6025	6090	1889000
1998-08-04	5990	6085	5970	6010	2208600
1998-08-05	5980	6045	5920	5965	3189800
1998-08-06	5935	5935	5760	5825	4262000
1998-08-07	5850	5935	5835	5855	2208000
1998-08-10	5875	6000	5865	6000	1345000
1998-08-11	5975	6050	5945	6000	2109200
1998-08-12	5805	5900	5755	5790	2947400
1998-08-13	5830	5850	5775	5840	1846400
1998-08-14	5740	5815	5735	5750	2864000
1998-08-17	5740	5750	5575	5580	2120800
1998-08-18	5680	5775	5630	5775	1544200
1998-08-19	5875	6035	5825	5990	2392400
1998-08-20	5985	6070	5915	6035	1184200
1998-08-21	5985	6020	5925	5925	1060600
1998-08-24	5725	5765	5615	5695	2170600
1998-08-25	5700	5835	5695	5695	1945200
1998-08-26	5670	5670	5605	5610	1669000
1998-08-27	5600	5620	5515	5565	1915800
1998-08-28	5205	5345	5200	5285	3841600
1998-08-31	5320	5325	5125	5155	3074600
1998-09-01	4955	5115	4950	5115	2840400
1998-09-02	5045	5110	5025	5055	3092400
1998-09-03	5070	5130	5030	5085	1994600
1998-09-04	5000	5015	4975	4990	1918800
1998-09-07	4900	5090	4875	5080	2297400
1998-09-08	5125	5390	5120	5320	3426400
1998-09-09	5350	5350	5130	5145	2794000
1998-09-10	5245	5320	5145	5200	2104000
1998-09-11	5000	5075	4895	4900	7321200
1998-09-14	4905	5045	4890	4995	1756600
1998-09-16	5000	5150	5000	5090	1632400
1998-09-17	5055	5070	4955	4970	1218800
1998-09-18	4875	4895	4825	4875	2770800
1998-09-21	4805	4840	4700	4705	1960400
1998-09-22	4685	4730	4380	4490	5464800
1998-09-24	4740	4925	4695	4860	3183200
1998-09-25	4750	4785	4625	4750	1660400
1998-09-28	4725	4815	4660	4735	1988800
1998-09-29	4775	4905	4675	4875	1994000
1998-09-30	4970	5010	4730	4745	3071800
1998-10-01	4645	4670	4275	4475	6920600
1998-10-02	4175	4225	4020	4160	9157000
1998-10-05	4185	4215	4075	4145	2520000
1998-10-06	4120	4270	4115	4210	2193200
1998-10-07	4260	4465	4175	4465	4001200
1998-10-08	4165	4190	3965	4075	4882400
1998-10-09	3875	3970	3825	3885	5254000
1998-10-12	4085	4225	4035	4210	3973400
1998-10-13	4165	4200	4115	4145	2382200
1998-10-14	4150	4195	4075	4100	2154600
1998-10-15	4100	4120	3960	3995	2445200
1998-10-16	4145	4150	4045	4070	3411200
1998-10-19	4015	4125	3960	4005	2900400
1998-10-20	4105	4190	4050	4160	2343600
1998-10-21	4250	4310	4235	4295	3399800
1998-10-22	4400	4460	4300	4325	3127200
1998-10-23	4395	4450	4350	4430	1791800
1998-10-26	4400	4430	4355	4395	1657600
1998-10-27	4345	4410	4200	4270	1769400
1998-10-28	4100	4125	3990	4005	4090000
1998-10-29	3855	3930	3815	3850	6640200
1998-10-30	3850	3850	3615	3700	6434600
1998-11-02	3750	3815	3675	3750	3441000
1998-11-04	3945	3975	3885	3970	4959400
1998-11-05	4070	4145	4025	4105	5797200
1998-11-06	4125	4160	4095	4140	3533800
1998-11-09	4140	4175	4125	4175	1746600
1998-11-10	4185	4290	4170	4195	2956200
1998-11-11	4190	4205	4080	4190	2376800
1998-11-12	4140	4145	4045	4065	2052800
1998-11-13	4075	4110	3980	4050	2959200
1998-11-16	4035	4085	3980	4040	2570400
1998-11-17	4090	4140	4060	4140	1867800
1998-11-18	4140	4290	4130	4255	3227400
1998-11-19	4290	4295	4175	4220	1703000
1998-11-20	4300	4325	4265	4300	2116600
1998-11-24	4500	4625	4440	4600	4795600
1998-11-25	4510	4565	4485	4565	1925200
1998-11-26	4600	4660	4585	4640	2326400
1998-11-27	4655	4710	4620	4700	1542200
1998-11-30	4700	4710	4505	4505	2017200
1998-12-01	4505	4570	4485	4520	1727000
1998-12-02	4505	4550	4450	4550	2174600
1998-12-03	4525	4565	4500	4500	1492000
1998-12-04	4475	4495	4390	4445	1594400
1998-12-07	4475	4490	4445	4475	1238800
1998-12-08	4510	4550	4500	4505	1335400
1998-12-09	4455	4515	4435	4495	1169200
1998-12-10	4475	4500	4415	4425	1133200
1998-12-11	4375	4440	4290	4345	4337400
1998-12-14	4295	4295	4150	4150	1867400
1998-12-15	4150	4210	4120	4130	1402800
1998-12-16	4180	4245	4160	4220	1093600
1998-12-17	4200	4220	4130	4155	1554600
1998-12-18	4205	4275	4190	4250	1314600
1998-12-21	4250	4250	4190	4220	889600
1998-12-22	4270	4285	4130	4160	1345400
1998-12-24	4190	4190	4115	4135	893600
1998-12-25	4195	4220	4135	4135	397800
1998-12-28	4185	4200	4120	4140	599400
1998-12-29	4175	4175	4105	4130	799800
1998-12-30	4140	4185	4115	4115	281000
1999-01-04	4050	4080	4015	4025	1000600
1999-01-05	4015	4025	3860	3885	2624600
1999-01-06	3915	3925	3830	3870	3301400
1999-01-07	3970	3995	3820	3850	3577600
1999-01-08	3800	3835	3740	3785	4223200
1999-01-11	3795	3800	3725	3730	3258000
1999-01-12	3680	3765	3645	3695	6031400
1999-01-13	3745	3805	3720	3780	3943600
1999-01-14	3760	3850	3750	3825	2882200
1999-01-18	3895	3945	3880	3940	2221400
1999-01-19	3950	3965	3890	3950	2182800
1999-01-20	3930	4010	3910	3995	2014400
1999-01-21	4015	4075	3965	4045	2544000
1999-01-22	4025	4095	4025	4030	2015000
1999-01-25	4010	4030	3950	3960	2071000
1999-01-26	3965	3990	3900	3950	1840600
1999-01-27	3945	4065	3905	4030	1851000
1999-01-28	4105	4170	4065	4065	3217400
1999-01-29	4215	4260	4185	4225	3268800
1999-02-01	4270	4285	4225	4260	1453400
1999-02-02	4240	4240	4180	4205	1037400
1999-02-03	4120	4160	4080	4100	1459600
1999-02-04	4150	4230	4105	4145	1666200
1999-02-05	4125	4145	4055	4085	1432600
1999-02-08	4135	4175	4105	4175	1150000
1999-02-09	4200	4200	4105	4110	1291200
1999-02-10	4075	4200	4070	4200	1484800
1999-02-12	4150	4195	4140	4170	2378800
1999-02-15	4175	4210	4160	4200	1023400
1999-02-16	4225	4320	4225	4300	2115000
1999-02-17	4400	4450	4375	4420	3508800
1999-02-18	4415	4430	4355	4425	1759200
1999-02-19	4475	4550	4455	4550	3160200
1999-02-22	4580	4585	4540	4550	1524800
1999-02-23	4545	4570	4510	4570	1313000
1999-02-24	4545	4585	4495	4530	2278000
1999-02-25	4580	4610	4530	4545	1617600
1999-02-26	4540	4540	4480	4490	1369600
1999-03-01	4445	4475	4360	4360	1561400
1999-03-02	4420	4470	4345	4345	1481600
1999-03-03	4430	4550	4410	4535	2180200
1999-03-04	4635	4740	4610	4725	4289800
1999-03-05	5000	5055	4930	5050	6693400
1999-03-08	5150	5170	5025	5025	3654400
1999-03-09	5325	5525	5275	5470	9334400
1999-03-10	5850	5965	5795	5925	11909000
1999-03-11	5525	5675	5375	5455	8524400
1999-03-12	5600	5640	5500	5505	7531200
1999-03-15	5575	5650	5540	5650	3959400
1999-03-16	5750	5765	5680	5750	6191800
1999-03-17	5715	5795	5645	5795	3728800
1999-03-18	5775	5775	5490	5535	3464200
1999-03-19	5600	5700	5550	5680	3027000
1999-03-23	5750	5775	5630	5700	3112000
1999-03-24	5400	5515	5375	5375	3170800
1999-03-25	5525	5650	5525	5645	2144800
1999-03-26	5700	5750	5545	5700	2216000
1999-03-29	5695	5710	5640	5650	1729000
1999-03-30	5700	5725	5560	5650	1844000
1999-03-31	5550	5600	5465	5475	1686200
1999-04-01	5500	5700	5470	5650	2438000
1999-04-02	5750	5785	5675	5700	2556800
1999-04-05	5700	5745	5620	5690	1432600
1999-04-06	5750	5845	5655	5845	2640000
1999-04-07	5875	6125	5830	6045	8668200
1999-04-08	6045	6200	6000	6200	3554400
1999-04-09	6400	6400	6150	6180	5967600
1999-04-12	6080	6120	5985	6000	1823600
1999-04-13	6100	6105	6025	6040	2339800
1999-04-14	5975	5990	5800	5850	3419800
1999-04-15	5875	5980	5835	5925	2577600
1999-04-16	5950	6010	5800	5805	2491400
1999-04-19	5805	5805	5655	5725	2164600
1999-04-20	5625	5685	5600	5650	2056200
1999-04-21	5665	5700	5590	5640	1318400
1999-04-22	5740	5745	5635	5745	2220400
1999-04-23	5750	5845	5740	5815	2081400
1999-04-26	5775	5840	5715	5715	1415200
1999-04-27	5815	5820	5725	5780	1540800
1999-04-28	5825	5935	5780	5850	2860200
1999-04-30	5650	5665	5525	5575	4814800
1999-05-06	5550	5660	5545	5640	3135400
1999-05-07	5635	5650	5500	5500	2409400
1999-05-10	5575	5595	5535	5545	1354400
1999-05-11	5610	5610	5540	5560	1901000
1999-05-12	5650	5720	5610	5610	2202600
1999-05-13	5580	5665	5560	5625	1232200
1999-05-14	5665	5670	5620	5660	2742400
1999-05-17	5640	5645	5580	5590	1457200
1999-05-18	5590	5635	5525	5590	1570200
1999-05-19	5505	5610	5480	5490	2154000
1999-05-20	5590	5725	5500	5705	2346800
1999-05-21	5705	5745	5650	5740	1547200
1999-05-24	5720	5815	5680	5800	1997600
1999-05-25	5650	5685	5575	5585	1882200
1999-05-26	5580	5750	5570	5655	1731400
1999-05-27	5755	5755	5655	5725	1229000
1999-05-28	5670	5705	5640	5680	2002200
1999-05-31	5650	5665	5555	5615	1586000
1999-06-01	5575	5655	5555	5620	1482800
1999-06-02	5610	5615	5515	5540	1853800
1999-06-03	5505	5535	5400	5425	2660000
1999-06-04	5445	5470	5360	5425	1812600
1999-06-07	5475	5635	5460	5585	2406400
1999-06-08	5685	5700	5630	5650	1719400
1999-06-09	5650	5700	5635	5685	1397600
1999-06-10	5650	5770	5615	5720	2168200
1999-06-11	5700	5925	5700	5900	9132800
1999-06-14	5910	5995	5865	5900	3232400
1999-06-15	5945	6010	5875	5995	2561200
1999-06-16	5975	6015	5925	5950	1882800
1999-06-17	6050	6120	6025	6075	2924400
1999-06-18	6095	6150	6080	6145	3013600
1999-06-21	6245	6490	6205	6490	5818400
1999-06-22	6690	6705	6585	6650	9487000
1999-06-23	6550	6575	6475	6510	4527400
1999-06-24	6450	6470	6360	6425	2635000
1999-06-25	6325	6355	6255	6255	2080000
1999-06-28	6300	6305	6255	6290	1545800
1999-06-29	6330	6575	6330	6535	4800600
1999-06-30	6650	6730	6525	6525	4978000
1999-07-01	6675	6795	6605	6795	5707800
1999-07-02	6850	6885	6730	6825	3831400
1999-07-05	6870	6950	6850	6850	2858200
1999-07-06	6850	6870	6650	6750	2368400
1999-07-07	6750	6810	6675	6750	2454000
1999-07-08	6800	6935	6760	6850	4001800
1999-07-09	6900	6920	6765	6885	3301800
1999-07-12	6930	7215	6900	7215	5142000
1999-07-13	7150	7275	7115	7210	3770600
1999-07-14	7155	7365	7155	7270	3662000
1999-07-15	7400	7450	7330	7410	4004200
1999-07-16	7710	7840	7530	7575	4981600
1999-07-19	7550	7560	7440	7510	2425000
1999-07-21	7210	7255	7100	7165	3421600
1999-07-22	7065	7090	6850	6925	3275200
1999-07-23	6750	6960	6735	6850	3308600
1999-07-26	6950	7075	6925	6985	2914400
1999-07-27	7035	7060	6860	6885	2899000
1999-07-28	7050	7115	6960	7010	2445200
1999-07-29	7275	7615	7260	7375	6612600
1999-07-30	7245	7395	7190	7295	3641200
1999-08-02	7150	7245	7130	7180	2453000
1999-08-03	7225	7275	7105	7220	2845200
1999-08-04	7125	7150	7000	7020	2635600
1999-08-05	6820	6865	6745	6825	3146200
1999-08-06	6850	6910	6825	6870	3009600
1999-08-09	6825	6945	6790	6885	2083400
1999-08-10	6945	7135	6920	7120	4001400
1999-08-11	7080	7180	7045	7065	2879600
1999-08-12	7250	7275	7165	7195	1969200
1999-08-13	7195	7305	7150	7265	2712800
1999-08-16	7500	7500	7410	7410	2731400
1999-08-17	7490	7535	7435	7475	3705600
1999-08-18	7550	7605	7445	7485	4542800
1999-08-19	7285	7300	7150	7225	2614600
1999-08-20	7075	7395	7075	7375	3155600
1999-08-23	7450	7450	7140	7230	1932600
1999-08-24	7400	7500	7345	7400	2032800
1999-08-25	7275	7375	7130	7165	1948600
1999-08-26	7250	7285	7155	7155	1675200
1999-08-27	7155	7200	7105	7175	1148600
1999-08-30	7075	7285	7070	7275	1109200
1999-08-31	7105	7160	7055	7090	2227800
1999-09-01	7055	7220	7030	7175	2149600
1999-09-02	7175	7185	7075	7075	1333400
1999-09-03	7030	7135	7025	7070	1566600
1999-09-06	7270	7270	7105	7110	1349200
1999-09-07	7150	7220	7095	7175	1603200
1999-09-08	7165	7165	7085	7155	1930000
1999-09-09	7250	7260	7080	7080	1758000
1999-09-10	7000	7260	6995	7140	7356400
1999-09-13	7320	7545	7285	7465	5545400
1999-09-14	7665	8075	7535	7975	14931200
1999-09-16	7775	7920	7750	7800	7647600
1999-09-17	7810	7890	7680	7770	4718200
1999-09-20	7970	8435	7965	8230	9393000
1999-09-21	8375	8630	8335	8625	9500400
1999-09-22	8225	8435	8165	8300	7665200
1999-09-24	8000	8040	7800	7985	6768600
1999-09-27	8025	8140	7875	7880	2861600
1999-09-28	8080	8115	8000	8070	2820000
1999-09-29	8070	8070	7900	7970	1901000
1999-09-30	8050	8120	7955	7955	3126200
1999-10-01	8095	8460	8075	8275	6935800
1999-10-04	8245	8335	8200	8250	2745200
1999-10-05	8350	8440	8275	8310	2497200
1999-10-06	8400	8400	8205	8350	2366800
1999-10-07	8450	8485	8365	8440	3839800
1999-10-08	8400	8400	8280	8395	3209600
1999-10-12	8295	8400	8285	8345	2660400
1999-10-13	8290	8345	8255	8255	1699800
1999-10-14	8215	8420	8210	8340	1993000
1999-10-15	8345	8395	8080	8125	2378600
1999-10-18	7750	7850	7565	7635	4434600
1999-10-19	7700	7705	7585	7605	2247400
1999-10-20	7800	7890	7760	7795	2688400
1999-10-21	7870	7870	7680	7710	2098800
1999-10-22	7800	7820	7670	7710	2026800
1999-10-25	7900	8005	7865	7875	3015200
1999-10-26	7925	8045	7895	7940	2187000
1999-10-27	7980	8000	7775	7810	2358200
1999-10-28	7910	8010	7855	7855	3235200
1999-10-29	8100	8205	8080	8130	4843800
1999-11-01	8200	8310	8175	8185	3200800
1999-11-02	8185	8275	8155	8270	2026200
1999-11-04	8320	8415	8310	8330	4136200
1999-11-05	8395	8670	8315	8525	6460800
1999-11-08	8700	8790	8650	8705	6893000
1999-11-09	8905	9025	8825	8995	8386600
1999-11-10	8925	9225	8825	9150	6121800
1999-11-11	9150	9260	9040	9040	5178200
1999-11-12	9045	9275	9040	9245	3986800
1999-11-15	9345	9470	9335	9380	4049800
1999-11-16	9375	9550	9215	9400	4407400
1999-11-17	9600	9685	9215	9365	4306800
1999-11-18	9365	9365	9195	9280	3032200
1999-11-19	9340	9440	9265	9300	2824800
1999-11-22	9350	9500	9350	9400	2706600
1999-11-24	9330	9545	9295	9445	3800600
1999-11-25	9545	9635	9385	9400	3180800
1999-11-26	9500	9650	9365	9650	2578800
1999-11-29	9600	9700	9520	9675	2895600
1999-11-30	9665	9685	9375	9450	2849400
1999-12-01	9350	9400	9155	9215	2392400
1999-12-02	9215	9285	8950	9065	2377800
1999-12-03	9100	9140	9030	9075	1660800
1999-12-06	9275	9310	9185	9275	2444800
1999-12-07	9365	9450	9315	9390	2742600
1999-12-08	9390	9395	9230	9270	1736000
1999-12-09	9370	9370	9155	9235	1827200
1999-12-10	9795	9860	9525	9580	11369200
1999-12-13	9625	9630	9490	9625	2998800
1999-12-14	9685	9755	9640	9700	4075200
1999-12-15	9690	9725	9650	9705	4011200
1999-12-16	9725	9755	9575	9715	2370800
1999-12-17	9815	10485	9730	10255	8824400
1999-12-20	10750	11040	10645	10660	6630600
1999-12-21	10660	10850	10660	10825	4308200
1999-12-22	10925	11825	10885	11545	6725400
1999-12-24	12145	12490	12080	12400	6388200
1999-12-27	12305	12425	12030	12150	2363600
1999-12-28	13150	13150	13150	13150	160400
1999-12-29	14150	14150	14150	14150	379000
1999-12-30	15150	15150	15150	15150	4839600
2000-01-04	15000	16125	14900	15350	8794200
2000-01-05	13850	13850	13850	13850	2073200
2000-01-06	13550	13625	12850	12850	9919800
2000-01-07	11850	12050	11850	11850	9360200
2000-01-11	12850	12850	12850	12850	2482600
2000-01-12	12550	12895	12365	12700	7863200
2000-01-13	12350	12395	12000	12125	5948000
2000-01-14	12225	12275	11715	12000	6117000
2000-01-17	12100	12390	12085	12315	3331800
2000-01-18	12015	12075	11815	11890	3147000
2000-01-19	11990	12080	11725	11725	3313200
2000-01-20	11800	11975	11725	11850	3108600
2000-01-21	12000	12100	11925	12100	2778000
2000-01-24	12400	12600	12360	12575	4222000
2000-01-25	12375	12800	12335	12515	4025000
2000-01-26	12675	12765	12640	12740	2824600
2000-01-27	13000	13125	12900	13125	4050800
2000-01-28	13225	13675	13155	13545	4751600
2000-01-31	13345	13750	13250	13480	3577600
2000-02-01	13750	13750	13450	13565	3635000
2000-02-02	13760	14075	13725	13775	5774400
2000-02-03	14070	14125	13980	14050	3788400
2000-02-04	14450	14795	14450	14590	5649200
2000-02-07	14990	14995	14750	14990	4387600
2000-02-08	15000	15000	14355	14575	4325800
2000-02-09	14875	14925	14775	14785	4288400
2000-02-10	14485	14500	14205	14355	4912600
2000-02-14	14055	14225	14000	14000	3344600
2000-02-15	14070	14220	13975	14005	3452800
2000-02-16	13980	14005	13690	13950	2979000
2000-02-17	13900	14740	13760	14450	5008000
2000-02-18	14650	14890	14575	14825	4117200
2000-02-21	15000	15825	14975	15825	8291200
2000-02-22	16575	16625	15050	15175	8647800
2000-02-23	15125	15300	14680	15000	4384800
2000-02-24	15300	15375	14935	14985	3679000
2000-02-25	15175	15425	15000	15425	3796600
2000-02-28	15400	15775	15325	15500	4587000
2000-02-29	15800	16450	15750	16250	7754800
2000-03-01	16850	16950	16250	16300	7444200
2000-03-02	16450	16475	15975	16150	4291200
2000-03-03	15700	15950	15425	15500	4125000
2000-03-06	15650	15725	14510	14775	5686000
2000-03-07	14375	14690	14275	14520	5708400
2000-03-08	14150	14625	14070	14430	3867600
2000-03-09	14450	14665	14010	14050	3930800
2000-03-10	14050	14085	13050	13150	11500000
2000-03-13	12550	12590	12150	12150	4662400
2000-03-14	11950	12920	11950	12695	7516800
2000-03-15	12795	13475	12715	13375	5718200
2000-03-16	13475	13660	13155	13505	3889800
2000-03-17	13405	13405	13035	13320	4767600
2000-03-21	13250	13250	12880	12975	4105000
2000-03-22	12875	13350	12850	13190	4272600
2000-03-23	13195	13195	12880	12935	3825200
2000-03-24	13025	13075	12850	12850	4521200
2000-03-27	12900	13340	12350	13200	10937200
2000-03-28	13000	13450	12600	13120	6840000
2000-03-29	13300	13840	13300	13730	5632000
2000-03-30	13920	14880	13800	14500	8860000
2000-03-31	14300	14820	14050	14500	4130100
2000-04-03	14490	15100	14360	15000	5948200
2000-04-04	14920	14930	14570	14760	3046100
2000-04-05	14360	14440	14060	14250	4283300
2000-04-06	14250	14330	13810	14060	2975500
2000-04-07	14200	14250	13900	14020	2619200
2000-04-10	14420	14580	14350	14570	2759100
2000-04-11	14370	14460	14170	14250	2040900
2000-04-12	14020	14120	13940	14110	2316600
2000-04-13	13700	13770	13300	13450	3465000
2000-04-14	13180	13630	13070	13280	4223000
2000-04-17	11880	12200	11450	12040	6895300
2000-04-18	12440	12650	12200	12380	4006400
2000-04-19	12580	12670	12400	12590	3091000
2000-04-20	12600	12930	12510	12580	4359300
2000-04-21	12780	12870	12280	12300	5009100
2000-04-24	12690	12800	12520	12700	2721400
2000-04-25	12700	12740	12450	12700	2792900
2000-04-26	12850	12850	12520	12750	2296900
2000-04-27	12560	12650	12450	12480	2388400
2000-04-28	12500	12570	12190	12410	2654000
2000-05-01	12210	12640	12110	12580	2800500
2000-05-02	12660	12700	12380	12500	1980100
2000-05-08	12480	12480	12110	12170	3288100
2000-05-09	11900	11960	11700	11700	3835200
2000-05-10	11600	11920	11490	11810	3228500
2000-05-11	11550	11600	11320	11440	3567000
2000-05-12	11700	11790	11600	11690	2880200
2000-05-15	11710	11790	11630	11720	1318200
2000-05-16	11720	11740	11580	11670	1295800
2000-05-17	11800	11850	11710	11770	1322300
2000-05-18	11670	11670	11380	11490	2024300
2000-05-19	11090	11190	10700	10830	3823300
2000-05-22	10230	10340	10010	10280	3968200
2000-05-23	10080	10310	9900	10000	5788700
2000-05-24	9700	9750	9260	9490	5688800
2000-05-25	9990	10350	9970	10080	4601700
2000-05-26	9780	9860	9490	9680	4642000
2000-05-29	9780	10330	9720	10100	4685800
2000-05-30	10080	10100	9880	9970	1593100
2000-05-31	10160	10160	9520	9750	4063000
2000-06-01	9550	9750	9490	9750	3822500
2000-06-02	9950	10300	9910	10290	4033000
2000-06-05	10890	11150	10720	11120	4938100
2000-06-06	11090	11100	10910	11100	2406400
2000-06-07	10900	11010	10850	11000	1833200
2000-06-08	11000	11060	10740	10750	2194500
2000-06-09	10550	10850	10500	10680	3207600
2000-06-12	10560	10610	10460	10590	1214600
2000-06-13	10400	10560	10170	10280	1855500
2000-06-14	10050	10070	9780	9850	3575700
2000-06-15	9600	9700	9410	9550	4737500
2000-06-16	9550	9780	9490	9660	3236300
2000-06-19	9670	9720	9510	9700	2385400
2000-06-20	9800	9950	9780	9800	2047900
2000-06-21	9970	10090	9900	10010	2370400
2000-06-22	10200	10360	10050	10150	3293500
2000-06-23	10000	10080	9920	9990	2109800
2000-06-26	9890	9890	9680	9850	1850900
2000-06-27	9870	9930	9780	9910	1501900
2000-06-28	9910	9920	9780	9890	1583700
2000-06-29	10080	10230	10020	10100	1743800
2000-06-30	10000	10060	9850	9900	1281200
2000-07-03	9930	10350	9930	10340	1772800
2000-07-04	10500	10520	10220	10420	1753400
2000-07-05	10610	10710	10480	10600	1825500
2000-07-06	10580	10870	10360	10750	2485600
2000-07-07	11000	11100	10900	10980	3344000
2000-07-10	11150	11250	11110	11180	2841300
2000-07-11	11000	11130	10840	10900	2072400
2000-07-12	11050	11080	10820	10820	1612200
2000-07-13	10650	10750	10500	10560	1759700
2000-07-14	10720	10910	10650	10900	1744400
2000-07-17	11100	11260	11000	11170	1850200
2000-07-18	11200	11200	10770	10910	1590600
2000-07-19	10660	11070	10640	10950	2002400
2000-07-21	10950	10950	10610	10680	1620200
2000-07-24	10500	10550	10300	10490	1409100
2000-07-25	10290	10460	10250	10450	2617500
2000-07-26	10610	10840	10510	10710	1823000
2000-07-27	10520	10580	10250	10360	2592000
2000-07-28	10160	10210	9940	10180	2469200
2000-07-31	9880	10270	9850	10070	2572800
2000-08-01	10250	10340	9990	10040	2833500
2000-08-02	10180	10500	10120	10400	2321100
2000-08-03	10120	10180	9980	10030	2549800
2000-08-04	9950	10020	9850	9900	3709700
2000-08-07	10000	10160	9920	10150	1935200
2000-08-08	10200	10240	9960	10090	1644100
2000-08-09	10000	10050	9910	10050	2008200
2000-08-10	10030	10090	10020	10090	1746300
2000-08-11	10040	10280	10040	10200	2379000
2000-08-14	10200	10280	10100	10190	1016400
2000-08-15	10350	10600	10310	10550	2846600
2000-08-16	10630	10740	10510	10640	1962600
2000-08-17	10570	10690	10460	10580	1218400
2000-08-18	10580	10630	10510	10610	1161400
2000-08-21	10500	10570	10320	10430	925200
2000-08-22	10320	10430	10150	10430	1392400
2000-08-23	10500	10640	10450	10540	1990600
2000-08-24	10580	10880	10550	10800	2428800
2000-08-25	11000	11100	10930	11100	3107900
2000-08-28	11400	12030	11300	11890	6642900
2000-08-29	11950	11990	11750	11850	3012600
2000-08-30	11850	11940	11500	11530	2032400
2000-08-31	11730	11900	11630	11900	2583900
2000-09-01	12000	12140	11860	11990	3088400
2000-09-04	12000	12030	11870	11900	1297600
2000-09-05	11800	11840	11530	11620	2077100
2000-09-06	11420	11580	11330	11330	2236100
2000-09-07	11340	11460	11280	11340	1836000
2000-09-08	11600	11740	11500	11680	3613600
2000-09-11	11600	11850	11570	11700	2077000
2000-09-12	11550	11700	11510	11650	1562200
2000-09-13	11460	11690	11460	11650	1581500
2000-09-14	11700	11750	11370	11430	1758600
2000-09-18	11430	11880	11400	11750	2397600
2000-09-19	11550	11990	11520	11940	2791000
2000-09-20	12000	12370	11960	12260	4413400
2000-09-21	12300	12480	12200	12480	3275900
2000-09-22	12000	12090	11760	11830	2898500
2000-09-25	12030	12140	11700	11840	1495700
2000-09-26	11850	11950	11630	11800	1215200
2000-09-27	11500	11550	11350	11370	2018400
2000-09-28	10970	11110	10630	10640	3089900
2000-09-29	11000	11120	10900	10960	3227400
2000-10-02	10660	10800	10480	10800	3041400
2000-10-03	10750	10840	10670	10690	1977800
2000-10-04	10500	10870	10500	10760	1806000
2000-10-05	10770	10800	10560	10650	2097200
2000-10-06	10650	10870	10650	10740	1645700
2000-10-10	10540	10680	10540	10650	1816200
2000-10-11	10450	10460	10240	10280	2369900
2000-10-12	10090	10240	10050	10150	2373900
2000-10-13	10000	10110	9990	10050	2688100
2000-10-16	10200	10270	10010	10080	2389200
2000-10-17	10010	10090	9990	10010	2055300
2000-10-18	9800	9840	9540	9610	4312000
2000-10-19	9710	9820	9690	9770	2091500
2000-10-20	10370	10550	10250	10470	4420200
2000-10-23	10470	10490	10180	10280	1819600
2000-10-24	10250	10430	10160	10380	1548000
2000-10-25	10580	10680	10410	10410	2563500
2000-10-26	10210	10420	10150	10350	1817500
2000-10-27	9900	9950	9480	9570	6123000
2000-10-30	9370	9430	9090	9190	4445200
2000-10-31	9000	9020	8620	8720	5410300
2000-11-01	9050	9290	9030	9250	3377000
2000-11-02	9050	9060	8920	8990	3703900
2000-11-06	9140	9360	9100	9360	2616600
2000-11-07	9340	9340	9080	9140	2196800
2000-11-08	9080	9350	9060	9230	2094400
2000-11-09	9060	9150	9030	9060	1952800
2000-11-10	8950	9000	8830	8850	2807100
2000-11-13	8510	8540	8410	8470	3254900
2000-11-14	8470	8530	8360	8470	2837900
2000-11-15	8770	8780	8510	8520	2694900
2000-11-16	8500	8530	8320	8340	2946800
2000-11-17	8250	8480	8100	8230	3574100
2000-11-20	8130	8190	8070	8120	2060500
2000-11-21	8000	8010	7820	7940	3808600
2000-11-22	8040	8120	7990	8040	3239400
2000-11-24	8140	8200	8050	8170	2609600
2000-11-27	8470	8960	8420	8800	3672200
2000-11-28	8900	8980	8790	8930	2349000
2000-11-29	8710	8730	8400	8510	2770800
2000-11-30	8310	8420	8190	8360	3052600
2000-12-01	8290	8350	8160	8240	2832400
2000-12-04	8300	8630	8290	8540	2785400
2000-12-05	8610	8640	8420	8450	1685700
2000-12-06	8850	8920	8730	8800	3083200
2000-12-07	8740	8740	8570	8670	1281500
2000-12-08	8550	8600	8420	8540	4049500
2000-12-11	8800	8980	8760	8980	2551800
2000-12-12	8960	9040	8830	8900	2962400
2000-12-13	8800	9010	8660	8980	2288800
2000-12-14	8780	8870	8700	8790	2120700
2000-12-15	8540	8630	8330	8340	2641200
2000-12-18	8240	8440	8240	8400	2022700
2000-12-19	8350	8370	8230	8300	1472600
2000-12-20	8100	8160	8010	8100	2749300
2000-12-21	7830	7920	7570	7770	3744500
2000-12-22	7800	7860	7510	7560	3149800
2000-12-25	7760	7900	7710	7900	1906000
2000-12-26	7880	7990	7830	7900	1330400
2000-12-27	7880	7930	7770	7900	1017400
2000-12-28	8000	8110	7950	8000	1693000
2000-12-29	8070	8070	7900	7900	702300
2001-01-04	8300	8430	8200	8230	2575900
2001-01-05	8430	8600	8410	8600	3954400
2001-01-09	8700	8710	8530	8690	3687100
2001-01-10	8740	8820	8700	8700	2911100
2001-01-11	8750	8770	8400	8620	2850400
2001-01-12	8630	8830	8630	8800	3763700
2001-01-15	8900	9050	8850	8980	3690900
2001-01-16	9020	9060	8830	8930	3052000
2001-01-17	8830	8990	8730	8920	2032600
2001-01-18	9050	9160	8770	8850	3063300
2001-01-19	8980	9120	8870	9080	3707400
2001-01-22	8990	9050	8750	8870	2460100
2001-01-23	8720	8850	8630	8750	2117100
2001-01-24	8750	8850	8530	8580	2647200
2001-01-25	8500	8590	8350	8510	2416500
2001-01-26	8500	8730	8470	8570	2365300
2001-01-29	8550	8630	8490	8590	1487700
2001-01-30	8560	8610	8380	8460	2098900
2001-01-31	8360	8460	8290	8450	1442600
2001-02-01	8330	8440	8260	8440	2096600
2001-02-02	8340	8370	8150	8160	2591300
2001-02-05	8000	8120	7990	8040	2597000
2001-02-06	8040	8260	8040	8160	2427100
2001-02-07	8060	8440	8060	8320	2644900
2001-02-08	8400	8510	8270	8450	3204700
2001-02-09	8550	8640	8510	8550	3469600
2001-02-13	8650	8700	8480	8550	2634500
2001-02-14	8450	8500	8230	8360	2296600
2001-02-15	8380	8480	8370	8440	1484100
2001-02-16	8340	8420	8260	8300	2087200
2001-02-19	8200	8340	8180	8340	1482700
2001-02-20	8240	8310	8230	8270	1442800
2001-02-21	8170	8220	8080	8150	1840300
2001-02-22	8040	8220	8000	8180	2035000
2001-02-23	8160	8450	8160	8360	1733000
2001-02-26	8390	8640	8370	8520	2635900
2001-02-27	8620	8770	8560	8580	2683600
2001-02-28	8380	8450	8350	8450	1885900
2001-03-01	8250	8320	8150	8220	2946400
2001-03-02	8150	8360	8050	8130	3407800
2001-03-05	8100	8160	8050	8150	1942000
2001-03-06	8240	8360	8210	8360	1824800
2001-03-07	8560	8570	8310	8480	2834400
2001-03-08	8580	8650	8530	8550	3126700
2001-03-09	8350	8520	8340	8490	4026300
2001-03-12	8390	8420	8220	8330	2218500
2001-03-13	8060	8190	8060	8100	3991500
2001-03-14	8130	8210	8080	8120	3042200
2001-03-15	8000	8170	8000	8160	3062700
2001-03-16	8260	8600	8250	8440	3119300
2001-03-19	8340	8620	8200	8270	2214800
2001-03-21	8310	8590	8300	8580	2875900
2001-03-22	8510	8880	8510	8710	3524900
2001-03-23	8880	9070	8840	9000	4713000
2001-03-26	9060	9290	9060	9290	3921500
2001-03-27	9270	9560	9170	9370	4022700
2001-03-28	9470	9480	9240	9350	2272700
2001-03-29	9120	9150	8920	8970	2311200
2001-03-30	8990	9050	8810	8900	2341800
2001-04-02	8810	8930	8610	8890	3125700
2001-04-03	8700	8870	8680	8740	2111000
2001-04-04	8550	8700	8510	8700	2552200
2001-04-05	8760	8950	8740	8890	2199500
2001-04-06	9140	9140	8900	8900	2255400
2001-04-09	8800	8810	8600	8600	1674200
2001-04-10	8570	8640	8420	8450	1919200
2001-04-11	8560	8680	8490	8660	2399600
2001-04-12	8700	8840	8650	8720	2033400
2001-04-13	8820	8950	8530	8630	2172500
2001-04-16	8570	8710	8520	8670	996800
2001-04-17	8680	8840	8610	8770	1828600
2001-04-18	8900	9000	8840	8960	2896000
2001-04-19	9360	9380	9140	9250	3760100
2001-04-20	9200	9280	9050	9170	1912300
2001-04-23	9120	9270	8990	8990	1842600
2001-04-24	8850	8980	8770	8930	1751100
2001-04-25	9050	9260	9010	9030	1972300
2001-04-26	9230	9250	9100	9150	2347400
2001-04-27	9250	9270	9130	9240	1772000
2001-05-01	9440	9520	9360	9520	4080800
2001-05-02	9720	9830	9650	9790	5830400
2001-05-07	9890	9950	9790	9930	5215900
2001-05-08	9890	10000	9840	9990	4565200
2001-05-09	9990	9990	9670	9770	3792400
2001-05-10	9670	9800	9670	9740	1606100
2001-05-11	9780	9920	9770	9880	2605900
2001-05-14	9710	9750	9450	9630	2700000
2001-05-15	9480	9720	9420	9690	1903100
2001-05-16	9710	9930	9700	9700	2060100
2001-05-17	9870	9980	9820	9980	2908100
2001-05-18	9970	10050	9910	9960	3277800
2001-05-21	10000	10170	9970	10170	2887500
2001-05-22	10300	10340	10120	10150	3166500
2001-05-23	10100	10250	10070	10200	1805400
2001-05-24	9900	9970	9850	9950	2193200
2001-05-25	10000	10160	9970	10000	1916900
2001-05-28	9880	9940	9730	9750	1448600
2001-05-29	9700	9860	9700	9810	908100
2001-05-30	9610	9660	9350	9400	2915700
2001-05-31	9200	9360	9130	9170	2522600
2001-06-01	9370	9420	9260	9300	1449400
2001-06-04	9400	9440	9320	9370	1074700
2001-06-05	9210	9270	9060	9260	2686800
2001-06-06	9400	9440	9160	9270	1682700
2001-06-07	9200	9210	9090	9140	1689500
2001-06-08	9080	9280	9060	9210	5306300
2001-06-11	9200	9220	9110	9180	1181000
2001-06-12	9060	9100	8800	8800	2345200
2001-06-13	8830	8980	8810	8840	2522800
2001-06-14	8860	8940	8810	8850	1243100
2001-06-15	8750	8810	8600	8780	2542100
2001-06-18	8730	8790	8620	8660	1693800
2001-06-19	8760	8940	8730	8760	2198100
2001-06-20	8750	8840	8640	8660	2003800
2001-06-21	8750	8750	8500	8610	2502500
2001-06-22	8650	8850	8650	8690	2360200
2001-06-25	8590	8640	8320	8380	3106200
2001-06-26	8280	8350	8150	8180	4090800
2001-06-27	8190	8360	8170	8190	3147100
2001-06-28	8220	8230	8020	8100	3122100
2001-06-29	8220	8260	8120	8200	2548800
2001-07-02	8280	8280	8100	8150	1823600
2001-07-03	8200	8220	7960	7980	3328100
2001-07-04	7950	7960	7780	7800	3762500
2001-07-05	7600	7670	7530	7590	5513100
2001-07-06	7450	7460	7200	7250	6923200
2001-07-09	7100	7190	7030	7150	5770100
2001-07-10	7130	7350	7080	7240	7196400
2001-07-11	7130	7160	7010	7010	5351900
2001-07-12	7210	7420	7200	7420	4240000
2001-07-13	7520	7550	7200	7380	5382500
2001-07-16	7380	7450	7320	7400	1687100
2001-07-17	7280	7320	7240	7270	2903000
2001-07-18	7220	7250	6990	7000	6418700
2001-07-19	7020	7180	7020	7160	4276100
2001-07-23	7190	7190	6930	7020	3802900
2001-07-24	7060	7110	6930	7060	3624700
2001-07-25	7080	7240	7060	7120	3409900
2001-07-26	7130	7140	6930	7070	3817000
2001-07-27	6370	6430	6080	6260	16181400
2001-07-30	6200	6230	5780	5830	10276000
2001-07-31	5960	6190	5940	6150	6913200
2001-08-01	6250	6310	6060	6200	5977300
2001-08-02	6310	6510	6200	6500	5388000
2001-08-03	6460	6560	6290	6360	3118200
2001-08-06	6280	6370	6250	6300	2514000
2001-08-07	6240	6430	6200	6410	2296200
2001-08-08	6400	6440	6340	6410	1380700
2001-08-09	6260	6280	6120	6130	2460000
2001-08-10	6120	6250	6100	6120	2507800
2001-08-13	6120	6150	5990	6000	3072600
2001-08-14	6050	6200	5990	6190	2734100
2001-08-15	6200	6340	6080	6320	2316100
2001-08-16	6020	6060	5950	6010	3458200
2001-08-17	5960	6000	5730	5740	5202100
2001-08-20	5640	5820	5620	5740	3883500
2001-08-21	5720	5740	5460	5580	7212400
2001-08-22	5620	5840	5590	5790	3620600
2001-08-23	5790	5800	5510	5550	4113300
2001-08-24	5700	5710	5500	5600	2482800
2001-08-27	5700	5830	5680	5690	2573800
2001-08-28	5790	5800	5650	5790	2105800
2001-08-29	5690	5780	5670	5690	1856000
2001-08-30	5690	5690	5500	5590	3136300
2001-08-31	5450	5450	5230	5290	5722600
2001-09-03	5190	5210	5030	5060	4216300
2001-09-04	5160	5290	5040	5280	5336100
2001-09-05	5180	5230	5100	5160	3835500
2001-09-06	5160	5310	5100	5230	2913100
2001-09-07	5030	5110	4960	5050	5178100
2001-09-10	4960	5040	4940	4950	4267500
2001-09-11	4950	5010	4890	4980	4831700
2001-09-12	4730	4730	4730	4730	533800
2001-09-13	4680	4770	4480	4480	8777400
2001-09-14	4430	4610	4410	4580	8296000
2001-09-17	4400	4410	4080	4210	6240700
2001-09-18	4310	4360	4260	4260	6613600
2001-09-19	4340	4540	4320	4480	4696400
2001-09-20	4350	4490	4300	4450	3847900
2001-09-21	4250	4300	4180	4220	5449000
2001-09-25	4470	4550	4300	4390	5906300
2001-09-26	4400	4420	4310	4350	3113900
2001-09-27	4300	4420	4290	4390	2820300
2001-09-28	4400	4450	4340	4390	4573900
2001-10-01	4040	4160	3970	4100	7589400
2001-10-02	4000	4080	4000	4050	6910700
2001-10-03	4100	4120	3960	3980	7500200
2001-10-04	4130	4250	4070	4250	5781300
2001-10-05	4300	4440	4230	4380	5434300
2001-10-09	4210	4270	4170	4210	4453400
2001-10-10	4240	4400	4190	4320	3800200
2001-10-11	4520	4820	4500	4820	9259400
2001-10-12	4970	5120	4940	5060	10634400
2001-10-15	4910	4940	4830	4850	4729100
2001-10-16	4800	4970	4750	4900	4426400
2001-10-17	5000	5100	4930	5050	5403800
2001-10-18	4910	5020	4910	4930	4084300
2001-10-19	4920	5090	4870	5040	4700900
2001-10-22	5020	5100	5000	5000	2183900
2001-10-23	5100	5150	5050	5150	3743000
2001-10-24	5080	5080	4940	4950	5768800
2001-10-25	4950	4950	4670	4780	6310900
2001-10-26	5030	5050	4920	4930	4916900
2001-10-29	4980	4990	4810	4880	2080500
2001-10-30	4780	4830	4690	4750	3323200
2001-10-31	4610	4720	4610	4630	2258400
2001-11-01	4680	4760	4620	4660	2611100
2001-11-02	4760	4810	4720	4780	3285400
2001-11-05	4830	4980	4830	4940	2971700
2001-11-06	5000	5020	4950	4980	3628000
2001-11-07	4980	4990	4710	4710	2873700
2001-11-08	4790	4850	4700	4820	2398500
2001-11-09	4870	4880	4750	4760	2713200
2001-11-12	4800	4870	4780	4810	2200300
2001-11-13	4780	4820	4760	4800	1978400
2001-11-14	4950	4970	4860	4920	2587500
2001-11-15	4980	5420	4980	5400	10210000
2001-11-16	5540	5740	5480	5710	9482500
2001-11-19	5790	5940	5750	5830	6195600
2001-11-20	5860	5870	5610	5650	3608700
2001-11-21	5530	5770	5510	5740	3274700
2001-11-22	5640	5690	5560	5690	2198900
2001-11-26	5840	5940	5770	5900	5448700
2001-11-27	5950	6140	5880	6010	10336600
2001-11-28	5910	5990	5830	5830	3991000
2001-11-29	5730	5790	5660	5750	3922200
2001-11-30	5830	5860	5760	5810	2416400
2001-12-03	5840	5840	5630	5710	3340400
2001-12-04	5680	5850	5640	5850	3938900
2001-12-05	5920	5990	5800	5960	3134900
2001-12-06	6180	6230	6080	6200	6213400
2001-12-07	6200	6260	6080	6140	3943600
2001-12-10	6090	6120	5970	6030	3704800
2001-12-11	5880	5900	5790	5840	3122200
2001-12-12	5900	6080	5870	6030	3231800
2001-12-13	5960	5990	5870	5880	2631300
2001-12-14	5800	5880	5720	5800	7590100
2001-12-17	5800	5850	5700	5730	2141500
2001-12-18	5900	5970	5860	5950	3194400
2001-12-19	5960	6020	5930	5960	3127000
2001-12-20	5970	5990	5880	5970	2941200
2001-12-21	5810	5920	5640	5690	3874500
2001-12-25	5700	5730	5500	5580	3355000
2001-12-26	5630	5640	5570	5600	1731500
2001-12-27	5700	5870	5660	5820	2582300
2001-12-28	5920	6000	5860	5990	2296200
2002-01-04	6290	6460	6280	6420	6214700
2002-01-07	6400	6510	6380	6470	3984200
2002-01-08	6370	6420	6310	6360	3732700
2002-01-09	6350	6450	6300	6390	3671300
2002-01-10	6440	6700	6420	6550	7831200
2002-01-11	6520	6550	6340	6400	3773600
2002-01-15	6030	6110	6030	6050	4279500
2002-01-16	6000	6000	5920	5930	3146900
2002-01-17	5930	5970	5830	5900	2541400
2002-01-18	5990	6040	5900	5990	3148000
2002-01-21	5890	5930	5840	5890	3067300
2002-01-22	5910	5960	5820	5820	2340400
2002-01-23	5850	6040	5830	5940	3601600
2002-01-24	6040	6150	5840	6080	4682600
2002-01-25	6200	6220	6110	6200	2927200
2002-01-28	6190	6250	5980	6040	5225200
2002-01-29	5940	6010	5900	5920	3202400
2002-01-30	5790	5820	5730	5790	2906900
2002-01-31	5830	5890	5760	5870	2491100
2002-02-01	5970	5980	5810	5810	3007100
2002-02-04	5780	5840	5770	5810	2062200
2002-02-05	5650	5750	5580	5600	4232600
2002-02-06	5540	5680	5530	5540	2850900
2002-02-07	5560	5780	5520	5720	2925000
2002-02-08	5670	5830	5640	5710	3461700
2002-02-12	5890	5900	5830	5900	2548200
2002-02-13	5860	5960	5830	5920	3441000
2002-02-14	5980	6130	5970	6050	4790400
2002-02-15	6040	6070	5950	6030	2456700
2002-02-18	5960	6090	5900	6040	1784800
2002-02-19	6290	6300	6150	6150	4491000
2002-02-20	6050	6100	6000	6000	2542800
2002-02-21	6080	6270	6070	6260	3701100
2002-02-22	6200	6300	6140	6270	3110900
2002-02-25	6300	6310	6200	6200	1887300
2002-02-26	6290	6300	6140	6200	2133200
2002-02-27	6240	6330	6210	6300	2969300
2002-02-28	6340	6370	6080	6080	3916700
2002-03-01	6210	6310	6180	6270	3194000
2002-03-04	6360	6530	6350	6530	5280600
2002-03-05	6690	6690	6560	6590	3951600
2002-03-06	6650	6890	6640	6880	5951300
2002-03-07	7000	7320	7000	7200	11113500
2002-03-08	7200	7240	7090	7160	7560400
2002-03-11	7250	7280	7120	7200	2943600
2002-03-12	7020	7100	6970	6970	3127600
2002-03-13	6910	7070	6830	6830	3272600
2002-03-14	6890	7090	6800	7090	4366200
2002-03-15	7180	7230	7080	7140	3029300
2002-03-18	7150	7170	6920	6920	2809500
2002-03-19	7000	7210	6990	7170	3535200
2002-03-20	7200	7230	6880	6890	4845100
2002-03-22	6910	7020	6880	6930	2561000
2002-03-25	6850	6880	6690	6770	2758600
2002-03-26	6710	6920	6660	6740	3091400
2002-03-27	6830	6870	6700	6770	2534500
2002-03-28	6860	6890	6750	6890	2124000
2002-03-29	6840	6910	6680	6700	2026000
2002-04-01	6750	6820	6700	6700	1517100
2002-04-02	6800	6950	6760	6930	2309900
2002-04-03	6830	7050	6800	7000	3028000
2002-04-04	7030	7050	6950	6980	2848900
2002-04-05	6860	6910	6760	6770	3196400
2002-04-08	6800	6960	6780	6910	1574400
2002-04-09	6830	6900	6760	6760	1953600
2002-04-10	6710	6930	6710	6800	2357900
2002-04-11	6860	6920	6820	6820	1629900
2002-04-12	6720	6800	6710	6710	3340600
2002-04-15	6750	6800	6720	6790	2294600
2002-04-16	6810	6890	6760	6890	2241300
2002-04-17	6970	7060	6950	7050	3906900
2002-04-18	7010	7120	6980	7100	5822700
2002-04-19	6920	6960	6820	6930	4145000
2002-04-22	6950	7150	6950	7150	3032400
2002-04-23	7050	7120	7010	7040	2541200
2002-04-24	7040	7080	6950	7020	2511900
2002-04-25	7090	7180	7060	7150	3406700
2002-04-26	7200	7300	7150	7200	7491300
2002-04-30	7100	7110	6860	6900	4854900
2002-05-01	6910	7000	6890	6910	3107100
2002-05-02	6940	6950	6850	6850	1954600
2002-05-07	6800	6820	6730	6820	3248700
2002-05-08	6840	6950	6840	6850	2537700
2002-05-09	7020	7060	6950	7000	3143100
2002-05-10	6980	7040	6940	7000	2022800
2002-05-13	6920	6930	6860	6870	1643200
2002-05-14	6970	7030	6940	6960	1926400
2002-05-15	7060	7150	7040	7150	2755000
2002-05-16	7160	7180	7070	7160	2243600
2002-05-17	7200	7300	7190	7260	3656600
2002-05-20	7310	7340	7230	7250	2247800
2002-05-21	7210	7230	7130	7190	1447800
2002-05-22	7250	7310	7120	7270	3422200
2002-05-23	7350	7390	7300	7390	3355600
2002-05-24	7430	7450	7380	7450	4189700
2002-05-27	7450	7460	7330	7330	1669100
2002-05-28	7320	7320	7210	7280	1865400
2002-05-29	7180	7270	7170	7210	1756800
2002-05-30	7140	7220	7090	7210	2169600
2002-05-31	7110	7200	7020	7200	2708700
2002-06-03	7170	7170	7080	7140	2577500
2002-06-04	7010	7040	6860	6880	3971600
2002-06-05	6950	7050	6930	6970	2397500
2002-06-06	7070	7090	6950	6970	2781900
2002-06-07	6820	6920	6810	6910	3138700
2002-06-10	6860	6930	6800	6800	1457700
2002-06-11	6780	6840	6730	6770	2419100
2002-06-12	6780	6950	6750	6950	2659300
2002-06-13	6870	6880	6710	6710	3614400
2002-06-14	6700	6700	6560	6560	5989100
2002-06-17	6460	6490	6360	6420	4446900
2002-06-18	6490	6600	6420	6480	4935000
2002-06-19	6410	6500	6230	6290	4223300
2002-06-20	6210	6280	6060	6280	5004000
2002-06-21	6080	6120	6000	6020	4446500
2002-06-24	5960	6180	5910	6150	4118200
2002-06-25	6100	6270	6080	6100	4044100
2002-06-26	5950	5980	5800	5810	5213200
2002-06-27	5960	6100	5930	6030	4686600
2002-06-28	6150	6330	6130	6330	3981700
2002-07-01	6230	6260	6150	6190	2468100
2002-07-02	6150	6190	5990	6190	4555000
2002-07-03	6020	6300	6020	6240	4572300
2002-07-04	6140	6190	6030	6050	4139900
2002-07-05	6100	6170	6090	6150	2380800
2002-07-08	6350	6360	6180	6180	3941300
2002-07-09	6220	6320	6160	6300	2898500
2002-07-10	6200	6230	6100	6100	3242500
2002-07-11	6000	6030	5960	5990	3580900
2002-07-12	6090	6110	6040	6040	3652600
2002-07-15	5970	5980	5880	5880	2857100
2002-07-16	5840	5910	5800	5800	4127900
2002-07-17	5750	5760	5470	5560	8632700
2002-07-18	5650	5800	5630	5800	5412200
2002-07-19	5700	5700	5510	5530	5655800
2002-07-22	5310	5410	5280	5390	6321500
2002-07-23	5250	5460	5210	5420	6676200
2002-07-24	5320	5360	5280	5280	4775400
2002-07-25	5470	5470	5270	5290	4540300
2002-07-26	5310	5390	5270	5280	8526500
2002-07-29	5370	5470	5310	5310	4596000
2002-07-30	5550	5600	5500	5570	4704200
2002-07-31	5620	5620	5410	5410	3506300
2002-08-01	5500	5500	5360	5400	3068100
2002-08-02	5310	5310	5170	5220	4889400
2002-08-05	5120	5160	5060	5110	4321600
2002-08-06	5010	5060	4950	4980	5673800
2002-08-07	5230	5310	5200	5280	4252500
2002-08-08	5280	5340	5230	5280	2534600
2002-08-09	5320	5380	5250	5380	4783900
2002-08-12	5240	5260	5130	5130	2687100
2002-08-13	5100	5190	5050	5070	3211600
2002-08-14	5010	5060	5010	5040	2919700
2002-08-15	5100	5200	5060	5070	4587300
2002-08-16	5170	5190	5090	5150	3195100
2002-08-19	5180	5190	5090	5120	3308600
2002-08-20	5250	5290	5190	5280	4612800
2002-08-21	5220	5390	5210	5360	4169300
2002-08-22	5390	5540	5330	5490	5320200
2002-08-23	5580	5600	5540	5550	3764300
2002-08-26	5480	5600	5470	5540	3504900
2002-08-27	5470	5510	5340	5340	3266200
2002-08-28	5430	5450	5290	5350	2834400
2002-08-29	5220	5250	5160	5180	3593100
2002-08-30	5200	5220	5160	5170	3607800
2002-09-02	5110	5140	5080	5100	2641800
2002-09-03	5060	5090	5000	5010	4467600
2002-09-04	4910	4910	4810	4850	5712600
2002-09-05	4920	5040	4900	4940	4815700
2002-09-06	4840	4940	4810	4910	4059400
2002-09-09	5000	5050	4970	4980	2345300
2002-09-10	5030	5190	5030	5100	5253300
2002-09-11	5200	5320	5160	5240	3565300
2002-09-12	5300	5330	5240	5310	3739100
2002-09-13	5200	5210	5080	5110	6150400
2002-09-17	5310	5450	5270	5440	4955200
2002-09-18	5240	5370	5230	5350	3344200
2002-09-19	5510	5570	5350	5350	3997500
2002-09-20	5210	5280	5200	5200	2507900
2002-09-24	5060	5100	5030	5060	3073700
2002-09-25	5030	5060	4980	4980	3193500
2002-09-26	5090	5210	5080	5170	3056400
2002-09-27	5290	5370	5270	5330	2520500
2002-09-30	5230	5260	5090	5110	2692000
2002-10-01	5100	5100	5050	5090	2944600
2002-10-02	5190	5210	5080	5080	2144800
2002-10-03	5100	5140	5030	5030	3472400
2002-10-04	5030	5180	5020	5170	2655500
2002-10-07	5050	5100	5040	5040	2738300
2002-10-08	5040	5150	5030	5100	4177000
2002-10-09	5030	5070	5000	5040	3992200
2002-10-10	4980	4990	4900	4960	3761200
2002-10-11	5040	5080	4990	5020	2385200
2002-10-15	5200	5210	5130	5210	3092300
2002-10-16	5300	5340	5240	5290	3850200
2002-10-17	5300	5390	5300	5370	2541300
2002-10-18	5470	5590	5460	5540	6204700
2002-10-21	5520	5540	5460	5490	2024100
2002-10-22	5460	5470	5300	5300	3140600
2002-10-23	5310	5380	5230	5370	2839400
2002-10-24	5380	5390	5260	5320	1708800
2002-10-25	5350	5450	5340	5390	2654000
2002-10-28	5380	5490	5350	5490	2659600
2002-10-29	5500	5530	5420	5420	3926700
2002-10-30	5320	5430	5300	5370	2453900
2002-10-31	5410	5420	5250	5270	2322400
2002-11-01	5300	5330	5260	5330	2371700
2002-11-05	5490	5530	5440	5500	3143400
2002-11-06	5500	5510	5410	5460	2577000
2002-11-07	5360	5410	5280	5320	3324900
2002-11-08	5220	5230	5150	5190	3319200
2002-11-11	5060	5080	4930	4930	5441900
2002-11-12	4900	4950	4850	4870	5547300
2002-11-13	4940	4980	4870	4870	3481200
2002-11-14	4920	4990	4900	4950	2512400
2002-11-15	5060	5150	5030	5150	4528200
2002-11-18	5100	5120	4950	5000	2633200
2002-11-19	5030	5080	5010	5070	2851300
2002-11-20	5120	5160	5110	5130	2108700
2002-11-21	5200	5210	5130	5200	3080100
2002-11-22	5300	5320	5240	5320	4132200
2002-11-25	5360	5410	5350	5390	3862500
2002-11-26	5380	5390	5300	5380	2649100
2002-11-27	5310	5360	5310	5340	1838100
2002-11-28	5410	5450	5390	5450	3889800
2002-11-29	5450	5490	5420	5420	2645100
2002-12-02	5440	5470	5390	5470	2051100
2002-12-03	5490	5520	5460	5500	3548800
2002-12-04	5400	5430	5310	5310	2770400
2002-12-05	5310	5420	5310	5350	2674900
2002-12-06	5370	5400	5340	5350	3121700
2002-12-09	5360	5400	5300	5300	2433300
2002-12-10	5220	5250	5200	5200	2507900
2002-12-11	5250	5300	5220	5230	1933600
2002-12-12	5210	5220	5160	5200	1937800
2002-12-13	5150	5170	5050	5080	5290500
2002-12-16	5030	5080	5020	5030	3183700
2002-12-17	5100	5110	5060	5070	2644400
2002-12-18	5060	5060	4990	5000	2864300
2002-12-19	4980	5030	4960	5020	3312100
2002-12-20	4990	5010	4980	4990	2916200
2002-12-24	5020	5080	4990	5060	4067600
2002-12-25	5040	5060	5020	5020	3143600
2002-12-26	5050	5120	5050	5100	1861400
2002-12-27	5090	5100	5040	5060	1583300
2002-12-30	4990	5010	4960	4960	1535300
2003-01-06	5110	5110	5010	5030	1974500
2003-01-07	5130	5130	5020	5030	2573000
2003-01-08	5040	5050	4960	4980	2319500
2003-01-09	4960	5050	4940	5050	2571800
2003-01-10	5080	5120	5060	5110	3714000
2003-01-14	5100	5110	5030	5060	2176500
2003-01-15	5050	5050	4970	5000	3507000
2003-01-16	4970	4990	4960	4990	2534800
2003-01-17	4970	5040	4960	5020	2862800
2003-01-20	5000	5030	4980	5010	3139800
2003-01-21	5000	5100	4970	5090	3716600
2003-01-22	5020	5050	4990	5000	3559000
2003-01-23	5020	5060	4980	5060	4032800
2003-01-24	5030	5040	4980	5000	3662300
2003-01-27	4920	4940	4900	4910	3361700
2003-01-28	4880	4890	4820	4850	5025600
2003-01-29	4840	4850	4750	4760	4907900
2003-01-30	4770	4850	4750	4770	4719100
2003-01-31	4770	4770	4620	4710	5467400
2003-02-03	4720	4810	4660	4800	3467800
2003-02-04	4820	4840	4730	4740	3041300
2003-02-05	4670	4720	4660	4690	4207400
2003-02-06	4700	4740	4650	4660	2643700
2003-02-07	4650	4670	4620	4650	2602500
2003-02-10	4600	4670	4600	4650	1918300
2003-02-12	4670	4720	4660	4700	2899700
2003-02-13	4650	4690	4600	4620	3179100
2003-02-14	4630	4690	4620	4650	3714100
2003-02-17	4700	4760	4690	4710	3379000
2003-02-18	4710	4730	4640	4660	2424100
2003-02-19	4710	4750	4700	4720	3237300
2003-02-20	4690	4720	4640	4690	2269200
2003-02-21	4650	4670	4570	4590	2768600
2003-02-24	4600	4600	4570	4580	1519100
2003-02-25	4520	4550	4450	4460	3929800
2003-02-26	4430	4550	4430	4500	4319600
2003-02-27	4470	4520	4450	4470	3413500
2003-02-28	4500	4510	4450	4490	2460300
2003-03-03	4500	4520	4470	4510	2057700
2003-03-04	4480	4490	4450	4480	1508500
2003-03-05	4430	4460	4420	4430	1696200
2003-03-06	4400	4410	4320	4330	4025400
2003-03-07	4260	4290	4220	4250	5035600
2003-03-10	4270	4290	4180	4200	5369500
2003-03-11	4100	4160	4070	4080	4891100
2003-03-12	4120	4180	4110	4160	4117100
2003-03-13	4150	4170	4110	4110	3329800
2003-03-14	4280	4320	4250	4290	7405700
2003-03-17	4310	4320	4230	4240	2393100
2003-03-18	4410	4430	4340	4340	4277200
2003-03-19	4360	4360	4270	4350	2535200
2003-03-20	4450	4490	4420	4480	3460600
2003-03-24	4580	4600	4530	4560	3378900
2003-03-25	4510	4510	4440	4450	2360700
2003-03-26	4460	4500	4450	4460	2368100
2003-03-27	4460	4510	4450	4490	1772300
2003-03-28	4500	4500	4360	4400	2650900
2003-03-31	4300	4310	4190	4200	3132200
2003-04-01	4100	4160	4100	4110	4516700
2003-04-02	4150	4170	4080	4150	3529700
2003-04-03	4240	4240	4140	4160	3132400
2003-04-04	4170	4170	4040	4140	4614600
2003-04-07	4180	4210	4100	4190	4831000
2003-04-08	4140	4150	4090	4120	4321900
2003-04-09	4020	4080	4000	4020	6672900
2003-04-10	4000	4000	3870	3910	7103300
2003-04-11	3860	3890	3750	3770	8369900
2003-04-14	3820	3850	3780	3810	4690400
2003-04-15	3880	3940	3870	3910	4849900
2003-04-16	3960	3990	3930	3950	3470400
2003-04-17	3910	3940	3870	3890	2776900
2003-04-18	3920	3940	3860	3880	2995900
2003-04-21	3850	3880	3800	3870	3555400
2003-04-22	3860	3870	3750	3790	4049700
2003-04-23	3800	3800	3640	3700	7805400
2003-04-24	3750	3780	3640	3720	7982700
2003-04-25	3220	3220	3220	3220	1986500
2003-04-28	2720	2770	2720	2720	34982300
2003-04-30	2845	2915	2835	2900	23292200
2003-05-01	2940	2940	2855	2865	8324800
2003-05-02	2870	2875	2800	2860	8998400
2003-05-06	2940	3020	2935	2985	11663500
2003-05-07	3030	3040	2935	2965	5695200
2003-05-08	2940	2945	2865	2890	7032800
2003-05-09	2850	2860	2775	2815	9417900
2003-05-12	2880	2880	2815	2850	5355600
2003-05-13	2915	2970	2905	2920	7905900
2003-05-14	3030	3040	2990	3040	9874200
2003-05-15	3000	3010	2925	2955	6328700
2003-05-16	2960	2965	2870	2920	6938500
2003-05-19	2870	2935	2870	2930	3571700
2003-05-20	2915	2915	2860	2890	5150600
2003-05-21	2905	2920	2865	2900	3488800
2003-05-22	2890	2925	2880	2915	3517300
2003-05-23	2990	3050	2970	3040	7608000
2003-05-26	3020	3080	3010	3060	3207500
2003-05-27	3020	3020	2990	3000	2861600
2003-05-28	3030	3050	2995	3000	4851700
2003-05-29	3120	3130	3070	3100	7028200
2003-05-30	3150	3190	3140	3180	7238300
2003-06-02	3250	3300	3240	3300	6153200
2003-06-03	3310	3370	3280	3330	6707000
2003-06-04	3380	3430	3340	3390	5453100
2003-06-05	3440	3450	3400	3420	3910200
2003-06-06	3420	3490	3380	3470	4904800
2003-06-09	3490	3590	3470	3550	5448200
2003-06-10	3480	3480	3400	3420	5712400
2003-06-11	3440	3500	3440	3450	8062500
2003-06-12	3540	3540	3450	3470	4326300
2003-06-13	3460	3490	3460	3480	5558600
2003-06-16	3420	3430	3370	3370	4338300
2003-06-17	3460	3480	3430	3470	4212800
2003-06-18	3510	3540	3480	3480	3909100
2003-06-19	3530	3540	3500	3540	3828300
2003-06-20	3490	3520	3460	3520	2837300
2003-06-23	3470	3480	3420	3450	3341100
2003-06-24	3370	3390	3320	3330	4184100
2003-06-25	3300	3300	3250	3270	4860500
2003-06-26	3260	3300	3220	3270	5204000
2003-06-27	3360	3370	3320	3340	4238900
2003-06-30	3360	3400	3340	3380	3495500
2003-07-01	3350	3440	3350	3430	3161200
2003-07-02	3470	3680	3470	3640	10907000
2003-07-03	3840	3880	3700	3720	12179900
2003-07-04	3680	3730	3660	3680	4732600
2003-07-07	3690	3840	3680	3830	5300200
2003-07-08	3950	3970	3890	3910	9249100
2003-07-09	3920	3940	3880	3890	6844100
2003-07-10	3860	3870	3780	3810	6360300
2003-07-11	3730	3760	3650	3670	7038400
2003-07-14	3770	3890	3750	3890	7520500
2003-07-15	3970	4050	3960	3990	13971000
2003-07-16	4010	4020	3910	3990	7087600
2003-07-17	3890	3910	3810	3820	4535900
2003-07-18	3800	3810	3750	3780	4166400
2003-07-22	3750	3760	3680	3750	4042200
2003-07-23	3810	3820	3760	3790	4861500
2003-07-24	3740	3800	3680	3760	5245400
2003-07-25	3710	3750	3650	3710	10478000
2003-07-28	3790	3820	3760	3820	4402400
2003-07-29	3850	3870	3830	3840	3825000
2003-07-30	3800	3810	3720	3730	4110900
2003-07-31	3760	3760	3680	3730	3221300
2003-08-01	3820	3820	3720	3750	3694900
2003-08-04	3700	3700	3590	3600	4740800
2003-08-05	3620	3680	3620	3630	4100100
2003-08-06	3590	3600	3540	3560	3610700
2003-08-07	3570	3590	3530	3590	2985300
2003-08-08	3530	3570	3510	3530	3670700
2003-08-11	3540	3570	3500	3570	1843900
2003-08-12	3590	3630	3560	3600	1871600
2003-08-13	3620	3650	3590	3630	2570100
2003-08-14	3650	3720	3640	3720	2447400';

is( $quotes2, $expected,
	'fetch() and extract() quotes (with adjustment for the splits)' );

my @quotes3 = Finance::YahooJPN::QuoteHist->quotes('6758.t', 'Start' => '1991-09-20');
my $quotes3 = join "\n", @quotes3[0..2932];
is( $quotes3, $expected,
	'quotes() method (automatically new(), fetch(), extract() and output())' );
