# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl 1.t'

# this code is written in Unicode/UTF-8 character-set
# including Japanese letters.

use strict;
use warnings;

use Test::More tests => 4;

# use utf8;
# use Encode;

BEGIN {
    use_ok( 'CGI::Cookie::Jam' )
};

my $obj = CGI::Cookie::Jam->new('jammed_cookies', Size => 4096);
isa_ok($obj, 'CGI::Cookie::Jam');
########################################################################
# method enjam(%cookies)

my $long1 = <<'EOF';
PERSISTENT CLIENT STATE
HTTP COOKIES
Preliminary Specification - Use with caution

--------------------------------------------------------------------------------

INTRODUCTION
Cookies are a general mechanism which server side connections (such as CGI scripts) can use to both store and retrieve information on the client side of the connection. The addition of a simple, persistent, client-side state significantly extends the capabilities of Web-based client/server applications.

OVERVIEW
A server, when returning an HTTP object to a client, may also send a piece of state information which the client will store. Included in that state object is a description of the range of URLs for which that state is valid. Any future HTTP requests made by the client which fall in that range will include a transmittal of the current value of the state object from the client back to the server. The state object is called a cookie, for no compelling reason.
This simple mechanism provides a powerful new tool which enables a host of new types of applications to be written for web-based environments. Shopping applications can now store information about the currently selected items, for fee services can send back registration information and free the client from retyping a user-id on next connection, sites can store per-user preferences on the client, and have the client supply those preferences every time that site is connected to.
EOF

my $long2 = <<'EOF';
SPECIFICATION
A cookie is introduced to the client by including a Set-Cookie header as part of an HTTP response, typically this will be generated by a CGI script.
Syntax of the Set-Cookie HTTP Response Header
This is the format a CGI script would use to add to the HTTP headers a new piece of data which is to be stored by the client for later retrieval.
Set-Cookie: NAME=VALUE; expires=DATE;
path=PATH; domain=DOMAIN_NAME; secure

NAME=VALUE
This string is a sequence of characters excluding semi-colon, comma and white space. If there is a need to place such data in the name or value, some encoding method such as URL style %XX encoding is recommended, though no encoding is defined or required.
This is the only required attribute on the Set-Cookie header.


expires=DATE
The expires attribute specifies a date string that defines the valid life time of that cookie. Once the expiration date has been reached, the cookie will no longer be stored or given out.
The date string is formatted as:

Wdy, DD-Mon-YYYY HH:MM:SS GMT
This is based on RFC 822, RFC 850, RFC 1036, and RFC 1123, with the variations that the only legal time zone is GMT and the separators between the elements of the date must be dashes.
expires is an optional attribute. If not specified, the cookie will expire when the user's session ends.

Note: There is a bug in Netscape Navigator version 1.1 and earlier. Only cookies whose path attribute is set explicitly to "/" will be properly saved between sessions if they have an expires attribute.
EOF

my $long3 = <<'EOF';
domain=DOMAIN_NAME
When searching the cookie list for valid cookies, a comparison of the domain attributes of the cookie is made with the Internet domain name of the host from which the URL will be fetched. If there is a tail match, then the cookie will go through path matching to see if it should be sent. "Tail matching" means that domain attribute is matched against the tail of the fully qualified domain name of the host. A domain attribute of "acme.com" would match host names "anvil.acme.com" as well as "shipping.crate.acme.com". 
Only hosts within the specified domain can set a cookie for a domain and domains must have at least two (2) or three (3) periods in them to prevent domains of the form: ".com", ".edu", and "va.us". Any domain that fails within one of the seven special top level domains listed below only require two periods. Any other domain requires at least three. The seven special top level domains are: "COM", "EDU", "NET", "ORG", "GOV", "MIL", and "INT".

The default value of domain is the host name of the server which generated the cookie response.


path=PATH
The path attribute is used to specify the subset of URLs in a domain for which the cookie is valid. If a cookie has already passed domain matching, then the pathname component of the URL is compared with the path attribute, and if there is a match, the cookie is considered valid and is sent along with the URL request. The path "/foo" would match "/foobar" and "/foo/bar.html". The path "/" is the most general path.
If the path is not specified, it as assumed to be the same path as the document being described by the header which contains the cookie.


secure
If a cookie is marked secure, it will only be transmitted if the communications channel with the host is a secure one. Currently this means that secure cookies will only be sent to HTTPS (HTTP over SSL) servers.
If secure is not specified, a cookie is considered safe to be sent in the clear over unsecured channels. 

Syntax of the Cookie HTTP Request Header
When requesting a URL from an HTTP server, the browser will match the URL against all cookies and if any of them match, a line containing the name/value pairs of all matching cookies will be included in the HTTP request. Here is the format of that line:
Cookie: NAME1=OPAQUE_STRING1; NAME2=OPAQUE_STRING2 ...
EOF

my $long4 = <<'EOF';
Additional Notes
Multiple Set-Cookie headers can be issued in a single server response. 

Instances of the same path and name will overwrite each other, with the latest instance taking precedence. Instances of the same path but different names will add additional mappings.

Setting the path to a higher-level value does not override other more specific path mappings. If there are multiple matches for a given cookie name, but with separate paths, all the matching cookies will be sent. (See examples below.)

The expires header lets the client know when it is safe to purge the mapping but the client is not required to do so. A client may also delete a cookie before it's expiration date arrives if the number of cookies exceeds its internal limits.

When sending cookies to a server, all cookies with a more specific path mapping should be sent before cookies with less specific path mappings. For example, a cookie "name1=foo" with a path mapping of "/" should be sent after a cookie "name1=foo2" with a path mapping of "/bar" if they are both to be sent.

There are limitations on the number of cookies that a client can store at any one time. This is a specification of the minimum number of cookies that a client should be prepared to receive and store.
300 total cookies
4 kilobytes per cookie, where the name and the OPAQUE_STRING combine to form the 4 kilobyte limit.
20 cookies per server or domain. (note that completely specified hosts and domains are treated as separate entities and have a 20 cookie limitation for each, not combined)
Servers should not expect clients to be able to exceed these limits. When the 300 cookie limit or the 20 cookie per server limit is exceeded, clients should delete the least recently used cookie. When a cookie larger than 4 kilobytes is encountered the cookie should be trimmed to fit, but the name should remain intact as long as it is less than 4 kilobytes.

If a CGI script wishes to delete a cookie, it can do so by returning a cookie with the same name, and an expires time which is in the past. The path and name must match exactly in order for the expiring cookie to replace the valid cookie. This requirement makes it difficult for anyone but the originator of a cookie to delete a cookie.

When caching HTTP, as a proxy server might do, the Set-cookie response header should never be cached.

If a proxy server receives a response which contains a Set-cookie header, it should propagate the Set-cookie header to the client, regardless of whether the response was 304 (Not Modified) or 200 (OK).
Similarly, if a client request contains a Cookie: header, it should be forwarded through a proxy, even if the conditional If-modified-since request is being made. 
EOF

my $long5 = <<'EOF';
EXAMPLES
Here are some sample exchanges which are designed to illustrate the use of cookies.
First Example transaction sequence:
Client requests a document, and receives in the response:
Set-Cookie: CUSTOMER=WILE_E_COYOTE; path=/; expires=Wednesday, 09-Nov-99 23:12:40 GMT
When client requests a URL in path "/" on this server, it sends:
Cookie: CUSTOMER=WILE_E_COYOTE
Client requests a document, and receives in the response:
Set-Cookie: PART_NUMBER=ROCKET_LAUNCHER_0001; path=/
When client requests a URL in path "/" on this server, it sends:
Cookie: CUSTOMER=WILE_E_COYOTE; PART_NUMBER=ROCKET_LAUNCHER_0001
Client receives:
Set-Cookie: SHIPPING=FEDEX; path=/foo
When client requests a URL in path "/" on this server, it sends:
Cookie: CUSTOMER=WILE_E_COYOTE; PART_NUMBER=ROCKET_LAUNCHER_0001
When client requests a URL in path "/foo" on this server, it sends:
Cookie: CUSTOMER=WILE_E_COYOTE; PART_NUMBER=ROCKET_LAUNCHER_0001; SHIPPING=FEDEX
Second Example transaction sequence:
Assume all mappings from above have been cleared.

Client receives:
Set-Cookie: PART_NUMBER=ROCKET_LAUNCHER_0001; path=/
When client requests a URL in path "/" on this server, it sends:
Cookie: PART_NUMBER=ROCKET_LAUNCHER_0001
Client receives:
Set-Cookie: PART_NUMBER=RIDING_ROCKET_0023; path=/ammo
When client requests a URL in path "/ammo" on this server, it sends:
Cookie: PART_NUMBER=RIDING_ROCKET_0023; PART_NUMBER=ROCKET_LAUNCHER_0001
NOTE: There are two name/value pairs named "PART_NUMBER" due to the inheritance of the "/" mapping in addition to the "/ammo" mapping.
EOF

my @got = $obj->enjam(
    name    => 'Masanori HATA'           ,
    mail    => 'lovewing@geocities.co.jp',
    sex     => 'male'                    ,
    birth   => '2003-04-09'              ,
    nation  => 'Japan'                   ,
    pref    => 'Saitama'                 ,
    city    => 'Kawaguchi'               ,
    tel     => '+81-48-2XX-XXXX'         ,
    fax     => '+81-48-2XX-XXXX'         ,
    job     => 'student'                 ,
    role    => 'president'               ,
    hobby   => 'exaggeration'            ,
    long1   => $long1                    ,
    long2   => $long2                    ,
    long3   => $long3                    ,
    long4   => $long4                    ,
    long5   => $long5                    ,
);

my $got = join("\n", @got);

my @expected = qw(
    jammed_cookies_00=name%3DMasanori%2520HATA%26mail%3Dlovewing%2540geocities.co.jp%26sex%3Dmale%26birth%3D2003-04-09%26nation%3DJapan%26pref%3DSaitama%26city%3DKawaguchi%26tel%3D%252B81-48-2XX-XXXX%26fax%3D%252B81-48-2XX-XXXX%26job%3Dstudent%26role%3Dpresident%26hobby%3Dexaggeration%26long1%3DPERSISTENT%2520CLIENT%2520STATE%250AHTTP%2520COOKIES%250APreliminary%2520Specification%2520-%2520Use%2520with%2520caution%250A%250A--------------------------------------------------------------------------------%250A%250AINTRODUCTION%250ACookies%2520are%2520a%2520general%2520mechanism%2520which%2520server%2520side%2520connections%2520(such%2520as%2520CGI%2520scripts)%2520can%2520use%2520to%2520both%2520store%2520and%2520retrieve%2520information%2520on%2520the%2520client%2520side%2520of%2520the%2520connection.%2520The%2520addition%2520of%2520a%2520simple%252C%2520persistent%252C%2520client-side%2520state%2520significantly%2520extends%2520the%2520capabilities%2520of%2520Web-based%2520client%252Fserver%2520applications.%250A%250AOVERVIEW%250AA%2520server%252C%2520when%2520returning%2520an%2520HTTP%2520object%2520to%2520a%2520client%252C%2520may%2520also%2520send%2520a%2520piece%2520of%2520state%2520information%2520which%2520the%2520client%2520will%2520store.%2520Included%2520in%2520that%2520state%2520object%2520is%2520a%2520description%2520of%2520the%2520range%2520of%2520URLs%2520for%2520which%2520that%2520state%2520is%2520valid.%2520Any%2520future%2520HTTP%2520requests%2520made%2520by%2520the%2520client%2520which%2520fall%2520in%2520that%2520range%2520will%2520include%2520a%2520transmittal%2520of%2520the%2520current%2520value%2520of%2520the%2520state%2520object%2520from%2520the%2520client%2520back%2520to%2520the%2520server.%2520The%2520state%2520object%2520is%2520called%2520a%2520cookie%252C%2520for%2520no%2520compelling%2520reason.%250AThis%2520simple%2520mechanism%2520provides%2520a%2520powerful%2520new%2520tool%2520which%2520enables%2520a%2520host%2520of%2520new%2520types%2520of%2520applications%2520to%2520be%2520written%2520for%2520web-based%2520environments.%2520Shopping%2520applications%2520can%2520now%2520store%2520information%2520about%2520the%2520currently%2520selected%2520items%252C%2520for%2520fee%2520services%2520can%2520send%2520back%2520registration%2520information%2520and%2520free%2520the%2520client%2520from%2520retyping%2520a%2520user-id%2520on%2520next%2520connection%252C%2520sites%2520can%2520store%2520per-user%2520preferences%2520on%2520the%2520client%252C%2520and%2520have%2520the%2520client%2520supply%2520those%2520preferences%2520every%2520time%2520that%2520site%2520is%2520connected%2520to.%250A%26long2%3DSPECIFICATION%250AA%2520cookie%2520is%2520introduced%2520to%2520the%2520client%2520by%2520including%2520a%2520Set-Cookie%2520header%2520as%2520part%2520of%2520an%2520HTTP%2520response%252C%2520typically%2520this%2520will%2520be%2520generated%2520by%2520a%2520CGI%2520script.%250ASyntax%2520of%2520the%2520Set-Cookie%2520HTTP%2520Response%2520Header%250AThis%2520is%2520the%2520format%2520a%2520CGI%2520script%2520would%2520use%2520to%2520add%2520to%2520the%2520HTTP%2520headers%2520a%2520new%2520piece%2520of%2520data%2520which%2520is%2520to%2520be%2520stored%2520by%2520the%2520client%2520for%2520later%2520retrieval.%250ASet-Cookie%253A%2520NAME%253DVALUE%253B%2520expires%253DDATE%253B%250Apath%253DPATH%253B%2520domain%253DDOMAIN_NAME%253B%2520secure%250A%250ANAME%253DVALUE%250AThis%2520string%2520is%2520a%2520sequence%2520of%2520characters%2520excluding%2520semi-colon%252C%2520comma%2520and%2520white%2520space.%2520If%2520there%2520is%2520a%2520need%2520to%2520place%2520such%2520data%2520in%2520the%2520name%2520or%2520value%252C%2520some%2520encoding%2520method%2520such%2520as%2520URL%2520style%2520%2525XX%2520encoding%2520is%2520recommended%252C%2520though%2520no%2520encoding%2520is%2520defined%2520or%2520required.%250AThis%2520is%2520the%2520only%2520required%2520attribute%2520on%2520the%2520Set-Cookie%2520header.%250A%250A%250Aexpires%253DDATE%250AThe%2520expires%2520attribute%2520specifies%2520a%2520date%2520string%
    jammed_cookies_01=2520that%2520defines%2520the%2520valid%2520life%2520time%2520of%2520that%2520cookie.%2520Once%2520the%2520expiration%2520date%2520has%2520been%2520reached%252C%2520the%2520cookie%2520will%2520no%2520longer%2520be%2520stored%2520or%2520given%2520out.%250AThe%2520date%2520string%2520is%2520formatted%2520as%253A%250A%250AWdy%252C%2520DD-Mon-YYYY%2520HH%253AMM%253ASS%2520GMT%250AThis%2520is%2520based%2520on%2520RFC%2520822%252C%2520RFC%2520850%252C%2520RFC%25201036%252C%2520and%2520RFC%25201123%252C%2520with%2520the%2520variations%2520that%2520the%2520only%2520legal%2520time%2520zone%2520is%2520GMT%2520and%2520the%2520separators%2520between%2520the%2520elements%2520of%2520the%2520date%2520must%2520be%2520dashes.%250Aexpires%2520is%2520an%2520optional%2520attribute.%2520If%2520not%2520specified%252C%2520the%2520cookie%2520will%2520expire%2520when%2520the%2520user's%2520session%2520ends.%250A%250ANote%253A%2520There%2520is%2520a%2520bug%2520in%2520Netscape%2520Navigator%2520version%25201.1%2520and%2520earlier.%2520Only%2520cookies%2520whose%2520path%2520attribute%2520is%2520set%2520explicitly%2520to%2520%2522%252F%2522%2520will%2520be%2520properly%2520saved%2520between%2520sessions%2520if%2520they%2520have%2520an%2520expires%2520attribute.%250A%26long3%3Ddomain%253DDOMAIN_NAME%250AWhen%2520searching%2520the%2520cookie%2520list%2520for%2520valid%2520cookies%252C%2520a%2520comparison%2520of%2520the%2520domain%2520attributes%2520of%2520the%2520cookie%2520is%2520made%2520with%2520the%2520Internet%2520domain%2520name%2520of%2520the%2520host%2520from%2520which%2520the%2520URL%2520will%2520be%2520fetched.%2520If%2520there%2520is%2520a%2520tail%2520match%252C%2520then%2520the%2520cookie%2520will%2520go%2520through%2520path%2520matching%2520to%2520see%2520if%2520it%2520should%2520be%2520sent.%2520%2522Tail%2520matching%2522%2520means%2520that%2520domain%2520attribute%2520is%2520matched%2520against%2520the%2520tail%2520of%2520the%2520fully%2520qualified%2520domain%2520name%2520of%2520the%2520host.%2520A%2520domain%2520attribute%2520of%2520%2522acme.com%2522%2520would%2520match%2520host%2520names%2520%2522anvil.acme.com%2522%2520as%2520well%2520as%2520%2522shipping.crate.acme.com%2522.%2520%250AOnly%2520hosts%2520within%2520the%2520specified%2520domain%2520can%2520set%2520a%2520cookie%2520for%2520a%2520domain%2520and%2520domains%2520must%2520have%2520at%2520least%2520two%2520(2)%2520or%2520three%2520(3)%2520periods%2520in%2520them%2520to%2520prevent%2520domains%2520of%2520the%2520form%253A%2520%2522.com%2522%252C%2520%2522.edu%2522%252C%2520and%2520%2522va.us%2522.%2520Any%2520domain%2520that%2520fails%2520within%2520one%2520of%2520the%2520seven%2520special%2520top%2520level%2520domains%2520listed%2520below%2520only%2520require%2520two%2520periods.%2520Any%2520other%2520domain%2520requires%2520at%2520least%2520three.%2520The%2520seven%2520special%2520top%2520level%2520domains%2520are%253A%2520%2522COM%2522%252C%2520%2522EDU%2522%252C%2520%2522NET%2522%252C%2520%2522ORG%2522%252C%2520%2522GOV%2522%252C%2520%2522MIL%2522%252C%2520and%2520%2522INT%2522.%250A%250AThe%2520default%2520value%2520of%2520domain%2520is%2520the%2520host%2520name%2520of%2520the%2520server%2520which%2520generated%2520the%2520cookie%2520response.%250A%250A%250Apath%253DPATH%250AThe%2520path%2520attribute%2520is%2520used%2520to%2520specify%2520the%2520subset%2520of%2520URLs%2520in%2520a%2520domain%2520for%2520which%2520the%2520cookie%2520is%2520valid.%2520If%2520a%2520cookie%2520has%2520already%2520passed%2520domain%2520matching%252C%2520then%2520the%2520pathname%2520component%2520of%2520the%2520URL%2520is%2520compared%2520with%2520the%2520path%2520attribute%252C%2520and%2520if%2520there%2520is%2520a%2520match%252C%2520the%2520cookie%2520is%2520considered%2520valid%2520and%2520is%2520sent%2520along%2520with%2520the%2520URL%2520request.%2520The%2520path%2520%2522%252Ffoo%2522%2520would%2520match%2520%2522%252Ffoobar%2522%2520and%2520%2522%252Ffoo%252Fbar.html%2522.%2520The%2520path%2520%2522%252F%2522%2520is%2520the%2520most%2520general%2520path.%250AI
    jammed_cookies_02=f%2520the%2520path%2520is%2520not%2520specified%252C%2520it%2520as%2520assumed%2520to%2520be%2520the%2520same%2520path%2520as%2520the%2520document%2520being%2520described%2520by%2520the%2520header%2520which%2520contains%2520the%2520cookie.%250A%250A%250Asecure%250AIf%2520a%2520cookie%2520is%2520marked%2520secure%252C%2520it%2520will%2520only%2520be%2520transmitted%2520if%2520the%2520communications%2520channel%2520with%2520the%2520host%2520is%2520a%2520secure%2520one.%2520Currently%2520this%2520means%2520that%2520secure%2520cookies%2520will%2520only%2520be%2520sent%2520to%2520HTTPS%2520(HTTP%2520over%2520SSL)%2520servers.%250AIf%2520secure%2520is%2520not%2520specified%252C%2520a%2520cookie%2520is%2520considered%2520safe%2520to%2520be%2520sent%2520in%2520the%2520clear%2520over%2520unsecured%2520channels.%2520%250A%250ASyntax%2520of%2520the%2520Cookie%2520HTTP%2520Request%2520Header%250AWhen%2520requesting%2520a%2520URL%2520from%2520an%2520HTTP%2520server%252C%2520the%2520browser%2520will%2520match%2520the%2520URL%2520against%2520all%2520cookies%2520and%2520if%2520any%2520of%2520them%2520match%252C%2520a%2520line%2520containing%2520the%2520name%252Fvalue%2520pairs%2520of%2520all%2520matching%2520cookies%2520will%2520be%2520included%2520in%2520the%2520HTTP%2520request.%2520Here%2520is%2520the%2520format%2520of%2520that%2520line%253A%250ACookie%253A%2520NAME1%253DOPAQUE_STRING1%253B%2520NAME2%253DOPAQUE_STRING2%2520...%250A%26long4%3DAdditional%2520Notes%250AMultiple%2520Set-Cookie%2520headers%2520can%2520be%2520issued%2520in%2520a%2520single%2520server%2520response.%2520%250A%250AInstances%2520of%2520the%2520same%2520path%2520and%2520name%2520will%2520overwrite%2520each%2520other%252C%2520with%2520the%2520latest%2520instance%2520taking%2520precedence.%2520Instances%2520of%2520the%2520same%2520path%2520but%2520different%2520names%2520will%2520add%2520additional%2520mappings.%250A%250ASetting%2520the%2520path%2520to%2520a%2520higher-level%2520value%2520does%2520not%2520override%2520other%2520more%2520specific%2520path%2520mappings.%2520If%2520there%2520are%2520multiple%2520matches%2520for%2520a%2520given%2520cookie%2520name%252C%2520but%2520with%2520separate%2520paths%252C%2520all%2520the%2520matching%2520cookies%2520will%2520be%2520sent.%2520(See%2520examples%2520below.)%250A%250AThe%2520expires%2520header%2520lets%2520the%2520client%2520know%2520when%2520it%2520is%2520safe%2520to%2520purge%2520the%2520mapping%2520but%2520the%2520client%2520is%2520not%2520required%2520to%2520do%2520so.%2520A%2520client%2520may%2520also%2520delete%2520a%2520cookie%2520before%2520it's%2520expiration%2520date%2520arrives%2520if%2520the%2520number%2520of%2520cookies%2520exceeds%2520its%2520internal%2520limits.%250A%250AWhen%2520sending%2520cookies%2520to%2520a%2520server%252C%2520all%2520cookies%2520with%2520a%2520more%2520specific%2520path%2520mapping%2520should%2520be%2520sent%2520before%2520cookies%2520with%2520less%2520specific%2520path%2520mappings.%2520For%2520example%252C%2520a%2520cookie%2520%2522name1%253Dfoo%2522%2520with%2520a%2520path%2520mapping%2520of%2520%2522%252F%2522%2520should%2520be%2520sent%2520after%2520a%2520cookie%2520%2522name1%253Dfoo2%2522%2520with%2520a%2520path%2520mapping%2520of%2520%2522%252Fbar%2522%2520if%2520they%2520are%2520both%2520to%2520be%2520sent.%250A%250AThere%2520are%2520limitations%2520on%2520the%2520number%2520of%2520cookies%2520that%2520a%2520client%2520can%2520store%2520at%2520any%2520one%2520time.%2520This%2520is%2520a%2520specification%2520of%2520the%2520minimum%2520number%2520of%2520cookies%2520that%2520a%2520client%2520should%2520be%2520prepared%2520to%2520receive%2520and%2520store.%250A300%2520total%2520cookies%250A4%2520kilobytes%2520per%2520cookie%252C%2520where%2520the%2520name%2520and%2520the%2520OPAQUE_STRING%2520combine%2520to%2520form%2520the%25204%2520kilobyte%2520limit.%250A20%2520cookies%2520per%2520server%2520or%2520domain.%2520(note%2520that%2520completely%2520specified%2520hosts%2520and%2520domains%2520are%2520treated%2520as%2520separate%2520entities%2520and%2520ha
    jammed_cookies_03=ve%2520a%252020%2520cookie%2520limitation%2520for%2520each%252C%2520not%2520combined)%250AServers%2520should%2520not%2520expect%2520clients%2520to%2520be%2520able%2520to%2520exceed%2520these%2520limits.%2520When%2520the%2520300%2520cookie%2520limit%2520or%2520the%252020%2520cookie%2520per%2520server%2520limit%2520is%2520exceeded%252C%2520clients%2520should%2520delete%2520the%2520least%2520recently%2520used%2520cookie.%2520When%2520a%2520cookie%2520larger%2520than%25204%2520kilobytes%2520is%2520encountered%2520the%2520cookie%2520should%2520be%2520trimmed%2520to%2520fit%252C%2520but%2520the%2520name%2520should%2520remain%2520intact%2520as%2520long%2520as%2520it%2520is%2520less%2520than%25204%2520kilobytes.%250A%250AIf%2520a%2520CGI%2520script%2520wishes%2520to%2520delete%2520a%2520cookie%252C%2520it%2520can%2520do%2520so%2520by%2520returning%2520a%2520cookie%2520with%2520the%2520same%2520name%252C%2520and%2520an%2520expires%2520time%2520which%2520is%2520in%2520the%2520past.%2520The%2520path%2520and%2520name%2520must%2520match%2520exactly%2520in%2520order%2520for%2520the%2520expiring%2520cookie%2520to%2520replace%2520the%2520valid%2520cookie.%2520This%2520requirement%2520makes%2520it%2520difficult%2520for%2520anyone%2520but%2520the%2520originator%2520of%2520a%2520cookie%2520to%2520delete%2520a%2520cookie.%250A%250AWhen%2520caching%2520HTTP%252C%2520as%2520a%2520proxy%2520server%2520might%2520do%252C%2520the%2520Set-cookie%2520response%2520header%2520should%2520never%2520be%2520cached.%250A%250AIf%2520a%2520proxy%2520server%2520receives%2520a%2520response%2520which%2520contains%2520a%2520Set-cookie%2520header%252C%2520it%2520should%2520propagate%2520the%2520Set-cookie%2520header%2520to%2520the%2520client%252C%2520regardless%2520of%2520whether%2520the%2520response%2520was%2520304%2520(Not%2520Modified)%2520or%2520200%2520(OK).%250ASimilarly%252C%2520if%2520a%2520client%2520request%2520contains%2520a%2520Cookie%253A%2520header%252C%2520it%2520should%2520be%2520forwarded%2520through%2520a%2520proxy%252C%2520even%2520if%2520the%2520conditional%2520If-modified-since%2520request%2520is%2520being%2520made.%2520%250A%26long5%3DEXAMPLES%250AHere%2520are%2520some%2520sample%2520exchanges%2520which%2520are%2520designed%2520to%2520illustrate%2520the%2520use%2520of%2520cookies.%250AFirst%2520Example%2520transaction%2520sequence%253A%250AClient%2520requests%2520a%2520document%252C%2520and%2520receives%2520in%2520the%2520response%253A%250ASet-Cookie%253A%2520CUSTOMER%253DWILE_E_COYOTE%253B%2520path%253D%252F%253B%2520expires%253DWednesday%252C%252009-Nov-99%252023%253A12%253A40%2520GMT%250AWhen%2520client%2520requests%2520a%2520URL%2520in%2520path%2520%2522%252F%2522%2520on%2520this%2520server%252C%2520it%2520sends%253A%250ACookie%253A%2520CUSTOMER%253DWILE_E_COYOTE%250AClient%2520requests%2520a%2520document%252C%2520and%2520receives%2520in%2520the%2520response%253A%250ASet-Cookie%253A%2520PART_NUMBER%253DROCKET_LAUNCHER_0001%253B%2520path%253D%252F%250AWhen%2520client%2520requests%2520a%2520URL%2520in%2520path%2520%2522%252F%2522%2520on%2520this%2520server%252C%2520it%2520sends%253A%250ACookie%253A%2520CUSTOMER%253DWILE_E_COYOTE%253B%2520PART_NUMBER%253DROCKET_LAUNCHER_0001%250AClient%2520receives%253A%250ASet-Cookie%253A%2520SHIPPING%253DFEDEX%253B%2520path%253D%252Ffoo%250AWhen%2520client%2520requests%2520a%2520URL%2520in%2520path%2520%2522%252F%2522%2520on%2520this%2520server%252C%2520it%2520sends%253A%250ACookie%253A%2520CUSTOMER%253DWILE_E_COYOTE%253B%2520PART_NUMBER%253DROCKET_LAUNCHER_0001%250AWhen%2520client%2520requests%2520a%2520URL%2520in%2520path%2520%2522%252Ffoo%2522%2520on%2520this%2520server%252C%2520it%2520sends%253A%250ACookie%253A%2520CUSTOMER%253DWILE_E_COYOTE%253B%2520PART_NUMBER%253DROCKET_LAUNCHER_0001%253B%2520SHIPPING%253DFEDEX%250ASecond%2520Example%2520transaction%2520sequence%253A%250AAssume%2520all%2520mappings%2520from%2520above%2520have%2520been%2520cleared.%250A%250AClient%2520receives%253A%250ASet-Cookie%253A%2520PART_NUMBER%253DROCKET_LAUNCHER_0001%253B%2520path%253D%252F%250AWhen%2520cl
    jammed_cookies_04=ient%2520requests%2520a%2520URL%2520in%2520path%2520%2522%252F%2522%2520on%2520this%2520server%252C%2520it%2520sends%253A%250ACookie%253A%2520PART_NUMBER%253DROCKET_LAUNCHER_0001%250AClient%2520receives%253A%250ASet-Cookie%253A%2520PART_NUMBER%253DRIDING_ROCKET_0023%253B%2520path%253D%252Fammo%250AWhen%2520client%2520requests%2520a%2520URL%2520in%2520path%2520%2522%252Fammo%2522%2520on%2520this%2520server%252C%2520it%2520sends%253A%250ACookie%253A%2520PART_NUMBER%253DRIDING_ROCKET_0023%253B%2520PART_NUMBER%253DROCKET_LAUNCHER_0001%250ANOTE%253A%2520There%2520are%2520two%2520name%252Fvalue%2520pairs%2520named%2520%2522PART_NUMBER%2522%2520due%2520to%2520the%2520inheritance%2520of%2520the%2520%2522%252F%2522%2520mapping%2520in%2520addition%2520to%2520the%2520%2522%252Fammo%2522%2520mapping.%250A
);
my $expected = join("\n", @expected);
is($got, $expected,
    'method enjam(%cookies)');

########################################################################
# method enjam(%cookies) without size limitation

my $obj2 = CGI::Cookie::Jam->new('jammed_cookie', Size => 0);

$got = $obj2->enjam(
    name    => 'Masanori HATA'           ,
    mail    => 'lovewing@geocities.co.jp',
    sex     => 'male'                    ,
    birth   => '2003-04-09'              ,
    nation  => 'Japan'                   ,
    pref    => 'Saitama'                 ,
    city    => 'Kawaguchi'               ,
    tel     => '+81-48-2XX-XXXX'         ,
    fax     => '+81-48-2XX-XXXX'         ,
    job     => 'student'                 ,
    role    => 'president'               ,
    hobby   => 'exaggeration'            ,
    long1   => $long1                    ,
    long2   => $long2                    ,
);

chomp($expected = <<'EOF');
jammed_cookie=name%3DMasanori%2520HATA%26mail%3Dlovewing%2540geocities.co.jp%26sex%3Dmale%26birth%3D2003-04-09%26nation%3DJapan%26pref%3DSaitama%26city%3DKawaguchi%26tel%3D%252B81-48-2XX-XXXX%26fax%3D%252B81-48-2XX-XXXX%26job%3Dstudent%26role%3Dpresident%26hobby%3Dexaggeration%26long1%3DPERSISTENT%2520CLIENT%2520STATE%250AHTTP%2520COOKIES%250APreliminary%2520Specification%2520-%2520Use%2520with%2520caution%250A%250A--------------------------------------------------------------------------------%250A%250AINTRODUCTION%250ACookies%2520are%2520a%2520general%2520mechanism%2520which%2520server%2520side%2520connections%2520(such%2520as%2520CGI%2520scripts)%2520can%2520use%2520to%2520both%2520store%2520and%2520retrieve%2520information%2520on%2520the%2520client%2520side%2520of%2520the%2520connection.%2520The%2520addition%2520of%2520a%2520simple%252C%2520persistent%252C%2520client-side%2520state%2520significantly%2520extends%2520the%2520capabilities%2520of%2520Web-based%2520client%252Fserver%2520applications.%250A%250AOVERVIEW%250AA%2520server%252C%2520when%2520returning%2520an%2520HTTP%2520object%2520to%2520a%2520client%252C%2520may%2520also%2520send%2520a%2520piece%2520of%2520state%2520information%2520which%2520the%2520client%2520will%2520store.%2520Included%2520in%2520that%2520state%2520object%2520is%2520a%2520description%2520of%2520the%2520range%2520of%2520URLs%2520for%2520which%2520that%2520state%2520is%2520valid.%2520Any%2520future%2520HTTP%2520requests%2520made%2520by%2520the%2520client%2520which%2520fall%2520in%2520that%2520range%2520will%2520include%2520a%2520transmittal%2520of%2520the%2520current%2520value%2520of%2520the%2520state%2520object%2520from%2520the%2520client%2520back%2520to%2520the%2520server.%2520The%2520state%2520object%2520is%2520called%2520a%2520cookie%252C%2520for%2520no%2520compelling%2520reason.%250AThis%2520simple%2520mechanism%2520provides%2520a%2520powerful%2520new%2520tool%2520which%2520enables%2520a%2520host%2520of%2520new%2520types%2520of%2520applications%2520to%2520be%2520written%2520for%2520web-based%2520environments.%2520Shopping%2520applications%2520can%2520now%2520store%2520information%2520about%2520the%2520currently%2520selected%2520items%252C%2520for%2520fee%2520services%2520can%2520send%2520back%2520registration%2520information%2520and%2520free%2520the%2520client%2520from%2520retyping%2520a%2520user-id%2520on%2520next%2520connection%252C%2520sites%2520can%2520store%2520per-user%2520preferences%2520on%2520the%2520client%252C%2520and%2520have%2520the%2520client%2520supply%2520those%2520preferences%2520every%2520time%2520that%2520site%2520is%2520connected%2520to.%250A%26long2%3DSPECIFICATION%250AA%2520cookie%2520is%2520introduced%2520to%2520the%2520client%2520by%2520including%2520a%2520Set-Cookie%2520header%2520as%2520part%2520of%2520an%2520HTTP%2520response%252C%2520typically%2520this%2520will%2520be%2520generated%2520by%2520a%2520CGI%2520script.%250ASyntax%2520of%2520the%2520Set-Cookie%2520HTTP%2520Response%2520Header%250AThis%2520is%2520the%2520format%2520a%2520CGI%2520script%2520would%2520use%2520to%2520add%2520to%2520the%2520HTTP%2520headers%2520a%2520new%2520piece%2520of%2520data%2520which%2520is%2520to%2520be%2520stored%2520by%2520the%2520client%2520for%2520later%2520retrieval.%250ASet-Cookie%253A%2520NAME%253DVALUE%253B%2520expires%253DDATE%253B%250Apath%253DPATH%253B%2520domain%253DDOMAIN_NAME%253B%2520secure%250A%250ANAME%253DVALUE%250AThis%2520string%2520is%2520a%2520sequence%2520of%2520characters%2520excluding%2520semi-colon%252C%2520comma%2520and%2520white%2520space.%2520If%2520there%2520is%2520a%2520need%2520to%2520place%2520such%2520data%2520in%2520the%2520name%2520or%2520value%252C%2520some%2520encoding%2520method%2520such%2520as%2520URL%2520style%2520%2525XX%2520encoding%2520is%2520recommended%252C%2520though%2520no%2520encoding%2520is%2520defined%2520or%2520required.%250AThis%2520is%2520the%2520only%2520required%2520attribute%2520on%2520the%2520Set-Cookie%2520header.%250A%250A%250Aexpires%253DDATE%250AThe%2520expires%2520attribute%2520specifies%2520a%2520date%2520string%2520that%2520defines%2520the%2520valid%2520life%2520time%2520of%2520that%2520cookie.%2520Once%2520the%2520expiration%2520date%2520has%2520been%2520reached%252C%2520the%2520cookie%2520will%2520no%2520longer%2520be%2520stored%2520or%2520given%2520out.%250AThe%2520date%2520string%2520is%2520formatted%2520as%253A%250A%250AWdy%252C%2520DD-Mon-YYYY%2520HH%253AMM%253ASS%2520GMT%250AThis%2520is%2520based%2520on%2520RFC%2520822%252C%2520RFC%2520850%252C%2520RFC%25201036%252C%2520and%2520RFC%25201123%252C%2520with%2520the%2520variations%2520that%2520the%2520only%2520legal%2520time%2520zone%2520is%2520GMT%2520and%2520the%2520separators%2520between%2520the%2520elements%2520of%2520the%2520date%2520must%2520be%2520dashes.%250Aexpires%2520is%2520an%2520optional%2520attribute.%2520If%2520not%2520specified%252C%2520the%2520cookie%2520will%2520expire%2520when%2520the%2520user's%2520session%2520ends.%250A%250ANote%253A%2520There%2520is%2520a%2520bug%2520in%2520Netscape%2520Navigator%2520version%25201.1%2520and%2520earlier.%2520Only%2520cookies%2520whose%2520path%2520attribute%2520is%2520set%2520explicitly%2520to%2520%2522%252F%2522%2520will%2520be%2520properly%2520saved%2520between%2520sessions%2520if%2520they%2520have%2520an%2520expires%2520attribute.%250A
EOF

is($got, $expected,
    'method enjam(%cookies) without size limitation');

########################################################################
# method dejam($cookie)

chomp(my $string = <<'EOF');
jammed_cookie=my%2520name%3DMasanori%2520HATA%26mail%3Dlovewing%2540geocities.co.jp%26sex%3Dmale%26birth%3D2003-04-09%26nation%3DJapan%26pref%3DSaitama%26city%3DKawaguchi%26tel%3D%252B81-48-2XX-XXXX%26fax%3D%252B81-48-2XX-XXXX%26job%3Dstudent%26role%3Dpresident%26hobby%3Dexaggeration%26long1%3DPERSISTENT%2520CLIENT%2520STATE%250AHTTP%2520COOKIES%250APreliminary%2520Specification%2520-%2520Use%2520with%2520caution%250A%250A--------------------------------------------------------------------------------%250A%250AINTRODUCTION%250ACookies%2520are%2520a%2520general%2520mechanism%2520which%2520server%2520side%2520connections%2520(such%2520as%2520CGI%2520scripts)%2520can%2520use%2520to%2520both%2520store%2520and%2520retrieve%2520information%2520on%2520the%2520client%2520side%2520of%2520the%2520connection.%2520The%2520addition%2520of%2520a%2520simple%252C%2520persistent%252C%2520client-side%2520state%2520significantly%2520extends%2520the%2520capabilities%2520of%2520Web-based%2520client%252Fserver%2520applications.%250A%250AOVERVIEW%250AA%2520server%252C%2520when%2520returning%2520an%2520HTTP%2520object%2520to%2520a%2520client%252C%2520may%2520also%2520send%2520a%2520piece%2520of%2520state%2520information%2520which%2520the%2520client%2520will%2520store.%2520Included%2520in%2520that%2520state%2520object%2520is%2520a%2520description%2520of%2520the%2520range%2520of%2520URLs%2520for%2520which%2520that%2520state%2520is%2520valid.%2520Any%2520future%2520HTTP%2520requests%2520made%2520by%2520the%2520client%2520which%2520fall%2520in%2520that%2520range%2520will%2520include%2520a%2520transmittal%2520of%2520the%2520current%2520value%2520of%2520the%2520state%2520object%2520from%2520the%2520client%2520back%2520to%2520the%2520server.%2520The%2520state%2520object%2520is%2520called%2520a%2520cookie%252C%2520for%2520no%2520compelling%2520reason.%250AThis%2520simple%2520mechanism%2520provides%2520a%2520powerful%2520new%2520tool%2520which%2520enables%2520a%2520host%2520of%2520new%2520types%2520of%2520applications%2520to%2520be%2520written%2520for%2520web-based%2520environments.%2520Shopping%2520applications%2520can%2520now%2520store%2520information%2520about%2520the%2520currently%2520selected%2520items%252C%2520for%2520fee%2520services%2520can%2520send%2520back%2520registration%2520information%2520and%2520free%2520the%2520client%2520from%2520retyping%2520a%2520user-id%2520on%2520next%2520connection%252C%2520sites%2520can%2520store%2520per-user%2520preferences%2520on%2520the%2520client%252C%2520and%2520have%2520the%2520client%2520supply%2520those%2520preferences%2520every%2520time%2520that%2520site%2520is%2520connected%2520to.%250A%26long2%3DSPECIFICATION%250AA%2520cookie%2520is%2520introduced%2520to%2520the%2520client%2520by%2520including%2520a%2520Set-Cookie%2520header%2520as%2520part%2520of%2520an%2520HTTP%2520response%252C%2520typically%2520this%2520will%2520be%2520generated%2520by%2520a%2520CGI%2520script.%250ASyntax%2520of%2520the%2520Set-Cookie%2520HTTP%2520Response%2520Header%250AThis%2520is%2520the%2520format%2520a%2520CGI%2520script%2520would%2520use%2520to%2520add%2520to%2520the%2520HTTP%2520headers%2520a%2520new%2520piece%2520of%2520data%2520which%2520is%2520to%2520be%2520stored%2520by%2520the%2520client%2520for%2520later%2520retrieval.%250ASet-Cookie%253A%2520NAME%253DVALUE%253B%2520expires%253DDATE%253B%250Apath%253DPATH%253B%2520domain%253DDOMAIN_NAME%253B%2520secure%250A%250ANAME%253DVALUE%250AThis%2520string%2520is%2520a%2520sequence%2520of%2520characters%2520excluding%2520semi-colon%252C%2520comma%2520and%2520white%2520space.%2520If%2520there%2520is%2520a%2520need%2520to%2520place%2520such%2520data%2520in%2520the%2520name%2520or%2520value%252C%2520some%2520encoding%2520method%2520such%2520as%2520URL%2520style%2520%2525XX%2520encoding%2520is%2520recommended%252C%2520though%2520no%2520encoding%2520is%2520defined%2520or%2520required.%250AThis%2520is%2520the%2520only%2520required%2520attribute%2520on%2520the%2520Set-Cookie%2520header.%250A%250A%250Aexpires%253DDATE%250AThe%2520expires%2520attribute%2520specifies%2520a%2520date%2520string%2520that%2520defines%2520the%2520valid%2520life%2520time%2520of%2520that%2520cookie.%2520Once%2520the%2520expiration%2520date%2520has%2520been%2520reached%252C%2520the%2520cookie%2520will%2520no%2520longer%2520be%2520stored%2520or%2520given%2520out.%250AThe%2520date%2520string%2520is%2520formatted%2520as%253A%250A%250AWdy%252C%2520DD-Mon-YYYY%2520HH%253AMM%253ASS%2520GMT%250AThis%2520is%2520based%2520on%2520RFC%2520822%252C%2520RFC%2520850%252C%2520RFC%25201036%252C%2520and%2520RFC%25201123%252C%2520with%2520the%2520variations%2520that%2520the%2520only%2520legal%2520time%2520zone%2520is%2520GMT%2520and%2520the%2520separators%2520between%2520the%2520elements%2520of%2520the%2520date%2520must%2520be%2520dashes.%250Aexpires%2520is%2520an%2520optional%2520attribute.%2520If%2520not%2520specified%252C%2520the%2520cookie%2520will%2520expire%2520when%2520the%2520user's%2520session%2520ends.%250A%250ANote%253A%2520There%2520is%2520a%2520bug%2520in%2520Netscape%2520Navigator%2520version%25201.1%2520and%2520earlier.%2520Only%2520cookies%2520whose%2520path%2520attribute%2520is%2520set%2520explicitly%2520to%2520%2522%252F%2522%2520will%2520be%2520properly%2520saved%2520between%2520sessions%2520if%2520they%2520have%2520an%2520expires%2520attribute.%250A
EOF

print CGI::Cookie::Jam::dejam($string);
