use strict;
use warnings;
use Test::More tests => 68;
use Digest::Shabal qw(shabal_512 shabal_512_hex);

my $len = 0;

while (my $line = <DATA>) {
    chomp $line;
    my ($msg, $digest) = split '\|', $line, 2;
    my $data = pack 'H*', $msg;
    $digest = lc $digest;

    if ($len and not $len % 8) {
        my $md = Digest::Shabal->new(512)->add($data)->hexdigest;
        is($md, $digest, "new/add/hexdigest: $len bits of $msg");
        is(
            shabal_512_hex($data), $digest,
            "shabal_512_hex: $len bits of $msg"
        );
        ok(
            shabal_512($data) eq pack('H*', $digest),
            "shabal_512: $len bits of $msg"
        );
    }

    my $md = Digest::Shabal->new(512)->add_bits($data, $len)->hexdigest;
    is($md, $digest, "new/add_bits/hexdigest: $msg");
}
continue { $len++ }

__DATA__
00|FC2D5DFF5D70B7F6B1F8C2FCC8C1F9FE9934E54257EDED0CF2B539A2EF0A19CCFFA84F8D9FA135E4BD3C09F590F3A927EBD603AC29EB729E6F2A9AF031AD8DC6
00|5819A0C28164B911EB9AE4DC1D84CA02ABB501F9A19CD9124E2E8339EC44CEFD8EC3B9464DAA6FE0F3AF79E7B31B3BA15F7C47CB7A31C4858E89B4B6D47A619D
C0|0AA3BCB3AAF08B6C68B35FAC5114AF3322A2371597C0FF952F88CF42A91AA4FD08056E1F01CF952F765056394A0F86156F872F78916E7564A1E814888AFAB71D
C0|B02885270F0FFDDF3223A11D00AC9991884959B8B1DC45BECD62D9451AD2C9BE0F9B0D9D103680332C673137F35203364DB56249F63C6E35C237601D5F3B7B32
80|B6E319EE447FD4BE787AA3B4FD253F17B60546082216CCB030DB392738D66E4AEBC6B79DB4A89391E2F11CF8BF3C419BF40D847B548C8FBBCD20FBEC6353D4F8
48|B4AF26972455F2AB213C179257876A04FC1CC7E976E84A6CB737F3B9AE9008765B3EF8CD445E3F24A0E5D11B8ABDACD4977105E635A0B72C812D87817EFE5749
50|8E23C77945EDEBA20AE3AA08E068E8139C0D3ADB6C51ED4F6637AEEFA4391FF78CCF1546094265DB7DCC1BF9A69E65F5E2DE200A4AA3853B39ECCBF9276B8856
98|5879B18603BF020A4166887F7BC48EAA4DDAC7BBC6CC3B6B007FA97ACAC90137A7FDE7F72DA9C5A76C7B23DFE91DBF189ABBD4711AA7709C61E4AD4FAB5008F1
CC|DA2621AC83FA9ED23E2FD977CDBA8906492E7C9405940974A4017C61A9615BB32A3EC0FF89937B58395168B012175973DEA0DEF7B4412C4C1ED80E5B2D9A6AD0
9800|5D899C2F0A606983F5BFA7DE8D8B8C625593D8A1C413187805B00B4D74860785E8DD9D52FBBA04F7DAC8AF9B51EADE799BD9875448821814BBD68AD67E3CCC3A
9D40|B8EB687E5F0B8D916072BB082CC8C5861B61410E5A04D4F2783011ED230B1FCEBC2A147643A8609310154247743B9E0DF19C6D8A4C3075EFF53F0FE1EC4BEACF
AA80|71209DA8D78EA729C7043BEE4509C43B40C6577E27782374AFCDAD5D5CC717A3413E77800849C1A72C8401C9C52517C7DBE5378890F1ECFD4D596D170AD5B8A9
9830|664BBF98B0144BB50EE253412F868C4DF00D98DD5E3D963AE8FCBF01685F3786E6757E99204D9CD0C1940C9A4DE43E11508FD800199004F7B848306CACB96077
5030|BD93430BA374121219FA74E9F195DAA98BBC6C8E459DE7C32985F0345AFBB05AB9D2C11BA591AABE114059A22D07BEBF6120683A258E4078BAF958AC5BE10FF4
4D24|AE21C7D603F80A0A91F56B37EABB0B33B38B6EE80447E33C0B921EF9AA2B320407D108C5A2CA0E6A1D05E732611337A7637E45B0C7D05E69B10EBBDE567E03CC
CBDE|5CFF25FAADAC1E432B66BE53320660FF0A55A63C7BA210EBDDFB7AF9F9BE92275CE5DEABE4D9295B296F849AA297F48DF75641840D931056C6BEB7FD07BC9F5E
41FB|4632729E95EEF7A43E701F85C9754506D00AC7EA239A7772B920580A93C95DAAFCD9ACC5E29BEF2D6FA954355F80095E3521BD1665E5D1FCB079706676319267
4FF400|E7592A72C3AF449BAEF15FAEAEAD1ABF6DE3F2B25C8D49679B5748B860CE2420E2E62990A51687FB059E7F99AF8467511C5AA918026A5CDF50FC3E60DD51124E
FD0440|0F94E331D6505095E39919927FF95FAE0C59D20F20A12B9E9213D2DADACC267D9F85F3AC25423D8502D54063597E9EE6FCBAAF6F9F045FAF7DCFE350FA0CB37B
424D00|0448570038E72394C98B6F52C81D9E4CB13BA619BF739AE2DCC6C726402B29EDDE1C9335E99A1EFA779E2CDE24D03F916AD248AC03D1E226AD37B266592ADA92
3FDEE0|615E6E47A155D968AE7A8FB60C418EDA8995850B86E6B1B6225C43B774E2949EA374C38D4206B1A1BA4B2A7262908CB77FD3FD0056ED1743599E66D0BABB2BFC
335768|F7C060701DC05B8EAAB4DDE010827B0B8463D0C399A909E363CAA365FC94042773E5DF4FF884A5BC5CB0F2A3BB7557C55A65D6279E24E8961C1C9610235D4D0F
051E7C|E4AD9079D73C39CA17DCAA25B62945D6876E95AE0D732D149F7E4F1C062B6F75ED06B3599B5E02976B75A7583E78A381752D23DB6748313E45FD41F8CA55D1A4
717F8C|A00BEC3413A243747832703BE59068F099EDCFCB7C3D560D4D153105525B068846A1E33701146E30CBFF4C0F17DFD320C6DBAD6FF59D185530BB70F9EBB3535B
1F877C|6E1D4A235CFDAD76F8A51396624A28E0B403CC172B94FA3AC198848F66B4033107B5C15F67DA912358B4F3FEDC85496B4CA5FEAFBE1E6FDAA921CD6F63F76772
EB35CF80|AA1BD2B73B9C91EC10BEDFAB6C0D0CCDBB25126652FA2428C0212F148577E3CFE27B88621D8281B9E146411B3901DD5B9ABA0D957E8D47C1C0EA8AFEDD895930
B406C480|DB330C4280FC35BED2FEB513B77C652228E7E343BD0FF4F72D8215D162705137CA090AAE26206A1519DC208532E93786616EE5547D25BA3F97361F0A71E8BB79
CEE88040|1356C20D90F3EED226B5328A24E365D4379F7C45AB0836DDFC5844ECC82303AC435CB9DC826D15FDECC9DED2FF948F54FBE21F30D6A432F4773963138D0CCE74
C584DB70|F4A86E1F206A1A2349E746A9498F8B51100B3743DFBDDC28573BA6C5F5D5ABBDA4E8CB1D7564F49BFCB55B0E72F46F66EEDE8EB30194379F97B6C49395B22AC2
53587BC8|5411FB56DFADEC7F578E41F7DD20F05A151A0271510A09CA0A7B1E73733191595F544AFEA509DFCB99855FF0463E2D9EA14761EF5CEE5C547578E567F99B5DAA
69A305B0|83C2100CD3D25C972BD8101161ED289CAE2C3BF30EBB72D31C627C35FAE2E6D0978FDAE83F696E798C11C57712FFE89D7D1CA7165C65F1952CB88A2837C96887
C9375ECE|4D3104810401651BB760F809321C772BBC7EE6C9DE715B9E21B3C4D45AFE39CA480743DBE56B1F20726D4E6ACE874597AF4EBEA021091EC9EF6D5724986BE3F9
C1ECFDFC|9C97939F8AE8F7A2EEF79871CD5DEAD034B2473EA42A1A07851B343F694B2ECF64DA457E75526241F5CC419686F85C9F537C88686057FC3D5DC3546306A30750
8D73E8A280|6B085A3942F523A443DC070F0913B9B6DD3579EFA428BC4C59BE3AB5CCF2A9B5537C3EDEDF1361039550FB84BCA026F34F1CB0F4D36AD74AFA5E718628F6C41C
06F2522080|72B87B19A61B371B958AF5F3C3CACF8A7C505E9EB17A2DD49D5136755F3C089A1ABB43BA0CC8E8D5B48DDFA2414F31DF96998BDAD94C58D422A8D45CEF9F94D4
3EF6C36F20|9B2B36A526A55A4EA86FD712976EDB3E0B23EC379620C164B9BF8B827823DE97412B58CD052403E215EA6D170BD7274CCC237C6D0B9C8D96C564652FFBA7E76E
0127A1D340|51F0F4B00BA2C7821E0FD44088BFA73B6499D23EE3EC94DCA7B8298DFAE31F5399F94B257EB26035D95F1A7E88C4D04892A0E3C807811F281224B49962DA1BE4
6A6AB6C210|F4EF4CAA3F889F2ED25F7F321805B143C85B244AEB8C144757417A5A61C2BBF9ABF6D39C21BD8949930BC93AB65E785E55EED69D10D96CE03F727BB94534BA93
AF3175E160|F829C4298A53D48D47E71BEA61C649BB8C4B9AC918D817AF706C6ED95F91FDE85204AD246A205AACD03A90EB72B69CAF4207180BC5041474CF5CE5E2CDB04AC2
B66609ED86|F1105FA422EB203358E438B4634E11303D864DBAFFF8AB135F8DDE241E5BF70FDC62EDB53FD89590C069CFF4468F33B405C5511481F27C5F68B6BEC1F4DAC399
21F134AC57|54B1595BF9419F3B84502DD448B00D01731EAEA413D4915802AFC9FA7C571FFE5488E042BAC81F898367873417341C90F6D0AC43743DB8BE96B362F5EB5E3D7E
3DC2AADFFC80|2E4378529F8739405EE4E72B642841C9FE02565CD080829DAA427670CF60623D46B57BD8177FC0D68824E22A329CF50902AC9C3F537B6019608F2B26DF18B228
9202736D2240|872FD1BF2DDA35CFB429BD6B1C2C86355581FF6CFB7E22DFC08E1A797DA6BED5A033D5F153FB95037B8B0C5A87C76AE14D2308CE81CE906A5C19996218DFBA55
F219BD629820|844B4298B0BE465F673DE2F401486C1AF3EA51FF14DEA850F8B0905A979A9941794B608F8DD5DB7506587C710F66FB5E32E48A24837E4170BC33E27D62D5DA54
F3511EE2C4B0|927EAFF0221AD1B8C2A721DFC5C12B4C938E6099BF958B38B1A53F9DAC3416157A71DD9A7408095059558E5E1CFB32D8ABCEC9EBFD2A3C18DDA181ECD8699DFE
3ECAB6BF7720|E5B8C833736D2F80EE7481C91C3F63BAAC9FF20324422938A9B700183B3ECBF3726B2F7E995E36C8096E3FDA51152573991EE99C68C1EE1C213A56D4B7B233D0
CD62F688F498|1756FB4D6491CEF78C53FC904D7135E361FCE8E8D39D3660AB99F736464280AF12DD996E130411CA3F00E89B128235DFEC2783CBB1510B65203AF395FB034218
C2CBAA33A9F8|E7D02F98949E32D4877328B4EA4A5A0CC18F8310A9D3ED30D4E342B1F18059CFEE70F5107CB75B96BA98A2F5AC0C9455344B4EB7292C785BCAF9EE6A13C118CE
C6F50BB74E29|10CA666FC70B270D026F5474149FCEF7BF22B1BDD7BF4A9CD2CCE0E712096B994C05470B6E923EF342E66F2F785A984A81E638B66502043CEB8315764D2F29ED
79F1B4CCC62A00|CEA5472B5551EB505DE9ED8CA55D47E8A97FBB5C878B1B47A9871A47FD7916D968F5AE9D0D951B8F3FE5E79E8245C9477D909FE40435604D05DB8D8B3C4ED2A5
