# NOTE: Derived from blib/lib/Tk/CmdLine.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Tk::CmdLine;

#line 303 "blib/lib/Tk/CmdLine.pm (autosplit into blib/lib/auto/Tk/CmdLine/SetResources.al)"
#/----------------------------------------------------------------------------//
#/ Set the initial resources.
#/   Returns the object reference.
#/----------------------------------------------------------------------------//

sub SetResources # Tk::CmdLine::SetResources((\@resource | $resource) [, $priority])
{
    my $self = (@_ # define the object as necessary
        ? ((ref($_[0]) eq $ThisModule)
            ? shift(@_)
            : (($_[0] eq $ThisModule) ? shift(@_) : 1) && ($OBJECT ||= $ThisModule->new()))
        : ($OBJECT ||= $ThisModule->new()));
    $OBJECT = $self; # update the current object

    $self->SetArguments() unless exists($self->{offset}); # set arguments if not yet done
    return $self unless @_;

    my $data      = shift(@_);
    my $priority  = shift(@_) || 'userDefault';

    $self->{resources}->{$priority} = [] unless exists($self->{resources}->{$priority});

    foreach my $resource ((ref($data) eq 'ARRAY') ? @{$data} : $data)
    {
        if (ref($resource) eq 'ARRAY') # resources in [ <pattern>, <value> ] format
        {
            push(@{$self->{resources}->{$priority}}, [ @{$resource} ])
                if (@{$resource} == 2);
        }
        else # resources in resource file format
        {
            push(@{$self->{resources}->{$priority}}, [ $1, $2 ])
                if ($resource =~ /^([^!:\s]+)*\s*:\s*(.*)$/);
        }
    }

    return $self;
}

# end of Tk::CmdLine::SetResources
1;
