# for developers:
#   "cpanm < author/requires.cpanm" will install all the modules required
#   "make test_with_env" does all the extra tests (with pure Perl, Moose, etc.)
use strict;
use warnings;
BEGIN{
    $INC{'Module/Install/ExtraTests.pm'} = 1;# considered harmful!
}
use inc::Module::Install;
use Module::Install::XSUtil 0.36;
use Module::Install::AuthorTests;
use Module::Install::TestTarget;

all_from 'lib/Text/Xslate.pm';

requires 'Any::Moose' => '0.13';

# XXX we don't handle Moose stuff here
requires 'Mouse'                => '0.61';
requires 'MouseX::Getopt'       => '0.2601';
requires 'Data::MessagePack'    => '0.30';
requires 'parent'               => '0.221';
requires 'Scalar::Util'         => '1.14';

test_requires 'Test::More' => 0.88; # done_testing()
test_requires 'Test::Requires';
#test_requires 'Test::LeakTrace';

install_script 'xslate';

tests_recursive;
author_tests 'xt';

my $want_xs = want_xs();
if($want_xs) {
    use_xshelper;
    cc_warnings;

    cc_src_paths qw(xs);
}


homepage 'http://xslate.org/';
repository 'git://github.com/gfx/p5-Text-Xslate.git';


system "$^X tool/opcode.PL xs/xslate_opcode.inc >xslate_ops.h";
system "$^X tool/opcode_for_pp.PL xs/xslate_opcode.inc > lib/Text/Xslate/PP/Const.pm";

postamble <<'M';
xs/Text-Xslate.xs :: xs/xslate_opcode.inc

# xslate_ops.h is automatically generated by xs/Text-Xslate.xs
xslate_ops.h :: xs/xslate_opcode.inc tool/opcode.PL
	$(PERLRUNINST) tool/opcode.PL xs/xslate_opcode.inc >xslate_ops.h

lib/Text/Xslate/PP/Const.pm :: xs/xslate_opcode.inc tool/opcode_for_pp.PL
	$(PERLRUNINST) tool/opcode_for_pp.PL xs/xslate_opcode.inc > lib/Text/Xslate/PP/Const.pm
M

if(eval q{ use Moose 1.05 (); 1}) {
    test_target test_moose => (
        env    => { ANY_MOOSE => 'Moose' },
    );
}

my @testall;
if($Module::Install::AUTHOR) {
    @testall = (alias => 'test');
}

if($want_xs) {
    # default pp backend is pp_booster
    test_target test_pp => (
        env    => { PERL_ONLY => 1 },
        @testall,
    );

    # optional pp backend
    test_target test_pp_opcode => (
        env    => { XSLATE => 'pp=opcode' },
        @testall,
    );
}

clean_files qw(
    Text-Xslate-*
    nytprof *.out
    cover_db
    .xslate_cache
);

WriteAll(check_nmake => 0);

