# for developers:
#   "cpanm < author/requires.cpanm" will install all the modules required
#   "make test_with_env" does all the extra tests (with pure Perl, Moose, etc.)
use strict;
use warnings;
BEGIN{
    $INC{'Module/Install/ExtraTests.pm'} = 1;# considered harmful!
}
use inc::Module::Install;
use Module::Install::XSUtil 0.30;
use Module::Install::AuthorTests;

all_from 'lib/Text/Xslate.pm';

requires 'Any::Moose' => '0.13';

# XXX we don't handle Moose stuff here
requires 'Mouse'                => '0.61';
requires 'MouseX::Getopt'       => '0.2601';
requires 'parent'               => '0.221';
requires 'Scalar::Util'         => '1.23';

test_requires 'Test::More' => 0.88; # done_testing()
test_requires 'Test::Requires';
#test_requires 'Test::LeakTrace';

install_script 'xslate';

tests_recursive;
author_tests 'xt';

my $want_xs = want_xs();
if($want_xs) {
    use_xshelper;
    cc_warnings;

    cc_src_paths qw(xs);
}


homepage 'http://xslate.org/';
repository 'git://github.com/gfx/p5-Text-Xslate.git';


system "$^X tool/opcode.PL xs/xslate_opcode.inc >xslate_ops.h";
system "$^X tool/opcode_for_pp.PL xs/xslate_opcode.inc > lib/Text/Xslate/PP/Const.pm";

postamble <<'M';
xs/Text-Xslate.xs :: xs/xslate_opcode.inc

# xslate_ops.h is automatically generated by xs/Text-Xslate.xs
xslate_ops.h :: xs/xslate_opcode.inc tool/opcode.PL
	$(PERLRUNINST) tool/opcode.PL xs/xslate_opcode.inc >xslate_ops.h

lib/Text/Xslate/PP/Const.pm :: xs/xslate_opcode.inc tool/opcode_for_pp.PL
	$(PERLRUNINST) tool/opcode_for_pp.PL xs/xslate_opcode.inc > lib/Text/Xslate/PP/Const.pm
M

sub test_with_env;

if(eval q{ use Moose 1.05 (); 1}) {
    test_with_env test_moose => (
        ANY_MOOSE => 'Moose',
    );
}

if($want_xs) {
    test_with_env test_pp => (
        XSLATE         => 'pp',
        MOUSE_PUREPERL => 1,
    );

    test_with_env test_pp_opcode => (
        XSLATE => 'pp=opcode',
    );

    test_with_env test_pp_booster => (
        XSLATE => 'pp=booster',
    );

}

if($Module::Install::AUTHOR) {
    postamble qq{test :: test_pp_opcode test_pp_booster\n\n};
}

sub test_with_env {
    my($name, %env) = @_;

    my $dir = '.testenv';
    if(not -e $dir) {
        mkdir $dir or die "Cannot mkdir '.testenv': $!";
    }
    clean_files($dir);

    {
        open my $out, '>', "$dir/$name.pl"
            or die "Cannot open '$dir/$name.pl' for writing: $!";
       print $out "# This file sets the env for 'make $name', \n";
       print $out "# generated by $0 at ", scalar(localtime), ".\n";
       print $out "# DO NOT EDIT THIS FILE DIRECTLY.\n";
       print $out "\n";

        while(my($name, $value) = each %env) {
            printf $out '$ENV{q{%s}} = q{%s};'."\n", $name, $value;
        }
    }

    # repeat testing for pure Perl mode
    # see also ExtUtils::MM_Any::test_via_harness()

    my $t =  q{$(FULLPERLRUN) -MExtUtils::Command::MM -e}
            .q{ "do q[%s]; test_harness($(TEST_VERBOSE), '$(INST_LIB)', '$(INST_ARCHLIB)')"}
            .q{ $(TEST_FILES)};

    postamble qq{$name :: pure_all\n}
            . qq{\t} . q{$(NOECHO) $(ECHO) TESTING: } . $name . qq{\n}
            . qq{\t} . sprintf($t, "$dir/$name.pl") . qq{\n\n}

            . qq{testall :: $name\n\n};
    return;
}

clean_files qw(
    Text-Xslate-*
    nytprof *.out
    cover_db
    .xslate_cache
);

WriteAll(check_nmake => 0);

