package Test::WebService::FitBit::intraday_calories_burned;
use base 'Test::WebService::FitBit::BASE';

use strictures 1;

use Test::More;

sub intraday_calories_burned :Test(2) {
  my $test = shift;

  my $test_data = _test_data();

  my @log = $test->{fb}->intraday_calories_burned();
  is_deeply( \@log , $test_data , 'intraday_calories_burned' );

  my @log_by_date = $test->{fb}->intraday_calories_burned('2010-10-20');
  is_deeply( \@log_by_date , $test_data , 'intraday_calories_burned with date ' );
}

sub _test_data {
  return [
    { '00:00' => '8.0' } ,
    { '00:05' => '6.0' } ,
    { '00:10' => '6.0' } ,
    { '00:15' => '6.0' } ,
    { '00:20' => '6.0' } ,
    { '00:25' => '6.0' } ,
    { '00:30' => '6.0' } ,
    { '00:35' => '8.0' } ,
    { '00:40' => '6.0' } ,
    { '00:45' => '6.0' } ,
    { '00:50' => '8.0' } ,
    { '00:55' => '6.0' } ,
    { '01:00' => '8.0' } ,
    { '01:05' => '11.0' } ,
    { '01:10' => '8.0' } ,
    { '01:15' => '6.0' } ,
    { '01:20' => '12.0' } ,
    { '01:25' => '6.0' } ,
    { '01:30' => '6.0' } ,
    { '01:35' => '6.0' } ,
    { '01:40' => '6.0' } ,
    { '01:45' => '6.0' } ,
    { '01:50' => '6.0' } ,
    { '01:55' => '6.0' } ,
    { '02:00' => '6.0' } ,
    { '02:05' => '6.0' } ,
    { '02:10' => '6.0' } ,
    { '02:15' => '11.0' } ,
    { '02:20' => '6.0' } ,
    { '02:25' => '6.0' } ,
    { '02:30' => '6.0' } ,
    { '02:35' => '8.0' } ,
    { '02:40' => '6.0' } ,
    { '02:45' => '6.0' } ,
    { '02:50' => '6.0' } ,
    { '02:55' => '6.0' } ,
    { '03:00' => '6.0' } ,
    { '03:05' => '6.0' } ,
    { '03:10' => '6.0' } ,
    { '03:15' => '11.0' } ,
    { '03:20' => '8.0' } ,
    { '03:25' => '6.0' } ,
    { '03:30' => '6.0' } ,
    { '03:35' => '6.0' } ,
    { '03:40' => '6.0' } ,
    { '03:45' => '6.0' } ,
    { '03:50' => '6.0' } ,
    { '03:55' => '6.0' } ,
    { '04:00' => '6.0' } ,
    { '04:05' => '6.0' } ,
    { '04:10' => '6.0' } ,
    { '04:15' => '6.0' } ,
    { '04:20' => '6.0' } ,
    { '04:25' => '6.0' } ,
    { '04:30' => '14.0' } ,
    { '04:35' => '13.0' } ,
    { '04:40' => '6.0' } ,
    { '04:45' => '10.0' } ,
    { '04:50' => '12.0' } ,
    { '04:55' => '6.0' } ,
    { '05:00' => '6.0' } ,
    { '05:05' => '13.0' } ,
    { '05:10' => '6.0' } ,
    { '05:15' => '6.0' } ,
    { '05:20' => '8.0' } ,
    { '05:25' => '6.0' } ,
    { '05:30' => '6.0' } ,
    { '05:35' => '6.0' } ,
    { '05:40' => '6.0' } ,
    { '05:45' => '6.0' } ,
    { '05:50' => '6.0' } ,
    { '05:55' => '0.0' } ,
    { '06:00' => '0.0' } ,
    { '06:05' => '0.0' } ,
    { '06:10' => '0.0' } ,
    { '06:15' => '0.0' } ,
    { '06:20' => '0.0' } ,
    { '06:25' => '0.0' } ,
    { '06:30' => '0.0' } ,
    { '06:35' => '0.0' } ,
    { '06:40' => '0.0' } ,
    { '06:45' => '0.0' } ,
    { '06:50' => '0.0' } ,
    { '06:55' => '0.0' } ,
    { '07:00' => '0.0' } ,
    { '07:05' => '0.0' } ,
    { '07:10' => '0.0' } ,
    { '07:15' => '0.0' } ,
    { '07:20' => '0.0' } ,
    { '07:25' => '0.0' } ,
    { '07:30' => '0.0' } ,
    { '07:35' => '0.0' } ,
    { '07:40' => '0.0' } ,
    { '07:45' => '0.0' } ,
    { '07:50' => '0.0' } ,
    { '07:55' => '0.0' } ,
    { '08:00' => '0.0' } ,
    { '08:05' => '0.0' } ,
    { '08:10' => '0.0' } ,
    { '08:15' => '0.0' } ,
    { '08:20' => '0.0' } ,
    { '08:25' => '0.0' } ,
    { '08:30' => '0.0' } ,
    { '08:35' => '0.0' } ,
    { '08:40' => '0.0' } ,
    { '08:45' => '0.0' } ,
    { '08:50' => '0.0' } ,
    { '08:55' => '0.0' } ,
    { '09:00' => '0.0' } ,
    { '09:05' => '0.0' } ,
    { '09:10' => '0.0' } ,
    { '09:15' => '0.0' } ,
    { '09:20' => '0.0' } ,
    { '09:25' => '0.0' } ,
    { '09:30' => '0.0' } ,
    { '09:35' => '0.0' } ,
    { '09:40' => '0.0' } ,
    { '09:45' => '0.0' } ,
    { '09:50' => '0.0' } ,
    { '09:55' => '0.0' } ,
    { '10:00' => '0.0' } ,
    { '10:05' => '0.0' } ,
    { '10:10' => '0.0' } ,
    { '10:15' => '0.0' } ,
    { '10:20' => '0.0' } ,
    { '10:25' => '0.0' } ,
    { '10:30' => '0.0' } ,
    { '10:35' => '0.0' } ,
    { '10:40' => '0.0' } ,
    { '10:45' => '0.0' } ,
    { '10:50' => '0.0' } ,
    { '10:55' => '0.0' } ,
    { '11:00' => '0.0' } ,
    { '11:05' => '0.0' } ,
    { '11:10' => '0.0' } ,
    { '11:15' => '0.0' } ,
    { '11:20' => '0.0' } ,
    { '11:25' => '0.0' } ,
    { '11:30' => '0.0' } ,
    { '11:35' => '0.0' } ,
    { '11:40' => '0.0' } ,
    { '11:45' => '0.0' } ,
    { '11:50' => '0.0' } ,
    { '11:55' => '0.0' } ,
    { '12:00' => '0.0' } ,
    { '12:05' => '0.0' } ,
    { '12:10' => '0.0' } ,
    { '12:15' => '0.0' } ,
    { '12:20' => '0.0' } ,
    { '12:25' => '0.0' } ,
    { '12:30' => '0.0' } ,
    { '12:35' => '0.0' } ,
    { '12:40' => '0.0' } ,
    { '12:45' => '0.0' } ,
    { '12:50' => '0.0' } ,
    { '12:55' => '0.0' } ,
    { '13:00' => '0.0' } ,
    { '13:05' => '0.0' } ,
    { '13:10' => '0.0' } ,
    { '13:15' => '0.0' } ,
    { '13:20' => '0.0' } ,
    { '13:25' => '0.0' } ,
    { '13:30' => '0.0' } ,
    { '13:35' => '0.0' } ,
    { '13:40' => '0.0' } ,
    { '13:45' => '0.0' } ,
    { '13:50' => '0.0' } ,
    { '13:55' => '0.0' } ,
    { '14:00' => '0.0' } ,
    { '14:05' => '0.0' } ,
    { '14:10' => '0.0' } ,
    { '14:15' => '0.0' } ,
    { '14:20' => '0.0' } ,
    { '14:25' => '0.0' } ,
    { '14:30' => '0.0' } ,
    { '14:35' => '0.0' } ,
    { '14:40' => '0.0' } ,
    { '14:45' => '0.0' } ,
    { '14:50' => '0.0' } ,
    { '14:55' => '0.0' } ,
    { '15:00' => '0.0' } ,
    { '15:05' => '0.0' } ,
    { '15:10' => '0.0' } ,
    { '15:15' => '0.0' } ,
    { '15:20' => '0.0' } ,
    { '15:25' => '0.0' } ,
    { '15:30' => '0.0' } ,
    { '15:35' => '0.0' } ,
    { '15:40' => '0.0' } ,
    { '15:45' => '0.0' } ,
    { '15:50' => '0.0' } ,
    { '15:55' => '0.0' } ,
    { '16:00' => '0.0' } ,
    { '16:05' => '0.0' } ,
    { '16:10' => '0.0' } ,
    { '16:15' => '0.0' } ,
    { '16:20' => '0.0' } ,
    { '16:25' => '0.0' } ,
    { '16:30' => '0.0' } ,
    { '16:35' => '0.0' } ,
    { '16:40' => '0.0' } ,
    { '16:45' => '0.0' } ,
    { '16:50' => '0.0' } ,
    { '16:55' => '0.0' } ,
    { '17:00' => '0.0' } ,
    { '17:05' => '0.0' } ,
    { '17:10' => '0.0' } ,
    { '17:15' => '0.0' } ,
    { '17:20' => '0.0' } ,
    { '17:25' => '0.0' } ,
    { '17:30' => '0.0' } ,
    { '17:35' => '0.0' } ,
    { '17:40' => '0.0' } ,
    { '17:45' => '0.0' } ,
    { '17:50' => '0.0' } ,
    { '17:55' => '0.0' } ,
    { '18:00' => '0.0' } ,
    { '18:05' => '0.0' } ,
    { '18:10' => '0.0' } ,
    { '18:15' => '0.0' } ,
    { '18:20' => '0.0' } ,
    { '18:25' => '0.0' } ,
    { '18:30' => '0.0' } ,
    { '18:35' => '0.0' } ,
    { '18:40' => '0.0' } ,
    { '18:45' => '0.0' } ,
    { '18:50' => '0.0' } ,
    { '18:55' => '0.0' } ,
    { '19:00' => '0.0' } ,
    { '19:05' => '0.0' } ,
    { '19:10' => '0.0' } ,
    { '19:15' => '0.0' } ,
    { '19:20' => '0.0' } ,
    { '19:25' => '0.0' } ,
    { '19:30' => '0.0' } ,
    { '19:35' => '0.0' } ,
    { '19:40' => '0.0' } ,
    { '19:45' => '0.0' } ,
    { '19:50' => '0.0' } ,
    { '19:55' => '0.0' } ,
    { '20:00' => '0.0' } ,
    { '20:05' => '0.0' } ,
    { '20:10' => '0.0' } ,
    { '20:15' => '0.0' } ,
    { '20:20' => '0.0' } ,
    { '20:25' => '0.0' } ,
    { '20:30' => '0.0' } ,
    { '20:35' => '0.0' } ,
    { '20:40' => '0.0' } ,
    { '20:45' => '0.0' } ,
    { '20:50' => '0.0' } ,
    { '20:55' => '0.0' } ,
    { '21:00' => '0.0' } ,
    { '21:05' => '0.0' } ,
    { '21:10' => '0.0' } ,
    { '21:15' => '0.0' } ,
    { '21:20' => '0.0' } ,
    { '21:25' => '0.0' } ,
    { '21:30' => '0.0' } ,
    { '21:35' => '0.0' } ,
    { '21:40' => '0.0' } ,
    { '21:45' => '0.0' } ,
    { '21:50' => '0.0' } ,
    { '21:55' => '0.0' } ,
    { '22:00' => '0.0' } ,
    { '22:05' => '0.0' } ,
    { '22:10' => '0.0' } ,
    { '22:15' => '0.0' } ,
    { '22:20' => '0.0' } ,
    { '22:25' => '0.0' } ,
    { '22:30' => '0.0' } ,
    { '22:35' => '0.0' } ,
    { '22:40' => '0.0' } ,
    { '22:45' => '0.0' } ,
    { '22:50' => '0.0' } ,
    { '22:55' => '0.0' } ,
    { '23:00' => '0.0' } ,
    { '23:05' => '0.0' } ,
    { '23:10' => '0.0' } ,
    { '23:15' => '0.0' } ,
    { '23:20' => '0.0' } ,
    { '23:25' => '0.0' } ,
    { '23:30' => '0.0' } ,
    { '23:35' => '0.0' } ,
    { '23:40' => '0.0' } ,
    { '23:45' => '0.0' } ,
    { '23:50' => '0.0' } ,
    { '23:55' => '0.0' } ,
  ]
}

1;
