use v6-alpha;
use Test;
use v6;
use Test;

=pod

This file was originally derived from the perl5 CPAN module Perl6::Rules,
version 0.3 (12 Apr 2004), file t/named_chars.t.

=cut
plan 200;

if !eval('("a" ~~ /a/)') {
  skip_rest "skipped tests - rules support appears to be missing";
} else {

ok("abc\x[a]def" ~~ m/\c[LINE FEED (LF)]/, 'Unanchored named LINE FEED (LF)');
ok("abc\c[LINE FEED (LF)]def" ~~ m/\x[A]/, 'Unanchored \x[A]');
ok("abc\c[LINE FEED (LF)]def" ~~ m/\o[12]/, 'Unanchored \o[12]');
ok("abc\x[a]def" ~~ m/^ abc \c[LINE FEED (LF)] def $/, 'Anchored LINE FEED (LF)');
ok("abc\x[c]def" ~~ m/\c[FORM FEED (FF)]/, 'Unanchored named FORM FEED (FF)');
ok("abc\c[FORM FEED (FF)]def" ~~ m/\x[C]/, 'Unanchored \x[C]');
ok("abc\c[FORM FEED (FF)]def" ~~ m/\o[14]/, 'Unanchored \o[14]');
ok("abc\x[c]def" ~~ m/^ abc \c[FORM FEED (FF)] def $/, 'Anchored FORM FEED (FF)');
ok("abc\x[c]\x[a]def" ~~ m/\c[FORM FEED (FF); LINE FEED (LF)]/, 'Multiple FORM FEED (FF); LINE FEED (LF)');
ok("\x[c]\x[a]" ~~ m/<[\c[FORM FEED (FF); LINE FEED (LF)]]>/, 'Charclass multiple FORM FEED (FF); LINE FEED (LF)');
ok(!( "\x[c]\x[a]" ~~ m/^ <-[\c[FORM FEED (FF); LINE FEED (LF)]]>/ ), 'Negative charclass FORM FEED (FF); LINE FEED (LF)');
ok(!( "\x[c]" ~~ m/^ \C[FORM FEED (FF)]/ ), 'Negative named FORM FEED (FF) nomatch');
ok("\x[a]" ~~ m/^ \C[FORM FEED (FF)]/, 'Negative named FORM FEED (FF) match');
ok(!( "\x[c]" ~~ m/^ <[\C[FORM FEED (FF)]]>/ ), 'Negative charclass named FORM FEED (FF) nomatch');
ok("\x[a]" ~~ m/^ <[\C[FORM FEED (FF)]]>/, 'Negative charclass named FORM FEED (FF) match');
ok(!( "\x[c]" ~~ m/^ \X[C]/ ), 'Negative hex \X[C] nomatch');
ok(!( "\x[c]" ~~ m/^ <[\X[C]]>/ ), 'Negative charclass hex \X[C] nomatch');
ok("\x[c]" ~~ m/^ \X[A]/, 'Negative hex \X[A] match');
ok("\x[c]" ~~ m/^ <[\X[A]]>/, 'Negative charclass hex \X[A] match');
ok("abc\x[d]def" ~~ m/\c[CARRIAGE RETURN (CR)]/, 'Unanchored named CARRIAGE RETURN (CR)');
ok("abc\c[CARRIAGE RETURN (CR)]def" ~~ m/\x[d]/, 'Unanchored \x[d]');
ok("abc\c[CARRIAGE RETURN (CR)]def" ~~ m/\o[15]/, 'Unanchored \o[15]');
ok("abc\x[d]def" ~~ m/^ abc \c[CARRIAGE RETURN (CR)] def $/, 'Anchored CARRIAGE RETURN (CR)');
ok("abc\x[d]\x[c]def" ~~ m/\c[CARRIAGE RETURN (CR); FORM FEED (FF)]/, 'Multiple CARRIAGE RETURN (CR); FORM FEED (FF)');
ok("\x[d]\x[c]" ~~ m/<[\c[CARRIAGE RETURN (CR); FORM FEED (FF)]]>/, 'Charclass multiple CARRIAGE RETURN (CR); FORM FEED (FF)');
ok(!( "\x[d]\x[c]" ~~ m/^ <-[\c[CARRIAGE RETURN (CR); FORM FEED (FF)]]>/ ), 'Negative charclass CARRIAGE RETURN (CR); FORM FEED (FF)');
ok(!( "\x[d]" ~~ m/^ \C[CARRIAGE RETURN (CR)]/ ), 'Negative named CARRIAGE RETURN (CR) nomatch');
ok("\x[c]" ~~ m/^ \C[CARRIAGE RETURN (CR)]/, 'Negative named CARRIAGE RETURN (CR) match');
ok(!( "\x[d]" ~~ m/^ <[\C[CARRIAGE RETURN (CR)]]>/ ), 'Negative charclass named CARRIAGE RETURN (CR) nomatch');
ok("\x[c]" ~~ m/^ <[\C[CARRIAGE RETURN (CR)]]>/, 'Negative charclass named CARRIAGE RETURN (CR) match');
ok(!( "\x[d]" ~~ m/^ \X[D]/ ), 'Negative hex \X[D] nomatch');
ok(!( "\x[d]" ~~ m/^ <[\X[D]]>/ ), 'Negative charclass hex \X[D] nomatch');
ok("\x[d]" ~~ m/^ \X[C]/, 'Negative hex \X[C] match');
ok("\x[d]" ~~ m/^ <[\X[C]]>/, 'Negative charclass hex \X[C] match');
ok("abc\x[85]def" ~~ m/\c[NEXT LINE (NEL)]/, 'Unanchored named NEXT LINE (NEL)');
ok("abc\c[NEXT LINE (NEL)]def" ~~ m/\x[85]/, 'Unanchored \x[85]');
ok("abc\c[NEXT LINE (NEL)]def" ~~ m/\o[205]/, 'Unanchored \o[205]');
ok("abc\x[85]def" ~~ m/^ abc \c[NEXT LINE (NEL)] def $/, 'Anchored NEXT LINE (NEL)');
ok("abc\x[85]\x[d]def" ~~ m/\c[NEXT LINE (NEL); CARRIAGE RETURN (CR)]/, 'Multiple NEXT LINE (NEL); CARRIAGE RETURN (CR)');
ok("\x[85]\x[d]" ~~ m/<[\c[NEXT LINE (NEL); CARRIAGE RETURN (CR)]]>/, 'Charclass multiple NEXT LINE (NEL); CARRIAGE RETURN (CR)');
ok(!( "\x[85]\x[d]" ~~ m/^ <-[\c[NEXT LINE (NEL); CARRIAGE RETURN (CR)]]>/ ), 'Negative charclass NEXT LINE (NEL); CARRIAGE RETURN (CR)');
ok(!( "\x[85]" ~~ m/^ \C[NEXT LINE (NEL)]/ ), 'Negative named NEXT LINE (NEL) nomatch');
ok("\x[d]" ~~ m/^ \C[NEXT LINE (NEL)]/, 'Negative named NEXT LINE (NEL) match');
ok(!( "\x[85]" ~~ m/^ <[\C[NEXT LINE (NEL)]]>/ ), 'Negative charclass named NEXT LINE (NEL) nomatch');
ok("\x[d]" ~~ m/^ <[\C[NEXT LINE (NEL)]]>/, 'Negative charclass named NEXT LINE (NEL) match');
ok(!( "\x[85]" ~~ m/^ \X[85]/ ), 'Negative hex \X[85] nomatch');
ok(!( "\x[85]" ~~ m/^ <[\X[85]]>/ ), 'Negative charclass hex \X[85] nomatch');
ok("\x[85]" ~~ m/^ \X[D]/, 'Negative hex \X[D] match');
ok("\x[85]" ~~ m/^ <[\X[D]]>/, 'Negative charclass hex \X[D] match');

ok("abc\c[LINE FEED]def" ~~ m/\c[LINE FEED]/, 'Unanchored named LINE FEED');
ok("abc\c[LINE FEED]def" ~~ m/^ abc \c[LINE FEED] def $/, 'Anchored LINE FEED');
ok("abc\c[LINE FEED]\x[85]def" ~~ m/\c[LINE FEED; NEXT LINE (NEL)]/, 'Multiple LINE FEED; NEXT LINE (NEL)');
ok("\c[LINE FEED]\x[85]" ~~ m/<[\c[LINE FEED; NEXT LINE (NEL)]]>/, 'Charclass multiple LINE FEED; NEXT LINE (NEL)');
ok(!( "\c[LINE FEED]\x[85]" ~~ m/^ <-[\c[LINE FEED; NEXT LINE (NEL)]]>/ ), 'Negative charclass LINE FEED; NEXT LINE (NEL)');
ok(!( "\c[LINE FEED]" ~~ m/^ \C[LINE FEED]/ ), 'Negative named LINE FEED nomatch');
ok("\x[85]" ~~ m/^ \C[LINE FEED]/, 'Negative named LINE FEED match');
ok(!( "\c[LINE FEED]" ~~ m/^ <[\C[LINE FEED]]>/ ), 'Negative charclass named LINE FEED nomatch');
ok("\x[85]" ~~ m/^ <[\C[LINE FEED]]>/, 'Negative charclass named LINE FEED match');
ok("abc\c[FORM FEED]def" ~~ m/\c[FORM FEED]/, 'Unanchored named FORM FEED');
ok("abc\c[FORM FEED]def" ~~ m/^ abc \c[FORM FEED] def $/, 'Anchored FORM FEED');
ok("abc\c[FORM FEED]\c[LINE FEED]def" ~~ m/\c[FORM FEED; LINE FEED]/, 'Multiple FORM FEED; LINE FEED');
ok("\c[FORM FEED]\c[LINE FEED]" ~~ m/<[\c[FORM FEED; LINE FEED]]>/, 'Charclass multiple FORM FEED; LINE FEED');
ok(!( "\c[FORM FEED]\c[LINE FEED]" ~~ m/^ <-[\c[FORM FEED; LINE FEED]]>/ ), 'Negative charclass FORM FEED; LINE FEED');
ok(!( "\c[FORM FEED]" ~~ m/^ \C[FORM FEED]/ ), 'Negative named FORM FEED nomatch');
ok("\c[LINE FEED]" ~~ m/^ \C[FORM FEED]/, 'Negative named FORM FEED match');
ok(!( "\c[FORM FEED]" ~~ m/^ <[\C[FORM FEED]]>/ ), 'Negative charclass named FORM FEED nomatch');
ok("\c[LINE FEED]" ~~ m/^ <[\C[FORM FEED]]>/, 'Negative charclass named FORM FEED match');
ok("abc\c[CARRIAGE RETURN]def" ~~ m/\c[CARRIAGE RETURN]/, 'Unanchored named CARRIAGE RETURN');
ok("abc\c[CARRIAGE RETURN]def" ~~ m/^ abc \c[CARRIAGE RETURN] def $/, 'Anchored CARRIAGE RETURN');
ok("abc\c[CARRIAGE RETURN]\c[FORM FEED]def" ~~ m/\c[CARRIAGE RETURN;FORM FEED]/, 'Multiple CARRIAGE RETURN;FORM FEED');
ok("\c[CARRIAGE RETURN]\c[FORM FEED]" ~~ m/<[\c[CARRIAGE RETURN;FORM FEED]]>/, 'Charclass multiple CARRIAGE RETURN;FORM FEED');
ok(!( "\c[CARRIAGE RETURN]\c[FORM FEED]" ~~ m/^ <-[\c[CARRIAGE RETURN;FORM FEED]]>/ ), 'Negative charclass CARRIAGE RETURN;FORM FEED');
ok(!( "\c[CARRIAGE RETURN]" ~~ m/^ \C[CARRIAGE RETURN]/ ), 'Negative named CARRIAGE RETURN nomatch');
ok("\c[FORM FEED]" ~~ m/^ \C[CARRIAGE RETURN]/, 'Negative named CARRIAGE RETURN match');
ok(!( "\c[CARRIAGE RETURN]" ~~ m/^ <[\C[CARRIAGE RETURN]]>/ ), 'Negative charclass named CARRIAGE RETURN nomatch');
ok("\c[FORM FEED]" ~~ m/^ <[\C[CARRIAGE RETURN]]>/, 'Negative charclass named CARRIAGE RETURN match');
ok("abc\c[NEXT LINE]def" ~~ m/\c[NEXT LINE]/, 'Unanchored named NEXT LINE');
ok("abc\c[NEXT LINE]def" ~~ m/^ abc \c[NEXT LINE] def $/, 'Anchored NEXT LINE');
ok("abc\c[NEXT LINE]\c[CARRIAGE RETURN]def" ~~ m/\c[NEXT LINE;CARRIAGE RETURN]/, 'Multiple NEXT LINE;CARRIAGE RETURN');
ok("\c[NEXT LINE]\c[CARRIAGE RETURN]" ~~ m/<[\c[NEXT LINE;CARRIAGE RETURN]]>/, 'Charclass multiple NEXT LINE;CARRIAGE RETURN');
ok(!( "\c[NEXT LINE]\c[CARRIAGE RETURN]" ~~ m/^ <-[\c[NEXT LINE;CARRIAGE RETURN]]>/ ), 'Negative charclass NEXT LINE;CARRIAGE RETURN');
ok(!( "\c[NEXT LINE]" ~~ m/^ \C[NEXT LINE]/ ), 'Negative named NEXT LINE nomatch');
ok("\c[CARRIAGE RETURN]" ~~ m/^ \C[NEXT LINE]/, 'Negative named NEXT LINE match');
ok(!( "\c[NEXT LINE]" ~~ m/^ <[\C[NEXT LINE]]>/ ), 'Negative charclass named NEXT LINE nomatch');
ok("\c[CARRIAGE RETURN]" ~~ m/^ <[\C[NEXT LINE]]>/, 'Negative charclass named NEXT LINE match');
ok("abc\c[LF]def" ~~ m/\c[LF]/, 'Unanchored named LF');
ok("abc\c[LF]def" ~~ m/^ abc \c[LF] def $/, 'Anchored LF');
ok("abc\c[LF]\c[NEXT LINE]def" ~~ m/\c[LF; NEXT LINE]/, 'Multiple LF; NEXT LINE');
ok("\c[LF]\c[NEXT LINE]" ~~ m/<[\c[LF; NEXT LINE]]>/, 'Charclass multiple LF; NEXT LINE');
ok(!( "\c[LF]\c[NEXT LINE]" ~~ m/^ <-[\c[LF; NEXT LINE]]>/ ), 'Negative charclass LF; NEXT LINE');
ok(!( "\c[LF]" ~~ m/^ \C[LF]/ ), 'Negative named LF nomatch');
ok("\c[NEXT LINE]" ~~ m/^ \C[LF]/, 'Negative named LF match');
ok(!( "\c[LF]" ~~ m/^ <[\C[LF]]>/ ), 'Negative charclass named LF nomatch');
ok("\c[NEXT LINE]" ~~ m/^ <[\C[LF]]>/, 'Negative charclass named LF match');
ok("abc\c[FF]def" ~~ m/\c[FF]/, 'Unanchored named FF');
ok("abc\c[FF]def" ~~ m/^ abc \c[FF] def $/, 'Anchored FF');
ok("abc\c[FF]\c[LF]def" ~~ m/\c[FF;LF]/, 'Multiple FF;LF');
ok("\c[FF]\c[LF]" ~~ m/<[\c[FF;LF]]>/, 'Charclass multiple FF;LF');
ok(!( "\c[FF]\c[LF]" ~~ m/^ <-[\c[FF;LF]]>/ ), 'Negative charclass FF;LF');
ok(!( "\c[FF]" ~~ m/^ \C[FF]/ ), 'Negative named FF nomatch');
ok("\c[LF]" ~~ m/^ \C[FF]/, 'Negative named FF match');
ok(!( "\c[FF]" ~~ m/^ <[\C[FF]]>/ ), 'Negative charclass named FF nomatch');
ok("\c[LF]" ~~ m/^ <[\C[FF]]>/, 'Negative charclass named FF match');
ok("abc\c[CR]def" ~~ m/\c[CR]/, 'Unanchored named CR');
ok("abc\c[CR]def" ~~ m/^ abc \c[CR] def $/, 'Anchored CR');
ok("abc\c[CR]\c[FF]def" ~~ m/\c[CR;FF]/, 'Multiple CR;FF');
ok("\c[CR]\c[FF]" ~~ m/<[\c[CR;FF]]>/, 'Charclass multiple CR;FF');
ok(!( "\c[CR]\c[FF]" ~~ m/^ <-[\c[CR;FF]]>/ ), 'Negative charclass CR;FF');
ok(!( "\c[CR]" ~~ m/^ \C[CR]/ ), 'Negative named CR nomatch');
ok("\c[FF]" ~~ m/^ \C[CR]/, 'Negative named CR match');
ok(!( "\c[CR]" ~~ m/^ <[\C[CR]]>/ ), 'Negative charclass named CR nomatch');
ok("\c[FF]" ~~ m/^ <[\C[CR]]>/, 'Negative charclass named CR match');
ok("abc\c[NEL]def" ~~ m/\c[NEL]/, 'Unanchored named NEL');
ok("abc\c[NEL]def" ~~ m/^ abc \c[NEL] def $/, 'Anchored NEL');
ok("abc\c[NEL]\c[CR]def" ~~ m/\c[NEL;CR]/, 'Multiple NEL;CR');
ok("\c[NEL]\c[CR]" ~~ m/<[\c[NEL;CR]]>/, 'Charclass multiple NEL;CR');
ok(!( "\c[NEL]\c[CR]" ~~ m/^ <-[\c[NEL;CR]]>/ ), 'Negative charclass NEL;CR');
ok(!( "\c[NEL]" ~~ m/^ \C[NEL]/ ), 'Negative named NEL nomatch');
ok("\c[CR]" ~~ m/^ \C[NEL]/, 'Negative named NEL match');
ok(!( "\c[NEL]" ~~ m/^ <[\C[NEL]]>/ ), 'Negative charclass named NEL nomatch');
ok("\c[CR]" ~~ m/^ <[\C[NEL]]>/, 'Negative charclass named NEL match');
ok("abc\x[fd55]def" ~~ m/\c[ARABIC LIGATURE TEH WITH MEEM WITH JEEM INITIAL FORM]/, 'Unanchored named ARABIC LIGATURE TEH WITH MEEM WITH JEEM INITIAL FORM');
ok("abc\c[ARABIC LIGATURE TEH WITH MEEM WITH JEEM INITIAL FORM]def" ~~ m/\x[fd55]/, 'Unanchored \x[fd55]');
ok("abc\c[ARABIC LIGATURE TEH WITH MEEM WITH JEEM INITIAL FORM]def" ~~ m/\o[176525]/, 'Unanchored \o[176525]');
ok("abc\x[fd55]def" ~~ m/^ abc \c[ARABIC LIGATURE TEH WITH MEEM WITH JEEM INITIAL FORM] def $/, 'Anchored ARABIC LIGATURE TEH WITH MEEM WITH JEEM INITIAL FORM');
ok("abc\x[fd55]\c[NEL]def" ~~ m/\c[ARABIC LIGATURE TEH WITH MEEM WITH JEEM INITIAL FORM;NEL]/, 'Multiple ARABIC LIGATURE TEH WITH MEEM WITH JEEM INITIAL FORM;NEL');
ok("\x[fd55]\c[NEL]" ~~ m/<[\c[ARABIC LIGATURE TEH WITH MEEM WITH JEEM INITIAL FORM;NEL]]>/, 'Charclass multiple ARABIC LIGATURE TEH WITH MEEM WITH JEEM INITIAL FORM;NEL');
ok(!( "\x[fd55]\c[NEL]" ~~ m/^ <-[\c[ARABIC LIGATURE TEH WITH MEEM WITH JEEM INITIAL FORM;NEL]]>/ ), 'Negative charclass ARABIC LIGATURE TEH WITH MEEM WITH JEEM INITIAL FORM;NEL');
ok(!( "\x[fd55]" ~~ m/^ \C[ARABIC LIGATURE TEH WITH MEEM WITH JEEM INITIAL FORM]/ ), 'Negative named ARABIC LIGATURE TEH WITH MEEM WITH JEEM INITIAL FORM nomatch');
ok("\c[NEL]" ~~ m/^ \C[ARABIC LIGATURE TEH WITH MEEM WITH JEEM INITIAL FORM]/, 'Negative named ARABIC LIGATURE TEH WITH MEEM WITH JEEM INITIAL FORM match');
ok(!( "\x[fd55]" ~~ m/^ <[\C[ARABIC LIGATURE TEH WITH MEEM WITH JEEM INITIAL FORM]]>/ ), 'Negative charclass named ARABIC LIGATURE TEH WITH MEEM WITH JEEM INITIAL FORM nomatch');
ok("\c[NEL]" ~~ m/^ <[\C[ARABIC LIGATURE TEH WITH MEEM WITH JEEM INITIAL FORM]]>/, 'Negative charclass named ARABIC LIGATURE TEH WITH MEEM WITH JEEM INITIAL FORM match');

ok(!( "\x[fd55]" ~~ m/^ \X[FD55]/ ), 'Negative hex \X[FD55] nomatch');
ok(!( "\x[fd55]" ~~ m/^ <[\X[FD55]]>/ ), 'Negative charclass hex \X[FD55] nomatch');
ok("abc\x[5b4]def" ~~ m/\c[HEBREW POINT HIRIQ]/, 'Unanchored named HEBREW POINT HIRIQ');
ok("abc\c[HEBREW POINT HIRIQ]def" ~~ m/\x[5B4]/, 'Unanchored \x[5B4]');
ok("abc\c[HEBREW POINT HIRIQ]def" ~~ m/\o[2664]/, 'Unanchored \o[2664]');
ok("abc\x[5b4]def" ~~ m/^ abc \c[HEBREW POINT HIRIQ] def $/, 'Anchored HEBREW POINT HIRIQ');
ok("abc\x[5b4]\x[fd55]def" ~~ m/\c[HEBREW POINT HIRIQ;ARABIC LIGATURE TEH WITH MEEM WITH JEEM INITIAL FORM]/, 'Multiple HEBREW POINT HIRIQ;ARABIC LIGATURE TEH WITH MEEM WITH JEEM INITIAL FORM');
ok("\x[5b4]\x[fd55]" ~~ m/<[\c[HEBREW POINT HIRIQ;ARABIC LIGATURE TEH WITH MEEM WITH JEEM INITIAL FORM]]>/, 'Charclass multiple HEBREW POINT HIRIQ;ARABIC LIGATURE TEH WITH MEEM WITH JEEM INITIAL FORM');
ok(!( "\x[5b4]\x[fd55]" ~~ m/^ <-[\c[HEBREW POINT HIRIQ;ARABIC LIGATURE TEH WITH MEEM WITH JEEM INITIAL FORM]]>/ ), 'Negative charclass HEBREW POINT HIRIQ;ARABIC LIGATURE TEH WITH MEEM WITH JEEM INITIAL FORM');
ok(!( "\x[5b4]" ~~ m/^ \C[HEBREW POINT HIRIQ]/ ), 'Negative named HEBREW POINT HIRIQ nomatch');
ok("\x[fd55]" ~~ m/^ \C[HEBREW POINT HIRIQ]/, 'Negative named HEBREW POINT HIRIQ match');
ok(!( "\x[5b4]" ~~ m/^ <[\C[HEBREW POINT HIRIQ]]>/ ), 'Negative charclass named HEBREW POINT HIRIQ nomatch');
ok("\x[fd55]" ~~ m/^ <[\C[HEBREW POINT HIRIQ]]>/, 'Negative charclass named HEBREW POINT HIRIQ match');
ok(!( "\x[5b4]" ~~ m/^ \X[5B4]/ ), 'Negative hex \X[5B4] nomatch');
ok(!( "\x[5b4]" ~~ m/^ <[\X[5B4]]>/ ), 'Negative charclass hex \X[5B4] nomatch');
ok("\x[5b4]" ~~ m/^ \X[FD55]/, 'Negative hex \X[FD55] match');
ok("\x[5b4]" ~~ m/^ <[\X[FD55]]>/, 'Negative charclass hex \X[FD55] match');
ok("abc\x[1ea2]def" ~~ m/\c[LATIN CAPITAL LETTER A WITH HOOK ABOVE]/, 'Unanchored named LATIN CAPITAL LETTER A WITH HOOK ABOVE');
ok("abc\c[LATIN CAPITAL LETTER A WITH HOOK ABOVE]def" ~~ m/\x[1EA2]/, 'Unanchored \x[1EA2]');
ok("abc\c[LATIN CAPITAL LETTER A WITH HOOK ABOVE]def" ~~ m/\o[17242]/, 'Unanchored \o[17242]');
ok("abc\x[1ea2]def" ~~ m/^ abc \c[LATIN CAPITAL LETTER A WITH HOOK ABOVE] def $/, 'Anchored LATIN CAPITAL LETTER A WITH HOOK ABOVE');
ok("abc\x[1ea2]\x[5b4]def" ~~ m/\c[LATIN CAPITAL LETTER A WITH HOOK ABOVE;HEBREW POINT HIRIQ]/, 'Multiple LATIN CAPITAL LETTER A WITH HOOK ABOVE;HEBREW POINT HIRIQ');
ok("\x[1ea2]\x[5b4]" ~~ m/<[\c[LATIN CAPITAL LETTER A WITH HOOK ABOVE;HEBREW POINT HIRIQ]]>/, 'Charclass multiple LATIN CAPITAL LETTER A WITH HOOK ABOVE;HEBREW POINT HIRIQ');
ok(!( "\x[1ea2]\x[5b4]" ~~ m/^ <-[\c[LATIN CAPITAL LETTER A WITH HOOK ABOVE;HEBREW POINT HIRIQ]]>/ ), 'Negative charclass LATIN CAPITAL LETTER A WITH HOOK ABOVE;HEBREW POINT HIRIQ');
ok(!( "\x[1ea2]" ~~ m/^ \C[LATIN CAPITAL LETTER A WITH HOOK ABOVE]/ ), 'Negative named LATIN CAPITAL LETTER A WITH HOOK ABOVE nomatch');
ok("\x[5b4]" ~~ m/^ \C[LATIN CAPITAL LETTER A WITH HOOK ABOVE]/, 'Negative named LATIN CAPITAL LETTER A WITH HOOK ABOVE match');
ok(!( "\x[1ea2]" ~~ m/^ <[\C[LATIN CAPITAL LETTER A WITH HOOK ABOVE]]>/ ), 'Negative charclass named LATIN CAPITAL LETTER A WITH HOOK ABOVE nomatch');
ok("\x[5b4]" ~~ m/^ <[\C[LATIN CAPITAL LETTER A WITH HOOK ABOVE]]>/, 'Negative charclass named LATIN CAPITAL LETTER A WITH HOOK ABOVE match');
ok(!( "\x[1ea2]" ~~ m/^ \X[1EA2]/ ), 'Negative hex \X[1EA2] nomatch');
ok(!( "\x[1ea2]" ~~ m/^ <[\X[1EA2]]>/ ), 'Negative charclass hex \X[1EA2] nomatch');
ok("\x[1ea2]" ~~ m/^ \X[5B4]/, 'Negative hex \X[5B4] match');
ok("\x[1ea2]" ~~ m/^ <[\X[5B4]]>/, 'Negative charclass hex \X[5B4] match');
ok("abc\x[565]def" ~~ m/\c[ARMENIAN SMALL LETTER ECH]/, 'Unanchored named ARMENIAN SMALL LETTER ECH');
ok("abc\c[ARMENIAN SMALL LETTER ECH]def" ~~ m/\x[565]/, 'Unanchored \x[565]');
ok("abc\c[ARMENIAN SMALL LETTER ECH]def" ~~ m/\o[2545]/, 'Unanchored \o[2545]');
ok("abc\x[565]def" ~~ m/^ abc \c[ARMENIAN SMALL LETTER ECH] def $/, 'Anchored ARMENIAN SMALL LETTER ECH');
ok("abc\x[565]\x[1ea2]def" ~~ m/\c[ARMENIAN SMALL LETTER ECH;LATIN CAPITAL LETTER A WITH HOOK ABOVE]/, 'Multiple ARMENIAN SMALL LETTER ECH;LATIN CAPITAL LETTER A WITH HOOK ABOVE');
ok("\x[565]\x[1ea2]" ~~ m/<[\c[ARMENIAN SMALL LETTER ECH;LATIN CAPITAL LETTER A WITH HOOK ABOVE]]>/, 'Charclass multiple ARMENIAN SMALL LETTER ECH;LATIN CAPITAL LETTER A WITH HOOK ABOVE');
ok(!( "\x[565]\x[1ea2]" ~~ m/^ <-[\c[ARMENIAN SMALL LETTER ECH;LATIN CAPITAL LETTER A WITH HOOK ABOVE]]>/ ), 'Negative charclass ARMENIAN SMALL LETTER ECH;LATIN CAPITAL LETTER A WITH HOOK ABOVE');
ok(!( "\x[565]" ~~ m/^ \C[ARMENIAN SMALL LETTER ECH]/ ), 'Negative named ARMENIAN SMALL LETTER ECH nomatch');
ok("\x[1ea2]" ~~ m/^ \C[ARMENIAN SMALL LETTER ECH]/, 'Negative named ARMENIAN SMALL LETTER ECH match');
ok(!( "\x[565]" ~~ m/^ <[\C[ARMENIAN SMALL LETTER ECH]]>/ ), 'Negative charclass named ARMENIAN SMALL LETTER ECH nomatch');
ok("\x[1ea2]" ~~ m/^ <[\C[ARMENIAN SMALL LETTER ECH]]>/, 'Negative charclass named ARMENIAN SMALL LETTER ECH match');
ok(!( "\x[565]" ~~ m/^ \X[565]/ ), 'Negative hex \X[565] nomatch');
ok(!( "\x[565]" ~~ m/^ <[\X[565]]>/ ), 'Negative charclass hex \X[565] nomatch');
ok("\x[565]" ~~ m/^ \X[1EA2]/, 'Negative hex \X[1EA2] match');
ok("\x[565]" ~~ m/^ <[\X[1EA2]]>/, 'Negative charclass hex \X[1EA2] match');
ok("abc\x[25db]def" ~~ m/\c[LOWER HALF INVERSE WHITE CIRCLE]/, 'Unanchored named LOWER HALF INVERSE WHITE CIRCLE');
ok("abc\c[LOWER HALF INVERSE WHITE CIRCLE]def" ~~ m/\x[25DB]/, 'Unanchored \x[25DB]');
ok("abc\c[LOWER HALF INVERSE WHITE CIRCLE]def" ~~ m/\o[22733]/, 'Unanchored \o[22733]');
ok("abc\x[25db]def" ~~ m/^ abc \c[LOWER HALF INVERSE WHITE CIRCLE] def $/, 'Anchored LOWER HALF INVERSE WHITE CIRCLE');
ok("abc\x[25db]\x[565]def" ~~ m/\c[LOWER HALF INVERSE WHITE CIRCLE;ARMENIAN SMALL LETTER ECH]/, 'Multiple LOWER HALF INVERSE WHITE CIRCLE;ARMENIAN SMALL LETTER ECH');
ok("\x[25db]\x[565]" ~~ m/<[\c[LOWER HALF INVERSE WHITE CIRCLE;ARMENIAN SMALL LETTER ECH]]>/, 'Charclass multiple LOWER HALF INVERSE WHITE CIRCLE;ARMENIAN SMALL LETTER ECH');
ok(!( "\x[25db]\x[565]" ~~ m/^ <-[\c[LOWER HALF INVERSE WHITE CIRCLE;ARMENIAN SMALL LETTER ECH]]>/ ), 'Negative charclass LOWER HALF INVERSE WHITE CIRCLE;ARMENIAN SMALL LETTER ECH');
ok(!( "\x[25db]" ~~ m/^ \C[LOWER HALF INVERSE WHITE CIRCLE]/ ), 'Negative named LOWER HALF INVERSE WHITE CIRCLE nomatch');
ok("\x[565]" ~~ m/^ \C[LOWER HALF INVERSE WHITE CIRCLE]/, 'Negative named LOWER HALF INVERSE WHITE CIRCLE match');
ok(!( "\x[25db]" ~~ m/^ <[\C[LOWER HALF INVERSE WHITE CIRCLE]]>/ ), 'Negative charclass named LOWER HALF INVERSE WHITE CIRCLE nomatch');
ok("\x[565]" ~~ m/^ <[\C[LOWER HALF INVERSE WHITE CIRCLE]]>/, 'Negative charclass named LOWER HALF INVERSE WHITE CIRCLE match');
ok(!( "\x[25db]" ~~ m/^ \X[25DB]/ ), 'Negative hex \X[25DB] nomatch');
ok(!( "\x[25db]" ~~ m/^ <[\X[25DB]]>/ ), 'Negative charclass hex \X[25DB] nomatch');
ok("\x[25db]" ~~ m/^ \X[565]/, 'Negative hex \X[565] match');
ok("\x[25db]" ~~ m/^ <[\X[565]]>/, 'Negative charclass hex \X[565] match');
ok("abc\x[fe7d]def" ~~ m/\c[ARABIC SHADDA MEDIAL FORM]/, 'Unanchored named ARABIC SHADDA MEDIAL FORM');
ok("abc\c[ARABIC SHADDA MEDIAL FORM]def" ~~ m/\x[fe7d]/, 'Unanchored \x[fe7d]');
ok("abc\c[ARABIC SHADDA MEDIAL FORM]def" ~~ m/\o[177175]/, 'Unanchored \o[177175]');
ok("abc\x[fe7d]def" ~~ m/^ abc \c[ARABIC SHADDA MEDIAL FORM] def $/, 'Anchored ARABIC SHADDA MEDIAL FORM');
ok("abc\x[fe7d]\x[25db]def" ~~ m/\c[ARABIC SHADDA MEDIAL FORM;LOWER HALF INVERSE WHITE CIRCLE]/, 'Multiple ARABIC SHADDA MEDIAL FORM;LOWER HALF INVERSE WHITE CIRCLE');
ok("\x[fe7d]\x[25db]" ~~ m/<[\c[ARABIC SHADDA MEDIAL FORM;LOWER HALF INVERSE WHITE CIRCLE]]>/, 'Charclass multiple ARABIC SHADDA MEDIAL FORM;LOWER HALF INVERSE WHITE CIRCLE');
}
