#
# (c) Jan Gehring <jan.gehring@gmail.com>
#
# vim: set ts=2 sw=2 tw=0:
# vim: set expandtab:

package Rex::Exporter;

use strict;
use warnings;

our $VERSION = '1.7.0'; # VERSION

use Data::Dumper;

our @EXPORT;

no strict 'refs'; ## no critic ProhibitNoStrict

sub import {
  my ( $mod_to_register, %option ) = @_;
  my ( $mod_to_register_in, $file, $line ) = caller;

  if ( exists $option{register_in} && $option{register_in} ) {
    $mod_to_register_in = $option{register_in};
  }

  my $no_import = "";
  if ( exists $option{"-no"} && $option{"-no"} ) {
    $no_import = "," . join( ",", @{ $option{"-no"} } ) . ",";
  }

  for my $reg_func ( @{ $_[0] . "::EXPORT" } ) {
    if ( $no_import =~ m/,$reg_func,/ ) {
      next;
    }

    *{ $mod_to_register_in . "::" . $reg_func } =
      *{ $mod_to_register . "::" . $reg_func };
  }
}

use strict;

1;
