use strict;
use warnings;
use Test::More;
use Import::Into::As;

BEGIN {
    $INC{'AA.pm'} = 1;
    package AA;

    our @EXPORT = qw/aa aaa $A/;
    our @EXPORT_OK = qw/a/;
    use base 'Exporter';

    our $A = 'a';

    sub a   { 'a' }
    sub aa  { 'aa' }
    sub aaa { 'aaa' }
}

BEGIN {
    $INC{'BB.pm'} = 1;
    package BB;

    our @EXPORT = qw/b bb bbb $B/;
    use base 'Exporter';

    our $B;

    sub b   { 'b' }
    sub bb  { 'bb' }
    sub bbb { 'bbb' }
}

BEGIN {
    $INC{'CC.pm'} = 1;
    package CC;

    our @EXPORT = qw/c cc ccc $c/;
    use base 'Exporter';

    our $C = 'c';

    sub c   { 'c' }
    sub cc  { 'cc' }
    sub ccc { 'ccc' }
}

BEGIN {
    $INC{'DD.pm'} = 1;
    package DD;

    # These sub names are intentionally 'a'
    our @EXPORT = qw/a aa aaa $D/;
    use base 'Exporter';

    our $D = 'd';

    # These sub names are intentionally 'a'
    sub a   { 'd' }
    sub aa  { 'dd' }
    sub aaa { 'ddd' }
}

BEGIN {
    # defaults, by level, no renames
    'AA'->import::into::as(0, {});

    # subset, by package, no renames
    'BB'->import::into::as(__PACKAGE__, {}, qw/$B bb bbb/);

    # rename c to b (no conflict), use hash target with level
    'CC'->import::into::as({level => 0}, { c => 'b' });

    # rename with potential conflicts, package in hash target
    'DD'->import::into::as({package => __PACKAGE__}, { a => 'x', aa => 'xx', aaa => 'xxx' });
}

ok(!__PACKAGE__->can('a'), 'a is not a defined sub');
is(aa(),  'aa',  'simple import aa');
is(aaa(), 'aaa', 'simple import aaa');
is($A, 'a', 'Imported $A');

is(b(),   'c',   "non conflict rename c to b");
is(bb(),  'bb',  "simple import bb");
is(bbb(), 'bbb', "simple import bbb");
is($B, undef, 'Imported $B, (check for import of undef scalar)');

ok(!__PACKAGE__->can('c'), "no c function");
is(cc(),  'cc',  "simple import cc");
is(ccc(), 'ccc', "simple import ccc");

is(x(),   'd',   'renamed conflicting a to x');
is(xx(),  'dd',  'renamed conflicting aa to xx');
is(xxx(), 'ddd', 'renamed conflicting aaa to xxx');
is($D, 'd', 'Imported $D');

done_testing;
