#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    12/31/2004  - P. Harvey Created
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.07';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);
sub AddFields($$$$$$;$$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkII_2',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfo7D_2',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorCalib',
	'Image::ExifTool::Canon::ColorCoefs',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorData6',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::GE::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::FaceDetect',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::LensInfo',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FacePos',
	'Image::ExifTool::Pentax::FaceSize',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TempInfoK5',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::Reconyx::Main',
	'Image::ExifTool::Ricoh::FirmwareInfo',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Samsung::Type1',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::FaceInfo1',
	'Image::ExifTool::Sony::FaceInfo2',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::cell',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::mwg_coll',
	'Image::ExifTool::XMP::mwg_kw',
	'Image::ExifTool::XMP::mwg_rs',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::plus',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 78 => 0x69 },
	'about' => { 296 => 'about' },
	'abspeakaudiofilepath' => { 302 => 'absPeakAudioFilePath' },
	'accessorytype' => { 218 => 0x53 },
	'actionadvised' => { 90 => 0x2a },
	'activearea' => { 83 => 0xc68d },
	'actived-lighting' => { 158 => 0x22, 184 => 0x24 },
	'actived-lightingmode' => { 184 => 0x25 },
	'addaspectratioinfo' => { 59 => 0x80e },
	'additionalmodelinformation' => { 286 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 59 => 0x80f, 60 => 0x11, 61 => 0x13, 64 => 0x14 },
	'address' => { 116 => 'Address' },
	'adjustmentmode' => { 262 => 0x15 },
	'adultcontentwarning' => { 292 => 'AdultContentWarning', 295 => 'adultContentWarning' },
	'advancedraw' => { 186 => 0x76a43203 },
	'advancedscenemode' => { 218 => 0x3d },
	'advisory' => { 300 => 'Advisory' },
	'ae_iso' => { 221 => 0x2 },
	'aeaperture' => { 221 => 0x1 },
	'aebautocancel' => { 59 => 0x104 },
	'aebbracketvalue' => { 54 => 0x11 },
	'aebsequence' => { 59 => 0x105 },
	'aebsequenceautocancel' => { 57 => 0x9, 58 => 0x9, 60 => 0x8, 61 => 0x9, 64 => 0x9, 65 => 0x7 },
	'aebshotcount' => { 59 => 0x106 },
	'aebxv' => { 221 => 0x4 },
	'aeexposuretime' => { 221 => 0x0 },
	'aelbutton' => { 132 => 0x45 },
	'aelexposureindicator' => { 132 => 0x51 },
	'aelock' => { 132 => 0x5b, 194 => '4.2', 196 => '4.2', 198 => 0x201, 241 => 0x48 },
	'aelockbutton' => { 193 => '16.1', 194 => '4.1', 195 => '15.1', 196 => '4.1', 197 => '17.1' },
	'aelockbuttonplusdials' => { 193 => '16.2' },
	'aelockformb-d80' => { 197 => '3.1' },
	'aemaxaperture' => { 221 => 0x9 },
	'aemaxaperture2' => { 221 => 0xa },
	'aemeteringmode' => { 221 => 0xc },
	'aemeteringsegments' => { 241 => 0x209 },
	'aemicroadjustment' => { 59 => 0x111 },
	'aeminaperture' => { 221 => 0xb },
	'aeminexposuretime' => { 221 => 0x5 },
	'aeprogrammode' => { 221 => 0x6 },
	'aesetting' => { 24 => 0x21 },
	'aexv' => { 221 => 0x3 },
	'af-cpriorityselection' => { 193 => '1.1' },
	'af-onformb-d10' => { 193 => '3.3' },
	'af-spriorityselection' => { 193 => '1.2' },
	'afactivation' => { 193 => '2.1' },
	'afadjustment' => { 241 => 0x72 },
	'afandmeteringbuttons' => { 59 => 0x701 },
	'afaperture' => { 156 => 0x5, 157 => 0x5 },
	'afareaheight' => { 139 => 0x1a },
	'afareaillumination' => { 132 => 0x4b, 196 => '15.3' },
	'afareamode' => { 132 => 0xe, 138 => 0x0, 139 => 0x5, 218 => 0xf, 263 => 0x11, 264 => 0x11 },
	'afareamodesetting' => { 194 => '11.1', 195 => '0.1', 196 => '16.1', 197 => '2.1' },
	'afareas' => { 198 => 0x304 },
	'afareawidth' => { 139 => 0x18 },
	'afareaxposition' => { 139 => 0x14 },
	'afareayposition' => { 139 => 0x16 },
	'afassist' => { 57 => 0x5, 65 => 0x5, 132 => 0x48, 193 => '2.5', 194 => '0.2', 195 => '0.2', 196 => '0.2', 197 => '2.3' },
	'afassistbeam' => { 59 => 0x50e, 60 => 0x4, 61 => 0x5, 62 => 0x4, 63 => 0x4, 64 => 0x5 },
	'afassistlamp' => { 218 => 0x31 },
	'afdefocus' => { 222 => 0x6 },
	'afduringliveview' => { 59 => 0x511 },
	'affinetune' => { 140 => 0x0 },
	'affinetuneadj' => { 140 => 0x2, 166 => 0x2d1, 167 => 0x2dc, 198 => 0x307 },
	'affinetuneindex' => { 140 => 0x1 },
	'afilluminator' => { 263 => 0x29, 268 => 0xb044 },
	'afimageheight' => { 139 => 0x12 },
	'afimagewidth' => { 139 => 0x10 },
	'afintegrationtime' => { 222 => 0x7 },
	'afmicroadjactive' => { 1 => 0x1 },
	'afmicroadjustment' => { 59 => 0x507 },
	'afmicroadjvalue' => { 1 => 0x2 },
	'afmode' => { 80 => 0x3009, 262 => 0x5, 268 => 0xb043 },
	'afonaelockbuttonswitch' => { 59 => 0x702 },
	'afonbutton' => { 193 => '3.1' },
	'afpoint' => { 24 => 0x13, 79 => 0x18, 138 => 0x1, 201 => 0x308, 262 => 0x1f },
	'afpointactivationarea' => { 58 => 0x11, 64 => 0x11 },
	'afpointareaexpansion' => { 59 => 0x508 },
	'afpointautoselection' => { 59 => 0x50b },
	'afpointbrightness' => { 59 => 0x50d, 193 => '2.4' },
	'afpointdisplayduringfocus' => { 59 => 0x50c },
	'afpointillumination' => { 58 => 0xa, 193 => '2.3', 197 => '2.4' },
	'afpointmode' => { 226 => 0x3 },
	'afpointposition' => { 80 => 0x2021, 218 => 0x4d },
	'afpointregistration' => { 57 => 0x7 },
	'afpoints' => { 131 => 0x10 },
	'afpointselected' => { 198 => 0x305, 241 => 0xe },
	'afpointselected2' => { 226 => 0x4 },
	'afpointselection' => { 58 => 0xb, 193 => '1.3' },
	'afpointselectionmethod' => { 59 => 0x50f, 60 => 0xc, 61 => 0xd, 64 => 0xd },
	'afpointsinfocus' => { 54 => 0xe, 138 => 0x2, 222 => 0xb, 241 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 15 => 0x38 },
	'afpointspotmetering' => { 58 => 0xd },
	'afpointsunknown1' => { 222 => 0x0 },
	'afpointsunknown2' => { 222 => 0x2 },
	'afpointsused' => { 139 => 0x8 },
	'afpredictor' => { 222 => 0x4 },
	'afresponse' => { 158 => 0xad },
	'afresult' => { 203 => 0x1038 },
	'afsearch' => { 198 => 0x303 },
	'afwithshutter' => { 263 => 0x2a },
	'aggregationtype' => { 293 => 'aggregationType' },
	'agreement' => { 295 => 'agreement' },
	'aiservocontinuousshooting' => { 58 => 0x15 },
	'aiservoimagepriority' => { 59 => 0x503 },
	'aiservotrackingmethod' => { 59 => 0x504 },
	'aiservotrackingsensitivity' => { 58 => 0x14, 59 => 0x502 },
	'album' => { 302 => 'album' },
	'alreadyapplied' => { 280 => 'AlreadyApplied' },
	'alternatetitle' => { 293 => 'alternateTitle' },
	'alttapename' => { 302 => 'altTapeName' },
	'alttimecode' => { 302 => 'altTimecode' },
	'alttimecodetimeformat' => { 302 => [\'altTimecode','altTimecodeTimeFormat'] },
	'alttimecodetimevalue' => { 302 => [\'altTimecode','altTimecodeTimeValue'] },
	'alttimecodevalue' => { 302 => [\'altTimecode','altTimecodeValue'] },
	'ambienceselection' => { 2 => 0x1 },
	'ambienttemperature' => { 253 => 0x14 },
	'ambienttemperaturefahrenheit' => { 253 => 0x13 },
	'analogbalance' => { 83 => 0xc627 },
	'angleadj' => { 78 => 0x8b },
	'anti-blur' => { 268 => 0xb04b },
	'antialiasstrength' => { 83 => 0xc632 },
	'aperturerange' => { 59 => 0x10d },
	'apertureringuse' => { 226 => '1.4' },
	'aperturevalue' => { 68 => 0x2, 83 => 0x9202, 203 => 0x1002, 284 => 'ApertureValue' },
	'applekeywords' => { 207 => 'AAPL:Keywords' },
	'applicationnotes' => { 83 => 0x2bc, 220 => 0x2bc },
	'applicationrecordversion' => { 90 => 0x0 },
	'applyshootingmeteringmode' => { 59 => 0x10e },
	'approximatefnumber' => { 213 => 0x313, 219 => 0x3406 },
	'armidentifier' => { 91 => 0x78 },
	'armversion' => { 91 => 0x7a },
	'artfilter' => { 198 => 0x529 },
	'artist' => { 83 => 0x13b, 209 => 'Artist', 241 => 0x22e, 298 => 'Artist', 302 => 'artist' },
	'artworkcopyrightnotice' => { 286 => [\'ArtworkOrObject','ArtworkOrObjectAOCopyrightNotice'] },
	'artworkcreator' => { 286 => [\'ArtworkOrObject','ArtworkOrObjectAOCreator'] },
	'artworkdatecreated' => { 286 => [\'ArtworkOrObject','ArtworkOrObjectAODateCreated'] },
	'artworkorobject' => { 286 => 'ArtworkOrObject' },
	'artworksource' => { 286 => [\'ArtworkOrObject','ArtworkOrObjectAOSource'] },
	'artworksourceinventoryno' => { 286 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvNo'] },
	'artworktitle' => { 286 => [\'ArtworkOrObject','ArtworkOrObjectAOTitle'] },
	'aspectframe' => { 202 => 0x1113 },
	'aspectratio' => { 3 => 0x0, 202 => 0x1112, 263 => 0x55 },
	'asshoticcprofile' => { 83 => 0xc68f },
	'asshotneutral' => { 83 => 0xc628 },
	'asshotpreprofilematrix' => { 83 => 0xc690 },
	'asshotprofilename' => { 83 => 0xc6f6 },
	'asshotwhitexy' => { 83 => 0xc629 },
	'assignbktbutton' => { 193 => '4.2' },
	'assignfuncbutton' => { 59 => 0x70b },
	'assistbuttonfunction' => { 57 => 0xd },
	'attributionname' => { 278 => 'attributionName' },
	'attributionurl' => { 278 => 'attributionURL' },
	'audio' => { 218 => 0x20 },
	'audiobitrate' => { 46 => 0x6c },
	'audiochannels' => { 46 => 0x70 },
	'audiochanneltype' => { 302 => 'audioChannelType' },
	'audiocompression' => { 110 => 'Compression' },
	'audiocompressor' => { 302 => 'audioCompressor' },
	'audioduration' => { 90 => 0x99 },
	'audiomoddate' => { 302 => 'audioModDate' },
	'audiooutcue' => { 90 => 0x9a },
	'audiosamplerate' => { 46 => 0x6e, 302 => 'audioSampleRate' },
	'audiosampletype' => { 302 => 'audioSampleType' },
	'audiosamplingrate' => { 90 => 0x97 },
	'audiosamplingresolution' => { 90 => 0x98 },
	'audiotype' => { 90 => 0x96 },
	'author' => { 112 => 'Author', 207 => 'Author', 209 => 'Author', 252 => 'Author', 276 => 'author', 290 => 'Author' },
	'authorsposition' => { 291 => 'AuthorsPosition' },
	'autoaperture' => { 235 => '0.1' },
	'autobracket' => { 262 => 0x19 },
	'autobracketing' => { 87 => 0x1100, 241 => 0x18 },
	'autobracketmodem' => { 193 => '21.2' },
	'autobracketorder' => { 132 => 0x43, 193 => '21.3', 196 => '2.2', 197 => '13.2' },
	'autobracketset' => { 193 => '21.1', 195 => '11.1', 196 => '2.1', 197 => '13.1' },
	'autobrightness' => { 280 => 'AutoBrightness' },
	'autocontrast' => { 280 => 'AutoContrast' },
	'autodistortioncontrol' => { 147 => 0x4 },
	'autodynamicrange' => { 87 => 0x140b },
	'autoexposure' => { 280 => 'AutoExposure' },
	'autoexposurebracketing' => { 54 => 0x10 },
	'autofocus' => { 201 => 0x209 },
	'autofp' => { 196 => '7.3', 197 => '31.4' },
	'autoiso' => { 54 => 0x1, 80 => 0x3008, 194 => '1.1', 196 => '1.1' },
	'autoisomax' => { 194 => '1.2', 196 => '1.2' },
	'autoisominshutterspeed' => { 194 => '1.3', 196 => '1.3' },
	'autolightingoptimizer' => { 12 => 0xbe, 13 => 0xbf, 16 => 0xbf, 42 => 0x2, 59 => 0x204, 78 => 0x6f },
	'autolightingoptimizeron' => { 78 => 0x6e },
	'autoredeye' => { 186 => 0xfe28a44f },
	'autorotate' => { 54 => 0x1b },
	'autoshadows' => { 280 => 'AutoShadows' },
	'auxiliarylens' => { 158 => 0x82 },
	'avaperturesetting' => { 226 => 0x13 },
	'avsettingwithoutlens' => { 59 => 0x707 },
	'azimuth' => { 120 => 'Azimuth' },
	'babyage' => { 218 => [0x8010,0x33] },
	'babyname' => { 218 => 0x66 },
	'backgroundalpha' => { 297 => 'bgalpha' },
	'baseexposurecompensation' => { 226 => 0x15 },
	'baseiso' => { 54 => 0x2, 72 => 0x101c, 219 => 0x312a },
	'baselineexposure' => { 83 => 0xc62a },
	'baselinenoise' => { 83 => 0xc62b },
	'baselinesharpness' => { 83 => 0xc62c },
	'baseurl' => { 300 => 'BaseURL' },
	'batterylevel' => { 132 => 0x60 },
	'batteryorder' => { 193 => '12.5' },
	'bayergreensplit' => { 83 => 0xc62d },
	'bayerpattern' => { 94 => 0xf902, 135 => 0x17 },
	'beatspliceparams' => { 302 => 'beatSpliceParams' },
	'beatspliceparamsriseindecibel' => { 302 => [\'beatSpliceParams','beatSpliceParamsRiseInDecibel'] },
	'beatspliceparamsriseintimeduration' => { 302 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDuration'] },
	'beatspliceparamsriseintimedurationscale' => { 302 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationScale'] },
	'beatspliceparamsriseintimedurationvalue' => { 302 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationValue'] },
	'beatspliceparamsusefilebeatsmarker' => { 302 => [\'beatSpliceParams','beatSpliceParamsUseFileBeatsMarker'] },
	'beep' => { 193 => '13.1', 194 => '0.1', 195 => '2.1', 196 => '0.1', 197 => '4.1' },
	'bestqualityscale' => { 83 => 0xc65c },
	'bestshotmode' => { 80 => 0x3007 },
	'bitdepth' => { 117 => 'BitDepth', 135 => 0x11, 163 => 0x41 },
	'bitspercomponent' => { 92 => 0x87 },
	'bitspersample' => { 83 => 0x102, 298 => 'BitsPerSample' },
	'blacklevel' => { 83 => 0xc61a, 203 => 0x1012 },
	'blacklevel2' => { 202 => 0x600, 206 => 0x600 },
	'blacklevelrepeatdim' => { 83 => 0xc619 },
	'blackpoint' => { 241 => 0x200 },
	'bleachbypasstoning' => { 241 => 0x7f },
	'bluebalance' => { 146 => 0x271, 203 => 0x1018, 220 => 0x12, 241 => 0x1b },
	'bluecurvelimits' => { 77 => 0x1fe },
	'bluecurvepoints' => { 77 => 0x1d4 },
	'bluehue' => { 280 => 'BlueHue' },
	'bluesaturation' => { 280 => 'BlueSaturation' },
	'blurwarning' => { 87 => 0x1300 },
	'bodybatteryadload' => { 224 => 0x3 },
	'bodybatteryadnoload' => { 224 => 0x2 },
	'bodybatterystate' => { 224 => '1.1' },
	'bodybatteryvoltage1' => { 224 => 0x2 },
	'bodybatteryvoltage2' => { 224 => 0x4 },
	'bodybatteryvoltage3' => { 224 => 0x6 },
	'bodybatteryvoltage4' => { 224 => 0x8 },
	'bodyfirmware' => { 257 => 0x0 },
	'bodyfirmwareversion' => { 199 => 0x104, 200 => 0x100, 203 => 0x104 },
	'bodyserialnumber' => { 257 => 0x10 },
	'bracketmode' => { 38 => 0x3 },
	'bracketsequence' => { 80 => 0x301d },
	'bracketshotnumber' => { 38 => 0x5, 226 => 0x9 },
	'bracketstep' => { 129 => 0xe },
	'bracketvalue' => { 38 => 0x4 },
	'brightness' => { 83 => 0xfe53, 111 => 'Brightness', 129 => 0x2c, 160 => 0x34, 263 => 0x22, 268 => 0x2007, 280 => 'Brightness' },
	'brightnessadj' => { 77 => 0x114, 179 => 0x0, 189 => 0x2d, 271 => 0x8018 },
	'brightnessvalue' => { 83 => 0x9203, 203 => 0x1003, 284 => 'BrightnessValue' },
	'bulbduration' => { 54 => 0x18 },
	'burstmode' => { 97 => 0xa, 218 => 0x2a },
	'burstmode2' => { 97 => 0x18 },
	'burstshot' => { 262 => 0x34 },
	'buttonfunctioncontroloff' => { 59 => 0x70a },
	'bwfilter' => { 129 => 0x2a, 136 => 0x39 },
	'bwmode' => { 203 => 0x203 },
	'by-line' => { 90 => 0x50 },
	'by-linetitle' => { 90 => 0x55 },
	'bytecount' => { 293 => 'byteCount' },
	'calibration' => { 262 => 0x24 },
	'calibrationilluminant1' => { 83 => 0xc65a },
	'calibrationilluminant2' => { 83 => 0xc65b },
	'cameraangle' => { 302 => 'cameraAngle' },
	'cameracalibration1' => { 83 => 0xc623 },
	'cameracalibration2' => { 83 => 0xc624 },
	'cameracalibrationsig' => { 83 => 0xc6f3 },
	'cameracolorcalibration01' => { 26 => 0x0, 32 => 0xba },
	'cameracolorcalibration02' => { 26 => 0x4, 32 => 0xbf },
	'cameracolorcalibration03' => { 26 => 0x8, 32 => 0xc4 },
	'cameracolorcalibration04' => { 26 => 0xc, 32 => 0xc9 },
	'cameracolorcalibration05' => { 26 => 0x10, 32 => 0xce },
	'cameracolorcalibration06' => { 26 => 0x14, 32 => 0xd3 },
	'cameracolorcalibration07' => { 26 => 0x18, 32 => 0xd8 },
	'cameracolorcalibration08' => { 26 => 0x1c, 32 => 0xdd },
	'cameracolorcalibration09' => { 26 => 0x20, 32 => 0xe2 },
	'cameracolorcalibration10' => { 26 => 0x24, 32 => 0xe7 },
	'cameracolorcalibration11' => { 26 => 0x28, 32 => 0xec },
	'cameracolorcalibration12' => { 26 => 0x2c, 32 => 0xf1 },
	'cameracolorcalibration13' => { 26 => 0x30, 32 => 0xf6 },
	'cameracolorcalibration14' => { 26 => 0x34, 32 => 0xfb },
	'cameracolorcalibration15' => { 26 => 0x38, 32 => 0x100 },
	'cameraid' => { 203 => 0x209, 261 => 0x209 },
	'cameraiso' => { 24 => 0x10 },
	'cameralabel' => { 302 => 'cameraLabel' },
	'cameramodel' => { 302 => 'cameraModel' },
	'cameramove' => { 302 => 'cameraMove' },
	'cameraorientation' => { 4 => 0x30, 7 => 0x30, 9 => 0x35, 10 => 0x30, 11 => 0x30, 12 => 0x31, 13 => 0x31, 14 => 0x35, 15 => 0x27, 16 => 0x31, 18 => 0x36, 20 => 0x11, 243 => 0x1 },
	'cameraowner' => { 98 => 0xc353 },
	'cameraparameters' => { 203 => 0x2050 },
	'cameraprofile' => { 280 => 'CameraProfile' },
	'cameraprofiledigest' => { 280 => 'CameraProfileDigest' },
	'cameraserialnumber' => { 83 => 0xc62f, 128 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 198 => 0x0 },
	'cameratemperature' => { 4 => 0x18, 7 => 0x18, 9 => 0x19, 10 => 0x18, 11 => 0x18, 12 => 0x19, 13 => 0x19, 14 => 0x19, 15 => 0x17, 16 => 0x19, 18 => 0x19, 19 => 0x19, 21 => [0x87,0x91], 22 => [0x99,0x9f,0xa4,0xa8,0x105], 23 => [0x64,0x1d2,0x1f7,0x1fa,0x47,0x53,0x5b,0x5c], 54 => 0xc, 213 => 0x320, 219 => 0x3402, 241 => 0x47, 260 => 0x43 },
	'cameratemperature2' => { 244 => 0xc },
	'cameratemperature3' => { 244 => 0xe },
	'cameratemperature4' => { 244 => 0x14 },
	'cameratemperature5' => { 244 => 0x16 },
	'cameratype' => { 54 => 0x1a, 203 => 0x207 },
	'cameratype2' => { 199 => 0x100 },
	'canonexposuremode' => { 24 => 0x14 },
	'canonfiledescription' => { 72 => 0x805 },
	'canonfilelength' => { 43 => 0xe },
	'canonfirmwareversion' => { 43 => 0x7, 72 => 0x80b },
	'canonflashinfo' => { 72 => 0x1028 },
	'canonflashmode' => { 24 => 0x4 },
	'canonimagesize' => { 6 => 0x39, 24 => 0xa },
	'canonimagetype' => { 43 => 0x6, 72 => 0x815 },
	'canonmodelid' => { 43 => 0x10, 72 => 0x1834 },
	'canonvrd' => { 84 => 'CanonVRD' },
	'caption' => { 276 => 'caption' },
	'caption-abstract' => { 90 => 0x78 },
	'captionsauthornames' => { 283 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 283 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 291 => 'CaptionWriter' },
	'captureframerate' => { 80 => 0x4001 },
	'cardshutterlock' => { 132 => 0x49 },
	'casioimagesize' => { 80 => 0x9 },
	'catalogsets' => { 90 => 0xff, 275 => 'CatalogSets' },
	'categories' => { 43 => 0x23, 276 => 'categories' },
	'category' => { 90 => 0xf, 291 => 'Category' },
	'ccdboardversion' => { 213 => 0x331 },
	'ccdscanmode' => { 203 => 0x1039 },
	'ccdsensitivity' => { 176 => 0x6 },
	'ccdversion' => { 213 => 0x330 },
	'cellglobalid' => { 279 => 'cgi' },
	'celllength' => { 83 => 0x109 },
	'cellr' => { 279 => 'r' },
	'celltowerid' => { 279 => 'cellid' },
	'cellwidth' => { 83 => 0x108 },
	'centerafarea' => { 196 => '15.1' },
	'centerfocuspoint' => { 197 => '2.2' },
	'centerweightedareasize' => { 193 => '7.1', 196 => '6.3', 197 => '8.1' },
	'certificate' => { 306 => 'Certificate' },
	'cfapattern' => { 83 => 0xa302, 284 => 'CFAPattern' },
	'cfapatterncolumns' => { 284 => [\'CFAPattern','CFAPatternColumns'] },
	'cfapatternrows' => { 284 => [\'CFAPattern','CFAPatternRows'] },
	'cfapatternvalues' => { 284 => [\'CFAPattern','CFAPatternValues'] },
	'channel' => { 293 => 'channel' },
	'channels' => { 110 => 'Channels' },
	'checkmark' => { 77 => 0x26a },
	'checkmark2' => { 78 => 0x8e },
	'childfontfiles' => { 307 => [\'Fonts','FontsChildFontFiles'] },
	'chmodeshootingspeed' => { 193 => '10.3' },
	'chromablurradius' => { 83 => 0xc631 },
	'chromaticaberration' => { 78 => 0x66 },
	'chromaticaberrationb' => { 280 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 78 => 0x6b },
	'chromaticaberrationcorrection' => { 234 => 0x1 },
	'chromaticaberrationon' => { 78 => 0x62 },
	'chromaticaberrationr' => { 280 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 78 => 0x6a },
	'chrominancenoisereduction' => { 78 => 0x5e, 262 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 78 => 0x60 },
	'city' => { 90 => 0x5a, 116 => 'City', 218 => 0x6d, 291 => 'City' },
	'clarity' => { 280 => 'Clarity' },
	'classifystate' => { 90 => 0xe1 },
	'client' => { 302 => 'client' },
	'clmodeshootingspeed' => { 193 => '10.2', 197 => '11.1' },
	'cmcontrast' => { 206 => 0x2022 },
	'cmexposurecompensation' => { 206 => 0x2000 },
	'cmhue' => { 206 => 0x2021 },
	'cmsaturation' => { 206 => 0x2020 },
	'cmsharpness' => { 206 => 0x2023 },
	'cmwhitebalance' => { 206 => 0x2001 },
	'cmwhitebalancecomp' => { 206 => 0x2002 },
	'cmwhitebalancegraypoint' => { 206 => 0x2010 },
	'codec' => { 124 => 'Codec' },
	'codedcharacterset' => { 91 => 0x5a },
	'collectionname' => { 287 => [\'Collections','CollectionsCollectionName'] },
	'collections' => { 287 => 'Collections' },
	'collectionuri' => { 287 => [\'Collections','CollectionsCollectionURI'] },
	'coloraberrationcontrol' => { 186 => 0xc89224b },
	'coloradjustment' => { 262 => 0x14 },
	'coloradjustmentmode' => { 261 => 0x210 },
	'coloranta' => { 307 => [\'Colorants','ColorantsA'] },
	'colorantb' => { 307 => [\'Colorants','ColorantsB'] },
	'colorantblack' => { 307 => [\'Colorants','ColorantsBlack'] },
	'colorantblue' => { 307 => [\'Colorants','ColorantsBlue'] },
	'colorantcyan' => { 307 => [\'Colorants','ColorantsCyan'] },
	'colorantgreen' => { 307 => [\'Colorants','ColorantsGreen'] },
	'colorantl' => { 307 => [\'Colorants','ColorantsL'] },
	'colorantmagenta' => { 307 => [\'Colorants','ColorantsMagenta'] },
	'colorantmode' => { 307 => [\'Colorants','ColorantsMode'] },
	'colorantred' => { 307 => [\'Colorants','ColorantsRed'] },
	'colorants' => { 307 => 'Colorants' },
	'colorantswatchname' => { 307 => [\'Colorants','ColorantsSwatchName'] },
	'coloranttype' => { 307 => [\'Colorants','ColorantsType'] },
	'colorantyellow' => { 307 => [\'Colorants','ColorantsYellow'] },
	'colorbalance' => { 111 => 'ColorBalance' },
	'colorbalanceadj' => { 186 => 0x76a43202 },
	'colorbalanceblue' => { 129 => 0x1e },
	'colorbalancegreen' => { 129 => 0x1d },
	'colorbalancered' => { 129 => 0x1c },
	'colorblur' => { 78 => 0x65 },
	'colorbooster' => { 186 => 0x5f0e7d23 },
	'colorboostlevel' => { 180 => 0x1 },
	'colorboosttype' => { 180 => 0x0 },
	'colorclass' => { 247 => 0xde },
	'colorcompensationfilter' => { 132 => [0x3a,0x5f], 133 => 0x111, 268 => 0xb022 },
	'colorcontrol' => { 203 => 0x102b },
	'colorcorrection' => { 271 => 0x8015 },
	'colordataversion' => { 30 => 0x0, 31 => 0x0, 33 => 0x0 },
	'coloreffect' => { 218 => 0x28 },
	'colorfilter' => { 79 => 0x17, 80 => 0x3017, 129 => 0x29, 136 => [0x38,0x4d,0x4f], 246 => 0x17 },
	'colorgain' => { 163 => 0x51 },
	'colorhue' => { 158 => 0x8d },
	'colorimetricreference' => { 83 => 0xc6bf },
	'colormatrix' => { 202 => 0x200, 203 => 0x1011 },
	'colormatrix1' => { 83 => 0xc621 },
	'colormatrix2' => { 83 => 0xc622, 206 => 0x200 },
	'colormatrixa' => { 241 => 0x203 },
	'colormatrixb' => { 241 => 0x204 },
	'colormatrixnumber' => { 203 => 0x1019 },
	'colormode' => { 80 => 0x3015, 87 => 0x1210, 97 => 0x66, 129 => 0x28, 132 => 0x16, 133 => 0x101, 136 => 0x7, 158 => 0x3, 176 => 0x4, 218 => 0x32, 262 => 0x2c, 268 => 0xb029, 291 => 'ColorMode' },
	'colormoirereduction' => { 187 => 0x15 },
	'colormoirereductionmode' => { 187 => 0x5 },
	'colornoisereduction' => { 271 => 0x8029, 280 => 'ColorNoiseReduction' },
	'colornoisereductionintensity' => { 187 => 0x18 },
	'colornoisereductionsharpness' => { 187 => 0x1c },
	'colorplanes' => { 86 => 0x2 },
	'colorprofile' => { 129 => 0x33 },
	'colorrepresentation' => { 92 => 0x3c },
	'colorreproduction' => { 268 => 0xb020 },
	'colorsequence' => { 92 => 0x41 },
	'colorspace' => { 34 => 0x3, 43 => 0xb4, 72 => 0x10b4, 83 => 0xa001, 117 => 'ColorSpace', 130 => 0x2f, 131 => 0x25, 132 => 0x17, 158 => 0x1e, 198 => 0x507, 241 => 0x37, 262 => 0xb, 284 => 'ColorSpace' },
	'colortempasshot' => { 27 => 0x4, 28 => 0x1d, 29 => 0x26, 30 => 0x43, 33 => 0x43 },
	'colortempauto' => { 27 => 0x9, 28 => 0x22, 29 => 0x1c, 30 => 0x48, 33 => 0x48 },
	'colortempcloudy' => { 27 => 0x22, 28 => 0x31, 29 => 0x35, 30 => 0x5c, 33 => 0x75 },
	'colortempcustom' => { 30 => 0x84 },
	'colortempcustom1' => { 28 => 0x45 },
	'colortempcustom2' => { 28 => 0x4a },
	'colortempdaylight' => { 27 => 0x18, 28 => 0x27, 29 => 0x2b, 30 => 0x52, 33 => 0x6b },
	'colortemperature' => { 4 => 0x73, 5 => [0x48,0x4e], 6 => 0x37, 7 => 0x62, 8 => 0x37, 9 => [0x7b,0x7c], 10 => 0x73, 11 => 0x73, 12 => 0x77, 13 => 0x73, 14 => 0x7c, 15 => 0x58, 16 => 0x73, 18 => 0x7d, 20 => 0x57, 43 => 0xae, 52 => 0x9, 72 => 0x10ae, 87 => 0x1005, 95 => 0x846, 111 => 'ColorTemperature', 130 => [0x6e,0x49], 131 => 0x3f, 132 => [0x39,0x5e], 133 => 0x10b, 136 => [0x3c,0x4c,0x4e], 213 => 0x321, 241 => 0x50, 268 => 0xb021, 280 => 'Temperature' },
	'colortemperatureadj' => { 271 => 0x8013 },
	'colortemperaturebg' => { 203 => 0x1013 },
	'colortemperaturerg' => { 203 => 0x1014 },
	'colortemperaturesetting' => { 132 => 0x25 },
	'colortempflash' => { 27 => 0x36, 28 => 0x40, 29 => 0x49, 30 => 0x70, 33 => 0x89 },
	'colortempflashdata' => { 30 => 0x24a },
	'colortempfluorescent' => { 27 => 0x2c, 28 => 0x3b, 29 => 0x3f, 30 => 0x66, 33 => 0x7f },
	'colortempkelvin' => { 27 => 0x31, 29 => 0x44, 30 => 0x6b, 33 => 0x84 },
	'colortempmeasured' => { 27 => 0xe, 30 => 0x4d, 33 => 0x4d },
	'colortemppc1' => { 29 => 0x94, 30 => 0x75 },
	'colortemppc2' => { 29 => 0x99, 30 => 0x7a },
	'colortemppc3' => { 29 => 0x9e, 30 => 0x7f },
	'colortempshade' => { 27 => 0x1d, 28 => 0x2c, 29 => 0x30, 30 => 0x57, 33 => 0x70 },
	'colortemptungsten' => { 27 => 0x27, 28 => 0x36, 29 => 0x3a, 30 => 0x61, 33 => 0x7a },
	'colortempunknown' => { 27 => 0x13, 29 => 0x21, 33 => 0x52 },
	'colortempunknown10' => { 27 => 0x63, 29 => 0x76, 33 => 0xa2 },
	'colortempunknown11' => { 27 => 0x68, 29 => 0x7b, 33 => 0xa7 },
	'colortempunknown12' => { 27 => 0x6d, 29 => 0x80, 33 => 0xac },
	'colortempunknown13' => { 27 => 0x72, 29 => 0x85, 33 => 0xb1 },
	'colortempunknown14' => { 29 => 0x8a, 33 => 0xb6 },
	'colortempunknown15' => { 29 => 0x8f, 33 => 0xbb },
	'colortempunknown16' => { 29 => 0xa3 },
	'colortempunknown2' => { 27 => 0x3b, 29 => 0x4e, 33 => 0x57 },
	'colortempunknown3' => { 27 => 0x40, 29 => 0x53, 33 => 0x5c },
	'colortempunknown4' => { 27 => 0x45, 29 => 0x58, 33 => 0x61 },
	'colortempunknown5' => { 27 => 0x4a, 29 => 0x5d, 33 => 0x66 },
	'colortempunknown6' => { 27 => 0x4f, 29 => 0x62, 33 => 0x8e },
	'colortempunknown7' => { 27 => 0x54, 29 => 0x67, 33 => 0x93 },
	'colortempunknown8' => { 27 => 0x59, 29 => 0x6c, 33 => 0x98 },
	'colortempunknown9' => { 27 => 0x5e, 29 => 0x71, 33 => 0x9d },
	'colortone' => { 6 => 0x6f, 8 => 0x77, 24 => 0x2a, 34 => 0x2 },
	'colortoneadj' => { 77 => 0x11e },
	'colortonefaithful' => { 15 => 0x107, 48 => 0x6c, 49 => 0x6c },
	'colortonelandscape' => { 15 => 0x105, 48 => 0x3c, 49 => 0x3c },
	'colortonemonochrome' => { 48 => 0x84, 49 => 0x84 },
	'colortoneneutral' => { 15 => 0x106, 48 => 0x54, 49 => 0x54 },
	'colortoneportrait' => { 15 => 0x104, 48 => 0x24, 49 => 0x24 },
	'colortonestandard' => { 15 => 0x103, 48 => 0xc, 49 => 0xc },
	'colortoneunknown' => { 49 => 0x9c },
	'colortoneuserdef1' => { 15 => 0x109, 48 => 0x9c, 49 => 0xb4 },
	'colortoneuserdef2' => { 15 => 0x10a, 48 => 0xb4, 49 => 0xcc },
	'colortoneuserdef3' => { 15 => 0x10b, 48 => 0xcc, 49 => 0xe4 },
	'commanddials' => { 196 => '5.1' },
	'commanddialsaperturesetting' => { 193 => '17.3' },
	'commanddialschangemainsub' => { 193 => '17.2' },
	'commanddialsmenuandplayback' => { 193 => '17.4' },
	'commanddialsreverserotation' => { 193 => '17.1', 195 => '16.2', 197 => '18.1' },
	'commanderchannel' => { 196 => '10.2' },
	'commandergroupa_ttl-aacomp' => { 196 => '13.1' },
	'commandergroupa_ttlcomp' => { 197 => '32.1' },
	'commandergroupamanualoutput' => { 196 => '13.2' },
	'commandergroupamode' => { 196 => '11.2' },
	'commandergroupb_ttl-aacomp' => { 196 => '14.1' },
	'commandergroupb_ttlcomp' => { 197 => '33.1' },
	'commandergroupbmanualoutput' => { 196 => '14.2' },
	'commandergroupbmode' => { 196 => '11.3' },
	'commanderinternalflash' => { 196 => '11.1' },
	'commanderinternalmanualoutput' => { 196 => '12.2' },
	'commanderinternalttlcomp' => { 196 => '12.1', 197 => '31.2' },
	'comment' => { 0 => 0x2, 84 => 'Comment', 112 => 'Comment', 209 => 'Comment' },
	'complianceprofile' => { 293 => 'complianceProfile' },
	'componentsconfiguration' => { 83 => 0x9101, 117 => 'Components', 284 => 'ComponentsConfiguration' },
	'componentversion' => { 72 => 0x80c },
	'composer' => { 302 => 'composer' },
	'compositionadjust' => { 240 => '0.1' },
	'compositionadjustrotation' => { 240 => 0x7 },
	'compositionadjustx' => { 240 => 0x5 },
	'compositionadjusty' => { 240 => 0x6 },
	'compressedbitsperpixel' => { 83 => 0x9102, 284 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 133 => 0x40, 203 => 0x40 },
	'compression' => { 83 => 0x103, 298 => 'Compression' },
	'compressionfactor' => { 198 => 0x50d },
	'compressionratio' => { 117 => 'Compression', 203 => 0x1034 },
	'constrainedcropheight' => { 77 => 0x266, 247 => 0xd6 },
	'constrainedcropwidth' => { 77 => 0x262, 247 => 0xd5 },
	'contact' => { 90 => 0x76 },
	'contentlocationcode' => { 90 => 0x1a },
	'contentlocationname' => { 90 => 0x1b },
	'continuousbracketing' => { 132 => 0x20 },
	'continuousdrive' => { 24 => 0x5 },
	'continuousshootingspeed' => { 59 => 0x610 },
	'continuousshotlimit' => { 59 => 0x611 },
	'contrast' => { 6 => 0x73, 8 => 0x75, 24 => 0xd, 79 => 0xc, 80 => [0x3012,0x20], 83 => [0xa408,0xfe54], 87 => [0x1004,0x1006], 111 => 'Contrast', 129 => 0x20, 130 => 0x31, 131 => 0x27, 132 => 0x19, 136 => 0x2, 160 => 0x33, 203 => 0x1029, 218 => 0x39, 219 => 0x300a, 241 => 0x20, 246 => 0xc, 262 => 0xd, 263 => 0x1d, 264 => 0x1a, 268 => 0x2004, 280 => 'Contrast', 284 => 'Contrast' },
	'contrastadj' => { 77 => 0x115, 189 => 0x2c, 271 => 0x8017 },
	'contrastdetectaf' => { 139 => 0x4 },
	'contrastdetectafarea' => { 241 => 0x231 },
	'contrastdetectafinfocus' => { 139 => 0x1c },
	'contrastfaithful' => { 15 => 0xec, 48 => 0x60, 49 => 0x60 },
	'contrasthighlight' => { 241 => 0x6d },
	'contrasthighlightshadowadj' => { 241 => 0x6f },
	'contrastlandscape' => { 15 => 0xea, 48 => 0x30, 49 => 0x30 },
	'contrastmode' => { 218 => 0x2c },
	'contrastmonochrome' => { 15 => 0xed, 48 => 0x78, 49 => 0x78 },
	'contrastneutral' => { 15 => 0xeb, 48 => 0x48, 49 => 0x48 },
	'contrastportrait' => { 15 => 0xe9, 48 => 0x18, 49 => 0x18 },
	'contrastsetting' => { 198 => 0x505, 206 => 0x1012 },
	'contrastshadow' => { 241 => 0x6e },
	'contraststandard' => { 15 => 0xe8, 48 => 0x0, 49 => 0x0 },
	'contrastunknown' => { 49 => 0x90 },
	'contrastuserdef1' => { 15 => 0xee, 48 => 0x90, 49 => 0xa8 },
	'contrastuserdef2' => { 15 => 0xef, 48 => 0xa8, 49 => 0xc0 },
	'contrastuserdef3' => { 15 => 0xf0, 48 => 0xc0, 49 => 0xd8 },
	'contributedmedia' => { 302 => 'contributedMedia' },
	'contributedmediaduration' => { 302 => [\'contributedMedia','contributedMediaDuration'] },
	'contributedmediadurationscale' => { 302 => [\'contributedMedia','contributedMediaDurationScale'] },
	'contributedmediadurationvalue' => { 302 => [\'contributedMedia','contributedMediaDurationValue'] },
	'contributedmediamanaged' => { 302 => [\'contributedMedia','contributedMediaManaged'] },
	'contributedmediapath' => { 302 => [\'contributedMedia','contributedMediaPath'] },
	'contributedmediastarttime' => { 302 => [\'contributedMedia','contributedMediaStartTime'] },
	'contributedmediastarttimescale' => { 302 => [\'contributedMedia','contributedMediaStartTimeScale'] },
	'contributedmediastarttimevalue' => { 302 => [\'contributedMedia','contributedMediaStartTimeValue'] },
	'contributedmediatrack' => { 302 => [\'contributedMedia','contributedMediaTrack'] },
	'contributedmediawebstatement' => { 302 => [\'contributedMedia','contributedMediaWebStatement'] },
	'contributor' => { 281 => 'contributor' },
	'contributors' => { 112 => 'Contributors' },
	'controldialset' => { 132 => 0x46 },
	'controlledvocabularyterm' => { 286 => 'CVterm' },
	'controllerboardversion' => { 213 => 0x332 },
	'controlmode' => { 54 => 0x12 },
	'conversionlens' => { 218 => 0x35 },
	'converter' => { 83 => 0xfe4d, 176 => 0xb, 280 => 'Converter' },
	'converttograyscale' => { 280 => 'ConvertToGrayscale' },
	'copyright' => { 0 => 0x3, 83 => 0x8298, 112 => 'Copyright', 209 => 'Copyright', 241 => 0x22f, 252 => 'Copyright', 290 => 'Copyright', 293 => 'copyright', 295 => 'copyright', 298 => 'Copyright', 302 => 'copyright' },
	'copyrightflag' => { 250 => 0x40a },
	'copyrightnotice' => { 90 => 0x74 },
	'copyrightowner' => { 292 => 'CopyrightOwner' },
	'copyrightownerid' => { 292 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerID'] },
	'copyrightownerimageid' => { 292 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 292 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerName'] },
	'copyrightregistrationnumber' => { 292 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 292 => 'CopyrightStatus' },
	'coringfilter' => { 202 => 0x310, 203 => 0x102d, 206 => 0x310 },
	'coringvalues' => { 202 => 0x311, 206 => 0x311 },
	'corporateentity' => { 293 => 'corporateEntity' },
	'country' => { 116 => 'Country', 218 => 0x69, 291 => 'Country' },
	'country-primarylocationcode' => { 90 => 0x64 },
	'country-primarylocationname' => { 90 => 0x65 },
	'countrycode' => { 248 => 'CountryCode', 285 => 'CountryCode' },
	'coverage' => { 281 => 'coverage' },
	'coverdate' => { 293 => 'coverDate' },
	'coverdisplaydate' => { 293 => 'coverDisplayDate' },
	'cpufirmwareversion' => { 241 => 0x28 },
	'crc32' => { 282 => 'crc32' },
	'createdate' => { 83 => 0x9004, 112 => 'CreateDate', 207 => 'CreationDate', 209 => 'create-date', 252 => 'CreationDate', 300 => 'CreateDate' },
	'creationdate' => { 290 => 'CreationDate', 293 => 'creationDate' },
	'creationtime' => { 209 => 'Creation Time' },
	'creativestyle' => { 263 => 0x1a, 264 => 0x18 },
	'creativestylewaschanged' => { 271 => 0x8001 },
	'creator' => { 207 => 'Creator', 252 => 'Creator', 281 => 'creator', 290 => 'Creator' },
	'creatoraddress' => { 285 => [\'CreatorContactInfo','CreatorContactInfoCiAdrExtadr'] },
	'creatorcity' => { 285 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCity'] },
	'creatorcontactinfo' => { 285 => 'CreatorContactInfo' },
	'creatorcountry' => { 285 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCtry'] },
	'creatorpostalcode' => { 285 => [\'CreatorContactInfo','CreatorContactInfoCiAdrPcode'] },
	'creatorregion' => { 285 => [\'CreatorContactInfo','CreatorContactInfoCiAdrRegion'] },
	'creatortool' => { 300 => 'CreatorTool' },
	'creatorworkemail' => { 285 => [\'CreatorContactInfo','CreatorContactInfoCiEmailWork'] },
	'creatorworktelephone' => { 285 => [\'CreatorContactInfo','CreatorContactInfoCiTelWork'] },
	'creatorworkurl' => { 285 => [\'CreatorContactInfo','CreatorContactInfoCiUrlWork'] },
	'credit' => { 90 => 0x6e, 291 => 'Credit' },
	'creditline' => { 295 => 'creditLine' },
	'creditlinereq' => { 305 => 'CreditLineReq' },
	'creditlinerequired' => { 292 => 'CreditLineRequired' },
	'cropactive' => { 77 => 0x244 },
	'cropangle' => { 280 => 'CropAngle' },
	'cropaspectratio' => { 77 => 0x260 },
	'cropbottom' => { 86 => 0x9, 181 => 0x36, 247 => 0xdc, 280 => 'CropBottom' },
	'cropbottommargin' => { 35 => 0x3 },
	'cropheight' => { 77 => 0x24c, 202 => 0x615, 206 => 0x615, 280 => 'CropHeight' },
	'crophispeed' => { 158 => 0x1b },
	'cropleft' => { 77 => 0x246, 86 => 0x6, 181 => 0x1e, 202 => 0x612, 206 => 0x612, 247 => 0xd9, 280 => 'CropLeft' },
	'cropleftmargin' => { 35 => 0x0 },
	'cropoutputheight' => { 181 => 0xce },
	'cropoutputheightinches' => { 181 => 0x96 },
	'cropoutputpixels' => { 181 => 0xd6 },
	'cropoutputresolution' => { 181 => 0xb6 },
	'cropoutputscale' => { 181 => 0xbe },
	'cropoutputwidth' => { 181 => 0xc6 },
	'cropoutputwidthinches' => { 181 => 0x8e },
	'croppedimageheight' => { 3 => 0x2 },
	'croppedimagewidth' => { 3 => 0x1 },
	'cropright' => { 86 => 0x8, 181 => 0x2e, 247 => 0xdb, 280 => 'CropRight' },
	'croprightmargin' => { 35 => 0x1 },
	'croprotation' => { 86 => 0xb },
	'cropscaledresolution' => { 181 => 0x9e },
	'cropsourceresolution' => { 181 => 0xae },
	'croptop' => { 77 => 0x248, 86 => 0x7, 181 => 0x26, 202 => 0x613, 206 => 0x613, 247 => 0xda, 280 => 'CropTop' },
	'croptopmargin' => { 35 => 0x2 },
	'cropunit' => { 280 => 'CropUnit' },
	'cropunits' => { 280 => 'CropUnits' },
	'cropwidth' => { 77 => 0x24a, 202 => 0x614, 206 => 0x614, 280 => 'CropWidth' },
	'crossprocess' => { 241 => 0x7b },
	'crossprocessparams' => { 241 => 0x235 },
	'currenticcprofile' => { 83 => 0xc691 },
	'currentpreprofilematrix' => { 83 => 0xc692 },
	'currentversion' => { 271 => 0xd000 },
	'curves' => { 186 => 0x76a43201 },
	'custom1' => { 292 => 'Custom1' },
	'custom10' => { 292 => 'Custom10' },
	'custom2' => { 292 => 'Custom2' },
	'custom3' => { 292 => 'Custom3' },
	'custom4' => { 292 => 'Custom4' },
	'custom5' => { 292 => 'Custom5' },
	'custom6' => { 292 => 'Custom6' },
	'custom7' => { 292 => 'Custom7' },
	'custom8' => { 292 => 'Custom8' },
	'custom9' => { 292 => 'Custom9' },
	'customcontrast' => { 78 => 0x4e },
	'customcontrols' => { 59 => 0x70c },
	'customlinear' => { 78 => 0x4f },
	'customoutputhighlightpoint' => { 78 => 0x53 },
	'customoutputshadowpoint' => { 78 => 0x54 },
	'custompicturestylefilename' => { 43 => 0x4010 },
	'customrawhighlight' => { 78 => 0x7c },
	'customrawhighlightpoint' => { 78 => 0x51 },
	'customrawshadow' => { 78 => 0x85 },
	'customrawshadowpoint' => { 78 => 0x52 },
	'customrendered' => { 83 => 0xa401, 284 => 'CustomRendered' },
	'customsaturation' => { 198 => 0x503 },
	'customsettingsalldefault' => { 193 => '0.2' },
	'customsettingsbank' => { 193 => '0.1' },
	'customsharpness' => { 78 => 0x50 },
	'customwbbluelevel' => { 132 => 0x36 },
	'customwberror' => { 132 => 0x37 },
	'customwbgreenlevel' => { 132 => 0x35 },
	'customwbredlevel' => { 132 => 0x34 },
	'customwbsetting' => { 132 => 0x26 },
	'd-lightinghq' => { 186 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 182 => 0x2 },
	'd-lightinghqhighlight' => { 182 => 0x1 },
	'd-lightinghqselected' => { 186 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 182 => 0x0 },
	'd-lightinghs' => { 186 => 0xce5554aa },
	'd-lightinghsadjustment' => { 183 => 0x0 },
	'd-lightinghscolorboost' => { 183 => 0x1 },
	'd-rangeoptimizerhighlight' => { 271 => 0x8024 },
	'd-rangeoptimizermode' => { 271 => 0x8022 },
	'd-rangeoptimizershadow' => { 271 => 0x802d },
	'd-rangeoptimizervalue' => { 271 => 0x8023 },
	'datacompressionmethod' => { 92 => 0x6e },
	'dataimprint' => { 129 => 0x34 },
	'date' => { 241 => 0x6, 281 => 'date' },
	'dateacquired' => { 128 => 'DateAcquired' },
	'datecreated' => { 90 => 0x37, 291 => 'DateCreated' },
	'datedisplayformat' => { 178 => 0x3 },
	'dateimprint' => { 195 => '4.2' },
	'daterecieved' => { 293 => 'dateRecieved' },
	'datesent' => { 91 => 0x46 },
	'datestampmode' => { 43 => 0x1c },
	'datetime' => { 276 => 'datetime', 298 => 'DateTime' },
	'datetimedigitized' => { 284 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 75 => 0x0, 83 => 0x9003, 109 => 0x14, 112 => 'OriginalDate', 253 => 0xb, 284 => 'DateTimeOriginal' },
	'datetimestamp' => { 97 => 0x64 },
	'daylightsavings' => { 178 => 0x2 },
	'declination' => { 120 => 'Declination' },
	'decposition' => { 129 => 0x32 },
	'defaultcroporigin' => { 83 => 0xc61f },
	'defaultcropsize' => { 83 => 0xc620 },
	'defaultscale' => { 83 => 0xc61e },
	'defringe' => { 280 => 'Defringe' },
	'deletedimagecount' => { 158 => 0xa6, 164 => 0x6e },
	'derivedfrom' => { 303 => 'DerivedFrom' },
	'derivedfromalternatepaths' => { 303 => [\'DerivedFrom','DerivedFromAlternatePaths'] },
	'derivedfromdocumentid' => { 303 => [\'DerivedFrom','DerivedFromDocumentID'] },
	'derivedfromfilepath' => { 303 => [\'DerivedFrom','DerivedFromFilePath'] },
	'derivedfromfrompart' => { 303 => [\'DerivedFrom','DerivedFromFromPart'] },
	'derivedfrominstanceid' => { 303 => [\'DerivedFrom','DerivedFromInstanceID'] },
	'derivedfromlastmodifydate' => { 303 => [\'DerivedFrom','DerivedFromLastModifyDate'] },
	'derivedfrommanager' => { 303 => [\'DerivedFrom','DerivedFromManager'] },
	'derivedfrommanagervariant' => { 303 => [\'DerivedFrom','DerivedFromManagerVariant'] },
	'derivedfrommanageto' => { 303 => [\'DerivedFrom','DerivedFromManageTo'] },
	'derivedfrommanageui' => { 303 => [\'DerivedFrom','DerivedFromManageUI'] },
	'derivedfrommaskmarkers' => { 303 => [\'DerivedFrom','DerivedFromMaskMarkers'] },
	'derivedfromoriginaldocumentid' => { 303 => [\'DerivedFrom','DerivedFromOriginalDocumentID'] },
	'derivedfrompartmapping' => { 303 => [\'DerivedFrom','DerivedFromPartMapping'] },
	'derivedfromrenditionclass' => { 303 => [\'DerivedFrom','DerivedFromRenditionClass'] },
	'derivedfromrenditionparams' => { 303 => [\'DerivedFrom','DerivedFromRenditionParams'] },
	'derivedfromtopart' => { 303 => [\'DerivedFrom','DerivedFromToPart'] },
	'derivedfromversionid' => { 303 => [\'DerivedFrom','DerivedFromVersionID'] },
	'description' => { 209 => 'Description', 281 => 'description' },
	'destination' => { 91 => 0x5 },
	'destinationcity' => { 241 => 0x24, 245 => 0x3 },
	'destinationcitycode' => { 246 => 0x1001 },
	'destinationdst' => { 241 => 0x26, 245 => '0.3' },
	'developmentdynamicrange' => { 87 => 0x1403 },
	'devicesettingdescription' => { 284 => 'DeviceSettingDescription' },
	'devicesettingdescriptioncolumns' => { 284 => [\'DeviceSettingDescription','DeviceSettingDescriptionColumns'] },
	'devicesettingdescriptionrows' => { 284 => [\'DeviceSettingDescription','DeviceSettingDescriptionRows'] },
	'devicesettingdescriptionsettings' => { 284 => [\'DeviceSettingDescription','DeviceSettingDescriptionSettings'] },
	'dialdirectiontvav' => { 59 => 0x706 },
	'digitalcreationdate' => { 90 => 0x3e },
	'digitalcreationtime' => { 90 => 0x3f },
	'digitaldeehighlightadj' => { 163 => 0x202 },
	'digitaldeeshadowadj' => { 163 => 0x200 },
	'digitaldeethreshold' => { 163 => 0x201 },
	'digitalfilter01' => { 232 => 0x5 },
	'digitalfilter02' => { 232 => 0x16 },
	'digitalfilter03' => { 232 => 0x27 },
	'digitalfilter04' => { 232 => 0x38 },
	'digitalfilter05' => { 232 => 0x49 },
	'digitalfilter06' => { 232 => 0x5a },
	'digitalfilter07' => { 232 => 0x6b },
	'digitalfilter08' => { 232 => 0x7c },
	'digitalfilter09' => { 232 => 0x8d },
	'digitalfilter10' => { 232 => 0x9e },
	'digitalfilter11' => { 232 => 0xaf },
	'digitalfilter12' => { 232 => 0xc0 },
	'digitalfilter13' => { 232 => 0xd1 },
	'digitalfilter14' => { 232 => 0xe2 },
	'digitalfilter15' => { 232 => 0xf3 },
	'digitalfilter16' => { 232 => 0x104 },
	'digitalfilter17' => { 232 => 0x115 },
	'digitalfilter18' => { 232 => 0x126 },
	'digitalfilter19' => { 232 => 0x137 },
	'digitalfilter20' => { 232 => 0x148 },
	'digitalgain' => { 52 => 0xb },
	'digitalgem' => { 153 => 0x0 },
	'digitalice' => { 163 => 0x100 },
	'digitalimageguid' => { 286 => 'DigImageGUID' },
	'digitalroc' => { 162 => 0x0 },
	'digitalsourcefiletype' => { 286 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 286 => 'DigitalSourceType' },
	'digitalzoom' => { 24 => 0xc, 79 => 0xa, 97 => 0x68, 111 => 'DigitalZoom', 129 => 0xc, 158 => 0x86, 176 => 0xa, 203 => 0x204, 241 => 0x1e, 246 => 0xa, 261 => 0x204 },
	'digitalzoomon' => { 261 => 0x21b },
	'digitalzoomratio' => { 83 => 0xa404, 284 => 'DigitalZoomRatio' },
	'director' => { 302 => 'director' },
	'directorphotography' => { 302 => 'directorPhotography' },
	'directory' => { 84 => 'Directory' },
	'directoryindex' => { 4 => 0x137, 7 => 0x17e, 9 => [0x233,0x238], 10 => 0x13f, 11 => 0x133, 12 => 0x1df, 13 => [0x1a3,0x1a7], 14 => 0x1f0, 17 => 0x49, 18 => 0x1e5, 20 => 0x1d3 },
	'directorynumber' => { 149 => 0x6 },
	'disclaimer' => { 209 => 'Disclaimer' },
	'displayallafpoints' => { 59 => 0x514 },
	'displayaperture' => { 24 => 0x23 },
	'displayedunitsx' => { 251 => 0x2 },
	'displayedunitsy' => { 251 => 0x6 },
	'distance1' => { 97 => 0x28 },
	'distance2' => { 97 => 0x2c },
	'distance3' => { 97 => 0x30 },
	'distance4' => { 97 => 0x34 },
	'distortioncontrol' => { 164 => 0x10 },
	'distortioncorrection' => { 78 => 0x67, 198 => 0x50b, 234 => 0x0 },
	'distortioncorrection2' => { 202 => 0x1011 },
	'distortioncorrectionon' => { 78 => 0x63 },
	'distributor' => { 293 => 'distributor' },
	'dmcomment' => { 302 => 'comment' },
	'dngbackwardversion' => { 83 => 0xc613 },
	'dnglensinfo' => { 83 => 0xc630 },
	'dngversion' => { 83 => 0xc612 },
	'document' => { 209 => 'Document' },
	'documentancestorid' => { 291 => [\'DocumentAncestors','DocumentAncestorsAncestorID'] },
	'documentancestors' => { 291 => 'DocumentAncestors' },
	'documenthistory' => { 90 => 0xe7 },
	'documentid' => { 303 => 'DocumentID' },
	'documentname' => { 83 => 0x10d },
	'documentnotes' => { 90 => 0xe6 },
	'doi' => { 293 => 'doi' },
	'dotrange' => { 83 => 0x150 },
	'drivemode' => { 80 => 0x3103, 129 => 0x6, 132 => 0x1e, 198 => 0x600, 241 => 0x34, 262 => 0x3, 263 => 0x4 },
	'drivemode2' => { 132 => 0xa, 226 => 0x7 },
	'dspfirmwareversion' => { 241 => 0x27 },
	'duration' => { 46 => 0x6a, 110 => 'Duration', 124 => 'Duration', 302 => 'duration' },
	'durationscale' => { 302 => [\'duration','durationScale'] },
	'durationvalue' => { 302 => [\'duration','durationValue'] },
	'dustremovaldata' => { 43 => 0x97 },
	'dynamicafarea' => { 193 => '1.4' },
	'dynamicrange' => { 87 => 0x1400 },
	'dynamicrangeexpansion' => { 241 => 0x69 },
	'dynamicrangemax' => { 77 => 0x7c },
	'dynamicrangemin' => { 77 => 0x7a },
	'dynamicrangeoptimizer' => { 132 => 0x15, 268 => [0xb025,0xb04f] },
	'dynamicrangeoptimizerlevel' => { 263 => 0x19, 264 => 0x17 },
	'dynamicrangeoptimizermode' => { 263 => 0x18, 264 => 0x16 },
	'dynamicrangeoptimizersetting' => { 132 => 0x27 },
	'dynamicrangesetting' => { 87 => 0x1402 },
	'e-dialinprogram' => { 226 => '1.3' },
	'easyexposurecomp' => { 197 => '6.1' },
	'easyexposurecompensation' => { 193 => '6.4' },
	'easymode' => { 24 => 0xb },
	'edgenoisereduction' => { 187 => 0x4, 271 => 0x8028 },
	'edition' => { 293 => 'edition' },
	'editorialupdate' => { 90 => 0x8 },
	'editstatus' => { 90 => 0x7, 248 => 'EditStatus' },
	'effectivelv' => { 241 => 0x2d },
	'effectivemaxaperture' => { 156 => 0x12, 157 => 0x13 },
	'eissn' => { 293 => 'eIssn' },
	'elevation' => { 120 => 'Elevation' },
	'email' => { 112 => 'EMail' },
	'embargodate' => { 293 => 'embargoDate', 295 => 'embargoDate' },
	'endingpage' => { 293 => 'endingPage' },
	'enduser' => { 292 => 'EndUser' },
	'enduserid' => { 292 => [\'EndUser','EndUserEndUserID'] },
	'endusername' => { 292 => [\'EndUser','EndUserEndUserName'] },
	'engineer' => { 302 => 'engineer' },
	'enhancedarktones' => { 179 => 0x8 },
	'enhancement' => { 79 => 0x16, 80 => 0x3016 },
	'enhancer' => { 202 => 0x300 },
	'enhancervalues' => { 202 => 0x301 },
	'envelopenumber' => { 91 => 0x28 },
	'envelopepriority' => { 91 => 0x3c },
	'enveloperecordversion' => { 91 => 0x0 },
	'epsonimageheight' => { 203 => 0x20c },
	'epsonimagewidth' => { 203 => 0x20b },
	'epsonsoftware' => { 203 => 0x20d },
	'equipmentinstitution' => { 273 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 273 => 'EquipmentManufacturer' },
	'equipmentversion' => { 199 => 0x0 },
	'ettlii' => { 59 => 0x304, 60 => 0xd, 61 => 0xe, 62 => 0x7, 63 => 0x7, 64 => 0xe },
	'event' => { 275 => 'Event', 286 => 'Event', 293 => 'event' },
	'evsteps' => { 226 => '1.2', 228 => 0x0 },
	'evstepsize' => { 195 => '5.1', 196 => '0.7' },
	'exclusivityenddate' => { 295 => 'exclusivityEndDate' },
	'excursiontolerance' => { 92 => 0x82 },
	'exif' => { 84 => 'EXIF' },
	'exifbyteorder' => { 84 => 'ExifByteOrder' },
	'exifcamerainfo' => { 90 => 0xe8 },
	'exifimageheight' => { 83 => 0xa003, 284 => 'PixelYDimension' },
	'exifimagewidth' => { 83 => 0xa002, 284 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 84 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 83 => 0x9000, 284 => 'ExifVersion' },
	'exitpupilposition' => { 156 => 0x4, 157 => 0x4 },
	'expirationdate' => { 90 => 0x25, 293 => 'expirationDate', 295 => 'expirationDate' },
	'expirationtime' => { 90 => 0x26 },
	'exposure' => { 83 => 0xfe51, 280 => 'Exposure' },
	'exposureadj' => { 184 => 0x0 },
	'exposureadj2' => { 184 => 0x12 },
	'exposureadjust' => { 262 => 0xc },
	'exposurebracketingindicatorlast' => { 132 => 0x52 },
	'exposurebracketstepsize' => { 226 => 0x8 },
	'exposurebracketvalue' => { 158 => 0x19 },
	'exposurecompensation' => { 54 => 0x6, 68 => 0x0, 83 => 0x9204, 97 => 0x24, 111 => 'ExposureComp', 129 => 0xd, 130 => 0x53, 131 => 0x1e, 203 => 0x1006, 241 => 0x16, 260 => 0xa013, 262 => [0xc,0x35], 284 => 'ExposureBiasValue' },
	'exposurecompensationmode' => { 132 => 0x47 },
	'exposurecompensationsetting' => { 132 => 0x1 },
	'exposurecompstepsize' => { 193 => '6.3' },
	'exposurecontrolstepsize' => { 193 => '6.2', 197 => '7.1' },
	'exposuredelaymode' => { 193 => '10.1', 195 => '9.1', 196 => '6.4', 197 => '11.2' },
	'exposuredifference' => { 158 => 0xe },
	'exposureindex' => { 83 => 0xa215, 284 => 'ExposureIndex' },
	'exposureindicator' => { 132 => 0x50 },
	'exposurelevelincrements' => { 57 => 0x6, 58 => 0x6, 59 => 0x101, 60 => 0x5, 61 => 0x6, 62 => 0x5, 63 => 0x5, 64 => 0x6, 65 => 0x4, 263 => 0x58 },
	'exposuremode' => { 83 => 0xa402, 111 => 'ExposureMode', 129 => 0x1, 130 => 0xa, 131 => 0x0, 132 => 0x0, 198 => 0x200, 215 => 0x40d, 262 => 0x8, 268 => 0xb041, 284 => 'ExposureMode' },
	'exposuremodeinmanual' => { 59 => 0x10b },
	'exposureprogram' => { 83 => 0x8822, 263 => 0x3c, 264 => 0x3c, 284 => 'ExposureProgram' },
	'exposureshift' => { 198 => 0x203 },
	'exposuretime' => { 4 => 0x4, 5 => 0x4, 6 => 0x4, 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 18 => 0x4, 19 => 0x4, 21 => 0x6, 22 => 0x7, 54 => 0x16, 83 => 0x829a, 94 => 0xfd05, 97 => 0x20, 99 => 0xfa24, 101 => 0xf104, 104 => 0x12, 106 => 0x38, 109 => 0x10, 111 => 'ExposureTime', 129 => 0x9, 130 => 0x35, 131 => 0x48, 132 => 0x8, 241 => 0x12, 260 => 0xa018, 262 => 0x32, 284 => 'ExposureTime' },
	'exposuretime2' => { 262 => 0x33 },
	'exposuretuning' => { 158 => 0x1c },
	'exposurevalue' => { 95 => 0x3 },
	'exposurewarning' => { 87 => 0x1302 },
	'exrauto' => { 87 => 0x1033 },
	'exrmode' => { 87 => 0x1034 },
	'extendedwbdetect' => { 198 => 0x902 },
	'extender' => { 199 => 0x301 },
	'extenderfirmwareversion' => { 199 => 0x304 },
	'extendermagnification' => { 113 => 'Magnification' },
	'extendermake' => { 113 => 'Make' },
	'extendermodel' => { 113 => 'Model', 199 => 0x303 },
	'extenderserialnumber' => { 113 => 'SerialNumber', 199 => 0x302 },
	'externalflash' => { 201 => 0x1201 },
	'externalflashae1' => { 203 => 0x101f },
	'externalflashae1_0' => { 203 => 0x101b },
	'externalflashae2' => { 203 => 0x1020 },
	'externalflashae2_0' => { 203 => 0x101c },
	'externalflashbounce' => { 201 => 0x1204, 203 => 0x1026, 233 => 0x1a },
	'externalflashexposurecomp' => { 158 => 0x17, 233 => 0x19 },
	'externalflashfirmware' => { 150 => 0x6, 151 => 0x6, 152 => 0x6 },
	'externalflashflags' => { 150 => 0x8, 151 => 0x8, 152 => 0x8 },
	'externalflashguidenumber' => { 201 => 0x1203, 233 => '24.1' },
	'externalflashgvalue' => { 203 => 0x1025 },
	'externalflashmode' => { 203 => 0x1028, 233 => 0x2 },
	'externalflashzoom' => { 201 => 0x1205, 203 => 0x1027 },
	'externalsensorbrightnessvalue' => { 213 => 0x311, 219 => 0x3408 },
	'eyestartaf' => { 132 => 0x40 },
	'face10position' => { 148 => 0x28, 230 => 0x12 },
	'face10size' => { 231 => 0x12 },
	'face11position' => { 148 => 0x2c, 230 => 0x14 },
	'face11size' => { 231 => 0x14 },
	'face12position' => { 148 => 0x30, 230 => 0x16 },
	'face12size' => { 231 => 0x16 },
	'face13position' => { 230 => 0x18 },
	'face13size' => { 231 => 0x18 },
	'face14position' => { 230 => 0x1a },
	'face14size' => { 231 => 0x1a },
	'face15position' => { 230 => 0x1c },
	'face15size' => { 231 => 0x1c },
	'face16position' => { 230 => 0x1e },
	'face16size' => { 231 => 0x1e },
	'face17position' => { 230 => 0x20 },
	'face17size' => { 231 => 0x20 },
	'face18position' => { 230 => 0x22 },
	'face18size' => { 231 => 0x22 },
	'face19position' => { 230 => 0x24 },
	'face19size' => { 231 => 0x24 },
	'face1position' => { 36 => 0x8, 148 => 0x4, 211 => 0x1, 230 => 0x0, 266 => 0x0, 267 => 0x0 },
	'face1size' => { 231 => 0x0 },
	'face20position' => { 230 => 0x26 },
	'face20size' => { 231 => 0x26 },
	'face21position' => { 230 => 0x28 },
	'face21size' => { 231 => 0x28 },
	'face22position' => { 230 => 0x2a },
	'face22size' => { 231 => 0x2a },
	'face23position' => { 230 => 0x2c },
	'face23size' => { 231 => 0x2c },
	'face24position' => { 230 => 0x2e },
	'face24size' => { 231 => 0x2e },
	'face25position' => { 230 => 0x30 },
	'face25size' => { 231 => 0x30 },
	'face26position' => { 230 => 0x32 },
	'face26size' => { 231 => 0x32 },
	'face27position' => { 230 => 0x34 },
	'face27size' => { 231 => 0x34 },
	'face28position' => { 230 => 0x36 },
	'face28size' => { 231 => 0x36 },
	'face29position' => { 230 => 0x38 },
	'face29size' => { 231 => 0x38 },
	'face2position' => { 36 => 0xa, 148 => 0x8, 211 => 0x5, 230 => 0x2, 266 => 0x20, 267 => 0x25 },
	'face2size' => { 231 => 0x2 },
	'face30position' => { 230 => 0x3a },
	'face30size' => { 231 => 0x3a },
	'face31position' => { 230 => 0x3c },
	'face31size' => { 231 => 0x3c },
	'face32position' => { 230 => 0x3e },
	'face32size' => { 231 => 0x3e },
	'face3position' => { 36 => 0xc, 148 => 0xc, 211 => 0x9, 230 => 0x4, 266 => 0x40, 267 => 0x4a },
	'face3size' => { 231 => 0x4 },
	'face4position' => { 36 => 0xe, 148 => 0x10, 211 => 0xd, 230 => 0x6, 266 => 0x60, 267 => 0x6f },
	'face4size' => { 231 => 0x6 },
	'face5position' => { 36 => 0x10, 148 => 0x14, 211 => 0x11, 230 => 0x8, 266 => 0x80, 267 => 0x94 },
	'face5size' => { 231 => 0x8 },
	'face6position' => { 36 => 0x12, 148 => 0x18, 230 => 0xa, 266 => 0xa0, 267 => 0xb9 },
	'face6size' => { 231 => 0xa },
	'face7position' => { 36 => 0x14, 148 => 0x1c, 230 => 0xc, 266 => 0xc0, 267 => 0xde },
	'face7size' => { 231 => 0xc },
	'face8position' => { 36 => 0x16, 148 => 0x20, 230 => 0xe, 266 => 0xe0, 267 => 0x103 },
	'face8size' => { 231 => 0xe },
	'face9position' => { 36 => 0x18, 148 => 0x24, 230 => 0x10 },
	'face9size' => { 231 => 0x10 },
	'facedetect' => { 241 => 0x76 },
	'facedetectarea' => { 202 => 0x1201 },
	'facedetectframecrop' => { 202 => 0x1207 },
	'facedetectframeheight' => { 36 => 0x4 },
	'facedetectframesize' => { 148 => 0x1, 202 => 0x1203, 241 => 0x77 },
	'facedetectframewidth' => { 36 => 0x3 },
	'faceposition' => { 229 => 0x2 },
	'facepositions' => { 87 => 0x4103 },
	'facesdetected' => { 36 => 0x2, 37 => 0x2, 87 => 0x4100, 148 => 0x3, 202 => 0x1200, 218 => 0x3f, 229 => 0x0, 270 => 0x30 },
	'facesrecognized' => { 212 => 0x0 },
	'facewidth' => { 37 => 0x1 },
	'faithfuloutputhighlightpoint' => { 78 => 0x38 },
	'faithfuloutputshadowpoint' => { 78 => 0x39 },
	'faithfulrawcolortone' => { 78 => 0x31 },
	'faithfulrawcontrast' => { 78 => 0x33 },
	'faithfulrawhighlight' => { 78 => 0x79 },
	'faithfulrawhighlightpoint' => { 78 => 0x36 },
	'faithfulrawlinear' => { 78 => 0x34 },
	'faithfulrawsaturation' => { 78 => 0x32 },
	'faithfulrawshadow' => { 78 => 0x82 },
	'faithfulrawshadowpoint' => { 78 => 0x37 },
	'faithfulrawsharpness' => { 78 => 0x35 },
	'femicroadjustment' => { 59 => 0x110 },
	'ffid' => { 282 => 'ffid' },
	'fieldcount' => { 203 => 0x103f },
	'filedatarate' => { 302 => 'fileDataRate' },
	'fileformat' => { 70 => 0x0, 91 => 0x14, 262 => 0x22, 268 => 0xb000 },
	'fileindex' => { 4 => 0x143, 7 => 0x172, 9 => [0x227,0x22c], 10 => 0x133, 11 => 0x13f, 12 => 0x1d3, 13 => [0x197,0x19b], 14 => 0x1e4, 17 => 0x3d, 18 => 0x1d9, 20 => 0x1c7 },
	'filemodifydate' => { 84 => 'FileModifyDate' },
	'filename' => { 84 => 'FileName' },
	'filenameasdelivered' => { 292 => 'FileNameAsDelivered' },
	'filenumber' => { 38 => 0x1, 43 => 0x8, 72 => 0x1817, 81 => 'FileNumber', 149 => 0x8 },
	'filenumbermemory' => { 129 => 0x1a },
	'filenumbersequence' => { 193 => '12.2', 195 => '3.1', 197 => '5.2' },
	'filesource' => { 83 => 0xa300, 87 => 0x8000, 284 => 'FileSource' },
	'fileversion' => { 91 => 0x16 },
	'fillflashautoreduction' => { 57 => 0xe, 58 => 0xe, 65 => 0xa },
	'filllight' => { 280 => 'FillLight' },
	'fillorder' => { 83 => 0x10a },
	'filmmode' => { 87 => 0x1401, 215 => 0x412, 218 => 0x42 },
	'filmtype' => { 163 => 0x2 },
	'filtereffect' => { 38 => 0xe, 160 => 0x37 },
	'filtereffectfaithful' => { 48 => 0x70, 49 => 0x70 },
	'filtereffectlandscape' => { 48 => 0x40, 49 => 0x40 },
	'filtereffectmonochrome' => { 15 => 0xff, 48 => 0x88, 49 => 0x88 },
	'filtereffectneutral' => { 48 => 0x58, 49 => 0x58 },
	'filtereffectportrait' => { 48 => 0x28, 49 => 0x28 },
	'filtereffectstandard' => { 48 => 0x10, 49 => 0x10 },
	'filtereffectunknown' => { 49 => 0xa0 },
	'filtereffectuserdef1' => { 48 => 0xa0, 49 => 0xb8 },
	'filtereffectuserdef2' => { 48 => 0xb8, 49 => 0xd0 },
	'filtereffectuserdef3' => { 48 => 0xd0, 49 => 0xe8 },
	'finderdisplayduringexposure' => { 58 => 0x1 },
	'finesharpness' => { 241 => 0x70 },
	'finetuneoptcenterweighted' => { 193 => '7.2', 197 => '9.1' },
	'finetuneoptmatrixmetering' => { 193 => '8.1', 197 => '8.2' },
	'finetuneoptspotmetering' => { 193 => '8.2', 197 => '9.2' },
	'firmware' => { 203 => 0x405, 262 => [0x17,0x3b], 277 => 'Firmware' },
	'firmwaredate' => { 79 => 0x15, 80 => 0x2001 },
	'firmwareid' => { 135 => 0x0 },
	'firmwarename' => { 260 => 0xa001 },
	'firmwarerevision' => { 15 => 0xa4, 43 => 0x1e, 254 => 0x0 },
	'firmwarerevision2' => { 254 => 0xc },
	'firmwareversion' => { 4 => 0x10b, 7 => 0x136, 10 => 0xff, 11 => 0x107, 95 => 0xce5, 109 => 0x57, 111 => 'FirmwareVersion', 218 => 0x2, 219 => 0x3109, 241 => 0x230, 256 => 0x2 },
	'firstpublicationdate' => { 292 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 90 => 0x16 },
	'flash' => { 83 => 0x9209, 130 => 0x1f, 131 => 0x15, 284 => 'Flash' },
	'flashactivity' => { 24 => 0x1c },
	'flashbatterylevel' => { 30 => 0x249 },
	'flashbias' => { 218 => 0x24 },
	'flashbits' => { 24 => 0x1d },
	'flashchargelevel' => { 203 => 0x1010 },
	'flashcolorfilter' => { 152 => 0x10 },
	'flashcommandermode' => { 150 => '9.1', 151 => '9.1', 152 => '9.1' },
	'flashcompensation' => { 150 => 0xa, 151 => 0xa, 152 => 0xa, 277 => 'FlashCompensation' },
	'flashcontrolmode' => { 150 => '9.2', 151 => '9.2', 152 => '9.2', 198 => 0x404 },
	'flashdefault' => { 132 => 0x42 },
	'flashdevice' => { 203 => 0x1005 },
	'flashdistance' => { 80 => 0x2034 },
	'flashenergy' => { 83 => 0xa20b, 284 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 158 => 0x18 },
	'flashexposurecomp' => { 54 => 0xf, 87 => 0x1011, 114 => 'ExposureComp', 129 => 0x23, 133 => 0x104, 158 => 0x12, 198 => 0x401, 203 => 0x1023, 241 => 0x4d, 262 => 0x3a, 268 => 0x104 },
	'flashexposurecompset' => { 221 => 0xe },
	'flashexposurecompsetting' => { 132 => 0x10 },
	'flashexposureindicator' => { 132 => 0x54 },
	'flashexposureindicatorlast' => { 132 => 0x56 },
	'flashexposureindicatornext' => { 132 => 0x55 },
	'flashexposurelock' => { 38 => 0x19 },
	'flashfired' => { 97 => 0x5d, 114 => 'Fired', 129 => 0x14, 174 => '590.3', 218 => 0x8007, 284 => [\'Flash','FlashFired'] },
	'flashfiring' => { 59 => 0x306, 60 => 0x6, 61 => 0x7, 64 => 0x7 },
	'flashfirmwareversion' => { 199 => 0x1002 },
	'flashfocallength' => { 150 => 0xb, 151 => 0xc, 152 => 0xc },
	'flashfunction' => { 284 => [\'Flash','FlashFunction'] },
	'flashgndistance' => { 150 => 0xe, 151 => 0xf, 152 => 0xf },
	'flashgroupacompensation' => { 150 => 0x11, 151 => 0x12, 152 => 0x13 },
	'flashgroupacontrolmode' => { 150 => 0xf, 151 => '16.1', 152 => '17.1' },
	'flashgroupaoutput' => { 150 => 0x11, 151 => 0x12, 152 => 0x13 },
	'flashgroupbcompensation' => { 150 => 0x12, 151 => 0x13, 152 => 0x14 },
	'flashgroupbcontrolmode' => { 150 => 0x10, 151 => '17.1', 152 => '18.1' },
	'flashgroupboutput' => { 150 => 0x12, 151 => 0x13, 152 => 0x14 },
	'flashgroupccompensation' => { 151 => 0x14, 152 => 0x15 },
	'flashgroupccontrolmode' => { 151 => '17.2', 152 => '18.2' },
	'flashgroupcoutput' => { 151 => 0x14, 152 => 0x15 },
	'flashguidenumber' => { 54 => 0xd, 69 => 0x0, 114 => 'GuideNumber' },
	'flashintensity' => { 79 => [0x19,0x5], 198 => 0x405 },
	'flashlevel' => { 194 => 0x9, 268 => 0xb048 },
	'flashmake' => { 114 => 'Make' },
	'flashmanufacturer' => { 128 => 'FlashManufacturer' },
	'flashmetering' => { 129 => 0x3f, 132 => 0x1c },
	'flashmeteringmode' => { 4 => 0x15, 9 => 0x15, 10 => 0x15, 11 => 0x15, 12 => 0x15, 13 => 0x15, 14 => 0x15, 16 => 0x15, 19 => 0x15 },
	'flashmeteringsegments' => { 241 => 0x20a },
	'flashmode' => { 79 => 0x4, 97 => 0x5c, 114 => 'Mode', 129 => 0x2, 130 => 0x20, 131 => 0x16, 132 => 0xf, 158 => 0x87, 198 => 0x400, 203 => 0x1004, 241 => 0xc, 246 => 0x4, 255 => 0x20, 261 => 0x225, 263 => 0x23, 264 => 0x23, 284 => [\'Flash','FlashMode'] },
	'flashmodel' => { 114 => 'Model', 128 => 'FlashModel', 199 => 0x1001 },
	'flashoptions' => { 226 => 0x2 },
	'flashoptions2' => { 226 => 0x10 },
	'flashoutput' => { 30 => 0x248, 54 => 0x21, 150 => 0xa, 151 => 0xa, 152 => 0xa },
	'flashpixversion' => { 83 => 0xa000, 284 => 'FlashpixVersion' },
	'flashredeyemode' => { 284 => [\'Flash','FlashRedEyeMode'] },
	'flashremotecontrol' => { 198 => 0x403 },
	'flashreturn' => { 284 => [\'Flash','FlashReturn'] },
	'flashserialnumber' => { 114 => 'SerialNumber', 199 => 0x1003 },
	'flashsetting' => { 158 => 0x8 },
	'flashshutterspeed' => { 193 => '20.2', 196 => '7.2', 197 => '23.1' },
	'flashsource' => { 150 => 0x4, 151 => 0x4, 152 => 0x4 },
	'flashstatus' => { 233 => 0x0 },
	'flashsyncspeed' => { 193 => '20.1' },
	'flashsyncspeedav' => { 57 => 0x3, 59 => 0x10f, 60 => 0x2, 61 => 0x3, 62 => 0x2, 63 => 0x2, 64 => 0x3, 65 => 0x6 },
	'flashthreshold' => { 69 => 0x1 },
	'flashtype' => { 114 => 'Type', 132 => 0x59, 158 => 0x9, 199 => 0x1000 },
	'flashwarning' => { 196 => '7.1', 197 => '31.1', 218 => 0x62 },
	'flickerreduce' => { 261 => 0x218 },
	'fliphorizontal' => { 186 => 0x76a43206 },
	'fnumber' => { 4 => 0x3, 7 => 0x3, 9 => 0x3, 10 => 0x3, 11 => 0x3, 12 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 18 => 0x3, 19 => 0x3, 21 => 0x5, 22 => 0x6, 54 => 0x15, 83 => 0x829d, 94 => 0xfd04, 97 => 0x1e, 99 => 0xfa23, 101 => 0xf103, 104 => 0x13, 106 => 0x3c, 109 => 0xc, 118 => 'FNumber', 129 => 0xa, 130 => 0x36, 131 => 0x47, 132 => 0x9, 241 => 0x13, 260 => 0xa019, 262 => 0x31, 284 => 'FNumber' },
	'focallength' => { 4 => 0x1d, 5 => 0xa, 6 => 0x9, 7 => 0x1d, 8 => 0x9, 9 => 0x1e, 10 => 0x1d, 11 => 0x1d, 12 => 0x1e, 13 => 0x1e, 14 => 0x1e, 15 => 0x28, 16 => 0x1e, 18 => 0x1e, 19 => 0x1e, 40 => 0x1, 80 => 0x1d, 83 => 0x920a, 104 => 0x1d, 118 => 'FocalLength', 129 => 0x12, 156 => 0xa, 157 => 0xb, 235 => 0x9, 241 => 0x1d, 284 => 'FocalLength' },
	'focallengthin35mmformat' => { 83 => 0xa405, 260 => 0xa01a, 284 => 'FocalLengthIn35mmFilm' },
	'focalplanediagonal' => { 199 => 0x103, 203 => 0x205 },
	'focalplaneresolutionunit' => { 83 => 0xa210, 284 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 83 => 0xa20e, 284 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 40 => 0x2 },
	'focalplanexunknown' => { 40 => 0x2 },
	'focalplaneyresolution' => { 83 => 0xa20f, 284 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 40 => 0x3 },
	'focalplaneyunknown' => { 40 => 0x3 },
	'focaltype' => { 6 => 0x2d, 40 => 0x0 },
	'focalunits' => { 24 => 0x19 },
	'focus' => { 176 => 0x8 },
	'focusarea' => { 129 => 0x31 },
	'focusareaselection' => { 196 => '15.2' },
	'focuscontinuous' => { 24 => 0x20 },
	'focusdisplayaiservoandmf' => { 59 => 0x515 },
	'focusdistance' => { 118 => 'FocusDistance', 129 => 0x13, 156 => 0x9, 157 => 0xa, 201 => 0x305 },
	'focusdistancelower' => { 4 => 0x45, 7 => 0x45, 9 => 0x56, 10 => 0x45, 11 => 0x45, 12 => 0x52, 13 => 0x52, 14 => 0x56, 16 => 0x52, 18 => 0x57, 20 => 0x32, 54 => 0x14 },
	'focusdistanceupper' => { 4 => 0x43, 7 => 0x43, 9 => 0x54, 10 => 0x43, 11 => 0x43, 12 => 0x50, 13 => 0x50, 14 => 0x54, 16 => 0x50, 18 => 0x55, 20 => 0x30, 54 => 0x13 },
	'focusholdbutton' => { 132 => 0x44 },
	'focusinfoversion' => { 201 => 0x0 },
	'focusingscreen' => { 58 => 0x0, 59 => 0x80b, 64 => 0x0 },
	'focusmode' => { 24 => 0x7, 79 => 0x3, 80 => [0x3003,0xd], 87 => 0x1021, 97 => 0x38, 111 => 'FocusMode', 129 => 0x30, 131 => 0xe, 132 => 0xc, 158 => 0x7, 198 => 0x301, 203 => 0x100b, 218 => 0x7, 241 => 0xd, 246 => 0x3, 263 => 0x10, 264 => 0x10, 268 => 0xb042 },
	'focusmode2' => { 226 => '3.1' },
	'focusmodesetting' => { 194 => '10.1' },
	'focusmodeswitch' => { 132 => 0x58 },
	'focuspixel' => { 87 => 0x1023 },
	'focuspointwrap' => { 193 => '2.2', 197 => '2.5' },
	'focusposition' => { 156 => 0x8, 157 => 0x8, 241 => 0x10 },
	'focusprocess' => { 198 => 0x302 },
	'focusrange' => { 24 => 0x12, 203 => 0x100a },
	'focussetting' => { 262 => 0x6 },
	'focusstepcount' => { 201 => 0x301, 203 => 0x100e },
	'focusstepinfinity' => { 201 => 0x303, 203 => 0x103b },
	'focusstepnear' => { 201 => 0x304, 203 => 0x103c },
	'focustrackinglockon' => { 193 => ['1.5','4.1'] },
	'focuswarning' => { 87 => 0x1301 },
	'foldername' => { 129 => 0x27 },
	'fontcomposite' => { 307 => [\'Fonts','FontsComposite'] },
	'fontface' => { 307 => [\'Fonts','FontsFontFace'] },
	'fontfamily' => { 307 => [\'Fonts','FontsFontFamily'] },
	'fontfilename' => { 307 => [\'Fonts','FontsFontFileName'] },
	'fontname' => { 307 => [\'Fonts','FontsFontName'] },
	'fonts' => { 307 => 'Fonts' },
	'fonttype' => { 307 => [\'Fonts','FontsFontType'] },
	'fontversion' => { 307 => [\'Fonts','FontsVersionString'] },
	'for' => { 252 => 'For' },
	'format' => { 281 => 'format' },
	'forwardlock' => { 297 => 'forwardlock' },
	'forwardmatrix1' => { 83 => 0xc714 },
	'forwardmatrix2' => { 83 => 0xc715 },
	'framecount' => { 46 => [0x2,0x4] },
	'framenum' => { 247 => 0xd7 },
	'framenumber' => { 87 => 0x8003, 241 => 0x29 },
	'framerate' => { 46 => [0x1,0x6] },
	'frameselector' => { 217 => '0.1' },
	'freebytes' => { 72 => 0x1 },
	'freememorycardimages' => { 130 => [0x37,0x54], 131 => [0x2d,0x4a], 132 => 0x32 },
	'fujiflashmode' => { 87 => 0x1010 },
	'fullimagesize' => { 268 => 0xb02b },
	'fullsizeimage' => { 117 => 'data' },
	'fullsizeimagename' => { 117 => '1Name' },
	'fullsizeimagetype' => { 117 => '0Type' },
	'funcbutton' => { 193 => ['14.1','15.1'], 197 => '14.1' },
	'funcbuttonplusdials' => { 193 => ['14.2','15.2'] },
	'functionbutton' => { 196 => '5.2' },
	'gainbase' => { 202 => 0x610 },
	'gaincontrol' => { 83 => 0xa407, 284 => 'GainControl' },
	'gamma' => { 83 => 0xa500 },
	'gammacompensatedvalue' => { 92 => 0x91 },
	'gemake' => { 88 => 0x300 },
	'gemodel' => { 88 => 0x207 },
	'genre' => { 293 => 'genre', 302 => 'genre' },
	'geography' => { 294 => 'geography' },
	'geosync' => { 84 => 'Geosync' },
	'geotag' => { 84 => 'Geotag' },
	'geotime' => { 84 => 'Geotime' },
	'globalaltitude' => { 250 => 0x419 },
	'globalangle' => { 250 => 0x40d },
	'good' => { 302 => 'good' },
	'gpsaltitude' => { 89 => 0x6, 115 => 'Altitude', 284 => 'GPSAltitude' },
	'gpsaltituderef' => { 89 => 0x5, 284 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 89 => 0x1c, 284 => 'GPSAreaInformation' },
	'gpsdatestamp' => { 89 => 0x1d },
	'gpsdatetime' => { 115 => 'DateTime', 284 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 89 => 0x18, 115 => 'Bearing', 284 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 89 => 0x17, 284 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 89 => 0x1a, 115 => 'Distance', 284 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 89 => 0x19, 284 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 89 => 0x14, 284 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 89 => 0x13 },
	'gpsdestlongitude' => { 89 => 0x16, 284 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 89 => 0x15 },
	'gpsdifferential' => { 89 => 0x1e, 115 => 'Differential', 284 => 'GPSDifferential' },
	'gpsdop' => { 89 => 0xb, 284 => 'GPSDOP' },
	'gpshpositioningerror' => { 89 => 0x1f },
	'gpsimgdirection' => { 89 => 0x11, 284 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 89 => 0x10, 284 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 89 => 0x2, 115 => 'Latitude', 284 => 'GPSLatitude' },
	'gpslatituderef' => { 89 => 0x1 },
	'gpslongitude' => { 89 => 0x4, 115 => 'Longitude', 284 => 'GPSLongitude' },
	'gpslongituderef' => { 89 => 0x3 },
	'gpsmapdatum' => { 89 => 0x12, 115 => 'Datum', 284 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 89 => 0xa, 115 => 'MeasureMode', 284 => 'GPSMeasureMode' },
	'gpsprocessingmethod' => { 89 => 0x1b, 284 => 'GPSProcessingMethod' },
	'gpssatellites' => { 89 => 0x8, 115 => 'Satellites', 284 => 'GPSSatellites' },
	'gpsspeed' => { 89 => 0xd, 115 => 'Speed', 284 => 'GPSSpeed' },
	'gpsspeedref' => { 89 => 0xc, 284 => 'GPSSpeedRef' },
	'gpsstatus' => { 89 => 0x9, 284 => 'GPSStatus' },
	'gpstimestamp' => { 89 => 0x7 },
	'gpstrack' => { 89 => 0xf, 115 => 'Heading', 284 => 'GPSTrack' },
	'gpstrackref' => { 89 => 0xe, 284 => 'GPSTrackRef' },
	'gpsversionid' => { 89 => 0x0, 284 => 'GPSVersionID' },
	'gradation' => { 198 => 0x50f },
	'gradientbasedcorractive' => { 280 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'] },
	'gradientbasedcorramount' => { 280 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'] },
	'gradientbasedcorrbrightness' => { 280 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'] },
	'gradientbasedcorrclarity' => { 280 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'] },
	'gradientbasedcorrcontrast' => { 280 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'] },
	'gradientbasedcorrections' => { 280 => 'GradientBasedCorrections' },
	'gradientbasedcorrexposure' => { 280 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'] },
	'gradientbasedcorrhue' => { 280 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'] },
	'gradientbasedcorrmaskcenterweight' => { 280 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'gradientbasedcorrmaskdabs' => { 280 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'] },
	'gradientbasedcorrmaskflow' => { 280 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'] },
	'gradientbasedcorrmaskfullx' => { 280 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'] },
	'gradientbasedcorrmaskfully' => { 280 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'] },
	'gradientbasedcorrmaskradius' => { 280 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'] },
	'gradientbasedcorrmasks' => { 280 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'] },
	'gradientbasedcorrmaskvalue' => { 280 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'gradientbasedcorrmaskwhat' => { 280 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'] },
	'gradientbasedcorrmaskzerox' => { 280 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'] },
	'gradientbasedcorrmaskzeroy' => { 280 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'] },
	'gradientbasedcorrsaturation' => { 280 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation','GradientBasedCorrectionsLocalToningSaturation'] },
	'gradientbasedcorrsharpness' => { 280 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'] },
	'gradientbasedcorrwhat' => { 280 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'] },
	'graymixeraqua' => { 280 => 'GrayMixerAqua' },
	'graymixerblue' => { 280 => 'GrayMixerBlue' },
	'graymixergreen' => { 280 => 'GrayMixerGreen' },
	'graymixermagenta' => { 280 => 'GrayMixerMagenta' },
	'graymixerorange' => { 280 => 'GrayMixerOrange' },
	'graymixerpurple' => { 280 => 'GrayMixerPurple' },
	'graymixerred' => { 280 => 'GrayMixerRed' },
	'graymixeryellow' => { 280 => 'GrayMixerYellow' },
	'graypoint' => { 271 => 0x8021 },
	'grayresponseunit' => { 83 => 0x122 },
	'greencurvelimits' => { 77 => 0x1c4 },
	'greencurvepoints' => { 77 => 0x19a },
	'greenhue' => { 280 => 'GreenHue' },
	'greensaturation' => { 280 => 'GreenSaturation' },
	'griddisplay' => { 193 => '13.3', 195 => '2.2', 196 => '6.1', 197 => '4.2' },
	'gripbatteryadload' => { 224 => 0x5 },
	'gripbatteryadnoload' => { 224 => 0x4 },
	'gripbatterystate' => { 224 => '1.2' },
	'halftonehints' => { 83 => 0x141 },
	'hasalternative' => { 293 => 'hasAlternative' },
	'hascorrection' => { 293 => 'hasCorrection' },
	'hascrop' => { 280 => 'HasCrop' },
	'hasextendedxmp' => { 304 => 'HasExtendedXMP' },
	'haspreviousversion' => { 293 => 'hasPreviousVersion' },
	'hassettings' => { 280 => 'HasSettings' },
	'hastranslation' => { 293 => 'hasTranslation' },
	'hdr' => { 268 => 0x200a },
	'headline' => { 90 => 0x69, 291 => 'Headline' },
	'hierarchicalkeywords' => { 288 => [\'Keywords','KeywordsHierarchy'] },
	'hierarchicalkeywords1' => { 288 => [\'Keywords','KeywordsHierarchyKeyword'] },
	'hierarchicalkeywords1applied' => { 288 => [\'Keywords','KeywordsHierarchyApplied'] },
	'hierarchicalkeywords1children' => { 288 => [\'Keywords','KeywordsHierarchyChildren'] },
	'hierarchicalkeywords2' => { 288 => [\'Keywords','KeywordsHierarchyChildrenKeyword'] },
	'hierarchicalkeywords2applied' => { 288 => [\'Keywords','KeywordsHierarchyChildrenApplied'] },
	'hierarchicalkeywords2children' => { 288 => [\'Keywords','KeywordsHierarchyChildrenChildren'] },
	'hierarchicalkeywords3' => { 288 => [\'Keywords','KeywordsHierarchyChildrenChildrenKeyword'] },
	'hierarchicalkeywords3applied' => { 288 => [\'Keywords','KeywordsHierarchyChildrenChildrenApplied'] },
	'hierarchicalkeywords3children' => { 288 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildren'] },
	'hierarchicalkeywords4' => { 288 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords4applied' => { 288 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenApplied'] },
	'hierarchicalsubject' => { 274 => 'hierarchicalSubject' },
	'highisonoisereduction' => { 12 => 0xbc, 13 => 0xbd, 16 => 0xbd, 20 => 0xa5, 59 => 0x202, 158 => 0xb1, 241 => 0x71, 263 => 0x2c, 268 => 0x2009 },
	'highlight' => { 262 => 0xf },
	'highlightcolordistortreduct' => { 271 => 0x8026 },
	'highlightprotection' => { 185 => 0x6 },
	'highlightrecovery' => { 280 => 'HighlightRecovery' },
	'highlighttonepriority' => { 9 => 0x7, 12 => 0x7, 13 => 0x7, 14 => 0x7, 16 => 0x7, 19 => 0x7, 59 => 0x203 },
	'highlowkeyadj' => { 241 => 0x6c },
	'highspeedsync' => { 132 => 0x5 },
	'history' => { 291 => 'History', 303 => 'History' },
	'historyaction' => { 303 => [\'History','HistoryAction'] },
	'historychanged' => { 303 => [\'History','HistoryChanged'] },
	'historyinstanceid' => { 303 => [\'History','HistoryInstanceID'] },
	'historyparameters' => { 303 => [\'History','HistoryParameters'] },
	'historysoftwareagent' => { 303 => [\'History','HistorySoftwareAgent'] },
	'historywhen' => { 303 => [\'History','HistoryWhen'] },
	'hometowncity' => { 80 => 0x3006, 241 => 0x23, 245 => 0x2 },
	'hometowncitycode' => { 246 => 0x1000 },
	'hometowndst' => { 241 => 0x25, 245 => '0.2' },
	'hostcomputer' => { 83 => 0x13c },
	'hue' => { 136 => 0x3b, 241 => 0x67 },
	'hueadj' => { 189 => 0x2f, 271 => 0x8019 },
	'hueadjustment' => { 130 => 0x4a, 131 => 0x40, 158 => 0x92, 160 => 0x36 },
	'hueadjustmentaqua' => { 280 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 280 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 280 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 280 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 280 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 280 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 280 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 280 => 'HueAdjustmentYellow' },
	'huesetting' => { 206 => 0x1011 },
	'icc_profile' => { 84 => 'ICC_Profile' },
	'iccprofilename' => { 291 => 'ICCProfile' },
	'idccreativestyle' => { 271 => 0x8000 },
	'idcpreviewlength' => { 271 => 0x202 },
	'idcpreviewstart' => { 271 => 0x201 },
	'identifier' => { 281 => 'identifier', 300 => 'Identifier' },
	'illumination' => { 196 => '0.5' },
	'imageadjustment' => { 158 => 0x80, 176 => 0x5 },
	'imagealterationconstraints' => { 292 => 'ImageAlterationConstraints' },
	'imagearea' => { 168 => 0x10, 171 => 0x10 },
	'imageareaoffset' => { 241 => 0x38 },
	'imageauthentication' => { 158 => 0x20 },
	'imageboundary' => { 158 => 0x16 },
	'imagecount' => { 158 => 0xa5 },
	'imagecreator' => { 292 => 'ImageCreator' },
	'imagecreatorid' => { 292 => [\'ImageCreator','ImageCreatorImageCreatorID'] },
	'imagecreatorimageid' => { 292 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 292 => [\'ImageCreator','ImageCreatorImageCreatorName'] },
	'imagedatasize' => { 158 => 0xa2 },
	'imagedescription' => { 83 => 0x10e, 298 => 'ImageDescription' },
	'imageduplicationconstraints' => { 292 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 186 => 0xfe443a45 },
	'imageeditcount' => { 241 => 0x41 },
	'imageediting' => { 241 => 0x32 },
	'imagefileconstraints' => { 292 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 292 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 292 => 'ImageFileSizeAsDelivered' },
	'imageheight' => { 83 => 0x101, 135 => 0xc, 298 => 'ImageLength' },
	'imagehistory' => { 83 => 0x9213 },
	'imageidnumber' => { 213 => 0x340 },
	'imagenumber' => { 15 => 0xd0, 83 => 0x9211, 111 => 'ImageNumber', 130 => 0xae, 131 => 0x5e, 277 => 'ImageNumber' },
	'imagenumber2' => { 131 => 0x62 },
	'imageoptimization' => { 158 => 0xa9 },
	'imageorientation' => { 90 => 0x83 },
	'imageprocessing' => { 158 => 0x1a },
	'imageprocessingversion' => { 202 => 0x0 },
	'imagequality' => { 111 => 'ImageQuality', 170 => '723.2', 171 => '732.2', 174 => '708.1', 218 => 0x1 },
	'imagequality2' => { 198 => 0x603 },
	'imagereview' => { 194 => '0.4', 196 => '0.4' },
	'imagereviewtime' => { 194 => '2.1', 195 => '19.1', 197 => '21.2' },
	'imagesize' => { 117 => 'ImageSize' },
	'imagesizerestriction' => { 295 => 'imageSizeRestriction' },
	'imagesourcedata' => { 83 => 0x935c },
	'imagestabilization' => { 24 => 0x22, 80 => 0x3020, 111 => 'ImageStabilization', 130 => 0xbd, 131 => 0x71, 132 => 0x57, 133 => [0x18,0x107,0x113], 158 => 0xac, 198 => 0x604, 201 => 0x1600, 218 => 0x1a, 263 => 0x3d, 268 => 0xb026 },
	'imagestyle' => { 263 => 0x2d },
	'imagesupplier' => { 292 => 'ImageSupplier' },
	'imagesupplierid' => { 292 => [\'ImageSupplier','ImageSupplierImageSupplierID'] },
	'imagesupplierimageid' => { 292 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 292 => [\'ImageSupplier','ImageSupplierImageSupplierName'] },
	'imagetone' => { 241 => 0x4f },
	'imagetype' => { 90 => 0x82, 292 => 'ImageType' },
	'imageuniqueid' => { 43 => 0x28, 83 => 0xa420, 284 => 'ImageUniqueID' },
	'imagewidth' => { 83 => 0x100, 135 => 0xe, 298 => 'ImageWidth' },
	'incrementaltemperature' => { 280 => 'IncrementalTemperature' },
	'incrementaltint' => { 280 => 'IncrementalTint' },
	'industry' => { 293 => 'industry', 294 => 'industry' },
	'infobuttonwhenshooting' => { 59 => 0x409 },
	'infraredilluminator' => { 253 => 0x28 },
	'ingredients' => { 303 => 'Ingredients' },
	'ingredientsalternatepaths' => { 303 => [\'Ingredients','IngredientsAlternatePaths'] },
	'ingredientsdocumentid' => { 303 => [\'Ingredients','IngredientsDocumentID'] },
	'ingredientsfilepath' => { 303 => [\'Ingredients','IngredientsFilePath'] },
	'ingredientsfrompart' => { 303 => [\'Ingredients','IngredientsFromPart'] },
	'ingredientsinstanceid' => { 303 => [\'Ingredients','IngredientsInstanceID'] },
	'ingredientslastmodifydate' => { 303 => [\'Ingredients','IngredientsLastModifyDate'] },
	'ingredientsmanager' => { 303 => [\'Ingredients','IngredientsManager'] },
	'ingredientsmanagervariant' => { 303 => [\'Ingredients','IngredientsManagerVariant'] },
	'ingredientsmanageto' => { 303 => [\'Ingredients','IngredientsManageTo'] },
	'ingredientsmanageui' => { 303 => [\'Ingredients','IngredientsManageUI'] },
	'ingredientsmaskmarkers' => { 303 => [\'Ingredients','IngredientsMaskMarkers'] },
	'ingredientsoriginaldocumentid' => { 303 => [\'Ingredients','IngredientsOriginalDocumentID'] },
	'ingredientspartmapping' => { 303 => [\'Ingredients','IngredientsPartMapping'] },
	'ingredientsrenditionclass' => { 303 => [\'Ingredients','IngredientsRenditionClass'] },
	'ingredientsrenditionparams' => { 303 => [\'Ingredients','IngredientsRenditionParams'] },
	'ingredientstopart' => { 303 => [\'Ingredients','IngredientsToPart'] },
	'ingredientsversionid' => { 303 => [\'Ingredients','IngredientsVersionID'] },
	'initialzoomliveview' => { 193 => '4.4' },
	'initialzoomsetting' => { 193 => '9.3' },
	'inkset' => { 83 => 0x14c },
	'instanceid' => { 303 => 'InstanceID' },
	'instantplaybacksetup' => { 132 => 0x3e },
	'instantplaybacktime' => { 132 => 0x3d },
	'instructions' => { 291 => 'Instructions' },
	'instrument' => { 302 => 'instrument' },
	'intellectualgenre' => { 285 => 'IntellectualGenre' },
	'intelligentauto' => { 268 => 0xb052 },
	'intelligentd-range' => { 218 => 0x79 },
	'intelligentexposure' => { 218 => 0x5d },
	'intelligentresolution' => { 218 => 0x70 },
	'interchangecolorspace' => { 92 => 0x40 },
	'internalflash' => { 129 => 0x2b, 193 => '23.1', 194 => '8.1', 195 => '22.1', 196 => '8.1', 197 => '24.1', 201 => 0x1208 },
	'internalflashae1' => { 203 => 0x1021 },
	'internalflashae1_0' => { 203 => 0x101d },
	'internalflashae2' => { 203 => 0x1022 },
	'internalflashae2_0' => { 203 => 0x101e },
	'internalflashmode' => { 233 => 0x1 },
	'internalflashstrength' => { 233 => 0x3 },
	'internalflashtable' => { 203 => 0x1024 },
	'internalserialnumber' => { 43 => 0x96, 53 => 0x9, 87 => 0x10, 134 => 0x49dc, 199 => 0x102, 218 => 0x25, 225 => 0x4, 256 => 0x5 },
	'interopindex' => { 83 => 0x1 },
	'interopversion' => { 83 => 0x2 },
	'intervallength' => { 129 => 0x10 },
	'intervalmode' => { 129 => 0x26 },
	'intervalnumber' => { 129 => 0x11 },
	'introtime' => { 302 => 'introTime' },
	'introtimescale' => { 302 => [\'introTime','introTimeScale'] },
	'introtimevalue' => { 302 => [\'introTime','introTimeValue'] },
	'iptc-naa' => { 83 => 0x83bb, 220 => 0x83bb },
	'iptcbitspersample' => { 92 => 0x56 },
	'iptcdigest' => { 250 => 0x425 },
	'iptcimageheight' => { 92 => 0x1e },
	'iptcimagerotation' => { 92 => 0x66 },
	'iptcimagewidth' => { 92 => 0x14 },
	'iptclastedited' => { 286 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 92 => 0xa },
	'iptcpixelheight' => { 92 => 0x32 },
	'iptcpixelwidth' => { 92 => 0x28 },
	'isbn' => { 293 => 'isbn' },
	'iscorrectionof' => { 293 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 78 => 0x3 },
	'iso' => { 4 => 0x6, 6 => 0x75, 7 => 0x6, 8 => 0x79, 9 => 0x6, 10 => 0x6, 11 => 0x6, 12 => 0x6, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 18 => 0x6, 19 => 0x6, 21 => 0x0, 22 => 0x1, 79 => 0x14, 80 => [0x3014,0x14], 83 => 0x8827, 94 => 0xfd06, 95 => 0x1784, 97 => 0x60, 99 => [0xfa2e,0xfa46], 100 => [0x27,0x28], 101 => 0xf105, 104 => 0x14, 106 => 0x4e, 109 => 0x34, 111 => 'ISO', 129 => 0x8, 154 => 0x0, 158 => 0x2, 220 => 0x17, 241 => 0x14, 246 => 0x14, 260 => 0xa014, 284 => 'ISOSpeedRatings' },
	'iso2' => { 154 => 0x6, 165 => 0x265, 166 => 0x25c, 167 => 0x265, 168 => 0x221, 169 => 0x25d, 170 => 0x256, 171 => 0x25d, 173 => 0x2b5, 175 => 0x2b5 },
	'isoauto' => { 226 => '14.4' },
	'isoautoparameters' => { 241 => 0x7a },
	'isodisplay' => { 195 => '2.3', 197 => '4.3' },
	'isoexpansion' => { 59 => 0x103, 60 => 0x7, 61 => 0x8, 64 => 0x8, 154 => 0x4 },
	'isoexpansion2' => { 154 => 0xa },
	'isofloor' => { 226 => 0x6 },
	'isoselection' => { 158 => 0xf },
	'isosetting' => { 97 => 0x5e, 111 => 'ISOSetting', 129 => 0x24, 130 => 0x26, 131 => 0x1c, 132 => 0x13, 136 => 0x6, 158 => 0x13, 226 => '17.3', 255 => 0x27, 263 => 0x16, 264 => 0x14 },
	'isospeed' => { 83 => 0x8833 },
	'isospeedexpansion' => { 58 => 0x3 },
	'isospeedincrements' => { 59 => 0x102 },
	'isospeedlatitudeyyy' => { 83 => 0x8834 },
	'isospeedlatitudezzz' => { 83 => 0x8835 },
	'isospeedrange' => { 59 => 0x103 },
	'isostepsize' => { 193 => '6.1' },
	'isovalue' => { 203 => 0x1001 },
	'issn' => { 293 => 'issn' },
	'issueidentifier' => { 293 => 'issueIdentifier' },
	'issuename' => { 293 => 'issueName' },
	'istranslationof' => { 293 => 'isTranslationOf' },
	'jobid' => { 90 => 0xb8 },
	'jobref' => { 301 => 'JobRef' },
	'jobrefid' => { 301 => [\'JobRef','JobRefId'] },
	'jobrefname' => { 301 => [\'JobRef','JobRefName'] },
	'jobrefurl' => { 301 => [\'JobRef','JobRefUrl'] },
	'jpegquality' => { 6 => 0x66, 219 => 0x3034 },
	'jpegsize' => { 219 => 0x303a },
	'jpgfromraw' => { 72 => 0x2007, 81 => 'JpgFromRaw', 220 => 0x2e },
	'jpgfromrawlength' => { 83 => [0x117,0x202] },
	'jpgfromrawstart' => { 83 => [0x111,0x201] },
	'jpgrecordedpixels' => { 226 => '14.1' },
	'key' => { 302 => 'key' },
	'keyword' => { 293 => 'keyword' },
	'keywordinfo' => { 288 => 'Keywords' },
	'keywords' => { 90 => 0x19, 112 => 'Keywords', 207 => 'Keywords', 252 => 'Keywords', 276 => 'keywords', 290 => 'Keywords' },
	'killdate' => { 293 => 'killDate' },
	'kodakimageheight' => { 94 => 0xf908, 97 => 0xe, 99 => [0xfa1e,0xfa52], 105 => 0x70 },
	'kodakimagewidth' => { 94 => 0xf907, 97 => 0xc, 99 => [0xfa1d,0xfa51], 105 => 0x6c },
	'kodakinfotype' => { 94 => 0xfa00 },
	'kodakmaker' => { 105 => 0x8 },
	'kodakmodel' => { 97 => 0x0, 105 => 0x28 },
	'label' => { 209 => 'Label', 300 => 'Label' },
	'landmark' => { 218 => 0x6f },
	'landscapeoutputhighlightpoint' => { 78 => 0x26 },
	'landscapeoutputshadowpoint' => { 78 => 0x27 },
	'landscaperawcolortone' => { 78 => 0x1f },
	'landscaperawcontrast' => { 78 => 0x21 },
	'landscaperawhighlight' => { 78 => 0x77 },
	'landscaperawhighlightpoint' => { 78 => 0x24 },
	'landscaperawlinear' => { 78 => 0x22 },
	'landscaperawsaturation' => { 78 => 0x20 },
	'landscaperawshadow' => { 78 => 0x80 },
	'landscaperawshadowpoint' => { 78 => 0x25 },
	'landscaperawsharpness' => { 78 => 0x23 },
	'language' => { 281 => 'language' },
	'languageidentifier' => { 90 => 0x87 },
	'lastfilenumber' => { 129 => 0x1b },
	'lastkeywordiptc' => { 128 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 128 => 'LastKeywordXMP' },
	'lasturl' => { 303 => 'LastURL' },
	'lc1' => { 235 => 0x2 },
	'lc10' => { 235 => 0xb },
	'lc11' => { 235 => 0xc },
	'lc12' => { 235 => 0xd },
	'lc14' => { 235 => 0xf },
	'lc15' => { 235 => 0x10 },
	'lc2' => { 235 => 0x3 },
	'lc3' => { 235 => 0x4 },
	'lc4' => { 235 => 0x5 },
	'lc5' => { 235 => 0x6 },
	'lc6' => { 235 => 0x7 },
	'lc7' => { 235 => 0x8 },
	'lcddisplayatpoweron' => { 59 => 0x811, 63 => 0xa },
	'lcddisplayreturntoshoot' => { 64 => 0x12 },
	'lcdillumination' => { 193 => '17.5', 197 => '5.4' },
	'lcdilluminationduringbulb' => { 59 => 0x408 },
	'lcdpanels' => { 58 => 0x8 },
	'lcheditor' => { 186 => 0x8ae85e },
	'legacyiptcdigest' => { 291 => 'LegacyIPTCDigest' },
	'lens' => { 83 => 0xfdea, 158 => 0x84, 277 => 'Lens' },
	'lensafstopbutton' => { 57 => 0x11, 58 => 0x13, 59 => 0x506, 60 => 0x10, 61 => 0x12, 64 => 0x13, 65 => 0x9 },
	'lensaperturerange' => { 262 => 0x30 },
	'lensdistortionparams' => { 203 => 0x206 },
	'lensdrivenoaf' => { 59 => 0x505 },
	'lensfirmware' => { 257 => 0x20 },
	'lensfirmwareversion' => { 199 => 0x204 },
	'lensfocalrange' => { 262 => 0xa },
	'lensfstops' => { 155 => 0x7, 156 => 0xc, 157 => 0xd, 158 => 0x8b, 235 => '0.3' },
	'lensid' => { 277 => 'LensID' },
	'lensidnumber' => { 155 => 0x6, 156 => 0xb, 157 => 0xc },
	'lensinfo' => { 83 => 0xa432, 277 => 'LensInfo' },
	'lenskind' => { 235 => 0x1 },
	'lensmake' => { 83 => 0xa433, 118 => 'Make' },
	'lensmanufacturer' => { 128 => 'LensManufacturer' },
	'lensmodel' => { 4 => 0x937, 10 => 0x92b, 11 => 0x933, 43 => 0x95, 83 => 0xa434, 118 => 'Model', 128 => 'LensModel', 199 => 0x203 },
	'lensproperties' => { 199 => 0x20b },
	'lensserialnumber' => { 41 => 0x0, 83 => 0xa435, 118 => 'SerialNumber', 199 => 0x202, 218 => 0x52, 257 => 0x30 },
	'lensshutterlock' => { 132 => 0x4a },
	'lenstemperature' => { 203 => 0x1008 },
	'lenstype' => { 4 => 0xe2, 5 => 0xd, 6 => 0xc, 7 => 0x111, 8 => 0xc, 9 => [0x14e,0x14f], 10 => 0xd6, 11 => 0xde, 12 => 0xf6, 13 => 0xea, 14 => 0xff, 15 => [0xc,0x97], 16 => 0xe6, 18 => 0xe8, 20 => 0xee, 24 => 0x16, 133 => 0x10c, 158 => 0x83, 199 => 0x201, 210 => 0x16, 216 => 0x303, 217 => 0x0, 218 => 0x51, 219 => 0x3405, 236 => 0x0, 237 => 0x0, 238 => 0x1, 239 => 0x1, 241 => 0x3f, 260 => 0xa003, 268 => 0xb027 },
	'levelgaugepitch' => { 198 => 0x904 },
	'levelgaugeroll' => { 198 => 0x903 },
	'levelorientation' => { 240 => 0x0 },
	'license' => { 278 => 'license' },
	'licensee' => { 292 => 'Licensee' },
	'licenseeid' => { 292 => [\'Licensee','LicenseeLicenseeID'] },
	'licenseeimageid' => { 292 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 292 => 'LicenseeImageNotes' },
	'licenseename' => { 292 => [\'Licensee','LicenseeLicenseeName'] },
	'licenseenddate' => { 292 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 292 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 292 => 'LicenseeTransactionID' },
	'licenseid' => { 292 => 'LicenseID' },
	'licensestartdate' => { 292 => 'LicenseStartDate' },
	'licensetransactiondate' => { 292 => 'LicenseTransactionDate' },
	'licensetype' => { 282 => 'licensetype' },
	'licensor' => { 292 => 'Licensor' },
	'licensorcity' => { 292 => [\'Licensor','LicensorLicensorCity'] },
	'licensorcountry' => { 292 => [\'Licensor','LicensorLicensorCountry'] },
	'licensoremail' => { 292 => [\'Licensor','LicensorLicensorEmail'] },
	'licensorextendedaddress' => { 292 => [\'Licensor','LicensorLicensorExtendedAddress'] },
	'licensorid' => { 292 => [\'Licensor','LicensorLicensorID'] },
	'licensorimageid' => { 292 => 'LicensorImageID' },
	'licensorname' => { 292 => [\'Licensor','LicensorLicensorName'] },
	'licensornotes' => { 292 => 'LicensorNotes' },
	'licensorpostalcode' => { 292 => [\'Licensor','LicensorLicensorPostalCode'] },
	'licensorregion' => { 292 => [\'Licensor','LicensorLicensorRegion'] },
	'licensorstreetaddress' => { 292 => [\'Licensor','LicensorLicensorStreetAddress'] },
	'licensortelephone1' => { 292 => [\'Licensor','LicensorLicensorTelephone1'] },
	'licensortelephone2' => { 292 => [\'Licensor','LicensorLicensorTelephone2'] },
	'licensortelephonetype1' => { 292 => [\'Licensor','LicensorLicensorTelephoneType1'] },
	'licensortelephonetype2' => { 292 => [\'Licensor','LicensorLicensorTelephoneType2'] },
	'licensortransactionid' => { 292 => 'LicensorTransactionID' },
	'licensorurl' => { 292 => [\'Licensor','LicensorLicensorURL'] },
	'lightcondition' => { 203 => 0x1009 },
	'lightingmode' => { 80 => 0x302a },
	'lightreading' => { 241 => 0x15 },
	'lightsource' => { 83 => 0x9208, 158 => 0x90, 206 => 0x1000, 284 => 'LightSource' },
	'lightsourcespecial' => { 261 => 0x21d },
	'lightswitch' => { 197 => '0.1' },
	'lightvaluecenter' => { 203 => 0x103d },
	'lightvalueperiphery' => { 203 => 0x103e },
	'linearresponselimit' => { 83 => 0xc62e },
	'linkaetoafpoint' => { 226 => '14.2' },
	'liveviewaf' => { 195 => '32.1', 197 => '34.1' },
	'liveviewexposuresimulation' => { 59 => 0x810 },
	'liveviewshooting' => { 38 => 0x13 },
	'localafareapoint' => { 132 => 0xd, 263 => 0x12, 264 => 0x12 },
	'localcaption' => { 90 => 0x79 },
	'localizedcameramodel' => { 83 => 0xc615 },
	'location' => { 218 => 0x67, 275 => 'Location', 285 => 'Location', 293 => 'location' },
	'locationareacode' => { 279 => 'lac' },
	'locationcreated' => { 286 => 'LocationCreated' },
	'locationcreatedcity' => { 286 => [\'LocationCreated','LocationCreatedCity'] },
	'locationcreatedcountrycode' => { 286 => [\'LocationCreated','LocationCreatedCountryCode'] },
	'locationcreatedcountryname' => { 286 => [\'LocationCreated','LocationCreatedCountryName'] },
	'locationcreatedprovincestate' => { 286 => [\'LocationCreated','LocationCreatedProvinceState'] },
	'locationcreatedsublocation' => { 286 => [\'LocationCreated','LocationCreatedSublocation'] },
	'locationcreatedworldregion' => { 286 => [\'LocationCreated','LocationCreatedWorldRegion'] },
	'locationshown' => { 286 => 'LocationShown' },
	'locationshowncity' => { 286 => [\'LocationShown','LocationShownCity'] },
	'locationshowncountrycode' => { 286 => [\'LocationShown','LocationShownCountryCode'] },
	'locationshowncountryname' => { 286 => [\'LocationShown','LocationShownCountryName'] },
	'locationshownprovincestate' => { 286 => [\'LocationShown','LocationShownProvinceState'] },
	'locationshownsublocation' => { 286 => [\'LocationShown','LocationShownSublocation'] },
	'locationshownworldregion' => { 286 => [\'LocationShown','LocationShownWorldRegion'] },
	'lockmicrophonebutton' => { 59 => 0x709 },
	'logcomment' => { 302 => 'logComment' },
	'longexposurenoisereduction' => { 59 => 0x201, 60 => 0x1, 61 => 0x2, 62 => 0x1, 63 => 0x1, 64 => 0x2, 65 => 0x1, 263 => 0x2b, 268 => [0xb04e,0x2008] },
	'longexposurenoisereduction2' => { 38 => 0x8 },
	'longfocal' => { 5 => 0x10, 6 => 0x13, 7 => 0x115, 8 => 0x13, 9 => [0x152,0x153], 10 => 0xda, 12 => 0xfa, 13 => 0xee, 14 => 0x103, 15 => 0x95, 16 => 0xea, 18 => 0xec, 20 => 0xf2, 24 => 0x17 },
	'loop' => { 302 => 'loop' },
	'luminanceadjustmentaqua' => { 280 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 280 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 280 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 280 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 280 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 280 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 280 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 280 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 77 => 0x150 },
	'luminancecurvepoints' => { 77 => 0x126 },
	'luminancenoisereduction' => { 78 => 0x5f, 262 => 0x1b },
	'luminancenr_tiff_jpeg' => { 78 => 0x6d },
	'luminancesmoothing' => { 280 => 'LuminanceSmoothing' },
	'm16cversion' => { 213 => 0x333 },
	'macro' => { 87 => 0x1020, 88 => 0x202, 203 => 0x202, 255 => 0x21, 261 => 0x202, 268 => 0xb040 },
	'macromagnification' => { 4 => 0x1b, 7 => 0x1b, 10 => 0x1b, 11 => 0x1b, 15 => 0x1b, 16 => 0x1b, 38 => 0x10 },
	'macromode' => { 24 => 0x1, 129 => 0xb, 198 => 0x300, 218 => 0x1c },
	'magicfilter' => { 198 => 0x52c },
	'magnifiedview' => { 61 => 0x11, 63 => 0x9 },
	'maindialexposurecomp' => { 196 => '0.6' },
	'make' => { 73 => 0x0, 83 => 0x10f, 111 => 'Make', 209 => 'Make', 220 => 0x10f, 298 => 'Make' },
	'makernote' => { 284 => 'MakerNote' },
	'makernotecanon' => { 82 => 'MakN', 83 => 0x927c },
	'makernotecasio' => { 82 => 'MakN', 83 => 0x927c },
	'makernotecasio2' => { 82 => 'MakN', 83 => 0x927c },
	'makernotefujifilm' => { 82 => 'MakN', 83 => 0x927c },
	'makernotege' => { 82 => 'MakN', 83 => 0x927c },
	'makernotege2' => { 82 => 'MakN', 83 => 0x927c },
	'makernotehp' => { 82 => 'MakN', 83 => 0x927c },
	'makernotehp2' => { 82 => 'MakN', 83 => 0x927c },
	'makernotehp4' => { 82 => 'MakN', 83 => 0x927c },
	'makernotehp6' => { 82 => 'MakN', 83 => 0x927c },
	'makernoteisl' => { 82 => 'MakN', 83 => 0x927c },
	'makernotejvc' => { 82 => 'MakN', 83 => 0x927c },
	'makernotejvctext' => { 82 => 'MakN', 83 => 0x927c },
	'makernotekodak10' => { 82 => 'MakN', 83 => 0x927c },
	'makernotekodak1a' => { 82 => 'MakN', 83 => 0x927c },
	'makernotekodak1b' => { 82 => 'MakN', 83 => 0x927c },
	'makernotekodak2' => { 82 => 'MakN', 83 => 0x927c },
	'makernotekodak3' => { 82 => 'MakN', 83 => 0x927c },
	'makernotekodak4' => { 82 => 'MakN', 83 => 0x927c },
	'makernotekodak5' => { 82 => 'MakN', 83 => 0x927c },
	'makernotekodak6a' => { 82 => 'MakN', 83 => 0x927c },
	'makernotekodak6b' => { 82 => 'MakN', 83 => 0x927c },
	'makernotekodak7' => { 82 => 'MakN', 83 => 0x927c },
	'makernotekodak8a' => { 82 => 'MakN', 83 => 0x927c },
	'makernotekodak8b' => { 82 => 'MakN', 83 => 0x927c },
	'makernotekodak9' => { 82 => 'MakN', 83 => 0x927c },
	'makernotekodakunknown' => { 82 => 'MakN', 83 => 0x927c },
	'makernotekyocera' => { 82 => 'MakN', 83 => 0x927c },
	'makernoteleica' => { 82 => 'MakN', 83 => 0x927c },
	'makernoteleica2' => { 82 => 'MakN', 83 => 0x927c },
	'makernoteleica3' => { 82 => 'MakN', 83 => 0x927c },
	'makernoteleica4' => { 82 => 'MakN', 83 => 0x927c },
	'makernoteleica5' => { 82 => 'MakN', 83 => 0x927c },
	'makernoteleica6' => { 82 => 'MakN', 83 => 0x927c },
	'makernoteminolta' => { 82 => 'MakN', 83 => 0x927c },
	'makernoteminolta2' => { 82 => 'MakN', 83 => 0x927c },
	'makernoteminolta3' => { 82 => 'MakN', 83 => 0x927c },
	'makernotenikon' => { 82 => 'MakN', 83 => 0x927c },
	'makernotenikon2' => { 82 => 'MakN', 83 => 0x927c },
	'makernotenikon3' => { 82 => 'MakN', 83 => 0x927c },
	'makernoteoffset' => { 261 => 0xff },
	'makernoteolympus' => { 82 => 'MakN', 83 => 0x927c },
	'makernoteolympus2' => { 82 => 'MakN', 83 => 0x927c },
	'makernotepanasonic' => { 82 => 'MakN', 83 => 0x927c },
	'makernotepanasonic2' => { 82 => 'MakN', 83 => 0x927c },
	'makernotepentax' => { 82 => 'MakN', 83 => 0x927c },
	'makernotepentax2' => { 82 => 'MakN', 83 => 0x927c },
	'makernotepentax3' => { 82 => 'MakN', 83 => 0x927c },
	'makernotepentax4' => { 82 => 'MakN', 83 => 0x927c },
	'makernotephaseone' => { 82 => 'MakN', 83 => 0x927c },
	'makernotereconyx' => { 82 => 'MakN', 83 => 0x927c },
	'makernotericoh' => { 82 => 'MakN', 83 => 0x927c },
	'makernotericohtext' => { 82 => 'MakN', 83 => 0x927c },
	'makernotesafety' => { 83 => 0xc635 },
	'makernotesamsung1a' => { 82 => 'MakN', 83 => 0x927c },
	'makernotesamsung1b' => { 82 => 'MakN', 83 => 0x927c },
	'makernotesamsung2' => { 82 => 'MakN', 83 => 0x927c },
	'makernotesanyo' => { 82 => 'MakN', 83 => 0x927c },
	'makernotesanyoc4' => { 82 => 'MakN', 83 => 0x927c },
	'makernotesanyopatch' => { 82 => 'MakN', 83 => 0x927c },
	'makernotesigma' => { 82 => 'MakN', 83 => 0x927c },
	'makernotesony' => { 82 => 'MakN', 83 => 0x927c },
	'makernotesony2' => { 82 => 'MakN', 83 => 0x927c },
	'makernotesony3' => { 82 => 'MakN', 83 => 0x927c },
	'makernotesony4' => { 82 => 'MakN', 83 => 0x927c },
	'makernotesonyericsson' => { 82 => 'MakN', 83 => 0x927c },
	'makernotesonysrf' => { 82 => 'MakN', 83 => 0x927c },
	'makernotetype' => { 256 => 0x1 },
	'makernoteunknown' => { 82 => 'MakN', 83 => 0x927c },
	'makernoteunknowntext' => { 82 => 'MakN', 83 => 0x927c },
	'makernoteversion' => { 133 => 0x0, 158 => 0x1, 203 => 0x0, 218 => 0x8000, 259 => 0x0, 260 => 0x1, 262 => 0x1d, 265 => 0x2000 },
	'managedfrom' => { 303 => 'ManagedFrom' },
	'managedfromalternatepaths' => { 303 => [\'ManagedFrom','ManagedFromAlternatePaths'] },
	'managedfromdocumentid' => { 303 => [\'ManagedFrom','ManagedFromDocumentID'] },
	'managedfromfilepath' => { 303 => [\'ManagedFrom','ManagedFromFilePath'] },
	'managedfromfrompart' => { 303 => [\'ManagedFrom','ManagedFromFromPart'] },
	'managedfrominstanceid' => { 303 => [\'ManagedFrom','ManagedFromInstanceID'] },
	'managedfromlastmodifydate' => { 303 => [\'ManagedFrom','ManagedFromLastModifyDate'] },
	'managedfrommanager' => { 303 => [\'ManagedFrom','ManagedFromManager'] },
	'managedfrommanagervariant' => { 303 => [\'ManagedFrom','ManagedFromManagerVariant'] },
	'managedfrommanageto' => { 303 => [\'ManagedFrom','ManagedFromManageTo'] },
	'managedfrommanageui' => { 303 => [\'ManagedFrom','ManagedFromManageUI'] },
	'managedfrommaskmarkers' => { 303 => [\'ManagedFrom','ManagedFromMaskMarkers'] },
	'managedfromoriginaldocumentid' => { 303 => [\'ManagedFrom','ManagedFromOriginalDocumentID'] },
	'managedfrompartmapping' => { 303 => [\'ManagedFrom','ManagedFromPartMapping'] },
	'managedfromrenditionclass' => { 303 => [\'ManagedFrom','ManagedFromRenditionClass'] },
	'managedfromrenditionparams' => { 303 => [\'ManagedFrom','ManagedFromRenditionParams'] },
	'managedfromtopart' => { 303 => [\'ManagedFrom','ManagedFromToPart'] },
	'managedfromversionid' => { 303 => [\'ManagedFrom','ManagedFromVersionID'] },
	'manager' => { 303 => 'Manager' },
	'managervariant' => { 303 => 'ManagerVariant' },
	'manageto' => { 303 => 'ManageTo' },
	'manageui' => { 303 => 'ManageUI' },
	'manifest' => { 303 => 'Manifest' },
	'manifestlinkform' => { 303 => [\'Manifest','ManifestLinkForm'] },
	'manifestplacedresolutionunit' => { 303 => [\'Manifest','ManifestPlacedResolutionUnit'] },
	'manifestplacedxresolution' => { 303 => [\'Manifest','ManifestPlacedXResolution'] },
	'manifestplacedyresolution' => { 303 => [\'Manifest','ManifestPlacedYResolution'] },
	'manifestreference' => { 303 => [\'Manifest','ManifestReference'] },
	'manifestreferencealternatepaths' => { 303 => [\'Manifest','ManifestReferenceAlternatePaths'] },
	'manifestreferencedocumentid' => { 303 => [\'Manifest','ManifestReferenceDocumentID'] },
	'manifestreferencefilepath' => { 303 => [\'Manifest','ManifestReferenceFilePath'] },
	'manifestreferencefrompart' => { 303 => [\'Manifest','ManifestReferenceFromPart'] },
	'manifestreferenceinstanceid' => { 303 => [\'Manifest','ManifestReferenceInstanceID'] },
	'manifestreferencelastmodifydate' => { 303 => [\'Manifest','ManifestReferenceLastModifyDate'] },
	'manifestreferencemanager' => { 303 => [\'Manifest','ManifestReferenceManager'] },
	'manifestreferencemanagervariant' => { 303 => [\'Manifest','ManifestReferenceManagerVariant'] },
	'manifestreferencemanageto' => { 303 => [\'Manifest','ManifestReferenceManageTo'] },
	'manifestreferencemanageui' => { 303 => [\'Manifest','ManifestReferenceManageUI'] },
	'manifestreferencemaskmarkers' => { 303 => [\'Manifest','ManifestReferenceMaskMarkers'] },
	'manifestreferenceoriginaldocumentid' => { 303 => [\'Manifest','ManifestReferenceOriginalDocumentID'] },
	'manifestreferencepartmapping' => { 303 => [\'Manifest','ManifestReferencePartMapping'] },
	'manifestreferencerenditionclass' => { 303 => [\'Manifest','ManifestReferenceRenditionClass'] },
	'manifestreferencerenditionparams' => { 303 => [\'Manifest','ManifestReferenceRenditionParams'] },
	'manifestreferencetopart' => { 303 => [\'Manifest','ManifestReferenceToPart'] },
	'manifestreferenceversionid' => { 303 => [\'Manifest','ManifestReferenceVersionID'] },
	'manometerpressure' => { 198 => 0x900 },
	'manometerreading' => { 198 => 0x901 },
	'manualafpointselectpattern' => { 59 => 0x513 },
	'manualexposuretime' => { 132 => 0x6 },
	'manualflash' => { 201 => 0x1209 },
	'manualflashoutput' => { 24 => 0x29, 194 => '8.2', 195 => '22.2', 196 => '8.2', 197 => '24.2' },
	'manualflashstrength' => { 198 => 0x406 },
	'manualfnumber' => { 132 => 0x7 },
	'manualfocusdistance' => { 158 => 0x85, 203 => 0x100c, 261 => 0x223 },
	'manualtv' => { 58 => 0x5, 59 => 0x705 },
	'manufacturedate' => { 225 => 0x1 },
	'manufacturedate1' => { 258 => 0x4 },
	'manufacturedate2' => { 258 => 0x5 },
	'marked' => { 290 => 'Marked', 306 => 'Marked' },
	'markers' => { 302 => 'markers' },
	'markerscomment' => { 302 => [\'markers','markersComment'] },
	'markerscuepointparams' => { 302 => [\'markers','markersCuePointParams'] },
	'markerscuepointparamskey' => { 302 => [\'markers','markersCuePointParamsKey'] },
	'markerscuepointparamsvalue' => { 302 => [\'markers','markersCuePointParamsValue'] },
	'markerscuepointtype' => { 302 => [\'markers','markersCuePointType'] },
	'markersduration' => { 302 => [\'markers','markersDuration'] },
	'markerslocation' => { 302 => [\'markers','markersLocation'] },
	'markersname' => { 302 => [\'markers','markersName'] },
	'markersprobability' => { 302 => [\'markers','markersProbability'] },
	'markersspeaker' => { 302 => [\'markers','markersSpeaker'] },
	'markersstarttime' => { 302 => [\'markers','markersStartTime'] },
	'markerstarget' => { 302 => [\'markers','markersTarget'] },
	'markerstype' => { 302 => [\'markers','markersType'] },
	'maskedareas' => { 83 => 0xc68e },
	'masterdocumentid' => { 90 => 0xb9 },
	'mastergain' => { 163 => 0x50 },
	'maxaperture' => { 24 => 0x1a, 101 => 0x6103, 118 => 'MaxAperture', 129 => 0x17, 235 => '14.1' },
	'maxapertureatcurrentfocal' => { 199 => 0x20a },
	'maxapertureatmaxfocal' => { 87 => 0x1407, 118 => 'MaxApertureAtMaxFocal', 155 => 0xb, 156 => 0x10, 157 => 0x11, 199 => 0x206 },
	'maxapertureatminfocal' => { 87 => 0x1406, 155 => 0xa, 156 => 0xf, 157 => 0x10, 199 => 0x205 },
	'maxaperturevalue' => { 83 => 0x9205, 284 => 'MaxApertureValue' },
	'maxavailheight' => { 286 => 'MaxAvailHeight' },
	'maxavailwidth' => { 286 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 193 => 0xb },
	'maxfaces' => { 202 => 0x1202 },
	'maxfocallength' => { 87 => 0x1405, 118 => 'MaxFocalLength', 155 => 0x9, 156 => 0xe, 157 => 0xf, 199 => 0x208 },
	'maximumdensityrange' => { 92 => 0x8c },
	'maxpagesize' => { 307 => 'MaxPageSize' },
	'maxpagesizeh' => { 307 => [\'MaxPageSize','MaxPageSizeH'] },
	'maxpagesizeunit' => { 307 => [\'MaxPageSize','MaxPageSizeUnit'] },
	'maxpagesizew' => { 307 => [\'MaxPageSize','MaxPageSizeW'] },
	'maxsamplevalue' => { 83 => 0x119 },
	'maxstorage' => { 297 => 'maxstorage' },
	'mb-d10batteries' => { 193 => '12.6' },
	'mb-d80batteries' => { 196 => '6.5' },
	'mb-d80batterytype' => { 197 => '3.2' },
	'mcuversion' => { 155 => 0xc, 156 => 0x11, 157 => 0x12 },
	'md5digest' => { 119 => 'zmd5' },
	'measuredev' => { 19 => 0x9, 54 => 0x3, 72 => 0x1814, 111 => 'MeasuredEV' },
	'measuredev2' => { 9 => 0x8, 19 => 0x8, 54 => 0x17 },
	'measuredev3' => { 9 => 0x9 },
	'measuredlv' => { 213 => 0x312, 219 => 0x3407 },
	'measuredrggb' => { 44 => 0x1 },
	'measuredrggbdata' => { 30 => 0x287 },
	'mediaconstraints' => { 292 => 'MediaConstraints' },
	'mediasummarycode' => { 292 => 'MediaSummaryCode' },
	'menubuttondisplayposition' => { 57 => 0xb, 60 => 0xa, 61 => 0xb, 64 => 0xb },
	'menubuttonreturn' => { 65 => 0xb },
	'menumonitorofftime' => { 197 => '22.1' },
	'metadatadate' => { 300 => 'MetadataDate' },
	'metadatamoddate' => { 302 => 'metadataModDate' },
	'metering' => { 194 => '6.1' },
	'meteringmode' => { 24 => 0x11, 83 => 0x9207, 97 => 0x1c, 129 => 0x7, 130 => 0x25, 132 => 0x12, 198 => 0x202, 241 => 0x17, 262 => 0x9, 263 => 0x15, 264 => 0x13, 284 => 'MeteringMode' },
	'meteringmode2' => { 226 => '2.1' },
	'meteringmode3' => { 226 => '16.1' },
	'meteringoffscaleindicator' => { 132 => 0x53 },
	'meteringtime' => { 193 => '22.2', 194 => '3.2', 195 => '17.1', 196 => '3.2', 197 => '19.1' },
	'mieversion' => { 119 => '0Vers' },
	'minaperture' => { 24 => 0x1b, 118 => 'MinAperture', 235 => '0.2' },
	'minfocallength' => { 87 => 0x1404, 118 => 'MinFocalLength', 155 => 0x8, 156 => 0xd, 157 => 0xe, 199 => 0x207 },
	'minoltadate' => { 129 => 0x15 },
	'minoltaimagesize' => { 129 => 0x4, 130 => 0xc, 131 => 0x2, 133 => 0x103 },
	'minoltamodelid' => { 129 => 0x25 },
	'minoltaquality' => { 129 => 0x5, 130 => 0xd, 131 => 0x3, 133 => [0x102,0x103] },
	'minoltatime' => { 129 => 0x16 },
	'minormodelagedisclosure' => { 292 => 'MinorModelAgeDisclosure' },
	'minsamplevalue' => { 83 => 0x118 },
	'mirrorlockup' => { 57 => 0xc, 58 => 0xc, 59 => 0x60f, 60 => 0xb, 61 => 0xc, 62 => 0x6, 63 => 0x6, 64 => 0xc, 65 => 0x3 },
	'mobilecountrycode' => { 279 => 'mcc' },
	'mobilenetworkcode' => { 279 => 'mnc' },
	'moddate' => { 209 => 'modify-date', 290 => 'ModDate' },
	'model' => { 73 => 0x6, 83 => 0x110, 111 => 'Model', 209 => 'Model', 220 => 0x110, 298 => 'Model' },
	'modelage' => { 286 => 'ModelAge' },
	'modelingflash' => { 193 => '21.4', 196 => '7.4', 197 => '31.3' },
	'modelreleaseid' => { 292 => 'ModelReleaseID' },
	'modelreleasestatus' => { 292 => 'ModelReleaseStatus' },
	'modificationdate' => { 293 => 'modificationDate' },
	'modifiedcolortemp' => { 45 => 0x9 },
	'modifieddigitalgain' => { 45 => 0xb },
	'modifiedparamflag' => { 39 => 0x1 },
	'modifiedpicturestyle' => { 45 => 0xa },
	'modifiedsaturation' => { 198 => 0x504 },
	'modifiedsensorbluelevel' => { 45 => 0x5 },
	'modifiedsensorredlevel' => { 45 => 0x4 },
	'modifiedsharpness' => { 45 => 0x2 },
	'modifiedsharpnessfreq' => { 45 => 0x3 },
	'modifiedtonecurve' => { 45 => 0x1 },
	'modifiedwhitebalance' => { 45 => 0x8 },
	'modifiedwhitebalanceblue' => { 45 => 0x7 },
	'modifiedwhitebalancered' => { 45 => 0x6 },
	'modifydate' => { 83 => 0x132, 112 => 'ModifyDate', 207 => 'ModDate', 208 => 'tIME', 252 => 'ModDate', 300 => 'ModifyDate' },
	'moirefilter' => { 83 => 0xfe58, 280 => 'MoireFilter' },
	'monitordisplayoff' => { 132 => 0x4c },
	'monitorofftime' => { 193 => '18.2', 194 => '3.1', 196 => '3.1' },
	'monochromecontrast' => { 78 => 0x3c },
	'monochromefiltereffect' => { 78 => 0x3a, 241 => 0x73 },
	'monochromelinear' => { 78 => 0x3d },
	'monochromeoutputhighlightpoint' => { 78 => 0x41 },
	'monochromeoutputshadowpoint' => { 78 => 0x42 },
	'monochromerawhighlight' => { 78 => 0x7a },
	'monochromerawhighlightpoint' => { 78 => 0x3f },
	'monochromerawshadow' => { 78 => 0x83 },
	'monochromerawshadowpoint' => { 78 => 0x40 },
	'monochromesharpness' => { 78 => 0x3e },
	'monochrometoning' => { 241 => 0x74 },
	'monochrometoningeffect' => { 78 => 0x3b },
	'monthdaycreated' => { 97 => 0x12, 106 => 0xe },
	'moonphase' => { 253 => 0x12 },
	'morepermissions' => { 278 => 'morePermissions' },
	'multiburstimageheight' => { 268 => 0x1002 },
	'multiburstimagewidth' => { 268 => 0x1001 },
	'multiburstmode' => { 268 => 0x1000 },
	'multicontrollerwhilemetering' => { 59 => 0x517 },
	'multiexposureautogain' => { 159 => 0x3 },
	'multiexposuremode' => { 159 => 0x1 },
	'multiexposureshots' => { 159 => 0x2 },
	'multiframenoisereduction' => { 268 => 0x200b },
	'multipleexposuremode' => { 202 => 0x101c },
	'multipleexposureset' => { 226 => '10.1' },
	'multisample' => { 163 => 0x40 },
	'multiselector' => { 193 => '9.4' },
	'multiselectorliveview' => { 193 => '4.3' },
	'multiselectorplaybackmode' => { 193 => ['13.5','9.2'] },
	'multiselectorshootmode' => { 193 => '9.1' },
	'mycolormode' => { 47 => 0x2 },
	'nativedigest' => { 284 => 'NativeDigest', 298 => 'NativeDigest' },
	'ncdfileinfo' => { 95 => 0x414 },
	'ndfilter' => { 54 => 0x1c },
	'nefbitdepth' => { 158 => 0xe22 },
	'nefcompression' => { 158 => 0x93 },
	'neutraloutputhighlightpoint' => { 78 => 0x2f },
	'neutraloutputshadowpoint' => { 78 => 0x30 },
	'neutralrawcolortone' => { 78 => 0x28 },
	'neutralrawcontrast' => { 78 => 0x2a },
	'neutralrawhighlight' => { 78 => 0x78 },
	'neutralrawhighlightpoint' => { 78 => 0x2d },
	'neutralrawlinear' => { 78 => 0x2b },
	'neutralrawsaturation' => { 78 => 0x29 },
	'neutralrawshadow' => { 78 => 0x81 },
	'neutralrawshadowpoint' => { 78 => 0x2e },
	'neutralrawsharpness' => { 78 => 0x2c },
	'newsphotoversion' => { 92 => 0x0 },
	'nickname' => { 300 => 'Nickname' },
	'nikoncapturedata' => { 158 => 0xe01 },
	'nikoncapturehistory' => { 158 => 0xe13 },
	'nikoncaptureoutput' => { 158 => 0xe1e },
	'nikoncaptureversion' => { 158 => 0xe09 },
	'nikoniccprofile' => { 158 => 0xe1d },
	'nikonimagesize' => { 170 => '723.1', 171 => '732.1', 174 => 0x2c4 },
	'noisefilter' => { 198 => 0x527 },
	'noisereduction' => { 87 => 0x100b, 130 => 0xb0, 131 => 0x60, 132 => 0x3f, 158 => 0x95, 186 => 0x753dcbc0, 187 => 0x17, 198 => 0x50a, 203 => 0x103a, 218 => 0x2d, 241 => 0x49, 258 => 0x2a },
	'noisereduction2' => { 202 => 0x1010 },
	'noisereductionapplied' => { 83 => 0xc6f7 },
	'noisereductionintensity' => { 187 => 0x9 },
	'noisereductionmethod' => { 187 => 0x11 },
	'noisereductionmode' => { 271 => 0x801e },
	'noisereductionsharpness' => { 187 => 0xd },
	'noisereductionvalue' => { 271 => 0x8027 },
	'nomemorycard' => { 193 => '22.1', 194 => '0.3', 195 => '2.4', 196 => '0.3', 197 => '4.5' },
	'nominalmaxaperture' => { 235 => 0xa },
	'nominalminaperture' => { 235 => '10.1' },
	'notes' => { 272 => 'Notes', 276 => 'notes' },
	'npages' => { 307 => 'NPages' },
	'nrwdata' => { 158 => 0x14 },
	'nullrecord' => { 72 => 0x0 },
	'number' => { 293 => 'number' },
	'numberofbeats' => { 302 => 'numberOfBeats' },
	'numfacepositions' => { 211 => 0x0 },
	'numindexentries' => { 92 => 0x54 },
	'object' => { 293 => 'object' },
	'objectattributereference' => { 90 => 0x4 },
	'objectcycle' => { 90 => 0x4b },
	'objectdistance' => { 79 => 0x6, 80 => 0x2022 },
	'objectname' => { 90 => 0x5 },
	'objectpreviewdata' => { 90 => 0xca },
	'objectpreviewfileformat' => { 90 => 0xc8 },
	'objectpreviewfileversion' => { 90 => 0xc9 },
	'objecttypereference' => { 90 => 0x3 },
	'oecfcolumns' => { 284 => [\'OECF','OECFColumns'] },
	'oecfnames' => { 284 => [\'OECF','OECFNames'] },
	'oecfrows' => { 284 => [\'OECF','OECFRows'] },
	'oecfvalues' => { 284 => [\'OECF','OECFValues'] },
	'offsetschema' => { 83 => 0xea1d },
	'okbutton' => { 197 => '16.1' },
	'oldsubfiletype' => { 83 => 0xff },
	'olympusimageheight' => { 203 => 0x102f },
	'olympusimagewidth' => { 203 => 0x102e },
	'onetouchwb' => { 203 => 0x302 },
	'opticalzoom' => { 99 => 0xfa3d, 101 => [0x6006,0xf006], 102 => 0x1000, 103 => 0xf, 106 => 0x1e, 118 => 'OpticalZoom' },
	'opticalzoomcode' => { 54 => 0xa },
	'opticalzoommode' => { 218 => 0x34 },
	'opticalzoomon' => { 261 => 0x219 },
	'optionenddate' => { 295 => 'optionEndDate' },
	'opto-electricconvfactor' => { 284 => 'OECF' },
	'ordernumber' => { 87 => 0x8002 },
	'organisationinimagecode' => { 286 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 286 => 'OrganisationInImageName' },
	'organization' => { 293 => 'organization' },
	'orientation' => { 83 => 0x112, 220 => 0x112, 298 => 'Orientation' },
	'orientationlinkedafpoint' => { 59 => 0x516 },
	'originaldecisiondata' => { 81 => 'OriginalDecisionData' },
	'originaldecisiondataoffset' => { 43 => 0x83 },
	'originaldirectory' => { 215 => 0x408 },
	'originaldocumentid' => { 303 => 'OriginalDocumentID' },
	'originalfilename' => { 72 => 0x816, 95 => 0x3e9, 107 => 0x20, 215 => 0x407 },
	'originalimageheight' => { 55 => 0xc, 86 => 0x1 },
	'originalimagewidth' => { 55 => 0xb, 86 => 0x0 },
	'originalrawfiledata' => { 83 => 0xc68c },
	'originalrawfiledigest' => { 83 => 0xc71d },
	'originalrawfilename' => { 83 => 0xc68b },
	'originaltransmissionreference' => { 90 => 0x67 },
	'originatingprogram' => { 90 => 0x41 },
	'originplatform' => { 293 => 'originPlatform' },
	'os' => { 282 => 'os' },
	'otherconditions' => { 292 => 'OtherConditions' },
	'otherconstraints' => { 292 => 'OtherConstraints' },
	'otherimageinfo' => { 292 => 'OtherImageInfo' },
	'otherlicensedocuments' => { 292 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 292 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 292 => 'OtherLicenseRequirements' },
	'outcue' => { 302 => 'outCue' },
	'outcuescale' => { 302 => [\'outCue','outCueScale'] },
	'outcuevalue' => { 302 => [\'outCue','outCueValue'] },
	'outputimageheight' => { 141 => 0x3 },
	'outputimagewidth' => { 141 => 0x2 },
	'outputresolution' => { 141 => 0x4 },
	'owner' => { 306 => 'Owner' },
	'ownerid' => { 90 => 0xbc },
	'ownername' => { 11 => 0x10f, 43 => 0x9, 72 => 0x810, 83 => [0xa430,0xfde8], 111 => 'OwnerName', 277 => 'OwnerName' },
	'padding' => { 83 => 0xea1c },
	'pageimage' => { 300 => [\'PageInfo','PageInfoImage'] },
	'pageimageformat' => { 300 => [\'PageInfo','PageInfoFormat'] },
	'pageimageheight' => { 300 => [\'PageInfo','PageInfoHeight'] },
	'pageimagepagenumber' => { 300 => [\'PageInfo','PageInfoPageNumber'] },
	'pageimagewidth' => { 300 => [\'PageInfo','PageInfoWidth'] },
	'pageinfo' => { 300 => 'PageInfo' },
	'pagename' => { 83 => 0x11d },
	'pagenumber' => { 83 => 0x129 },
	'pagerange' => { 293 => 'pageRange' },
	'paintbasedcorrectionmasks' => { 280 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'] },
	'paintbasedcorrections' => { 280 => 'PaintBasedCorrections' },
	'paintcorrectionactive' => { 280 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'] },
	'paintcorrectionamount' => { 280 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'] },
	'paintcorrectionbrightness' => { 280 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'] },
	'paintcorrectionclarity' => { 280 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'] },
	'paintcorrectioncontrast' => { 280 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'] },
	'paintcorrectionexposure' => { 280 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'] },
	'paintcorrectionhue' => { 280 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'] },
	'paintcorrectionmaskcenterweight' => { 280 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'] },
	'paintcorrectionmaskdabs' => { 280 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'] },
	'paintcorrectionmaskflow' => { 280 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'] },
	'paintcorrectionmaskfullx' => { 280 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'] },
	'paintcorrectionmaskfully' => { 280 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'] },
	'paintcorrectionmaskradius' => { 280 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'] },
	'paintcorrectionmaskvalue' => { 280 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'] },
	'paintcorrectionmaskwhat' => { 280 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'] },
	'paintcorrectionmaskzerox' => { 280 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'] },
	'paintcorrectionmaskzeroy' => { 280 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'] },
	'paintcorrectionsaturation' => { 280 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation','PaintBasedCorrectionsLocalToningSaturation'] },
	'paintcorrectionsharpness' => { 280 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'] },
	'paintcorrectionwhat' => { 280 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'] },
	'panasonicexifversion' => { 218 => 0x26 },
	'panasonicimageheight' => { 218 => 0x4c },
	'panasonicimagewidth' => { 218 => 0x4b },
	'panasonicrawversion' => { 220 => 0x1 },
	'panasonictitle' => { 83 => 0xc6d2 },
	'panasonictitle2' => { 83 => 0xc6d3 },
	'panoramacropbottom' => { 269 => 0x7 },
	'panoramacropleft' => { 269 => 0x4 },
	'panoramacropright' => { 269 => 0x6 },
	'panoramacroptop' => { 269 => 0x5 },
	'panoramadirection' => { 50 => 0x5, 269 => 0x3 },
	'panoramaframeheight' => { 269 => 0x9 },
	'panoramaframenumber' => { 50 => 0x2 },
	'panoramaframewidth' => { 269 => 0x8 },
	'panoramafullheight' => { 269 => 0x2 },
	'panoramafullwidth' => { 269 => 0x1 },
	'panoramamode' => { 97 => 0x3c, 198 => 0x601 },
	'panoramasourceheight' => { 269 => 0xb },
	'panoramasourcewidth' => { 269 => 0xa },
	'panoramicstitchcameramotion' => { 126 => 'PanoramicStitchCameraMotion', 127 => 0x1 },
	'panoramicstitchmaptype' => { 126 => 'PanoramicStitchMapType', 127 => 0x2 },
	'panoramicstitchphi0' => { 126 => 'PanoramicStitchPhi0', 127 => 0x5 },
	'panoramicstitchphi1' => { 126 => 'PanoramicStitchPhi1', 127 => 0x6 },
	'panoramicstitchtheta0' => { 126 => 'PanoramicStitchTheta0', 127 => 0x3 },
	'panoramicstitchtheta1' => { 126 => 'PanoramicStitchTheta1', 127 => 0x4 },
	'panoramicstitchversion' => { 127 => 0x0 },
	'pantry' => { 303 => 'Pantry' },
	'parallax' => { 87 => 0xb211 },
	'parametricdarks' => { 280 => 'ParametricDarks' },
	'parametrichighlights' => { 280 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 280 => 'ParametricHighlightSplit' },
	'parametriclights' => { 280 => 'ParametricLights' },
	'parametricmidtonesplit' => { 280 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 280 => 'ParametricShadows' },
	'parametricshadowsplit' => { 280 => 'ParametricShadowSplit' },
	'patientbirthdate' => { 273 => 'PatientDOB' },
	'patientid' => { 273 => 'PatientID' },
	'patientname' => { 273 => 'PatientName' },
	'patientsex' => { 273 => 'PatientSex' },
	'pdfversion' => { 290 => 'PDFVersion' },
	'pentaximagesize' => { 241 => 0x9 },
	'pentaxmodelid' => { 225 => 0x0, 241 => 0x5 },
	'pentaxmodeltype' => { 241 => 0x1 },
	'pentaxversion' => { 241 => 0x0 },
	'people' => { 275 => 'People' },
	'peripheralillumcentralradius' => { 271 => 0x8030 },
	'peripheralillumcentralvalue' => { 271 => 0x8031 },
	'peripheralillumination' => { 78 => 0x68 },
	'peripheralilluminationon' => { 78 => 0x64 },
	'peripheralillumperiphvalue' => { 271 => 0x8032 },
	'peripherallighting' => { 55 => 0x2 },
	'peripherallightingsetting' => { 56 => 0x5 },
	'peripherallightingvalue' => { 55 => 0x6 },
	'permissions' => { 295 => 'permissions' },
	'person' => { 293 => 'person' },
	'personinimage' => { 286 => 'PersonInImage' },
	'pf0customfuncregistration' => { 67 => 0x1 },
	'pf10retainprogramshift' => { 67 => 0xb },
	'pf13drivepriority' => { 67 => 0xe },
	'pf14disablefocussearch' => { 67 => 0xf },
	'pf15disableafassistbeam' => { 67 => 0x10 },
	'pf16autofocuspointshoot' => { 67 => 0x11 },
	'pf17disableafpointsel' => { 67 => 0x12 },
	'pf18enableautoafpointsel' => { 67 => 0x13 },
	'pf19continuousshootspeed' => { 67 => 0x14 },
	'pf19shootingspeedhigh' => { 66 => 0xa },
	'pf19shootingspeedlow' => { 66 => 0x9 },
	'pf1disableshootingmodes' => { 67 => 0x2 },
	'pf1value' => { 66 => 0x1 },
	'pf20limitcontinousshots' => { 67 => 0x15 },
	'pf20maxcontinousshots' => { 66 => 0xb },
	'pf21enablequietoperation' => { 67 => 0x16 },
	'pf23felocktime' => { 66 => 0xd },
	'pf23postreleasetime' => { 66 => 0xe },
	'pf23settimerlengths' => { 67 => 0x18 },
	'pf23shutterbuttontime' => { 66 => 0xc },
	'pf24lightlcdduringbulb' => { 67 => 0x19 },
	'pf25aemode' => { 66 => 0xf },
	'pf25afmode' => { 66 => 0x12 },
	'pf25afpointsel' => { 66 => 0x13 },
	'pf25colormatrix' => { 66 => 0x17 },
	'pf25defaultclearsettings' => { 67 => 0x1a },
	'pf25drivemode' => { 66 => 0x11 },
	'pf25imagesize' => { 66 => 0x14 },
	'pf25meteringmode' => { 66 => 0x10 },
	'pf25parameters' => { 66 => 0x16 },
	'pf25wbmode' => { 66 => 0x15 },
	'pf26shortenreleaselag' => { 67 => 0x1b },
	'pf27reversedialrotation' => { 67 => 0x1c },
	'pf27value' => { 66 => 0x18 },
	'pf28noquickdialexpcomp' => { 67 => 0x1d },
	'pf29quickdialswitchoff' => { 67 => 0x1e },
	'pf2disablemeteringmodes' => { 67 => 0x3 },
	'pf2value' => { 66 => 0x2 },
	'pf30enlargementmode' => { 67 => 0x1f },
	'pf31originaldecisiondata' => { 67 => 0x20 },
	'pf3manualexposuremetering' => { 67 => 0x4 },
	'pf3value' => { 66 => 0x3 },
	'pf4exposuretimelimits' => { 67 => 0x5 },
	'pf4exposuretimemax' => { 66 => 0x5 },
	'pf4exposuretimemin' => { 66 => 0x4 },
	'pf5aperturelimits' => { 67 => 0x6 },
	'pf5aperturemax' => { 66 => 0x7 },
	'pf5aperturemin' => { 66 => 0x6 },
	'pf6presetshootingmodes' => { 67 => 0x7 },
	'pf7bracketcontinuousshoot' => { 67 => 0x8 },
	'pf8bracketshots' => { 66 => 0x8 },
	'pf8setbracketshots' => { 67 => 0x9 },
	'pf9changebracketsequence' => { 67 => 0xa },
	'phasedetectaf' => { 139 => 0x6 },
	'phonenumber' => { 112 => 'Phone' },
	'photoeffect' => { 24 => 0x28 },
	'photoeffects' => { 186 => 0xab5eca5e },
	'photoeffectsblue' => { 188 => 0x8 },
	'photoeffectsgreen' => { 188 => 0x6 },
	'photoeffectsred' => { 188 => 0x4 },
	'photoeffectstype' => { 188 => 0x0 },
	'photoinfoplayback' => { 193 => '17.6' },
	'photometricinterpretation' => { 83 => 0x106, 298 => 'PhotometricInterpretation' },
	'photoshopquality' => { 249 => 0x0 },
	'pictinfo' => { 261 => 0x208 },
	'picturecontrol' => { 186 => 0xe2173c47 },
	'picturecontrolactive' => { 189 => 0x0 },
	'picturecontroladjust' => { 160 => 0x30 },
	'picturecontrolbase' => { 160 => 0x18 },
	'picturecontroldata' => { 158 => [0xbd,0x23] },
	'picturecontrolmode' => { 189 => 0x13 },
	'picturecontrolname' => { 160 => 0x4 },
	'picturecontrolquickadjust' => { 160 => 0x31 },
	'picturefinish' => { 130 => 0x71 },
	'picturemode' => { 87 => 0x1031, 198 => 0x520, 241 => [0xb,0x33], 262 => 0x3d },
	'picturemode2' => { 226 => 0x0 },
	'picturemodebwfilter' => { 198 => 0x525 },
	'picturemodecontrast' => { 198 => 0x523 },
	'picturemodehue' => { 198 => 0x522 },
	'picturemodesaturation' => { 198 => 0x521 },
	'picturemodesharpness' => { 198 => 0x524 },
	'picturemodetone' => { 198 => 0x526 },
	'picturestyle' => { 5 => [0x4b,0x51], 6 => 0x6c, 7 => 0x86, 8 => 0x73, 12 => 0xab, 13 => 0xa7, 14 => 0xb0, 15 => 0x6c, 16 => 0xa7, 52 => 0xa, 78 => 0x2 },
	'picturewizard' => { 260 => 0x21 },
	'pitchangle' => { 240 => 0x2 },
	'planarconfiguration' => { 83 => 0x11c, 298 => 'PlanarConfiguration' },
	'platenames' => { 307 => 'PlateNames' },
	'playbackmenustime' => { 195 => '20.1' },
	'playbackmonitorofftime' => { 197 => '21.1' },
	'playdisplay' => { 132 => 0x4e },
	'plusversion' => { 292 => 'Version' },
	'pngwarning' => { 209 => 'Warning' },
	'portraitoutputhighlightpoint' => { 78 => 0x1d },
	'portraitoutputshadowpoint' => { 78 => 0x1e },
	'portraitrawcolortone' => { 78 => 0x16 },
	'portraitrawcontrast' => { 78 => 0x18 },
	'portraitrawhighlight' => { 78 => 0x76 },
	'portraitrawhighlightpoint' => { 78 => 0x1b },
	'portraitrawlinear' => { 78 => 0x19 },
	'portraitrawsaturation' => { 78 => 0x17 },
	'portraitrawshadow' => { 78 => 0x7f },
	'portraitrawshadowpoint' => { 78 => 0x1c },
	'portraitrawsharpness' => { 78 => 0x1a },
	'portraitrefiner' => { 80 => 0x302b },
	'postalcode' => { 116 => 'PostalCode' },
	'postcropvignetteamount' => { 280 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 280 => 'PostCropVignetteFeather' },
	'postcropvignettemidpoint' => { 280 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 280 => 'PostCropVignetteRoundness' },
	'powersource' => { 224 => '0.1' },
	'poweruptime' => { 158 => 0xb6 },
	'precaptureframes' => { 203 => 0x300 },
	'predictor' => { 83 => 0x13d },
	'preflashreturnstrength' => { 171 => 0x28a },
	'prefs' => { 90 => 0xdd, 248 => 'Prefs' },
	'preservedfilename' => { 303 => 'PreservedFileName' },
	'presetwhitebalance' => { 132 => 0x24, 271 => 0x8002 },
	'presetwhitebalanceadj' => { 271 => 0x8014 },
	'previewapplicationname' => { 83 => 0xc716 },
	'previewapplicationversion' => { 83 => 0xc717 },
	'previewbutton' => { 193 => ['14.1','15.1'] },
	'previewbuttonplusdials' => { 193 => ['14.2','15.2'] },
	'previewcolorspace' => { 83 => 0xc71a },
	'previewcropbottom' => { 247 => 0xef },
	'previewcropleft' => { 247 => 0xec },
	'previewcropright' => { 247 => 0xee },
	'previewcroptop' => { 247 => 0xed },
	'previewdatetime' => { 83 => 0xc71b },
	'previewheight' => { 99 => 0xfa58 },
	'previewimage' => { 80 => 0x2000, 81 => 'PreviewImage', 84 => 'PreviewImage', 85 => 0x4, 121 => 'data', 133 => 0x81, 203 => 0x280, 216 => 0x300, 268 => 0x2001 },
	'previewimageborders' => { 241 => 0x3e },
	'previewimageheight' => { 51 => 0x4 },
	'previewimagelength' => { 51 => 0x2, 80 => 0x3, 83 => [0x117,0x202], 133 => 0x89, 161 => 0x202, 198 => 0x102, 203 => 0x1037, 241 => 0x3, 255 => 0x1e, 259 => 0x3, 262 => 0x1b, 265 => 0x202 },
	'previewimagename' => { 121 => '1Name' },
	'previewimagesize' => { 80 => 0x2, 104 => 0x2, 121 => 'ImageSize', 241 => 0x2, 262 => 0x1c, 268 => 0xb02c },
	'previewimagestart' => { 51 => 0x5, 80 => 0x4, 83 => [0x111,0x201], 133 => 0x88, 161 => 0x201, 198 => 0x101, 203 => 0x1036, 241 => 0x4, 255 => 0x1c, 259 => 0x2, 262 => 0x1a, 265 => 0x201 },
	'previewimagetype' => { 121 => '0Type' },
	'previewimagevalid' => { 198 => 0x100, 203 => 0x1035 },
	'previewimagewidth' => { 51 => 0x3 },
	'previewquality' => { 51 => 0x1 },
	'previewsettingsdigest' => { 83 => 0xc719 },
	'previewsettingsname' => { 83 => 0xc718 },
	'previewwidth' => { 99 => 0xfa57 },
	'primaryafpoint' => { 139 => 0x7 },
	'primarychromaticities' => { 83 => 0x13f, 298 => 'PrimaryChromaticities' },
	'printim' => { 83 => 0xc4a5 },
	'prioritysetupshutterrelease' => { 132 => 0x1d, 263 => 0x28 },
	'privatertkinfo' => { 274 => 'privateRTKInfo' },
	'processingsoftware' => { 83 => 0xb },
	'producer' => { 207 => 'Producer', 290 => 'Producer' },
	'productid' => { 91 => 0x32 },
	'productioncode' => { 225 => 0x2 },
	'productorserviceconstraints' => { 292 => 'ProductOrServiceConstraints' },
	'profilecalibrationsig' => { 83 => 0xc6f4 },
	'profilecopyright' => { 83 => 0xc6fe },
	'profileembedpolicy' => { 83 => 0xc6fd },
	'profilehuesatmapdata1' => { 83 => 0xc6fa },
	'profilehuesatmapdata2' => { 83 => 0xc6fb },
	'profilehuesatmapdims' => { 83 => 0xc6f9 },
	'profilelooktabledata' => { 83 => 0xc726 },
	'profilelooktabledims' => { 83 => 0xc725 },
	'profilename' => { 83 => 0xc6f8 },
	'profiletonecurve' => { 83 => 0xc6fc },
	'programiso' => { 218 => 0x3c },
	'programline' => { 226 => '1.1' },
	'programmode' => { 136 => 0x5 },
	'programshift' => { 158 => 0xd },
	'programversion' => { 90 => 0x46 },
	'projectname' => { 302 => 'projectName' },
	'projectref' => { 302 => 'projectRef' },
	'projectrefpath' => { 302 => [\'projectRef','projectRefPath'] },
	'projectreftype' => { 302 => [\'projectRef','projectRefType'] },
	'propertyreleaseid' => { 292 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 292 => 'PropertyReleaseStatus' },
	'province-state' => { 90 => 0x5f },
	'publicationdate' => { 293 => 'publicationDate' },
	'publicationname' => { 293 => 'publicationName' },
	'publisher' => { 281 => 'publisher' },
	'pulldown' => { 302 => 'pullDown' },
	'quality' => { 0 => 0x1, 24 => 0x3, 79 => 0x2, 80 => 0x3002, 87 => 0x1000, 97 => 0x9, 158 => 0x4, 176 => 0x3, 203 => 0x201, 213 => 0x300, 241 => 0x8, 246 => 0x2, 262 => 0x16, 263 => 0x56, 268 => [0x102,0xb047] },
	'qualitymode' => { 80 => 0x8 },
	'quantizationmethod' => { 92 => 0x78 },
	'quickadjust' => { 189 => 0x2a },
	'quickcontroldialinmeter' => { 59 => 0x703 },
	'quickshot' => { 261 => 0x213 },
	'rangefinder' => { 195 => '4.1' },
	'rasterizedcaption' => { 90 => 0x7d },
	'rating' => { 83 => 0x4746, 247 => 0xdf, 276 => 'rating', 282 => 'rating', 300 => 'Rating' },
	'ratingpercent' => { 83 => 0x4749, 128 => 'Rating' },
	'rawandjpgrecording' => { 57 => 0x8, 133 => 0x109, 226 => 0xd },
	'rawbrightnessadj' => { 77 => 0x38 },
	'rawcoloradj' => { 77 => 0x2e },
	'rawcropbottom' => { 247 => 0xd4 },
	'rawcropleft' => { 247 => 0xd1 },
	'rawcropright' => { 247 => 0xd3 },
	'rawcroptop' => { 247 => 0xd2 },
	'rawcustomsaturation' => { 77 => 0x30 },
	'rawcustomtone' => { 77 => 0x34 },
	'rawdatauniqueid' => { 83 => 0xc65d },
	'rawdepth' => { 135 => 0x10 },
	'rawdevautogradation' => { 205 => 0x119 },
	'rawdevcolorspace' => { 204 => 0x108, 205 => 0x109 },
	'rawdevcontrastvalue' => { 204 => 0x106, 205 => 0x105 },
	'rawdeveditstatus' => { 204 => 0x10b },
	'rawdevengine' => { 204 => 0x109, 205 => 0x10b },
	'rawdevexposurebiasvalue' => { 204 => 0x100, 205 => 0x100 },
	'rawdevgradation' => { 205 => 0x112 },
	'rawdevgraypoint' => { 204 => 0x103, 205 => 0x104 },
	'rawdevmemorycoloremphasis' => { 204 => 0x105, 205 => 0x108 },
	'rawdevnoisereduction' => { 204 => 0x10a, 205 => 0x10a },
	'rawdevpicturemode' => { 205 => 0x10c },
	'rawdevpm_bwfilter' => { 205 => 0x110 },
	'rawdevpmcontrast' => { 205 => 0x10e },
	'rawdevpmnoisefilter' => { 205 => 0x120 },
	'rawdevpmpicturetone' => { 205 => 0x111 },
	'rawdevpmsaturation' => { 205 => 0x10d },
	'rawdevpmsharpness' => { 205 => 0x10f },
	'rawdevsaturation3' => { 205 => 0x113 },
	'rawdevsaturationemphasis' => { 204 => 0x104, 205 => 0x107 },
	'rawdevsettings' => { 204 => 0x10c },
	'rawdevsharpnessvalue' => { 204 => 0x107, 205 => 0x106 },
	'rawdevversion' => { 204 => 0x0, 205 => 0x0 },
	'rawdevwbfineadjustment' => { 204 => 0x102, 205 => 0x103 },
	'rawdevwhitebalance' => { 205 => 0x101 },
	'rawdevwhitebalancevalue' => { 204 => 0x101, 205 => 0x102 },
	'rawfile' => { 83 => 0xfe4c },
	'rawfilename' => { 280 => 'RawFileName' },
	'rawimagecenter' => { 158 => 0x99 },
	'rawimagedigest' => { 83 => 0xc71c },
	'rawimagesize' => { 241 => 0x39 },
	'rawinfoversion' => { 206 => 0x0 },
	'rawjpgheight' => { 74 => 0x4 },
	'rawjpgquality' => { 38 => 0x6, 74 => 0x1 },
	'rawjpgsize' => { 38 => 0x7, 74 => 0x2 },
	'rawjpgwidth' => { 74 => 0x3 },
	'rawmeasuredrggb' => { 29 => 0x26a, 31 => 0x280, 33 => 0x194 },
	'reardisplay' => { 193 => '12.3' },
	'recognizedface1age' => { 212 => 0x20 },
	'recognizedface1name' => { 212 => 0x4 },
	'recognizedface1position' => { 212 => 0x18 },
	'recognizedface2age' => { 212 => 0x50 },
	'recognizedface2name' => { 212 => 0x34 },
	'recognizedface2position' => { 212 => 0x48 },
	'recognizedface3age' => { 212 => 0x80 },
	'recognizedface3name' => { 212 => 0x64 },
	'recognizedface3position' => { 212 => 0x78 },
	'recognizedfaceflags' => { 218 => 0x63 },
	'recommendedexposureindex' => { 83 => 0x8832 },
	'recorddisplay' => { 132 => 0x4d },
	'recordid' => { 72 => 0x1804 },
	'recordingmode' => { 79 => 0x1, 246 => 0x1 },
	'recordmode' => { 24 => 0x9, 80 => 0x3000 },
	'recordshutterrelease' => { 261 => 0x217 },
	'redbalance' => { 146 => 0x270, 203 => 0x1017, 220 => 0x11, 241 => 0x1c },
	'redcurvelimits' => { 77 => 0x18a },
	'redcurvepoints' => { 77 => 0x160 },
	'redeyecorrection' => { 190 => 0x0 },
	'redeyeinfo' => { 280 => 'RedEyeInfo' },
	'redeyereduction' => { 132 => 0x41 },
	'redhue' => { 280 => 'RedHue' },
	'redsaturation' => { 280 => 'RedSaturation' },
	'reductionmatrix1' => { 83 => 0xc625 },
	'reductionmatrix2' => { 83 => 0xc626 },
	'referenceblackwhite' => { 83 => 0x214, 298 => 'ReferenceBlackWhite' },
	'referencedate' => { 90 => 0x2f },
	'referencenumber' => { 90 => 0x32 },
	'references' => { 112 => 'References' },
	'referenceservice' => { 90 => 0x2d },
	'regionappliedtodimensions' => { 289 => [\'Regions','RegionsAppliedToDimensions'] },
	'regionappliedtodimensionsh' => { 289 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'regionappliedtodimensionsunit' => { 289 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'regionappliedtodimensionsw' => { 289 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'regionarea' => { 289 => [\'Regions','RegionsRegionListArea'] },
	'regionaread' => { 289 => [\'Regions','RegionsRegionListAreaD'] },
	'regionareah' => { 289 => [\'Regions','RegionsRegionListAreaH'] },
	'regionareaunit' => { 289 => [\'Regions','RegionsRegionListAreaUnit'] },
	'regionareaw' => { 289 => [\'Regions','RegionsRegionListAreaW'] },
	'regionareax' => { 289 => [\'Regions','RegionsRegionListAreaX'] },
	'regionareay' => { 289 => [\'Regions','RegionsRegionListAreaY'] },
	'regionbarcodevalue' => { 289 => [\'Regions','RegionsRegionListBarCodeValue'] },
	'regionconstraints' => { 292 => 'RegionConstraints' },
	'regiondescription' => { 289 => [\'Regions','RegionsRegionListDescription'] },
	'regionextensions' => { 289 => [\'Regions','RegionsRegionListExtensions'] },
	'regionfocususage' => { 289 => [\'Regions','RegionsRegionListFocusUsage'] },
	'regioninfo' => { 289 => 'Regions' },
	'regioninfomp' => { 125 => 'RegionInfo' },
	'regioninfompregions' => { 125 => [\'RegionInfo','RegionInfoRegions'] },
	'regionlist' => { 289 => [\'Regions','RegionsRegionList'] },
	'regionname' => { 289 => [\'Regions','RegionsRegionListName'] },
	'regionpersondisplayname' => { 125 => [\'RegionInfo','RegionInfoRegionsPersonDisplayName'] },
	'regionrectangle' => { 125 => [\'RegionInfo','RegionInfoRegionsRectangle'] },
	'regionseealso' => { 289 => [\'Regions','RegionsRegionListSeeAlso'] },
	'regiontype' => { 289 => [\'Regions','RegionsRegionListType'] },
	'registryid' => { 286 => 'RegistryId' },
	'registryitemid' => { 286 => [\'RegistryId','RegistryIdRegItemId'] },
	'registryorganisationid' => { 286 => [\'RegistryId','RegistryIdRegOrgId'] },
	'relatedaudiofile' => { 110 => 'data' },
	'relatedaudiofilename' => { 110 => '1Name' },
	'relatedaudiofiletype' => { 110 => '0Type' },
	'relatedimagefileformat' => { 83 => 0x1000 },
	'relatedimageheight' => { 83 => 0x1002 },
	'relatedimagewidth' => { 83 => 0x1001 },
	'relatedsoundfile' => { 83 => 0xa004, 284 => 'RelatedSoundFile' },
	'relatedvideofile' => { 124 => 'data' },
	'relatedvideofilename' => { 124 => '1Name' },
	'relatedvideofiletype' => { 124 => '0Type' },
	'relation' => { 281 => 'relation' },
	'relativepeakaudiofilepath' => { 302 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 302 => 'relativeTimestamp' },
	'relativetimestampscale' => { 302 => [\'relativeTimestamp','relativeTimestampScale'] },
	'relativetimestampvalue' => { 302 => [\'relativeTimestamp','relativeTimestampValue'] },
	'releasebuttontousedial' => { 193 => '17.8' },
	'releasedate' => { 90 => 0x1e, 302 => 'releaseDate' },
	'releasemode' => { 80 => 0x3001, 268 => 0xb049 },
	'releasesetting' => { 72 => 0x1016 },
	'releasetime' => { 90 => 0x23 },
	'remoteonduration' => { 194 => '3.4', 195 => '17.2', 196 => '4.3', 197 => '19.2' },
	'renditionclass' => { 303 => 'RenditionClass' },
	'renditionof' => { 303 => 'RenditionOf' },
	'renditionofalternatepaths' => { 303 => [\'RenditionOf','RenditionOfAlternatePaths'] },
	'renditionofdocumentid' => { 303 => [\'RenditionOf','RenditionOfDocumentID'] },
	'renditionoffilepath' => { 303 => [\'RenditionOf','RenditionOfFilePath'] },
	'renditionoffrompart' => { 303 => [\'RenditionOf','RenditionOfFromPart'] },
	'renditionofinstanceid' => { 303 => [\'RenditionOf','RenditionOfInstanceID'] },
	'renditionoflastmodifydate' => { 303 => [\'RenditionOf','RenditionOfLastModifyDate'] },
	'renditionofmanager' => { 303 => [\'RenditionOf','RenditionOfManager'] },
	'renditionofmanagervariant' => { 303 => [\'RenditionOf','RenditionOfManagerVariant'] },
	'renditionofmanageto' => { 303 => [\'RenditionOf','RenditionOfManageTo'] },
	'renditionofmanageui' => { 303 => [\'RenditionOf','RenditionOfManageUI'] },
	'renditionofmaskmarkers' => { 303 => [\'RenditionOf','RenditionOfMaskMarkers'] },
	'renditionoforiginaldocumentid' => { 303 => [\'RenditionOf','RenditionOfOriginalDocumentID'] },
	'renditionofpartmapping' => { 303 => [\'RenditionOf','RenditionOfPartMapping'] },
	'renditionofrenditionclass' => { 303 => [\'RenditionOf','RenditionOfRenditionClass'] },
	'renditionofrenditionparams' => { 303 => [\'RenditionOf','RenditionOfRenditionParams'] },
	'renditionoftopart' => { 303 => [\'RenditionOf','RenditionOfToPart'] },
	'renditionofversionid' => { 303 => [\'RenditionOf','RenditionOfVersionID'] },
	'renditionparams' => { 303 => 'RenditionParams' },
	'repeatingflashcount' => { 150 => 0xd, 151 => 0xe, 152 => 0xe, 196 => '9.2', 197 => '25.2' },
	'repeatingflashoutput' => { 196 => '9.1', 197 => '25.1' },
	'repeatingflashrate' => { 150 => 0xc, 151 => 0xd, 152 => 0xd, 196 => '10.1', 197 => '26.1' },
	'resampleparams' => { 302 => 'resampleParams' },
	'resampleparamsquality' => { 302 => [\'resampleParams','resampleParamsQuality'] },
	'resaved' => { 261 => 0x21e },
	'resolution' => { 117 => 'Resolution' },
	'resolutionmode' => { 262 => 0x4 },
	'resolutionunit' => { 83 => 0x128, 93 => 0x2, 298 => 'ResolutionUnit' },
	'restrictions' => { 295 => 'restrictions' },
	'retouchhistory' => { 158 => 0x9e },
	'retouchinfo' => { 280 => 'RetouchInfo' },
	'reuse' => { 292 => 'Reuse' },
	'reuseallowed' => { 305 => 'ReuseAllowed' },
	'reuseprohibited' => { 295 => 'reuseProhibited' },
	'reverseindicators' => { 193 => '12.1', 195 => '4.3', 197 => '6.2' },
	'revision' => { 282 => 'revision' },
	'rgbcurvelimits' => { 77 => 0x238 },
	'rgbcurvepoints' => { 77 => 0x20e },
	'ricohdate' => { 255 => 0x6 },
	'ricohimageheight' => { 255 => 0x2 },
	'ricohimagewidth' => { 255 => 0x0 },
	'rightascension' => { 120 => 'RightAscension' },
	'rights' => { 281 => 'rights' },
	'rightsagent' => { 293 => 'rightsAgent', 295 => 'rightsAgent' },
	'rightsowner' => { 295 => 'rightsOwner' },
	'rollangle' => { 240 => 0x1 },
	'romoperationmode' => { 72 => 0x80d },
	'rotation' => { 21 => 0x17, 22 => 0x18, 71 => 0x3, 77 => 0x26e, 86 => 0x4, 120 => 'Rotation', 130 => [0x65,0x50], 131 => 0x46, 132 => 0x5a, 174 => '590.1', 186 => 0x76a43207, 218 => 0x30, 226 => '17.2', 247 => 0xd8, 263 => 0x3f, 264 => 0x3f },
	'routing' => { 252 => 'Routing' },
	'rowsperstrip' => { 83 => 0x116 },
	'rpp' => { 276 => 'rpp' },
	'safetyshift' => { 59 => 0x108 },
	'safetyshiftinavortv' => { 57 => 0x10, 58 => 0x10, 60 => 0xf, 61 => 0x10, 64 => 0x10 },
	'samplebits' => { 110 => 'SampleBits' },
	'samplerate' => { 110 => 'SampleRate' },
	'samplesperpixel' => { 83 => 0x115, 298 => 'SamplesPerPixel' },
	'samplestructure' => { 92 => 0x5a },
	'sanyoquality' => { 261 => 0x201 },
	'sanyothumbnail' => { 261 => 0x100 },
	'saturation' => { 6 => 0x6e, 8 => 0x76, 24 => 0xe, 34 => 0x1, 79 => 0xd, 80 => [0x3013,0x1f], 83 => [0xa409,0xfe55], 87 => 0x1003, 111 => 'Saturation', 129 => 0x1f, 130 => 0x32, 131 => 0x28, 132 => 0x1a, 136 => 0x1, 158 => [0x94,0xaa], 160 => 0x35, 218 => 0x40, 219 => 0x300d, 241 => 0x1f, 246 => 0xd, 255 => 0x28, 262 => 0x10, 263 => 0x1e, 264 => 0x1b, 268 => 0x2005, 280 => 'Saturation', 284 => 'Saturation' },
	'saturationadj' => { 77 => 0x116, 185 => 0x1, 189 => 0x2e, 271 => 0x8016 },
	'saturationadjustmentaqua' => { 280 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 280 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 280 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 280 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 280 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 280 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 280 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 280 => 'SaturationAdjustmentYellow' },
	'saturationfaithful' => { 15 => 0xfe, 48 => 0x68, 49 => 0x68 },
	'saturationlandscape' => { 15 => 0xfc, 48 => 0x38, 49 => 0x38 },
	'saturationmonochrome' => { 48 => 0x80, 49 => 0x80 },
	'saturationneutral' => { 15 => 0xfd, 48 => 0x50, 49 => 0x50 },
	'saturationportrait' => { 15 => 0xfb, 48 => 0x20, 49 => 0x20 },
	'saturationsetting' => { 206 => 0x1010 },
	'saturationstandard' => { 15 => 0xfa, 48 => 0x8, 49 => 0x8 },
	'saturationunknown' => { 49 => 0x98 },
	'saturationuserdef1' => { 15 => 0x100, 48 => 0x98, 49 => 0xb0 },
	'saturationuserdef2' => { 15 => 0x101, 48 => 0xb0, 49 => 0xc8 },
	'saturationuserdef3' => { 15 => 0x102, 48 => 0xc8, 49 => 0xe0 },
	'saveid' => { 303 => 'SaveID' },
	'scaletype' => { 302 => 'scaleType' },
	'scanimageenhancer' => { 163 => 0x60 },
	'scanningdirection' => { 92 => 0x64 },
	'scene' => { 285 => 'Scene', 302 => 'scene' },
	'scenearea' => { 201 => 0x211, 203 => 0x1031 },
	'sceneassist' => { 158 => 0x9c },
	'scenecapturetype' => { 83 => 0xa406, 284 => 'SceneCaptureType' },
	'scenedetect' => { 201 => 0x210, 203 => 0x1030 },
	'scenedetectdata' => { 201 => 0x212, 203 => 0x1033 },
	'scenemode' => { 99 => 0xfa02, 133 => 0x100, 158 => 0x8f, 198 => 0x509, 203 => 0x403, 218 => 0x8001, 268 => 0xb023 },
	'scenemodeused' => { 101 => [0x6002,0xf002] },
	'sceneselect' => { 261 => 0x21f },
	'scenetype' => { 83 => 0xa301, 284 => 'SceneType' },
	'screentips' => { 193 => '12.7', 197 => '5.1' },
	'section' => { 293 => 'section' },
	'securityclassification' => { 83 => 0x9212 },
	'selectableafpoint' => { 59 => 0x509 },
	'selectafareaselectmode' => { 59 => 0x512 },
	'selftimer' => { 24 => 0x2, 218 => 0x2e, 261 => 0x214 },
	'selftimer2' => { 54 => 0x1d },
	'selftimermode' => { 83 => 0x882b },
	'selftimershotcount' => { 195 => '18.2', 197 => '20.2' },
	'selftimertime' => { 72 => 0x1806, 132 => 0x1f, 193 => '18.1', 194 => '3.3', 195 => '18.1', 196 => '3.3', 197 => '20.1' },
	'seminfo' => { 83 => 0x8546 },
	'sensingmethod' => { 83 => 0xa217, 284 => 'SensingMethod' },
	'sensitivityadjust' => { 241 => 0x40 },
	'sensitivitysteps' => { 226 => ['14.3','17.4'], 228 => 0x1 },
	'sensitivitytype' => { 83 => 0x8830 },
	'sensorareas' => { 260 => 0xa010 },
	'sensorbitdepth' => { 219 => 0x312d },
	'sensorbluelevel' => { 52 => 0x5 },
	'sensorcleaning' => { 65 => 0xd },
	'sensorfullheight' => { 94 => 0xf904 },
	'sensorfullwidth' => { 94 => 0xf903 },
	'sensorheight' => { 94 => 0xf901, 99 => 0xfa21, 135 => 0x8, 219 => 0x312c },
	'sensorpixelsize' => { 158 => 0x9a },
	'sensorredlevel' => { 52 => 0x4 },
	'sensorsize' => { 111 => 'SensorSize', 241 => 0x35 },
	'sensortemperature' => { 201 => 0x1500, 203 => 0x1007, 262 => 0x39 },
	'sensorwidth' => { 94 => 0xf900, 99 => 0xfa20, 135 => 0xa, 219 => 0x312b },
	'sequence' => { 253 => 0x7 },
	'sequencenumber' => { 54 => 0x9, 80 => 0x301c, 87 => 0x1101, 97 => 0x1d, 218 => 0x2b, 268 => 0xb04a },
	'sequenceshotinterval' => { 261 => 0x224 },
	'sequentialshot' => { 261 => 0x20e },
	'serialnumber' => { 43 => 0xc, 72 => 0x180b, 83 => [0xa431,0xfde9], 94 => 0xfa04, 96 => 0xfa00, 98 => 0xc354, 99 => 0xfa19, 108 => 0x0, 109 => 0xa8, 111 => 'SerialNumber', 158 => [0xa0,0x1d], 199 => 0x101, 203 => [0x404,0x101a], 213 => 0x303, 219 => 0x3103, 241 => 0x229, 253 => 0x15, 256 => 0x5, 262 => 0x2, 277 => 'SerialNumber' },
	'serialnumberformat' => { 43 => 0x15, 72 => 0x183b },
	'seriesdatetime' => { 273 => 'SeriesDateTime' },
	'seriesdescription' => { 273 => 'SeriesDescription' },
	'seriesmodality' => { 273 => 'SeriesModality' },
	'seriesnumber' => { 273 => 'SeriesNumber' },
	'serviceidentifier' => { 91 => 0x1e },
	'setbuttoncrosskeysfunc' => { 62 => 0x0, 63 => 0x0 },
	'setbuttonwhenshooting' => { 57 => 0x1, 59 => 0x704, 65 => 0xc },
	'setfunctionwhenshooting' => { 60 => 0x0, 61 => 0x1, 64 => 0x1 },
	'shadingcompensation' => { 198 => 0x50c },
	'shadingcompensation2' => { 202 => 0x1012 },
	'shadow' => { 262 => 0xe },
	'shadowcompensation' => { 241 => 0x79 },
	'shadowprotection' => { 185 => 0x0 },
	'shadows' => { 83 => 0xfe52, 280 => 'Shadows' },
	'shadowscale' => { 83 => 0xc633 },
	'shadowtint' => { 280 => 'ShadowTint' },
	'shakereduction' => { 242 => 0x1 },
	'sharpendetail' => { 280 => 'SharpenDetail' },
	'sharpenedgemasking' => { 280 => 'SharpenEdgeMasking' },
	'sharpening' => { 219 => 0x300b },
	'sharpeningadj' => { 189 => 0x2b },
	'sharpenradius' => { 280 => 'SharpenRadius' },
	'sharpness' => { 5 => [0x42,0x48], 6 => 0x72, 8 => 0x74, 24 => 0xf, 52 => 0x2, 79 => 0xb, 80 => [0x3011,0x21], 83 => [0xa40a,0xfe56], 87 => 0x1001, 97 => 0x6b, 106 => 0x37, 111 => 'Sharpness', 129 => 0x21, 130 => 0x30, 131 => 0x26, 132 => 0x18, 136 => 0x3, 158 => 0x6, 160 => 0x32, 203 => 0x100f, 218 => 0x41, 241 => 0x21, 246 => 0xb, 255 => 0x22, 256 => 0x1003, 262 => 0x11, 263 => 0x1c, 264 => 0x19, 268 => 0x2006, 280 => 'Sharpness', 284 => 'Sharpness' },
	'sharpnessadj' => { 77 => 0x25a, 271 => 0x801a },
	'sharpnessfactor' => { 203 => 0x102a },
	'sharpnessfaithful' => { 15 => 0xf5, 48 => 0x64, 49 => 0x64 },
	'sharpnessfrequency' => { 5 => [0x41,0x47], 52 => 0x3 },
	'sharpnesslandscape' => { 15 => 0xf3, 48 => 0x34, 49 => 0x34 },
	'sharpnessmonochrome' => { 15 => 0xf6, 48 => 0x7c, 49 => 0x7c },
	'sharpnessneutral' => { 15 => 0xf4, 48 => 0x4c, 49 => 0x4c },
	'sharpnessovershoot' => { 271 => 0x801b },
	'sharpnessportrait' => { 15 => 0xf2, 48 => 0x1c, 49 => 0x1c },
	'sharpnesssetting' => { 198 => 0x506, 206 => 0x1013 },
	'sharpnessstandard' => { 15 => 0xf1, 48 => 0x4, 49 => 0x4 },
	'sharpnessthreshold' => { 271 => 0x801d },
	'sharpnessundershoot' => { 271 => 0x801c },
	'sharpnessunknown' => { 49 => 0x94 },
	'sharpnessuserdef1' => { 15 => 0xf7, 48 => 0x94, 49 => 0xac },
	'sharpnessuserdef2' => { 15 => 0xf8, 48 => 0xac, 49 => 0xc4 },
	'sharpnessuserdef3' => { 15 => 0xf9, 48 => 0xc4, 49 => 0xdc },
	'shootinginfodisplay' => { 193 => '13.2', 197 => '5.3' },
	'shootinginfomonitorofftime' => { 197 => '22.2' },
	'shootingmode' => { 111 => 'ShootingMode', 158 => 0x89, 218 => 0x1f },
	'shootingmodesetting' => { 194 => '5.1' },
	'shortdescription' => { 282 => 'shortdescription' },
	'shortdocumentid' => { 90 => 0xba },
	'shortfocal' => { 5 => 0xe, 6 => 0x11, 7 => 0x113, 8 => 0x11, 9 => [0x150,0x151], 10 => 0xd8, 12 => 0xf8, 13 => 0xec, 14 => 0x101, 15 => 0x93, 16 => 0xe8, 18 => 0xea, 20 => 0xf0, 24 => 0x18 },
	'shortownername' => { 15 => 0xac },
	'shortreleasetimelag' => { 59 => 0x80d },
	'shotdate' => { 302 => 'shotDate' },
	'shotday' => { 302 => 'shotDay' },
	'shotlocation' => { 302 => 'shotLocation' },
	'shotname' => { 302 => 'shotName' },
	'shotnumber' => { 302 => 'shotNumber' },
	'shotsize' => { 302 => 'shotSize' },
	'shutter-aelock' => { 57 => 0x4, 59 => 0x701, 60 => 0x3, 61 => 0x4, 62 => 0x3, 63 => 0x3, 64 => 0x4, 65 => 0x2 },
	'shutteraelbutton' => { 58 => 0x4 },
	'shutterbuttonafonbutton' => { 59 => 0x701 },
	'shuttercount' => { 7 => 0x176, 38 => 0x1, 158 => 0xa7, 164 => [0x6a,0x157,0x24d], 165 => 0x286, 166 => 0x279, 167 => 0x284, 168 => 0x242, 169 => 0x280, 170 => 0x276, 171 => [0x27d,0x27f], 172 => 0x246, 173 => 0x2d6, 174 => 0x24a, 175 => 0x2d5, 241 => 0x5d },
	'shuttercurtainsync' => { 57 => 0xf, 58 => 0xf, 59 => 0x305, 60 => 0xe, 61 => 0xf, 62 => 0x8, 63 => 0x8, 64 => 0xf, 65 => 0x8 },
	'shuttermode' => { 97 => 0x1b },
	'shutterreleasebuttonae-l' => { 193 => '17.7', 195 => '16.1', 197 => '18.2' },
	'shutterreleasemethod' => { 72 => 0x1010 },
	'shutterreleasenocfcard' => { 57 => 0x2, 58 => 0x2, 65 => 0xf },
	'shutterreleasetiming' => { 72 => 0x1011 },
	'shutterspeedrange' => { 59 => 0x10c },
	'shutterspeedvalue' => { 68 => 0x1, 83 => 0x9201, 203 => 0x1000, 284 => 'ShutterSpeedValue' },
	'sidecarforextension' => { 291 => 'SidecarForExtension' },
	'similarityindex' => { 90 => 0xe4 },
	'singleframebracketing' => { 132 => 0x21 },
	'slaveflashmeteringsegments' => { 241 => 0x20b },
	'slowshutter' => { 54 => 0x8 },
	'slowsync' => { 87 => 0x1030 },
	'smoothness' => { 83 => 0xfe57, 280 => 'Smoothness' },
	'software' => { 83 => 0x131, 112 => 'Software', 209 => 'Software', 262 => 0x18, 298 => 'Software' },
	'softwareversion' => { 261 => 0x207 },
	'sonydatetime' => { 270 => 0x6 },
	'sonyimagesize' => { 132 => 0x3b, 263 => 0x54, 264 => 0x54 },
	'sonymodelid' => { 268 => 0xb001 },
	'sonyquality' => { 132 => 0x3c },
	'source' => { 90 => 0x73, 209 => 'Source', 281 => 'source', 282 => 'source', 291 => 'Source' },
	'sourcedirectoryindex' => { 232 => 0x0 },
	'sourcefileindex' => { 232 => 0x2 },
	'spatialfrequencyresponse' => { 284 => 'SpatialFrequencyResponse' },
	'spatialfrequencyresponsecolumns' => { 284 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseColumns'] },
	'spatialfrequencyresponsenames' => { 284 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseNames'] },
	'spatialfrequencyresponserows' => { 284 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseRows'] },
	'spatialfrequencyresponsevalues' => { 284 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseValues'] },
	'speakerplacement' => { 302 => 'speakerPlacement' },
	'specialeffectlevel' => { 80 => 0x3030 },
	'specialeffectmode' => { 80 => 0x2076 },
	'specialeffectsetting' => { 80 => 0x3031 },
	'specialinstructions' => { 90 => 0x28 },
	'specialmode' => { 203 => 0x200, 261 => 0x200 },
	'spectralsensitivity' => { 83 => 0x8824, 284 => 'SpectralSensitivity' },
	'splittoningbalance' => { 280 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 280 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 280 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 280 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 280 => 'SplitToningShadowSaturation' },
	'spotfocuspointx' => { 129 => 0x2d },
	'spotfocuspointy' => { 129 => 0x2e },
	'spotmeteringmode' => { 24 => 0x27 },
	'spotmeterlinktoafpoint' => { 59 => 0x107 },
	'sractive' => { 226 => '17.1' },
	'srawquality' => { 24 => 0x2e },
	'srfocallength' => { 242 => 0x3 },
	'srhalfpresstime' => { 242 => 0x2 },
	'srresult' => { 242 => 0x0 },
	'standardoutputhighlightpoint' => { 78 => 0x14 },
	'standardoutputsensitivity' => { 83 => 0x8831 },
	'standardoutputshadowpoint' => { 78 => 0x15 },
	'standardrawcolortone' => { 78 => 0xd },
	'standardrawcontrast' => { 78 => 0xf },
	'standardrawhighlight' => { 78 => 0x75 },
	'standardrawhighlightpoint' => { 78 => 0x12 },
	'standardrawlinear' => { 78 => 0x10 },
	'standardrawsaturation' => { 78 => 0xe },
	'standardrawshadow' => { 78 => 0x7e },
	'standardrawshadowpoint' => { 78 => 0x13 },
	'standardrawsharpness' => { 78 => 0x11 },
	'startingpage' => { 293 => 'startingPage' },
	'startmovieshooting' => { 59 => 0x70d },
	'starttimecode' => { 302 => 'startTimecode' },
	'starttimecodetimeformat' => { 302 => [\'startTimecode','startTimecodeTimeFormat'] },
	'starttimecodetimevalue' => { 302 => [\'startTimecode','startTimecodeTimeValue'] },
	'starttimecodevalue' => { 302 => [\'startTimecode','startTimecodeValue'] },
	'state' => { 116 => 'State', 218 => 0x6b, 291 => 'State' },
	'status' => { 275 => 'Status' },
	'storagemethod' => { 135 => 0x12 },
	'straightenangle' => { 186 => 0x2fc08431 },
	'stretchmode' => { 302 => 'stretchMode' },
	'studydatetime' => { 273 => 'StudyDateTime' },
	'studydescription' => { 273 => 'StudyDescription' },
	'studyid' => { 273 => 'StudyID' },
	'studyphysician' => { 273 => 'StudyPhysician' },
	'sub-location' => { 90 => 0x5c },
	'subfiledata' => { 119 => 'data' },
	'subfiledirectory' => { 119 => '1Directory' },
	'subfilemimetype' => { 119 => '2MIME' },
	'subfilename' => { 119 => '1Name' },
	'subfileresource' => { 119 => 'rsrc' },
	'subfiletype' => { 83 => 0xfe, 119 => '0Type' },
	'subject' => { 207 => 'Subject', 252 => 'Subject', 281 => 'subject', 290 => 'Subject' },
	'subjectarea' => { 83 => 0x9214, 284 => 'SubjectArea' },
	'subjectcode' => { 285 => 'SubjectCode' },
	'subjectdistance' => { 83 => 0x9206, 97 => 0x3e, 284 => 'SubjectDistance' },
	'subjectdistancerange' => { 83 => 0xa40c, 284 => 'SubjectDistanceRange' },
	'subjectlocation' => { 83 => 0xa214, 284 => 'SubjectLocation' },
	'subjectprogram' => { 129 => 0x22 },
	'subjectreference' => { 90 => 0xc },
	'subsectime' => { 83 => 0x9290 },
	'subsectimedigitized' => { 83 => 0x9292 },
	'subsectimeoriginal' => { 83 => 0x9291 },
	'subsection1' => { 293 => 'subsection1' },
	'subsection2' => { 293 => 'subsection2' },
	'subsection3' => { 293 => 'subsection3' },
	'subsection4' => { 293 => 'subsection4' },
	'superimposeddisplay' => { 57 => 0xa, 59 => 0x510, 60 => 0x9, 61 => 0xa, 64 => 0xa, 65 => 0xe },
	'supermacro' => { 43 => 0x1a },
	'supplementalcategories' => { 90 => 0x14, 291 => 'SupplementalCategories' },
	'supplementaltype' => { 92 => 0x37 },
	'svisosetting' => { 226 => 0x14 },
	'switchtoregisteredafpoint' => { 58 => 0x12, 59 => 0x50a },
	'tagged' => { 247 => 0xdd, 276 => 'tagged' },
	'tagslist' => { 283 => 'TagsList' },
	'takenumber' => { 302 => 'takeNumber' },
	'tapename' => { 302 => 'tapeName' },
	'targetaperture' => { 54 => 0x4 },
	'targetcompressionratio' => { 70 => 0x1 },
	'targetdistancesetting' => { 72 => 0x1807 },
	'targetexposuretime' => { 54 => 0x5 },
	'targetimagetype' => { 72 => 0x100a },
	'teaser' => { 293 => 'teaser' },
	'teleconverter' => { 133 => 0x105, 268 => 0x105 },
	'tempo' => { 302 => 'tempo' },
	'termsandconditionstext' => { 292 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 292 => 'TermsAndConditionsURL' },
	'textlayername' => { 291 => [\'TextLayers','TextLayersLayerName'] },
	'textlayers' => { 291 => 'TextLayers' },
	'textlayertext' => { 291 => [\'TextLayers','TextLayersLayerText'] },
	'textstamp' => { 218 => [0x8008,0x8009,0x3b,0x3e] },
	'thresholding' => { 83 => 0x107 },
	'thumbnailfilename' => { 72 => 0x817 },
	'thumbnailformat' => { 300 => [\'Thumbnails','ThumbnailsFormat'] },
	'thumbnailheight' => { 99 => 0xfa55, 300 => [\'Thumbnails','ThumbnailsHeight'] },
	'thumbnailimage' => { 72 => 0x2008, 81 => 'ThumbnailImage', 85 => 0x3, 122 => 'data', 203 => 0x100, 300 => [\'Thumbnails','ThumbnailsImage'] },
	'thumbnailimagename' => { 122 => '1Name' },
	'thumbnailimagesize' => { 122 => 'ImageSize' },
	'thumbnailimagetype' => { 122 => '0Type' },
	'thumbnailimagevalidarea' => { 43 => 0x13 },
	'thumbnaillength' => { 83 => 0x202 },
	'thumbnailoffset' => { 83 => 0x201 },
	'thumbnails' => { 300 => 'Thumbnails' },
	'thumbnailwidth' => { 99 => 0xfa54, 300 => [\'Thumbnails','ThumbnailsWidth'] },
	'ticker' => { 293 => 'ticker' },
	'tilelength' => { 83 => 0x143 },
	'tilewidth' => { 83 => 0x142 },
	'time' => { 95 => 0x401, 241 => 0x7 },
	'timecreated' => { 90 => 0x3c, 97 => 0x14, 106 => 0x10, 248 => 'TimeCreated' },
	'timeperiod' => { 293 => 'timePeriod' },
	'timerfunctionbutton' => { 194 => '5.2', 195 => '12.1' },
	'timerlength' => { 59 => 0x80c },
	'timescaleparams' => { 302 => 'timeScaleParams' },
	'timescaleparamsframeoverlappingpercentage' => { 302 => [\'timeScaleParams','timeScaleParamsFrameOverlappingPercentage'] },
	'timescaleparamsframesize' => { 302 => [\'timeScaleParams','timeScaleParamsFrameSize'] },
	'timescaleparamsquality' => { 302 => [\'timeScaleParams','timeScaleParamsQuality'] },
	'timesent' => { 91 => 0x50 },
	'timesignature' => { 302 => 'timeSignature' },
	'timesincepoweron' => { 218 => 0x29 },
	'timestamp' => { 7 => 0x45e, 15 => 0x11c, 209 => 'TimeStamp' },
	'timestamp1' => { 7 => 0x45a },
	'timezone' => { 178 => 0x0 },
	'timezonecode' => { 75 => 0x1 },
	'timezoneinfo' => { 75 => 0x2 },
	'timezoneoffset' => { 83 => 0x882a },
	'tint' => { 280 => 'Tint' },
	'title' => { 112 => 'Title', 207 => 'Title', 209 => 'Title', 218 => 0x65, 252 => 'Title', 281 => 'title', 290 => 'Title' },
	'tonecomp' => { 158 => 0x81 },
	'tonecurve' => { 52 => 0x1, 241 => 0x402, 280 => 'ToneCurve' },
	'tonecurveactive' => { 77 => 0x110 },
	'tonecurvebluex' => { 271 => 0x9003 },
	'tonecurvebluey' => { 271 => 0x9007 },
	'tonecurvebrightnessx' => { 271 => 0x9000 },
	'tonecurvebrightnessy' => { 271 => 0x9004 },
	'tonecurvefilename' => { 95 => 0x1391 },
	'tonecurvegreenx' => { 271 => 0x9002 },
	'tonecurvegreeny' => { 271 => 0x9006 },
	'tonecurveinterpolation' => { 77 => 0x159 },
	'tonecurvemode' => { 77 => 0x113 },
	'tonecurvename' => { 280 => 'ToneCurveName' },
	'tonecurveproperty' => { 77 => 0x3c },
	'tonecurveredx' => { 271 => 0x9001 },
	'tonecurveredy' => { 271 => 0x9005 },
	'tonecurves' => { 241 => 0x403 },
	'toningeffect' => { 38 => 0xf, 158 => 0xb3, 160 => 0x38 },
	'toningeffectfaithful' => { 48 => 0x74, 49 => 0x74 },
	'toningeffectlandscape' => { 48 => 0x44, 49 => 0x44 },
	'toningeffectmonochrome' => { 15 => 0x108, 48 => 0x8c, 49 => 0x8c },
	'toningeffectneutral' => { 48 => 0x5c, 49 => 0x5c },
	'toningeffectportrait' => { 48 => 0x2c, 49 => 0x2c },
	'toningeffectstandard' => { 48 => 0x14, 49 => 0x14 },
	'toningeffectunknown' => { 49 => 0xa4 },
	'toningeffectuserdef1' => { 48 => 0xa4, 49 => 0xbc },
	'toningeffectuserdef2' => { 48 => 0xbc, 49 => 0xd4 },
	'toningeffectuserdef3' => { 48 => 0xd4, 49 => 0xec },
	'toningsaturation' => { 160 => 0x39 },
	'totalzoom' => { 97 => 0x62 },
	'tracknumber' => { 302 => 'trackNumber' },
	'tracks' => { 302 => 'Tracks' },
	'tracksframerate' => { 302 => [\'Tracks','TracksFrameRate'] },
	'tracksmarkers' => { 302 => [\'Tracks','TracksMarkers'] },
	'tracksmarkerscomment' => { 302 => [\'Tracks','TracksMarkersComment'] },
	'tracksmarkerscuepointparams' => { 302 => [\'Tracks','TracksMarkersCuePointParams'] },
	'tracksmarkerscuepointparamskey' => { 302 => [\'Tracks','TracksMarkersCuePointParamsKey'] },
	'tracksmarkerscuepointparamsvalue' => { 302 => [\'Tracks','TracksMarkersCuePointParamsValue'] },
	'tracksmarkerscuepointtype' => { 302 => [\'Tracks','TracksMarkersCuePointType'] },
	'tracksmarkersduration' => { 302 => [\'Tracks','TracksMarkersDuration'] },
	'tracksmarkerslocation' => { 302 => [\'Tracks','TracksMarkersLocation'] },
	'tracksmarkersname' => { 302 => [\'Tracks','TracksMarkersName'] },
	'tracksmarkersprobability' => { 302 => [\'Tracks','TracksMarkersProbability'] },
	'tracksmarkersspeaker' => { 302 => [\'Tracks','TracksMarkersSpeaker'] },
	'tracksmarkersstarttime' => { 302 => [\'Tracks','TracksMarkersStartTime'] },
	'tracksmarkerstarget' => { 302 => [\'Tracks','TracksMarkersTarget'] },
	'tracksmarkerstype' => { 302 => [\'Tracks','TracksMarkersType'] },
	'trackstrackname' => { 302 => [\'Tracks','TracksTrackName'] },
	'trackstracktype' => { 302 => [\'Tracks','TracksTrackType'] },
	'trailersignature' => { 119 => 'zmie' },
	'transferfunction' => { 83 => 0x12d, 298 => 'TransferFunction' },
	'transform' => { 218 => [0x8012,0x59] },
	'transmissionreference' => { 291 => 'TransmissionReference' },
	'trapped' => { 207 => 'Trapped', 290 => 'Trapped' },
	'travelday' => { 218 => 0x36 },
	'triggermode' => { 253 => 0x6 },
	'ttl_da_adown' => { 233 => 0x5 },
	'ttl_da_aup' => { 233 => 0x4 },
	'ttl_da_bdown' => { 233 => 0x7 },
	'ttl_da_bup' => { 233 => 0x6 },
	'tungstenawb' => { 223 => 0x1 },
	'tvexposuretimesetting' => { 226 => 0x12 },
	'type' => { 281 => 'type', 297 => 'type' },
	'uniquecameramodel' => { 83 => 0xc614 },
	'uniquedocumentid' => { 90 => 0xbb },
	'uniqueobjectname' => { 91 => 0x64 },
	'unknownblock' => { 202 => 0x1103 },
	'unknowncontrast' => { 78 => 0x45 },
	'unknownev' => { 95 => 0x1 },
	'unknownlinear' => { 78 => 0x46 },
	'unknownmode' => { 80 => 0x301b },
	'unknownnumber' => { 72 => 0x180b },
	'unknownoutputhighlightpoint' => { 78 => 0x4a },
	'unknownoutputshadowpoint' => { 78 => 0x4b },
	'unknownrawhighlight' => { 78 => 0x7b },
	'unknownrawhighlightpoint' => { 78 => 0x48 },
	'unknownrawshadow' => { 78 => 0x84 },
	'unknownrawshadowpoint' => { 78 => 0x49 },
	'unknownsharpness' => { 78 => 0x47 },
	'unsharp1color' => { 191 => 0x13 },
	'unsharp1halowidth' => { 191 => 0x19 },
	'unsharp1intensity' => { 191 => 0x17 },
	'unsharp1threshold' => { 191 => 0x1b },
	'unsharp2color' => { 191 => 0x2e },
	'unsharp2halowidth' => { 191 => 0x34 },
	'unsharp2intensity' => { 191 => 0x32 },
	'unsharp2threshold' => { 191 => 0x36 },
	'unsharp3color' => { 191 => 0x49 },
	'unsharp3halowidth' => { 191 => 0x4f },
	'unsharp3intensity' => { 191 => 0x4d },
	'unsharp3threshold' => { 191 => 0x51 },
	'unsharp4color' => { 191 => 0x64 },
	'unsharp4halowidth' => { 191 => 0x6a },
	'unsharp4intensity' => { 191 => 0x68 },
	'unsharp4threshold' => { 191 => 0x6c },
	'unsharpcount' => { 191 => 0x0 },
	'unsharpmask' => { 78 => 0x90, 186 => 0x76a43200 },
	'unsharpmaskfineness' => { 78 => 0x94 },
	'unsharpmaskstrength' => { 78 => 0x92 },
	'unsharpmaskthreshold' => { 78 => 0x96 },
	'urgency' => { 90 => 0xa, 291 => 'Urgency' },
	'url' => { 112 => 'URL', 209 => 'URL', 250 => 0x40b, 293 => 'url' },
	'usablemeteringmodes' => { 59 => 0x10a },
	'usableshootingmodes' => { 59 => 0x109 },
	'usage' => { 294 => 'usage' },
	'usagefee' => { 295 => 'usageFee' },
	'usageterms' => { 306 => 'UsageTerms' },
	'usercomment' => { 72 => 0x805, 83 => 0x9286, 284 => 'UserComment' },
	'userdef1picturestyle' => { 15 => 0x10c, 48 => 0xd8, 49 => 0xf0 },
	'userdef2picturestyle' => { 15 => 0x10e, 48 => 0xda, 49 => 0xf2 },
	'userdef3picturestyle' => { 15 => 0x110, 48 => 0xdc, 49 => 0xf4 },
	'userfields' => { 275 => 'UserFields' },
	'userlabel' => { 253 => 0x2b },
	'userprofile' => { 213 => 0x302, 219 => 0x3038 },
	'usmlenselectronicmf' => { 58 => 0x7, 59 => 0x501 },
	'utmeasting' => { 123 => 'Easting' },
	'utmmapdatum' => { 123 => 'Datum' },
	'utmnorthing' => { 123 => 'Northing' },
	'utmzone' => { 123 => 'Zone' },
	'uv-irfiltercorrection' => { 213 => 0x325 },
	'validbits' => { 202 => 0x611, 203 => 0x102c },
	'validpixeldepth' => { 206 => 0x611 },
	'variousmodes' => { 97 => 0x26 },
	'variousmodes2' => { 97 => 0x3a },
	'variprogram' => { 158 => 0xab },
	'version' => { 87 => 0x0, 252 => 'Version', 280 => 'Version' },
	'versioncreatedate' => { 271 => 0xd100 },
	'versionid' => { 303 => 'VersionID' },
	'versionidentifier' => { 293 => 'versionIdentifier' },
	'versionmodifydate' => { 271 => 0xd101 },
	'versions' => { 303 => 'Versions' },
	'versionscomments' => { 303 => [\'Versions','VersionsComments'] },
	'versionsevent' => { 303 => [\'Versions','VersionsEvent'] },
	'versionseventaction' => { 303 => [\'Versions','VersionsEventAction'] },
	'versionseventchanged' => { 303 => [\'Versions','VersionsEventChanged'] },
	'versionseventinstanceid' => { 303 => [\'Versions','VersionsEventInstanceID'] },
	'versionseventparameters' => { 303 => [\'Versions','VersionsEventParameters'] },
	'versionseventsoftwareagent' => { 303 => [\'Versions','VersionsEventSoftwareAgent'] },
	'versionseventwhen' => { 303 => [\'Versions','VersionsEventWhen'] },
	'versionsmodifier' => { 303 => [\'Versions','VersionsModifier'] },
	'versionsmodifydate' => { 303 => [\'Versions','VersionsModifyDate'] },
	'versionsversion' => { 303 => [\'Versions','VersionsVersion'] },
	'verticalafonbutton' => { 193 => '3.2' },
	'vfdisplayillumination' => { 59 => 0x510 },
	'vibrance' => { 280 => 'Vibrance' },
	'vibrationreduction' => { 164 => [0x75,0x82,0x1ae], 172 => '586.1', 174 => '590.2', 177 => 0x4 },
	'videoalphamode' => { 302 => 'videoAlphaMode' },
	'videoalphapremultiplecolor' => { 302 => 'videoAlphaPremultipleColor' },
	'videoalphapremultiplecolora' => { 302 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorA'] },
	'videoalphapremultiplecolorb' => { 302 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorB'] },
	'videoalphapremultiplecolorblack' => { 302 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlack'] },
	'videoalphapremultiplecolorblue' => { 302 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlue'] },
	'videoalphapremultiplecolorcyan' => { 302 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorCyan'] },
	'videoalphapremultiplecolorgreen' => { 302 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGreen'] },
	'videoalphapremultiplecolorl' => { 302 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorL'] },
	'videoalphapremultiplecolormagenta' => { 302 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMagenta'] },
	'videoalphapremultiplecolormode' => { 302 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMode'] },
	'videoalphapremultiplecolorred' => { 302 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorRed'] },
	'videoalphapremultiplecolorswatchname' => { 302 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorSwatchName'] },
	'videoalphapremultiplecolortype' => { 302 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorType'] },
	'videoalphapremultiplecoloryellow' => { 302 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorYellow'] },
	'videoalphaunityistransparent' => { 302 => 'videoAlphaUnityIsTransparent' },
	'videocodec' => { 46 => 0x74 },
	'videocolorspace' => { 302 => 'videoColorSpace' },
	'videocompressor' => { 302 => 'videoCompressor' },
	'videofieldorder' => { 302 => 'videoFieldOrder' },
	'videoframerate' => { 302 => 'videoFrameRate' },
	'videoframesize' => { 302 => 'videoFrameSize' },
	'videoframesizeh' => { 302 => [\'videoFrameSize','videoFrameSizeH'] },
	'videoframesizeunit' => { 302 => [\'videoFrameSize','videoFrameSizeUnit'] },
	'videoframesizew' => { 302 => [\'videoFrameSize','videoFrameSizeW'] },
	'videomoddate' => { 302 => 'videoModDate' },
	'videopixelaspectratio' => { 302 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 302 => 'videoPixelDepth' },
	'videoquality' => { 80 => 0x4003 },
	'viewfinderdisplay' => { 193 => '12.4' },
	'viewfinderwarning' => { 193 => '13.4', 196 => '6.2', 197 => '4.4' },
	'viewinfoduringexposure' => { 59 => 0x407 },
	'vignetteamount' => { 280 => 'VignetteAmount' },
	'vignettecontrol' => { 158 => 0x2a, 186 => 0x76a43205 },
	'vignettecontrolintensity' => { 186 => 0xac6bd5c0 },
	'vignettemidpoint' => { 280 => 'VignetteMidpoint' },
	'voicememo' => { 261 => 0x216 },
	'volume' => { 293 => 'volume' },
	'vr_0x66' => { 164 => 0x66 },
	'vrdoffset' => { 43 => 0xd0 },
	'wb_bluepresetsfluorescent' => { 134 => 0x40a },
	'wb_gbrglevels' => { 134 => 0xae, 137 => 0x4 },
	'wb_glevel' => { 202 => 0x11f },
	'wb_glevel3000k' => { 202 => 0x113 },
	'wb_glevel3300k' => { 202 => 0x114 },
	'wb_glevel3600k' => { 202 => 0x115 },
	'wb_glevel3900k' => { 202 => 0x116 },
	'wb_glevel4000k' => { 202 => 0x117 },
	'wb_glevel4300k' => { 202 => 0x118 },
	'wb_glevel4500k' => { 202 => 0x119 },
	'wb_glevel4800k' => { 202 => 0x11a },
	'wb_glevel5300k' => { 202 => 0x11b },
	'wb_glevel6000k' => { 202 => 0x11c },
	'wb_glevel6600k' => { 202 => 0x11d },
	'wb_glevel7500k' => { 202 => 0x11e },
	'wb_grbglevels' => { 145 => 0x0 },
	'wb_rbgglevels' => { 142 => 0x0 },
	'wb_rblevels' => { 158 => 0xc, 202 => 0x100 },
	'wb_rblevels3000k' => { 202 => 0x102 },
	'wb_rblevels3300k' => { 202 => 0x103 },
	'wb_rblevels3600k' => { 202 => 0x104 },
	'wb_rblevels3900k' => { 202 => 0x105 },
	'wb_rblevels4000k' => { 202 => 0x106 },
	'wb_rblevels4300k' => { 202 => 0x107 },
	'wb_rblevels4500k' => { 202 => 0x108 },
	'wb_rblevels4800k' => { 202 => 0x109 },
	'wb_rblevels5300k' => { 202 => 0x10a },
	'wb_rblevels6000k' => { 202 => 0x10b },
	'wb_rblevels6600k' => { 202 => 0x10c },
	'wb_rblevels7500k' => { 202 => 0x10d },
	'wb_rblevelsauto' => { 206 => 0x110 },
	'wb_rblevelscloudy' => { 136 => 0x10, 206 => 0x121 },
	'wb_rblevelscoolwhitef' => { 136 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 206 => 0x132 },
	'wb_rblevelscwb1' => { 202 => 0x10e },
	'wb_rblevelscwb2' => { 202 => 0x10f },
	'wb_rblevelscwb3' => { 202 => 0x110 },
	'wb_rblevelscwb4' => { 202 => 0x111 },
	'wb_rblevelsdaylight' => { 136 => 0xc },
	'wb_rblevelsdaylightf' => { 136 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 206 => 0x130 },
	'wb_rblevelsdaywhitef' => { 136 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 206 => 0x131 },
	'wb_rblevelseveningsunlight' => { 206 => 0x124 },
	'wb_rblevelsfineweather' => { 206 => 0x122 },
	'wb_rblevelsflash' => { 136 => 0x18 },
	'wb_rblevelsshade' => { 136 => 0x20, 206 => 0x120 },
	'wb_rblevelstungsten' => { 136 => 0x8, 206 => 0x123 },
	'wb_rblevelsunknown' => { 136 => 0x1c },
	'wb_rblevelsused' => { 206 => 0x100 },
	'wb_rblevelswhitef' => { 136 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 206 => 0x133 },
	'wb_rbpresetcloudy' => { 134 => 0x3f0 },
	'wb_rbpresetcoolwhitef' => { 134 => 0x308 },
	'wb_rbpresetcustom' => { 134 => 0x424 },
	'wb_rbpresetdaylight' => { 134 => 0x3ec },
	'wb_rbpresetflash' => { 134 => [0x3f4,0x304] },
	'wb_rbpresetshade' => { 134 => 0x418 },
	'wb_rbpresettungsten' => { 134 => 0x3e8 },
	'wb_redpresetsfluorescent' => { 134 => 0x3fc },
	'wb_rgbglevels' => { 144 => 0x0 },
	'wb_rgblevels' => { 134 => 0x96, 214 => 0xd, 215 => 0x413, 219 => 0x3036 },
	'wb_rggblevels' => { 137 => 0x4, 143 => 0x0, 260 => 0xa021 },
	'wb_rggblevelsasshot' => { 27 => 0x0, 28 => 0x19, 29 => 0x22, 30 => 0x3f, 33 => 0x3f },
	'wb_rggblevelsauto' => { 25 => 0x0, 27 => 0x5, 28 => 0x1e, 29 => 0x18, 30 => 0x44, 33 => 0x44 },
	'wb_rggblevelscloudy' => { 25 => 0xc, 27 => 0x1e, 28 => 0x2d, 29 => 0x31, 30 => 0x58, 33 => 0x71, 241 => 0x20f },
	'wb_rggblevelscustom' => { 25 => 0x1c, 30 => 0x80 },
	'wb_rggblevelscustom1' => { 28 => 0x41 },
	'wb_rggblevelscustom2' => { 28 => 0x46 },
	'wb_rggblevelsdaylight' => { 25 => 0x4, 27 => 0x14, 28 => 0x23, 29 => 0x27, 30 => 0x4e, 33 => 0x67, 241 => 0x20d },
	'wb_rggblevelsflash' => { 25 => 0x18, 27 => 0x32, 28 => 0x3c, 29 => 0x45, 30 => 0x6c, 33 => 0x85, 241 => 0x214 },
	'wb_rggblevelsfluorescent' => { 25 => 0x14, 27 => 0x28, 28 => 0x37, 29 => 0x3b, 30 => 0x62, 33 => 0x7b },
	'wb_rggblevelsfluorescentd' => { 241 => 0x211 },
	'wb_rggblevelsfluorescentn' => { 241 => 0x212 },
	'wb_rggblevelsfluorescentw' => { 241 => 0x213 },
	'wb_rggblevelskelvin' => { 25 => 0x20, 27 => 0x2d, 29 => 0x40, 30 => 0x67, 33 => 0x80 },
	'wb_rggblevelsmeasured' => { 27 => 0xa, 30 => 0x49, 33 => 0x49 },
	'wb_rggblevelspc1' => { 29 => 0x90, 30 => 0x71 },
	'wb_rggblevelspc2' => { 29 => 0x95, 30 => 0x76 },
	'wb_rggblevelspc3' => { 29 => 0x9a, 30 => 0x7b },
	'wb_rggblevelsshade' => { 25 => 0x8, 27 => 0x19, 28 => 0x28, 29 => 0x2c, 30 => 0x53, 33 => 0x6c, 241 => 0x20e },
	'wb_rggblevelstungsten' => { 25 => 0x10, 27 => 0x23, 28 => 0x32, 29 => 0x36, 30 => 0x5d, 33 => 0x76, 241 => 0x210 },
	'wb_rggblevelsunknown' => { 27 => 0xf, 29 => 0x1d, 33 => 0x4e },
	'wb_rggblevelsunknown10' => { 27 => 0x5f, 29 => 0x72, 33 => 0x9e },
	'wb_rggblevelsunknown11' => { 27 => 0x64, 29 => 0x77, 33 => 0xa3 },
	'wb_rggblevelsunknown12' => { 27 => 0x69, 29 => 0x7c, 33 => 0xa8 },
	'wb_rggblevelsunknown13' => { 27 => 0x6e, 29 => 0x81, 33 => 0xad },
	'wb_rggblevelsunknown14' => { 29 => 0x86, 33 => 0xb2 },
	'wb_rggblevelsunknown15' => { 29 => 0x8b, 33 => 0xb7 },
	'wb_rggblevelsunknown16' => { 29 => 0x9f },
	'wb_rggblevelsunknown2' => { 27 => 0x37, 29 => 0x4a, 33 => 0x53 },
	'wb_rggblevelsunknown3' => { 27 => 0x3c, 29 => 0x4f, 33 => 0x58 },
	'wb_rggblevelsunknown4' => { 27 => 0x41, 29 => 0x54, 33 => 0x5d },
	'wb_rggblevelsunknown5' => { 27 => 0x46, 29 => 0x59, 33 => 0x62 },
	'wb_rggblevelsunknown6' => { 27 => 0x4b, 29 => 0x5e, 33 => 0x8a },
	'wb_rggblevelsunknown7' => { 27 => 0x50, 29 => 0x63, 33 => 0x8f },
	'wb_rggblevelsunknown8' => { 27 => 0x55, 29 => 0x68, 33 => 0x94 },
	'wb_rggblevelsunknown9' => { 27 => 0x5a, 29 => 0x6d, 33 => 0x99 },
	'wbadjbluebalance' => { 192 => 0x8 },
	'wbadjcolortemp' => { 77 => 0x1a },
	'wbadjlighting' => { 192 => 0x15 },
	'wbadjlightingsubtype' => { 192 => 0x14 },
	'wbadjmode' => { 192 => 0x10 },
	'wbadjredbalance' => { 192 => 0x0 },
	'wbadjrgblevels' => { 77 => 0x8 },
	'wbadjtemperature' => { 192 => 0x18 },
	'wbadjtint' => { 192 => 0x25 },
	'wbadjustab' => { 218 => 0x46 },
	'wbadjustgm' => { 218 => 0x47 },
	'wbbluelevel' => { 213 => 0x324, 218 => 0x8006, 220 => 0x26 },
	'wbbracketmode' => { 38 => 0x9 },
	'wbbracketvalueab' => { 38 => 0xc },
	'wbbracketvaluegm' => { 38 => 0xd },
	'wbfinetuneactive' => { 77 => 0x24 },
	'wbfinetunesaturation' => { 77 => 0x28 },
	'wbfinetunetone' => { 77 => 0x2c },
	'wbgreenlevel' => { 213 => 0x323, 218 => 0x8005, 220 => 0x25 },
	'wbmediaimagesizesetting' => { 59 => 0x708 },
	'wbmode' => { 136 => 0x4, 203 => 0x1015 },
	'wbredlevel' => { 213 => 0x322, 218 => 0x8004, 220 => 0x24 },
	'wbscale' => { 137 => 0x0 },
	'wbshiftab' => { 52 => 0xc, 227 => 0x10 },
	'wbshiftgm' => { 52 => 0xd },
	'wbshiftmg' => { 227 => 0x11 },
	'webstatement' => { 306 => 'WebStatement' },
	'whitebalance' => { 4 => 0x6f, 5 => [0x44,0x4a], 6 => 0x36, 7 => 0x5e, 8 => 0x36, 9 => [0x77,0x78], 10 => 0x6f, 11 => 0x6f, 12 => 0x73, 13 => 0x6f, 14 => 0x78, 15 => 0x54, 16 => 0x6f, 20 => 0x53, 52 => 0x8, 54 => 0x7, 79 => 0x7, 80 => [0x19,0x2012], 83 => [0xa403,0xfe4e], 87 => 0x1002, 95 => 0x3fc, 96 => 0xfa0d, 97 => 0x40, 129 => 0x3, 130 => 0xe, 131 => 0x4, 132 => 0xb, 133 => 0x115, 158 => 0x5, 176 => 0x7, 213 => 0x304, 218 => 0x3, 219 => 0x3033, 241 => 0x19, 246 => 0x7, 255 => 0x26, 262 => [0x3c,0x7], 268 => [0x115,0xb054], 280 => 'WhiteBalance', 284 => 'WhiteBalance' },
	'whitebalance2' => { 198 => 0x500 },
	'whitebalanceadj' => { 77 => 0x18, 186 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 223 => 0x0 },
	'whitebalancebias' => { 80 => 0x2011, 203 => 0x304, 218 => 0x23 },
	'whitebalanceblue' => { 52 => 0x7 },
	'whitebalancebracket' => { 198 => 0x502, 203 => 0x303 },
	'whitebalancebracketing' => { 132 => 0x22 },
	'whitebalancecomp' => { 206 => 0x1001 },
	'whitebalancefinetune' => { 87 => 0x100a, 132 => 0x38, 133 => 0x112, 158 => 0xb, 263 => 0x6, 268 => 0x112 },
	'whitebalancemode' => { 241 => 0x1a },
	'whitebalancered' => { 52 => 0x6 },
	'whitebalanceset' => { 226 => 0xa },
	'whitebalancesetting' => { 132 => 0x23 },
	'whitebalancetemperature' => { 198 => 0x501 },
	'whiteboard' => { 203 => 0x301 },
	'whitelevel' => { 83 => 0xc61d },
	'whitepoint' => { 83 => 0x13e, 241 => 0x201, 298 => 'WhitePoint' },
	'widefocuszone' => { 129 => 0x2f },
	'widerange' => { 261 => 0x20f },
	'wordcount' => { 293 => 'wordCount' },
	'workcolorspace' => { 77 => 0x270 },
	'worldtimelocation' => { 218 => 0x3a, 241 => 0x22, 245 => '0.1' },
	'writer-editor' => { 90 => 0x7a },
	'x3filllight' => { 262 => 0x12 },
	'xmp' => { 76 => 0xffff00f6, 84 => 'XMP' },
	'xmptoolkit' => { 299 => 'xmptk' },
	'xpauthor' => { 83 => 0x9c9d },
	'xpcomment' => { 83 => 0x9c9c },
	'xpkeywords' => { 83 => 0x9c9e },
	'xposition' => { 83 => 0x11e },
	'xpsubject' => { 83 => 0x9c9f },
	'xptitle' => { 83 => 0x9c9b },
	'xresolution' => { 83 => 0x11a, 93 => 0x3, 251 => 0x0, 298 => 'XResolution' },
	'xyresolution' => { 86 => 0x3 },
	'ycbcrcoefficients' => { 83 => 0x211, 298 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 83 => 0x213, 298 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 83 => 0x212, 298 => 'YCbCrSubSampling' },
	'yearcreated' => { 97 => 0x10, 106 => 0xc },
	'yposition' => { 83 => 0x11f },
	'yresolution' => { 83 => 0x11b, 93 => 0x5, 251 => 0x4, 298 => 'YResolution' },
	'zonematching' => { 133 => 0x10a, 136 => [0x3a,0x4a], 268 => 0xb024 },
	'zonematchingmode' => { 132 => 0x14 },
	'zonematchingon' => { 131 => 0x75 },
	'zonematchingvalue' => { 263 => 0x1f },
	'zoomedpreviewlength' => { 203 => 0xf05 },
	'zoomedpreviewsize' => { 203 => 0xf06 },
	'zoomedpreviewstart' => { 203 => 0xf04 },
	'zoomsourcewidth' => { 24 => 0x24 },
	'zoomstepcount' => { 201 => 0x300, 203 => 0x100d },
	'zoomtargetwidth' => { 24 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_ac3' => 1,
	'_h264' => 1,
	'_stream' => 1,
	'a100dataoffset' => 1,
	'abstract' => 1,
	'accessdate' => 1,
	'acdsee' => 1,
	'actualcompensation' => 1,
	'adobe' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aeflags' => 1,
	'aeinfo' => 1,
	'aeunknown' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afmicroadj' => 1,
	'afpointsinfocus1d' => 1,
	'afpointsselected' => 1,
	'aftune' => 1,
	'aimetadata' => 1,
	'aiprivatedata' => 1,
	'album2' => 1,
	'albumartist' => 1,
	'albumcoverurl' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitle' => 1,
	'albumtitleid' => 1,
	'aliaslayermetadata' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphaoffset' => 1,
	'alphasample' => 1,
	'alternateduotonecolors' => 1,
	'alternatespotcolors' => 1,
	'ambienceinfo' => 1,
	'animationextension' => 1,
	'animationiterations' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'aperturesetting' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'applestoreaccount' => 1,
	'applestoreaccounttype' => 1,
	'applestorecatalogid' => 1,
	'applestorecountry' => 1,
	'application' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationversion' => 1,
	'appversion' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'arranger' => 1,
	'arrangerkeywords' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artisturl' => 1,
	'artwork' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'aspectinfo' => 1,
	'aspectratiotype' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'attachedfile' => 1,
	'attachedfiledata' => 1,
	'attachedfiledescription' => 1,
	'attachedfilemimetype' => 1,
	'attachedfilename' => 1,
	'attachedfilereferral' => 1,
	'attachedfileuid' => 1,
	'attachments' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavgbitrate' => 1,
	'audiobitspersample' => 1,
	'audiobytes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiodelay' => 1,
	'audioencoding' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiogain' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audiolayer' => 1,
	'audiomaxbitrate' => 1,
	'audiomode' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiovendorid' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authorlen' => 1,
	'authorship' => 1,
	'authorurl' => 1,
	'aux' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'balance' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'baselinelength' => 1,
	'baseviewpointnum' => 1,
	'basisobject' => 1,
	'bass' => 1,
	'batteryinfo' => 1,
	'beatsperminute' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'bitrate' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackleveldeltah' => 1,
	'blackleveldeltav' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'block' => 1,
	'blockaddid' => 1,
	'blockadditional' => 1,
	'blockadditionalid' => 1,
	'blockadditions' => 1,
	'blockduration' => 1,
	'blockgroup' => 1,
	'blocklocation' => 1,
	'blockmore' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blockvirtual' => 1,
	'blueadjust' => 1,
	'bluegain' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'booktitle' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bracketshot' => 1,
	'breakchar' => 1,
	'brightnessdata' => 1,
	'broadcast' => 1,
	'broadcastextension' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'bytes' => 1,
	'bytesperminute' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calibrationdatetime' => 1,
	'camera' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameradirection' => 1,
	'cameraidentifier' => 1,
	'camerainfo' => 1,
	'camerainfo5dmkii_2a' => 1,
	'camerainfo5dmkii_2b' => 1,
	'camerainfo7d_2a' => 1,
	'camerainfo7d_2b' => 1,
	'cameramotion' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraprofileversion' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'cameraspecification' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cc' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'cell' => 1,
	'centerdarkrect' => 1,
	'cfalayout' => 1,
	'cfapattern2' => 1,
	'cfaplanecolor' => 1,
	'cfarepeatpatterndim' => 1,
	'channelmode' => 1,
	'channelpositions' => 1,
	'chapter' => 1,
	'chapteratom' => 1,
	'chaptercountry' => 1,
	'chapterdisplay' => 1,
	'chapterflagenabled' => 1,
	'chapterflaghidden' => 1,
	'chapterlanguage' => 1,
	'chapterlist' => 1,
	'chapterphysicalequivalent' => 1,
	'chapterprocess' => 1,
	'chapterprocesscodecid' => 1,
	'chapterprocesscommand' => 1,
	'chapterprocessdata' => 1,
	'chapterprocessprivate' => 1,
	'chapterprocesstime' => 1,
	'chapters' => 1,
	'chaptersegmenteditionuid' => 1,
	'chaptersegmentuid' => 1,
	'chapterstring' => 1,
	'chaptertimeend' => 1,
	'chaptertimestart' => 1,
	'chaptertrack' => 1,
	'chaptertracknumber' => 1,
	'chaptertranslate' => 1,
	'chaptertranslatecodec' => 1,
	'chaptertranslateeditionuid' => 1,
	'chaptertranslateid' => 1,
	'chapteruid' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'checkedby' => 1,
	'chromaticadaptation' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classification' => 1,
	'cleanfaxdata' => 1,
	'clipboundary' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'cluster' => 1,
	'clusterduration' => 1,
	'cmmflags' => 1,
	'cmykequivalent' => 1,
	'codecdecodeall' => 1,
	'codecdownloadurl' => 1,
	'codecflavorid' => 1,
	'codecid' => 1,
	'codecinfourl' => 1,
	'codeclist' => 1,
	'codecname' => 1,
	'codecprivate' => 1,
	'codecsettings' => 1,
	'codecstate' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'color' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantorder' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalib' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcoefs' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordata6' => 1,
	'colordataunknown' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorimetry' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspecification' => 1,
	'colortable' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'commandlinearguments' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblebrands' => 1,
	'compatiblefontname' => 1,
	'compilation' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'composerkeywords' => 1,
	'compositinglayerheader' => 1,
	'composition' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'compressorversion' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductor' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'cont' => 1,
	'containerformat' => 1,
	'containerversion' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentcompression' => 1,
	'contentcompressionalgorithm' => 1,
	'contentcompressionsettings' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributor' => 1,
	'contentencoding' => 1,
	'contentencodingorder' => 1,
	'contentencodings' => 1,
	'contentencodingscope' => 1,
	'contentencodingtype' => 1,
	'contentencryption' => 1,
	'contentencryptionalgorithm' => 1,
	'contentencryptionkeyid' => 1,
	'contentgroupdescription' => 1,
	'contentlanguage' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentsignature' => 1,
	'contentsignaturealgorithm' => 1,
	'contentsignaturehashalgorithm' => 1,
	'contentsignaturekeyid' => 1,
	'contentstyletype' => 1,
	'contenttype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastcurve' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'costumedesigner' => 1,
	'coverart' => 1,
	'coverartmimetype' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'crc-32' => 1,
	'crcdevelparams' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorappid' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatorinfo' => 1,
	'creatorversion' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropped' => 1,
	'cropx' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropy' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cueblocknumber' => 1,
	'cueclusterposition' => 1,
	'cuecodecstate' => 1,
	'cuepoint' => 1,
	'cuerefcluster' => 1,
	'cuerefcodecstate' => 1,
	'cuereference' => 1,
	'cuerefnumber' => 1,
	'cuereftime' => 1,
	'cues' => 1,
	'cuetime' => 1,
	'cuetrack' => 1,
	'cuetrackpositions' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'custompicturestyledata' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd40' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd90' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'darkcorrectiontype' => 1,
	'darwindata' => 1,
	'data' => 1,
	'data1' => 1,
	'data2' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datainformation' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasize' => 1,
	'datatype' => 1,
	'datecompleted' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'datetimeend' => 1,
	'dc' => 1,
	'dcmd' => 1,
	'dcme' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'decode' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultduration' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'deviceattributes' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'discardobjects' => 1,
	'disknumber' => 1,
	'displayheight' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunit' => 1,
	'displayunits' => 1,
	'displaywidth' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distortinfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'division' => 1,
	'djvuversion' => 1,
	'dngadobedata' => 1,
	'dngprivatedata' => 1,
	'docclass' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'doctypereadversion' => 1,
	'doctypeversion' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dotsperinch' => 1,
	'driveserialnumber' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'ducky' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dvdid' => 1,
	'ebmlheader' => 1,
	'ebmlmaxidlength' => 1,
	'ebmlmaxsizelength' => 1,
	'ebmlreadversion' => 1,
	'ebmlversion' => 1,
	'edit1' => 1,
	'edit2' => 1,
	'edit3' => 1,
	'edit4' => 1,
	'edit5' => 1,
	'edit6' => 1,
	'edit7' => 1,
	'edit8' => 1,
	'edit9' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editionentry' => 1,
	'editionflagdefault' => 1,
	'editionflaghidden' => 1,
	'editionflagordered' => 1,
	'editionuid' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectsvisible' => 1,
	'eighthlanguage' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'emphasis' => 1,
	'encodedby' => 1,
	'encodedusing' => 1,
	'encoder' => 1,
	'encodersettings' => 1,
	'encoderversion' => 1,
	'encoding' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encodingtime' => 1,
	'encrypt' => 1,
	'encryptedblock' => 1,
	'encryption' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'envvardata' => 1,
	'episodeglobaluniqueid' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escchar' => 1,
	'evalstate' => 1,
	'events' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureinfo' => 1,
	'exposureunknown' => 1,
	'extcache' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedstreamprops' => 1,
	'extendedxmp' => 1,
	'extenderstatus' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'externalleading' => 1,
	'extraflags' => 1,
	'extrasamples' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'faceinfo1' => 1,
	'faceinfo2' => 1,
	'faceinfolength' => 1,
	'faceinfooffset' => 1,
	'facepos' => 1,
	'facerecinfo' => 1,
	'facesize' => 1,
	'fastseek' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fieldmdp' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'fileattributes' => 1,
	'filedescription' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepermissions' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'fileurl' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'finalframeblocks' => 1,
	'firmwareinfo' => 1,
	'firstchar' => 1,
	'firstlanguage' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'flags' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'focallength35efl' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspos' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fontweight' => 1,
	'footerposition' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'frameheight' => 1,
	'frameinfo' => 1,
	'framepriority' => 1,
	'framereadouttime' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framewidth' => 1,
	'free' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'fstype' => 1,
	'fujifilm' => 1,
	'fujilayout' => 1,
	'fullname' => 1,
	'fullscreen' => 1,
	'gain' => 1,
	'gamut' => 1,
	'gapless' => 1,
	'gdalmetadata' => 1,
	'gdalnodata' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'generator' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genr' => 1,
	'genreid' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geotiffasciiparams' => 1,
	'geotiffdirectory' => 1,
	'geotiffdoubleparams' => 1,
	'geotiffversion' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'gps' => 1,
	'gpscoordinates' => 1,
	'gpsinfo' => 1,
	'gpsposition' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greengain' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'group' => 1,
	'groupcaption' => 1,
	'grouping' => 1,
	'groupmutualexclusion' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasscript' => 1,
	'hasvideo' => 1,
	'hcusage' => 1,
	'hdrl' => 1,
	'hdvideo' => 1,
	'header' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hiddenslides' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'historybuffersize' => 1,
	'hotkey' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huffmantable' => 1,
	'hyperfocaldistance' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'identification' => 1,
	'idependentanddisposablesamples' => 1,
	'idsbasevalue' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illustrator' => 1,
	'image' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagedata' => 1,
	'imagedatadiscard' => 1,
	'imagedepth' => 1,
	'imagefields' => 1,
	'imageformat' => 1,
	'imageheader' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imageoffset' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imageresolution' => 1,
	'imageresources' => 1,
	'imagerotated' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagesourceek' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'includedfileid' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolourtablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'info' => 1,
	'information' => 1,
	'ingrreserved' => 1,
	'initialdisplayeffect' => 1,
	'initializeddatasize' => 1,
	'initialkey' => 1,
	'initialobjectdescriptor' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputprofile' => 1,
	'insertmode' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'integrationtime' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphmatrix' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpretedby' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isbasefont' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isoinfo' => 1,
	'isrc' => 1,
	'isrccode' => 1,
	'isrcnumber' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemid' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemprotection' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtables' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keys' => 1,
	'kids' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodakbordersifd' => 1,
	'kodakeffectsifd' => 1,
	'kodakifd' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'lacenumber' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'lastauthor' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lasttimestamp' => 1,
	'layercomps' => 1,
	'layersgroupinfo' => 1,
	'layerstateinfo' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensshading' => 1,
	'lensspec' => 1,
	'levelinfo' => 1,
	'libraryid' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'linearizationtable' => 1,
	'linearized' => 1,
	'lines' => 1,
	'linkerversion' => 1,
	'linkinfo' => 1,
	'linksuptodate' => 1,
	'lit' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'locationbody' => 1,
	'locationdate' => 1,
	'locationname' => 1,
	'locationnote' => 1,
	'locationrole' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'longdescription' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookuptable' => 1,
	'loopstyle' => 1,
	'lotus' => 1,
	'lr' => 1,
	'lslv' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics' => 1,
	'lyrics_synchronised' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshprintinfo' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailstop' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'majorbrand' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotes' => 1,
	'makerurl' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturer' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'matrixstructure' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxblockadditionid' => 1,
	'maxcache' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mcdi' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'mean' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementobserver' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediaclassprimaryid' => 1,
	'mediaclasssecondaryid' => 1,
	'mediacolor' => 1,
	'mediacreatedate' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediaduration' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'medialanguagecode' => 1,
	'mediamodifydate' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediatype' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'metermode' => 1,
	'microsoft' => 1,
	'mie' => 1,
	'mimetype' => 1,
	'mincache' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minorversion' => 1,
	'minpacketsize' => 1,
	'mintransmissiontime' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'modeextension' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltiepoint' => 1,
	'modeltransform' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationpermissions' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'montage' => 1,
	'month' => 1,
	'mood' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'mosaicpattern' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'moviedata' => 1,
	'moviedatasize' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'movieinfo' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'multiexposure' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mute' => 1,
	'muxingapp' => 1,
	'mwg-coll' => 1,
	'mwg-kw' => 1,
	'mwg-rs' => 1,
	'mxfversion' => 1,
	'mycolors' => 1,
	'name' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'narrator' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'nextfilename' => 1,
	'nexttrackid' => 1,
	'nextuid' => 1,
	'nikon' => 1,
	'nikoncaptureoffsets' => 1,
	'nikondata' => 1,
	'nikonncdt' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noiseprofile' => 1,
	'noisereductiondata' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nomssmarttags' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numafpoints' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numstreams' => 1,
	'objectfiletype' => 1,
	'objectid' => 1,
	'objectsizeannounced' => 1,
	'objecttype' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'offsetorigin' => 1,
	'offsetxy' => 1,
	'oldxmp' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusjunk' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'opacity' => 1,
	'opcodelist1' => 1,
	'opcodelist2' => 1,
	'opcodelist3' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'optimalbitrate' => 1,
	'orderingrestrictions' => 1,
	'originalalbum' => 1,
	'originalalbumtitle' => 1,
	'originalartist' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalimagebroker' => 1,
	'originallyricist' => 1,
	'originalmedia' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'osversion' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'otherformat' => 1,
	'otherimage' => 1,
	'otherimagelength' => 1,
	'otherimagestart' => 1,
	'otherinfo' => 1,
	'othersampledesc' => 1,
	'outputaudiosamplerate' => 1,
	'outputdataobjectlist' => 1,
	'outputprofile' => 1,
	'outputresponse' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pagecount' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'palette' => 1,
	'palettehistogram' => 1,
	'panasonic' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'parameter' => 1,
	'parasites' => 1,
	'parentalrating' => 1,
	'parentalratingreason' => 1,
	'part' => 1,
	'partialpalette' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'patternangle' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'peakbitrate' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxjunk' => 1,
	'pentaxtags' => 1,
	'perceptualrenderingintentgamut' => 1,
	'performer' => 1,
	'performerkeywords' => 1,
	'performers' => 1,
	'performersortorder' => 1,
	'performerurl' => 1,
	'period' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'pgfversion' => 1,
	'photoeffectsdata' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshopbgrthumbnail' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'photoshopthumbnail' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturestyleinfo2' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'pitchandfamily' => 1,
	'pitchshift' => 1,
	'pixelaspectratio' => 1,
	'pixelcalibration' => 1,
	'pixelformat' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelscale' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixelsperunitx' => 1,
	'pixelsperunity' => 1,
	'pixelunits' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planes' => 1,
	'playallframes' => 1,
	'playcounter' => 1,
	'playduration' => 1,
	'playerversion' => 1,
	'playgap' => 1,
	'playlistdelay' => 1,
	'playlistid' => 1,
	'playmode' => 1,
	'playselection' => 1,
	'plus' => 1,
	'podcast' => 1,
	'podcasturl' => 1,
	'pointsize' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'position' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2csa' => 1,
	'postscriptfontname' => 1,
	'pragma' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'prevfilename' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewdate' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'prevsize' => 1,
	'prevuid' => 1,
	'primaryitemreference' => 1,
	'primaryplatform' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printimversion' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producerkeywords' => 1,
	'product' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'productversion' => 1,
	'productversionnumber' => 1,
	'profile' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profiletype' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'promotionurl' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protectiontype' => 1,
	'provider' => 1,
	'providercopyright' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasedate' => 1,
	'purpose' => 1,
	'pyramidlevels' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafversion' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'rawcodecversion' => 1,
	'rawdata' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawimagefullsize' => 1,
	'rawimagemode' => 1,
	'rawimagesegmentation' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readerrequirements' => 1,
	'realtimestreamingprotocol' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'recinfo' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingcopyright' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'recordlabelname' => 1,
	'recordlabelurl' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'redadjust' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reference' => 1,
	'referenceblock' => 1,
	'referencepriority' => 1,
	'referencevirtual' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refresh' => 1,
	'relatedimagefile' => 1,
	'relativepath' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requirements' => 1,
	'reserved1' => 1,
	'resolutioninfo' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'ricoh' => 1,
	'ricohjunk' => 1,
	'ricohrdc2' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'root' => 1,
	'rotationangle' => 1,
	'roundtripversion' => 1,
	'rowinterleavefactor' => 1,
	'runwindow' => 1,
	'sampledegradationpriority' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'samplerate2' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsunginfo' => 1,
	'samsungtags' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbaexposurerecord' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerserialnumber' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'sceneappearanceestimates' => 1,
	'scenecolorimetryestimates' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'scriptcommand' => 1,
	'secondarygenre' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'seek' => 1,
	'seekable' => 1,
	'seekhead' => 1,
	'seekid' => 1,
	'seekpoint' => 1,
	'seekposition' => 1,
	'segmentfamily' => 1,
	'segmentfilename' => 1,
	'segmentheader' => 1,
	'segmentuid' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'sendduration' => 1,
	'sensorbottomborder' => 1,
	'sensorid' => 1,
	'sensorimageheight' => 1,
	'sensorimagewidth' => 1,
	'sensorinfo' => 1,
	'sensorleftborder' => 1,
	'sensorrightborder' => 1,
	'sensortopborder' => 1,
	'serialinfo' => 1,
	'series' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'seventhlanguage' => 1,
	'shadowendpoints' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'shareduserrating' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod40' => 1,
	'shotinfod5000' => 1,
	'shotinfod80' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shutter' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sigma' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signaturealgo' => 1,
	'signatureelementlist' => 1,
	'signatureelements' => 1,
	'signaturehash' => 1,
	'signaturepublickey' => 1,
	'signatureslot' => 1,
	'signatureusagerights' => 1,
	'signedelement' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'silenttracknumber' => 1,
	'silenttracks' => 1,
	'simpleblock' => 1,
	'simpleindex' => 1,
	'simpletag' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slices' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarerelease' => 1,
	'songwriter' => 1,
	'songwriterkeywords' => 1,
	'sony' => 1,
	'sonyimageheight' => 1,
	'sonyimagewidth' => 1,
	'sortalbum' => 1,
	'sortalbumartist' => 1,
	'sortartist' => 1,
	'sortcomposer' => 1,
	'sortname' => 1,
	'sortshow' => 1,
	'soundschemetitle' => 1,
	'sourcecredits' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'speed' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spothalftone' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'srgbrendering' => 1,
	'stamptoolcount' => 1,
	'starring' => 1,
	'startofframe' => 1,
	'starttime' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereo3dmode' => 1,
	'stereoimage' => 1,
	'stereomode' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitchinfo' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtype' => 1,
	'streamtypeinfo' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'sub-sampleinformation' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subseccreatedate' => 1,
	'subsecdatetimeoriginal' => 1,
	'subsecmodifydate' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitle' => 1,
	'subtitledescription' => 1,
	'subtitlekeywords' => 1,
	'suggestedpalette' => 1,
	'summaryinfo' => 1,
	'surroundmode' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'synchronizedlyrictext' => 1,
	'syncsampletable' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag' => 1,
	'tagattachmentuid' => 1,
	'tagbinary' => 1,
	'tagchapteruid' => 1,
	'tagdefault' => 1,
	'tageditionuid' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'taglanguage' => 1,
	'tagname' => 1,
	'tags' => 1,
	'tagstring' => 1,
	'tagtrackuid' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetprinter' => 1,
	'targets' => 1,
	'targettype' => 1,
	'targettypevalue' => 1,
	'targetxy' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'telephonenumber' => 1,
	'temperature' => 1,
	'tempinfok5' => 1,
	'template' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'text' => 1,
	'textinfo' => 1,
	'textjunk' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbnail' => 1,
	'thumbnailclip' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tileoffsets' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timecodescale' => 1,
	'timeinfo' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timeslice' => 1,
	'timetosampletable' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'tocitems' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonespaceflow' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topmag' => 1,
	'totalbitrate' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaledittime' => 1,
	'totalframecount' => 1,
	'totalframes' => 1,
	'totalsamples' => 1,
	'toycamerafilter' => 1,
	'track' => 1,
	'trackattachmentuid' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackcreatedate' => 1,
	'trackdefault' => 1,
	'trackduration' => 1,
	'trackentry' => 1,
	'trackerdata' => 1,
	'trackforced' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'tracklacing' => 1,
	'tracklanguage' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackmodifydate' => 1,
	'trackname' => 1,
	'trackoffset' => 1,
	'trackoverlay' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'tracktimecodescale' => 1,
	'tracktranslate' => 1,
	'tracktranslatecodec' => 1,
	'tracktranslateeditionuid' => 1,
	'tracktranslatetrackid' => 1,
	'tracktype' => 1,
	'trackuid' => 1,
	'trackused' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transferrange' => 1,
	'transformation' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentindex' => 1,
	'trapindicator' => 1,
	'trebel' => 1,
	'tvepisode' => 1,
	'tvepisodeid' => 1,
	'tvnetworkname' => 1,
	'tvseason' => 1,
	'tvshow' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'units' => 1,
	'unknown' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknowninfo' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknowntags' => 1,
	'unsharpdata' => 1,
	'unused' => 1,
	'ur3' => 1,
	'url_list' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'userselectgrouptitle' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-exif' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-prof' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendor' => 1,
	'vendorid' => 1,
	'vendorname' => 1,
	'vendorurl' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionyear' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videobitrate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videosampledesc' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'void' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wb_grgblevels' => 1,
	'wb_rgbcoeffs0' => 1,
	'wb_rgbcoeffs1' => 1,
	'wb_rgbcoeffs2' => 1,
	'wb_rgbcoeffs3' => 1,
	'wb_rgblevelsauto' => 1,
	'wb_rgblevelscloudy' => 1,
	'wb_rgblevelsdaylight' => 1,
	'wb_rgblevelsflash' => 1,
	'wb_rgblevelsfluorescent' => 1,
	'wb_rgblevelsshade' => 1,
	'wb_rgblevelstungsten' => 1,
	'wb_rgbmul0' => 1,
	'wb_rgbmul1' => 1,
	'wb_rgbmul2' => 1,
	'wb_rgbmul3' => 1,
	'wbadjdata' => 1,
	'wbinfoa100' => 1,
	'wcsprofiles' => 1,
	'weight' => 1,
	'whitebalancematching' => 1,
	'whitebalancetable' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'windowlocation' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'writer' => 1,
	'writingapp' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xml' => 1,
	'xmldata' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpextension' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xp_dip_xml' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yawangle' => 1,
	'yclippathunits' => 1,
	'year' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'ytarget' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'previewimage' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

my %specialStruct = (
    NAMESPACE   => 1,
    STRUCT_NAME => 1,
    TYPE        => 1,
    NOTES       => 1,
);

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tag names corresponding to flattened XMP tags for all structure fields
# Inputs: 0) tag table ref for flattened tags, 1) tagID, 2) lowercase tag name,
#         3) tag ID list ref, 4) reference to list of lowercase tag names
#         5) table number in lookup, 6) tagInfo hash for parent structure
#         7) tag ID of top-level stucture
# Notes: Used only for user-defined structures
sub AddFields($$$$$$;$$)
{
    my ($tagTablePtr, $tagID, $lcTag, $tagIDs, $lcTags, $tnum, $tagInfo, $baseID) = @_;
    unless ($tagInfo) {
        $tagInfo = $$tagTablePtr{$tagID};
        $baseID = $tagID;
    }
    my $strTable = $$tagInfo{Struct};
    unless (ref $strTable) {
        my $strName = $strTable;
        $strTable = $Image::ExifTool::UserDefined::xmpStruct{$strTable};
        $strTable or warn("No definition for structure '$strName'\n"), return;
        $$strTable{STRUCT_NAME} or $$strTable{STRUCT_NAME} = $strName;
        $$tagInfo{Struct} = $strTable;  # replace name with hash ref
        delete $$tagInfo{SubDirectory}; # deprecated use of SubDirectory in Struct tags
    }
    # inherit NAMESPACE from parent table if it doesn't exist
    $$strTable{NAMESPACE} = $$tagTablePtr{NAMESPACE} unless exists $$strTable{NAMESPACE};
    my $field;
    foreach $field (keys %$strTable) {
        next if $specialStruct{$field};
        my $id = $tagID . ucfirst($field);
        # use name of existing flattened tag if already defined
        my $lc = $$tagTablePtr{$id} ? lc $$tagTablePtr{$id}{Name} : $lcTag . lc($field);
        my $copyID = $baseID;
        push @$tagIDs, \$copyID, $id;
        push @$lcTags, $lc, $lc;
        my $fieldInfo = $$strTable{$field};
        next unless ref $fieldInfo eq 'HASH' and $$fieldInfo{Struct};
        # recursively add flattened tags for all sub-fields
        AddFields($tagTablePtr, $id, $lc, $tagIDs, $lcTags, $tnum, $fieldInfo, $baseID);
    }
}

#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) tag table ref, 1) table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagTablePtr, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagTablePtr)) {
            my $newInfo = $$tagTablePtr{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = ucfirst($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagTablePtr{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc $$newInfo{Name};
            my (@lcTags, @tagIDs, $existed, $isFlat);
            # if this is a structure, add all flattened tag names to lookup
            if ($$newInfo{Struct}) {
                AddFields($tagTablePtr, $tagID, $lcTag, \@tagIDs, \@lcTags, $tnum);
            }
            # add tags to lookup even though we don't know if they are writable
            # (to save speed by not having to load the module)
Tags:       for (;;) {
                my $lookup = $tagLookup{$lcTag};
                $lookup or $lookup = $tagLookup{$lcTag} = { };
                if ($$lookup{$tnum}) {
                    my $le = $$lookup{$tnum};
                    my $ids = (ref $le eq 'ARRAY') ? $le : [ $le ];
                    if (ref $tagID) {
                        # a reference points to the tag ID of the base structure for
                        # a flattened tag.  There must be only one of these,
                        # and it must come first.
                        unshift @$ids, $tagID unless ref $$ids[0];
                    # only add new tag ID if it didn't already exist
                    } elsif (grep /^$tagID$/, @$ids) {
                        $existed = 1 unless $isFlat;
                    } else {
                        push @$ids, $tagID;
                    }
                    # only update lookup if there is now more than one entry
                    $$lookup{$tnum} = $ids if @$ids > 1;
                } else {
                    $$lookup{$tnum} = $tagID;
                }
                last unless @tagIDs;
                for (;;) {
                    $tagID = shift @tagIDs;
                    $lcTag = shift @lcTags;
                    last unless $$tagTablePtr{$tagID}; # don't waste time if it exists
                    last Tags unless @tagIDs;
                }
                $isFlat = 1;
            }
            # add any new subdirectory tables (unless done already)
            next if $existed or not $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagTablePtr = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList);
    my $lookup = $tagLookup{$lcTag};
    if ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $le = $$lookup{$tableNum};
            my ($tagID, $tagIDs);
            if (ref $le eq 'ARRAY') {
                $tagIDs = $le;
                # if first entry is a reference, it indicates that this is a
                # flattened tag and refers to the tag ID of the containing top-level
                # structure, so now is the time to generate the flattened tags
                if (ref $$tagIDs[0]) {
                    # (remove from the lookup since we only need to do this once)
                    my $rootIDPtr = shift @$tagIDs;
                    require Image::ExifTool::XMP;
                    Image::ExifTool::XMP::AddFlattenedTags($table, $$rootIDPtr);
                }
            } else {
                $tagIDs = [ $le ];
            }
            foreach $tagID (@$tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    $reload = 1 if $writeProc and &$writeProc();
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2011, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
