# NAME

Dist::Zilla::Plugin::MungeFile::WithData - Modify files in the build, with templates and DATA section

# VERSION

version 0.005

# SYNOPSIS

In your `dist.ini`:

    [MungeFile::WithData]
    file = lib/My/Module.pm
    house = maison

And during the build, `lib/My/Module.pm`:

    my @stuff = qw(
        {{
            join "    \n",
            map { expensive_build_time_sub($_) }
            split(' ', $DATA)   # awk-style whitespace splitting
        }}
    );
    my ${{ $house }} = 'my castle';
    __DATA__
    alpha
    beta
    gamma

Is transformed to:

    my @stuff = qw(
        SOMETHING_WITH_ALPHA
        SOMETHING_WITH_BETA
        SOMETHING_WITH_GAMMA
    );
    my $maison = 'my castle';

# DESCRIPTION

This is a `FileMunger` plugin for [Dist::Zilla](https://metacpan.org/pod/Dist::Zilla) that passes the main module
through a [Text::Template](https://metacpan.org/pod/Text::Template), with a variable provided that contain the
content from the file's `__DATA__` section.

[Text::Template](https://metacpan.org/pod/Text::Template) is used to transform the file by making the `$DATA`
variable available to all code blocks within `{{ }}` sections.

The data section is extracted by scanning the file for `qr/^__DATA__$/`,
so this may pose a problem for you if you include this string in a here-doc or
some other construct.  However, this method means we do not have to load the
file before applying the template, which makes it much easier to construct
your templates in `.pm` files (i.e. not having to put `{{` after a comment
and inside a `do` block, as was previously required).

The [Dist::Zilla](https://metacpan.org/pod/Dist::Zilla) object (as `$dist`) and this plugin (as `$plugin`) are
also made available to the template, for extracting other information about
the build.

# OPTIONS

- `finder`

    This is the name of a [FileFinder](https://metacpan.org/pod/Dist::Zilla::Role::FileFinder) for finding
    files to modify.

    Other pre-defined finders are listed in
    ["default_finders" in Dist::Zilla::Role::FileFinderUser](https://metacpan.org/pod/Dist::Zilla::Role::FileFinderUser#default_finders).
    You can define your own with the
    [[FileFinder::ByName]](https://metacpan.org/pod/Dist::Zilla::Plugin::FileFinder::ByName) plugin.

    The default is `:MainModule`.

- `file`

    Indicates the filename in the dist to be operated upon; this file can exist on
    disk, or have been generated by some other plugin.  Can be included more than once.

    __At least one of the `finder` or `file` options is required.__

- `arbitrary option`

    All other keys/values provided will be passed to the template as is.

# BACKGROUND

This module was originally a part of the [Acme::CPANAuthors::Nonhuman](https://metacpan.org/pod/Acme::CPANAuthors::Nonhuman)
distribution, used to transform a `DATA` section containing a list of PAUSE
ids to their corresponding names, as well as embedded HTML with everyone's
avatar images.  It used to only work on `.pm` files, by first loading the
module and then reading from a filehandle created from `\*{"$pkg\::DATA"}`.
This also required the file to jump through some convoluted syntactual hoops
to ensure that the file was still compilable __before__ the template was run.
(Check it out and roll your eyes:
[https://github.com/karenetheridge/Acme-CPANAuthors-Nonhuman/blob/v0.005/lib/Acme/CPANAuthors/Nonhuman.pm#L18](https://github.com/karenetheridge/Acme-CPANAuthors-Nonhuman/blob/v0.005/lib/Acme/CPANAuthors/Nonhuman.pm#L18))

Now that we support munging all file types, we are forced to parse the file
more dumbly (by scanning for `qr/^__DATA__/`), which also removes the need
for these silly syntax games. The moral of the story is that simple code
usually __is__ better!

# SUPPORT

Bugs may be submitted through [the RT bug tracker](https://rt.cpan.org/Public/Dist/Display.html?Name=Dist-Zilla-Plugin-MungeFile::WithData)
(or [bug-Dist-Zilla-Plugin-MungeFile::WithData@rt.cpan.org](mailto:bug-Dist-Zilla-Plugin-MungeFile::WithData@rt.cpan.org)).
I am also usually active on irc, as 'ether' at `irc.perl.org`.

# SEE ALSO

- [Dist::Zilla::Plugin::Substitute](https://metacpan.org/pod/Dist::Zilla::Plugin::Substitute)
- [Dist::Zilla::Plugin::TemplateFiles](https://metacpan.org/pod/Dist::Zilla::Plugin::TemplateFiles)

# AUTHOR

Karen Etheridge <ether@cpan.org>

# COPYRIGHT AND LICENSE

This software is copyright (c) 2013 by Karen Etheridge.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.
