#!/usr/bin/perl -w 
#
# Test for IBPerl.
#
# Copyright 1998 Bill Karwin.

use strict;
use IBPerl;

my $DBPATH = 'param_insert.gdb';
my ($db, $tr, $st);

print "IBPerl version $IBPerl::VERSION\n";

print "Trying connect database...\n";
$db = new IBPerl::Connection(
    Path=>$DBPATH,
    User=>'sysdba',
    Password=>'masterkey'
);

if ($db->{Handle} < 0)
{
    print "Could not connect to $DBPATH\n$db->{Error} Trying creating database...\n";

    $db = create IBPerl::Connection(
	Path=>$DBPATH,
	User=>'sysdba',
	Password=>'masterkey'
    );
    if ($db->{Handle} < 0)
    {
	print STDERR "Could not open or create database localhost:$DBPATH\n";
	exit 1;
    }
}

if (1) # table T not exist
{
    $tr = new IBPerl::Transaction(Database=>$db);
    if ($tr->{Handle} < 0)
    {
	print "Transaction Error:\n$tr->{Error}";
	exit 1;
    }

    $st = new IBPerl::Statement(Transaction=>$tr,
	Stmt=>"CREATE TABLE T (".
	 "B BLOB SUB_TYPE 1, ".
	 "C CHAR(30), ".
	 "D DATE, ".
	 "F FLOAT, ".
	 "G DOUBLE PRECISION, ".
	 "I INTEGER, ".
	 "S SMALLINT, ".
	 "T BLOB SUB_TYPE 1, ".
	 "V VARCHAR(30))"
	);

    if ($st->{Handle} < 0)
    {
	print "Statement Error:\n$st->{Error}";
	exit 1;
    }

    if ($st->execute())
    {
	print "Statement Error:\n$st->{Error}";
	print "*** Ignored\n";
    }

    if ($tr->commit() < 0)
    {
	print "Commit Error:\n$tr->{Error}";
	exit 1;
    }
}

$tr = new IBPerl::Transaction(Database=>$db);
if ($tr->{Handle} < 0)
{
    print "Transaction Error:\n$tr->{Error}";
    exit 1;
}

$st = new IBPerl::Statement(Transaction=>$tr,
    Stmt=>"INSERT INTO T (B, C, D, F, G, I, S, T, V) ".
      "VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
if ($st->{Handle} < 0)
{
    print "Statement Error:\n$st->{Error}";
    exit 1;
}

my $ls_output = <<_BLOB_;
This is a multi-line Blob
full of words to test how
well IBPerl inserts Blob data.
_BLOB_

print "Trying to execute INSERT stmt\n";

if ($st->execute(
	# BLOB SUB_TYPE 0
	"Bill Karwin is just another Perl hacker!",

	# CHAR
	"Bill",

	# DATE
	"TODAY",

	# FLOAT
	3.14,

	# DOUBLE PRECISION
	3.1415927,

	# INTEGER
	20,

	# SMALLINT
	30,

	# BLOB SUB_TYPE TEXT
	$ls_output,

	# VARCHAR
	"Karwin"
    ) < 0)
{
    print "Statement Error:\n$st->{Error}";
    exit 1;
}
print "Statement succeeded\n";

print "Committing... ";
if ($tr->commit() < 0)
{
    print "Commit Error:\n$tr->{Error}";
    exit 1;
}
print "ok\n";

print "Disconnecting... ";
if ($db->disconnect() < 0)
{
    print "Disconnection Error:\n$db->{Error}";
    exit 1;
}
print "ok\n";

exit 0;
