#!/usr/local/bin/perl 
# Diag.pl - Example CGI script that uses IBPerl.pm version 0.2
# and CGI.pm 2.36 to provide an interface to an expert system.
#
# A sample diag.gdb database is created by running diag.sql,
# which should be distributed with this example.
#
# Copyright 1996-1999 Bill Karwin

use IBPerl;
use CGI;

$r = new CGI;
$r->autoEscape(undef);

# If no node specified, start at the top of the tree.
$node = $r->param('node')? $r->param('node'): '1';

# >Get the narrative for the specified node.
$db = new IBPerl::Connection(
	Path     => '/www/cgi-bin/data/diag.gdb',
	User     => 'sysdba',
	Password => 'masterkey');

$tr = new IBPerl::Transaction( Database => $db );
$query = 'SELECT NOTES, HITS FROM FLOWCHART WHERE NODE = ' . $node;
$st = new IBPerl::Statement( Transaction => $tr, Stmt => $query);
$st->open();
$st->fetch(\@data); # No loop; there must be only one.
($notes, $count) = @data;
$st->close();

print CGI::header();

if (!$notes) # There ain't no such node!
{
	print   CGI::start_html( -title=>'Troubleshooting System Error',
		-author=>'Bill Karwin',
		-BGCOLOR=>'Black',
		-TEXT=>'Yellow');
	$ref_url = CGI::referer();
	print   CGI::center(
		CGI::h2("Sorry, I can't help you with that.", CGI::p(),
		"Click ", CGI::a({href=>"$ref_url"}, "here"), 
		" to go back."), CGI::p());
	# Perl will invoke destructors for the IBPerl handles.
} else {

    print   CGI::start_html( -title=>'Troubleshooting',
	    -author=>'Bill Karwin',
	    -BGCOLOR=>'white'), "\n";
    print   CGI::center(
		CGI::h3("InterBase Connection Troubleshooting: Screen ", $node)
		);
    print   "<CENTER><TABLE WIDTH=50% BGCOLOR=Beige CELLPADDING=20>\n";

    print   "<TR BGCOLOR=Gold><TD>", CGI::h2( $notes ), "</TD></TR>\n";

    # Update the statistics for this node
    $query = 'UPDATE FLOWCHART SET LAST = "TODAY", HITS = ' . ($count+1) . ' WHERE NODE = ' . $node;
    $st = new IBPerl::Statement( Transaction => $tr, Stmt => $query);
    $st->execute;

    # Get the choices for the user.
    $query = 'SELECT CHOICE, LINK FROM LINKS WHERE NODE = ' . $node;
    $st = new IBPerl::Statement( Transaction => $tr, Stmt => $query );
    if ($st->open) { print "$st->{Error}\n"; };
    for ($i = 0; !$st->fetch(\@row); $i++)
    {
	    $destination[$i] = $row[1];
	    $choice{ $destination[$i] } = $row[0];
    }
    # We're done with the database now.
    if ($st->close) { print "$st->{Error}\n"; };
    $tr->commit;
    $db->disconnect;

    print   "<TR>\n<TD>\n";
    if ($i) 
    {      # Print a picklist to choose from.
	    print   CGI::startform("POST", CGI::script_name(), $CGI::URL_ENCODED), "\n";
	    print   CGI::radio_group( -name=>'node',
		    -values=>\@destination,
		    -linebreak=>'true',
		    -labels=>\%choice), CGI::p(), "\n";
	    print	CGI::center( CGI::submit(-name=>'Go') );
	    print   CGI::endform(), "\n";

    } else
    {      # No options, this must have been a leaf of the tree.
	    print   "The end.\n", CGI::p(), "\n";
	    print   "Click ", CGI::a({href=>CGI::script_name()}, "here"), 
		    " to start again.\n", CGI::p(), "\n";
    }

    print   "</TD>\n</TR>\n";

    print   "</TABLE>\n</CENTER>\n";
}


print   CGI::end_html(), "\n"; 

close(STDOUT);
exit(0);
