#!/usr/local/bin/perl -w
######################################################################
#
# IBPerl -- a Perl 5 package for SQL RDBMS
#   programming with InterBase client library.
#
# Makefile.PL
#
# Copyright (c) 1996-1999 Bill Karwin
#
# This is unsupported, free software.  Neither Bill Karwin, InterBase
# Software Corporation, nor Inprise Corporation is responsible for
# damages resulting from the use or misuse of this software.
# Test early, test well, test often.
#
# You may distribute under the terms of either the GNU General
# Public License or the Artistics License, as specified in the
# Perl README file.
#
######################################################################

use strict;
use ExtUtils::MakeMaker;
use Config;
use Carp;

my $VERSION = '0.7';
my $INC = '-I/usr/interbase/include';
my $LDDLFLAGS = '';
my $LDFROM = '$(OBJECT) handles.o';
my $LIBS = '';
my $OPT = $Config::Config{'optimize'};
my $depend = {'$(OBJECT)' => 'handles.o' };
my $CCFLAGS = '';

my $os = $Config::Config{'osname'};
carp "IBPerl $VERSION configuring for the $os platform.\n";

if ($os eq 'MSWin32') {
    $CCFLAGS = '-a4';
    $LDFROM = '$(OBJECT) handles.obj';
    $INC = "-I$Config::Config{'archlibexp'}/CORE -I\"C:/Program Files/InterBase Corp/InterBase/include\" -I\"C:/Program Files/Borland/BC5/include\"";
    $depend = {'$(OBJECT)' => 'handles.obj' };
    eval "
sub MY::const_loadlibs {
'
LDLOADLIBS = \$(LIBC) import32.lib gds32.lib
LDDLFLAGS = -L\"C:/Progra~1/InterB~1/InterB~1/lib;C:/Progra~1/Borland/BC5/lib\"
# RESFILES = IBPerl.res
'
}
    ";
}
elsif ($os eq 'solaris') {
    $LIBS = '-lgdsmt -lm -lc'; 
}
elsif ($os eq 'linux') {
    # This is for both:
    # o Free IB 4.0 for Red Hat Linux 4.2
    # o Commercial IB 5.1.1 for Red Hat Linux 5.1
    $LIBS = '-lgds -ldl';
}
elsif ($os eq 'freebsd') {
    $LIBS = '-lgds';
}
elsif ($os eq 'hpux') {
    $LIBS = '-lgds -ldld';
}
elsif ($os eq 'sco') {
    # InterBase 4.0 for SCO OSR5:
    $LIBS = '-b elf -B dynamic -lgds -lsocket -lcrypt_i';
    # InterBase 5.5 for SCO OSR5:
    # $LIBS = '-lgds -lsocket -lcrypt_i -lc -lm';
}
elsif ($os eq 'sunos') {
    $LIBS = '-lgdslib -ldl';
}
elsif ($os eq 'irix') {
    $LIBS = '-lgds -lsun';
}
elsif ($os eq 'aix') {
    $LIBS = '-lgdsshr';
}
elsif ($os eq 'dgux') {
    $LIBS = '-lgds -lgdsf -ldl -ldgc';
}
elsif ($os eq 'osf1') {
    $LIBS = '-lgds';
}
elsif ($os eq 'sysv') {
    $LIBS = '-lgds -lnsl -lsocket -ldl';
}
else {
    croak "IBPerl is not supported on platform $os.\n";
}


WriteMakefile(
    CCFLAGS	=> $CCFLAGS,
    DEFINE	=> '',
    INC		=> "$INC",
    LDDLFLAGS	=> $LDDLFLAGS,
    LDFROM	=> $LDFROM,
    LIBS	=> [ $LIBS ],
    OPTIMIZE	=> $OPT,
    NAME	=> 'IBPerl',
    VERSION	=> $VERSION,
    XSPROTOARG	=> '-noprototypes',
    depend	=> $depend,
    dist	=> {COMPRESS=>'gzip -9f', SUFFIX=>'gz'},
);
