NAME

    Code::TidyAll - Engine for tidyall, your all-in-one code tidier and
    validator

VERSION

    version 0.28

SYNOPSIS

        use Code::TidyAll;
    
        my $ct = Code::TidyAll->new_from_conf_file(
            '/path/to/conf/file',
            ...
        );
    
        # or
    
        my $ct = Code::TidyAll->new(
            root_dir => '/path/to/root',
            plugins  => {
                perltidy => {
                    select => 'lib/**/*.(pl|pm)',
                    argv => '-noll -it=2',
                },
                ...
            }
        );
    
        # then...
    
        $ct->process_paths($file1, $file2);

DESCRIPTION

    This is the engine used by tidyall - read that first to get an overview.

    You can call this API from your own program instead of executing tidyall.

CONSTRUCTION

 Constructor methods

    new (%params)

      The regular constructor. Must pass at least plugins and root_dir.

    new_with_conf_file ($conf_file, %params)

      Takes a conf file path, followed optionally by a set of key/value
      parameters. Reads parameters out of the conf file and combines them with
      the passed parameters (the latter take precedence), and calls the regular
      constructor.

      If the conf file or params defines tidyall_class, then that class is
      constructed instead of Code::TidyAll.

 Constructor parameters

    plugins

      Specify a hash of plugins, each of which is itself a hash of options.
      This is equivalent to what would be parsed out of the sections in the
      configuration file.

    cache_model_class

      The cache model class. Defaults to Code::TidyAll::CacheModel

    cache

      The cache instance (e.g. an instance of Code::TidyAll::Cache or a CHI
      instance.) An instance of Code::TidyAll::Cache is automatically
      instantiated by default.

    backup_ttl

    check_only

    data_dir

    iterations

    mode

    no_backups

    no_cache

    output_suffix

    quiet

    root_dir

    verbose

      These options are the same as the equivalent tidyall command-line
      options, replacing dashes with underscore (e.g. the backup-ttl option
      becomes backup_ttl here).

    msg_outputter

      This is a subroutine reference that is called whenever a message needs to
      be printed in some way. The sub receives a sprintf() format string
      followed by one or more parameters. The default sub used simply calls
      printf "$format\n", @_ but Test::Code::TidyAll overrides this to use the
      Test::Builder->diag method.

METHODS

    process_paths (path, ...)

      Call "process_file" on each file; descend recursively into each directory
      if the recursive flag is on. Return a list of Code::TidyAll::Result
      objects, one for each file.

    process_file (file)

      Process the file, meaning

        * Check the cache and return immediately if file has not changed

        * Apply appropriate matching plugins

        * Print success or failure result to STDOUT, depending on quiet/verbose
        settings

        * Write the cache if enabled

        * Return a Code::TidyAll::Result object

    process_source (source, path)

      Like "process_file", but process the source string instead of a file, and
      do not read from or write to the cache. You must still pass the relative
      path from the root as the second argument, so that we know which plugins
      to apply. Return a Code::TidyAll::Result object.

    plugins_for_path (path)

      Given a relative path from the root, return a list of
      Code::TidyAll::Plugin objects that apply to it, or an empty list if no
      plugins apply.

    find_conf_file (conf_names, start_dir)

      Class method. Start in the start_dir and work upwards, looking for one of
      the conf_names. Return the pathname if found or throw an error if not
      found.

    find_matched_files

      Returns a list of sorted files that match at least one plugin in
      configuration.

AUTHORS

      * Jonathan Swartz <swartz@pobox.com>

      * Dave Rolsky <autarch@urth.org>

CONTRIBUTORS

      * Andy Jack <andyjack@cpan.org>

      * George Hartzell <georgewh@gene.com>

      * Gregory Oschwald <goschwald@maxmind.com>

      * Joe Crotty <joe.crotty@returnpath.net>

      * Mark Fowler <mark@twoshortplanks.com>

      * Mark Grimes <mgrimes@cpan.org>

      * Olaf Alders <olaf@wundersolutions.com>

      * Pedro Melo <melo@simplicidade.org>

      * timgimyee <tim.gim.yee@gmail.com>

COPYRIGHT AND LICENSE

    This software is copyright (c) 2011 - 2015 by Jonathan Swartz.

    This is free software; you can redistribute it and/or modify it under the
    same terms as the Perl 5 programming language system itself.

