package Locales::DB::Language::my;

# Auto generated from CLDR

$Locales::DB::Language::my::VERSION = '0.01';

$Locales::DB::Language::my::cldr_version = '1.7.1';

%Locales::DB::Language::my::misc_info = (
    'cldr_formats' => {
        'decimal' => {
            'content' => "\#\,\#\#0\.\#\#\#",
            'draft'   => 'provisional'
        },
        'language' => "ဘာသာစကား\ \-\ \{0\}",
        'locale'   => "\{0\}\ \(\{1\}\)",
        'percent'  => {
            'content' => "\#\,\#\#0\%",
            'draft'   => 'provisional'
        },
        'territory' => "နယ်ပယ်ဒေသ\ \-\ \{0\}"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr' => {
            'content' => 'မဟုတ်ဘူး',
            'draft'   => 'provisional'
        },
        'yesstr' => {
            'content' => 'ဟုတ်တယ်',
            'draft'   => 'provisional'
        }
    },
);

%Locales::DB::Language::my::code_to_name = (
    'aa'    => 'Afar',
    'ab'    => 'Abkhazian',
    'ace'   => 'Achinese',
    'ach'   => 'Acoli',
    'ada'   => 'Adangme',
    'ady'   => 'Adyghe',
    'ae'    => 'Avestan',
    'af'    => 'Afrikaans',
    'afa'   => "Afro\-Asiatic\ Language",
    'afh'   => 'Afrihili',
    'ain'   => 'Ainu',
    'ak'    => 'Akan',
    'akk'   => 'Akkadian',
    'ale'   => 'Aleut',
    'alg'   => "Algonquian\ Language",
    'alt'   => "Southern\ Altai",
    'am'    => 'Amharic',
    'an'    => 'Aragonese',
    'ang'   => 'အင်္ဂလိပ်စာဟောင်း',
    'anp'   => 'Angika',
    'apa'   => "Apache\ Language",
    'ar'    => 'အာရေဗီ',
    'arc'   => 'Aramaic',
    'arn'   => 'Araucanian',
    'arp'   => 'Arapaho',
    'art'   => "အယောင်ဆောင်\ ဘာသာစကား",
    'arw'   => 'Arawak',
    'as'    => 'Assamese',
    'ast'   => 'Asturian',
    'ath'   => "Athapascan\ Language",
    'aus'   => "Australian\ Language",
    'av'    => 'Avaric',
    'awa'   => 'Awadhi',
    'ay'    => 'Aymara',
    'az'    => 'Azeri',
    'ba'    => 'Bashkir',
    'bad'   => 'Banda',
    'bai'   => "Bamileke\ Language",
    'bal'   => 'Baluchi',
    'ban'   => 'ဘာလီ',
    'bas'   => 'ဘာဆာ',
    'bat'   => "ဘော်လတစ်\ ဘာသာစကား",
    'be'    => 'ဘီလာရု',
    'bej'   => 'Beja',
    'bem'   => 'Bemba',
    'ber'   => 'Berber',
    'bg'    => 'ဘူဂေးရီးယား',
    'bh'    => 'Bihari',
    'bho'   => 'Bhojpuri',
    'bi'    => 'Bislama',
    'bik'   => 'Bikol',
    'bin'   => 'Bini',
    'bla'   => 'Siksika',
    'bm'    => 'Bambara',
    'bn'    => 'ဘင်္ဂါလီ',
    'bnt'   => 'Bantu',
    'bo'    => 'တိဘက်',
    'br'    => 'Breton',
    'bra'   => 'Braj',
    'bs'    => 'ဘော့စ်နီးယား',
    'btk'   => 'Batak',
    'bua'   => 'Buriat',
    'bug'   => 'Buginese',
    'byn'   => 'Blin',
    'ca'    => 'Catalan',
    'cad'   => 'Caddo',
    'cai'   => "အလယ်ပိုင်း\ အမေရိကန်\ အိန္ဒြိယ\ ဘာသာစကား",
    'car'   => 'Carib',
    'cau'   => "ကောက်ကေးရှပ်\ ဘာသာစကား",
    'cch'   => 'Atsam',
    'ce'    => 'ချေချင်း',
    'ceb'   => 'Cebuano',
    'cel'   => "Celtic\ Language",
    'ch'    => 'Chamorro',
    'chb'   => 'Chibcha',
    'chg'   => 'Chagatai',
    'chk'   => 'Chuukese',
    'chm'   => 'Mari',
    'chn'   => "Chinook\ Jargon",
    'cho'   => 'Choctaw',
    'chp'   => 'Chipewyan',
    'chr'   => 'ချာရိုကီ',
    'chy'   => 'Cheyenne',
    'cmc'   => "Chamic\ Language",
    'co'    => 'Corsican',
    'cop'   => 'Coptic',
    'cpe'   => "English\-based\ Creole\ or\ Pidgin",
    'cpf'   => "French\-based\ Creole\ or\ Pidgin",
    'cpp'   => "ပေါ်တူဂီ\ အခြေခံ\ အနောက်အိန္ဒြိယ\ ကျွန်းစုသား\ သို့မဟုတ်\ ဗန်းစကား",
    'cr'    => 'ခရီး',
    'crh'   => "Crimean\ Turkish",
    'crp'   => "အနောက်အိန္ဒြိယ\ ကျွန်းစုသား\ သို့မဟုတ်\ ဗန်းစကား",
    'cs'    => 'ချက်',
    'csb'   => 'Kashubian',
    'cu'    => "Church\ Slavic",
    'cus'   => "Cushitic\ Language",
    'cv'    => 'Chuvash',
    'cy'    => 'ဝေလ',
    'da'    => 'ဒိန်းမတ်',
    'dak'   => 'ဒါကိုတာ',
    'dar'   => 'Dargwa',
    'day'   => 'Dayak',
    'de'    => 'ဂျာမန်',
    'de_at' => "ဩစတြီးယ\ ဂျာမန်",
    'de_ch' => "ဆွစ်\ အမြင့်\ ဂျာမန်",
    'del'   => 'ဒီလာဝဲ',
    'den'   => 'Slave',
    'dgr'   => 'Dogrib',
    'din'   => 'Dinka',
    'doi'   => 'Dogri',
    'dra'   => "Dravidian\ Language",
    'dsb'   => "Lower\ Sorbian",
    'dua'   => 'Duala',
    'dum'   => "အလယ်ပိုင်း\ ဒတ်ချ်",
    'dv'    => 'Divehi',
    'dyu'   => 'Dyula',
    'dz'    => 'ဒွန်ကာ',
    'ee'    => 'Ewe',
    'efi'   => 'Efik',
    'egy'   => "ရှေးဟောင်း\ အီဂျစ်",
    'eka'   => 'Ekajuk',
    'el'    => 'ဂရိ',
    'elx'   => 'Elamite',
    'en'    => 'အင်္ဂလိပ်',
    'en_au' => "ဩစတြေးလျှ\ အင်္ဂလိပ်",
    'en_ca' => "ကနေဒါ\ အင်္ဂလိပ်",
    'en_gb' => "ဗြိတိသျှ\ အင်္ဂလိပ်",
    'en_us' => "အမေရိကန်\ အင်္ဂလိပ်",
    'enm'   => "အလယ်ပိုင်း\ အင်္ဂလိပ်",
    'eo'    => 'Esperanto',
    'es'    => 'စပိန်',
    'es_es' => "Iberian\ Spanish",
    'et'    => 'အက်စ်တိုးနီးရန်း',
    'eu'    => 'Basque',
    'ewo'   => 'Ewondo',
    'fa'    => 'ပါရှန်',
    'fan'   => 'Fang',
    'fat'   => 'Fanti',
    'ff'    => 'Fulah',
    'fi'    => 'ဖင်နစ်ရှ်',
    'fil'   => 'ဖိလစ်ပီနို',
    'fiu'   => "Finno\-Ugrian\ Language",
    'fj'    => 'ဖီဂျီ',
    'fo'    => 'Faroese',
    'fon'   => 'Fon',
    'fr'    => 'ပြင်သစ်',
    'fr_ca' => "ကနေဒါ\ ပြင်သစ်",
    'fr_ch' => "ဆွစ်\ ပြင်သစ်",
    'frm'   => 'အလယ်ပိုင်းပြင်သစ်',
    'fro'   => 'ပြင်သစ်ဟောင်း',
    'frr'   => "မြောက်ပိုင်း\ ဖရီစီရန်",
    'frs'   => "အရှေ့ပိုင်း\ ဖရီစီရန်",
    'fur'   => 'Friulian',
    'fy'    => "အနောက်ပိုင်း\ ဖရီစီရန်",
    'ga'    => 'အိုင်းရစ်',
    'gaa'   => 'Ga',
    'gay'   => 'Gayo',
    'gba'   => 'Gbaya',
    'gd'    => "Scottish\ Gaelic",
    'gem'   => "ဂျာမန်\ အခြေခံဘာသာစကား",
    'gez'   => 'Geez',
    'gil'   => 'Gilbertese',
    'gl'    => 'Galician',
    'gmh'   => 'အလယ်ပိုင်းအမြင့်ဂျာမန်',
    'gn'    => 'Guarani',
    'goh'   => "Old\ High\ German",
    'gon'   => 'Gondi',
    'gor'   => 'Gorontalo',
    'got'   => 'Gothic',
    'grb'   => 'Grebo',
    'grc'   => "ရှေးဟောင်း\ ဂရိ",
    'gsw'   => "ဆွစ်\ ဂျာမန်",
    'gu'    => 'ဂူဂျာရသီ',
    'gv'    => 'Manx',
    'gwi'   => "Gwich\Ê\¼in",
    'ha'    => 'Hausa',
    'hai'   => 'Haida',
    'haw'   => 'ဟာဝေယံ',
    'he'    => 'ဟီးဘရူး',
    'hi'    => 'ဟိန္ဒီ',
    'hil'   => 'Hiligaynon',
    'him'   => 'Himachali',
    'hit'   => 'Hittite',
    'hmn'   => 'Hmong',
    'ho'    => "Hiri\ Motu",
    'hr'    => 'ခရိုအေရှန်',
    'hsb'   => "Upper\ Sorbian",
    'ht'    => 'Haitian',
    'hu'    => 'ဟန်ဂေရီ',
    'hup'   => 'Hupa',
    'hy'    => 'Armenian',
    'hz'    => 'Herero',
    'ia'    => 'Interlingua',
    'iba'   => 'Iban',
    'id'    => 'အင်ဒိုနီးရှား',
    'ie'    => 'Interlingue',
    'ig'    => 'Igbo',
    'ii'    => "စီချွမ်\ ရီ",
    'ijo'   => 'Ijo',
    'ik'    => 'Inupiaq',
    'ilo'   => 'Iloko',
    'inc'   => "Indic\ Language",
    'ine'   => "အင်ဒို\ ဥရောပ\ ဘာသာစကား",
    'inh'   => 'Ingush',
    'io'    => 'Ido',
    'ira'   => "အီရန်\ အခြေခံ\ ဘာသာစကား",
    'iro'   => "Iroquoian\ Language",
    'is'    => 'Icelandic',
    'it'    => 'အီတလီ',
    'iu'    => 'Inuktitut',
    'ja'    => 'ဂျပန်',
    'jbo'   => 'Lojban',
    'jpr'   => "ဂျူဒီယို\-ပါရှန်",
    'jrb'   => "ဂျူဒီယို\-အာရေဗျ",
    'jv'    => 'ဂျာဗားနီးစ်',
    'ka'    => 'ဂျော်ဂျီယန်',
    'kaa'   => "Kara\-Kalpak",
    'kab'   => 'Kabyle',
    'kac'   => 'ကချင်',
    'kaj'   => 'Jju',
    'kam'   => 'Kamba',
    'kar'   => 'ကရင်',
    'kaw'   => 'Kawi',
    'kbd'   => 'Kabardian',
    'kcg'   => 'Tyap',
    'kfo'   => 'Koro',
    'kg'    => 'ကွန်ဂို',
    'kha'   => 'ခါစီ',
    'khi'   => "Khoisan\ Language",
    'kho'   => 'Khotanese',
    'ki'    => 'Kikuyu',
    'kj'    => 'Kuanyama',
    'kk'    => 'Kazakh',
    'kl'    => 'Kalaallisut',
    'km'    => 'ခမာ',
    'kmb'   => 'Kimbundu',
    'kn'    => 'ကန်နာဒါ',
    'ko'    => 'ကိုးရီးယား',
    'kok'   => 'Konkani',
    'kos'   => 'Kosraean',
    'kpe'   => 'Kpelle',
    'kr'    => 'Kanuri',
    'krc'   => "Karachay\-Balkar",
    'krl'   => 'Karelian',
    'kro'   => 'Kru',
    'kru'   => 'Kurukh',
    'ks'    => 'Kashmiri',
    'ku'    => 'ကဒ်',
    'kum'   => 'Kumyk',
    'kut'   => 'Kutenai',
    'kv'    => 'Komi',
    'kw'    => 'Cornish',
    'ky'    => 'Kirghiz',
    'la'    => 'လက်တင်',
    'lad'   => 'Ladino',
    'lah'   => 'Lahnda',
    'lam'   => 'Lamba',
    'lb'    => 'Luxembourgish',
    'lez'   => 'Lezghian',
    'lg'    => 'Ganda',
    'li'    => 'Limburgish',
    'ln'    => 'Lingala',
    'lo'    => 'လာအို',
    'lol'   => 'Mongo',
    'loz'   => 'Lozi',
    'lt'    => 'Lithuanian',
    'lu'    => "Luba\-Katanga",
    'lua'   => "Luba\-Lulua",
    'lui'   => 'Luiseno',
    'lun'   => 'Lunda',
    'luo'   => 'Luo',
    'lus'   => 'Lushai',
    'lv'    => 'Latvian',
    'mad'   => 'Madurese',
    'mag'   => 'Magahi',
    'mai'   => 'Maithili',
    'mak'   => 'Makasar',
    'man'   => 'Mandingo',
    'map'   => "Austronesian\ Language",
    'mas'   => 'Masai',
    'mdf'   => 'Moksha',
    'mdr'   => 'Mandar',
    'men'   => 'Mende',
    'mfe'   => 'Morisyen',
    'mg'    => 'Malagasy',
    'mga'   => "အလယ်ပိုင်း\ အိုင်းရစ်",
    'mh'    => 'Marshallese',
    'mi'    => 'Maori',
    'mic'   => 'Micmac',
    'min'   => 'Minangkabau',
    'mis'   => "အမျိုးမျိုးသော\ ဘာသာစကား",
    'mk'    => 'Macedonian',
    'mkh'   => "မွန်\-ခမာ\ ဘာသာစကား",
    'ml'    => 'မလေးရာလမ်',
    'mn'    => 'မွန်ဂိုလီးယန်း',
    'mnc'   => 'မန်ချူး',
    'mni'   => 'မနိပူရီ',
    'mno'   => "မနိုဘို\ ဘာသာစကား",
    'mo'    => 'Moldavian',
    'moh'   => 'Mohawk',
    'mos'   => 'Mossi',
    'mr'    => 'မာရသီ',
    'ms'    => 'မလေး',
    'mt'    => 'Maltese',
    'mul'   => "အကြိမ်များစွာ\ ဘာသာစကားများ",
    'mun'   => "Munda\ Language",
    'mus'   => 'Creek',
    'mwl'   => 'Mirandese',
    'mwr'   => 'Marwari',
    'my'    => 'ဗမာ',
    'myn'   => "Mayan\ Language",
    'myv'   => 'Erzya',
    'na'    => 'Nauru',
    'nah'   => 'Nahuatl',
    'nai'   => "North\ American\ Indian\ Language",
    'nap'   => 'Neapolitan',
    'nb'    => "Norwegian\ Bokm\Ã\¥l",
    'nd'    => "North\ Ndebele",
    'nds'   => "အနိမ့်\ ဂျာမန်",
    'ne'    => 'နီပေါလ်',
    'new'   => 'Newari',
    'ng'    => 'Ndonga',
    'nia'   => 'Nias',
    'nic'   => "Niger\-Kordofanian\ Language",
    'niu'   => 'Niuean',
    'nl'    => 'ဒတ်ချ်',
    'nl_be' => 'Flemish',
    'nn'    => "Norwegian\ Nynorsk",
    'no'    => 'နော်ဝေး',
    'nog'   => 'Nogai',
    'non'   => "Old\ Norse",
    'nqo'   => "N\â\\Ko",
    'nr'    => "South\ Ndebele",
    'nso'   => "Northern\ Sotho",
    'nub'   => "Nubian\ Language",
    'nv'    => 'Navajo',
    'nwc'   => "Classical\ Newari",
    'ny'    => 'Nyanja',
    'nym'   => 'Nyamwezi',
    'nyn'   => 'Nyankole',
    'nyo'   => 'Nyoro',
    'nzi'   => 'Nzima',
    'oc'    => 'Occitan',
    'oj'    => 'Ojibwa',
    'om'    => 'Oromo',
    'or'    => 'Oriya',
    'os'    => 'Ossetic',
    'osa'   => 'Osage',
    'ota'   => "Ottoman\ Turkish",
    'oto'   => "Otomian\ Language",
    'pa'    => 'ပန်ဂျာပီ',
    'paa'   => "ပါပူရန်\ ဘာသာစကား",
    'pag'   => 'Pangasinan',
    'pal'   => 'Pahlavi',
    'pam'   => 'Pampanga',
    'pap'   => 'Papiamento',
    'pau'   => 'Palauan',
    'peo'   => "ပါရှန်\ အဟောင်း",
    'phi'   => "ဖိလစ်ပိုင်\ ဘာသာစကား",
    'phn'   => 'Phoenician',
    'pi'    => 'ပါဠိ',
    'pl'    => 'ပိုလန်',
    'pon'   => 'Pohnpeian',
    'pra'   => "Prakrit\ Language",
    'pro'   => "Old\ Proven\Ã\§al",
    'ps'    => 'Pushto',
    'pt'    => 'ပေါ်တူဂီ',
    'pt_br' => "ဘရာဇီး\ ပေါ်တူဂီ",
    'pt_pt' => "Iberian\ Portuguese",
    'qu'    => 'Quechua',
    'raj'   => 'Rajasthani',
    'rap'   => 'Rapanui',
    'rar'   => 'Rarotongan',
    'rm'    => "Rhaeto\-Romance",
    'rn'    => 'Rundi',
    'ro'    => 'ရိုမေနီယား',
    'roa'   => "Romance\ Language",
    'rom'   => 'Romany',
    'ru'    => 'ရုရှ',
    'rup'   => 'Aromanian',
    'rw'    => 'Kinyarwanda',
    'sa'    => 'သင်္သကရိုက်',
    'sad'   => 'Sandawe',
    'sah'   => 'Yakut',
    'sai'   => "တောင်\ အမေရိကန်\ အိန္ဒြိယ\ ဘာသာစကား",
    'sal'   => "Salishan\ Language",
    'sam'   => "Samaritan\ Aramaic",
    'sas'   => 'Sasak',
    'sat'   => 'Santali',
    'sc'    => 'Sardinian',
    'scn'   => 'Sicilian',
    'sco'   => 'စကော့',
    'sd'    => 'စင်ဒီ',
    'se'    => "Northern\ Sami",
    'sel'   => 'Selkup',
    'sem'   => "Semitic\ Language",
    'sg'    => 'Sango',
    'sga'   => "အိုင်းရစ်\ ဟောင်း",
    'sgn'   => "အချက်ပြ\ ဘာသာစကား",
    'sh'    => "Serbo\-Croatian",
    'shn'   => 'ရှမ်း',
    'si'    => 'ဆင်ဟာလ',
    'sid'   => 'Sidamo',
    'sio'   => "Siouan\ Language",
    'sit'   => "တရုတ်\-တိဘက်\ ဘာသာစကား",
    'sk'    => 'စလိုဗက်',
    'sl'    => 'စလိုဗေးနီးယမ်း',
    'sla'   => "စလိုဗစ်\ ဘာသာစကား",
    'sm'    => 'Samoan',
    'sma'   => "တောင်ပိုင်း\ ဆာမိ",
    'smi'   => "ဆာမိ\ ဘာသာစကား",
    'smj'   => "Lule\ Sami",
    'smn'   => "Inari\ Sami",
    'sms'   => "Skolt\ Sami",
    'sn'    => 'Shona',
    'snk'   => 'Soninke',
    'so'    => 'ဆိုမာလီ',
    'sog'   => 'Sogdien',
    'son'   => 'Songhai',
    'sq'    => 'အယ်လ်ဘေးနီးယန်း',
    'sr'    => 'ဆားဗီးယန်း',
    'srn'   => "Sranan\ Tongo",
    'srr'   => 'Serer',
    'ss'    => 'Swati',
    'ssa'   => "Nilo\-Saharan\ Language",
    'st'    => "Southern\ Sotho",
    'su'    => 'ဆူဒန်',
    'suk'   => 'Sukuma',
    'sus'   => 'Susu',
    'sux'   => 'Sumerian',
    'sv'    => 'ဆွီဒင်',
    'sw'    => 'Swahili',
    'syc'   => "Classical\ Syriac",
    'syr'   => 'Syriac',
    'ta'    => 'တမီးလ်',
    'tai'   => "တိုင်\ ဘာသာစကား",
    'te'    => 'Telugu',
    'tem'   => 'Timne',
    'ter'   => 'Tereno',
    'tet'   => 'Tetum',
    'tg'    => 'Tajik',
    'th'    => 'ထိုင်း',
    'ti'    => 'Tigrinya',
    'tig'   => 'Tigre',
    'tiv'   => 'Tiv',
    'tk'    => 'Turkmen',
    'tkl'   => 'Tokelau',
    'tl'    => 'Tagalog',
    'tlh'   => 'Klingon',
    'tli'   => 'Tlingit',
    'tmh'   => 'Tamashek',
    'tn'    => 'Tswana',
    'to'    => 'Tonga',
    'tog'   => "Nyasa\ Tonga",
    'tpi'   => "Tok\ Pisin",
    'tr'    => 'Turkish',
    'trv'   => 'Taroko',
    'ts'    => 'Tsonga',
    'tsi'   => 'Tsimshian',
    'tt'    => 'Tatar',
    'tum'   => 'Tumbuka',
    'tup'   => "တူပီ\ ဘာသာစကား",
    'tut'   => "Altaic\ Language",
    'tvl'   => 'Tuvalu',
    'tw'    => 'Twi',
    'ty'    => 'Tahitian',
    'tyv'   => 'Tuvinian',
    'udm'   => 'Udmurt',
    'ug'    => 'Uyghur',
    'uga'   => 'Ugaritic',
    'uk'    => 'ယူကရိန်း',
    'umb'   => 'Umbundu',
    'und'   => "မသိ\ သို့မဟုတ်\ မရှိ\ သော\ ဘာသာစကား",
    'ur'    => 'Urdu',
    'uz'    => 'Uzbek',
    'vai'   => 'Vai',
    've'    => 'Venda',
    'vi'    => 'ဗီယက်နမ်',
    'vo'    => "Volap\Ã\¼k",
    'vot'   => 'Votic',
    'wa'    => 'Walloon',
    'wak'   => "Wakashan\ Language",
    'wal'   => 'Walamo',
    'war'   => 'Waray',
    'was'   => 'Washo',
    'wen'   => "Sorbian\ Language",
    'wo'    => 'Wolof',
    'xal'   => 'Kalmyk',
    'xh'    => 'Xhosa',
    'yao'   => 'Yao',
    'yap'   => 'Yapese',
    'yi'    => 'Yiddish',
    'yo'    => 'Yoruba',
    'ypk'   => "Yupik\ Language",
    'za'    => 'Zhuang',
    'zap'   => 'Zapotec',
    'zbl'   => 'Blissymbols',
    'zen'   => 'Zenaga',
    'zh'    => 'တရုတ်',
    'znd'   => 'Zande',
    'zu'    => 'ဇူလူ',
    'zun'   => 'Zuni',
    'zxx'   => "ဘာသာစကား\ နှင့်\ ပတ်သက်\ သောအရာမရှိ",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::my::name_to_code = (
    ''                                  => 'zu',
    "\ "                                => 'tup',
    "\ \ "                              => 'ira',
    "\ \ \ "                            => 'zxx',
    "\ \ \ \ "                          => 'und',
    "\ \ \ \ \ "                        => 'cpp',
    'abkhazian'                         => 'ab',
    'achinese'                          => 'ace',
    'acoli'                             => 'ach',
    'adangme'                           => 'ada',
    'adyghe'                            => 'ady',
    'afar'                              => 'aa',
    'afrihili'                          => 'afh',
    'afrikaans'                         => 'af',
    "afroasiatic\ language"             => 'afa',
    'ainu'                              => 'ain',
    'akan'                              => 'ak',
    'akkadian'                          => 'akk',
    'aleut'                             => 'ale',
    "algonquian\ language"              => 'alg',
    "altaic\ language"                  => 'tut',
    'amharic'                           => 'am',
    'angika'                            => 'anp',
    "apache\ language"                  => 'apa',
    'aragonese'                         => 'an',
    'aramaic'                           => 'arc',
    'arapaho'                           => 'arp',
    'araucanian'                        => 'arn',
    'arawak'                            => 'arw',
    'armenian'                          => 'hy',
    'aromanian'                         => 'rup',
    'assamese'                          => 'as',
    'asturian'                          => 'ast',
    "athapascan\ language"              => 'ath',
    'atsam'                             => 'cch',
    "australian\ language"              => 'aus',
    "austronesian\ language"            => 'map',
    'avaric'                            => 'av',
    'avestan'                           => 'ae',
    'awadhi'                            => 'awa',
    'aymara'                            => 'ay',
    'azeri'                             => 'az',
    'baluchi'                           => 'bal',
    'bambara'                           => 'bm',
    "bamileke\ language"                => 'bai',
    'banda'                             => 'bad',
    'bantu'                             => 'bnt',
    'bashkir'                           => 'ba',
    'basque'                            => 'eu',
    'batak'                             => 'btk',
    'beja'                              => 'bej',
    'bemba'                             => 'bem',
    'berber'                            => 'ber',
    'bhojpuri'                          => 'bho',
    'bihari'                            => 'bh',
    'bikol'                             => 'bik',
    'bini'                              => 'bin',
    'bislama'                           => 'bi',
    'blin'                              => 'byn',
    'blissymbols'                       => 'zbl',
    'braj'                              => 'bra',
    'breton'                            => 'br',
    'buginese'                          => 'bug',
    'buriat'                            => 'bua',
    'caddo'                             => 'cad',
    'carib'                             => 'car',
    'catalan'                           => 'ca',
    'cebuano'                           => 'ceb',
    "celtic\ language"                  => 'cel',
    'chagatai'                          => 'chg',
    "chamic\ language"                  => 'cmc',
    'chamorro'                          => 'ch',
    'cheyenne'                          => 'chy',
    'chibcha'                           => 'chb',
    "chinook\ jargon"                   => 'chn',
    'chipewyan'                         => 'chp',
    'choctaw'                           => 'cho',
    "church\ slavic"                    => 'cu',
    'chuukese'                          => 'chk',
    'chuvash'                           => 'cv',
    "classical\ newari"                 => 'nwc',
    "classical\ syriac"                 => 'syc',
    'coptic'                            => 'cop',
    'cornish'                           => 'kw',
    'corsican'                          => 'co',
    'creek'                             => 'mus',
    "crimean\ turkish"                  => 'crh',
    "cushitic\ language"                => 'cus',
    'dargwa'                            => 'dar',
    'dayak'                             => 'day',
    'dinka'                             => 'din',
    'divehi'                            => 'dv',
    'dogri'                             => 'doi',
    'dogrib'                            => 'dgr',
    "dravidian\ language"               => 'dra',
    'duala'                             => 'dua',
    'dyula'                             => 'dyu',
    'efik'                              => 'efi',
    'ekajuk'                            => 'eka',
    'elamite'                           => 'elx',
    "englishbased\ creole\ or\ pidgin"  => 'cpe',
    'erzya'                             => 'myv',
    'esperanto'                         => 'eo',
    'ewe'                               => 'ee',
    'ewondo'                            => 'ewo',
    'fang'                              => 'fan',
    'fanti'                             => 'fat',
    'faroese'                           => 'fo',
    "finnougrian\ language"             => 'fiu',
    'flemish'                           => 'nl_be',
    'fon'                               => 'fon',
    "frenchbased\ creole\ or\ pidgin"   => 'cpf',
    'friulian'                          => 'fur',
    'fulah'                             => 'ff',
    'ga'                                => 'gaa',
    'galician'                          => 'gl',
    'ganda'                             => 'lg',
    'gayo'                              => 'gay',
    'gbaya'                             => 'gba',
    'geez'                              => 'gez',
    'gilbertese'                        => 'gil',
    'gondi'                             => 'gon',
    'gorontalo'                         => 'gor',
    'gothic'                            => 'got',
    'grebo'                             => 'grb',
    'guarani'                           => 'gn',
    'gwichin'                           => 'gwi',
    'haida'                             => 'hai',
    'haitian'                           => 'ht',
    'hausa'                             => 'ha',
    'herero'                            => 'hz',
    'hiligaynon'                        => 'hil',
    'himachali'                         => 'him',
    "hiri\ motu"                        => 'ho',
    'hittite'                           => 'hit',
    'hmong'                             => 'hmn',
    'hupa'                              => 'hup',
    'iban'                              => 'iba',
    "iberian\ portuguese"               => 'pt_pt',
    "iberian\ spanish"                  => 'es_es',
    'icelandic'                         => 'is',
    'ido'                               => 'io',
    'igbo'                              => 'ig',
    'ijo'                               => 'ijo',
    'iloko'                             => 'ilo',
    "inari\ sami"                       => 'smn',
    "indic\ language"                   => 'inc',
    'ingush'                            => 'inh',
    'interlingua'                       => 'ia',
    'interlingue'                       => 'ie',
    'inuktitut'                         => 'iu',
    'inupiaq'                           => 'ik',
    "iroquoian\ language"               => 'iro',
    'jju'                               => 'kaj',
    'kabardian'                         => 'kbd',
    'kabyle'                            => 'kab',
    'kalaallisut'                       => 'kl',
    'kalmyk'                            => 'xal',
    'kamba'                             => 'kam',
    'kanuri'                            => 'kr',
    'karachaybalkar'                    => 'krc',
    'karakalpak'                        => 'kaa',
    'karelian'                          => 'krl',
    'kashmiri'                          => 'ks',
    'kashubian'                         => 'csb',
    'kawi'                              => 'kaw',
    'kazakh'                            => 'kk',
    "khoisan\ language"                 => 'khi',
    'khotanese'                         => 'kho',
    'kikuyu'                            => 'ki',
    'kimbundu'                          => 'kmb',
    'kinyarwanda'                       => 'rw',
    'kirghiz'                           => 'ky',
    'klingon'                           => 'tlh',
    'komi'                              => 'kv',
    'konkani'                           => 'kok',
    'koro'                              => 'kfo',
    'kosraean'                          => 'kos',
    'kpelle'                            => 'kpe',
    'kru'                               => 'kro',
    'kuanyama'                          => 'kj',
    'kumyk'                             => 'kum',
    'kurukh'                            => 'kru',
    'kutenai'                           => 'kut',
    'ladino'                            => 'lad',
    'lahnda'                            => 'lah',
    'lamba'                             => 'lam',
    'latvian'                           => 'lv',
    'lezghian'                          => 'lez',
    'limburgish'                        => 'li',
    'lingala'                           => 'ln',
    'lithuanian'                        => 'lt',
    'lojban'                            => 'jbo',
    "lower\ sorbian"                    => 'dsb',
    'lozi'                              => 'loz',
    'lubakatanga'                       => 'lu',
    'lubalulua'                         => 'lua',
    'luiseno'                           => 'lui',
    "lule\ sami"                        => 'smj',
    'lunda'                             => 'lun',
    'luo'                               => 'luo',
    'lushai'                            => 'lus',
    'luxembourgish'                     => 'lb',
    'macedonian'                        => 'mk',
    'madurese'                          => 'mad',
    'magahi'                            => 'mag',
    'maithili'                          => 'mai',
    'makasar'                           => 'mak',
    'malagasy'                          => 'mg',
    'maltese'                           => 'mt',
    'mandar'                            => 'mdr',
    'mandingo'                          => 'man',
    'manx'                              => 'gv',
    'maori'                             => 'mi',
    'mari'                              => 'chm',
    'marshallese'                       => 'mh',
    'marwari'                           => 'mwr',
    'masai'                             => 'mas',
    "mayan\ language"                   => 'myn',
    'mende'                             => 'men',
    'micmac'                            => 'mic',
    'minangkabau'                       => 'min',
    'mirandese'                         => 'mwl',
    'mohawk'                            => 'moh',
    'moksha'                            => 'mdf',
    'moldavian'                         => 'mo',
    'mongo'                             => 'lol',
    'morisyen'                          => 'mfe',
    'mossi'                             => 'mos',
    "munda\ language"                   => 'mun',
    'nahuatl'                           => 'nah',
    'nauru'                             => 'na',
    'navajo'                            => 'nv',
    'ndonga'                            => 'ng',
    'neapolitan'                        => 'nap',
    'newari'                            => 'new',
    'nias'                              => 'nia',
    "nigerkordofanian\ language"        => 'nic',
    "nilosaharan\ language"             => 'ssa',
    'niuean'                            => 'niu',
    'nko'                               => 'nqo',
    'nogai'                             => 'nog',
    "north\ american\ indian\ language" => 'nai',
    "north\ ndebele"                    => 'nd',
    "northern\ sami"                    => 'se',
    "northern\ sotho"                   => 'nso',
    "norwegian\ bokml"                  => 'nb',
    "norwegian\ nynorsk"                => 'nn',
    "nubian\ language"                  => 'nub',
    'nyamwezi'                          => 'nym',
    'nyanja'                            => 'ny',
    'nyankole'                          => 'nyn',
    "nyasa\ tonga"                      => 'tog',
    'nyoro'                             => 'nyo',
    'nzima'                             => 'nzi',
    'occitan'                           => 'oc',
    'ojibwa'                            => 'oj',
    "old\ high\ german"                 => 'goh',
    "old\ norse"                        => 'non',
    "old\ provenal"                     => 'pro',
    'oriya'                             => 'or',
    'oromo'                             => 'om',
    'osage'                             => 'osa',
    'ossetic'                           => 'os',
    "otomian\ language"                 => 'oto',
    "ottoman\ turkish"                  => 'ota',
    'pahlavi'                           => 'pal',
    'palauan'                           => 'pau',
    'pampanga'                          => 'pam',
    'pangasinan'                        => 'pag',
    'papiamento'                        => 'pap',
    'phoenician'                        => 'phn',
    'pohnpeian'                         => 'pon',
    "prakrit\ language"                 => 'pra',
    'pushto'                            => 'ps',
    'quechua'                           => 'qu',
    'rajasthani'                        => 'raj',
    'rapanui'                           => 'rap',
    'rarotongan'                        => 'rar',
    'rhaetoromance'                     => 'rm',
    "romance\ language"                 => 'roa',
    'romany'                            => 'rom',
    'rundi'                             => 'rn',
    "salishan\ language"                => 'sal',
    "samaritan\ aramaic"                => 'sam',
    'samoan'                            => 'sm',
    'sandawe'                           => 'sad',
    'sango'                             => 'sg',
    'santali'                           => 'sat',
    'sardinian'                         => 'sc',
    'sasak'                             => 'sas',
    "scottish\ gaelic"                  => 'gd',
    'selkup'                            => 'sel',
    "semitic\ language"                 => 'sem',
    'serbocroatian'                     => 'sh',
    'serer'                             => 'srr',
    'shona'                             => 'sn',
    'sicilian'                          => 'scn',
    'sidamo'                            => 'sid',
    'siksika'                           => 'bla',
    "siouan\ language"                  => 'sio',
    "skolt\ sami"                       => 'sms',
    'slave'                             => 'den',
    'sogdien'                           => 'sog',
    'songhai'                           => 'son',
    'soninke'                           => 'snk',
    "sorbian\ language"                 => 'wen',
    "south\ ndebele"                    => 'nr',
    "southern\ altai"                   => 'alt',
    "southern\ sotho"                   => 'st',
    "sranan\ tongo"                     => 'srn',
    'sukuma'                            => 'suk',
    'sumerian'                          => 'sux',
    'susu'                              => 'sus',
    'swahili'                           => 'sw',
    'swati'                             => 'ss',
    'syriac'                            => 'syr',
    'tagalog'                           => 'tl',
    'tahitian'                          => 'ty',
    'tajik'                             => 'tg',
    'tamashek'                          => 'tmh',
    'taroko'                            => 'trv',
    'tatar'                             => 'tt',
    'telugu'                            => 'te',
    'tereno'                            => 'ter',
    'tetum'                             => 'tet',
    'tigre'                             => 'tig',
    'tigrinya'                          => 'ti',
    'timne'                             => 'tem',
    'tiv'                               => 'tiv',
    'tlingit'                           => 'tli',
    "tok\ pisin"                        => 'tpi',
    'tokelau'                           => 'tkl',
    'tonga'                             => 'to',
    'tsimshian'                         => 'tsi',
    'tsonga'                            => 'ts',
    'tswana'                            => 'tn',
    'tumbuka'                           => 'tum',
    'turkish'                           => 'tr',
    'turkmen'                           => 'tk',
    'tuvalu'                            => 'tvl',
    'tuvinian'                          => 'tyv',
    'twi'                               => 'tw',
    'tyap'                              => 'kcg',
    'udmurt'                            => 'udm',
    'ugaritic'                          => 'uga',
    'umbundu'                           => 'umb',
    "upper\ sorbian"                    => 'hsb',
    'urdu'                              => 'ur',
    'uyghur'                            => 'ug',
    'uzbek'                             => 'uz',
    'vai'                               => 'vai',
    'venda'                             => 've',
    'volapk'                            => 'vo',
    'votic'                             => 'vot',
    "wakashan\ language"                => 'wak',
    'walamo'                            => 'wal',
    'walloon'                           => 'wa',
    'waray'                             => 'war',
    'washo'                             => 'was',
    'wolof'                             => 'wo',
    'xhosa'                             => 'xh',
    'yakut'                             => 'sah',
    'yao'                               => 'yao',
    'yapese'                            => 'yap',
    'yiddish'                           => 'yi',
    'yoruba'                            => 'yo',
    "yupik\ language"                   => 'ypk',
    'zande'                             => 'znd',
    'zapotec'                           => 'zap',
    'zaza'                              => 'zza',
    'zenaga'                            => 'zen',
    'zhuang'                            => 'za',
    'zuni'                              => 'zun',
);

1;
