package Locales::DB::Language::kok;

# Auto generated from CLDR

$Locales::DB::Language::kok::VERSION = '0.01';

$Locales::DB::Language::kok::cldr_version = '1.7.1';

%Locales::DB::Language::kok::misc_info = (
    'cldr_formats' => {
        'decimal'   => "\#\,\#\#\,\#\#0\.\#\#\#",
        'language'  => "Language\:\ \{0\}",
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#\,\#\#0\%",
        'territory' => "Region\:\ \{0\}"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr'  => "no\:n",
        'yesstr' => "yes\:y"
    },
);

%Locales::DB::Language::kok::code_to_name = (
    'aa'    => 'अफार',
    'ab'    => 'अबखेज़ियन',
    'ace'   => 'Achinese',
    'ach'   => 'Acoli',
    'ada'   => 'Adangme',
    'ady'   => 'Adyghe',
    'ae'    => 'Avestan',
    'af'    => 'अफ्रिकान्स',
    'afa'   => "Afro\-Asiatic\ Language",
    'afh'   => 'Afrihili',
    'ain'   => 'Ainu',
    'ak'    => 'Akan',
    'akk'   => 'Akkadian',
    'ale'   => 'Aleut',
    'alg'   => "Algonquian\ Language",
    'alt'   => "Southern\ Altai",
    'am'    => 'अमहारिक्',
    'an'    => 'Aragonese',
    'ang'   => "Old\ English",
    'anp'   => 'Angika',
    'apa'   => "Apache\ Language",
    'ar'    => 'अरेबिक्',
    'arc'   => 'Aramaic',
    'arn'   => 'Araucanian',
    'arp'   => 'Arapaho',
    'art'   => "Artificial\ Language",
    'arw'   => 'Arawak',
    'as'    => 'असामी',
    'ast'   => 'Asturian',
    'ath'   => "Athapascan\ Language",
    'aus'   => "Australian\ Language",
    'av'    => 'Avaric',
    'awa'   => 'Awadhi',
    'ay'    => 'ऐमरा',
    'az'    => 'अज़रबैजानी',
    'ba'    => 'बष्किर',
    'bad'   => 'Banda',
    'bai'   => "Bamileke\ Language",
    'bal'   => 'Baluchi',
    'ban'   => 'Balinese',
    'bas'   => 'Basa',
    'bat'   => "Baltic\ Language",
    'be'    => 'बैलोरुसियन्',
    'bej'   => 'Beja',
    'bem'   => 'Bemba',
    'ber'   => 'Berber',
    'bg'    => 'बल्गेरियन',
    'bh'    => 'बीहारी',
    'bho'   => 'Bhojpuri',
    'bi'    => 'बिसलमा',
    'bik'   => 'Bikol',
    'bin'   => 'Bini',
    'bla'   => 'Siksika',
    'bm'    => 'Bambara',
    'bn'    => 'बंगाली',
    'bnt'   => 'Bantu',
    'bo'    => 'तिबेतियन',
    'br'    => 'ब्रेटन',
    'bra'   => 'Braj',
    'bs'    => 'Bosnian',
    'btk'   => 'Batak',
    'bua'   => 'Buriat',
    'bug'   => 'Buginese',
    'byn'   => 'Blin',
    'ca'    => 'कटलान',
    'cad'   => 'Caddo',
    'cai'   => "Central\ American\ Indian\ Language",
    'car'   => 'Carib',
    'cau'   => "Caucasian\ Language",
    'cch'   => 'Atsam',
    'ce'    => 'Chechen',
    'ceb'   => 'Cebuano',
    'cel'   => "Celtic\ Language",
    'ch'    => 'Chamorro',
    'chb'   => 'Chibcha',
    'chg'   => 'Chagatai',
    'chk'   => 'Chuukese',
    'chm'   => 'Mari',
    'chn'   => "Chinook\ Jargon",
    'cho'   => 'Choctaw',
    'chp'   => 'Chipewyan',
    'chr'   => 'Cherokee',
    'chy'   => 'Cheyenne',
    'cmc'   => "Chamic\ Language",
    'co'    => 'कोर्शियन',
    'cop'   => 'Coptic',
    'cpe'   => "English\-based\ Creole\ or\ Pidgin",
    'cpf'   => "French\-based\ Creole\ or\ Pidgin",
    'cpp'   => "Portuguese\-based\ Creole\ or\ Pidgin",
    'cr'    => 'Cree',
    'crh'   => "Crimean\ Turkish",
    'crp'   => "Creole\ or\ Pidgin",
    'cs'    => 'ज़ेक्',
    'csb'   => 'Kashubian',
    'cu'    => "Church\ Slavic",
    'cus'   => "Cushitic\ Language",
    'cv'    => 'Chuvash',
    'cy'    => 'वेळ्ष्',
    'da'    => 'डानिष',
    'dak'   => 'Dakota',
    'dar'   => 'Dargwa',
    'day'   => 'Dayak',
    'de'    => 'जर्मन',
    'de_at' => "Austrian\ German",
    'de_ch' => "Swiss\ High\ German",
    'del'   => 'Delaware',
    'den'   => 'Slave',
    'dgr'   => 'Dogrib',
    'din'   => 'Dinka',
    'doi'   => 'Dogri',
    'dra'   => "Dravidian\ Language",
    'dsb'   => "Lower\ Sorbian",
    'dua'   => 'Duala',
    'dum'   => "Middle\ Dutch",
    'dv'    => 'Divehi',
    'dyu'   => 'Dyula',
    'dz'    => 'भूटानी',
    'ee'    => 'Ewe',
    'efi'   => 'Efik',
    'egy'   => "Ancient\ Egyptian",
    'eka'   => 'Ekajuk',
    'el'    => 'ग्रीक्',
    'elx'   => 'Elamite',
    'en'    => 'आंग्ल',
    'en_au' => "Australian\ English",
    'en_ca' => "Canadian\ English",
    'en_gb' => "British\ English",
    'en_us' => "U\.S\.\ English",
    'enm'   => "Middle\ English",
    'eo'    => 'इस्परान्टो',
    'es'    => 'स्पानिष',
    'es_es' => "Iberian\ Spanish",
    'et'    => 'इस्टोनियन्',
    'eu'    => 'बास्क',
    'ewo'   => 'Ewondo',
    'fa'    => 'पर्षियन्',
    'fan'   => 'Fang',
    'fat'   => 'Fanti',
    'ff'    => 'Fulah',
    'fi'    => 'फिन्निष्',
    'fil'   => 'Filipino',
    'fiu'   => "Finno\-Ugrian\ Language",
    'fj'    => 'फिजी',
    'fo'    => 'फेरोस्',
    'fon'   => 'Fon',
    'fr'    => 'फ्रेन्च',
    'fr_ca' => "Canadian\ French",
    'fr_ch' => "Swiss\ French",
    'frm'   => "Middle\ French",
    'fro'   => "Old\ French",
    'frr'   => "Northern\ Frisian",
    'frs'   => "Eastern\ Frisian",
    'fur'   => 'Friulian',
    'fy'    => 'फ्रिशियन्',
    'ga'    => 'ऐरिष',
    'gaa'   => 'Ga',
    'gay'   => 'Gayo',
    'gba'   => 'Gbaya',
    'gd'    => "स्काटस्\ गेलिक्",
    'gem'   => "Germanic\ Language",
    'gez'   => 'Geez',
    'gil'   => 'Gilbertese',
    'gl'    => 'गेलीशियन',
    'gmh'   => "Middle\ High\ German",
    'gn'    => 'गौरानी',
    'goh'   => "Old\ High\ German",
    'gon'   => 'Gondi',
    'gor'   => 'Gorontalo',
    'got'   => 'Gothic',
    'grb'   => 'Grebo',
    'grc'   => "Ancient\ Greek",
    'gsw'   => "Swiss\ German",
    'gu'    => 'गुजराती',
    'gv'    => 'Manx',
    'gwi'   => "Gwich\Ê\¼in",
    'ha'    => 'हौसा',
    'hai'   => 'Haida',
    'haw'   => 'Hawaiian',
    'he'    => 'हेब्रु',
    'hi'    => 'हिन्दी',
    'hil'   => 'Hiligaynon',
    'him'   => 'Himachali',
    'hit'   => 'Hittite',
    'hmn'   => 'Hmong',
    'ho'    => "Hiri\ Motu",
    'hr'    => 'क्रोयेषियन्',
    'hsb'   => "Upper\ Sorbian",
    'ht'    => 'Haitian',
    'hu'    => 'हंगेरियन्',
    'hup'   => 'Hupa',
    'hy'    => 'आर्मीनियन्',
    'hz'    => 'Herero',
    'ia'    => 'इन्टरलिंग्वा',
    'iba'   => 'Iban',
    'id'    => 'इन्डोनेषियन',
    'ie'    => 'इन्टरलिंग्',
    'ig'    => 'Igbo',
    'ii'    => "Sichuan\ Yi",
    'ijo'   => 'Ijo',
    'ik'    => 'इनूपेयाक्',
    'ilo'   => 'Iloko',
    'inc'   => "Indic\ Language",
    'ine'   => "Indo\-European\ Language",
    'inh'   => 'Ingush',
    'io'    => 'Ido',
    'ira'   => "Iranian\ Language",
    'iro'   => "Iroquoian\ Language",
    'is'    => 'आईस्लान्डिक',
    'it'    => 'इटालियन',
    'iu'    => 'इन्युकट्ट',
    'ja'    => 'जापनीस्',
    'jbo'   => 'Lojban',
    'jpr'   => "Judeo\-Persian",
    'jrb'   => "Judeo\-Arabic",
    'jv'    => 'जावनीस्',
    'ka'    => 'जार्जियन्',
    'kaa'   => "Kara\-Kalpak",
    'kab'   => 'Kabyle',
    'kac'   => 'Kachin',
    'kaj'   => 'Jju',
    'kam'   => 'Kamba',
    'kar'   => 'Karen',
    'kaw'   => 'Kawi',
    'kbd'   => 'Kabardian',
    'kcg'   => 'Tyap',
    'kfo'   => 'Koro',
    'kg'    => 'Kongo',
    'kha'   => 'Khasi',
    'khi'   => "Khoisan\ Language",
    'kho'   => 'Khotanese',
    'ki'    => 'Kikuyu',
    'kj'    => 'Kuanyama',
    'kk'    => 'कज़ख्',
    'kl'    => 'ग्रीनलान्डिक',
    'km'    => 'कंबोडियन',
    'kmb'   => 'Kimbundu',
    'kn'    => 'कन्नडा',
    'ko'    => 'कोरियन्',
    'kok'   => 'कोंकणी',
    'kos'   => 'Kosraean',
    'kpe'   => 'Kpelle',
    'kr'    => 'Kanuri',
    'krc'   => "Karachay\-Balkar",
    'krl'   => 'Karelian',
    'kro'   => 'Kru',
    'kru'   => 'Kurukh',
    'ks'    => 'कश्मीरी',
    'ku'    => 'कुर्दिष',
    'kum'   => 'Kumyk',
    'kut'   => 'Kutenai',
    'kv'    => 'Komi',
    'kw'    => 'Cornish',
    'ky'    => 'किर्गिज़',
    'la'    => 'लाटिन',
    'lad'   => 'Ladino',
    'lah'   => 'Lahnda',
    'lam'   => 'Lamba',
    'lb'    => 'Luxembourgish',
    'lez'   => 'Lezghian',
    'lg'    => 'Ganda',
    'li'    => 'Limburgish',
    'ln'    => 'लिंगाला',
    'lo'    => 'लाओतियन्',
    'lol'   => 'Mongo',
    'loz'   => 'Lozi',
    'lt'    => 'लिथुआनियन्',
    'lu'    => "Luba\-Katanga",
    'lua'   => "Luba\-Lulua",
    'lui'   => 'Luiseno',
    'lun'   => 'Lunda',
    'luo'   => 'Luo',
    'lus'   => 'Lushai',
    'lv'    => "लाट्वियन्\ \(लेट्टिष्\)",
    'mad'   => 'Madurese',
    'mag'   => 'Magahi',
    'mai'   => 'Maithili',
    'mak'   => 'Makasar',
    'man'   => 'Mandingo',
    'map'   => "Austronesian\ Language",
    'mas'   => 'Masai',
    'mdf'   => 'Moksha',
    'mdr'   => 'Mandar',
    'men'   => 'Mende',
    'mfe'   => 'Morisyen',
    'mg'    => 'मलागसी',
    'mga'   => "Middle\ Irish",
    'mh'    => 'Marshallese',
    'mi'    => 'माओरी',
    'mic'   => 'Micmac',
    'min'   => 'Minangkabau',
    'mis'   => "Miscellaneous\ Language",
    'mk'    => 'मसीडोनियन्',
    'mkh'   => "Mon\-Khmer\ Language",
    'ml'    => 'मळियाळम',
    'mn'    => 'मंगोलियन्',
    'mnc'   => 'Manchu',
    'mni'   => 'Manipuri',
    'mno'   => "Manobo\ Language",
    'mo'    => 'मोल्डावियन्',
    'moh'   => 'Mohawk',
    'mos'   => 'Mossi',
    'mr'    => 'मराठी',
    'ms'    => 'मलय',
    'mt'    => 'मालतीस्',
    'mul'   => "Multiple\ Languages",
    'mun'   => "Munda\ Language",
    'mus'   => 'Creek',
    'mwl'   => 'Mirandese',
    'mwr'   => 'Marwari',
    'my'    => 'बर्मीज़्',
    'myn'   => "Mayan\ Language",
    'myv'   => 'Erzya',
    'na'    => 'नौरो',
    'nah'   => 'Nahuatl',
    'nai'   => "North\ American\ Indian\ Language",
    'nap'   => 'Neapolitan',
    'nb'    => "Norwegian\ Bokm\Ã\¥l",
    'nd'    => "North\ Ndebele",
    'nds'   => "Low\ German",
    'ne'    => 'नेपाळी',
    'new'   => 'Newari',
    'ng'    => 'Ndonga',
    'nia'   => 'Nias',
    'nic'   => "Niger\-Kordofanian\ Language",
    'niu'   => 'Niuean',
    'nl'    => 'डच्',
    'nl_be' => 'Flemish',
    'nn'    => "Norwegian\ Nynorsk",
    'no'    => 'नोर्वेजियन',
    'nog'   => 'Nogai',
    'non'   => "Old\ Norse",
    'nqo'   => "N\â\\Ko",
    'nr'    => "South\ Ndebele",
    'nso'   => "Northern\ Sotho",
    'nub'   => "Nubian\ Language",
    'nv'    => 'Navajo',
    'nwc'   => "Classical\ Newari",
    'ny'    => 'Nyanja',
    'nym'   => 'Nyamwezi',
    'nyn'   => 'Nyankole',
    'nyo'   => 'Nyoro',
    'nzi'   => 'Nzima',
    'oc'    => 'ओसिटान्',
    'oj'    => 'Ojibwa',
    'om'    => "ओरोमो\ \(अफान\)",
    'or'    => 'ओरिया',
    'os'    => 'Ossetic',
    'osa'   => 'Osage',
    'ota'   => "Ottoman\ Turkish",
    'oto'   => "Otomian\ Language",
    'pa'    => 'पंजाबी',
    'paa'   => "Papuan\ Language",
    'pag'   => 'Pangasinan',
    'pal'   => 'Pahlavi',
    'pam'   => 'Pampanga',
    'pap'   => 'Papiamento',
    'pau'   => 'Palauan',
    'peo'   => "Old\ Persian",
    'phi'   => "Philippine\ Language",
    'phn'   => 'Phoenician',
    'pi'    => 'Pali',
    'pl'    => 'पोलिष',
    'pon'   => 'Pohnpeian',
    'pra'   => "Prakrit\ Language",
    'pro'   => "Old\ Proven\Ã\§al",
    'ps'    => "पाष्टो\ \(पुष्टो\)",
    'pt'    => 'पोर्चुगीज़्',
    'pt_br' => "Brazilian\ Portuguese",
    'pt_pt' => "Iberian\ Portuguese",
    'qu'    => 'क्वेच्वा',
    'raj'   => 'Rajasthani',
    'rap'   => 'Rapanui',
    'rar'   => 'Rarotongan',
    'rm'    => "रहटो\-रोमान्स्",
    'rn'    => 'किरुन्दी',
    'ro'    => 'रोमानियन्',
    'roa'   => "Romance\ Language",
    'rom'   => 'Romany',
    'ru'    => 'रष्यन्',
    'rup'   => 'Aromanian',
    'rw'    => 'किन्यार्वान्डा',
    'sa'    => 'संस्कृत',
    'sad'   => 'Sandawe',
    'sah'   => 'Yakut',
    'sai'   => "South\ American\ Indian\ Language",
    'sal'   => "Salishan\ Language",
    'sam'   => "Samaritan\ Aramaic",
    'sas'   => 'Sasak',
    'sat'   => 'Santali',
    'sc'    => 'Sardinian',
    'scn'   => 'Sicilian',
    'sco'   => 'Scots',
    'sd'    => 'सिंधी',
    'se'    => "Northern\ Sami",
    'sel'   => 'Selkup',
    'sem'   => "Semitic\ Language",
    'sg'    => 'सांग्रो',
    'sga'   => "Old\ Irish",
    'sgn'   => "Sign\ Language",
    'sh'    => "सेर्बो\-क्रोयेषियन्",
    'shn'   => 'Shan',
    'si'    => 'सिन्हलीस्',
    'sid'   => 'Sidamo',
    'sio'   => "Siouan\ Language",
    'sit'   => "Sino\-Tibetan\ Language",
    'sk'    => 'स्लोवाक',
    'sl'    => 'स्लोवेनियन्',
    'sla'   => "Slavic\ Language",
    'sm'    => 'समोन',
    'sma'   => "Southern\ Sami",
    'smi'   => "Sami\ Language",
    'smj'   => "Lule\ Sami",
    'smn'   => "Inari\ Sami",
    'sms'   => "Skolt\ Sami",
    'sn'    => 'शोना',
    'snk'   => 'Soninke',
    'so'    => 'सोमाळी',
    'sog'   => 'Sogdien',
    'son'   => 'Songhai',
    'sq'    => 'आल्बेनियन्',
    'sr'    => 'सेर्बियन्',
    'srn'   => "Sranan\ Tongo",
    'srr'   => 'Serer',
    'ss'    => 'सिस्वाती',
    'ssa'   => "Nilo\-Saharan\ Language",
    'st'    => 'सेसोथो',
    'su'    => 'सुंदनीस',
    'suk'   => 'Sukuma',
    'sus'   => 'Susu',
    'sux'   => 'Sumerian',
    'sv'    => 'स्वीदीष',
    'sw'    => 'स्वाहिली',
    'syc'   => "Classical\ Syriac",
    'syr'   => 'Syriac',
    'ta'    => 'तमिळ',
    'tai'   => "Tai\ Language",
    'te'    => 'तेलुगू',
    'tem'   => 'Timne',
    'ter'   => 'Tereno',
    'tet'   => 'Tetum',
    'tg'    => 'तजिक',
    'th'    => 'थाई',
    'ti'    => 'तिग्रिन्या',
    'tig'   => 'Tigre',
    'tiv'   => 'Tiv',
    'tk'    => 'तुर्कमन',
    'tkl'   => 'Tokelau',
    'tl'    => 'तगालोग',
    'tlh'   => 'Klingon',
    'tli'   => 'Tlingit',
    'tmh'   => 'Tamashek',
    'tn'    => 'सेत्स्वाना',
    'to'    => 'तोंगा',
    'tog'   => "Nyasa\ Tonga",
    'tpi'   => "Tok\ Pisin",
    'tr'    => 'तुर्किष',
    'trv'   => 'Taroko',
    'ts'    => 'त्सोगा',
    'tsi'   => 'Tsimshian',
    'tt'    => 'तटार',
    'tum'   => 'Tumbuka',
    'tup'   => "Tupi\ Language",
    'tut'   => "Altaic\ Language",
    'tvl'   => 'Tuvalu',
    'tw'    => 'त्वि',
    'ty'    => 'Tahitian',
    'tyv'   => 'Tuvinian',
    'udm'   => 'Udmurt',
    'ug'    => 'उधूर',
    'uga'   => 'Ugaritic',
    'uk'    => 'युक्रेनियन्',
    'umb'   => 'Umbundu',
    'und'   => "Unknown\ or\ Invalid\ Language",
    'ur'    => 'उर्दू',
    'uz'    => 'उज़बेक',
    'vai'   => 'Vai',
    've'    => 'Venda',
    'vi'    => 'वियत्नामीज़',
    'vo'    => 'ओलापुक',
    'vot'   => 'Votic',
    'wa'    => 'Walloon',
    'wak'   => "Wakashan\ Language",
    'wal'   => 'Walamo',
    'war'   => 'Waray',
    'was'   => 'Washo',
    'wen'   => "Sorbian\ Language",
    'wo'    => 'उलोफ़',
    'xal'   => 'Kalmyk',
    'xh'    => 'झ़ौसा',
    'yao'   => 'Yao',
    'yap'   => 'Yapese',
    'yi'    => 'इद्दिष्',
    'yo'    => 'यूरुबा',
    'ypk'   => "Yupik\ Language",
    'za'    => 'झ्हुन्ग',
    'zap'   => 'Zapotec',
    'zbl'   => 'Blissymbols',
    'zen'   => 'Zenaga',
    'zh'    => 'चीनीस्',
    'znd'   => 'Zande',
    'zu'    => 'जुलू',
    'zun'   => 'Zuni',
    'zxx'   => "No\ linguistic\ content",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::kok::name_to_code = (
    ''                                    => 'zu',
    "\ "                                  => 'ps',
    'achinese'                            => 'ace',
    'acoli'                               => 'ach',
    'adangme'                             => 'ada',
    'adyghe'                              => 'ady',
    'afrihili'                            => 'afh',
    "afroasiatic\ language"               => 'afa',
    'ainu'                                => 'ain',
    'akan'                                => 'ak',
    'akkadian'                            => 'akk',
    'aleut'                               => 'ale',
    "algonquian\ language"                => 'alg',
    "altaic\ language"                    => 'tut',
    "ancient\ egyptian"                   => 'egy',
    "ancient\ greek"                      => 'grc',
    'angika'                              => 'anp',
    "apache\ language"                    => 'apa',
    'aragonese'                           => 'an',
    'aramaic'                             => 'arc',
    'arapaho'                             => 'arp',
    'araucanian'                          => 'arn',
    'arawak'                              => 'arw',
    'aromanian'                           => 'rup',
    "artificial\ language"                => 'art',
    'asturian'                            => 'ast',
    "athapascan\ language"                => 'ath',
    'atsam'                               => 'cch',
    "australian\ english"                 => 'en_au',
    "australian\ language"                => 'aus',
    "austrian\ german"                    => 'de_at',
    "austronesian\ language"              => 'map',
    'avaric'                              => 'av',
    'avestan'                             => 'ae',
    'awadhi'                              => 'awa',
    'balinese'                            => 'ban',
    "baltic\ language"                    => 'bat',
    'baluchi'                             => 'bal',
    'bambara'                             => 'bm',
    "bamileke\ language"                  => 'bai',
    'banda'                               => 'bad',
    'bantu'                               => 'bnt',
    'basa'                                => 'bas',
    'batak'                               => 'btk',
    'beja'                                => 'bej',
    'bemba'                               => 'bem',
    'berber'                              => 'ber',
    'bhojpuri'                            => 'bho',
    'bikol'                               => 'bik',
    'bini'                                => 'bin',
    'blin'                                => 'byn',
    'blissymbols'                         => 'zbl',
    'bosnian'                             => 'bs',
    'braj'                                => 'bra',
    "brazilian\ portuguese"               => 'pt_br',
    "british\ english"                    => 'en_gb',
    'buginese'                            => 'bug',
    'buriat'                              => 'bua',
    'caddo'                               => 'cad',
    "canadian\ english"                   => 'en_ca',
    "canadian\ french"                    => 'fr_ca',
    'carib'                               => 'car',
    "caucasian\ language"                 => 'cau',
    'cebuano'                             => 'ceb',
    "celtic\ language"                    => 'cel',
    "central\ american\ indian\ language" => 'cai',
    'chagatai'                            => 'chg',
    "chamic\ language"                    => 'cmc',
    'chamorro'                            => 'ch',
    'chechen'                             => 'ce',
    'cherokee'                            => 'chr',
    'cheyenne'                            => 'chy',
    'chibcha'                             => 'chb',
    "chinook\ jargon"                     => 'chn',
    'chipewyan'                           => 'chp',
    'choctaw'                             => 'cho',
    "church\ slavic"                      => 'cu',
    'chuukese'                            => 'chk',
    'chuvash'                             => 'cv',
    "classical\ newari"                   => 'nwc',
    "classical\ syriac"                   => 'syc',
    'coptic'                              => 'cop',
    'cornish'                             => 'kw',
    'cree'                                => 'cr',
    'creek'                               => 'mus',
    "creole\ or\ pidgin"                  => 'crp',
    "crimean\ turkish"                    => 'crh',
    "cushitic\ language"                  => 'cus',
    'dakota'                              => 'dak',
    'dargwa'                              => 'dar',
    'dayak'                               => 'day',
    'delaware'                            => 'del',
    'dinka'                               => 'din',
    'divehi'                              => 'dv',
    'dogri'                               => 'doi',
    'dogrib'                              => 'dgr',
    "dravidian\ language"                 => 'dra',
    'duala'                               => 'dua',
    'dyula'                               => 'dyu',
    "eastern\ frisian"                    => 'frs',
    'efik'                                => 'efi',
    'ekajuk'                              => 'eka',
    'elamite'                             => 'elx',
    "englishbased\ creole\ or\ pidgin"    => 'cpe',
    'erzya'                               => 'myv',
    'ewe'                                 => 'ee',
    'ewondo'                              => 'ewo',
    'fang'                                => 'fan',
    'fanti'                               => 'fat',
    'filipino'                            => 'fil',
    "finnougrian\ language"               => 'fiu',
    'flemish'                             => 'nl_be',
    'fon'                                 => 'fon',
    "frenchbased\ creole\ or\ pidgin"     => 'cpf',
    'friulian'                            => 'fur',
    'fulah'                               => 'ff',
    'ga'                                  => 'gaa',
    'ganda'                               => 'lg',
    'gayo'                                => 'gay',
    'gbaya'                               => 'gba',
    'geez'                                => 'gez',
    "germanic\ language"                  => 'gem',
    'gilbertese'                          => 'gil',
    'gondi'                               => 'gon',
    'gorontalo'                           => 'gor',
    'gothic'                              => 'got',
    'grebo'                               => 'grb',
    'gwichin'                             => 'gwi',
    'haida'                               => 'hai',
    'haitian'                             => 'ht',
    'hawaiian'                            => 'haw',
    'herero'                              => 'hz',
    'hiligaynon'                          => 'hil',
    'himachali'                           => 'him',
    "hiri\ motu"                          => 'ho',
    'hittite'                             => 'hit',
    'hmong'                               => 'hmn',
    'hupa'                                => 'hup',
    'iban'                                => 'iba',
    "iberian\ portuguese"                 => 'pt_pt',
    "iberian\ spanish"                    => 'es_es',
    'ido'                                 => 'io',
    'igbo'                                => 'ig',
    'ijo'                                 => 'ijo',
    'iloko'                               => 'ilo',
    "inari\ sami"                         => 'smn',
    "indic\ language"                     => 'inc',
    "indoeuropean\ language"              => 'ine',
    'ingush'                              => 'inh',
    "iranian\ language"                   => 'ira',
    "iroquoian\ language"                 => 'iro',
    'jju'                                 => 'kaj',
    'judeoarabic'                         => 'jrb',
    'judeopersian'                        => 'jpr',
    'kabardian'                           => 'kbd',
    'kabyle'                              => 'kab',
    'kachin'                              => 'kac',
    'kalmyk'                              => 'xal',
    'kamba'                               => 'kam',
    'kanuri'                              => 'kr',
    'karachaybalkar'                      => 'krc',
    'karakalpak'                          => 'kaa',
    'karelian'                            => 'krl',
    'karen'                               => 'kar',
    'kashubian'                           => 'csb',
    'kawi'                                => 'kaw',
    'khasi'                               => 'kha',
    "khoisan\ language"                   => 'khi',
    'khotanese'                           => 'kho',
    'kikuyu'                              => 'ki',
    'kimbundu'                            => 'kmb',
    'klingon'                             => 'tlh',
    'komi'                                => 'kv',
    'kongo'                               => 'kg',
    'koro'                                => 'kfo',
    'kosraean'                            => 'kos',
    'kpelle'                              => 'kpe',
    'kru'                                 => 'kro',
    'kuanyama'                            => 'kj',
    'kumyk'                               => 'kum',
    'kurukh'                              => 'kru',
    'kutenai'                             => 'kut',
    'ladino'                              => 'lad',
    'lahnda'                              => 'lah',
    'lamba'                               => 'lam',
    'lezghian'                            => 'lez',
    'limburgish'                          => 'li',
    'lojban'                              => 'jbo',
    "low\ german"                         => 'nds',
    "lower\ sorbian"                      => 'dsb',
    'lozi'                                => 'loz',
    'lubakatanga'                         => 'lu',
    'lubalulua'                           => 'lua',
    'luiseno'                             => 'lui',
    "lule\ sami"                          => 'smj',
    'lunda'                               => 'lun',
    'luo'                                 => 'luo',
    'lushai'                              => 'lus',
    'luxembourgish'                       => 'lb',
    'madurese'                            => 'mad',
    'magahi'                              => 'mag',
    'maithili'                            => 'mai',
    'makasar'                             => 'mak',
    'manchu'                              => 'mnc',
    'mandar'                              => 'mdr',
    'mandingo'                            => 'man',
    'manipuri'                            => 'mni',
    "manobo\ language"                    => 'mno',
    'manx'                                => 'gv',
    'mari'                                => 'chm',
    'marshallese'                         => 'mh',
    'marwari'                             => 'mwr',
    'masai'                               => 'mas',
    "mayan\ language"                     => 'myn',
    'mende'                               => 'men',
    'micmac'                              => 'mic',
    "middle\ dutch"                       => 'dum',
    "middle\ english"                     => 'enm',
    "middle\ french"                      => 'frm',
    "middle\ high\ german"                => 'gmh',
    "middle\ irish"                       => 'mga',
    'minangkabau'                         => 'min',
    'mirandese'                           => 'mwl',
    "miscellaneous\ language"             => 'mis',
    'mohawk'                              => 'moh',
    'moksha'                              => 'mdf',
    'mongo'                               => 'lol',
    "monkhmer\ language"                  => 'mkh',
    'morisyen'                            => 'mfe',
    'mossi'                               => 'mos',
    "multiple\ languages"                 => 'mul',
    "munda\ language"                     => 'mun',
    'nahuatl'                             => 'nah',
    'navajo'                              => 'nv',
    'ndonga'                              => 'ng',
    'neapolitan'                          => 'nap',
    'newari'                              => 'new',
    'nias'                                => 'nia',
    "nigerkordofanian\ language"          => 'nic',
    "nilosaharan\ language"               => 'ssa',
    'niuean'                              => 'niu',
    'nko'                                 => 'nqo',
    "no\ linguistic\ content"             => 'zxx',
    'nogai'                               => 'nog',
    "north\ american\ indian\ language"   => 'nai',
    "north\ ndebele"                      => 'nd',
    "northern\ frisian"                   => 'frr',
    "northern\ sami"                      => 'se',
    "northern\ sotho"                     => 'nso',
    "norwegian\ bokml"                    => 'nb',
    "norwegian\ nynorsk"                  => 'nn',
    "nubian\ language"                    => 'nub',
    'nyamwezi'                            => 'nym',
    'nyanja'                              => 'ny',
    'nyankole'                            => 'nyn',
    "nyasa\ tonga"                        => 'tog',
    'nyoro'                               => 'nyo',
    'nzima'                               => 'nzi',
    'ojibwa'                              => 'oj',
    "old\ english"                        => 'ang',
    "old\ french"                         => 'fro',
    "old\ high\ german"                   => 'goh',
    "old\ irish"                          => 'sga',
    "old\ norse"                          => 'non',
    "old\ persian"                        => 'peo',
    "old\ provenal"                       => 'pro',
    'osage'                               => 'osa',
    'ossetic'                             => 'os',
    "otomian\ language"                   => 'oto',
    "ottoman\ turkish"                    => 'ota',
    'pahlavi'                             => 'pal',
    'palauan'                             => 'pau',
    'pali'                                => 'pi',
    'pampanga'                            => 'pam',
    'pangasinan'                          => 'pag',
    'papiamento'                          => 'pap',
    "papuan\ language"                    => 'paa',
    "philippine\ language"                => 'phi',
    'phoenician'                          => 'phn',
    'pohnpeian'                           => 'pon',
    "portuguesebased\ creole\ or\ pidgin" => 'cpp',
    "prakrit\ language"                   => 'pra',
    'rajasthani'                          => 'raj',
    'rapanui'                             => 'rap',
    'rarotongan'                          => 'rar',
    "romance\ language"                   => 'roa',
    'romany'                              => 'rom',
    "salishan\ language"                  => 'sal',
    "samaritan\ aramaic"                  => 'sam',
    "sami\ language"                      => 'smi',
    'sandawe'                             => 'sad',
    'santali'                             => 'sat',
    'sardinian'                           => 'sc',
    'sasak'                               => 'sas',
    'scots'                               => 'sco',
    'selkup'                              => 'sel',
    "semitic\ language"                   => 'sem',
    'serer'                               => 'srr',
    'shan'                                => 'shn',
    "sichuan\ yi"                         => 'ii',
    'sicilian'                            => 'scn',
    'sidamo'                              => 'sid',
    "sign\ language"                      => 'sgn',
    'siksika'                             => 'bla',
    "sinotibetan\ language"               => 'sit',
    "siouan\ language"                    => 'sio',
    "skolt\ sami"                         => 'sms',
    'slave'                               => 'den',
    "slavic\ language"                    => 'sla',
    'sogdien'                             => 'sog',
    'songhai'                             => 'son',
    'soninke'                             => 'snk',
    "sorbian\ language"                   => 'wen',
    "south\ american\ indian\ language"   => 'sai',
    "south\ ndebele"                      => 'nr',
    "southern\ altai"                     => 'alt',
    "southern\ sami"                      => 'sma',
    "sranan\ tongo"                       => 'srn',
    'sukuma'                              => 'suk',
    'sumerian'                            => 'sux',
    'susu'                                => 'sus',
    "swiss\ french"                       => 'fr_ch',
    "swiss\ german"                       => 'gsw',
    "swiss\ high\ german"                 => 'de_ch',
    'syriac'                              => 'syr',
    'tahitian'                            => 'ty',
    "tai\ language"                       => 'tai',
    'tamashek'                            => 'tmh',
    'taroko'                              => 'trv',
    'tereno'                              => 'ter',
    'tetum'                               => 'tet',
    'tigre'                               => 'tig',
    'timne'                               => 'tem',
    'tiv'                                 => 'tiv',
    'tlingit'                             => 'tli',
    "tok\ pisin"                          => 'tpi',
    'tokelau'                             => 'tkl',
    'tsimshian'                           => 'tsi',
    'tumbuka'                             => 'tum',
    "tupi\ language"                      => 'tup',
    'tuvalu'                              => 'tvl',
    'tuvinian'                            => 'tyv',
    'tyap'                                => 'kcg',
    'udmurt'                              => 'udm',
    'ugaritic'                            => 'uga',
    'umbundu'                             => 'umb',
    "unknown\ or\ invalid\ language"      => 'und',
    "upper\ sorbian"                      => 'hsb',
    "us\ english"                         => 'en_us',
    'vai'                                 => 'vai',
    'venda'                               => 've',
    'votic'                               => 'vot',
    "wakashan\ language"                  => 'wak',
    'walamo'                              => 'wal',
    'walloon'                             => 'wa',
    'waray'                               => 'war',
    'washo'                               => 'was',
    'yakut'                               => 'sah',
    'yao'                                 => 'yao',
    'yapese'                              => 'yap',
    "yupik\ language"                     => 'ypk',
    'zande'                               => 'znd',
    'zapotec'                             => 'zap',
    'zaza'                                => 'zza',
    'zenaga'                              => 'zen',
    'zuni'                                => 'zun',
);

1;
