package Locales::DB::Language::kn;

# Auto generated from CLDR

$Locales::DB::Language::kn::VERSION = '0.01';

$Locales::DB::Language::kn::cldr_version = '1.7.1';

%Locales::DB::Language::kn::misc_info = (
    'cldr_formats' => {
        'decimal'   => "\#\,\#\#\,\#\#0\.\#\#\#",
        'language'  => "Language\:\ \{0\}",
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#\,\#\#0\%",
        'territory' => "Region\:\ \{0\}"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr' => {
            'content' => "ಇಲ್ಲ\:ಅಲ್ಲ",
            'draft'   => 'unconfirmed'
        },
        'yesstr' => {
            'content' => 'ಹೌದು',
            'draft'   => 'unconfirmed'
        }
    },
);

%Locales::DB::Language::kn::code_to_name = (
    'aa'    => 'ಅಫಾರ್',
    'ab'    => 'ಅಬ್ಖಾಜಿಯನ್',
    'ace'   => 'ಅಛಿನೀಸ್',
    'ach'   => 'ಅಕೋಲಿ',
    'ada'   => 'ಅಡಂಗ್‌ಮೆ',
    'ady'   => 'ಅಡೈಘೆ',
    'ae'    => 'ಅವೆಸ್ಟನ್',
    'af'    => 'ಆಫ್ರಿಕಾನ್ಸ್',
    'afa'   => "ಆಫ್ರೋ\-ಏಶಿಯಾಟಿಕ್\ ಭಾಷೆ",
    'afh'   => 'ಆಫ್ರಿಹಿಲಿ',
    'ain'   => 'ಐನು',
    'ak'    => 'ಅಕನ್',
    'akk'   => 'ಅಕ್ಕಾಡಿಯನ್',
    'ale'   => 'ಅಲೆಯುಟ್',
    'alg'   => "ಅಲ್ಗೊಂಕ್ವಿಯನ್\ ಭಾಷೆ",
    'alt'   => "ದಕ್ಷಿಣ\ ಅಲ್ಟಾಯ್",
    'am'    => 'ಅಂಹರಿಕ್',
    'an'    => 'ಅರಗೊನೀಸ್',
    'ang'   => "ಪ್ರಾಚೀನ\ ಇಂಗ್ಲೀಷ್",
    'anp'   => 'ಆಂಗಿಕಾ',
    'apa'   => "ಅಪಾಚಿ\ ಭಾಷೆ",
    'ar'    => 'ಅರೇಬಿಕ್',
    'arc'   => 'ಅರಾಮಿಕ್',
    'arn'   => 'ಅರೌಕೇನಿಯನ್',
    'arp'   => 'ಅರಪಾಹೋ',
    'art'   => "ಕೃತಕ\ ಭಾಷೆ",
    'arw'   => 'ಅರಾವಾಕ್',
    'as'    => 'ಅಸ್ಸಾಮೀಸ್',
    'ast'   => 'ಆಸ್ಟುರಿಯನ್',
    'ath'   => "ಅಥಪಾಸ್ಕನ್\ ಭಾಷೆ",
    'aus'   => "ಆಸ್ಟ್ರೇಲಿಯನ್\ ಭಾಷೆ",
    'av'    => 'ಅವರಿಕ್',
    'awa'   => 'ಅವಧಿ',
    'ay'    => 'ಅಯ್ಮಾರಾ',
    'az'    => 'ಅಜರ್‌ಬೈಜಾನಿ',
    'ba'    => 'ಬಶ್ಕಿರ್',
    'bad'   => 'ಬಾಂಡಾ',
    'bai'   => "ಬಮಿಲೇಕೆ\ ಭಾಷೆ",
    'bal'   => 'ಬಲೂಚಿ',
    'ban'   => 'ಬಲಿನೀಸ್',
    'bas'   => 'ಬಸಾ',
    'bat'   => "ಬಾಲ್ಟಿಕ್\ ಭಾಷೆ",
    'be'    => 'ಬೆಲರೂಸಿಯನ್',
    'bej'   => 'ಬೇಜಾ',
    'bem'   => 'ಬೆಂಬಾ',
    'ber'   => 'ಬೆರ್ಬರ್',
    'bg'    => 'ಬಲ್ಗೇರಿಯನ್',
    'bh'    => 'ಬಿಹಾರಿ',
    'bho'   => 'ಭೋಜಪುರಿ',
    'bi'    => 'ಬಿಸ್ಲಾಮಾ',
    'bik'   => 'ಬಿಕೊಲ್',
    'bin'   => 'ಬಿನಿ',
    'bla'   => 'ಸಿಕ್ಸಿಕಾ',
    'bm'    => 'ಬಂಬಾರಾ',
    'bn'    => 'ಬೆಂಗಾಲಿ',
    'bnt'   => 'ಬಂಟು',
    'bo'    => 'ಟಿಬೇಟಿಯನ್',
    'br'    => 'ಬ್ರೆಟನ್',
    'bra'   => 'ಬ್ರಾಜ್',
    'bs'    => 'ಬೋಸ್ನಿಯನ್',
    'btk'   => 'ಬಟಾಕ್',
    'bua'   => 'ಬುರಿಯಟ್',
    'bug'   => 'ಬುಗಿನೀಸ್',
    'byn'   => 'ಬ್ಲಿನ್',
    'ca'    => 'ಕೆಟಲಾನ್',
    'cad'   => 'ಕ್ಯಾಡ್ಡೋ',
    'cai'   => "ಮಧ್ಯ\ ಅಮೇರಿಕನ್\ ಇಂಡಿಯನ್\ ಭಾಷೆ",
    'car'   => 'ಕಾರಿಬ್',
    'cau'   => "ಕಕೇಶಿಯನ್\ ಭಾಷೆ",
    'cch'   => 'ಅಟ್ಸಮ್',
    'ce'    => 'ಚೆಚನ್',
    'ceb'   => 'ಸೆಬುಆನೋ',
    'cel'   => "ಸೆಲ್ಟಿಕ್\ ಭಾಷೆ",
    'ch'    => 'ಕಮೊರೊ',
    'chb'   => 'ಚಿಬ್ಚಾ',
    'chg'   => 'ಚಗಟಾಯ್',
    'chk'   => 'ಚೂಕಿಸೆ',
    'chm'   => 'ಮಾರಿ',
    'chn'   => "ಚಿನೂಕ್\ ಜಾರ್ಗೋನ್",
    'cho'   => 'ಚೋಕ್ಟಾವ್',
    'chp'   => 'ಚಿಪೆವ್ಯಾನ್',
    'chr'   => 'ಚೀರೋಕೀ',
    'chy'   => 'ಚೀಯೆನ್ನೇ',
    'cmc'   => "ಚಾಮಿಕ್\ ಭಾಷೆ",
    'co'    => 'ಕೊರ್ಸಿಕನ್',
    'cop'   => 'ಕೊಪ್ಟಿಕ್',
    'cpe'   => "ಇಂಗ್ಲೀಷ್\-ಮೂಲದ\ ಕ್ರಿಯೋಲ್\ ಅಥವಾ\ ಪಿಡ್ಗಿನ್",
    'cpf'   => "ಫ್ರೆಂಚ್\-ಮೂಲದ\ ಕ್ರಿಯೋಲ್\ ಅಥವಾ\ ಪಿಡ್ಗಿನ್",
    'cpp'   => "ಪೋರ್ಚುಗೀಸ್\-\ ಮೂಲದ\ ಕ್ರಿಯೋಲ್\ ಅಥವಾ\ ಪಿಡ್ಗಿನ್",
    'cr'    => 'ಕ್ರೀ',
    'crh'   => "ಕ್ರಿಮೀಯನ್\ ಟರ್ಕಿಷ್",
    'crp'   => "ಕ್ರಿಯೋಲ್\ ಅಥವಾ\ ಪಿಡ್ಗಿನ್",
    'cs'    => 'ಜೆಕ್',
    'csb'   => 'ಕಶುಬಿಯನ್',
    'cu'    => "ಚರ್ಚ್\ ಸ್ಲಾವಿಕ್",
    'cus'   => "ಕುಷಿಟಿಕ್\ ಭಾಷೆ",
    'cv'    => 'ಚುವಾಶ್',
    'cy'    => 'ವೆಲ್ಶ್',
    'da'    => 'ಡ್ಯಾನಿಶ್',
    'dak'   => 'ಡಕೋಟ',
    'dar'   => 'ದರ್ಗ್ವಾ',
    'day'   => 'ದಾಯಕ್',
    'de'    => 'ಜರ್ಮನ್',
    'de_at' => "ಆಸ್ಟ್ರಿಯನ್\ ಜರ್ಮನ್",
    'de_ch' => "ಸ್ವಿಸ್\ ಹೈ\ ಜರ್ಮನ್",
    'del'   => 'ಡೆಲಾವೇರ್',
    'den'   => 'ಸ್ಲೇವ್',
    'dgr'   => 'ಡೋಗ್ರಿಬ್',
    'din'   => 'ಡಿಂಕಾ',
    'doi'   => 'ಡೋಗ್ರಿ',
    'dra'   => "ಡ್ರಾವಿಡಿಯನ್\ ಭಾಷೆ",
    'dsb'   => "ಲೋವರ್\ ಸೋರ್ಬಿಯನ್",
    'dua'   => 'ಡುವಾಲಾ',
    'dum'   => "ಮಧ್ಯ\ ಡಚ್",
    'dv'    => 'ದಿವೆಹಿ',
    'dyu'   => 'ಡ್ಯೂಲಾ',
    'dz'    => 'ಜೋಂಗ್‌ಖಾ',
    'ee'    => 'ಏವ್',
    'efi'   => 'ಎಫಿಕ್',
    'egy'   => "ಪ್ರಾಚೀನ\ ಈಜಿಪ್ಟಿಯನ್",
    'eka'   => 'ಎಕಾಜುಕ್',
    'el'    => 'ಗ್ರೀಕ್',
    'elx'   => 'ಎಲಾಮೈಟ್',
    'en'    => 'ಇಂಗ್ಲೀಷ್',
    'en_au' => "ಆಸ್ಟ್ರೇಲಿಯನ್\ ಇಂಗ್ಲೀಷ್",
    'en_ca' => "ಕೆನೆಡಿಯನ್\ ಇಂಗ್ಲೀಷ್",
    'en_gb' => "ಬ್ರಿಟಿಷ್\ ಇಂಗ್ಲೀಷ್",
    'en_us' => "ಯು\.ಎಸ್\.\ ಇಂಗ್ಲೀಷ್",
    'enm'   => "ಮಧ್ಯ\ ಇಂಗ್ಲೀಷ್",
    'eo'    => 'ಎಸ್ಪೆರಾಂಟೊ',
    'es'    => 'ಸ್ಪ್ಯಾನಿಷ್',
    'es_es' => "ಐಬೇರಿಯನ್\ ಸ್ಪ್ಯಾನಿಶ್",
    'et'    => 'ಎಸ್ಟೊನಿಯನ್',
    'eu'    => 'ಬಾಸ್ಕ್',
    'ewo'   => 'ಇವಾಂಡೋ',
    'fa'    => 'ಪರ್ಶಿಯನ್',
    'fan'   => 'ಫೆಂಗ್',
    'fat'   => 'ಫಾಂಟಿ',
    'ff'    => 'ಫುಲಾಹ್',
    'fi'    => 'ಫಿನ್ನಿಶ್',
    'fil'   => 'ಫಿಲಿಪಿನೊ',
    'fiu'   => "ಫಿನ್ನೋ\-ಉಗ್ರಿಯನ್\ ಭಾಷೆ",
    'fj'    => 'ಫಿಜಿಯನ್',
    'fo'    => 'ಫರೋಸಿ',
    'fon'   => 'ಫೋನ್',
    'fr'    => 'ಫ್ರೆಂಚ್',
    'fr_ca' => "ಕೆನೆಡಿಯನ್\ ಫ್ರೆಂಚ್",
    'fr_ch' => "ಸ್ವಿಸ್\ ಫ್ರೆಂಚ್",
    'frm'   => "ಮಧ್ಯ\ ಫ್ರೆಂಚ್",
    'fro'   => "ಪ್ರಾಚೀನ\ ಫ್ರೆಂಚ್",
    'frr'   => "ಉತ್ತರ\ ಫ್ರಿಸಿಯನ್",
    'frs'   => "ಪೂರ್ವ\ ಫ್ರಿಸಿಯನ್",
    'fur'   => 'ಫ್ರಿಯುಲಿಯನ್',
    'fy'    => "ಪಶ್ಚಿಮ\ ಫ್ರಿಸಿಯನ್",
    'ga'    => 'ಐರಿಷ್',
    'gaa'   => 'ಗಾ',
    'gay'   => 'ಗಾಯೋ',
    'gba'   => 'ಗ್ಬಾಯಾ',
    'gd'    => "ಸ್ಕಾಟಿಶ್\ ಗ್ಯಾಲಿಕ್",
    'gem'   => "ಜರ್ಮನಿಕ್\ ಭಾಷೆ",
    'gez'   => 'ಗೀಝ್',
    'gil'   => 'ಗಿಲ್ಬರ್ಟೀಸ್',
    'gl'    => 'ಗ್ಯಾಲಿಶಿಯನ್',
    'gmh'   => "ಮಧ್ಯ\ ಹೈ\ ಜರ್ಮನ್",
    'gn'    => 'ಗೌರಾನಿ',
    'goh'   => "ಪ್ರಾಚೀನ\ ಹೈ\ ಜರ್ಮನ್",
    'gon'   => 'ಗೊಂಡಿ',
    'gor'   => 'ಗೊರೊಂಟಾಲೋ',
    'got'   => 'ಗೋಥಿಕ್',
    'grb'   => 'ಗ್ರೇಬೋ',
    'grc'   => "ಪ್ರಾಚೀನ\ ಗ್ರೀಕ್",
    'gsw'   => "ಸ್ವಿಸ್\ ಜರ್ಮನ್",
    'gu'    => 'ಗುಜರಾತಿ',
    'gv'    => 'ಮ್ಯಾಂಕ್ಸ್',
    'gwi'   => 'ಗ್ವಿಚ್‌ಇನ್',
    'ha'    => 'ಹೌಸಾ',
    'hai'   => 'ಹೈಡಾ',
    'haw'   => 'ಹವಾಯಿಯನ್',
    'he'    => 'ಹೀಬ್ರ್ಯೂ',
    'hi'    => 'ಹಿಂದಿ',
    'hil'   => 'ಹಿಲಿಗೇನನ್',
    'him'   => 'ಹಿಮಾಚಲಿ',
    'hit'   => 'ಹಿಟ್ಟಿಟೆ',
    'hmn'   => 'ಮೋಂಗ್',
    'ho'    => "ಹಿರಿ\ ಮೊಟು",
    'hr'    => 'ಕ್ರೊಯೇಶಿಯನ್',
    'hsb'   => "ಅಪ್ಪರ್\ ಸರ್ಬಿಯನ್",
    'ht'    => 'ಹೈತಿಯನ್',
    'hu'    => 'ಹಂಗೇರಿಯನ್',
    'hup'   => 'ಹೂಪಾ',
    'hy'    => 'ಅರ್ಮೇನಿಯನ್',
    'hz'    => 'ಹೆರೆರೊ',
    'ia'    => 'ಇಂಟರ್ಲಿಂಗುವಾ',
    'iba'   => 'ಇಬಾನ್',
    'id'    => 'ಇಂಡೋನೇಶಿಯನ್',
    'ie'    => 'ಇಂಟರ್ಲಿಂಗ್',
    'ig'    => 'ಇಗ್ಬೊ',
    'ii'    => "ಸಿಚುಅನ್\ ಯಿ",
    'ijo'   => 'ಇಜೋ',
    'ik'    => 'ಇನುಪಿಯಾಕ್',
    'ilo'   => 'ಇಲ್ಲಿಕೋ',
    'inc'   => "ಭಾರತೀಯ\ ಭಾಷೆ",
    'ine'   => "ಇಂಡೋ\-ಯೂರೋಪಿಯನ್\ ಭಾಷೆ",
    'inh'   => 'ಇಂಗುಷ್',
    'io'    => 'ಇಡೊ',
    'ira'   => "ಇರಾನಿಯನ್\ ಭಾಷೆ",
    'iro'   => "ಇರೋಕ್ವಿಯನ್\ ಭಾಷೆ",
    'is'    => 'ಐಸ್‌ಲ್ಯಾಂಡಿಕ್',
    'it'    => 'ಇಟಾಲಿಯನ್',
    'iu'    => 'ಇನುಕ್ಟಿಟುಟ್',
    'ja'    => 'ಜಪಾನೀಸ್',
    'jbo'   => 'ಲೊಜ್ಬಾನ್',
    'jpr'   => "ಜೂಡಿಯೋ\-ಪರ್ಶಿಯನ್",
    'jrb'   => "ಜೂಡಿಯೋ\-ಅರೇಬಿಕ್",
    'jv'    => 'ಜವಾನೀಸ್',
    'ka'    => 'ಜಾರ್ಜಿಯನ್',
    'kaa'   => "ಕಾರಾ\-ಕಲ್ಪಾಕ್",
    'kab'   => 'ಕಬೈಲ್',
    'kac'   => 'ಕಚಿನ್',
    'kaj'   => 'ಜ್ಜು',
    'kam'   => 'ಕಂಬಾ',
    'kar'   => 'ಕರೆನ್',
    'kaw'   => 'ಕಾವಿ',
    'kbd'   => 'ಕಬರ್ಡಿಯನ್',
    'kcg'   => 'ಟ್ಯಾಪ್',
    'kfo'   => 'ಕೋರೋ',
    'kg'    => 'ಕಾಂಗೋ',
    'kha'   => 'ಖಾಸಿ',
    'khi'   => "ಖೋಇಸನ್\ ಭಾಷೆ",
    'kho'   => 'ಖೋಟಾನೀಸ್',
    'ki'    => 'ಕಿಕುಯು',
    'kj'    => 'ಕ್ವಾನ್‌ಯಾಮಾ',
    'kk'    => 'ಕಝಕ್',
    'kl'    => 'ಕಲಾಲ್ಲಿಸುಟ್',
    'km'    => 'ಖಮೇರ್',
    'kmb'   => 'ಕಿಂಬುಂಡು',
    'kn'    => 'ಕನ್ನಡ',
    'ko'    => 'ಕೋರಿಯನ್',
    'kok'   => 'ಕೊಂಕಣಿ',
    'kos'   => 'ಕೊಸರಿಯನ್',
    'kpe'   => 'ಕಪೆಲ್ಲೆ',
    'kr'    => 'ಕನುರಿ',
    'krc'   => "ಕರಚಯ್\-ಬಲ್ಕಾರ್",
    'krl'   => 'ಕರೇಲಿಯನ್',
    'kro'   => 'ಕ್ರು',
    'kru'   => 'ಕುರುಖ್',
    'ks'    => 'ಕಾಶ್ಮೀರಿ',
    'ku'    => 'ಕುರ್ದಿಷ್',
    'kum'   => 'ಕುಮೈಕ್',
    'kut'   => 'ಕುಟೇನಾಯ್',
    'kv'    => 'ಕೋಮಿ',
    'kw'    => 'ಕೋರ್ನಿಷ್',
    'ky'    => 'ಕಿರ್ಜಿಝ್',
    'la'    => 'ಲ್ಯಾಟಿನ್',
    'lad'   => 'ಕಾಡಿನೋ',
    'lah'   => 'ಲಹಂಡಾ',
    'lam'   => 'ಲಂಬಾ',
    'lb'    => 'ಲಕ್ಸಂಬರ್ಗ್',
    'lez'   => 'ಲೆಜ್ಘಿಯನ್',
    'lg'    => 'ಗಂಡಾ',
    'li'    => 'ಲಿಂಬರ್ಗಿಶ್',
    'ln'    => 'ಲಿಂಗಾಲ',
    'lo'    => 'ಲಾವೋ',
    'lol'   => 'ಮೊಂಗೋ',
    'loz'   => 'ಲೋಜಿ',
    'lt'    => 'ಲಿಥುವೇನಿಯನ್',
    'lu'    => "ಲೂಬಾ\-ಕಟಾಂಗಾ",
    'lua'   => "ಲೂಬಾ\-ಲುಲುಆ",
    'lui'   => 'ಲೂಯಿಸೆನೋ',
    'lun'   => 'ಲುಂಡಾ',
    'luo'   => 'ಲುವೋ',
    'lus'   => 'ಲುಶಾಯ್',
    'lv'    => 'ಲಟ್ವಿಯನ್',
    'mad'   => 'ಮದುರೀಸ್',
    'mag'   => 'ಮಗಾಹಿ',
    'mai'   => 'ಮೈಥಿಲಿ',
    'mak'   => 'ಮಕಾಸರ್',
    'man'   => 'ಮಂಡಿಂಗೊ',
    'map'   => 'ಆಸ್ಟ್ರೋನೇಷ್ಯನ್',
    'mas'   => 'ಮಸಾಯ್',
    'mdf'   => 'ಮೋಕ್ಷ',
    'mdr'   => 'ಮಂದಾರ್',
    'men'   => 'ಮೆಂಡೆ',
    'mfe'   => 'Morisyen',
    'mg'    => 'ಮಲಗಾಸಿ',
    'mga'   => "ಮಧ್ಯ\ ಐರಿಷ್",
    'mh'    => 'ಮಾರ್ಶಲ್ಲೀಸ್',
    'mi'    => 'ಮಾವೋರಿ',
    'mic'   => 'ಮಿಕ್‌ಮ್ಯಾಕ್',
    'min'   => 'ಮಿನಂಗ್‌ಕಬಾವು',
    'mis'   => "ಸಮ್ಮಿಶ್ರ\ ಭಾಷೆ",
    'mk'    => 'ಮೆಸಿಡೋನಿಯನ್',
    'mkh'   => "ಮೋನ್\-ಖಮೇರ್\ ಭಾಷೆ",
    'ml'    => 'ಮಲೆಯಾಳಂ',
    'mn'    => 'ಮಂಗೋಲಿಯನ್',
    'mnc'   => 'ಮಂಚು',
    'mni'   => 'ಮಣಿಪುರಿ',
    'mno'   => "ಮನೋಬೋ\ ಭಾಷೆ",
    'mo'    => 'ಮಾಲ್ಡೀವಿಯನ್',
    'moh'   => 'ಮೊಹಾವ್ಕ್',
    'mos'   => 'ಮೊಸ್ಸಿ',
    'mr'    => 'ಮರಾಠಿ',
    'ms'    => 'ಮಲಯ',
    'mt'    => 'ಮಾಲ್ಟೀಸ್',
    'mul'   => "ಬಹುಸಂಖ್ಯೆಯ\ ಭಾಷೆಗಳು",
    'mun'   => "ಮುಂಡಾ\ ಭಾಷೆ",
    'mus'   => 'ಕ್ರೀಕ್',
    'mwl'   => 'ಕಿರಾಂಡೀಸ್',
    'mwr'   => 'ಮಾರ್ವಾಡಿ',
    'my'    => 'ಬರ್ಮೀಸ್',
    'myn'   => "ಮಯನ್\ ಭಾಷೆ",
    'myv'   => 'ಎರ್‌ಝ್ಯಾ',
    'na'    => 'ನೌರು',
    'nah'   => 'ನಹೌಟಿ',
    'nai'   => "ಉತ್ತರ\ ಅಮೇರಿಕದ\ ಇಂಡಿಯನ್\ ಭಾಷೆ",
    'nap'   => 'ನಿಯಾಪೊಲಿಟನ್',
    'nb'    => "ನೋರ್ವೇಜಿಯನ್\ ಬೊಕ್ಮಲ್",
    'nd'    => "ಉತ್ತರ\ ದೆಬೆಲೆ",
    'nds'   => "ಲೋ\ ಜರ್ಮನ್",
    'ne'    => 'ನೇಪಾಳಿ',
    'new'   => 'ನೇವಾರೀ',
    'ng'    => 'ಡೋಂಗಾ',
    'nia'   => 'ನಿಯಾಸ್',
    'nic'   => "ನೈಗರ್\-ಕೊರ್ಡೊಫನಿಯನ್\ ಭಾಷೆ",
    'niu'   => 'ನಿಯುವನ್',
    'nl'    => 'ಡಚ್',
    'nl_be' => 'ಫ್ಲೆಮಿಷ್',
    'nn'    => "ನಾರ್ವೇಜಿಯನ್\ ನೂನಾರ್ಸ್ಕ್",
    'no'    => 'ನಾರ್ವೇಜಿಯನ್',
    'nog'   => 'ನೊಗಾಯ್',
    'non'   => "ಪ್ರಾಚೀನ\ ನೋರ್ಸ್",
    'nqo'   => 'ಎನ್‌ಕೋ',
    'nr'    => "ದಕ್ಷಿಣ\ ದೆಬೆಲೆ",
    'nso'   => "ಉತ್ತರ\ ಸೋಥೋ",
    'nub'   => "ನುಬಿಯನ್\ ಭಾಷೆ",
    'nv'    => 'ನವಾಜೊ',
    'nwc'   => "ಶಾಸ್ತ್ರೀಯ\ ನೇವಾರಿ",
    'ny'    => 'ನ್ಯಾಂಜಾ',
    'nym'   => 'ನ್ಯಾಮ್‌ವೆಂಜಿ',
    'nyn'   => 'ನ್ಯಾನ್‌ಕೋಲೆ',
    'nyo'   => 'ನ್ಯೋರೋ',
    'nzi'   => 'ಜೀಮಾ',
    'oc'    => 'ಆಕ್ಸಿಟಾನ್',
    'oj'    => 'ಒಜಿಬ್ವಾ',
    'om'    => 'ಒರೊಮೊ',
    'or'    => 'ಓರಿಯಾ',
    'os'    => 'ಒಸ್ಸೆಟಿಕ್',
    'osa'   => 'ಓಸಾಜ್',
    'ota'   => "ಒಟ್ಟೋಮನ್\ ತುರ್ಕಿಷ್",
    'oto'   => "ಒಟ್ಟೋಮನ್\ ಭಾಷೆ",
    'pa'    => 'ಪಂಜಾಬಿ',
    'paa'   => "ಪಪುವನ್\ ಭಾಷೆ",
    'pag'   => 'ಪಂಗಾಸಿನನ್',
    'pal'   => 'ಪಹ್ಲವಿ',
    'pam'   => 'ಪಂಪಾಂಗಾ',
    'pap'   => 'ಪಾಪಿಯಮೆಂಟೋ',
    'pau'   => 'ಪಲುಆನ್',
    'peo'   => "ಪ್ರಾಚೀನ\ ಪರ್ಶಿಯನ್",
    'phi'   => "ಫಿಲಿಫೈನ್\ ಭಾಷೆ",
    'phn'   => 'ಫೀನಿಷಿಯನ್',
    'pi'    => 'ಪಾಲಿ',
    'pl'    => 'ಪೋಲಿಶ್',
    'pon'   => 'ಪೋನ್‌‌ಪಿಯನ್',
    'pra'   => "ಪ್ರಾಕೃತ್\ ಭಾಷೆ",
    'pro'   => "ಪ್ರಾಚೀನ\ ಪ್ರೊವೆನ್ಶಿಯಲ್",
    'ps'    => 'ಪಾಷ್ಟೋ',
    'pt'    => 'ಪೋರ್ಚುಗೀಸ್',
    'pt_br' => "ಬ್ರೆಜಿಲಿಯನ್\ ಪೋರ್ಚುಗೀಸ್",
    'pt_pt' => "ಐಬೀರಿಯನ್\ ಪೋರ್ಚುಗೀಸ್",
    'qu'    => 'ಕ್ವೆಚುವಾ',
    'raj'   => 'ರಾಜಾಸ್ಥಾನಿ',
    'rap'   => 'ರಾಪಾನುಯಿ',
    'rar'   => 'ರಾರೋಟೊಂಗನ್',
    'rm'    => "ರಹೇಟೋ\-ರೋಮ್ಯಾನ್ಸ್",
    'rn'    => 'ರುಂಡಿ',
    'ro'    => 'ರೊಮ್ಯಾನಿಯನ್',
    'roa'   => "ರೋಮನ್\ ಭಾಷೆ",
    'rom'   => 'ರೋಮಾನಿ',
    'ru'    => 'ರಶಿಯನ್',
    'rup'   => 'ಅರೋಮಾನಿಯನ್',
    'rw'    => 'ಕೀನ್ಯಾರುವಾಂಡಾ',
    'sa'    => 'ಸಂಸ್ಕೃತ',
    'sad'   => 'ಸಂಡಾವೇ',
    'sah'   => 'ಯಾಕುಟ್',
    'sai'   => "ದಕ್ಷಿಣ\ ಅಮೇರಿಕದ\ ಇಂಡಿಯನ್\ ಭಾಷೆ",
    'sal'   => "ಸಲಿಷನ್\ ಭಾಷೆ",
    'sam'   => "ಸಮರಿಟನ್\ ಅರಾಮಿಕ್",
    'sas'   => 'ಸಸಾಕ್',
    'sat'   => 'ಸಂತಾಲಿ',
    'sc'    => 'ಸರ್ಡೀನಿಯನ್',
    'scn'   => 'ಸಿಸಿಲಿಯನ್',
    'sco'   => 'ಸ್ಕೋಟ್ಸ್',
    'sd'    => 'ಸಿಂಧಿ',
    'se'    => "ಉತ್ತರ\ ಸಾಮಿ",
    'sel'   => 'ಸೆಲ್ಕಪ್',
    'sem'   => "ಸೆಮಿಟಿಕ್\ ಭಾಷೆ",
    'sg'    => 'ಸಾಂಗೋ',
    'sga'   => "ಪ್ರಾಚೀನ\ ಐರಿಷ್",
    'sgn'   => "ಸಂಜ್ಞಾ\ ಭಾಷೆ",
    'sh'    => "ಸರ್ಬೋ\-ಕ್ರೊಯೇಶಿಯನ್",
    'shn'   => 'ಶಾನ್',
    'si'    => 'ಸಿಂಹಳ',
    'sid'   => 'ಸಿಡಾಮೋ',
    'sio'   => "ಸಿವುಅನ್\ ಭಾಷೆ",
    'sit'   => "ಸೈನೋ\-ಟಿಬೇಟಿಯನ್\ ಭಾಷೆ",
    'sk'    => 'ಸ್ಲೋವಾಕ್',
    'sl'    => 'ಸ್ಲೋವೇನಿಯನ್',
    'sla'   => "ಸ್ಲಾವಿಕ್\ ಭಾಷೆ",
    'sm'    => 'ಸಮೋವನ್',
    'sma'   => "ದಕ್ಷಿಣ\ ಸಾಮಿ",
    'smi'   => "ಸಾಮಿ\ ಭಾಷೆ",
    'smj'   => "ಲೂಲ್\ ಸಾಮಿ",
    'smn'   => "ಇನರಿ\ ಸಾಮಿ",
    'sms'   => "ಸ್ಕೋಟ್\ ಸಾಮಿ",
    'sn'    => 'ಶೋನಾ',
    'snk'   => 'ಸೋನಿಂಕೆ',
    'so'    => 'ಸೋಮಾಲಿ',
    'sog'   => 'ಸೋಗ್ಡಿಏನ್',
    'son'   => 'ಸೋಂಘಾಯ್',
    'sq'    => 'ಅಲ್ಬೇನಿಯನ್',
    'sr'    => 'ಸರ್ಬಿಯನ್',
    'srn'   => "ಸ್ರಾನನ್\ ಟೋಂಗೋ",
    'srr'   => 'ಸೇರೇರ್',
    'ss'    => 'ಸ್ವಾತಿ',
    'ssa'   => "ನಿಲೋ\-ಸಹಾರನ್\ ಭಾಷೆ",
    'st'    => "ದಕ್ಷಿಣ\ ಸೋಥೋ",
    'su'    => 'ಸುಂಡಾನೀಸ್',
    'suk'   => 'ಸುಕುಮಾ',
    'sus'   => 'ಸುಸು',
    'sux'   => 'ಸುಮೇರಿಯನ್',
    'sv'    => 'ಸ್ವೀಡಿಷ್',
    'sw'    => 'ಸ್ವಹಿಲಿ',
    'syc'   => "ಶಾಸ್ತ್ರೀಯ\ ಸಿರಿಯಕ್",
    'syr'   => 'ಸಿರಿಯಕ್',
    'ta'    => 'ತಮಿಳು',
    'tai'   => "ಥಾಯ್\ ಭಾಷೆ",
    'te'    => 'ತೆಲುಗು',
    'tem'   => 'ಟಿಮ್ನೆ',
    'ter'   => 'ಟೆರೆನೋ',
    'tet'   => 'ಟೇಟಮ್',
    'tg'    => 'ತಾಜಿಕ್',
    'th'    => 'ಥಾಯಿ',
    'ti'    => 'ಟೈಗ್ರಿನ್ಯಾ',
    'tig'   => 'ಟೈಗ್ರೆ',
    'tiv'   => 'ಟಿವ್',
    'tk'    => 'ಟರ್ಕ್‌ಮೆನ್',
    'tkl'   => 'ಟೊಕೆಲಾವ್',
    'tl'    => 'ಟ್ಯಾಗಲೋಗ್',
    'tlh'   => 'ಕ್ಲಿಂಗೋನ್',
    'tli'   => 'ಟ್ಲಿಂಗಿಟ್',
    'tmh'   => 'ಟಮಾಷೆಕ್',
    'tn'    => 'ಸ್ವಾನಾ',
    'to'    => 'ಟೊಂಗಾ',
    'tog'   => "ನ್ಯಾಸಾ\ ಟೋಂಗಾ",
    'tpi'   => "ಟೋಕ್\ ಪಿಸಿನ್",
    'tr'    => 'ಟರ್ಕಿಶ್',
    'trv'   => 'Taroko',
    'ts'    => 'ಸೋಂಗಾ',
    'tsi'   => 'ಸಿಂಶಿಯನ್',
    'tt'    => 'ಟಾಟರ್',
    'tum'   => 'ಟುಂಬುಕ',
    'tup'   => "ಟೂಪಿ\ ಭಾಷೆ",
    'tut'   => "ಆಲ್ಟಾಯಿಕ್\ ಭಾಷೆ",
    'tvl'   => 'ಟುವಾಲು',
    'tw'    => 'ಟ್ವಿ',
    'ty'    => 'ತಹಿತಿಯನ್',
    'tyv'   => 'ಟುವಿನಿಯನ್',
    'udm'   => 'ಉಡ್‌ಮುರ್ಟ್',
    'ug'    => 'ಉಯಿಘರ್',
    'uga'   => 'ಉಗಾರಿಟಿಕ್',
    'uk'    => 'ಉಕ್ರೈನಿಯನ್',
    'umb'   => 'ಉಂಬುಂಡು',
    'und'   => "ಅಪರಿಚಿತ\ ಅಥವಾ\ ಅಮಾನ್ಯ\ ಭಾಷೆ",
    'ur'    => 'ಉರ್ದು',
    'uz'    => 'ಉಜ್ಬೇಕ್',
    'vai'   => 'ವಾಯಿ',
    've'    => 'ವೆಂಡಾ',
    'vi'    => 'ವಿಯೇಟ್ನಾಮೀಸ್',
    'vo'    => 'ವೋಲಾಪುಕ್',
    'vot'   => 'ವೋಟಿಕ್',
    'wa'    => 'ವಾಲೂನ್',
    'wak'   => "ವಾಕಾಷನ್\ ಭಾಷೆ",
    'wal'   => 'ವಲಾಮೋ',
    'war'   => 'ವರಾಯ್',
    'was'   => 'ವಾಷೋ',
    'wen'   => "ಸೋರ್ಬಿಯನ್\ ಭಾಷೆ",
    'wo'    => 'ವೋಲೋಫ್',
    'xal'   => 'ಕಲ್‌ಮೈಕ್',
    'xh'    => 'ಷೋಸಾ',
    'yao'   => 'ಯಾಓ',
    'yap'   => 'ಯಪೀಸೆ',
    'yi'    => 'ಯಿಡ್ಡಿಷ್',
    'yo'    => 'ಯೊರುಬಾ',
    'ypk'   => "ಯೂಪಿಕ್\ ಭಾಷೆ",
    'za'    => 'ಝೂವಾಂಗ್',
    'zap'   => 'ಝೋಪೊಟೆಕ್',
    'zbl'   => 'ಬ್ಲಿಸ್‌ಸಿಂಬಲ್ಸ್',
    'zen'   => 'ಝೆನಾಗಾ',
    'zh'    => 'ಚೈನೀಸ್',
    'znd'   => 'ಝಂಡೇ',
    'zu'    => 'ಜುಲು',
    'zun'   => 'ಝೂನಿ',
    'zxx'   => "ಯಾವುದೇ\ ಭಾಷಾಸಂಬಂಧಿ\ ವಿಷಯವಿಲ್ಲ",
    'zza'   => 'ಜಾಝಾ',
);

%Locales::DB::Language::kn::name_to_code = (
    ''         => 'zza',
    "\ "       => 'ypk',
    "\ \ "     => 'zxx',
    "\ \ \ "   => 'und',
    "\ \ \ \ " => 'cpp',
    'morisyen' => 'mfe',
    'taroko'   => 'trv',
);

1;
