package Locales::DB::Language::fi;

# Auto generated from CLDR

$Locales::DB::Language::fi::VERSION = '0.01';

$Locales::DB::Language::fi::cldr_version = '1.7.1';

%Locales::DB::Language::fi::misc_info = (
    'cldr_formats' => {
        'decimal'   => "\#\,\#\#0\.\#\#\#",
        'language'  => "kieli\:\ \{0\}",
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0 \%",
        'territory' => "alue\:\ \{0\}"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr'  => "ei\:e",
        'yesstr' => "kyllä\:kylla\:k"
    },
);

%Locales::DB::Language::fi::code_to_name = (
    'aa'    => 'afar',
    'ab'    => 'abhaasi',
    'ace'   => 'aceh',
    'ach'   => 'atšoli',
    'ada'   => 'adangme',
    'ady'   => 'adyge',
    'ae'    => 'avesta',
    'af'    => 'afrikaans',
    'afa'   => "afro\-aasialainen\ kieli",
    'afh'   => 'afrihili',
    'ain'   => 'ainu',
    'ak'    => 'akan',
    'akk'   => 'akkadi',
    'ale'   => 'aleutti',
    'alg'   => "algonkin\-kieli",
    'alt'   => 'altai',
    'am'    => 'amhara',
    'an'    => 'aragonia',
    'ang'   => 'muinaisenglanti',
    'anp'   => 'angika',
    'apa'   => 'apaššikieli',
    'ar'    => 'arabia',
    'arc'   => 'aramea',
    'arn'   => 'araukaani',
    'arp'   => 'arapaho',
    'art'   => "keinotekoinen\ kieli",
    'arw'   => 'arawak',
    'as'    => 'assami',
    'ast'   => 'asturia',
    'ath'   => "athabasca\-kieli",
    'aus'   => "australialainen\ kieli",
    'av'    => 'avaari',
    'awa'   => 'awadhi',
    'ay'    => 'aimara',
    'az'    => 'azeri',
    'ba'    => 'baškiiri',
    'bad'   => 'banda',
    'bai'   => "bamileke\-kieli",
    'bal'   => 'belutši',
    'ban'   => 'bali',
    'bas'   => 'basa',
    'bat'   => "balttilainen\ kieli",
    'be'    => 'valkovenäjä',
    'bej'   => 'bedža',
    'bem'   => 'bemba',
    'ber'   => 'berberikieli',
    'bg'    => 'bulgaria',
    'bh'    => 'bihari',
    'bho'   => 'bhodžpuri',
    'bi'    => 'bislama',
    'bik'   => 'bikol',
    'bin'   => 'bini',
    'bla'   => 'mustajalka',
    'bm'    => 'bambara',
    'bn'    => 'bengali',
    'bnt'   => 'bantukieli',
    'bo'    => 'tiibet',
    'br'    => 'bretoni',
    'bra'   => 'bradž',
    'bs'    => 'bosnia',
    'btk'   => 'batak',
    'bua'   => 'burjaatti',
    'bug'   => 'bugi',
    'byn'   => 'bilin',
    'ca'    => 'katalaani',
    'cad'   => 'caddo',
    'cai'   => "keskiamerikkalainen\ intiaanikieli",
    'car'   => 'karibi',
    'cau'   => "kaukasialainen\ kieli",
    'cch'   => 'atsam',
    'ce'    => 'tšetšeeni',
    'ceb'   => 'cebuano',
    'cel'   => "kelttiläinen\ kieli",
    'ch'    => 'tšamorro',
    'chb'   => 'tšibtša',
    'chg'   => 'tšagatai',
    'chk'   => 'chuuk',
    'chm'   => 'mari',
    'chn'   => "chinook\-jargon",
    'cho'   => 'choctaw',
    'chp'   => 'chipewyan',
    'chr'   => 'cherokee',
    'chy'   => 'cheyenne',
    'cmc'   => "tšam\-kieli",
    'co'    => 'korsika',
    'cop'   => 'kopti',
    'cpe'   => "englantiin\ perustuva\ kreoli\-\ tai\ pidgin\-kieli",
    'cpf'   => "ranskaan\ perustuva\ kreoli\-\ tai\ pidgin\-kieli",
    'cpp'   => "portugaliin\ perustuva\ kreoli\-\ tai\ pidgin\-kieli",
    'cr'    => 'cree',
    'crh'   => 'kriminturkki',
    'crp'   => "kreoli\-\ tai\ pidgin\-kieli",
    'cs'    => 'tšekki',
    'csb'   => 'kašubi',
    'cu'    => 'kirkkoslaavi',
    'cus'   => "kuušilainen\ kieli",
    'cv'    => 'tšuvassi',
    'cy'    => 'kymri',
    'da'    => 'tanska',
    'dak'   => 'dakota',
    'dar'   => 'dargi',
    'day'   => "bidayuh\ kieli",
    'de'    => 'saksa',
    'de_at' => 'itävallansaksa',
    'de_ch' => 'sveitsinyläsaksa',
    'del'   => 'delaware',
    'den'   => 'slevi',
    'dgr'   => 'dogrib',
    'din'   => 'dinka',
    'doi'   => 'dogri',
    'dra'   => 'dravidakieli',
    'dsb'   => 'alasorbi',
    'dua'   => 'duala',
    'dum'   => 'keskihollanti',
    'dv'    => 'divehi',
    'dyu'   => 'djula',
    'dz'    => 'dzongkha',
    'ee'    => 'ewe',
    'efi'   => 'efik',
    'egy'   => 'muinaisegypti',
    'eka'   => 'ekajuk',
    'el'    => 'kreikka',
    'elx'   => 'elami',
    'en'    => 'englanti',
    'en_au' => 'australianenglanti',
    'en_ca' => 'kanadanenglanti',
    'en_gb' => 'britannianenglanti',
    'en_us' => 'amerikanenglanti',
    'enm'   => 'keskienglanti',
    'eo'    => 'esperanto',
    'es'    => 'espanja',
    'es_es' => 'espanjanespanja',
    'et'    => 'viro',
    'eu'    => 'baski',
    'ewo'   => 'ewondo',
    'fa'    => 'persia',
    'fan'   => 'fang',
    'fat'   => 'fanti',
    'ff'    => 'fulani',
    'fi'    => 'suomi',
    'fil'   => 'filipino',
    'fiu'   => "suomalais\-ugrilainen\ kieli",
    'fj'    => 'fidži',
    'fo'    => 'fääri',
    'fon'   => 'fon',
    'fr'    => 'ranska',
    'fr_ca' => 'kanadanranska',
    'fr_ch' => 'sveitsinranska',
    'frm'   => 'keskiranska',
    'fro'   => 'muinaisranska',
    'frr'   => 'pohjoisfriisi',
    'frs'   => 'itäfriisi',
    'fur'   => 'friuli',
    'fy'    => 'länsifriisi',
    'ga'    => 'iiri',
    'gaa'   => 'ga',
    'gay'   => 'gajo',
    'gba'   => 'gbaja',
    'gd'    => 'gaeli',
    'gem'   => "germaaninen\ kieli",
    'gez'   => 'ge’ez',
    'gil'   => 'kiribati',
    'gl'    => 'galicia',
    'gmh'   => 'keskiyläsaksa',
    'gn'    => 'guarani',
    'goh'   => 'muinaisyläsaksa',
    'gon'   => 'gondi',
    'gor'   => 'gorontalo',
    'got'   => 'gootti',
    'grb'   => 'grebo',
    'grc'   => 'muinaiskreikka',
    'gsw'   => 'sveitsinsaksa',
    'gu'    => 'gudžarati',
    'gv'    => 'manx',
    'gwi'   => 'gwitšin',
    'ha'    => 'hausa',
    'hai'   => 'haida',
    'haw'   => 'havaiji',
    'he'    => 'heprea',
    'hi'    => 'hindi',
    'hil'   => 'hiligaino',
    'him'   => 'himatšali',
    'hit'   => 'heetti',
    'hmn'   => 'hmong',
    'ho'    => "hiri\-motu",
    'hr'    => 'kroatia',
    'hsb'   => 'yläsorbi',
    'ht'    => 'haiti',
    'hu'    => 'unkari',
    'hup'   => 'hupa',
    'hy'    => 'armenia',
    'hz'    => 'herero',
    'ia'    => 'interlingua',
    'iba'   => 'iban',
    'id'    => 'indonesia',
    'ie'    => 'interlingue',
    'ig'    => 'igbo',
    'ii'    => "sichuanin\-yi",
    'ijo'   => 'idžo',
    'ik'    => 'inupiatun',
    'ilo'   => 'iloko',
    'inc'   => "indoarjalainen\ kieli",
    'ine'   => "indoeurooppalainen\ kieli",
    'inh'   => 'inguuši',
    'io'    => 'ido',
    'ira'   => "iranilainen\ kieli",
    'iro'   => 'irokeesikieli',
    'is'    => 'islanti',
    'it'    => 'italia',
    'iu'    => 'inuktitut',
    'ja'    => 'japani',
    'jbo'   => 'lojban',
    'jpr'   => 'juutalaispersia',
    'jrb'   => 'juutalaisarabia',
    'jv'    => 'jaava',
    'ka'    => 'georgia',
    'kaa'   => 'karakalpakki',
    'kab'   => 'kabyyli',
    'kac'   => 'kachin',
    'kaj'   => 'jju',
    'kam'   => 'kamba',
    'kar'   => 'karen',
    'kaw'   => 'kavi',
    'kbd'   => 'kabardi',
    'kcg'   => 'tyap',
    'kfo'   => 'norsunluurannikonkoro',
    'kg'    => 'kongo',
    'kha'   => 'khasi',
    'khi'   => "khoisan\-kieli",
    'kho'   => 'khotani',
    'ki'    => 'kikuju',
    'kj'    => 'kuanjama',
    'kk'    => 'kazakki',
    'kl'    => 'grönlanti',
    'km'    => 'khmer',
    'kmb'   => 'kimbundu',
    'kn'    => 'kannada',
    'ko'    => 'korea',
    'kok'   => 'konkani',
    'kos'   => 'kosrae',
    'kpe'   => 'kpelle',
    'kr'    => 'kanuri',
    'krc'   => "karatšai\-balkaari",
    'krl'   => 'karjala',
    'kro'   => "kru\-kieli",
    'kru'   => 'kurukh',
    'ks'    => 'kašmiri',
    'ku'    => 'kurdi',
    'kum'   => 'kumykki',
    'kut'   => 'kutenai',
    'kv'    => 'komi',
    'kw'    => 'korni',
    'ky'    => 'kirgiisi',
    'la'    => 'latina',
    'lad'   => 'juutalaisespanja',
    'lah'   => 'lahnda',
    'lam'   => 'lamba',
    'lb'    => 'luxemburg',
    'lez'   => 'lezgi',
    'lg'    => 'ganda',
    'li'    => 'limburg',
    'ln'    => 'lingala',
    'lo'    => 'lao',
    'lol'   => 'mongo',
    'loz'   => 'lozi',
    'lt'    => 'liettua',
    'lu'    => 'katanganluba',
    'lua'   => 'luluanluba',
    'lui'   => 'luiseño',
    'lun'   => 'lunda',
    'luo'   => 'luo',
    'lus'   => 'lusai',
    'lv'    => 'latvia',
    'mad'   => 'madura',
    'mag'   => 'magahi',
    'mai'   => 'maithili',
    'mak'   => 'makassar',
    'man'   => 'mandingo',
    'map'   => "austronesialainen\ kieli",
    'mas'   => 'maasai',
    'mdf'   => 'mokša',
    'mdr'   => 'mandar',
    'men'   => 'mende',
    'mfe'   => 'Morisyen',
    'mg'    => 'malagassi',
    'mga'   => "keski\-iiri",
    'mh'    => 'marshall',
    'mi'    => 'maori',
    'mic'   => 'micmac',
    'min'   => 'minangkabau',
    'mis'   => "luokittelematon\ kieli",
    'mk'    => 'makedonia',
    'mkh'   => "mon\-khmer\-kieli",
    'ml'    => 'malajalam',
    'mn'    => 'mongoli',
    'mnc'   => 'mantšu',
    'mni'   => 'manipuri',
    'mno'   => "manobo\-kieli",
    'mo'    => 'moldavia',
    'moh'   => 'mohawk',
    'mos'   => 'mossi',
    'mr'    => 'marathi',
    'ms'    => 'malaiji',
    'mt'    => 'malta',
    'mul'   => "monia\ kieliä",
    'mun'   => 'mundakieli',
    'mus'   => 'creek',
    'mwl'   => 'mirandeesi',
    'mwr'   => 'marwari',
    'my'    => 'burma',
    'myn'   => "maya\-kieli",
    'myv'   => 'ersä',
    'na'    => 'nauru',
    'nah'   => 'nahuatl',
    'nai'   => "pohjoisamerikkalainen\ intiaanikieli",
    'nap'   => 'napoli',
    'nb'    => "norjan\ bokmål",
    'nd'    => "pohjois\-ndebele",
    'nds'   => 'alasaksa',
    'ne'    => 'nepali',
    'new'   => 'newari',
    'ng'    => 'ndonga',
    'nia'   => 'nias',
    'nic'   => "nigeriläis\-kongolainen\ kieli",
    'niu'   => 'niue',
    'nl'    => 'hollanti',
    'nl_be' => 'flaami',
    'nn'    => "norjan\ nynorsk",
    'no'    => 'norja',
    'nog'   => 'nogai',
    'non'   => 'muinaisnorja',
    'nqo'   => 'n’ko',
    'nr'    => "etelä\-ndebele",
    'nso'   => 'pohjoissotho',
    'nub'   => "nubialainen\ kieli",
    'nv'    => 'navajo',
    'nwc'   => "klassinen\ newari",
    'ny'    => 'njandža',
    'nym'   => 'nyamwezi',
    'nyn'   => 'nyankole',
    'nyo'   => 'nyoro',
    'nzi'   => 'nzima',
    'oc'    => 'oksitaani',
    'oj'    => 'odžibwa',
    'om'    => 'oromo',
    'or'    => 'orija',
    'os'    => 'osseetti',
    'osa'   => 'osage',
    'ota'   => 'osmani',
    'oto'   => "otomi\-kieli",
    'pa'    => 'pandžabi',
    'paa'   => 'papualaiskieli',
    'pag'   => 'pangasinan',
    'pal'   => 'pahlavi',
    'pam'   => 'pampanga',
    'pap'   => 'papiamentu',
    'pau'   => 'palau',
    'peo'   => 'muinaispersia',
    'phi'   => "filippiiniläinen\ kieli",
    'phn'   => 'foinikia',
    'pi'    => 'paali',
    'pl'    => 'puola',
    'pon'   => 'pohnpei',
    'pra'   => "prakrit\-kieli",
    'pro'   => 'muinaisprovensaali',
    'ps'    => 'paštu',
    'pt'    => 'portugali',
    'pt_br' => 'brasilianportugali',
    'pt_pt' => 'portugalinportugali',
    'qu'    => 'ketšua',
    'raj'   => 'radžastani',
    'rap'   => 'rapanui',
    'rar'   => 'rarotonga',
    'rm'    => 'retoromaani',
    'rn'    => 'rundi',
    'ro'    => 'romania',
    'roa'   => "romaaninen\ kieli",
    'rom'   => 'romani',
    'ru'    => 'venäjä',
    'rup'   => 'aromania',
    'rw'    => 'ruanda',
    'sa'    => 'sanskrit',
    'sad'   => 'sandawe',
    'sah'   => 'jakuutti',
    'sai'   => "eteläamerikkalainen\ intiaanikieli",
    'sal'   => "sališilainen\ kieli",
    'sam'   => 'samarianaramea',
    'sas'   => 'sasak',
    'sat'   => 'santali',
    'sc'    => 'sardi',
    'scn'   => 'sisilia',
    'sco'   => 'skotti',
    'sd'    => 'sindhi',
    'se'    => 'pohjoissaame',
    'sel'   => 'selkuppi',
    'sem'   => "seemiläinen\ kieli",
    'sg'    => 'sango',
    'sga'   => 'muinaisiiri',
    'sgn'   => 'viittomakieli',
    'sh'    => 'serbokroaatti',
    'shn'   => 'shan',
    'si'    => 'sinhali',
    'sid'   => 'sidamo',
    'sio'   => "sioux\-kieli",
    'sit'   => "sinotiibetiläinen\ kieli",
    'sk'    => 'slovakki',
    'sl'    => 'sloveeni',
    'sla'   => "slaavilainen\ kieli",
    'sm'    => 'samoa',
    'sma'   => 'eteläsaame',
    'smi'   => 'saamelaiskieli',
    'smj'   => 'luulajansaame',
    'smn'   => 'inarinsaame',
    'sms'   => 'koltansaame',
    'sn'    => 'šona',
    'snk'   => 'soninke',
    'so'    => 'somali',
    'sog'   => 'sogdi',
    'son'   => 'songhai',
    'sq'    => 'albania',
    'sr'    => 'serbia',
    'srn'   => 'sranan',
    'srr'   => 'serer',
    'ss'    => 'swazi',
    'ssa'   => "niililäis\-saharalainen\ kieli",
    'st'    => 'eteläsotho',
    'su'    => 'sunda',
    'suk'   => 'sukuma',
    'sus'   => 'susu',
    'sux'   => 'sumeri',
    'sv'    => 'ruotsi',
    'sw'    => 'swahili',
    'syc'   => 'muinaissyyria',
    'syr'   => 'syyria',
    'ta'    => 'tamil',
    'tai'   => 'thaikieli',
    'te'    => 'telugu',
    'tem'   => 'temne',
    'ter'   => 'tereno',
    'tet'   => 'tetum',
    'tg'    => 'tadžikki',
    'th'    => 'thai',
    'ti'    => 'tigrinja',
    'tig'   => 'tigre',
    'tiv'   => 'tiv',
    'tk'    => 'turkmeeni',
    'tkl'   => 'tokelau',
    'tl'    => 'tagalog',
    'tlh'   => 'klingon',
    'tli'   => 'tlingit',
    'tmh'   => 'tamašek',
    'tn'    => 'tswana',
    'to'    => 'tongantonga',
    'tog'   => 'malawintonga',
    'tpi'   => "tok\-pisin",
    'tr'    => 'turkki',
    'trv'   => 'Taroko',
    'ts'    => 'tsonga',
    'tsi'   => 'tsimši',
    'tt'    => 'tataari',
    'tum'   => 'tumbuka',
    'tup'   => "tupi\-kieli",
    'tut'   => "altailainen\ kieli",
    'tvl'   => 'tuvalu',
    'tw'    => 'twi',
    'ty'    => 'tahiti',
    'tyv'   => 'tuva',
    'udm'   => 'udmurtti',
    'ug'    => 'uiguuri',
    'uga'   => 'ugarit',
    'uk'    => 'ukraina',
    'umb'   => 'umbundu',
    'und'   => 'määrittämätön',
    'ur'    => 'urdu',
    'uz'    => 'uzbekki',
    'vai'   => 'vai',
    've'    => 'venda',
    'vi'    => 'vietnam',
    'vo'    => 'volapük',
    'vot'   => 'vatja',
    'wa'    => 'valloni',
    'wak'   => "wakash\-kieli",
    'wal'   => 'walamo',
    'war'   => 'waray',
    'was'   => 'washo',
    'wen'   => "sorbin\ kieli",
    'wo'    => 'wolof',
    'xal'   => 'kalmukki',
    'xh'    => 'xhosa',
    'yao'   => 'jao',
    'yap'   => 'japi',
    'yi'    => 'jiddiš',
    'yo'    => 'joruba',
    'ypk'   => 'jupikkikieli',
    'za'    => 'zhuang',
    'zap'   => 'sapoteekki',
    'zbl'   => 'blisskieli',
    'zen'   => 'zenaga',
    'zh'    => 'kiina',
    'znd'   => 'zande',
    'zu'    => 'zulu',
    'zun'   => 'zuni',
    'zxx'   => "ei\ kielellistä\ sisältöä",
    'zza'   => 'zaza',
);

%Locales::DB::Language::fi::name_to_code = (
    'abhaasi'                                          => 'ab',
    'aceh'                                             => 'ace',
    'adangme'                                          => 'ada',
    'adyge'                                            => 'ady',
    'afar'                                             => 'aa',
    'afrihili'                                         => 'afh',
    'afrikaans'                                        => 'af',
    "afroaasialainen\ kieli"                           => 'afa',
    'aimara'                                           => 'ay',
    'ainu'                                             => 'ain',
    'akan'                                             => 'ak',
    'akkadi'                                           => 'akk',
    'alasaksa'                                         => 'nds',
    'alasorbi'                                         => 'dsb',
    'albania'                                          => 'sq',
    'aleutti'                                          => 'ale',
    'algonkinkieli'                                    => 'alg',
    'altai'                                            => 'alt',
    "altailainen\ kieli"                               => 'tut',
    'amerikanenglanti'                                 => 'en_us',
    'amhara'                                           => 'am',
    'angika'                                           => 'anp',
    'apaikieli'                                        => 'apa',
    'arabia'                                           => 'ar',
    'aragonia'                                         => 'an',
    'aramea'                                           => 'arc',
    'arapaho'                                          => 'arp',
    'araukaani'                                        => 'arn',
    'arawak'                                           => 'arw',
    'armenia'                                          => 'hy',
    'aromania'                                         => 'rup',
    'assami'                                           => 'as',
    'asturia'                                          => 'ast',
    'athabascakieli'                                   => 'ath',
    'atoli'                                            => 'ach',
    'atsam'                                            => 'cch',
    "australialainen\ kieli"                           => 'aus',
    'australianenglanti'                               => 'en_au',
    "austronesialainen\ kieli"                         => 'map',
    'avaari'                                           => 'av',
    'avesta'                                           => 'ae',
    'awadhi'                                           => 'awa',
    'azeri'                                            => 'az',
    'bakiiri'                                          => 'ba',
    'bali'                                             => 'ban',
    "balttilainen\ kieli"                              => 'bat',
    'bambara'                                          => 'bm',
    'bamilekekieli'                                    => 'bai',
    'banda'                                            => 'bad',
    'bantukieli'                                       => 'bnt',
    'basa'                                             => 'bas',
    'baski'                                            => 'eu',
    'batak'                                            => 'btk',
    'beda'                                             => 'bej',
    'beluti'                                           => 'bal',
    'bemba'                                            => 'bem',
    'bengali'                                          => 'bn',
    'berberikieli'                                     => 'ber',
    'bhodpuri'                                         => 'bho',
    "bidayuh\ kieli"                                   => 'day',
    'bihari'                                           => 'bh',
    'bikol'                                            => 'bik',
    'bilin'                                            => 'byn',
    'bini'                                             => 'bin',
    'bislama'                                          => 'bi',
    'blisskieli'                                       => 'zbl',
    'bosnia'                                           => 'bs',
    'brad'                                             => 'bra',
    'brasilianportugali'                               => 'pt_br',
    'bretoni'                                          => 'br',
    'britannianenglanti'                               => 'en_gb',
    'bugi'                                             => 'bug',
    'bulgaria'                                         => 'bg',
    'burjaatti'                                        => 'bua',
    'burma'                                            => 'my',
    'caddo'                                            => 'cad',
    'cebuano'                                          => 'ceb',
    'cherokee'                                         => 'chr',
    'cheyenne'                                         => 'chy',
    'chinookjargon'                                    => 'chn',
    'chipewyan'                                        => 'chp',
    'choctaw'                                          => 'cho',
    'chuuk'                                            => 'chk',
    'cree'                                             => 'cr',
    'creek'                                            => 'mus',
    'dakota'                                           => 'dak',
    'dargi'                                            => 'dar',
    'delaware'                                         => 'del',
    'dinka'                                            => 'din',
    'divehi'                                           => 'dv',
    'djula'                                            => 'dyu',
    'dogri'                                            => 'doi',
    'dogrib'                                           => 'dgr',
    'dravidakieli'                                     => 'dra',
    'duala'                                            => 'dua',
    'dzongkha'                                         => 'dz',
    'efik'                                             => 'efi',
    "ei\ kielellist\ sislt"                            => 'zxx',
    'ekajuk'                                           => 'eka',
    'elami'                                            => 'elx',
    'englanti'                                         => 'en',
    "englantiin\ perustuva\ kreoli\ tai\ pidginkieli"  => 'cpe',
    'ers'                                              => 'myv',
    'espanja'                                          => 'es',
    'espanjanespanja'                                  => 'es_es',
    'esperanto'                                        => 'eo',
    "etelamerikkalainen\ intiaanikieli"                => 'sai',
    'etelndebele'                                      => 'nr',
    'etelsaame'                                        => 'sma',
    'etelsotho'                                        => 'st',
    'ewe'                                              => 'ee',
    'ewondo'                                           => 'ewo',
    'fang'                                             => 'fan',
    'fanti'                                            => 'fat',
    'fidi'                                             => 'fj',
    'filipino'                                         => 'fil',
    "filippiinilinen\ kieli"                           => 'phi',
    'flaami'                                           => 'nl_be',
    'foinikia'                                         => 'phn',
    'fon'                                              => 'fon',
    'fri'                                              => 'fo',
    'friuli'                                           => 'fur',
    'fulani'                                           => 'ff',
    'ga'                                               => 'gaa',
    'gaeli'                                            => 'gd',
    'gajo'                                             => 'gay',
    'galicia'                                          => 'gl',
    'ganda'                                            => 'lg',
    'gbaja'                                            => 'gba',
    'geez'                                             => 'gez',
    'georgia'                                          => 'ka',
    "germaaninen\ kieli"                               => 'gem',
    'gondi'                                            => 'gon',
    'gootti'                                           => 'got',
    'gorontalo'                                        => 'gor',
    'grebo'                                            => 'grb',
    'grnlanti'                                         => 'kl',
    'guarani'                                          => 'gn',
    'gudarati'                                         => 'gu',
    'gwitin'                                           => 'gwi',
    'haida'                                            => 'hai',
    'haiti'                                            => 'ht',
    'hausa'                                            => 'ha',
    'havaiji'                                          => 'haw',
    'heetti'                                           => 'hit',
    'heprea'                                           => 'he',
    'herero'                                           => 'hz',
    'hiligaino'                                        => 'hil',
    'himatali'                                         => 'him',
    'hindi'                                            => 'hi',
    'hirimotu'                                         => 'ho',
    'hmong'                                            => 'hmn',
    'hollanti'                                         => 'nl',
    'hupa'                                             => 'hup',
    'iban'                                             => 'iba',
    'ido'                                              => 'io',
    'igbo'                                             => 'ig',
    'iiri'                                             => 'ga',
    'iloko'                                            => 'ilo',
    'inarinsaame'                                      => 'smn',
    "indoarjalainen\ kieli"                            => 'inc',
    "indoeurooppalainen\ kieli"                        => 'ine',
    'indonesia'                                        => 'id',
    'inguui'                                           => 'inh',
    'interlingua'                                      => 'ia',
    'interlingue'                                      => 'ie',
    'inuktitut'                                        => 'iu',
    'inupiatun'                                        => 'ik',
    "iranilainen\ kieli"                               => 'ira',
    'irokeesikieli'                                    => 'iro',
    'islanti'                                          => 'is',
    'italia'                                           => 'it',
    'itfriisi'                                         => 'frs',
    'itvallansaksa'                                    => 'de_at',
    'jaava'                                            => 'jv',
    'jakuutti'                                         => 'sah',
    'jao'                                              => 'yao',
    'japani'                                           => 'ja',
    'japi'                                             => 'yap',
    'jiddi'                                            => 'yi',
    'jju'                                              => 'kaj',
    'joruba'                                           => 'yo',
    'jupikkikieli'                                     => 'ypk',
    'juutalaisarabia'                                  => 'jrb',
    'juutalaisespanja'                                 => 'lad',
    'juutalaispersia'                                  => 'jpr',
    'kabardi'                                          => 'kbd',
    'kabyyli'                                          => 'kab',
    'kachin'                                           => 'kac',
    'kalmukki'                                         => 'xal',
    'kamba'                                            => 'kam',
    'kamiri'                                           => 'ks',
    'kanadanenglanti'                                  => 'en_ca',
    'kanadanranska'                                    => 'fr_ca',
    'kannada'                                          => 'kn',
    'kanuri'                                           => 'kr',
    'karakalpakki'                                     => 'kaa',
    'karataibalkaari'                                  => 'krc',
    'karen'                                            => 'kar',
    'karibi'                                           => 'car',
    'karjala'                                          => 'krl',
    'katalaani'                                        => 'ca',
    'katanganluba'                                     => 'lu',
    'kaubi'                                            => 'csb',
    "kaukasialainen\ kieli"                            => 'cau',
    'kavi'                                             => 'kaw',
    'kazakki'                                          => 'kk',
    "keinotekoinen\ kieli"                             => 'art',
    "kelttilinen\ kieli"                               => 'cel',
    "keskiamerikkalainen\ intiaanikieli"               => 'cai',
    'keskienglanti'                                    => 'enm',
    'keskihollanti'                                    => 'dum',
    'keskiiiri'                                        => 'mga',
    'keskiranska'                                      => 'frm',
    'keskiylsaksa'                                     => 'gmh',
    'ketua'                                            => 'qu',
    'khasi'                                            => 'kha',
    'khmer'                                            => 'km',
    'khoisankieli'                                     => 'khi',
    'khotani'                                          => 'kho',
    'kiina'                                            => 'zh',
    'kikuju'                                           => 'ki',
    'kimbundu'                                         => 'kmb',
    'kirgiisi'                                         => 'ky',
    'kiribati'                                         => 'gil',
    'kirkkoslaavi'                                     => 'cu',
    "klassinen\ newari"                                => 'nwc',
    'klingon'                                          => 'tlh',
    'koltansaame'                                      => 'sms',
    'komi'                                             => 'kv',
    'kongo'                                            => 'kg',
    'konkani'                                          => 'kok',
    'kopti'                                            => 'cop',
    'korea'                                            => 'ko',
    'korni'                                            => 'kw',
    'korsika'                                          => 'co',
    'kosrae'                                           => 'kos',
    'kpelle'                                           => 'kpe',
    'kreikka'                                          => 'el',
    "kreoli\ tai\ pidginkieli"                         => 'crp',
    'kriminturkki'                                     => 'crh',
    'kroatia'                                          => 'hr',
    'krukieli'                                         => 'kro',
    'kuanjama'                                         => 'kj',
    'kumykki'                                          => 'kum',
    'kurdi'                                            => 'ku',
    'kurukh'                                           => 'kru',
    'kutenai'                                          => 'kut',
    "kuuilainen\ kieli"                                => 'cus',
    'kymri'                                            => 'cy',
    'lahnda'                                           => 'lah',
    'lamba'                                            => 'lam',
    'lao'                                              => 'lo',
    'latina'                                           => 'la',
    'latvia'                                           => 'lv',
    'lezgi'                                            => 'lez',
    'liettua'                                          => 'lt',
    'limburg'                                          => 'li',
    'lingala'                                          => 'ln',
    'lnsifriisi'                                       => 'fy',
    'lojban'                                           => 'jbo',
    'lozi'                                             => 'loz',
    'luiseo'                                           => 'lui',
    'luluanluba'                                       => 'lua',
    'lunda'                                            => 'lun',
    'luo'                                              => 'luo',
    "luokittelematon\ kieli"                           => 'mis',
    'lusai'                                            => 'lus',
    'luulajansaame'                                    => 'smj',
    'luxemburg'                                        => 'lb',
    'maasai'                                           => 'mas',
    'madura'                                           => 'mad',
    'magahi'                                           => 'mag',
    'maithili'                                         => 'mai',
    'makassar'                                         => 'mak',
    'makedonia'                                        => 'mk',
    'malagassi'                                        => 'mg',
    'malaiji'                                          => 'ms',
    'malajalam'                                        => 'ml',
    'malawintonga'                                     => 'tog',
    'malta'                                            => 'mt',
    'mandar'                                           => 'mdr',
    'mandingo'                                         => 'man',
    'manipuri'                                         => 'mni',
    'manobokieli'                                      => 'mno',
    'mantu'                                            => 'mnc',
    'manx'                                             => 'gv',
    'maori'                                            => 'mi',
    'marathi'                                          => 'mr',
    'mari'                                             => 'chm',
    'marshall'                                         => 'mh',
    'marwari'                                          => 'mwr',
    'mayakieli'                                        => 'myn',
    'mende'                                            => 'men',
    'micmac'                                           => 'mic',
    'minangkabau'                                      => 'min',
    'mirandeesi'                                       => 'mwl',
    'mohawk'                                           => 'moh',
    'moka'                                             => 'mdf',
    'moldavia'                                         => 'mo',
    'mongo'                                            => 'lol',
    'mongoli'                                          => 'mn',
    "monia\ kieli"                                     => 'mul',
    'monkhmerkieli'                                    => 'mkh',
    'morisyen'                                         => 'mfe',
    'mossi'                                            => 'mos',
    'mrittmtn'                                         => 'und',
    'muinaisegypti'                                    => 'egy',
    'muinaisenglanti'                                  => 'ang',
    'muinaisiiri'                                      => 'sga',
    'muinaiskreikka'                                   => 'grc',
    'muinaisnorja'                                     => 'non',
    'muinaispersia'                                    => 'peo',
    'muinaisprovensaali'                               => 'pro',
    'muinaisranska'                                    => 'fro',
    'muinaissyyria'                                    => 'syc',
    'muinaisylsaksa'                                   => 'goh',
    'mundakieli'                                       => 'mun',
    'mustajalka'                                       => 'bla',
    'nahuatl'                                          => 'nah',
    'napoli'                                           => 'nap',
    'nauru'                                            => 'na',
    'navajo'                                           => 'nv',
    'ndonga'                                           => 'ng',
    'nepali'                                           => 'ne',
    'newari'                                           => 'new',
    'nias'                                             => 'nia',
    "nigeriliskongolainen\ kieli"                      => 'nic',
    "niililissaharalainen\ kieli"                      => 'ssa',
    'niue'                                             => 'niu',
    'njanda'                                           => 'ny',
    'nko'                                              => 'nqo',
    'nogai'                                            => 'nog',
    'norja'                                            => 'no',
    "norjan\ bokml"                                    => 'nb',
    "norjan\ nynorsk"                                  => 'nn',
    'norsunluurannikonkoro'                            => 'kfo',
    "nubialainen\ kieli"                               => 'nub',
    'nyamwezi'                                         => 'nym',
    'nyankole'                                         => 'nyn',
    'nyoro'                                            => 'nyo',
    'nzima'                                            => 'nzi',
    'odibwa'                                           => 'oj',
    'oksitaani'                                        => 'oc',
    'ona'                                              => 'sn',
    'orija'                                            => 'or',
    'oromo'                                            => 'om',
    'osage'                                            => 'osa',
    'osmani'                                           => 'ota',
    'osseetti'                                         => 'os',
    'otomikieli'                                       => 'oto',
    'paali'                                            => 'pi',
    'pahlavi'                                          => 'pal',
    'palau'                                            => 'pau',
    'pampanga'                                         => 'pam',
    'pandabi'                                          => 'pa',
    'pangasinan'                                       => 'pag',
    'papiamentu'                                       => 'pap',
    'papualaiskieli'                                   => 'paa',
    'patu'                                             => 'ps',
    'persia'                                           => 'fa',
    "pohjoisamerikkalainen\ intiaanikieli"             => 'nai',
    'pohjoisfriisi'                                    => 'frr',
    'pohjoisndebele'                                   => 'nd',
    'pohjoissaame'                                     => 'se',
    'pohjoissotho'                                     => 'nso',
    'pohnpei'                                          => 'pon',
    'portugali'                                        => 'pt',
    "portugaliin\ perustuva\ kreoli\ tai\ pidginkieli" => 'cpp',
    'portugalinportugali'                              => 'pt_pt',
    'prakritkieli'                                     => 'pra',
    'puola'                                            => 'pl',
    'radastani'                                        => 'raj',
    'ranska'                                           => 'fr',
    "ranskaan\ perustuva\ kreoli\ tai\ pidginkieli"    => 'cpf',
    'rapanui'                                          => 'rap',
    'rarotonga'                                        => 'rar',
    'retoromaani'                                      => 'rm',
    "romaaninen\ kieli"                                => 'roa',
    'romani'                                           => 'rom',
    'romania'                                          => 'ro',
    'ruanda'                                           => 'rw',
    'rundi'                                            => 'rn',
    'ruotsi'                                           => 'sv',
    'saamelaiskieli'                                   => 'smi',
    'saksa'                                            => 'de',
    "saliilainen\ kieli"                               => 'sal',
    'samarianaramea'                                   => 'sam',
    'samoa'                                            => 'sm',
    'sandawe'                                          => 'sad',
    'sango'                                            => 'sg',
    'sanskrit'                                         => 'sa',
    'santali'                                          => 'sat',
    'sapoteekki'                                       => 'zap',
    'sardi'                                            => 'sc',
    'sasak'                                            => 'sas',
    "seemilinen\ kieli"                                => 'sem',
    'selkuppi'                                         => 'sel',
    'serbia'                                           => 'sr',
    'serbokroaatti'                                    => 'sh',
    'serer'                                            => 'srr',
    'shan'                                             => 'shn',
    'sichuaninyi'                                      => 'ii',
    'sidamo'                                           => 'sid',
    'sindhi'                                           => 'sd',
    'sinhali'                                          => 'si',
    "sinotiibetilinen\ kieli"                          => 'sit',
    'siouxkieli'                                       => 'sio',
    'sisilia'                                          => 'scn',
    'skotti'                                           => 'sco',
    "slaavilainen\ kieli"                              => 'sla',
    'slevi'                                            => 'den',
    'slovakki'                                         => 'sk',
    'sloveeni'                                         => 'sl',
    'sogdi'                                            => 'sog',
    'somali'                                           => 'so',
    'songhai'                                          => 'son',
    'soninke'                                          => 'snk',
    "sorbin\ kieli"                                    => 'wen',
    'sranan'                                           => 'srn',
    'sukuma'                                           => 'suk',
    'sumeri'                                           => 'sux',
    'sunda'                                            => 'su',
    "suomalaisugrilainen\ kieli"                       => 'fiu',
    'suomi'                                            => 'fi',
    'susu'                                             => 'sus',
    'sveitsinranska'                                   => 'fr_ch',
    'sveitsinsaksa'                                    => 'gsw',
    'sveitsinylsaksa'                                  => 'de_ch',
    'swahili'                                          => 'sw',
    'swazi'                                            => 'ss',
    'syyria'                                           => 'syr',
    'tadikki'                                          => 'tg',
    'tagalog'                                          => 'tl',
    'tagatai'                                          => 'chg',
    'tahiti'                                           => 'ty',
    'tamaek'                                           => 'tmh',
    'tamil'                                            => 'ta',
    'tamkieli'                                         => 'cmc',
    'tamorro'                                          => 'ch',
    'tanska'                                           => 'da',
    'taroko'                                           => 'trv',
    'tataari'                                          => 'tt',
    'tekki'                                            => 'cs',
    'telugu'                                           => 'te',
    'temne'                                            => 'tem',
    'tereno'                                           => 'ter',
    'teteeni'                                          => 'ce',
    'tetum'                                            => 'tet',
    'thai'                                             => 'th',
    'thaikieli'                                        => 'tai',
    'tibta'                                            => 'chb',
    'tigre'                                            => 'tig',
    'tigrinja'                                         => 'ti',
    'tiibet'                                           => 'bo',
    'tiv'                                              => 'tiv',
    'tlingit'                                          => 'tli',
    'tokelau'                                          => 'tkl',
    'tokpisin'                                         => 'tpi',
    'tongantonga'                                      => 'to',
    'tsimi'                                            => 'tsi',
    'tsonga'                                           => 'ts',
    'tswana'                                           => 'tn',
    'tumbuka'                                          => 'tum',
    'tupikieli'                                        => 'tup',
    'turkki'                                           => 'tr',
    'turkmeeni'                                        => 'tk',
    'tuva'                                             => 'tyv',
    'tuvalu'                                           => 'tvl',
    'tuvassi'                                          => 'cv',
    'twi'                                              => 'tw',
    'tyap'                                             => 'kcg',
    'udmurtti'                                         => 'udm',
    'ugarit'                                           => 'uga',
    'uiguuri'                                          => 'ug',
    'ukraina'                                          => 'uk',
    'umbundu'                                          => 'umb',
    'unkari'                                           => 'hu',
    'urdu'                                             => 'ur',
    'uzbekki'                                          => 'uz',
    'vai'                                              => 'vai',
    'valkovenj'                                        => 'be',
    'valloni'                                          => 'wa',
    'vatja'                                            => 'vot',
    'venda'                                            => 've',
    'venj'                                             => 'ru',
    'vietnam'                                          => 'vi',
    'viittomakieli'                                    => 'sgn',
    'viro'                                             => 'et',
    'volapk'                                           => 'vo',
    'wakashkieli'                                      => 'wak',
    'walamo'                                           => 'wal',
    'waray'                                            => 'war',
    'washo'                                            => 'was',
    'wolof'                                            => 'wo',
    'xhosa'                                            => 'xh',
    'ylsorbi'                                          => 'hsb',
    'zande'                                            => 'znd',
    'zaza'                                             => 'zza',
    'zenaga'                                           => 'zen',
    'zhuang'                                           => 'za',
    'zulu'                                             => 'zu',
    'zuni'                                             => 'zun',
);

1;
