package Locales::DB::Language::es;

# Auto generated from CLDR

$Locales::DB::Language::es::VERSION = '0.01';

$Locales::DB::Language::es::cldr_version = '1.7.1';

%Locales::DB::Language::es::misc_info = (
    'cldr_formats' => {
        'decimal'   => "\#\,\#\#0\.\#\#\#",
        'language'  => "Idioma\:\ \{0\}",
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Región\:\ \{0\}"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr'  => "no\:n",
        'yesstr' => "sí\:si\:s"
    },
);

%Locales::DB::Language::es::code_to_name = (
    'aa'    => 'afar',
    'ab'    => 'abjasio',
    'ace'   => 'acehnés',
    'ach'   => 'acoli',
    'ada'   => 'adangme',
    'ady'   => 'adigeo',
    'ae'    => 'avéstico',
    'af'    => 'afrikaans',
    'afa'   => "lengua\ afroasiática",
    'afh'   => 'afrihili',
    'ain'   => 'ainu',
    'ak'    => 'akan',
    'akk'   => 'acadio',
    'ale'   => 'aleutiano',
    'alg'   => "lenguas\ algonquinas",
    'alt'   => "altái\ meridional",
    'am'    => 'amárico',
    'an'    => 'aragonés',
    'ang'   => "inglés\ antiguo",
    'anp'   => 'angika',
    'apa'   => "lenguas\ apache",
    'ar'    => 'árabe',
    'arc'   => 'arameo',
    'arn'   => 'mapudungun',
    'arp'   => 'arapaho',
    'art'   => "lengua\ artificial",
    'arw'   => 'arahuaco',
    'as'    => 'asamés',
    'ast'   => 'asturiano',
    'ath'   => "lenguas\ atabascas",
    'aus'   => "lenguas\ australianas",
    'av'    => 'avar',
    'awa'   => 'avadhi',
    'ay'    => 'aimara',
    'az'    => 'azerí',
    'ba'    => 'bashkir',
    'bad'   => 'banda',
    'bai'   => "lenguas\ bamileke",
    'bal'   => 'baluchi',
    'ban'   => 'balinés',
    'bas'   => 'basa',
    'bat'   => "lengua\ báltica",
    'be'    => 'bielorruso',
    'bej'   => 'beja',
    'bem'   => 'bemba',
    'ber'   => 'bereber',
    'bg'    => 'búlgaro',
    'bh'    => 'bihari',
    'bho'   => 'bhojpuri',
    'bi'    => 'bislama',
    'bik'   => 'bicol',
    'bin'   => 'bini',
    'bla'   => 'siksika',
    'bm'    => 'bambara',
    'bn'    => 'bengalí',
    'bnt'   => 'bantú',
    'bo'    => 'tibetano',
    'br'    => 'bretón',
    'bra'   => 'braj',
    'bs'    => 'bosnio',
    'btk'   => 'batak',
    'bua'   => 'buriat',
    'bug'   => 'buginés',
    'byn'   => 'blin',
    'ca'    => 'catalán',
    'cad'   => 'caddo',
    'cai'   => "lengua\ india\ centroamericana",
    'car'   => 'caribe',
    'cau'   => "lengua\ caucásica",
    'cch'   => 'atsam',
    'ce'    => 'checheno',
    'ceb'   => 'cebuano',
    'cel'   => "lengua\ celta",
    'ch'    => 'chamorro',
    'chb'   => 'chibcha',
    'chg'   => 'chagatái',
    'chk'   => 'trukés',
    'chm'   => 'marí',
    'chn'   => "jerga\ chinuk",
    'cho'   => 'choctaw',
    'chp'   => 'chipewyan',
    'chr'   => 'cherokee',
    'chy'   => 'cheyene',
    'cmc'   => "lenguas\ chámicas",
    'co'    => 'corso',
    'cop'   => 'copto',
    'cpe'   => "lengua\ criolla\ o\ pidgin\ basada\ en\ el\ inglés",
    'cpf'   => "lengua\ criolla\ o\ pidgin\ basada\ en\ el\ francés",
    'cpp'   => "lengua\ criolla\ o\ pidgin\ basada\ en\ el\ portugués",
    'cr'    => 'cree',
    'crh'   => "tártaro\ de\ Crimea",
    'crp'   => "lengua\ criolla\ o\ pidgin",
    'cs'    => 'checo',
    'csb'   => 'casubio',
    'cu'    => "eslavo\ eclesiástico",
    'cus'   => "lengua\ cusita",
    'cv'    => 'chuvash',
    'cy'    => 'galés',
    'da'    => 'danés',
    'dak'   => 'dakota',
    'dar'   => 'dargva',
    'day'   => 'dayak',
    'de'    => 'alemán',
    'de_at' => "alemán\ austríaco",
    'de_ch' => "alto\ alemán\ de\ Suiza",
    'del'   => 'delaware',
    'den'   => 'slave',
    'dgr'   => 'dogrib',
    'din'   => 'dinka',
    'doi'   => 'dogri',
    'dra'   => "lengua\ dravídica",
    'dsb'   => "sorbio\ inferior",
    'dua'   => 'duala',
    'dum'   => "neerlandés\ medieval",
    'dv'    => 'divehi',
    'dyu'   => 'diula',
    'dz'    => 'dzongkha',
    'ee'    => 'ewe',
    'efi'   => 'efik',
    'egy'   => "egipcio\ antiguo",
    'eka'   => 'ekajuk',
    'el'    => 'griego',
    'elx'   => 'elamita',
    'en'    => 'inglés',
    'en_au' => "inglés\ australiano",
    'en_ca' => "inglés\ canadiense",
    'en_gb' => "inglés\ británico",
    'en_us' => "inglés\ estadounidense",
    'enm'   => "inglés\ medieval",
    'eo'    => 'esperanto',
    'es'    => 'español',
    'es_es' => "español\ de\ España",
    'et'    => 'estonio',
    'eu'    => 'vasco',
    'ewo'   => 'ewondo',
    'fa'    => 'persa',
    'fan'   => 'fang',
    'fat'   => 'fanti',
    'ff'    => 'fula',
    'fi'    => 'finés',
    'fil'   => 'filipino',
    'fiu'   => "lengua\ fino\-ugria",
    'fj'    => 'fidjiano',
    'fo'    => 'feroés',
    'fon'   => 'fon',
    'fr'    => 'francés',
    'fr_ca' => "francés\ canadiense",
    'fr_ch' => "francés\ de\ Suiza",
    'frm'   => "francés\ medieval",
    'fro'   => "francés\ antiguo",
    'frr'   => "frisón\ septentrional",
    'frs'   => "frisón\ oriental",
    'fur'   => 'friulano',
    'fy'    => 'frisón',
    'ga'    => 'irlandés',
    'gaa'   => 'ga',
    'gay'   => 'gayo',
    'gba'   => 'gbaya',
    'gd'    => "gaélico\ escocés",
    'gem'   => "lengua\ germánica",
    'gez'   => 'geez',
    'gil'   => 'gilbertense',
    'gl'    => 'gallego',
    'gmh'   => "alemán\ de\ la\ alta\ edad\ media",
    'gn'    => 'guaraní',
    'goh'   => "alemán\ de\ la\ alta\ edad\ antigua",
    'gon'   => 'gondi',
    'gor'   => 'gorontalo',
    'got'   => 'gótico',
    'grb'   => 'grebo',
    'grc'   => "griego\ antiguo",
    'gsw'   => "alemán\ suizo",
    'gu'    => 'gujarati',
    'gv'    => "gaélico\ manés",
    'gwi'   => 'kutchin',
    'ha'    => 'hausa',
    'hai'   => 'haida',
    'haw'   => 'hawaiano',
    'he'    => 'hebreo',
    'hi'    => 'hindi',
    'hil'   => 'hiligaynon',
    'him'   => 'himachali',
    'hit'   => 'hitita',
    'hmn'   => 'hmong',
    'ho'    => "hiri\ motu",
    'hr'    => 'croata',
    'hsb'   => "sorbio\ superior",
    'ht'    => 'haitiano',
    'hu'    => 'húngaro',
    'hup'   => 'hupa',
    'hy'    => 'armenio',
    'hz'    => 'herero',
    'ia'    => 'interlingua',
    'iba'   => 'iban',
    'id'    => 'indonesio',
    'ie'    => 'interlingue',
    'ig'    => 'igbo',
    'ii'    => "sichuan\ yi",
    'ijo'   => 'ijo',
    'ik'    => 'inupiaq',
    'ilo'   => 'ilocano',
    'inc'   => "lengua\ índica",
    'ine'   => "lengua\ indoeuropea",
    'inh'   => 'ingush',
    'io'    => 'ido',
    'ira'   => "lengua\ irania",
    'iro'   => "lenguas\ iroquesas",
    'is'    => 'islandés',
    'it'    => 'italiano',
    'iu'    => 'inuktitut',
    'ja'    => 'japonés',
    'jbo'   => 'lojban',
    'jpr'   => "judeo\-persa",
    'jrb'   => "judeo\-árabe",
    'jv'    => 'javanés',
    'ka'    => 'georgiano',
    'kaa'   => 'karakalpako',
    'kab'   => 'cabila',
    'kac'   => 'kachin',
    'kaj'   => 'jju',
    'kam'   => 'kamba',
    'kar'   => 'karen',
    'kaw'   => 'kawi',
    'kbd'   => 'kabardiano',
    'kcg'   => 'tyap',
    'kfo'   => 'koro',
    'kg'    => 'kongo',
    'kha'   => 'khasi',
    'khi'   => "lengua\ joisana",
    'kho'   => 'kotanés',
    'ki'    => 'kikuyu',
    'kj'    => 'kuanyama',
    'kk'    => 'kazajo',
    'kl'    => 'groenlandés',
    'km'    => 'jemer',
    'kmb'   => 'kimbundu',
    'kn'    => 'canarés',
    'ko'    => 'coreano',
    'kok'   => 'konkani',
    'kos'   => 'kosraeano',
    'kpe'   => 'kpelle',
    'kr'    => 'kanuri',
    'krc'   => "karachay\-balkar",
    'krl'   => 'carelio',
    'kro'   => 'kru',
    'kru'   => 'kurukh',
    'ks'    => 'cachemiro',
    'ku'    => 'kurdo',
    'kum'   => 'kumyk',
    'kut'   => 'kutenai',
    'kv'    => 'komi',
    'kw'    => 'córnico',
    'ky'    => 'kirghiz',
    'la'    => 'latín',
    'lad'   => 'ladino',
    'lah'   => 'lahnda',
    'lam'   => 'lamba',
    'lb'    => 'luxemburgués',
    'lez'   => 'lezgiano',
    'lg'    => 'ganda',
    'li'    => 'limburgués',
    'ln'    => 'lingala',
    'lo'    => 'laosiano',
    'lol'   => 'mongo',
    'loz'   => 'lozi',
    'lt'    => 'lituano',
    'lu'    => "luba\-katanga",
    'lua'   => "luba\-lulua",
    'lui'   => 'luiseño',
    'lun'   => 'lunda',
    'luo'   => 'luo',
    'lus'   => 'lushai',
    'lv'    => 'letón',
    'mad'   => 'madurés',
    'mag'   => 'magahi',
    'mai'   => 'maithili',
    'mak'   => 'macasar',
    'man'   => 'mandingo',
    'map'   => "lengua\ austronesia",
    'mas'   => 'masai',
    'mdf'   => 'moksha',
    'mdr'   => 'mandar',
    'men'   => 'mende',
    'mfe'   => 'Morisyen',
    'mg'    => 'malgache',
    'mga'   => "irlandés\ medieval",
    'mh'    => 'marshalés',
    'mi'    => 'maorí',
    'mic'   => 'micmac',
    'min'   => 'minangkabau',
    'mis'   => "lenguas\ varias",
    'mk'    => 'macedonio',
    'mkh'   => "lengua\ mon\-jemer",
    'ml'    => 'malayalam',
    'mn'    => 'mongol',
    'mnc'   => 'manchú',
    'mni'   => 'manipuri',
    'mno'   => "lenguas\ manobo",
    'mo'    => 'moldavo',
    'moh'   => 'mohawk',
    'mos'   => 'mossi',
    'mr'    => 'marathi',
    'ms'    => 'malayo',
    'mt'    => 'maltés',
    'mul'   => "lenguas\ múltiples",
    'mun'   => "lenguas\ munda",
    'mus'   => 'creek',
    'mwl'   => 'mirandés',
    'mwr'   => 'marwari',
    'my'    => 'birmano',
    'myn'   => 'maya',
    'myv'   => 'erzya',
    'na'    => 'nauruano',
    'nah'   => 'náhuatl',
    'nai'   => "lengua\ india\ norteamericana",
    'nap'   => 'napolitano',
    'nb'    => "bokmal\ noruego",
    'nd'    => "ndebele\ septentrional",
    'nds'   => "bajo\ alemán",
    'ne'    => 'nepalí',
    'new'   => 'newari',
    'ng'    => 'ndonga',
    'nia'   => 'nias',
    'nic'   => "lengua\ níger\-cordofana",
    'niu'   => 'niueano',
    'nl'    => 'neerlandés',
    'nl_be' => 'flamenco',
    'nn'    => "nynorsk\ noruego",
    'no'    => 'noruego',
    'nog'   => 'nogai',
    'non'   => "nórdico\ antiguo",
    'nqo'   => 'n’ko',
    'nr'    => "ndebele\ meridional",
    'nso'   => "sotho\ septentrional",
    'nub'   => "lenguas\ nubias",
    'nv'    => 'navajo',
    'nwc'   => "newari\ clásico",
    'ny'    => 'nyanja',
    'nym'   => 'nyamwezi',
    'nyn'   => 'nyankole',
    'nyo'   => 'nyoro',
    'nzi'   => 'nzima',
    'oc'    => 'occitano',
    'oj'    => 'ojibwa',
    'om'    => 'oromo',
    'or'    => 'oriya',
    'os'    => 'osético',
    'osa'   => 'osage',
    'ota'   => "turco\ otomano",
    'oto'   => "lenguas\ otomanas",
    'pa'    => 'punjabí',
    'paa'   => "lengua\ papú",
    'pag'   => 'pangasinán',
    'pal'   => 'pahlavi',
    'pam'   => 'pampanga',
    'pap'   => 'papiamento',
    'pau'   => 'palauano',
    'peo'   => "persa\ antiguo",
    'phi'   => "lengua\ filipina",
    'phn'   => 'fenicio',
    'pi'    => 'pali',
    'pl'    => 'polaco',
    'pon'   => 'pohnpeiano',
    'pra'   => "lenguas\ prácritas",
    'pro'   => "provenzal\ antiguo",
    'ps'    => 'pashto',
    'pt'    => 'portugués',
    'pt_br' => "portugués\ de\ Brasil",
    'pt_pt' => "portugués\ de\ Portugal",
    'qu'    => 'quechua',
    'raj'   => 'rajasthani',
    'rap'   => 'rapanui',
    'rar'   => 'rarotongano',
    'rm'    => 'retorrománico',
    'rn'    => 'kiroundi',
    'ro'    => 'rumano',
    'roa'   => "lengua\ romance",
    'rom'   => 'romaní',
    'ru'    => 'ruso',
    'rup'   => 'arrumano',
    'rw'    => 'kinyarwanda',
    'sa'    => 'sánscrito',
    'sad'   => 'sandawe',
    'sah'   => 'yakut',
    'sai'   => "lengua\ india\ sudamericana",
    'sal'   => "lenguas\ salish",
    'sam'   => "arameo\ samaritano",
    'sas'   => 'sasak',
    'sat'   => 'santali',
    'sc'    => 'sardo',
    'scn'   => 'siciliano',
    'sco'   => 'escocés',
    'sd'    => 'sindhi',
    'se'    => "sami\ septentrional",
    'sel'   => 'selkup',
    'sem'   => "lengua\ semítica",
    'sg'    => 'sango',
    'sga'   => "irlandés\ antiguo",
    'sgn'   => "lenguajes\ de\ signos",
    'sh'    => 'serbocroata',
    'shn'   => 'shan',
    'si'    => 'cingalés',
    'sid'   => 'sidamo',
    'sio'   => "lenguas\ sioux",
    'sit'   => "lengua\ sino\-tibetana",
    'sk'    => 'eslovaco',
    'sl'    => 'esloveno',
    'sla'   => "lengua\ eslava",
    'sm'    => 'samoano',
    'sma'   => "sami\ meridional",
    'smi'   => "lengua\ sami",
    'smj'   => "sami\ lule",
    'smn'   => "sami\ inari",
    'sms'   => "sami\ skolt",
    'sn'    => 'shona',
    'snk'   => 'soninké',
    'so'    => 'somalí',
    'sog'   => 'sogdiano',
    'son'   => 'songhai',
    'sq'    => 'albanés',
    'sr'    => 'serbio',
    'srn'   => "sranan\ tongo",
    'srr'   => 'serer',
    'ss'    => 'siswati',
    'ssa'   => "lengua\ nilo\-sahariana",
    'st'    => 'sesotho',
    'su'    => 'sundanés',
    'suk'   => 'sukuma',
    'sus'   => 'susu',
    'sux'   => 'sumerio',
    'sv'    => 'sueco',
    'sw'    => 'swahili',
    'syc'   => "siríaco\ clásico",
    'syr'   => 'siriaco',
    'ta'    => 'tamil',
    'tai'   => "lengua\ tai",
    'te'    => 'telugu',
    'tem'   => 'temne',
    'ter'   => 'tereno',
    'tet'   => 'tetún',
    'tg'    => 'tayiko',
    'th'    => 'tailandés',
    'ti'    => 'tigriña',
    'tig'   => 'tigré',
    'tiv'   => 'tiv',
    'tk'    => 'turcomano',
    'tkl'   => 'tokelauano',
    'tl'    => 'tagalo',
    'tlh'   => 'klingon',
    'tli'   => 'tlingit',
    'tmh'   => 'tamashek',
    'tn'    => 'setchwana',
    'to'    => 'tongano',
    'tog'   => "tonga\ del\ Nyasa",
    'tpi'   => "tok\ pisin",
    'tr'    => 'turco',
    'trv'   => 'Taroko',
    'ts'    => 'tsonga',
    'tsi'   => 'tsimshiano',
    'tt'    => 'tártaro',
    'tum'   => 'tumbuka',
    'tup'   => "lenguas\ tupí",
    'tut'   => "lengua\ altaica",
    'tvl'   => 'tuvaluano',
    'tw'    => 'twi',
    'ty'    => 'tahitiano',
    'tyv'   => 'tuviniano',
    'udm'   => 'udmurt',
    'ug'    => 'uigur',
    'uga'   => 'ugarítico',
    'uk'    => 'ucraniano',
    'umb'   => 'umbundu',
    'und'   => 'indeterminada',
    'ur'    => 'urdu',
    'uz'    => 'uzbeko',
    'vai'   => 'vai',
    've'    => 'venda',
    'vi'    => 'vietnamita',
    'vo'    => 'volapük',
    'vot'   => 'vótico',
    'wa'    => 'valón',
    'wak'   => "lenguas\ wakasha",
    'wal'   => 'walamo',
    'war'   => 'waray',
    'was'   => 'washo',
    'wen'   => "lenguas\ sorbias",
    'wo'    => 'uolof',
    'xal'   => 'kalmyk',
    'xh'    => 'xhosa',
    'yao'   => 'yao',
    'yap'   => 'yapés',
    'yi'    => 'yídish',
    'yo'    => 'yoruba',
    'ypk'   => "lenguas\ yupik",
    'za'    => 'zhuang',
    'zap'   => 'zapoteco',
    'zbl'   => "símbolos\ Bliss",
    'zen'   => 'zenaga',
    'zh'    => 'chino',
    'znd'   => 'zande',
    'zu'    => 'zulú',
    'zun'   => 'zuni',
    'zxx'   => "sin\ contenido\ lingüístico",
    'zza'   => 'zazaki',
);

%Locales::DB::Language::es::name_to_code = (
    'abjasio'                                              => 'ab',
    'acadio'                                               => 'akk',
    'acehns'                                               => 'ace',
    'acoli'                                                => 'ach',
    'adangme'                                              => 'ada',
    'adigeo'                                               => 'ady',
    'afar'                                                 => 'aa',
    'afrihili'                                             => 'afh',
    'afrikaans'                                            => 'af',
    'aimara'                                               => 'ay',
    'ainu'                                                 => 'ain',
    'akan'                                                 => 'ak',
    'albans'                                               => 'sq',
    'alemn'                                                => 'de',
    "alemn\ austraco"                                      => 'de_at',
    "alemn\ de\ la\ alta\ edad\ antigua"                   => 'goh',
    "alemn\ de\ la\ alta\ edad\ media"                     => 'gmh',
    "alemn\ suizo"                                         => 'gsw',
    'aleutiano'                                            => 'ale',
    "alti\ meridional"                                     => 'alt',
    "alto\ alemn\ de\ suiza"                               => 'de_ch',
    'amrico'                                               => 'am',
    'angika'                                               => 'anp',
    'aragons'                                              => 'an',
    'arahuaco'                                             => 'arw',
    'arameo'                                               => 'arc',
    "arameo\ samaritano"                                   => 'sam',
    'arapaho'                                              => 'arp',
    'armenio'                                              => 'hy',
    'arrumano'                                             => 'rup',
    'asams'                                                => 'as',
    'asturiano'                                            => 'ast',
    'atsam'                                                => 'cch',
    'avadhi'                                               => 'awa',
    'avar'                                                 => 'av',
    'avstico'                                              => 'ae',
    'azer'                                                 => 'az',
    "bajo\ alemn"                                          => 'nds',
    'balins'                                               => 'ban',
    'baluchi'                                              => 'bal',
    'bambara'                                              => 'bm',
    'banda'                                                => 'bad',
    'bant'                                                 => 'bnt',
    'basa'                                                 => 'bas',
    'bashkir'                                              => 'ba',
    'batak'                                                => 'btk',
    'beja'                                                 => 'bej',
    'bemba'                                                => 'bem',
    'bengal'                                               => 'bn',
    'bereber'                                              => 'ber',
    'bhojpuri'                                             => 'bho',
    'bicol'                                                => 'bik',
    'bielorruso'                                           => 'be',
    'bihari'                                               => 'bh',
    'bini'                                                 => 'bin',
    'birmano'                                              => 'my',
    'bislama'                                              => 'bi',
    'blgaro'                                               => 'bg',
    'blin'                                                 => 'byn',
    "bokmal\ noruego"                                      => 'nb',
    'bosnio'                                               => 'bs',
    'braj'                                                 => 'bra',
    'bretn'                                                => 'br',
    'bugins'                                               => 'bug',
    'buriat'                                               => 'bua',
    'cabila'                                               => 'kab',
    'cachemiro'                                            => 'ks',
    'caddo'                                                => 'cad',
    'canars'                                               => 'kn',
    'carelio'                                              => 'krl',
    'caribe'                                               => 'car',
    'casubio'                                              => 'csb',
    'cataln'                                               => 'ca',
    'cebuano'                                              => 'ceb',
    'chagati'                                              => 'chg',
    'chamorro'                                             => 'ch',
    'checheno'                                             => 'ce',
    'checo'                                                => 'cs',
    'cherokee'                                             => 'chr',
    'cheyene'                                              => 'chy',
    'chibcha'                                              => 'chb',
    'chino'                                                => 'zh',
    'chipewyan'                                            => 'chp',
    'choctaw'                                              => 'cho',
    'chuvash'                                              => 'cv',
    'cingals'                                              => 'si',
    'copto'                                                => 'cop',
    'coreano'                                              => 'ko',
    'corso'                                                => 'co',
    'cree'                                                 => 'cr',
    'creek'                                                => 'mus',
    'crnico'                                               => 'kw',
    'croata'                                               => 'hr',
    'dakota'                                               => 'dak',
    'dans'                                                 => 'da',
    'dargva'                                               => 'dar',
    'dayak'                                                => 'day',
    'delaware'                                             => 'del',
    'dinka'                                                => 'din',
    'diula'                                                => 'dyu',
    'divehi'                                               => 'dv',
    'dogri'                                                => 'doi',
    'dogrib'                                               => 'dgr',
    'duala'                                                => 'dua',
    'dzongkha'                                             => 'dz',
    'efik'                                                 => 'efi',
    "egipcio\ antiguo"                                     => 'egy',
    'ekajuk'                                               => 'eka',
    'elamita'                                              => 'elx',
    'erzya'                                                => 'myv',
    'escocs'                                               => 'sco',
    "eslavo\ eclesistico"                                  => 'cu',
    'eslovaco'                                             => 'sk',
    'esloveno'                                             => 'sl',
    'espaol'                                               => 'es',
    "espaol\ de\ espaa"                                    => 'es_es',
    'esperanto'                                            => 'eo',
    'estonio'                                              => 'et',
    'ewe'                                                  => 'ee',
    'ewondo'                                               => 'ewo',
    'fang'                                                 => 'fan',
    'fanti'                                                => 'fat',
    'fenicio'                                              => 'phn',
    'feros'                                                => 'fo',
    'fidjiano'                                             => 'fj',
    'filipino'                                             => 'fil',
    'fins'                                                 => 'fi',
    'flamenco'                                             => 'nl_be',
    'fon'                                                  => 'fon',
    'francs'                                               => 'fr',
    "francs\ antiguo"                                      => 'fro',
    "francs\ canadiense"                                   => 'fr_ca',
    "francs\ de\ suiza"                                    => 'fr_ch',
    "francs\ medieval"                                     => 'frm',
    'frisn'                                                => 'fy',
    "frisn\ oriental"                                      => 'frs',
    "frisn\ septentrional"                                 => 'frr',
    'friulano'                                             => 'fur',
    'fula'                                                 => 'ff',
    'ga'                                                   => 'gaa',
    "galico\ escocs"                                       => 'gd',
    "galico\ mans"                                         => 'gv',
    'gallego'                                              => 'gl',
    'gals'                                                 => 'cy',
    'ganda'                                                => 'lg',
    'gayo'                                                 => 'gay',
    'gbaya'                                                => 'gba',
    'geez'                                                 => 'gez',
    'georgiano'                                            => 'ka',
    'gilbertense'                                          => 'gil',
    'gondi'                                                => 'gon',
    'gorontalo'                                            => 'gor',
    'grebo'                                                => 'grb',
    'griego'                                               => 'el',
    "griego\ antiguo"                                      => 'grc',
    'groenlands'                                           => 'kl',
    'gtico'                                                => 'got',
    'guaran'                                               => 'gn',
    'gujarati'                                             => 'gu',
    'haida'                                                => 'hai',
    'haitiano'                                             => 'ht',
    'hausa'                                                => 'ha',
    'hawaiano'                                             => 'haw',
    'hebreo'                                               => 'he',
    'herero'                                               => 'hz',
    'hiligaynon'                                           => 'hil',
    'himachali'                                            => 'him',
    'hindi'                                                => 'hi',
    "hiri\ motu"                                           => 'ho',
    'hitita'                                               => 'hit',
    'hmong'                                                => 'hmn',
    'hngaro'                                               => 'hu',
    'hupa'                                                 => 'hup',
    'iban'                                                 => 'iba',
    'ido'                                                  => 'io',
    'igbo'                                                 => 'ig',
    'ijo'                                                  => 'ijo',
    'ilocano'                                              => 'ilo',
    'indeterminada'                                        => 'und',
    'indonesio'                                            => 'id',
    'ingls'                                                => 'en',
    "ingls\ antiguo"                                       => 'ang',
    "ingls\ australiano"                                   => 'en_au',
    "ingls\ britnico"                                      => 'en_gb',
    "ingls\ canadiense"                                    => 'en_ca',
    "ingls\ estadounidense"                                => 'en_us',
    "ingls\ medieval"                                      => 'enm',
    'ingush'                                               => 'inh',
    'interlingua'                                          => 'ia',
    'interlingue'                                          => 'ie',
    'inuktitut'                                            => 'iu',
    'inupiaq'                                              => 'ik',
    'irlands'                                              => 'ga',
    "irlands\ antiguo"                                     => 'sga',
    "irlands\ medieval"                                    => 'mga',
    'islands'                                              => 'is',
    'italiano'                                             => 'it',
    'japons'                                               => 'ja',
    'javans'                                               => 'jv',
    'jemer'                                                => 'km',
    "jerga\ chinuk"                                        => 'chn',
    'jju'                                                  => 'kaj',
    'judeopersa'                                           => 'jpr',
    'judeorabe'                                            => 'jrb',
    'kabardiano'                                           => 'kbd',
    'kachin'                                               => 'kac',
    'kalmyk'                                               => 'xal',
    'kamba'                                                => 'kam',
    'kanuri'                                               => 'kr',
    'karachaybalkar'                                       => 'krc',
    'karakalpako'                                          => 'kaa',
    'karen'                                                => 'kar',
    'kawi'                                                 => 'kaw',
    'kazajo'                                               => 'kk',
    'khasi'                                                => 'kha',
    'kikuyu'                                               => 'ki',
    'kimbundu'                                             => 'kmb',
    'kinyarwanda'                                          => 'rw',
    'kirghiz'                                              => 'ky',
    'kiroundi'                                             => 'rn',
    'klingon'                                              => 'tlh',
    'komi'                                                 => 'kv',
    'kongo'                                                => 'kg',
    'konkani'                                              => 'kok',
    'koro'                                                 => 'kfo',
    'kosraeano'                                            => 'kos',
    'kotans'                                               => 'kho',
    'kpelle'                                               => 'kpe',
    'kru'                                                  => 'kro',
    'kuanyama'                                             => 'kj',
    'kumyk'                                                => 'kum',
    'kurdo'                                                => 'ku',
    'kurukh'                                               => 'kru',
    'kutchin'                                              => 'gwi',
    'kutenai'                                              => 'kut',
    'ladino'                                               => 'lad',
    'lahnda'                                               => 'lah',
    'lamba'                                                => 'lam',
    'laosiano'                                             => 'lo',
    'latn'                                                 => 'la',
    "lengua\ afroasitica"                                  => 'afa',
    "lengua\ altaica"                                      => 'tut',
    "lengua\ artificial"                                   => 'art',
    "lengua\ austronesia"                                  => 'map',
    "lengua\ bltica"                                       => 'bat',
    "lengua\ caucsica"                                     => 'cau',
    "lengua\ celta"                                        => 'cel',
    "lengua\ criolla\ o\ pidgin"                           => 'crp',
    "lengua\ criolla\ o\ pidgin\ basada\ en\ el\ francs"   => 'cpf',
    "lengua\ criolla\ o\ pidgin\ basada\ en\ el\ ingls"    => 'cpe',
    "lengua\ criolla\ o\ pidgin\ basada\ en\ el\ portugus" => 'cpp',
    "lengua\ cusita"                                       => 'cus',
    "lengua\ dravdica"                                     => 'dra',
    "lengua\ eslava"                                       => 'sla',
    "lengua\ filipina"                                     => 'phi',
    "lengua\ finougria"                                    => 'fiu',
    "lengua\ germnica"                                     => 'gem',
    "lengua\ india\ centroamericana"                       => 'cai',
    "lengua\ india\ norteamericana"                        => 'nai',
    "lengua\ india\ sudamericana"                          => 'sai',
    "lengua\ indoeuropea"                                  => 'ine',
    "lengua\ irania"                                       => 'ira',
    "lengua\ joisana"                                      => 'khi',
    "lengua\ monjemer"                                     => 'mkh',
    "lengua\ ndica"                                        => 'inc',
    "lengua\ ngercordofana"                                => 'nic',
    "lengua\ nilosahariana"                                => 'ssa',
    "lengua\ pap"                                          => 'paa',
    "lengua\ romance"                                      => 'roa',
    "lengua\ sami"                                         => 'smi',
    "lengua\ semtica"                                      => 'sem',
    "lengua\ sinotibetana"                                 => 'sit',
    "lengua\ tai"                                          => 'tai',
    "lenguajes\ de\ signos"                                => 'sgn',
    "lenguas\ algonquinas"                                 => 'alg',
    "lenguas\ apache"                                      => 'apa',
    "lenguas\ atabascas"                                   => 'ath',
    "lenguas\ australianas"                                => 'aus',
    "lenguas\ bamileke"                                    => 'bai',
    "lenguas\ chmicas"                                     => 'cmc',
    "lenguas\ iroquesas"                                   => 'iro',
    "lenguas\ manobo"                                      => 'mno',
    "lenguas\ mltiples"                                    => 'mul',
    "lenguas\ munda"                                       => 'mun',
    "lenguas\ nubias"                                      => 'nub',
    "lenguas\ otomanas"                                    => 'oto',
    "lenguas\ prcritas"                                    => 'pra',
    "lenguas\ salish"                                      => 'sal',
    "lenguas\ sioux"                                       => 'sio',
    "lenguas\ sorbias"                                     => 'wen',
    "lenguas\ tup"                                         => 'tup',
    "lenguas\ varias"                                      => 'mis',
    "lenguas\ wakasha"                                     => 'wak',
    "lenguas\ yupik"                                       => 'ypk',
    'letn'                                                 => 'lv',
    'lezgiano'                                             => 'lez',
    'limburgus'                                            => 'li',
    'lingala'                                              => 'ln',
    'lituano'                                              => 'lt',
    'lojban'                                               => 'jbo',
    'lozi'                                                 => 'loz',
    'lubakatanga'                                          => 'lu',
    'lubalulua'                                            => 'lua',
    'luiseo'                                               => 'lui',
    'lunda'                                                => 'lun',
    'luo'                                                  => 'luo',
    'lushai'                                               => 'lus',
    'luxemburgus'                                          => 'lb',
    'macasar'                                              => 'mak',
    'macedonio'                                            => 'mk',
    'madurs'                                               => 'mad',
    'magahi'                                               => 'mag',
    'maithili'                                             => 'mai',
    'malayalam'                                            => 'ml',
    'malayo'                                               => 'ms',
    'malgache'                                             => 'mg',
    'malts'                                                => 'mt',
    'manch'                                                => 'mnc',
    'mandar'                                               => 'mdr',
    'mandingo'                                             => 'man',
    'manipuri'                                             => 'mni',
    'maor'                                                 => 'mi',
    'mapudungun'                                           => 'arn',
    'mar'                                                  => 'chm',
    'marathi'                                              => 'mr',
    'marshals'                                             => 'mh',
    'marwari'                                              => 'mwr',
    'masai'                                                => 'mas',
    'maya'                                                 => 'myn',
    'mende'                                                => 'men',
    'micmac'                                               => 'mic',
    'minangkabau'                                          => 'min',
    'mirands'                                              => 'mwl',
    'mohawk'                                               => 'moh',
    'moksha'                                               => 'mdf',
    'moldavo'                                              => 'mo',
    'mongo'                                                => 'lol',
    'mongol'                                               => 'mn',
    'morisyen'                                             => 'mfe',
    'mossi'                                                => 'mos',
    'napolitano'                                           => 'nap',
    'nauruano'                                             => 'na',
    'navajo'                                               => 'nv',
    "ndebele\ meridional"                                  => 'nr',
    "ndebele\ septentrional"                               => 'nd',
    'ndonga'                                               => 'ng',
    'neerlands'                                            => 'nl',
    "neerlands\ medieval"                                  => 'dum',
    'nepal'                                                => 'ne',
    'newari'                                               => 'new',
    "newari\ clsico"                                       => 'nwc',
    'nhuatl'                                               => 'nah',
    'nias'                                                 => 'nia',
    'niueano'                                              => 'niu',
    'nko'                                                  => 'nqo',
    'nogai'                                                => 'nog',
    'noruego'                                              => 'no',
    "nrdico\ antiguo"                                      => 'non',
    'nyamwezi'                                             => 'nym',
    'nyanja'                                               => 'ny',
    'nyankole'                                             => 'nyn',
    "nynorsk\ noruego"                                     => 'nn',
    'nyoro'                                                => 'nyo',
    'nzima'                                                => 'nzi',
    'occitano'                                             => 'oc',
    'ojibwa'                                               => 'oj',
    'oriya'                                                => 'or',
    'oromo'                                                => 'om',
    'osage'                                                => 'osa',
    'ostico'                                               => 'os',
    'pahlavi'                                              => 'pal',
    'palauano'                                             => 'pau',
    'pali'                                                 => 'pi',
    'pampanga'                                             => 'pam',
    'pangasinn'                                            => 'pag',
    'papiamento'                                           => 'pap',
    'pashto'                                               => 'ps',
    'persa'                                                => 'fa',
    "persa\ antiguo"                                       => 'peo',
    'pohnpeiano'                                           => 'pon',
    'polaco'                                               => 'pl',
    'portugus'                                             => 'pt',
    "portugus\ de\ brasil"                                 => 'pt_br',
    "portugus\ de\ portugal"                               => 'pt_pt',
    "provenzal\ antiguo"                                   => 'pro',
    'punjab'                                               => 'pa',
    'quechua'                                              => 'qu',
    'rabe'                                                 => 'ar',
    'rajasthani'                                           => 'raj',
    'rapanui'                                              => 'rap',
    'rarotongano'                                          => 'rar',
    'retorromnico'                                         => 'rm',
    'roman'                                                => 'rom',
    'rumano'                                               => 'ro',
    'ruso'                                                 => 'ru',
    "sami\ inari"                                          => 'smn',
    "sami\ lule"                                           => 'smj',
    "sami\ meridional"                                     => 'sma',
    "sami\ septentrional"                                  => 'se',
    "sami\ skolt"                                          => 'sms',
    'samoano'                                              => 'sm',
    'sandawe'                                              => 'sad',
    'sango'                                                => 'sg',
    'santali'                                              => 'sat',
    'sardo'                                                => 'sc',
    'sasak'                                                => 'sas',
    'selkup'                                               => 'sel',
    'serbio'                                               => 'sr',
    'serbocroata'                                          => 'sh',
    'serer'                                                => 'srr',
    'sesotho'                                              => 'st',
    'setchwana'                                            => 'tn',
    'shan'                                                 => 'shn',
    'shona'                                                => 'sn',
    "sichuan\ yi"                                          => 'ii',
    'siciliano'                                            => 'scn',
    'sidamo'                                               => 'sid',
    'siksika'                                              => 'bla',
    "sin\ contenido\ lingstico"                            => 'zxx',
    'sindhi'                                               => 'sd',
    "siraco\ clsico"                                       => 'syc',
    'siriaco'                                              => 'syr',
    'siswati'                                              => 'ss',
    'slave'                                                => 'den',
    "smbolos\ bliss"                                       => 'zbl',
    'snscrito'                                             => 'sa',
    'sogdiano'                                             => 'sog',
    'somal'                                                => 'so',
    'songhai'                                              => 'son',
    'sonink'                                               => 'snk',
    "sorbio\ inferior"                                     => 'dsb',
    "sorbio\ superior"                                     => 'hsb',
    "sotho\ septentrional"                                 => 'nso',
    "sranan\ tongo"                                        => 'srn',
    'sueco'                                                => 'sv',
    'sukuma'                                               => 'suk',
    'sumerio'                                              => 'sux',
    'sundans'                                              => 'su',
    'susu'                                                 => 'sus',
    'swahili'                                              => 'sw',
    'tagalo'                                               => 'tl',
    'tahitiano'                                            => 'ty',
    'tailands'                                             => 'th',
    'tamashek'                                             => 'tmh',
    'tamil'                                                => 'ta',
    'taroko'                                               => 'trv',
    'tayiko'                                               => 'tg',
    'telugu'                                               => 'te',
    'temne'                                                => 'tem',
    'tereno'                                               => 'ter',
    'tetn'                                                 => 'tet',
    'tibetano'                                             => 'bo',
    'tigr'                                                 => 'tig',
    'tigria'                                               => 'ti',
    'tiv'                                                  => 'tiv',
    'tlingit'                                              => 'tli',
    "tok\ pisin"                                           => 'tpi',
    'tokelauano'                                           => 'tkl',
    "tonga\ del\ nyasa"                                    => 'tog',
    'tongano'                                              => 'to',
    'trtaro'                                               => 'tt',
    "trtaro\ de\ crimea"                                   => 'crh',
    'truks'                                                => 'chk',
    'tsimshiano'                                           => 'tsi',
    'tsonga'                                               => 'ts',
    'tumbuka'                                              => 'tum',
    'turco'                                                => 'tr',
    "turco\ otomano"                                       => 'ota',
    'turcomano'                                            => 'tk',
    'tuvaluano'                                            => 'tvl',
    'tuviniano'                                            => 'tyv',
    'twi'                                                  => 'tw',
    'tyap'                                                 => 'kcg',
    'ucraniano'                                            => 'uk',
    'udmurt'                                               => 'udm',
    'ugartico'                                             => 'uga',
    'uigur'                                                => 'ug',
    'umbundu'                                              => 'umb',
    'uolof'                                                => 'wo',
    'urdu'                                                 => 'ur',
    'uzbeko'                                               => 'uz',
    'vai'                                                  => 'vai',
    'valn'                                                 => 'wa',
    'vasco'                                                => 'eu',
    'venda'                                                => 've',
    'vietnamita'                                           => 'vi',
    'volapk'                                               => 'vo',
    'vtico'                                                => 'vot',
    'walamo'                                               => 'wal',
    'waray'                                                => 'war',
    'washo'                                                => 'was',
    'xhosa'                                                => 'xh',
    'yakut'                                                => 'sah',
    'yao'                                                  => 'yao',
    'yaps'                                                 => 'yap',
    'ydish'                                                => 'yi',
    'yoruba'                                               => 'yo',
    'zande'                                                => 'znd',
    'zapoteco'                                             => 'zap',
    'zazaki'                                               => 'zza',
    'zenaga'                                               => 'zen',
    'zhuang'                                               => 'za',
    'zul'                                                  => 'zu',
    'zuni'                                                 => 'zun',
);

1;
