package Locales::DB::Language::ca;

# Auto generated from CLDR

$Locales::DB::Language::ca::VERSION = '0.01';

$Locales::DB::Language::ca::cldr_version = '1.7.1';

%Locales::DB::Language::ca::misc_info = (
    'cldr_formats' => {
        'decimal'   => "\#\,\#\#0\.\#\#\#",
        'language'  => "Idioma\:\ \{0\}",
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Regió\:\ \{0\}"
    },
    'fallback'    => [ 'es_ES' ],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr'  => "no\:n",
        'yesstr' => "sí\:s"
    },
);

%Locales::DB::Language::ca::code_to_name = (
    'aa'    => 'àfar',
    'ab'    => 'abkhaz',
    'ace'   => 'atjeh',
    'ach'   => 'acoli',
    'ada'   => 'adangme',
    'ady'   => 'adigué',
    'ae'    => 'avèstic',
    'af'    => 'afrikaans',
    'afa'   => "llengua\ afroasiàtica",
    'afh'   => 'afrihili',
    'ain'   => 'ainu',
    'ak'    => 'àkan',
    'akk'   => 'accadi',
    'ale'   => 'aleuta',
    'alg'   => "llengua\ algonquina",
    'alt'   => "altaic\ meridional",
    'am'    => 'amhàric',
    'an'    => 'aragonès',
    'ang'   => "anglès\ antic",
    'anp'   => 'angika',
    'apa'   => "llengua\ apatxe",
    'ar'    => 'àrab',
    'arc'   => 'arameu',
    'arn'   => 'araucà',
    'arp'   => 'arapaho',
    'art'   => "llengua\ artificial",
    'arw'   => 'arauac',
    'as'    => 'assamès',
    'ast'   => 'asturià',
    'ath'   => "llengua\ atapascana",
    'aus'   => "llengua\ australiana",
    'av'    => 'àvar',
    'awa'   => 'awadhi',
    'ay'    => 'aimara',
    'az'    => 'àzeri',
    'ba'    => 'baixkir',
    'bad'   => 'banda',
    'bai'   => 'bamileké',
    'bal'   => 'balutxi',
    'ban'   => 'balinès',
    'bas'   => 'basa',
    'bat'   => "llengua\ bàltica",
    'be'    => 'bielorús',
    'bej'   => 'beja',
    'bem'   => 'bemba',
    'ber'   => 'berber',
    'bg'    => 'búlgar',
    'bh'    => 'bihari',
    'bho'   => 'bhojpuri',
    'bi'    => 'bislama',
    'bik'   => 'bicol',
    'bin'   => 'bini',
    'bla'   => 'blackfoot',
    'bm'    => 'bambara',
    'bn'    => 'bengalí',
    'bnt'   => 'bantu',
    'bo'    => 'tibetà',
    'br'    => 'bretó',
    'bra'   => 'braj',
    'bs'    => 'bosnià',
    'btk'   => 'batak',
    'bua'   => 'buriat',
    'bug'   => 'bugui',
    'byn'   => 'bilin',
    'ca'    => 'català',
    'cad'   => 'caddo',
    'cai'   => "llengua\ ameríndia\ d\'Amèrica\ Central",
    'car'   => 'carib',
    'cau'   => "llengua\ caucàsica",
    'cch'   => 'atsam',
    'ce'    => 'txetxè',
    'ceb'   => 'cebuano',
    'cel'   => "llengua\ cèltica",
    'ch'    => 'chamorro',
    'chb'   => 'txibtxa',
    'chg'   => 'txagatai',
    'chk'   => 'chuuk',
    'chm'   => 'mari',
    'chn'   => "pidgin\ chinook",
    'cho'   => 'choctaw',
    'chp'   => 'chipewyan',
    'chr'   => 'cherokee',
    'chy'   => 'xeienne',
    'cmc'   => 'txam',
    'co'    => 'cors',
    'cop'   => 'copte',
    'cpe'   => "llengua\ criolla\ o\ pidgin\ basada\ en\ l\'anglès",
    'cpf'   => "llengua\ criolla\ o\ pidgin\ basada\ en\ el\ francès",
    'cpp'   => "llengua\ criolla\ o\ pidgin\ basada\ en\ el\ portuguès",
    'cr'    => 'cree',
    'crh'   => "tàtar\ de\ Crimea",
    'crp'   => "llengua\ criolla\ o\ pidgin",
    'cs'    => 'txec',
    'csb'   => 'caixubi',
    'cu'    => "eslau\ eclesiàstic",
    'cus'   => "llengua\ cuixítica",
    'cv'    => 'txuvaix',
    'cy'    => 'gal·lès',
    'da'    => 'danès',
    'dak'   => 'dakota',
    'dar'   => 'darguà',
    'day'   => 'daiak',
    'de'    => 'alemany',
    'de_at' => "alemany\ austríac",
    'de_ch' => "alt\ alemany\ suís",
    'del'   => 'delaware',
    'den'   => 'slavey',
    'dgr'   => 'dogrib',
    'din'   => 'dinka',
    'doi'   => 'dogri',
    'dra'   => "llengua\ dravídica",
    'dsb'   => "baix\ sòrab",
    'dua'   => 'duala',
    'dum'   => "neerlandès\ mitjà",
    'dv'    => 'divehi',
    'dyu'   => 'jula',
    'dz'    => 'dzongka',
    'ee'    => 'ewe',
    'efi'   => 'efik',
    'egy'   => "egipci\ antic",
    'eka'   => 'ekajuk',
    'el'    => 'grec',
    'elx'   => 'elamita',
    'en'    => 'anglès',
    'en_au' => "anglès\ australià",
    'en_ca' => "anglès\ canadenc",
    'en_gb' => "anglès\ britànic",
    'en_us' => "anglès\ americà",
    'enm'   => "anglès\ mitjà",
    'eo'    => 'esperanto',
    'es'    => 'espanyol',
    'es_es' => "espanyol\ d\'Espanya",
    'et'    => 'estonià',
    'eu'    => 'basc',
    'ewo'   => 'ewondo',
    'fa'    => 'persa',
    'fan'   => 'fang',
    'fat'   => 'fanti',
    'ff'    => 'ful',
    'fi'    => 'finès',
    'fil'   => 'filipí',
    'fiu'   => "llengua\ finoúgrica",
    'fj'    => 'fijià',
    'fo'    => 'feroès',
    'fon'   => 'fon',
    'fr'    => 'francès',
    'fr_ca' => "francès\ canadenc",
    'fr_ch' => "francès\ suís",
    'frm'   => "francès\ mitjà",
    'fro'   => "francès\ antic",
    'frr'   => "frisó\ septentrional",
    'frs'   => "frisó\ occidental",
    'fur'   => 'friülà',
    'fy'    => "frisó\ oriental",
    'ga'    => 'irlandès',
    'gaa'   => 'ga',
    'gay'   => 'gayo',
    'gba'   => 'gbaya',
    'gd'    => "gaèlic\ escocès",
    'gem'   => "llengua\ germànica",
    'gez'   => 'gueez',
    'gil'   => 'gilbertès',
    'gl'    => 'gallec',
    'gmh'   => "alt\ alemany\ mitjà",
    'gn'    => 'guaraní',
    'goh'   => "alt\ alemany\ antic",
    'gon'   => 'gondi',
    'gor'   => 'gorontalo',
    'got'   => 'gòtic',
    'grb'   => 'grebo',
    'grc'   => "grec\ antic",
    'gsw'   => "alemany\ suís",
    'gu'    => 'gujarati',
    'gv'    => 'manx',
    'gwi'   => 'gwichin',
    'ha'    => 'haussa',
    'hai'   => 'haida',
    'haw'   => 'hawaià',
    'he'    => 'hebreu',
    'hi'    => 'hindi',
    'hil'   => 'hiligainon',
    'him'   => 'himachali',
    'hit'   => 'hitita',
    'hmn'   => 'hmong',
    'ho'    => "hiri\ motu",
    'hr'    => 'croat',
    'hsb'   => "alt\ sòrab",
    'ht'    => 'haitià',
    'hu'    => 'hongarès',
    'hup'   => 'hupa',
    'hy'    => 'armeni',
    'hz'    => 'herero',
    'ia'    => 'interlingua',
    'iba'   => 'iban',
    'id'    => 'indonesi',
    'ie'    => 'interlingue',
    'ig'    => 'igbo',
    'ii'    => "yi\ sichuan",
    'ijo'   => 'ijo',
    'ik'    => 'inupiak',
    'ilo'   => 'ilocà',
    'inc'   => "llengua\ índica",
    'ine'   => "llengua\ indoeuropea",
    'inh'   => 'ingúix',
    'io'    => 'ido',
    'ira'   => "llengua\ irànica",
    'iro'   => 'iroquès',
    'is'    => 'islandès',
    'it'    => 'italià',
    'iu'    => 'inuktitut',
    'ja'    => 'japonès',
    'jbo'   => 'lojban',
    'jpr'   => 'judeopersa',
    'jrb'   => 'judeoàrab',
    'jv'    => 'javanès',
    'ka'    => 'georgià',
    'kaa'   => 'karakalpak',
    'kab'   => 'cabilenc',
    'kac'   => 'katxin',
    'kaj'   => 'jju',
    'kam'   => 'kamba',
    'kar'   => 'karen',
    'kaw'   => 'kawi',
    'kbd'   => 'kabardí',
    'kcg'   => 'tyap',
    'kfo'   => 'koro',
    'kg'    => 'kongo',
    'kha'   => 'khasi',
    'khi'   => "llengua\ khoisan",
    'kho'   => 'khotanès',
    'ki'    => 'kikuiu',
    'kj'    => 'kuanyama',
    'kk'    => 'kazakh',
    'kl'    => 'grenlandès',
    'km'    => 'khmer',
    'kmb'   => 'kimbundu',
    'kn'    => 'kannada',
    'ko'    => 'coreà',
    'kok'   => 'konkani',
    'kos'   => 'kosraeà',
    'kpe'   => 'kpelle',
    'kr'    => 'kanuri',
    'krc'   => 'karatxai',
    'krl'   => 'carelià',
    'kro'   => 'kru',
    'kru'   => 'kurukh',
    'ks'    => 'caixmiri',
    'ku'    => 'kurd',
    'kum'   => 'kúmik',
    'kut'   => 'kutenai',
    'kv'    => 'komi',
    'kw'    => 'còrnic',
    'ky'    => 'kirguís',
    'la'    => 'llatí',
    'lad'   => 'ladí',
    'lah'   => "panjabi\ occidental",
    'lam'   => 'lamba',
    'lb'    => 'luxemburguès',
    'lez'   => 'lesguià',
    'lg'    => 'ganda',
    'li'    => 'limburguès',
    'ln'    => 'lingala',
    'lo'    => 'laosià',
    'lol'   => 'mongo',
    'loz'   => 'lozi',
    'lt'    => 'lituà',
    'lu'    => "luba\ katanga",
    'lua'   => "luba\-lulua",
    'lui'   => 'luisenyo',
    'lun'   => 'lunda',
    'luo'   => 'luo',
    'lus'   => 'mizo',
    'lv'    => 'letó',
    'mad'   => 'madurès',
    'mag'   => 'magahi',
    'mai'   => 'maithili',
    'mak'   => 'makassar',
    'man'   => 'mandinga',
    'map'   => "llengua\ austronèsia",
    'mas'   => 'massai',
    'mdf'   => "mordovià\ moksa",
    'mdr'   => 'mandar',
    'men'   => 'mende',
    'mfe'   => 'Morisyen',
    'mg'    => 'malgaix',
    'mga'   => "gaèlic\ irlandès\ mitjà",
    'mh'    => 'marshallès',
    'mi'    => 'maori',
    'mic'   => 'micmac',
    'min'   => 'minangkabau',
    'mis'   => "llengua\ miscel·lània",
    'mk'    => 'macedoni',
    'mkh'   => "llengua\ monkhmer",
    'ml'    => 'malaialam',
    'mn'    => 'mongol',
    'mnc'   => 'manxú',
    'mni'   => 'manipurí',
    'mno'   => "llengua\ manobo",
    'mo'    => 'moldau',
    'moh'   => 'mohawk',
    'mos'   => 'moré',
    'mr'    => 'marathi',
    'ms'    => 'malai',
    'mt'    => 'maltès',
    'mul'   => "llengües\ vàries",
    'mun'   => "llengua\ munda",
    'mus'   => 'creek',
    'mwl'   => 'mirandès',
    'mwr'   => 'marwari',
    'my'    => 'birmà',
    'myn'   => "llengua\ maia",
    'myv'   => "mordovià\ erza",
    'na'    => 'nauruà',
    'nah'   => 'nàhuatl',
    'nai'   => "llengua\ ameríndia\ septentrional",
    'nap'   => 'napolità',
    'nb'    => "noruec\ bokmål",
    'nd'    => "ndebele\ septentrional",
    'nds'   => "baix\ alemany",
    'ne'    => 'nepalès',
    'new'   => 'newari',
    'ng'    => 'ndonga',
    'nia'   => 'nias',
    'nic'   => "llengua\ nigerokurdufaniana",
    'niu'   => 'niueà',
    'nl'    => 'neerlandès',
    'nl_be' => 'flamenc',
    'nn'    => "noruec\ nynorsk",
    'no'    => 'noruec',
    'nog'   => 'nogai',
    'non'   => "nòrdic\ antic",
    'nqo'   => 'n’Ko',
    'nr'    => "ndebele\ meridional",
    'nso'   => "sotho\ septentrional",
    'nub'   => "llengua\ nubiana",
    'nv'    => 'navaho',
    'nwc'   => "newari\ clàssic",
    'ny'    => 'nyanja',
    'nym'   => 'nyamwesi',
    'nyn'   => 'nyankore',
    'nyo'   => 'nyoro',
    'nzi'   => 'nzema',
    'oc'    => 'occità',
    'oj'    => 'ojibwa',
    'om'    => 'oromo',
    'or'    => 'oriya',
    'os'    => 'osset',
    'osa'   => 'osage',
    'ota'   => "turc\ otomà",
    'oto'   => "llengua\ otomangueana",
    'pa'    => 'panjabi',
    'paa'   => "llengua\ papú",
    'pag'   => 'pangasi',
    'pal'   => 'pahlavi',
    'pam'   => 'pampangà',
    'pap'   => 'papiamento',
    'pau'   => 'palauà',
    'peo'   => "persa\ antic",
    'phi'   => "llengua\ filipina",
    'phn'   => 'fenici',
    'pi'    => 'pali',
    'pl'    => 'polonès',
    'pon'   => 'ponapeà',
    'pra'   => 'pràcrit',
    'pro'   => "provençal\ antic",
    'ps'    => 'paixto',
    'pt'    => 'portuguès',
    'pt_br' => "portuguès\ de\ Brasil",
    'pt_pt' => "portuguès\ de\ Portugal",
    'qu'    => 'quètxua',
    'raj'   => 'rajasthani',
    'rap'   => 'rapanui',
    'rar'   => 'rarotongà',
    'rm'    => 'retoromànic',
    'rn'    => 'rundi',
    'ro'    => 'romanès',
    'roa'   => "llengua\ romànica",
    'rom'   => 'romaní',
    'ru'    => 'rus',
    'rup'   => 'aromanès',
    'rw'    => 'ruandès',
    'sa'    => 'sànscrit',
    'sad'   => 'sandawe',
    'sah'   => 'iacut',
    'sai'   => "llengua\ ameríndia\ meridional",
    'sal'   => "llengua\ salish",
    'sam'   => "arameu\ samarità",
    'sas'   => 'sasak',
    'sat'   => 'santali',
    'sc'    => 'sard',
    'scn'   => 'sicilià',
    'sco'   => 'escocès',
    'sd'    => 'sindhi',
    'se'    => "sami\ septentrional",
    'sel'   => 'selkup',
    'sem'   => "llengua\ semítica",
    'sg'    => 'sango',
    'sga'   => "irlandès\ antic",
    'sgn'   => "llengua\ de\ signes",
    'sh'    => 'serbocroat',
    'shn'   => 'xan',
    'si'    => 'singalès',
    'sid'   => 'sidamo',
    'sio'   => "llengua\ sioux",
    'sit'   => "llengua\ sinotibetana",
    'sk'    => 'eslovac',
    'sl'    => 'eslovè',
    'sla'   => "llengua\ eslava",
    'sm'    => 'samoà',
    'sma'   => "sami\ meridional",
    'smi'   => "llengua\ sami",
    'smj'   => "sami\ lule",
    'smn'   => "sami\ d\'Inari",
    'sms'   => "sami\ skolt",
    'sn'    => 'shona',
    'snk'   => 'soninke',
    'so'    => 'somali',
    'sog'   => 'sogdià',
    'son'   => 'songhai',
    'sq'    => 'albanès',
    'sr'    => 'serbi',
    'srn'   => 'sranan',
    'srr'   => 'serer',
    'ss'    => 'siswati',
    'ssa'   => "llengua\ nilosahariana",
    'st'    => "sotho\ meridional",
    'su'    => 'sundanès',
    'suk'   => 'sukuma',
    'sus'   => 'susú',
    'sux'   => 'sumeri',
    'sv'    => 'suec',
    'sw'    => 'suahili',
    'syc'   => "siríac\ clàssic",
    'syr'   => 'siríac',
    'ta'    => 'tàmil',
    'tai'   => "llengua\ tai",
    'te'    => 'telugu',
    'tem'   => 'temne',
    'ter'   => 'terena',
    'tet'   => 'tetun',
    'tg'    => 'tadjik',
    'th'    => 'thai',
    'ti'    => 'tigrinya',
    'tig'   => 'tigre',
    'tiv'   => 'tiv',
    'tk'    => 'turcman',
    'tkl'   => 'tokelauès',
    'tl'    => 'tagàlog',
    'tlh'   => 'klingonià',
    'tli'   => 'tlingit',
    'tmh'   => 'tamazight',
    'tn'    => 'tswana',
    'to'    => 'tongalès',
    'tog'   => 'tonga',
    'tpi'   => "tok\ pisin",
    'tr'    => 'turc',
    'trv'   => 'Taroko',
    'ts'    => 'tsonga',
    'tsi'   => 'tsimshià',
    'tt'    => 'tàtar',
    'tum'   => 'tumbuka',
    'tup'   => "llengua\ tupí",
    'tut'   => "llengua\ altaica",
    'tvl'   => 'tuvaluà',
    'tw'    => 'twi',
    'ty'    => 'tahitià',
    'tyv'   => 'tuvinià',
    'udm'   => 'udmurt',
    'ug'    => 'uigur',
    'uga'   => 'ugarític',
    'uk'    => 'ucraïnès',
    'umb'   => 'umbundu',
    'und'   => "idioma\ desconegut\ o\ no\ vàlid",
    'ur'    => 'urdú',
    'uz'    => 'uzbek',
    'vai'   => 'vai',
    've'    => 'venda',
    'vi'    => 'vietnamita',
    'vo'    => 'volapük',
    'vot'   => 'vòtic',
    'wa'    => 'való',
    'wak'   => "llengua\ wakash",
    'wal'   => 'ameto',
    'war'   => "waray\-waray",
    'was'   => 'washo',
    'wen'   => 'sòrab',
    'wo'    => 'wòlof',
    'xal'   => 'calmuc',
    'xh'    => 'xosa',
    'yao'   => 'yao',
    'yap'   => 'yapeà',
    'yi'    => 'jiddisch',
    'yo'    => 'ioruba',
    'ypk'   => "llengua\ iupik",
    'za'    => 'zhuang',
    'zap'   => 'zapoteca',
    'zbl'   => "símbols\ Bliss",
    'zen'   => 'zenaga',
    'zh'    => 'xinès',
    'znd'   => 'zande',
    'zu'    => 'zulu',
    'zun'   => 'zuni',
    'zxx'   => "sense\ contingut\ lingüístic",
    'zza'   => 'zaza',
);

%Locales::DB::Language::ca::name_to_code = (
    'abkhaz'                                                => 'ab',
    'accadi'                                                => 'akk',
    'acoli'                                                 => 'ach',
    'adangme'                                               => 'ada',
    'adigu'                                                 => 'ady',
    'afrihili'                                              => 'afh',
    'afrikaans'                                             => 'af',
    'aimara'                                                => 'ay',
    'ainu'                                                  => 'ain',
    'albans'                                                => 'sq',
    'alemany'                                               => 'de',
    "alemany\ austrac"                                      => 'de_at',
    "alemany\ sus"                                          => 'gsw',
    'aleuta'                                                => 'ale',
    "alt\ alemany\ antic"                                   => 'goh',
    "alt\ alemany\ mitj"                                    => 'gmh',
    "alt\ alemany\ sus"                                     => 'de_ch',
    "alt\ srab"                                             => 'hsb',
    "altaic\ meridional"                                    => 'alt',
    'ameto'                                                 => 'wal',
    'amhric'                                                => 'am',
    'angika'                                                => 'anp',
    'angls'                                                 => 'en',
    "angls\ americ"                                         => 'en_us',
    "angls\ antic"                                          => 'ang',
    "angls\ australi"                                       => 'en_au',
    "angls\ britnic"                                        => 'en_gb',
    "angls\ canadenc"                                       => 'en_ca',
    "angls\ mitj"                                           => 'enm',
    'aragons'                                               => 'an',
    'arameu'                                                => 'arc',
    "arameu\ samarit"                                       => 'sam',
    'arapaho'                                               => 'arp',
    'arauac'                                                => 'arw',
    'arauc'                                                 => 'arn',
    'armeni'                                                => 'hy',
    'aromans'                                               => 'rup',
    'assams'                                                => 'as',
    'asturi'                                                => 'ast',
    'atjeh'                                                 => 'ace',
    'atsam'                                                 => 'cch',
    'avstic'                                                => 'ae',
    'awadhi'                                                => 'awa',
    "baix\ alemany"                                         => 'nds',
    "baix\ srab"                                            => 'dsb',
    'baixkir'                                               => 'ba',
    'balins'                                                => 'ban',
    'balutxi'                                               => 'bal',
    'bambara'                                               => 'bm',
    'bamilek'                                               => 'bai',
    'banda'                                                 => 'bad',
    'bantu'                                                 => 'bnt',
    'basa'                                                  => 'bas',
    'basc'                                                  => 'eu',
    'batak'                                                 => 'btk',
    'beja'                                                  => 'bej',
    'bemba'                                                 => 'bem',
    'bengal'                                                => 'bn',
    'berber'                                                => 'ber',
    'bhojpuri'                                              => 'bho',
    'bicol'                                                 => 'bik',
    'bielors'                                               => 'be',
    'bihari'                                                => 'bh',
    'bilin'                                                 => 'byn',
    'bini'                                                  => 'bin',
    'birm'                                                  => 'my',
    'bislama'                                               => 'bi',
    'blackfoot'                                             => 'bla',
    'blgar'                                                 => 'bg',
    'bosni'                                                 => 'bs',
    'braj'                                                  => 'bra',
    'bret'                                                  => 'br',
    'bugui'                                                 => 'bug',
    'buriat'                                                => 'bua',
    'cabilenc'                                              => 'kab',
    'caddo'                                                 => 'cad',
    'caixmiri'                                              => 'ks',
    'caixubi'                                               => 'csb',
    'calmuc'                                                => 'xal',
    'careli'                                                => 'krl',
    'carib'                                                 => 'car',
    'catal'                                                 => 'ca',
    'cebuano'                                               => 'ceb',
    'chamorro'                                              => 'ch',
    'cherokee'                                              => 'chr',
    'chipewyan'                                             => 'chp',
    'choctaw'                                               => 'cho',
    'chuuk'                                                 => 'chk',
    'copte'                                                 => 'cop',
    'core'                                                  => 'ko',
    'cors'                                                  => 'co',
    'cree'                                                  => 'cr',
    'creek'                                                 => 'mus',
    'crnic'                                                 => 'kw',
    'croat'                                                 => 'hr',
    'daiak'                                                 => 'day',
    'dakota'                                                => 'dak',
    'dans'                                                  => 'da',
    'dargu'                                                 => 'dar',
    'delaware'                                              => 'del',
    'dinka'                                                 => 'din',
    'divehi'                                                => 'dv',
    'dogri'                                                 => 'doi',
    'dogrib'                                                => 'dgr',
    'duala'                                                 => 'dua',
    'dzongka'                                               => 'dz',
    'efik'                                                  => 'efi',
    "egipci\ antic"                                         => 'egy',
    'ekajuk'                                                => 'eka',
    'elamita'                                               => 'elx',
    'escocs'                                                => 'sco',
    "eslau\ eclesistic"                                     => 'cu',
    'eslov'                                                 => 'sl',
    'eslovac'                                               => 'sk',
    'espanyol'                                              => 'es',
    "espanyol\ despanya"                                    => 'es_es',
    'esperanto'                                             => 'eo',
    'estoni'                                                => 'et',
    'ewe'                                                   => 'ee',
    'ewondo'                                                => 'ewo',
    'fang'                                                  => 'fan',
    'fanti'                                                 => 'fat',
    'far'                                                   => 'aa',
    'fenici'                                                => 'phn',
    'feros'                                                 => 'fo',
    'fiji'                                                  => 'fj',
    'filip'                                                 => 'fil',
    'fins'                                                  => 'fi',
    'flamenc'                                               => 'nl_be',
    'fon'                                                   => 'fon',
    'francs'                                                => 'fr',
    "francs\ antic"                                         => 'fro',
    "francs\ canadenc"                                      => 'fr_ca',
    "francs\ mitj"                                          => 'frm',
    "francs\ sus"                                           => 'fr_ch',
    'fril'                                                  => 'fur',
    "fris\ occidental"                                      => 'frs',
    "fris\ oriental"                                        => 'fy',
    "fris\ septentrional"                                   => 'frr',
    'ful'                                                   => 'ff',
    'ga'                                                    => 'gaa',
    "galic\ escocs"                                         => 'gd',
    "galic\ irlands\ mitj"                                  => 'mga',
    'gallec'                                                => 'gl',
    'galls'                                                 => 'cy',
    'ganda'                                                 => 'lg',
    'gayo'                                                  => 'gay',
    'gbaya'                                                 => 'gba',
    'georgi'                                                => 'ka',
    'gilberts'                                              => 'gil',
    'gondi'                                                 => 'gon',
    'gorontalo'                                             => 'gor',
    'grebo'                                                 => 'grb',
    'grec'                                                  => 'el',
    "grec\ antic"                                           => 'grc',
    'grenlands'                                             => 'kl',
    'gtic'                                                  => 'got',
    'guaran'                                                => 'gn',
    'gueez'                                                 => 'gez',
    'gujarati'                                              => 'gu',
    'gwichin'                                               => 'gwi',
    'haida'                                                 => 'hai',
    'haiti'                                                 => 'ht',
    'haussa'                                                => 'ha',
    'hawai'                                                 => 'haw',
    'hebreu'                                                => 'he',
    'herero'                                                => 'hz',
    'hiligainon'                                            => 'hil',
    'himachali'                                             => 'him',
    'hindi'                                                 => 'hi',
    "hiri\ motu"                                            => 'ho',
    'hitita'                                                => 'hit',
    'hmong'                                                 => 'hmn',
    'hongars'                                               => 'hu',
    'hupa'                                                  => 'hup',
    'iacut'                                                 => 'sah',
    'iban'                                                  => 'iba',
    "idioma\ desconegut\ o\ no\ vlid"                       => 'und',
    'ido'                                                   => 'io',
    'igbo'                                                  => 'ig',
    'ijo'                                                   => 'ijo',
    'iloc'                                                  => 'ilo',
    'indonesi'                                              => 'id',
    'ingix'                                                 => 'inh',
    'interlingua'                                           => 'ia',
    'interlingue'                                           => 'ie',
    'inuktitut'                                             => 'iu',
    'inupiak'                                               => 'ik',
    'ioruba'                                                => 'yo',
    'irlands'                                               => 'ga',
    "irlands\ antic"                                        => 'sga',
    'iroqus'                                                => 'iro',
    'islands'                                               => 'is',
    'itali'                                                 => 'it',
    'japons'                                                => 'ja',
    'javans'                                                => 'jv',
    'jiddisch'                                              => 'yi',
    'jju'                                                   => 'kaj',
    'judeopersa'                                            => 'jpr',
    'judeorab'                                              => 'jrb',
    'jula'                                                  => 'dyu',
    'kabard'                                                => 'kbd',
    'kamba'                                                 => 'kam',
    'kan'                                                   => 'ak',
    'kannada'                                               => 'kn',
    'kanuri'                                                => 'kr',
    'karakalpak'                                            => 'kaa',
    'karatxai'                                              => 'krc',
    'karen'                                                 => 'kar',
    'katxin'                                                => 'kac',
    'kawi'                                                  => 'kaw',
    'kazakh'                                                => 'kk',
    'khasi'                                                 => 'kha',
    'khmer'                                                 => 'km',
    'khotans'                                               => 'kho',
    'kikuiu'                                                => 'ki',
    'kimbundu'                                              => 'kmb',
    'kirgus'                                                => 'ky',
    'klingoni'                                              => 'tlh',
    'kmik'                                                  => 'kum',
    'komi'                                                  => 'kv',
    'kongo'                                                 => 'kg',
    'konkani'                                               => 'kok',
    'koro'                                                  => 'kfo',
    'kosrae'                                                => 'kos',
    'kpelle'                                                => 'kpe',
    'kru'                                                   => 'kro',
    'kuanyama'                                              => 'kj',
    'kurd'                                                  => 'ku',
    'kurukh'                                                => 'kru',
    'kutenai'                                               => 'kut',
    'lad'                                                   => 'lad',
    'lamba'                                                 => 'lam',
    'laosi'                                                 => 'lo',
    'lesgui'                                                => 'lez',
    'let'                                                   => 'lv',
    'limburgus'                                             => 'li',
    'lingala'                                               => 'ln',
    'litu'                                                  => 'lt',
    'llat'                                                  => 'la',
    "llenges\ vries"                                        => 'mul',
    "llengua\ afroasitica"                                  => 'afa',
    "llengua\ algonquina"                                   => 'alg',
    "llengua\ altaica"                                      => 'tut',
    "llengua\ amerndia\ damrica\ central"                   => 'cai',
    "llengua\ amerndia\ meridional"                         => 'sai',
    "llengua\ amerndia\ septentrional"                      => 'nai',
    "llengua\ apatxe"                                       => 'apa',
    "llengua\ artificial"                                   => 'art',
    "llengua\ atapascana"                                   => 'ath',
    "llengua\ australiana"                                  => 'aus',
    "llengua\ austronsia"                                   => 'map',
    "llengua\ bltica"                                       => 'bat',
    "llengua\ caucsica"                                     => 'cau',
    "llengua\ cltica"                                       => 'cel',
    "llengua\ criolla\ o\ pidgin"                           => 'crp',
    "llengua\ criolla\ o\ pidgin\ basada\ en\ el\ francs"   => 'cpf',
    "llengua\ criolla\ o\ pidgin\ basada\ en\ el\ portugus" => 'cpp',
    "llengua\ criolla\ o\ pidgin\ basada\ en\ langls"       => 'cpe',
    "llengua\ cuixtica"                                     => 'cus',
    "llengua\ de\ signes"                                   => 'sgn',
    "llengua\ dravdica"                                     => 'dra',
    "llengua\ eslava"                                       => 'sla',
    "llengua\ filipina"                                     => 'phi',
    "llengua\ finogrica"                                    => 'fiu',
    "llengua\ germnica"                                     => 'gem',
    "llengua\ indoeuropea"                                  => 'ine',
    "llengua\ irnica"                                       => 'ira',
    "llengua\ iupik"                                        => 'ypk',
    "llengua\ khoisan"                                      => 'khi',
    "llengua\ maia"                                         => 'myn',
    "llengua\ manobo"                                       => 'mno',
    "llengua\ miscellnia"                                   => 'mis',
    "llengua\ monkhmer"                                     => 'mkh',
    "llengua\ munda"                                        => 'mun',
    "llengua\ ndica"                                        => 'inc',
    "llengua\ nigerokurdufaniana"                           => 'nic',
    "llengua\ nilosahariana"                                => 'ssa',
    "llengua\ nubiana"                                      => 'nub',
    "llengua\ otomangueana"                                 => 'oto',
    "llengua\ pap"                                          => 'paa',
    "llengua\ romnica"                                      => 'roa',
    "llengua\ salish"                                       => 'sal',
    "llengua\ sami"                                         => 'smi',
    "llengua\ semtica"                                      => 'sem',
    "llengua\ sinotibetana"                                 => 'sit',
    "llengua\ sioux"                                        => 'sio',
    "llengua\ tai"                                          => 'tai',
    "llengua\ tup"                                          => 'tup',
    "llengua\ wakash"                                       => 'wak',
    'lojban'                                                => 'jbo',
    'lozi'                                                  => 'loz',
    "luba\ katanga"                                         => 'lu',
    'lubalulua'                                             => 'lua',
    'luisenyo'                                              => 'lui',
    'lunda'                                                 => 'lun',
    'luo'                                                   => 'luo',
    'luxemburgus'                                           => 'lb',
    'macedoni'                                              => 'mk',
    'madurs'                                                => 'mad',
    'magahi'                                                => 'mag',
    'maithili'                                              => 'mai',
    'makassar'                                              => 'mak',
    'malai'                                                 => 'ms',
    'malaialam'                                             => 'ml',
    'malgaix'                                               => 'mg',
    'malts'                                                 => 'mt',
    'mandar'                                                => 'mdr',
    'mandinga'                                              => 'man',
    'manipur'                                               => 'mni',
    'manx'                                                  => 'mnc',
    'maori'                                                 => 'mi',
    'marathi'                                               => 'mr',
    'mari'                                                  => 'chm',
    'marshalls'                                             => 'mh',
    'marwari'                                               => 'mwr',
    'massai'                                                => 'mas',
    'mende'                                                 => 'men',
    'micmac'                                                => 'mic',
    'minangkabau'                                           => 'min',
    'mirands'                                               => 'mwl',
    'mizo'                                                  => 'lus',
    'mohawk'                                                => 'moh',
    'moldau'                                                => 'mo',
    'mongo'                                                 => 'lol',
    'mongol'                                                => 'mn',
    'mor'                                                   => 'mos',
    "mordovi\ erza"                                         => 'myv',
    "mordovi\ moksa"                                        => 'mdf',
    'morisyen'                                              => 'mfe',
    'napolit'                                               => 'nap',
    'nauru'                                                 => 'na',
    'navaho'                                                => 'nv',
    "ndebele\ meridional"                                   => 'nr',
    "ndebele\ septentrional"                                => 'nd',
    'ndonga'                                                => 'ng',
    'neerlands'                                             => 'nl',
    "neerlands\ mitj"                                       => 'dum',
    'nepals'                                                => 'ne',
    'newari'                                                => 'new',
    "newari\ clssic"                                        => 'nwc',
    'nhuatl'                                                => 'nah',
    'nias'                                                  => 'nia',
    'niue'                                                  => 'niu',
    'nko'                                                   => 'nqo',
    'nogai'                                                 => 'nog',
    'noruec'                                                => 'no',
    "noruec\ bokml"                                         => 'nb',
    "noruec\ nynorsk"                                       => 'nn',
    "nrdic\ antic"                                          => 'non',
    'nyamwesi'                                              => 'nym',
    'nyanja'                                                => 'ny',
    'nyankore'                                              => 'nyn',
    'nyoro'                                                 => 'nyo',
    'nzema'                                                 => 'nzi',
    'occit'                                                 => 'oc',
    'ojibwa'                                                => 'oj',
    'oriya'                                                 => 'or',
    'oromo'                                                 => 'om',
    'osage'                                                 => 'osa',
    'osset'                                                 => 'os',
    'pahlavi'                                               => 'pal',
    'paixto'                                                => 'ps',
    'palau'                                                 => 'pau',
    'pali'                                                  => 'pi',
    'pampang'                                               => 'pam',
    'pangasi'                                               => 'pag',
    'panjabi'                                               => 'pa',
    "panjabi\ occidental"                                   => 'lah',
    'papiamento'                                            => 'pap',
    'persa'                                                 => 'fa',
    "persa\ antic"                                          => 'peo',
    "pidgin\ chinook"                                       => 'chn',
    'polons'                                                => 'pl',
    'ponape'                                                => 'pon',
    'portugus'                                              => 'pt',
    "portugus\ de\ brasil"                                  => 'pt_br',
    "portugus\ de\ portugal"                                => 'pt_pt',
    'prcrit'                                                => 'pra',
    "provenal\ antic"                                       => 'pro',
    'qutxua'                                                => 'qu',
    'rab'                                                   => 'ar',
    'rajasthani'                                            => 'raj',
    'rapanui'                                               => 'rap',
    'rarotong'                                              => 'rar',
    'retoromnic'                                            => 'rm',
    'roman'                                                 => 'rom',
    'romans'                                                => 'ro',
    'ruands'                                                => 'rw',
    'rundi'                                                 => 'rn',
    'rus'                                                   => 'ru',
    "sami\ dinari"                                          => 'smn',
    "sami\ lule"                                            => 'smj',
    "sami\ meridional"                                      => 'sma',
    "sami\ septentrional"                                   => 'se',
    "sami\ skolt"                                           => 'sms',
    'samo'                                                  => 'sm',
    'sandawe'                                               => 'sad',
    'sango'                                                 => 'sg',
    'santali'                                               => 'sat',
    'sard'                                                  => 'sc',
    'sasak'                                                 => 'sas',
    'selkup'                                                => 'sel',
    "sense\ contingut\ lingstic"                            => 'zxx',
    'serbi'                                                 => 'sr',
    'serbocroat'                                            => 'sh',
    'serer'                                                 => 'srr',
    'shona'                                                 => 'sn',
    'sicili'                                                => 'scn',
    'sidamo'                                                => 'sid',
    'sindhi'                                                => 'sd',
    'singals'                                               => 'si',
    'sirac'                                                 => 'syr',
    "sirac\ clssic"                                         => 'syc',
    'siswati'                                               => 'ss',
    'slavey'                                                => 'den',
    "smbols\ bliss"                                         => 'zbl',
    'snscrit'                                               => 'sa',
    'sogdi'                                                 => 'sog',
    'somali'                                                => 'so',
    'songhai'                                               => 'son',
    'soninke'                                               => 'snk',
    "sotho\ meridional"                                     => 'st',
    "sotho\ septentrional"                                  => 'nso',
    'srab'                                                  => 'wen',
    'sranan'                                                => 'srn',
    'suahili'                                               => 'sw',
    'suec'                                                  => 'sv',
    'sukuma'                                                => 'suk',
    'sumeri'                                                => 'sux',
    'sundans'                                               => 'su',
    'sus'                                                   => 'sus',
    'tadjik'                                                => 'tg',
    'taglog'                                                => 'tl',
    'tahiti'                                                => 'ty',
    'tamazight'                                             => 'tmh',
    'taroko'                                                => 'trv',
    'telugu'                                                => 'te',
    'temne'                                                 => 'tem',
    'terena'                                                => 'ter',
    'tetun'                                                 => 'tet',
    'thai'                                                  => 'th',
    'tibet'                                                 => 'bo',
    'tigre'                                                 => 'tig',
    'tigrinya'                                              => 'ti',
    'tiv'                                                   => 'tiv',
    'tlingit'                                               => 'tli',
    'tmil'                                                  => 'ta',
    "tok\ pisin"                                            => 'tpi',
    'tokelaus'                                              => 'tkl',
    'tonga'                                                 => 'tog',
    'tongals'                                               => 'to',
    'tsimshi'                                               => 'tsi',
    'tsonga'                                                => 'ts',
    'tswana'                                                => 'tn',
    'ttar'                                                  => 'tt',
    "ttar\ de\ crimea"                                      => 'crh',
    'tumbuka'                                               => 'tum',
    'turc'                                                  => 'tr',
    "turc\ otom"                                            => 'ota',
    'turcman'                                               => 'tk',
    'tuvalu'                                                => 'tvl',
    'tuvini'                                                => 'tyv',
    'twi'                                                   => 'tw',
    'txagatai'                                              => 'chg',
    'txam'                                                  => 'cmc',
    'txec'                                                  => 'cs',
    'txetx'                                                 => 'ce',
    'txibtxa'                                               => 'chb',
    'txuvaix'                                               => 'cv',
    'tyap'                                                  => 'kcg',
    'ucrans'                                                => 'uk',
    'udmurt'                                                => 'udm',
    'ugartic'                                               => 'uga',
    'uigur'                                                 => 'ug',
    'umbundu'                                               => 'umb',
    'urd'                                                   => 'ur',
    'uzbek'                                                 => 'uz',
    'vai'                                                   => 'vai',
    'val'                                                   => 'wa',
    'var'                                                   => 'av',
    'venda'                                                 => 've',
    'vietnamita'                                            => 'vi',
    'volapk'                                                => 'vo',
    'vtic'                                                  => 'vot',
    'waraywaray'                                            => 'war',
    'washo'                                                 => 'was',
    'wlof'                                                  => 'wo',
    'xan'                                                   => 'shn',
    'xeienne'                                               => 'chy',
    'xins'                                                  => 'zh',
    'xosa'                                                  => 'xh',
    'yao'                                                   => 'yao',
    'yape'                                                  => 'yap',
    "yi\ sichuan"                                           => 'ii',
    'zande'                                                 => 'znd',
    'zapoteca'                                              => 'zap',
    'zaza'                                                  => 'zza',
    'zenaga'                                                => 'zen',
    'zeri'                                                  => 'az',
    'zhuang'                                                => 'za',
    'zulu'                                                  => 'zu',
    'zuni'                                                  => 'zun',
);

1;
