package Locales::DB::Language::az;

# Auto generated from CLDR

$Locales::DB::Language::az::VERSION = '0.01';

$Locales::DB::Language::az::cldr_version = '1.7.1';

%Locales::DB::Language::az::misc_info = (
    'cldr_formats' => {
        'decimal'   => "\#\,\#\#0\.\#\#\#",
        'language'  => "Dil\:\ \{0\}",
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Rayon\:\ \{0\}"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr' => {
            'content' => "yox\:y",
            'draft'   => 'contributed'
        },
        'yesstr' => {
            'content' => "hə\:h",
            'draft'   => 'contributed'
        }
    },
);

%Locales::DB::Language::az::code_to_name = (
    'aa'    => 'afarca',
    'ab'    => 'abxazca',
    'ace'   => "akin\ dili",
    'ach'   => "akoli\ dili",
    'ada'   => "adangme\ dili",
    'ady'   => "aduge\ dili",
    'ae'    => 'avestanca',
    'af'    => 'Afrikaanca',
    'afa'   => "afro\-aziat\ dili",
    'afh'   => "afrihili\ dili",
    'ain'   => 'aynuca',
    'ak'    => 'akanca',
    'akk'   => 'akadianca',
    'ale'   => 'aleutca',
    'alg'   => "algonguyan\ dili",
    'alt'   => "cənub\ altay\ dili",
    'am'    => 'amarikcə',
    'an'    => 'aragonca',
    'ang'   => "qədimi\ ingiliscə",
    'anp'   => "angikə\ dili",
    'apa'   => "apaçi\ dili",
    'ar'    => 'Ərəbcə',
    'arc'   => "aramik\ dili",
    'arn'   => 'araukanca',
    'arp'   => "arapaho\ dili",
    'art'   => "suni\ dil",
    'arw'   => 'aravakça',
    'as'    => 'as',
    'ast'   => 'asturicə',
    'ath'   => 'atapaskanca',
    'aus'   => 'avstraliyca',
    'av'    => 'avarikcə',
    'awa'   => 'avadicə',
    'ay'    => 'aymarca',
    'az'    => 'azərbaycanca',
    'ba'    => "başkir\ dili",
    'bad'   => "banda\ dili",
    'bai'   => "bamilek\ dili",
    'bal'   => "baluc\ dili",
    'ban'   => 'balincə',
    'bas'   => "basa\ dili",
    'bat'   => "baltik\ dili",
    'be'    => 'belarusca',
    'bej'   => "beja\ dili",
    'bem'   => "bemba\ dili",
    'ber'   => "berber\ dili",
    'bg'    => 'bolqarca',
    'bh'    => 'biharicə',
    'bho'   => "bxoçpuri\ dili",
    'bi'    => "bislama\ dili",
    'bik'   => 'bikolca',
    'bin'   => "bini\ dili",
    'bla'   => "siksikə\ dili",
    'bm'    => "bambara\ dili",
    'bn'    => "Benqal\ dili",
    'bnt'   => "bantu\ dili",
    'bo'    => "tibet\ dili",
    'br'    => 'Bretonca',
    'bra'   => "braj\ dili",
    'bs'    => "bosniya\ dili",
    'btk'   => "batak\ dili",
    'bua'   => "buryat\ dili",
    'bug'   => "bugin\ dili",
    'byn'   => 'bilincə',
    'ca'    => 'katalanca',
    'cad'   => "kado\ dili",
    'cai'   => "mərkəzi\ amerika\ indus\ dili",
    'car'   => "karib\ dili",
    'cau'   => "qavqaz\ dili",
    'cch'   => 'atsamca',
    'ce'    => "çeçen\ dili",
    'ceb'   => "kebuano\ dili",
    'cel'   => "kelt\ dili",
    'ch'    => "çamoro\ dili",
    'chb'   => "çibçə\ dili",
    'chg'   => "çağatay\ dili",
    'chk'   => "çukiz\ dili",
    'chm'   => "mari\ dili",
    'chn'   => "çinuk\ ləhçəsi",
    'cho'   => "çoktau\ dili",
    'chp'   => "çipevyan\ dili",
    'chr'   => "çiroki\ dili",
    'chy'   => "çeyen\ dili",
    'cmc'   => "çamik\ dili",
    'co'    => "korsikan\ dili",
    'cop'   => "kopt\ dili",
    'cpe'   => "inglis\ kreol\ dili",
    'cpf'   => "fransız\ kreol\ dili",
    'cpp'   => "portugal\ kreol\ dili",
    'cr'    => "kri\ dili",
    'crh'   => "krım\ türkçə",
    'crp'   => "kreol\ dili",
    'cs'    => "çex\ dili",
    'csb'   => "kaşubyan\ dili",
    'cu'    => "kilsə\ slav\ dili",
    'cus'   => "kuşitik\ dili",
    'cv'    => "çuvaş\ dili",
    'cy'    => 'uelscə',
    'da'    => "danimarka\ dili",
    'dak'   => "dakota\ dili",
    'dar'   => "darqva\ dili",
    'day'   => "dayak\ dili",
    'de'    => 'almanca',
    'de_at' => "almanca\ \(AT\)",
    'de_ch' => "isveç\ yüksək\ almancası",
    'del'   => "delaver\ dili",
    'den'   => 'slavey',
    'dgr'   => "doqrib\ dili",
    'din'   => "dinka\ dili",
    'doi'   => "doqri\ dili",
    'dra'   => "dravid\ dili",
    'dsb'   => "aşağı\ sorbca",
    'dua'   => "duala\ dili",
    'dum'   => "ortacaq\ hollandca",
    'dv'    => "diveh\ dili",
    'dyu'   => "dyula\ dili",
    'dz'    => "dzonqa\ dili",
    'ee'    => "eve\ dili",
    'efi'   => "efik\ dili",
    'egy'   => "qədimi\ misir\ dili",
    'eka'   => "ekacuk\ dili",
    'el'    => 'yunanca',
    'elx'   => "elamit\ dili",
    'en'    => 'ingiliscə',
    'en_au' => "ingiliscə\ \(AU\)",
    'en_ca' => "ingiliscə\ \(CA\)",
    'en_gb' => "ingiliscə\ \(GB\)",
    'en_us' => "ingiliscə\ \(ABŞ\)",
    'enm'   => "ortacaq\ ingiliscə",
    'eo'    => "esperanto\ dili",
    'es'    => 'ispanca',
    'es_es' => "iber\-ispanca",
    'et'    => 'estonca',
    'eu'    => "bask\ dili",
    'ewo'   => "evondo\ dili",
    'fa'    => 'farsca',
    'fan'   => "fang\ dili",
    'fat'   => "fanti\ dili",
    'ff'    => "fula\ dili",
    'fi'    => 'fincə',
    'fil'   => 'taqaloqca',
    'fiu'   => "fin\-uğri\ dili",
    'fj'    => "fiji\ dili",
    'fo'    => "farer\ dili",
    'fon'   => "fon\ dili",
    'fr'    => 'fransızca',
    'fr_ca' => "fransızca\ \(CA\)",
    'fr_ch' => "isveç\ fransızca",
    'frm'   => "ortacaq\ fransızca",
    'fro'   => "qədimi\ fransızca",
    'frr'   => "şimal\ fris\ dili",
    'frs'   => "Eastern\ Frisian",
    'fur'   => "friul\ dili",
    'fy'    => "frisk\ dili",
    'ga'    => 'irlandca',
    'gaa'   => "qa\ dili",
    'gay'   => "qayo\ dili",
    'gba'   => "qabaya\ dili",
    'gd'    => "skot\ gaelik\ dili",
    'gem'   => "Alman\ dili",
    'gez'   => "qez\ dili",
    'gil'   => "qilbert\ gili",
    'gl'    => "qalisian\ dili",
    'gmh'   => "ortacaq\ yüksək\ almanca",
    'gn'    => 'quaranicə',
    'goh'   => "qədimi\ almanca",
    'gon'   => "qondi\ dili",
    'gor'   => "qorontalo\ dili",
    'got'   => 'gotça',
    'grb'   => "qrebo\ dili",
    'grc'   => "qədimi\ yunanca",
    'gsw'   => "isveç\ almanca",
    'gu'    => "gujarati\ dili",
    'gv'    => "manks\ dili",
    'gwi'   => "qviçin\ dili",
    'ha'    => "Hausa\ dili",
    'hai'   => "hayda\ dili",
    'haw'   => 'Qavayca',
    'he'    => 'ivritcə',
    'hi'    => "hindi\ dili",
    'hil'   => "hiliqaynon\ dili",
    'him'   => "himaçali\ dili",
    'hit'   => "hittit\ dili",
    'hmn'   => "monq\ dili",
    'ho'    => "hiri\ motu\ dili",
    'hr'    => 'xorvatca',
    'hsb'   => "yuxarı\ sorbca",
    'ht'    => "haiti\ dili",
    'hu'    => 'macarca',
    'hup'   => "hupa\ dili",
    'hy'    => 'Ermənicə',
    'hz'    => "Herer\ dili",
    'ia'    => "interlingua\ dili",
    'iba'   => "iban\ dili",
    'id'    => "indoneziya\ dili",
    'ie'    => "interlingue\ dili",
    'ig'    => "iqbo\ dili",
    'ii'    => "siçuan\ yi\ dili",
    'ijo'   => "ico\ dili",
    'ik'    => "inupiaq\ dili",
    'ilo'   => "iloko\ dili",
    'inc'   => "diqər\ hint\ dili",
    'ine'   => "hint\-yevropa\ dili",
    'inh'   => "inquş\ dili",
    'io'    => "ido\ dili",
    'ira'   => 'iranca',
    'iro'   => "irokuay\ dili",
    'is'    => 'isləndcə',
    'it'    => 'italyanca',
    'iu'    => "inuktikut\ dili",
    'ja'    => 'yaponca',
    'jbo'   => "loğban\ dili",
    'jpr'   => "judo\-farsca",
    'jrb'   => "jude\-ərəbcə",
    'jv'    => "yavaca\ dili",
    'ka'    => "gürcü\ dili",
    'kaa'   => "qara\-qalpaq\ dili",
    'kab'   => "kabule\ dili",
    'kac'   => 'kaçinca',
    'kaj'   => "ju\ dili",
    'kam'   => "kamba\ dili",
    'kar'   => "karen\ dili",
    'kaw'   => "kavi\ dili",
    'kbd'   => 'kabardca',
    'kcg'   => "tiyap\ dili",
    'kfo'   => "koro\ dili",
    'kg'    => "konqo\ dili",
    'kha'   => "xazi\ dili",
    'khi'   => "xoyzan\ dili",
    'kho'   => "xotan\ dili",
    'ki'    => "kikuyu\ dili",
    'kj'    => "kuanyama\ dili",
    'kk'    => "qazax\ dili",
    'kl'    => "kalalisut\ dili",
    'km'    => "kambodiya\ dili",
    'kmb'   => "kimbundu\ dili",
    'kn'    => "kannada\ dili",
    'ko'    => "koreya\ dili",
    'kok'   => "konkan\ dili",
    'kos'   => "kosreyan\ dili",
    'kpe'   => "kpelle\ dili",
    'kr'    => "kanur\ dili",
    'krc'   => "qaraçay\-balkar\ dili",
    'krl'   => "karelyan\ dili",
    'kro'   => "kru\ dili",
    'kru'   => "kurux\ dili",
    'ks'    => "kəşmir\ dili",
    'ku'    => 'kürdcə',
    'kum'   => "kumuk\ dili",
    'kut'   => "kutenay\ dili",
    'kv'    => "komi\ dili",
    'kw'    => "korniş\ dili",
    'ky'    => 'qırğızca',
    'la'    => 'latınca',
    'lad'   => "ladin\ dili",
    'lah'   => "laxnda\ dili",
    'lam'   => "lamba\ dili",
    'lb'    => "luksemburq\ dili",
    'lez'   => "ləzqi\ dili",
    'lg'    => "qanda\ dili",
    'li'    => "limburqiş\ dili",
    'ln'    => "Linqala\ dili",
    'lo'    => "laos\ dili",
    'lol'   => "monqo\ dili",
    'loz'   => "lozi\ dili",
    'lt'    => "litva\ dili",
    'lu'    => "luba\-katanqa\ dili",
    'lua'   => "luba\-lulua\ dili",
    'lui'   => "luyseno\ dili",
    'lun'   => "lunda\ dili",
    'luo'   => "luo\ dili",
    'lus'   => 'lushayca',
    'lv'    => 'latışca',
    'mad'   => "maduriz\ dili",
    'mag'   => "maqahi\ dili",
    'mai'   => "maitili\ dili",
    'mak'   => "makasar\ dili",
    'man'   => "məndinqo\ dili",
    'map'   => 'avstronezicə',
    'mas'   => "masay\ dili",
    'mdf'   => "mokşa\ dili",
    'mdr'   => "mandar\ dili",
    'men'   => "mende\ dili",
    'mfe'   => 'Morisyen',
    'mg'    => "malaqas\ dili",
    'mga'   => "ortacaq\ irlandca",
    'mh'    => "marşal\ dili",
    'mi'    => "maori\ dili",
    'mic'   => "mikmak\ dili",
    'min'   => "minanqkaban\ dili",
    'mis'   => "çeşitli\ diller",
    'mk'    => "makedoniya\ dili",
    'mkh'   => "mon\-xmer\ dili",
    'ml'    => 'malayalamca',
    'mn'    => 'monqolca',
    'mnc'   => "mançu\ dili",
    'mni'   => "manipüri\ dili",
    'mno'   => "manobo\ dili",
    'mo'    => 'moldavca',
    'moh'   => "moxak\ dili",
    'mos'   => "mosi\ dili",
    'mr'    => "marati\ dili",
    'ms'    => 'malayca',
    'mt'    => "malta\ dili",
    'mul'   => "digər\ dillər",
    'mun'   => "munda\ dili",
    'mus'   => "krik\ dili",
    'mwl'   => "mirand\ dili",
    'mwr'   => "maruari\ dili",
    'my'    => "burmis\ dili",
    'myn'   => "maya\ dili",
    'myv'   => "erzya\ dili",
    'na'    => "nauru\ dili",
    'nah'   => "nahuatl\ dili",
    'nai'   => "şimal\ amerika\ yerli\ dili",
    'nap'   => "neapolital\ dili",
    'nb'    => "norvec\ bokmal\ dili",
    'nd'    => "şimal\ ndebele\ dili",
    'nds'   => "aşağı\ almanca",
    'ne'    => 'nepalca',
    'new'   => "nevari\ dili",
    'ng'    => "nqonka\ dili",
    'nia'   => "nyas\ dili",
    'nic'   => "niger\-kordofyan\ dili",
    'niu'   => "niyuan\ dili",
    'nl'    => 'hollandca',
    'nl_be' => "flem\ dili",
    'nn'    => "norveç\ ninorsk\ dili",
    'no'    => "norveç\ dili",
    'nog'   => "noqay\ dili",
    'non'   => "qədimi\ norsca",
    'nqo'   => "nqo\ dili",
    'nr'    => "cənub\ ndebele\ dili",
    'nso'   => "şimal\ soto\ dili",
    'nub'   => "nubiy\ dili",
    'nv'    => "navayo\ dili",
    'nwc'   => "Classical\ Newari",
    'ny'    => "nyanca\ dili",
    'nym'   => "nyamvezi\ dili",
    'nyn'   => "nyankol\ dili",
    'nyo'   => "niyoro\ dili",
    'nzi'   => "nizima\ dili",
    'oc'    => 'oksitanca',
    'oj'    => "ocibva\ dili",
    'om'    => "oromo\ dili",
    'or'    => "Oriyə\ dili",
    'os'    => "osetik\ dili",
    'osa'   => "osage\ dili",
    'ota'   => "osman\ dili",
    'oto'   => "otomian\ dili",
    'pa'    => "puncab\ dili",
    'paa'   => "papua\ dili",
    'pag'   => "panqasinan\ dili",
    'pal'   => "paxlavi\ dili",
    'pam'   => "pampanqa\ dili",
    'pap'   => "papyamento\ dili",
    'pau'   => 'palayanca',
    'peo'   => "qədimi\ farsca",
    'phi'   => "filipin\ dili",
    'phn'   => "foyenik\ dili",
    'pi'    => "pali\ dili",
    'pl'    => "Polish\ dili",
    'pon'   => "ponpeyan\ dili",
    'pra'   => "prakrit\ dili",
    'pro'   => "qədimi\ provensialca",
    'ps'    => "Puştu\ dili",
    'pt'    => 'portuqalca',
    'pt_br' => "Brazilian\ Portuguese",
    'pt_pt' => "İber\ portuqalca",
    'qu'    => "kuechya\ dili",
    'raj'   => "racastan\ dili",
    'rap'   => "rapanu\ dili",
    'rar'   => "rarotonqan\ dili",
    'rm'    => "Rhaeto\-Romance",
    'rn'    => "rundi\ dili",
    'ro'    => 'rumın',
    'roa'   => "Romance\ Language",
    'rom'   => "roman\ dili",
    'ru'    => 'rusca',
    'rup'   => 'aromanca',
    'rw'    => "kinyarvanda\ dili",
    'sa'    => "Sanskrit\ dili",
    'sad'   => "sandave\ dili",
    'sah'   => "yakut\ dili",
    'sai'   => "cənub\ amerika\ yerli\ dili",
    'sal'   => "salişan\ dili",
    'sam'   => "samaritan\ dili",
    'sas'   => "sasak\ dili",
    'sat'   => "santal\ dili",
    'sc'    => "sardin\ dili",
    'scn'   => "sisili\ dili",
    'sco'   => "skots\ dili",
    'sd'    => "sindhi\ dili",
    'se'    => "şimal\ sami\ dili",
    'sel'   => "selkup\ dili",
    'sem'   => "ivrit\ dili",
    'sg'    => "sanqo\ dili",
    'sga'   => "qədimi\ irlandca",
    'sgn'   => "işarət\ dili",
    'sh'    => "serb\-xorvatca",
    'shn'   => "şan\ dili",
    'si'    => 'sinhaliscə',
    'sid'   => "sidamo\ dili",
    'sio'   => "sioyan\ dili",
    'sit'   => "sino\-tibet\ dili",
    'sk'    => 'slovakca',
    'sl'    => 'slovencə',
    'sla'   => "slav\ dili",
    'sm'    => "samoa\ dili",
    'sma'   => "cənub\ sami\ dili",
    'smi'   => "səmi\ dili",
    'smj'   => "lule\ sami\ dili",
    'smn'   => "inari\ sami",
    'sms'   => "skolt\ dili",
    'sn'    => "şona\ dili",
    'snk'   => "soninke\ dili",
    'so'    => "somali\ dili",
    'sog'   => "soqdiyen\ dili",
    'son'   => "sonqay\ dili",
    'sq'    => 'Albanca',
    'sr'    => "serb\ dili",
    'srn'   => "sranan\ tonqo\ dili",
    'srr'   => "serer\ dilii",
    'ss'    => "svati\ dili",
    'ssa'   => "nilo\-sahara\ dili",
    'st'    => "Sesoto\ dili",
    'su'    => 'sundanca',
    'suk'   => "sukuma\ dili",
    'sus'   => "susu\ dili",
    'sux'   => "sumeryan\ dili",
    'sv'    => 'isveçcə',
    'sw'    => 'suahilicə',
    'syc'   => "Classical\ Syriac",
    'syr'   => "siryak\ dili",
    'ta'    => 'tamilcə',
    'tai'   => "tay\ dili",
    'te'    => "teluqu\ dili",
    'tem'   => "timne\ dili",
    'ter'   => "tereno\ dili",
    'tet'   => "tetum\ dili",
    'tg'    => "tacik\ dili",
    'th'    => 'tayca',
    'ti'    => "tiqrin\ dili",
    'tig'   => "tiqre\ dili",
    'tiv'   => "tiv\ dili",
    'tk'    => 'türkməncə',
    'tkl'   => "tokelay\ dili",
    'tl'    => "taqaloq\ dili",
    'tlh'   => 'klinqon',
    'tli'   => "tlinqit\ dili",
    'tmh'   => "tamaşek\ dili",
    'tn'    => "svana\ dili",
    'to'    => "tonqa\ dili",
    'tog'   => "niyasa\ tonga\ dili",
    'tpi'   => "tok\ pisin\ dili",
    'tr'    => 'türkcə',
    'trv'   => 'Taroko',
    'ts'    => "sonqa\ dili",
    'tsi'   => "simşyan\ dili",
    'tt'    => 'tatarca',
    'tum'   => "tumbuka\ dili",
    'tup'   => "tupi\ dili",
    'tut'   => "altaik\ dili",
    'tvl'   => "tuvalu\ dili",
    'tw'    => "Tvi\ dili",
    'ty'    => "taxiti\ dili",
    'tyv'   => "tuvinyan\ dili",
    'udm'   => "udmurt\ dili",
    'ug'    => 'uyğurca',
    'uga'   => "uqaritik\ dili",
    'uk'    => 'ukraynaca',
    'umb'   => "umbundu\ dili",
    'und'   => "bilinməyən\ vəya\ gəcərsiz\ dil",
    'ur'    => 'urduca',
    'uz'    => 'özbəkcə',
    'vai'   => "vay\ dili",
    've'    => "venda\ dili",
    'vi'    => 'vyetnamca',
    'vo'    => "volapük\ dili",
    'vot'   => "votik\ dili",
    'wa'    => "valun\ dili",
    'wak'   => "vakaşan\ dili",
    'wal'   => "valamo\ dili",
    'war'   => "varay\ dili",
    'was'   => "vaşo\ dili",
    'wen'   => "sorb\ dili",
    'wo'    => "volof\ dili",
    'xal'   => 'kalmıqca',
    'xh'    => "xosa\ dili",
    'yao'   => "yao\ dili",
    'yap'   => "yapiz\ dili",
    'yi'    => "Yahudi\ dili",
    'yo'    => "yoruba\ dili",
    'ypk'   => "yupik\ dili",
    'za'    => "juənq\ dili",
    'zap'   => "zapotek\ dili",
    'zbl'   => "blisimbols\ dili",
    'zen'   => "zenaqa\ dili",
    'zh'    => 'çincə',
    'znd'   => "zande\ dili",
    'zu'    => "zulu\ dili",
    'zun'   => "zuni\ dili",
    'zxx'   => "No\ linguistic\ content",
    'zza'   => "zaza\ dili",
);

%Locales::DB::Language::az::name_to_code = (
    "aa\ almanca"                 => 'nds',
    "aa\ sorbca"                  => 'dsb',
    "aatay\ dili"                 => 'chg',
    'abxazca'                     => 'ab',
    "adangme\ dili"               => 'ada',
    "aduge\ dili"                 => 'ady',
    'afarca'                      => 'aa',
    "afrihili\ dili"              => 'afh',
    'afrikaanca'                  => 'af',
    "afroaziat\ dili"             => 'afa',
    'akadianca'                   => 'akk',
    'akanca'                      => 'ak',
    "akin\ dili"                  => 'ace',
    "akoli\ dili"                 => 'ach',
    'albanca'                     => 'sq',
    'aleutca'                     => 'ale',
    "algonguyan\ dili"            => 'alg',
    "alman\ dili"                 => 'gem',
    'almanca'                     => 'de',
    "almanca\ at"                 => 'de_at',
    "altaik\ dili"                => 'tut',
    'amarikc'                     => 'am',
    "amik\ dili"                  => 'cmc',
    "amoro\ dili"                 => 'ch',
    "an\ dili"                    => 'shn',
    "angik\ dili"                 => 'anp',
    "apai\ dili"                  => 'apa',
    'aragonca'                    => 'an',
    "aramik\ dili"                => 'arc',
    "arapaho\ dili"               => 'arp',
    'araukanca'                   => 'arn',
    'aravaka'                     => 'arw',
    'aromanca'                    => 'rup',
    'as'                          => 'as',
    'asturic'                     => 'ast',
    'atapaskanca'                 => 'ath',
    'atsamca'                     => 'cch',
    'avadic'                      => 'awa',
    'avarikc'                     => 'av',
    'avestanca'                   => 'ae',
    'avstraliyca'                 => 'aus',
    'avstronezic'                 => 'map',
    'aymarca'                     => 'ay',
    'aynuca'                      => 'ain',
    'azrbaycanca'                 => 'az',
    "bakir\ dili"                 => 'ba',
    'balinc'                      => 'ban',
    "baltik\ dili"                => 'bat',
    "baluc\ dili"                 => 'bal',
    "bambara\ dili"               => 'bm',
    "bamilek\ dili"               => 'bai',
    "banda\ dili"                 => 'bad',
    "bantu\ dili"                 => 'bnt',
    "basa\ dili"                  => 'bas',
    "bask\ dili"                  => 'eu',
    "batak\ dili"                 => 'btk',
    "beja\ dili"                  => 'bej',
    'belarusca'                   => 'be',
    "bemba\ dili"                 => 'bem',
    "benqal\ dili"                => 'bn',
    "ber\ portuqalca"             => 'pt_pt',
    "berber\ dili"                => 'ber',
    'biharic'                     => 'bh',
    'bikolca'                     => 'bik',
    'bilinc'                      => 'byn',
    "bilinmyn\ vya\ gcrsiz\ dil"  => 'und',
    "bini\ dili"                  => 'bin',
    "bislama\ dili"               => 'bi',
    "blisimbols\ dili"            => 'zbl',
    'bolqarca'                    => 'bg',
    "bosniya\ dili"               => 'bs',
    "braj\ dili"                  => 'bra',
    "brazilian\ portuguese"       => 'pt_br',
    'bretonca'                    => 'br',
    "bugin\ dili"                 => 'bug',
    "burmis\ dili"                => 'my',
    "buryat\ dili"                => 'bua',
    "bxopuri\ dili"               => 'bho',
    "classical\ newari"           => 'nwc',
    "classical\ syriac"           => 'syc',
    "cnub\ altay\ dili"           => 'alt',
    "cnub\ amerika\ yerli\ dili"  => 'sai',
    "cnub\ ndebele\ dili"         => 'nr',
    "cnub\ sami\ dili"            => 'sma',
    "dakota\ dili"                => 'dak',
    "danimarka\ dili"             => 'da',
    "darqva\ dili"                => 'dar',
    "dayak\ dili"                 => 'day',
    "delaver\ dili"               => 'del',
    "digr\ dillr"                 => 'mul',
    "dinka\ dili"                 => 'din',
    "diqr\ hint\ dili"            => 'inc',
    "diveh\ dili"                 => 'dv',
    "doqri\ dili"                 => 'doi',
    "doqrib\ dili"                => 'dgr',
    "dravid\ dili"                => 'dra',
    "duala\ dili"                 => 'dua',
    "dyula\ dili"                 => 'dyu',
    "dzonqa\ dili"                => 'dz',
    "eastern\ frisian"            => 'frs',
    "een\ dili"                   => 'ce',
    "efik\ dili"                  => 'efi',
    "eitli\ diller"               => 'mis',
    "ekacuk\ dili"                => 'eka',
    "elamit\ dili"                => 'elx',
    'ermnic'                      => 'hy',
    "erzya\ dili"                 => 'myv',
    "esperanto\ dili"             => 'eo',
    'estonca'                     => 'et',
    "eve\ dili"                   => 'ee',
    "evondo\ dili"                => 'ewo',
    "ex\ dili"                    => 'cs',
    "eyen\ dili"                  => 'chy',
    "fang\ dili"                  => 'fan',
    "fanti\ dili"                 => 'fat',
    "farer\ dili"                 => 'fo',
    'farsca'                      => 'fa',
    "fiji\ dili"                  => 'fj',
    "filipin\ dili"               => 'phi',
    'finc'                        => 'fi',
    "finuri\ dili"                => 'fiu',
    "flem\ dili"                  => 'nl_be',
    "fon\ dili"                   => 'fon',
    "foyenik\ dili"               => 'phn',
    "fransz\ kreol\ dili"         => 'cpf',
    'franszca'                    => 'fr',
    "franszca\ ca"                => 'fr_ca',
    "frisk\ dili"                 => 'fy',
    "friul\ dili"                 => 'fur',
    "fula\ dili"                  => 'ff',
    'gota'                        => 'got',
    "grc\ dili"                   => 'ka',
    "gujarati\ dili"              => 'gu',
    "haiti\ dili"                 => 'ht',
    "hausa\ dili"                 => 'ha',
    "hayda\ dili"                 => 'hai',
    "herer\ dili"                 => 'hz',
    "hiliqaynon\ dili"            => 'hil',
    "himaali\ dili"               => 'him',
    "hindi\ dili"                 => 'hi',
    "hintyevropa\ dili"           => 'ine',
    "hiri\ motu\ dili"            => 'ho',
    "hittit\ dili"                => 'hit',
    'hollandca'                   => 'nl',
    "hupa\ dili"                  => 'hup',
    "iart\ dili"                  => 'sgn',
    "ib\ dili"                    => 'chb',
    "iban\ dili"                  => 'iba',
    'iberispanca'                 => 'es_es',
    "ico\ dili"                   => 'ijo',
    "ido\ dili"                   => 'io',
    "iloko\ dili"                 => 'ilo',
    "imal\ amerika\ yerli\ dili"  => 'nai',
    "imal\ fris\ dili"            => 'frr',
    "imal\ ndebele\ dili"         => 'nd',
    "imal\ sami\ dili"            => 'se',
    "imal\ soto\ dili"            => 'nso',
    "inari\ sami"                 => 'smn',
    'inc'                         => 'zh',
    "indoneziya\ dili"            => 'id',
    'ingilisc'                    => 'en',
    "ingilisc\ ab"                => 'en_us',
    "ingilisc\ au"                => 'en_au',
    "ingilisc\ ca"                => 'en_ca',
    "ingilisc\ gb"                => 'en_gb',
    "inglis\ kreol\ dili"         => 'cpe',
    "inqu\ dili"                  => 'inh',
    "interlingua\ dili"           => 'ia',
    "interlingue\ dili"           => 'ie',
    "inuk\ lhsi"                  => 'chn',
    "inuktikut\ dili"             => 'iu',
    "inupiaq\ dili"               => 'ik',
    "ipevyan\ dili"               => 'chp',
    "iqbo\ dili"                  => 'ig',
    'iranca'                      => 'ira',
    'irlandca'                    => 'ga',
    "iroki\ dili"                 => 'chr',
    "irokuay\ dili"               => 'iro',
    'islndc'                      => 'is',
    'ispanca'                     => 'es',
    "isve\ almanca"               => 'gsw',
    "isve\ franszca"              => 'fr_ch',
    "isve\ yksk\ almancas"        => 'de_ch',
    'isvec'                       => 'sv',
    'italyanca'                   => 'it',
    "ivrit\ dili"                 => 'sem',
    'ivritc'                      => 'he',
    "ju\ dili"                    => 'kaj',
    'juderbc'                     => 'jrb',
    'judofarsca'                  => 'jpr',
    "junq\ dili"                  => 'za',
    'kabardca'                    => 'kbd',
    "kabule\ dili"                => 'kab',
    "kado\ dili"                  => 'cad',
    'kainca'                      => 'kac',
    "kalalisut\ dili"             => 'kl',
    'kalmqca'                     => 'xal',
    "kamba\ dili"                 => 'kam',
    "kambodiya\ dili"             => 'km',
    "kannada\ dili"               => 'kn',
    "kanur\ dili"                 => 'kr',
    "karelyan\ dili"              => 'krl',
    "karen\ dili"                 => 'kar',
    "karib\ dili"                 => 'car',
    'katalanca'                   => 'ca',
    "kaubyan\ dili"               => 'csb',
    "kavi\ dili"                  => 'kaw',
    "kebuano\ dili"               => 'ceb',
    "kelt\ dili"                  => 'cel',
    "kikuyu\ dili"                => 'ki',
    "kils\ slav\ dili"            => 'cu',
    "kimbundu\ dili"              => 'kmb',
    "kinyarvanda\ dili"           => 'rw',
    'klinqon'                     => 'tlh',
    "kmir\ dili"                  => 'ks',
    "komi\ dili"                  => 'kv',
    "konkan\ dili"                => 'kok',
    "konqo\ dili"                 => 'kg',
    "kopt\ dili"                  => 'cop',
    "koreya\ dili"                => 'ko',
    "korni\ dili"                 => 'kw',
    "koro\ dili"                  => 'kfo',
    "korsikan\ dili"              => 'co',
    "kosreyan\ dili"              => 'kos',
    "kpelle\ dili"                => 'kpe',
    'krdc'                        => 'ku',
    "kreol\ dili"                 => 'crp',
    "kri\ dili"                   => 'cr',
    "krik\ dili"                  => 'mus',
    "krm\ trk"                    => 'crh',
    "kru\ dili"                   => 'kro',
    "kuanyama\ dili"              => 'kj',
    "kuechya\ dili"               => 'qu',
    "kuitik\ dili"                => 'cus',
    "kumuk\ dili"                 => 'kum',
    "kurux\ dili"                 => 'kru',
    "kutenay\ dili"               => 'kut',
    "ladin\ dili"                 => 'lad',
    "lamba\ dili"                 => 'lam',
    "laos\ dili"                  => 'lo',
    'latca'                       => 'lv',
    'latnca'                      => 'la',
    "laxnda\ dili"                => 'lah',
    "limburqi\ dili"              => 'li',
    "linqala\ dili"               => 'ln',
    "litva\ dili"                 => 'lt',
    "loban\ dili"                 => 'jbo',
    "lozi\ dili"                  => 'loz',
    "lubakatanqa\ dili"           => 'lu',
    "lubalulua\ dili"             => 'lua',
    "luksemburq\ dili"            => 'lb',
    "lule\ sami\ dili"            => 'smj',
    "lunda\ dili"                 => 'lun',
    "luo\ dili"                   => 'luo',
    'lushayca'                    => 'lus',
    "luyseno\ dili"               => 'lui',
    "lzqi\ dili"                  => 'lez',
    'macarca'                     => 'hu',
    "maduriz\ dili"               => 'mad',
    "maitili\ dili"               => 'mai',
    "makasar\ dili"               => 'mak',
    "makedoniya\ dili"            => 'mk',
    "malaqas\ dili"               => 'mg',
    'malayalamca'                 => 'ml',
    'malayca'                     => 'ms',
    "malta\ dili"                 => 'mt',
    "mandar\ dili"                => 'mdr',
    "manipri\ dili"               => 'mni',
    "manks\ dili"                 => 'gv',
    "manobo\ dili"                => 'mno',
    "manu\ dili"                  => 'mnc',
    "maori\ dili"                 => 'mi',
    "maqahi\ dili"                => 'mag',
    "maral\ dili"                 => 'mh',
    "marati\ dili"                => 'mr',
    "mari\ dili"                  => 'chm',
    "maruari\ dili"               => 'mwr',
    "masay\ dili"                 => 'mas',
    "maya\ dili"                  => 'myn',
    "mende\ dili"                 => 'men',
    "mikmak\ dili"                => 'mic',
    "minanqkaban\ dili"           => 'min',
    "mirand\ dili"                => 'mwl',
    "mndinqo\ dili"               => 'man',
    "moka\ dili"                  => 'mdf',
    'moldavca'                    => 'mo',
    "monq\ dili"                  => 'hmn',
    "monqo\ dili"                 => 'lol',
    'monqolca'                    => 'mn',
    "monxmer\ dili"               => 'mkh',
    'morisyen'                    => 'mfe',
    "mosi\ dili"                  => 'mos',
    "moxak\ dili"                 => 'moh',
    "mrkzi\ amerika\ indus\ dili" => 'cai',
    "munda\ dili"                 => 'mun',
    "nahuatl\ dili"               => 'nah',
    "nauru\ dili"                 => 'na',
    "navayo\ dili"                => 'nv',
    "neapolital\ dili"            => 'nap',
    'nepalca'                     => 'ne',
    "nevari\ dili"                => 'new',
    "nigerkordofyan\ dili"        => 'nic',
    "nilosahara\ dili"            => 'ssa',
    "niyasa\ tonga\ dili"         => 'tog',
    "niyoro\ dili"                => 'nyo',
    "niyuan\ dili"                => 'niu',
    "nizima\ dili"                => 'nzi',
    "no\ linguistic\ content"     => 'zxx',
    "noqay\ dili"                 => 'nog',
    "norve\ dili"                 => 'no',
    "norve\ ninorsk\ dili"        => 'nn',
    "norvec\ bokmal\ dili"        => 'nb',
    "nqo\ dili"                   => 'nqo',
    "nqonka\ dili"                => 'ng',
    "nubiy\ dili"                 => 'nub',
    "nyamvezi\ dili"              => 'nym',
    "nyanca\ dili"                => 'ny',
    "nyankol\ dili"               => 'nyn',
    "nyas\ dili"                  => 'nia',
    "ocibva\ dili"                => 'oj',
    'oksitanca'                   => 'oc',
    "oktau\ dili"                 => 'cho',
    "ona\ dili"                   => 'sn',
    "oriy\ dili"                  => 'or',
    "oromo\ dili"                 => 'om',
    "ortacaq\ franszca"           => 'frm',
    "ortacaq\ hollandca"          => 'dum',
    "ortacaq\ ingilisc"           => 'enm',
    "ortacaq\ irlandca"           => 'mga',
    "ortacaq\ yksk\ almanca"      => 'gmh',
    "osage\ dili"                 => 'osa',
    "osetik\ dili"                => 'os',
    "osman\ dili"                 => 'ota',
    "otomian\ dili"               => 'oto',
    'palayanca'                   => 'pau',
    "pali\ dili"                  => 'pi',
    "pampanqa\ dili"              => 'pam',
    "panqasinan\ dili"            => 'pag',
    "papua\ dili"                 => 'paa',
    "papyamento\ dili"            => 'pap',
    "paxlavi\ dili"               => 'pal',
    "polish\ dili"                => 'pl',
    "ponpeyan\ dili"              => 'pon',
    "portugal\ kreol\ dili"       => 'cpp',
    'portuqalca'                  => 'pt',
    "prakrit\ dili"               => 'pra',
    "puncab\ dili"                => 'pa',
    "putu\ dili"                  => 'ps',
    "qa\ dili"                    => 'gaa',
    "qabaya\ dili"                => 'gba',
    "qalisian\ dili"              => 'gl',
    "qanda\ dili"                 => 'lg',
    "qaraaybalkar\ dili"          => 'krc',
    "qaraqalpaq\ dili"            => 'kaa',
    'qavayca'                     => 'haw',
    "qavqaz\ dili"                => 'cau',
    "qayo\ dili"                  => 'gay',
    "qazax\ dili"                 => 'kk',
    "qdimi\ almanca"              => 'goh',
    "qdimi\ farsca"               => 'peo',
    "qdimi\ franszca"             => 'fro',
    "qdimi\ ingilisc"             => 'ang',
    "qdimi\ irlandca"             => 'sga',
    "qdimi\ misir\ dili"          => 'egy',
    "qdimi\ norsca"               => 'non',
    "qdimi\ provensialca"         => 'pro',
    "qdimi\ yunanca"              => 'grc',
    "qez\ dili"                   => 'gez',
    "qilbert\ gili"               => 'gil',
    "qondi\ dili"                 => 'gon',
    "qorontalo\ dili"             => 'gor',
    "qrebo\ dili"                 => 'grb',
    'qrzca'                       => 'ky',
    'quaranic'                    => 'gn',
    "qviin\ dili"                 => 'gwi',
    "racastan\ dili"              => 'raj',
    "rapanu\ dili"                => 'rap',
    "rarotonqan\ dili"            => 'rar',
    'rbc'                         => 'ar',
    'rhaetoromance'               => 'rm',
    "roman\ dili"                 => 'rom',
    "romance\ language"           => 'roa',
    'rumn'                        => 'ro',
    "rundi\ dili"                 => 'rn',
    'rusca'                       => 'ru',
    "salian\ dili"                => 'sal',
    "samaritan\ dili"             => 'sam',
    "samoa\ dili"                 => 'sm',
    "sandave\ dili"               => 'sad',
    "sanqo\ dili"                 => 'sg',
    "sanskrit\ dili"              => 'sa',
    "santal\ dili"                => 'sat',
    "sardin\ dili"                => 'sc',
    "sasak\ dili"                 => 'sas',
    "selkup\ dili"                => 'sel',
    "serb\ dili"                  => 'sr',
    'serbxorvatca'                => 'sh',
    "serer\ dilii"                => 'srr',
    "sesoto\ dili"                => 'st',
    "sidamo\ dili"                => 'sid',
    "siksik\ dili"                => 'bla',
    "simyan\ dili"                => 'tsi',
    "sindhi\ dili"                => 'sd',
    'sinhalisc'                   => 'si',
    "sinotibet\ dili"             => 'sit',
    "sioyan\ dili"                => 'sio',
    "siryak\ dili"                => 'syr',
    "sisili\ dili"                => 'scn',
    "siuan\ yi\ dili"             => 'ii',
    "skolt\ dili"                 => 'sms',
    "skot\ gaelik\ dili"          => 'gd',
    "skots\ dili"                 => 'sco',
    "slav\ dili"                  => 'sla',
    'slavey'                      => 'den',
    'slovakca'                    => 'sk',
    'slovenc'                     => 'sl',
    "smi\ dili"                   => 'smi',
    "somali\ dili"                => 'so',
    "soninke\ dili"               => 'snk',
    "sonqa\ dili"                 => 'ts',
    "sonqay\ dili"                => 'son',
    "soqdiyen\ dili"              => 'sog',
    "sorb\ dili"                  => 'wen',
    "sranan\ tonqo\ dili"         => 'srn',
    'suahilic'                    => 'sw',
    "sukuma\ dili"                => 'suk',
    "sumeryan\ dili"              => 'sux',
    'sundanca'                    => 'su',
    "suni\ dil"                   => 'art',
    "susu\ dili"                  => 'sus',
    "svana\ dili"                 => 'tn',
    "svati\ dili"                 => 'ss',
    "tacik\ dili"                 => 'tg',
    "tamaek\ dili"                => 'tmh',
    'tamilc'                      => 'ta',
    "taqaloq\ dili"               => 'tl',
    'taqaloqca'                   => 'fil',
    'taroko'                      => 'trv',
    'tatarca'                     => 'tt',
    "taxiti\ dili"                => 'ty',
    "tay\ dili"                   => 'tai',
    'tayca'                       => 'th',
    "teluqu\ dili"                => 'te',
    "tereno\ dili"                => 'ter',
    "tetum\ dili"                 => 'tet',
    "tibet\ dili"                 => 'bo',
    "timne\ dili"                 => 'tem',
    "tiqre\ dili"                 => 'tig',
    "tiqrin\ dili"                => 'ti',
    "tiv\ dili"                   => 'tiv',
    "tiyap\ dili"                 => 'kcg',
    "tlinqit\ dili"               => 'tli',
    "tok\ pisin\ dili"            => 'tpi',
    "tokelay\ dili"               => 'tkl',
    "tonqa\ dili"                 => 'to',
    'trkc'                        => 'tr',
    'trkmnc'                      => 'tk',
    "tumbuka\ dili"               => 'tum',
    "tupi\ dili"                  => 'tup',
    "tuvalu\ dili"                => 'tvl',
    "tuvinyan\ dili"              => 'tyv',
    "tvi\ dili"                   => 'tw',
    "udmurt\ dili"                => 'udm',
    'uelsc'                       => 'cy',
    "ukiz\ dili"                  => 'chk',
    'ukraynaca'                   => 'uk',
    "umbundu\ dili"               => 'umb',
    "uqaritik\ dili"              => 'uga',
    'urduca'                      => 'ur',
    "uva\ dili"                   => 'cv',
    'uyurca'                      => 'ug',
    "vakaan\ dili"                => 'wak',
    "valamo\ dili"                => 'wal',
    "valun\ dili"                 => 'wa',
    "vao\ dili"                   => 'was',
    "varay\ dili"                 => 'war',
    "vay\ dili"                   => 'vai',
    "venda\ dili"                 => 've',
    "volapk\ dili"                => 'vo',
    "volof\ dili"                 => 'wo',
    "votik\ dili"                 => 'vot',
    'vyetnamca'                   => 'vi',
    "xazi\ dili"                  => 'kha',
    'xorvatca'                    => 'hr',
    "xosa\ dili"                  => 'xh',
    "xotan\ dili"                 => 'kho',
    "xoyzan\ dili"                => 'khi',
    "yahudi\ dili"                => 'yi',
    "yakut\ dili"                 => 'sah',
    "yao\ dili"                   => 'yao',
    "yapiz\ dili"                 => 'yap',
    'yaponca'                     => 'ja',
    "yavaca\ dili"                => 'jv',
    "yoruba\ dili"                => 'yo',
    'yunanca'                     => 'el',
    "yupik\ dili"                 => 'ypk',
    "yuxar\ sorbca"               => 'hsb',
    "zande\ dili"                 => 'znd',
    "zapotek\ dili"               => 'zap',
    "zaza\ dili"                  => 'zza',
    'zbkc'                        => 'uz',
    "zenaqa\ dili"                => 'zen',
    "zulu\ dili"                  => 'zu',
    "zuni\ dili"                  => 'zun',
);

1;
