/*
 * This file was generated automatically by ExtUtils::ParseXS version 2.2206 from the
 * contents of geohash.xs. Do not edit this file, edit geohash.xs instead.
 *
 *	ANY CHANGES MADE HERE WILL BE LOST! 
 *
 */

#line 1 "XS/geohash.xs"
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

char PIECES[32] = {
    '0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
    'b', 'c', 'd', 'e', 'f', 'g', 'h', 'j', 'k', 'm',
    'n', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z',
};

void
encode(char *buf, STRLEN precision, NV lat, NV lon) {
    IV which = 0;
    STRLEN count = 0;
    NV 
        lat_min = -90,
        lat_max = 90,
        lon_min = -180,
        lon_max = 180
    ;

    while ( count < precision ) {
        IV i;
        IV bits = 0;
        for( i = 0; i < 5; i++ ) {
            IV bit;
            if (which) {
                NV mid = (lat_max + lat_min) / 2;
                bit = lat >= mid ? 1 : 0;
                if ( bit ) { lat_min = mid; }
                else       { lat_max = mid; }
            } else {
                NV mid = (lon_max + lon_min) / 2;
                bit = lon >= mid ? 1 : 0;
                if ( bit ) { lon_min = mid; }
                else       { lon_max = mid; }
            }
            bits = ( ( bits << 1 ) | bit );
            which ^= 1;
        }

        buf[count] = PIECES[bits];
        count++;
    }


    buf[count] = '\0';
}

void
decode(char *hash, STRLEN len, NV *lat, NV *lon) {
    STRLEN i, j;
    IV which = 0, min_or_max;
    NV 
        lat_min = -90,
        lat_max = 90,
        lon_min = -180,
        lon_max = 180
    ;
    for (i = 0; i < len; i++ ) {
        IV bits;
        int x = (int) hash[i];
        if (x >= 48 && x <= 57) {
            bits = x - 48;
        } else if ( x >= 98 && x <= 104 ) {
            bits = x - 88;
        } else if ( x >= 106 && x <= 107 ) {
            bits = x - 89;
        } else if ( x >= 109 && x <= 110 ) {
            bits = x - 90;
        } else if ( x >= 112 && x <= 122 ) {
            bits = x - 91;
        } else {
            croak("Bad character '%c' in hash '%s'", hash[i], hash);
        }

        for (j = 0; j < 5; j++){ 
            min_or_max = ( bits & 16 ) >> 4;
            if (which) {
                NV mid = (lat_max + lat_min ) / 2;
                if (min_or_max) { /* max */
                    lat_min = mid;
                } else {
                    lat_max = mid;
                }
            } else {
                NV mid = (lon_max + lon_min ) / 2;
                if (min_or_max) { /* max */
                    lon_min = mid;
                } else {
                    lon_max = mid;
                }
            }

            which ^= 1;
            bits <<= 1;
        }
    }

    *lat = (lat_max + lat_min) / 2;
    *lon = (lon_max + lon_min) / 2;
}

char* NEIGHBORS[4][2] = {
    { "bc01fg45238967deuvhjyznpkmstqrwx", "p0r21436x8zb9dcf5h7kjnmqesgutwvy" },
    { "238967debc01fg45kmstqrwxuvhjyznp", "14365h7k9dcfesgujnmqp0r2twvyx8zb" },
    { "p0r21436x8zb9dcf5h7kjnmqesgutwvy", "bc01fg45238967deuvhjyznpkmstqrwx" },
    { "14365h7k9dcfesgujnmqp0r2twvyx8zb", "238967debc01fg45kmstqrwxuvhjyznp" }
};

char* BORDERS[4][2] = {
    { "bcfguvyz", "prxz" },
    { "0145hjnp", "028b" },
    { "prxz", "bcfguvyz" },
    { "028b", "0145hjnp" }
};

STRLEN
precision(STRLEN lat, STRLEN lon) {
    IV lab;
    IV lob;
    lab = (int) ( (lat * 3.32192809488736 + 1) + 8 );
    lob = (int) ( (lon * 3.32192809488736 + 1) + 9 );
    return (int) ( ( ( lab > lob ? lab : lob ) + 1 ) / 2.5 );
}

enum GH_DIRECTION {
    RIGHT = 0,
    LEFT = 1,
    TOP = 2,
    BOTTOM = 3
};

/* need to free this return value! */
#define HASHBASE_BUFSIZ 8192
char *
adjacent(char *hash, STRLEN hashlen, enum GH_DIRECTION direction) {
    char base[HASHBASE_BUFSIZ];
    char last_ch = hash[ hashlen - 1 ];
    char *pos, *ret;
    IV type = hashlen % 2;
    IV base_len;

    if (hashlen < 1)
        croak("PANIC: hash too short!");
    if (hashlen > HASHBASE_BUFSIZ)
        croak("PANIC: hash too big!");

    memcpy(base, hash, hashlen - 1);
    *(base + hashlen - 1) = '\0';

    pos = strchr(BORDERS[direction][type], last_ch);
    if (pos != NULL) {
        char *tmp = adjacent(base, strlen(base), direction);
        strcpy(base, tmp);
        Safefree(tmp);
    }
    base_len = strlen(base);
    Newxz( ret, base_len + 2, char );
    strcpy( ret, base );
    ret[ base_len ] = PIECES[ strchr(NEIGHBORS[direction][type], last_ch) - NEIGHBORS[direction][type] ]; 
    *(ret + base_len + 1) = '\0';
    return ret;
}

void
neighbors(char *hash, STRLEN hashlen, int around, int offset, char ***neighbors, int *nsize) {
    char *xhash;
    STRLEN xhashlen = hashlen;
    int i = 1;

    Newxz( xhash, hashlen, char );
    Copy( hash, xhash, hashlen, char );

    while ( offset > 0 ) {
        char *top = adjacent( xhash, xhashlen, TOP );
        char *left = adjacent( top, strlen(top) + 1, LEFT );
        Safefree(xhash);
        Safefree(top);
        xhash = left;
        xhashlen = strlen(xhash);

        offset--;
        i++;
    }

    {
    int n = 0;
    *nsize = 0;
    Newxz( *neighbors, around, char *);
    while (around-- > 0) {
        int j;
        int m = 0;

        /* going to insert this many neighbors */
        Renew( neighbors[n], 8 * i, char *);

        xhash = neighbors[n][m++] = adjacent(xhash, xhashlen, TOP);
        for ( j = 0; j < 2 * i - 1; j ++ ) {
            xhash = neighbors[n][m++] = adjacent(xhash, xhashlen, RIGHT);
        }
        for ( j = 0; j < 2 * i; j ++ ) {
            xhash = neighbors[n][m++] = adjacent(xhash, xhashlen, BOTTOM);
        }
        for ( j = 0; j < 2 * i; j ++ ) {
            xhash = neighbors[n][m++] = adjacent(xhash, xhashlen, LEFT);
        }
        for ( j = 0; j < 2 * i; j ++ ) {
            xhash = neighbors[n][m++] = adjacent(xhash, xhashlen, TOP);
        }
        i++;
        n++;
        *nsize += m;
    }
    }
}

#line 228 "XS/geohash.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(pTHX_ const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(pTHX_ const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
            Perl_croak(aTHX_ "Usage: %s::%s(%s)", hvname, gvname, params);
        else
            Perl_croak(aTHX_ "Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
        Perl_croak(aTHX_ "Usage: CODE(0x%"UVxf")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#ifdef PERL_IMPLICIT_CONTEXT
#define croak_xs_usage(a,b)	S_croak_xs_usage(aTHX_ a,b)
#else
#define croak_xs_usage		S_croak_xs_usage
#endif

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#line 280 "XS/geohash.c"

XS(XS_Geo__Hash__XS_encode); /* prototype to pass -Wmissing-prototypes */
XS(XS_Geo__Hash__XS_encode)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 3 || items > 4)
       croak_xs_usage(cv,  "self, lat, lon, p = 32");
    {
	SV *	self = ST(0);
	SV *	lat = ST(1);
	SV *	lon = ST(2);
	IV	p;
	char *	RETVAL;
	dXSTARG;

	if (items < 4)
	    p = 32;
	else {
	    p = (IV)SvIV(ST(3));
	}
#line 229 "XS/geohash.xs"
        /*
        if (p <= 0) {
            p = precision( SvLEN(lat), SvLEN(lon) );
        }
        */
        PERL_UNUSED_VAR(self);

        Newxz(RETVAL, p + 1, char);
        encode(RETVAL, p, SvNV(lat), SvNV(lon));
#line 315 "XS/geohash.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS(XS_Geo__Hash__XS_decode); /* prototype to pass -Wmissing-prototypes */
XS(XS_Geo__Hash__XS_decode)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "self, hash");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	self = ST(0);
	char *	hash = (char *)SvPV_nolen(ST(1));
#line 246 "XS/geohash.xs"
        NV lat = 0, lon = 0;
        STRLEN len = strlen(hash);
#line 340 "XS/geohash.c"
#line 249 "XS/geohash.xs"
        PERL_UNUSED_VAR(self);
        decode(hash, len, &lat, &lon);
        mXPUSHn(lat);
        mXPUSHn(lon);
#line 346 "XS/geohash.c"
	PUTBACK;
	return;
    }
}


XS(XS_Geo__Hash__XS_adjacent); /* prototype to pass -Wmissing-prototypes */
XS(XS_Geo__Hash__XS_adjacent)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "self, hash, direction");
    {
	SV *	self = ST(0);
	char *	hash = (char *)SvPV_nolen(ST(1));
	int	direction = (int)SvIV(ST(2));
	char *	RETVAL;
	dXSTARG;
#line 260 "XS/geohash.xs"
        PERL_UNUSED_VAR(self);
        RETVAL = adjacent(hash, strlen(hash), direction);
#line 372 "XS/geohash.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS(XS_Geo__Hash__XS_neighbors); /* prototype to pass -Wmissing-prototypes */
XS(XS_Geo__Hash__XS_neighbors)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 2 || items > 4)
       croak_xs_usage(cv,  "self, hash, around = 1, offset = 0");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	self = ST(0);
	char *	hash = (char *)SvPV_nolen(ST(1));
	int	around;
	int	offset;
#line 272 "XS/geohash.xs"
        int i;
        int nsize;
        char **list;
#line 400 "XS/geohash.c"

	if (items < 3)
	    around = 1;
	else {
	    around = (int)SvIV(ST(2));
	}

	if (items < 4)
	    offset = 0;
	else {
	    offset = (int)SvIV(ST(3));
	}
#line 276 "XS/geohash.xs"
        PERL_UNUSED_VAR(self);
        neighbors(hash, strlen(hash), around, offset, &list, &nsize);

        for( i = 0; i < nsize; i++ ) {
            mXPUSHp( list[i], strlen(list[i]) );
        }
        for( i = 0; i < nsize; i++ ) {
            Safefree(list[i]);
        }
        Safefree(list);
#line 424 "XS/geohash.c"
	PUTBACK;
	return;
    }
}

#ifdef __cplusplus
extern "C"
#endif
XS(boot_Geo__Hash__XS); /* prototype to pass -Wmissing-prototypes */
XS(boot_Geo__Hash__XS)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
#if (PERL_REVISION == 5 && PERL_VERSION < 9)
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    XS_VERSION_BOOTCHECK ;

        newXS("Geo::Hash::XS::encode", XS_Geo__Hash__XS_encode, file);
        newXS("Geo::Hash::XS::decode", XS_Geo__Hash__XS_decode, file);
        newXS("Geo::Hash::XS::adjacent", XS_Geo__Hash__XS_adjacent, file);
        newXS("Geo::Hash::XS::neighbors", XS_Geo__Hash__XS_neighbors, file);
#if (PERL_REVISION == 5 && PERL_VERSION >= 9)
  if (PL_unitcheckav)
       call_list(PL_scopestack_ix, PL_unitcheckav);
#endif
    XSRETURN_YES;
}

