package Business::BR::CNJ::Classes;

use strict;
use utf8;
use Exporter 'import';

our $VERSION = 0.01;
our @EXPORT_OK = qw/ cnj_classe /;


sub cnj_classe {
 return $Business::BR::CNJ::Classes::map->{ $_[0] };
}

$Business::BR::CNJ::Classes::map = {
 'AACC'  =>      'Ação Anulatória de Cláusulas Convencionais',
 'AAlim' =>      'Ação de Alimentos',
 'AC'    =>      'Ação Cautelar',
 'ACC'   =>      'Ação Civil Coletiva',
 'ACi'   =>      'Apelação Cível',
 'ACIA'  =>      'Ação Civil de Improbidade Administrativa',
 'ACO'   =>      'Ação Civil Originária',
 'ACP'   =>      'Ação Civil Pública',
 'ACP'   =>      'Ação Civil Pública',
 'ACr'   =>      'Apelação Criminal',
 'ACum'  =>      'Ação de Cumprimento',
 'ADC'   =>      'Declaratória de Constitucionalidade',
 'ADC'   =>      'Ação Declaratória de Constitucionalidade',
 'ADCVRD'        =>      'Apreensão e Depósito de Coisa Vendida com Reserva de Domínio',
 'ADepos'        =>      'Depósito da Lei 8. 866/94',
 'ADI'   =>      'Direta de Inconstitucionalidade',
 'ADI'   =>      'Ação Direta de Inconstitucionalidade',
 'Adocao'        =>      'Adoção',
 'AdoDPF'        =>      'Adoção c/c Destituição do Poder Familiar',
 'ADPF'  =>      'Arguição de Descumprimento de Preceito Fundamental',
 'Advert'        =>      'Advertência ',
 'AE'    =>      'Apuração de Eleição',
 'Ag'    =>      'Agravo',
 'Ag'    =>      'Agravo',
 'AgExPe'        =>      'Agravo de Execução Penal',
 'AgR'   =>      'Agravo Regimental',
 'AgR'   =>      'Agravo Regimental',
 'AG/RE' =>      'Agravo de Instrumento em Recurso Extraordinário',
 'AG/RHC'        =>      'Agravo de Instrumento em Recurso de Habeas Corpus',
 'AG/RMS'        =>      'Agravo de Instrumento em Recurso de Mandado de Segurança',
 'AI'    =>      'Agravo de Instrumento',
 'AI'    =>      'Agravo de Instrumento',
 'AIA'   =>      'Ação de Improbidade Administrativa',
 'AIANPCA'       =>      'Apuração de Infração Administrativa às Normas de Proteção à Criança ou Adolescente',
 'AIAP'  =>      'Agravo de Instrumento em Agravo de Petição',
 'AIEA'  =>      'Apuração de Irregularidades em Entidades de Atendimento',
 'AIJE'  =>      'Ação de Investigação Judicial Eleitoral',
 'AIME'  =>      'Ação de Impugnação de Mandato Eletivo',
 'AIRE'  =>      'Agravo de Instrumento em Recurso Extraordinário',
 'AIRE'  =>      'Agravo de Instrumento em Recurso Especial',
 'AIROSTF'       =>      'Agravo de Instrumento em Recurso Ordinário para o STF',
 'AIRR'  =>      'Agravo de Instrumento em Recurso de Revista',
 'AlEsp' =>      'Alimentos - Lei Especial Nº 5.478/68',
 'AlienBAc'      =>      'Alienação de Bens do Acusado',
 'AliPro'        =>      'Alimentos - Provisionais',
 'AlJuBe'        =>      'Alienação Judicial de Bens',
 'AlReBe'        =>      'Alteração do Regime de Bens',
 'Alvará'        =>      'Alvará Judicial',
 'AlvJud'        =>      'Alvará Judicial - Lei 6858/80',
 'Anisti'        =>      'Anistia',
 'AO'    =>      'Ação Originária',
 'AOE'   =>      'Ação Originária Especial',
 'AOR'   =>      'Ação Ordinária Regressiva',
 'AP'    =>      'Ação Penal Eleitoral',
 'ApMS'  =>      'Apelação em Mandado de Segurança',
 'Apn'   =>      'Ação Penal Militar - Procedimento Ordinário',
 'APN'   =>      'Ação Penal',
 'APN'   =>      'Ação Penal - Procedimento Ordinário',
 'APN'   =>      'Ação Penal',
 'APop'  =>      'Ação Popular',
 'AprEmb'        =>      'Apreensão de Embarcações',
 'AprTit'        =>      'Apreensão de  Títulos',
 'AR'    =>      'Ação Rescisória',
 'AR'    =>      'Ação Rescisória',
 'AR'    =>      'Ação Rescisória',
 'ArCoVa'        =>      'Arrecadação das Coisas Vagas',
 'ARCT'  =>      'Abertura, Registro e Cumprimento de Testamento',
 'ARg'   =>      'Ação Regressiva',
 'ArgInc'        =>      'Incidente de Arguição de Inconstitucionalidade',
 'ArgInc'        =>      'Incidente De Arguição de Inconstitucionalidade',
 'ArrBen'        =>      'Arrolamento de Bens',
 'ArrCom'        =>      'Arrolamento Comum',
 'Arrest'        =>      'Arresto ',
 'ArrFor'        =>      'Arribadas Forçadas',
 'ArrSum'        =>      'Arrolamento Sumário',
 'ARv'   =>      'Arguição de Relevância',
 'AS'    =>      'Arguição de Suspeição',
 'AssJud'        =>      'Assistência Judiciária',
 'AssJudCrim'    =>      'Assistência Judiciária',
 'ASTP'  =>      'Anulação e Substituição de Títulos ao Portador',
 'Atent' =>      'Atentado',
 'Ato'   =>      'Ato Normativo',
 'AuApFl'        =>      'Auto de Apreensão em Flagrante',
 'AuPrFl'        =>      'Auto de Prisão em Flagrante',
 'AvalDep'       =>      'Avaliação para atestar dependência de drogas',
 'Avaria'        =>      'Avarias',
 'AvePat'        =>      'Averiguação de Paternidade',
 'BAAF'  =>      'Busca e Apreensão em Alienação Fiduciária',
 'BoOcCi'        =>      'Boletim de Ocorrência Circunstanciada',
 'BusApr'        =>      'Busca e Apreensão',
 'BusApr'        =>      'Busca e Apreensão',
 'CA'    =>      'Conflito de Atribuições',
 'CA'    =>      'Conflito de atribuição',
 'CanNat'        =>      'Cancelamento de Naturalização',
 'Cartas'        =>      'Cartas',
 'Cartas'        =>      'Cartas',
 'Cartas'        =>      'Cartas',
 'CartOrd'       =>      'Carta de Ordem Criminal',
 'CartOrd'       =>      'Carta de Ordem Infância e Juventude',
 'CartOrd'       =>      'Carta de Ordem Cível',
 'CartOrd'       =>      'Carta de Ordem Infracional',
 'CartPrec'      =>      'Carta Precatória Infância e Juventude',
 'CartPrec'      =>      'Carta Precatória Criminal',
 'CartPrec'      =>      'Carta Precatória Cível',
 'CartPrec'      =>      'Carta Precatória Infracional',
 'CartRog'       =>      'Carta Rogatória Criminal',
 'CAt'   =>      'Conflito de Atribuição',
 'Cauçao'        =>      'Caução',
 'CauFis'        =>      'Cautelar Fiscal',
 'CauIno'        =>      'Cautelar Inominada',
 'CauInom'       =>      'Cautelar Inominada',
 'CauInomCrim'   =>      'Cautelar Inominada Criminal',
 'CC'    =>      'Conflito de Competência',
 'CC'    =>      'Conflito de Competência',
 'CC'    =>      'Conflito de Competência',
 'CC'    =>      'Conflito de Competência',
 'CC'    =>      'Conflito de competência',
 'CCCI'  =>      'Cobrança de Cédula de Crédito Industrial',
 'CCIDCJS'       =>      'Crimes de Calúnia, Injúria e Difamação de Competência do Juiz Singular',
 'CCPI'  =>      'Crimes Contra a Propriedade Industrial',
 'CCPI'  =>      'Crimes Contra a Propriedade Intelectual',
 'CCPI'  =>      'Crimes Contra a Propriedade Imaterial',
 'CJ'    =>      'Conflito de Jurisdição',
 'CJ'    =>      'Conflito de Jurisdição',
 'Cm'    =>      'Comunicação',
 'Cm'    =>      'Comunicação',
 'CoiJul'        =>      'Exceção de Coisa Julgada',
 'Com'   =>      'Comunicação',
 'ComArb'        =>      'Compromisso Arbitral',
 'Comissão'      =>      'Procedimento de Competência de Comissão',
 'ComPen'        =>      'Comutação de Pena',
 'ConAlu'        =>      'Consignatória de Aluguéis',
 'ConPag'        =>      'Consignação em Pagamento',
 'Cons'  =>      'Consulta',
 'ConTes'        =>      'Confirmação de Testamento',
 'CONTFORODIV'   =>      'Contestação em Foro Diverso',
 'Conver'        =>      'Conversão de Pena',
 'Cor'   =>      'Correição',
 'CorExt'        =>      'Correição Extraordinária',
 'CorOrd'        =>      'Correição Ordinária',
 'CorPar'        =>      'Correição Parcial',
 'CorPar'        =>      'Correição Parcial ou Reclamação Correicional',
 'CProt' =>      'Contraprotesto Judicial',
 'CR'    =>      'Carta Rogatória',
 'CR'    =>      'Carta Rogatória',
 'CRFP'  =>      'Crimes de Responsabilidade dos Funcionários Públicos',
 'CriAmb'        =>      'Crimes Ambientais',
 'CriImp'        =>      'Crimes de Imprensa',
 'CRPP'  =>      'Cancelamento de Registro de Partido Político',
 'CSJD'  =>      'Conversão de Separação Judicial em Divórcio',
 'CT'    =>      'Carta Testemunhável',
 'CT'    =>      'Carta Testemunhável',
 'Cta'   =>      'Consulta',
 'Cumprdec'      =>      'Acompanhamento de Cumprimento de Decisão',
 'CuPrSe'        =>      'Cumprimento Provisório de Sentença',
 'CZER'  =>      'Criação de Zona Eleitoral ou Remanejamento',
 'DC'    =>      'Dissídio Coletivo',
 'DCG'   =>      'Dissídio Coletivo de Greve',
 'DecAus'        =>      'Declaração de Ausência',
 'DeFaPa'        =>      'Despejo por Falta de Pagamento',
 'DemDiv'        =>      'Demarcação / Divisão',
 'Den'   =>      'Denúncia',
 'Deposi'        =>      'Depósito',
 'Desapr'        =>      'Desapropriação',
 'DesJul'        =>      'Desaforamento de Julgamento',
 'Despej'        =>      'Despejo',
 'DFPCC' =>      'Despejo por Falta de Pagamento Cumulado Com Cobrança',
 'DiLiSo'        =>      'Dissolução e Liquidação de Sociedade',
 'DIRIS' =>      'Desapropriação Imóvel Rural por Interesse Social',
 'Discri'        =>      'Discriminatória',
 'DissParcSocied'        =>      'Dissolução Parcial de Sociedade',
 'DivCon'        =>      'Divórcio Consensual',
 'DivLit'        =>      'Divórcio Litigioso',
 'Duvida'        =>      'Dúvida',
 'E'     =>      'Embargos',
 'EAdj'  =>      'Embargos à Adjudicação',
 'EARESP'        =>      'Embargos de Divergência em Agravo em Recurso Especial',
 'EArr'  =>      'Embargos à Arrematação',
 'ECFP'  =>      'Execução Contra a Fazenda Pública',
 'ECFP'  =>      'Processo de Execução Trabalhista',
 'ED'    =>      'Embargos de Declaração',
 'ED'    =>      'Embargos de Declaração',
 'EE'    =>      'Embargos à Execução',
 'EEFis' =>      'Embargos à Execução Fiscal',
 'EI'    =>      'Embargos Infringentes',
 'EI'    =>      'Embargos Infringentes',
 'EIfNu' =>      'Embargos Infringentes e de Nulidade',
 'Emanci'        =>      'Emancipação',
 'EmbAc' =>      'Embargos do Acusado',
 'EmbExecMC'     =>      'Embargos à Execução em Medida Cautelar',
 'EmbExeMS'      =>      'Embargos à Execução em Mandado de Segurança',
 'EmbExeXAr'     =>      'Embargos à Execução em Ação Recisoria',
 'EmReBe'        =>      'Embargos de Retenção por Benfeitorias',
 'ER'    =>      'Embargos Remetidos',
 'ES'    =>      'Exceção de Suspeição',
 'ES'    =>      'Efeito Suspensivo',
 'EsHiLe'        =>      'Especialização de Hipoteca Legal',
 'ET'    =>      'Embargos de Terceiro',
 'ET'    =>      'Embargos de Terceiro',
 'EV'    =>      'Exceção da Verdade',
 'ExCCJ' =>      'Execução de Certidão de Crédito Judicial',
 'ExCCP' =>      'Execução de Termo de Conciliação de CCP',
 'ExcDes'        =>      'Excesso ou Desvio',
 'Exceco'        =>      'Exceções',
 'ExcImp'        =>      'Exceção de Impedimento',
 'ExcInc'        =>      'Exceção de Incompetência',
 'ExCr'  =>      'Execução da Pena',
 'ExcSusp'       =>      'Exceção de Suspeição',
 'ExDoCo'        =>      'Exibição de Documento ou Coisa',
 'ExDoCoCrim'    =>      'Exibição de Documento ou Coisa ',
 'ExeAli'        =>      'Execução de Alimentos',
 'ExeAli'        =>      'Execução de Alimentos',
 'ExeCri'        =>      'Execução Criminal',
 'ExeMul'        =>      'Execução de Multa',
 'ExeSE' =>      'Execução em Sentença Estrangeira',
 'ExeSEC'        =>      'Execução em Sentença Estrangeira Contestada',
 'ExFis' =>      'Execução Fiscal',
 'ExHipSFH'      =>      'Execução Hipotecária do Sistema Financeiro da Habitação',
 'Exibic'        =>      'Exibição',
 'ExImp' =>      'Exceção de Impedimento',
 'ExMeSo'        =>      'Execução de Medidas Sócio-Educativas',
 'Exprop'        =>      'Expropriação da Lei 8.257/91',
 'ExProvAS'      =>      'Execução Provisória em Autos Suplementares',
 'Expuls'        =>      'Pedido de Prisão/ Liberdade Vigiada para Fins de Expulsão',
 'ExSusp'        =>      'Exceção de Suspeição',
 'ExTAC' =>      'Execução de Termo de Ajuste de Conduta',
 'ExTiEx'        =>      'Execução de Título Extrajudicial',
 'ExTiEx'        =>      'Execução de Título Extrajudicial',
 'ExTiEx'        =>      'Execução de Título Extrajudicial',
 'ExTiJu'        =>      'Execução de Título Judicial',
 'Extrad'        =>      'Extradição',
 'ExVerd'        =>      'Exceção da Verdade',
 'Falsid'        =>      'Incidente de Falsidade',
 'FESEMEPP'      =>      'Falência de Empresários, Sociedades Empresáriais, Microempresas e Empresas de Pequeno Porte',
 'Guarda'        =>      'Guarda',
 'HabCas'        =>      'Habilitação para Casamento',
 'HabCre'        =>      'Habilitação de Crédito',
 'Habili'        =>      'Habilitação',
 'HC'    =>      'Habeas Corpus',
 'HC'    =>      'Habeas Corpus',
 'HC'    =>      'Habeas Corpus',
 'HC'    =>      'Habeas Corpus',
 'HD'    =>      'Habeas Data',
 'HD'    =>      'Habeas Data',
 'HD'    =>      'Habeas Data',
 'HerJac'        =>      'Herança Jacente',
 'HipLeg'        =>      'Arresto / Hipoteca Legal',
 'HomPen'        =>      'Homologação do Penhor Legal',
 'HoTrEx'        =>      'Homologação de Transação Extrajudicial',
 'IA'    =>      'Inquérito Administrativo',
 'IAC'   =>      'Incidente de Assunção de Competência',
 'IAFG'  =>      'Inquérito para Apuração de Falta Grave',
 'IDC'   =>      'Incidente de Deslocamento de Competência ',
 'IF'    =>      'Intervenção Federal',
 'IF'    =>      'Intervenção Federal',
 'IJ'    =>      'Interpelação Judicial',
 'IlePar'        =>      'Exceção de Ilegitimidade de Parte',
 'ImCuSe'        =>      'Impugnação ao Cumprimento de Sentença',
 'ImiPos'        =>      'Imissão na Posse',
 'ImpCre'        =>      'Impugnação de Crédito',
 'Impedi'        =>      'Exceção de Impedimento',
 'InAtEx'        =>      'Internação sem Atividades Externas',
 'InAtEx'        =>      'Internação com Atividades Externas',
 'IncFal'        =>      'Incidente de Falsidade',
 'IncJui'        =>      'Exceção de Incompetência de Juízo',
 'IncResDemRept' =>      'Incidente de Resolução de Demandas Repetitivas',
 'IncTra'        =>      'Incidentes Trabalhistas',
 'Indult'        =>      'Indulto',
 'Inq'   =>      'Inquérito',
 'InqExt'        =>      'Inquérito Extrajudicial',
 'Inquer'        =>      'Procedimentos Investigatórios',
 'InsanAc'       =>      'Insanidade Mental do Acusado',
 'InsCiv'        =>      'Insolvência Civil',
 'Insp'  =>      'Inspeção',
 'Inst'  =>      'Instrução',
 'InstProvIns'   =>      'Instrução Provisória de Insubmissão',
 'Int'   =>      'Interpelação',
 'Inter' =>      'Interpelação',
 'Interd'        =>      'Interdição',
 'Interdito'     =>      'Interdito Proibitório',
 'Interp'        =>      'Interpelações',
 'IntMun'        =>      'Intervenção em Município',
 'Invent'        =>      'Inventário',
 'IP'    =>      'Inquérito Policial',
 'IP'    =>      'Inquérito Policial',
 'IPALS' =>      'Impugnação ao Pedido de Assistência Litisconsorcial ou Simples',
 'IPE'   =>      'Inquérito Policial Especial',
 'IPM'   =>      'Inquérito Policial Militar',
 'IRPC'  =>      'Insolvência Requerida pelo Credor',
 'IRPDPE'        =>      'Insolvência Requerida pelo Devedor ou pelo Espólio',
 'IUJ'   =>      'Incidente de Uniformização de Jurisprudência',
 'IUJ'   =>      'Incidente de Uniformização de Jurisprudência',
 'IVC'   =>      'Impugnação ao Valor da Causa',
 'IVCCrim'       =>      'Impugnação ao Valor da Causa',
 'JuDiRi'        =>      'Justificação de Dinheiro a Risco',
 'Juri'  =>      'Ação Penal de Competência do Júri',
 'JustCrim'      =>      'Justificação Criminal',
 'Justif'        =>      'Justificação',
 'LibAss'        =>      'Liberdade Assistida',
 'Liberd'        =>      'Liberdade',
 'LiPrAr'        =>      'Liquidação Provisória por Arbitramento',
 'LiPrAr'        =>      'Liquidação Provisória de Sentença pelo Procedimento Comum',
 'LiqArb'        =>      'Liquidação por Arbitramento',
 'LiqArt'        =>      'Liquidação de Sentença pelo Procedimento Comum',
 'LiqPvSenProcComum'     =>      'Liquidação Provisória de Sentença pelo Procedimento Comum',
 'Litisp'        =>      'Exceção de Litispendência',
 'LS'    =>      'Liquidação de Sentença',
 'LT'    =>      'Lista Tríplice',
 'MC'    =>      'Medida Cautelar',
 'MC'    =>      'Medida Cautelar',
 'MedAss'        =>      'Medidas Assecuratórias',
 'MedCau'        =>      'Medidas Cautelares',
 'MedGar'        =>      'Medidas Garantidoras',
 'MedPre'        =>      'Medidas Preparatórias',
 'MI'    =>      'Mandado de Injunção',
 'MI'    =>      'Mandado de Injunção',
 'MI'    =>      'Mandado de Injunção',
 'MISOC' =>      'Medidas Investigatórias Sobre Organizações Criminosas',
 'Monito'        =>      'Monitória',
 'MPCA'  =>      'Medidas de Proteção à Criança e Adolescente',
 'MPCA'  =>      'Procedimento de Cumprimento de Sentença/Decisão',
 'MPUMP' =>      'Medidas Protetivas de urgência (Lei Maria da Penha)',
 'MS'    =>      'Mandado de Segurança',
 'MS'    =>      'Mandado de Segurança',
 'MS'    =>      'Mandado de Segurança',
 'MS'    =>      'Mandado de Segurança',
 'MSCol' =>      'Mandado de Segurança Coletivo',
 'Natura'        =>      'Naturalização',
 'NoImpr'        =>      'Notificação para Explicações (Lei de Imprensa)',
 'Not'   =>      'Notificação',
 'NotExp'        =>      'Notificação para Explicações',
 'Notici'        =>      'Notícia-Crime',
 'Notif' =>      'Notificação',
 'NTec'  =>      'Nota Técnica',
 'NunciObr'      =>      'Nunciação de Obra Nova',
 'ObReDa'        =>      'Obrigação de Reparar o Dano',
 'OpcNac'        =>      'Opção de Nacionalidade',
 'OPJV'  =>      'Outros procedimentos de jurisdição voluntária',
 'Oposic'        =>      'Oposição',
 'OrFiFu'        =>      'Organização e Fiscalização de Fundação',
 'OuMePr'        =>      'Outras medidas provisionais',
 'OutPro'        =>      'Outros Procedimentos',
 'PA'    =>      'Processo Administrativo',
 'PA'    =>      'Processo Administrativo',
 'PADMag'        =>      'Processo Administrativo Disciplinar em face de Magistrado',
 'PADServ'       =>      'Processo Administrativo Disciplinar em face de Servidor',
 'PAM'   =>      'Parecer de Mérito sobre Anteprojeto de Lei',
 'PAP'   =>      'Produção Antecipada da Prova',
 'PARC'  =>      'Pedido de Arquivamento em Representação Criminal',
 'PAv'   =>      'Pedido de Avocação',
 'PBAC'  =>      'Pedido de Busca e Apreensão Criminal',
 'PC'    =>      'Processo Crime',
 'PC'    =>      'Prestação de Contas',
 'PCA'   =>      'Procedimento de Controle Administrativo',
 'PECAA' =>      'Procedimento Especial dos Crimes de Abuso de Autoridade',
 'PECPP' =>      'Processo Especial do Código de Processo Penal',
 'PedPri'        =>      'Pedido de Prisão',
 'PEJV'  =>      'Procedimentos Especiais de Jurisdição Voluntária',
 'PELE'  =>      'Processo Especial de Leis Esparsas',
 'PePrPr'        =>      'Pedido de Prisão Preventiva',
 'PePrTe'        =>      'Pedido de Prisão Temporária',
 'Pet'   =>      'Petição',
 'Pet'   =>      'Petição',
 'Pet'   =>      'Petição',
 'Pet'   =>      'Petição',
 'PJ'    =>      'Processo Judicial',
 'PJEC'  =>      'Procedimento do Juizado Especial Cível',
 'PodFam'        =>      'Perda ou Suspensão do Poder Familiar',
 'PoNoNa'        =>      'Posse em Nome do Nascituro',
 'PP'    =>      'Pedido de Providências',
 'PP'    =>      'Propaganda Partidária',
 'PPE'   =>      'Prisão Preventiva para Extradição',
 'PrApIn'        =>      'Processo de Apuração de Ato Infracional',
 'Prc'   =>      'Precatório',
 'PrCoEx'        =>      'Ação de Exigir Contas',
 'PrCoOf'        =>      'Prestação de Contas - Oferecidas',
 'Precat'        =>      'Precatório',
 'PreCon'        =>      'Prestação de Contas',
 'PrEsAn'        =>      'Procedimento Especial da Lei Antitóxicos',
 'PrFoBo'        =>      'Protesto Formado a Bordo',
 'PrNoJu'        =>      'Protesto por Novo Júri',
 'ProcApMSeg'    =>      'Processo de Aplicação de Medida de Segurança Por Fato Não Criminoso',
 'ProCau'        =>      'Processos Cautelares',
 'PROCLER'       =>      'Procedimentos Regidos por Outros Códigos, Leis Esparsas e Regimentos',
 'ProCom'        =>      'Procedimento Comum',
 'ProCon'        =>      'Processo de Conhecimento',
 'PROCRI'        =>      'PROCESSO CRIMINAL',
 'ProEsp'        =>      'Procedimentos Especiais',
 'ProEsp'        =>      'Processo Especial',
 'ProExe'        =>      'Processo de Execução',
 'ProFia'        =>      'Liberdade Provisória com ou sem fiança',
 'ProJui'        =>      'Providência ',
 'ProLiq'        =>      'Procedimento de Liquidação',
 'ProOrd'        =>      'Procedimento Comum',
 'ProSum'        =>      'Procedimento Sumário',
 'ProSum'        =>      'Procedimento do Juizado Especial Criminal - Sumariíssimo',
 'Protes'        =>      'Protesto',
 'PRRI'  =>      'Pedido de Resposta ou Retificação da Lei de Imprensa',
 'PrSeCo'        =>      'Prestação de Serviços a Comunidade',
 'PrSuD' =>      'Processo Sumário (Detenção)',
 'PRVC'  =>      'Pedido de Revisão do Valor da Causa',
 'PUIL'  =>      'Pedido de Uniformização de Interpretação de Lei',
 'PUILCrim'      =>      'Pedido de Uniformização de Interpretação de Lei',
 'QC'    =>      'Queixa Crime',
 'QO'    =>      'Questão de Ordem',
 'QuebSig'       =>      'Pedido de Quebra de Sigilo de Dados e/ou Telefônico',
 'QuPrIn'        =>      'Questões e Processos Incidentes',
 'RAL'   =>      'Recurso de Apreensão de Livro',
 'RCand' =>      'Registro de Candidatura',
 'RCDFDE'        =>      'Restituição de Coisa ou Dinheiro na Falência do Devedor Empresário',
 'RCED'  =>      'Recurso contra Expedição de Diploma',
 'RCF'   =>      'Registro de Comitê Financeiro',
 'Rcl'   =>      'Reclamação',
 'Rcl'   =>      'Reclamação',
 'Rcl'   =>      'Reclamação',
 'Rcl'   =>      'Reclamação',
 'RclDisc'       =>      'Reclamação Disciplinar',
 'RclPP' =>      'Reclamação Pré-processual',
 'Reabil'        =>      'Reabilitação',
 'RecAdm'        =>      'Recurso Administrativo',
 'ReCaNu'        =>      'Registro de Casamento Nuncupativo',
 'RecExt'        =>      'Recuperação Extrajudicial',
 'RecJud'        =>      'Recuperação Judicial',
 'ReCoAp'        =>      'Restituição de Coisas Apreendidas',
 'ReCoApInf'     =>      'Restituição de Coisas Apreendidas - Infracional',
 'RegAvaG'       =>      'Regulação de Avaria Grossa',
 'RegRegCiv'     =>      'Regularização de Registro Civil',
 'RegTor'        =>      'Registro Torrens',
 'RegVis'        =>      'Regulamentação de Visitas',
 'ReImHi'        =>      'Remição do Imóvel Hipotecado',
 'RelFal'        =>      'Relatório Falimentar',
 'RelInv'        =>      'Relatório de Investigações',
 'RelPri'        =>      'Relaxamento de Prisão',
 'RemInv'        =>      'Remoção de Inventariante',
 'RemPena'       =>      'Remição de Pena',
 'RenLoc'        =>      'Renovatória de Locação',
 'REP'   =>      'Representação por Excesso de Prazo',
 'ResAut'        =>      'Restauração de Autos',
 'ResAut'        =>      'Restauração de Autos',
 'RevAlu'        =>      'Revisional de Aluguel',
 'RevDis'        =>      'Revisão Disciplinar',
 'RGD'   =>      'Reclamação para Garantia das Decisões',
 'RJDCT' =>      'Revisão Judicial de Decisão do Conselho Tutelar',
 'RLS'   =>      'Recurso de Liquidação de Sentença',
 'RM'    =>      'Recurso de Multa',
 'RNE'   =>      'Retificação de Nome Estrangeiro',
 'RO'    =>      'Recurso Ordinário',
 'Rogato'        =>      'Carta Rogatória Cível',
 'ROPPF' =>      'Registro de Órgão de Partido Político em Formação',
 'Rp'    =>      'Representação',
 'Rp'    =>      'Representação',
 'Rp'    =>      'Representação',
 'RpCr'  =>      'Representação Criminal',
 'RpCr'  =>      'Representação Criminal/Notícia de Crime',
 'RPEPF' =>      'Renovação de Permanência em Estabelecimento Penal Federal',
 'RPP'   =>      'Registro de Partido Político',
 'RPV'   =>      'Requisição de Pequeno Valor',
 'RPV'   =>      'Requisição de Pequeno Valor',
 'RR'    =>      'Recurso de Revista',
 'RR'    =>      'Recurso de Revista',
 'RSCr'  =>      'Recurso de Sentença Criminal',
 'RSE'   =>      'Recurso em Sentido Estrito',
 'RTAlç' =>      'Ação Trabalhista - Rito Sumário (Alçada)',
 'RTOrd' =>      'Ação Trabalhista - Rito Ordinário',
 'RtPosse'       =>      'Reintegração / Manutenção de Posse',
 'RTSum' =>      'Ação Trabalhista - Rito Sumaríssimo',
 'RvC'   =>      'Revisão Criminal',
 'RvC'   =>      'Revisão Criminal',
 'RvCr'  =>      'Revisão Criminal',
 'RvE'   =>      'Revisão de Eleitorado',
 'SA'    =>      'Sentença Arbitral',
 'SD'    =>      'Sindicância',
 'SD'    =>      'Suspensão de Direitos',
 'SE'    =>      'Sentença Estrangeira',
 'SE'    =>      'Sentença Estrangeira',
 'SEC'   =>      'Sentença Estrangeira Contestada',
 'SEC'   =>      'Sentença Estrangeira Contestada',
 'SecCiv'        =>      'Seção Cível',
 'SecInf'        =>      'Seção Infracional',
 'Semili'        =>      'Semiliberdade',
 'SepCon'        =>      'Separação Consensual',
 'SepCor'        =>      'Separação de Corpos',
 'SepLit'        =>      'Separação Litigiosa',
 'Seques'        =>      'Seqüestro',
 'Seques'        =>      'Seqüestro',
 'SICMPPC'       =>      'Suprimento de Capacidade ou de Consentimento para Casar',
 'SIEC'  =>      'Suprimento de Idade e/ou Consentimento',
 'Sind'  =>      'Inquerito',
 'Sind'  =>      'Sindicância',
 'SIRDR' =>      'Suspensão Nacional do Incidente de Resolução de Demandas Repetitivas',
 'SLAT'  =>      'Suspensão de Liminar ou Antecipação de Tutela',
 'SLS'   =>      'Suspensão de Liminar e de Sentença',
 'Sobrep'        =>      'Sobrepartilha',
 'Sonega'        =>      'Sonegados',
 'STP'   =>      'Suspensão de Tutela Provisória',
 'SuDoMe'        =>      'Superveniência de doença mental',
 'SuExSe'        =>      'Suspensão de Execução de Sentença',
 'Suspei'        =>      'Exceção de Suspeição',
 'TCRD'  =>      'Tutela e Curatela - Remoção e Dispensa',
 'TDPF'  =>      'Tutela c/c Destituição do Poder Familiar',
 'TEEP'  =>      'Transferência entre estabelecimentos penais',
 'TerCir'        =>      'Termo Circunstanciado',
 'TPA'   =>      'Tutela Provisória Antecedente',
 'TuCuNo'        =>      'Tutela e Curatela -  Nomeação',
 'TutAntAntec'   =>      'Tutela Antecipada Antecedente',
 'TutCautAntec'  =>      'Tutela Cautelar Antecedente',
 'Tutela'        =>      'Tutela',
 'UniPen'        =>      'Unificação de penas',
 'Usucap'        =>      'Usucapião',
 'Verdad'        =>      'Exceção da Verdade',

 '2'     =>      'PROCESSO CÍVEL E DO TRABALHO',
 '7'     =>      'Procedimento Comum',
 '22'    =>      'Procedimento Sumário',
 '26'    =>      'Procedimentos Especiais',
 '27'    =>      'Procedimentos Especiais de Jurisdição Contenciosa',
 '28'    =>      'Anulação e Substituição de Títulos ao Portador',
 '29'    =>      'Apreensão e Depósito de Coisa Vendida com Reserva de Domínio',
 '30'    =>      'Arrolamento Comum',
 '31'    =>      'Arrolamento Sumário',
 '32'    =>      'Consignação em Pagamento',
 '34'    =>      'Demarcação / Divisão',
 '35'    =>      'Depósito',
 '37'    =>      'Embargos de Terceiro',
 '38'    =>      'Habilitação',
 '39'    =>      'Inventário',
 '40'    =>      'Monitória',
 '41'    =>      'Nunciação de Obra Nova',
 '44'    =>      'Prestação de Contas - Oferecidas',
 '45'    =>      'Ação de Exigir Contas',
 '46'    =>      'Restauração de Autos',
 '47'    =>      'Ação Rescisória',
 '48'    =>      'Sobrepartilha',
 '49'    =>      'Usucapião',
 '50'    =>      'Procedimentos Especiais de Jurisdição Voluntária',
 '51'    =>      'Abertura, Registro e Cumprimento de Testamento',
 '52'    =>      'Alienação Judicial de Bens',
 '53'    =>      'Arrecadação das Coisas Vagas',
 '54'    =>      'Confirmação de Testamento',
 '55'    =>      'Declaração de Ausência',
 '56'    =>      'Especialização de Hipoteca Legal',
 '57'    =>      'Herança Jacente',
 '58'    =>      'Interdição',
 '59'    =>      'Organização e Fiscalização de Fundação',
 '60'    =>      'Separação Consensual',
 '61'    =>      'Tutela e Curatela -  Nomeação',
 '62'    =>      'Procedimentos Regidos por Outros Códigos, Leis Esparsas e Regimentos',
 '63'    =>      'Ação Civil Coletiva',
 '64'    =>      'Ação Civil de Improbidade Administrativa',
 '65'    =>      'Ação Civil Pública',
 '66'    =>      'Ação Popular',
 '69'    =>      'Alimentos - Lei Especial Nº 5.478/68',
 '72'    =>      'Alteração do Regime de Bens',
 '74'    =>      'Alvará Judicial - Lei 6858/80',
 '76'    =>      'Apreensão de Embarcações',
 '77'    =>      'Arribadas Forçadas',
 '79'    =>      'Regulação de Avaria Grossa',
 '80'    =>      'Avarias',
 '81'    =>      'Busca e Apreensão em Alienação Fiduciária',
 '82'    =>      'Cancelamento de Naturalização',
 '83'    =>      'Cautelar Fiscal',
 '84'    =>      'Cobrança de Cédula de Crédito Industrial',
 '85'    =>      'Compromisso Arbitral',
 '86'    =>      'Consignatória de Aluguéis',
 '87'    =>      'Conversão de Separação Judicial em Divórcio',
 '88'    =>      'Correição Parcial ou Reclamação Correicional',
 '89'    =>      'Depósito da Lei 8. 866/94',
 '90'    =>      'Desapropriação',
 '91'    =>      'Desapropriação Imóvel Rural por Interesse Social',
 '92'    =>      'Despejo',
 '93'    =>      'Despejo por Falta de Pagamento',
 '94'    =>      'Despejo por Falta de Pagamento Cumulado Com Cobrança',
 '95'    =>      'Direta de Inconstitucionalidade',
 '96'    =>      'Discriminatória',
 '97'    =>      'Dissolução e Liquidação de Sociedade',
 '98'    =>      'Divórcio Consensual',
 '99'    =>      'Divórcio Litigioso',
 '100'   =>      'Dúvida',
 '107'   =>      'Expropriação da Lei 8.257/91',
 '108'   =>      'Falência de Empresários, Sociedades Empresáriais, Microempresas e Empresas de Pequeno Porte',
 '110'   =>      'Habeas Data',
 '111'   =>      'Habilitação de Crédito',
 '112'   =>      'Homologação de Transação Extrajudicial',
 '113'   =>      'Imissão na Posse',
 '114'   =>      'Impugnação de Crédito',
 '115'   =>      'Inquérito Extrajudicial',
 '118'   =>      'Mandado de Injunção',
 '119'   =>      'Mandado de Segurança Coletivo',
 '120'   =>      'Mandado de Segurança',
 '121'   =>      'Naturalização',
 '122'   =>      'Opção de Nacionalidade',
 '123'   =>      'Averiguação de Paternidade',
 '124'   =>      'Pedido de Resposta ou Retificação da Lei de Imprensa',
 '127'   =>      'Protesto Formado a Bordo',
 '128'   =>      'Recuperação Extrajudicial',
 '129'   =>      'Recuperação Judicial',
 '134'   =>      'Registro Torrens',
 '135'   =>      'Relatório Falimentar',
 '136'   =>      'Remição do Imóvel Hipotecado',
 '137'   =>      'Renovatória de Locação',
 '138'   =>      'Restituição de Coisa ou Dinheiro na Falência do Devedor Empresário',
 '140'   =>      'Revisional de Aluguel',
 '141'   =>      'Separação Litigiosa',
 '142'   =>      'Sonegados',
 '143'   =>      'Suprimento de Idade e/ou Consentimento',
 '144'   =>      'Suspensão de Liminar ou Antecipação de Tutela',
 '145'   =>      'Suspensão de Execução de Sentença',
 '150'   =>      'Procedimento de Liquidação',
 '151'   =>      'Liquidação por Arbitramento',
 '152'   =>      'Liquidação de Sentença pelo Procedimento Comum',
 '153'   =>      'Liquidação Provisória por Arbitramento',
 '154'   =>      'Liquidação Provisória de Sentença pelo Procedimento Comum',
 '155'   =>      'Procedimento de Cumprimento de Sentença/Decisão',
 '156'   =>      'Cumprimento de sentença',
 '157'   =>      'Cumprimento Provisório de Sentença',
 '158'   =>      'Processo de Execução',
 '159'   =>      'Execução de Título Extrajudicial',
 '165'   =>      'Insolvência Civil',
 '166'   =>      'Insolvência Requerida pelo Credor',
 '167'   =>      'Insolvência Requerida pelo Devedor ou pelo Espólio',
 '169'   =>      'Embargos',
 '170'   =>      'Embargos à Adjudicação',
 '171'   =>      'Embargos à Arrematação',
 '172'   =>      'Embargos à Execução',
 '173'   =>      'Embargos de Retenção por Benfeitorias',
 '176'   =>      'Alimentos - Provisionais',
 '177'   =>      'Apreensão de  Títulos',
 '178'   =>      'Arresto ',
 '179'   =>      'Arrolamento de Bens',
 '180'   =>      'Atentado',
 '181'   =>      'Busca e Apreensão',
 '182'   =>      'Caução',
 '183'   =>      'Cautelar Inominada',
 '186'   =>      'Exibição',
 '188'   =>      'Homologação do Penhor Legal',
 '190'   =>      'Justificação',
 '191'   =>      'Protesto',
 '192'   =>      'Posse em Nome do Nascituro',
 '193'   =>      'Produção Antecipada da Prova',
 '194'   =>      'Regulamentação de Visitas',
 '195'   =>      'Separação de Corpos',
 '196'   =>      'Seqüestro',
 '197'   =>      'Recursos',
 '198'   =>      'Apelação',
 '199'   =>      'Remessa Necessária',
 '200'   =>      'Agravos',
 '202'   =>      'Agravo de Instrumento',
 '203'   =>      'Agravo de Instrumento em Recurso Especial',
 '204'   =>      'Agravo de Instrumento em Recurso Extraordinário',
 '206'   =>      'Agravo Regimental',
 '207'   =>      'Embargos',
 '208'   =>      'Embargos Infringentes',
 '210'   =>      'Embargos Infringentes na Execução Fiscal',
 '211'   =>      'Recurso Ordinário',
 '212'   =>      'Recurso Extraordinário',
 '213'   =>      'Recurso Especial',
 '214'   =>      'Outros Procedimentos',
 '215'   =>      'Incidentes',
 '216'   =>      'Incidente De Arguição de Inconstitucionalidade',
 '218'   =>      'Assistência Judiciária',
 '221'   =>      'Conflito de competência',
 '224'   =>      'Exceções',
 '228'   =>      'Exibição de Documento ou Coisa',
 '229'   =>      'Impugnação ao Cumprimento de Sentença',
 '230'   =>      'Impugnação ao Pedido de Assistência Litisconsorcial ou Simples',
 '231'   =>      'Impugnação ao Valor da Causa',
 '232'   =>      'Incidente de Falsidade',
 '233'   =>      'Incidente de Uniformização de Jurisprudência',
 '234'   =>      'Remoção de Inventariante',
 '236'   =>      'Oposição',
 '237'   =>      'Atos e expedientes',
 '238'   =>      'Avocatória',
 '239'   =>      'Habilitação para Casamento',
 '240'   =>      'Instrução de Rescisória',
 '241'   =>      'Petição',
 '242'   =>      'Comunicação',
 '244'   =>      'Reclamação',
 '251'   =>      'Registro de Casamento Nuncupativo',
 '256'   =>      'Representação por Excesso de Prazo',
 '257'   =>      'Cartas',
 '258'   =>      'Carta de Ordem Cível',
 '261'   =>      'Carta Precatória Cível',
 '264'   =>      'Carta Rogatória Cível',
 '268'   =>      'PROCESSO CRIMINAL',
 '269'   =>      'Medidas Preparatórias',
 '270'   =>      'Notícia-Crime',
 '271'   =>      'Representação Criminal',
 '272'   =>      'Representação Criminal/Notícia de Crime',
 '273'   =>      'Pedido de Arquivamento em Representação Criminal',
 '274'   =>      'Interpelações',
 '275'   =>      'Notificação para Explicações',
 '276'   =>      'Notificação para Explicações (Lei de Imprensa)',
 '277'   =>      'Procedimentos Investigatórios',
 '278'   =>      'Termo Circunstanciado',
 '279'   =>      'Inquérito Policial',
 '280'   =>      'Auto de Prisão em Flagrante',
 '281'   =>      'Procedimento Comum',
 '282'   =>      'Ação Penal de Competência do Júri',
 '283'   =>      'Ação Penal - Procedimento Ordinário',
 '284'   =>      'Processo Especial',
 '285'   =>      'Processo Especial do Código de Processo Penal',
 '287'   =>      'Crimes de Responsabilidade dos Funcionários Públicos',
 '288'   =>      'Crimes de Calúnia, Injúria e Difamação de Competência do Juiz Singular',
 '289'   =>      'Crimes Contra a Propriedade Imaterial',
 '290'   =>      'Processo Sumário (Detenção)',
 '291'   =>      'Restauração de Autos',
 '292'   =>      'Processo Especial de Leis Esparsas',
 '293'   =>      'Crimes Ambientais',
 '294'   =>      'Crimes Contra a Propriedade Industrial',
 '295'   =>      'Crimes Contra a Propriedade Intelectual',
 '297'   =>      'Crimes de Imprensa',
 '299'   =>      'Procedimento do Juizado Especial Criminal - Sumariíssimo',
 '300'   =>      'Procedimento Especial da Lei Antitóxicos',
 '302'   =>      'Procedimento Especial dos Crimes de Abuso de Autoridade',
 '303'   =>      'Medidas Garantidoras',
 '304'   =>      'Liberdade',
 '305'   =>      'Liberdade Provisória com ou sem fiança',
 '306'   =>      'Relaxamento de Prisão',
 '307'   =>      'Habeas Corpus',
 '308'   =>      'Medidas Cautelares',
 '309'   =>      'Pedido de Busca e Apreensão Criminal',
 '310'   =>      'Pedido de Quebra de Sigilo de Dados e/ou Telefônico',
 '311'   =>      'Medidas Investigatórias Sobre Organizações Criminosas',
 '312'   =>      'Pedido de Prisão',
 '313'   =>      'Pedido de Prisão Preventiva',
 '314'   =>      'Pedido de Prisão Temporária',
 '315'   =>      'Pedido de Prisão/ Liberdade Vigiada para Fins de Expulsão',
 '316'   =>      'Questões e Processos Incidentes',
 '317'   =>      'Exceções',
 '318'   =>      'Exceção de Suspeição',
 '319'   =>      'Exceção de Incompetência de Juízo',
 '320'   =>      'Exceção de Litispendência',
 '321'   =>      'Exceção de Ilegitimidade de Parte',
 '322'   =>      'Exceção de Coisa Julgada',
 '323'   =>      'Exceção de Impedimento',
 '324'   =>      'Exceção da Verdade',
 '325'   =>      'Conflito de Jurisdição',
 '326'   =>      'Restituição de Coisas Apreendidas',
 '327'   =>      'Embargos de Terceiro',
 '328'   =>      'Medidas Assecuratórias',
 '329'   =>      'Seqüestro',
 '330'   =>      'Arresto / Hipoteca Legal',
 '331'   =>      'Incidentes',
 '332'   =>      'Incidente de Falsidade',
 '333'   =>      'Insanidade Mental do Acusado',
 '335'   =>      'Carta de Ordem Criminal',
 '355'   =>      'Carta Precatória Criminal',
 '375'   =>      'Carta Rogatória Criminal',
 '385'   =>      'Execução Criminal',
 '386'   =>      'Execução da Pena',
 '406'   =>      'Incidentes',
 '407'   =>      'Conversão de Pena',
 '408'   =>      'Excesso ou Desvio',
 '409'   =>      'Anistia',
 '410'   =>      'Indulto',
 '411'   =>      'Comutação de Pena',
 '413'   =>      'Agravo de Execução Penal',
 '416'   =>      'Apelação em Mandado de Segurança',
 '417'   =>      'Apelação',
 '418'   =>      'Carta Testemunhável',
 '419'   =>      'Correição Parcial',
 '420'   =>      'Embargos de Declaração',
 '421'   =>      'Embargos Infringentes e de Nulidade',
 '422'   =>      'Protesto por Novo Júri',
 '424'   =>      'Recurso de Medida Cautelar',
 '425'   =>      'Recurso de Sentença Criminal',
 '426'   =>      'Recurso em Sentido Estrito',
 '427'   =>      'Remessa Necessária',
 '428'   =>      'Revisão Criminal',
 '432'   =>      'Desaforamento de Julgamento',
 '433'   =>      'Incidente de Uniformização de Jurisprudência',
 '436'   =>      'Procedimento do Juizado Especial Cível',
 '457'   =>      'Pedido de Uniformização de Interpretação de Lei',
 '460'   =>      'Recurso Inominado',
 '976'   =>      'Ação Anulatória de Cláusulas Convencionais',
 '980'   =>      'Ação de Cumprimento',
 '985'   =>      'Ação Trabalhista - Rito Ordinário',
 '986'   =>      'Inquérito para Apuração de Falta Grave',
 '987'   =>      'Dissídio Coletivo',
 '988'   =>      'Dissídio Coletivo de Greve',
 '990'   =>      'Execução de Título Extrajudicial',
 '991'   =>      'Execução de Termo de Ajuste de Conduta',
 '992'   =>      'Execução de Termo de Conciliação de CCP',
 '993'   =>      'Execução de Certidão de Crédito Judicial',
 '994'   =>      'Execução Provisória em Autos Suplementares',
 '1000'  =>      'Agravo',
 '1001'  =>      'Agravo de Instrumento em Agravo de Petição',
 '1002'  =>      'Agravo de Instrumento em Recurso de Revista',
 '1003'  =>      'Agravo de Instrumento em Recurso Ordinário',
 '1004'  =>      'Agravo de Petição',
 '1005'  =>      'Agravo Regimental',
 '1006'  =>      'Embargos',
 '1007'  =>      'Embargos Infringentes',
 '1008'  =>      'Recurso de Revista',
 '1009'  =>      'Recurso Ordinário',
 '1013'  =>      'Agravo de Instrumento em Recurso de Habeas Corpus',
 '1015'  =>      'Embargos de Divergência em Recurso de Mandado de Segurança',
 '1016'  =>      'Embargos em Agravo de Instrumento',
 '1017'  =>      'Embargos à Execução em Mandado de Segurança',
 '1018'  =>      'Embargos à Execução em Ação Recisoria',
 '1019'  =>      'Embargos à Execução em Medida Cautelar',
 '1020'  =>      'Execução em Ação Rescisória',
 '1021'  =>      'Execução em Sentença Estrangeira',
 '1022'  =>      'Execução em Sentença Estrangeira Contestada',
 '1023'  =>      'Execução em Mandado de Segurança',
 '1024'  =>      'Execução em Medida Cautelar',
 '1025'  =>      'Incidente de Deslocamento de Competência ',
 '1026'  =>      'Sentença Estrangeira',
 '1027'  =>      'Sentença Estrangeira Contestada',
 '1028'  =>      'Sindicância',
 '1029'  =>      'Mandado de Segurança',
 '1030'  =>      'Reclamação',
 '1031'  =>      'Recurso Ordinário',
 '1032'  =>      'Recurso Especial',
 '1033'  =>      'Ação Penal',
 '1034'  =>      'Interpelação Judicial',
 '1035'  =>      'Apelação Cível',
 '1036'  =>      'Suspensão de Liminar e de Sentença',
 '1037'  =>      'Embargos Infringentes em Apelação Cível',
 '1038'  =>      'Representação',
 '1040'  =>      'Requisição de Pequeno Valor',
 '1042'  =>      'Inquérito',
 '1044'  =>      'Agravo de Instrumento',
 '1045'  =>      'Agravo de Instrumento em Recurso Extraordinário',
 '1046'  =>      'Agravo de Instrumento em Recurso de Mandado de Segurança',
 '1047'  =>      'Carta Rogatória',
 '1049'  =>      'Habeas Data',
 '1053'  =>      'Conflito de Atribuição',
 '1054'  =>      'Conflito de Competência',
 '1057'  =>      'Petição',
 '1062'  =>      'Medida Cautelar',
 '1063'  =>      'Exceção da Verdade',
 '1064'  =>      'Recurso Ordinário em Habeas Corpus',
 '1066'  =>      'Embargos Infringentes em Ação Rescisória',
 '1068'  =>      'Processo de Execução Trabalhista',
 '1070'  =>      'Incidentes Trabalhistas',
 '1071'  =>      'Recursos Trabalhistas',
 '1072'  =>      'Pedido de Revisão do Valor da Causa',
 '1106'  =>      'Processo de Conhecimento',
 '1107'  =>      'Procedimento de Conhecimento',
 '1111'  =>      'Execução de Título Judicial',
 '1112'  =>      'Execução de Alimentos',
 '1114'  =>      'Execução Contra a Fazenda Pública',
 '1116'  =>      'Execução Fiscal',
 '1117'  =>      'Execução Hipotecária do Sistema Financeiro da Habitação',
 '1118'  =>      'Embargos à Execução Fiscal',
 '1122'  =>      'Tutela e Curatela - Remoção e Dispensa',
 '1124'  =>      'Justificação de Dinheiro a Risco',
 '1125'  =>      'Ação Trabalhista - Rito Sumaríssimo',
 '1126'  =>      'Ação Trabalhista - Rito Sumário (Alçada)',
 '1137'  =>      'Embargos de Divergência em Recurso Especial',
 '1145'  =>      'Conflito de Competência',
 '1178'  =>      'Incidente de Arguição de Inconstitucionalidade',
 '1198'  =>      'PROCEDIMENTOS ADMINISTRATIVOS',
 '1199'  =>      'Pedido de Providências',
 '1202'  =>      'Reclamação',
 '1208'  =>      'Agravo Interno',
 '1230'  =>      'Exceção de Impedimento',
 '1231'  =>      'Exceção de Suspeição',
 '1232'  =>      'Exceção de Incompetência',
 '1233'  =>      'Efeito Suspensivo',
 '1262'  =>      'Processo Administrativo Disciplinar em face de Servidor',
 '1264'  =>      'Processo Administrativo Disciplinar em face de Magistrado',
 '1265'  =>      'Precatório',
 '1266'  =>      'Requisição de Pequeno Valor',
 '1267'  =>      'Recurso de Multa',
 '1268'  =>      'Medidas Protetivas de urgência (Lei Maria da Penha)',
 '1269'  =>      'Habeas Corpus',
 '1271'  =>      'Recurso de Medida Cautelar',
 '1283'  =>      'Superveniência de doença mental',
 '1284'  =>      'Unificação de penas',
 '1285'  =>      'Conflito de atribuição',
 '1288'  =>      'Transferência entre estabelecimentos penais',
 '1289'  =>      'Outras medidas provisionais',
 '1291'  =>      'Reabilitação',
 '1294'  =>      'Outros procedimentos de jurisdição voluntária',
 '1295'  =>      'Alvará Judicial',
 '1296'  =>      'Declaratória de Constitucionalidade',
 '1297'  =>      'Intervenção em Município',
 '1298'  =>      'Processo Administrativo',
 '1299'  =>      'Recurso Administrativo',
 '1301'  =>      'Reclamação Disciplinar',
 '1303'  =>      'Correição Extraordinária',
 '1304'  =>      'Inspeção',
 '1306'  =>      'Recurso em Processo Administrativo Disciplinar em face de Servidor',
 '1307'  =>      'Correição Ordinária',
 '1308'  =>      'Sindicância',
 '1311'  =>      'Ação Cautelar',
 '1312'  =>      'Ação Civil Originária',
 '1313'  =>      'Ação Declaratória de Constitucionalidade',
 '1314'  =>      'Ação Direta de Inconstitucionalidade',
 '1315'  =>      'Ação Originária',
 '1316'  =>      'Ação Originária Especial',
 '1317'  =>      'Ação Penal',
 '1318'  =>      'Ação Rescisória',
 '1319'  =>      'Agravo',
 '1320'  =>      'Agravo de Instrumento',
 '1321'  =>      'Agravo Regimental',
 '1322'  =>      'Arguição de Descumprimento de Preceito Fundamental',
 '1323'  =>      'Arguição de Suspeição',
 '1324'  =>      'Carta Rogatória',
 '1325'  =>      'Comunicação',
 '1326'  =>      'Conflito de Competência',
 '1327'  =>      'Embargos de Declaração',
 '1328'  =>      'Embargos de Divergência',
 '1329'  =>      'Embargos Infringentes',
 '1330'  =>      'Extradição',
 '1331'  =>      'Habeas Corpus',
 '1332'  =>      'Habeas Data',
 '1333'  =>      'Inquerito',
 '1334'  =>      'Intervenção Federal',
 '1335'  =>      'Mandado de Injunção',
 '1336'  =>      'Mandado de Segurança',
 '1337'  =>      'Medida Cautelar',
 '1338'  =>      'Petição',
 '1339'  =>      'Prisão Preventiva para Extradição',
 '1340'  =>      'Processo Administrativo',
 '1341'  =>      'Questão de Ordem',
 '1342'  =>      'Reclamação',
 '1343'  =>      'Recurso Criminal',
 '1344'  =>      'Recurso em Habeas Corpus',
 '1345'  =>      'Recurso em Habeas Data',
 '1346'  =>      'Recurso em Mandado de Injunção',
 '1347'  =>      'Recurso em Mandado de Segurança',
 '1348'  =>      'Recurso Extraordinário',
 '1349'  =>      'Revisão Criminal',
 '1350'  =>      'Sentença Estrangeira',
 '1351'  =>      'Sentença Estrangeira Contestada',
 '1352'  =>      'Suspensão de Liminar',
 '1353'  =>      'Suspensão de Segurança',
 '1354'  =>      'Suspensão de Tutela Provisória',
 '1356'  =>      'Ação Ordinária Regressiva',
 '1357'  =>      'Ação Regressiva',
 '1358'  =>      'Apelação Cível',
 '1359'  =>      'Apelação Criminal',
 '1360'  =>      'Arguição de Relevância',
 '1361'  =>      'Carta Testemunhável',
 '1362'  =>      'Conflito de Atribuições',
 '1363'  =>      'Conflito de Jurisdição',
 '1364'  =>      'Denúncia',
 '1365'  =>      'Embargos Remetidos',
 '1366'  =>      'Exceção da Verdade',
 '1367'  =>      'Exceção de Suspeição',
 '1368'  =>      'Inquérito Administrativo',
 '1369'  =>      'Inquérito Policial',
 '1370'  =>      'Inquérito Policial Especial',
 '1371'  =>      'Interpelação',
 '1372'  =>      'Liquidação de Sentença',
 '1373'  =>      'Notificação',
 '1374'  =>      'Pedido de Avocação',
 '1375'  =>      'Processo Crime',
 '1376'  =>      'Processo Judicial',
 '1377'  =>      'Queixa Crime',
 '1378'  =>      'Recurso de Apreensão de Livro',
 '1379'  =>      'Recurso de Liquidação de Sentença',
 '1380'  =>      'Recurso de Revista',
 '1381'  =>      'Representação',
 '1382'  =>      'Retificação de Nome Estrangeiro',
 '1383'  =>      'Sentença Arbitral',
 '1384'  =>      'Suspensão de Direitos',
 '1385'  =>      'Seção Cível',
 '1386'  =>      'Processo de Conhecimento',
 '1389'  =>      'Ação de Alimentos',
 '1390'  =>      'Revisão Judicial de Decisão do Conselho Tutelar',
 '1391'  =>      'Apuração de Irregularidades em Entidades de Atendimento',
 '1392'  =>      'Apuração de Infração Administrativa às Normas de Proteção à Criança ou Adolescente',
 '1396'  =>      'Tutela',
 '1399'  =>      'Tutela c/c Destituição do Poder Familiar',
 '1401'  =>      'Adoção',
 '1412'  =>      'Adoção c/c Destituição do Poder Familiar',
 '1414'  =>      'Suprimento de Capacidade ou de Consentimento para Casar',
 '1415'  =>      'Emancipação',
 '1417'  =>      'Regularização de Registro Civil',
 '1420'  =>      'Guarda',
 '1424'  =>      'Providência ',
 '1425'  =>      'Prestação de Contas',
 '1426'  =>      'Perda ou Suspensão do Poder Familiar',
 '1430'  =>      'Processo de Execução',
 '1432'  =>      'Execução de Alimentos',
 '1434'  =>      'Medidas de Proteção à Criança e Adolescente',
 '1435'  =>      'Execução de Multa',
 '1436'  =>      'Processos Cautelares',
 '1438'  =>      'Busca e Apreensão',
 '1440'  =>      'Cautelar Inominada',
 '1450'  =>      'Cartas',
 '1451'  =>      'Carta de Ordem Infância e Juventude',
 '1455'  =>      'Carta Precatória Infância e Juventude',
 '1459'  =>      'Seção Infracional',
 '1460'  =>      'Procedimentos Investigatórios',
 '1461'  =>      'Auto de Apreensão em Flagrante',
 '1462'  =>      'Relatório de Investigações',
 '1463'  =>      'Boletim de Ocorrência Circunstanciada',
 '1464'  =>      'Processo de Apuração de Ato Infracional',
 '1465'  =>      'Execução de Medidas Sócio-Educativas',
 '1466'  =>      'Internação com Atividades Externas',
 '1467'  =>      'Internação sem Atividades Externas',
 '1468'  =>      'Semiliberdade',
 '1469'  =>      'Liberdade Assistida',
 '1470'  =>      'Prestação de Serviços a Comunidade',
 '1471'  =>      'Obrigação de Reparar o Dano',
 '1472'  =>      'Advertência ',
 '1473'  =>      'Cartas',
 '1474'  =>      'Carta de Ordem Infracional',
 '1478'  =>      'Carta Precatória Infracional',
 '1669'  =>      'Ação Rescisória',
 '1670'  =>      'Ação de Improbidade Administrativa',
 '1671'  =>      'Comunicação',
 '1672'  =>      'Exceção de Impedimento',
 '1673'  =>      'Exceção de Suspeição',
 '1674'  =>      'Intervenção Federal',
 '1675'  =>      'Mandado de Injunção',
 '1677'  =>      'Precatório',
 '1678'  =>      'Revisão Criminal',
 '1679'  =>      'Suspensão de Segurança',
 '1680'  =>      'Consulta',
 '1682'  =>      'Retificação ou Suprimento ou Restauração de Registro Civil',
 '1683'  =>      'Retificação de Registro de Imóvel',
 '1685'  =>      'Reexame Necessário',
 '1689'  =>      'Embargos de Declaração',
 '1690'  =>      'Ação Civil Pública',
 '1691'  =>      'Mandado de Segurança',
 '1701'  =>      'Nomeação de Advogado',
 '1702'  =>      'Impugnação de Assistência Judiciária',
 '1703'  =>      'Autorização judicial',
 '1704'  =>      'Embargos de Terceiro',
 '1705'  =>      'Remoção, modificação  e dispensa de tutor ou curador',
 '1706'  =>      'Procedimento ordinário',
 '1707'  =>      'Reintegração / Manutenção de Posse',
 '1709'  =>      'Interdito Proibitório',
 '1710'  =>      'Mandado de Segurança',
 '1711'  =>      'Agravo de Instrumento em Recurso Especial',
 '1712'  =>      'Agravo de Instrumento em Recurso Extraordinário',
 '1714'  =>      'Execução Provisória',
 '1715'  =>      'Embargos do Acusado',
 '1717'  =>      'Alienação de Bens do Acusado',
 '1719'  =>      'Avaliação para atestar dependência de drogas',
 '1720'  =>      'Habeas Corpus',
 '1721'  =>      'Recurso Ordinário em Mandado de Segurança',
 '1722'  =>      'Recurso Ordinário em Habeas Corpus',
 '1723'  =>      'Contraprotesto Judicial',
 '1725'  =>      'Notificação',
 '1726'  =>      'Interpelação',
 '1727'  =>      'Petição',
 '1728'  =>      'Apelação / Remessa Necesária',
 '1729'  =>      'Agravo Regimental',
 '1730'  =>      'Recurso Ordinário',
 '1731'  =>      'Investigação contra magistrado',
 '1733'  =>      'Procedimento Investigatório Criminal (PIC-MP) ',
 '10933' =>      'Habilitação para Adoção',
 '10942' =>      'Correição Parcial',
 '10943' =>      'Ação Penal - Procedimento Sumário',
 '10944' =>      'Ação Penal - Procedimento Sumaríssimo',
 '10960' =>      'Incidente de Sanidade Mental',
 '10967' =>      'Medidas Protetivas - Estatuto do Idoso ',
 '10970' =>      'Conflito de Competência',
 '10972' =>      'Exibição de Documento ou Coisa',
 '10973' =>      'Impugnação ao Valor da Causa',
 '10974' =>      'Incidente de Falsidade',
 '10975' =>      'Exceção de Impedimento',
 '10976' =>      'Exceção de Incompetência',
 '10977' =>      'Exceção de Suspeição',
 '10979' =>      'Petição',
 '10980' =>      'Cumprimento Provisório de Decisão',
 '10981' =>      'Impugnação ao Cumprimento  de Decisão',
 '11026' =>      'Petição',
 '11027' =>      'Reexame Necessário / Recurso Ordinário',
 '11034' =>      'Conselho de Justificação ',
 '11035' =>      'Representação p/ Declaração de Indignidade/Incompatibilidade ',
 '11036' =>      'Representação p/ Perda da Graduação ',
 '11037' =>      'Ação Penal Militar - Procedimento Ordinário',
 '11038' =>      'Embargos em Ação Penal Militar',
 '11039' =>      'Reclamação',
 '11040' =>      'Recurso Inominado',
 '11041' =>      'Inquérito Policial Militar',
 '11042' =>      'Correição Parcial',
 '11043' =>      'Deserção',
 '11044' =>      'Insubmissão',
 '11045' =>      'Deserção de Oficial',
 '11046' =>      'Deserção de Praça',
 '11397' =>      'Extinção das obrigações do falido',
 '11398' =>      'Recurso em sentido estrito/Recurso ex officio',
 '11399' =>      'Execução de Medida de Segurança',
 '11400' =>      'Agravo de Instrumento em Recurso Ordinário para o STF',
 '11427' =>      'PROCESSO ELEITORAL',
 '11525' =>      'Processos Cíveis-Eleitorais',
 '11526' =>      'Ação de Impugnação de Mandato Eletivo',
 '11527' =>      'Ação de Investigação Judicial Eleitoral',
 '11528' =>      'Ação Penal Eleitoral',
 '11529' =>      'Procedimentos Relativos a Realização de Eleição',
 '11530' =>      'Apuração de Eleição',
 '11531' =>      'Prestação de Contas',
 '11532' =>      'Registro de Candidatura',
 '11533' =>      'Recurso contra Expedição de Diploma',
 '11534' =>      'Procedimentos Relativos a Partidos Políticos',
 '11535' =>      'Cancelamento de Registro de Partido Político',
 '11536' =>      'Propaganda Partidária',
 '11537' =>      'Registro de Órgão de Partido Político em Formação',
 '11538' =>      'Registro de Comitê Financeiro',
 '11539' =>      'Registro de Partido Político',
 '11540' =>      'Procedimentos Administrativos da Justiça Eleitoral',
 '11541' =>      'Representação',
 '11542' =>      'Correição',
 '11543' =>      'Criação de Zona Eleitoral ou Remanejamento',
 '11544' =>      'Instrução',
 '11545' =>      'Lista Tríplice',
 '11546' =>      'Revisão de Eleitorado',
 '11547' =>      'Recursos Eleitorais',
 '11548' =>      'Recurso Eleitoral',
 '11549' =>      'Recurso Especial Eleitoral',
 '11550' =>      'Recurso Ordinário',
 '11551' =>      'Consulta',
 '11552' =>      'Pedido de Desaforamento',
 '11553' =>      'Instrução Provisória de Deserção',
 '11555' =>      'Suspensão de Liminar e de Sentença',
 '11556' =>      'Suspensão de Segurança',
 '11787' =>      'Assistência Judiciária',
 '11788' =>      'Exibição de Documento ou Coisa ',
 '11789' =>      'Impugnação ao Valor da Causa',
 '11790' =>      'Impugnação de Assistência Judiciária',
 '11791' =>      'Pedido de Uniformização de Interpretação de Lei',
 '11793' =>      'Justificação Criminal',
 '11794' =>      'Restituição de Coisas Apreendidas - Infracional',
 '11798' =>      'Processo de Aplicação de Medida de Segurança Por Fato Não Criminoso',
 '11799' =>      'Instrução Provisória de Insubmissão',
 '11800' =>      'Instrução Provisória de Deserção',
 '11875' =>      'Reclamação Pré-processual',
 '11880' =>      'Recurso Extraordinário com Agravo',
 '11881' =>      'Agravo em Recurso Especial',
 '11882' =>      'Recurso de Revista com Agravo',
 '11887' =>      'Acompanhamento de Cumprimento de Decisão',
 '11888' =>      'Ato Normativo',
 '11889' =>      'Nota Técnica',
 '11890' =>      'Parecer de Mérito sobre Anteprojeto de Lei',
 '11891' =>      'Procedimento de Controle Administrativo',
 '11892' =>      'Revisão Disciplinar',
 '11893' =>      'Reclamação para Garantia das Decisões',
 '11894' =>      'Procedimento de Competência de Comissão',
 '11953' =>      'Arguição de Suspeição e de Impedimento',
 '11955' =>      'Cautelar Inominada Criminal',
 '11956' =>      'Embargos de Divergência em Agravo em Recurso Especial',
 '11957' =>      'Remição de Pena',
 '12070' =>      'Pedido de Medida de Proteção',
 '12071' =>      'Procedimentos Cautelares',
 '12072' =>      'Busca e Apreensão',
 '12073' =>      'Internação Provisória',
 '12074' =>      'Pedido De Desinternação/Reavaliação/Substituição/Suspensão da Medida',
 '12075' =>      'Procedimento Conciliatório',
 '12076' =>      'Restabelecimento do Poder Familiar',
 '12077' =>      'Homologação em Acordo de Colaboração Premiada',
 '12078' =>      'Cumprimento de Sentença contra a Fazenda Pública',
 '12079' =>      'Execução de Título Extajudicial contra a Fazenda Pública',
 '12080' =>      'Incidente de Impedimento',
 '12081' =>      'Incidente de Suspeição',
 '12082' =>      'Carta Arbitral',
 '12083' =>      'Tutela Antecipada Antecedente',
 '12084' =>      'Tutela Cautelar Antecedente',
 '12085' =>      'Incidente de Resolução de Demandas Repetitivas',
 '12086' =>      'Dissolução Parcial de Sociedade',
 '12087' =>      'Incidente de Assunção de Competência',
 '12088' =>      'Liquidação Provisória de Sentença pelo Procedimento Comum',
 '12089' =>      'Renovação de Permanência em Estabelecimento Penal Federal',
 '12117' =>      'Suspensão em Incidente de Resolução de Demandas Repetitivas',
 '12118' =>      'Suspensão em Incidente de Resolução de Demandas Repetitivas',
 '12119' =>      'Incidente de Desconsideração de Personalidade Jurídica',
 '12120' =>      'Agravo em Execução de Medidas Sócio-Educativas',
 '12121' =>      'Auto de Prisão',
 '12122' =>      'Reclamação Criminal',
 '12123' =>      'Roteiro de Pena',
 '12125' =>      'Progressão de Regime',
 '12126' =>      'Regressão de Regime',
 '12127' =>      'Remição',
 '12128' =>      'Livramento Condicional',
 '12129' =>      'Outros Incidentes de Execução Iniciados de Ofício',
 '12132' =>      'Incidente de Julgamento de Recurso de Revista e de Embargos Repetitivos',
 '12133' =>      'Tutela Provisória',
 '12134' =>      'Tutela Cautelar Antecedente',
 '12135' =>      'Tutela Antecipada Antecedente',
 '12136' =>      'Pedido de Mediação Pré-Processual',
 '12137' =>      'Requerimento de Apreensão de Veículo',
 '12138' =>      'Requerimento de Reintegração de Posse',
 '12139' =>      'Contestação em Foro Diverso',
 '12153' =>      'Embargos Parciais à Ação Monitória',
 '12154' =>      'Execução de Título Extrajudicial',
 '12190' =>      'Suspensão Nacional do Incidente de Resolução de Demandas Repetitivas',
 '12191' =>      'Tutela Provisória Antecedente',
 '12192' =>      'Tutela Provisória Incidental',
};

1;

__END__

=head1 NAME

Business::BR::CNJ::Classes - Convert brazilian CNJ (Conselho Nacional de Justiça) class numbers and abreviations to full text names/description.

=head1 SYNOPSIS

   use Business::BR::CNJ::Classes ( qw/ cnj_classe / );

   print cnj_classe('Ag');   # Will aouput "Agravo"
   print cnj_classe(12128);  # Will output "Livramento Condicional"
   

=head1 DESCRIPTION

This module handles CNJ class numbers and abreviations, converting them to full text names/description.

=head1 METHDOS

=head2 cnj_classe

Convert a CNF class number or abreviation to it's full name.

References:

http://www.cnj.jus.br/sgt/consulta_publica_classes.php

=over

=head1 SEE ALSO

Please check CNJ website at http://www.cnj.jus.br/

=head1 AUTHOR

Diego de Lima, E<lt>diego_de_lima@hotmail.comE<gt>

=head1 SPECIAL THANKS

This module was kindly made available by the https://modeloinicial.com.br/ team.

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2017 by Diego de Lima

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.10.1 or,
at your option, any later version of Perl 5 you may have available.

=cut
