#!/usr/bin/env perl
use strict;
use warnings;
use lib 'lib';
use Test::More;
use Test::Exception;
use Catan::Map;
use Catan::Map::Tile;
use Catan::Map::Intersection;
use Catan::Map::Path;

my $tiles = [
    [0,-3,"HR",undef],
    [1,-3,"S",undef],
    [2,-3,"HRW",undef],
    [3,-3,"S",undef],
    [3,-2,"HR",undef],
    [3,-1,"S",undef],
    [3,0,"HRG",undef],
    [2,1,"S",undef],
    [1,2,"HRB",undef],
    [0,3,"S",undef],
    [-1,3,"HRL",undef],
    [-2,3,"S",undef],
    [-3,3,"HR",undef],
    [-3,2,"S",undef],
    [-3,1,"HR",undef],
    [-3,0,"S",undef],
    [-2,-1,"HRO",undef],
    [-1,-2,"S",undef],
    [0,-2,"FO",11],
    [1,-2,"P",12],
    [2,-2,"F",9],
    [2,-1,"P",10],
    [2,0,"F",8],
    [1,1,"M",3],
    [0,2,"FO",6],
    [-1,2,"F",2],
    [-2,2,"M",5],
    [-2,1,"H",8],
    [-2,0,"D",undef],
    [-1,-1,"H",4],
    [0,-1,"M",6],
    [1,-1,"H",5],
    [1,0,"FO",4],
    [0,1,"P",9],
    [-1,1,"P",10],
    [-1,0,"FO",3],
    [0,0,"F",11]
];

# starter
ok my $map = Catan::Map->new({type => 'starter'}), 'construct new map';
is_deeply $map->_starter, $tiles, 'starter map meets expected layout';

# custom
ok my $custom_map = Catan::Map->new({type => 'custom', map => $tiles}), 'construct new custom map';

# random
ok my $random_map = Catan::Map->new({type => 'random'}), 'construct new random map';
cmp_ok scalar keys %{$random_map->tiles}, '==', 37, 'random map has 37 tiles';

# lookups
ok my $tile1 = $map->find_tile([0,0]), 'find center tile';
ok my $tile2 = $map->find_tile([0,-1]), 'find neighboring tile';
ok my $tile3 = $map->find_tile([-1,-1]), 'find further away tile';
ok my $i = $map->find_intersection([[0,0],[-1,0],[0,-1]]), 'find intersection';
ok my $p = $map->find_path([[[0,0],[-1,1],[-1,0]], [[0,0],[-1,0],[0,-1]]]), 'find path';
is scalar @{$map->tiles_by_type_code('D')}, 1, 'found 1 desert tile';
is scalar @{$map->tiles_by_resource_number(2)}, 1, 'found 1 tile with resource number 2';
is scalar @{$map->tiles_by_resource_number(1)}, 0, 'found 0 tiles with resource number 1';
is scalar @{$map->tiles_by_resource_number(6)}, 2, 'found 2 tiles with resource number 6';
is scalar @{$map->tiles_by_intersection($i)}, 3, 'found 3 tiles by intersection';

# exceptions
dies_ok { Catan::Map::Intersection->new([$tile1, $tile2, $tile3]) }
  'dies on invalid intersection';
dies_ok { Catan::Map->new({type => 'custom'}) }
  'dies on custom map type missing map arg';

done_testing;
