package Catan::Asset::DevelopmentCard;
$Catan::Asset::DevelopmentCard::VERSION = '0.02';
use strict;
use warnings;
use Catan::Resource::Ore;
use Catan::Resource::Grain;
use Catan::Resource::Wool;

our %types = (
  KN => 'Knight',
  MO => 'Monopoly',
  RB => 'Road Building',
  VP => 'Victory Point',
  YP => 'Year of Plenty',
);

sub new
{
  my ($class, $type) = @_;
  die "$class new requires a type argument"
    unless $type && exists $types{$type};

  bless {
    type => $type,
    code => 'DC',
  }, $class;
}

sub code      { $_[0]->{code} }
sub type      { $_[0]->{type} }
sub type_name { $types{ $_[0]->{type} } }

sub cost
{
  return [
    Catan::Resource::Ore->new(-1),
    Catan::Resource::Grain->new(-1),
    Catan::Resource::Wool->new(-1),
  ];
}
1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Catan::Asset::DevelopmentCard

=head1 VERSION

version 0.02

=head1 AUTHOR

David Farrell <dfarrell@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2015 by David Farrell.

This is free software, licensed under:

  The (two-clause) FreeBSD License

=cut
