## no critic ( Modules::ProhibitExcessMainComplexity )
use 5.008;
use strict;
use warnings;

my $sc = 'https://codeberg.org/h3xx/perl-Chicken-Ipsum';
my $bt = "$sc/issues";

my %META = (
	name        => 'Chicken-Ipsum',
	author      => 'Dan Church <h3xx@gmx.com>',
	x_copyright => { holder => 'Dan Church', year => 2023 },
	license     => 'perl_5',
	resources   => {
		license    => [ 'https://dev.perl.org/licenses/' ],
		repository => { type => 'git', url => "$sc.git", web => $sc },
		bugtracker => { web => $bt },
	},
	dynamic_config => 0,
    pl_files => {
        'chicken-ipsum.PL' => 'chicken-ipsum',
    },
    exe_files => [
        'chicken-ipsum',
    ],
	prereqs => {
		runtime => {
			requires => {qw(
				perl 5.008
                Carp 0
                List::Util 1.54
			)},
		},
		test => {
			requires => {qw(
				Test::More 0
			)},
		},
	},
);

## BOILERPLATE ###############################################################
## no critic ( BuiltinFunctions::ProhibitStringyEval )
## no critic ( ControlStructures::ProhibitPostfixControls )
## no critic ( References::ProhibitDoubleSigils )
require ExtUtils::MakeMaker;

my %MM_ARGS;

# have to do this since old EUMM dev releases miss the eval $VERSION line
my $eumm_version  = eval $ExtUtils::MakeMaker::VERSION;
my $mymeta        = $eumm_version >= 6.57_02;
my $mymeta_broken = $mymeta && $eumm_version < 6.57_07;

(my $basepath = (-d 'lib' && 'lib/') . $META{name}) =~ s{-}{/}g;

($MM_ARGS{NAME} = $META{name}) =~ s/-/::/g;
$MM_ARGS{VERSION_FROM} = "$basepath.pm";
$MM_ARGS{ABSTRACT_FROM} = -f "$basepath.pod" ? "$basepath.pod" : "$basepath.pm";
$META{license} = [ $META{license} ]
	if $META{license} && !ref $META{license};
$MM_ARGS{LICENSE} = $META{license}[0]
	if $META{license} && $eumm_version >= 6.30;
$MM_ARGS{NO_MYMETA} = 1
	if $mymeta_broken;
$MM_ARGS{META_ADD} = { 'meta-spec' => { version => 2 }, %META }
	unless -f 'META.yml';
$MM_ARGS{PL_FILES} //= $META{pl_files} // {};
$MM_ARGS{EXE_FILES} //= $META{exe_files} // [];
$MM_ARGS{clean}->{FILES} //= $META{exe_files};
$MM_ARGS{NORECURS} = 1
	if not exists $MM_ARGS{NORECURS};

for (qw(configure build test runtime)) {
	my $key = $_ eq 'runtime' ? 'PREREQ_PM' : uc $_.'_REQUIRES';
	my $r = $MM_ARGS{$key} = {
		%{$META{prereqs}{$_}{requires} || {}},
		%{delete $MM_ARGS{$key} || {}},
	};
	defined $r->{$_} or delete $r->{$_} for keys %$r;
}

$MM_ARGS{MIN_PERL_VERSION} = eval delete $MM_ARGS{PREREQ_PM}{perl} || 0;

delete $MM_ARGS{MIN_PERL_VERSION}
	if $eumm_version < 6.47_01;
$MM_ARGS{BUILD_REQUIRES} = {%{$MM_ARGS{BUILD_REQUIRES}}, %{delete $MM_ARGS{TEST_REQUIRES}}}
	if $eumm_version < 6.63_03;
$MM_ARGS{PREREQ_PM} = {%{$MM_ARGS{PREREQ_PM}}, %{delete $MM_ARGS{BUILD_REQUIRES}}}
	if $eumm_version < 6.55_01;
delete $MM_ARGS{CONFIGURE_REQUIRES}
	if $eumm_version < 6.51_03;

ExtUtils::MakeMaker::WriteMakefile(%MM_ARGS);
## END BOILERPLATE ###########################################################
