use Module::Build;

my $build = Module::Build->new(
			       module_name => 'WWW::Shorten',
                               dist_version => '1.100',
			       license     => 'perl',
			       requires    => {
                                 'perl'                => '5.6.0',
                                 'LWP'                 => '5.75',
                                 'LWP::UserAgent'      => '2.023',
                                 'URI'                 => '1.27',
                               },
			       build_requires => {
                                 'Test::More'          => '0.47',
                               },
                               build_recommends => {
                                 'Test::Pod'           => 0,
                                 'Test::Pod::Coverage' => 0,
                                 'Test::Signature'     => 0,
                               },               
			       create_makefile_pl => 'traditional',
                               script_files       => [ 'bin/shorten' ],
			       sign        => 1,
);

$build->create_build_script;
