use 5.006;
use strict;
use warnings;

package Task::BeLike::DAGOLDEN;
our $VERSION = '0.002'; # VERSION
# ABSTRACT: DAGOLDEN's frequently-used or favorite modules


1;

# vim: ts=2 sts=2 sw=2 et:

__END__
=pod

=head1 NAME

Task::BeLike::DAGOLDEN - DAGOLDEN's frequently-used or favorite modules

=head1 VERSION

version 0.002

=head1 TASK CONTENTS

=head2 Apps

=head3 L<App::Ack>

=head3 L<App::cpanminus>

=head3 L<App::grindperl>

=head3 L<App::mymeta_requires>

=head3 L<App::Nopaste>

=head2 CLI tools

=head3 L<Daemon::Daemonize>

=head3 L<Getopt::Lucid>

=head3 L<Pod::Usage>

=head2 Filesystem tools

=head3 L<File::Find::Rule>

=head3 L<File::Find::Rule::Perl>

=head3 L<File::Slurp>

=head3 L<File::pushd>

=head3 L<Path::Class>

=head3 L<Path::Class::Rule>

=head2 Database Modules

=head3 L<DBI>

=head3 L<DBD::SQLite>

=head2 Testing Modules

=head3 L<Test::Deep>

=head3 L<Test::Differences>

=head3 L<Test::Fatal>

Better than Test::Exception

=head3 L<Test::More> 0.96

Version 0.96 required because: Minimally sane subtest()'s

=head3 L<Test::Routine>

Better than Test::Class

=head3 L<Test::Perl::Critic>

=head3 L<Perl::Critic::Lax>

=head3 L<Test::CPAN::Meta>

=head3 L<Test::Pod::Coverage> 1.08

=head3 L<Pod::Coverage::TrustPod>

=head3 L<Test::Pod> 1.41

=head2 Perl development tools

=head3 L<Archive::Tar>

=head3 L<Archive::Tar::Wrapper>

=head3 L<Archive::Zip>

=head3 L<CPAN::DistnameInfo>

=head3 L<CPAN::Mini>

=head3 L<CPAN::Uploader>

=head3 L<CPAN::Visitor>

=head3 L<Data::Dump::Streamer>

=head3 L<Devel::NYTProf>

=head3 L<Dist::Zilla> 4

=head3 L<Dist::Zilla::PluginBundle::DAGOLDEN> 0.018

=head3 L<Module::Load::Conditional>

=head3 L<Moose>

=head3 L<Perl::Version>

=head3 L<Pod::Strip>

=head3 L<autodie>

=head3 L<namespace::autoclean>

=head3 L<version>

=head2 Email tools

=head3 L<Email::MIME>

=head3 L<Email::Sender>

=head3 L<Email::Sender::Simple>

=head3 L<Email::Simple>

=head3 L<Email::Simple::Creator>

=head2 Web tools

=head3 L<Bundle::LWP>

=head3 L<LWP::Protocol::https>

=head3 L<HTTP::Tiny>

=head3 L<IO::Socket::SSL>

=head3 L<URI>

=head3 L<WWW::Mechanize>

=head2 Data manipulation tools

=head3 L<Data::Stream::Bulk>

=head3 L<JSON>

=head3 L<JSON::XS>

=head3 L<List::AllUtils>

=head3 L<Regexp::Common>

=head3 L<XML::RSS>

=head3 L<XML::Simple>

=head3 L<YAML>

=head2 System interaction tools

=head3 L<Capture::Tiny>

=head3 L<IO::CaptureOutput>

=head3 L<IPC::Run3>

=head3 L<IPC::System::Simple>

=head3 L<Time::HiRes>

=head2 Special-purpose tools

=head3 L<Git::Wrapper>

=head3 L<Image::ExifTool>

=head3 L<Net::GitHub::V2::Repositories>

=head3 L<Vi::QuickFix>

=head1 AUTHOR

David Golden <dagolden@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2011 by David Golden.

This is free software, licensed under:

  The Apache License, Version 2.0, January 2004

=cut

