package OpenInteract2::Action::PageDirectory;

# $Id: PageDirectory.pm,v 1.3 2003/06/04 15:47:03 lachoy Exp $

use strict;
use base qw( OpenInteract2::Action::CommonUpdate
             OpenInteract2::Action::CommonAdd
             OpenInteract2::Action::CommonRemove );
use OpenInteract2::Constants qw( :log );
use OpenInteract2::Context   qw( CTX DEBUG LOG );
use SPOPS::Secure            qw( SEC_LEVEL_WRITE );

$OpenInteract2::Action::PageDirectory::VERSION = sprintf("%d.%02d", q$Revision: 1.3 $ =~ /(\d+)\.(\d+)/);

sub list {
    my ( $self ) = @_;
    my $handlers = eval {
        CTX->lookup_object( 'page_directory' )->fetch_iterator;
    };
    return $self->generate_content(
                    { iterator => $handlers },
                    { name => 'base_page::page_directory_handler_list' } );
}

# Just grab all the actions available

sub _display_add_customize {
    my ( $self, $params ) = @_;
    return $self->_display_customize( $params );
}

sub _display_form_customize {
    my ( $self, $params ) = @_;
    return $self->_display_customize( $params );
}

sub _display_customize {
    my ( $self, $params ) = @_;
    $params->{action_list} = eval {
        CTX->lookup_object( 'page_directory' )->list_directory_actions
    };
    if ( $@ ) {
        $self->param_add( error_msg => "Failed to lookup action types: $@" );
    }
    return undef;
}

sub _update_customize {
    my ( $self, $dir, $old_data, $update_options ) = @_;

    # If the user changed the directory, then we need to set the ID so
    # the UPDATE works properly.

    if ( $old_data->{directory} and $dir->{directory} ne $old_data->{directory} ) {
        DEBUG && LOG( LDEBUG, "User changed directory from ",
                              "[$old_data->{directory}] ",
                              "to [$dir->{directory}]" );
        $update_options->{use_id} = $old_data->{directory};
    }
    return undef;
}

1;


