package OpenInteract::Handler::Redirect;

# $Id: Redirect.pm,v 1.5 2001/08/20 14:52:58 lachoy Exp $

use strict;

@OpenInteract::Redirect::ISA     = ();
$OpenInteract::Redirect::VERSION = sprintf("%d.%02d", q$Revision: 1.5 $ =~ /(\d+)\.(\d+)/);

use constant DEBUG  => 0;

my $MSG = '<p>Going back from whence we came, which is hopefully <a href="%%URL%%">%%URL%%</a></p>';

my $BASE_PAGE = <<'EOF';
<html>
 <head>
  <meta http-equiv="refresh" content="0; URL=%%URL%%">
 </head>
 <body>
  %%MSG%%
 </body>
</html>
EOF

sub handler {
    my ( $class, $p ) = @_;
    $p->{url} ||= '/';
    my $R = OpenInteract::Request->instance;
    $R->{page}->{_no_template_}++;

    # the url in the meta refresh tag doesn't like semicolons 
    $p->{url} =~ s/;/&/g; 

    $R->DEBUG && $R->scrib( 1, "Trying to go to ($p->{url})" );
    my $msg  = $MSG;
    $msg  =~ s|%%URL%%|$p->{url}|g;
    unless ( $R->CONFIG->{display_info}->{show_redirect_message} ) {
        $msg = '<!-- ' . $msg . '-->';
    }
    my $page = $BASE_PAGE;
    $page =~ s|%%MSG%%|$msg|;
    $page =~ s|%%URL%%|$p->{url}|g;
    return $page;
}

1;

__END__

=pod

=head1 NAME

OpenInteract::Handler::Redirect - Process redirect requests

=head1 SYNOPSIS

 my ( $redir_class, $redir_method ) = $R->lookup_action( 'redirect' );
 $redir_class->$redir_method( { url => '/where/I/want/to/go' } );

=head1 DESCRIPTION

This handler processes redirect requests. Just pass in:

 { url => '/url/to/go/to' }

As the first parameter and OI will send you there.

=head1 METHODS

B<handler( \%params )>

Process the request for redirection.

=head1 TO DO

Modify to handle redirects the way they are supposed to be handled
rather than lamely generating a page to do it. (But the lame page
works, so this has a relatively low priority...)

=head1 BUGS

None known, beyond general junkiness.

=head1 COPYRIGHT

Copyright (c) 2001 intes.net, inc.. All rights reserved.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=head1 AUTHORS

Chris Winters <chris@cwinters.com>

=cut
