use 5.14.0;
use strict;
use warnings;

package Map::Metro::Plugin::Map::Bilbao;

our $VERSION = '0.1001'; # VERSION
# ABSTRACT: Map::Metro map for Bilbao

use Moose;
with 'Map::Metro::Plugin::Map';

has '+mapfile' => (
    default => 'map-bilbao.metro',
);
sub map_version {
    return $VERSION;
}
sub map_package {
    return __PACKAGE__;
}

1;

__END__

=pod

=encoding utf-8

=head1 NAME

Map::Metro::Plugin::Map::Bilbao - Map::Metro map for Bilbao

=head1 VERSION

Version 0.1001, released 2015-01-27.

=head1 SYNOPSIS

    use Map::Metro;
    my $graph = Map::Metro->new('Bilbao')->parse;

Or:

    $ map-metro.pl route Bilbao Lamiako Ariz

=head1 DESCRIPTION

See L<Map::Metro> for usage information.

=head1 STATUS

This map L<contains|Map::Metro::Plugin::Map::Bilbao::Lines>:

=over 4

=item *

Line 1 and 2, and the Mamariga shuttle [L<wikipedia|https://en.wikipedia.org/wiki/Metro_Bilbao>]

=back

=head2 Note

* The I<Ibarbengoa-Getxo> station is not included.

=for HTML <p><a href="https://raw.githubusercontent.com/Csson/p5-Map-Metro-Bilbao/master/static/images/bilbao.png"><img src="https://raw.githubusercontent.com/Csson/p5-Map-Metro-Bilbao/master/static/images/bilbao.png" style="max-width: 600px" /></a></p>

=head1 SOURCE

Source repository is at L<https://github.com/Csson/p5-Map-Metro-Bilbao>.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Map-Metro-Plugin-Map-Bilbao>.

=head1 AUTHOR

Erik Carlsson <info@code301.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Erik Carlsson <info@code301.com>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
