package Lingua::PT::Ords2Nums;

use 5.008;
use strict;
use warnings;

use Lingua::PT::Words2Nums;

require Exporter;

our @ISA = qw(Exporter);

our %EXPORT_TAGS = ( 'all' => [ qw(
	ord2num isord
) ] );

our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );

our @EXPORT = qw(
	ord2num isord
);

our $VERSION = '0.02';

my %values;

=head1 NAME

Lingua::PT::Ords2Nums - Converts Portuguese ordinals to numbers

=head1 SYNOPSIS

  use Lingua::PT::Ords2Nums;

  $num = word2num('dcimo primeiro')   # 11

=cut

BEGIN {
  %values = (
    'bilionsimo'	=> 1000000000,
    'milionsimo'	=> 1000000,
    'milsimo'		=> 1000,

    'nongentsimo'	=> 900,
    'octigentsimo'	=> 800,
    'septigentsimo'	=> 700,
    'seiscentsimo'	=> 600,
    'quingentsimo'	=> 500,
    'quadrigentsimo'	=> 400,
    'tricentsimo'	=> 300,
    'ducentsimo'	=> 200,
    'centsimo' 	=> 100,

    'nonagsimo'	=> 90,
    'octogsimo' 	=> 80,
    'septuagsimo' 	=> 70,
    'sexagsimo' 	=> 60,
    'quinquagsimo' 	=> 50,
    'quadragsimo' 	=> 40,
    'trigsimo' 	=> 30,
    'vigsimo' 		=> 20,
    'dcimo' 		=> 10,

    nono		=> 9,
    oitavo		=> 8,
    'stimo'		=> 7,
    sexto		=> 6,
    quinto		=> 5,
    quarto		=> 4,
    terceiro		=> 3,
    segundo		=> 2,
    primeiro		=> 1,

  );
}

sub ord2num {
  $_ = shift || return undef;
  my $result = 0;

  s/(.*)bilionsimos/$result += (word2num($1) * 1000000000)/e;
  s/(.*)milionsimos/$result += (word2num($1) * 1000000)/e;
  s/(.*)milsimos/$result += (word2num($1) * 1000)/e;

  for my $value (keys %values) {
    s/$value/$result += $values{$value}/e;
  }

  $result;
}

sub isord { return 1 }

1;
__END__

=head1 DESCRIPTION

Converts Portuguese ordinals to numbers. Works up to 999.999.999.999
('novecentos e noventa e nove bilionsimos novecentos e noventa e nove
milionsimos novecentos e noventa e nove milsimos nongentsimo nonagsimo
nono').

=head1 DEPENDENCIES

Lingua::PT::Words2Nums

=head1 SEE ALSO

Lingua::PT::Nums2Ords

=head1 AUTHOR

Jose Alves de Castro, E<lt>jac@localdomainE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright 2004 by Jose Alves de Castro

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself. 

=cut
